---
sidebarDepth: 2
editLink: false
---
# Prefect Tasks
---
Tasks for interacting with the Prefect API
 ## FlowRunTask
 <div class='class-sig' id='prefect-tasks-prefect-flow-run-flowruntask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.prefect.flow_run.FlowRunTask</p>(flow_name=None, project_name=None, parameters=None, wait=False, new_flow_context=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L12">[source]</a></span></div>

Task used to kick off a flow run using Prefect Core's server or Prefect Cloud.  If multiple versions of the flow are found, this task will kick off the most recent unarchived version.

**Args**:     <ul class="args"><li class="args">`flow_name (str, optional)`: the name of the flow to schedule; this value may also be         provided at run time     </li><li class="args">`project_name (str, optional)`: if running with Cloud as a backend, this is the project         in which the flow is located; this value may also be provided at runtime. If         running with Prefect Core's server as the backend, this should not be provided.     </li><li class="args">`parameters (dict, optional)`: the parameters to pass to the flow run being scheduled;         this value may also be provided at run time     </li><li class="args">`new_flow_context (dict, optional)`: the optional run context for the new flow run     </li><li class="args">`wait (bool, optional)`: whether to wait the triggered flow run's state; if True, this         task will wait until the flow run is complete, and then reflect the corresponding         state as the state of this task.  Defaults to `False`.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-prefect-flow-run-flowruntask-run'><p class="prefect-class">prefect.tasks.prefect.flow_run.FlowRunTask.run</p>(flow_name=None, project_name=None, parameters=None, idempotency_key=None, new_flow_context=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/prefect/flow_run.py#L50">[source]</a></span></div>
<p class="methods">Run method for the task; responsible for scheduling the specified flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_name (str, optional)`: the name of the flow to schedule; if not provided,         this method will use the flow name provided at initialization     </li><li class="args">`project_name (str, optional)`: the Cloud project in which the flow is located; if         not provided, this method will use the project provided at initialization. If         running with Prefect Core's server as the backend, this should not be provided.     </li><li class="args">`parameters (dict, optional)`: the parameters to pass to the flow run being         scheduled; if not provided, this method will use the parameters provided at         initialization     </li><li class="args">`idempotency_key (str, optional)`: an optional idempotency key for scheduling the         flow run; if provided, ensures that only one run is created if this task is retried         or rerun with the same inputs.  If not provided, the current flow run ID will be used.     </li><li class="args">`new_flow_context (dict, optional)`: the optional run context for the new flow run</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-scheduled flow run</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if flow was not provided, cannot be found, or if a project name was         not provided while using Cloud as a backend</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect.tasks.prefect.flow_run <span class="token keyword">import</span> FlowRunTask<br><br>    kickoff_task <span class="token operator">=</span> FlowRunTask<span class="token punctuation">(</span>project_name<span class="token operator">=</span><span class="token string">"</span><span class="token string">Hello, World!</span><span class="token string">"</span><span class="token punctuation">,</span> flow_name<span class="token operator">=</span><span class="token string">"</span><span class="token string">My Cloud Flow</span><span class="token string">"</span><span class="token punctuation">)</span><br>    <br></code></pre><br></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on August 6, 2020 at 13:56 UTC</p>