---
sidebarDepth: 2
editLink: false
---
# Kubernetes Agent
---
 ## KubernetesAgent
 <div class='class-sig' id='prefect-agent-kubernetes-agent-kubernetesagent'><p class="prefect-sig">class </p><p class="prefect-class">prefect.agent.kubernetes.agent.KubernetesAgent</p>(namespace=None, name=None, labels=None, env_vars=None, max_polls=None, agent_address=None, no_cloud_logs=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/kubernetes/agent.py#L17">[source]</a></span></div>

Agent which deploys flow runs as Kubernetes jobs. Currently this is required to either run on a k8s cluster or on a local machine where the kube_config is pointing at the desired cluster. Information on using the Kubernetes Agent can be found at https://docs.prefect.io/orchestration/agents/kubernetes.html

Environment variables may be set on the agent to be provided to each flow run's job: 
```
prefect agent start kubernetes --env MY_SECRET_KEY=secret --env OTHER_VAR=$OTHER_VAR

```

These can also be used to control the k8s job spec that describes the flow run jobs. For example, to set the k8s secret used to pull images from a non-public registry: 
```
prefect agent start kubernetes --env IMAGE_PULL_SECRETS=my-img-pull-secret

```

For details on the available environment variables for customizing the job spec, see `help(KubernetesAgent.replace_job-spec_yaml)`.

Specifying a namespace for the agent will create flow run jobs in that namespace: 
```
prefect agent start kubernetes --namespace dev

```

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: A Kubernetes namespace to create jobs in. Defaults         to the environment variable `NAMESPACE` or `default`.     </li><li class="args">`name (str, optional)`: An optional name to give this agent. Can also be set through         the environment variable `PREFECT__CLOUD__AGENT__NAME`. Defaults to "agent"     </li><li class="args">`labels (List[str], optional)`: a list of labels, which are arbitrary string         identifiers used by Prefect Agents when polling for work     </li><li class="args">`env_vars (dict, optional)`: a dictionary of environment variables and values that will         be set on each flow run that this agent submits for execution and in the agent's         own environment     </li><li class="args">`max_polls (int, optional)`: maximum number of times the agent will poll Prefect Cloud         for flow runs; defaults to infinite     </li><li class="args">`agent_address (str, optional)`:  Address to serve internal API at. Currently this is         just health checks for use by an orchestration layer. Leave blank for no API server         (default).     </li><li class="args">`no_cloud_logs (bool, optional)`: Disable logging to a Prefect backend for this agent         and all deployed flow runs</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-agent-kubernetes-agent-kubernetesagent-deploy-flow'><p class="prefect-class">prefect.agent.kubernetes.agent.KubernetesAgent.deploy_flow</p>(flow_run)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/kubernetes/agent.py#L99">[source]</a></span></div>
<p class="methods">Deploy flow runs on to a k8s cluster as jobs<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: A GraphQLResult flow run object</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: Information about the deployment</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-kubernetes-agent-kubernetesagent-generate-deployment-yaml'><p class="prefect-class">prefect.agent.kubernetes.agent.KubernetesAgent.generate_deployment_yaml</p>(token=None, api=None, namespace=None, image_pull_secrets=None, resource_manager_enabled=False, rbac=False, latest=False, mem_request=None, mem_limit=None, cpu_request=None, cpu_limit=None, image_pull_policy=None, service_account_name=None, labels=None, env_vars=None, backend=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/kubernetes/agent.py#L220">[source]</a></span></div>
<p class="methods">Generate and output an installable YAML spec for the agent.<br><br>**Args**:     <ul class="args"><li class="args">`token (str, optional)`: A `RUNNER` token to give the agent     </li><li class="args">`api (str, optional)`: A URL pointing to the Prefect API. Defaults to         `https://api.prefect.io`     </li><li class="args">`namespace (str, optional)`: The namespace to create Prefect jobs in. Defaults         to `default`     </li><li class="args">`image_pull_secrets (str, optional)`: The name of an image pull secret to use         for Prefect jobs     </li><li class="args">`resource_manager_enabled (bool, optional)`: Whether to include the resource         manager as part of the YAML. Defaults to `False`     </li><li class="args">`rbac (bool, optional)`: Whether to include default RBAC configuration as         part of the YAML. Defaults to `False`     </li><li class="args">`latest (bool, optional)`: Whether to use the `latest` Prefect image.         Defaults to `False`     </li><li class="args">`mem_request (str, optional)`: Requested memory for Prefect init job.     </li><li class="args">`mem_limit (str, optional)`: Limit memory for Prefect init job.     </li><li class="args">`cpu_request (str, optional)`: Requested CPU for Prefect init job.     </li><li class="args">`cpu_limit (str, optional)`: Limit CPU for Prefect init job.     </li><li class="args">`image_pull_policy (str, optional)`: imagePullPolicy to use for Prefect init job.         Job defaults to `IfNotPresent`.     </li><li class="args">`service_account_name (str, optional)`: Name of a service account to use for         Prefect init job. Job defaults to using `default` service account.     </li><li class="args">`labels (List[str], optional)`: a list of labels, which are arbitrary string         identifiers used by Prefect Agents when polling for work     </li><li class="args">`env_vars (dict, optional)`: additional environment variables to attach to all         jobs created by this agent and to set in the agent's own environment     </li><li class="args">`backend (str, optional)`: toggle which backend to use for this agent.         Defaults to backend currently set in config.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: A string representation of the generated YAML</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-kubernetes-agent-kubernetesagent-replace-job-spec-yaml'><p class="prefect-class">prefect.agent.kubernetes.agent.KubernetesAgent.replace_job_spec_yaml</p>(flow_run, image)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/kubernetes/agent.py#L128">[source]</a></span></div>
<p class="methods">Populate a k8s job spec. This spec defines a k8s job that handles executing a flow. This method runs each time the agent receives a flow to run.<br><br>That job spec can optionally be customized by setting the following environment variables on the agent.<br><br>- `NAMESPACE`: the k8s namespace the job will run in, defaults to `"default"` - `JOB_MEM_REQUEST`: memory requested, for example, `256Mi` for 256 MB. If this         environment variable is not set, the cluster's defaults will be used. - `JOB_MEM_LIMIT`: memory limit, for example, `512Mi` For 512 MB. If this         environment variable is not set, the cluster's defaults will be used. - `JOB_CPU_REQUEST`: CPU requested, defaults to `"100m"` - `JOB_CPU_LIMIT`: CPU limit, defaults to `"100m"` - `IMAGE_PULL_POLICY`: policy for pulling images. Defaults to `"IfNotPresent"`. - `IMAGE_PULL_SECRETS`: name of an existing k8s secret that can be used to pull         images. This is necessary if your flow uses an image that is in a non-public         container registry, such as Amazon ECR. - `SERVICE_ACCOUNT_NAME`: name of a service account to run the job as.         By default, none is specified.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: A flow run object     </li><li class="args">`image (str)`: The full name of an image to use for the job</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: a dictionary representation of a k8s job for flow execution</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on August 6, 2020 at 13:56 UTC</p>