(function(window){'use strict';window.Appwrite=function(){let config={endpoint:'https://appwrite.io/v1',project:'',key:'',locale:'',mode:'',};let setEndpoint=function(endpoint){config.endpoint=endpoint;return this};let setProject=function(value){http.addGlobalHeader('X-Appwrite-Project',value);config.project=value;return this};let setKey=function(value){http.addGlobalHeader('X-Appwrite-Key',value);config.key=value;return this};let setLocale=function(value){http.addGlobalHeader('X-Appwrite-Locale',value);config.locale=value;return this};let setMode=function(value){http.addGlobalHeader('X-Appwrite-Mode',value);config.mode=value;return this};let http=function(document){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){let a=document.createElement('a'),regex=/(?:\?|&amp;|&)+([^=]+)(?:=([^&]*))*/g;let match,str=[];a.href=url;param=encodeURIComponent(param);while(match=regex.exec(a.search))if(param!==match[1])str.push(match[1]+(match[2]?"="+match[2]:""));str.push(param+(value?"="+encodeURIComponent(value):""));a.search=str.join("&");return a.href};let buildQuery=function(params){let str=[];for(let p in params){if(Array.isArray(params[p])){for(let index=0;index<params[p].length;index++){let param=params[p][index];str.push(encodeURIComponent(p+'[]')+"="+encodeURIComponent(param))}}else{str.push(encodeURIComponent(p)+"="+encodeURIComponent(params[p]))}}
return str.join("&")};let addGlobalHeader=function(key,value){globalHeaders[key]={key:key.toLowerCase(),value:value.toLowerCase()}};let addGlobalParam=function(key,value){globalParams.push({key:key,value:value})};addGlobalHeader('x-sdk-version','appwrite:javascript:1.0.28');addGlobalHeader('content-type','');let call=function(method,path,headers={},params={},progress=null){let i;path=config.endpoint+path;if(-1===['GET','POST','PUT','DELETE','TRACE','HEAD','OPTIONS','CONNECT','PATCH'].indexOf(method)){throw new Error('var method must contain a valid HTTP method name')}
if(typeof path!=='string'){throw new Error('var path must be of type string')}
if(typeof headers!=='object'){throw new Error('var headers must be of type object')}
for(i=0;i<globalParams.length;i++){path=addParam(path,globalParams[i].key,globalParams[i].value)}
for(let key in globalHeaders){if(globalHeaders.hasOwnProperty(key)){if(!headers[globalHeaders[key].key]){headers[globalHeaders[key].key]=globalHeaders[key].value}}}
if(method==='GET'){for(let param in params){if(param.hasOwnProperty(key)){path=addParam(path,key+(Array.isArray(param)?'[]':''),params[key])}}}
switch(headers['content-type']){case 'application/json':params=JSON.stringify(params);break;case 'multipart/form-data':let formData=new FormData();Object.keys(params).forEach(function(key){let param=params[key];formData.append(key+(Array.isArray(param)?'[]':''),param)});params=formData;break}
return new Promise(function(resolve,reject){let request=new XMLHttpRequest(),key;request.withCredentials=!0;request.open(method,path,!0);for(key in headers){if(headers.hasOwnProperty(key)){if(key==='content-type'&&headers[key]==='multipart/form-data'){continue}
request.setRequestHeader(key,headers[key])}}
request.onload=function(){if(4===request.readyState&&399>=request.status){let data=request.response;let contentType=this.getResponseHeader('content-type')||'';contentType=contentType.substring(0,contentType.indexOf(';'));switch(contentType){case 'application/json':data=JSON.parse(data);break}
resolve(data)}else{reject(new Error(request.statusText))}};if(progress){request.addEventListener('progress',progress);request.upload.addEventListener('progress',progress,!1)}
request.onerror=function(){reject(new Error("Network Error"))};request.send(params)})};return{'get':function(path,headers={},params={}){return call('GET',path+((Object.keys(params).length>0)?'?'+buildQuery(params):''),headers,{})},'post':function(path,headers={},params={},progress=null){return call('POST',path,headers,params,progress)},'put':function(path,headers={},params={},progress=null){return call('PUT',path,headers,params,progress)},'patch':function(path,headers={},params={},progress=null){return call('PATCH',path,headers,params,progress)},'delete':function(path,headers={},params={},progress=null){return call('DELETE',path,headers,params,progress)},'addGlobalParam':addGlobalParam,'addGlobalHeader':addGlobalHeader}}(window.document);let iframe=function(method,url,params){let form=document.createElement('form');form.setAttribute('method',method);form.setAttribute('action',config.endpoint+url);for(let key in params){if(params.hasOwnProperty(key)){let hiddenField=document.createElement("input");hiddenField.setAttribute("type","hidden");hiddenField.setAttribute("name",key);hiddenField.setAttribute("value",params[key]);form.appendChild(hiddenField)}}
document.body.appendChild(form);return form.submit()};let account={get:function(){let path='/account';let payload={};return http.get(path,{'content-type':'application/json',},payload)},delete:function(){let path='/account';let payload={};return http.delete(path,{'content-type':'application/json',},payload)},updateEmail:function(email,password){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/account/email';let payload={};if(email){payload.email=email}
if(password){payload.password=password}
return http.patch(path,{'content-type':'application/json',},payload)},updateName:function(name){if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/account/name';let payload={};if(name){payload.name=name}
return http.patch(path,{'content-type':'application/json',},payload)},updatePassword:function(password,oldPassword){if(password===undefined){throw new Error('Missing required parameter: "password"')}
if(oldPassword===undefined){throw new Error('Missing required parameter: "oldPassword"')}
let path='/account/password';let payload={};if(password){payload.password=password}
if(oldPassword){payload['old-password']=oldPassword}
return http.patch(path,{'content-type':'application/json',},payload)},getPrefs:function(){let path='/account/prefs';let payload={};return http.get(path,{'content-type':'application/json',},payload)},updatePrefs:function(prefs){if(prefs===undefined){throw new Error('Missing required parameter: "prefs"')}
let path='/account/prefs';let payload={};if(prefs){payload.prefs=prefs}
return http.patch(path,{'content-type':'application/json',},payload)},getSecurity:function(){let path='/account/security';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getSessions:function(){let path='/account/sessions';let payload={};return http.get(path,{'content-type':'application/json',},payload)}};let auth={login:function(email,password,success='',failure=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/auth/login';let payload={};if(email){payload.email=email}
if(password){payload.password=password}
if(success){payload.success=success}
if(failure){payload.failure=failure}
payload.project=config.project;return iframe('post',path,payload)},oauth:function(provider,success,failure){if(provider===undefined){throw new Error('Missing required parameter: "provider"')}
if(success===undefined){throw new Error('Missing required parameter: "success"')}
if(failure===undefined){throw new Error('Missing required parameter: "failure"')}
let path='/auth/login/oauth/{provider}'.replace(new RegExp('{provider}','g'),provider);let payload={};if(success){payload.success=success}
if(failure){payload.failure=failure}
payload.project=config.project;return iframe('get',path,payload)},logout:function(){let path='/auth/logout';let payload={};return http.delete(path,{'content-type':'application/json',},payload)},logoutBySession:function(id){if(id===undefined){throw new Error('Missing required parameter: "id"')}
let path='/auth/logout/{id}'.replace(new RegExp('{id}','g'),id);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},recovery:function(email,reset){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(reset===undefined){throw new Error('Missing required parameter: "reset"')}
let path='/auth/recovery';let payload={};if(email){payload.email=email}
if(reset){payload.reset=reset}
return http.post(path,{'content-type':'application/json',},payload)},recoveryReset:function(userId,token,passwordA,passwordB){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(token===undefined){throw new Error('Missing required parameter: "token"')}
if(passwordA===undefined){throw new Error('Missing required parameter: "passwordA"')}
if(passwordB===undefined){throw new Error('Missing required parameter: "passwordB"')}
let path='/auth/recovery/reset';let payload={};if(userId){payload.userId=userId}
if(token){payload.token=token}
if(passwordA){payload['password-a']=passwordA}
if(passwordB){payload['password-b']=passwordB}
return http.put(path,{'content-type':'application/json',},payload)},register:function(email,password,confirm,success='',failure='',name=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
if(confirm===undefined){throw new Error('Missing required parameter: "confirm"')}
let path='/auth/register';let payload={};if(email){payload.email=email}
if(password){payload.password=password}
if(confirm){payload.confirm=confirm}
if(success){payload.success=success}
if(failure){payload.failure=failure}
if(name){payload.name=name}
payload.project=config.project;return iframe('post',path,payload)},confirm:function(userId,token){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(token===undefined){throw new Error('Missing required parameter: "token"')}
let path='/auth/register/confirm';let payload={};if(userId){payload.userId=userId}
if(token){payload.token=token}
return http.post(path,{'content-type':'application/json',},payload)},confirmResend:function(confirm){if(confirm===undefined){throw new Error('Missing required parameter: "confirm"')}
let path='/auth/register/confirm/resend';let payload={};if(confirm){payload.confirm=confirm}
return http.post(path,{'content-type':'application/json',},payload)}};let avatars={getBrowser:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/browsers/{code}'.replace(new RegExp('{code}','g'),code);let payload={};if(width){payload.width=width}
if(height){payload.height=height}
if(quality){payload.quality=quality}
return http.get(path,{'content-type':'application/json',},payload)},getCreditCard:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/credit-cards/{code}'.replace(new RegExp('{code}','g'),code);let payload={};if(width){payload.width=width}
if(height){payload.height=height}
if(quality){payload.quality=quality}
return http.get(path,{'content-type':'application/json',},payload)},getFavicon:function(url){if(url===undefined){throw new Error('Missing required parameter: "url"')}
let path='/avatars/favicon';let payload={};if(url){payload.url=url}
return http.get(path,{'content-type':'application/json',},payload)},getFlag:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/flags/{code}'.replace(new RegExp('{code}','g'),code);let payload={};if(width){payload.width=width}
if(height){payload.height=height}
if(quality){payload.quality=quality}
return http.get(path,{'content-type':'application/json',},payload)},getImage:function(url,width=400,height=400){if(url===undefined){throw new Error('Missing required parameter: "url"')}
let path='/avatars/image';let payload={};if(url){payload.url=url}
if(width){payload.width=width}
if(height){payload.height=height}
return http.get(path,{'content-type':'application/json',},payload)},getQR:function(text,size=400,margin=1,download=0){if(text===undefined){throw new Error('Missing required parameter: "text"')}
let path='/avatars/qr';let payload={};if(text){payload.text=text}
if(size){payload.size=size}
if(margin){payload.margin=margin}
if(download){payload.download=download}
return http.get(path,{'content-type':'application/json',},payload)}};let database={listCollections:function(search='',limit=25,offset=0,orderType='ASC'){let path='/database';let payload={};if(search){payload.search=search}
if(limit){payload.limit=limit}
if(offset){payload.offset=offset}
if(orderType){payload.orderType=orderType}
return http.get(path,{'content-type':'application/json',},payload)},createCollection:function(name,read,write,rules){if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
if(rules===undefined){throw new Error('Missing required parameter: "rules"')}
let path='/database';let payload={};if(name){payload.name=name}
if(read){payload.read=read}
if(write){payload.write=write}
if(rules){payload.rules=rules}
return http.post(path,{'content-type':'application/json',},payload)},getCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateCollection:function(collectionId,name,read,write,rules=[]){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);let payload={};if(name){payload.name=name}
if(read){payload.read=read}
if(write){payload.write=write}
if(rules){payload.rules=rules}
return http.put(path,{'content-type':'application/json',},payload)},deleteCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},listDocuments:function(collectionId,filters=[],offset=0,limit=50,orderField='$uid',orderType='ASC',orderCast='string',search='',first=0,last=0){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);let payload={};if(filters){payload.filters=filters}
if(offset){payload.offset=offset}
if(limit){payload.limit=limit}
if(orderField){payload['order-field']=orderField}
if(orderType){payload['order-type']=orderType}
if(orderCast){payload['order-cast']=orderCast}
if(search){payload.search=search}
if(first){payload.first=first}
if(last){payload.last=last}
return http.get(path,{'content-type':'application/json',},payload)},createDocument:function(collectionId,data,read,write,parentDocument='',parentProperty='',parentPropertyType='assign'){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(data===undefined){throw new Error('Missing required parameter: "data"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);let payload={};if(data){payload.data=data}
if(read){payload.read=read}
if(write){payload.write=write}
if(parentDocument){payload.parentDocument=parentDocument}
if(parentProperty){payload.parentProperty=parentProperty}
if(parentPropertyType){payload.parentPropertyType=parentPropertyType}
return http.post(path,{'content-type':'application/json',},payload)},getDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateDocument:function(collectionId,documentId,data,read,write){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
if(data===undefined){throw new Error('Missing required parameter: "data"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);let payload={};if(data){payload.data=data}
if(read){payload.read=read}
if(write){payload.write=write}
return http.patch(path,{'content-type':'application/json',},payload)},deleteDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)}};let locale={getLocale:function(){let path='/locale';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getContinents:function(){let path='/locale/continents';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getCountries:function(){let path='/locale/countries';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getCountriesEU:function(){let path='/locale/countries/eu';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getCountriesPhones:function(){let path='/locale/countries/phones';let payload={};return http.get(path,{'content-type':'application/json',},payload)},getCurrencies:function(){let path='/locale/currencies';let payload={};return http.get(path,{'content-type':'application/json',},payload)}};let projects={listProjects:function(){let path='/projects';let payload={};return http.get(path,{'content-type':'application/json',},payload)},createProject:function(name,teamId,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/projects';let payload={};if(name){payload.name=name}
if(teamId){payload.teamId=teamId}
if(description){payload.description=description}
if(logo){payload.logo=logo}
if(url){payload.url=url}
if(legalName){payload.legalName=legalName}
if(legalCountry){payload.legalCountry=legalCountry}
if(legalState){payload.legalState=legalState}
if(legalCity){payload.legalCity=legalCity}
if(legalAddress){payload.legalAddress=legalAddress}
if(legalTaxId){payload.legalTaxId=legalTaxId}
return http.post(path,{'content-type':'application/json',},payload)},getProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateProject:function(projectId,name,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(name){payload.name=name}
if(description){payload.description=description}
if(logo){payload.logo=logo}
if(url){payload.url=url}
if(legalName){payload.legalName=legalName}
if(legalCountry){payload.legalCountry=legalCountry}
if(legalState){payload.legalState=legalState}
if(legalCity){payload.legalCity=legalCity}
if(legalAddress){payload.legalAddress=legalAddress}
if(legalTaxId){payload.legalTaxId=legalTaxId}
return http.patch(path,{'content-type':'application/json',},payload)},deleteProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},listKeys:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},createKey:function(projectId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"')}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(name){payload.name=name}
if(scopes){payload.scopes=scopes}
return http.post(path,{'content-type':'application/json',},payload)},getKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateKey:function(projectId,keyId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);let payload={};if(name){payload.name=name}
if(scopes){payload.scopes=scopes}
return http.put(path,{'content-type':'application/json',},payload)},deleteKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},updateProjectOAuth:function(projectId,provider,appId='',secret=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(provider===undefined){throw new Error('Missing required parameter: "provider"')}
let path='/projects/{projectId}/oauth'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(provider){payload.provider=provider}
if(appId){payload.appId=appId}
if(secret){payload.secret=secret}
return http.patch(path,{'content-type':'application/json',},payload)},listPlatforms:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},createPlatform:function(projectId,type,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(type===undefined){throw new Error('Missing required parameter: "type"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(type){payload.type=type}
if(name){payload.name=name}
if(key){payload.key=key}
if(store){payload.store=store}
if(url){payload.url=url}
return http.post(path,{'content-type':'application/json',},payload)},getPlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updatePlatform:function(projectId,platformId,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);let payload={};if(name){payload.name=name}
if(key){payload.key=key}
if(store){payload.store=store}
if(url){payload.url=url}
return http.put(path,{'content-type':'application/json',},payload)},deletePlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},listTasks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},createTask:function(projectId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"')}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"')}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(name){payload.name=name}
if(status){payload.status=status}
if(schedule){payload.schedule=schedule}
if(security){payload.security=security}
if(httpMethod){payload.httpMethod=httpMethod}
if(httpUrl){payload.httpUrl=httpUrl}
if(httpHeaders){payload.httpHeaders=httpHeaders}
if(httpUser){payload.httpUser=httpUser}
if(httpPass){payload.httpPass=httpPass}
return http.post(path,{'content-type':'application/json',},payload)},getTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateTask:function(projectId,taskId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"')}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);let payload={};if(name){payload.name=name}
if(status){payload.status=status}
if(schedule){payload.schedule=schedule}
if(security){payload.security=security}
if(httpMethod){payload.httpMethod=httpMethod}
if(httpUrl){payload.httpUrl=httpUrl}
if(httpHeaders){payload.httpHeaders=httpHeaders}
if(httpUser){payload.httpUser=httpUser}
if(httpPass){payload.httpPass=httpPass}
return http.put(path,{'content-type':'application/json',},payload)},deleteTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},getProjectUsage:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/usage'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},listWebhooks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},createWebhook:function(projectId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(events===undefined){throw new Error('Missing required parameter: "events"')}
if(url===undefined){throw new Error('Missing required parameter: "url"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);let payload={};if(name){payload.name=name}
if(events){payload.events=events}
if(url){payload.url=url}
if(security){payload.security=security}
if(httpUser){payload.httpUser=httpUser}
if(httpPass){payload.httpPass=httpPass}
return http.post(path,{'content-type':'application/json',},payload)},getWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateWebhook:function(projectId,webhookId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(events===undefined){throw new Error('Missing required parameter: "events"')}
if(url===undefined){throw new Error('Missing required parameter: "url"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);let payload={};if(name){payload.name=name}
if(events){payload.events=events}
if(url){payload.url=url}
if(security){payload.security=security}
if(httpUser){payload.httpUser=httpUser}
if(httpPass){payload.httpPass=httpPass}
return http.put(path,{'content-type':'application/json',},payload)},deleteWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)}};let storage={listFiles:function(search='',limit=25,offset=0,orderType='ASC'){let path='/storage/files';let payload={};if(search){payload.search=search}
if(limit){payload.limit=limit}
if(offset){payload.offset=offset}
if(orderType){payload.orderType=orderType}
return http.get(path,{'content-type':'application/json',},payload)},createFile:function(files,read,write){if(files===undefined){throw new Error('Missing required parameter: "files"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
let path='/storage/files';let payload={};if(files){payload.files=files}
if(read){payload.read=read}
if(write){payload.write=write}
return http.post(path,{'content-type':'multipart/form-data',},payload)},getFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateFile:function(fileId,read,write){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
if(read===undefined){throw new Error('Missing required parameter: "read"')}
if(write===undefined){throw new Error('Missing required parameter: "write"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);let payload={};if(read){payload.read=read}
if(write){payload.write=write}
return http.put(path,{'content-type':'application/json',},payload)},deleteFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},getFileDownload:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/download'.replace(new RegExp('{fileId}','g'),fileId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},getFilePreview:function(fileId,width=0,height=0,quality=100,background='',output=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/preview'.replace(new RegExp('{fileId}','g'),fileId);let payload={};if(width){payload.width=width}
if(height){payload.height=height}
if(quality){payload.quality=quality}
if(background){payload.background=background}
if(output){payload.output=output}
return http.get(path,{'content-type':'application/json',},payload)},getFileView:function(fileId,as=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/view'.replace(new RegExp('{fileId}','g'),fileId);let payload={};if(as){payload.as=as}
return http.get(path,{'content-type':'application/json',},payload)}};let teams={listTeams:function(search='',limit=25,offset=0,orderType='ASC'){let path='/teams';let payload={};if(search){payload.search=search}
if(limit){payload.limit=limit}
if(offset){payload.offset=offset}
if(orderType){payload.orderType=orderType}
return http.get(path,{'content-type':'application/json',},payload)},createTeam:function(name,roles=["owner"]){if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/teams';let payload={};if(name){payload.name=name}
if(roles){payload.roles=roles}
return http.post(path,{'content-type':'application/json',},payload)},getTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateTeam:function(teamId,name){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);let payload={};if(name){payload.name=name}
return http.put(path,{'content-type':'application/json',},payload)},deleteTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},getTeamMembers:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}/members'.replace(new RegExp('{teamId}','g'),teamId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},createTeamMembership:function(teamId,email,roles,redirect,name=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(roles===undefined){throw new Error('Missing required parameter: "roles"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/teams/{teamId}/memberships'.replace(new RegExp('{teamId}','g'),teamId);let payload={};if(email){payload.email=email}
if(name){payload.name=name}
if(roles){payload.roles=roles}
if(redirect){payload.redirect=redirect}
return http.post(path,{'content-type':'application/json',},payload)},deleteTeamMembership:function(teamId,inviteId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
let path='/teams/{teamId}/memberships/{inviteId}'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},createTeamMembershipResend:function(teamId,inviteId,redirect){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/teams/{teamId}/memberships/{inviteId}/resend'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);let payload={};if(redirect){payload.redirect=redirect}
return http.post(path,{'content-type':'application/json',},payload)},updateTeamMembershipStatus:function(teamId,inviteId,userId,secret,success='',failure=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(secret===undefined){throw new Error('Missing required parameter: "secret"')}
let path='/teams/{teamId}/memberships/{inviteId}/status'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);let payload={};if(userId){payload.userId=userId}
if(secret){payload.secret=secret}
if(success){payload.success=success}
if(failure){payload.failure=failure}
payload.project=config.project;return iframe('patch',path,payload)}};let users={listUsers:function(search='',limit=25,offset=0,orderType='ASC'){let path='/users';let payload={};if(search){payload.search=search}
if(limit){payload.limit=limit}
if(offset){payload.offset=offset}
if(orderType){payload.orderType=orderType}
return http.get(path,{'content-type':'application/json',},payload)},createUser:function(email,password,name=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/users';let payload={};if(email){payload.email=email}
if(password){payload.password=password}
if(name){payload.name=name}
return http.post(path,{'content-type':'application/json',},payload)},getUser:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}'.replace(new RegExp('{userId}','g'),userId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},getUserLogs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/logs'.replace(new RegExp('{userId}','g'),userId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},getUserPrefs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/prefs'.replace(new RegExp('{userId}','g'),userId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},updateUserPrefs:function(userId,prefs){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(prefs===undefined){throw new Error('Missing required parameter: "prefs"')}
let path='/users/{userId}/prefs'.replace(new RegExp('{userId}','g'),userId);let payload={};if(prefs){payload.prefs=prefs}
return http.patch(path,{'content-type':'application/json',},payload)},getUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);let payload={};return http.get(path,{'content-type':'application/json',},payload)},deleteUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);let payload={};return http.delete(path,{'content-type':'application/json',},payload)},deleteUserSession:function(userId,sessionId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(sessionId===undefined){throw new Error('Missing required parameter: "sessionId"')}
let path='/users/{userId}/sessions/:session'.replace(new RegExp('{userId}','g'),userId);let payload={};if(sessionId){payload.sessionId=sessionId}
return http.delete(path,{'content-type':'application/json',},payload)},updateUserStatus:function(userId,status){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
let path='/users/{userId}/status'.replace(new RegExp('{userId}','g'),userId);let payload={};if(status){payload.status=status}
return http.patch(path,{'content-type':'application/json',},payload)}};return{setEndpoint:setEndpoint,setProject:setProject,setKey:setKey,setLocale:setLocale,setMode:setMode,account:account,auth:auth,avatars:avatars,database:database,locale:locale,projects:projects,storage:storage,teams:teams,users:users}};if(typeof module!=="undefined"){module.exports=window.Appwrite}})((typeof window!=="undefined")?window:{})