/*
 * Decompiled with CFR 0.152.
 */
package jtermios.solaris;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/term/";
    static Solaris_C_lib m_Clib = (Solaris_C_lib)Native.loadLibrary((String)"c", Solaris_C_lib.class);

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 1074030207;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 128;
        JTermios.O_NOCTTY = 2048;
        JTermios.O_NDELAY = 4;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 11;
        JTermios.EBADF = 9;
        JTermios.EACCES = 22;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 90;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 78;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSR = 63;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 79;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 48;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.IGNPAR = 4;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 64;
        JTermios.IEXTEN = 32768;
        JTermios.CLOCAL = 2048;
        JTermios.OPOST = 1;
        JTermios.VSTART = 8;
        JTermios.TCSANOW = 21518;
        JTermios.VSTOP = 9;
        JTermios.VMIN = 4;
        JTermios.VTIME = 5;
        JTermios.VEOF = 4;
        JTermios.TIOCMGET = 29725;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 2;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 16;
        JTermios.ISIG = 1;
        JTermios.TIOCMSET = 29722;
        JTermios.IXON = 1024;
        JTermios.IXOFF = 4096;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = Integer.MIN_VALUE;
        JTermios.TCSADRAIN = 21519;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 48;
        JTermios.TCIFLUSH = 0;
        JTermios.TCOFLUSH = 1;
        JTermios.TCIOFLUSH = 2;
        JTermios.CS5 = 0;
        JTermios.CS6 = 16;
        JTermios.CS7 = 32;
        JTermios.CS8 = 48;
        JTermios.CSTOPB = 64;
        JTermios.CREAD = 128;
        JTermios.PARENB = 256;
        JTermios.PARODD = 512;
        JTermios.B0 = 0;
        JTermios.B50 = 1;
        JTermios.B75 = 2;
        JTermios.B110 = 3;
        JTermios.B134 = 4;
        JTermios.B150 = 5;
        JTermios.B200 = 6;
        JTermios.B300 = 7;
        JTermios.B600 = 8;
        JTermios.B1200 = 8;
        JTermios.B1800 = 10;
        JTermios.B2400 = 11;
        JTermios.B4800 = 12;
        JTermios.B9600 = 13;
        JTermios.B19200 = 14;
        JTermios.B38400 = 15;
        JTermios.B57600 = 16;
        JTermios.B76800 = 17;
        JTermios.B115200 = 18;
        JTermios.B230400 = 20;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        Solaris_C_lib.termios t = new Solaris_C_lib.termios(termios2);
        t.c_iflag &= ~(JTermios.IGNBRK | JTermios.BRKINT | JTermios.PARMRK | JTermios.ISTRIP | JTermios.INLCR | JTermios.IGNCR | JTermios.ICRNL | JTermios.IXON);
        t.c_oflag &= ~JTermios.OPOST;
        t.c_lflag &= ~(JTermios.ECHO | JTermios.ECHONL | JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN);
        t.c_cflag &= ~(JTermios.CSIZE | JTermios.PARENB);
        t.c_cflag |= JTermios.CS8;
        t.update(termios2);
    }

    public int fcntl(int fd, int cmd, int[] arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int tcdrain(int fd) {
        return m_Clib.tcdrain(fd);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new Solaris_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new Solaris_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        Solaris_C_lib.termios t = new Solaris_C_lib.termios(termios2);
        int ret = m_Clib.cfsetispeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        Solaris_C_lib.termios t = new Solaris_C_lib.termios(termios2);
        int ret = m_Clib.cfsetospeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int open(String s, int t) {
        if (s != null && !s.startsWith("/")) {
            s = DEVICE_DIR_PATH + s;
        }
        return m_Clib.open(s, t);
    }

    @Override
    public int read(int fd, byte[] buffer, int len) {
        return m_Clib.read(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int write(int fd, byte[] buffer, int len) {
        return m_Clib.write(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public int tcflush(int fd, int b) {
        return m_Clib.tcflush(fd, b);
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        Solaris_C_lib.termios t = new Solaris_C_lib.termios();
        int ret = m_Clib.tcgetattr(fd, t);
        t.update(termios2);
        return ret;
    }

    @Override
    public void perror(String msg) {
        m_Clib.perror(msg);
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        return m_Clib.tcsendbreak(fd, duration / 250);
    }

    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        return m_Clib.tcsetattr(fd, cmd, new Solaris_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] & ~(1 << fd % 32);
    }

    @Override
    public boolean FD_ISSET(int fd, FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        return (p.bits[fd / 32] & 1 << fd % 32) != 0;
    }

    @Override
    public void FD_SET(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] | 1 << fd % 32;
    }

    @Override
    public void FD_ZERO(FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, 0);
    }

    @Override
    public int select(int nfds, FDSet rfds, FDSet wfds, FDSet efds, TimeVal timeout) {
        Solaris_C_lib.timeval tout = null;
        if (timeout != null) {
            tout = new Solaris_C_lib.timeval(timeout);
        }
        int[] r = rfds != null ? ((FDSetImpl)rfds).bits : null;
        int[] w = wfds != null ? ((FDSetImpl)wfds).bits : null;
        int[] e = efds != null ? ((FDSetImpl)efds).bits : null;
        return m_Clib.select(nfds, r, w, e, tout);
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        Solaris_C_lib.pollfd[] pfds = new Solaris_C_lib.pollfd[fds.length];
        for (int i = 0; i < nfds; ++i) {
            pfds[i] = new Solaris_C_lib.pollfd(fds[i]);
        }
        int ret = m_Clib.poll(pfds, nfds, timeout);
        for (int i = 0; i < nfds; ++i) {
            fds[i].revents = pfds[i].revents;
        }
        return ret;
    }

    @Override
    public int poll(int[] fds, int nfds, int timeout) {
        return m_Clib.poll(fds, nfds, timeout);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int fd, int cmd, int[] data) {
        return m_Clib.ioctl(fd, cmd, data);
    }

    @Override
    public String getPortNamePattern() {
        return ".*";
    }

    @Override
    public List<String> getPortList() {
        File dir = new File(DEVICE_DIR_PATH);
        if (!dir.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] devs = dir.list();
        LinkedList<String> list = new LinkedList<String>();
        Pattern p = JTermios.getPortNamePattern(this);
        if (devs != null) {
            for (int i = 0; i < devs.length; ++i) {
                String s = devs[i];
                if (!p.matcher(s).matches()) continue;
                list.add(s);
            }
        }
        return list;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int br = speed;
        switch (speed) {
            case 50: {
                br = JTermios.B50;
                break;
            }
            case 75: {
                br = JTermios.B75;
                break;
            }
            case 110: {
                br = JTermios.B110;
                break;
            }
            case 134: {
                br = JTermios.B134;
                break;
            }
            case 150: {
                br = JTermios.B150;
                break;
            }
            case 200: {
                br = JTermios.B200;
                break;
            }
            case 300: {
                br = JTermios.B300;
                break;
            }
            case 600: {
                br = JTermios.B600;
                break;
            }
            case 1200: {
                br = JTermios.B1200;
                break;
            }
            case 1800: {
                br = JTermios.B1800;
                break;
            }
            case 2400: {
                br = JTermios.B2400;
                break;
            }
            case 4800: {
                br = JTermios.B4800;
                break;
            }
            case 9600: {
                br = JTermios.B9600;
                break;
            }
            case 19200: {
                br = JTermios.B19200;
                break;
            }
            case 38400: {
                br = JTermios.B38400;
                break;
            }
            case 7200: {
                br = JTermios.B7200;
                break;
            }
            case 14400: {
                br = JTermios.B14400;
                break;
            }
            case 28800: {
                br = JTermios.B28800;
                break;
            }
            case 57600: {
                br = JTermios.B57600;
                break;
            }
            case 76800: {
                br = JTermios.B76800;
                break;
            }
            case 115200: {
                br = JTermios.B115200;
                break;
            }
            case 230400: {
                br = JTermios.B230400;
            }
        }
        int r = this.cfsetispeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.cfsetospeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    @Override
    public int pipe(int[] fds) {
        return m_Clib.pipe(fds);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface Solaris_C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public int fcntl(int var1, int var2, int[] var3);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public NativeLong write(int var1, ByteBuffer var2, NativeLong var3);

        public NativeLong read(int var1, ByteBuffer var2, NativeLong var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public static class termios
        extends Structure {
            public int c_iflag;
            public int c_oflag;
            public int c_cflag;
            public int c_lflag;
            public byte[] c_cc = new byte[32];

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc");
            }

            public termios() {
            }

            public termios(Termios t) {
                this.c_iflag = t.c_iflag;
                this.c_oflag = t.c_oflag;
                this.c_cflag = t.c_cflag;
                this.c_lflag = t.c_lflag;
                System.arraycopy(t.c_cc, 0, this.c_cc, 0, t.c_cc.length);
            }

            public void update(Termios t) {
                t.c_iflag = this.c_iflag;
                t.c_oflag = this.c_oflag;
                t.c_cflag = this.c_cflag;
                t.c_lflag = this.c_lflag;
                System.arraycopy(this.c_cc, 0, t.c_cc, 0, t.c_cc.length);
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pfd) {
                this.fd = pfd.fd;
                this.events = pfd.events;
                this.revents = pfd.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeout) {
                this.tv_sec = new NativeLong(timeout.tv_sec);
                this.tv_usec = new NativeLong(timeout.tv_usec);
            }
        }
    }
}

