Corda Network: UAT Environment
=============================

Corda Network UAT seeks to provide a test environment which is as close as possible to Corda Network in its make-up and operation.

For owners of tested CorDapps with a firm plan to take them into production, a bespoke UAT environment can be provided by R3. Here, such CorDapps can be further tested in the network configuration they will experience in production, utilising relevant Corda Network Services (including the Identity Operator, and trusted notaries). 

Corda UAT is not intended for customers' full test cycles, as it is expected that the bulk of CorDapp testing will occur in simpler network configurations run by the CorDapp provider, but is available for testing of functionally complete and tested CorDapps in realistic network settings to simulate the real-world business environment, including the production settings of network parameters, Corda network services and supported Corda versions. 

UAT is therefore more aligned to the testing of the operational characteristics of networked CorDapps rather than their specific functional features, although we recognise there can be overlap between the two. Realistic test data is therefore expected to be used and may include data copied from production environments and hence representing real world entities and business activities. It will be up to the introducer of such data to ensure that all relevant data protection legislation is complied with and, in particular, that the terms and conditions under which Corda Network Services processes such data is suitable for their needs. All test data will be cleared down from Corda Network Services on the completion of testing.

More information about UAT will continue to be uploaded on this site or related sub-sites.


Joining the UAT environment
---------------------------

*The below joining steps assume the potential participant is joining the UAT environment directly, and as such is not “sponsoring” or onboarding other participants. If this is the case, please contact your Corda representative for how to ‘sponsor’ end-participants onto UAT.*

**Pre-requisites:**

*Technical*
* One or more physical or virtual machines upon which to deploy Corda, with compatible operating system and a compatible Java version (e.g. Oracle JDK 8u131+)
* Corda software - either Open Source or Corda Enterprise (CE requires a license from R3) 
* A static external IP addresses must be available for each machine on which Corda will be run.

*Business*
* Appropriate contractual terms have been agreed for access to the Services
* Access to the appropriate environment has been agreed with your project representative with sufficient advance notice (4 weeks standard but may be longer if you have special service requirements) to ensure appropriate SLAs can be in place. Your project representative will be able to supply the booking template.

**Note**: 
Corda Network UAT is governed by an [independent Foundation](https://corda.network/governance/index.html). 


Steps to join UAT environment
-----------------------------

Steps to join are outlined on the [Corda Network UAT microsite](http://uat.network.r3.com/pages/joining/joining.html)

For further questions on this process, please contact us - preferably on the mailing list: https://groups.io/g/corda-network
