/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.nio.ByteBuffer;

public class Benchmark {
    static CLibDM m_CLibDM;
    static CLib m_CLibIB;
    static CLib m_CLib;
    static byte[] m_Bytes;
    static ByteBuffer m_BytesAsBuffer;
    static long m_BytesN;

    static void call_memset() {
        m_CLib.memset(m_Bytes, 69, m_BytesN);
    }

    static void call_memmove() {
        m_CLib.memmove(m_Bytes, m_Bytes, m_BytesN);
    }

    static int call_htonl() {
        return m_CLib.htonl(-559038737);
    }

    public static void runBenchmarks(int N, double[] res, int offs) {
        int i;
        long t0 = System.nanoTime();
        for (i = 0; i < N; ++i) {
            Benchmark.call_htonl();
        }
        res[offs] = (System.nanoTime() - t0) / (long)N;
        t0 = System.nanoTime();
        for (i = 0; i < N; ++i) {
            Benchmark.call_memset();
        }
        long dt = System.nanoTime() - t0;
        res[offs + 1] = (System.nanoTime() - t0) / (long)N;
        t0 = System.nanoTime();
        for (i = 0; i < N; ++i) {
            Benchmark.call_memmove();
        }
        dt = System.nanoTime() - t0;
        res[offs + 2] = (System.nanoTime() - t0) / (long)N;
    }

    public static void main(String[] args) {
        try {
            Native.register(CLibDM.class, (NativeLibrary)NativeLibrary.getInstance((String)"c"));
            m_CLibDM = new CLibDM();
            m_CLibIB = (CLib)Native.loadLibrary((String)"c", CLib.class);
            int N = 10000;
            double[] res = new double[6];
            for (int i = 0; i < 10000; ++i) {
                m_CLib = m_CLibIB;
                Benchmark.runBenchmarks(N, res, 0);
                m_CLib = m_CLibDM;
                Benchmark.runBenchmarks(N, res, 3);
                for (int j = 0; j < res.length; ++j) {
                    System.out.printf("%15.3f", res[j] / 1000.0);
                }
                System.out.println();
            }
            System.out.printf("%15s%15s%150s%15s%15s%15s\n", "IB/htonl", "IB/memset", "IB/memmove", "DM/htonl", "DM/htonl", "DM/memmove");
            System.out.printf("results in usec", new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        m_Bytes = new byte[4096];
        m_BytesAsBuffer = ByteBuffer.wrap(m_Bytes);
        m_BytesN = m_Bytes.length;
    }

    public static class CLibDM
    implements CLib {
        public native int htonl(int var1);

        public native void memset(byte[] var1, int var2, long var3);

        public native void memmove(byte[] var1, byte[] var2, long var3);
    }

    public static interface CLib
    extends Library {
        public int htonl(int var1);

        public void memset(byte[] var1, int var2, long var3);

        public void memmove(byte[] var1, byte[] var2, long var3);
    }
}

