# -*- coding: utf-8 -*-

import sphinx_rtd_theme
import sys, os

############################################################################
#
# TEXT SUBSTITUTIONS

with open("../../constants.properties", "r") as f:
    constants_properties_lines = f.readlines()
constants_properties_dict = dict([l.strip().split('=') for l in constants_properties_lines if not l.startswith("#") and not l.strip() == ""])

def cordaSourceReadReplace(app, docname, source):
    result = source[0]
    for key in app.config.corda_substitutions:
        result = result.replace(key, app.config.corda_substitutions[key])
    source[0] = result

corda_substitutions = {
    "|corda_version|" : constants_properties_dict["cordaVersion"],
    "|corda_version_lower|" : constants_properties_dict["cordaVersion"].lower(),
    "|java_version|" : "8u"+constants_properties_dict["java8MinUpdateVersion"],
    "|kotlin_version|" : constants_properties_dict["kotlinVersion"],
    "|gradle_plugins_version|" : constants_properties_dict["gradlePluginsVersion"],
    "|quasar_version|" : constants_properties_dict["quasarVersion"],
    "|platform_version|" : constants_properties_dict["platformVersion"],
    "|os_branch|" : constants_properties_dict["openSourceBranch"],
    "|os_samples_branch|" : constants_properties_dict["openSourceSamplesBranch"],
    "|jolokia_version|" : constants_properties_dict["jolokiaAgentVersion"]
}

def setup(app):
   app.add_config_value('corda_substitutions', {}, True)
   app.connect('source-read', cordaSourceReadReplace)

############################################################################

sys.path.append(os.path.abspath('../ext/'))

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
# sys.path.insert(0, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# m2r is a Markdown to RST converter, as our design docs use Markdown.
extensions = ['rst2pdf.pdfbuilder', 'm2r', 'conditional_toctree']

# PDF configuration
pdf_documents = [('index', u'corda-developer-site', u'Corda Developer Documentation', u'R3')]
pdf_stylesheets = ['sphinx', 'kerning', 'a4', 'murphy', 'tenpoint']
pdf_compressed = True
pdf_fit_mode = "shrink"
pdf_fit_background_mode = "shrink"

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
source_suffix = ['.rst', '.md']

# The encoding of source files.
source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'R3 Corda'
copyright = u'2018, R3 Limited'
author = u'R3 DLG'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = 'Master'
# The full version, including alpha/beta/rc tags.
release = 'Master'
# The version for use in the dropdown html.
html_context = {'version': 'Master'}

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['design/README.md']
if tags.has('pdfmode'):
    exclude_patterns = ['design', 'design/README.md']

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

highlight_language = 'kotlin'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# html_theme = 'alabaster'

html_theme = "sphinx_rtd_theme"

html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# html_add_permalinks = True

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.

html_theme_options = {
    'includehidden':True,
    'collapse_navigation':False,
    'sticky_navigation':True,
    'titles_only':True
}
# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_static/favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_style = 'css/custom.css'

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
# html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr'
# html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
# html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
# html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = 'R3doc'

# -- Options for LaTeX output ---------------------------------------------

latex_documents = [('index', u'corda-developer-site.tex', u'Corda Developer Documentation', u'R3', 'manual', False)]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True

_PREAMBLE = r"""
\usepackage[utf8]{inputenc}
\usepackage{pmboxdraw}
\DeclareUnicodeCharacter{2514}{\textSFii}
\DeclareUnicodeCharacter{251C}{\textSFviii}
\DeclareUnicodeCharacter{2705}{\checkmark}
"""

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    # 'preamble': '',

    # Latex figure (float) alignment
    # 'figure_align': 'htbp',

    'maxlistdepth' : '2000',

    'preamble' : _PREAMBLE,

    'extraclassoptions' : 'openany',
}
