/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPort;

public class TestBase {
    protected static volatile String m_TestPortName;
    protected static volatile SerialPort m_Port;
    private static volatile long m_T0;
    protected static volatile OutputStream m_Out;
    protected static volatile InputStream m_In;
    protected static volatile int[] m_SyncSema4;
    protected static int m_Tab;
    protected static int m_Progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sync(int N) throws InterruptedException {
        int[] nArray = m_SyncSema4;
        synchronized (m_SyncSema4) {
            m_SyncSema4[0] = m_SyncSema4[0] + 1;
            if (m_SyncSema4[0] < N) {
                m_SyncSema4.wait();
            } else {
                TestBase.m_SyncSema4[0] = 0;
                m_SyncSema4.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static void openPort() throws Exception {
        try {
            CommPortIdentifier portid = CommPortIdentifier.getPortIdentifier(m_TestPortName);
            m_Port = (SerialPort)portid.open("PureJavaCommTestSuite", 1000);
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            TestBase.drain(m_In);
        }
        catch (NoSuchPortException e) {
            TestBase.fail("could no open port '%s'\n", m_TestPortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closePort() {
        if (m_Port != null) {
            try {
                m_Out.flush();
                m_Port.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                m_Port = null;
            }
        }
    }

    protected static void drain(InputStream ins) throws Exception {
        int n;
        TestBase.sleep(100);
        while ((n = ins.available()) > 0) {
            for (int i = 0; i < n; ++i) {
                ins.read();
            }
            TestBase.sleep(100);
        }
    }

    static void begin(String name) {
        System.out.printf("%-46s", name);
        m_Tab = 46;
        m_T0 = System.currentTimeMillis();
        m_Progress = 0;
    }

    protected static void sleep() throws InterruptedException {
        TestBase.sleep(40);
    }

    protected static void sleep(int t) throws InterruptedException {
        int m = 1000;
        while (t > 0) {
            Thread.sleep(t > m ? (long)m : (long)t);
            t -= m;
            while ((System.currentTimeMillis() - m_T0) / (long)m > (long)m_Progress) {
                System.out.print(".");
                --m_Tab;
                ++m_Progress;
            }
        }
    }

    static void fail(String format, Object ... args) throws TestFailedException {
        System.out.println(" FAILED");
        System.out.println("------------------------------------------------------------");
        System.out.printf(format, args);
        System.out.println();
        System.out.println("------------------------------------------------------------");
        throw new TestFailedException();
    }

    static void finishedOK() {
        TestBase.finishedOK("", new Object[0]);
    }

    static void finishedOK(String format, Object ... args) {
        for (int i = 0; i < m_Tab; ++i) {
            System.out.print(".");
        }
        System.out.printf(" OK " + format, args);
        System.out.println();
    }

    public static void init(String[] args) {
        m_TestPortName = "cu.usbserial-FTOXM3NX";
        if (args.length > 0) {
            m_TestPortName = args[0];
        }
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        boolean found = false;
        String last = null;
        while (e.hasMoreElements()) {
            CommPortIdentifier portid = (CommPortIdentifier)e.nextElement();
            if (portid.getPortType() != 1) continue;
            if (portid.getName().equals(m_TestPortName)) {
                found = true;
            }
            last = portid.getName();
        }
        if (!found) {
            m_TestPortName = last;
        }
    }

    public static String getPortName() {
        return m_TestPortName;
    }

    static {
        m_SyncSema4 = new int[]{0};
    }

    static class TestFailedException
    extends Exception {
        TestFailedException() {
        }
    }
}

