/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.CommPortIdentifier;
import purejavacomm.SerialPort;

public class SpeedTest {
    static volatile SerialPort port = null;
    static volatile boolean rxdone;
    static volatile boolean txdone;
    static volatile int messageSize;
    static volatile int messageCount;
    static volatile byte[] txbuffer;
    static volatile byte[] rxbuffer;
    static volatile long T0;
    static volatile long T1;
    static volatile long N;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            CommPortIdentifier portIdent = CommPortIdentifier.getPortIdentifier("ttyUSB0");
            port = (SerialPort)portIdent.open("speedtest", 1000);
            messageSize = 200;
            messageCount = 500;
            port.setSerialPortParams(230000, 8, 1, 0);
            port.enableReceiveThreshold(messageSize);
            port.enableReceiveTimeout(1000);
            txbuffer = new byte[messageSize];
            rxbuffer = new byte[messageSize];
            for (int i = 0; i < messageSize; ++i) {
                SpeedTest.txbuffer[i] = (byte)((i & 0x1F) + 65);
            }
            Thread txthread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OutputStream out = port.getOutputStream();
                        int txCount = 0;
                        if (T0 == 0L) {
                            T0 = System.nanoTime();
                        }
                        while (txCount++ < messageCount) {
                            out.write(txbuffer);
                            N += (long)txbuffer.length;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        txdone = true;
                    }
                }
            });
            Thread rxthread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        InputStream in = port.getInputStream();
                        byte[] rxbuffer = new byte[messageSize];
                        int rxCount = 0;
                        while (rxCount++ < messageCount) {
                            int n = in.read(rxbuffer);
                            if (n != messageSize) {
                                throw new IOException("" + n + " != " + messageSize);
                            }
                            for (int i = 0; i < messageSize; ++i) {
                                if (rxbuffer[i] == txbuffer[i]) continue;
                                throw new IOException(String.format(" rxbuffer[%d] = 0x%02X,txbuffer[%d]=0x%02X, message %d ", i, 0xFF & rxbuffer[i], i, 0xFF & txbuffer[i], rxCount));
                            }
                        }
                        T1 = System.nanoTime();
                        System.out.println("Done, average speed was " + (int)((double)(N * 10L) / ((double)(T1 - T0) / 1.0E9)) + " baud");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        rxdone = true;
                    }
                }
            });
            rxthread.setPriority(10);
            txthread.setPriority(10);
            rxthread.start();
            txthread.start();
            while (!txdone || !rxdone) {
                System.out.println("Dave, I'm feeling sleepy...");
                Thread.sleep(100L);
            }
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
    }
}

