/*
 * Decompiled with CFR 0.152.
 */
package jtermios;

import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.macosx.JTermiosImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermios {
    public static int FIONREAD = 1074030207;
    public static int O_RDWR = 2;
    public static int O_NONBLOCK = 4;
    public static int O_NOCTTY = 131072;
    public static int O_NDELAY = 4;
    public static int O_CREAT = 512;
    public static int F_GETFL = 3;
    public static int F_SETFL = 4;
    public static int EAGAIN = 35;
    public static int EBADF = 9;
    public static int EACCES = 22;
    public static int EEXIST = 17;
    public static int EINTR = 4;
    public static int EINVAL = 22;
    public static int EIO = 5;
    public static int EISDIR = 21;
    public static int ELOOP = 62;
    public static int EMFILE = 24;
    public static int ENAMETOOLONG = 63;
    public static int ENFILE = 23;
    public static int ENOENT = 2;
    public static int ENOSR = 98;
    public static int ENOSPC = 28;
    public static int ENOTDIR = 20;
    public static int ENXIO = 6;
    public static int EOVERFLOW = 84;
    public static int EROFS = 30;
    public static int ENOTSUP = 45;
    public static int EBUSY = 16;
    public static int TIOCM_RNG = 128;
    public static int TIOCM_CAR = 64;
    public static int IGNBRK = 1;
    public static int BRKINT = 2;
    public static int IGNPAR = 4;
    public static int PARMRK = 8;
    public static int INLCR = 64;
    public static int IGNCR = 128;
    public static int ICRNL = 256;
    public static int ECHONL = 16;
    public static int IEXTEN = 1024;
    public static int CLOCAL = 32768;
    public static int OPOST = 1;
    public static int VSTART = 12;
    public static int TCSANOW = 0;
    public static int VSTOP = 13;
    public static int VMIN = 16;
    public static int VTIME = 17;
    public static int VEOF = 0;
    public static int TIOCMGET = 1074033770;
    public static int TIOCM_CTS = 32;
    public static int TIOCM_DSR = 256;
    public static int TIOCM_RI = 128;
    public static int TIOCM_CD = 64;
    public static int TIOCM_DTR = 2;
    public static int TIOCM_RTS = 4;
    public static int ICANON = 256;
    public static int ECHO = 8;
    public static int ECHOE = 2;
    public static int ISIG = 128;
    public static int TIOCMSET = -2147191699;
    public static int IXON = 512;
    public static int IXOFF = 1024;
    public static int IXANY = 2048;
    public static int CRTSCTS = 196608;
    public static int TCSADRAIN = 1;
    public static int INPCK = 16;
    public static int ISTRIP = 32;
    public static int CSIZE = 768;
    public static int TCIFLUSH = 1;
    public static int TCOFLUSH = 2;
    public static int TCIOFLUSH = 3;
    public static int CS5 = 0;
    public static int CS6 = 256;
    public static int CS7 = 512;
    public static int CS8 = 768;
    public static int CSTOPB = 1024;
    public static int CREAD = 2048;
    public static int PARENB = 4096;
    public static int PARODD = 8192;
    public static int CMSPAR = 0x40000000;
    public static int B0 = 0;
    public static int B50 = 50;
    public static int B75 = 75;
    public static int B110 = 110;
    public static int B134 = 134;
    public static int B150 = 150;
    public static int B200 = 200;
    public static int B300 = 300;
    public static int B600 = 600;
    public static int B1200 = 1200;
    public static int B1800 = 1800;
    public static int B2400 = 2400;
    public static int B4800 = 4800;
    public static int B9600 = 9600;
    public static int B19200 = 19200;
    public static int B38400 = 38400;
    public static int B7200 = 7200;
    public static int B14400 = 14400;
    public static int B28800 = 28800;
    public static int B57600 = 57600;
    public static int B76800 = 76800;
    public static int B115200 = 115200;
    public static int B230400 = 230400;
    public static short POLLIN = 1;
    public static int POLLIN_IN = 1;
    public static int POLLIN_OUT = 1;
    public static short POLLPRI = (short)2;
    public static short POLLOUT = (short)4;
    public static int POLLOUT_IN = 4;
    public static int POLLOUT_OUT = 4;
    public static short POLLERR = (short)8;
    public static short POLLERR_OUT = (short)8;
    public static short POLLNVAL = (short)32;
    public static int POLLNVAL_OUT = 32;
    public static int DC1 = 17;
    public static int DC3 = 19;
    private static JTermiosInterface m_Termios;

    public void shutdown() {
        if (m_Termios != null) {
            m_Termios.shutDown();
        }
    }

    public static int errno() {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> errno()\n", new Object[0]);
        int ret = m_Termios.errno();
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< errno() => %d\n", ret);
        return ret;
    }

    public static int fcntl(int fd, int cmd, int arg) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> fcntl(%d, %d, %d)\n", fd, cmd, arg);
        int ret = m_Termios.fcntl(fd, cmd, arg);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< fcntl(%d, %d, %d) => %d\n", fd, cmd, arg, ret);
        return ret;
    }

    public static int cfgetispeed(Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetispeed(%s)\n", termios2);
        int ret = m_Termios.cfgetispeed(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetispeed(%s) => %d\n", termios2, ret);
        return ret;
    }

    public static int cfgetospeed(Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s)\n", termios2);
        int ret = m_Termios.cfgetospeed(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s) => %d\n", termios2, ret);
        return ret;
    }

    public static int cfsetispeed(Termios termios2, int speed) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s,%d)\n", termios2, speed);
        int ret = m_Termios.cfsetispeed(termios2, speed);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s,%d) => %d\n", termios2, speed, ret);
        return ret;
    }

    public static int cfsetospeed(Termios termios2, int speed) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s,%d)\n", termios2, speed);
        int ret = m_Termios.cfsetospeed(termios2, speed);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s,%d) => %d\n", termios2, speed, ret);
        return ret;
    }

    public static int setspeed(int fd, Termios termios2, int speed) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> setspeed(%d,%s,%d)\n", fd, termios2, speed);
        int ret = m_Termios.setspeed(fd, termios2, speed);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< setspeed(%d,%s,%d) => %d\n", fd, termios2, speed, ret);
        return ret;
    }

    public static int tcflush(int a, int b) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcflush(%d,%d)\n", a, b);
        int ret = m_Termios.tcflush(a, b);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcflush(%d,%d) => %d\n", a, b, ret);
        return ret;
    }

    public static int tcdrain(int fd) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcdrain(%d)\n", fd);
        int ret = m_Termios.tcdrain(fd);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcdrain(%d) => %d\n", fd, ret);
        return ret;
    }

    public static void cfmakeraw(int fd, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfmakeraw(%d,%s)\n", fd, termios2);
        m_Termios.cfmakeraw(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfmakeraw(%d,%s)\n", fd, termios2);
    }

    public static int tcgetattr(int fd, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcgetattr(%d,%s)\n", fd, termios2);
        int ret = m_Termios.tcgetattr(fd, termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcgetattr(%d,%s) => %d\n", fd, termios2, ret);
        return ret;
    }

    public static int tcsetattr(int fd, int cmd, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcsetattr(%d,%d,%s)\n", fd, cmd, termios2);
        int ret = m_Termios.tcsetattr(fd, cmd, termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcsetattr(%d,%d,%s) => %d\n", fd, cmd, termios2, ret);
        return ret;
    }

    public static int tcsendbreak(int fd, int duration) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcsendbreak(%d,%d,%s)\n", fd, duration);
        int ret = m_Termios.tcsendbreak(fd, duration);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcsendbreak(%d,%d,%s) => %d\n", fd, duration, ret);
        return ret;
    }

    public static int open(String s, int t) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> open('%s',%08X)\n", s, t);
        int ret = m_Termios.open(s, t);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< open('%s',%08X) => %d\n", s, t, ret);
        return ret;
    }

    public static int close(int fd) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> close(%d)\n", fd);
        int ret = m_Termios.close(fd);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< close(%d) => %d\n", fd, ret);
        return ret;
    }

    public static int write(int fd, byte[] buffer, int len) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> write(%d,%s,%d)\n", fd, JTermiosLogging.log(buffer, 8), len);
        int ret = m_Termios.write(fd, buffer, len);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< write(%d,%s,%d) => %d\n", fd, JTermiosLogging.log(buffer, 8), len, ret);
        return ret;
    }

    public static int read(int fd, byte[] buffer, int len) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> read(%d,%s,%d)\n", fd, JTermiosLogging.log(buffer, 8), len);
        int ret = m_Termios.read(fd, buffer, len);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< read(%d,%s,%d) => %d\n", fd, JTermiosLogging.log(buffer, 8), len, ret);
        return ret;
    }

    public static int ioctl(int fd, int cmd, int[] data) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> ioctl(%d,%d,[%08X])\n", fd, cmd, data[0]);
        int ret = m_Termios.ioctl(fd, cmd, data);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< ioctl(%d,%d,[%08X]) => %d\n", fd, cmd, data[0], ret);
        return ret;
    }

    private static String toString(int n, FDSet fdset) {
        StringBuffer s = new StringBuffer("[");
        for (int fd = 0; fd < n; ++fd) {
            if (!JTermios.FD_ISSET(fd, fdset)) continue;
            s.append(Integer.toString(fd));
        }
        s.append("]");
        return s.toString();
    }

    public static int select(int n, FDSet read, FDSet write, FDSet error, TimeVal timeout) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> select(%d,%s,%s,%s,%s)\n", n, JTermios.toString(n, read), JTermios.toString(n, write), JTermios.toString(n, error), timeout);
        int ret = m_Termios.select(n, read, write, error, timeout);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< select(%d,%s,%s,%s,%s) => %d\n", n, JTermios.toString(n, read), JTermios.toString(n, write), JTermios.toString(n, error), timeout, ret);
        return ret;
    }

    public static int poll(Pollfd[] fds, int nfds, int timeout) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> poll(%s,%d,%d)\n", JTermiosLogging.log(fds, 8), nfds, timeout);
        int ret = m_Termios.poll(fds, nfds, timeout);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< poll(%s,%d,%d) => %d\n", JTermiosLogging.log(fds, 8), nfds, timeout, ret);
        return ret;
    }

    public static int poll(int[] fds, int nfds, int timeout) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> poll(%s,%d,%d)\n", JTermiosLogging.log(fds, 8), nfds, timeout);
        int ret = m_Termios.poll(fds, nfds, timeout);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< poll(%s,%d,%d) => %d\n", JTermiosLogging.log(fds, 8), nfds, timeout, ret);
        return ret;
    }

    public static int pipe(int[] fds) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> pipe([%d,%d,%d])\n", fds.length, fds[0], fds[1]);
        int ret = m_Termios.pipe(fds);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< pipe([%d,%d,%d]) => %d\n", fds.length, fds[0], fds[1], ret);
        return ret;
    }

    public static void perror(String msg) {
        m_Termios.perror(msg);
    }

    public static FDSet newFDSet() {
        return m_Termios.newFDSet();
    }

    public static void FD_SET(int fd, FDSet set) {
        m_Termios.FD_SET(fd, set);
    }

    public static void FD_CLR(int fd, FDSet set) {
        m_Termios.FD_CLR(fd, set);
    }

    public static boolean FD_ISSET(int fd, FDSet set) {
        return m_Termios.FD_ISSET(fd, set);
    }

    public static void FD_ZERO(FDSet set) {
        m_Termios.FD_ZERO(set);
    }

    public static List<String> getPortList() {
        return m_Termios.getPortList();
    }

    public static Pattern getPortNamePattern(JTermiosInterface jtermios) {
        String ps = System.getProperty("purejavacomm.portnamepattern." + jtermios.getClass().getName());
        if (ps == null) {
            ps = System.getProperty("purejavacomm.portnamepattern");
        }
        if (ps == null) {
            ps = jtermios.getPortNamePattern();
        }
        return Pattern.compile(ps);
    }

    static {
        if (Platform.isMac()) {
            m_Termios = new JTermiosImpl();
        } else if (Platform.isWindows()) {
            m_Termios = new jtermios.windows.JTermiosImpl();
        } else if (Platform.isLinux()) {
            m_Termios = new jtermios.linux.JTermiosImpl();
        } else if (Platform.isSolaris()) {
            m_Termios = new jtermios.solaris.JTermiosImpl();
        } else if (Platform.isFreeBSD()) {
            m_Termios = new jtermios.freebsd.JTermiosImpl();
        } else {
            JTermiosLogging.log(0, "JTermios has no support for OS %s\n", System.getProperty("os.name"));
        }
    }

    public static class JTermiosLogging {
        private static int LOG_MASK = 0;
        public static boolean log = false;
        private static StringBuffer buffer;

        public static String lineno() {
            return JTermiosLogging.lineno(0);
        }

        public static String lineno(int n) {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2 + n];
            return String.format("class %s line% d", e.getClassName(), e.getLineNumber());
        }

        public static String ref(Structure struct) {
            if (struct == null) {
                return "null";
            }
            return struct.getPointer().toString();
        }

        public static String log(byte[] bts, int n) {
            StringBuffer b = new StringBuffer();
            if (n < 0 || n > bts.length) {
                n = bts.length;
            }
            b.append(String.format("[%d", bts.length));
            for (int i = 0; i < n; ++i) {
                b.append(String.format(",0x%02X", bts[i]));
            }
            if (n < bts.length) {
                b.append("...");
            }
            b.append("]");
            return b.toString();
        }

        public static String log(int[] ints, int n) {
            StringBuffer b = new StringBuffer();
            if (n < 0 || n > ints.length) {
                n = ints.length;
            }
            b.append(String.format("[%d", ints.length));
            for (int i = 0; i < n; ++i) {
                b.append(String.format(",0x%08X", ints[i]));
            }
            if (n < ints.length) {
                b.append("...");
            }
            b.append("]");
            return b.toString();
        }

        public static String log(char[] bts, int n) {
            StringBuffer b = new StringBuffer();
            if (n < 0 || n > bts.length) {
                n = bts.length;
            }
            b.append(String.format("[%d", bts.length));
            for (int i = 0; i < n; ++i) {
                b.append(String.format(",%c", Character.valueOf(bts[i])));
            }
            if (n < bts.length) {
                b.append("...");
            }
            b.append("]");
            return b.toString();
        }

        public static String log(Object[] bts, int n) {
            StringBuffer b = new StringBuffer();
            if (n < 0 || n > bts.length) {
                n = bts.length;
            }
            b.append(String.format("[%d", bts.length));
            for (int i = 0; i < n; ++i) {
                b.append(",");
                b.append(bts[i] != null ? bts[i].toString() : "null");
            }
            if (n < bts.length) {
                b.append("...");
            }
            b.append("]");
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean log(int l, String format, Object ... args) {
            if (l == 0 || LOG_MASK != 0) {
                StringBuffer stringBuffer = buffer;
                synchronized (stringBuffer) {
                    buffer.setLength(0);
                    if ((LOG_MASK & 0x20) != 0) {
                        buffer.append(String.format("%06d,", System.currentTimeMillis() % 1000000L));
                    }
                    if ((LOG_MASK & 0x40) != 0) {
                        buffer.append(JTermiosLogging.lineno(2));
                        buffer.append(", ");
                    }
                    if ((LOG_MASK & 0x80) != 0) {
                        buffer.append("thread id ");
                        buffer.append(Thread.currentThread().getId());
                        buffer.append(", ");
                        buffer.append(Thread.currentThread().getName());
                        buffer.append(", ");
                    }
                    if (l == 0 || (LOG_MASK & 1 << l - 1) != 0) {
                        buffer.append(String.format(format, args));
                    }
                    if (buffer.length() > 0) {
                        System.err.printf("log: " + buffer.toString(), new Object[0]);
                    }
                }
            }
            return true;
        }

        public static void setLogLevel(int l) {
            LOG_MASK = 0;
            for (int i = 0; i < l; ++i) {
                LOG_MASK = (LOG_MASK << 1) + 1;
            }
            log = LOG_MASK != 0;
        }

        public static void setLogMask(int mask) {
            LOG_MASK = mask;
            log = LOG_MASK != 0;
        }

        static {
            String loglevel = System.getProperty("purejavacomm.loglevel");
            if (loglevel != null) {
                JTermiosLogging.setLogLevel(Integer.parseInt(loglevel));
            }
            buffer = new StringBuffer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JTermiosInterface {
        public int pipe(int[] var1);

        public void shutDown();

        public int errno();

        public int fcntl(int var1, int var2, int var3);

        public int setspeed(int var1, Termios var2, int var3);

        public int cfgetispeed(Termios var1);

        public int cfgetospeed(Termios var1);

        public int cfsetispeed(Termios var1, int var2);

        public int cfsetospeed(Termios var1, int var2);

        public int tcflush(int var1, int var2);

        public int tcdrain(int var1);

        public void cfmakeraw(Termios var1);

        public int tcgetattr(int var1, Termios var2);

        public int tcsetattr(int var1, int var2, Termios var3);

        public int tcsendbreak(int var1, int var2);

        public int open(String var1, int var2);

        public int close(int var1);

        public int write(int var1, byte[] var2, int var3);

        public int read(int var1, byte[] var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int select(int var1, FDSet var2, FDSet var3, FDSet var4, TimeVal var5);

        public int poll(Pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public void perror(String var1);

        public FDSet newFDSet();

        public void FD_SET(int var1, FDSet var2);

        public void FD_CLR(int var1, FDSet var2);

        public boolean FD_ISSET(int var1, FDSet var2);

        public void FD_ZERO(FDSet var1);

        public List<String> getPortList();

        public String getPortNamePattern();
    }
}

