// Code generated by capnpc-go. DO NOT EDIT.

package proto

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	server "capnproto.org/go/capnp/v3/server"
	context "context"
)

type Conmon capnp.Client

// Conmon_TypeID is the unique identifier for the type Conmon.
const Conmon_TypeID = 0xb737e899dd6633f1

func (c Conmon) Version(ctx context.Context, params func(Conmon_version_Params) error) (Conmon_version_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_version_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_version_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) CreateContainer(ctx context.Context, params func(Conmon_createContainer_Params) error) (Conmon_createContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_createContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_createContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ExecSyncContainer(ctx context.Context, params func(Conmon_execSyncContainer_Params) error) (Conmon_execSyncContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_execSyncContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_execSyncContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) AttachContainer(ctx context.Context, params func(Conmon_attachContainer_Params) error) (Conmon_attachContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_attachContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_attachContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ReopenLogContainer(ctx context.Context, params func(Conmon_reopenLogContainer_Params) error) (Conmon_reopenLogContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_reopenLogContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_reopenLogContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) SetWindowSizeContainer(ctx context.Context, params func(Conmon_setWindowSizeContainer_Params) error) (Conmon_setWindowSizeContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_setWindowSizeContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_setWindowSizeContainer_Results_Future{Future: ans.Future()}, release
}

func (c Conmon) AddRef() Conmon {
	return Conmon(capnp.Client(c).AddRef())
}

func (c Conmon) Release() {
	capnp.Client(c).Release()
}

func (c Conmon) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Client(c).EncodeAsPtr(seg)
}

func (Conmon) DecodeFromPtr(p capnp.Ptr) Conmon {
	return Conmon(capnp.Client{}.DecodeFromPtr(p))
}

func (c Conmon) IsValid() bool {
	return capnp.Client(c).IsValid()
}

// A Conmon_Server is a Conmon with a local implementation.
type Conmon_Server interface {
	Version(context.Context, Conmon_version) error

	CreateContainer(context.Context, Conmon_createContainer) error

	ExecSyncContainer(context.Context, Conmon_execSyncContainer) error

	AttachContainer(context.Context, Conmon_attachContainer) error

	ReopenLogContainer(context.Context, Conmon_reopenLogContainer) error

	SetWindowSizeContainer(context.Context, Conmon_setWindowSizeContainer) error
}

// Conmon_NewServer creates a new Server from an implementation of Conmon_Server.
func Conmon_NewServer(s Conmon_Server) *server.Server {
	c, _ := s.(server.Shutdowner)
	return server.New(Conmon_Methods(nil, s), s, c)
}

// Conmon_ServerToClient creates a new Client from an implementation of Conmon_Server.
// The caller is responsible for calling Release on the returned Client.
func Conmon_ServerToClient(s Conmon_Server) Conmon {
	return Conmon(capnp.NewClient(Conmon_NewServer(s)))
}

// Conmon_Methods appends Methods to a slice that invoke the methods on s.
// This can be used to create a more complicated Server.
func Conmon_Methods(methods []server.Method, s Conmon_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 6)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.Version(ctx, Conmon_version{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.CreateContainer(ctx, Conmon_createContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ExecSyncContainer(ctx, Conmon_execSyncContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.AttachContainer(ctx, Conmon_attachContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ReopenLogContainer(ctx, Conmon_reopenLogContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.SetWindowSizeContainer(ctx, Conmon_setWindowSizeContainer{call})
		},
	})

	return methods
}

// Conmon_version holds the state for a server call to Conmon.version.
// See server.Call for documentation.
type Conmon_version struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_version) Args() Conmon_version_Params {
	return Conmon_version_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_version) AllocResults() (Conmon_version_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(r), err
}

// Conmon_createContainer holds the state for a server call to Conmon.createContainer.
// See server.Call for documentation.
type Conmon_createContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_createContainer) Args() Conmon_createContainer_Params {
	return Conmon_createContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_createContainer) AllocResults() (Conmon_createContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(r), err
}

// Conmon_execSyncContainer holds the state for a server call to Conmon.execSyncContainer.
// See server.Call for documentation.
type Conmon_execSyncContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_execSyncContainer) Args() Conmon_execSyncContainer_Params {
	return Conmon_execSyncContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_execSyncContainer) AllocResults() (Conmon_execSyncContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(r), err
}

// Conmon_attachContainer holds the state for a server call to Conmon.attachContainer.
// See server.Call for documentation.
type Conmon_attachContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_attachContainer) Args() Conmon_attachContainer_Params {
	return Conmon_attachContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_attachContainer) AllocResults() (Conmon_attachContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(r), err
}

// Conmon_reopenLogContainer holds the state for a server call to Conmon.reopenLogContainer.
// See server.Call for documentation.
type Conmon_reopenLogContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_reopenLogContainer) Args() Conmon_reopenLogContainer_Params {
	return Conmon_reopenLogContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_reopenLogContainer) AllocResults() (Conmon_reopenLogContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(r), err
}

// Conmon_setWindowSizeContainer holds the state for a server call to Conmon.setWindowSizeContainer.
// See server.Call for documentation.
type Conmon_setWindowSizeContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_setWindowSizeContainer) Args() Conmon_setWindowSizeContainer_Params {
	return Conmon_setWindowSizeContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_setWindowSizeContainer) AllocResults() (Conmon_setWindowSizeContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(r), err
}

// Conmon_List is a list of Conmon.
type Conmon_List = capnp.CapList[Conmon]

// NewConmon creates a new list of Conmon.
func NewConmon_List(s *capnp.Segment, sz int32) (Conmon_List, error) {
	l, err := capnp.NewPointerList(s, sz)
	return capnp.CapList[Conmon](l), err
}

type Conmon_VersionResponse capnp.Struct

// Conmon_VersionResponse_TypeID is the unique identifier for the type Conmon_VersionResponse.
const Conmon_VersionResponse_TypeID = 0xf34be5cbac1feed1

func NewConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_VersionResponse(st), err
}

func NewRootConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_VersionResponse(st), err
}

func ReadRootConmon_VersionResponse(msg *capnp.Message) (Conmon_VersionResponse, error) {
	root, err := msg.Root()
	return Conmon_VersionResponse(root.Struct()), err
}

func (s Conmon_VersionResponse) String() string {
	str, _ := text.Marshal(0xf34be5cbac1feed1, capnp.Struct(s))
	return str
}

func (s Conmon_VersionResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_VersionResponse) DecodeFromPtr(p capnp.Ptr) Conmon_VersionResponse {
	return Conmon_VersionResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_VersionResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_VersionResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_VersionResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_VersionResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_VersionResponse) Version() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasVersion() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_VersionResponse) VersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetVersion(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_VersionResponse) Tag() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasTag() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_VersionResponse) TagBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetTag(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_VersionResponse) Commit() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasCommit() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_VersionResponse) CommitBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetCommit(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

func (s Conmon_VersionResponse) BuildDate() (string, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasBuildDate() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_VersionResponse) BuildDateBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetBuildDate(v string) error {
	return capnp.Struct(s).SetText(3, v)
}

func (s Conmon_VersionResponse) RustVersion() (string, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasRustVersion() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Conmon_VersionResponse) RustVersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetRustVersion(v string) error {
	return capnp.Struct(s).SetText(4, v)
}

func (s Conmon_VersionResponse) ProcessId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Conmon_VersionResponse) SetProcessId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// Conmon_VersionResponse_List is a list of Conmon_VersionResponse.
type Conmon_VersionResponse_List = capnp.StructList[Conmon_VersionResponse]

// NewConmon_VersionResponse creates a new list of Conmon_VersionResponse.
func NewConmon_VersionResponse_List(s *capnp.Segment, sz int32) (Conmon_VersionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5}, sz)
	return capnp.StructList[Conmon_VersionResponse](l), err
}

// Conmon_VersionResponse_Future is a wrapper for a Conmon_VersionResponse promised by a client call.
type Conmon_VersionResponse_Future struct{ *capnp.Future }

func (p Conmon_VersionResponse_Future) Struct() (Conmon_VersionResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_VersionResponse(s), err
}

type Conmon_CreateContainerRequest capnp.Struct

// Conmon_CreateContainerRequest_TypeID is the unique identifier for the type Conmon_CreateContainerRequest.
const Conmon_CreateContainerRequest_TypeID = 0xba77e3fa3aa9b6ca

func NewConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 8})
	return Conmon_CreateContainerRequest(st), err
}

func NewRootConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 8})
	return Conmon_CreateContainerRequest(st), err
}

func ReadRootConmon_CreateContainerRequest(msg *capnp.Message) (Conmon_CreateContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerRequest(root.Struct()), err
}

func (s Conmon_CreateContainerRequest) String() string {
	str, _ := text.Marshal(0xba77e3fa3aa9b6ca, capnp.Struct(s))
	return str
}

func (s Conmon_CreateContainerRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateContainerRequest) DecodeFromPtr(p capnp.Ptr) Conmon_CreateContainerRequest {
	return Conmon_CreateContainerRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateContainerRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateContainerRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateContainerRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateContainerRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateContainerRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_CreateContainerRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_CreateContainerRequest) BundlePath() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasBundlePath() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_CreateContainerRequest) BundlePathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetBundlePath(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_CreateContainerRequest) Terminal() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Conmon_CreateContainerRequest) SetTerminal(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Conmon_CreateContainerRequest) ExitPaths() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasExitPaths() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_CreateContainerRequest) SetExitPaths(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(2, v.ToPtr())
}

// NewExitPaths sets the exitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(2, l.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) OomExitPaths() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasOomExitPaths() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_CreateContainerRequest) SetOomExitPaths(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewOomExitPaths sets the oomExitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewOomExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) LogDrivers() (Conmon_LogDriver_List, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return Conmon_LogDriver_List(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasLogDrivers() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Conmon_CreateContainerRequest) SetLogDrivers(v Conmon_LogDriver_List) error {
	return capnp.Struct(s).SetPtr(4, v.ToPtr())
}

// NewLogDrivers sets the logDrivers field to a newly
// allocated Conmon_LogDriver_List, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewLogDrivers(n int32) (Conmon_LogDriver_List, error) {
	l, err := NewConmon_LogDriver_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Conmon_LogDriver_List{}, err
	}
	err = capnp.Struct(s).SetPtr(4, l.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) CleanupCmd() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasCleanupCmd() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s Conmon_CreateContainerRequest) SetCleanupCmd(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(5, v.ToPtr())
}

// NewCleanupCmd sets the cleanupCmd field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewCleanupCmd(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(5, l.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) GlobalArgs() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasGlobalArgs() bool {
	return capnp.Struct(s).HasPtr(6)
}

func (s Conmon_CreateContainerRequest) SetGlobalArgs(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(6, v.ToPtr())
}

// NewGlobalArgs sets the globalArgs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewGlobalArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(6, l.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) CommandArgs() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(7)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasCommandArgs() bool {
	return capnp.Struct(s).HasPtr(7)
}

func (s Conmon_CreateContainerRequest) SetCommandArgs(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(7, v.ToPtr())
}

// NewCommandArgs sets the commandArgs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewCommandArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(7, l.ToPtr())
	return l, err
}

// Conmon_CreateContainerRequest_List is a list of Conmon_CreateContainerRequest.
type Conmon_CreateContainerRequest_List = capnp.StructList[Conmon_CreateContainerRequest]

// NewConmon_CreateContainerRequest creates a new list of Conmon_CreateContainerRequest.
func NewConmon_CreateContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 8}, sz)
	return capnp.StructList[Conmon_CreateContainerRequest](l), err
}

// Conmon_CreateContainerRequest_Future is a wrapper for a Conmon_CreateContainerRequest promised by a client call.
type Conmon_CreateContainerRequest_Future struct{ *capnp.Future }

func (p Conmon_CreateContainerRequest_Future) Struct() (Conmon_CreateContainerRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_CreateContainerRequest(s), err
}

type Conmon_LogDriver capnp.Struct

// Conmon_LogDriver_TypeID is the unique identifier for the type Conmon_LogDriver.
const Conmon_LogDriver_TypeID = 0xae78ee8eb6b3a134

func NewConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Conmon_LogDriver(st), err
}

func NewRootConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Conmon_LogDriver(st), err
}

func ReadRootConmon_LogDriver(msg *capnp.Message) (Conmon_LogDriver, error) {
	root, err := msg.Root()
	return Conmon_LogDriver(root.Struct()), err
}

func (s Conmon_LogDriver) String() string {
	str, _ := text.Marshal(0xae78ee8eb6b3a134, capnp.Struct(s))
	return str
}

func (s Conmon_LogDriver) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_LogDriver) DecodeFromPtr(p capnp.Ptr) Conmon_LogDriver {
	return Conmon_LogDriver(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_LogDriver) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_LogDriver) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_LogDriver) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_LogDriver) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_LogDriver) Type() Conmon_LogDriver_Type {
	return Conmon_LogDriver_Type(capnp.Struct(s).Uint16(0))
}

func (s Conmon_LogDriver) SetType(v Conmon_LogDriver_Type) {
	capnp.Struct(s).SetUint16(0, uint16(v))
}

func (s Conmon_LogDriver) Path() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_LogDriver) HasPath() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_LogDriver) PathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_LogDriver) SetPath(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_LogDriver) MaxSize() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Conmon_LogDriver) SetMaxSize(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

// Conmon_LogDriver_List is a list of Conmon_LogDriver.
type Conmon_LogDriver_List = capnp.StructList[Conmon_LogDriver]

// NewConmon_LogDriver creates a new list of Conmon_LogDriver.
func NewConmon_LogDriver_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_LogDriver](l), err
}

// Conmon_LogDriver_Future is a wrapper for a Conmon_LogDriver promised by a client call.
type Conmon_LogDriver_Future struct{ *capnp.Future }

func (p Conmon_LogDriver_Future) Struct() (Conmon_LogDriver, error) {
	s, err := p.Future.Struct()
	return Conmon_LogDriver(s), err
}

type Conmon_LogDriver_Type uint16

// Conmon_LogDriver_Type_TypeID is the unique identifier for the type Conmon_LogDriver_Type.
const Conmon_LogDriver_Type_TypeID = 0xf026e3d750335bc1

// Values of Conmon_LogDriver_Type.
const (
	Conmon_LogDriver_Type_containerRuntimeInterface Conmon_LogDriver_Type = 0
)

// String returns the enum's constant name.
func (c Conmon_LogDriver_Type) String() string {
	switch c {
	case Conmon_LogDriver_Type_containerRuntimeInterface:
		return "containerRuntimeInterface"

	default:
		return ""
	}
}

// Conmon_LogDriver_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Conmon_LogDriver_TypeFromString(c string) Conmon_LogDriver_Type {
	switch c {
	case "containerRuntimeInterface":
		return Conmon_LogDriver_Type_containerRuntimeInterface

	default:
		return 0
	}
}

type Conmon_LogDriver_Type_List = capnp.EnumList[Conmon_LogDriver_Type]

func NewConmon_LogDriver_Type_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_Type_List, error) {
	return capnp.NewEnumList[Conmon_LogDriver_Type](s, sz)
}

type Conmon_CreateContainerResponse capnp.Struct

// Conmon_CreateContainerResponse_TypeID is the unique identifier for the type Conmon_CreateContainerResponse.
const Conmon_CreateContainerResponse_TypeID = 0xde3a625e70772b9a

func NewConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse(st), err
}

func NewRootConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse(st), err
}

func ReadRootConmon_CreateContainerResponse(msg *capnp.Message) (Conmon_CreateContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerResponse(root.Struct()), err
}

func (s Conmon_CreateContainerResponse) String() string {
	str, _ := text.Marshal(0xde3a625e70772b9a, capnp.Struct(s))
	return str
}

func (s Conmon_CreateContainerResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateContainerResponse) DecodeFromPtr(p capnp.Ptr) Conmon_CreateContainerResponse {
	return Conmon_CreateContainerResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateContainerResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateContainerResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateContainerResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateContainerResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateContainerResponse) ContainerPid() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Conmon_CreateContainerResponse) SetContainerPid(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// Conmon_CreateContainerResponse_List is a list of Conmon_CreateContainerResponse.
type Conmon_CreateContainerResponse_List = capnp.StructList[Conmon_CreateContainerResponse]

// NewConmon_CreateContainerResponse creates a new list of Conmon_CreateContainerResponse.
func NewConmon_CreateContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_CreateContainerResponse](l), err
}

// Conmon_CreateContainerResponse_Future is a wrapper for a Conmon_CreateContainerResponse promised by a client call.
type Conmon_CreateContainerResponse_Future struct{ *capnp.Future }

func (p Conmon_CreateContainerResponse_Future) Struct() (Conmon_CreateContainerResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_CreateContainerResponse(s), err
}

type Conmon_ExecSyncContainerRequest capnp.Struct

// Conmon_ExecSyncContainerRequest_TypeID is the unique identifier for the type Conmon_ExecSyncContainerRequest.
const Conmon_ExecSyncContainerRequest_TypeID = 0xf41122f890a371a6

func NewConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Conmon_ExecSyncContainerRequest(st), err
}

func NewRootConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Conmon_ExecSyncContainerRequest(st), err
}

func ReadRootConmon_ExecSyncContainerRequest(msg *capnp.Message) (Conmon_ExecSyncContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerRequest(root.Struct()), err
}

func (s Conmon_ExecSyncContainerRequest) String() string {
	str, _ := text.Marshal(0xf41122f890a371a6, capnp.Struct(s))
	return str
}

func (s Conmon_ExecSyncContainerRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ExecSyncContainerRequest) DecodeFromPtr(p capnp.Ptr) Conmon_ExecSyncContainerRequest {
	return Conmon_ExecSyncContainerRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ExecSyncContainerRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ExecSyncContainerRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ExecSyncContainerRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ExecSyncContainerRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ExecSyncContainerRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_ExecSyncContainerRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ExecSyncContainerRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ExecSyncContainerRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_ExecSyncContainerRequest) TimeoutSec() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Conmon_ExecSyncContainerRequest) SetTimeoutSec(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Conmon_ExecSyncContainerRequest) Command() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return capnp.TextList(p.List()), err
}

func (s Conmon_ExecSyncContainerRequest) HasCommand() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_ExecSyncContainerRequest) SetCommand(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewCommand sets the command field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_ExecSyncContainerRequest) NewCommand(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

func (s Conmon_ExecSyncContainerRequest) Terminal() bool {
	return capnp.Struct(s).Bit(64)
}

func (s Conmon_ExecSyncContainerRequest) SetTerminal(v bool) {
	capnp.Struct(s).SetBit(64, v)
}

// Conmon_ExecSyncContainerRequest_List is a list of Conmon_ExecSyncContainerRequest.
type Conmon_ExecSyncContainerRequest_List = capnp.StructList[Conmon_ExecSyncContainerRequest]

// NewConmon_ExecSyncContainerRequest creates a new list of Conmon_ExecSyncContainerRequest.
func NewConmon_ExecSyncContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerRequest](l), err
}

// Conmon_ExecSyncContainerRequest_Future is a wrapper for a Conmon_ExecSyncContainerRequest promised by a client call.
type Conmon_ExecSyncContainerRequest_Future struct{ *capnp.Future }

func (p Conmon_ExecSyncContainerRequest_Future) Struct() (Conmon_ExecSyncContainerRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_ExecSyncContainerRequest(s), err
}

type Conmon_ExecSyncContainerResponse capnp.Struct

// Conmon_ExecSyncContainerResponse_TypeID is the unique identifier for the type Conmon_ExecSyncContainerResponse.
const Conmon_ExecSyncContainerResponse_TypeID = 0xd9d61d1d803c85fc

func NewConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse(st), err
}

func NewRootConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse(st), err
}

func ReadRootConmon_ExecSyncContainerResponse(msg *capnp.Message) (Conmon_ExecSyncContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerResponse(root.Struct()), err
}

func (s Conmon_ExecSyncContainerResponse) String() string {
	str, _ := text.Marshal(0xd9d61d1d803c85fc, capnp.Struct(s))
	return str
}

func (s Conmon_ExecSyncContainerResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ExecSyncContainerResponse) DecodeFromPtr(p capnp.Ptr) Conmon_ExecSyncContainerResponse {
	return Conmon_ExecSyncContainerResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ExecSyncContainerResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ExecSyncContainerResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ExecSyncContainerResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ExecSyncContainerResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ExecSyncContainerResponse) ExitCode() int32 {
	return int32(capnp.Struct(s).Uint32(0))
}

func (s Conmon_ExecSyncContainerResponse) SetExitCode(v int32) {
	capnp.Struct(s).SetUint32(0, uint32(v))
}

func (s Conmon_ExecSyncContainerResponse) Stdout() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStdout() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ExecSyncContainerResponse) SetStdout(v []byte) error {
	return capnp.Struct(s).SetData(0, v)
}

func (s Conmon_ExecSyncContainerResponse) Stderr() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStderr() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_ExecSyncContainerResponse) SetStderr(v []byte) error {
	return capnp.Struct(s).SetData(1, v)
}

func (s Conmon_ExecSyncContainerResponse) TimedOut() bool {
	return capnp.Struct(s).Bit(32)
}

func (s Conmon_ExecSyncContainerResponse) SetTimedOut(v bool) {
	capnp.Struct(s).SetBit(32, v)
}

// Conmon_ExecSyncContainerResponse_List is a list of Conmon_ExecSyncContainerResponse.
type Conmon_ExecSyncContainerResponse_List = capnp.StructList[Conmon_ExecSyncContainerResponse]

// NewConmon_ExecSyncContainerResponse creates a new list of Conmon_ExecSyncContainerResponse.
func NewConmon_ExecSyncContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerResponse](l), err
}

// Conmon_ExecSyncContainerResponse_Future is a wrapper for a Conmon_ExecSyncContainerResponse promised by a client call.
type Conmon_ExecSyncContainerResponse_Future struct{ *capnp.Future }

func (p Conmon_ExecSyncContainerResponse_Future) Struct() (Conmon_ExecSyncContainerResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_ExecSyncContainerResponse(s), err
}

type Conmon_AttachRequest capnp.Struct

// Conmon_AttachRequest_TypeID is the unique identifier for the type Conmon_AttachRequest.
const Conmon_AttachRequest_TypeID = 0xdf703ca0befc3afc

func NewConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Conmon_AttachRequest(st), err
}

func NewRootConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Conmon_AttachRequest(st), err
}

func ReadRootConmon_AttachRequest(msg *capnp.Message) (Conmon_AttachRequest, error) {
	root, err := msg.Root()
	return Conmon_AttachRequest(root.Struct()), err
}

func (s Conmon_AttachRequest) String() string {
	str, _ := text.Marshal(0xdf703ca0befc3afc, capnp.Struct(s))
	return str
}

func (s Conmon_AttachRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_AttachRequest) DecodeFromPtr(p capnp.Ptr) Conmon_AttachRequest {
	return Conmon_AttachRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_AttachRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_AttachRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_AttachRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_AttachRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_AttachRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_AttachRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_AttachRequest) SocketPath() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasSocketPath() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_AttachRequest) SocketPathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetSocketPath(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_AttachRequest) ExecSessionId() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasExecSessionId() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_AttachRequest) ExecSessionIdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetExecSessionId(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

// Conmon_AttachRequest_List is a list of Conmon_AttachRequest.
type Conmon_AttachRequest_List = capnp.StructList[Conmon_AttachRequest]

// NewConmon_AttachRequest creates a new list of Conmon_AttachRequest.
func NewConmon_AttachRequest_List(s *capnp.Segment, sz int32) (Conmon_AttachRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return capnp.StructList[Conmon_AttachRequest](l), err
}

// Conmon_AttachRequest_Future is a wrapper for a Conmon_AttachRequest promised by a client call.
type Conmon_AttachRequest_Future struct{ *capnp.Future }

func (p Conmon_AttachRequest_Future) Struct() (Conmon_AttachRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_AttachRequest(s), err
}

type Conmon_AttachResponse capnp.Struct

// Conmon_AttachResponse_TypeID is the unique identifier for the type Conmon_AttachResponse.
const Conmon_AttachResponse_TypeID = 0xace5517aafc86077

func NewConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse(st), err
}

func NewRootConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse(st), err
}

func ReadRootConmon_AttachResponse(msg *capnp.Message) (Conmon_AttachResponse, error) {
	root, err := msg.Root()
	return Conmon_AttachResponse(root.Struct()), err
}

func (s Conmon_AttachResponse) String() string {
	str, _ := text.Marshal(0xace5517aafc86077, capnp.Struct(s))
	return str
}

func (s Conmon_AttachResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_AttachResponse) DecodeFromPtr(p capnp.Ptr) Conmon_AttachResponse {
	return Conmon_AttachResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_AttachResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_AttachResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_AttachResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_AttachResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_AttachResponse_List is a list of Conmon_AttachResponse.
type Conmon_AttachResponse_List = capnp.StructList[Conmon_AttachResponse]

// NewConmon_AttachResponse creates a new list of Conmon_AttachResponse.
func NewConmon_AttachResponse_List(s *capnp.Segment, sz int32) (Conmon_AttachResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_AttachResponse](l), err
}

// Conmon_AttachResponse_Future is a wrapper for a Conmon_AttachResponse promised by a client call.
type Conmon_AttachResponse_Future struct{ *capnp.Future }

func (p Conmon_AttachResponse_Future) Struct() (Conmon_AttachResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_AttachResponse(s), err
}

type Conmon_ReopenLogRequest capnp.Struct

// Conmon_ReopenLogRequest_TypeID is the unique identifier for the type Conmon_ReopenLogRequest.
const Conmon_ReopenLogRequest_TypeID = 0xd0476e0f34d1411a

func NewConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_ReopenLogRequest(st), err
}

func NewRootConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_ReopenLogRequest(st), err
}

func ReadRootConmon_ReopenLogRequest(msg *capnp.Message) (Conmon_ReopenLogRequest, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogRequest(root.Struct()), err
}

func (s Conmon_ReopenLogRequest) String() string {
	str, _ := text.Marshal(0xd0476e0f34d1411a, capnp.Struct(s))
	return str
}

func (s Conmon_ReopenLogRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ReopenLogRequest) DecodeFromPtr(p capnp.Ptr) Conmon_ReopenLogRequest {
	return Conmon_ReopenLogRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ReopenLogRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ReopenLogRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ReopenLogRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ReopenLogRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ReopenLogRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_ReopenLogRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ReopenLogRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ReopenLogRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

// Conmon_ReopenLogRequest_List is a list of Conmon_ReopenLogRequest.
type Conmon_ReopenLogRequest_List = capnp.StructList[Conmon_ReopenLogRequest]

// NewConmon_ReopenLogRequest creates a new list of Conmon_ReopenLogRequest.
func NewConmon_ReopenLogRequest_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_ReopenLogRequest](l), err
}

// Conmon_ReopenLogRequest_Future is a wrapper for a Conmon_ReopenLogRequest promised by a client call.
type Conmon_ReopenLogRequest_Future struct{ *capnp.Future }

func (p Conmon_ReopenLogRequest_Future) Struct() (Conmon_ReopenLogRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_ReopenLogRequest(s), err
}

type Conmon_ReopenLogResponse capnp.Struct

// Conmon_ReopenLogResponse_TypeID is the unique identifier for the type Conmon_ReopenLogResponse.
const Conmon_ReopenLogResponse_TypeID = 0xa20f49456be85b99

func NewConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse(st), err
}

func NewRootConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse(st), err
}

func ReadRootConmon_ReopenLogResponse(msg *capnp.Message) (Conmon_ReopenLogResponse, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogResponse(root.Struct()), err
}

func (s Conmon_ReopenLogResponse) String() string {
	str, _ := text.Marshal(0xa20f49456be85b99, capnp.Struct(s))
	return str
}

func (s Conmon_ReopenLogResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ReopenLogResponse) DecodeFromPtr(p capnp.Ptr) Conmon_ReopenLogResponse {
	return Conmon_ReopenLogResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ReopenLogResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ReopenLogResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ReopenLogResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ReopenLogResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_ReopenLogResponse_List is a list of Conmon_ReopenLogResponse.
type Conmon_ReopenLogResponse_List = capnp.StructList[Conmon_ReopenLogResponse]

// NewConmon_ReopenLogResponse creates a new list of Conmon_ReopenLogResponse.
func NewConmon_ReopenLogResponse_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_ReopenLogResponse](l), err
}

// Conmon_ReopenLogResponse_Future is a wrapper for a Conmon_ReopenLogResponse promised by a client call.
type Conmon_ReopenLogResponse_Future struct{ *capnp.Future }

func (p Conmon_ReopenLogResponse_Future) Struct() (Conmon_ReopenLogResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_ReopenLogResponse(s), err
}

type Conmon_SetWindowSizeRequest capnp.Struct

// Conmon_SetWindowSizeRequest_TypeID is the unique identifier for the type Conmon_SetWindowSizeRequest.
const Conmon_SetWindowSizeRequest_TypeID = 0xb5418b8ea8ead17b

func NewConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_SetWindowSizeRequest(st), err
}

func NewRootConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_SetWindowSizeRequest(st), err
}

func ReadRootConmon_SetWindowSizeRequest(msg *capnp.Message) (Conmon_SetWindowSizeRequest, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeRequest(root.Struct()), err
}

func (s Conmon_SetWindowSizeRequest) String() string {
	str, _ := text.Marshal(0xb5418b8ea8ead17b, capnp.Struct(s))
	return str
}

func (s Conmon_SetWindowSizeRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_SetWindowSizeRequest) DecodeFromPtr(p capnp.Ptr) Conmon_SetWindowSizeRequest {
	return Conmon_SetWindowSizeRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_SetWindowSizeRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_SetWindowSizeRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_SetWindowSizeRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_SetWindowSizeRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_SetWindowSizeRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_SetWindowSizeRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_SetWindowSizeRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_SetWindowSizeRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_SetWindowSizeRequest) Width() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s Conmon_SetWindowSizeRequest) SetWidth(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s Conmon_SetWindowSizeRequest) Height() uint16 {
	return capnp.Struct(s).Uint16(2)
}

func (s Conmon_SetWindowSizeRequest) SetHeight(v uint16) {
	capnp.Struct(s).SetUint16(2, v)
}

// Conmon_SetWindowSizeRequest_List is a list of Conmon_SetWindowSizeRequest.
type Conmon_SetWindowSizeRequest_List = capnp.StructList[Conmon_SetWindowSizeRequest]

// NewConmon_SetWindowSizeRequest creates a new list of Conmon_SetWindowSizeRequest.
func NewConmon_SetWindowSizeRequest_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_SetWindowSizeRequest](l), err
}

// Conmon_SetWindowSizeRequest_Future is a wrapper for a Conmon_SetWindowSizeRequest promised by a client call.
type Conmon_SetWindowSizeRequest_Future struct{ *capnp.Future }

func (p Conmon_SetWindowSizeRequest_Future) Struct() (Conmon_SetWindowSizeRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_SetWindowSizeRequest(s), err
}

type Conmon_SetWindowSizeResponse capnp.Struct

// Conmon_SetWindowSizeResponse_TypeID is the unique identifier for the type Conmon_SetWindowSizeResponse.
const Conmon_SetWindowSizeResponse_TypeID = 0xf9b3cd8033aba1f8

func NewConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse(st), err
}

func NewRootConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse(st), err
}

func ReadRootConmon_SetWindowSizeResponse(msg *capnp.Message) (Conmon_SetWindowSizeResponse, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeResponse(root.Struct()), err
}

func (s Conmon_SetWindowSizeResponse) String() string {
	str, _ := text.Marshal(0xf9b3cd8033aba1f8, capnp.Struct(s))
	return str
}

func (s Conmon_SetWindowSizeResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_SetWindowSizeResponse) DecodeFromPtr(p capnp.Ptr) Conmon_SetWindowSizeResponse {
	return Conmon_SetWindowSizeResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_SetWindowSizeResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_SetWindowSizeResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_SetWindowSizeResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_SetWindowSizeResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_SetWindowSizeResponse_List is a list of Conmon_SetWindowSizeResponse.
type Conmon_SetWindowSizeResponse_List = capnp.StructList[Conmon_SetWindowSizeResponse]

// NewConmon_SetWindowSizeResponse creates a new list of Conmon_SetWindowSizeResponse.
func NewConmon_SetWindowSizeResponse_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_SetWindowSizeResponse](l), err
}

// Conmon_SetWindowSizeResponse_Future is a wrapper for a Conmon_SetWindowSizeResponse promised by a client call.
type Conmon_SetWindowSizeResponse_Future struct{ *capnp.Future }

func (p Conmon_SetWindowSizeResponse_Future) Struct() (Conmon_SetWindowSizeResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_SetWindowSizeResponse(s), err
}

type Conmon_version_Params capnp.Struct

// Conmon_version_Params_TypeID is the unique identifier for the type Conmon_version_Params.
const Conmon_version_Params_TypeID = 0xcc2f70676afee4e7

func NewConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_version_Params(st), err
}

func NewRootConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_version_Params(st), err
}

func ReadRootConmon_version_Params(msg *capnp.Message) (Conmon_version_Params, error) {
	root, err := msg.Root()
	return Conmon_version_Params(root.Struct()), err
}

func (s Conmon_version_Params) String() string {
	str, _ := text.Marshal(0xcc2f70676afee4e7, capnp.Struct(s))
	return str
}

func (s Conmon_version_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_version_Params) DecodeFromPtr(p capnp.Ptr) Conmon_version_Params {
	return Conmon_version_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_version_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_version_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_version_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_version_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_version_Params_List is a list of Conmon_version_Params.
type Conmon_version_Params_List = capnp.StructList[Conmon_version_Params]

// NewConmon_version_Params creates a new list of Conmon_version_Params.
func NewConmon_version_Params_List(s *capnp.Segment, sz int32) (Conmon_version_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_version_Params](l), err
}

// Conmon_version_Params_Future is a wrapper for a Conmon_version_Params promised by a client call.
type Conmon_version_Params_Future struct{ *capnp.Future }

func (p Conmon_version_Params_Future) Struct() (Conmon_version_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_version_Params(s), err
}

type Conmon_version_Results capnp.Struct

// Conmon_version_Results_TypeID is the unique identifier for the type Conmon_version_Results.
const Conmon_version_Results_TypeID = 0xe313695ea9477b30

func NewConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(st), err
}

func NewRootConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(st), err
}

func ReadRootConmon_version_Results(msg *capnp.Message) (Conmon_version_Results, error) {
	root, err := msg.Root()
	return Conmon_version_Results(root.Struct()), err
}

func (s Conmon_version_Results) String() string {
	str, _ := text.Marshal(0xe313695ea9477b30, capnp.Struct(s))
	return str
}

func (s Conmon_version_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_version_Results) DecodeFromPtr(p capnp.Ptr) Conmon_version_Results {
	return Conmon_version_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_version_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_version_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_version_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_version_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_version_Results) Response() (Conmon_VersionResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_VersionResponse(p.Struct()), err
}

func (s Conmon_version_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_version_Results) SetResponse(v Conmon_VersionResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_VersionResponse struct, preferring placement in s's segment.
func (s Conmon_version_Results) NewResponse() (Conmon_VersionResponse, error) {
	ss, err := NewConmon_VersionResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_VersionResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_version_Results_List is a list of Conmon_version_Results.
type Conmon_version_Results_List = capnp.StructList[Conmon_version_Results]

// NewConmon_version_Results creates a new list of Conmon_version_Results.
func NewConmon_version_Results_List(s *capnp.Segment, sz int32) (Conmon_version_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_version_Results](l), err
}

// Conmon_version_Results_Future is a wrapper for a Conmon_version_Results promised by a client call.
type Conmon_version_Results_Future struct{ *capnp.Future }

func (p Conmon_version_Results_Future) Struct() (Conmon_version_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_version_Results(s), err
}

func (p Conmon_version_Results_Future) Response() Conmon_VersionResponse_Future {
	return Conmon_VersionResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Params capnp.Struct

// Conmon_createContainer_Params_TypeID is the unique identifier for the type Conmon_createContainer_Params.
const Conmon_createContainer_Params_TypeID = 0xf44732c48f949ab8

func NewConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params(st), err
}

func NewRootConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params(st), err
}

func ReadRootConmon_createContainer_Params(msg *capnp.Message) (Conmon_createContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Params(root.Struct()), err
}

func (s Conmon_createContainer_Params) String() string {
	str, _ := text.Marshal(0xf44732c48f949ab8, capnp.Struct(s))
	return str
}

func (s Conmon_createContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_createContainer_Params {
	return Conmon_createContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createContainer_Params) Request() (Conmon_CreateContainerRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateContainerRequest(p.Struct()), err
}

func (s Conmon_createContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createContainer_Params) SetRequest(v Conmon_CreateContainerRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_CreateContainerRequest struct, preferring placement in s's segment.
func (s Conmon_createContainer_Params) NewRequest() (Conmon_CreateContainerRequest, error) {
	ss, err := NewConmon_CreateContainerRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateContainerRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createContainer_Params_List is a list of Conmon_createContainer_Params.
type Conmon_createContainer_Params_List = capnp.StructList[Conmon_createContainer_Params]

// NewConmon_createContainer_Params creates a new list of Conmon_createContainer_Params.
func NewConmon_createContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Params](l), err
}

// Conmon_createContainer_Params_Future is a wrapper for a Conmon_createContainer_Params promised by a client call.
type Conmon_createContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_createContainer_Params_Future) Struct() (Conmon_createContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_createContainer_Params(s), err
}

func (p Conmon_createContainer_Params_Future) Request() Conmon_CreateContainerRequest_Future {
	return Conmon_CreateContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Results capnp.Struct

// Conmon_createContainer_Results_TypeID is the unique identifier for the type Conmon_createContainer_Results.
const Conmon_createContainer_Results_TypeID = 0xceba3c1a97be15f8

func NewConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(st), err
}

func NewRootConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(st), err
}

func ReadRootConmon_createContainer_Results(msg *capnp.Message) (Conmon_createContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Results(root.Struct()), err
}

func (s Conmon_createContainer_Results) String() string {
	str, _ := text.Marshal(0xceba3c1a97be15f8, capnp.Struct(s))
	return str
}

func (s Conmon_createContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_createContainer_Results {
	return Conmon_createContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createContainer_Results) Response() (Conmon_CreateContainerResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateContainerResponse(p.Struct()), err
}

func (s Conmon_createContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createContainer_Results) SetResponse(v Conmon_CreateContainerResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_CreateContainerResponse struct, preferring placement in s's segment.
func (s Conmon_createContainer_Results) NewResponse() (Conmon_CreateContainerResponse, error) {
	ss, err := NewConmon_CreateContainerResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateContainerResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createContainer_Results_List is a list of Conmon_createContainer_Results.
type Conmon_createContainer_Results_List = capnp.StructList[Conmon_createContainer_Results]

// NewConmon_createContainer_Results creates a new list of Conmon_createContainer_Results.
func NewConmon_createContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Results](l), err
}

// Conmon_createContainer_Results_Future is a wrapper for a Conmon_createContainer_Results promised by a client call.
type Conmon_createContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_createContainer_Results_Future) Struct() (Conmon_createContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_createContainer_Results(s), err
}

func (p Conmon_createContainer_Results_Future) Response() Conmon_CreateContainerResponse_Future {
	return Conmon_CreateContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Params capnp.Struct

// Conmon_execSyncContainer_Params_TypeID is the unique identifier for the type Conmon_execSyncContainer_Params.
const Conmon_execSyncContainer_Params_TypeID = 0x83479da67279e173

func NewConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params(st), err
}

func NewRootConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params(st), err
}

func ReadRootConmon_execSyncContainer_Params(msg *capnp.Message) (Conmon_execSyncContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Params(root.Struct()), err
}

func (s Conmon_execSyncContainer_Params) String() string {
	str, _ := text.Marshal(0x83479da67279e173, capnp.Struct(s))
	return str
}

func (s Conmon_execSyncContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_execSyncContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_execSyncContainer_Params {
	return Conmon_execSyncContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_execSyncContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_execSyncContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_execSyncContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_execSyncContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_execSyncContainer_Params) Request() (Conmon_ExecSyncContainerRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ExecSyncContainerRequest(p.Struct()), err
}

func (s Conmon_execSyncContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_execSyncContainer_Params) SetRequest(v Conmon_ExecSyncContainerRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ExecSyncContainerRequest struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Params) NewRequest() (Conmon_ExecSyncContainerRequest, error) {
	ss, err := NewConmon_ExecSyncContainerRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ExecSyncContainerRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Params_List is a list of Conmon_execSyncContainer_Params.
type Conmon_execSyncContainer_Params_List = capnp.StructList[Conmon_execSyncContainer_Params]

// NewConmon_execSyncContainer_Params creates a new list of Conmon_execSyncContainer_Params.
func NewConmon_execSyncContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Params](l), err
}

// Conmon_execSyncContainer_Params_Future is a wrapper for a Conmon_execSyncContainer_Params promised by a client call.
type Conmon_execSyncContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_execSyncContainer_Params_Future) Struct() (Conmon_execSyncContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_execSyncContainer_Params(s), err
}

func (p Conmon_execSyncContainer_Params_Future) Request() Conmon_ExecSyncContainerRequest_Future {
	return Conmon_ExecSyncContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Results capnp.Struct

// Conmon_execSyncContainer_Results_TypeID is the unique identifier for the type Conmon_execSyncContainer_Results.
const Conmon_execSyncContainer_Results_TypeID = 0xf8e86a5c0baa01bc

func NewConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(st), err
}

func NewRootConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(st), err
}

func ReadRootConmon_execSyncContainer_Results(msg *capnp.Message) (Conmon_execSyncContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Results(root.Struct()), err
}

func (s Conmon_execSyncContainer_Results) String() string {
	str, _ := text.Marshal(0xf8e86a5c0baa01bc, capnp.Struct(s))
	return str
}

func (s Conmon_execSyncContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_execSyncContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_execSyncContainer_Results {
	return Conmon_execSyncContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_execSyncContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_execSyncContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_execSyncContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_execSyncContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_execSyncContainer_Results) Response() (Conmon_ExecSyncContainerResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ExecSyncContainerResponse(p.Struct()), err
}

func (s Conmon_execSyncContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_execSyncContainer_Results) SetResponse(v Conmon_ExecSyncContainerResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ExecSyncContainerResponse struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Results) NewResponse() (Conmon_ExecSyncContainerResponse, error) {
	ss, err := NewConmon_ExecSyncContainerResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ExecSyncContainerResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Results_List is a list of Conmon_execSyncContainer_Results.
type Conmon_execSyncContainer_Results_List = capnp.StructList[Conmon_execSyncContainer_Results]

// NewConmon_execSyncContainer_Results creates a new list of Conmon_execSyncContainer_Results.
func NewConmon_execSyncContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Results](l), err
}

// Conmon_execSyncContainer_Results_Future is a wrapper for a Conmon_execSyncContainer_Results promised by a client call.
type Conmon_execSyncContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_execSyncContainer_Results_Future) Struct() (Conmon_execSyncContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_execSyncContainer_Results(s), err
}

func (p Conmon_execSyncContainer_Results_Future) Response() Conmon_ExecSyncContainerResponse_Future {
	return Conmon_ExecSyncContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Params capnp.Struct

// Conmon_attachContainer_Params_TypeID is the unique identifier for the type Conmon_attachContainer_Params.
const Conmon_attachContainer_Params_TypeID = 0xaa2f3c8ad1c3af24

func NewConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params(st), err
}

func NewRootConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params(st), err
}

func ReadRootConmon_attachContainer_Params(msg *capnp.Message) (Conmon_attachContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Params(root.Struct()), err
}

func (s Conmon_attachContainer_Params) String() string {
	str, _ := text.Marshal(0xaa2f3c8ad1c3af24, capnp.Struct(s))
	return str
}

func (s Conmon_attachContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_attachContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_attachContainer_Params {
	return Conmon_attachContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_attachContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_attachContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_attachContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_attachContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_attachContainer_Params) Request() (Conmon_AttachRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_AttachRequest(p.Struct()), err
}

func (s Conmon_attachContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_attachContainer_Params) SetRequest(v Conmon_AttachRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_AttachRequest struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Params) NewRequest() (Conmon_AttachRequest, error) {
	ss, err := NewConmon_AttachRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_AttachRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_attachContainer_Params_List is a list of Conmon_attachContainer_Params.
type Conmon_attachContainer_Params_List = capnp.StructList[Conmon_attachContainer_Params]

// NewConmon_attachContainer_Params creates a new list of Conmon_attachContainer_Params.
func NewConmon_attachContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Params](l), err
}

// Conmon_attachContainer_Params_Future is a wrapper for a Conmon_attachContainer_Params promised by a client call.
type Conmon_attachContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_attachContainer_Params_Future) Struct() (Conmon_attachContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_attachContainer_Params(s), err
}

func (p Conmon_attachContainer_Params_Future) Request() Conmon_AttachRequest_Future {
	return Conmon_AttachRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Results capnp.Struct

// Conmon_attachContainer_Results_TypeID is the unique identifier for the type Conmon_attachContainer_Results.
const Conmon_attachContainer_Results_TypeID = 0xc5e65eec3dcf5b10

func NewConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(st), err
}

func NewRootConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(st), err
}

func ReadRootConmon_attachContainer_Results(msg *capnp.Message) (Conmon_attachContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Results(root.Struct()), err
}

func (s Conmon_attachContainer_Results) String() string {
	str, _ := text.Marshal(0xc5e65eec3dcf5b10, capnp.Struct(s))
	return str
}

func (s Conmon_attachContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_attachContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_attachContainer_Results {
	return Conmon_attachContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_attachContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_attachContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_attachContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_attachContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_attachContainer_Results) Response() (Conmon_AttachResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_AttachResponse(p.Struct()), err
}

func (s Conmon_attachContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_attachContainer_Results) SetResponse(v Conmon_AttachResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_AttachResponse struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Results) NewResponse() (Conmon_AttachResponse, error) {
	ss, err := NewConmon_AttachResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_AttachResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_attachContainer_Results_List is a list of Conmon_attachContainer_Results.
type Conmon_attachContainer_Results_List = capnp.StructList[Conmon_attachContainer_Results]

// NewConmon_attachContainer_Results creates a new list of Conmon_attachContainer_Results.
func NewConmon_attachContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Results](l), err
}

// Conmon_attachContainer_Results_Future is a wrapper for a Conmon_attachContainer_Results promised by a client call.
type Conmon_attachContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_attachContainer_Results_Future) Struct() (Conmon_attachContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_attachContainer_Results(s), err
}

func (p Conmon_attachContainer_Results_Future) Response() Conmon_AttachResponse_Future {
	return Conmon_AttachResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Params capnp.Struct

// Conmon_reopenLogContainer_Params_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Params.
const Conmon_reopenLogContainer_Params_TypeID = 0xe5ea916eb0c31336

func NewConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params(st), err
}

func NewRootConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params(st), err
}

func ReadRootConmon_reopenLogContainer_Params(msg *capnp.Message) (Conmon_reopenLogContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Params(root.Struct()), err
}

func (s Conmon_reopenLogContainer_Params) String() string {
	str, _ := text.Marshal(0xe5ea916eb0c31336, capnp.Struct(s))
	return str
}

func (s Conmon_reopenLogContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_reopenLogContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_reopenLogContainer_Params {
	return Conmon_reopenLogContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_reopenLogContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_reopenLogContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_reopenLogContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_reopenLogContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_reopenLogContainer_Params) Request() (Conmon_ReopenLogRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ReopenLogRequest(p.Struct()), err
}

func (s Conmon_reopenLogContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_reopenLogContainer_Params) SetRequest(v Conmon_ReopenLogRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ReopenLogRequest struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Params) NewRequest() (Conmon_ReopenLogRequest, error) {
	ss, err := NewConmon_ReopenLogRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ReopenLogRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Params_List is a list of Conmon_reopenLogContainer_Params.
type Conmon_reopenLogContainer_Params_List = capnp.StructList[Conmon_reopenLogContainer_Params]

// NewConmon_reopenLogContainer_Params creates a new list of Conmon_reopenLogContainer_Params.
func NewConmon_reopenLogContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Params](l), err
}

// Conmon_reopenLogContainer_Params_Future is a wrapper for a Conmon_reopenLogContainer_Params promised by a client call.
type Conmon_reopenLogContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_reopenLogContainer_Params_Future) Struct() (Conmon_reopenLogContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_reopenLogContainer_Params(s), err
}

func (p Conmon_reopenLogContainer_Params_Future) Request() Conmon_ReopenLogRequest_Future {
	return Conmon_ReopenLogRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Results capnp.Struct

// Conmon_reopenLogContainer_Results_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Results.
const Conmon_reopenLogContainer_Results_TypeID = 0xa0ef8355b64ee985

func NewConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(st), err
}

func NewRootConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(st), err
}

func ReadRootConmon_reopenLogContainer_Results(msg *capnp.Message) (Conmon_reopenLogContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Results(root.Struct()), err
}

func (s Conmon_reopenLogContainer_Results) String() string {
	str, _ := text.Marshal(0xa0ef8355b64ee985, capnp.Struct(s))
	return str
}

func (s Conmon_reopenLogContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_reopenLogContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_reopenLogContainer_Results {
	return Conmon_reopenLogContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_reopenLogContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_reopenLogContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_reopenLogContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_reopenLogContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_reopenLogContainer_Results) Response() (Conmon_ReopenLogResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ReopenLogResponse(p.Struct()), err
}

func (s Conmon_reopenLogContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_reopenLogContainer_Results) SetResponse(v Conmon_ReopenLogResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ReopenLogResponse struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Results) NewResponse() (Conmon_ReopenLogResponse, error) {
	ss, err := NewConmon_ReopenLogResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ReopenLogResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Results_List is a list of Conmon_reopenLogContainer_Results.
type Conmon_reopenLogContainer_Results_List = capnp.StructList[Conmon_reopenLogContainer_Results]

// NewConmon_reopenLogContainer_Results creates a new list of Conmon_reopenLogContainer_Results.
func NewConmon_reopenLogContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Results](l), err
}

// Conmon_reopenLogContainer_Results_Future is a wrapper for a Conmon_reopenLogContainer_Results promised by a client call.
type Conmon_reopenLogContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_reopenLogContainer_Results_Future) Struct() (Conmon_reopenLogContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_reopenLogContainer_Results(s), err
}

func (p Conmon_reopenLogContainer_Results_Future) Response() Conmon_ReopenLogResponse_Future {
	return Conmon_ReopenLogResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Params capnp.Struct

// Conmon_setWindowSizeContainer_Params_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Params.
const Conmon_setWindowSizeContainer_Params_TypeID = 0xc76ccd4502bb61e7

func NewConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params(st), err
}

func NewRootConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params(st), err
}

func ReadRootConmon_setWindowSizeContainer_Params(msg *capnp.Message) (Conmon_setWindowSizeContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Params(root.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Params) String() string {
	str, _ := text.Marshal(0xc76ccd4502bb61e7, capnp.Struct(s))
	return str
}

func (s Conmon_setWindowSizeContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_setWindowSizeContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_setWindowSizeContainer_Params {
	return Conmon_setWindowSizeContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_setWindowSizeContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_setWindowSizeContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_setWindowSizeContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_setWindowSizeContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_setWindowSizeContainer_Params) Request() (Conmon_SetWindowSizeRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_SetWindowSizeRequest(p.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Params) SetRequest(v Conmon_SetWindowSizeRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_SetWindowSizeRequest struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Params) NewRequest() (Conmon_SetWindowSizeRequest, error) {
	ss, err := NewConmon_SetWindowSizeRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_SetWindowSizeRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Params_List is a list of Conmon_setWindowSizeContainer_Params.
type Conmon_setWindowSizeContainer_Params_List = capnp.StructList[Conmon_setWindowSizeContainer_Params]

// NewConmon_setWindowSizeContainer_Params creates a new list of Conmon_setWindowSizeContainer_Params.
func NewConmon_setWindowSizeContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Params](l), err
}

// Conmon_setWindowSizeContainer_Params_Future is a wrapper for a Conmon_setWindowSizeContainer_Params promised by a client call.
type Conmon_setWindowSizeContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_setWindowSizeContainer_Params_Future) Struct() (Conmon_setWindowSizeContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_setWindowSizeContainer_Params(s), err
}

func (p Conmon_setWindowSizeContainer_Params_Future) Request() Conmon_SetWindowSizeRequest_Future {
	return Conmon_SetWindowSizeRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Results capnp.Struct

// Conmon_setWindowSizeContainer_Results_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Results.
const Conmon_setWindowSizeContainer_Results_TypeID = 0xe00e522611477055

func NewConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(st), err
}

func NewRootConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(st), err
}

func ReadRootConmon_setWindowSizeContainer_Results(msg *capnp.Message) (Conmon_setWindowSizeContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Results(root.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Results) String() string {
	str, _ := text.Marshal(0xe00e522611477055, capnp.Struct(s))
	return str
}

func (s Conmon_setWindowSizeContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_setWindowSizeContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_setWindowSizeContainer_Results {
	return Conmon_setWindowSizeContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_setWindowSizeContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_setWindowSizeContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_setWindowSizeContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_setWindowSizeContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_setWindowSizeContainer_Results) Response() (Conmon_SetWindowSizeResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_SetWindowSizeResponse(p.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Results) SetResponse(v Conmon_SetWindowSizeResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_SetWindowSizeResponse struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Results) NewResponse() (Conmon_SetWindowSizeResponse, error) {
	ss, err := NewConmon_SetWindowSizeResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_SetWindowSizeResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Results_List is a list of Conmon_setWindowSizeContainer_Results.
type Conmon_setWindowSizeContainer_Results_List = capnp.StructList[Conmon_setWindowSizeContainer_Results]

// NewConmon_setWindowSizeContainer_Results creates a new list of Conmon_setWindowSizeContainer_Results.
func NewConmon_setWindowSizeContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Results](l), err
}

// Conmon_setWindowSizeContainer_Results_Future is a wrapper for a Conmon_setWindowSizeContainer_Results promised by a client call.
type Conmon_setWindowSizeContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_setWindowSizeContainer_Results_Future) Struct() (Conmon_setWindowSizeContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_setWindowSizeContainer_Results(s), err
}

func (p Conmon_setWindowSizeContainer_Results_Future) Response() Conmon_SetWindowSizeResponse_Future {
	return Conmon_SetWindowSizeResponse_Future{Future: p.Future.Field(0, nil)}
}

const schema_ffaaf7385bc4adad = "x\xda\xacX}l\x14\xd7\x11\x9fy\xef\xd6k\xc2\x9d" +
	"\xd7\xcb:*\xb1\x8a\xdc \x88\x14Pc\x82\xe9G\x10" +
	"\x91\x0d\xc6\"NI{\xef\x0cE\xe1K,w/\xf6" +
	"\x91\xbb\xdd\xf3\xee\x1e\xb6I\x10\x90\x14UJ\xdb\xb4\x89" +
	"\x88Z\xa3\"\xe16\x89\x82\x0b%\x1f\x85&\xb4\x8a\xda" +
	"&(\x0d-mm\xa9\xad\x1a)\xfd\xa24\x04\xb5i" +
	"\xa2\"\xd5T\xa8[\xbd\xdd\xdb\x8f;\xbb\x8a?\xfa\x9f" +
	"o\xf6\xb7\xf3f\xe6\xcd\xfc~\xb3^\xf1\xa2\xd4\x91\xb8" +
	"3\xb5\xe5& lP\xaas\xed?\x0dY\xcf\x1e\xdb" +
	"\xf0(\xa8\xcb\x11@B\x19\xa0M\x95\x16\x13@\xedv" +
	"\xa9\x1d\xd0=\xfc\xeeg\xcfn~\xf4\x1f\xc7\xe3\x80n" +
	"i\xa5\x00\xe8\x1e`x\xdb\x95\x07\xbb\xba\x95o\x09\x80" +
	"\xfbA\xdb\x03o\x0f_\xf9\xd4\xf7!!p\x87\xa5\xab" +
	"\xa8\x8dH2Pw\xc9\xe9\xd7\xc6\x1e[\xd3:\x1aw" +
	"\xb3_Z \xdc<\xe5\xb9\x19\xd8\xf5\xd3\xd3\xfb\xd8\xe5" +
	"\x93S\xb89#\x8d\xa36\xe6\xb9Y5\xf2\xd2\xd9\xc7" +
	"\xdf\x1b\xfc.\xb0\xe5H\"\x98\xef\xef\x944\x8a\xday" +
	"\xe9#\x00\xdaE\xe94\xa0\xfb\xd0\xd8\xd5\xe7\x1e\xff\xd2" +
	"\xda3\x02\x8d\xb5h^G\x88v\xa8N\x06\xd0\xf6\xd7" +
	"\x09t\xf8\\]B\xddS\xa7^\xdf\xf6\xe9\x7f\x8d\xba" +
	"\x00\xd8v\xb3\xbc\x15\xb5\xdb\xe57\x00\xdaR\xf5_D" +
	"m\xd1<\x19\xc0\xbdp\xf6\xc4\xea\x7f_\x1a8W\xeb" +
	"\xbc^8\x97\xe6- \xdaR\x81k\xbbu\x9e\x8b\x80" +
	"n\xe3\xb6_\xde\xfd\xb7\x9d\x7f=\x1f/\xc0\xc8\xfcf" +
	"Q\x80W\xe6\x8b\x02\xbc\xa3\xff\x80t],\xbc\x11\x07" +
	"\xbc=\xff^\x01\xb8\xee\x03\xfe\xf2\x9f=\xbd\xa5\xd6\x9f" +
	"\xfb\x00\xaf2\xb7$\xc7\x11\x12\xee\xc4\xcd\xaf~\xbdy" +
	"\xcd\xb9_\xc4_M%=\xdfK\x93\xe2\xd5\xe6\xb5c" +
	"\xab\x14c\xc3\xaf\xaa\x8b[\xb9\xcc\xe4\x9fQ\xe3IQ" +
	"\x07\xdd\x03\xdf8\xbc\xe6\xe0\xa2E\xbf\xf9]mbD" +
	"\xa0\x0f%\x97\x11m\xc4C\x1fK\xbe\x03\xe8\x1e]>" +
	"P\xda\xb9{\xf5\xefk\xd0^xC\xa9f\xa2\x0d\xa7" +
	"\x04\xf8\xa9\x94\xe7z\xf5\x8dW\x8f\xaf)\xfd\xa1&\x0e" +
	"*\xc0\xaf\xa4.\xa0\xf6k\x0f<\x96\x12\xf7\xb1\xb9\xb4" +
	"A\xbd-\xd3\xf0\xc7xV\xfd\x0d\x19\x91\xd5W\x1a\x84" +
	"\xb7\x15\x0fm8\xb13\xaf]\x8a\x03^hx\x0b\x01" +
	"\xb5\xf3\x1e\xe0\x93\xdak\xcf\x1bO\\\xbd\x1c\x07\xbc\xdb" +
	"\xb0Lx@E\x00~\xbc\xad-\xfd\xdbK\xb7\xbd\x0f" +
	"\xea'H\xd4[\x80m\xb7*\xe3\xa8\xdd\xad\x88`\xee" +
	"RZ\x00\xdd\xb1\xf7ZN\xfe\xec\xf2g\xfeY[\x14" +
	"I\xf8\xbcKy\x0b\xb5\xcd\x02\xdd\xc6\x94-\xe2\xb6\x9f" +
	"\xed\xff\xf6\xd7&\x16\xab\xd7j\xfb\xd4\xab\xe1\x89\xc6\xc5" +
	"D{\xb3Q8?\xdf(j\xf8\xf2\xd1#_}}" +
	"\xe5\x86kU\x89\xa8\xdep\xbc\xa9\x8a8\x7f\x88\xa3\xf3" +
	"\xb7\xef\xb92Q\x95\x88\xea'\xb2@\x00&F\xbe\xd3" +
	"v\xf0\xe2K\xd7\xa7\x98\x9e\xa5\x0bn\"Z\xd7\x02\x19" +
	"Z\xdd\xaci\x14M\xe3\xe3\x96l\xb7f\xcdb\xd14" +
	"ZK\x96\xe9\x98\xad\xbe\xfd\x8e\xac^2J\xab;\xfd" +
	"\x1f|\x90g{\x86\x8cl\xa7i8z\xde\xe0\xd6\x92" +
	"\xb4n\xc9z\xd1f\x09\x9a\x00H \x80\x9aZ\x07\xc0" +
	"\xea)\xb2&\x82\x07,\xde_\xe6\xb6\x83\x8dQ\xf2\x80" +
	"\xd8\x088\xa3c-n\x96\xb8\xb1\xd1\xec\x8d\xce\xcd\xf0" +
	"\x16\xbb\\p\xaa\x0e\xbe\x17\x80%)\xb2\x85\x04]\x8b" +
	"\xdb%\xd3\xb09\x00`cDG5\x87\xd7M\xe3\xf0" +
	"Lpx\x86\xdb%E\xf8L\xe3\xcc\xc2\xd7\x1dG\xcf" +
	"\xf6U\xd5L/\xe24j\x16N\xc6,\xc2^\xeb\x1d" +
	"\x9a\xf1\xcb\x80U1K\xd3x}\xa3\xd9\xbb\xdeR\xf2" +
	"{\xb9\xc5\x12\x18\x9f\x09\\\xa6l\x1a*q\x96\x0c\x83" +
	"\xefZ\x06\xc0:(\xb2\x8d\x04\x11\x9bP\xd8\xba\x85m" +
	"=E\x96&\xa8\x12lB\x02\xa0\xde'\xb2\xbc\x87\"" +
	"\xdbDPq\x86J\x1c\x95\xc81 *\x80JIw" +
	"\xfa0\x09\x04\x93\x80\x07\x8a\xfa`O~\x1f\xc7y@" +
	"p\xde\x0c{\xa6\x87;[\xf2F\xce\x1c\x10\x1e2~" +
	"I!\x8d\x18\x0f\xbcy\x8a\xc0WN\x15\xf8\xea(p" +
	"\x9a\xcf\x05\xf1\xb5\x0c\xe4sN\x1f\xca@P\x06l\xef" +
	"\xe3\xf9\xde>'\xf8\x19\x06\x9b\xf8\xb0`\xa9i\xb0\x15" +
	"\x18c\x13\xf5\xfeG\"!Q\xef?\x17\x91\x90\xba#" +
	"\x13q\xab\xba\xe3'\xd1T\xa9\xfa\x85\x88\xa3\xd5\xfcx" +
	"\x8cU\xfb\xad\x98\x8e\xf6\xef\x8b\xf1~\xffc1\xa1." +
	"?\x19I\xa3:4\x1ac\x8f\xfd/\xba\x9f\xe7\x96\x9d" +
	"7\x8d\x0c\x0d\xc6\xaa\xd3\xe2\xba\xc3\xc3\x9e\xce\xb4\xfb\x15" +
	"v\xbd\xbe\xc9\xef\xe5\x80\x96\x1b`\xa4\x00\x14\xbc\xdcU" +
	"K#\xc1\xfd\x80\x1b<\"\xb1g\x95\x16v\x83\x96\x86" +
	"\x16\xff\xac\xf0w\xbb\xef\xd7\x0dF\x15{#\x87q[" +
	"\xe0(\xe8\x0d\x0c\x9aC\xf1\xfc\xd5\x9a\xed\x16\xcf-[" +
	"H%\x80Pi1P\x18\xf5\x85u@\xd4gd\x8c" +
	"\xb8\x1a\x03\xd1U\x87\x1f\x01\xa2>!#\x09\x97)\x0c" +
	"\xf8Z=\xfc$\x10\xf5\x90\x8c\xd1\x02\x84\xc1\"\xa0\x96" +
	"\xc5{E\x19\x13\xa1Na\xb0l\xa9\xfaQ \xea\x0e" +
	"\x19\xa5p-\xc0@\x0eUv\x0e\x88z\x9f|`\xaf" +
	"\x7fQ\x1d\xe8f+\xd5\xc7J\x1d\xa1\x03\xdd\x80\xbf1" +
	"\xa8.Z\x1d\xe8\x06\xfc\x14GZa\xd9*P\xca\x05" +
	"\xd4\xae*Q\xa7i\xb4\xfb\xaft\xe0LI\xb1\xb6\x81" +
	"\xbc\x0bCGL\xe8\x92pB\xff.&\xf4\x0aEv" +
	"\x8d\xa0\x1a\x8c\xe8\x07[\x01\xd8\xfb\x14\xd9\x0d\x82H\xfc" +
	"\x09\xbd.\xb8\x7f\x82bO\x02\x09\xaa\x944!\x05\xd0" +
	"\x103\x00\x19\xa4\xd8\xf3QaN\xd0&L\x00h\xb7" +
	"\xe0\x1e\x80\x9e\x85\xc2\xbeJ\xd8\xa5D\x13J\x00\xda\x9d" +
	"\xb8\x15\xa0g\x85\xb0o\x14\xf6:\xa9\x09\xeb\x00\xb4n" +
	"\xcf~\x8f\xb0\xe7\x84]\xaekBo3\xf2\xec\xbb\x84" +
	"\xfdaa\xaf\x97\x9b\xb0\x1e@\x1b\xc2\xdd\x00=\x83\xc2" +
	"~\x04\xab\x18\xc3\xdd]6r\x05\x9e\xd6\x81F4\xe7" +
	":\xdc*\xe6\x0d\xbd \xb4\x0a\x81\xa0\xd8\x15\xf8`\xde" +
	"I\xebN\x1f\xa0\x8d\x0d\x80i\x8a\x1e\xbc\x01\xd05\xcd" +
	"b\x97x\x0a\x8a\xee\xf4MzZ\x08\x06\x90Z\xe1\xb3" +
	"\xc6\xf8\x1a\xe3\xa1\xb2\x05\xae\x1b\xe5R'\xd0b\xae\xd6" +
	"Co\xc1\xdc\xad\x17\xd6Z@{'y\x17\xd7\xaa\x1b" +
	"\xb9\xb5 [S=\x9c\xbd&f\xb8].\xd0\xe9\xea" +
	"y\xc8g5\xc2X?\x8d\x93\xed\xb80\xd4\x88\xb2\x0d" +
	"\xf0\xe1\xaa\x1c\xb2\xe4,T\xb92\x9e\xc1\x0a0\xa3\x92" +
	"e\xab'f\x86%\x0becn+P\x7fY\xe6\xb6" +
	"7\xa5\xb1S\x9b\xa3:\xc5\x9b}&\xc9M!\x09\xd1" +
	"\xb6\xc5\x1a\xc3\xb3t\x91\xe1.\x8a\xac\x10iv^\xc8" +
	"s\x8e\"+\xc54\xbb(\x8c}\x14\x99#\x08\xe1c" +
	"\x1e!\xa8\xfd\xe2\xed\x12E\xf60\xf1G\xac\xd3\xccy" +
	"\xf5I\x00\xc1\x04`\xbb\xed\xe4\xcc\xb2\x83) \x98\xf2" +
	"\x7fr\xcb\x0a~\xbaN\xbe\xc8s\x9f+;\xf1A\x9d" +
	"\x13\xe7\x89\x0b\xa2~\x8a\xb1r\xee\x89]b\xb6\x02\x06" +
	"\xc5J\xe7sX\x0f\x04\xebg\xb9\x09V\x14\xf1\x7f\xef" +
	"@!\xc3vo\x8d\xf6\x1d\x95T(\x96Y\x00,M" +
	"\x91m\xaf\xbee\xdb\xcc>\xc8\x9d\x1aJ\xf3\x84\x86\xdb" +
	"6\xb4\xe4M\xa3{rK\xccaP\xbd\xb6wp\x9a" +
	"m\x1fn1s\x18\xd6\x99\x0dZ\xb8\xc6\xfd\x7f>t" +
	"\xd2\xbabM\xeb\x03+\\\xebf\x91i\xb0\xb5Yw" +
	"l\x1a*\xa1\xdf\x8f\xde\xa5K\xe3\x00a\x0f\x12+S" +
	"6\xc4\x0ct\x1b\x0e\xb7\x1e\xd0\xb3\xc8gtJ\xb0D" +
	"\xc6\xdb~a\x98\xd6\xb0H\xeb\x08Ev<\xd6\x89\xc7" +
	"\x16\x03\xb0oPdO\xc7:qD\x8c\xf67)\xb2" +
	"\xe7\xc4hS\x7f\xb4\x9f\xc9\x00\xb0\xa7)\xb2\xe7\x85\xd2" +
	"'<\xa5WO\xed\x06`')\xb2\x97\x09\xa2\xe4\xa9" +
	"\xbczF\x00\xbfG\x91\xfd\x88`\xb0.\x05\xfd);" +
	"zo\xf0w\xbb\xc8'\xef\xc4\xa4;_\xc8\xad\xd7\x1d" +
	"@\x1e\xda\xac\xb2\xed\x88\xac@\x8e9qK\x96\x99\xe5" +
	"\xb6\xdd\x0d8y`g\xc9\x85\x11\xed\xc6\xa8P\x8c\xee" +
	"v\x8a\xac/\xa2B\xbeu**\\W\xa1\xc2/\x88" +
	"zu\xf8\xf5:$:\xf8 E\xf6\xe5\xeaq\x16\xf7" +
	"k\x96\x9d\x1e\xa0<\x1b|x\x1d\xa8\xc8~\xad\xe0O" +
	"\xb5\xb8\xccE\xd1\xa6\xfda\x1c~\x1d\xcdb\xc6&\xff" +
	"\x0f#\xc3me\xfa\xffK\x08\xbf\xb2fqv\xcdG" +
	"i\xe06\x8d\xf8\xdf\x00\x00\x00\xff\xffg\x85U\x84"

func init() {
	schemas.Register(schema_ffaaf7385bc4adad,
		0x83479da67279e173,
		0xa0ef8355b64ee985,
		0xa20f49456be85b99,
		0xaa2f3c8ad1c3af24,
		0xace5517aafc86077,
		0xae78ee8eb6b3a134,
		0xb5418b8ea8ead17b,
		0xb737e899dd6633f1,
		0xba77e3fa3aa9b6ca,
		0xc5e65eec3dcf5b10,
		0xc76ccd4502bb61e7,
		0xcc2f70676afee4e7,
		0xceba3c1a97be15f8,
		0xd0476e0f34d1411a,
		0xd9d61d1d803c85fc,
		0xde3a625e70772b9a,
		0xdf703ca0befc3afc,
		0xe00e522611477055,
		0xe313695ea9477b30,
		0xe5ea916eb0c31336,
		0xf026e3d750335bc1,
		0xf34be5cbac1feed1,
		0xf41122f890a371a6,
		0xf44732c48f949ab8,
		0xf8e86a5c0baa01bc,
		0xf9b3cd8033aba1f8)
}
