<p align="center"><img src ="https://github.com/bokuweb/react-rnd/blob/master/logo.png?raw=true" /></p>

<p align="center">A resizable and draggable component for React.</p>

<p align="center"><a href="https://circleci.com/gh/bokuweb/react-rnd/tree/master">
<img src="https://circleci.com/gh/bokuweb/react-rnd/tree/master.svg?style=svg" alt="Build Status" /></a>
<a href="https://www.npmjs.com/package/react-rnd">
<img src="https://img.shields.io/npm/v/react-rnd.svg" alt="Build Status" /></a>
<a href="https://www.npmjs.com/package/react-rnd">
<img src="https://img.shields.io/npm/dm/react-rnd.svg" /></a>
<a href="https://renovatebot.com/">
<img src="https://img.shields.io/badge/renovate-enabled-brightgreen.svg" /></a>
<a href="https://github.com/prettier/prettier">
<img src="https://img.shields.io/badge/styled_with-prettier-ff69b4.svg" /></a>
<a href="https://bokuweb.github.io/react-rnd/stories">
<img src="https://camo.githubusercontent.com/302badad5b2c7f7fa0929dadc1ca0ca7cdf2e8f0/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f73746f7279626f6f6b2d72656163742d3030643866662e7376673f636f6c6f72413d653136313863266c6f676f3d646174613a696d6167652f706e673b6261736536342c6956424f5277304b47676f414141414e53556845556741414144454141414179434159414141443143444f794141414141584e535230494172733463365141414141526e51553142414143786a777638595155414141414a6345685a6377414144734d41414137444163647671475141414158305355524256476844375a6c7262425256464d66506e6666757a72623067566751553651594c425574425931457742636153535434494349314367676d4b6e345341686a6b6736434a565a517678432f794d694342524979474742494450694a6f524155667142686549744241433561793233334d7a6f7a337a6836774f4a325a75374f376f54482b6d736e39337a76623766336678376c6e707642666747423552646d335a667659786d6d54683971325853744a55723356666736366c7134445652416861356d4e456845367174597666426f2f37714a6b4a72352b634b452b4b464952723956693846656d70796b7571324259356943426b446f6259414439513030793752527461355945555241415a4175676d6e5641486e633969547a7a674a6a2f4a67447231466c494c4632504e5963446c6573574e4b463245576a69777079565937717a36516c525352466f4278706f52796f743236366974356f6b316857415774704a42623949796865466f64777a4272535a64324b7463424e4f4c2f7967552f79524c7175723649692b7159725373375273705a3266517139723657313252616b4231766c514268696b496f6f714849456d364a535848614a72546d6b65504f475568524a7377725936554a594e45744d67732f554c534c3632425a497233734e5766674a4e304431774847585a53472f2b44444937396a7261504e494f79655762484d304c78307a516256746d374b3445716a7832786b44465236434a6a4a6c445651414341574641444b52523961446333517a712f654e6f42476f4761665177495045496671683042496259784a79564330336262734e71494d72454730475a6367734956773341466a66576d533749664c67486a4b392b785a5a41696775784675647149705578694331724257335776623447474f782b5a4e3455694c30344131754b493967455235416c455a56323644455136362f47466a3745686947674c333853612b454a4e474661316b6d556e7167503377374377457173465959777042626b6c6846594330656769616973744b5073453649706f4577616a6256776145394d5268574f51424e5a303054564e394c4e772b6d3638503461746f6d7a4f2f6542656577307472686845617559314350515245633634627370784748652b38424a354a61736866536d585a42386553506b39682f474f32366b6b554e5246553667696147787175395139676d70306c4735796631386a475751574b4d6e3877653755626b52427670484e44384354644463435a5548707666396630637275374d626c5275575034556c384c41374e36744e46346c774161737531476e6a515a3136473962634a462f64444f6168552f6b4b49666b395a4f54417068666b3648347a544c42706166646b584f6c484c346f373749353064374c436333636265333542315465784a544e4175573973766b4b58566d37664957655a73625462504e774f3576457a7a7437784d5242496f496d7832396f53644c6f387a323057665877375145646665335153364b2f4d426e4677445461576c6b41546a4b444d49376e7966565465434858564546737843364c5054334e4f2b464a5345685057795535496239794a4e582b6b35754551587a33667957704c425a634a6b5244636d64356b642b3248314e76627352614d4e764d75694332596a7258694b4d6c4d584d5459657841536939654131584565572f775247362b6c6d652f6a7a72347042693454675764464c3968475479783642314962506e4643615242692f53445148706d41745842776d54424d7377736c4e38626e50304c332f4e5667374436414c64346f394d6d504a5a4a6834544b6853664a504b4e327774655a31305a6c4972646b4250573162615a3031654b506363524f71777546616a4f646e76374752467133353275586f62584d39527a4778614133597159796a685a6f4b30462b66352b692b734537535a50476c793937363961613445357468574e37704f4e46704775317867664c5053304872624464397076592b33556c4e484658683843306e556634657052752f424842774e616f38767338555176674978575843396c6e514c4270356f557875515a5648764b344f6c5273376c5556564f46776d63706233614f642b2b784f564735617852702b62366b5166567371336a7351376269356c756948674d70484d5a547850722b7a483336447147366c6c42476a544a7a716c482b7a454477755869576f3135686c69375751617a4e2f447663322b534f37414833524777372f7935544b527466785058706246737567544270762b6e704e7a2b52386a766e435a4f4a394e6f664b41486d7273685944785a66447066416b614b374b662f67434a5a52766f55313061473850424664645363392f53733662702b596a6147784b50676a792b456551784453445168794369796e536f36466a52344d41696b48576945347a396835776e517259554f536e756633614d39464f7239497956347a4a524a6f6f2f7358764d664f7251582b4579636254374c4e2b5558534734544c527361324e76417672746448435a364f39776d7967696a4a6564516d62433978582f6c6153672f58717364626c6572555467654c4b726f55714e794c716b676d6c626374597952366d43784e364b514e724d3151754558434d4a6f6a4e43686d57316944544e5a6a2b57626466526a385359707244584177726e4442642f5470534c62783961724e646f5561696c3139454c3532366f56714e36584e6259594a426b4c747569304945514352304b516b355872483368586679312f2b6d6e4150774e6e34482f346f436769623841414141415355564f524b35435949493d" /></a>
</p>

## Table of Contents

* [Screenshot](#Screenshot)
* [Live Demo](#live-demo)
  * [Storybook](#storybook)
  * [CodeSandbox](#codesandbox)
* [Install](#install)
* [Usage](#usage)
* [Props](#props)
* [Instance API](#instance-api)
  * [updateSize(size: { width: number | string, height: number | string }): void](#updateSize-void)
  * [updatePosition({ x: number, y: number }): void](#updatePosition-void)
* [Test](#test)
* [Related](#related)
* [Changelog](#changelog)
* [License](#license)


## Screenshot

<p align="center">
  <img src="https://raw.githubusercontent.com/bokuweb/react-rnd/master/screenshot.gif" />
</p>

https://codesandbox.io/s/xpm699v4lp

## Live Demo

### Storybook

[Storybook](http://bokuweb.github.io/react-rnd/stories)

### CodeSandbox

[![Edit y3997qply9](https://codesandbox.io/static/img/play-codesandbox.svg)](https://codesandbox.io/s/y3997qply9)   
[CodeSandbox(with default)](https://codesandbox.io/s/y3997qply9)    
[CodeSandbox(with size and position)](https://codesandbox.io/s/my4kjly94x)    
[CodeSandbox(with typescript)](https://codesandbox.io/s/j1vvkpo9wv)


## Install

- use npm

```sh
npm i -S react-rnd
```

- use yarn

```sh
yarn add react-rnd
```

## Usage

### Example with `default`

``` javascript
<Rnd
  default={{
    x: 0,
    y: 0,
    width: 320,
    height: 200,
  }}
>
  Rnd
</Rnd>
```

### Example with `position` and `size`

``` javascript
<Rnd
  size={{ width: this.state.width,  height: this.state.height }}
  position={{ x: this.state.x, y: this.state.y }}
  onDragStop={(e, d) => { this.setState({ x: d.x, y: d.y }) }}
  onResizeStop={(e, direction, ref, delta, position) => {
    this.setState({
      width: ref.style.width,
      height: ref.style.height,
      ...position,
    });
  }}
>
  001
</Rnd>
```

## Props

#### `default: { x: number; y: number;  width?: number | string;  height?: number | string; };`

The `width` and `height` property is used to set the default size of the component.
For example, you can set `300`, `'300px'`, `50%`.
If omitted, set `'auto'`.

The `x` and `y` property is used to set the default position of the component.

#### `size?: { width: (number | string), height: (number | string) };`

The `size` property is used to set size of the component.
For example, you can set 300, '300px', 50%.

Use `size` if you need to control size state by yourself.

#### `position?: { x: number, y: number };`

The `position` property is used to set position of the component.
Use `position` if you need to control size state by yourself.

see, following example.

``` javascript
<Rnd
  size={{ width: this.state.width,  height: this.state.height }}
  position={{ x: this.state.x, y: this.state.y }}
  onDragStop={(e, d) => { this.setState({ x: d.x, y: d.y }) }}
  onResize={(e, direction, ref, delta, position) => {
    this.setState({
      width: ref.offsetWidth,
      height: ref.offsetHeight,
      ...position,
    });
  }}
>
  001
</Rnd>
```

#### `className?: string;`

The `className` property is used to set the custom `className` of the component.

#### `style?: { [key: string]: string };`

The `style` property is used to set the custom `style` of the component.

#### `minWidth?: number | string;`

The `minWidth` property is used to set the minimum width of the component.
For example, you can set `300`, `'300px'`, `50%`.

#### `minHeight?: number | string;`

The `minHeight` property is used to set the minimum height of the component.
For example, you can set `300`, `'300px'`, `50%`.

#### `maxWidth?: number | string;`

The `maxWidth` property is used to set the maximum width of the component.
For example, you can set `300`, `'300px'`, `50%`.

#### `maxHeight?: number | string`;

The `maxHeight` property is used to set the maximum height of the component.
For example, you can set `300`, `'300px'`, `50%`.

#### `resizeGrid?: [number, number];`

The `resizeGrid` property is used to specify the increments that resizing should snap to. Defaults to `[1, 1]`.

#### `dragGrid?: [number, number];`

The `dragGrid` property is used to specify the increments that moving should snap to. Defaults to `[1, 1]`.

#### `lockAspectRatio?: boolean | number;`

The `lockAspectRatio` property is used to lock aspect ratio.
Set to `true` to lock the aspect ratio based on the initial size.
Set to a numeric value to lock a specific aspect ratio (such as `16/9`).
If set to numeric, make sure to set initial height/width to values with correct aspect ratio.
If omitted, set `false`.

#### `lockAspectRatioExtraWidth?: number;`

The `lockAspectRatioExtraWidth` property enables a resizable component to maintain an aspect ratio plus extra width.
For instance, a video could be displayed 16:9 with a 50px side bar.
If omitted, set `0`.

#### `scale?: number;`

Specifies the scale of the canvas your are dragging or resizing this element on. This allows
you to, for example, get the correct drag / resize deltas while you are zoomed in or out via
a transform or matrix in the parent of this element.
If omitted, set `1`.

#### `lockAspectRatioExtraHeight?: number;`

The `lockAspectRatioExtraHeight` property enables a resizable component to maintain an aspect ratio plus extra height.
For instance, a video could be displayed 16:9 with a 50px header bar.
If omitted, set `0`.

#### `dragHandleClassName?: string;`

Specifies a selector to be used as the handle that initiates drag.
Example: `handle`.

#### `resizeHandleStyles?: HandleStyles;`

The `resizeHandleStyles` property is used to override the style of one or more resize handles.
Only the axis you specify will have its handle style replaced.
If you specify a value for `right` it will completely replace the styles for the `right` resize handle,
but other handle will still use the default styles.

``` javascript

export type HandleStyles = {
  bottom?: React.CSSProperties,
  bottomLeft?: React.CSSProperties,
  bottomRight?: React.CSSProperties,
  left?: React.CSSProperties,
  right?: React.CSSProperties,
  top?: React.CSSProperties,
  topLeft?: React.CSSProperties,
  topRight?: React.CSSProperties
}
```

#### `resizeHandleClasses?: HandleClasses;`

The `resizeHandleClasses` property is used to set the className of one or more resize handles.

``` javascript
type HandleClasses = {
  bottom?: string;
  bottomLeft?: string;
  bottomRight?: string;
  left?: string;
  right?: string;
  top?: string;
  topLeft?: string;
  topRight?: string;
}
```

#### `resizeHandleComponent?`: HandleCompoent;`

The `resizeHandleComponent` allows you to pass a custom React component as the resize handle.

``` javascript
type HandleComponent = {
  top?: React.ReactElement<any>;
  right?: React.ReactElement<any>;
  bottom?: React.ReactElement<any>;
  left?: React.ReactElement<any>;
  topRight?: React.ReactElement<any>;
  bottomRight?: React.ReactElement<any>;
  bottomLeft?: React.ReactElement<any>;
  topLeft?: React.ReactElement<any>;
}
```

#### `resizeHandleWrapperClass?: string;`

The `resizeHandleWrapperClass` property is used to set css class name of resize handle wrapper(`span`) element.

#### `resizeHandleWrapperStyle?: Style;`

The `resizeHandleWrapperStyle` property is used to set css class name of resize handle wrapper(`span`) element.

#### `enableResizing?: ?Enable;`

The `enableResizing` property is used to set the resizable permission of the component.

The permission of `top`, `right`, `bottom`, `left`, `topRight`, `bottomRight`, `bottomLeft`, `topLeft` direction resizing.
If omitted, all resizer are enabled.
If you want to permit only right direction resizing, set `{ top:false, right:true, bottom:false, left:false, topRight:false, bottomRight:false, bottomLeft:false, topLeft:false }`.

``` javascript
export type Enable = {
  bottom?: boolean;
  bottomLeft?: boolean;
  bottomRight?: boolean;
  left?: boolean;
  right?: boolean;
  top?: boolean;
  topLeft?: boolean;
  topRight?: boolean;
}
```

#### `disableDragging?: boolean;`

The `disableDragging` property disables dragging completely.

#### `cancel?: string;`

The `cancel` property disables specifies a selector to be used to prevent drag initialization (e.g. `.body`).

#### `dragAxis?: 'x' | 'y' | 'both' | 'none'`

The direction of allowed movement (dragging) allowed ('x','y','both','none').

#### `bounds?: string;`

Specifies movement boundaries. Accepted values:
 - `parent` restricts movement within the node's offsetParent
    (nearest node with position relative or absolute)
 - `window`, `body`, or
 - Selector, like `.fooClassName`.


#### `enableUserSelectHack?: boolean;`

By default, we add 'user-select:none' attributes to the document body    
to prevent ugly text selection during drag. If this is causing problems    
for your app, set this to `false`.    

#### `scale?: number;`

Specifies the scale of the canvas your are resizing and dragging this element on. This allows
you to, for example, get the correct resize and drag deltas while you are zoomed in or out via
a transform or matrix in the parent of this element.
If omitted, set `1`.

## Callback

#### `onResizeStart?: RndResizeStartCallback;`

`RndResizeStartCallback` type is below.

``` javascript
export type RndResizeStartCallback = (
  e: SyntheticMouseEvent<HTMLDivElement> | SyntheticTouchEvent<HTMLDivElement>,
  dir: ResizeDirection,
  refToElement: React.ElementRef<'div'>,
) => void;
```

Calls when resizable component resize start.

#### `onResize?: RndResizeCallback;`

`RndResizeCallback` type is below.

``` javascript
export type RndResizeCallback = (
  e: MouseEvent | TouchEvent,
  dir: ResizeDirection,
  refToElement: React.ElementRef<'div'>,
  delta: ResizableDelta,
  position: Position,
) => void;
```

Calls when resizable component resizing.

#### `onResizeStop?: RndResizeCallback;`

`RndResizeCallback` type is below.

``` javascript
export type RndResizeCallback = (
  e: MouseEvent | TouchEvent,
  dir: ResizeDirection,
  refToElement: React.ElementRef<'div'>,
  delta: ResizableDelta,
  position: Position,
) => void;
```

Calls when resizable component resize stop.

#### `onDragStart: DraggableEventHandler;`

Callback called on dragging start.

``` javascript
type DraggableData = {
  node: HTMLElement,
  x: number,
  y: number,
  deltaX: number, deltaY: number,
  lastX: number, lastY: number
};

type DraggableEventHandler = (
  e: SyntheticMouseEvent | SyntheticTouchEvent, data: DraggableData,
) => void | false;
```

#### `onDrag: DraggableEventHandler;`

`onDrag` called with the following parameters:

``` javascript
type DraggableData = {
  node: HTMLElement,
  x: number,
  y: number,
  deltaX: number, deltaY: number,
  lastX: number, lastY: number
};

type DraggableEventHandler = (
  e: SyntheticMouseEvent | SyntheticTouchEvent, data: DraggableData,
) => void | false;
```

#### `onDragStop: DraggableEventHandler;`

`onDragStop` called on dragging stop.


``` javascript
type DraggableData = {
  node: HTMLElement,
  x: number,
  y: number,
  deltaX: number, deltaY: number,
  lastX: number, lastY: number
};

type DraggableEventHandler = (
  e: SyntheticMouseEvent | SyntheticTouchEvent, data: DraggableData,
) => void | false;
```

## Instance API


#### `updateSize(size: { width: string | number, height: string | number })`

Update component size.
For example, you can set `300`, `'300px'`, `50%`.

- for example

``` js
class YourComponent extends Component {

  ...

  update() {
    this.rnd.updateSize({ width: 200, height: 300 });
  }

  render() {
    return (
      <Rnd ref={c => { this.rnd = c; }} ...rest >
        example
      </Rnd>
    );
  }
  ...
}
```

#### `updatePosition({ x: number, y: number }): void`

Update component position.
`grid` `bounds` props is ignored, when this method called.

- for example

``` js
class YourComponent extends Component {

  ...

  update() {
    this.rnd.updatePosition({ x: 200, y: 300 });
  }

  render() {
    return (
      <Rnd ref={c => { this.rnd = c; }} ...rest >
        example
      </Rnd>
    );
  }

  ...
}
```

## Test

``` sh
npm t
```

## Contribute

If you have a feature request, please add it as an issue or make a pull request.

If you have a bug to report, please reproduce the bug in [CodeSandbox](https://codesandbox.io/s/y3997qply9) to help us easily isolate it.

## Changelog

#### v10.1.5

- Fixed a bug, react-draggable not bundling with rollup #641

#### v10.1.4

- Fixed a bug, box moves when resized  #622

#### v10.1.3

- Fixed a bug, position is wrong when onResize #618

#### v10.1.2

- Upgrade re-resizable to 6.1.1
- Upgrade react-draggable to 4.1.0

#### v10.1.1

- Upgrade re-resizable to 6.1.0

#### v10.1.0

- Implement resizeHandleComponent #591
- Update dependency react-draggable to v4

#### v10.0.0

- Fix: Fix #526
- Feat: Add `onMouseUp` callback. 
- Feat: Use `React.pureComponent`

#### v9.2.0

- Chore: Use `re-resizablev5` 

#### v9.1.2

- Fix: Fixes memory leak #499

#### v9.1.1

- Fix: Add `scale` props to index.js.flow.

#### v9.1.0

- Feat: Add `scale` props. #482
- Feat: Upgrade deps.

#### v9.0.4

- Fix: cursor style #469

#### v9.0.3

- update dependency re-resizable to v4.9.3 #444

#### v9.0.2

- fix: resizeHandleWrapperClass warning shown in console #428

#### v9.0.1

- fix: Allow additional props in typescript.

#### v9.0.0

- fix: change `default export` to `export` #405

#### v8.0.2

- fix: fixed a bug, `bounds` is ignored when lock aspect ratio set.
- feat: add `body` to bounds props.

#### v8.0.1

- fix: [#221] fixed a bug, maxwidth / height not applied.

#### v8.0.0

- fix: fixed some position and resizing bug.       
- fix: [#209] bounds `window`. you can check [here](http://bokuweb.github.io/react-rnd/stories/?selectedKind=bounds&selectedStory=window%20controlled&full=0&addons=1&stories=1&panelRight=0&addonPanel=storybook%2Factions%2Factions-panel).       
- fix: [#317] add onMouseDown. i.e) `<Rnd onMouseDown={...} />`      
- [BREAKING] fix: [#335] add . to `dragHandleClassName` automatically, Please pass string (i.e `handle`.      
- [BREAKING] fix: remove `extendsProps`. Please add extends props directly. i.e) `<Rnd data-foo="42" />`      
- [BREAKING] fix: remove `z` props. Please add `zIndex` via `style` props. i.e) `<Rnd style={{ zIndex: 9 }} />`

#### v8.0.0-beta.2

- fix: Upgrade `re-resizable` to fix percentage size and bare behavior.

#### v8.0.0-beta.1

- fix: Fixed a bug, controlled position does not work correctly.
- feat: Use `typescript` instead of `flowype`.

#### v8.0.0-beta.0

- fix: Remove dummy `<div />`, `isMounted` state and `setParentPosition()`.

#### v7.4.3

- fix: Add `props,children` to dummy `<div>` to render children in first.

#### v7.4.2 (unpublished)

fix: `isMounted` and `(!this.state.isMounted) return <div />` line #356

#### v7.4.1

- fix: Fixed Array.from error in IE11

#### v7.4.0

- fix: add `enableUserSelectHack?: boolean;`.

#### v7.3.1

- chore(deps): upgrade deps
- chore(deps): upgrade lint and remove unused state
- chore(deps): install prettier

#### v7.3.0

- chore(deps): upgrade re-resizable

#### v7.2.0

- Support for cancel feature of react-draggable #206

#### v7.1.5

- Fixed a issue #199 Add enableUserSelectHack props to react-draggable

#### v7.1.4

- Fixed a issue #188 maxWidth and maxHeight props don't respect after resize

#### v7.1.3
 
- Fixed a bug, `extendProps` is not passed correctly.
- Fixed a bug, `bounds` is not work correctly. (#162)

#### v7.1.1 / v7.1.2

- Add internal props.

#### v7.1.0

- Add `size`.
- Add `position`.

#### v7.0.0

- Add `default` instead of `x`, `y`, `width`, `height`.
- Add `resizeHandleWrapperClass` and `resizeHandleWrapperStyle`.

#### v6.0.1

- Remove unnecessary types.

#### v6.0.0

- Use rollup.
- Support % min/max size.
- Change props, remove `default` and add `x`, `y`, `width`, `height`.
- Rename `dragHandlersXXXX` and `resizeHandlersXXXX` props to `dragHandleXXXX` and `resizeHandleXXXX`.

#### v5.1.3

- Fix cursor style, set `normal` to cursor style when `dragHandlerClassName` is not empty.

#### v5.1.2

- Add position `relative` when component will update.

#### v5.1.1

- Add `top: 0`, `left: 0`.
- Add position `relative` when parent position equals `static`.

#### v5.1.0

- Update dependencies(`react-draggable v3`, `flow-bin v0.53`, and other...)

#### v5.0.9

- Fix bug new `z` props is not applied to state.

#### v5.0.8

- Add `extendsProps`. #129

#### v5.0.7

- Add `disableDragging` props.

#### v5.0.6

- Fix flow error.

#### v5.0.5

- Add index.js.flow

#### v5.0.4

- Fix Issue #117.

#### v5.0.3

- Fix `updateZIndex`.
- Fix `updateSize`.
- Fix left and top bounds.

#### v5.0.2

- Fix argument events #100

#### v5.0.1

- Fix example
- Update README

#### v5.0.0

- Fix resize bounds.
- Modify API.
- Use original `react-draggable`.


#### v4.2.1

- Added `updateZIndex`, method to updated component `zIndex` state.

#### v4.2.0

- Pass the new position in the onResizeStop callback #60


#### v4.1.0

- Pass the new position along in the resize callback #55


#### v4.0.1

- Fix style props to applt zIndex chaned.

#### v4.0.0

- Rename `react-rnd`.
- Remove `canUpdatePositionByParent` property.
- Remove `canUpdateSizeByParent` property.
- Remove `initiAsResizing` property.
- Change `x`, `y`, `width` and `height` property to `initial`.
- Add `updateSize`, `updatePosition`, method to updated conponent state.
- Add `lockAspectRatio` property to lock aspect ratio when resizing.

#### v3.0.0

- Add `canUpdatePositionByParent` property.

#### v2.0.0

- Fix bug, resize and grid not work properly.

#### v1.2.0

- Add `grid` props to snap grid. (thanks @paulyoung)
- Fix bug, moveAxis not work properly.


#### v1.1.3

- Fix situations when on dragStop you wanted to revert to 0,0 position #39
- Add `canUpdateSizeByParent` props #38

#### v1.1.2

- Add object.assign transform

#### v1.1.0

- Add add module exports plugin for `require`

#### v1.0.1

- Bug fix

#### v1.0.0

- Support react v15.x
- Support left, top resizer
- Remove start props, use width, height, x, and y.

#### v0.5.3

- Add handle selector

## License

The MIT License (MIT)

Copyright (c) 2018 bokuweb

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
