/*
const DOWNCLS = 'fa-sort-down';
const UPCLS = 'fa-sort-up';
*/
Template.boardMenuPopup.events({
  'click .js-rename-board': Popup.open('boardChangeTitle'),
  'click .js-custom-fields'() {
    Sidebar.setView('customFields');
    Popup.close();
  },
  'click .js-open-archives'() {
    Sidebar.setView('archives');
    Popup.close();
  },
  'click .js-change-board-color': Popup.open('boardChangeColor'),
  'click .js-change-language': Popup.open('changeLanguage'),
  'click .js-archive-board ': Popup.afterConfirm('archiveBoard', function() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    currentBoard.archive();
    // XXX We should have some kind of notification on top of the page to
    // confirm that the board was successfully archived.
    FlowRouter.go('home');
  }),
  'click .js-delete-board': Popup.afterConfirm('deleteBoard', function() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    Popup.close();
    Boards.remove(currentBoard._id);
    FlowRouter.go('home');
  }),
  'click .js-outgoing-webhooks': Popup.open('outgoingWebhooks'),
  'click .js-import-board': Popup.open('chooseBoardSource'),
  'click .js-subtask-settings': Popup.open('boardSubtaskSettings'),
  'click .js-card-settings': Popup.open('boardCardSettings'),
});

Template.boardChangeTitlePopup.events({
  submit(event, templateInstance) {
    const newTitle = templateInstance
      .$('.js-board-name')
      .val()
      .trim();
    const newDesc = templateInstance
      .$('.js-board-desc')
      .val()
      .trim();
    if (newTitle) {
      this.rename(newTitle);
      this.setDescription(newDesc);
      Popup.close();
    }
    event.preventDefault();
  },
});

BlazeComponent.extendComponent({
  watchLevel() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    return currentBoard && currentBoard.getWatchLevel(Meteor.userId());
  },

  isStarred() {
    const boardId = Session.get('currentBoard');
    const user = Meteor.user();
    return user && user.hasStarred(boardId);
  },

  // Only show the star counter if the number of star is greater than 2
  showStarCounter() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    return currentBoard && currentBoard.stars >= 2;
  },
  /*
  showSort() {
    return Meteor.user().hasSortBy();
  },
  directionClass() {
    return this.currentDirection() === -1 ? DOWNCLS : UPCLS;
  },
  changeDirection() {
    const direction = 0 - this.currentDirection() === -1 ? '-' : '';
    Meteor.call('setListSortBy', direction + this.currentListSortBy());
  },
  currentDirection() {
    return Meteor.user().getListSortByDirection();
  },
  currentListSortBy() {
    return Meteor.user().getListSortBy();
  },
  listSortShortDesc() {
    return `list-label-short-${this.currentListSortBy()}`;
  },
  */
  events() {
    return [
      {
        'click .js-edit-board-title': Popup.open('boardChangeTitle'),
        'click .js-star-board'() {
          Meteor.user().toggleBoardStar(Session.get('currentBoard'));
        },
        'click .js-open-board-menu': Popup.open('boardMenu'),
        'click .js-change-visibility': Popup.open('boardChangeVisibility'),
        'click .js-watch-board': Popup.open('boardChangeWatch'),
        'click .js-open-archived-board'() {
          Modal.open('archivedBoards');
        },
        'click .js-toggle-board-view': Popup.open('boardChangeView'),
        'click .js-toggle-sidebar'() {
          Sidebar.toggle();
        },
        'click .js-open-filter-view'() {
          Sidebar.setView('filter');
        },
        /*
        'click .js-open-sort-view'(evt) {
          const target = evt.target;
          if (target.tagName === 'I') {
            // click on the text, popup choices
            this.changeDirection();
          } else {
            // change the sort order
            Popup.open('listsort')(evt);
          }
        },
        */
        'click .js-filter-reset'(event) {
          event.stopPropagation();
          Sidebar.setView();
          Filter.reset();
        },
        'click .js-open-search-view'() {
          Sidebar.setView('search');
        },
        'click .js-multiselection-activate'() {
          const currentCard = Session.get('currentCard');
          MultiSelection.activate();
          if (currentCard) {
            MultiSelection.add(currentCard);
          }
        },
        'click .js-multiselection-reset'(event) {
          event.stopPropagation();
          MultiSelection.disable();
        },
        'click .js-log-in'() {
          FlowRouter.go('atSignIn');
        },
      },
    ];
  },
}).register('boardHeaderBar');

Template.boardHeaderBar.helpers({
  canModifyBoard() {
    return (
      Meteor.user() &&
      Meteor.user().isBoardMember() &&
      !Meteor.user().isCommentOnly()
    );
  },
  boardView() {
    return Utils.boardView();
  },
});

Template.boardChangeViewPopup.events({
  'click .js-open-lists-view'() {
    Utils.setBoardView('board-view-lists');
    Popup.close();
  },
  'click .js-open-swimlanes-view'() {
    Utils.setBoardView('board-view-swimlanes');
    Popup.close();
  },
  'click .js-open-cal-view'() {
    Utils.setBoardView('board-view-cal');
    Popup.close();
  },
});

const CreateBoard = BlazeComponent.extendComponent({
  template() {
    return 'createBoard';
  },

  onCreated() {
    this.visibilityMenuIsOpen = new ReactiveVar(false);
    this.visibility = new ReactiveVar('private');
    this.boardId = new ReactiveVar('');
  },

  visibilityCheck() {
    return this.currentData() === this.visibility.get();
  },

  setVisibility(visibility) {
    this.visibility.set(visibility);
    this.visibilityMenuIsOpen.set(false);
  },

  toggleVisibilityMenu() {
    this.visibilityMenuIsOpen.set(!this.visibilityMenuIsOpen.get());
  },

  onSubmit(event) {
    event.preventDefault();
    const title = this.find('.js-new-board-title').value;
    const visibility = this.visibility.get();

    this.boardId.set(
      Boards.insert({
        title,
        permission: visibility,
      }),
    );

    Swimlanes.insert({
      title: 'Default',
      boardId: this.boardId.get(),
    });

    Utils.goBoardId(this.boardId.get());
  },

  events() {
    return [
      {
        'click .js-select-visibility'() {
          this.setVisibility(this.currentData());
        },
        'click .js-change-visibility': this.toggleVisibilityMenu,
        'click .js-import': Popup.open('boardImportBoard'),
        submit: this.onSubmit,
        'click .js-import-board': Popup.open('chooseBoardSource'),
        'click .js-board-template': Popup.open('searchElement'),
      },
    ];
  },
}).register('createBoardPopup');

(class HeaderBarCreateBoard extends CreateBoard {
  onSubmit(event) {
    super.onSubmit(event);
    // Immediately star boards crated with the headerbar popup.
    Meteor.user().toggleBoardStar(this.boardId.get());
  }
}.register('headerBarCreateBoardPopup'));

BlazeComponent.extendComponent({
  visibilityCheck() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    return this.currentData() === currentBoard.permission;
  },

  selectBoardVisibility() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    const visibility = this.currentData();
    currentBoard.setVisibility(visibility);
    Popup.close();
  },

  events() {
    return [
      {
        'click .js-select-visibility': this.selectBoardVisibility,
      },
    ];
  },
}).register('boardChangeVisibilityPopup');

BlazeComponent.extendComponent({
  watchLevel() {
    const currentBoard = Boards.findOne(Session.get('currentBoard'));
    return currentBoard.getWatchLevel(Meteor.userId());
  },

  watchCheck() {
    return this.currentData() === this.watchLevel();
  },

  events() {
    return [
      {
        'click .js-select-watch'() {
          const level = this.currentData();
          Meteor.call(
            'watch',
            'board',
            Session.get('currentBoard'),
            level,
            (err, ret) => {
              if (!err && ret) Popup.close();
            },
          );
        },
      },
    ];
  },
}).register('boardChangeWatchPopup');

/*
BlazeComponent.extendComponent({
  onCreated() {
    //this.sortBy = new ReactiveVar();
    ////this.sortDirection = new ReactiveVar();
    //this.setSortBy();
    this.downClass = DOWNCLS;
    this.upClass = UPCLS;
  },
  allowedSortValues() {
    const types = [];
    const pushed = {};
    Meteor.user()
      .getListSortTypes()
      .forEach(type => {
        const key = type.replace(/^-/, '');
        if (pushed[key] === undefined) {
          types.push({
            name: key,
            label: `list-label-${key}`,
            shortLabel: `list-label-short-${key}`,
          });
          pushed[key] = 1;
        }
      });
    return types;
  },
  Direction() {
    return Meteor.user().getListSortByDirection() === -1
      ? this.downClass
      : this.upClass;
  },
  sortby() {
    return Meteor.user().getListSortBy();
  },

  setSortBy(type = null) {
    const user = Meteor.user();
    if (type === null) {
      type = user._getListSortBy();
    } else {
      let value = '';
      if (type.map) {
        // is an array
        value = (type[1] === -1 ? '-' : '') + type[0];
      }
      Meteor.call('setListSortBy', value);
    }
    //this.sortBy.set(type[0]);
    //this.sortDirection.set(type[1]);
  },

  events() {
    return [
      {
        'click .js-sort-by'(evt) {
          evt.preventDefault();
          const target = evt.target;
          const sortby = target.getAttribute('name');
          const down = !!target.querySelector(`.${this.upClass}`);
          const direction = down ? -1 : 1;
          this.setSortBy([sortby, direction]);
          if (Utils.isMiniScreen) {
            Popup.close();
          }
        },
      },
    ];
  },
}).register('listsortPopup');
*/
