// Copyright 2014 ISRG.  All rights reserved
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

package policy

// wget https://publicsuffix.org/list/effective_tld_names.dat
// cat effective_tld_names.dat | grep "^[a-zA-Z0-9.*]\+$" | sed -e 's/^\*\.//; s/^\(.*\)$/  "\1": true,/' | sort | pbcopy
var publicSuffixList = map[string]bool{
	"0.bg":                 true,
	"1.bg":                 true,
	"1kapp.com":            true,
	"2.bg":                 true,
	"2000.hu":              true,
	"3.bg":                 true,
	"4.bg":                 true,
	"5.bg":                 true,
	"6.bg":                 true,
	"7.bg":                 true,
	"8.bg":                 true,
	"9.bg":                 true,
	"a.bg":                 true,
	"a.prod.fastly.net":    true,
	"a.se":                 true,
	"a.ssl.fastly.net":     true,
	"aa.no":                true,
	"aarborte.no":          true,
	"ab.ca":                true,
	"abashiri.hokkaido.jp": true,
	"abb":                true,
	"abbott":             true,
	"abeno.osaka.jp":     true,
	"abiko.chiba.jp":     true,
	"abira.hokkaido.jp":  true,
	"abo.pa":             true,
	"abogado":            true,
	"abr.it":             true,
	"abruzzo.it":         true,
	"abu.yamaguchi.jp":   true,
	"ac":                 true,
	"ac.ae":              true,
	"ac.at":              true,
	"ac.be":              true,
	"ac.ci":              true,
	"ac.cn":              true,
	"ac.cr":              true,
	"ac.gn":              true,
	"ac.id":              true,
	"ac.im":              true,
	"ac.in":              true,
	"ac.ir":              true,
	"ac.jp":              true,
	"ac.kr":              true,
	"ac.ma":              true,
	"ac.me":              true,
	"ac.mu":              true,
	"ac.mw":              true,
	"ac.nz":              true,
	"ac.pa":              true,
	"ac.pr":              true,
	"ac.rs":              true,
	"ac.ru":              true,
	"ac.rw":              true,
	"ac.se":              true,
	"ac.sz":              true,
	"ac.th":              true,
	"ac.tj":              true,
	"ac.tz":              true,
	"ac.ug":              true,
	"ac.uk":              true,
	"ac.vn":              true,
	"aca.pro":            true,
	"academy":            true,
	"academy.museum":     true,
	"accenture":          true,
	"accountant":         true,
	"accountants":        true,
	"achi.nagano.jp":     true,
	"aco":                true,
	"act.au":             true,
	"act.edu.au":         true,
	"active":             true,
	"actor":              true,
	"ad":                 true,
	"ad.jp":              true,
	"adachi.tokyo.jp":    true,
	"adm.br":             true,
	"ads":                true,
	"adult":              true,
	"adult.ht":           true,
	"adv.br":             true,
	"adygeya.ru":         true,
	"adygeya.su":         true,
	"ae":                 true,
	"ae.org":             true,
	"aejrie.no":          true,
	"aero":               true,
	"aero.mv":            true,
	"aero.tt":            true,
	"aerobatic.aero":     true,
	"aeroclub.aero":      true,
	"aerodrome.aero":     true,
	"aeroport.fr":        true,
	"af":                 true,
	"afjord.no":          true,
	"afl":                true,
	"africa":             true,
	"africa.com":         true,
	"ag":                 true,
	"ag.it":              true,
	"aga.niigata.jp":     true,
	"agano.niigata.jp":   true,
	"agdenes.no":         true,
	"agematsu.nagano.jp": true,
	"agency":             true,
	"agents.aero":        true,
	"agr.br":             true,
	"agrar.hu":           true,
	"agriculture.museum": true,
	"agrigento.it":       true,
	"agrinet.tn":         true,
	"agro.pl":            true,
	"aguni.okinawa.jp":   true,
	"ah.cn":              true,
	"ah.no":              true,
	"ai":                 true,
	"aibetsu.hokkaido.jp":        true,
	"aichi.jp":                   true,
	"aid.pl":                     true,
	"aig":                        true,
	"aikawa.kanagawa.jp":         true,
	"ainan.ehime.jp":             true,
	"aioi.hyogo.jp":              true,
	"aip.ee":                     true,
	"air.museum":                 true,
	"aircraft.aero":              true,
	"airforce":                   true,
	"airguard.museum":            true,
	"airline.aero":               true,
	"airport.aero":               true,
	"airtel":                     true,
	"airtraffic.aero":            true,
	"aisai.aichi.jp":             true,
	"aisho.shiga.jp":             true,
	"aizubange.fukushima.jp":     true,
	"aizumi.tokushima.jp":        true,
	"aizumisato.fukushima.jp":    true,
	"aizuwakamatsu.fukushima.jp": true,
	"ak.us":                   true,
	"akabira.hokkaido.jp":     true,
	"akagi.shimane.jp":        true,
	"akaiwa.okayama.jp":       true,
	"akashi.hyogo.jp":         true,
	"aki.kochi.jp":            true,
	"akiruno.tokyo.jp":        true,
	"akishima.tokyo.jp":       true,
	"akita.akita.jp":          true,
	"akita.jp":                true,
	"akkeshi.hokkaido.jp":     true,
	"aknoluokta.no":           true,
	"ako.hyogo.jp":            true,
	"akrehamn.no":             true,
	"akune.kagoshima.jp":      true,
	"al":                      true,
	"al.it":                   true,
	"al.no":                   true,
	"al.us":                   true,
	"alabama.museum":          true,
	"alaheadju.no":            true,
	"aland.fi":                true,
	"alaska.museum":           true,
	"alessandria.it":          true,
	"alesund.no":              true,
	"algard.no":               true,
	"alibaba":                 true,
	"alipay":                  true,
	"allfinanz":               true,
	"alsace":                  true,
	"alstahaug.no":            true,
	"alta.no":                 true,
	"altai.ru":                true,
	"altoadige.it":            true,
	"alvdal.no":               true,
	"am":                      true,
	"am.br":                   true,
	"ama.aichi.jp":            true,
	"ama.shimane.jp":          true,
	"amagasaki.hyogo.jp":      true,
	"amakusa.kumamoto.jp":     true,
	"amami.kagoshima.jp":      true,
	"amber.museum":            true,
	"ambulance.aero":          true,
	"ambulance.museum":        true,
	"american.museum":         true,
	"americana.museum":        true,
	"americanantiques.museum": true,
	"americanart.museum":      true,
	"ami.ibaraki.jp":          true,
	"amli.no":                 true,
	"amot.no":                 true,
	"amsterdam":               true,
	"amsterdam.museum":        true,
	"amur.ru":                 true,
	"amursk.ru":               true,
	"amusement.aero":          true,
	"an":                      true,
	"an.it":                   true,
	"analytics":               true,
	"anamizu.ishikawa.jp":     true,
	"anan.nagano.jp":          true,
	"anan.tokushima.jp":       true,
	"ancona.it":               true,
	"and.museum":              true,
	"andasuolo.no":            true,
	"andebu.no":               true,
	"ando.nara.jp":            true,
	"andoy.no":                true,
	"andriabarlettatrani.it":  true,
	"andriatranibarletta.it":  true,
	"android":                 true,
	"anjo.aichi.jp":           true,
	"annaka.gunma.jp":         true,
	"annefrank.museum":        true,
	"anpachi.gifu.jp":         true,
	"anquan":                  true,
	"anthro.museum":           true,
	"anthropology.museum":     true,
	"antiques.museum":         true,
	"ao":                      true,
	"ao.it":                   true,
	"aogaki.hyogo.jp":         true,
	"aogashima.tokyo.jp":      true,
	"aoki.nagano.jp":          true,
	"aomori.aomori.jp":        true,
	"aomori.jp":               true,
	"aosta.it":                true,
	"aostavalley.it":          true,
	"aoste.it":                true,
	"ap.it":                   true,
	"apartments":              true,
	"appspot.com":             true,
	"aq":                      true,
	"aq.it":                   true,
	"aquarelle":               true,
	"aquarium.museum":         true,
	"aquila.it":               true,
	"ar":                      true,
	"ar.com":                  true,
	"ar.it":                   true,
	"ar.us":                   true,
	"arai.shizuoka.jp":        true,
	"arakawa.saitama.jp":      true,
	"arakawa.tokyo.jp":        true,
	"aramco":                  true,
	"arao.kumamoto.jp":        true,
	"arboretum.museum":        true,
	"archaeological.museum":   true,
	"archaeology.museum":      true,
	"archi":                   true,
	"architecture.museum":     true,
	"ardal.no":                true,
	"aremark.no":              true,
	"arendal.no":              true,
	"arezzo.it":               true,
	"ariake.saga.jp":          true,
	"arida.wakayama.jp":       true,
	"aridagawa.wakayama.jp":   true,
	"arita.saga.jp":           true,
	"arkhangelsk.ru":          true,
	"arkhangelsk.su":          true,
	"army":                    true,
	"arna.no":                 true,
	"arpa":                    true,
	"arq.br":                  true,
	"art.br":                  true,
	"art.do":                  true,
	"art.dz":                  true,
	"art.ht":                  true,
	"art.museum":              true,
	"art.pl":                  true,
	"art.sn":                  true,
	"artanddesign.museum":     true,
	"artcenter.museum":        true,
	"artdeco.museum":          true,
	"arte":                    true,
	"arteducation.museum":     true,
	"artgallery.museum":       true,
	"arts.co":                 true,
	"arts.museum":             true,
	"arts.nf":                 true,
	"arts.ro":                 true,
	"arts.ve":                 true,
	"artsandcrafts.museum":    true,
	"as":                               true,
	"as.us":                            true,
	"asago.hyogo.jp":                   true,
	"asahi.chiba.jp":                   true,
	"asahi.ibaraki.jp":                 true,
	"asahi.mie.jp":                     true,
	"asahi.nagano.jp":                  true,
	"asahi.toyama.jp":                  true,
	"asahi.yamagata.jp":                true,
	"asahikawa.hokkaido.jp":            true,
	"asaka.saitama.jp":                 true,
	"asakawa.fukushima.jp":             true,
	"asakuchi.okayama.jp":              true,
	"asaminami.hiroshima.jp":           true,
	"ascolipiceno.it":                  true,
	"aseral.no":                        true,
	"ashibetsu.hokkaido.jp":            true,
	"ashikaga.tochigi.jp":              true,
	"ashiya.fukuoka.jp":                true,
	"ashiya.hyogo.jp":                  true,
	"ashoro.hokkaido.jp":               true,
	"asia":                             true,
	"asker.no":                         true,
	"askim.no":                         true,
	"askoy.no":                         true,
	"askvoll.no":                       true,
	"asmatart.museum":                  true,
	"asn.au":                           true,
	"asn.lv":                           true,
	"asnes.no":                         true,
	"aso.kumamoto.jp":                  true,
	"ass.km":                           true,
	"assabu.hokkaido.jp":               true,
	"assassination.museum":             true,
	"assedic.fr":                       true,
	"assisi.museum":                    true,
	"assn.lk":                          true,
	"asso.bj":                          true,
	"asso.ci":                          true,
	"asso.dz":                          true,
	"asso.fr":                          true,
	"asso.gp":                          true,
	"asso.ht":                          true,
	"asso.km":                          true,
	"asso.mc":                          true,
	"asso.nc":                          true,
	"asso.re":                          true,
	"associates":                       true,
	"association.aero":                 true,
	"association.museum":               true,
	"asti.it":                          true,
	"astrakhan.ru":                     true,
	"astronomy.museum":                 true,
	"asuke.aichi.jp":                   true,
	"at":                               true,
	"at.it":                            true,
	"atami.shizuoka.jp":                true,
	"ath.cx":                           true,
	"atlanta.museum":                   true,
	"atm.pl":                           true,
	"ato.br":                           true,
	"atsugi.kanagawa.jp":               true,
	"atsuma.hokkaido.jp":               true,
	"attorney":                         true,
	"au":                               true,
	"auction":                          true,
	"audio":                            true,
	"audnedaln.no":                     true,
	"augustow.pl":                      true,
	"aukra.no":                         true,
	"aure.no":                          true,
	"aurland.no":                       true,
	"austevoll.no":                     true,
	"austin.museum":                    true,
	"australia.museum":                 true,
	"austrheim.no":                     true,
	"author":                           true,
	"author.aero":                      true,
	"auto":                             true,
	"auto.pl":                          true,
	"automotive.museum":                true,
	"autos":                            true,
	"av.it":                            true,
	"av.tr":                            true,
	"avellino.it":                      true,
	"averoy.no":                        true,
	"avianca":                          true,
	"aviation.museum":                  true,
	"avocat.fr":                        true,
	"avoues.fr":                        true,
	"aw":                               true,
	"awaji.hyogo.jp":                   true,
	"ax":                               true,
	"axa":                              true,
	"axis.museum":                      true,
	"aya.miyazaki.jp":                  true,
	"ayabe.kyoto.jp":                   true,
	"ayagawa.kagawa.jp":                true,
	"ayase.kanagawa.jp":                true,
	"az":                               true,
	"az.us":                            true,
	"azumino.nagano.jp":                true,
	"azure":                            true,
	"azurewebsites.net":                true,
	"b.bg":                             true,
	"b.br":                             true,
	"b.se":                             true,
	"b.ssl.fastly.net":                 true,
	"ba":                               true,
	"ba.it":                            true,
	"badaddja.no":                      true,
	"badajoz.museum":                   true,
	"baghdad.museum":                   true,
	"bahcavuotna.no":                   true,
	"bahccavuotna.no":                  true,
	"bahn.museum":                      true,
	"baidar.no":                        true,
	"baidu":                            true,
	"baikal.ru":                        true,
	"bajddar.no":                       true,
	"balashov.su":                      true,
	"balat.no":                         true,
	"bale.museum":                      true,
	"balestrand.no":                    true,
	"ballangen.no":                     true,
	"ballooning.aero":                  true,
	"balsan.it":                        true,
	"balsfjord.no":                     true,
	"baltimore.museum":                 true,
	"bamble.no":                        true,
	"band":                             true,
	"bandai.fukushima.jp":              true,
	"bando.ibaraki.jp":                 true,
	"bank":                             true,
	"bar":                              true,
	"bar.pro":                          true,
	"barcelona":                        true,
	"barcelona.museum":                 true,
	"barclaycard":                      true,
	"barclays":                         true,
	"bardu.no":                         true,
	"bargains":                         true,
	"bari.it":                          true,
	"barlettatraniandria.it":           true,
	"barreau.bj":                       true,
	"barum.no":                         true,
	"bas.it":                           true,
	"baseball.museum":                  true,
	"basel.museum":                     true,
	"bashkiria.ru":                     true,
	"bashkiria.su":                     true,
	"basilicata.it":                    true,
	"baths.museum":                     true,
	"bato.tochigi.jp":                  true,
	"batsfjord.no":                     true,
	"bauern.museum":                    true,
	"bauhaus":                          true,
	"bayern":                           true,
	"bb":                               true,
	"bbc":                              true,
	"bbs.tr":                           true,
	"bbva":                             true,
	"bc.ca":                            true,
	"bcn":                              true,
	"bd":                               true,
	"bd.se":                            true,
	"be":                               true,
	"bearalvahki.no":                   true,
	"beardu.no":                        true,
	"beauxarts.museum":                 true,
	"bedzin.pl":                        true,
	"beeldengeluid.museum":             true,
	"beer":                             true,
	"beiarn.no":                        true,
	"bel.tr":                           true,
	"belau.pw":                         true,
	"belgorod.ru":                      true,
	"bellevue.museum":                  true,
	"belluno.it":                       true,
	"benevento.it":                     true,
	"bentley":                          true,
	"beppu.oita.jp":                    true,
	"berg.no":                          true,
	"bergamo.it":                       true,
	"bergbau.museum":                   true,
	"bergen.no":                        true,
	"berkeley.museum":                  true,
	"berlevag.no":                      true,
	"berlin":                           true,
	"berlin.museum":                    true,
	"bern.museum":                      true,
	"beskidy.pl":                       true,
	"best":                             true,
	"betainabox.com":                   true,
	"bf":                               true,
	"bg":                               true,
	"bg.it":                            true,
	"bh":                               true,
	"bharti":                           true,
	"bi":                               true,
	"bi.it":                            true,
	"bialowieza.pl":                    true,
	"bialystok.pl":                     true,
	"bibai.hokkaido.jp":                true,
	"bible":                            true,
	"bible.museum":                     true,
	"bid":                              true,
	"biei.hokkaido.jp":                 true,
	"bielawa.pl":                       true,
	"biella.it":                        true,
	"bieszczady.pl":                    true,
	"bievat.no":                        true,
	"bifuka.hokkaido.jp":               true,
	"bihoro.hokkaido.jp":               true,
	"bike":                             true,
	"bilbao.museum":                    true,
	"bill.museum":                      true,
	"bindal.no":                        true,
	"bing":                             true,
	"bingo":                            true,
	"bio":                              true,
	"bio.br":                           true,
	"bir.ru":                           true,
	"biratori.hokkaido.jp":             true,
	"birdart.museum":                   true,
	"birkenes.no":                      true,
	"birthplace.museum":                true,
	"biz":                              true,
	"biz.at":                           true,
	"biz.az":                           true,
	"biz.bb":                           true,
	"biz.et":                           true,
	"biz.id":                           true,
	"biz.ki":                           true,
	"biz.mv":                           true,
	"biz.mw":                           true,
	"biz.nr":                           true,
	"biz.pk":                           true,
	"biz.pl":                           true,
	"biz.pr":                           true,
	"biz.tj":                           true,
	"biz.tr":                           true,
	"biz.tt":                           true,
	"biz.vn":                           true,
	"bizen.okayama.jp":                 true,
	"bj":                               true,
	"bj.cn":                            true,
	"bjarkoy.no":                       true,
	"bjerkreim.no":                     true,
	"bjugn.no":                         true,
	"bl.it":                            true,
	"black":                            true,
	"blackfriday":                      true,
	"blog.br":                          true,
	"blogdns.com":                      true,
	"blogdns.net":                      true,
	"blogdns.org":                      true,
	"blogsite.org":                     true,
	"blogspot.ae":                      true,
	"blogspot.be":                      true,
	"blogspot.bj":                      true,
	"blogspot.ca":                      true,
	"blogspot.cf":                      true,
	"blogspot.ch":                      true,
	"blogspot.co.at":                   true,
	"blogspot.co.il":                   true,
	"blogspot.co.nz":                   true,
	"blogspot.co.uk":                   true,
	"blogspot.com":                     true,
	"blogspot.com.ar":                  true,
	"blogspot.com.au":                  true,
	"blogspot.com.br":                  true,
	"blogspot.com.es":                  true,
	"blogspot.com.tr":                  true,
	"blogspot.cv":                      true,
	"blogspot.cz":                      true,
	"blogspot.de":                      true,
	"blogspot.dk":                      true,
	"blogspot.fi":                      true,
	"blogspot.fr":                      true,
	"blogspot.gr":                      true,
	"blogspot.hk":                      true,
	"blogspot.hu":                      true,
	"blogspot.ie":                      true,
	"blogspot.in":                      true,
	"blogspot.it":                      true,
	"blogspot.jp":                      true,
	"blogspot.kr":                      true,
	"blogspot.mr":                      true,
	"blogspot.mx":                      true,
	"blogspot.nl":                      true,
	"blogspot.no":                      true,
	"blogspot.pt":                      true,
	"blogspot.re":                      true,
	"blogspot.ro":                      true,
	"blogspot.ru":                      true,
	"blogspot.se":                      true,
	"blogspot.sg":                      true,
	"blogspot.sk":                      true,
	"blogspot.td":                      true,
	"blogspot.tw":                      true,
	"bloomberg":                        true,
	"blue":                             true,
	"bm":                               true,
	"bmd.br":                           true,
	"bms":                              true,
	"bmw":                              true,
	"bn":                               true,
	"bn.it":                            true,
	"bnl":                              true,
	"bnpparibas":                       true,
	"bo":                               true,
	"bo.it":                            true,
	"bo.nordland.no":                   true,
	"bo.telemark.no":                   true,
	"boats":                            true,
	"bodo.no":                          true,
	"bokn.no":                          true,
	"boldlygoingnowhere.org":           true,
	"boleslawiec.pl":                   true,
	"bologna.it":                       true,
	"bolt.hu":                          true,
	"bolzano.it":                       true,
	"bom":                              true,
	"bomlo.no":                         true,
	"bond":                             true,
	"bonn.museum":                      true,
	"boo":                              true,
	"boots":                            true,
	"boston.museum":                    true,
	"bot":                              true,
	"botanical.museum":                 true,
	"botanicalgarden.museum":           true,
	"botanicgarden.museum":             true,
	"botany.museum":                    true,
	"boutique":                         true,
	"bozen.it":                         true,
	"br":                               true,
	"br.com":                           true,
	"br.it":                            true,
	"bradesco":                         true,
	"brand.se":                         true,
	"brandywinevalley.museum":          true,
	"brasil.museum":                    true,
	"bremanger.no":                     true,
	"brescia.it":                       true,
	"bridgestone":                      true,
	"brindisi.it":                      true,
	"bristol.museum":                   true,
	"british.museum":                   true,
	"britishcolumbia.museum":           true,
	"broadcast.museum":                 true,
	"broadway":                         true,
	"broker":                           true,
	"broker.aero":                      true,
	"bronnoy.no":                       true,
	"bronnoysund.no":                   true,
	"brumunddal.no":                    true,
	"brunel.museum":                    true,
	"brussel.museum":                   true,
	"brussels":                         true,
	"brussels.museum":                  true,
	"bruxelles.museum":                 true,
	"bryansk.ru":                       true,
	"bryansk.su":                       true,
	"bryne.no":                         true,
	"bs":                               true,
	"bs.it":                            true,
	"bt":                               true,
	"bt.it":                            true,
	"bu.no":                            true,
	"budapest":                         true,
	"budejju.no":                       true,
	"build":                            true,
	"builders":                         true,
	"building.museum":                  true,
	"bungoono.oita.jp":                 true,
	"bungotakada.oita.jp":              true,
	"bunkyo.tokyo.jp":                  true,
	"burghof.museum":                   true,
	"buryatia.ru":                      true,
	"bus.museum":                       true,
	"busan.kr":                         true,
	"bushey.museum":                    true,
	"business":                         true,
	"buy":                              true,
	"buyshouses.net":                   true,
	"buzen.fukuoka.jp":                 true,
	"buzz":                             true,
	"bv":                               true,
	"bv.nl":                            true,
	"bw":                               true,
	"by":                               true,
	"bydgoszcz.pl":                     true,
	"bygland.no":                       true,
	"bykle.no":                         true,
	"bytom.pl":                         true,
	"bz":                               true,
	"bz.it":                            true,
	"bzh":                              true,
	"c.bg":                             true,
	"c.la":                             true,
	"c.se":                             true,
	"ca":                               true,
	"ca.it":                            true,
	"ca.na":                            true,
	"ca.us":                            true,
	"caa.aero":                         true,
	"cab":                              true,
	"cadaques.museum":                  true,
	"cagliari.it":                      true,
	"cahcesuolo.no":                    true,
	"cal":                              true,
	"cal.it":                           true,
	"calabria.it":                      true,
	"california.museum":                true,
	"call":                             true,
	"caltanissetta.it":                 true,
	"cam.it":                           true,
	"cambridge.museum":                 true,
	"camera":                           true,
	"camp":                             true,
	"campania.it":                      true,
	"campidanomedio.it":                true,
	"campobasso.it":                    true,
	"can.museum":                       true,
	"canada.museum":                    true,
	"cancerresearch":                   true,
	"canon":                            true,
	"capebreton.museum":                true,
	"capetown":                         true,
	"capital":                          true,
	"car":                              true,
	"caravan":                          true,
	"carboniaiglesias.it":              true,
	"cards":                            true,
	"care":                             true,
	"career":                           true,
	"careers":                          true,
	"cargo.aero":                       true,
	"carraramassa.it":                  true,
	"carrier.museum":                   true,
	"cars":                             true,
	"cartier":                          true,
	"cartoonart.museum":                true,
	"casa":                             true,
	"casadelamoneda.museum":            true,
	"caserta.it":                       true,
	"cash":                             true,
	"casino":                           true,
	"casino.hu":                        true,
	"castle.museum":                    true,
	"castres.museum":                   true,
	"cat":                              true,
	"catania.it":                       true,
	"catanzaro.it":                     true,
	"catering":                         true,
	"catering.aero":                    true,
	"cb.it":                            true,
	"cba":                              true,
	"cbg.ru":                           true,
	"cbn":                              true,
	"cc":                               true,
	"cc.ak.us":                         true,
	"cc.al.us":                         true,
	"cc.ar.us":                         true,
	"cc.as.us":                         true,
	"cc.az.us":                         true,
	"cc.ca.us":                         true,
	"cc.co.us":                         true,
	"cc.ct.us":                         true,
	"cc.dc.us":                         true,
	"cc.de.us":                         true,
	"cc.fl.us":                         true,
	"cc.ga.us":                         true,
	"cc.gu.us":                         true,
	"cc.hi.us":                         true,
	"cc.ia.us":                         true,
	"cc.id.us":                         true,
	"cc.il.us":                         true,
	"cc.in.us":                         true,
	"cc.ks.us":                         true,
	"cc.ky.us":                         true,
	"cc.la.us":                         true,
	"cc.ma.us":                         true,
	"cc.md.us":                         true,
	"cc.me.us":                         true,
	"cc.mi.us":                         true,
	"cc.mn.us":                         true,
	"cc.mo.us":                         true,
	"cc.ms.us":                         true,
	"cc.mt.us":                         true,
	"cc.na":                            true,
	"cc.nc.us":                         true,
	"cc.nd.us":                         true,
	"cc.ne.us":                         true,
	"cc.nh.us":                         true,
	"cc.nj.us":                         true,
	"cc.nm.us":                         true,
	"cc.nv.us":                         true,
	"cc.ny.us":                         true,
	"cc.oh.us":                         true,
	"cc.ok.us":                         true,
	"cc.or.us":                         true,
	"cc.pa.us":                         true,
	"cc.pr.us":                         true,
	"cc.ri.us":                         true,
	"cc.sc.us":                         true,
	"cc.sd.us":                         true,
	"cc.tn.us":                         true,
	"cc.tx.us":                         true,
	"cc.ut.us":                         true,
	"cc.va.us":                         true,
	"cc.vi.us":                         true,
	"cc.vt.us":                         true,
	"cc.wa.us":                         true,
	"cc.wi.us":                         true,
	"cc.wv.us":                         true,
	"cc.wy.us":                         true,
	"cci.fr":                           true,
	"cd":                               true,
	"ce.it":                            true,
	"cechire.com":                      true,
	"celtic.museum":                    true,
	"center":                           true,
	"center.museum":                    true,
	"ceo":                              true,
	"cern":                             true,
	"certification.aero":               true,
	"cesenaforli.it":                   true,
	"cf":                               true,
	"cfa":                              true,
	"cfd":                              true,
	"cg":                               true,
	"ch":                               true,
	"ch.it":                            true,
	"chambagri.fr":                     true,
	"championship.aero":                true,
	"channel":                          true,
	"charter.aero":                     true,
	"chat":                             true,
	"chattanooga.museum":               true,
	"cheap":                            true,
	"chel.ru":                          true,
	"cheltenham.museum":                true,
	"chelyabinsk.ru":                   true,
	"cherkassy.ua":                     true,
	"cherkasy.ua":                      true,
	"chernigov.ua":                     true,
	"chernihiv.ua":                     true,
	"chernivtsi.ua":                    true,
	"chernovtsy.ua":                    true,
	"chesapeakebay.museum":             true,
	"chiba.jp":                         true,
	"chicago.museum":                   true,
	"chichibu.saitama.jp":              true,
	"chieti.it":                        true,
	"chigasaki.kanagawa.jp":            true,
	"chihayaakasaka.osaka.jp":          true,
	"chijiwa.nagasaki.jp":              true,
	"chikugo.fukuoka.jp":               true,
	"chikuho.fukuoka.jp":               true,
	"chikuhoku.nagano.jp":              true,
	"chikujo.fukuoka.jp":               true,
	"chikuma.nagano.jp":                true,
	"chikusei.ibaraki.jp":              true,
	"chikushino.fukuoka.jp":            true,
	"chikuzen.fukuoka.jp":              true,
	"children.museum":                  true,
	"childrens.museum":                 true,
	"childrensgarden.museum":           true,
	"chino.nagano.jp":                  true,
	"chippubetsu.hokkaido.jp":          true,
	"chiropractic.museum":              true,
	"chiryu.aichi.jp":                  true,
	"chita.aichi.jp":                   true,
	"chita.ru":                         true,
	"chitose.hokkaido.jp":              true,
	"chiyoda.gunma.jp":                 true,
	"chiyoda.tokyo.jp":                 true,
	"chizu.tottori.jp":                 true,
	"chloe":                            true,
	"chocolate.museum":                 true,
	"chofu.tokyo.jp":                   true,
	"chonan.chiba.jp":                  true,
	"chosei.chiba.jp":                  true,
	"choshi.chiba.jp":                  true,
	"choyo.kumamoto.jp":                true,
	"christiansburg.museum":            true,
	"christmas":                        true,
	"chrome":                           true,
	"chtr.k12.ma.us":                   true,
	"chukotka.ru":                      true,
	"chungbuk.kr":                      true,
	"chungnam.kr":                      true,
	"chuo.chiba.jp":                    true,
	"chuo.fukuoka.jp":                  true,
	"chuo.osaka.jp":                    true,
	"chuo.tokyo.jp":                    true,
	"chuo.yamanashi.jp":                true,
	"church":                           true,
	"chuvashia.ru":                     true,
	"ci":                               true,
	"ci.it":                            true,
	"cieszyn.pl":                       true,
	"cim.br":                           true,
	"cincinnati.museum":                true,
	"cinema.museum":                    true,
	"circle":                           true,
	"circus.museum":                    true,
	"cisco":                            true,
	"citic":                            true,
	"city":                             true,
	"city.hu":                          true,
	"cityeats":                         true,
	"civilaviation.aero":               true,
	"civilisation.museum":              true,
	"civilization.museum":              true,
	"civilwar.museum":                  true,
	"ck":                               true,
	"ck.ua":                            true,
	"cl":                               true,
	"cl.it":                            true,
	"claims":                           true,
	"cleaning":                         true,
	"click":                            true,
	"clinic":                           true,
	"clinton.museum":                   true,
	"clock.museum":                     true,
	"clothing":                         true,
	"cloudapp.net":                     true,
	"cloudcontrolapp.com":              true,
	"cloudcontrolled.com":              true,
	"cloudfront.net":                   true,
	"club":                             true,
	"club.aero":                        true,
	"club.tw":                          true,
	"cm":                               true,
	"cmw.ru":                           true,
	"cn":                               true,
	"cn.com":                           true,
	"cn.it":                            true,
	"cn.ua":                            true,
	"cng.br":                           true,
	"cnt.br":                           true,
	"co":                               true,
	"co.ae":                            true,
	"co.ag":                            true,
	"co.ao":                            true,
	"co.at":                            true,
	"co.ba":                            true,
	"co.bb":                            true,
	"co.bi":                            true,
	"co.bw":                            true,
	"co.ca":                            true,
	"co.ci":                            true,
	"co.cl":                            true,
	"co.cm":                            true,
	"co.com":                           true,
	"co.cr":                            true,
	"co.gg":                            true,
	"co.gy":                            true,
	"co.hu":                            true,
	"co.id":                            true,
	"co.im":                            true,
	"co.in":                            true,
	"co.ir":                            true,
	"co.it":                            true,
	"co.je":                            true,
	"co.jp":                            true,
	"co.kr":                            true,
	"co.lc":                            true,
	"co.ls":                            true,
	"co.ma":                            true,
	"co.me":                            true,
	"co.mu":                            true,
	"co.mw":                            true,
	"co.na":                            true,
	"co.nl":                            true,
	"co.no":                            true,
	"co.nz":                            true,
	"co.om":                            true,
	"co.pl":                            true,
	"co.pn":                            true,
	"co.pw":                            true,
	"co.rs":                            true,
	"co.rw":                            true,
	"co.st":                            true,
	"co.sz":                            true,
	"co.th":                            true,
	"co.tj":                            true,
	"co.tm":                            true,
	"co.tt":                            true,
	"co.tz":                            true,
	"co.ua":                            true,
	"co.ug":                            true,
	"co.uk":                            true,
	"co.us":                            true,
	"co.uz":                            true,
	"co.ve":                            true,
	"co.vi":                            true,
	"coach":                            true,
	"coal.museum":                      true,
	"coastaldefence.museum":            true,
	"codes":                            true,
	"codespot.com":                     true,
	"cody.museum":                      true,
	"coffee":                           true,
	"coldwar.museum":                   true,
	"collection.museum":                true,
	"college":                          true,
	"cologne":                          true,
	"colonialwilliamsburg.museum":      true,
	"coloradoplateau.museum":           true,
	"columbia.museum":                  true,
	"columbus.museum":                  true,
	"com":                              true,
	"com.ac":                           true,
	"com.af":                           true,
	"com.ag":                           true,
	"com.ai":                           true,
	"com.al":                           true,
	"com.an":                           true,
	"com.ar":                           true,
	"com.au":                           true,
	"com.aw":                           true,
	"com.az":                           true,
	"com.ba":                           true,
	"com.bb":                           true,
	"com.bh":                           true,
	"com.bi":                           true,
	"com.bm":                           true,
	"com.bo":                           true,
	"com.br":                           true,
	"com.bs":                           true,
	"com.bt":                           true,
	"com.by":                           true,
	"com.bz":                           true,
	"com.ci":                           true,
	"com.cm":                           true,
	"com.cn":                           true,
	"com.co":                           true,
	"com.cu":                           true,
	"com.cw":                           true,
	"com.de":                           true,
	"com.dm":                           true,
	"com.do":                           true,
	"com.dz":                           true,
	"com.ec":                           true,
	"com.ee":                           true,
	"com.eg":                           true,
	"com.es":                           true,
	"com.et":                           true,
	"com.fr":                           true,
	"com.ge":                           true,
	"com.gh":                           true,
	"com.gi":                           true,
	"com.gn":                           true,
	"com.gp":                           true,
	"com.gr":                           true,
	"com.gt":                           true,
	"com.gy":                           true,
	"com.hk":                           true,
	"com.hn":                           true,
	"com.hr":                           true,
	"com.ht":                           true,
	"com.im":                           true,
	"com.io":                           true,
	"com.iq":                           true,
	"com.is":                           true,
	"com.jo":                           true,
	"com.kg":                           true,
	"com.ki":                           true,
	"com.km":                           true,
	"com.kp":                           true,
	"com.ky":                           true,
	"com.kz":                           true,
	"com.la":                           true,
	"com.lb":                           true,
	"com.lc":                           true,
	"com.lk":                           true,
	"com.lr":                           true,
	"com.lv":                           true,
	"com.ly":                           true,
	"com.mg":                           true,
	"com.mk":                           true,
	"com.ml":                           true,
	"com.mo":                           true,
	"com.ms":                           true,
	"com.mt":                           true,
	"com.mu":                           true,
	"com.mv":                           true,
	"com.mw":                           true,
	"com.mx":                           true,
	"com.my":                           true,
	"com.na":                           true,
	"com.nf":                           true,
	"com.ng":                           true,
	"com.nr":                           true,
	"com.om":                           true,
	"com.pa":                           true,
	"com.pe":                           true,
	"com.pf":                           true,
	"com.ph":                           true,
	"com.pk":                           true,
	"com.pl":                           true,
	"com.pr":                           true,
	"com.ps":                           true,
	"com.pt":                           true,
	"com.py":                           true,
	"com.qa":                           true,
	"com.re":                           true,
	"com.ro":                           true,
	"com.ru":                           true,
	"com.rw":                           true,
	"com.sa":                           true,
	"com.sb":                           true,
	"com.sc":                           true,
	"com.sd":                           true,
	"com.se":                           true,
	"com.sg":                           true,
	"com.sh":                           true,
	"com.sl":                           true,
	"com.sn":                           true,
	"com.so":                           true,
	"com.st":                           true,
	"com.sv":                           true,
	"com.sy":                           true,
	"com.tj":                           true,
	"com.tm":                           true,
	"com.tn":                           true,
	"com.to":                           true,
	"com.tr":                           true,
	"com.tt":                           true,
	"com.tw":                           true,
	"com.ua":                           true,
	"com.ug":                           true,
	"com.uy":                           true,
	"com.uz":                           true,
	"com.vc":                           true,
	"com.ve":                           true,
	"com.vi":                           true,
	"com.vn":                           true,
	"com.vu":                           true,
	"com.ws":                           true,
	"commbank":                         true,
	"communication.museum":             true,
	"communications.museum":            true,
	"community":                        true,
	"community.museum":                 true,
	"como.it":                          true,
	"company":                          true,
	"compute.amazonaws.cn":             true,
	"compute.amazonaws.com":            true,
	"computer":                         true,
	"computer.museum":                  true,
	"computerhistory.museum":           true,
	"comsec":                           true,
	"condos":                           true,
	"conf.au":                          true,
	"conf.lv":                          true,
	"conference.aero":                  true,
	"construction":                     true,
	"consulado.st":                     true,
	"consultant.aero":                  true,
	"consulting":                       true,
	"consulting.aero":                  true,
	"contact":                          true,
	"contemporary.museum":              true,
	"contemporaryart.museum":           true,
	"contractors":                      true,
	"control.aero":                     true,
	"convent.museum":                   true,
	"cooking":                          true,
	"cool":                             true,
	"coop":                             true,
	"coop.br":                          true,
	"coop.ht":                          true,
	"coop.km":                          true,
	"coop.mv":                          true,
	"coop.mw":                          true,
	"coop.py":                          true,
	"coop.tt":                          true,
	"copenhagen.museum":                true,
	"corporation.museum":               true,
	"corsica":                          true,
	"corvette.museum":                  true,
	"cosenza.it":                       true,
	"costume.museum":                   true,
	"council.aero":                     true,
	"country":                          true,
	"countryestate.museum":             true,
	"county.museum":                    true,
	"courses":                          true,
	"cpa.pro":                          true,
	"cq.cn":                            true,
	"cr":                               true,
	"cr.it":                            true,
	"cr.ua":                            true,
	"crafts.museum":                    true,
	"cranbrook.museum":                 true,
	"creation.museum":                  true,
	"credit":                           true,
	"creditcard":                       true,
	"creditunion":                      true,
	"cremona.it":                       true,
	"crew.aero":                        true,
	"cri.nz":                           true,
	"cricket":                          true,
	"crimea.ua":                        true,
	"crotone.it":                       true,
	"crown":                            true,
	"crs":                              true,
	"cruises":                          true,
	"cs.it":                            true,
	"csc":                              true,
	"ct.it":                            true,
	"ct.us":                            true,
	"cu":                               true,
	"cuisinella":                       true,
	"cultural.museum":                  true,
	"culturalcenter.museum":            true,
	"culture.museum":                   true,
	"cuneo.it":                         true,
	"cupcake.is":                       true,
	"cv":                               true,
	"cv.ua":                            true,
	"cw":                               true,
	"cx":                               true,
	"cy":                               true,
	"cyber.museum":                     true,
	"cymru":                            true,
	"cymru.museum":                     true,
	"cyou":                             true,
	"cz":                               true,
	"cz.it":                            true,
	"czeladz.pl":                       true,
	"czest.pl":                         true,
	"d.bg":                             true,
	"d.se":                             true,
	"dabur":                            true,
	"dad":                              true,
	"daegu.kr":                         true,
	"daejeon.kr":                       true,
	"dagestan.ru":                      true,
	"dagestan.su":                      true,
	"daigo.ibaraki.jp":                 true,
	"daisen.akita.jp":                  true,
	"daito.osaka.jp":                   true,
	"daiwa.hiroshima.jp":               true,
	"dali.museum":                      true,
	"dallas.museum":                    true,
	"dance":                            true,
	"database.museum":                  true,
	"date":                             true,
	"date.fukushima.jp":                true,
	"date.hokkaido.jp":                 true,
	"dating":                           true,
	"datsun":                           true,
	"davvenjarga.no":                   true,
	"davvesiida.no":                    true,
	"day":                              true,
	"dazaifu.fukuoka.jp":               true,
	"dc.us":                            true,
	"dclk":                             true,
	"ddr.museum":                       true,
	"de":                               true,
	"de.com":                           true,
	"de.us":                            true,
	"dealer":                           true,
	"deals":                            true,
	"deatnu.no":                        true,
	"decorativearts.museum":            true,
	"defense.tn":                       true,
	"degree":                           true,
	"delaware.museum":                  true,
	"delivery":                         true,
	"dell":                             true,
	"dellogliastra.it":                 true,
	"delmenhorst.museum":               true,
	"democrat":                         true,
	"denmark.museum":                   true,
	"dental":                           true,
	"dentist":                          true,
	"dep.no":                           true,
	"depot.museum":                     true,
	"desa.id":                          true,
	"desi":                             true,
	"design":                           true,
	"design.aero":                      true,
	"design.museum":                    true,
	"detroit.museum":                   true,
	"dev":                              true,
	"dgca.aero":                        true,
	"diamonds":                         true,
	"dielddanuorri.no":                 true,
	"diet":                             true,
	"digital":                          true,
	"dinosaur.museum":                  true,
	"direct":                           true,
	"directory":                        true,
	"discount":                         true,
	"discovery.museum":                 true,
	"divtasvuodna.no":                  true,
	"divttasvuotna.no":                 true,
	"dj":                               true,
	"dk":                               true,
	"dlugoleka.pl":                     true,
	"dm":                               true,
	"dn.ua":                            true,
	"dnepropetrovsk.ua":                true,
	"dni.us":                           true,
	"dnipropetrovsk.ua":                true,
	"dnp":                              true,
	"dnsalias.com":                     true,
	"dnsalias.net":                     true,
	"dnsalias.org":                     true,
	"dnsdojo.com":                      true,
	"dnsdojo.net":                      true,
	"dnsdojo.org":                      true,
	"do":                               true,
	"docs":                             true,
	"doesntexist.com":                  true,
	"doesntexist.org":                  true,
	"dog":                              true,
	"doha":                             true,
	"dolls.museum":                     true,
	"domains":                          true,
	"dominic.ua":                       true,
	"donetsk.ua":                       true,
	"donna.no":                         true,
	"donostia.museum":                  true,
	"dontexist.com":                    true,
	"dontexist.net":                    true,
	"dontexist.org":                    true,
	"doomdns.com":                      true,
	"doomdns.org":                      true,
	"doosan":                           true,
	"doshi.yamanashi.jp":               true,
	"dovre.no":                         true,
	"download":                         true,
	"dp.ua":                            true,
	"dr.na":                            true,
	"dr.tr":                            true,
	"drammen.no":                       true,
	"drangedal.no":                     true,
	"dreamhosters.com":                 true,
	"drobak.no":                        true,
	"dubai":                            true,
	"dudinka.ru":                       true,
	"durban":                           true,
	"durham.museum":                    true,
	"dvag":                             true,
	"dvrdns.org":                       true,
	"dynalias.com":                     true,
	"dynalias.net":                     true,
	"dynalias.org":                     true,
	"dynathome.net":                    true,
	"dyndns.biz":                       true,
	"dyndns.info":                      true,
	"dyndns.org":                       true,
	"dyndns.tv":                        true,
	"dyndns.ws":                        true,
	"dyroy.no":                         true,
	"dz":                               true,
	"e.bg":                             true,
	"e.se":                             true,
	"e12.ve":                           true,
	"e164.arpa":                        true,
	"earth":                            true,
	"eastafrica.museum":                true,
	"eastcoast.museum":                 true,
	"eat":                              true,
	"ebetsu.hokkaido.jp":               true,
	"ebina.kanagawa.jp":                true,
	"ebino.miyazaki.jp":                true,
	"ebiz.tw":                          true,
	"ec":                               true,
	"echizen.fukui.jp":                 true,
	"ecn.br":                           true,
	"eco.br":                           true,
	"ed.ao":                            true,
	"ed.ci":                            true,
	"ed.cr":                            true,
	"ed.jp":                            true,
	"ed.pw":                            true,
	"edeka":                            true,
	"edogawa.tokyo.jp":                 true,
	"edu":                              true,
	"edu.ac":                           true,
	"edu.af":                           true,
	"edu.al":                           true,
	"edu.an":                           true,
	"edu.ar":                           true,
	"edu.au":                           true,
	"edu.az":                           true,
	"edu.ba":                           true,
	"edu.bb":                           true,
	"edu.bh":                           true,
	"edu.bi":                           true,
	"edu.bm":                           true,
	"edu.bo":                           true,
	"edu.br":                           true,
	"edu.bs":                           true,
	"edu.bt":                           true,
	"edu.bz":                           true,
	"edu.ci":                           true,
	"edu.cn":                           true,
	"edu.co":                           true,
	"edu.cu":                           true,
	"edu.cw":                           true,
	"edu.dm":                           true,
	"edu.do":                           true,
	"edu.dz":                           true,
	"edu.ec":                           true,
	"edu.ee":                           true,
	"edu.eg":                           true,
	"edu.es":                           true,
	"edu.et":                           true,
	"edu.ge":                           true,
	"edu.gh":                           true,
	"edu.gi":                           true,
	"edu.gn":                           true,
	"edu.gp":                           true,
	"edu.gr":                           true,
	"edu.gt":                           true,
	"edu.hk":                           true,
	"edu.hn":                           true,
	"edu.ht":                           true,
	"edu.in":                           true,
	"edu.iq":                           true,
	"edu.is":                           true,
	"edu.it":                           true,
	"edu.jo":                           true,
	"edu.kg":                           true,
	"edu.ki":                           true,
	"edu.km":                           true,
	"edu.kn":                           true,
	"edu.kp":                           true,
	"edu.ky":                           true,
	"edu.kz":                           true,
	"edu.la":                           true,
	"edu.lb":                           true,
	"edu.lc":                           true,
	"edu.lk":                           true,
	"edu.lr":                           true,
	"edu.lv":                           true,
	"edu.ly":                           true,
	"edu.me":                           true,
	"edu.mg":                           true,
	"edu.mk":                           true,
	"edu.ml":                           true,
	"edu.mn":                           true,
	"edu.mo":                           true,
	"edu.ms":                           true,
	"edu.mt":                           true,
	"edu.mv":                           true,
	"edu.mw":                           true,
	"edu.mx":                           true,
	"edu.my":                           true,
	"edu.ng":                           true,
	"edu.nr":                           true,
	"edu.om":                           true,
	"edu.pa":                           true,
	"edu.pe":                           true,
	"edu.pf":                           true,
	"edu.ph":                           true,
	"edu.pk":                           true,
	"edu.pl":                           true,
	"edu.pn":                           true,
	"edu.pr":                           true,
	"edu.ps":                           true,
	"edu.pt":                           true,
	"edu.py":                           true,
	"edu.qa":                           true,
	"edu.rs":                           true,
	"edu.ru":                           true,
	"edu.rw":                           true,
	"edu.sa":                           true,
	"edu.sb":                           true,
	"edu.sc":                           true,
	"edu.sd":                           true,
	"edu.sg":                           true,
	"edu.sl":                           true,
	"edu.sn":                           true,
	"edu.st":                           true,
	"edu.sv":                           true,
	"edu.sy":                           true,
	"edu.tj":                           true,
	"edu.tm":                           true,
	"edu.to":                           true,
	"edu.tr":                           true,
	"edu.tt":                           true,
	"edu.tw":                           true,
	"edu.ua":                           true,
	"edu.uy":                           true,
	"edu.vc":                           true,
	"edu.ve":                           true,
	"edu.vn":                           true,
	"edu.vu":                           true,
	"edu.ws":                           true,
	"education":                        true,
	"education.museum":                 true,
	"educational.museum":               true,
	"educator.aero":                    true,
	"edunet.tn":                        true,
	"ee":                               true,
	"eg":                               true,
	"egersund.no":                      true,
	"egyptian.museum":                  true,
	"ehime.jp":                         true,
	"eid.no":                           true,
	"eidfjord.no":                      true,
	"eidsberg.no":                      true,
	"eidskog.no":                       true,
	"eidsvoll.no":                      true,
	"eigersund.no":                     true,
	"eiheiji.fukui.jp":                 true,
	"eisenbahn.museum":                 true,
	"elasticbeanstalk.com":             true,
	"elb.amazonaws.com":                true,
	"elblag.pl":                        true,
	"elburg.museum":                    true,
	"elk.pl":                           true,
	"elvendrell.museum":                true,
	"elverum.no":                       true,
	"email":                            true,
	"embaixada.st":                     true,
	"embetsu.hokkaido.jp":              true,
	"embroidery.museum":                true,
	"emerck":                           true,
	"emergency.aero":                   true,
	"emiliaromagna.it":                 true,
	"emp.br":                           true,
	"emr.it":                           true,
	"en.it":                            true,
	"ena.gifu.jp":                      true,
	"encyclopedic.museum":              true,
	"endofinternet.net":                true,
	"endofinternet.org":                true,
	"endoftheinternet.org":             true,
	"enebakk.no":                       true,
	"energy":                           true,
	"eng.br":                           true,
	"eng.pro":                          true,
	"engerdal.no":                      true,
	"engine.aero":                      true,
	"engineer":                         true,
	"engineer.aero":                    true,
	"engineering":                      true,
	"england.museum":                   true,
	"eniwa.hokkaido.jp":                true,
	"enna.it":                          true,
	"ens.tn":                           true,
	"enterprises":                      true,
	"entertainment.aero":               true,
	"entomology.museum":                true,
	"environment.museum":               true,
	"environmentalconservation.museum": true,
	"epilepsy.museum":                  true,
	"epson":                            true,
	"equipment":                        true,
	"equipment.aero":                   true,
	"er":                               true,
	"erimo.hokkaido.jp":                true,
	"erni":                             true,
	"erotica.hu":                       true,
	"erotika.hu":                       true,
	"es":                               true,
	"es.kr":                            true,
	"esan.hokkaido.jp":                 true,
	"esashi.hokkaido.jp":               true,
	"esp.br":                           true,
	"esq":                              true,
	"essex.museum":                     true,
	"est.pr":                           true,
	"estate":                           true,
	"estate.museum":                    true,
	"et":                               true,
	"etajima.hiroshima.jp":          true,
	"etc.br":                        true,
	"ethnology.museum":              true,
	"eti.br":                        true,
	"etne.no":                       true,
	"etnedal.no":                    true,
	"eu":                            true,
	"eu.com":                        true,
	"eu.int":                        true,
	"eun.eg":                        true,
	"eurovision":                    true,
	"eus":                           true,
	"evenassi.no":                   true,
	"evenes.no":                     true,
	"events":                        true,
	"everbank":                      true,
	"exchange":                      true,
	"exchange.aero":                 true,
	"exeter.museum":                 true,
	"exhibition.museum":             true,
	"expert":                        true,
	"exposed":                       true,
	"express.aero":                  true,
	"f.bg":                          true,
	"f.se":                          true,
	"fage":                          true,
	"fail":                          true,
	"fairwinds":                     true,
	"faith":                         true,
	"fam.pk":                        true,
	"family.museum":                 true,
	"fan":                           true,
	"fans":                          true,
	"far.br":                        true,
	"fareast.ru":                    true,
	"farm":                          true,
	"farm.museum":                   true,
	"farmequipment.museum":          true,
	"farmers.museum":                true,
	"farmstead.museum":              true,
	"farsund.no":                    true,
	"fashion":                       true,
	"fast":                          true,
	"fauske.no":                     true,
	"fc.it":                         true,
	"fe.it":                         true,
	"fed.us":                        true,
	"federation.aero":               true,
	"fedje.no":                      true,
	"feedback":                      true,
	"fermo.it":                      true,
	"ferrara.it":                    true,
	"ferrero":                       true,
	"fet.no":                        true,
	"fetsund.no":                    true,
	"fg.it":                         true,
	"fh.se":                         true,
	"fhs.no":                        true,
	"fhsk.se":                       true,
	"fhv.se":                        true,
	"fi":                            true,
	"fi.cr":                         true,
	"fi.it":                         true,
	"fie.ee":                        true,
	"field.museum":                  true,
	"figueres.museum":               true,
	"filatelia.museum":              true,
	"film":                          true,
	"film.hu":                       true,
	"film.museum":                   true,
	"fin.ec":                        true,
	"fin.tn":                        true,
	"final":                         true,
	"finance":                       true,
	"financial":                     true,
	"fineart.museum":                true,
	"finearts.museum":               true,
	"finland.museum":                true,
	"finnoy.no":                     true,
	"firebaseapp.com":               true,
	"firenze.it":                    true,
	"firestone":                     true,
	"firm.co":                       true,
	"firm.ht":                       true,
	"firm.in":                       true,
	"firm.nf":                       true,
	"firm.ro":                       true,
	"firm.ve":                       true,
	"firmdale":                      true,
	"fish":                          true,
	"fishing":                       true,
	"fit":                           true,
	"fitjar.no":                     true,
	"fitness":                       true,
	"fj":                            true,
	"fj.cn":                         true,
	"fjaler.no":                     true,
	"fjell.no":                      true,
	"fk":                            true,
	"fl.us":                         true,
	"fla.no":                        true,
	"flakstad.no":                   true,
	"flanders.museum":               true,
	"flatanger.no":                  true,
	"flekkefjord.no":                true,
	"flesberg.no":                   true,
	"flight.aero":                   true,
	"flights":                       true,
	"flog.br":                       true,
	"flora.no":                      true,
	"florence.it":                   true,
	"florida.museum":                true,
	"florist":                       true,
	"floro.no":                      true,
	"flowers":                       true,
	"flsmidth":                      true,
	"fly":                           true,
	"flynnhub.com":                  true,
	"fm":                            true,
	"fm.br":                         true,
	"fm.it":                         true,
	"fm.no":                         true,
	"fnd.br":                        true,
	"fo":                            true,
	"foggia.it":                     true,
	"folkebibl.no":                  true,
	"folldal.no":                    true,
	"foo":                           true,
	"football":                      true,
	"force.museum":                  true,
	"ford":                          true,
	"forde.no":                      true,
	"forex":                         true,
	"forgot.her.name":               true,
	"forgot.his.name":               true,
	"forlicesena.it":                true,
	"forsale":                       true,
	"forsand.no":                    true,
	"fortmissoula.museum":           true,
	"fortworth.museum":              true,
	"forum.hu":                      true,
	"fosnes.no":                     true,
	"fot.br":                        true,
	"foundation":                    true,
	"foundation.museum":             true,
	"fr":                            true,
	"fr.it":                         true,
	"frana.no":                      true,
	"francaise.museum":              true,
	"frankfurt.museum":              true,
	"franziskaner.museum":           true,
	"fredrikstad.no":                true,
	"freemasonry.museum":            true,
	"frei.no":                       true,
	"freiburg.museum":               true,
	"freight.aero":                  true,
	"fribourg.museum":               true,
	"friulivegiulia.it":             true,
	"friuliveneziagiulia.it":        true,
	"friulivgiulia.it":              true,
	"frl":                           true,
	"frog.museum":                   true,
	"frogans":                       true,
	"frogn.no":                      true,
	"froland.no":                    true,
	"from.hr":                       true,
	"frosinone.it":                  true,
	"frosta.no":                     true,
	"froya.no":                      true,
	"fst.br":                        true,
	"ftpaccess.cc":                  true,
	"fuchu.hiroshima.jp":            true,
	"fuchu.tokyo.jp":                true,
	"fuchu.toyama.jp":               true,
	"fudai.iwate.jp":                true,
	"fuefuki.yamanashi.jp":          true,
	"fuel.aero":                     true,
	"fuettertdasnetz.de":            true,
	"fuji.shizuoka.jp":              true,
	"fujieda.shizuoka.jp":           true,
	"fujiidera.osaka.jp":            true,
	"fujikawa.shizuoka.jp":          true,
	"fujikawa.yamanashi.jp":         true,
	"fujikawaguchiko.yamanashi.jp":  true,
	"fujimi.nagano.jp":              true,
	"fujimi.saitama.jp":             true,
	"fujimino.saitama.jp":           true,
	"fujinomiya.shizuoka.jp":        true,
	"fujioka.gunma.jp":              true,
	"fujisato.akita.jp":             true,
	"fujisawa.iwate.jp":             true,
	"fujisawa.kanagawa.jp":          true,
	"fujishiro.ibaraki.jp":          true,
	"fujiyoshida.yamanashi.jp":      true,
	"fukagawa.hokkaido.jp":          true,
	"fukaya.saitama.jp":             true,
	"fukuchi.fukuoka.jp":            true,
	"fukuchiyama.kyoto.jp":          true,
	"fukudomi.saga.jp":              true,
	"fukui.fukui.jp":                true,
	"fukui.jp":                      true,
	"fukumitsu.toyama.jp":           true,
	"fukuoka.jp":                    true,
	"fukuroi.shizuoka.jp":           true,
	"fukusaki.hyogo.jp":             true,
	"fukushima.fukushima.jp":        true,
	"fukushima.hokkaido.jp":         true,
	"fukushima.jp":                  true,
	"fukuyama.hiroshima.jp":         true,
	"funabashi.chiba.jp":            true,
	"funagata.yamagata.jp":          true,
	"funahashi.toyama.jp":           true,
	"fund":                          true,
	"fundacio.museum":               true,
	"fuoisku.no":                    true,
	"fuossko.no":                    true,
	"furano.hokkaido.jp":            true,
	"furniture":                     true,
	"furniture.museum":              true,
	"furubira.hokkaido.jp":          true,
	"furudono.fukushima.jp":         true,
	"furukawa.miyagi.jp":            true,
	"fusa.no":                       true,
	"fuso.aichi.jp":                 true,
	"fussa.tokyo.jp":                true,
	"futaba.fukushima.jp":           true,
	"futbol":                        true,
	"futsu.nagasaki.jp":             true,
	"futtsu.chiba.jp":               true,
	"fvg.it":                        true,
	"fylkesbibl.no":                 true,
	"fyresdal.no":                   true,
	"g.bg":                          true,
	"g.se":                          true,
	"g12.br":                        true,
	"ga":                            true,
	"ga.us":                         true,
	"gaivuotna.no":                  true,
	"gal":                           true,
	"gallery":                       true,
	"gallery.museum":                true,
	"galsa.no":                      true,
	"gamagori.aichi.jp":             true,
	"game.tw":                       true,
	"games.hu":                      true,
	"gamo.shiga.jp":                 true,
	"gamvik.no":                     true,
	"gangaviika.no":                 true,
	"gangwon.kr":                    true,
	"garden":                        true,
	"garden.museum":                 true,
	"gateway.museum":                true,
	"gaular.no":                     true,
	"gausdal.no":                    true,
	"gb":                            true,
	"gb.com":                        true,
	"gb.net":                        true,
	"gbiz":                          true,
	"gc.ca":                         true,
	"gd":                            true,
	"gd.cn":                         true,
	"gda.pl":                        true,
	"gdansk.pl":                     true,
	"gdn":                           true,
	"gdynia.pl":                     true,
	"ge":                            true,
	"ge.it":                         true,
	"gea":                           true,
	"geek.nz":                       true,
	"geelvinck.museum":              true,
	"geisei.kochi.jp":               true,
	"gemological.museum":            true,
	"gen.in":                        true,
	"gen.nz":                        true,
	"gen.tr":                        true,
	"genkai.saga.jp":                true,
	"genoa.it":                      true,
	"genova.it":                     true,
	"gent":                          true,
	"geology.museum":                true,
	"georgia.museum":                true,
	"getmyip.com":                   true,
	"gf":                            true,
	"gg":                            true,
	"ggee":                          true,
	"ggf.br":                        true,
	"gh":                            true,
	"gi":                            true,
	"giehtavuoatna.no":              true,
	"giessen.museum":                true,
	"gift":                          true,
	"gifts":                         true,
	"gifu.gifu.jp":                  true,
	"gifu.jp":                       true,
	"gildeskal.no":                  true,
	"ginan.gifu.jp":                 true,
	"ginowan.okinawa.jp":            true,
	"ginoza.okinawa.jp":             true,
	"giske.no":                      true,
	"github.io":                     true,
	"githubusercontent.com":         true,
	"gives":                         true,
	"giving":                        true,
	"gjemnes.no":                    true,
	"gjerdrum.no":                   true,
	"gjerstad.no":                   true,
	"gjesdal.no":                    true,
	"gjovik.no":                     true,
	"gl":                            true,
	"glas.museum":                   true,
	"glass":                         true,
	"glass.museum":                  true,
	"gle":                           true,
	"gliding.aero":                  true,
	"gliwice.pl":                    true,
	"global":                        true,
	"global.prod.fastly.net":        true,
	"global.ssl.fastly.net":         true,
	"globo":                         true,
	"glogow.pl":                     true,
	"gloppen.no":                    true,
	"gm":                            true,
	"gmail":                         true,
	"gmina.pl":                      true,
	"gmo":                           true,
	"gmx":                           true,
	"gn":                            true,
	"gniezno.pl":                    true,
	"go.ci":                         true,
	"go.cr":                         true,
	"go.dyndns.org":                 true,
	"go.id":                         true,
	"go.it":                         true,
	"go.jp":                         true,
	"go.kr":                         true,
	"go.pw":                         true,
	"go.th":                         true,
	"go.tj":                         true,
	"go.tz":                         true,
	"go.ug":                         true,
	"gob.ar":                        true,
	"gob.bo":                        true,
	"gob.cl":                        true,
	"gob.do":                        true,
	"gob.ec":                        true,
	"gob.es":                        true,
	"gob.gt":                        true,
	"gob.hn":                        true,
	"gob.mx":                        true,
	"gob.pa":                        true,
	"gob.pe":                        true,
	"gob.pk":                        true,
	"gob.sv":                        true,
	"gob.ve":                        true,
	"gobo.wakayama.jp":              true,
	"godo.gifu.jp":                  true,
	"gojome.akita.jp":               true,
	"gok.pk":                        true,
	"gokase.miyazaki.jp":            true,
	"gol.no":                        true,
	"gold":                          true,
	"goldpoint":                     true,
	"golf":                          true,
	"gon.pk":                        true,
	"gonohe.aomori.jp":              true,
	"goo":                           true,
	"goog":                          true,
	"google":                        true,
	"googleapis.com":                true,
	"googlecode.com":                true,
	"gop":                           true,
	"gop.pk":                        true,
	"gorge.museum":                  true,
	"gorizia.it":                    true,
	"gorlice.pl":                    true,
	"gos.pk":                        true,
	"gose.nara.jp":                  true,
	"gosen.niigata.jp":              true,
	"goshiki.hyogo.jp":              true,
	"got":                           true,
	"gotdns.com":                    true,
	"gotdns.org":                    true,
	"gotemba.shizuoka.jp":           true,
	"goto.nagasaki.jp":              true,
	"gotsu.shimane.jp":              true,
	"gouv.bj":                       true,
	"gouv.ci":                       true,
	"gouv.fr":                       true,
	"gouv.ht":                       true,
	"gouv.km":                       true,
	"gouv.ml":                       true,
	"gouv.rw":                       true,
	"gouv.sn":                       true,
	"gov":                           true,
	"gov.ac":                        true,
	"gov.ae":                        true,
	"gov.af":                        true,
	"gov.al":                        true,
	"gov.ar":                        true,
	"gov.as":                        true,
	"gov.au":                        true,
	"gov.az":                        true,
	"gov.ba":                        true,
	"gov.bb":                        true,
	"gov.bf":                        true,
	"gov.bh":                        true,
	"gov.bm":                        true,
	"gov.bo":                        true,
	"gov.br":                        true,
	"gov.bs":                        true,
	"gov.bt":                        true,
	"gov.by":                        true,
	"gov.bz":                        true,
	"gov.cd":                        true,
	"gov.cl":                        true,
	"gov.cm":                        true,
	"gov.cn":                        true,
	"gov.co":                        true,
	"gov.cu":                        true,
	"gov.cx":                        true,
	"gov.dm":                        true,
	"gov.do":                        true,
	"gov.dz":                        true,
	"gov.ec":                        true,
	"gov.ee":                        true,
	"gov.eg":                        true,
	"gov.et":                        true,
	"gov.ge":                        true,
	"gov.gh":                        true,
	"gov.gi":                        true,
	"gov.gn":                        true,
	"gov.gr":                        true,
	"gov.hk":                        true,
	"gov.ie":                        true,
	"gov.in":                        true,
	"gov.iq":                        true,
	"gov.ir":                        true,
	"gov.is":                        true,
	"gov.it":                        true,
	"gov.jo":                        true,
	"gov.kg":                        true,
	"gov.ki":                        true,
	"gov.km":                        true,
	"gov.kn":                        true,
	"gov.kp":                        true,
	"gov.ky":                        true,
	"gov.kz":                        true,
	"gov.la":                        true,
	"gov.lb":                        true,
	"gov.lc":                        true,
	"gov.lk":                        true,
	"gov.lr":                        true,
	"gov.lt":                        true,
	"gov.lv":                        true,
	"gov.ly":                        true,
	"gov.ma":                        true,
	"gov.me":                        true,
	"gov.mg":                        true,
	"gov.mk":                        true,
	"gov.ml":                        true,
	"gov.mn":                        true,
	"gov.mo":                        true,
	"gov.mr":                        true,
	"gov.ms":                        true,
	"gov.mu":                        true,
	"gov.mv":                        true,
	"gov.mw":                        true,
	"gov.my":                        true,
	"gov.nc.tr":                     true,
	"gov.ng":                        true,
	"gov.nr":                        true,
	"gov.om":                        true,
	"gov.ph":                        true,
	"gov.pk":                        true,
	"gov.pl":                        true,
	"gov.pn":                        true,
	"gov.pr":                        true,
	"gov.ps":                        true,
	"gov.pt":                        true,
	"gov.py":                        true,
	"gov.qa":                        true,
	"gov.rs":                        true,
	"gov.ru":                        true,
	"gov.rw":                        true,
	"gov.sa":                        true,
	"gov.sb":                        true,
	"gov.sc":                        true,
	"gov.sd":                        true,
	"gov.sg":                        true,
	"gov.sh":                        true,
	"gov.sl":                        true,
	"gov.st":                        true,
	"gov.sx":                        true,
	"gov.sy":                        true,
	"gov.tj":                        true,
	"gov.tl":                        true,
	"gov.tm":                        true,
	"gov.tn":                        true,
	"gov.to":                        true,
	"gov.tr":                        true,
	"gov.tt":                        true,
	"gov.tw":                        true,
	"gov.ua":                        true,
	"gov.uk":                        true,
	"gov.vc":                        true,
	"gov.ve":                        true,
	"gov.vn":                        true,
	"gov.ws":                        true,
	"government.aero":               true,
	"govt.nz":                       true,
	"gp":                            true,
	"gq":                            true,
	"gr":                            true,
	"gr.com":                        true,
	"gr.it":                         true,
	"gr.jp":                         true,
	"grajewo.pl":                    true,
	"gran.no":                       true,
	"grandrapids.museum":            true,
	"grane.no":                      true,
	"granvin.no":                    true,
	"graphics":                      true,
	"gratangen.no":                  true,
	"gratis":                        true,
	"graz.museum":                   true,
	"green":                         true,
	"greta.fr":                      true,
	"grimstad.no":                   true,
	"gripe":                         true,
	"grong.no":                      true,
	"grosseto.it":                   true,
	"groundhandling.aero":           true,
	"group":                         true,
	"group.aero":                    true,
	"grozny.ru":                     true,
	"grozny.su":                     true,
	"grp.lk":                        true,
	"grue.no":                       true,
	"gs":                            true,
	"gs.aa.no":                      true,
	"gs.ah.no":                      true,
	"gs.bu.no":                      true,
	"gs.cn":                         true,
	"gs.fm.no":                      true,
	"gs.hl.no":                      true,
	"gs.hm.no":                      true,
	"gs.mr.no":                      true,
	"gs.nl.no":                      true,
	"gs.nt.no":                      true,
	"gs.of.no":                      true,
	"gs.ol.no":                      true,
	"gs.oslo.no":                    true,
	"gs.rl.no":                      true,
	"gs.sf.no":                      true,
	"gs.st.no":                      true,
	"gs.svalbard.no":                true,
	"gs.tm.no":                      true,
	"gs.tr.no":                      true,
	"gs.va.no":                      true,
	"gs.vf.no":                      true,
	"gsm.pl":                        true,
	"gt":                            true,
	"gu":                            true,
	"gu.us":                         true,
	"gub.uy":                        true,
	"gucci":                         true,
	"guernsey.museum":               true,
	"guge":                          true,
	"guide":                         true,
	"guitars":                       true,
	"gujo.gifu.jp":                  true,
	"gulen.no":                      true,
	"gunma.jp":                      true,
	"guovdageaidnu.no":              true,
	"guru":                          true,
	"gushikami.okinawa.jp":          true,
	"gv.ao":                         true,
	"gv.at":                         true,
	"gw":                            true,
	"gwangju.kr":                    true,
	"gx.cn":                         true,
	"gy":                            true,
	"gyeongbuk.kr":                  true,
	"gyeonggi.kr":                   true,
	"gyeongnam.kr":                  true,
	"gyokuto.kumamoto.jp":           true,
	"gz.cn":                         true,
	"h.bg":                          true,
	"h.se":                          true,
	"ha.cn":                         true,
	"ha.no":                         true,
	"habikino.osaka.jp":             true,
	"habmer.no":                     true,
	"haboro.hokkaido.jp":            true,
	"hachijo.tokyo.jp":              true,
	"hachinohe.aomori.jp":           true,
	"hachioji.tokyo.jp":             true,
	"hachirogata.akita.jp":          true,
	"hadano.kanagawa.jp":            true,
	"hadsel.no":                     true,
	"haebaru.okinawa.jp":            true,
	"haga.tochigi.jp":               true,
	"hagebostad.no":                 true,
	"hagi.yamaguchi.jp":             true,
	"haibara.shizuoka.jp":           true,
	"hakata.fukuoka.jp":             true,
	"hakodate.hokkaido.jp":          true,
	"hakone.kanagawa.jp":            true,
	"hakuba.nagano.jp":              true,
	"hakui.ishikawa.jp":             true,
	"hakusan.ishikawa.jp":           true,
	"halden.no":                     true,
	"halloffame.museum":             true,
	"halsa.no":                      true,
	"hamada.shimane.jp":             true,
	"hamamatsu.shizuoka.jp":         true,
	"hamar.no":                      true,
	"hamaroy.no":                    true,
	"hamatama.saga.jp":              true,
	"hamatonbetsu.hokkaido.jp":      true,
	"hamburg":                       true,
	"hamburg.museum":                true,
	"hammarfeasta.no":               true,
	"hammerfest.no":                 true,
	"hamura.tokyo.jp":               true,
	"hanamaki.iwate.jp":             true,
	"hanamigawa.chiba.jp":           true,
	"hanawa.fukushima.jp":           true,
	"handa.aichi.jp":                true,
	"handson.museum":                true,
	"hanggliding.aero":              true,
	"hangout":                       true,
	"hannan.osaka.jp":               true,
	"hanno.saitama.jp":              true,
	"hanyu.saitama.jp":              true,
	"hapmir.no":                     true,
	"happou.akita.jp":               true,
	"hara.nagano.jp":                true,
	"haram.no":                      true,
	"hareid.no":                     true,
	"harima.hyogo.jp":               true,
	"harstad.no":                    true,
	"harvestcelebration.museum":     true,
	"hasama.oita.jp":                true,
	"hasami.nagasaki.jp":            true,
	"hashikami.aomori.jp":           true,
	"hashima.gifu.jp":               true,
	"hashimoto.wakayama.jp":         true,
	"hasuda.saitama.jp":             true,
	"hasvik.no":                     true,
	"hatogaya.saitama.jp":           true,
	"hatoyama.saitama.jp":           true,
	"hatsukaichi.hiroshima.jp":      true,
	"hattfjelldal.no":               true,
	"haugesund.no":                  true,
	"haus":                          true,
	"hawaii.museum":                 true,
	"hayakawa.yamanashi.jp":         true,
	"hayashima.okayama.jp":          true,
	"hazu.aichi.jp":                 true,
	"hb.cn":                         true,
	"he.cn":                         true,
	"health.museum":                 true,
	"health.nz":                     true,
	"health.vn":                     true,
	"healthcare":                    true,
	"heguri.nara.jp":                true,
	"heimatunduhren.museum":         true,
	"hekinan.aichi.jp":              true,
	"hellas.museum":                 true,
	"help":                          true,
	"helsinki.museum":               true,
	"hembygdsforbund.museum":        true,
	"hemne.no":                      true,
	"hemnes.no":                     true,
	"hemsedal.no":                   true,
	"herad.no":                      true,
	"here":                          true,
	"heritage.museum":               true,
	"hermes":                        true,
	"herokuapp.com":                 true,
	"herokussl.com":                 true,
	"heroy.nordland.no":             true,
	"hi.cn":                         true,
	"hi.us":                         true,
	"hichiso.gifu.jp":               true,
	"hida.gifu.jp":                  true,
	"hidaka.hokkaido.jp":            true,
	"hidaka.kochi.jp":               true,
	"hidaka.saitama.jp":             true,
	"hidaka.wakayama.jp":            true,
	"higashi.fukuoka.jp":            true,
	"higashi.fukushima.jp":          true,
	"higashi.okinawa.jp":            true,
	"higashiagatsuma.gunma.jp":      true,
	"higashichichibu.saitama.jp":    true,
	"higashihiroshima.hiroshima.jp": true,
	"higashiizu.shizuoka.jp":        true,
	"higashiizumo.shimane.jp":       true,
	"higashikagawa.kagawa.jp":       true,
	"higashikagura.hokkaido.jp":     true,
	"higashikawa.hokkaido.jp":       true,
	"higashikurume.tokyo.jp":        true,
	"higashimatsushima.miyagi.jp":   true,
	"higashimatsuyama.saitama.jp":   true,
	"higashimurayama.tokyo.jp":      true,
	"higashinaruse.akita.jp":        true,
	"higashine.yamagata.jp":         true,
	"higashiomi.shiga.jp":           true,
	"higashiosaka.osaka.jp":         true,
	"higashishirakawa.gifu.jp":      true,
	"higashisumiyoshi.osaka.jp":     true,
	"higashitsuno.kochi.jp":         true,
	"higashiura.aichi.jp":           true,
	"higashiyama.kyoto.jp":          true,
	"higashiyamato.tokyo.jp":        true,
	"higashiyodogawa.osaka.jp":      true,
	"higashiyoshino.nara.jp":        true,
	"hiji.oita.jp":                  true,
	"hikari.yamaguchi.jp":           true,
	"hikawa.shimane.jp":             true,
	"hikimi.shimane.jp":             true,
	"hikone.shiga.jp":               true,
	"himeji.hyogo.jp":               true,
	"himeshima.oita.jp":             true,
	"himi.toyama.jp":                true,
	"hino.tokyo.jp":                 true,
	"hino.tottori.jp":               true,
	"hinode.tokyo.jp":               true,
	"hinohara.tokyo.jp":             true,
	"hioki.kagoshima.jp":            true,
	"hiphop":                        true,
	"hirado.nagasaki.jp":            true,
	"hiraizumi.iwate.jp":            true,
	"hirakata.osaka.jp":             true,
	"hiranai.aomori.jp":             true,
	"hirara.okinawa.jp":             true,
	"hirata.fukushima.jp":           true,
	"hiratsuka.kanagawa.jp":         true,
	"hiraya.nagano.jp":              true,
	"hirogawa.wakayama.jp":          true,
	"hirokawa.fukuoka.jp":           true,
	"hirono.fukushima.jp":           true,
	"hirono.iwate.jp":               true,
	"hiroo.hokkaido.jp":             true,
	"hirosaki.aomori.jp":            true,
	"hiroshima.jp":                  true,
	"hisayama.fukuoka.jp":           true,
	"histoire.museum":               true,
	"historical.museum":             true,
	"historicalsociety.museum":      true,
	"historichouses.museum":         true,
	"historisch.museum":             true,
	"historisches.museum":           true,
	"history.museum":                true,
	"historyofscience.museum":       true,
	"hita.oita.jp":                  true,
	"hitachi":                       true,
	"hitachi.ibaraki.jp":            true,
	"hitachinaka.ibaraki.jp":        true,
	"hitachiomiya.ibaraki.jp":       true,
	"hitachiota.ibaraki.jp":         true,
	"hitoyoshi.kumamoto.jp":         true,
	"hitra.no":                      true,
	"hiv":                           true,
	"hizen.saga.jp":                 true,
	"hjartdal.no":                   true,
	"hjelmeland.no":                 true,
	"hk":                            true,
	"hk.cn":                         true,
	"hk.com":                        true,
	"hk.org":                        true,
	"hl.cn":                         true,
	"hl.no":                         true,
	"hm":                            true,
	"hm.no":                         true,
	"hn":                            true,
	"hn.cn":                         true,
	"hobol.no":                      true,
	"hof.no":                        true,
	"hofu.yamaguchi.jp":             true,
	"hokkaido.jp":                   true,
	"hokksund.no":                   true,
	"hokuryu.hokkaido.jp":           true,
	"hokuto.hokkaido.jp":            true,
	"hokuto.yamanashi.jp":           true,
	"hol.no":                        true,
	"holdings":                      true,
	"hole.no":                       true,
	"holiday":                       true,
	"holmestrand.no":                true,
	"holtalen.no":                   true,
	"home.dyndns.org":               true,
	"homebuilt.aero":                true,
	"homedns.org":                   true,
	"homeftp.net":                   true,
	"homeftp.org":                   true,
	"homeip.net":                    true,
	"homelinux.com":                 true,
	"homelinux.net":                 true,
	"homelinux.org":                 true,
	"homes":                         true,
	"homeunix.com":                  true,
	"homeunix.net":                  true,
	"homeunix.org":                  true,
	"honai.ehime.jp":                true,
	"honbetsu.hokkaido.jp":          true,
	"honda":                         true,
	"honefoss.no":                   true,
	"hongo.hiroshima.jp":            true,
	"honjo.akita.jp":                true,
	"honjo.saitama.jp":              true,
	"honjyo.akita.jp":               true,
	"hornindal.no":                  true,
	"horokanai.hokkaido.jp":         true,
	"horology.museum":               true,
	"horonobe.hokkaido.jp":          true,
	"horse":                         true,
	"horten.no":                     true,
	"host":                          true,
	"hosting":                       true,
	"hotel.hu":                      true,
	"hotel.lk":                      true,
	"hotel.tz":                      true,
	"hotmail":                       true,
	"house":                         true,
	"house.museum":                  true,
	"how":                           true,
	"hoyanger.no":                   true,
	"hoylandet.no":                  true,
	"hr":                            true,
	"hs.kr":                         true,
	"hsbc":                          true,
	"ht":                            true,
	"hu":                            true,
	"hu.com":                        true,
	"hu.net":                        true,
	"humanities.museum":             true,
	"hurdal.no":                     true,
	"hurum.no":                      true,
	"hvaler.no":                     true,
	"hyllestad.no":                  true,
	"hyogo.jp":                      true,
	"hyuga.miyazaki.jp":             true,
	"i.bg":                          true,
	"i.ph":                          true,
	"i.se":                          true,
	"ia.us":                         true,
	"iamallama.com":                 true,
	"ibara.okayama.jp":              true,
	"ibaraki.ibaraki.jp":            true,
	"ibaraki.jp":                    true,
	"ibaraki.osaka.jp":              true,
	"ibestad.no":                    true,
	"ibigawa.gifu.jp":               true,
	"ibm":                           true,
	"ice":                           true,
	"ichiba.tokushima.jp":         true,
	"ichihara.chiba.jp":           true,
	"ichikai.tochigi.jp":          true,
	"ichikawa.chiba.jp":           true,
	"ichikawa.hyogo.jp":           true,
	"ichikawamisato.yamanashi.jp": true,
	"ichinohe.iwate.jp":           true,
	"ichinomiya.aichi.jp":         true,
	"ichinomiya.chiba.jp":         true,
	"ichinoseki.iwate.jp":         true,
	"icu":          true,
	"id":           true,
	"id.au":        true,
	"id.ir":        true,
	"id.lv":        true,
	"id.ly":        true,
	"id.us":        true,
	"ide.kyoto.jp": true,
	"idrett.no":    true,
	"idv.hk":       true,
	"idv.tw":       true,
	"ie":           true,
	"if.ua":        true,
	"ifm":          true,
	"iglesiascarbonia.it": true,
	"iheya.okinawa.jp":    true,
	"iida.nagano.jp":      true,
	"iide.yamagata.jp":    true,
	"iijima.nagano.jp":    true,
	"iinet":               true,
	"iitate.fukushima.jp": true,
	"iiyama.nagano.jp":    true,
	"iizuka.fukuoka.jp":   true,
	"iizuna.nagano.jp":    true,
	"ikaruga.nara.jp":     true,
	"ikata.ehime.jp":      true,
	"ikawa.akita.jp":      true,
	"ikeda.fukui.jp":      true,
	"ikeda.gifu.jp":       true,
	"ikeda.hokkaido.jp":   true,
	"ikeda.nagano.jp":     true,
	"ikeda.osaka.jp":      true,
	"iki.fi":              true,
	"iki.nagasaki.jp":     true,
	"ikoma.nara.jp":       true,
	"ikusaka.nagano.jp":   true,
	"il":                  true,
	"il.us":               true,
	"ilawa.pl":            true,
	"illustration.museum": true,
	"im":                      true,
	"im.it":                   true,
	"imabari.ehime.jp":        true,
	"imageandsound.museum":    true,
	"imakane.hokkaido.jp":     true,
	"imari.saga.jp":           true,
	"imb.br":                  true,
	"imizu.toyama.jp":         true,
	"immo":                    true,
	"immobilien":              true,
	"imperia.it":              true,
	"in":                      true,
	"in.na":                   true,
	"in.net":                  true,
	"in.rs":                   true,
	"in.th":                   true,
	"in.ua":                   true,
	"in.us":                   true,
	"ina.ibaraki.jp":          true,
	"ina.nagano.jp":           true,
	"ina.saitama.jp":          true,
	"inabe.mie.jp":            true,
	"inagawa.hyogo.jp":        true,
	"inagi.tokyo.jp":          true,
	"inami.toyama.jp":         true,
	"inami.wakayama.jp":       true,
	"inashiki.ibaraki.jp":     true,
	"inatsuki.fukuoka.jp":     true,
	"inawashiro.fukushima.jp": true,
	"inazawa.aichi.jp":        true,
	"inc.hk":                  true,
	"incheon.kr":              true,
	"ind.br":                  true,
	"ind.gt":                  true,
	"ind.in":                  true,
	"ind.tn":                  true,
	"inderoy.no":              true,
	"indian.museum":           true,
	"indiana.museum":          true,
	"indianapolis.museum":     true,
	"indianmarket.museum":     true,
	"industries":              true,
	"ine.kyoto.jp":            true,
	"inf.br":                  true,
	"inf.cu":                  true,
	"inf.mk":                  true,
	"infiniti":                true,
	"info":                    true,
	"info.at":                 true,
	"info.au":                 true,
	"info.az":                 true,
	"info.bb":                 true,
	"info.co":                 true,
	"info.ec":                 true,
	"info.et":                 true,
	"info.ht":                 true,
	"info.hu":                 true,
	"info.ki":                 true,
	"info.la":                 true,
	"info.mv":                 true,
	"info.na":                 true,
	"info.nf":                 true,
	"info.nr":                 true,
	"info.pk":                 true,
	"info.pl":                 true,
	"info.pr":                 true,
	"info.ro":                 true,
	"info.sd":                 true,
	"info.tn":                 true,
	"info.tr":                 true,
	"info.tt":                 true,
	"info.tz":                 true,
	"info.ve":                 true,
	"info.vn":                 true,
	"ing":                     true,
	"ing.pa":                  true,
	"ingatlan.hu":             true,
	"ink":                     true,
	"ino.kochi.jp":            true,
	"institute":               true,
	"insurance.aero":          true,
	"insure":                  true,
	"int":                     true,
	"int.ar":                  true,
	"int.az":                  true,
	"int.bo":                  true,
	"int.ci":                  true,
	"int.co":                  true,
	"int.is":                  true,
	"int.la":                  true,
	"int.lk":                  true,
	"int.mv":                  true,
	"int.mw":                  true,
	"int.pt":                  true,
	"int.ru":                  true,
	"int.rw":                  true,
	"int.tj":                  true,
	"int.tt":                  true,
	"int.ve":                  true,
	"int.vn":                  true,
	"intelligence.museum":     true,
	"interactive.museum":      true,
	"international":           true,
	"intl.tn":                 true,
	"inuyama.aichi.jp":        true,
	"investments":             true,
	"inzai.chiba.jp":          true,
	"io":                      true,
	"ip6.arpa":                true,
	"ipiranga":                true,
	"iq":                      true,
	"ir":                      true,
	"iraq.museum":             true,
	"iris.arpa":               true,
	"irish":                   true,
	"irkutsk.ru":              true,
	"iron.museum":             true,
	"iruma.saitama.jp":        true,
	"is":                      true,
	"is.it":                   true,
	"isa.kagoshima.jp":        true,
	"isa.us":                  true,
	"isahaya.nagasaki.jp":     true,
	"ise.mie.jp":              true,
	"isehara.kanagawa.jp":     true,
	"isen.kagoshima.jp":       true,
	"isernia.it":              true,
	"isesaki.gunma.jp":        true,
	"ishigaki.okinawa.jp":     true,
	"ishikari.hokkaido.jp":    true,
	"ishikawa.fukushima.jp":   true,
	"ishikawa.jp":             true,
	"ishikawa.okinawa.jp":     true,
	"ishinomaki.miyagi.jp":    true,
	"isla.pr":                 true,
	"isleofman.museum":        true,
	"isshiki.aichi.jp":        true,
	"issmarterthanyou.com":    true,
	"ist":                   true,
	"istanbul":              true,
	"isteingeek.de":         true,
	"istmein.de":            true,
	"isumi.chiba.jp":        true,
	"it":                    true,
	"it.ao":                 true,
	"itabashi.tokyo.jp":     true,
	"itako.ibaraki.jp":      true,
	"itakura.gunma.jp":      true,
	"itami.hyogo.jp":        true,
	"itano.tokushima.jp":    true,
	"itau":                  true,
	"itayanagi.aomori.jp":   true,
	"ito.shizuoka.jp":       true,
	"itoigawa.niigata.jp":   true,
	"itoman.okinawa.jp":     true,
	"its.me":                true,
	"ivanovo.ru":            true,
	"ivanovo.su":            true,
	"iveland.no":            true,
	"ivgu.no":               true,
	"iwade.wakayama.jp":     true,
	"iwafune.tochigi.jp":    true,
	"iwaizumi.iwate.jp":     true,
	"iwaki.fukushima.jp":    true,
	"iwakuni.yamaguchi.jp":  true,
	"iwakura.aichi.jp":      true,
	"iwama.ibaraki.jp":      true,
	"iwamizawa.hokkaido.jp": true,
	"iwanai.hokkaido.jp":    true,
	"iwanuma.miyagi.jp":     true,
	"iwata.shizuoka.jp":     true,
	"iwate.iwate.jp":        true,
	"iwate.jp":              true,
	"iwatsuki.saitama.jp":   true,
	"iwc":                       true,
	"iwi.nz":                    true,
	"iyo.ehime.jp":              true,
	"iz.hr":                     true,
	"izena.okinawa.jp":          true,
	"izhevsk.ru":                true,
	"izu.shizuoka.jp":           true,
	"izumi.kagoshima.jp":        true,
	"izumi.osaka.jp":            true,
	"izumiotsu.osaka.jp":        true,
	"izumisano.osaka.jp":        true,
	"izumizaki.fukushima.jp":    true,
	"izumo.shimane.jp":          true,
	"izumozaki.niigata.jp":      true,
	"izunokuni.shizuoka.jp":     true,
	"j.bg":                      true,
	"jaguar":                    true,
	"jamal.ru":                  true,
	"jamison.museum":            true,
	"jar.ru":                    true,
	"java":                      true,
	"jaworzno.pl":               true,
	"jcb":                       true,
	"je":                        true,
	"jefferson.museum":          true,
	"jeju.kr":                   true,
	"jeonbuk.kr":                true,
	"jeonnam.kr":                true,
	"jerusalem.museum":          true,
	"jessheim.no":               true,
	"jetzt":                     true,
	"jevnaker.no":               true,
	"jewelry.museum":            true,
	"jewish.museum":             true,
	"jewishart.museum":          true,
	"jfk.museum":                true,
	"jgora.pl":                  true,
	"jinsekikogen.hiroshima.jp": true,
	"jl.cn":                     true,
	"jlc":                       true,
	"jm":                        true,
	"jo":                        true,
	"joboji.iwate.jp":           true,
	"jobs":                      true,
	"jobs.tt":                   true,
	"joburg":                    true,
	"joetsu.niigata.jp":         true,
	"jogasz.hu":                 true,
	"johana.toyama.jp":          true,
	"jolster.no":                true,
	"jondal.no":                 true,
	"jor.br":                    true,
	"jorpeland.no":              true,
	"joso.ibaraki.jp":           true,
	"jot":                       true,
	"journal.aero":              true,
	"journalism.museum":         true,
	"journalist.aero":           true,
	"joy":                       true,
	"joyo.kyoto.jp":             true,
	"jp":                        true,
	"jp.net":                    true,
	"jpn.com":                   true,
	"jprs":                      true,
	"js.cn":                     true,
	"judaica.museum":            true,
	"judygarland.museum":        true,
	"juedisches.museum":         true,
	"juegos":                    true,
	"juif.museum":               true,
	"jur.pro":                   true,
	"jus.br":                    true,
	"jx.cn":                     true,
	"k.bg":                      true,
	"k.se":                      true,
	"k12.ak.us":                 true,
	"k12.al.us":                 true,
	"k12.ar.us":                 true,
	"k12.as.us":                 true,
	"k12.az.us":                 true,
	"k12.ca.us":                 true,
	"k12.co.us":                 true,
	"k12.ct.us":                 true,
	"k12.dc.us":                 true,
	"k12.de.us":                 true,
	"k12.ec":                    true,
	"k12.fl.us":                 true,
	"k12.ga.us":                 true,
	"k12.gu.us":                 true,
	"k12.ia.us":                 true,
	"k12.id.us":                 true,
	"k12.il.us":                 true,
	"k12.in.us":                 true,
	"k12.ks.us":                 true,
	"k12.ky.us":                 true,
	"k12.la.us":                 true,
	"k12.ma.us":                 true,
	"k12.md.us":                 true,
	"k12.me.us":                 true,
	"k12.mi.us":                 true,
	"k12.mn.us":                 true,
	"k12.mo.us":                 true,
	"k12.ms.us":                 true,
	"k12.mt.us":                 true,
	"k12.nc.us":                 true,
	"k12.ne.us":                 true,
	"k12.nh.us":                 true,
	"k12.nj.us":                 true,
	"k12.nm.us":                 true,
	"k12.nv.us":                 true,
	"k12.ny.us":                 true,
	"k12.oh.us":                 true,
	"k12.ok.us":                 true,
	"k12.or.us":                 true,
	"k12.pa.us":                 true,
	"k12.pr.us":                 true,
	"k12.ri.us":                 true,
	"k12.sc.us":                 true,
	"k12.tn.us":                 true,
	"k12.tr":                    true,
	"k12.tx.us":                 true,
	"k12.ut.us":                 true,
	"k12.va.us":                 true,
	"k12.vi":                    true,
	"k12.vi.us":                 true,
	"k12.vt.us":                 true,
	"k12.wa.us":                 true,
	"k12.wi.us":                 true,
	"k12.wy.us":                 true,
	"kadena.okinawa.jp":         true,
	"kadogawa.miyazaki.jp":      true,
	"kadoma.osaka.jp":           true,
	"kafjord.no":                true,
	"kaga.ishikawa.jp":          true,
	"kagami.kochi.jp":           true,
	"kagamiishi.fukushima.jp":   true,
	"kagamino.okayama.jp":       true,
	"kagawa.jp":                 true,
	"kagoshima.jp":              true,
	"kagoshima.kagoshima.jp":    true,
	"kaho.fukuoka.jp":           true,
	"kahoku.ishikawa.jp":        true,
	"kahoku.yamagata.jp":        true,
	"kai.yamanashi.jp":          true,
	"kainan.tokushima.jp":       true,
	"kainan.wakayama.jp":        true,
	"kaisei.kanagawa.jp":        true,
	"kaita.hiroshima.jp":        true,
	"kaizuka.osaka.jp":          true,
	"kakamigahara.gifu.jp":      true,
	"kakegawa.shizuoka.jp":      true,
	"kakinoki.shimane.jp":       true,
	"kakogawa.hyogo.jp":         true,
	"kakuda.miyagi.jp":          true,
	"kalisz.pl":                 true,
	"kalmykia.ru":               true,
	"kalmykia.su":               true,
	"kaluga.ru":                 true,
	"kaluga.su":                 true,
	"kamagaya.chiba.jp":         true,
	"kamaishi.iwate.jp":         true,
	"kamakura.kanagawa.jp":      true,
	"kamchatka.ru":              true,
	"kameoka.kyoto.jp":          true,
	"kameyama.mie.jp":           true,
	"kami.kochi.jp":             true,
	"kami.miyagi.jp":            true,
	"kamiamakusa.kumamoto.jp":   true,
	"kamifurano.hokkaido.jp":    true,
	"kamigori.hyogo.jp":         true,
	"kamiichi.toyama.jp":        true,
	"kamiizumi.saitama.jp":      true,
	"kamijima.ehime.jp":         true,
	"kamikawa.hokkaido.jp":      true,
	"kamikawa.hyogo.jp":         true,
	"kamikawa.saitama.jp":       true,
	"kamikitayama.nara.jp":      true,
	"kamikoani.akita.jp":        true,
	"kamimine.saga.jp":          true,
	"kaminokawa.tochigi.jp":     true,
	"kaminoyama.yamagata.jp":    true,
	"kamioka.akita.jp":          true,
	"kamisato.saitama.jp":       true,
	"kamishihoro.hokkaido.jp":   true,
	"kamisu.ibaraki.jp":         true,
	"kamisunagawa.hokkaido.jp":  true,
	"kamitonda.wakayama.jp":     true,
	"kamitsue.oita.jp":          true,
	"kamo.kyoto.jp":             true,
	"kamo.niigata.jp":           true,
	"kamoenai.hokkaido.jp":      true,
	"kamogawa.chiba.jp":         true,
	"kanagawa.jp":               true,
	"kanan.osaka.jp":            true,
	"kanazawa.ishikawa.jp":      true,
	"kanegasaki.iwate.jp":       true,
	"kaneyama.fukushima.jp":     true,
	"kaneyama.yamagata.jp":      true,
	"kani.gifu.jp":              true,
	"kanie.aichi.jp":            true,
	"kanmaki.nara.jp":           true,
	"kanna.gunma.jp":            true,
	"kannami.shizuoka.jp":       true,
	"kanonji.kagawa.jp":         true,
	"kanoya.kagoshima.jp":       true,
	"kanra.gunma.jp":            true,
	"kanuma.tochigi.jp":         true,
	"kanzaki.saga.jp":           true,
	"karasjohka.no":             true,
	"karasjok.no":               true,
	"karasuyama.tochigi.jp":     true,
	"karate.museum":             true,
	"karatsu.saga.jp":           true,
	"karelia.ru":                true,
	"karelia.su":                true,
	"karikatur.museum":          true,
	"kariwa.niigata.jp":         true,
	"kariya.aichi.jp":           true,
	"karlsoy.no":                true,
	"karmoy.no":                 true,
	"karpacz.pl":                true,
	"kartuzy.pl":                true,
	"karuizawa.nagano.jp":       true,
	"karumai.iwate.jp":          true,
	"kasahara.gifu.jp":          true,
	"kasai.hyogo.jp":            true,
	"kasama.ibaraki.jp":         true,
	"kasamatsu.gifu.jp":         true,
	"kasaoka.okayama.jp":        true,
	"kashiba.nara.jp":           true,
	"kashihara.nara.jp":         true,
	"kashima.ibaraki.jp":        true,
	"kashima.kumamoto.jp":       true,
	"kashima.saga.jp":           true,
	"kashiwa.chiba.jp":          true,
	"kashiwara.osaka.jp":        true,
	"kashiwazaki.niigata.jp":    true,
	"kasuga.fukuoka.jp":         true,
	"kasuga.hyogo.jp":           true,
	"kasugai.aichi.jp":          true,
	"kasukabe.saitama.jp":       true,
	"kasumigaura.ibaraki.jp":    true,
	"kasuya.fukuoka.jp":         true,
	"kaszuby.pl":                true,
	"katagami.akita.jp":         true,
	"katano.osaka.jp":           true,
	"katashina.gunma.jp":        true,
	"katori.chiba.jp":           true,
	"katowice.pl":               true,
	"katsuragi.nara.jp":         true,
	"katsuragi.wakayama.jp":     true,
	"katsushika.tokyo.jp":       true,
	"katsuura.chiba.jp":         true,
	"katsuyama.fukui.jp":        true,
	"kaufen":                    true,
	"kautokeino.no":             true,
	"kawaba.gunma.jp":           true,
	"kawachinagano.osaka.jp":    true,
	"kawagoe.mie.jp":            true,
	"kawagoe.saitama.jp":        true,
	"kawaguchi.saitama.jp":      true,
	"kawahara.tottori.jp":       true,
	"kawai.iwate.jp":            true,
	"kawai.nara.jp":             true,
	"kawajima.saitama.jp":       true,
	"kawakami.nagano.jp":        true,
	"kawakami.nara.jp":          true,
	"kawakita.ishikawa.jp":      true,
	"kawamata.fukushima.jp":     true,
	"kawaminami.miyazaki.jp":    true,
	"kawanabe.kagoshima.jp":     true,
	"kawanehon.shizuoka.jp":     true,
	"kawanishi.hyogo.jp":        true,
	"kawanishi.nara.jp":         true,
	"kawanishi.yamagata.jp":     true,
	"kawara.fukuoka.jp":         true,
	"kawasaki.jp":               true,
	"kawasaki.miyagi.jp":        true,
	"kawatana.nagasaki.jp":      true,
	"kawaue.gifu.jp":            true,
	"kawazu.shizuoka.jp":        true,
	"kayabe.hokkaido.jp":        true,
	"kazan.ru":                  true,
	"kazo.saitama.jp":           true,
	"kazuno.akita.jp":           true,
	"kchr.ru":                   true,
	"kddi":                      true,
	"ke":                        true,
	"keisen.fukuoka.jp":         true,
	"kembuchi.hokkaido.jp":      true,
	"kemerovo.ru":               true,
	"kep.tr":                    true,
	"kepno.pl":                  true,
	"kesennuma.miyagi.jp":       true,
	"ketrzyn.pl":                true,
	"kfh":                       true,
	"kg":                        true,
	"kg.kr":                     true,
	"kh":                        true,
	"kh.ua":                     true,
	"khabarovsk.ru":             true,
	"khakassia.ru":              true,
	"khakassia.su":              true,
	"kharkiv.ua":                true,
	"kharkov.ua":                true,
	"kherson.ua":                true,
	"khmelnitskiy.ua":           true,
	"khmelnytskyi.ua":           true,
	"khv.ru":                    true,
	"ki":                        true,
	"kibichuo.okayama.jp":  true,
	"kids.museum":          true,
	"kids.us":              true,
	"kiev.ua":              true,
	"kiho.mie.jp":          true,
	"kihoku.ehime.jp":      true,
	"kijo.miyazaki.jp":     true,
	"kikonai.hokkaido.jp":  true,
	"kikuchi.kumamoto.jp":  true,
	"kikugawa.shizuoka.jp": true,
	"kim":                       true,
	"kimino.wakayama.jp":        true,
	"kimitsu.chiba.jp":          true,
	"kimobetsu.hokkaido.jp":     true,
	"kin.okinawa.jp":            true,
	"kinder":                    true,
	"kinko.kagoshima.jp":        true,
	"kinokawa.wakayama.jp":      true,
	"kira.aichi.jp":             true,
	"kirkenes.no":               true,
	"kirov.ru":                  true,
	"kirovograd.ua":             true,
	"kiryu.gunma.jp":            true,
	"kisarazu.chiba.jp":         true,
	"kishiwada.osaka.jp":        true,
	"kiso.nagano.jp":            true,
	"kisofukushima.nagano.jp":   true,
	"kisosaki.mie.jp":           true,
	"kita.kyoto.jp":             true,
	"kita.osaka.jp":             true,
	"kita.tokyo.jp":             true,
	"kitaaiki.nagano.jp":        true,
	"kitaakita.akita.jp":        true,
	"kitadaito.okinawa.jp":      true,
	"kitagata.gifu.jp":          true,
	"kitagata.saga.jp":          true,
	"kitagawa.kochi.jp":         true,
	"kitagawa.miyazaki.jp":      true,
	"kitahata.saga.jp":          true,
	"kitahiroshima.hokkaido.jp": true,
	"kitakami.iwate.jp":         true,
	"kitakata.fukushima.jp":     true,
	"kitakata.miyazaki.jp":      true,
	"kitakyushu.jp":             true,
	"kitami.hokkaido.jp":        true,
	"kitamoto.saitama.jp":       true,
	"kitanakagusuku.okinawa.jp": true,
	"kitashiobara.fukushima.jp": true,
	"kitaura.miyazaki.jp":       true,
	"kitayama.wakayama.jp":      true,
	"kitchen":                   true,
	"kiwa.mie.jp":               true,
	"kiwi":                      true,
	"kiwi.nz":                   true,
	"kiyama.saga.jp":            true,
	"kiyokawa.kanagawa.jp":      true,
	"kiyosato.hokkaido.jp":      true,
	"kiyose.tokyo.jp":           true,
	"kiyosu.aichi.jp":           true,
	"kizu.kyoto.jp":             true,
	"klabu.no":                  true,
	"klepp.no":                  true,
	"klodzko.pl":                true,
	"km":                        true,
	"km.ua":                     true,
	"kms.ru":                    true,
	"kn":                        true,
	"knowsitall.info":           true,
	"kobayashi.miyazaki.jp":     true,
	"kobe.jp":                   true,
	"kobierzyce.pl":             true,
	"kochi.jp":                  true,
	"kochi.kochi.jp":            true,
	"kodaira.tokyo.jp":          true,
	"koebenhavn.museum":         true,
	"koeln":                     true,
	"koeln.museum":              true,
	"koenig.ru":                 true,
	"kofu.yamanashi.jp":         true,
	"koga.fukuoka.jp":           true,
	"koga.ibaraki.jp":           true,
	"koganei.tokyo.jp":          true,
	"koge.tottori.jp":           true,
	"koka.shiga.jp":             true,
	"kokonoe.oita.jp":           true,
	"kokubunji.tokyo.jp":        true,
	"kolobrzeg.pl":              true,
	"komae.tokyo.jp":            true,
	"komagane.nagano.jp":        true,
	"komaki.aichi.jp":           true,
	"komatsu":                   true,
	"komatsu.ishikawa.jp":       true,
	"komatsushima.tokushima.jp": true,
	"komforb.se":                true,
	"komi.ru":                   true,
	"kommunalforbund.se":        true,
	"kommune.no":                true,
	"komono.mie.jp":             true,
	"komoro.nagano.jp":          true,
	"komvux.se":                 true,
	"konan.aichi.jp":            true,
	"konan.shiga.jp":            true,
	"kongsberg.no":              true,
	"kongsvinger.no":            true,
	"konin.pl":                  true,
	"konskowola.pl":             true,
	"konyvelo.hu":               true,
	"koori.fukushima.jp":        true,
	"kopervik.no":               true,
	"koriyama.fukushima.jp":     true,
	"koryo.nara.jp":             true,
	"kosa.kumamoto.jp":          true,
	"kosai.shizuoka.jp":         true,
	"kosaka.akita.jp":           true,
	"kosei.shiga.jp":            true,
	"koshigaya.saitama.jp":      true,
	"koshimizu.hokkaido.jp":     true,
	"koshu.yamanashi.jp":        true,
	"kostroma.ru":               true,
	"kosuge.yamanashi.jp":       true,
	"kota.aichi.jp":             true,
	"koto.shiga.jp":             true,
	"koto.tokyo.jp":             true,
	"kotohira.kagawa.jp":        true,
	"kotoura.tottori.jp":        true,
	"kouhoku.saga.jp":           true,
	"kounosu.saitama.jp":        true,
	"kouyama.kagoshima.jp":      true,
	"kouzushima.tokyo.jp":       true,
	"koya.wakayama.jp":          true,
	"koza.wakayama.jp":          true,
	"kozagawa.wakayama.jp":      true,
	"kozaki.chiba.jp":           true,
	"kp":                        true,
	"kpn":                       true,
	"kr":                        true,
	"kr.com":                    true,
	"kr.it":                     true,
	"kr.ua":                     true,
	"kraanghke.no":              true,
	"kragero.no":                true,
	"krakow.pl":                 true,
	"krasnodar.su":              true,
	"krasnoyarsk.ru":            true,
	"krd":                       true,
	"kred":                      true,
	"kristiansand.no":           true,
	"kristiansund.no":           true,
	"krodsherad.no":             true,
	"krokstadelva.no":           true,
	"krym.ua":                   true,
	"ks.ua":                     true,
	"ks.us":                     true,
	"kuban.ru":                  true,
	"kuchinotsu.nagasaki.jp":    true,
	"kudamatsu.yamaguchi.jp":    true,
	"kudoyama.wakayama.jp":      true,
	"kui.hiroshima.jp":          true,
	"kuji.iwate.jp":             true,
	"kuju.oita.jp":              true,
	"kujukuri.chiba.jp":         true,
	"kuki.saitama.jp":           true,
	"kumagaya.saitama.jp":       true,
	"kumakogen.ehime.jp":        true,
	"kumamoto.jp":               true,
	"kumamoto.kumamoto.jp":      true,
	"kumano.hiroshima.jp":       true,
	"kumano.mie.jp":             true,
	"kumatori.osaka.jp":         true,
	"kumejima.okinawa.jp":       true,
	"kumenan.okayama.jp":        true,
	"kumiyama.kyoto.jp":         true,
	"kunigami.okinawa.jp":       true,
	"kunimi.fukushima.jp":       true,
	"kunisaki.oita.jp":          true,
	"kunitachi.tokyo.jp":        true,
	"kunitomi.miyazaki.jp":      true,
	"kunneppu.hokkaido.jp":      true,
	"kunohe.iwate.jp":           true,
	"kunst.museum":              true,
	"kunstsammlung.museum":      true,
	"kunstunddesign.museum":     true,
	"kurashiki.okayama.jp":      true,
	"kurate.fukuoka.jp":         true,
	"kure.hiroshima.jp":         true,
	"kurgan.ru":                 true,
	"kurgan.su":                 true,
	"kuriyama.hokkaido.jp":      true,
	"kurobe.toyama.jp":          true,
	"kurogi.fukuoka.jp":         true,
	"kuroishi.aomori.jp":        true,
	"kuroiso.tochigi.jp":        true,
	"kuromatsunai.hokkaido.jp":  true,
	"kurotaki.nara.jp":          true,
	"kursk.ru":                  true,
	"kurume.fukuoka.jp":         true,
	"kusatsu.gunma.jp":          true,
	"kusatsu.shiga.jp":          true,
	"kushima.miyazaki.jp":       true,
	"kushimoto.wakayama.jp":     true,
	"kushiro.hokkaido.jp":       true,
	"kustanai.ru":               true,
	"kusu.oita.jp":              true,
	"kutchan.hokkaido.jp":       true,
	"kutno.pl":                  true,
	"kuwana.mie.jp":             true,
	"kuzbass.ru":                true,
	"kuzumaki.iwate.jp":         true,
	"kv.ua":                     true,
	"kvafjord.no":               true,
	"kvalsund.no":               true,
	"kvam.no":                   true,
	"kvanangen.no":              true,
	"kvinesdal.no":              true,
	"kvinnherad.no":             true,
	"kviteseid.no":              true,
	"kvitsoy.no":                true,
	"kw":                        true,
	"ky":                        true,
	"ky.us":                     true,
	"kyiv.ua":                   true,
	"kyonan.chiba.jp":           true,
	"kyotamba.kyoto.jp":         true,
	"kyotanabe.kyoto.jp":        true,
	"kyotango.kyoto.jp":         true,
	"kyoto":                     true,
	"kyoto.jp":                  true,
	"kyowa.akita.jp":            true,
	"kyowa.hokkaido.jp":         true,
	"kyuragi.saga.jp":           true,
	"kz":                        true,
	"l.bg":                      true,
	"l.se":                      true,
	"la":                        true,
	"la.us":                     true,
	"laakesvuemie.no":           true,
	"labor.museum":              true,
	"labour.museum":             true,
	"lacaixa":                   true,
	"lahppi.no":                 true,
	"lajolla.museum":            true,
	"lakas.hu":                  true,
	"lanbib.se":                 true,
	"lancashire.museum":         true,
	"land":                      true,
	"landes.museum":             true,
	"landrover":                 true,
	"langevag.no":               true,
	"lans.museum":               true,
	"lapy.pl":                   true,
	"laquila.it":                true,
	"lardal.no":                 true,
	"larsson.museum":            true,
	"larvik.no":                 true,
	"laspezia.it":               true,
	"lat":                       true,
	"latina.it":                 true,
	"latrobe":                   true,
	"lavagis.no":                true,
	"lavangen.no":               true,
	"law":                       true,
	"law.pro":                   true,
	"lawyer":                    true,
	"laz.it":                    true,
	"lazio.it":                  true,
	"lb":                        true,
	"lc":                        true,
	"lc.it":                     true,
	"lds":                       true,
	"le.it":                     true,
	"leangaviika.no":            true,
	"lease":                     true,
	"leasing.aero":              true,
	"lebesby.no":                true,
	"lebork.pl":                 true,
	"lebtimnetz.de":             true,
	"lecce.it":                  true,
	"lecco.it":                  true,
	"leclerc":                   true,
	"leg.br":                    true,
	"legal":                     true,
	"legnica.pl":                true,
	"leikanger.no":              true,
	"leirfjord.no":              true,
	"leirvik.no":                true,
	"leitungsen.de":             true,
	"leka.no":                   true,
	"leksvik.no":                true,
	"lel.br":                    true,
	"lenug.su":                  true,
	"lenvik.no":                 true,
	"lerdal.no":                 true,
	"lesja.no":                  true,
	"levanger.no":               true,
	"lewismiller.museum":        true,
	"lezajsk.pl":                true,
	"lg.jp":                     true,
	"lg.ua":                     true,
	"lgbt":                      true,
	"li":                        true,
	"li.it":                     true,
	"liaison":                   true,
	"lib.ak.us":                 true,
	"lib.al.us":                 true,
	"lib.ar.us":                 true,
	"lib.as.us":                 true,
	"lib.az.us":                 true,
	"lib.ca.us":                 true,
	"lib.co.us":                 true,
	"lib.ct.us":                 true,
	"lib.dc.us":                 true,
	"lib.de.us":                 true,
	"lib.ee":                    true,
	"lib.fl.us":                 true,
	"lib.ga.us":                 true,
	"lib.gu.us":                 true,
	"lib.hi.us":                 true,
	"lib.ia.us":                 true,
	"lib.id.us":                 true,
	"lib.il.us":                 true,
	"lib.in.us":                 true,
	"lib.ks.us":                 true,
	"lib.ky.us":                 true,
	"lib.la.us":                 true,
	"lib.ma.us":                 true,
	"lib.md.us":                 true,
	"lib.me.us":                 true,
	"lib.mi.us":                 true,
	"lib.mn.us":                 true,
	"lib.mo.us":                 true,
	"lib.ms.us":                 true,
	"lib.mt.us":                 true,
	"lib.nc.us":                 true,
	"lib.nd.us":                 true,
	"lib.ne.us":                 true,
	"lib.nh.us":                 true,
	"lib.nj.us":                 true,
	"lib.nm.us":                 true,
	"lib.nv.us":                 true,
	"lib.ny.us":                 true,
	"lib.oh.us":                 true,
	"lib.ok.us":                 true,
	"lib.or.us":                 true,
	"lib.pa.us":                 true,
	"lib.pr.us":                 true,
	"lib.ri.us":                 true,
	"lib.sc.us":                 true,
	"lib.sd.us":                 true,
	"lib.tn.us":                 true,
	"lib.tx.us":                 true,
	"lib.ut.us":                 true,
	"lib.va.us":                 true,
	"lib.vi.us":                 true,
	"lib.vt.us":                 true,
	"lib.wa.us":                 true,
	"lib.wi.us":                 true,
	"lib.wy.us":                 true,
	"lidl":                      true,
	"lier.no":                   true,
	"lierne.no":                 true,
	"life":                      true,
	"lifeinsurance":             true,
	"lifestyle":                 true,
	"lig.it":                    true,
	"lighting":                  true,
	"liguria.it":                true,
	"like":                      true,
	"likescandy.com":            true,
	"lillehammer.no":            true,
	"lillesand.no":              true,
	"limanowa.pl":               true,
	"limited":                   true,
	"limo":                      true,
	"lincoln":                   true,
	"lincoln.museum":            true,
	"lindas.no":                 true,
	"linde":                     true,
	"lindesnes.no":              true,
	"link":                      true,
	"linz.museum":               true,
	"lipetsk.ru":                true,
	"live":                      true,
	"living.museum":             true,
	"livinghistory.museum":      true,
	"livorno.it":                true,
	"lk":                        true,
	"ln.cn":                     true,
	"lo.it":                     true,
	"loabat.no":                 true,
	"loan":                      true,
	"loans":                     true,
	"localhistory.museum":       true,
	"lodi.it":                   true,
	"lodingen.no":               true,
	"logistics.aero":            true,
	"lom.it":                    true,
	"lom.no":                    true,
	"lombardia.it":              true,
	"lombardy.it":               true,
	"lomza.pl":                  true,
	"london":                    true,
	"london.museum":             true,
	"loppa.no":                  true,
	"lorenskog.no":              true,
	"losangeles.museum":         true,
	"loten.no":                  true,
	"lotte":                     true,
	"lotto":                     true,
	"louvre.museum":             true,
	"love":                      true,
	"lowicz.pl":                 true,
	"loyalist.museum":           true,
	"lr":                        true,
	"ls":                        true,
	"lt":                        true,
	"lt.it":                     true,
	"lt.ua":                     true,
	"ltd":                       true,
	"ltd.co.im":                 true,
	"ltd.gi":                    true,
	"ltd.hk":                    true,
	"ltd.lk":                    true,
	"ltd.uk":                    true,
	"ltda":                      true,
	"lu":                        true,
	"lu.it":                     true,
	"lubin.pl":                  true,
	"lucania.it":                true,
	"lucca.it":                  true,
	"lucerne.museum":            true,
	"lugansk.ua":                true,
	"lukow.pl":                  true,
	"lund.no":                   true,
	"lunner.no":                 true,
	"lupin":                     true,
	"luroy.no":                  true,
	"luster.no":                 true,
	"lutsk.ua":                  true,
	"luxe":                      true,
	"luxembourg.museum":         true,
	"luxury":                    true,
	"luzern.museum":             true,
	"lv":                        true,
	"lv.ua":                     true,
	"lviv.ua":                   true,
	"ly":                        true,
	"lyngdal.no":                true,
	"lyngen.no":                 true,
	"m.bg":                      true,
	"m.se":                      true,
	"ma":                        true,
	"ma.us":                     true,
	"macerata.it":               true,
	"machida.tokyo.jp":          true,
	"mad.museum":                true,
	"madrid":                    true,
	"madrid.museum":             true,
	"maebashi.gunma.jp":         true,
	"magadan.ru":                true,
	"magazine.aero":             true,
	"magnitka.ru":               true,
	"maibara.shiga.jp":          true,
	"maif":                      true,
	"mail.pl":                   true,
	"maintenance.aero":          true,
	"maison":                    true,
	"maizuru.kyoto.jp":          true,
	"makeup":                    true,
	"makinohara.shizuoka.jp":    true,
	"makurazaki.kagoshima.jp":   true,
	"malatvuopmi.no":            true,
	"malbork.pl":                true,
	"mallorca.museum":           true,
	"malopolska.pl":             true,
	"malselv.no":                true,
	"malvik.no":                 true,
	"mamurogawa.yamagata.jp":    true,
	"man":                         true,
	"management":                  true,
	"manchester.museum":           true,
	"mandal.no":                   true,
	"mango":                       true,
	"maniwa.okayama.jp":           true,
	"manno.kagawa.jp":             true,
	"mansion.museum":              true,
	"mansions.museum":             true,
	"mantova.it":                  true,
	"manx.museum":                 true,
	"maori.nz":                    true,
	"mar.it":                      true,
	"marburg.museum":              true,
	"marche.it":                   true,
	"mari.ru":                     true,
	"marine.ru":                   true,
	"maritime.museum":             true,
	"maritimo.museum":             true,
	"marker.no":                   true,
	"market":                      true,
	"marketing":                   true,
	"marketplace.aero":            true,
	"markets":                     true,
	"marnardal.no":                true,
	"marriott":                    true,
	"marugame.kagawa.jp":          true,
	"marumori.miyagi.jp":          true,
	"maryland.museum":             true,
	"marylhurst.museum":           true,
	"masaki.ehime.jp":             true,
	"masfjorden.no":               true,
	"mashike.hokkaido.jp":         true,
	"mashiki.kumamoto.jp":         true,
	"mashiko.tochigi.jp":          true,
	"masoy.no":                    true,
	"massacarrara.it":             true,
	"masuda.shimane.jp":           true,
	"mat.br":                      true,
	"matera.it":                   true,
	"matsubara.osaka.jp":          true,
	"matsubushi.saitama.jp":       true,
	"matsuda.kanagawa.jp":         true,
	"matsudo.chiba.jp":            true,
	"matsue.shimane.jp":           true,
	"matsukawa.nagano.jp":         true,
	"matsumae.hokkaido.jp":        true,
	"matsumoto.kagoshima.jp":      true,
	"matsumoto.nagano.jp":         true,
	"matsuno.ehime.jp":            true,
	"matsusaka.mie.jp":            true,
	"matsushige.tokushima.jp":     true,
	"matsushima.miyagi.jp":        true,
	"matsuura.nagasaki.jp":        true,
	"matsuyama.ehime.jp":          true,
	"matsuzaki.shizuoka.jp":       true,
	"mazowsze.pl":                 true,
	"mazury.pl":                   true,
	"mb.ca":                       true,
	"mb.it":                       true,
	"mc":                          true,
	"mc.it":                       true,
	"md":                          true,
	"md.ci":                       true,
	"md.us":                       true,
	"me":                          true,
	"me.it":                       true,
	"me.tz":                       true,
	"me.uk":                       true,
	"me.us":                       true,
	"med.br":                      true,
	"med.ec":                      true,
	"med.ee":                      true,
	"med.ht":                      true,
	"med.ly":                      true,
	"med.om":                      true,
	"med.pa":                      true,
	"med.pl":                      true,
	"med.pro":                     true,
	"med.sa":                      true,
	"med.sd":                      true,
	"medecin.fr":                  true,
	"medecin.km":                  true,
	"media":                       true,
	"media.aero":                  true,
	"media.hu":                    true,
	"media.museum":                true,
	"media.pl":                    true,
	"medical.museum":              true,
	"mediocampidano.it":           true,
	"medizinhistorisches.museum":  true,
	"meeres.museum":               true,
	"meet":                        true,
	"meguro.tokyo.jp":             true,
	"meiwa.gunma.jp":              true,
	"meiwa.mie.jp":                true,
	"meland.no":                   true,
	"melbourne":                   true,
	"meldal.no":                   true,
	"melhus.no":                   true,
	"meloy.no":                    true,
	"meme":                        true,
	"memorial":                    true,
	"memorial.museum":             true,
	"menu":                        true,
	"meo":                         true,
	"meraker.no":                  true,
	"merseine.nu":                 true,
	"mesaverde.museum":            true,
	"messina.it":                  true,
	"mex.com":                     true,
	"mg":                          true,
	"mh":                          true,
	"mi.it":                       true,
	"mi.th":                       true,
	"mi.us":                       true,
	"miami":                       true,
	"miasa.nagano.jp":             true,
	"miasta.pl":                   true,
	"mibu.tochigi.jp":             true,
	"michigan.museum":             true,
	"microlight.aero":             true,
	"microsoft":                   true,
	"midatlantic.museum":          true,
	"midori.chiba.jp":             true,
	"midori.gunma.jp":             true,
	"midsund.no":                  true,
	"mie.jp":                      true,
	"mielec.pl":                   true,
	"mielno.pl":                   true,
	"mifune.kumamoto.jp":          true,
	"mihama.aichi.jp":             true,
	"mihama.chiba.jp":             true,
	"mihama.fukui.jp":             true,
	"mihama.mie.jp":               true,
	"mihama.wakayama.jp":          true,
	"mihara.hiroshima.jp":         true,
	"mihara.kochi.jp":             true,
	"miharu.fukushima.jp":         true,
	"miho.ibaraki.jp":             true,
	"mikasa.hokkaido.jp":          true,
	"mikawa.yamagata.jp":          true,
	"miki.hyogo.jp":               true,
	"mil":                         true,
	"mil.ac":                      true,
	"mil.ae":                      true,
	"mil.al":                      true,
	"mil.ar":                      true,
	"mil.az":                      true,
	"mil.ba":                      true,
	"mil.bo":                      true,
	"mil.br":                      true,
	"mil.by":                      true,
	"mil.cl":                      true,
	"mil.cn":                      true,
	"mil.co":                      true,
	"mil.do":                      true,
	"mil.ec":                      true,
	"mil.eg":                      true,
	"mil.ge":                      true,
	"mil.gh":                      true,
	"mil.gt":                      true,
	"mil.hn":                      true,
	"mil.id":                      true,
	"mil.in":                      true,
	"mil.iq":                      true,
	"mil.jo":                      true,
	"mil.kg":                      true,
	"mil.km":                      true,
	"mil.kr":                      true,
	"mil.kz":                      true,
	"mil.lv":                      true,
	"mil.mg":                      true,
	"mil.mv":                      true,
	"mil.my":                      true,
	"mil.ng":                      true,
	"mil.no":                      true,
	"mil.nz":                      true,
	"mil.pe":                      true,
	"mil.ph":                      true,
	"mil.pl":                      true,
	"mil.py":                      true,
	"mil.qa":                      true,
	"mil.ru":                      true,
	"mil.rw":                      true,
	"mil.sh":                      true,
	"mil.st":                      true,
	"mil.sy":                      true,
	"mil.tj":                      true,
	"mil.tm":                      true,
	"mil.to":                      true,
	"mil.tr":                      true,
	"mil.tw":                      true,
	"mil.tz":                      true,
	"mil.uy":                      true,
	"mil.vc":                      true,
	"mil.ve":                      true,
	"milan.it":                    true,
	"milano.it":                   true,
	"military.museum":             true,
	"mill.museum":                 true,
	"mima.tokushima.jp":           true,
	"mimata.miyazaki.jp":          true,
	"minakami.gunma.jp":           true,
	"minamata.kumamoto.jp":        true,
	"minami.fukuoka.jp":           true,
	"minami.kyoto.jp":             true,
	"minami.tokushima.jp":         true,
	"minamiaiki.nagano.jp":        true,
	"minamiashigara.kanagawa.jp":  true,
	"minamiawaji.hyogo.jp":        true,
	"minamiboso.chiba.jp":         true,
	"minamidaito.okinawa.jp":      true,
	"minamiechizen.fukui.jp":      true,
	"minamifurano.hokkaido.jp":    true,
	"minamiise.mie.jp":            true,
	"minamiizu.shizuoka.jp":       true,
	"minamimaki.nagano.jp":        true,
	"minamiminowa.nagano.jp":      true,
	"minamioguni.kumamoto.jp":     true,
	"minamisanriku.miyagi.jp":     true,
	"minamitane.kagoshima.jp":     true,
	"minamiuonuma.niigata.jp":     true,
	"minamiyamashiro.kyoto.jp":    true,
	"minano.saitama.jp":           true,
	"minato.osaka.jp":             true,
	"minato.tokyo.jp":             true,
	"mincom.tn":                   true,
	"mine.nu":                     true,
	"miners.museum":               true,
	"mini":                        true,
	"mining.museum":               true,
	"minnesota.museum":            true,
	"mino.gifu.jp":                true,
	"minobu.yamanashi.jp":         true,
	"minoh.osaka.jp":              true,
	"minokamo.gifu.jp":            true,
	"minowa.nagano.jp":            true,
	"misaki.okayama.jp":           true,
	"misaki.osaka.jp":             true,
	"misasa.tottori.jp":           true,
	"misato.akita.jp":             true,
	"misato.miyagi.jp":            true,
	"misato.saitama.jp":           true,
	"misato.shimane.jp":           true,
	"misato.wakayama.jp":          true,
	"misawa.aomori.jp":            true,
	"misconfused.org":             true,
	"mishima.fukushima.jp":        true,
	"mishima.shizuoka.jp":         true,
	"missile.museum":              true,
	"missoula.museum":             true,
	"misugi.mie.jp":               true,
	"mitaka.tokyo.jp":             true,
	"mitake.gifu.jp":              true,
	"mitane.akita.jp":             true,
	"mito.ibaraki.jp":             true,
	"mitou.yamaguchi.jp":          true,
	"mitoyo.kagawa.jp":            true,
	"mitsue.nara.jp":              true,
	"mitsuke.niigata.jp":          true,
	"miura.kanagawa.jp":           true,
	"miyada.nagano.jp":            true,
	"miyagi.jp":                   true,
	"miyake.nara.jp":              true,
	"miyako.fukuoka.jp":           true,
	"miyako.iwate.jp":             true,
	"miyakonojo.miyazaki.jp":      true,
	"miyama.fukuoka.jp":           true,
	"miyama.mie.jp":               true,
	"miyashiro.saitama.jp":        true,
	"miyawaka.fukuoka.jp":         true,
	"miyazaki.jp":                 true,
	"miyazaki.miyazaki.jp":        true,
	"miyazu.kyoto.jp":             true,
	"miyoshi.aichi.jp":            true,
	"miyoshi.hiroshima.jp":        true,
	"miyoshi.saitama.jp":          true,
	"miyoshi.tokushima.jp":        true,
	"miyota.nagano.jp":            true,
	"mizuho.tokyo.jp":             true,
	"mizumaki.fukuoka.jp":         true,
	"mizunami.gifu.jp":            true,
	"mizusawa.iwate.jp":           true,
	"mjondalen.no":                true,
	"mk":                          true,
	"mk.ua":                       true,
	"ml":                          true,
	"mm":                          true,
	"mma":                         true,
	"mn":                          true,
	"mn.it":                       true,
	"mn.us":                       true,
	"mo":                          true,
	"mo.cn":                       true,
	"mo.it":                       true,
	"mo.us":                       true,
	"moareke.no":                  true,
	"mobara.chiba.jp":             true,
	"mobi":                        true,
	"mobi.gp":                     true,
	"mobi.na":                     true,
	"mobi.ng":                     true,
	"mobi.tt":                     true,
	"mobi.tz":                     true,
	"mobily":                      true,
	"mochizuki.nagano.jp":         true,
	"mod.gi":                      true,
	"moda":                        true,
	"modalen.no":                  true,
	"modelling.aero":              true,
	"modena.it":                   true,
	"modern.museum":               true,
	"modum.no":                    true,
	"moe":                         true,
	"moi":                         true,
	"moka.tochigi.jp":             true,
	"mol.it":                      true,
	"molde.no":                    true,
	"molise.it":                   true,
	"moma.museum":                 true,
	"mombetsu.hokkaido.jp":        true,
	"monash":                      true,
	"money":                       true,
	"money.museum":                true,
	"monmouth.museum":             true,
	"montblanc":                   true,
	"monticello.museum":           true,
	"montreal.museum":             true,
	"monza.it":                    true,
	"monzabrianza.it":             true,
	"monzaebrianza.it":            true,
	"monzaedellabrianza.it":       true,
	"mordovia.ru":                 true,
	"mordovia.su":                 true,
	"moriguchi.osaka.jp":          true,
	"morimachi.shizuoka.jp":       true,
	"morioka.iwate.jp":            true,
	"moriya.ibaraki.jp":           true,
	"moriyama.shiga.jp":           true,
	"moriyoshi.akita.jp":          true,
	"mormon":                      true,
	"morotsuka.miyazaki.jp":       true,
	"moroyama.saitama.jp":         true,
	"mortgage":                    true,
	"moscow":                      true,
	"moscow.museum":               true,
	"moseushi.hokkaido.jp":        true,
	"mosjoen.no":                  true,
	"moskenes.no":                 true,
	"moss.no":                     true,
	"mosvik.no":                   true,
	"motegi.tochigi.jp":           true,
	"motobu.okinawa.jp":           true,
	"motorcycle.museum":           true,
	"motorcycles":                 true,
	"motosu.gifu.jp":              true,
	"motoyama.kochi.jp":           true,
	"mov":                         true,
	"movistar":                    true,
	"mp":                          true,
	"mp.br":                       true,
	"mq":                          true,
	"mr":                          true,
	"mr.no":                       true,
	"mragowo.pl":                  true,
	"ms":                          true,
	"ms.it":                       true,
	"ms.kr":                       true,
	"ms.us":                       true,
	"msk.ru":                      true,
	"msk.su":                      true,
	"mt":                          true,
	"mt.it":                       true,
	"mt.us":                       true,
	"mtn":                         true,
	"mtpc":                        true,
	"mu":                          true,
	"muenchen.museum":             true,
	"muenster.museum":             true,
	"mugi.tokushima.jp":           true,
	"muika.niigata.jp":            true,
	"mukawa.hokkaido.jp":          true,
	"muko.kyoto.jp":               true,
	"mulhouse.museum":             true,
	"munakata.fukuoka.jp":         true,
	"muncie.museum":               true,
	"muosat.no":                   true,
	"murakami.niigata.jp":         true,
	"murata.miyagi.jp":            true,
	"murayama.yamagata.jp":        true,
	"murmansk.ru":                 true,
	"murmansk.su":                 true,
	"muroran.hokkaido.jp":         true,
	"muroto.kochi.jp":             true,
	"mus.br":                      true,
	"musashimurayama.tokyo.jp":    true,
	"musashino.tokyo.jp":          true,
	"museet.museum":               true,
	"museum":                      true,
	"museum.mv":                   true,
	"museum.mw":                   true,
	"museum.no":                   true,
	"museum.om":                   true,
	"museum.tt":                   true,
	"museumcenter.museum":         true,
	"museumvereniging.museum":     true,
	"music.museum":                true,
	"mutsu.aomori.jp":             true,
	"mutsuzawa.chiba.jp":          true,
	"mv":                          true,
	"mw":                          true,
	"mx":                          true,
	"mx.na":                       true,
	"my":                          true,
	"my.id":                       true,
	"mykolaiv.ua":                 true,
	"myoko.niigata.jp":            true,
	"mypets.ws":                   true,
	"myphotos.cc":                 true,
	"mytis.ru":                    true,
	"mz":                          true,
	"n.bg":                        true,
	"n.se":                        true,
	"na":                          true,
	"na.it":                       true,
	"naamesjevuemie.no":           true,
	"nabari.mie.jp":               true,
	"nachikatsuura.wakayama.jp":   true,
	"nadex":                       true,
	"nagahama.shiga.jp":           true,
	"nagai.yamagata.jp":           true,
	"nagano.jp":                   true,
	"nagano.nagano.jp":            true,
	"naganohara.gunma.jp":         true,
	"nagaoka.niigata.jp":          true,
	"nagaokakyo.kyoto.jp":         true,
	"nagara.chiba.jp":             true,
	"nagareyama.chiba.jp":         true,
	"nagasaki.jp":                 true,
	"nagasaki.nagasaki.jp":        true,
	"nagasu.kumamoto.jp":          true,
	"nagato.yamaguchi.jp":         true,
	"nagatoro.saitama.jp":         true,
	"nagawa.nagano.jp":            true,
	"nagi.okayama.jp":             true,
	"nagiso.nagano.jp":            true,
	"nago.okinawa.jp":             true,
	"nagoya":                      true,
	"nagoya.jp":                   true,
	"naha.okinawa.jp":             true,
	"nahari.kochi.jp":             true,
	"naie.hokkaido.jp":            true,
	"naka.hiroshima.jp":           true,
	"naka.ibaraki.jp":             true,
	"nakadomari.aomori.jp":        true,
	"nakagawa.fukuoka.jp":         true,
	"nakagawa.hokkaido.jp":        true,
	"nakagawa.nagano.jp":          true,
	"nakagawa.tokushima.jp":       true,
	"nakagusuku.okinawa.jp":       true,
	"nakagyo.kyoto.jp":            true,
	"nakai.kanagawa.jp":           true,
	"nakama.fukuoka.jp":           true,
	"nakamichi.yamanashi.jp":      true,
	"nakamura.kochi.jp":           true,
	"nakaniikawa.toyama.jp":       true,
	"nakano.nagano.jp":            true,
	"nakano.tokyo.jp":             true,
	"nakanojo.gunma.jp":           true,
	"nakanoto.ishikawa.jp":        true,
	"nakasatsunai.hokkaido.jp":    true,
	"nakatane.kagoshima.jp":       true,
	"nakatombetsu.hokkaido.jp":    true,
	"nakatsugawa.gifu.jp":         true,
	"nakayama.yamagata.jp":        true,
	"nakhodka.ru":                 true,
	"nakijin.okinawa.jp":          true,
	"naklo.pl":                    true,
	"nalchik.ru":                  true,
	"nalchik.su":                  true,
	"namdalseid.no":               true,
	"name":                        true,
	"name.az":                     true,
	"name.eg":                     true,
	"name.et":                     true,
	"name.hr":                     true,
	"name.jo":                     true,
	"name.mk":                     true,
	"name.mv":                     true,
	"name.my":                     true,
	"name.na":                     true,
	"name.ng":                     true,
	"name.pr":                     true,
	"name.qa":                     true,
	"name.tj":                     true,
	"name.tr":                     true,
	"name.tt":                     true,
	"name.vn":                     true,
	"namegata.ibaraki.jp":         true,
	"namegawa.saitama.jp":         true,
	"namerikawa.toyama.jp":        true,
	"namie.fukushima.jp":          true,
	"namikata.ehime.jp":           true,
	"namsos.no":                   true,
	"namsskogan.no":               true,
	"nanae.hokkaido.jp":           true,
	"nanao.ishikawa.jp":           true,
	"nanbu.tottori.jp":            true,
	"nanbu.yamanashi.jp":          true,
	"nango.fukushima.jp":          true,
	"nanjo.okinawa.jp":            true,
	"nankoku.kochi.jp":            true,
	"nanmoku.gunma.jp":            true,
	"nannestad.no":                true,
	"nanporo.hokkaido.jp":         true,
	"nantan.kyoto.jp":             true,
	"nanto.toyama.jp":             true,
	"nanyo.yamagata.jp":           true,
	"naoshima.kagawa.jp":          true,
	"naples.it":                   true,
	"napoli.it":                   true,
	"nara.jp":                     true,
	"nara.nara.jp":                true,
	"narashino.chiba.jp":          true,
	"narita.chiba.jp":             true,
	"naroy.no":                    true,
	"narusawa.yamanashi.jp":       true,
	"naruto.tokushima.jp":         true,
	"narviika.no":                 true,
	"narvik.no":                   true,
	"nasu.tochigi.jp":             true,
	"nasushiobara.tochigi.jp":     true,
	"nat.tn":                      true,
	"national.museum":             true,
	"nationalfirearms.museum":     true,
	"nationalheritage.museum":     true,
	"nativeamerican.museum":       true,
	"natori.miyagi.jp":            true,
	"naturalhistory.museum":       true,
	"naturalhistorymuseum.museum": true,
	"naturalsciences.museum":      true,
	"naturbruksgymn.se":           true,
	"nature.museum":               true,
	"naturhistorisches.museum":    true,
	"natuurwetenschappen.museum":  true,
	"naumburg.museum":             true,
	"naustdal.no":                 true,
	"naval.museum":                true,
	"navigation.aero":             true,
	"navuotna.no":                 true,
	"navy":                        true,
	"nayoro.hokkaido.jp":          true,
	"nb.ca":                       true,
	"nc":                          true,
	"nc.tr":                       true,
	"nc.us":                       true,
	"nd.us":                       true,
	"ne":                          true,
	"ne.jp":                       true,
	"ne.kr":                       true,
	"ne.pw":                       true,
	"ne.tz":                       true,
	"ne.ug":                       true,
	"ne.us":                       true,
	"nebraska.museum":             true,
	"nec":                         true,
	"nemuro.hokkaido.jp":          true,
	"nerima.tokyo.jp":             true,
	"nes.akershus.no":             true,
	"nes.buskerud.no":             true,
	"nesna.no":                    true,
	"nesodden.no":                 true,
	"nesoddtangen.no":             true,
	"nesseby.no":                  true,
	"nesset.no":                   true,
	"net":                         true,
	"net.ac":                      true,
	"net.ae":                      true,
	"net.af":                      true,
	"net.ag":                      true,
	"net.ai":                      true,
	"net.al":                      true,
	"net.an":                      true,
	"net.ar":                      true,
	"net.au":                      true,
	"net.az":                      true,
	"net.ba":                      true,
	"net.bb":                      true,
	"net.bh":                      true,
	"net.bm":                      true,
	"net.bo":                      true,
	"net.br":                      true,
	"net.bs":                      true,
	"net.bt":                      true,
	"net.bz":                      true,
	"net.ci":                      true,
	"net.cm":                      true,
	"net.cn":                      true,
	"net.co":                      true,
	"net.cu":                      true,
	"net.cw":                      true,
	"net.dm":                      true,
	"net.do":                      true,
	"net.dz":                      true,
	"net.ec":                      true,
	"net.eg":                      true,
	"net.ge":                      true,
	"net.gg":                      true,
	"net.gn":                      true,
	"net.gp":                      true,
	"net.gr":                      true,
	"net.gt":                      true,
	"net.gy":                      true,
	"net.hk":                      true,
	"net.hn":                      true,
	"net.ht":                      true,
	"net.id":                      true,
	"net.im":                      true,
	"net.in":                      true,
	"net.iq":                      true,
	"net.ir":                      true,
	"net.is":                      true,
	"net.je":                      true,
	"net.jo":                      true,
	"net.kg":                      true,
	"net.ki":                      true,
	"net.kn":                      true,
	"net.ky":                      true,
	"net.kz":                      true,
	"net.la":                      true,
	"net.lb":                      true,
	"net.lc":                      true,
	"net.lk":                      true,
	"net.lr":                      true,
	"net.lv":                      true,
	"net.ly":                      true,
	"net.ma":                      true,
	"net.me":                      true,
	"net.mk":                      true,
	"net.ml":                      true,
	"net.mo":                      true,
	"net.ms":                      true,
	"net.mt":                      true,
	"net.mu":                      true,
	"net.mv":                      true,
	"net.mw":                      true,
	"net.mx":                      true,
	"net.my":                      true,
	"net.nf":                      true,
	"net.ng":                      true,
	"net.nr":                      true,
	"net.nz":                      true,
	"net.om":                      true,
	"net.pa":                      true,
	"net.pe":                      true,
	"net.ph":                      true,
	"net.pk":                      true,
	"net.pl":                      true,
	"net.pn":                      true,
	"net.pr":                      true,
	"net.ps":                      true,
	"net.pt":                      true,
	"net.py":                      true,
	"net.qa":                      true,
	"net.ru":                      true,
	"net.rw":                      true,
	"net.sa":                      true,
	"net.sb":                      true,
	"net.sc":                      true,
	"net.sd":                      true,
	"net.sg":                      true,
	"net.sh":                      true,
	"net.sl":                      true,
	"net.so":                      true,
	"net.st":                      true,
	"net.sy":                      true,
	"net.th":                      true,
	"net.tj":                      true,
	"net.tm":                      true,
	"net.tn":                      true,
	"net.to":                      true,
	"net.tr":                      true,
	"net.tt":                      true,
	"net.tw":                      true,
	"net.ua":                      true,
	"net.uk":                      true,
	"net.uy":                      true,
	"net.uz":                      true,
	"net.vc":                      true,
	"net.ve":                      true,
	"net.vi":                      true,
	"net.vn":                      true,
	"net.vu":                      true,
	"net.ws":                      true,
	"netbank":                     true,
	"network":                     true,
	"neues.museum":                true,
	"neustar":                     true,
	"new":                         true,
	"newhampshire.museum":       true,
	"newjersey.museum":          true,
	"newmexico.museum":          true,
	"newport.museum":            true,
	"news":                      true,
	"news.hu":                   true,
	"newspaper.museum":          true,
	"newyork.museum":            true,
	"nexus":                     true,
	"neyagawa.osaka.jp":         true,
	"nf":                        true,
	"nf.ca":                     true,
	"nfshost.com":               true,
	"ng":                        true,
	"ngo":                       true,
	"ngo.lk":                    true,
	"ngo.ph":                    true,
	"nh.us":                     true,
	"nhk":                       true,
	"nhs.uk":                    true,
	"ni":                        true,
	"nic.in":                    true,
	"nic.tj":                    true,
	"nichinan.miyazaki.jp":      true,
	"nichinan.tottori.jp":       true,
	"nico":                      true,
	"nid.io":                    true,
	"niepce.museum":             true,
	"nieruchomosci.pl":          true,
	"niigata.jp":                true,
	"niigata.niigata.jp":        true,
	"niihama.ehime.jp":          true,
	"niikappu.hokkaido.jp":      true,
	"niimi.okayama.jp":          true,
	"niiza.saitama.jp":          true,
	"nikaho.akita.jp":           true,
	"niki.hokkaido.jp":          true,
	"nikko.tochigi.jp":          true,
	"nikolaev.ua":               true,
	"ninja":                     true,
	"ninohe.iwate.jp":           true,
	"ninomiya.kanagawa.jp":      true,
	"nirasaki.yamanashi.jp":     true,
	"nishi.fukuoka.jp":          true,
	"nishi.osaka.jp":            true,
	"nishiaizu.fukushima.jp":    true,
	"nishiarita.saga.jp":        true,
	"nishiawakura.okayama.jp":   true,
	"nishiazai.shiga.jp":        true,
	"nishigo.fukushima.jp":      true,
	"nishihara.kumamoto.jp":     true,
	"nishihara.okinawa.jp":      true,
	"nishiizu.shizuoka.jp":      true,
	"nishikata.tochigi.jp":      true,
	"nishikatsura.yamanashi.jp": true,
	"nishikawa.yamagata.jp":     true,
	"nishimera.miyazaki.jp":     true,
	"nishinomiya.hyogo.jp":      true,
	"nishinoomote.kagoshima.jp": true,
	"nishinoshima.shimane.jp":   true,
	"nishio.aichi.jp":           true,
	"nishiokoppe.hokkaido.jp":   true,
	"nishitosa.kochi.jp":        true,
	"nishiwaki.hyogo.jp":        true,
	"nissan":                    true,
	"nissedal.no":               true,
	"nisshin.aichi.jp":          true,
	"nittedal.no":               true,
	"niyodogawa.kochi.jp":       true,
	"nj.us":                     true,
	"nkz.ru":                    true,
	"nl":                        true,
	"nl.ca":                     true,
	"nl.no":                     true,
	"nm.cn":                     true,
	"nm.us":                     true,
	"nnov.ru":                   true,
	"no":                        true,
	"no.com":                    true,
	"no.it":                     true,
	"nobeoka.miyazaki.jp":       true,
	"noboribetsu.hokkaido.jp":   true,
	"noda.chiba.jp":             true,
	"noda.iwate.jp":             true,
	"nogata.fukuoka.jp":         true,
	"nogi.tochigi.jp":           true,
	"noheji.aomori.jp":          true,
	"nokia":                     true,
	"nom.ad":                    true,
	"nom.ag":                    true,
	"nom.br":                    true,
	"nom.co":                    true,
	"nom.es":                    true,
	"nom.fr":                    true,
	"nom.km":                    true,
	"nom.mg":                    true,
	"nom.pa":                    true,
	"nom.pe":                    true,
	"nom.pl":                    true,
	"nom.re":                    true,
	"nom.ro":                    true,
	"nom.tm":                    true,
	"nome.pt":                   true,
	"nomi.ishikawa.jp":          true,
	"nonoichi.ishikawa.jp":      true,
	"norddal.no":                true,
	"nordkapp.no":               true,
	"nordreisa.no":              true,
	"norfolk.museum":            true,
	"norilsk.ru":                true,
	"north.museum":              true,
	"norton":                    true,
	"nose.osaka.jp":             true,
	"nosegawa.nara.jp":          true,
	"noshiro.akita.jp":          true,
	"not.br":                    true,
	"notaires.fr":               true,
	"notaires.km":               true,
	"noto.ishikawa.jp":          true,
	"notodden.no":               true,
	"notogawa.shiga.jp":         true,
	"notteroy.no":               true,
	"nov.ru":                    true,
	"nov.su":                    true,
	"novara.it":                 true,
	"novosibirsk.ru":            true,
	"nowaruda.pl":               true,
	"nowruz":                    true,
	"nozawaonsen.nagano.jp":     true,
	"np":                 true,
	"nr":                 true,
	"nra":                true,
	"nrw":                true,
	"nrw.museum":         true,
	"ns.ca":              true,
	"nsk.ru":             true,
	"nsn.us":             true,
	"nsw.au":             true,
	"nsw.edu.au":         true,
	"nt.au":              true,
	"nt.ca":              true,
	"nt.edu.au":          true,
	"nt.no":              true,
	"nt.ro":              true,
	"ntr.br":             true,
	"ntt":                true,
	"nu":                 true,
	"nu.ca":              true,
	"nu.it":              true,
	"nuernberg.museum":   true,
	"numata.gunma.jp":    true,
	"numata.hokkaido.jp": true,
	"numazu.shizuoka.jp": true,
	"nuoro.it":           true,
	"nuremberg.museum":   true,
	"nv.us":              true,
	"nx.cn":              true,
	"ny.us":              true,
	"nyc":                true,
	"nyc.mn":             true,
	"nyc.museum":         true,
	"nyny.museum":        true,
	"nysa.pl":            true,
	"nyuzen.toyama.jp":   true,
	"nz":                 true,
	"o.bg":               true,
	"o.se":               true,
	"oamishirasato.chiba.jp": true,
	"oarai.ibaraki.jp":       true,
	"obama.fukui.jp":         true,
	"obama.nagasaki.jp":      true,
	"obanazawa.yamagata.jp":  true,
	"obi": true,
	"obihiro.hokkaido.jp":        true,
	"obira.hokkaido.jp":          true,
	"obninsk.su":                 true,
	"obu.aichi.jp":               true,
	"obuse.nagano.jp":            true,
	"oceanographic.museum":       true,
	"oceanographique.museum":     true,
	"ochi.kochi.jp":              true,
	"od.ua":                      true,
	"odate.akita.jp":             true,
	"odawara.kanagawa.jp":        true,
	"odda.no":                    true,
	"odesa.ua":                   true,
	"odessa.ua":                  true,
	"odo.br":                     true,
	"oe.yamagata.jp":             true,
	"of.by":                      true,
	"of.no":                      true,
	"off.ai":                     true,
	"ofunato.iwate.jp":           true,
	"og.ao":                      true,
	"og.it":                      true,
	"oga.akita.jp":               true,
	"ogaki.gifu.jp":              true,
	"ogano.saitama.jp":           true,
	"ogasawara.tokyo.jp":         true,
	"ogata.akita.jp":             true,
	"ogawa.ibaraki.jp":           true,
	"ogawa.nagano.jp":            true,
	"ogawa.saitama.jp":           true,
	"ogawara.miyagi.jp":          true,
	"ogi.saga.jp":                true,
	"ogimi.okinawa.jp":           true,
	"ogliastra.it":               true,
	"ogori.fukuoka.jp":           true,
	"ogose.saitama.jp":           true,
	"oguchi.aichi.jp":            true,
	"oguni.kumamoto.jp":          true,
	"oguni.yamagata.jp":          true,
	"oh.us":                      true,
	"oharu.aichi.jp":             true,
	"ohda.shimane.jp":            true,
	"ohi.fukui.jp":               true,
	"ohira.miyagi.jp":            true,
	"ohira.tochigi.jp":           true,
	"ohkura.yamagata.jp":         true,
	"ohtawara.tochigi.jp":        true,
	"oi.kanagawa.jp":             true,
	"oirase.aomori.jp":           true,
	"oishida.yamagata.jp":        true,
	"oiso.kanagawa.jp":           true,
	"oita.jp":                    true,
	"oita.oita.jp":               true,
	"oizumi.gunma.jp":            true,
	"oji.nara.jp":                true,
	"ojiya.niigata.jp":           true,
	"ok.us":                      true,
	"okagaki.fukuoka.jp":         true,
	"okawa.fukuoka.jp":           true,
	"okawa.kochi.jp":             true,
	"okaya.nagano.jp":            true,
	"okayama.jp":                 true,
	"okayama.okayama.jp":         true,
	"okazaki.aichi.jp":           true,
	"okegawa.saitama.jp":         true,
	"oketo.hokkaido.jp":          true,
	"oki.fukuoka.jp":             true,
	"okinawa":                    true,
	"okinawa.jp":                 true,
	"okinawa.okinawa.jp":         true,
	"okinoshima.shimane.jp":      true,
	"okoppe.hokkaido.jp":         true,
	"oksnes.no":                  true,
	"okuizumo.shimane.jp":        true,
	"okuma.fukushima.jp":         true,
	"okutama.tokyo.jp":           true,
	"ol.no":                      true,
	"olawa.pl":                   true,
	"olbiatempio.it":             true,
	"olecko.pl":                  true,
	"olkusz.pl":                  true,
	"olsztyn.pl":                 true,
	"om":                         true,
	"omachi.nagano.jp":           true,
	"omachi.saga.jp":             true,
	"omaezaki.shizuoka.jp":       true,
	"omaha.museum":               true,
	"omasvuotna.no":              true,
	"ome.tokyo.jp":               true,
	"omega":                      true,
	"omi.nagano.jp":              true,
	"omi.niigata.jp":             true,
	"omigawa.chiba.jp":           true,
	"omihachiman.shiga.jp":       true,
	"omitama.ibaraki.jp":         true,
	"omiya.saitama.jp":           true,
	"omotego.fukushima.jp":       true,
	"omsk.ru":                    true,
	"omura.nagasaki.jp":          true,
	"omuta.fukuoka.jp":           true,
	"on.ca":                      true,
	"onagawa.miyagi.jp":          true,
	"one":                        true,
	"ong":                        true,
	"onga.fukuoka.jp":            true,
	"onjuku.chiba.jp":            true,
	"onl":                        true,
	"online":                     true,
	"online.museum":              true,
	"onna.okinawa.jp":            true,
	"ono.fukui.jp":               true,
	"ono.fukushima.jp":           true,
	"ono.hyogo.jp":               true,
	"onojo.fukuoka.jp":           true,
	"onomichi.hiroshima.jp":      true,
	"ontario.museum":             true,
	"ookuwa.nagano.jp":           true,
	"ooo":                        true,
	"ooshika.nagano.jp":          true,
	"openair.museum":             true,
	"operaunite.com":             true,
	"opoczno.pl":                 true,
	"opole.pl":                   true,
	"oppdal.no":                  true,
	"oppegard.no":                true,
	"or.at":                      true,
	"or.bi":                      true,
	"or.ci":                      true,
	"or.cr":                      true,
	"or.id":                      true,
	"or.it":                      true,
	"or.jp":                      true,
	"or.kr":                      true,
	"or.mu":                      true,
	"or.na":                      true,
	"or.pw":                      true,
	"or.th":                      true,
	"or.tz":                      true,
	"or.ug":                      true,
	"or.us":                      true,
	"ora.gunma.jp":               true,
	"oracle":                     true,
	"oregon.museum":              true,
	"oregontrail.museum":         true,
	"orenburg.ru":                true,
	"org":                        true,
	"org.ac":                     true,
	"org.ae":                     true,
	"org.af":                     true,
	"org.ag":                     true,
	"org.ai":                     true,
	"org.al":                     true,
	"org.an":                     true,
	"org.ar":                     true,
	"org.au":                     true,
	"org.az":                     true,
	"org.ba":                     true,
	"org.bb":                     true,
	"org.bh":                     true,
	"org.bi":                     true,
	"org.bm":                     true,
	"org.bo":                     true,
	"org.br":                     true,
	"org.bs":                     true,
	"org.bt":                     true,
	"org.bw":                     true,
	"org.bz":                     true,
	"org.ci":                     true,
	"org.cn":                     true,
	"org.co":                     true,
	"org.cu":                     true,
	"org.cw":                     true,
	"org.dm":                     true,
	"org.do":                     true,
	"org.dz":                     true,
	"org.ec":                     true,
	"org.ee":                     true,
	"org.eg":                     true,
	"org.es":                     true,
	"org.et":                     true,
	"org.ge":                     true,
	"org.gg":                     true,
	"org.gh":                     true,
	"org.gi":                     true,
	"org.gn":                     true,
	"org.gp":                     true,
	"org.gr":                     true,
	"org.gt":                     true,
	"org.hk":                     true,
	"org.hn":                     true,
	"org.ht":                     true,
	"org.hu":                     true,
	"org.im":                     true,
	"org.in":                     true,
	"org.iq":                     true,
	"org.ir":                     true,
	"org.is":                     true,
	"org.je":                     true,
	"org.jo":                     true,
	"org.kg":                     true,
	"org.ki":                     true,
	"org.km":                     true,
	"org.kn":                     true,
	"org.kp":                     true,
	"org.ky":                     true,
	"org.kz":                     true,
	"org.la":                     true,
	"org.lb":                     true,
	"org.lc":                     true,
	"org.lk":                     true,
	"org.lr":                     true,
	"org.ls":                     true,
	"org.lv":                     true,
	"org.ly":                     true,
	"org.ma":                     true,
	"org.me":                     true,
	"org.mg":                     true,
	"org.mk":                     true,
	"org.ml":                     true,
	"org.mn":                     true,
	"org.mo":                     true,
	"org.ms":                     true,
	"org.mt":                     true,
	"org.mu":                     true,
	"org.mv":                     true,
	"org.mw":                     true,
	"org.mx":                     true,
	"org.my":                     true,
	"org.na":                     true,
	"org.ng":                     true,
	"org.nr":                     true,
	"org.nz":                     true,
	"org.om":                     true,
	"org.pa":                     true,
	"org.pe":                     true,
	"org.pf":                     true,
	"org.ph":                     true,
	"org.pk":                     true,
	"org.pl":                     true,
	"org.pn":                     true,
	"org.pr":                     true,
	"org.ps":                     true,
	"org.pt":                     true,
	"org.py":                     true,
	"org.qa":                     true,
	"org.ro":                     true,
	"org.rs":                     true,
	"org.ru":                     true,
	"org.sa":                     true,
	"org.sb":                     true,
	"org.sc":                     true,
	"org.sd":                     true,
	"org.se":                     true,
	"org.sg":                     true,
	"org.sh":                     true,
	"org.sl":                     true,
	"org.sn":                     true,
	"org.so":                     true,
	"org.st":                     true,
	"org.sv":                     true,
	"org.sy":                     true,
	"org.sz":                     true,
	"org.tj":                     true,
	"org.tm":                     true,
	"org.tn":                     true,
	"org.to":                     true,
	"org.tr":                     true,
	"org.tt":                     true,
	"org.tw":                     true,
	"org.ua":                     true,
	"org.ug":                     true,
	"org.uk":                     true,
	"org.uy":                     true,
	"org.uz":                     true,
	"org.vc":                     true,
	"org.ve":                     true,
	"org.vi":                     true,
	"org.vn":                     true,
	"org.vu":                     true,
	"org.ws":                     true,
	"organic":                    true,
	"oristano.it":                true,
	"orkanger.no":                true,
	"orkdal.no":                  true,
	"orland.no":                  true,
	"orskog.no":                  true,
	"orsta.no":                   true,
	"oryol.ru":                   true,
	"os.hedmark.no":              true,
	"os.hordaland.no":            true,
	"osaka":                      true,
	"osaka.jp":                   true,
	"osakasayama.osaka.jp":       true,
	"osaki.miyagi.jp":            true,
	"osakikamijima.hiroshima.jp": true,
	"osen.no":                    true,
	"oseto.nagasaki.jp":          true,
	"oshima.tokyo.jp":            true,
	"oshima.yamaguchi.jp":        true,
	"oshino.yamanashi.jp":        true,
	"oshu.iwate.jp":              true,
	"oskol.ru":                   true,
	"oslo.no":                    true,
	"osoyro.no":                  true,
	"osteroy.no":                 true,
	"ostroda.pl":                 true,
	"ostroleka.pl":               true,
	"ostrowiec.pl":               true,
	"ostrowwlkp.pl":              true,
	"ot.it":                      true,
	"ota.gunma.jp":               true,
	"ota.tokyo.jp":               true,
	"otago.museum":               true,
	"otake.hiroshima.jp":         true,
	"otaki.chiba.jp":             true,
	"otaki.nagano.jp":            true,
	"otaki.saitama.jp":           true,
	"otama.fukushima.jp":         true,
	"otari.nagano.jp":            true,
	"otaru.hokkaido.jp":          true,
	"other.nf":                   true,
	"oto.fukuoka.jp":             true,
	"otobe.hokkaido.jp":          true,
	"otofuke.hokkaido.jp":        true,
	"otoineppu.hokkaido.jp":      true,
	"otoyo.kochi.jp":             true,
	"otsu.shiga.jp":              true,
	"otsuchi.iwate.jp":           true,
	"otsuka":                     true,
	"otsuki.kochi.jp":            true,
	"otsuki.yamanashi.jp":        true,
	"ouchi.saga.jp":              true,
	"ouda.nara.jp":               true,
	"oumu.hokkaido.jp":           true,
	"outsystemscloud.com":        true,
	"overhalla.no":               true,
	"ovh":                        true,
	"owani.aomori.jp":            true,
	"owariasahi.aichi.jp":        true,
	"oxford.museum":              true,
	"oyabe.toyama.jp":            true,
	"oyama.tochigi.jp":           true,
	"oyamazaki.kyoto.jp":         true,
	"oyer.no":                    true,
	"oygarden.no":                true,
	"oyodo.nara.jp":              true,
	"oz.au":                      true,
	"ozora.hokkaido.jp":          true,
	"ozu.ehime.jp":               true,
	"ozu.kumamoto.jp":            true,
	"p.bg":                       true,
	"p.se":                       true,
	"pa":                         true,
	"pa.gov.pl":                  true,
	"pa.it":                      true,
	"pa.us":                      true,
	"pacific.museum":             true,
	"paderborn.museum":           true,
	"padova.it":                  true,
	"padua.it":                   true,
	"page":                       true,
	"pagespeedmobilizer.com":  true,
	"palace.museum":           true,
	"palana.ru":               true,
	"paleo.museum":            true,
	"palermo.it":              true,
	"palmsprings.museum":      true,
	"panama.museum":           true,
	"panerai":                 true,
	"parachuting.aero":        true,
	"paragliding.aero":        true,
	"paris":                   true,
	"paris.museum":            true,
	"parliament.nz":           true,
	"parma.it":                true,
	"paroch.k12.ma.us":        true,
	"pars":                    true,
	"parti.se":                true,
	"partners":                true,
	"parts":                   true,
	"party":                   true,
	"pasadena.museum":         true,
	"pavia.it":                true,
	"pb.ao":                   true,
	"pc.it":                   true,
	"pc.pl":                   true,
	"pd.it":                   true,
	"pe":                      true,
	"pe.ca":                   true,
	"pe.it":                   true,
	"pe.kr":                   true,
	"penza.ru":                true,
	"penza.su":                true,
	"per.la":                  true,
	"per.nf":                  true,
	"per.sg":                  true,
	"perm.ru":                 true,
	"perso.ht":                true,
	"perso.sn":                true,
	"perso.tn":                true,
	"perugia.it":              true,
	"pesarourbino.it":         true,
	"pescara.it":              true,
	"pf":                      true,
	"pg":                      true,
	"pg.it":                   true,
	"ph":                      true,
	"pharmacien.fr":           true,
	"pharmaciens.km":          true,
	"pharmacy":                true,
	"pharmacy.museum":         true,
	"philadelphia.museum":     true,
	"philadelphiaarea.museum": true,
	"philately.museum":        true,
	"philips":                 true,
	"phoenix.museum":          true,
	"photo":                   true,
	"photography":             true,
	"photography.museum":      true,
	"photos":                  true,
	"physio":                  true,
	"pi.it":                   true,
	"piacenza.it":             true,
	"piaget":                  true,
	"pics":                    true,
	"pictet":                  true,
	"pictures":                true,
	"pid":                     true,
	"piedmont.it":             true,
	"piemonte.it":             true,
	"pila.pl":                 true,
	"pilot.aero":              true,
	"pilots.museum":           true,
	"pin":                     true,
	"pink":                    true,
	"pippu.hokkaido.jp":       true,
	"pisa.it":                 true,
	"pistoia.it":              true,
	"pisz.pl":                 true,
	"pittsburgh.museum":       true,
	"pizza":                   true,
	"pk":                      true,
	"pl":                      true,
	"pl.ua":                   true,
	"place":                   true,
	"planetarium.museum":      true,
	"plantation.museum":       true,
	"plants.museum":           true,
	"platform.sh":             true,
	"plaza.museum":            true,
	"plc.co.im":               true,
	"plc.ly":                  true,
	"plc.uk":                  true,
	"plo.ps":                  true,
	"plumbing":                true,
	"pm":                      true,
	"pmn.it":                  true,
	"pn":                      true,
	"pn.it":                   true,
	"po.gov.pl":               true,
	"po.it":                   true,
	"podhale.pl":              true,
	"podlasie.pl":             true,
	"podzone.net":             true,
	"podzone.org":             true,
	"pohl":                    true,
	"poker":                   true,
	"pokrovsk.su":             true,
	"pol.dz":                  true,
	"pol.ht":                  true,
	"pol.tr":                  true,
	"police.uk":               true,
	"polkowice.pl":            true,
	"poltava.ua":              true,
	"pomorskie.pl":            true,
	"pomorze.pl":              true,
	"pordenone.it":            true,
	"porn":                    true,
	"porsanger.no":            true,
	"porsangu.no":             true,
	"porsgrunn.no":            true,
	"port.fr":                 true,
	"portal.museum":           true,
	"portland.museum":         true,
	"portlligat.museum":       true,
	"post":                    true,
	"potenza.it":              true,
	"powiat.pl":               true,
	"poznan.pl":               true,
	"pp.az":                   true,
	"pp.ru":                   true,
	"pp.se":                   true,
	"pp.ua":                   true,
	"ppg.br":                  true,
	"pr":                      true,
	"pr.it":                   true,
	"pr.us":                   true,
	"prato.it":                true,
	"praxi":                   true,
	"prd.fr":                  true,
	"prd.km":                  true,
	"prd.mg":                  true,
	"preservation.museum":     true,
	"presidio.museum":         true,
	"press":                   true,
	"press.aero":              true,
	"press.ma":                true,
	"press.museum":            true,
	"press.se":                true,
	"presse.ci":               true,
	"presse.fr":               true,
	"presse.km":               true,
	"presse.ml":               true,
	"pri.ee":                  true,
	"principe.st":             true,
	"priv.at":                 true,
	"priv.hu":                 true,
	"priv.me":                 true,
	"priv.no":                 true,
	"priv.pl":                 true,
	"pro":                     true,
	"pro.az":                  true,
	"pro.br":                  true,
	"pro.ec":                  true,
	"pro.ht":                  true,
	"pro.mv":                  true,
	"pro.na":                  true,
	"pro.om":                  true,
	"pro.pr":                  true,
	"pro.tt":                  true,
	"pro.vn":                  true,
	"prochowice.pl":           true,
	"prod":                    true,
	"production.aero":         true,
	"productions":             true,
	"prof":                    true,
	"prof.pr":                 true,
	"project.museum":          true,
	"promo":                   true,
	"properties":              true,
	"property":                true,
	"pruszkow.pl":             true,
	"przeworsk.pl":            true,
	"ps":                      true,
	"psc.br":                  true,
	"psi.br":                  true,
	"pt":                      true,
	"pt.it":                   true,
	"ptz.ru":                  true,
	"pu.it":                   true,
	"pub":                     true,
	"pub.sa":                  true,
	"publ.pt":                 true,
	"public.museum":           true,
	"pubol.museum":            true,
	"pug.it":                  true,
	"puglia.it":               true,
	"pulawy.pl":               true,
	"pv.it":                   true,
	"pvt.ge":                  true,
	"pvt.k12.ma.us":           true,
	"pw":                      true,
	"py":                      true,
	"pyatigorsk.ru":           true,
	"pz.it":                   true,
	"q.bg":                    true,
	"qa":                      true,
	"qc.ca":                   true,
	"qc.com":                  true,
	"qh.cn":                   true,
	"qld.au":                  true,
	"qld.edu.au":              true,
	"qld.gov.au":              true,
	"qpon":                    true,
	"qsl.br":                  true,
	"quebec":                  true,
	"quebec.museum":           true,
	"r.bg":                    true,
	"r.se":                    true,
	"ra.it":                   true,
	"racing":                  true,
	"rade.no":                 true,
	"radio.br":                true,
	"radom.pl":                true,
	"radoy.no":                true,
	"ragusa.it":               true,
	"rahkkeravju.no":          true,
	"raholt.no":               true,
	"railroad.museum":         true,
	"railway.museum":          true,
	"raisa.no":                true,
	"rakkestad.no":            true,
	"ralingen.no":             true,
	"rana.no":                 true,
	"randaberg.no":            true,
	"rankoshi.hokkaido.jp":    true,
	"ranzan.saitama.jp":       true,
	"rauma.no":                true,
	"ravenna.it":              true,
	"rc.it":                   true,
	"re":                      true,
	"re.it":                   true,
	"re.kr":                   true,
	"read":                    true,
	"readmyblog.org":          true,
	"realestate.pl":           true,
	"realtor":                 true,
	"rebun.hokkaido.jp":       true,
	"rec.br":                  true,
	"rec.co":                  true,
	"rec.nf":                  true,
	"rec.ro":                  true,
	"rec.ve":                  true,
	"recipes":                 true,
	"recreation.aero":         true,
	"red":                     true,
	"red.sv":                  true,
	"redstone":                true,
	"reggiocalabria.it":       true,
	"reggioemilia.it":         true,
	"rehab":                   true,
	"reise":                   true,
	"reisen":                  true,
	"reit":                    true,
	"reklam.hu":               true,
	"rel.ht":                  true,
	"rel.pl":                  true,
	"ren":                     true,
	"rendalen.no":             true,
	"rennebu.no":              true,
	"rennesoy.no":             true,
	"rent":                    true,
	"rentals":                 true,
	"rep.kp":                  true,
	"repair":                  true,
	"repbody.aero":            true,
	"report":                  true,
	"republican":              true,
	"res.aero":                true,
	"res.in":                  true,
	"research.aero":           true,
	"research.museum":         true,
	"resistance.museum":       true,
	"rest":                    true,
	"restaurant":              true,
	"review":                  true,
	"reviews":                 true,
	"rg.it":                   true,
	"rhcloud.com":             true,
	"ri.it":                   true,
	"ri.us":                   true,
	"rich":                    true,
	"ricoh":                   true,
	"rieti.it":                true,
	"rifu.miyagi.jp":          true,
	"riik.ee":                 true,
	"rikubetsu.hokkaido.jp":   true,
	"rikuzentakata.iwate.jp":  true,
	"rimini.it":               true,
	"rindal.no":               true,
	"ringebu.no":              true,
	"ringerike.no":            true,
	"ringsaker.no":            true,
	"rio":                     true,
	"riodejaneiro.museum": true,
	"rip": true,
	"rishiri.hokkaido.jp":        true,
	"rishirifuji.hokkaido.jp":    true,
	"risor.no":                   true,
	"rissa.no":                   true,
	"ritto.shiga.jp":             true,
	"rivne.ua":                   true,
	"rl.no":                      true,
	"rm.it":                      true,
	"rn.it":                      true,
	"rnd.ru":                     true,
	"rnrt.tn":                    true,
	"rns.tn":                     true,
	"rnu.tn":                     true,
	"ro":                         true,
	"ro.com":                     true,
	"ro.it":                      true,
	"roan.no":                    true,
	"rocher":                     true,
	"rochester.museum":           true,
	"rockart.museum":             true,
	"rocks":                      true,
	"rodeo":                      true,
	"rodoy.no":                   true,
	"rokunohe.aomori.jp":         true,
	"rollag.no":                  true,
	"roma.it":                    true,
	"roma.museum":                true,
	"rome.it":                    true,
	"romsa.no":                   true,
	"romskog.no":                 true,
	"room":                       true,
	"roros.no":                   true,
	"rost.no":                    true,
	"rotorcraft.aero":            true,
	"rovigo.it":                  true,
	"rovno.ua":                   true,
	"royken.no":                  true,
	"royrvik.no":                 true,
	"rs":                         true,
	"rs.ba":                      true,
	"rsvp":                       true,
	"ru":                         true,
	"ru.com":                     true,
	"rubtsovsk.ru":               true,
	"ruhr":                       true,
	"ruovat.no":                  true,
	"russia.museum":              true,
	"rv.ua":                      true,
	"rw":                         true,
	"ryazan.ru":                  true,
	"rybnik.pl":                  true,
	"rygge.no":                   true,
	"ryokami.saitama.jp":         true,
	"ryugasaki.ibaraki.jp":       true,
	"ryukyu":                     true,
	"ryuoh.shiga.jp":             true,
	"rzeszow.pl":                 true,
	"s.bg":                       true,
	"s.se":                       true,
	"s3.amazonaws.com":           true,
	"sa":                         true,
	"sa.au":                      true,
	"sa.com":                     true,
	"sa.cr":                      true,
	"sa.edu.au":                  true,
	"sa.gov.au":                  true,
	"sa.it":                      true,
	"saarland":                   true,
	"sabae.fukui.jp":             true,
	"sado.niigata.jp":            true,
	"safe":                       true,
	"safety":                     true,
	"safety.aero":                true,
	"saga.jp":                    true,
	"saga.saga.jp":               true,
	"sagae.yamagata.jp":          true,
	"sagamihara.kanagawa.jp":     true,
	"saigawa.fukuoka.jp":         true,
	"saijo.ehime.jp":             true,
	"saikai.nagasaki.jp":         true,
	"saiki.oita.jp":              true,
	"saintlouis.museum":          true,
	"saitama.jp":                 true,
	"saitama.saitama.jp":         true,
	"saito.miyazaki.jp":          true,
	"saka.hiroshima.jp":          true,
	"sakado.saitama.jp":          true,
	"sakae.chiba.jp":             true,
	"sakae.nagano.jp":            true,
	"sakahogi.gifu.jp":           true,
	"sakai.fukui.jp":             true,
	"sakai.ibaraki.jp":           true,
	"sakai.osaka.jp":             true,
	"sakaiminato.tottori.jp":     true,
	"sakaki.nagano.jp":           true,
	"sakata.yamagata.jp":         true,
	"sakawa.kochi.jp":            true,
	"sakegawa.yamagata.jp":       true,
	"sakhalin.ru":                true,
	"saku.nagano.jp":             true,
	"sakuho.nagano.jp":           true,
	"sakura":                     true,
	"sakura.chiba.jp":            true,
	"sakura.tochigi.jp":          true,
	"sakuragawa.ibaraki.jp":      true,
	"sakurai.nara.jp":            true,
	"sakyo.kyoto.jp":             true,
	"salangen.no":                true,
	"salat.no":                   true,
	"sale":                       true,
	"salem.museum":               true,
	"salerno.it":                 true,
	"salon":                      true,
	"saltdal.no":                 true,
	"salvadordali.museum":        true,
	"salzburg.museum":            true,
	"samara.ru":                  true,
	"samegawa.fukushima.jp":      true,
	"samnanger.no":               true,
	"samsung":                    true,
	"samukawa.kanagawa.jp":       true,
	"sanagochi.tokushima.jp":     true,
	"sanda.hyogo.jp":             true,
	"sande.vestfold.no":          true,
	"sandefjord.no":              true,
	"sandiego.museum":            true,
	"sandnes.no":                 true,
	"sandnessjoen.no":            true,
	"sandoy.no":                  true,
	"sandvik":                    true,
	"sandvikcoromant":            true,
	"sanfrancisco.museum":        true,
	"sango.nara.jp":              true,
	"sanjo.niigata.jp":           true,
	"sannan.hyogo.jp":            true,
	"sannohe.aomori.jp":          true,
	"sano.tochigi.jp":            true,
	"sanofi":                     true,
	"sanok.pl":                   true,
	"santabarbara.museum":        true,
	"santacruz.museum":           true,
	"santafe.museum":             true,
	"sanuki.kagawa.jp":           true,
	"saotome.st":                 true,
	"sap":                        true,
	"sapo":                       true,
	"sapporo.jp":                 true,
	"sar.it":                     true,
	"saratov.ru":                 true,
	"sardegna.it":                true,
	"sardinia.it":                true,
	"sarl":                       true,
	"saroma.hokkaido.jp":         true,
	"sarpsborg.no":               true,
	"sarufutsu.hokkaido.jp":      true,
	"sasaguri.fukuoka.jp":        true,
	"sasayama.hyogo.jp":          true,
	"sasebo.nagasaki.jp":         true,
	"saskatchewan.museum":        true,
	"sassari.it":                 true,
	"satosho.okayama.jp":         true,
	"satsumasendai.kagoshima.jp": true,
	"satte.saitama.jp":           true,
	"satx.museum":                true,
	"sauda.no":                   true,
	"sauherad.no":                true,
	"savannahga.museum":          true,
	"savona.it":                  true,
	"saxo":                       true,
	"sayama.osaka.jp":            true,
	"sayama.saitama.jp":          true,
	"sayo.hyogo.jp":              true,
	"sb":                         true,
	"sb.ua":                      true,
	"sbs":                        true,
	"sc":                         true,
	"sc.cn":                      true,
	"sc.kr":                      true,
	"sc.tz":                      true,
	"sc.ug":                      true,
	"sc.us":                      true,
	"sca":                        true,
	"scb":                        true,
	"sch.ae":                     true,
	"sch.id":                     true,
	"sch.ir":                     true,
	"sch.jo":                     true,
	"sch.lk":                     true,
	"sch.ly":                     true,
	"sch.ng":                     true,
	"sch.qa":                     true,
	"sch.sa":                     true,
	"sch.uk":                     true,
	"schlesisches.museum":        true,
	"schmidt":                    true,
	"schoenbrunn.museum":         true,
	"schokoladen.museum":         true,
	"scholarships":               true,
	"school":                     true,
	"school.museum":              true,
	"school.na":                  true,
	"school.nz":                  true,
	"schule":                     true,
	"schwarz":                    true,
	"schweiz.museum":             true,
	"sci.eg":                     true,
	"science":                    true,
	"science.museum":             true,
	"scienceandhistory.museum":   true,
	"scienceandindustry.museum":  true,
	"sciencecenter.museum":       true,
	"sciencecenters.museum":      true,
	"sciencehistory.museum":      true,
	"sciences.museum":            true,
	"sciencesnaturelles.museum":  true,
	"scientist.aero":             true,
	"scor":                       true,
	"scot":                       true,
	"scotland.museum":            true,
	"scrapping.cc":               true,
	"sd":                         true,
	"sd.cn":                      true,
	"sd.us":                      true,
	"se":                         true,
	"se.com":                     true,
	"se.net":                     true,
	"seaport.museum":             true,
	"seat":                       true,
	"sebastopol.ua":              true,
	"sec.ps":                     true,
	"seek":                       true,
	"seihi.nagasaki.jp":          true,
	"seika.kyoto.jp":             true,
	"seiro.niigata.jp":           true,
	"seirou.niigata.jp":          true,
	"seiyo.ehime.jp":             true,
	"sejny.pl":                   true,
	"seki.gifu.jp":               true,
	"sekigahara.gifu.jp":         true,
	"sekikawa.niigata.jp":        true,
	"sel.no":                     true,
	"selbu.no":                   true,
	"selfip.biz":                 true,
	"selfip.com":                 true,
	"selfip.info":                true,
	"selfip.net":                 true,
	"selfip.org":                 true,
	"selje.no":                   true,
	"seljord.no":                 true,
	"sellsyourhome.org":          true,
	"semboku.akita.jp":           true,
	"semine.miyagi.jp":           true,
	"sendai.jp":                  true,
	"sener":                      true,
	"sennan.osaka.jp":            true,
	"seoul.kr":                   true,
	"sera.hiroshima.jp":          true,
	"seranishi.hiroshima.jp":     true,
	"servebbs.com":               true,
	"servebbs.net":               true,
	"servebbs.org":               true,
	"serveftp.net":               true,
	"serveftp.org":               true,
	"servegame.org":              true,
	"service.gov.uk":             true,
	"services":                   true,
	"services.aero":              true,
	"setagaya.tokyo.jp":          true,
	"seto.aichi.jp":              true,
	"setouchi.okayama.jp":        true,
	"settlement.museum":          true,
	"settlers.museum":            true,
	"settsu.osaka.jp":            true,
	"sevastopol.ua":              true,
	"sew":                        true,
	"sex":                        true,
	"sex.hu":                     true,
	"sex.pl":                     true,
	"sexy":                       true,
	"sf.no":                      true,
	"sg":                         true,
	"sh":                         true,
	"sh.cn":                      true,
	"shacknet.nu":                true,
	"shakotan.hokkaido.jp":       true,
	"shari.hokkaido.jp":          true,
	"sharp":                      true,
	"shell.museum":               true,
	"sherbrooke.museum":          true,
	"shia":                       true,
	"shibata.miyagi.jp":          true,
	"shibata.niigata.jp":         true,
	"shibecha.hokkaido.jp":       true,
	"shibetsu.hokkaido.jp":       true,
	"shibukawa.gunma.jp":         true,
	"shibuya.tokyo.jp":           true,
	"shichikashuku.miyagi.jp":    true,
	"shichinohe.aomori.jp":       true,
	"shiga.jp":                   true,
	"shiiba.miyazaki.jp":         true,
	"shijonawate.osaka.jp":       true,
	"shika.ishikawa.jp":          true,
	"shikabe.hokkaido.jp":        true,
	"shikama.miyagi.jp":          true,
	"shikaoi.hokkaido.jp":        true,
	"shikatsu.aichi.jp":          true,
	"shiki.saitama.jp":           true,
	"shikokuchuo.ehime.jp":       true,
	"shiksha":                    true,
	"shima.mie.jp":               true,
	"shimabara.nagasaki.jp":      true,
	"shimada.shizuoka.jp":        true,
	"shimamaki.hokkaido.jp":      true,
	"shimamoto.osaka.jp":         true,
	"shimane.jp":                 true,
	"shimane.shimane.jp":         true,
	"shimizu.hokkaido.jp":        true,
	"shimizu.shizuoka.jp":        true,
	"shimoda.shizuoka.jp":        true,
	"shimodate.ibaraki.jp":       true,
	"shimofusa.chiba.jp":         true,
	"shimogo.fukushima.jp":       true,
	"shimoichi.nara.jp":          true,
	"shimoji.okinawa.jp":         true,
	"shimokawa.hokkaido.jp":      true,
	"shimokitayama.nara.jp":      true,
	"shimonita.gunma.jp":         true,
	"shimonoseki.yamaguchi.jp":   true,
	"shimosuwa.nagano.jp":        true,
	"shimotsuke.tochigi.jp":      true,
	"shimotsuma.ibaraki.jp":      true,
	"shinagawa.tokyo.jp":         true,
	"shinanomachi.nagano.jp":     true,
	"shingo.aomori.jp":           true,
	"shingu.fukuoka.jp":          true,
	"shingu.hyogo.jp":            true,
	"shingu.wakayama.jp":         true,
	"shinichi.hiroshima.jp":      true,
	"shinjo.nara.jp":             true,
	"shinjo.okayama.jp":          true,
	"shinjo.yamagata.jp":         true,
	"shinjuku.tokyo.jp":          true,
	"shinkamigoto.nagasaki.jp":   true,
	"shinonsen.hyogo.jp":         true,
	"shinshinotsu.hokkaido.jp":   true,
	"shinshiro.aichi.jp":         true,
	"shinto.gunma.jp":            true,
	"shintoku.hokkaido.jp":       true,
	"shintomi.miyazaki.jp":       true,
	"shinyoshitomi.fukuoka.jp":   true,
	"shiogama.miyagi.jp":         true,
	"shiojiri.nagano.jp":         true,
	"shioya.tochigi.jp":          true,
	"shirahama.wakayama.jp":      true,
	"shirakawa.fukushima.jp":     true,
	"shirakawa.gifu.jp":          true,
	"shirako.chiba.jp":           true,
	"shiranuka.hokkaido.jp":      true,
	"shiraoi.hokkaido.jp":        true,
	"shiraoka.saitama.jp":        true,
	"shirataka.yamagata.jp":      true,
	"shiriuchi.hokkaido.jp":      true,
	"shiroi.chiba.jp":            true,
	"shiroishi.miyagi.jp":        true,
	"shiroishi.saga.jp":          true,
	"shirosato.ibaraki.jp":       true,
	"shishikui.tokushima.jp":     true,
	"shiso.hyogo.jp":             true,
	"shisui.chiba.jp":            true,
	"shitara.aichi.jp":           true,
	"shiwa.iwate.jp":             true,
	"shizukuishi.iwate.jp":       true,
	"shizuoka.jp":                true,
	"shizuoka.shizuoka.jp":       true,
	"shobara.hiroshima.jp":       true,
	"shoes":                      true,
	"shonai.fukuoka.jp":          true,
	"shonai.yamagata.jp":         true,
	"shoo.okayama.jp":            true,
	"shop.ht":                    true,
	"shop.hu":                    true,
	"shop.pl":                    true,
	"shouji":                     true,
	"show.aero":                  true,
	"showa.fukushima.jp":         true,
	"showa.gunma.jp":             true,
	"showa.yamanashi.jp":         true,
	"shriram":                    true,
	"shunan.yamaguchi.jp":        true,
	"si":                     true,
	"si.it":                  true,
	"sibenik.museum":         true,
	"sic.it":                 true,
	"sicilia.it":             true,
	"sicily.it":              true,
	"siellak.no":             true,
	"siena.it":               true,
	"sigdal.no":              true,
	"siljan.no":              true,
	"silk.museum":            true,
	"simbirsk.ru":            true,
	"sinaapp.com":            true,
	"singles":                true,
	"siracusa.it":            true,
	"sirdal.no":              true,
	"site":                   true,
	"sj":                     true,
	"sk":                     true,
	"sk.ca":                  true,
	"skanit.no":              true,
	"skanland.no":            true,
	"skaun.no":               true,
	"skedsmo.no":             true,
	"skedsmokorset.no":       true,
	"ski.museum":             true,
	"ski.no":                 true,
	"skien.no":               true,
	"skierva.no":             true,
	"skin":                   true,
	"skiptvet.no":            true,
	"skjak.no":               true,
	"skjervoy.no":            true,
	"sklep.pl":               true,
	"skoczow.pl":             true,
	"skodje.no":              true,
	"skole.museum":           true,
	"sky":                    true,
	"skydiving.aero":         true,
	"skype":                  true,
	"sl":                     true,
	"slask.pl":               true,
	"slattum.no":             true,
	"sld.do":                 true,
	"sld.pa":                 true,
	"slg.br":                 true,
	"slupsk.pl":              true,
	"sm":                     true,
	"sm.ua":                  true,
	"smile":                  true,
	"smola.no":               true,
	"smolensk.ru":            true,
	"sn":                     true,
	"sn.cn":                  true,
	"snaase.no":              true,
	"snasa.no":               true,
	"snillfjord.no":          true,
	"snoasa.no":              true,
	"snz.ru":                 true,
	"so":                     true,
	"so.gov.pl":              true,
	"so.it":                  true,
	"sobetsu.hokkaido.jp":    true,
	"soc.lk":                 true,
	"sochi.su":               true,
	"social":                 true,
	"society.museum":         true,
	"sodegaura.chiba.jp":     true,
	"soeda.fukuoka.jp":       true,
	"software":               true,
	"software.aero":          true,
	"sogndal.no":             true,
	"sogne.no":               true,
	"sohu":                   true,
	"soja.okayama.jp":        true,
	"soka.saitama.jp":        true,
	"sokndal.no":             true,
	"sola.no":                true,
	"solar":                  true,
	"sologne.museum":         true,
	"solund.no":              true,
	"solutions":              true,
	"soma.fukushima.jp":      true,
	"somna.no":               true,
	"sondrio.it":             true,
	"songdalen.no":           true,
	"soni.nara.jp":           true,
	"sony":                   true,
	"soo.kagoshima.jp":       true,
	"sopot.pl":               true,
	"sorfold.no":             true,
	"sorreisa.no":            true,
	"sortland.no":            true,
	"sorum.no":               true,
	"sos.pl":                 true,
	"sosa.chiba.jp":          true,
	"sosnowiec.pl":           true,
	"soundandvision.museum":  true,
	"southcarolina.museum":   true,
	"southwest.museum":       true,
	"sowa.ibaraki.jp":        true,
	"soy":                    true,
	"sp.it":                  true,
	"space":                  true,
	"space.museum":           true,
	"spb.ru":                 true,
	"spb.su":                 true,
	"spiegel":                true,
	"spjelkavik.no":          true,
	"sport.hu":               true,
	"spreadbetting":          true,
	"spy.museum":             true,
	"spydeberg.no":           true,
	"square.museum":          true,
	"sr":                     true,
	"sr.gov.pl":              true,
	"sr.it":                  true,
	"srv.br":                 true,
	"ss.it":                  true,
	"st":                     true,
	"st.no":                  true,
	"stada":                  true,
	"stadt.museum":           true,
	"stalbans.museum":        true,
	"stange.no":              true,
	"star":                   true,
	"starachowice.pl":        true,
	"stargard.pl":            true,
	"starnberg.museum":       true,
	"starostwo.gov.pl":       true,
	"stat.no":                true,
	"state.museum":           true,
	"stateofdelaware.museum": true,
	"stathelle.no":           true,
	"station.museum":         true,
	"statoil":                true,
	"stavanger.no":           true,
	"stavern.no":             true,
	"stavropol.ru":           true,
	"stc":                    true,
	"stcgroup":               true,
	"steam.museum":           true,
	"steiermark.museum":      true,
	"steigen.no":             true,
	"steinkjer.no":           true,
	"stjohn.museum":          true,
	"stjordal.no":            true,
	"stjordalshalsen.no":     true,
	"stockholm":              true,
	"stockholm.museum":       true,
	"stokke.no":              true,
	"storage":                true,
	"stord.no":               true,
	"stordal.no":             true,
	"store.bb":               true,
	"store.nf":               true,
	"store.ro":               true,
	"store.st":               true,
	"store.ve":               true,
	"storfjord.no":           true,
	"stpetersburg.museum":    true,
	"strand.no":              true,
	"stranda.no":             true,
	"stryn.no":               true,
	"student.aero":           true,
	"study":                  true,
	"stuttgart.museum":       true,
	"stv.ru":                 true,
	"style":                  true,
	"su":                     true,
	"sucks":                  true,
	"sue.fukuoka.jp":         true,
	"suedtirol.it":           true,
	"suginami.tokyo.jp":      true,
	"sugito.saitama.jp":      true,
	"suifu.ibaraki.jp":       true,
	"suisse.museum":          true,
	"suita.osaka.jp":         true,
	"sukagawa.fukushima.jp":  true,
	"sukumo.kochi.jp":        true,
	"sula.no":                true,
	"suldal.no":              true,
	"suli.hu":                true,
	"sumida.tokyo.jp":        true,
	"sumita.iwate.jp":        true,
	"sumoto.hyogo.jp":        true,
	"sumoto.kumamoto.jp":     true,
	"sumy.ua":                true,
	"sunagawa.hokkaido.jp":   true,
	"sund.no":                true,
	"sunndal.no":             true,
	"supplies":               true,
	"supply":                 true,
	"support":                true,
	"surf":                   true,
	"surgeonshall.museum":    true,
	"surgery":                true,
	"surgut.ru":              true,
	"surnadal.no":            true,
	"surrey.museum":          true,
	"susaki.kochi.jp":        true,
	"susono.shizuoka.jp":     true,
	"suwa.nagano.jp":         true,
	"suwalki.pl":             true,
	"suzaka.nagano.jp":       true,
	"suzu.ishikawa.jp":       true,
	"suzuka.mie.jp":          true,
	"suzuki":                 true,
	"sv":                     true,
	"sv.it":                  true,
	"svalbard.no":            true,
	"sveio.no":               true,
	"svelvik.no":             true,
	"svizzera.museum":        true,
	"swatch":                 true,
	"sweden.museum":          true,
	"swidnica.pl":            true,
	"swiebodzin.pl":          true,
	"swinoujscie.pl":         true,
	"swiss":                  true,
	"sx":                     true,
	"sx.cn":                  true,
	"sy":                     true,
	"sydney":                 true,
	"sydney.museum":          true,
	"sykkylven.no":           true,
	"symantec":               true,
	"systems":                true,
	"syzran.ru":              true,
	"sz":                     true,
	"szczecin.pl":            true,
	"szczytno.pl":            true,
	"szex.hu":                true,
	"szkola.pl":              true,
	"t.bg":                   true,
	"t.se":                   true,
	"ta.it":                  true,
	"taa.it":                 true,
	"tab":                    true,
	"tabayama.yamanashi.jp":    true,
	"tabuse.yamaguchi.jp":      true,
	"tachiarai.fukuoka.jp":     true,
	"tachikawa.tokyo.jp":       true,
	"tadaoka.osaka.jp":         true,
	"tado.mie.jp":              true,
	"tadotsu.kagawa.jp":        true,
	"tagajo.miyagi.jp":         true,
	"tagami.niigata.jp":        true,
	"tagawa.fukuoka.jp":        true,
	"tahara.aichi.jp":          true,
	"taiji.wakayama.jp":        true,
	"taiki.hokkaido.jp":        true,
	"taiki.mie.jp":             true,
	"tainai.niigata.jp":        true,
	"taipei":                   true,
	"taira.toyama.jp":          true,
	"taishi.hyogo.jp":          true,
	"taishi.osaka.jp":          true,
	"taishin.fukushima.jp":     true,
	"taito.tokyo.jp":           true,
	"taiwa.miyagi.jp":          true,
	"tajimi.gifu.jp":           true,
	"tajiri.osaka.jp":          true,
	"taka.hyogo.jp":            true,
	"takagi.nagano.jp":         true,
	"takahagi.ibaraki.jp":      true,
	"takahama.aichi.jp":        true,
	"takahama.fukui.jp":        true,
	"takaharu.miyazaki.jp":     true,
	"takahashi.okayama.jp":     true,
	"takahata.yamagata.jp":     true,
	"takaishi.osaka.jp":        true,
	"takamatsu.kagawa.jp":      true,
	"takamori.kumamoto.jp":     true,
	"takamori.nagano.jp":       true,
	"takanabe.miyazaki.jp":     true,
	"takanezawa.tochigi.jp":    true,
	"takaoka.toyama.jp":        true,
	"takarazuka.hyogo.jp":      true,
	"takasago.hyogo.jp":        true,
	"takasaki.gunma.jp":        true,
	"takashima.shiga.jp":       true,
	"takasu.hokkaido.jp":       true,
	"takata.fukuoka.jp":        true,
	"takatori.nara.jp":         true,
	"takatsuki.osaka.jp":       true,
	"takatsuki.shiga.jp":       true,
	"takayama.gifu.jp":         true,
	"takayama.gunma.jp":        true,
	"takayama.nagano.jp":       true,
	"takazaki.miyazaki.jp":     true,
	"takehara.hiroshima.jp":    true,
	"taketa.oita.jp":           true,
	"taketomi.okinawa.jp":      true,
	"taki.mie.jp":              true,
	"takikawa.hokkaido.jp":     true,
	"takino.hyogo.jp":          true,
	"takinoue.hokkaido.jp":     true,
	"takko.aomori.jp":          true,
	"tako.chiba.jp":            true,
	"taku.saga.jp":             true,
	"tama.tokyo.jp":            true,
	"tamakawa.fukushima.jp":    true,
	"tamaki.mie.jp":            true,
	"tamamura.gunma.jp":        true,
	"tamano.okayama.jp":        true,
	"tamatsukuri.ibaraki.jp":   true,
	"tamayu.shimane.jp":        true,
	"tamba.hyogo.jp":           true,
	"tambov.ru":                true,
	"tana.no":                  true,
	"tanabe.kyoto.jp":          true,
	"tanabe.wakayama.jp":       true,
	"tanagura.fukushima.jp":    true,
	"tananger.no":              true,
	"tank.museum":              true,
	"tanohata.iwate.jp":        true,
	"taobao":                   true,
	"tara.saga.jp":             true,
	"tarama.okinawa.jp":        true,
	"taranto.it":               true,
	"targi.pl":                 true,
	"tarnobrzeg.pl":            true,
	"tarui.gifu.jp":            true,
	"tarumizu.kagoshima.jp":    true,
	"tas.au":                   true,
	"tas.edu.au":               true,
	"tas.gov.au":               true,
	"tatar":                    true,
	"tatarstan.ru":             true,
	"tatebayashi.gunma.jp":     true,
	"tateshina.nagano.jp":      true,
	"tateyama.chiba.jp":        true,
	"tateyama.toyama.jp":       true,
	"tatsuno.hyogo.jp":         true,
	"tatsuno.nagano.jp":        true,
	"tattoo":                   true,
	"tawaramoto.nara.jp":       true,
	"tax":                      true,
	"taxi.aero":                true,
	"taxi.br":                  true,
	"tc":                       true,
	"tci":                      true,
	"tcm.museum":               true,
	"td":                       true,
	"te.it":                    true,
	"te.ua":                    true,
	"tec.ve":                   true,
	"technology":               true,
	"technology.museum":        true,
	"tel":                      true,
	"tel.tr":                   true,
	"telefonica":               true,
	"telekommunikation.museum": true,
	"television.museum":        true,
	"temasek":                  true,
	"tempioolbia.it":           true,
	"tendo.yamagata.jp":        true,
	"tenei.fukushima.jp":       true,
	"tenkawa.nara.jp":          true,
	"tennis":                   true,
	"tenri.nara.jp":            true,
	"teo.br":                   true,
	"teramo.it":                true,
	"terni.it":                 true,
	"ternopil.ua":              true,
	"teshikaga.hokkaido.jp":    true,
	"test.ru":                  true,
	"test.tj":                  true,
	"texas.museum":             true,
	"textile.museum":           true,
	"tf":                       true,
	"tg":                       true,
	"tgory.pl":                 true,
	"th":                       true,
	"theater.museum":           true,
	"thruhere.net":             true,
	"tienda":                   true,
	"time.museum":              true,
	"time.no":                  true,
	"timekeeping.museum":       true,
	"tingvoll.no":              true,
	"tinn.no":                  true,
	"tips":                     true,
	"tires":                    true,
	"tirol":                    true,
	"tj":                       true,
	"tj.cn":                    true,
	"tjeldsund.no":             true,
	"tjome.no":                 true,
	"tk":                       true,
	"tl":                       true,
	"tm":                       true,
	"tm.fr":                    true,
	"tm.hu":                    true,
	"tm.km":                    true,
	"tm.mc":                    true,
	"tm.mg":                    true,
	"tm.no":                    true,
	"tm.pl":                    true,
	"tm.ro":                    true,
	"tm.se":                    true,
	"tmall":                    true,
	"tmp.br":                   true,
	"tn":                       true,
	"tn.it":                    true,
	"tn.us":                    true,
	"to":                       true,
	"to.it":                    true,
	"toba.mie.jp":              true,
	"tobe.ehime.jp":            true,
	"tobetsu.hokkaido.jp":      true,
	"tobishima.aichi.jp":       true,
	"tochigi.jp":               true,
	"tochigi.tochigi.jp":       true,
	"tochio.niigata.jp":        true,
	"toda.saitama.jp":          true,
	"today":                    true,
	"toei.aichi.jp":            true,
	"toga.toyama.jp":           true,
	"togakushi.nagano.jp":      true,
	"togane.chiba.jp":          true,
	"togitsu.nagasaki.jp":      true,
	"togliatti.su":             true,
	"togo.aichi.jp":            true,
	"togura.nagano.jp":         true,
	"tohma.hokkaido.jp":        true,
	"tohnosho.chiba.jp":        true,
	"toho.fukuoka.jp":          true,
	"tokai.aichi.jp":           true,
	"tokai.ibaraki.jp":         true,
	"tokamachi.niigata.jp":     true,
	"tokashiki.okinawa.jp":     true,
	"toki.gifu.jp":             true,
	"tokigawa.saitama.jp":      true,
	"tokke.no":                 true,
	"tokoname.aichi.jp":        true,
	"tokorozawa.saitama.jp":    true,
	"tokushima.jp":             true,
	"tokushima.tokushima.jp":   true,
	"tokuyama.yamaguchi.jp":    true,
	"tokyo":                    true,
	"tokyo.jp":                 true,
	"tolga.no":                 true,
	"tom.ru":                   true,
	"tomakomai.hokkaido.jp":    true,
	"tomari.hokkaido.jp":       true,
	"tome.miyagi.jp":           true,
	"tomi.nagano.jp":           true,
	"tomigusuku.okinawa.jp":    true,
	"tomika.gifu.jp":           true,
	"tomioka.gunma.jp":         true,
	"tomisato.chiba.jp":        true,
	"tomiya.miyagi.jp":         true,
	"tomobe.ibaraki.jp":        true,
	"tomsk.ru":                 true,
	"tonaki.okinawa.jp":        true,
	"tonami.toyama.jp":         true,
	"tondabayashi.osaka.jp":    true,
	"tone.ibaraki.jp":          true,
	"tono.iwate.jp":            true,
	"tonosho.kagawa.jp":        true,
	"tonsberg.no":              true,
	"tools":                    true,
	"toon.ehime.jp":            true,
	"top":                      true,
	"topology.museum":          true,
	"torahime.shiga.jp":        true,
	"toray":                    true,
	"toride.ibaraki.jp":        true,
	"torino.it":                true,
	"torino.museum":            true,
	"torsken.no":               true,
	"tos.it":                   true,
	"tosa.kochi.jp":            true,
	"tosashimizu.kochi.jp":     true,
	"toscana.it":               true,
	"toshiba":                  true,
	"toshima.tokyo.jp":         true,
	"tosu.saga.jp":             true,
	"tottori.jp":               true,
	"tottori.tottori.jp":       true,
	"touch.museum":             true,
	"tourism.pl":               true,
	"tourism.tn":               true,
	"tours":                    true,
	"towada.aomori.jp":         true,
	"town":                     true,
	"town.museum":              true,
	"toya.hokkaido.jp":         true,
	"toyako.hokkaido.jp":       true,
	"toyama.jp":                true,
	"toyama.toyama.jp":         true,
	"toyo.kochi.jp":            true,
	"toyoake.aichi.jp":         true,
	"toyohashi.aichi.jp":       true,
	"toyokawa.aichi.jp":        true,
	"toyonaka.osaka.jp":        true,
	"toyone.aichi.jp":          true,
	"toyono.osaka.jp":          true,
	"toyooka.hyogo.jp":         true,
	"toyosato.shiga.jp":        true,
	"toyota.aichi.jp":          true,
	"toyota.yamaguchi.jp":      true,
	"toyotomi.hokkaido.jp":     true,
	"toyotsu.fukuoka.jp":       true,
	"toyoura.hokkaido.jp":      true,
	"toys":                     true,
	"tozawa.yamagata.jp":       true,
	"tozsde.hu":                true,
	"tp":                       true,
	"tp.it":                    true,
	"tr":                       true,
	"tr.it":                    true,
	"tr.no":                    true,
	"tra.kp":                   true,
	"trade":                    true,
	"trader.aero":              true,
	"trading":                  true,
	"trading.aero":             true,
	"traeumtgerade.de":         true,
	"trainer.aero":             true,
	"training":                 true,
	"trana.no":                 true,
	"tranby.no":                true,
	"traniandriabarletta.it":   true,
	"tranibarlettaandria.it":   true,
	"tranoy.no":                true,
	"transport.museum":         true,
	"trapani.it":               true,
	"travel":                   true,
	"travel.pl":                true,
	"travel.tt":                true,
	"trd.br":                   true,
	"tree.museum":              true,
	"trentino.it":              true,
	"trentinoaadige.it":        true,
	"trentinoaltoadige.it":     true,
	"trentinostirol.it":        true,
	"trentinosudtirol.it":      true,
	"trentinosuedtirol.it":     true,
	"trento.it":                true,
	"treviso.it":               true,
	"trieste.it":               true,
	"troandin.no":              true,
	"trogstad.no":              true,
	"troitsk.su":               true,
	"trolley.museum":           true,
	"tromsa.no":                true,
	"tromso.no":                true,
	"trondheim.no":             true,
	"trust":                    true,
	"trust.museum":             true,
	"trustee.museum":           true,
	"trysil.no":                true,
	"ts.it":                    true,
	"tsaritsyn.ru":             true,
	"tsk.ru":                   true,
	"tsu.mie.jp":               true,
	"tsubame.niigata.jp":       true,
	"tsubata.ishikawa.jp":      true,
	"tsubetsu.hokkaido.jp":     true,
	"tsuchiura.ibaraki.jp":     true,
	"tsuga.tochigi.jp":         true,
	"tsugaru.aomori.jp":        true,
	"tsuiki.fukuoka.jp":        true,
	"tsukigata.hokkaido.jp":    true,
	"tsukiyono.gunma.jp":       true,
	"tsukuba.ibaraki.jp":       true,
	"tsukui.kanagawa.jp":       true,
	"tsukumi.oita.jp":          true,
	"tsumagoi.gunma.jp":        true,
	"tsunan.niigata.jp":        true,
	"tsuno.kochi.jp":           true,
	"tsuno.miyazaki.jp":        true,
	"tsuru.yamanashi.jp":       true,
	"tsuruga.fukui.jp":         true,
	"tsurugashima.saitama.jp":  true,
	"tsurugi.ishikawa.jp":      true,
	"tsuruoka.yamagata.jp":     true,
	"tsuruta.aomori.jp":        true,
	"tsushima.aichi.jp":        true,
	"tsushima.nagasaki.jp":     true,
	"tsuwano.shimane.jp":       true,
	"tsuyama.okayama.jp":       true,
	"tt":                       true,
	"tt.im":                    true,
	"tui":                      true,
	"tula.ru":                  true,
	"tula.su":                  true,
	"tur.ar":                   true,
	"tur.br":                   true,
	"turek.pl":                 true,
	"turen.tn":                 true,
	"turin.it":                 true,
	"turystyka.pl":             true,
	"tuscany.it":               true,
	"tushu":                    true,
	"tuva.ru":                  true,
	"tuva.su":                  true,
	"tv":                       true,
	"tv.bb":                    true,
	"tv.bo":                    true,
	"tv.br":                    true,
	"tv.im":                    true,
	"tv.it":                    true,
	"tv.na":                    true,
	"tv.sd":                    true,
	"tv.tr":                    true,
	"tv.tz":                    true,
	"tvedestrand.no":           true,
	"tver.ru":                  true,
	"tw":                       true,
	"tw.cn":                    true,
	"tx.us":                    true,
	"tychy.pl":                 true,
	"tydal.no":                 true,
	"tynset.no":                true,
	"tysfjord.no":              true,
	"tysnes.no":                true,
	"tysvar.no":                true,
	"tyumen.ru":                true,
	"tz":                       true,
	"u.bg":                     true,
	"u.se":                     true,
	"ua":                       true,
	"ube.yamaguchi.jp":         true,
	"ubs":                      true,
	"uchihara.ibaraki.jp":   true,
	"uchiko.ehime.jp":       true,
	"uchinada.ishikawa.jp":  true,
	"uchinomi.kagawa.jp":    true,
	"ud.it":                 true,
	"uda.nara.jp":           true,
	"udine.it":              true,
	"udm.ru":                true,
	"udmurtia.ru":           true,
	"udono.mie.jp":          true,
	"ueda.nagano.jp":        true,
	"ueno.gunma.jp":         true,
	"uenohara.yamanashi.jp": true,
	"ug":                      true,
	"ug.gov.pl":               true,
	"uhren.museum":            true,
	"uji.kyoto.jp":            true,
	"ujiie.tochigi.jp":        true,
	"ujitawara.kyoto.jp":      true,
	"uk":                      true,
	"uk.com":                  true,
	"uk.net":                  true,
	"uki.kumamoto.jp":         true,
	"ukiha.fukuoka.jp":        true,
	"ullensaker.no":           true,
	"ullensvang.no":           true,
	"ulm.museum":              true,
	"ulsan.kr":                true,
	"ulvik.no":                true,
	"um.gov.pl":               true,
	"umaji.kochi.jp":          true,
	"umb.it":                  true,
	"umbria.it":               true,
	"umi.fukuoka.jp":          true,
	"unazuki.toyama.jp":       true,
	"unbi.ba":                 true,
	"undersea.museum":         true,
	"union.aero":              true,
	"univ.sn":                 true,
	"university":              true,
	"university.museum":       true,
	"unjarga.no":              true,
	"unnan.shimane.jp":        true,
	"uno":                     true,
	"unsa.ba":                 true,
	"unzen.nagasaki.jp":       true,
	"uol":                     true,
	"uonuma.niigata.jp":       true,
	"uozu.toyama.jp":          true,
	"upow.gov.pl":             true,
	"urakawa.hokkaido.jp":     true,
	"urasoe.okinawa.jp":       true,
	"urausu.hokkaido.jp":      true,
	"urawa.saitama.jp":        true,
	"urayasu.chiba.jp":        true,
	"urbinopesaro.it":         true,
	"ureshino.mie.jp":         true,
	"uri.arpa":                true,
	"urn.arpa":                true,
	"uruma.okinawa.jp":        true,
	"uryu.hokkaido.jp":        true,
	"us":                      true,
	"us.com":                  true,
	"us.na":                   true,
	"us.org":                  true,
	"usa.museum":              true,
	"usa.oita.jp":             true,
	"usantiques.museum":       true,
	"usarts.museum":           true,
	"uscountryestate.museum":  true,
	"usculture.museum":        true,
	"usdecorativearts.museum": true,
	"usgarden.museum":         true,
	"ushiku.ibaraki.jp":       true,
	"ushistory.museum":        true,
	"ushuaia.museum":          true,
	"uslivinghistory.museum":  true,
	"ustka.pl":                true,
	"usui.fukuoka.jp":         true,
	"usuki.oita.jp":           true,
	"ut.us":                   true,
	"utah.museum":             true,
	"utashinai.hokkaido.jp":   true,
	"utazas.hu":               true,
	"utazu.kagawa.jp":         true,
	"uto.kumamoto.jp":         true,
	"utsira.no":               true,
	"utsunomiya.tochigi.jp":   true,
	"uvic.museum":             true,
	"uw.gov.pl":               true,
	"uwajima.ehime.jp":        true,
	"uy":                      true,
	"uy.com":                  true,
	"uz":                      true,
	"uz.ua":                   true,
	"uzhgorod.ua":             true,
	"v.bg":                    true,
	"va":                      true,
	"va.it":                   true,
	"va.no":                   true,
	"va.us":                   true,
	"vaapste.no":              true,
	"vacations":               true,
	"vadso.no":                true,
	"vaga.no":                 true,
	"vagan.no":                true,
	"vagsoy.no":               true,
	"vaksdal.no":              true,
	"valdaosta.it":            true,
	"valer.hedmark.no":        true,
	"valer.ostfold.no":        true,
	"valle.no":                true,
	"valleaosta.it":           true,
	"valledaosta.it":          true,
	"valleeaoste.it":          true,
	"valley.museum":           true,
	"vana":                    true,
	"vang.no":                 true,
	"vantaa.museum":           true,
	"vanylven.no":             true,
	"vao.it":                  true,
	"vardo.no":                true,
	"varese.it":               true,
	"varggat.no":              true,
	"varoy.no":                true,
	"vb.it":                   true,
	"vc":                      true,
	"vc.it":                   true,
	"vda.it":                  true,
	"vdonsk.ru":               true,
	"ve":                      true,
	"ve.it":                   true,
	"vefsn.no":                true,
	"vega.no":                 true,
	"vegarshei.no":            true,
	"vegas":                   true,
	"ven.it":                  true,
	"veneto.it":               true,
	"venezia.it":              true,
	"venice.it":               true,
	"vennesla.no":             true,
	"ventures":                true,
	"verbania.it":             true,
	"vercelli.it":             true,
	"verdal.no":               true,
	"verona.it":               true,
	"verran.no":               true,
	"versailles.museum":       true,
	"versicherung":            true,
	"vestby.no":               true,
	"vestnes.no":              true,
	"vestvagoy.no":            true,
	"vet":                     true,
	"vet.br":                  true,
	"veterinaire.fr":          true,
	"veterinaire.km":          true,
	"vevelstad.no":            true,
	"vf.no":                   true,
	"vg":                      true,
	"vgs.no":                  true,
	"vi":                      true,
	"vi.it":                   true,
	"vi.us":                   true,
	"viajes":                  true,
	"vibovalentia.it":         true,
	"vic.au":                  true,
	"vic.edu.au":              true,
	"vic.gov.au":              true,
	"vicenza.it":              true,
	"video":                   true,
	"video.hu":                true,
	"vik.no":                  true,
	"viking.museum":           true,
	"vikna.no":                true,
	"village.museum":          true,
	"villas":                  true,
	"vindafjord.no":           true,
	"vinnica.ua":              true,
	"vinnytsia.ua":            true,
	"vip":                     true,
	"vipsinaapp.com":          true,
	"virgin":                  true,
	"virginia.museum":         true,
	"virtual.museum":          true,
	"virtuel.museum":          true,
	"vision":                  true,
	"vista":                   true,
	"vistaprint":              true,
	"viterbo.it":              true,
	"viva":                    true,
	"vlaanderen":              true,
	"vlaanderen.museum":       true,
	"vladikavkaz.ru":          true,
	"vladikavkaz.su":          true,
	"vladimir.ru":             true,
	"vladimir.su":             true,
	"vladivostok.ru":          true,
	"vlog.br":                 true,
	"vn":                      true,
	"vn.ua":                   true,
	"voagat.no":               true,
	"vodka":                   true,
	"volda.no":                true,
	"volgograd.ru":            true,
	"volkenkunde.museum":      true,
	"vologda.ru":              true,
	"vologda.su":              true,
	"volyn.ua":                true,
	"voronezh.ru":             true,
	"voss.no":                 true,
	"vossevangen.no":          true,
	"vote":                    true,
	"voting":                  true,
	"voto":                    true,
	"voyage":                  true,
	"vr.it":                   true,
	"vrn.ru":                  true,
	"vs.it":                   true,
	"vt.it":                   true,
	"vt.us":                   true,
	"vu":                      true,
	"vv.it":                   true,
	"vyatka.ru":               true,
	"w.bg":                    true,
	"w.se":                    true,
	"wa.au":                   true,
	"wa.edu.au":               true,
	"wa.gov.au":               true,
	"wa.us":                   true,
	"wada.nagano.jp":          true,
	"wajiki.tokushima.jp":     true,
	"wajima.ishikawa.jp":      true,
	"wakasa.fukui.jp":         true,
	"wakasa.tottori.jp":       true,
	"wakayama.jp":             true,
	"wakayama.wakayama.jp":    true,
	"wake.okayama.jp":         true,
	"wakkanai.hokkaido.jp":    true,
	"wakuya.miyagi.jp":        true,
	"walbrzych.pl":            true,
	"wales":                   true,
	"wales.museum":            true,
	"wallonie.museum":         true,
	"walter":                  true,
	"wang":                    true,
	"wanggou":                 true,
	"wanouchi.gifu.jp":        true,
	"war.museum":              true,
	"warabi.saitama.jp":       true,
	"warmia.pl":               true,
	"warszawa.pl":             true,
	"washingtondc.museum":     true,
	"wassamu.hokkaido.jp":     true,
	"watarai.mie.jp":          true,
	"watari.miyagi.jp":        true,
	"watch":                   true,
	"watchandclock.museum":    true,
	"watches":                 true,
	"waw.pl":                  true,
	"wazuka.kyoto.jp":         true,
	"weather":                 true,
	"web.co":                  true,
	"web.do":                  true,
	"web.id":                  true,
	"web.lk":                  true,
	"web.nf":                  true,
	"web.pk":                  true,
	"web.tj":                  true,
	"web.tr":                  true,
	"web.ve":                  true,
	"webcam":                  true,
	"webhop.biz":              true,
	"webhop.info":             true,
	"webhop.net":              true,
	"webhop.org":              true,
	"website":                 true,
	"wed":                     true,
	"wedding":                 true,
	"wegrow.pl":               true,
	"western.museum":          true,
	"westfalen.museum":        true,
	"wf":                      true,
	"whaling.museum":          true,
	"whoswho":                 true,
	"wi.us":                   true,
	"wielun.pl":               true,
	"wien":                    true,
	"wiki":                    true,
	"wiki.br":                 true,
	"wildlife.museum":         true,
	"williamhill":             true,
	"williamsburg.museum":     true,
	"win":                      true,
	"windmill.museum":          true,
	"windows":                  true,
	"withgoogle.com":           true,
	"wlocl.pl":                 true,
	"wloclawek.pl":             true,
	"wme":                      true,
	"wodzislaw.pl":             true,
	"wolomin.pl":               true,
	"work":                     true,
	"workinggroup.aero":        true,
	"works":                    true,
	"works.aero":               true,
	"workshop.museum":          true,
	"world":                    true,
	"writesthisblog.com":       true,
	"wroc.pl":                  true,
	"wroclaw.pl":               true,
	"ws":                       true,
	"ws.na":                    true,
	"wtc":                      true,
	"wtf":                      true,
	"wv.us":                    true,
	"www.ro":                   true,
	"wy.us":                    true,
	"x.bg":                     true,
	"x.se":                     true,
	"xbox":                     true,
	"xerox":                    true,
	"xihuan":                   true,
	"xin":                      true,
	"xj.cn":                    true,
	"xxx":                      true,
	"xyz":                      true,
	"xz.cn":                    true,
	"y.bg":                     true,
	"y.se":                     true,
	"yabu.hyogo.jp":            true,
	"yabuki.fukushima.jp":      true,
	"yachimata.chiba.jp":       true,
	"yachiyo.chiba.jp":         true,
	"yachiyo.ibaraki.jp":       true,
	"yachts":                   true,
	"yaese.okinawa.jp":         true,
	"yahaba.iwate.jp":          true,
	"yahiko.niigata.jp":        true,
	"yaita.tochigi.jp":         true,
	"yaizu.shizuoka.jp":        true,
	"yakage.okayama.jp":        true,
	"yakumo.hokkaido.jp":       true,
	"yakumo.shimane.jp":        true,
	"yakutia.ru":               true,
	"yalta.ua":                 true,
	"yamada.fukuoka.jp":        true,
	"yamada.iwate.jp":          true,
	"yamada.toyama.jp":         true,
	"yamaga.kumamoto.jp":       true,
	"yamagata.gifu.jp":         true,
	"yamagata.ibaraki.jp":      true,
	"yamagata.jp":              true,
	"yamagata.nagano.jp":       true,
	"yamagata.yamagata.jp":     true,
	"yamaguchi.jp":             true,
	"yamakita.kanagawa.jp":     true,
	"yamal.ru":                 true,
	"yamamoto.miyagi.jp":       true,
	"yamanakako.yamanashi.jp":  true,
	"yamanashi.jp":             true,
	"yamanashi.yamanashi.jp":   true,
	"yamanobe.yamagata.jp":     true,
	"yamanouchi.nagano.jp":     true,
	"yamashina.kyoto.jp":       true,
	"yamato.fukushima.jp":      true,
	"yamato.kanagawa.jp":       true,
	"yamato.kumamoto.jp":       true,
	"yamatokoriyama.nara.jp":   true,
	"yamatotakada.nara.jp":     true,
	"yamatsuri.fukushima.jp":   true,
	"yamaxun":                  true,
	"yamazoe.nara.jp":          true,
	"yame.fukuoka.jp":          true,
	"yanagawa.fukuoka.jp":      true,
	"yanaizu.fukushima.jp":     true,
	"yandex":                   true,
	"yao.osaka.jp":             true,
	"yaotsu.gifu.jp":           true,
	"yaroslavl.ru":             true,
	"yasaka.nagano.jp":         true,
	"yashio.saitama.jp":        true,
	"yashiro.hyogo.jp":         true,
	"yasu.shiga.jp":            true,
	"yasuda.kochi.jp":          true,
	"yasugi.shimane.jp":        true,
	"yasuoka.nagano.jp":        true,
	"yatomi.aichi.jp":          true,
	"yatsuka.shimane.jp":       true,
	"yatsushiro.kumamoto.jp":   true,
	"yawara.ibaraki.jp":        true,
	"yawata.kyoto.jp":          true,
	"yawatahama.ehime.jp":      true,
	"yazu.tottori.jp":          true,
	"ye":                       true,
	"yekaterinburg.ru":         true,
	"yk.ca":                    true,
	"yn.cn":                    true,
	"yodobashi":                true,
	"yoga":                     true,
	"yoichi.hokkaido.jp":       true,
	"yoita.niigata.jp":         true,
	"yoka.hyogo.jp":            true,
	"yokaichiba.chiba.jp":      true,
	"yokawa.hyogo.jp":          true,
	"yokkaichi.mie.jp":         true,
	"yokohama":                 true,
	"yokohama.jp":              true,
	"yokoshibahikari.chiba.jp": true,
	"yokosuka.kanagawa.jp":     true,
	"yokote.akita.jp":          true,
	"yokoze.saitama.jp":        true,
	"yolasite.com":             true,
	"yomitan.okinawa.jp":       true,
	"yonabaru.okinawa.jp":      true,
	"yonago.tottori.jp":        true,
	"yonaguni.okinawa.jp":      true,
	"yonezawa.yamagata.jp":     true,
	"yono.saitama.jp":          true,
	"yorii.saitama.jp":         true,
	"york.museum":              true,
	"yorkshire.museum":         true,
	"yoro.gifu.jp":             true,
	"yosemite.museum":          true,
	"yoshida.saitama.jp":       true,
	"yoshida.shizuoka.jp":      true,
	"yoshikawa.saitama.jp":     true,
	"yoshimi.saitama.jp":       true,
	"yoshino.nara.jp":          true,
	"yoshinogari.saga.jp":      true,
	"yoshioka.gunma.jp":        true,
	"yotsukaido.chiba.jp":      true,
	"youth.museum":             true,
	"youtube":                  true,
	"yt":                       true,
	"yuasa.wakayama.jp":        true,
	"yufu.oita.jp":             true,
	"yugawa.fukushima.jp":      true,
	"yugawara.kanagawa.jp":     true,
	"yuki.ibaraki.jp":          true,
	"yukuhashi.fukuoka.jp":     true,
	"yun":                true,
	"yura.wakayama.jp":   true,
	"yurihonjo.akita.jp": true,
	"yusuhara.kochi.jp":  true,
	"yusui.kagoshima.jp": true,
	"yuu.yamaguchi.jp":   true,
	"yuza.yamagata.jp":   true,
	"yuzawa.niigata.jp":  true,
	"z.bg":               true,
	"z.se":               true,
	"za":                 true,
	"za.bz":              true,
	"za.com":             true,
	"za.net":             true,
	"za.org":             true,
	"zachpomor.pl":       true,
	"zagan.pl":           true,
	"zakopane.pl":        true,
	"zama.kanagawa.jp":   true,
	"zamami.okinawa.jp":  true,
	"zao.miyagi.jp":      true,
	"zaporizhzhe.ua":     true,
	"zaporizhzhia.ua":    true,
	"zara":               true,
	"zarow.pl":           true,
	"zentsuji.kagawa.jp": true,
	"zero":               true,
	"zgora.pl":           true,
	"zgorzelec.pl":       true,
	"zgrad.ru":           true,
	"zhitomir.ua":        true,
	"zhytomyr.ua":        true,
	"zip":                true,
	"zj.cn":              true,
	"zlg.br":             true,
	"zm":                 true,
	"zone":               true,
	"zoological.museum":  true,
	"zoology.museum":     true,
	"zp.ua":              true,
	"zt.ua":              true,
	"zuerich":            true,
	"zushi.kanagawa.jp":  true,
	"zw":                 true,
}
