// Copyright 2014 ISRG.  All rights reserved
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

package policy

var blacklist = map[string]bool{
	// Special use domains
	// http://www.iana.org/assignments/special-use-domain-names/special-use-domain-names.xhtml#special-use-domain
	// > cut -d, -f1 special-use-domain.csv | grep "\." | sed -e 's/^\(.*\)\.$/  "\1": true,/' | pbcopy
	"in-addr.arpa": true,
	"ip6.arpa":     true,
	"example":      true,
	"example.com":  true,
	"example.net":  true,
	"example.org":  true,
	"invalid":      true,
	"local":        true,
	"localhost":    true,
	"test":         true,

	// Alexa Top 1000
	// from http://s3.amazonaws.com/alexa-static/top-1m.csv.zip
	// > unzip top-1m.csv.zip
	// > cut -d, -f2 top-1m.csv | head -n 1000 | sed -e 's/^\(.*\)$/  "\1": true,/' | pbcopy
	"google.com":                 true,
	"facebook.com":               true,
	"youtube.com":                true,
	"baidu.com":                  true,
	"yahoo.com":                  true,
	"wikipedia.org":              true,
	"amazon.com":                 true,
	"twitter.com":                true,
	"qq.com":                     true,
	"taobao.com":                 true,
	"google.co.in":               true,
	"linkedin.com":               true,
	"live.com":                   true,
	"sina.com.cn":                true,
	"weibo.com":                  true,
	"yahoo.co.jp":                true,
	"tmall.com":                  true,
	"google.co.jp":               true,
	"google.de":                  true,
	"ebay.com":                   true,
	"hao123.com":                 true,
	"blogspot.com":               true,
	"reddit.com":                 true,
	"bing.com":                   true,
	"google.co.uk":               true,
	"sohu.com":                   true,
	"amazon.co.jp":               true,
	"google.com.br":              true,
	"tumblr.com":                 true,
	"imgur.com":                  true,
	"google.fr":                  true,
	"instagram.com":              true,
	"wordpress.com":              true,
	"pinterest.com":              true,
	"t.co":                       true,
	"paypal.com":                 true,
	"msn.com":                    true,
	"apple.com":                  true,
	"microsoft.com":              true,
	"imdb.com":                   true,
	"google.it":                  true,
	"fc2.com":                    true,
	"aliexpress.com":             true,
	"xvideos.com":                true,
	"stackoverflow.com":          true,
	"alibaba.com":                true,
	"google.es":                  true,
	"360.cn":                     true,
	"ask.com":                    true,
	"yandex.ru":                  true,
	"amazon.de":                  true,
	"vk.com":                     true,
	"netflix.com":                true,
	"ziddu.com":                  true,
	"163.com":                    true,
	"google.ca":                  true,
	"adcash.com":                 true,
	"craigslist.org":             true,
	"go.com":                     true,
	"google.com.hk":              true,
	"onclickads.net":             true,
	"naver.com":                  true,
	"cntv.cn":                    true,
	"xhamster.com":               true,
	"soso.com":                   true,
	"amazon.co.uk":               true,
	"rakuten.co.jp":              true,
	"diply.com":                  true,
	"bbc.co.uk":                  true,
	"xinhuanet.com":              true,
	"google.com.tr":              true,
	"googleadservices.com":       true,
	"ebay.de":                    true,
	"kickass.to":                 true,
	"pornhub.com":                true,
	"amazon.cn":                  true,
	"google.pl":                  true,
	"dropbox.com":                true,
	"nicovideo.jp":               true,
	"cnn.com":                    true,
	"google.com.au":              true,
	"mail.ru":                    true,
	"youku.com":                  true,
	"googleusercontent.com":      true,
	"google.ru":                  true,
	"dailymotion.com":            true,
	"gmw.cn":                     true,
	"flipkart.com":               true,
	"jd.com":                     true,
	"blogger.com":                true,
	"github.com":                 true,
	"espn.go.com":                true,
	"buzzfeed.com":               true,
	"huffingtonpost.com":         true,
	"google.co.kr":               true,
	"uol.com.br":                 true,
	"tudou.com":                  true,
	"gmail.com":                  true,
	"nytimes.com":                true,
	"alipay.com":                 true,
	"adobe.com":                  true,
	"pixnet.net":                 true,
	"livedoor.com":               true,
	"indiatimes.com":             true,
	"dailymail.co.uk":            true,
	"ebay.co.uk":                 true,
	"espncricinfo.com":           true,
	"wikia.com":                  true,
	"amazon.in":                  true,
	"weather.com":                true,
	"google.com.tw":              true,
	"pconline.com.cn":            true,
	"sogou.com":                  true,
	"chase.com":                  true,
	"blogspot.in":                true,
	"salesforce.com":             true,
	"outbrain.com":               true,
	"booking.com":                true,
	"wordpress.org":              true,
	"amazonaws.com":              true,
	"globo.com":                  true,
	"douban.com":                 true,
	"godaddy.com":                true,
	"chinadaily.com.cn":          true,
	"themeforest.net":            true,
	"ameblo.jp":                  true,
	"flickr.com":                 true,
	"yelp.com":                   true,
	"china.com":                  true,
	"google.com.eg":              true,
	"google.nl":                  true,
	"bankofamerica.com":          true,
	"dmm.co.jp":                  true,
	"cnet.com":                   true,
	"etsy.com":                   true,
	"about.com":                  true,
	"directrev.com":              true,
	"naver.jp":                   true,
	"ettoday.net":                true,
	"bongacams.com":              true,
	"slideshare.net":             true,
	"google.com.pk":              true,
	"amazon.fr":                  true,
	"theguardian.com":            true,
	"quora.com":                  true,
	"daum.net":                   true,
	"deviantart.com":             true,
	"bbc.com":                    true,
	"snapdeal.com":               true,
	"forbes.com":                 true,
	"stackexchange.com":          true,
	"xnxx.com":                   true,
	"vimeo.com":                  true,
	"livejasmin.com":             true,
	"coccoc.com":                 true,
	"youradexchange.com":         true,
	"twitch.tv":                  true,
	"mozilla.org":                true,
	"life.com.tw":                true,
	"indeed.com":                 true,
	"redtube.com":                true,
	"bp.blogspot.com":            true,
	"china.com.cn":               true,
	"reference.com":              true,
	"aol.com":                    true,
	"google.com.mx":              true,
	"soundcloud.com":             true,
	"youporn.com":                true,
	"walmart.com":                true,
	"ok.ru":                      true,
	"wellsfargo.com":             true,
	"bycontext.com":              true,
	"mailchimp.com":              true,
	"feedly.com":                 true,
	"google.gr":                  true,
	"zol.com.cn":                 true,
	"w3schools.com":              true,
	"amazon.it":                  true,
	"wikihow.com":                true,
	"leboncoin.fr":               true,
	"businessinsider.com":        true,
	"xcar.com.cn":                true,
	"theladbible.com":            true,
	"force.com":                  true,
	"thepiratebay.se":            true,
	"adf.ly":                     true,
	"google.co.za":               true,
	"pclady.com.cn":              true,
	"office365.com":              true,
	"zillow.com":                 true,
	"ilividnewtab.com":           true,
	"pcbaby.com.cn":              true,
	"allegro.pl":                 true,
	"google.com.ua":              true,
	"popads.net":                 true,
	"google.co.id":               true,
	"tripadvisor.com":            true,
	"torrentz.eu":                true,
	"goo.ne.jp":                  true,
	"loading-delivery1.com":      true,
	"washingtonpost.com":         true,
	"ikea.com":                   true,
	"wikimedia.org":              true,
	"onet.pl":                    true,
	"blogfa.com":                 true,
	"secureserver.net":           true,
	"kakaku.com":                 true,
	"pixiv.net":                  true,
	"livejournal.com":            true,
	"dmm.com":                    true,
	"microsoftonline.com":        true,
	"ifeng.com":                  true,
	"google.be":                  true,
	"google.com.co":              true,
	"mashable.com":               true,
	"ndtv.com":                   true,
	"foxnews.com":                true,
	"sourceforge.net":            true,
	"ppomppu.co.kr":              true,
	"ups.com":                    true,
	"files.wordpress.com":        true,
	"tubecup.com":                true,
	"archive.org":                true,
	"bestbuy.com":                true,
	"caijing.com.cn":             true,
	"web.de":                     true,
	"usps.com":                   true,
	"nih.gov":                    true,
	"gome.com.cn":                true,
	"quikr.com":                  true,
	"vice.com":                   true,
	"stumbleupon.com":            true,
	"9gag.com":                   true,
	"pchome.net":                 true,
	"google.ro":                  true,
	"google.cn":                  true,
	"shutterstock.com":           true,
	"comcast.net":                true,
	"smzdm.com":                  true,
	"mystart.com":                true,
	"gmx.net":                    true,
	"doorblog.jp":                true,
	"americanexpress.com":        true,
	"youth.cn":                   true,
	"weebly.com":                 true,
	"intuit.com":                 true,
	"orange.fr":                  true,
	"google.com.sg":              true,
	"bet365.com":                 true,
	"icicibank.com":              true,
	"telegraph.co.uk":            true,
	"google.at":                  true,
	"google.se":                  true,
	"people.com.cn":              true,
	"zhihu.com":                  true,
	"skype.com":                  true,
	"mama.cn":                    true,
	"mercadolivre.com.br":        true,
	"mediafire.com":              true,
	"akamaihd.net":               true,
	"gfycat.com":                 true,
	"huanqiu.com":                true,
	"office.com":                 true,
	"pandora.com":                true,
	"ci123.com":                  true,
	"hdfcbank.com":               true,
	"jabong.com":                 true,
	"engadget.com":               true,
	"wp.pl":                      true,
	"target.com":                 true,
	"xuite.net":                  true,
	"bilibili.com":               true,
	"hootsuite.com":              true,
	"avg.com":                    true,
	"amazon.es":                  true,
	"google.pt":                  true,
	"wix.com":                    true,
	"youm7.com":                  true,
	"hulu.com":                   true,
	"ign.com":                    true,
	"wsj.com":                    true,
	"iqiyi.com":                  true,
	"39.net":                     true,
	"goodreads.com":              true,
	"groupon.com":                true,
	"rediff.com":                 true,
	"tianya.cn":                  true,
	"hurriyet.com.tr":            true,
	"media.tumblr.com":           true,
	"slickdeals.net":             true,
	"bild.de":                    true,
	"bomb01.com":                 true,
	"accuweather.com":            true,
	"google.com.ar":              true,
	"wordreference.com":          true,
	"bleacherreport.com":         true,
	"spiegel.de":                 true,
	"warmportrait.com":           true,
	"t-online.de":                true,
	"webmd.com":                  true,
	"hupu.com":                   true,
	"github.io":                  true,
	"usatoday.com":               true,
	"google.ch":                  true,
	"fiverr.com":                 true,
	"bloomberg.com":              true,
	"haosou.com":                 true,
	"google.com.ng":              true,
	"fedex.com":                  true,
	"lifehacker.com":             true,
	"seznam.cz":                  true,
	"addthis.com":                true,
	"trello.com":                 true,
	"badoo.com":                  true,
	"gameforge.com":              true,
	"starsports.com":             true,
	"taboola.com":                true,
	"steamcommunity.com":         true,
	"babytree.com":               true,
	"wow.com":                    true,
	"steampowered.com":           true,
	"kickstarter.com":            true,
	"likes.com":                  true,
	"zendesk.com":                true,
	"hp.com":                     true,
	"milliyet.com.tr":            true,
	"techcrunch.com":             true,
	"homedepot.com":              true,
	"lady8844.com":               true,
	"dell.com":                   true,
	"newegg.com":                 true,
	"moz.com":                    true,
	"stamplive.com":              true,
	"softonic.com":               true,
	"amazon.ca":                  true,
	"spotify.com":                true,
	"google.no":                  true,
	"google.com.bd":              true,
	"gsmarena.com":               true,
	"evernote.com":               true,
	"gizmodo.com":                true,
	"kompas.com":                 true,
	"meetup.com":                 true,
	"samsung.com":                true,
	"ce.cn":                      true,
	"capitalone.com":             true,
	"speedtest.net":              true,
	"extratorrent.cc":            true,
	"reuters.com":                true,
	"theverge.com":               true,
	"codecanyon.net":             true,
	"photobucket.com":            true,
	"tube8.com":                  true,
	"detik.com":                  true,
	"teepr.com":                  true,
	"mobile01.com":               true,
	"google.ae":                  true,
	"ebay.in":                    true,
	"udn.com":                    true,
	"libero.it":                  true,
	"googleapis.com":             true,
	"bitly.com":                  true,
	"whatsapp.com":               true,
	"disqus.com":                 true,
	"hudong.com":                 true,
	"varzesh3.com":               true,
	"google.cz":                  true,
	"ameba.jp":                   true,
	"google.co.hu":               true,
	"answers.com":                true,
	"ganji.com":                  true,
	"ask.fm":                     true,
	"google.com.pe":              true,
	"thefreedictionary.com":      true,
	"chinatimes.com":             true,
	"justdial.com":               true,
	"google.ie":                  true,
	"time.com":                   true,
	"2ch.net":                    true,
	"clickyab.com":               true,
	"eksisozluk.com":             true,
	"webssearches.com":           true,
	"sahibinden.com":             true,
	"autohome.com.cn":            true,
	"google.co.il":               true,
	"tistory.com":                true,
	"surveymonkey.com":           true,
	"oracle.com":                 true,
	"doublepimp.com":             true,
	"popcash.net":                true,
	"cricbuzz.com":               true,
	"b5m.com":                    true,
	"wired.com":                  true,
	"twimg.com":                  true,
	"kouclo.com":                 true,
	"paytm.com":                  true,
	"olx.in":                     true,
	"naukri.com":                 true,
	"enet.com.cn":                true,
	"wunderground.com":           true,
	"onlinesbi.com":              true,
	"expedia.com":                true,
	"google.com.vn":              true,
	"att.com":                    true,
	"xywy.com":                   true,
	"reimageplus.com":            true,
	"tmz.com":                    true,
	"taleo.net":                  true,
	"verizonwireless.com":        true,
	"irs.gov":                    true,
	"scribd.com":                 true,
	"drseks.com":                 true,
	"blog.jp":                    true,
	"okcupid.com":                true,
	"google.com.sa":              true,
	"xda-developers.com":         true,
	"tlbb8.com":                  true,
	"abs-cbnnews.com":            true,
	"repubblica.it":              true,
	"abril.com.br":               true,
	"ebay.com.au":                true,
	"theadgateway.com":           true,
	"free.fr":                    true,
	"odesk.com":                  true,
	"ebay.it":                    true,
	"list-manage.com":            true,
	"battle.net":                 true,
	"nba.com":                    true,
	"glassdoor.com":              true,
	"retailmenot.com":            true,
	"uploaded.net":               true,
	"58.com":                     true,
	"kaskus.co.id":               true,
	"citibank.com":               true,
	"cloudfront.net":             true,
	"yandex.ua":                  true,
	"gmarket.co.kr":              true,
	"kayak.com":                  true,
	"trackingclick.net":          true,
	"hostgator.com":              true,
	"privatehomeclips.com":       true,
	"vipcpms.com":                true,
	"livedoor.biz":               true,
	"trulia.com":                 true,
	"it168.com":                  true,
	"npr.org":                    true,
	"macys.com":                  true,
	"ltn.com.tw":                 true,
	"icloud.com":                 true,
	"goal.com":                   true,
	"marca.com":                  true,
	"jqw.com":                    true,
	"asana.com":                  true,
	"woot.com":                   true,
	"mobile.de":                  true,
	"intoday.in":                 true,
	"youboy.com":                 true,
	"4shared.com":                true,
	"williamhill.com":            true,
	"wetransfer.com":             true,
	"myntra.com":                 true,
	"fanli.com":                  true,
	"zoho.com":                   true,
	"styletv.com.cn":             true,
	"clien.net":                  true,
	"infusionsoft.com":           true,
	"elance.com":                 true,
	"php.net":                    true,
	"eyny.com":                   true,
	"icc-cricket.com":            true,
	"constantcontact.com":        true,
	"fbcdn.net":                  true,
	"google.fi":                  true,
	"cnzz.com":                   true,
	"ck101.com":                  true,
	"corriere.it":                true,
	"issuu.com":                  true,
	"urbandictionary.com":        true,
	"ink361.com":                 true,
	"liputan6.com":               true,
	"17ok.com":                   true,
	"google.sk":                  true,
	"bhaskar.com":                true,
	"xe.com":                     true,
	"hotels.com":                 true,
	"java.com":                   true,
	"gawker.com":                 true,
	"nbcnews.com":                true,
	"google.com.my":              true,
	"elpais.com":                 true,
	"chaturbate.com":             true,
	"nyaa.se":                    true,
	"stockstar.com":              true,
	"lazada.co.id":               true,
	"nordstrom.com":              true,
	"rambler.ru":                 true,
	"shopclues.com":              true,
	"blogimg.jp":                 true,
	"abcnews.go.com":             true,
	"rutracker.org":              true,
	"gap.com":                    true,
	"slack.com":                  true,
	"domaintools.com":            true,
	"eventbrite.com":             true,
	"sex.com":                    true,
	"fh21.com.cn":                true,
	"slate.com":                  true,
	"6pm.com":                    true,
	"goo.gl":                     true,
	"tabelog.com":                true,
	"asos.com":                   true,
	"squarespace.com":            true,
	"moneycontrol.com":           true,
	"rottentomatoes.com":         true,
	"google.dk":                  true,
	"houzz.com":                  true,
	"irctc.co.in":                true,
	"statcounter.com":            true,
	"eonline.com":                true,
	"independent.co.uk":          true,
	"azlyrics.com":               true,
	"onlylady.com":               true,
	"hatena.ne.jp":               true,
	"doubleclick.com":            true,
	"zippyshare.com":             true,
	"latimes.com":                true,
	"kijiji.ca":                  true,
	"seesaa.net":                 true,
	"ehow.com":                   true,
	"xunlei.com":                 true,
	"jrj.com.cn":                 true,
	"exoclick.com":               true,
	"mackeeper.com":              true,
	"impress.co.jp":              true,
	"rednet.cn":                  true,
	"aparat.com":                 true,
	"gazeta.pl":                  true,
	"aweber.com":                 true,
	"southwest.com":              true,
	"in.com":                     true,
	"hstpnetwork.com":            true,
	"timeanddate.com":            true,
	"gamefaqs.com":               true,
	"chinaz.com":                 true,
	"wikiwiki.jp":                true,
	"rt.com":                     true,
	"lenovo.com":                 true,
	"onedio.com":                 true,
	"voc.com.cn":                 true,
	"shopify.com":                true,
	"mega.co.nz":                 true,
	"olx.pl":                     true,
	"ewt.cc":                     true,
	"youdao.com":                 true,
	"nydailynews.com":            true,
	"realtor.com":                true,
	"workercn.cn":                true,
	"elmundo.es":                 true,
	"ca.gov":                     true,
	"ero-advertising.com":        true,
	"liveinternet.ru":            true,
	"etao.com":                   true,
	"eastday.com":                true,
	"beeg.com":                   true,
	"semrush.com":                true,
	"albawabhnews.com":           true,
	"donga.com":                  true,
	"nike.com":                   true,
	"omiga-plus.com":             true,
	"airtel.in":                  true,
	"vnexpress.net":              true,
	"airbnb.com":                 true,
	"chip.de":                    true,
	"avito.ru":                   true,
	"goodgamestudios.com":        true,
	"hubspot.com":                true,
	"pof.com":                    true,
	"blogspot.jp":                true,
	"priceline.com":              true,
	"csdn.net":                   true,
	"webtretho.com":              true,
	"kohls.com":                  true,
	"ptt01.cc":                   true,
	"ig.com.br":                  true,
	"neobux.com":                 true,
	"overstock.com":              true,
	"jmpdirect01.com":            true,
	"entrepreneur.com":           true,
	"basecamp.com":               true,
	"verizon.com":                true,
	"pcgames.com.cn":             true,
	"kdnet.net":                  true,
	"allrecipes.com":             true,
	"streamcloud.eu":             true,
	"haber7.com":                 true,
	"eastmoney.com":              true,
	"finstorieslive.com":         true,
	"blog.me":                    true,
	"kotaku.com":                 true,
	"mi.com":                     true,
	"subito.it":                  true,
	"udemy.com":                  true,
	"renren.com":                 true,
	"truemediapipe.com":          true,
	"adplxmd.com":                true,
	"mixi.jp":                    true,
	"discovercard.com":           true,
	"people.com":                 true,
	"fidelity.com":               true,
	"hm.com":                     true,
	"box.com":                    true,
	"ancestry.com":               true,
	"bodybuilding.com":           true,
	"vine.co":                    true,
	"nifty.com":                  true,
	"chron.com":                  true,
	"elwatannews.com":            true,
	"drudgereport.com":           true,
	"315che.com":                 true,
	"staticwebdom.com":           true,
	"instructables.com":          true,
	"livescore.com":              true,
	"ebay.fr":                    true,
	"blackboard.com":             true,
	"interia.pl":                 true,
	"4399.com":                   true,
	"soku.com":                   true,
	"jimdo.com":                  true,
	"shaadi.com":                 true,
	"zing.vn":                    true,
	"liveleak.com":               true,
	"japanpost.jp":               true,
	"v1.cn":                      true,
	"dianping.com":               true,
	"appledaily.com.tw":          true,
	"rbc.ru":                     true,
	"digikala.com":               true,
	"ticketmaster.com":           true,
	"atwiki.jp":                  true,
	"staples.com":                true,
	"11st.co.kr":                 true,
	"nownews.com":                true,
	"folha.uol.com.br":           true,
	"lowes.com":                  true,
	"bluehost.com":               true,
	"histats.com":                true,
	"cracked.com":                true,
	"so-net.ne.jp":               true,
	"behance.net":                true,
	"agoda.com":                  true,
	"digg.com":                   true,
	"medium.com":                 true,
	"zulily.com":                 true,
	"wiktionary.org":             true,
	"m-w.com":                    true,
	"mynavi.jp":                  true,
	"sakura.ne.jp":               true,
	"siteadvisor.com":            true,
	"youjizz.com":                true,
	"rvfrm2007.com":              true,
	"pcmag.com":                  true,
	"cbslocal.com":               true,
	"google.co.nz":               true,
	"youtube-mp3.org":            true,
	"marketwatch.com":            true,
	"united.com":                 true,
	"scoop.it":                   true,
	"ad6media.fr":                true,
	"makemytrip.com":             true,
	"costco.com":                 true,
	"mystartsearch.com":          true,
	"faithtap.com":               true,
	"myfitnesspal.com":           true,
	"ero-video.net":              true,
	"mirror.co.uk":               true,
	"bhphotovideo.com":           true,
	"io9.com":                    true,
	"gutefrage.net":              true,
	"foodnetwork.com":            true,
	"lefigaro.fr":                true,
	"freepik.com":                true,
	"yoka.com":                   true,
	"pinimg.com":                 true,
	"primewire.ag":               true,
	"qianlong.com":               true,
	"weather.gov":                true,
	"biglobe.ne.jp":              true,
	"4chan.org":                  true,
	"cookpad.com":                true,
	"cnbc.com":                   true,
	"lemonde.fr":                 true,
	"torcache.net":               true,
	"disney.go.com":              true,
	"el-balad.com":               true,
	"duckduckgo.com":             true,
	"custhelp.com":               true,
	"mlb.com":                    true,
	"mihanblog.com":              true,
	"terra.com.br":               true,
	"nhl.com":                    true,
	"mint.com":                   true,
	"india.com":                  true,
	"academia.edu":               true,
	"trovi.com":                  true,
	"backpage.com":               true,
	"sears.com":                  true,
	"adp.com":                    true,
	"slimspots.com":              true,
	"r10.net":                    true,
	"prntscr.com":                true,
	"lightinthebox.com":          true,
	"buzzfil.net":                true,
	"mackolik.com":               true,
	"patch.com":                  true,
	"asus.com":                   true,
	"ashleyrnadison.com":         true,
	"news.com.au":                true,
	"sulekha.com":                true,
	"comcast.com":                true,
	"vetogate.com":               true,
	"totaladperformance.com":     true,
	"letv.com":                   true,
	"delta.com":                  true,
	"coursera.org":               true,
	"swagbucks.com":              true,
	"babycenter.com":             true,
	"stanford.edu":               true,
	"milanuncios.com":            true,
	"elfagr.org":                 true,
	"tinyurl.com":                true,
	"hdzog.com":                  true,
	"cbssports.com":              true,
	"rapidgator.net":             true,
	"thehindu.com":               true,
	"billdesk.com":               true,
	"atlassian.net":              true,
	"ted.com":                    true,
	"usmagazine.com":             true,
	"subscene.com":               true,
	"nfl.com":                    true,
	"ruten.com.tw":               true,
	"imobile.com.cn":             true,
	"instructure.com":            true,
	"plarium.com":                true,
	"free-tv-video-online.me":    true,
	"ibm.com":                    true,
	"bestadbid.com":              true,
	"e-hentai.org":               true,
	"android.com":                true,
	"playstation.com":            true,
	"auction.co.kr":              true,
	"nypost.com":                 true,
	"weblio.jp":                  true,
	"virgilio.it":                true,
	"yts.re":                     true,
	"adsrvmedia.net":             true,
	"webex.com":                  true,
	"putlocker.is":               true,
	"anitube.se":                 true,
	"mit.edu":                    true,
	"saramin.co.kr":              true,
	"savefrom.net":               true,
	"clicksvenue.com":            true,
	"4dsply.com":                 true,
	"sfgate.com":                 true,
	"nikkei.com":                 true,
	"xing.com":                   true,
	"change.org":                 true,
	"google.rs":                  true,
	"21cn.com":                   true,
	"theatlantic.com":            true,
	"focus.de":                   true,
	"nate.com":                   true,
	"match.com":                  true,
	"rightmove.co.uk":            true,
	"itmedia.co.jp":              true,
	"reverso.net":                true,
	"zappos.com":                 true,
	"elmawke3.com":               true,
	"commentcamarche.net":        true,
	"filehippo.com":              true,
	"shareasale.com":             true,
	"xbox.com":                   true,
	"pchome.com.tw":              true,
	"www.gov.uk":                 true,
	"mynet.com":                  true,
	"sh.st":                      true,
	"novinky.cz":                 true,
	"ad4game.com":                true,
	"k618.cn":                    true,
	"eenadu.net":                 true,
	"sbnation.com":               true,
	"exblog.jp":                  true,
	"gyazo.com":                  true,
	"w3.org":                     true,
	"momoshop.com.tw":            true,
	"jia.com":                    true,
	"lenta.ru":                   true,
	"deadspin.com":               true,
	"pch.com":                    true,
	"asahi.com":                  true,
	"acfun.tv":                   true,
	"leagueoflegends.com":        true,
	"nbcsports.com":              true,
	"livestrong.com":             true,
	"indianexpress.com":          true,
	"sahadan.com":                true,
	"facenama.com":               true,
	"sciencedirect.com":          true,
	"altervista.org":             true,
	"yhd.com":                    true,
	"sfr.fr":                     true,
	"blogspot.de":                true,
	"tomshardware.com":           true,
	"blogspot.com.tr":            true,
	"usaa.com":                   true,
	"pagesjaunes.fr":             true,
	"wav.tv":                     true,
	"cbsnews.com":                true,
	"westernjournalism.com":      true,
	"superuser.com":              true,
	"media-fire.org":             true,
	"inclk.com":                  true,
	"investopedia.com":           true,
	"europa.eu":                  true,
	"ad132m.com":                 true,
	"aa.com":                     true,
	"qingdaonews.com":            true,
	"what-character-are-you.com": true,
	"twoo.com":                   true,
	"suning.com":                 true,
	"immobilienscout24.de":       true,
	"olx.com.br":                 true,
	"monster.com":                true,
	"quizlet.com":                true,
	"tutorialspoint.com":         true,
	"oyunskor.com":               true,
	"douyutv.com":                true,
	"slrclub.com":                true,
	"mayoclinic.org":             true,
	"gamespot.com":               true,
	"usbank.com":                 true,
	"sky.com":                    true,
	"bukalapak.com":              true,
	"firstpost.com":              true,
	"almasryalyoum.com":          true,
	"cdiscount.com":              true,
	"thedailybeast.com":          true,
	"cisco.com":                  true,
	"itau.com.br":                true,
	"taringa.net":                true,
	"scoopwhoop.com":             true,
	"typepad.com":                true,
	"epweike.com":                true,
	"126.com":                    true,
	"cnblogs.com":                true,
	"istockphoto.com":            true,
	"dreamstime.com":             true,
	"bloglovin.com":              true,
	"cnmo.com":                   true,
	"junbi-tracker.com":          true,
	"s2d6.com":                   true,
	"ebates.com":                 true,
	"viralnova.com":              true,
	"hollywoodreporter.com":      true,
	"roblox.com":                 true,
	"gamepedia.com":              true,
	"freelancer.com":             true,
	"movie4k.to":                 true,
	"blogspot.ca":                true,
	"myfreecams.com":             true,
	"huaban.com":                 true,
	"t-mobile.com":               true,
	"lequipe.fr":                 true,
	"abplive.in":                 true,
	"warriorforum.com":           true,
	"farsnews.com":               true,
	"informer.com":               true,
	"olx.ua":                     true,
	"ccb.com":                    true,
	"114la.com":                  true,
	"geocities.jp":               true,
	"chexun.com":                 true,
	"google.hr":                  true,
	"who.is":                     true,
	"gittigidiyor.com":           true,
	"web.tv":                     true,
	"indiamart.com":              true,
	"sapo.pt":                    true,
	"elitedaily.com":             true,
	"rollingstone.com":           true,
	"dafont.com":                 true,
	"zomato.com":                 true,
	"masrawy.com":                true,
	"smh.com.au":                 true,
	"flirchi.com":                true,
	"coupons.com":                true,
	"searchengineland.com":       true,
	"gumtree.com":                true,
	"howtogeek.com":              true,
	"envato.com":                 true,
	"gamer.com.tw":               true,
	"iflscience.com":             true,
	"bufferapp.com":              true,
	"allocine.fr":                true,
	"jumia.com.ng":               true,
	"cbc.ca":                     true,
	"ew.com":                     true,
	"nhk.or.jp":                  true,
	"tagged.com":                 true,
	"prothom-alo.com":            true,
	"rakuten.ne.jp":              true,
	"techradar.com":              true,
	"motherless.com":             true,
	"fitbit.com":                 true,
	"12306.cn":                   true,
	"bookmyshow.com":             true,
	"trklnks.com":                true,
	"hubpages.com":               true,
	"ultimate-guitar.com":        true,
	"tokopedia.com":              true,
	"citrixonline.com":           true,
	"pbs.org":                    true,
	"104.com.tw":                 true,
	"yellowpages.com":            true,
	"189.cn":                     true,
	"dangdang.com":               true,
	"liveperson.net":             true,
	"internethaber.com":          true,
	"himado.in":                  true,
	"yandex.com.tr":              true,
	"makeuseof.com":              true,
	"yodobashi.com":              true,
	"arstechnica.com":            true,
	"adultfriendfinder.com":      true,
	"gazzetta.it":                true,
	"nationalgeographic.com":     true,
	"apache.org":                 true,
	"miniinthebox.com":           true,
	"lotour.com":                 true,
	"ad120m.com":                 true,
	"google.com.ph":              true,
	"popsugar.com":               true,
	"harvard.edu":                true,
	"vi-view.com":                true,
	"viva.co.id":                 true,
	"redfin.com":                 true,
	"ytimg.com":                  true,
	"tutsplus.com":               true,
	"sporx.com":                  true,
	"androidcentral.com":         true,
	"tahrirnews.com":             true,
	"marriott.com":               true,
	"mpnrs.com":                  true,
	"getpocket.com":              true,
	"olx.co.id":                  true,
	"indianrail.gov.in":          true,
	"ixxx.com":                   true,
	"merdeka.com":                true,
	"caixa.gov.br":               true,
	"mediaset.it":                true,
	"jezebel.com":                true,
	"ukr.net":                    true,
	"donanimhaber.com":           true,
	"leadpages.net":              true,
	"tsite.jp":                   true,
	"food.com":                   true,
	"worldstarhiphop.com":        true,
	"google.co.th":               true,
	"hilton.com":                 true,
	"inc.com":                    true,
	"ed.gov":                     true,
	"ucoz.ru":                    true,
	"tnaflix.com":                true,
	"drtuber.com":                true,
	"filmon.com":                 true,
	"dict.cc":                    true,
	"ringring.vn":                true,
	"foursquare.com":             true,
	"vox.com":                    true,
	"wiley.com":                  true,
	"2345.com":                   true,
	"gofundme.com":               true,
	"nasa.gov":                   true,
	"thekitchn.com":              true,
	"porn.com":                   true,
	"zara.com":                   true,
	"cbs.com":                    true,
	"2chblog.jp":                 true,
	"marktplaats.nl":             true,
	"salon.com":                  true,
	"22find.com":                 true,
	"battlefield.com":            true,
	"thenextweb.com":             true,
	"jagran.com":                 true,
	"kinopoisk.ru":               true,
	"123rf.com":                  true,
	"persianblog.ir":             true,
	"intel.com":                  true,
	"hindustantimes.com":         true,
}
