package com.bumptech.glide.signature;

import static org.junit.Assert.assertNotNull;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.tests.KeyAssertions;

import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.Robolectric;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.annotation.Config;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

@RunWith(RobolectricTestRunner.class)
@Config(manifest = Config.NONE, emulateSdk = 18)
public class ApplicationVersionSignatureTest {

    @After
    public void tearDown() {
        ApplicationVersionSignature.reset();
    }

    @Test
    public void testCanGetKeyForSignature() {
        Key key = ApplicationVersionSignature.obtain(Robolectric.application);
        assertNotNull(key);
    }

    @Test
    public void testKeyForSignatureIsTheSameAcrossCallsInTheSamePackage() throws NoSuchAlgorithmException,
            UnsupportedEncodingException {
        Key first = ApplicationVersionSignature.obtain(Robolectric.application);
        Key second = ApplicationVersionSignature.obtain(Robolectric.application);
        KeyAssertions.assertSame(first, second);
    }
}