export const BotIcon = () => {
  return (
    <svg
      height="16"
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width="16"
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.75 2.79933C9.19835 2.53997 9.5 2.05521 9.5 1.5C9.5 0.671573 8.82843 0 8 0C7.17157 0 6.5 0.671573 6.5 1.5C6.5 2.05521 6.80165 2.53997 7.25 2.79933V5H7C4.027 5 1.55904 7.16229 1.08296 10H0V13H1V14.5V16H2.5H13.5H15V14.5V13H16V10H14.917C14.441 7.16229 11.973 5 9 5H8.75V2.79933ZM7 6.5C4.51472 6.5 2.5 8.51472 2.5 11V14.5H13.5V11C13.5 8.51472 11.4853 6.5 9 6.5H7ZM7.25 11.25C7.25 12.2165 6.4665 13 5.5 13C4.5335 13 3.75 12.2165 3.75 11.25C3.75 10.2835 4.5335 9.5 5.5 9.5C6.4665 9.5 7.25 10.2835 7.25 11.25ZM10.5 13C11.4665 13 12.25 12.2165 12.25 11.25C12.25 10.2835 11.4665 9.5 10.5 9.5C9.5335 9.5 8.75 10.2835 8.75 11.25C8.75 12.2165 9.5335 13 10.5 13Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const UserIcon = () => {
  return (
    <svg
      data-testid="geist-icon"
      height="16"
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width="16"
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.75 0C5.95507 0 4.5 1.45507 4.5 3.25V3.75C4.5 5.54493 5.95507 7 7.75 7H8.25C10.0449 7 11.5 5.54493 11.5 3.75V3.25C11.5 1.45507 10.0449 0 8.25 0H7.75ZM6 3.25C6 2.2835 6.7835 1.5 7.75 1.5H8.25C9.2165 1.5 10 2.2835 10 3.25V3.75C10 4.7165 9.2165 5.5 8.25 5.5H7.75C6.7835 5.5 6 4.7165 6 3.75V3.25ZM2.5 14.5V13.1709C3.31958 11.5377 4.99308 10.5 6.82945 10.5H9.17055C11.0069 10.5 12.6804 11.5377 13.5 13.1709V14.5H2.5ZM6.82945 9C4.35483 9 2.10604 10.4388 1.06903 12.6857L1 12.8353V13V15.25V16H1.75H14.25H15V15.25V13V12.8353L14.931 12.6857C13.894 10.4388 11.6452 9 9.17055 9H6.82945Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const AttachmentIcon = () => {
  return (
    <svg
      height="16"
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width="16"
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M14.5 6.5V13.5C14.5 14.8807 13.3807 16 12 16H4C2.61929 16 1.5 14.8807 1.5 13.5V1.5V0H3H8H9.08579C9.351 0 9.60536 0.105357 9.79289 0.292893L14.2071 4.70711C14.3946 4.89464 14.5 5.149 14.5 5.41421V6.5ZM13 6.5V13.5C13 14.0523 12.5523 14.5 12 14.5H4C3.44772 14.5 3 14.0523 3 13.5V1.5H8V5V6.5H9.5H13ZM9.5 2.12132V5H12.3787L9.5 2.12132Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const VercelIcon = ({ size = 17 }) => {
  return (
    <svg
      height={size}
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width={size}
      style={{ color: 'currentcolor' }}
    >
      <path fillRule="evenodd" clipRule="evenodd" d="M8 1L16 15H0L8 1Z" fill="currentColor"></path>
    </svg>
  );
};

export const MasonryIcon = () => {
  return (
    <svg
      height="16"
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width="16"
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.5 6.5V2.5H5.5V6.5H2.5ZM1 2C1 1.44772 1.44772 1 2 1H6C6.55228 1 7 1.44772 7 2V7C7 7.55228 6.55228 8 6 8H2C1.44772 8 1 7.55228 1 7V2ZM2.5 13.5V11.5H5.5V13.5H2.5ZM1 11C1 10.4477 1.44772 10 2 10H6C6.55228 10 7 10.4477 7 11V14C7 14.5523 6.55228 15 6 15H2C1.44772 15 1 14.5523 1 14V11ZM10.5 2.5V4.5H13.5V2.5H10.5ZM10 1C9.44772 1 9 1.44772 9 2V5C9 5.55228 9.44772 6 10 6H14C14.5523 6 15 5.55228 15 5V2C15 1.44772 14.5523 1 14 1H10ZM13.5 13.5H10.5V9.5H13.5V13.5ZM9 9C9 8.44772 9.44772 8 10 8H14C14.5523 8 15 8.44772 15 9V14C15 14.5523 14.5523 15 14 15H10C9.44772 15 9 14.5523 9 14V9Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const GitIcon = () => {
  return (
    <svg
      height="16"
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width="16"
      style={{ color: 'currentcolor' }}
    >
      <g clipPath="url(#clip0_872_3147)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 0C3.58 0 0 3.57879 0 7.99729C0 11.5361 2.29 14.5251 5.47 15.5847C5.87 15.6547 6.02 15.4148 6.02 15.2049C6.02 15.0149 6.01 14.3851 6.01 13.7154C4 14.0852 3.48 13.2255 3.32 12.7757C3.23 12.5458 2.84 11.836 2.5 11.6461C2.22 11.4961 1.82 11.1262 2.49 11.1162C3.12 11.1062 3.57 11.696 3.72 11.936C4.44 13.1455 5.59 12.8057 6.05 12.5957C6.12 12.0759 6.33 11.726 6.56 11.5261C4.78 11.3262 2.92 10.6364 2.92 7.57743C2.92 6.70773 3.23 5.98797 3.74 5.42816C3.66 5.22823 3.38 4.40851 3.82 3.30888C3.82 3.30888 4.49 3.09895 6.02 4.1286C6.66 3.94866 7.34 3.85869 8.02 3.85869C8.7 3.85869 9.38 3.94866 10.02 4.1286C11.55 3.08895 12.22 3.30888 12.22 3.30888C12.66 4.40851 12.38 5.22823 12.3 5.42816C12.81 5.98797 13.12 6.69773 13.12 7.57743C13.12 10.6464 11.25 11.3262 9.47 11.5261C9.76 11.776 10.01 12.2558 10.01 13.0056C10.01 14.0752 10 14.9349 10 15.2049C10 15.4148 10.15 15.6647 10.55 15.5847C12.1381 15.0488 13.5182 14.0284 14.4958 12.6673C15.4735 11.3062 15.9996 9.67293 16 7.99729C16 3.57879 12.42 0 8 0Z"
          fill="currentColor"
        ></path>
      </g>
      <defs>
        <clipPath id="clip0_872_3147">
          <rect width="16" height="16" fill="white"></rect>
        </clipPath>
      </defs>
    </svg>
  );
};

export const BoxIcon = ({ size = 16 }: { size: number }) => {
  return (
    <svg
      height={size}
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width={size}
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8 0.154663L8.34601 0.334591L14.596 3.58459L15 3.79466V4.25V11.75V12.2053L14.596 12.4154L8.34601 15.6654L8 15.8453L7.65399 15.6654L1.40399 12.4154L1 12.2053V11.75V4.25V3.79466L1.40399 3.58459L7.65399 0.334591L8 0.154663ZM2.5 11.2947V5.44058L7.25 7.81559V13.7647L2.5 11.2947ZM8.75 13.7647L13.5 11.2947V5.44056L8.75 7.81556V13.7647ZM8 1.84534L12.5766 4.22519L7.99998 6.51352L3.42335 4.2252L8 1.84534Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const HomeIcon = ({ size = 16 }: { size: number }) => {
  return (
    <svg
      height={size}
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width={size}
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.5 6.56062L8.00001 2.06062L3.50001 6.56062V13.5L6.00001 13.5V11C6.00001 9.89539 6.89544 8.99996 8.00001 8.99996C9.10458 8.99996 10 9.89539 10 11V13.5L12.5 13.5V6.56062ZM13.78 5.71933L8.70711 0.646409C8.31659 0.255886 7.68342 0.255883 7.2929 0.646409L2.21987 5.71944C2.21974 5.71957 2.21961 5.7197 2.21949 5.71982L0.469676 7.46963L-0.0606537 7.99996L1.00001 9.06062L1.53034 8.53029L2.00001 8.06062V14.25V15H2.75001L6.00001 15H7.50001H8.50001H10L13.25 15H14V14.25V8.06062L14.4697 8.53029L15 9.06062L16.0607 7.99996L15.5303 7.46963L13.7806 5.71993C13.7804 5.71973 13.7802 5.71953 13.78 5.71933ZM8.50001 11V13.5H7.50001V11C7.50001 10.7238 7.72386 10.5 8.00001 10.5C8.27615 10.5 8.50001 10.7238 8.50001 11Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const GPSIcon = ({ size = 16 }: { size: number }) => {
  return (
    <svg
      height={size}
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width={size}
      style={{ color: 'currentcolor' }}
    >
      <path
        d="M1 6L15 1L10 15L7.65955 8.91482C7.55797 8.65073 7.34927 8.44203 7.08518 8.34045L1 6Z"
        stroke="currentColor"
        strokeWidth="1.5"
        strokeLinecap="round"
        strokeLinejoin="bevel"
        fill="transparent"
      ></path>
    </svg>
  );
};

export const InvoiceIcon = ({ size = 16 }: { size: number }) => {
  return (
    <svg
      height={size}
      strokeLinejoin="round"
      viewBox="0 0 16 16"
      width={size}
      style={{ color: 'currentcolor' }}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13 15.1L12 14.5L10.1524 15.8857C10.0621 15.9534 9.93791 15.9534 9.8476 15.8857L8 14.5L6.14377 15.8922C6.05761 15.9568 5.94008 15.9601 5.85047 15.9003L3.75 14.5L3 15L2.83257 15.1116L1.83633 15.7758L1.68656 15.8756C1.60682 15.9288 1.5 15.8716 1.5 15.7758V15.5958V14.3985V14.1972V1.5V0H3H8H9.08579C9.351 0 9.60536 0.105357 9.79289 0.292893L14.2071 4.70711C14.3946 4.89464 14.5 5.149 14.5 5.41421V6.5V14.2507V14.411V15.5881V15.7881C14.5 15.8813 14.3982 15.9389 14.3183 15.891L14.1468 15.7881L13.1375 15.1825L13 15.1ZM12.3787 5L9.5 2.12132V5H12.3787ZM8 1.5V5V6.5H9.5H13V13.3507L12.7717 13.2138L11.9069 12.6948L11.1 13.3L10 14.125L8.9 13.3L8 12.625L7.1 13.3L5.94902 14.1632L4.58205 13.2519L3.75 12.6972L3 13.1972V1.5H8Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const Bird = () => (
  <svg width="45" height="39" viewBox="0 0 45 39" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M26.4047 17.9373C27.3193 17.5522 28.3302 17.3596 29.293 17.6003C29.7791 17.7218 30.4615 18.1747 31.111 18.6057C31.748 19.0283 32.3532 19.43 32.7107 19.4777C33.0285 19.52 33.4581 19.4971 33.8805 19.4746C34.4182 19.446 34.9443 19.418 35.2139 19.5258C35.4268 19.611 35.6304 19.9223 35.8537 20.2638C36.1351 20.6942 36.4479 21.1727 36.8506 21.3069C37.0202 21.3634 37.2005 21.412 37.3721 21.4583C37.9307 21.6088 38.3967 21.7343 38.1021 22.0289C37.717 22.414 35.3583 22.6547 35.1176 22.5585C34.9949 22.5094 35.0098 22.3852 35.0284 22.2306C35.0463 22.082 35.0676 21.9053 34.9732 21.7401C34.8829 21.5821 34.708 21.3289 34.5426 21.0896C34.3554 20.8185 34.1804 20.5652 34.1549 20.4885C33.9623 20.3441 33.144 20.1997 33.144 20.3923C33.144 20.5848 33.3847 21.9808 33.5772 22.1734C33.6063 22.2024 33.6354 22.2304 33.6628 22.2568C33.8169 22.4051 33.9187 22.503 33.6735 22.4622C33.3847 22.414 31.748 21.7401 31.2185 21.2106C30.689 20.6811 29.9188 19.959 29.2448 19.959C28.871 19.959 27.9491 21.1144 27.0625 22.2255C26.3509 23.1174 25.662 23.9808 25.2976 24.1951C24.4792 24.6765 21.7835 25.7837 20.2431 25.8799C18.7027 25.9762 16.8254 25.9762 16.7772 25.4948C16.7291 25.0135 16.9217 24.5802 17.6437 24.6765C18.3658 24.7728 24.2867 23.6656 25.9234 21.9808C26.3025 21.5905 26.612 21.2802 26.8612 21.0304C27.6877 20.2016 27.8524 20.0365 27.7044 19.8146C27.6538 19.7386 27.5032 19.5927 27.3183 19.4135C26.8006 18.9119 26.0145 18.1501 26.4047 17.9373ZM34.8264 20.5249C34.8275 20.5419 34.8288 20.5615 34.8288 20.5848C34.8288 20.7292 34.8769 20.8255 35.0213 20.8736C35.1657 20.9218 35.262 20.7292 35.2139 20.5848C35.1657 20.4404 35.1176 20.296 35.0213 20.296C34.8195 20.4171 34.8207 20.4366 34.8264 20.5249Z"
      fill="#7F7F7F"
    />
    <path
      d="M25.8272 13.4604C26.5492 14.1343 25.8272 17.167 25.779 17.3595C25.5615 18.2298 24.0352 17.619 23.565 16.8551C23.3126 16.4449 23.1018 15.9636 23.0833 15.4822C23.0352 14.2306 22.3131 13.0272 22.1206 12.4495C21.928 11.8719 19.5212 10.9573 18.414 10.6684C17.3068 10.3796 17.1143 8.3097 17.2587 8.02087C17.4031 7.73205 21.4948 10.524 23.0833 11.2461C24.6719 11.9681 25.1051 12.7865 25.8272 13.4604Z"
      fill="#7F7F7F"
    />
    <path
      d="M16.5848 24.0024C16.2478 24.0024 16.0553 24.195 15.6702 24.8208C15.253 25.3824 14.3704 26.5441 14.1779 26.6981C13.9372 26.8907 13.7447 26.5056 13.0707 26.4575C12.3968 26.4093 11.771 27.5646 11.4822 27.9016C11.1934 28.2385 12.7819 28.3348 14.3704 27.5646C15.959 26.7944 16.8255 24.7245 16.9699 24.3875C17.1143 24.0506 16.9217 24.0024 16.5848 24.0024Z"
      fill="#7F7F7F"
    />
    <path
      d="M20.2432 12.3532C21.4948 12.8827 21.8317 13.6529 21.8799 14.8563C21.9912 17.6399 22.2769 20.3073 19.7272 21.4296C17.9018 22.2331 16.1005 22.9204 15.7664 23.0397C15.0925 23.2804 14.6593 23.5211 14.3704 23.9062C14.0816 24.2913 14.5149 24.3876 14.7555 24.7727C14.9962 25.1578 14.0816 25.6391 13.2151 25.591C12.3487 25.5429 11.1934 24.8208 11.1452 24.195C11.0971 23.5692 13.4558 22.9434 14.3704 22.7027C15.2851 22.4621 16.5848 21.1623 17.4031 20.8254C18.2214 20.4884 17.3068 20.681 17.0661 20.4403C16.8255 20.1996 16.6329 19.0924 16.5848 18.5629C16.5366 18.0334 15.959 17.1669 15.7664 16.9262C15.5739 16.6856 18.1733 16.83 18.2696 16.6374C18.3659 16.4449 16.5848 16.493 15.4295 16.3005C14.2742 16.1079 13.7928 15.3377 13.6484 15.097C13.504 14.8563 17.7401 15.5784 17.9808 15.3377C18.2214 15.097 16.1997 15.097 15.2369 14.9045C14.2742 14.7119 13.3114 14.5194 12.83 14.1824C12.3487 13.8455 11.9154 13.0271 12.3005 13.2197C12.6856 13.4122 17.4031 14.2787 17.7401 14.0861C18.077 13.8936 12.9263 12.7383 12.1561 12.4495C11.3859 12.1606 10.712 10.8128 10.6157 10.524C10.5194 10.2351 11.7229 11.1016 12.3005 11.2942L12.3005 11.2942C12.8782 11.4867 16.9217 12.8346 17.4031 12.7383C17.8845 12.642 13.3596 11.0535 12.0598 10.524C10.7601 9.99446 10.375 8.5022 10.2788 8.1171C10.1825 7.732 11.3859 8.55034 12.0598 8.98357C12.7338 9.41681 18.9916 11.8237 20.2432 12.3532Z"
      fill="#7F7F7F"
    />
  </svg>
);
