// This file is auto-generated by @hey-api/openapi-ts

export type ClientOptions = {
    baseUrl: `${string}://${string}` | (string & {});
};

export type AddExtensionRequest = {
    config: ExtensionConfig;
    session_id: string;
};

export type Annotations = {
    audience?: Array<Role>;
    lastModified?: string;
    priority?: number;
};

export type Author = {
    contact?: string | null;
    metadata?: string | null;
};

export type AuthorRequest = {
    contact?: string | null;
    metadata?: string | null;
};

export type ChatRequest = {
    messages: Array<Message>;
    recipe_name?: string | null;
    recipe_version?: string | null;
    session_id: string;
};

/**
 * Configuration key metadata for provider setup
 */
export type ConfigKey = {
    /**
     * Optional default value for the key
     */
    default?: string | null;
    /**
     * The name of the configuration key (e.g., "API_KEY")
     */
    name: string;
    /**
     * Whether this key should be configured using OAuth device code flow
     * When true, the provider's configure_oauth() method will be called instead of prompting for manual input
     */
    oauth_flow: boolean;
    /**
     * Whether this key is required for the provider to function
     */
    required: boolean;
    /**
     * Whether this key should be stored securely (e.g., in keychain)
     */
    secret: boolean;
};

export type ConfigKeyQuery = {
    is_secret: boolean;
    key: string;
};

export type ConfigResponse = {
    config: {
        [key: string]: unknown;
    };
};

export type Content = RawTextContent | RawImageContent | RawEmbeddedResource | RawAudioContent | RawResource;

export type Conversation = Array<Message>;

export type CreateRecipeRequest = {
    author?: AuthorRequest | null;
    session_id: string;
};

export type CreateRecipeResponse = {
    error?: string | null;
    recipe?: Recipe | null;
};

export type CreateScheduleRequest = {
    cron: string;
    execution_mode?: string | null;
    id: string;
    recipe_source: string;
};

export type DeclarativeProviderConfig = {
    api_key_env: string;
    base_url: string;
    description?: string | null;
    display_name: string;
    engine: ProviderEngine;
    headers?: {
        [key: string]: string;
    } | null;
    models: Array<ModelInfo>;
    name: string;
    supports_streaming?: boolean | null;
    timeout_seconds?: number | null;
};

export type DecodeRecipeRequest = {
    deeplink: string;
};

export type DecodeRecipeResponse = {
    recipe: Recipe;
};

export type DeleteRecipeRequest = {
    id: string;
};

export type EmbeddedResource = {
    _meta?: {
        [key: string]: unknown;
    };
    annotations?: Annotations | {
        [key: string]: unknown;
    };
    resource: ResourceContents;
};

export type EncodeRecipeRequest = {
    recipe: Recipe;
};

export type EncodeRecipeResponse = {
    deeplink: string;
};

export type Envs = {
    [key: string]: string;
};

export type ErrorResponse = {
    message: string;
};

/**
 * Represents the different types of MCP extensions that can be added to the manager
 */
export type ExtensionConfig = {
    available_tools?: Array<string>;
    bundled?: boolean | null;
    description: string;
    env_keys?: Array<string>;
    envs?: Envs;
    /**
     * The name used to identify this extension
     */
    name: string;
    timeout?: number | null;
    type: 'sse';
    uri: string;
} | {
    args: Array<string>;
    available_tools?: Array<string>;
    bundled?: boolean | null;
    cmd: string;
    description: string;
    env_keys?: Array<string>;
    envs?: Envs;
    /**
     * The name used to identify this extension
     */
    name: string;
    timeout?: number | null;
    type: 'stdio';
} | {
    available_tools?: Array<string>;
    bundled?: boolean | null;
    description: string;
    display_name?: string | null;
    /**
     * The name used to identify this extension
     */
    name: string;
    timeout?: number | null;
    type: 'builtin';
} | {
    available_tools?: Array<string>;
    bundled?: boolean | null;
    description: string;
    /**
     * The name used to identify this extension
     */
    name: string;
    type: 'platform';
} | {
    available_tools?: Array<string>;
    bundled?: boolean | null;
    description: string;
    env_keys?: Array<string>;
    envs?: Envs;
    headers?: {
        [key: string]: string;
    };
    /**
     * The name used to identify this extension
     */
    name: string;
    timeout?: number | null;
    type: 'streamable_http';
    uri: string;
} | {
    available_tools?: Array<string>;
    bundled?: boolean | null;
    description: string;
    /**
     * Instructions for how to use these tools
     */
    instructions?: string | null;
    /**
     * The name used to identify this extension
     */
    name: string;
    /**
     * The tools provided by the frontend
     */
    tools: Array<Tool>;
    type: 'frontend';
} | {
    available_tools?: Array<string>;
    /**
     * The Python code to execute
     */
    code: string;
    /**
     * Python package dependencies required by this extension
     */
    dependencies?: Array<string> | null;
    description: string;
    /**
     * The name used to identify this extension
     */
    name: string;
    /**
     * Timeout in seconds
     */
    timeout?: number | null;
    type: 'inline_python';
};

/**
 * Extension data containing all extension states
 * Keys are in format "extension_name.version" (e.g., "todo.v0")
 */
export type ExtensionData = {
    [key: string]: unknown;
};

export type ExtensionEntry = ExtensionConfig & {
    enabled: boolean;
};

export type ExtensionQuery = {
    config: ExtensionConfig;
    enabled: boolean;
    name: string;
};

export type ExtensionResponse = {
    extensions: Array<ExtensionEntry>;
};

export type FrontendToolRequest = {
    id: string;
    toolCall: {
        [key: string]: unknown;
    };
};

export type GetToolsQuery = {
    extension_name?: string | null;
    session_id: string;
};

export type Icon = {
    mimeType?: string;
    sizes?: Array<string>;
    src: string;
};

export type ImageContent = {
    _meta?: {
        [key: string]: unknown;
    };
    annotations?: Annotations | {
        [key: string]: unknown;
    };
    data: string;
    mimeType: string;
};

export type ImportSessionRequest = {
    json: string;
};

export type InspectJobResponse = {
    processStartTime?: string | null;
    runningDurationSeconds?: number | null;
    sessionId?: string | null;
};

export type JsonObject = {
    [key: string]: unknown;
};

export type KillJobResponse = {
    message: string;
};

export type ListRecipeResponse = {
    recipe_manifest_responses: Array<RecipeManifestResponse>;
};

export type ListSchedulesResponse = {
    jobs: Array<ScheduledJob>;
};

export type LoadedProvider = {
    config: DeclarativeProviderConfig;
    is_editable: boolean;
};

/**
 * A message to or from an LLM
 */
export type Message = {
    content: Array<MessageContent>;
    created: number;
    id?: string | null;
    metadata: MessageMetadata;
    role: Role;
};

/**
 * Content passed inside a message, which can be both simple content and tool content
 */
export type MessageContent = (TextContent & {
    type: 'text';
}) | (ImageContent & {
    type: 'image';
}) | (ToolRequest & {
    type: 'toolRequest';
}) | (ToolResponse & {
    type: 'toolResponse';
}) | (ToolConfirmationRequest & {
    type: 'toolConfirmationRequest';
}) | (FrontendToolRequest & {
    type: 'frontendToolRequest';
}) | (ThinkingContent & {
    type: 'thinking';
}) | (RedactedThinkingContent & {
    type: 'redactedThinking';
}) | (SystemNotificationContent & {
    type: 'systemNotification';
});

export type MessageEvent = {
    message: Message;
    token_state: TokenState;
    type: 'Message';
} | {
    error: string;
    type: 'Error';
} | {
    reason: string;
    token_state: TokenState;
    type: 'Finish';
} | {
    mode: string;
    model: string;
    type: 'ModelChange';
} | {
    message: {
        [key: string]: unknown;
    };
    request_id: string;
    type: 'Notification';
} | {
    conversation: Conversation;
    type: 'UpdateConversation';
} | {
    type: 'Ping';
};

/**
 * Metadata for message visibility
 */
export type MessageMetadata = {
    /**
     * Whether the message should be included in the agent's context window
     */
    agentVisible: boolean;
    /**
     * Whether the message should be visible to the user in the UI
     */
    userVisible: boolean;
};

/**
 * Information about a model's capabilities
 */
export type ModelInfo = {
    /**
     * The maximum context length this model supports
     */
    context_limit: number;
    /**
     * Currency for the costs (default: "$")
     */
    currency?: string | null;
    /**
     * Cost per token for input (optional)
     */
    input_token_cost?: number | null;
    /**
     * The name of the model
     */
    name: string;
    /**
     * Cost per token for output (optional)
     */
    output_token_cost?: number | null;
    /**
     * Whether this model supports cache control
     */
    supports_cache_control?: boolean | null;
};

export type ParseRecipeRequest = {
    content: string;
};

export type ParseRecipeResponse = {
    recipe: Recipe;
};

export type PermissionConfirmationRequest = {
    action: string;
    id: string;
    principal_type?: PrincipalType;
    session_id: string;
};

/**
 * Enum representing the possible permission levels for a tool.
 */
export type PermissionLevel = 'always_allow' | 'ask_before' | 'never_allow';

export type PrincipalType = 'Extension' | 'Tool';

export type ProviderDetails = {
    is_configured: boolean;
    metadata: ProviderMetadata;
    name: string;
    provider_type: ProviderType;
};

export type ProviderEngine = 'openai' | 'ollama' | 'anthropic';

/**
 * Metadata about a provider's configuration requirements and capabilities
 */
export type ProviderMetadata = {
    /**
     * Required configuration keys
     */
    config_keys: Array<ConfigKey>;
    /**
     * The default/recommended model for this provider
     */
    default_model: string;
    /**
     * Description of the provider's capabilities
     */
    description: string;
    /**
     * Display name for the provider in UIs
     */
    display_name: string;
    /**
     * A list of currently known models with their capabilities
     */
    known_models: Array<ModelInfo>;
    /**
     * Link to the docs where models can be found
     */
    model_doc_link: string;
    /**
     * The unique identifier for this provider
     */
    name: string;
};

export type ProviderType = 'Preferred' | 'Builtin' | 'Declarative' | 'Custom';

export type ProvidersResponse = {
    providers: Array<ProviderDetails>;
};

export type RawAudioContent = {
    data: string;
    mimeType: string;
};

export type RawEmbeddedResource = {
    _meta?: {
        [key: string]: unknown;
    };
    resource: ResourceContents;
};

export type RawImageContent = {
    _meta?: {
        [key: string]: unknown;
    };
    data: string;
    mimeType: string;
};

export type RawResource = {
    description?: string;
    icons?: Array<Icon>;
    mimeType?: string;
    name: string;
    size?: number;
    title?: string;
    uri: string;
};

export type RawTextContent = {
    _meta?: {
        [key: string]: unknown;
    };
    text: string;
};

export type Recipe = {
    activities?: Array<string> | null;
    author?: Author | null;
    context?: Array<string> | null;
    description: string;
    extensions?: Array<ExtensionConfig> | null;
    instructions?: string | null;
    parameters?: Array<RecipeParameter> | null;
    prompt?: string | null;
    response?: Response | null;
    retry?: RetryConfig | null;
    settings?: Settings | null;
    sub_recipes?: Array<SubRecipe> | null;
    title: string;
    version?: string;
};

export type RecipeManifestResponse = {
    id: string;
    lastModified: string;
    recipe: Recipe;
};

export type RecipeParameter = {
    default?: string | null;
    description: string;
    input_type: RecipeParameterInputType;
    key: string;
    options?: Array<string> | null;
    requirement: RecipeParameterRequirement;
};

export type RecipeParameterInputType = 'string' | 'number' | 'boolean' | 'date' | 'file' | 'select';

export type RecipeParameterRequirement = 'required' | 'optional' | 'user_prompt';

export type RedactedThinkingContent = {
    data: string;
};

export type RemoveExtensionRequest = {
    name: string;
    session_id: string;
};

export type ResourceContents = {
    _meta?: {
        [key: string]: unknown;
    };
    mimeType?: string;
    text: string;
    uri: string;
} | {
    _meta?: {
        [key: string]: unknown;
    };
    blob: string;
    mimeType?: string;
    uri: string;
};

export type Response = {
    json_schema?: unknown;
};

export type ResumeAgentRequest = {
    load_model_and_extensions: boolean;
    session_id: string;
};

/**
 * Configuration for retry logic in recipe execution
 */
export type RetryConfig = {
    /**
     * List of success checks to validate recipe completion
     */
    checks: Array<SuccessCheck>;
    /**
     * Maximum number of retry attempts before giving up
     */
    max_retries: number;
    /**
     * Optional shell command to run on failure for cleanup
     */
    on_failure?: string | null;
    /**
     * Timeout in seconds for on_failure commands (default: 600 seconds)
     */
    on_failure_timeout_seconds?: number | null;
    /**
     * Timeout in seconds for individual shell commands (default: 300 seconds)
     */
    timeout_seconds?: number | null;
};

export type Role = string;

export type RunNowResponse = {
    session_id: string;
};

export type SaveRecipeRequest = {
    id?: string | null;
    recipe: Recipe;
};

export type SaveRecipeResponse = {
    id: string;
};

export type ScanRecipeRequest = {
    recipe: Recipe;
};

export type ScanRecipeResponse = {
    has_security_warnings: boolean;
};

export type ScheduledJob = {
    cron: string;
    current_session_id?: string | null;
    currently_running?: boolean;
    id: string;
    last_run?: string | null;
    paused?: boolean;
    process_start_time?: string | null;
    source: string;
};

export type Session = {
    accumulated_input_tokens?: number | null;
    accumulated_output_tokens?: number | null;
    accumulated_total_tokens?: number | null;
    conversation?: Conversation | null;
    created_at: string;
    extension_data: ExtensionData;
    id: string;
    input_tokens?: number | null;
    message_count: number;
    name: string;
    output_tokens?: number | null;
    recipe?: Recipe | null;
    schedule_id?: string | null;
    session_type?: SessionType;
    total_tokens?: number | null;
    updated_at: string;
    user_recipe_values?: {
        [key: string]: string;
    } | null;
    user_set_name?: boolean;
    working_dir: string;
};

export type SessionDisplayInfo = {
    accumulatedInputTokens?: number | null;
    accumulatedOutputTokens?: number | null;
    accumulatedTotalTokens?: number | null;
    createdAt: string;
    id: string;
    inputTokens?: number | null;
    messageCount: number;
    name: string;
    outputTokens?: number | null;
    scheduleId?: string | null;
    totalTokens?: number | null;
    workingDir: string;
};

export type SessionInsights = {
    totalSessions: number;
    totalTokens: number;
};

export type SessionListResponse = {
    /**
     * List of available session information objects
     */
    sessions: Array<Session>;
};

export type SessionType = 'user' | 'scheduled' | 'sub_agent' | 'hidden';

export type SessionsQuery = {
    limit?: number;
};

export type Settings = {
    goose_model?: string | null;
    goose_provider?: string | null;
    temperature?: number | null;
};

export type SetupResponse = {
    message: string;
    success: boolean;
};

export type StartAgentRequest = {
    recipe?: Recipe | null;
    recipe_deeplink?: string | null;
    recipe_id?: string | null;
    working_dir: string;
};

export type SubRecipe = {
    description?: string | null;
    name: string;
    path: string;
    sequential_when_repeated?: boolean;
    values?: {
        [key: string]: string;
    } | null;
};

/**
 * Execute a shell command and check its exit status
 */
export type SuccessCheck = {
    /**
     * The shell command to execute
     */
    command: string;
    type: 'Shell';
};

export type SystemNotificationContent = {
    msg: string;
    notificationType: SystemNotificationType;
};

export type SystemNotificationType = 'thinkingMessage' | 'inlineMessage';

export type TextContent = {
    _meta?: {
        [key: string]: unknown;
    };
    annotations?: Annotations | {
        [key: string]: unknown;
    };
    text: string;
};

export type ThinkingContent = {
    signature: string;
    thinking: string;
};

export type TokenState = {
    accumulatedInputTokens: number;
    accumulatedOutputTokens: number;
    accumulatedTotalTokens: number;
    inputTokens: number;
    outputTokens: number;
    totalTokens: number;
};

export type Tool = {
    annotations?: ToolAnnotations | {
        [key: string]: unknown;
    };
    description?: string;
    icons?: Array<Icon>;
    inputSchema: {
        [key: string]: unknown;
    };
    name: string;
    outputSchema?: {
        [key: string]: unknown;
    };
    title?: string;
};

export type ToolAnnotations = {
    destructiveHint?: boolean;
    idempotentHint?: boolean;
    openWorldHint?: boolean;
    readOnlyHint?: boolean;
    title?: string;
};

export type ToolConfirmationRequest = {
    arguments: JsonObject;
    id: string;
    prompt?: string | null;
    toolName: string;
};

/**
 * Information about the tool used for building prompts
 */
export type ToolInfo = {
    description: string;
    name: string;
    parameters: Array<string>;
    permission?: PermissionLevel | null;
};

export type ToolPermission = {
    permission: PermissionLevel;
    tool_name: string;
};

export type ToolRequest = {
    id: string;
    toolCall: {
        [key: string]: unknown;
    };
};

export type ToolResponse = {
    id: string;
    toolResult: {
        [key: string]: unknown;
    };
};

export type UpdateCustomProviderRequest = {
    api_key: string;
    api_url: string;
    display_name: string;
    engine: string;
    models: Array<string>;
    supports_streaming?: boolean | null;
};

export type UpdateFromSessionRequest = {
    session_id: string;
};

export type UpdateProviderRequest = {
    model?: string | null;
    provider: string;
    session_id: string;
};

export type UpdateRouterToolSelectorRequest = {
    session_id: string;
};

export type UpdateScheduleRequest = {
    cron: string;
};

export type UpdateSessionNameRequest = {
    /**
     * Updated name for the session (max 200 characters)
     */
    name: string;
};

export type UpdateSessionUserRecipeValuesRequest = {
    /**
     * Recipe parameter values entered by the user
     */
    userRecipeValues: {
        [key: string]: string;
    };
};

export type UpdateSessionUserRecipeValuesResponse = {
    recipe: Recipe;
};

export type UpsertConfigQuery = {
    is_secret: boolean;
    key: string;
    value: unknown;
};

export type UpsertPermissionsQuery = {
    tool_permissions: Array<ToolPermission>;
};

export type AgentAddExtensionData = {
    body: AddExtensionRequest;
    path?: never;
    query?: never;
    url: '/agent/add_extension';
};

export type AgentAddExtensionErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type AgentAddExtensionResponses = {
    /**
     * Extension added
     */
    200: string;
};

export type AgentAddExtensionResponse = AgentAddExtensionResponses[keyof AgentAddExtensionResponses];

export type AgentRemoveExtensionData = {
    body: RemoveExtensionRequest;
    path?: never;
    query?: never;
    url: '/agent/remove_extension';
};

export type AgentRemoveExtensionErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type AgentRemoveExtensionResponses = {
    /**
     * Extension removed
     */
    200: string;
};

export type AgentRemoveExtensionResponse = AgentRemoveExtensionResponses[keyof AgentRemoveExtensionResponses];

export type ResumeAgentData = {
    body: ResumeAgentRequest;
    path?: never;
    query?: never;
    url: '/agent/resume';
};

export type ResumeAgentErrors = {
    /**
     * Bad request - invalid working directory
     */
    400: unknown;
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ResumeAgentResponses = {
    /**
     * Agent started successfully
     */
    200: Session;
};

export type ResumeAgentResponse = ResumeAgentResponses[keyof ResumeAgentResponses];

export type StartAgentData = {
    body: StartAgentRequest;
    path?: never;
    query?: never;
    url: '/agent/start';
};

export type StartAgentErrors = {
    /**
     * Bad request
     */
    400: ErrorResponse;
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: ErrorResponse;
};

export type StartAgentError = StartAgentErrors[keyof StartAgentErrors];

export type StartAgentResponses = {
    /**
     * Agent started successfully
     */
    200: Session;
};

export type StartAgentResponse = StartAgentResponses[keyof StartAgentResponses];

export type GetToolsData = {
    body?: never;
    path?: never;
    query: {
        /**
         * Optional extension name to filter tools
         */
        extension_name?: string | null;
        /**
         * Required session ID to scope tools to a specific session
         */
        session_id: string;
    };
    url: '/agent/tools';
};

export type GetToolsErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetToolsResponses = {
    /**
     * Tools retrieved successfully
     */
    200: Array<ToolInfo>;
};

export type GetToolsResponse = GetToolsResponses[keyof GetToolsResponses];

export type UpdateFromSessionData = {
    body: UpdateFromSessionRequest;
    path?: never;
    query?: never;
    url: '/agent/update_from_session';
};

export type UpdateFromSessionErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
};

export type UpdateFromSessionResponses = {
    /**
     * Update agent from session data successfully
     */
    200: unknown;
};

export type UpdateAgentProviderData = {
    body: UpdateProviderRequest;
    path?: never;
    query?: never;
    url: '/agent/update_provider';
};

export type UpdateAgentProviderErrors = {
    /**
     * Bad request - missing or invalid parameters
     */
    400: unknown;
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpdateAgentProviderResponses = {
    /**
     * Provider updated successfully
     */
    200: unknown;
};

export type UpdateRouterToolSelectorData = {
    body: UpdateRouterToolSelectorRequest;
    path?: never;
    query?: never;
    url: '/agent/update_router_tool_selector';
};

export type UpdateRouterToolSelectorErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpdateRouterToolSelectorResponses = {
    /**
     * Tool selection strategy updated successfully
     */
    200: string;
};

export type UpdateRouterToolSelectorResponse = UpdateRouterToolSelectorResponses[keyof UpdateRouterToolSelectorResponses];

export type ReadAllConfigData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config';
};

export type ReadAllConfigResponses = {
    /**
     * All configuration values retrieved successfully
     */
    200: ConfigResponse;
};

export type ReadAllConfigResponse = ReadAllConfigResponses[keyof ReadAllConfigResponses];

export type BackupConfigData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/backup';
};

export type BackupConfigErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type BackupConfigResponses = {
    /**
     * Config file backed up
     */
    200: string;
};

export type BackupConfigResponse = BackupConfigResponses[keyof BackupConfigResponses];

export type CreateCustomProviderData = {
    body: UpdateCustomProviderRequest;
    path?: never;
    query?: never;
    url: '/config/custom-providers';
};

export type CreateCustomProviderErrors = {
    /**
     * Invalid request
     */
    400: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type CreateCustomProviderResponses = {
    /**
     * Custom provider created successfully
     */
    200: string;
};

export type CreateCustomProviderResponse = CreateCustomProviderResponses[keyof CreateCustomProviderResponses];

export type RemoveCustomProviderData = {
    body?: never;
    path: {
        id: string;
    };
    query?: never;
    url: '/config/custom-providers/{id}';
};

export type RemoveCustomProviderErrors = {
    /**
     * Provider not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type RemoveCustomProviderResponses = {
    /**
     * Custom provider removed successfully
     */
    200: string;
};

export type RemoveCustomProviderResponse = RemoveCustomProviderResponses[keyof RemoveCustomProviderResponses];

export type GetCustomProviderData = {
    body?: never;
    path: {
        id: string;
    };
    query?: never;
    url: '/config/custom-providers/{id}';
};

export type GetCustomProviderErrors = {
    /**
     * Provider not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetCustomProviderResponses = {
    /**
     * Custom provider retrieved successfully
     */
    200: LoadedProvider;
};

export type GetCustomProviderResponse = GetCustomProviderResponses[keyof GetCustomProviderResponses];

export type UpdateCustomProviderData = {
    body: UpdateCustomProviderRequest;
    path: {
        id: string;
    };
    query?: never;
    url: '/config/custom-providers/{id}';
};

export type UpdateCustomProviderErrors = {
    /**
     * Provider not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpdateCustomProviderResponses = {
    /**
     * Custom provider updated successfully
     */
    200: string;
};

export type UpdateCustomProviderResponse = UpdateCustomProviderResponses[keyof UpdateCustomProviderResponses];

export type GetExtensionsData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/extensions';
};

export type GetExtensionsErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetExtensionsResponses = {
    /**
     * All extensions retrieved successfully
     */
    200: ExtensionResponse;
};

export type GetExtensionsResponse = GetExtensionsResponses[keyof GetExtensionsResponses];

export type AddExtensionData = {
    body: ExtensionQuery;
    path?: never;
    query?: never;
    url: '/config/extensions';
};

export type AddExtensionErrors = {
    /**
     * Invalid request
     */
    400: unknown;
    /**
     * Could not serialize config.yaml
     */
    422: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type AddExtensionResponses = {
    /**
     * Extension added or updated successfully
     */
    200: string;
};

export type AddExtensionResponse = AddExtensionResponses[keyof AddExtensionResponses];

export type RemoveExtensionData = {
    body?: never;
    path: {
        name: string;
    };
    query?: never;
    url: '/config/extensions/{name}';
};

export type RemoveExtensionErrors = {
    /**
     * Extension not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type RemoveExtensionResponses = {
    /**
     * Extension removed successfully
     */
    200: string;
};

export type RemoveExtensionResponse = RemoveExtensionResponses[keyof RemoveExtensionResponses];

export type InitConfigData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/init';
};

export type InitConfigErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type InitConfigResponses = {
    /**
     * Config initialization check completed
     */
    200: string;
};

export type InitConfigResponse = InitConfigResponses[keyof InitConfigResponses];

export type UpsertPermissionsData = {
    body: UpsertPermissionsQuery;
    path?: never;
    query?: never;
    url: '/config/permissions';
};

export type UpsertPermissionsErrors = {
    /**
     * Invalid request
     */
    400: unknown;
};

export type UpsertPermissionsResponses = {
    /**
     * Permission update completed
     */
    200: string;
};

export type UpsertPermissionsResponse = UpsertPermissionsResponses[keyof UpsertPermissionsResponses];

export type ProvidersData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/providers';
};

export type ProvidersResponses = {
    /**
     * All configuration values retrieved successfully
     */
    200: Array<ProviderDetails>;
};

export type ProvidersResponse2 = ProvidersResponses[keyof ProvidersResponses];

export type GetProviderModelsData = {
    body?: never;
    path: {
        /**
         * Provider name (e.g., openai)
         */
        name: string;
    };
    query?: never;
    url: '/config/providers/{name}/models';
};

export type GetProviderModelsErrors = {
    /**
     * Unknown provider, provider not configured, or authentication error
     */
    400: unknown;
    /**
     * Rate limit exceeded
     */
    429: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetProviderModelsResponses = {
    /**
     * Models fetched successfully
     */
    200: Array<string>;
};

export type GetProviderModelsResponse = GetProviderModelsResponses[keyof GetProviderModelsResponses];

export type ReadConfigData = {
    body: ConfigKeyQuery;
    path?: never;
    query?: never;
    url: '/config/read';
};

export type ReadConfigErrors = {
    /**
     * Unable to get the configuration value
     */
    500: unknown;
};

export type ReadConfigResponses = {
    /**
     * Configuration value retrieved successfully
     */
    200: unknown;
};

export type RecoverConfigData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/recover';
};

export type RecoverConfigErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type RecoverConfigResponses = {
    /**
     * Config recovery attempted
     */
    200: string;
};

export type RecoverConfigResponse = RecoverConfigResponses[keyof RecoverConfigResponses];

export type RemoveConfigData = {
    body: ConfigKeyQuery;
    path?: never;
    query?: never;
    url: '/config/remove';
};

export type RemoveConfigErrors = {
    /**
     * Configuration key not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type RemoveConfigResponses = {
    /**
     * Configuration value removed successfully
     */
    200: string;
};

export type RemoveConfigResponse = RemoveConfigResponses[keyof RemoveConfigResponses];

export type UpsertConfigData = {
    body: UpsertConfigQuery;
    path?: never;
    query?: never;
    url: '/config/upsert';
};

export type UpsertConfigErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpsertConfigResponses = {
    /**
     * Configuration value upserted successfully
     */
    200: string;
};

export type UpsertConfigResponse = UpsertConfigResponses[keyof UpsertConfigResponses];

export type ValidateConfigData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/config/validate';
};

export type ValidateConfigErrors = {
    /**
     * Config file is corrupted
     */
    422: unknown;
};

export type ValidateConfigResponses = {
    /**
     * Config validation result
     */
    200: string;
};

export type ValidateConfigResponse = ValidateConfigResponses[keyof ValidateConfigResponses];

export type ConfirmPermissionData = {
    body: PermissionConfirmationRequest;
    path?: never;
    query?: never;
    url: '/confirm';
};

export type ConfirmPermissionErrors = {
    /**
     * Unauthorized - invalid secret key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ConfirmPermissionResponses = {
    /**
     * Permission action is confirmed
     */
    200: unknown;
};

export type DiagnosticsData = {
    body?: never;
    path: {
        session_id: string;
    };
    query?: never;
    url: '/diagnostics/{session_id}';
};

export type DiagnosticsErrors = {
    /**
     * Failed to generate diagnostics
     */
    500: unknown;
};

export type DiagnosticsResponses = {
    /**
     * Diagnostics zip file
     */
    200: Blob | File;
};

export type DiagnosticsResponse = DiagnosticsResponses[keyof DiagnosticsResponses];

export type StartOpenrouterSetupData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/handle_openrouter';
};

export type StartOpenrouterSetupResponses = {
    200: SetupResponse;
};

export type StartOpenrouterSetupResponse = StartOpenrouterSetupResponses[keyof StartOpenrouterSetupResponses];

export type StartTetrateSetupData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/handle_tetrate';
};

export type StartTetrateSetupResponses = {
    200: SetupResponse;
};

export type StartTetrateSetupResponse = StartTetrateSetupResponses[keyof StartTetrateSetupResponses];

export type CreateRecipeData = {
    body: CreateRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/create';
};

export type CreateRecipeErrors = {
    /**
     * Bad request
     */
    400: unknown;
    /**
     * Precondition failed - Agent not available
     */
    412: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type CreateRecipeResponses = {
    /**
     * Recipe created successfully
     */
    200: CreateRecipeResponse;
};

export type CreateRecipeResponse2 = CreateRecipeResponses[keyof CreateRecipeResponses];

export type DecodeRecipeData = {
    body: DecodeRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/decode';
};

export type DecodeRecipeErrors = {
    /**
     * Bad request
     */
    400: unknown;
};

export type DecodeRecipeResponses = {
    /**
     * Recipe decoded successfully
     */
    200: DecodeRecipeResponse;
};

export type DecodeRecipeResponse2 = DecodeRecipeResponses[keyof DecodeRecipeResponses];

export type DeleteRecipeData = {
    body: DeleteRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/delete';
};

export type DeleteRecipeErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Recipe not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type DeleteRecipeResponses = {
    /**
     * Recipe deleted successfully
     */
    204: void;
};

export type DeleteRecipeResponse = DeleteRecipeResponses[keyof DeleteRecipeResponses];

export type EncodeRecipeData = {
    body: EncodeRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/encode';
};

export type EncodeRecipeErrors = {
    /**
     * Bad request
     */
    400: unknown;
};

export type EncodeRecipeResponses = {
    /**
     * Recipe encoded successfully
     */
    200: EncodeRecipeResponse;
};

export type EncodeRecipeResponse2 = EncodeRecipeResponses[keyof EncodeRecipeResponses];

export type ListRecipesData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/recipes/list';
};

export type ListRecipesErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ListRecipesResponses = {
    /**
     * Get recipe list successfully
     */
    200: ListRecipeResponse;
};

export type ListRecipesResponse = ListRecipesResponses[keyof ListRecipesResponses];

export type ParseRecipeData = {
    body: ParseRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/parse';
};

export type ParseRecipeErrors = {
    /**
     * Bad request - Invalid recipe format
     */
    400: ErrorResponse;
    /**
     * Internal server error
     */
    500: ErrorResponse;
};

export type ParseRecipeError = ParseRecipeErrors[keyof ParseRecipeErrors];

export type ParseRecipeResponses = {
    /**
     * Recipe parsed successfully
     */
    200: ParseRecipeResponse;
};

export type ParseRecipeResponse2 = ParseRecipeResponses[keyof ParseRecipeResponses];

export type SaveRecipeData = {
    body: SaveRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/save';
};

export type SaveRecipeErrors = {
    /**
     * Unauthorized
     */
    401: ErrorResponse;
    /**
     * Not found
     */
    404: ErrorResponse;
    /**
     * Internal server error
     */
    500: ErrorResponse;
};

export type SaveRecipeError = SaveRecipeErrors[keyof SaveRecipeErrors];

export type SaveRecipeResponses = {
    /**
     * Recipe saved to file successfully
     */
    204: SaveRecipeResponse;
};

export type SaveRecipeResponse2 = SaveRecipeResponses[keyof SaveRecipeResponses];

export type ScanRecipeData = {
    body: ScanRecipeRequest;
    path?: never;
    query?: never;
    url: '/recipes/scan';
};

export type ScanRecipeResponses = {
    /**
     * Recipe scanned successfully
     */
    200: ScanRecipeResponse;
};

export type ScanRecipeResponse2 = ScanRecipeResponses[keyof ScanRecipeResponses];

export type ReplyData = {
    body: ChatRequest;
    path?: never;
    query?: never;
    url: '/reply';
};

export type ReplyErrors = {
    /**
     * Agent not initialized
     */
    424: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ReplyResponses = {
    /**
     * Streaming response initiated
     */
    200: MessageEvent;
};

export type ReplyResponse = ReplyResponses[keyof ReplyResponses];

export type CreateScheduleData = {
    body: CreateScheduleRequest;
    path?: never;
    query?: never;
    url: '/schedule/create';
};

export type CreateScheduleErrors = {
    /**
     * Invalid cron expression or recipe file
     */
    400: unknown;
    /**
     * Job ID already exists
     */
    409: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type CreateScheduleResponses = {
    /**
     * Scheduled job created successfully
     */
    200: ScheduledJob;
};

export type CreateScheduleResponse = CreateScheduleResponses[keyof CreateScheduleResponses];

export type DeleteScheduleData = {
    body?: never;
    path: {
        /**
         * ID of the schedule to delete
         */
        id: string;
    };
    query?: never;
    url: '/schedule/delete/{id}';
};

export type DeleteScheduleErrors = {
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type DeleteScheduleResponses = {
    /**
     * Scheduled job deleted successfully
     */
    204: void;
};

export type DeleteScheduleResponse = DeleteScheduleResponses[keyof DeleteScheduleResponses];

export type ListSchedulesData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/schedule/list';
};

export type ListSchedulesErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type ListSchedulesResponses = {
    /**
     * A list of scheduled jobs
     */
    200: ListSchedulesResponse;
};

export type ListSchedulesResponse2 = ListSchedulesResponses[keyof ListSchedulesResponses];

export type UpdateScheduleData = {
    body: UpdateScheduleRequest;
    path: {
        /**
         * ID of the schedule to update
         */
        id: string;
    };
    query?: never;
    url: '/schedule/{id}';
};

export type UpdateScheduleErrors = {
    /**
     * Cannot update a currently running job or invalid request
     */
    400: unknown;
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpdateScheduleResponses = {
    /**
     * Scheduled job updated successfully
     */
    200: ScheduledJob;
};

export type UpdateScheduleResponse = UpdateScheduleResponses[keyof UpdateScheduleResponses];

export type InspectRunningJobData = {
    body?: never;
    path: {
        /**
         * ID of the schedule to inspect
         */
        id: string;
    };
    query?: never;
    url: '/schedule/{id}/inspect';
};

export type InspectRunningJobErrors = {
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type InspectRunningJobResponses = {
    /**
     * Running job information
     */
    200: InspectJobResponse;
};

export type InspectRunningJobResponse = InspectRunningJobResponses[keyof InspectRunningJobResponses];

export type KillRunningJobData = {
    body?: never;
    path: {
        id: string;
    };
    query?: never;
    url: '/schedule/{id}/kill';
};

export type KillRunningJobResponses = {
    /**
     * Running job killed successfully
     */
    200: unknown;
};

export type PauseScheduleData = {
    body?: never;
    path: {
        /**
         * ID of the schedule to pause
         */
        id: string;
    };
    query?: never;
    url: '/schedule/{id}/pause';
};

export type PauseScheduleErrors = {
    /**
     * Cannot pause a currently running job
     */
    400: unknown;
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type PauseScheduleResponses = {
    /**
     * Scheduled job paused successfully
     */
    204: void;
};

export type PauseScheduleResponse = PauseScheduleResponses[keyof PauseScheduleResponses];

export type RunNowHandlerData = {
    body?: never;
    path: {
        /**
         * ID of the schedule to run
         */
        id: string;
    };
    query?: never;
    url: '/schedule/{id}/run_now';
};

export type RunNowHandlerErrors = {
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error when trying to run the job
     */
    500: unknown;
};

export type RunNowHandlerResponses = {
    /**
     * Scheduled job triggered successfully, returns new session ID
     */
    200: RunNowResponse;
};

export type RunNowHandlerResponse = RunNowHandlerResponses[keyof RunNowHandlerResponses];

export type SessionsHandlerData = {
    body?: never;
    path: {
        /**
         * ID of the schedule
         */
        id: string;
    };
    query?: {
        limit?: number;
    };
    url: '/schedule/{id}/sessions';
};

export type SessionsHandlerErrors = {
    /**
     * Internal server error
     */
    500: unknown;
};

export type SessionsHandlerResponses = {
    /**
     * A list of session display info
     */
    200: Array<SessionDisplayInfo>;
};

export type SessionsHandlerResponse = SessionsHandlerResponses[keyof SessionsHandlerResponses];

export type UnpauseScheduleData = {
    body?: never;
    path: {
        /**
         * ID of the schedule to unpause
         */
        id: string;
    };
    query?: never;
    url: '/schedule/{id}/unpause';
};

export type UnpauseScheduleErrors = {
    /**
     * Scheduled job not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UnpauseScheduleResponses = {
    /**
     * Scheduled job unpaused successfully
     */
    204: void;
};

export type UnpauseScheduleResponse = UnpauseScheduleResponses[keyof UnpauseScheduleResponses];

export type ListSessionsData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/sessions';
};

export type ListSessionsErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ListSessionsResponses = {
    /**
     * List of available sessions retrieved successfully
     */
    200: SessionListResponse;
};

export type ListSessionsResponse = ListSessionsResponses[keyof ListSessionsResponses];

export type ImportSessionData = {
    body: ImportSessionRequest;
    path?: never;
    query?: never;
    url: '/sessions/import';
};

export type ImportSessionErrors = {
    /**
     * Bad request - Invalid JSON
     */
    400: unknown;
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ImportSessionResponses = {
    /**
     * Session imported successfully
     */
    200: Session;
};

export type ImportSessionResponse = ImportSessionResponses[keyof ImportSessionResponses];

export type GetSessionInsightsData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/sessions/insights';
};

export type GetSessionInsightsErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetSessionInsightsResponses = {
    /**
     * Session insights retrieved successfully
     */
    200: SessionInsights;
};

export type GetSessionInsightsResponse = GetSessionInsightsResponses[keyof GetSessionInsightsResponses];

export type DeleteSessionData = {
    body?: never;
    path: {
        /**
         * Unique identifier for the session
         */
        session_id: string;
    };
    query?: never;
    url: '/sessions/{session_id}';
};

export type DeleteSessionErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Session not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type DeleteSessionResponses = {
    /**
     * Session deleted successfully
     */
    200: unknown;
};

export type GetSessionData = {
    body?: never;
    path: {
        /**
         * Unique identifier for the session
         */
        session_id: string;
    };
    query?: never;
    url: '/sessions/{session_id}';
};

export type GetSessionErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Session not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type GetSessionResponses = {
    /**
     * Session history retrieved successfully
     */
    200: Session;
};

export type GetSessionResponse = GetSessionResponses[keyof GetSessionResponses];

export type ExportSessionData = {
    body?: never;
    path: {
        /**
         * Unique identifier for the session
         */
        session_id: string;
    };
    query?: never;
    url: '/sessions/{session_id}/export';
};

export type ExportSessionErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Session not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type ExportSessionResponses = {
    /**
     * Session exported successfully
     */
    200: string;
};

export type ExportSessionResponse = ExportSessionResponses[keyof ExportSessionResponses];

export type UpdateSessionNameData = {
    body: UpdateSessionNameRequest;
    path: {
        /**
         * Unique identifier for the session
         */
        session_id: string;
    };
    query?: never;
    url: '/sessions/{session_id}/name';
};

export type UpdateSessionNameErrors = {
    /**
     * Bad request - Name too long (max 200 characters)
     */
    400: unknown;
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Session not found
     */
    404: unknown;
    /**
     * Internal server error
     */
    500: unknown;
};

export type UpdateSessionNameResponses = {
    /**
     * Session name updated successfully
     */
    200: unknown;
};

export type UpdateSessionUserRecipeValuesData = {
    body: UpdateSessionUserRecipeValuesRequest;
    path: {
        /**
         * Unique identifier for the session
         */
        session_id: string;
    };
    query?: never;
    url: '/sessions/{session_id}/user_recipe_values';
};

export type UpdateSessionUserRecipeValuesErrors = {
    /**
     * Unauthorized - Invalid or missing API key
     */
    401: unknown;
    /**
     * Session not found
     */
    404: ErrorResponse;
    /**
     * Internal server error
     */
    500: ErrorResponse;
};

export type UpdateSessionUserRecipeValuesError = UpdateSessionUserRecipeValuesErrors[keyof UpdateSessionUserRecipeValuesErrors];

export type UpdateSessionUserRecipeValuesResponses = {
    /**
     * Session user recipe values updated successfully
     */
    200: UpdateSessionUserRecipeValuesResponse;
};

export type UpdateSessionUserRecipeValuesResponse2 = UpdateSessionUserRecipeValuesResponses[keyof UpdateSessionUserRecipeValuesResponses];

export type StatusData = {
    body?: never;
    path?: never;
    query?: never;
    url: '/status';
};

export type StatusResponses = {
    /**
     * ok
     */
    200: string;
};

export type StatusResponse = StatusResponses[keyof StatusResponses];
