// This file is auto-generated by @hey-api/openapi-ts

import type { Client, Options as Options2, TDataShape } from './client';
import { client } from './client.gen';
import type { AddExtensionData, AddExtensionErrors, AddExtensionResponses, AgentAddExtensionData, AgentAddExtensionErrors, AgentAddExtensionResponses, AgentRemoveExtensionData, AgentRemoveExtensionErrors, AgentRemoveExtensionResponses, BackupConfigData, BackupConfigErrors, BackupConfigResponses, ConfirmPermissionData, ConfirmPermissionErrors, ConfirmPermissionResponses, CreateCustomProviderData, CreateCustomProviderErrors, CreateCustomProviderResponses, CreateRecipeData, CreateRecipeErrors, CreateRecipeResponses, CreateScheduleData, CreateScheduleErrors, CreateScheduleResponses, DecodeRecipeData, DecodeRecipeErrors, DecodeRecipeResponses, DeleteRecipeData, DeleteRecipeErrors, DeleteRecipeResponses, DeleteScheduleData, DeleteScheduleErrors, DeleteScheduleResponses, DeleteSessionData, DeleteSessionErrors, DeleteSessionResponses, DiagnosticsData, DiagnosticsErrors, DiagnosticsResponses, EncodeRecipeData, EncodeRecipeErrors, EncodeRecipeResponses, ExportSessionData, ExportSessionErrors, ExportSessionResponses, GetCustomProviderData, GetCustomProviderErrors, GetCustomProviderResponses, GetExtensionsData, GetExtensionsErrors, GetExtensionsResponses, GetProviderModelsData, GetProviderModelsErrors, GetProviderModelsResponses, GetSessionData, GetSessionErrors, GetSessionInsightsData, GetSessionInsightsErrors, GetSessionInsightsResponses, GetSessionResponses, GetToolsData, GetToolsErrors, GetToolsResponses, ImportSessionData, ImportSessionErrors, ImportSessionResponses, InitConfigData, InitConfigErrors, InitConfigResponses, InspectRunningJobData, InspectRunningJobErrors, InspectRunningJobResponses, KillRunningJobData, KillRunningJobResponses, ListRecipesData, ListRecipesErrors, ListRecipesResponses, ListSchedulesData, ListSchedulesErrors, ListSchedulesResponses, ListSessionsData, ListSessionsErrors, ListSessionsResponses, ParseRecipeData, ParseRecipeErrors, ParseRecipeResponses, PauseScheduleData, PauseScheduleErrors, PauseScheduleResponses, ProvidersData, ProvidersResponses, ReadAllConfigData, ReadAllConfigResponses, ReadConfigData, ReadConfigErrors, ReadConfigResponses, RecoverConfigData, RecoverConfigErrors, RecoverConfigResponses, RemoveConfigData, RemoveConfigErrors, RemoveConfigResponses, RemoveCustomProviderData, RemoveCustomProviderErrors, RemoveCustomProviderResponses, RemoveExtensionData, RemoveExtensionErrors, RemoveExtensionResponses, ReplyData, ReplyErrors, ReplyResponses, ResumeAgentData, ResumeAgentErrors, ResumeAgentResponses, RunNowHandlerData, RunNowHandlerErrors, RunNowHandlerResponses, SaveRecipeData, SaveRecipeErrors, SaveRecipeResponses, ScanRecipeData, ScanRecipeResponses, SessionsHandlerData, SessionsHandlerErrors, SessionsHandlerResponses, StartAgentData, StartAgentErrors, StartAgentResponses, StartOpenrouterSetupData, StartOpenrouterSetupResponses, StartTetrateSetupData, StartTetrateSetupResponses, StatusData, StatusResponses, UnpauseScheduleData, UnpauseScheduleErrors, UnpauseScheduleResponses, UpdateAgentProviderData, UpdateAgentProviderErrors, UpdateAgentProviderResponses, UpdateCustomProviderData, UpdateCustomProviderErrors, UpdateCustomProviderResponses, UpdateFromSessionData, UpdateFromSessionErrors, UpdateFromSessionResponses, UpdateRouterToolSelectorData, UpdateRouterToolSelectorErrors, UpdateRouterToolSelectorResponses, UpdateScheduleData, UpdateScheduleErrors, UpdateScheduleResponses, UpdateSessionNameData, UpdateSessionNameErrors, UpdateSessionNameResponses, UpdateSessionUserRecipeValuesData, UpdateSessionUserRecipeValuesErrors, UpdateSessionUserRecipeValuesResponses, UpsertConfigData, UpsertConfigErrors, UpsertConfigResponses, UpsertPermissionsData, UpsertPermissionsErrors, UpsertPermissionsResponses, ValidateConfigData, ValidateConfigErrors, ValidateConfigResponses } from './types.gen';

export type Options<TData extends TDataShape = TDataShape, ThrowOnError extends boolean = boolean> = Options2<TData, ThrowOnError> & {
    /**
     * You can provide a client instance returned by `createClient()` instead of
     * individual options. This might be also useful if you want to implement a
     * custom client.
     */
    client?: Client;
    /**
     * You can pass arbitrary values through the `meta` object. This can be
     * used to access values that aren't defined as part of the SDK function.
     */
    meta?: Record<string, unknown>;
};

export const agentAddExtension = <ThrowOnError extends boolean = false>(options: Options<AgentAddExtensionData, ThrowOnError>) => {
    return (options.client ?? client).post<AgentAddExtensionResponses, AgentAddExtensionErrors, ThrowOnError>({
        url: '/agent/add_extension',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const agentRemoveExtension = <ThrowOnError extends boolean = false>(options: Options<AgentRemoveExtensionData, ThrowOnError>) => {
    return (options.client ?? client).post<AgentRemoveExtensionResponses, AgentRemoveExtensionErrors, ThrowOnError>({
        url: '/agent/remove_extension',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const resumeAgent = <ThrowOnError extends boolean = false>(options: Options<ResumeAgentData, ThrowOnError>) => {
    return (options.client ?? client).post<ResumeAgentResponses, ResumeAgentErrors, ThrowOnError>({
        url: '/agent/resume',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const startAgent = <ThrowOnError extends boolean = false>(options: Options<StartAgentData, ThrowOnError>) => {
    return (options.client ?? client).post<StartAgentResponses, StartAgentErrors, ThrowOnError>({
        url: '/agent/start',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const getTools = <ThrowOnError extends boolean = false>(options: Options<GetToolsData, ThrowOnError>) => {
    return (options.client ?? client).get<GetToolsResponses, GetToolsErrors, ThrowOnError>({
        url: '/agent/tools',
        ...options
    });
};

export const updateFromSession = <ThrowOnError extends boolean = false>(options: Options<UpdateFromSessionData, ThrowOnError>) => {
    return (options.client ?? client).post<UpdateFromSessionResponses, UpdateFromSessionErrors, ThrowOnError>({
        url: '/agent/update_from_session',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const updateAgentProvider = <ThrowOnError extends boolean = false>(options: Options<UpdateAgentProviderData, ThrowOnError>) => {
    return (options.client ?? client).post<UpdateAgentProviderResponses, UpdateAgentProviderErrors, ThrowOnError>({
        url: '/agent/update_provider',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const updateRouterToolSelector = <ThrowOnError extends boolean = false>(options: Options<UpdateRouterToolSelectorData, ThrowOnError>) => {
    return (options.client ?? client).post<UpdateRouterToolSelectorResponses, UpdateRouterToolSelectorErrors, ThrowOnError>({
        url: '/agent/update_router_tool_selector',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const readAllConfig = <ThrowOnError extends boolean = false>(options?: Options<ReadAllConfigData, ThrowOnError>) => {
    return (options?.client ?? client).get<ReadAllConfigResponses, unknown, ThrowOnError>({
        url: '/config',
        ...options
    });
};

export const backupConfig = <ThrowOnError extends boolean = false>(options?: Options<BackupConfigData, ThrowOnError>) => {
    return (options?.client ?? client).post<BackupConfigResponses, BackupConfigErrors, ThrowOnError>({
        url: '/config/backup',
        ...options
    });
};

export const createCustomProvider = <ThrowOnError extends boolean = false>(options: Options<CreateCustomProviderData, ThrowOnError>) => {
    return (options.client ?? client).post<CreateCustomProviderResponses, CreateCustomProviderErrors, ThrowOnError>({
        url: '/config/custom-providers',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const removeCustomProvider = <ThrowOnError extends boolean = false>(options: Options<RemoveCustomProviderData, ThrowOnError>) => {
    return (options.client ?? client).delete<RemoveCustomProviderResponses, RemoveCustomProviderErrors, ThrowOnError>({
        url: '/config/custom-providers/{id}',
        ...options
    });
};

export const getCustomProvider = <ThrowOnError extends boolean = false>(options: Options<GetCustomProviderData, ThrowOnError>) => {
    return (options.client ?? client).get<GetCustomProviderResponses, GetCustomProviderErrors, ThrowOnError>({
        url: '/config/custom-providers/{id}',
        ...options
    });
};

export const updateCustomProvider = <ThrowOnError extends boolean = false>(options: Options<UpdateCustomProviderData, ThrowOnError>) => {
    return (options.client ?? client).put<UpdateCustomProviderResponses, UpdateCustomProviderErrors, ThrowOnError>({
        url: '/config/custom-providers/{id}',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const getExtensions = <ThrowOnError extends boolean = false>(options?: Options<GetExtensionsData, ThrowOnError>) => {
    return (options?.client ?? client).get<GetExtensionsResponses, GetExtensionsErrors, ThrowOnError>({
        url: '/config/extensions',
        ...options
    });
};

export const addExtension = <ThrowOnError extends boolean = false>(options: Options<AddExtensionData, ThrowOnError>) => {
    return (options.client ?? client).post<AddExtensionResponses, AddExtensionErrors, ThrowOnError>({
        url: '/config/extensions',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const removeExtension = <ThrowOnError extends boolean = false>(options: Options<RemoveExtensionData, ThrowOnError>) => {
    return (options.client ?? client).delete<RemoveExtensionResponses, RemoveExtensionErrors, ThrowOnError>({
        url: '/config/extensions/{name}',
        ...options
    });
};

export const initConfig = <ThrowOnError extends boolean = false>(options?: Options<InitConfigData, ThrowOnError>) => {
    return (options?.client ?? client).post<InitConfigResponses, InitConfigErrors, ThrowOnError>({
        url: '/config/init',
        ...options
    });
};

export const upsertPermissions = <ThrowOnError extends boolean = false>(options: Options<UpsertPermissionsData, ThrowOnError>) => {
    return (options.client ?? client).post<UpsertPermissionsResponses, UpsertPermissionsErrors, ThrowOnError>({
        url: '/config/permissions',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const providers = <ThrowOnError extends boolean = false>(options?: Options<ProvidersData, ThrowOnError>) => {
    return (options?.client ?? client).get<ProvidersResponses, unknown, ThrowOnError>({
        url: '/config/providers',
        ...options
    });
};

export const getProviderModels = <ThrowOnError extends boolean = false>(options: Options<GetProviderModelsData, ThrowOnError>) => {
    return (options.client ?? client).get<GetProviderModelsResponses, GetProviderModelsErrors, ThrowOnError>({
        url: '/config/providers/{name}/models',
        ...options
    });
};

export const readConfig = <ThrowOnError extends boolean = false>(options: Options<ReadConfigData, ThrowOnError>) => {
    return (options.client ?? client).post<ReadConfigResponses, ReadConfigErrors, ThrowOnError>({
        url: '/config/read',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const recoverConfig = <ThrowOnError extends boolean = false>(options?: Options<RecoverConfigData, ThrowOnError>) => {
    return (options?.client ?? client).post<RecoverConfigResponses, RecoverConfigErrors, ThrowOnError>({
        url: '/config/recover',
        ...options
    });
};

export const removeConfig = <ThrowOnError extends boolean = false>(options: Options<RemoveConfigData, ThrowOnError>) => {
    return (options.client ?? client).post<RemoveConfigResponses, RemoveConfigErrors, ThrowOnError>({
        url: '/config/remove',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const upsertConfig = <ThrowOnError extends boolean = false>(options: Options<UpsertConfigData, ThrowOnError>) => {
    return (options.client ?? client).post<UpsertConfigResponses, UpsertConfigErrors, ThrowOnError>({
        url: '/config/upsert',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const validateConfig = <ThrowOnError extends boolean = false>(options?: Options<ValidateConfigData, ThrowOnError>) => {
    return (options?.client ?? client).get<ValidateConfigResponses, ValidateConfigErrors, ThrowOnError>({
        url: '/config/validate',
        ...options
    });
};

export const confirmPermission = <ThrowOnError extends boolean = false>(options: Options<ConfirmPermissionData, ThrowOnError>) => {
    return (options.client ?? client).post<ConfirmPermissionResponses, ConfirmPermissionErrors, ThrowOnError>({
        url: '/confirm',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const diagnostics = <ThrowOnError extends boolean = false>(options: Options<DiagnosticsData, ThrowOnError>) => {
    return (options.client ?? client).get<DiagnosticsResponses, DiagnosticsErrors, ThrowOnError>({
        url: '/diagnostics/{session_id}',
        ...options
    });
};

export const startOpenrouterSetup = <ThrowOnError extends boolean = false>(options?: Options<StartOpenrouterSetupData, ThrowOnError>) => {
    return (options?.client ?? client).post<StartOpenrouterSetupResponses, unknown, ThrowOnError>({
        url: '/handle_openrouter',
        ...options
    });
};

export const startTetrateSetup = <ThrowOnError extends boolean = false>(options?: Options<StartTetrateSetupData, ThrowOnError>) => {
    return (options?.client ?? client).post<StartTetrateSetupResponses, unknown, ThrowOnError>({
        url: '/handle_tetrate',
        ...options
    });
};

export const createRecipe = <ThrowOnError extends boolean = false>(options: Options<CreateRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<CreateRecipeResponses, CreateRecipeErrors, ThrowOnError>({
        url: '/recipes/create',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const decodeRecipe = <ThrowOnError extends boolean = false>(options: Options<DecodeRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<DecodeRecipeResponses, DecodeRecipeErrors, ThrowOnError>({
        url: '/recipes/decode',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const deleteRecipe = <ThrowOnError extends boolean = false>(options: Options<DeleteRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<DeleteRecipeResponses, DeleteRecipeErrors, ThrowOnError>({
        url: '/recipes/delete',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const encodeRecipe = <ThrowOnError extends boolean = false>(options: Options<EncodeRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<EncodeRecipeResponses, EncodeRecipeErrors, ThrowOnError>({
        url: '/recipes/encode',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const listRecipes = <ThrowOnError extends boolean = false>(options?: Options<ListRecipesData, ThrowOnError>) => {
    return (options?.client ?? client).get<ListRecipesResponses, ListRecipesErrors, ThrowOnError>({
        url: '/recipes/list',
        ...options
    });
};

export const parseRecipe = <ThrowOnError extends boolean = false>(options: Options<ParseRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<ParseRecipeResponses, ParseRecipeErrors, ThrowOnError>({
        url: '/recipes/parse',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const saveRecipe = <ThrowOnError extends boolean = false>(options: Options<SaveRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<SaveRecipeResponses, SaveRecipeErrors, ThrowOnError>({
        url: '/recipes/save',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const scanRecipe = <ThrowOnError extends boolean = false>(options: Options<ScanRecipeData, ThrowOnError>) => {
    return (options.client ?? client).post<ScanRecipeResponses, unknown, ThrowOnError>({
        url: '/recipes/scan',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const reply = <ThrowOnError extends boolean = false>(options: Options<ReplyData, ThrowOnError>) => {
    return (options.client ?? client).sse.post<ReplyResponses, ReplyErrors, ThrowOnError>({
        url: '/reply',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const createSchedule = <ThrowOnError extends boolean = false>(options: Options<CreateScheduleData, ThrowOnError>) => {
    return (options.client ?? client).post<CreateScheduleResponses, CreateScheduleErrors, ThrowOnError>({
        url: '/schedule/create',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const deleteSchedule = <ThrowOnError extends boolean = false>(options: Options<DeleteScheduleData, ThrowOnError>) => {
    return (options.client ?? client).delete<DeleteScheduleResponses, DeleteScheduleErrors, ThrowOnError>({
        url: '/schedule/delete/{id}',
        ...options
    });
};

export const listSchedules = <ThrowOnError extends boolean = false>(options?: Options<ListSchedulesData, ThrowOnError>) => {
    return (options?.client ?? client).get<ListSchedulesResponses, ListSchedulesErrors, ThrowOnError>({
        url: '/schedule/list',
        ...options
    });
};

export const updateSchedule = <ThrowOnError extends boolean = false>(options: Options<UpdateScheduleData, ThrowOnError>) => {
    return (options.client ?? client).put<UpdateScheduleResponses, UpdateScheduleErrors, ThrowOnError>({
        url: '/schedule/{id}',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const inspectRunningJob = <ThrowOnError extends boolean = false>(options: Options<InspectRunningJobData, ThrowOnError>) => {
    return (options.client ?? client).get<InspectRunningJobResponses, InspectRunningJobErrors, ThrowOnError>({
        url: '/schedule/{id}/inspect',
        ...options
    });
};

export const killRunningJob = <ThrowOnError extends boolean = false>(options: Options<KillRunningJobData, ThrowOnError>) => {
    return (options.client ?? client).post<KillRunningJobResponses, unknown, ThrowOnError>({
        url: '/schedule/{id}/kill',
        ...options
    });
};

export const pauseSchedule = <ThrowOnError extends boolean = false>(options: Options<PauseScheduleData, ThrowOnError>) => {
    return (options.client ?? client).post<PauseScheduleResponses, PauseScheduleErrors, ThrowOnError>({
        url: '/schedule/{id}/pause',
        ...options
    });
};

export const runNowHandler = <ThrowOnError extends boolean = false>(options: Options<RunNowHandlerData, ThrowOnError>) => {
    return (options.client ?? client).post<RunNowHandlerResponses, RunNowHandlerErrors, ThrowOnError>({
        url: '/schedule/{id}/run_now',
        ...options
    });
};

export const sessionsHandler = <ThrowOnError extends boolean = false>(options: Options<SessionsHandlerData, ThrowOnError>) => {
    return (options.client ?? client).get<SessionsHandlerResponses, SessionsHandlerErrors, ThrowOnError>({
        url: '/schedule/{id}/sessions',
        ...options
    });
};

export const unpauseSchedule = <ThrowOnError extends boolean = false>(options: Options<UnpauseScheduleData, ThrowOnError>) => {
    return (options.client ?? client).post<UnpauseScheduleResponses, UnpauseScheduleErrors, ThrowOnError>({
        url: '/schedule/{id}/unpause',
        ...options
    });
};

export const listSessions = <ThrowOnError extends boolean = false>(options?: Options<ListSessionsData, ThrowOnError>) => {
    return (options?.client ?? client).get<ListSessionsResponses, ListSessionsErrors, ThrowOnError>({
        url: '/sessions',
        ...options
    });
};

export const importSession = <ThrowOnError extends boolean = false>(options: Options<ImportSessionData, ThrowOnError>) => {
    return (options.client ?? client).post<ImportSessionResponses, ImportSessionErrors, ThrowOnError>({
        url: '/sessions/import',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const getSessionInsights = <ThrowOnError extends boolean = false>(options?: Options<GetSessionInsightsData, ThrowOnError>) => {
    return (options?.client ?? client).get<GetSessionInsightsResponses, GetSessionInsightsErrors, ThrowOnError>({
        url: '/sessions/insights',
        ...options
    });
};

export const deleteSession = <ThrowOnError extends boolean = false>(options: Options<DeleteSessionData, ThrowOnError>) => {
    return (options.client ?? client).delete<DeleteSessionResponses, DeleteSessionErrors, ThrowOnError>({
        url: '/sessions/{session_id}',
        ...options
    });
};

export const getSession = <ThrowOnError extends boolean = false>(options: Options<GetSessionData, ThrowOnError>) => {
    return (options.client ?? client).get<GetSessionResponses, GetSessionErrors, ThrowOnError>({
        url: '/sessions/{session_id}',
        ...options
    });
};

export const exportSession = <ThrowOnError extends boolean = false>(options: Options<ExportSessionData, ThrowOnError>) => {
    return (options.client ?? client).get<ExportSessionResponses, ExportSessionErrors, ThrowOnError>({
        url: '/sessions/{session_id}/export',
        ...options
    });
};

export const updateSessionName = <ThrowOnError extends boolean = false>(options: Options<UpdateSessionNameData, ThrowOnError>) => {
    return (options.client ?? client).put<UpdateSessionNameResponses, UpdateSessionNameErrors, ThrowOnError>({
        url: '/sessions/{session_id}/name',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const updateSessionUserRecipeValues = <ThrowOnError extends boolean = false>(options: Options<UpdateSessionUserRecipeValuesData, ThrowOnError>) => {
    return (options.client ?? client).put<UpdateSessionUserRecipeValuesResponses, UpdateSessionUserRecipeValuesErrors, ThrowOnError>({
        url: '/sessions/{session_id}/user_recipe_values',
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers
        }
    });
};

export const status = <ThrowOnError extends boolean = false>(options?: Options<StatusData, ThrowOnError>) => {
    return (options?.client ?? client).get<StatusResponses, unknown, ThrowOnError>({
        url: '/status',
        ...options
    });
};
