---
title: goose grant program
description: $100K grants for open source devs building the future of agentic AI.
---

import Link from "@docusaurus/Link";
import { Button } from "@site/src/components/ui/button";

![](/img/goose-grant-program.png)

# goose grant program

We’ve created a grant program to accelerate goose in the open source community. If you believe in a future where agentic AI is open and accessible to all, we invite you to help us shape that future.

<Link to="https://forms.gle/psHBhj8xFY8q1nHP7" target="_blank" rel="noopener noreferrer">
    ##  → apply for a goose grant
</Link>

<br/>
  <Link className="button button--primary button-grant">
    ## what makes a good proposal
  </Link>
<br/>

We're looking for clear, compelling, and ambitious ideas that align with goose’s values: openness, modularity, and user empowerment.

We'd love to see proposals that explore novel ways of interacting with AI agents. Here are just a few examples:

- **New interaction paradigms:** interact with goose through sketches (white boarding!), camera, voice interactions that pay attention to emotions or other multi-modal interactions
- **Self-flying:** increase autonomy by adding a long-running background mode, experimenting with new intermediate states, deep planning, and tools to support such operation
- **Self improving agents:** efforts like absolute zero, the godel Darwin machine and alphaevolve show how agents can improve themselves. Help goose rewrite its system prompt, its MCP servers and maybe its own code
- **Automate everything:** give goose tools to interact with the real world for home automation, robots or 3D printing.

Above all, we want to fund work that aligns with these values and demonstrates an open-source-first mindset.


<br/>
  <Link className="button button--primary button-grant">
    ## grant details
  </Link>
<br/>

- **Project Length:** 12 months
- **Funding Amount:** $100,000 USD per grant
- **Structure:** Grants are milestone-based, with periodic check-ins, deliverables, and payouts

_subject to applicable law_

<br/>
  <Link className="button button--primary button-grant">
    ## faq
  </Link>
<br/>
**When are proposals accepted?**

We review proposals on a rolling basis. There is no fixed deadline, though submitting earlier increases your chances of being considered for the current review cycle.

**How many proposals will you accept?**

We will support as many strong, mission-aligned projects as our resources allow.

**Can my grant be renewed after 12 months?**

Potentially, yes. We may extend or renew grants based on progress, impact, and alignment. Renewals are not guaranteed and will be evaluated on a case-by-case basis.

**Does a grant lead to a job at goose or Block?**

No. Grants are not employment and do not imply future hiring. However, collaboration with goose or Block teams may emerge naturally from impactful work.

**How does work get reviewed?**

Each grant project will define clear deliverables and milestones. Progress will be reviewed quarterly by the goose team and selected external reviewers.

**How are payouts structured?**

Payouts are milestone-based and made quarterly, pending satisfactory progress updates.

**Are grants available worldwide?**

Yes. We accept proposals from individuals and teams globally. Payouts are made in USD, but we will work with you to accommodate your local currency and payment preferences wherever feasible.

**Can I propose more than one project?**

Yes. You can submit multiple applications as long as the projects are significantly different.

**Who can apply?**

Anyone. We welcome individuals, working on their own or in small teams, as long as the work is not already funded by an employer or client and subject to applicable law. Prior open source experience is a plus, but not required. If you're passionate about open source and have an idea - even if it's just a sketch - we encourage you to reach out.

**How do I apply?**

[Submit your application here](https://forms.gle/psHBhj8xFY8q1nHP7)


<br/>
  <Link className="button button--primary button-grant">
    ## contact us
  </Link>
<br/>

If you have additional questions, feel free to reach out in [Discord](https://discord.com/channels/1287729918100246654/1397943505216868444) in the #goose-grants forum.

<head>
  <meta property="og:title" content="goose grant program" />
  <meta property="og:type" content="article" />
  <meta property="og:url" content="https://block.github.io/goose/grants" />
  <meta property="og:description" content="$100K grants for open source devs building the future of agentic AI." />
  <meta property="og:image" content="https://block.github.io/goose/assets/images/goose-grant-program-3ede164a454d9f29e779108c63773416.png" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta property="twitter:domain" content="block.github.io/goose" />
  <meta name="twitter:title" content="goose grant program" />
  <meta name="twitter:description" content="$100K grants for open source devs building the future of agentic AI." />
  <meta name="twitter:image" content="https://block.github.io/goose/assets/images/goose-grant-program-3ede164a454d9f29e779108c63773416.png" />
</head>