---
title: "goose is Celebrating Hacktoberfest 2025!"
description: Explore goose prizes you can earn and contributions you can make during Hacktoberfest 2025
authors: 
    - tania
---

![blog banner](hacktoberfest2025.png)

October is around the corner, which means spooky season is upon us, and with that crispy fall air that gives you "goose" bumps...it's finally time for Hacktoberfest 2025! The goose team is beyond excited to celebrate with you all for the first time this year. Let's get into how you can participate, and what prizes you can win. 👀

<!-- truncate -->

# 📌 What is Hacktoberfest?
[Hacktoberfest](https://hacktoberfest.com/participation/) is a month-long celebration every October of open source and participating open source projects. It's a great chance to earn fun prizes for contributing to your favorite projects, or a perfect opportunity to get your feet wet in a new project. 

# 🎉 How Can I Contribute to goose?
In the [goose repo](https://github.com/block/goose), there's something for everyone no matter if you're a newbie or a veteran.

We've created an official [goose Hacktoberfest 2025 Project Hub](https://github.com/block/goose/issues/4705). This hub will serve as your source of truth for all open `hacktoberfest` labeled-issues and resources you will need throughout the month. It will be updated every week with new issues as we experience contributions, so make sure to bookmark it!

From writing blog posts about goose, fixing bugs, or adding new features, our goal is to give contributors of various practices the chance to contribute to goose! Here are all the categories of issues you can expect to make your impact:

- Feature Requests: Add new features to improve the goose experience
- Bug Fixes: Fix key bugs that have been troubling community members
- Platform Support: Add features and support for goose on platforms like Windows
- Documentation: Support goose guides with contributions to its documentation site
- Recipes: Submit your own goose recipes for community members to bookmark & use
- Prompt Library: Submit your top prompts to goose's library of top prompts
- Content Creation: Create blog posts and videos describing goose and its features

# 📝 Your Guide to goose x Hacktoberfest 2025
To help you make the most of each of your contributions, below is a quick guide on general rules to follow, important resources, how top contributors are tallied, and more below:

## ✅ Key Rules
1. Read the [code of conduct](https://github.com/block/.github/blob/main/CODE_OF_CONDUCT.md).
2. Refer to the [Responsible AI-Assisted Coding Guide](https://github.com/block/goose/blob/main/HOWTOAI.md), [Contributing Guide](https://github.com/block/goose/blob/main/CONTRIBUTING.md) & [README](https://github.com/block/goose/blob/main/README.md) for your contributions.
3. Choose a task from this project's Hacktoberfest [Project Hub](https://github.com/block/goose/issues/4705). Each issue has the 🏷️ `hacktoberfest` label.
4. Comment ".take" on the corresponding issue to get assigned the task.
5. Fork the repository and create a new branch for your work.
6. Make your changes and submit a pull request.
7. Wait for review and address any feedback.

## 🏷️ How To Self-Assign Issues
All issues available for contributions are in the official project hub mentioned earlier.

1. Once you've found an issue that hasn't been claimed, you can pick up any issue labeled `hacktoberfest` by commenting ".take" to assign yourself the issue. (No stealing from others!)
2. Followed any guidance in the issue, along with our AI Assisted and submitted your PR, you can consider your contribution accepted once it has been reviewed, approved, and merged with the label `hacktoberfest-accepted`.
- If your PR is marked as `spam`, `invalid`, or needs more input from you, you need to re-evaluate your contribution. This is to ensure it counts towards Hacktoberfest, and that your PR aligns with the repository's goals.
- Outside of guidelines of a given issue, always make sure your contributions adhere to our code of conduct.

## 🏆 Leaderboard & Prizes
Every hacktoberfest PR and contribution will earn you points on our leaderboard. The Top 20 Contributors with the most points by the end of the month will win special prizes! The leaderboard will auto-update with each contribution, so here's a breakdown of how our ranking system works:

| Weight | Points Awarded | Description |
| -------- | -------- | -------- |
| 🐭 Small     | 5 points     | For smaller issues that take limited time to complete and/or don't require any product knowledge.     |
| 🐰 Medium     | 10 points     | For average issues that take additional time to complete and/or require some product knowledge.     |
| 🐂 Large     | 15 points     | For meaty issues that take a significant amount of time to complete and/or possibly require deep product knowledge.     |

As a special thank you, the team is offering exclusive gift cards for the fresh new goose swag shop along with free LLM credits for our Top 20 contributors:

![goose swag shop](gooseswag.png)

| Place | Prize |
| -------- | -------- |
| 🥇 Top 1-5 Contributors | $100 gift card to goose swag shop + $100 LLM credits     | 
| 🥈 Top 6-10 Contributors | $50 gift card to goose swag shop + $50 LLM credits     | 
| 🥉 Top 11-20 Contributors | $25 LLM credits    | 

You can keep an eye on your progress all month long in our Hacktoberfest 2025 Leaderboard here!

## When You Need Help
When in doubt, don't stress! The goose team is here to help you make the most of your contributions. Here's where to go when you have specific questions:

1. 🆘 Maintainer Help: Connect with the maintainers by commenting on the issue or chat with them directly in the #🎃┃hacktoberfest channel on Discord.
2. 🫶 Community Support: [Join us on Discord](https://discord.gg/goose-oss) to live chat with fellow contributors and get tips for success from participants!
3. 🎙️ Office Hours: Join us every Tuesday at 1pm Eastern Time on [Discord](https://discord.gg/goose-oss) through the month of October to get live-over-voice help with open PRs, questions you may have, and general help. Keep an eye out on the [goose events calendar](https://block.github.io/goose/community/) for future events centered around Hacktoberfest!


Happy hacking and cheers to goose x Hacktoberfest 2025! 🎉



<head>
  <meta property="og:title" content="goose is Celebrating Hacktoberfest 2025!" />
  <meta property="og:type" content="article" />
  <meta property="og:url" content="https://block.github.io/goose/blog/2025-09-26-hacktoberfest2025" />
  <meta property="og:description" content="Explore goose prizes you can earn and contributions you can make during Hacktoberfest 2025" />
  <meta property="og:image" content="https://block.github.io/goose/assets/images/hacktoberfest2025-49342480747ee95fe69415c0f2de26f2.png" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta property="twitter:domain" content="block.github.io/goose" />
  <meta name="twitter:title" content="goose is Celebrating Hacktoberfest 2025!" />
  <meta name="twitter:description" content="Explore goose prizes you can earn and contributions you can make during Hacktoberfest 2025" />
  <meta name="twitter:image" content="https://block.github.io/goose/assets/images/hacktoberfest2025-49342480747ee95fe69415c0f2de26f2.png" />
</head>
