---
title: "5 Boring Tasks I Gave to My AI Agent Today (That Saved Me Hours)"
description: Forget the flashy demos. Here's everyday use cases for AI.
authors:
    - angie
---

![blog cover](everyday-usage-of-ai.png)


Whenever people talk about AI, they highlight the flashiest use cases like fully coded apps built by agents or cinematic video generation. Those things are certainly cool, but most days I'm just delegating mundane tasks to the bots. 

Today, I didn't build an app. I didn't write a screenplay. I just got stuff done.

Here are 5 real, everyday tasks I gave to my AI agent, [Goose](/), that saved me hours. None of them took more than one minute from prompt to result.


<!-- truncate -->

:::info LLM
For all of these, I used Anthropic's Claude 4 Sonnet
:::

## 1️⃣ Summarizing GitHub Activity into Actionable Insights

**Task**

I asked Goose to review all closed GitHub issues across my organization for the month and give me a breakdown. I wanted to see where our time went, how work was distributed, and any patterns or dependencies across projects.

**Result**

In under a minute, Goose gave me a report with productivity metrics, workload distribution, and notable dependencies between issue threads (e.g. one fix blocking another).

This kind of synthesis normally requires me to manually scan a bunch of repos and cross-reference PRs or issue comments. Not today.

**MCPs used** 

- [GitHub](/docs/mcp/github-mcp)


## 2️⃣ Extracting Action Items from a Long Slack Thread

**Task**

You know when a Slack thread starts as a quick brainstorm and somehow grows into a novel? Ours had 169 replies today 😂, and buried in there were some important ideas.

So, I asked Goose to analyze the entire thread and extract a clean list of action items.

**Result**

In one minute, I had a focused to-do list with responsible parties, deadlines (when mentioned), and themes. These takeaways will likely shape our Q3 goals, and when I'm ready, I can even have Goose go create GitHub issues for all of them!

**MCPs used** 

- Slack


## 3️⃣ Creating a Roadmap from Community Feedback

**Task**

Our Goose community is active across GitHub, Slack, and Discord. There's tons of feedback, but it's scattered.
I had Goose pull and analyze open questions, bug reports, feature requests, and discussion threads across all three platforms.

**Results**

A ranked list of the top 10 items we need to address, including a short description of each issue along with the estimated effort of the tasks. This gave us a nice jumpstart on our roadmap planning.

**MCPs used** 

- [GitHub](/docs/mcp/github-mcp)
- Slack
- [Discord](https://github.com/hanweg/mcp-discord)


## 4️⃣ Fixing My CSS Breakpoints (Because I Gave Up)

**Task**

Confession: CSS and I are not friends. After 30 minutes of fighting with breakpoints, spacing, and container widths, I gave the problem to Goose by showing it a screenshot of the page.

**Result**

Goose spotted the issue immediately and rewrote my media query logic as well as some other key CSS I was missing. 


**MCPs used** 

- [Developer](/docs/mcp/developer-mcp)

## 5️⃣ Fixing Broken Links After a Big Doc Restructure

**Task**

I restructured a big internal doc set and needed to update all internal links, reroute old paths, and make sure nothing was broken. 
I handled the restructure manually (it was delicate so I wanted to do it myself), then asked Goose to crawl the doc, find broken or outdated links, fix them and add redirects where needed.

**Result**

No dead ends. No 404s. Just tidy documentation.

**MCP used** 

- [Developer](/docs/mcp/developer-mcp)

---

Most AI posts show off what's possible. I'm focused on what was promised.
The whole point was to offload the tedious stuff so we could focus on the work that actually matters, and that's exactly what I'm using AI for.

What everyday tasks are you delegating to AI agents? Let us know in [Discord](https://discord.gg/goose-oss).


<head>
  <meta property="og:title" content="5 Boring Tasks I Gave to My AI Agent Today (That Saved Me Hours)" />
  <meta property="og:type" content="article" />
  <meta property="og:url" content="https://block.github.io/goose/blog/2025/06/27/everyday-usecases-ai" />
  <meta property="og:description" content="Forget the flashy demos. Here's everyday use cases for AI." />
  <meta property="og:image" content="https://block.github.io/goose/assets/images/everyday-usage-of-ai-69f4444328b28bdc945e5ff9fc92034d.png" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta property="twitter:domain" content="block.github.io/goose" />
  <meta name="twitter:title" content="5 Boring Tasks I Gave to My AI Agent Today (That Saved Me Hours)" />
  <meta name="twitter:description" content="Forget the flashy demos. Here's everyday use cases for AI." />
  <meta name="twitter:image" content="https://block.github.io/goose/assets/images/everyday-usage-of-ai-69f4444328b28bdc945e5ff9fc92034d.png" />
</head>