---
title: "How One Contribution Can Spark Many Wins"
description: "The snowball effect of one contributor's small fixes"
authors: 
    - tania
---

![blog cover](bestcodes.png)

The only way to discover how much of an impact your contributions can make is to submit them and hope for the best. Sometimes, what feels like "just a small fix" can end up reshaping an open source project or inspiring a brand new feature. Here's how one of our top contributors turned a small build fix into important improvements for the goose experience.

<!--truncate-->

## How BestCodes Discovered Goose

[BestCodes (aka William Steele)](https://bestcodes.dev/) first discovered Goose during a [GitHub Open Source Friday livestream](https://www.youtube.com/watch?v=O-zJJN-TkXc&ab_channel=AngieJones) and decided to give it a try. At the time, Goose offered limited support for Windows/Linux (with more work in progress before any official release). Since BestCodes wasn't a Mac user, he wanted to help bring support to Linux. After lots of troubleshooting, he ended up creating [a Debian build fix](https://github.com/block/goose/pull/2070) that finally let him start using Goose on Linux. 

Even though BestCodes wondered if such a small fix was worth sharing, it was this "small" contribution that enabled fellow community members wanting to use Goose on Linux, and gave him momentum for future PRs. His experience is proof that your contribution has a chance to help someone, and you should share it! You never know what curiosity and the open source community can make happen.

## Building Momentum

BestCodes has continued to make Goose better with thoughtful improvements—from [polishing the UI](https://github.com/block/goose/pull/2079) and [refining load states](https://github.com/block/goose/pull/2079), to [fixing subtle bugs](https://github.com/block/goose/pull/2279) that make the Goose experience smoother for everyone. You can check out [BestCodes' contributions on GitHub](https://github.com/block/goose/pulls?q=is%3Apr+is%3Aclosed+author%3AThe-Best-Codes).

Thank you so much for your continued support and contributions, BestCodes! Your work brings us one step closer to a full Goose experience on Windows and Linux.

To show how grateful we are for your contributions, we've granted you the exclusive ✨Top Contributor✨ badge on the Block Open Source Discord! Plus, you'll also be receiving exclusive codename goose swag. 👀🪿

## Become A Top Contributor
Interested in contributing to goose and having your work featured? Whether it's fixing bugs, sharing ideas, or helping others, every contribution from the open source community has the chance to help someone. You can [join the Block Open Source Discord](https://discord.gg/goose-oss) or [get started using codename goose](https://block.github.io/goose/) today.

<head>
  <meta property="og:title" content="How One Contribution Can Spark Many Wins" />
  <meta property="og:type" content="article" />
  <meta property="og:url" content="https://block.github.io/goose/blog/2025/04/22/community-bestcodes" />
  <meta property="og:description" content="The snowball effect of one contributor's fixes" />
  <meta property="og:image" content="https://block.github.io/goose/assets/images/bestcodes-3d6c50de10a2d84def19d515aaea0724.png" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta property="twitter:domain" content="block.github.io/goose" />
  <meta name="twitter:title" content="How One Contribution Can Spark Many Wins" />
  <meta name="twitter:description" content="The snowball effect of one contributor's small fixes" />
  <meta name="twitter:image" content="https://block.github.io/goose/assets/images/bestcodes-3d6c50de10a2d84def19d515aaea0724.png" />
</head>