use crate::kind_src::KindsSrc;

pub const HTML_KINDS_SRC: KindsSrc = KindsSrc {
    punct: &[
        ("<", "L_ANGLE"),
        (">", "R_ANGLE"),
        ("/", "SLASH"),
        ("=", "EQ"),
        ("!", "BANG"),
        ("-", "MINUS"),
        ("<![CDATA[", "CDATA_START"),
        ("]]>", "CDATA_END"),
        ("---", "FENCE"),
        ("{", "L_CURLY"),
        ("}", "R_CURLY"),
        ("{{", "L_DOUBLE_CURLY"),
        ("}}", "R_DOUBLE_CURLY"),
        ("{@", "SV_CURLY_AT"),
        ("{#", "SV_CURLY_HASH"),
        ("{/", "SV_CURLY_SLASH"),
        ("{:", "SV_CURLY_COLON"),
        (",", "COMMA"),
        (":", "COLON"),
        ("@", "AT"),
        (".", "DOT"),
        ("[", "L_BRACKET"),
        ("]", "R_BRACKET"),
        ("#", "HASH"),
    ],
    keywords: &[
        "null", "true", "false", "doctype", "html", "debug", "key", "render", "const", "attach",
        "else", "if",
    ],
    literals: &["HTML_STRING_LITERAL", "HTML_LITERAL"],
    tokens: &[
        "ERROR_TOKEN",
        "NEWLINE",
        "WHITESPACE",
        "IDENT",
        "HTML_IDENT",
        "SVELTE_IDENT",
        "VUE_IDENT",
    ],
    nodes: &[
        "HTML_ROOT",
        "HTML_DIRECTIVE",
        "HTML_SELF_CLOSING_TAG",
        "HTML_ELEMENT",
        "HTML_OPENING_ELEMENT",
        "HTML_CLOSING_ELEMENT",
        "HTML_SELF_CLOSING_ELEMENT",
        "HTML_ATTRIBUTE",
        "HTML_ATTRIBUTE_INITIALIZER_CLAUSE",
        "HTML_STRING",
        "HTML_TAG_NAME",
        "HTML_ATTRIBUTE_NAME",
        "HTML_ELEMENT_LIST",
        "HTML_ATTRIBUTE_LIST",
        "HTML_CONTENT",
        "HTML_EMBEDDED_CONTENT",
        "HTML_CDATA_SECTION",
        "COMMENT",
        "HTML_DOUBLE_TEXT_EXPRESSION",
        "HTML_SINGLE_TEXT_EXPRESSION",
        "HTML_TEXT_EXPRESSION",
        // Astro nodes
        "ASTRO_FRONTMATTER_ELEMENT",
        "ASTRO_EMBEDDED_CONTENT",
        // Svelte nodes
        "SVELTE_DEBUG_BLOCK",
        "SVELTE_KEY_BLOCK",
        "SVELTE_KEY_OPENING_BLOCK",
        "SVELTE_KEY_CLOSING_BLOCK",
        "SVELTE_BINDING_LIST",
        "SVELTE_NAME",
        "SVELTE_RENDER_BLOCK",
        "SVELTE_ATTACH_ATTRIBUTE",
        "SVELTE_HTML_BLOCK",
        "SVELTE_CONST_BLOCK",
        "SVELTE_IF_BLOCK",
        "SVELTE_IF_OPENING_BLOCK",
        "SVELTE_ELSE_IF_CLAUSE_LIST",
        "SVELTE_ELSE_CLAUSE",
        "SVELTE_IF_CLOSING_BLOCK",
        "SVELTE_ELSE_IF_CLAUSE",
        // Vue nodes
        "VUE_DIRECTIVE",
        "VUE_DIRECTIVE_ARGUMENT",
        "VUE_V_BIND_SHORTHAND_DIRECTIVE",
        "VUE_V_ON_SHORTHAND_DIRECTIVE",
        "VUE_V_SLOT_SHORTHAND_DIRECTIVE",
        "VUE_STATIC_ARGUMENT",
        "VUE_DYNAMIC_ARGUMENT",
        "VUE_MODIFIER_LIST",
        "VUE_MODIFIER",
        // Bogus nodes
        "HTML_BOGUS",
        "HTML_BOGUS_ELEMENT",
        "HTML_BOGUS_ATTRIBUTE",
        "HTML_BOGUS_TEXT_EXPRESSION",
        "ASTRO_BOGUS_FRONTMATTER",
        "SVELTE_BOGUS_BLOCK",
        "VUE_BOGUS_DIRECTIVE",
        "VUE_BOGUS_DIRECTIVE_ARGUMENT",
    ],
};
