/// Sorted array of TypeScript DOM builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/dom.ts>
pub const DOM: &[&str] = &[
    "ANGLE_instanced_arrays",
    "ARIAMixin",
    "AbortController",
    "AbortSignal",
    "AbortSignalEventMap",
    "AbstractRange",
    "AbstractWorker",
    "AbstractWorkerEventMap",
    "AddEventListenerOptions",
    "AesCbcParams",
    "AesCtrParams",
    "AesDerivedKeyParams",
    "AesGcmParams",
    "AesKeyAlgorithm",
    "AesKeyGenParams",
    "Algorithm",
    "AlgorithmIdentifier",
    "AlignSetting",
    "AllowSharedBufferSource",
    "AlphaOption",
    "AnalyserNode",
    "AnalyserOptions",
    "Animatable",
    "Animation",
    "AnimationEffect",
    "AnimationEvent",
    "AnimationEventInit",
    "AnimationEventMap",
    "AnimationFrameProvider",
    "AnimationPlayState",
    "AnimationPlaybackEvent",
    "AnimationPlaybackEventInit",
    "AnimationReplaceState",
    "AnimationTimeline",
    "AppendMode",
    "AssignedNodesOptions",
    "AttestationConveyancePreference",
    "Attr",
    "AudioBuffer",
    "AudioBufferOptions",
    "AudioBufferSourceNode",
    "AudioBufferSourceOptions",
    "AudioConfiguration",
    "AudioContext",
    "AudioContextLatencyCategory",
    "AudioContextOptions",
    "AudioContextState",
    "AudioDestinationNode",
    "AudioListener",
    "AudioNode",
    "AudioNodeOptions",
    "AudioParam",
    "AudioParamMap",
    "AudioProcessingEvent",
    "AudioProcessingEventInit",
    "AudioScheduledSourceNode",
    "AudioScheduledSourceNodeEventMap",
    "AudioTimestamp",
    "AudioWorklet",
    "AudioWorkletNode",
    "AudioWorkletNodeEventMap",
    "AudioWorkletNodeOptions",
    "AuthenticationExtensionsClientInputs",
    "AuthenticationExtensionsClientOutputs",
    "AuthenticatorAssertionResponse",
    "AuthenticatorAttachment",
    "AuthenticatorAttestationResponse",
    "AuthenticatorResponse",
    "AuthenticatorSelectionCriteria",
    "AuthenticatorTransport",
    "AutoFill",
    "AutoFillAddressKind",
    "AutoFillBase",
    "AutoFillContactField",
    "AutoFillContactKind",
    "AutoFillCredentialField",
    "AutoFillField",
    "AutoFillNormalField",
    "AutoFillSection",
    "AutoKeyword",
    "AutomationRate",
    "AvcBitstreamFormat",
    "AvcEncoderConfig",
    "BarProp",
    "BaseAudioContext",
    "BaseAudioContextEventMap",
    "BeforeUnloadEvent",
    "BigInteger",
    "BinaryData",
    "BinaryType",
    "BiquadFilterNode",
    "BiquadFilterOptions",
    "BiquadFilterType",
    "Blob",
    "BlobCallback",
    "BlobEvent",
    "BlobEventInit",
    "BlobPart",
    "BlobPropertyBag",
    "Body",
    "BodyInit",
    "BroadcastChannel",
    "BroadcastChannelEventMap",
    "BufferSource",
    "ByteLengthQueuingStrategy",
    "CDATASection",
    "COSEAlgorithmIdentifier",
    "CSS",
    "CSSAnimation",
    "CSSConditionRule",
    "CSSContainerRule",
    "CSSCounterStyleRule",
    "CSSFontFaceRule",
    "CSSFontFeatureValuesRule",
    "CSSFontPaletteValuesRule",
    "CSSGroupingRule",
    "CSSImageValue",
    "CSSImportRule",
    "CSSKeyframeRule",
    "CSSKeyframesRule",
    "CSSKeywordValue",
    "CSSKeywordish",
    "CSSLayerBlockRule",
    "CSSLayerStatementRule",
    "CSSMathClamp",
    "CSSMathInvert",
    "CSSMathMax",
    "CSSMathMin",
    "CSSMathNegate",
    "CSSMathOperator",
    "CSSMathProduct",
    "CSSMathSum",
    "CSSMathValue",
    "CSSMatrixComponent",
    "CSSMatrixComponentOptions",
    "CSSMediaRule",
    "CSSNamespaceRule",
    "CSSNumberish",
    "CSSNumericArray",
    "CSSNumericBaseType",
    "CSSNumericType",
    "CSSNumericValue",
    "CSSPageRule",
    "CSSPerspective",
    "CSSPerspectiveValue",
    "CSSPropertyRule",
    "CSSRotate",
    "CSSRule",
    "CSSRuleList",
    "CSSScale",
    "CSSSkew",
    "CSSSkewX",
    "CSSSkewY",
    "CSSStyleDeclaration",
    "CSSStyleRule",
    "CSSStyleSheet",
    "CSSStyleSheetInit",
    "CSSStyleValue",
    "CSSSupportsRule",
    "CSSTransformComponent",
    "CSSTransformValue",
    "CSSTransition",
    "CSSTranslate",
    "CSSUnitValue",
    "CSSUnparsedSegment",
    "CSSUnparsedValue",
    "CSSVariableReferenceValue",
    "Cache",
    "CacheQueryOptions",
    "CacheStorage",
    "CanPlayTypeResult",
    "CanvasCaptureMediaStreamTrack",
    "CanvasCompositing",
    "CanvasDirection",
    "CanvasDrawImage",
    "CanvasDrawPath",
    "CanvasFillRule",
    "CanvasFillStrokeStyles",
    "CanvasFilters",
    "CanvasFontKerning",
    "CanvasFontStretch",
    "CanvasFontVariantCaps",
    "CanvasGradient",
    "CanvasImageData",
    "CanvasImageSmoothing",
    "CanvasImageSource",
    "CanvasLineCap",
    "CanvasLineJoin",
    "CanvasPath",
    "CanvasPathDrawingStyles",
    "CanvasPattern",
    "CanvasRect",
    "CanvasRenderingContext2D",
    "CanvasRenderingContext2DSettings",
    "CanvasShadowStyles",
    "CanvasState",
    "CanvasText",
    "CanvasTextAlign",
    "CanvasTextBaseline",
    "CanvasTextDrawingStyles",
    "CanvasTextRendering",
    "CanvasTransform",
    "CanvasUserInterface",
    "ChannelCountMode",
    "ChannelInterpretation",
    "ChannelMergerNode",
    "ChannelMergerOptions",
    "ChannelSplitterNode",
    "ChannelSplitterOptions",
    "CharacterData",
    "CheckVisibilityOptions",
    "ChildNode",
    "ClientQueryOptions",
    "ClientRect",
    "ClientTypes",
    "Clipboard",
    "ClipboardEvent",
    "ClipboardEventInit",
    "ClipboardItem",
    "ClipboardItemData",
    "ClipboardItemOptions",
    "ClipboardItems",
    "CloseEvent",
    "CloseEventInit",
    "CodecState",
    "ColorGamut",
    "ColorSpaceConversion",
    "Comment",
    "CompositeOperation",
    "CompositeOperationOrAuto",
    "CompositionEvent",
    "CompositionEventInit",
    "CompressionFormat",
    "CompressionStream",
    "ComputedEffectTiming",
    "ComputedKeyframe",
    "Console",
    "ConstantSourceNode",
    "ConstantSourceOptions",
    "ConstrainBoolean",
    "ConstrainBooleanParameters",
    "ConstrainDOMString",
    "ConstrainDOMStringParameters",
    "ConstrainDouble",
    "ConstrainDoubleRange",
    "ConstrainULong",
    "ConstrainULongRange",
    "ConvolverNode",
    "ConvolverOptions",
    "CountQueuingStrategy",
    "Credential",
    "CredentialCreationOptions",
    "CredentialMediationRequirement",
    "CredentialPropertiesOutput",
    "CredentialRequestOptions",
    "CredentialsContainer",
    "Crypto",
    "CryptoKey",
    "CryptoKeyPair",
    "CustomElementConstructor",
    "CustomElementRegistry",
    "CustomEvent",
    "CustomEventInit",
    "DOMException",
    "DOMHighResTimeStamp",
    "DOMImplementation",
    "DOMMatrix",
    "DOMMatrix2DInit",
    "DOMMatrixInit",
    "DOMMatrixReadOnly",
    "DOMParser",
    "DOMParserSupportedType",
    "DOMPoint",
    "DOMPointInit",
    "DOMPointReadOnly",
    "DOMQuad",
    "DOMQuadInit",
    "DOMRect",
    "DOMRectInit",
    "DOMRectList",
    "DOMRectReadOnly",
    "DOMStringList",
    "DOMStringMap",
    "DOMTokenList",
    "DataTransfer",
    "DataTransferItem",
    "DataTransferItemList",
    "DecodeErrorCallback",
    "DecodeSuccessCallback",
    "DecompressionStream",
    "DelayNode",
    "DelayOptions",
    "DeviceMotionEvent",
    "DeviceMotionEventAcceleration",
    "DeviceMotionEventAccelerationInit",
    "DeviceMotionEventInit",
    "DeviceMotionEventRotationRate",
    "DeviceMotionEventRotationRateInit",
    "DeviceOrientationEvent",
    "DeviceOrientationEventInit",
    "DirectionSetting",
    "DisplayCaptureSurfaceType",
    "DisplayMediaStreamOptions",
    "DistanceModelType",
    "Document",
    "DocumentEventMap",
    "DocumentFragment",
    "DocumentOrShadowRoot",
    "DocumentReadyState",
    "DocumentTimeline",
    "DocumentTimelineOptions",
    "DocumentType",
    "DocumentVisibilityState",
    "DoubleRange",
    "DragEvent",
    "DragEventInit",
    "DynamicsCompressorNode",
    "DynamicsCompressorOptions",
    "EXT_blend_minmax",
    "EXT_color_buffer_float",
    "EXT_color_buffer_half_float",
    "EXT_float_blend",
    "EXT_frag_depth",
    "EXT_sRGB",
    "EXT_shader_texture_lod",
    "EXT_texture_compression_bptc",
    "EXT_texture_compression_rgtc",
    "EXT_texture_filter_anisotropic",
    "EXT_texture_norm16",
    "EcKeyAlgorithm",
    "EcKeyGenParams",
    "EcKeyImportParams",
    "EcdhKeyDeriveParams",
    "EcdsaParams",
    "EffectTiming",
    "Element",
    "ElementCSSInlineStyle",
    "ElementContentEditable",
    "ElementCreationOptions",
    "ElementDefinitionOptions",
    "ElementEventMap",
    "ElementInternals",
    "ElementTagNameMap",
    "EncodedVideoChunk",
    "EncodedVideoChunkInit",
    "EncodedVideoChunkMetadata",
    "EncodedVideoChunkOutputCallback",
    "EncodedVideoChunkType",
    "EndOfStreamError",
    "EndingType",
    "EpochTimeStamp",
    "ErrorCallback",
    "ErrorEvent",
    "ErrorEventInit",
    "Event",
    "EventCounts",
    "EventInit",
    "EventListener",
    "EventListenerObject",
    "EventListenerOptions",
    "EventListenerOrEventListenerObject",
    "EventModifierInit",
    "EventSource",
    "EventSourceEventMap",
    "EventSourceInit",
    "EventTarget",
    "External",
    "File",
    "FileCallback",
    "FileList",
    "FilePropertyBag",
    "FileReader",
    "FileReaderEventMap",
    "FileSystem",
    "FileSystemCreateWritableOptions",
    "FileSystemDirectoryEntry",
    "FileSystemDirectoryHandle",
    "FileSystemDirectoryReader",
    "FileSystemEntriesCallback",
    "FileSystemEntry",
    "FileSystemEntryCallback",
    "FileSystemFileEntry",
    "FileSystemFileHandle",
    "FileSystemFlags",
    "FileSystemGetDirectoryOptions",
    "FileSystemGetFileOptions",
    "FileSystemHandle",
    "FileSystemHandleKind",
    "FileSystemRemoveOptions",
    "FileSystemWritableFileStream",
    "FileSystemWriteChunkType",
    "FillMode",
    "Float32List",
    "FocusEvent",
    "FocusEventInit",
    "FocusOptions",
    "FontDisplay",
    "FontFace",
    "FontFaceDescriptors",
    "FontFaceLoadStatus",
    "FontFaceSet",
    "FontFaceSetEventMap",
    "FontFaceSetLoadEvent",
    "FontFaceSetLoadEventInit",
    "FontFaceSetLoadStatus",
    "FontFaceSource",
    "FormData",
    "FormDataEntryValue",
    "FormDataEvent",
    "FormDataEventInit",
    "FrameRequestCallback",
    "FullscreenNavigationUI",
    "FullscreenOptions",
    "FunctionStringCallback",
    "GLbitfield",
    "GLboolean",
    "GLclampf",
    "GLenum",
    "GLfloat",
    "GLint",
    "GLint64",
    "GLintptr",
    "GLsizei",
    "GLsizeiptr",
    "GLuint",
    "GLuint64",
    "GainNode",
    "GainOptions",
    "Gamepad",
    "GamepadButton",
    "GamepadEffectParameters",
    "GamepadEvent",
    "GamepadEventInit",
    "GamepadHapticActuator",
    "GamepadHapticActuatorType",
    "GamepadHapticEffectType",
    "GamepadHapticsResult",
    "GamepadMappingType",
    "GenericTransformStream",
    "Geolocation",
    "GeolocationCoordinates",
    "GeolocationPosition",
    "GeolocationPositionError",
    "GetAnimationsOptions",
    "GetNotificationOptions",
    "GetRootNodeOptions",
    "GlobalCompositeOperation",
    "GlobalEventHandlers",
    "GlobalEventHandlersEventMap",
    "HTMLAllCollection",
    "HTMLAnchorElement",
    "HTMLAreaElement",
    "HTMLAudioElement",
    "HTMLBRElement",
    "HTMLBaseElement",
    "HTMLBodyElement",
    "HTMLBodyElementEventMap",
    "HTMLButtonElement",
    "HTMLCanvasElement",
    "HTMLCollection",
    "HTMLCollectionBase",
    "HTMLCollectionOf",
    "HTMLDListElement",
    "HTMLDataElement",
    "HTMLDataListElement",
    "HTMLDetailsElement",
    "HTMLDialogElement",
    "HTMLDirectoryElement",
    "HTMLDivElement",
    "HTMLDocument",
    "HTMLElement",
    "HTMLElementDeprecatedTagNameMap",
    "HTMLElementEventMap",
    "HTMLElementTagNameMap",
    "HTMLEmbedElement",
    "HTMLFieldSetElement",
    "HTMLFontElement",
    "HTMLFormControlsCollection",
    "HTMLFormElement",
    "HTMLFrameElement",
    "HTMLFrameSetElement",
    "HTMLFrameSetElementEventMap",
    "HTMLHRElement",
    "HTMLHeadElement",
    "HTMLHeadingElement",
    "HTMLHtmlElement",
    "HTMLHyperlinkElementUtils",
    "HTMLIFrameElement",
    "HTMLImageElement",
    "HTMLInputElement",
    "HTMLLIElement",
    "HTMLLabelElement",
    "HTMLLegendElement",
    "HTMLLinkElement",
    "HTMLMapElement",
    "HTMLMarqueeElement",
    "HTMLMediaElement",
    "HTMLMediaElementEventMap",
    "HTMLMenuElement",
    "HTMLMetaElement",
    "HTMLMeterElement",
    "HTMLModElement",
    "HTMLOListElement",
    "HTMLObjectElement",
    "HTMLOptGroupElement",
    "HTMLOptionElement",
    "HTMLOptionsCollection",
    "HTMLOrSVGElement",
    "HTMLOrSVGImageElement",
    "HTMLOrSVGScriptElement",
    "HTMLOutputElement",
    "HTMLParagraphElement",
    "HTMLParamElement",
    "HTMLPictureElement",
    "HTMLPreElement",
    "HTMLProgressElement",
    "HTMLQuoteElement",
    "HTMLScriptElement",
    "HTMLSelectElement",
    "HTMLSlotElement",
    "HTMLSourceElement",
    "HTMLSpanElement",
    "HTMLStyleElement",
    "HTMLTableCaptionElement",
    "HTMLTableCellElement",
    "HTMLTableColElement",
    "HTMLTableDataCellElement",
    "HTMLTableElement",
    "HTMLTableHeaderCellElement",
    "HTMLTableRowElement",
    "HTMLTableSectionElement",
    "HTMLTemplateElement",
    "HTMLTextAreaElement",
    "HTMLTimeElement",
    "HTMLTitleElement",
    "HTMLTrackElement",
    "HTMLUListElement",
    "HTMLUnknownElement",
    "HTMLVideoElement",
    "HTMLVideoElementEventMap",
    "HardwareAcceleration",
    "HashAlgorithmIdentifier",
    "HashChangeEvent",
    "HashChangeEventInit",
    "HdrMetadataType",
    "Headers",
    "HeadersInit",
    "Highlight",
    "HighlightRegistry",
    "HighlightType",
    "History",
    "HkdfParams",
    "HmacImportParams",
    "HmacKeyAlgorithm",
    "HmacKeyGenParams",
    "IDBCursor",
    "IDBCursorDirection",
    "IDBCursorWithValue",
    "IDBDatabase",
    "IDBDatabaseEventMap",
    "IDBDatabaseInfo",
    "IDBFactory",
    "IDBIndex",
    "IDBIndexParameters",
    "IDBKeyRange",
    "IDBObjectStore",
    "IDBObjectStoreParameters",
    "IDBOpenDBRequest",
    "IDBOpenDBRequestEventMap",
    "IDBRequest",
    "IDBRequestEventMap",
    "IDBRequestReadyState",
    "IDBTransaction",
    "IDBTransactionDurability",
    "IDBTransactionEventMap",
    "IDBTransactionMode",
    "IDBTransactionOptions",
    "IDBValidKey",
    "IDBVersionChangeEvent",
    "IDBVersionChangeEventInit",
    "IIRFilterNode",
    "IIRFilterOptions",
    "IdleDeadline",
    "IdleRequestCallback",
    "IdleRequestOptions",
    "ImageBitmap",
    "ImageBitmapOptions",
    "ImageBitmapRenderingContext",
    "ImageBitmapRenderingContextSettings",
    "ImageBitmapSource",
    "ImageData",
    "ImageDataSettings",
    "ImageEncodeOptions",
    "ImageOrientation",
    "ImageSmoothingQuality",
    "ImportMeta",
    "InnerHTML",
    "InputDeviceInfo",
    "InputEvent",
    "InputEventInit",
    "InsertPosition",
    "Int32List",
    "IntersectionObserver",
    "IntersectionObserverCallback",
    "IntersectionObserverEntry",
    "IntersectionObserverEntryInit",
    "IntersectionObserverInit",
    "IterationCompositeOperation",
    "JsonWebKey",
    "KHR_parallel_shader_compile",
    "KeyAlgorithm",
    "KeyFormat",
    "KeyType",
    "KeyUsage",
    "KeyboardEvent",
    "KeyboardEventInit",
    "Keyframe",
    "KeyframeAnimationOptions",
    "KeyframeEffect",
    "KeyframeEffectOptions",
    "LargestContentfulPaint",
    "LatencyMode",
    "LineAlignSetting",
    "LineAndPositionSetting",
    "LinkStyle",
    "Location",
    "Lock",
    "LockGrantedCallback",
    "LockInfo",
    "LockManager",
    "LockManagerSnapshot",
    "LockMode",
    "LockOptions",
    "MIDIAccess",
    "MIDIAccessEventMap",
    "MIDIConnectionEvent",
    "MIDIConnectionEventInit",
    "MIDIInput",
    "MIDIInputEventMap",
    "MIDIInputMap",
    "MIDIMessageEvent",
    "MIDIMessageEventInit",
    "MIDIOptions",
    "MIDIOutput",
    "MIDIOutputMap",
    "MIDIPort",
    "MIDIPortConnectionState",
    "MIDIPortDeviceState",
    "MIDIPortEventMap",
    "MIDIPortType",
    "MathMLElement",
    "MathMLElementEventMap",
    "MathMLElementTagNameMap",
    "MediaCapabilities",
    "MediaCapabilitiesDecodingInfo",
    "MediaCapabilitiesEncodingInfo",
    "MediaCapabilitiesInfo",
    "MediaConfiguration",
    "MediaDecodingConfiguration",
    "MediaDecodingType",
    "MediaDeviceInfo",
    "MediaDeviceKind",
    "MediaDevices",
    "MediaDevicesEventMap",
    "MediaElementAudioSourceNode",
    "MediaElementAudioSourceOptions",
    "MediaEncodingConfiguration",
    "MediaEncodingType",
    "MediaEncryptedEvent",
    "MediaEncryptedEventInit",
    "MediaError",
    "MediaImage",
    "MediaKeyMessageEvent",
    "MediaKeyMessageEventInit",
    "MediaKeyMessageType",
    "MediaKeySession",
    "MediaKeySessionClosedReason",
    "MediaKeySessionEventMap",
    "MediaKeySessionType",
    "MediaKeyStatus",
    "MediaKeyStatusMap",
    "MediaKeySystemAccess",
    "MediaKeySystemConfiguration",
    "MediaKeySystemMediaCapability",
    "MediaKeys",
    "MediaKeysRequirement",
    "MediaList",
    "MediaMetadata",
    "MediaMetadataInit",
    "MediaPositionState",
    "MediaProvider",
    "MediaQueryList",
    "MediaQueryListEvent",
    "MediaQueryListEventInit",
    "MediaQueryListEventMap",
    "MediaRecorder",
    "MediaRecorderEventMap",
    "MediaRecorderOptions",
    "MediaSession",
    "MediaSessionAction",
    "MediaSessionActionDetails",
    "MediaSessionActionHandler",
    "MediaSessionPlaybackState",
    "MediaSource",
    "MediaSourceEventMap",
    "MediaStream",
    "MediaStreamAudioDestinationNode",
    "MediaStreamAudioSourceNode",
    "MediaStreamAudioSourceOptions",
    "MediaStreamConstraints",
    "MediaStreamEventMap",
    "MediaStreamTrack",
    "MediaStreamTrackEvent",
    "MediaStreamTrackEventInit",
    "MediaStreamTrackEventMap",
    "MediaStreamTrackState",
    "MediaTrackCapabilities",
    "MediaTrackConstraintSet",
    "MediaTrackConstraints",
    "MediaTrackSettings",
    "MediaTrackSupportedConstraints",
    "MessageChannel",
    "MessageEvent",
    "MessageEventInit",
    "MessageEventSource",
    "MessagePort",
    "MessagePortEventMap",
    "MimeType",
    "MimeTypeArray",
    "MouseEvent",
    "MouseEventInit",
    "MultiCacheQueryOptions",
    "MutationCallback",
    "MutationEvent",
    "MutationObserver",
    "MutationObserverInit",
    "MutationRecord",
    "MutationRecordType",
    "NamedCurve",
    "NamedNodeMap",
    "NavigationPreloadManager",
    "NavigationPreloadState",
    "NavigationTimingType",
    "Navigator",
    "NavigatorAutomationInformation",
    "NavigatorBadge",
    "NavigatorConcurrentHardware",
    "NavigatorContentUtils",
    "NavigatorCookies",
    "NavigatorID",
    "NavigatorLanguage",
    "NavigatorLocks",
    "NavigatorOnLine",
    "NavigatorPlugins",
    "NavigatorStorage",
    "Node",
    "NodeFilter",
    "NodeIterator",
    "NodeList",
    "NodeListOf",
    "NonDocumentTypeChildNode",
    "NonElementParentNode",
    "Notification",
    "NotificationDirection",
    "NotificationEventMap",
    "NotificationOptions",
    "NotificationPermission",
    "NotificationPermissionCallback",
    "OES_draw_buffers_indexed",
    "OES_element_index_uint",
    "OES_fbo_render_mipmap",
    "OES_standard_derivatives",
    "OES_texture_float",
    "OES_texture_float_linear",
    "OES_texture_half_float",
    "OES_texture_half_float_linear",
    "OES_vertex_array_object",
    "OVR_multiview2",
    "OfflineAudioCompletionEvent",
    "OfflineAudioCompletionEventInit",
    "OfflineAudioContext",
    "OfflineAudioContextEventMap",
    "OfflineAudioContextOptions",
    "OffscreenCanvas",
    "OffscreenCanvasEventMap",
    "OffscreenCanvasRenderingContext2D",
    "OffscreenRenderingContext",
    "OffscreenRenderingContextId",
    "OnBeforeUnloadEventHandler",
    "OnBeforeUnloadEventHandlerNonNull",
    "OnErrorEventHandler",
    "OnErrorEventHandlerNonNull",
    "OptionalEffectTiming",
    "OptionalPostfixToken",
    "OptionalPrefixToken",
    "OrientationType",
    "OscillatorNode",
    "OscillatorOptions",
    "OscillatorType",
    "OverSampleType",
    "OverconstrainedError",
    "PageTransitionEvent",
    "PageTransitionEventInit",
    "PannerNode",
    "PannerOptions",
    "PanningModelType",
    "ParentNode",
    "Path2D",
    "PaymentComplete",
    "PaymentCurrencyAmount",
    "PaymentDetailsBase",
    "PaymentDetailsInit",
    "PaymentDetailsModifier",
    "PaymentDetailsUpdate",
    "PaymentItem",
    "PaymentMethodChangeEvent",
    "PaymentMethodChangeEventInit",
    "PaymentMethodData",
    "PaymentRequest",
    "PaymentRequestEventMap",
    "PaymentRequestUpdateEvent",
    "PaymentRequestUpdateEventInit",
    "PaymentResponse",
    "PaymentValidationErrors",
    "Pbkdf2Params",
    "Performance",
    "PerformanceEntry",
    "PerformanceEntryList",
    "PerformanceEventMap",
    "PerformanceEventTiming",
    "PerformanceMark",
    "PerformanceMarkOptions",
    "PerformanceMeasure",
    "PerformanceMeasureOptions",
    "PerformanceNavigation",
    "PerformanceNavigationTiming",
    "PerformanceObserver",
    "PerformanceObserverCallback",
    "PerformanceObserverEntryList",
    "PerformanceObserverInit",
    "PerformancePaintTiming",
    "PerformanceResourceTiming",
    "PerformanceServerTiming",
    "PerformanceTiming",
    "PeriodicWave",
    "PeriodicWaveConstraints",
    "PeriodicWaveOptions",
    "PermissionDescriptor",
    "PermissionName",
    "PermissionState",
    "PermissionStatus",
    "PermissionStatusEventMap",
    "Permissions",
    "PictureInPictureEvent",
    "PictureInPictureEventInit",
    "PictureInPictureWindow",
    "PictureInPictureWindowEventMap",
    "PlaneLayout",
    "PlaybackDirection",
    "Plugin",
    "PluginArray",
    "PointerEvent",
    "PointerEventInit",
    "PopStateEvent",
    "PopStateEventInit",
    "PopoverInvokerElement",
    "PositionAlignSetting",
    "PositionCallback",
    "PositionErrorCallback",
    "PositionOptions",
    "PredefinedColorSpace",
    "PremultiplyAlpha",
    "PresentationStyle",
    "ProcessingInstruction",
    "ProgressEvent",
    "ProgressEventInit",
    "PromiseRejectionEvent",
    "PromiseRejectionEventInit",
    "PropertyDefinition",
    "PropertyIndexedKeyframes",
    "PublicKeyCredential",
    "PublicKeyCredentialCreationOptions",
    "PublicKeyCredentialDescriptor",
    "PublicKeyCredentialEntity",
    "PublicKeyCredentialParameters",
    "PublicKeyCredentialRequestOptions",
    "PublicKeyCredentialRpEntity",
    "PublicKeyCredentialType",
    "PublicKeyCredentialUserEntity",
    "PushEncryptionKeyName",
    "PushManager",
    "PushSubscription",
    "PushSubscriptionJSON",
    "PushSubscriptionOptions",
    "PushSubscriptionOptionsInit",
    "QueuingStrategy",
    "QueuingStrategyInit",
    "QueuingStrategySize",
    "RTCAnswerOptions",
    "RTCBundlePolicy",
    "RTCCertificate",
    "RTCCertificateExpiration",
    "RTCConfiguration",
    "RTCDTMFSender",
    "RTCDTMFSenderEventMap",
    "RTCDTMFToneChangeEvent",
    "RTCDTMFToneChangeEventInit",
    "RTCDataChannel",
    "RTCDataChannelEvent",
    "RTCDataChannelEventInit",
    "RTCDataChannelEventMap",
    "RTCDataChannelInit",
    "RTCDataChannelState",
    "RTCDegradationPreference",
    "RTCDtlsFingerprint",
    "RTCDtlsTransport",
    "RTCDtlsTransportEventMap",
    "RTCDtlsTransportState",
    "RTCEncodedAudioFrame",
    "RTCEncodedAudioFrameMetadata",
    "RTCEncodedVideoFrame",
    "RTCEncodedVideoFrameMetadata",
    "RTCEncodedVideoFrameType",
    "RTCError",
    "RTCErrorDetailType",
    "RTCErrorEvent",
    "RTCErrorEventInit",
    "RTCErrorInit",
    "RTCIceCandidate",
    "RTCIceCandidateInit",
    "RTCIceCandidatePair",
    "RTCIceCandidatePairStats",
    "RTCIceCandidateType",
    "RTCIceComponent",
    "RTCIceConnectionState",
    "RTCIceGathererState",
    "RTCIceGatheringState",
    "RTCIceProtocol",
    "RTCIceServer",
    "RTCIceTcpCandidateType",
    "RTCIceTransport",
    "RTCIceTransportEventMap",
    "RTCIceTransportPolicy",
    "RTCIceTransportState",
    "RTCInboundRtpStreamStats",
    "RTCLocalSessionDescriptionInit",
    "RTCOfferAnswerOptions",
    "RTCOfferOptions",
    "RTCOutboundRtpStreamStats",
    "RTCPeerConnection",
    "RTCPeerConnectionErrorCallback",
    "RTCPeerConnectionEventMap",
    "RTCPeerConnectionIceErrorEvent",
    "RTCPeerConnectionIceErrorEventInit",
    "RTCPeerConnectionIceEvent",
    "RTCPeerConnectionIceEventInit",
    "RTCPeerConnectionState",
    "RTCPriorityType",
    "RTCReceivedRtpStreamStats",
    "RTCRtcpMuxPolicy",
    "RTCRtcpParameters",
    "RTCRtpCapabilities",
    "RTCRtpCodec",
    "RTCRtpCodecCapability",
    "RTCRtpCodecParameters",
    "RTCRtpCodingParameters",
    "RTCRtpContributingSource",
    "RTCRtpEncodingParameters",
    "RTCRtpHeaderExtensionCapability",
    "RTCRtpHeaderExtensionParameters",
    "RTCRtpParameters",
    "RTCRtpReceiveParameters",
    "RTCRtpReceiver",
    "RTCRtpScriptTransform",
    "RTCRtpSendParameters",
    "RTCRtpSender",
    "RTCRtpStreamStats",
    "RTCRtpSynchronizationSource",
    "RTCRtpTransceiver",
    "RTCRtpTransceiverDirection",
    "RTCRtpTransceiverInit",
    "RTCRtpTransform",
    "RTCSctpTransport",
    "RTCSctpTransportEventMap",
    "RTCSctpTransportState",
    "RTCSdpType",
    "RTCSentRtpStreamStats",
    "RTCSessionDescription",
    "RTCSessionDescriptionCallback",
    "RTCSessionDescriptionInit",
    "RTCSetParameterOptions",
    "RTCSignalingState",
    "RTCStats",
    "RTCStatsIceCandidatePairState",
    "RTCStatsReport",
    "RTCStatsType",
    "RTCTrackEvent",
    "RTCTrackEventInit",
    "RTCTransportStats",
    "RadioNodeList",
    "Range",
    "ReadableByteStreamController",
    "ReadableStream",
    "ReadableStreamBYOBReader",
    "ReadableStreamBYOBRequest",
    "ReadableStreamController",
    "ReadableStreamDefaultController",
    "ReadableStreamDefaultReader",
    "ReadableStreamGenericReader",
    "ReadableStreamGetReaderOptions",
    "ReadableStreamReadDoneResult",
    "ReadableStreamReadResult",
    "ReadableStreamReadValueResult",
    "ReadableStreamReader",
    "ReadableStreamReaderMode",
    "ReadableStreamType",
    "ReadableWritablePair",
    "ReadyState",
    "RecordingState",
    "ReferrerPolicy",
    "RegistrationOptions",
    "RemotePlayback",
    "RemotePlaybackAvailabilityCallback",
    "RemotePlaybackEventMap",
    "RemotePlaybackState",
    "RenderingContext",
    "Report",
    "ReportBody",
    "ReportList",
    "ReportingObserver",
    "ReportingObserverCallback",
    "ReportingObserverOptions",
    "Request",
    "RequestCache",
    "RequestCredentials",
    "RequestDestination",
    "RequestInfo",
    "RequestInit",
    "RequestMode",
    "RequestPriority",
    "RequestRedirect",
    "ResidentKeyRequirement",
    "ResizeObserver",
    "ResizeObserverBoxOptions",
    "ResizeObserverCallback",
    "ResizeObserverEntry",
    "ResizeObserverOptions",
    "ResizeObserverSize",
    "ResizeQuality",
    "Response",
    "ResponseInit",
    "ResponseType",
    "RsaHashedImportParams",
    "RsaHashedKeyAlgorithm",
    "RsaHashedKeyGenParams",
    "RsaKeyAlgorithm",
    "RsaKeyGenParams",
    "RsaOaepParams",
    "RsaOtherPrimesInfo",
    "RsaPssParams",
    "SVGAElement",
    "SVGAngle",
    "SVGAnimateElement",
    "SVGAnimateMotionElement",
    "SVGAnimateTransformElement",
    "SVGAnimatedAngle",
    "SVGAnimatedBoolean",
    "SVGAnimatedEnumeration",
    "SVGAnimatedInteger",
    "SVGAnimatedLength",
    "SVGAnimatedLengthList",
    "SVGAnimatedNumber",
    "SVGAnimatedNumberList",
    "SVGAnimatedPoints",
    "SVGAnimatedPreserveAspectRatio",
    "SVGAnimatedRect",
    "SVGAnimatedString",
    "SVGAnimatedTransformList",
    "SVGAnimationElement",
    "SVGBoundingBoxOptions",
    "SVGCircleElement",
    "SVGClipPathElement",
    "SVGComponentTransferFunctionElement",
    "SVGDefsElement",
    "SVGDescElement",
    "SVGElement",
    "SVGElementEventMap",
    "SVGElementTagNameMap",
    "SVGEllipseElement",
    "SVGFEBlendElement",
    "SVGFEColorMatrixElement",
    "SVGFEComponentTransferElement",
    "SVGFECompositeElement",
    "SVGFEConvolveMatrixElement",
    "SVGFEDiffuseLightingElement",
    "SVGFEDisplacementMapElement",
    "SVGFEDistantLightElement",
    "SVGFEDropShadowElement",
    "SVGFEFloodElement",
    "SVGFEFuncAElement",
    "SVGFEFuncBElement",
    "SVGFEFuncGElement",
    "SVGFEFuncRElement",
    "SVGFEGaussianBlurElement",
    "SVGFEImageElement",
    "SVGFEMergeElement",
    "SVGFEMergeNodeElement",
    "SVGFEMorphologyElement",
    "SVGFEOffsetElement",
    "SVGFEPointLightElement",
    "SVGFESpecularLightingElement",
    "SVGFESpotLightElement",
    "SVGFETileElement",
    "SVGFETurbulenceElement",
    "SVGFilterElement",
    "SVGFilterPrimitiveStandardAttributes",
    "SVGFitToViewBox",
    "SVGForeignObjectElement",
    "SVGGElement",
    "SVGGeometryElement",
    "SVGGradientElement",
    "SVGGraphicsElement",
    "SVGImageElement",
    "SVGLength",
    "SVGLengthList",
    "SVGLineElement",
    "SVGLinearGradientElement",
    "SVGMPathElement",
    "SVGMarkerElement",
    "SVGMaskElement",
    "SVGMatrix",
    "SVGMetadataElement",
    "SVGNumber",
    "SVGNumberList",
    "SVGPathElement",
    "SVGPatternElement",
    "SVGPoint",
    "SVGPointList",
    "SVGPolygonElement",
    "SVGPolylineElement",
    "SVGPreserveAspectRatio",
    "SVGRadialGradientElement",
    "SVGRect",
    "SVGRectElement",
    "SVGSVGElement",
    "SVGSVGElementEventMap",
    "SVGScriptElement",
    "SVGSetElement",
    "SVGStopElement",
    "SVGStringList",
    "SVGStyleElement",
    "SVGSwitchElement",
    "SVGSymbolElement",
    "SVGTSpanElement",
    "SVGTests",
    "SVGTextContentElement",
    "SVGTextElement",
    "SVGTextPathElement",
    "SVGTextPositioningElement",
    "SVGTitleElement",
    "SVGTransform",
    "SVGTransformList",
    "SVGURIReference",
    "SVGUnitTypes",
    "SVGUseElement",
    "SVGViewElement",
    "Screen",
    "ScreenOrientation",
    "ScreenOrientationEventMap",
    "ScriptProcessorNode",
    "ScriptProcessorNodeEventMap",
    "ScrollBehavior",
    "ScrollIntoViewOptions",
    "ScrollLogicalPosition",
    "ScrollOptions",
    "ScrollRestoration",
    "ScrollSetting",
    "ScrollToOptions",
    "SecurityPolicyViolationEvent",
    "SecurityPolicyViolationEventDisposition",
    "SecurityPolicyViolationEventInit",
    "Selection",
    "SelectionMode",
    "ServiceWorker",
    "ServiceWorkerContainer",
    "ServiceWorkerContainerEventMap",
    "ServiceWorkerEventMap",
    "ServiceWorkerRegistration",
    "ServiceWorkerRegistrationEventMap",
    "ServiceWorkerState",
    "ServiceWorkerUpdateViaCache",
    "ShadowRoot",
    "ShadowRootEventMap",
    "ShadowRootInit",
    "ShadowRootMode",
    "ShareData",
    "SharedWorker",
    "SlotAssignmentMode",
    "Slottable",
    "SourceBuffer",
    "SourceBufferEventMap",
    "SourceBufferList",
    "SourceBufferListEventMap",
    "SpeechRecognitionAlternative",
    "SpeechRecognitionResult",
    "SpeechRecognitionResultList",
    "SpeechSynthesis",
    "SpeechSynthesisErrorCode",
    "SpeechSynthesisErrorEvent",
    "SpeechSynthesisErrorEventInit",
    "SpeechSynthesisEvent",
    "SpeechSynthesisEventInit",
    "SpeechSynthesisEventMap",
    "SpeechSynthesisUtterance",
    "SpeechSynthesisUtteranceEventMap",
    "SpeechSynthesisVoice",
    "StaticRange",
    "StaticRangeInit",
    "StereoPannerNode",
    "StereoPannerOptions",
    "Storage",
    "StorageEstimate",
    "StorageEvent",
    "StorageEventInit",
    "StorageManager",
    "StreamPipeOptions",
    "StructuredSerializeOptions",
    "StyleMedia",
    "StylePropertyMap",
    "StylePropertyMapReadOnly",
    "StyleSheet",
    "StyleSheetList",
    "SubmitEvent",
    "SubmitEventInit",
    "SubtleCrypto",
    "TexImageSource",
    "Text",
    "TextDecodeOptions",
    "TextDecoder",
    "TextDecoderCommon",
    "TextDecoderOptions",
    "TextDecoderStream",
    "TextEncoder",
    "TextEncoderCommon",
    "TextEncoderEncodeIntoResult",
    "TextEncoderStream",
    "TextMetrics",
    "TextTrack",
    "TextTrackCue",
    "TextTrackCueEventMap",
    "TextTrackCueList",
    "TextTrackEventMap",
    "TextTrackKind",
    "TextTrackList",
    "TextTrackListEventMap",
    "TextTrackMode",
    "TimeRanges",
    "TimerHandler",
    "ToggleEvent",
    "ToggleEventInit",
    "Touch",
    "TouchEvent",
    "TouchEventInit",
    "TouchInit",
    "TouchList",
    "TouchType",
    "TrackEvent",
    "TrackEventInit",
    "TransferFunction",
    "Transferable",
    "TransformStream",
    "TransformStreamDefaultController",
    "Transformer",
    "TransformerFlushCallback",
    "TransformerStartCallback",
    "TransformerTransformCallback",
    "TransitionEvent",
    "TransitionEventInit",
    "TreeWalker",
    "UIEvent",
    "UIEventInit",
    "ULongRange",
    "URL",
    "URLSearchParams",
    "Uint32List",
    "UnderlyingByteSource",
    "UnderlyingDefaultSource",
    "UnderlyingSink",
    "UnderlyingSinkAbortCallback",
    "UnderlyingSinkCloseCallback",
    "UnderlyingSinkStartCallback",
    "UnderlyingSinkWriteCallback",
    "UnderlyingSource",
    "UnderlyingSourceCancelCallback",
    "UnderlyingSourcePullCallback",
    "UnderlyingSourceStartCallback",
    "UserActivation",
    "UserVerificationRequirement",
    "VTTCue",
    "VTTRegion",
    "ValidityState",
    "ValidityStateFlags",
    "VibratePattern",
    "VideoColorPrimaries",
    "VideoColorSpace",
    "VideoColorSpaceInit",
    "VideoConfiguration",
    "VideoDecoder",
    "VideoDecoderConfig",
    "VideoDecoderEventMap",
    "VideoDecoderInit",
    "VideoDecoderSupport",
    "VideoEncoder",
    "VideoEncoderBitrateMode",
    "VideoEncoderConfig",
    "VideoEncoderEncodeOptions",
    "VideoEncoderEventMap",
    "VideoEncoderInit",
    "VideoEncoderSupport",
    "VideoFacingModeEnum",
    "VideoFrame",
    "VideoFrameBufferInit",
    "VideoFrameCallbackMetadata",
    "VideoFrameCopyToOptions",
    "VideoFrameInit",
    "VideoFrameOutputCallback",
    "VideoFrameRequestCallback",
    "VideoMatrixCoefficients",
    "VideoPixelFormat",
    "VideoPlaybackQuality",
    "VideoTransferCharacteristics",
    "VisualViewport",
    "VisualViewportEventMap",
    "VoidFunction",
    "WEBGL_color_buffer_float",
    "WEBGL_compressed_texture_astc",
    "WEBGL_compressed_texture_etc",
    "WEBGL_compressed_texture_etc1",
    "WEBGL_compressed_texture_pvrtc",
    "WEBGL_compressed_texture_s3tc",
    "WEBGL_compressed_texture_s3tc_srgb",
    "WEBGL_debug_renderer_info",
    "WEBGL_debug_shaders",
    "WEBGL_depth_texture",
    "WEBGL_draw_buffers",
    "WEBGL_lose_context",
    "WEBGL_multi_draw",
    "WakeLock",
    "WakeLockSentinel",
    "WakeLockSentinelEventMap",
    "WakeLockType",
    "WaveShaperNode",
    "WaveShaperOptions",
    "WebAssembly",
    "WebCodecsErrorCallback",
    "WebGL2RenderingContext",
    "WebGL2RenderingContextBase",
    "WebGL2RenderingContextOverloads",
    "WebGLActiveInfo",
    "WebGLBuffer",
    "WebGLContextAttributes",
    "WebGLContextEvent",
    "WebGLContextEventInit",
    "WebGLFramebuffer",
    "WebGLPowerPreference",
    "WebGLProgram",
    "WebGLQuery",
    "WebGLRenderbuffer",
    "WebGLRenderingContext",
    "WebGLRenderingContextBase",
    "WebGLRenderingContextOverloads",
    "WebGLSampler",
    "WebGLShader",
    "WebGLShaderPrecisionFormat",
    "WebGLSync",
    "WebGLTexture",
    "WebGLTransformFeedback",
    "WebGLUniformLocation",
    "WebGLVertexArrayObject",
    "WebGLVertexArrayObjectOES",
    "WebKitCSSMatrix",
    "WebSocket",
    "WebSocketEventMap",
    "WebTransport",
    "WebTransportBidirectionalStream",
    "WebTransportCloseInfo",
    "WebTransportCongestionControl",
    "WebTransportDatagramDuplexStream",
    "WebTransportError",
    "WebTransportErrorOptions",
    "WebTransportErrorSource",
    "WebTransportHash",
    "WebTransportOptions",
    "WebTransportSendStreamOptions",
    "WheelEvent",
    "WheelEventInit",
    "Window",
    "WindowEventHandlers",
    "WindowEventHandlersEventMap",
    "WindowEventMap",
    "WindowLocalStorage",
    "WindowOrWorkerGlobalScope",
    "WindowPostMessageOptions",
    "WindowProxy",
    "WindowSessionStorage",
    "Worker",
    "WorkerEventMap",
    "WorkerOptions",
    "WorkerType",
    "Worklet",
    "WorkletOptions",
    "WritableStream",
    "WritableStreamDefaultController",
    "WritableStreamDefaultWriter",
    "WriteCommandType",
    "WriteParams",
    "XMLDocument",
    "XMLHttpRequest",
    "XMLHttpRequestBodyInit",
    "XMLHttpRequestEventMap",
    "XMLHttpRequestEventTarget",
    "XMLHttpRequestEventTargetEventMap",
    "XMLHttpRequestResponseType",
    "XMLHttpRequestUpload",
    "XMLSerializer",
    "XPathEvaluator",
    "XPathEvaluatorBase",
    "XPathExpression",
    "XPathNSResolver",
    "XPathResult",
    "XSLTProcessor",
    "webkitURL",
];

/// Sorted array of TypeScript Web Worker builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/webworker.ts>
pub const WEB_WORKER: &[&str] = &[
    "ANGLE_instanced_arrays",
    "AbortController",
    "AbortSignal",
    "AbortSignalEventMap",
    "AbstractWorker",
    "AbstractWorkerEventMap",
    "AddEventListenerOptions",
    "AesCbcParams",
    "AesCtrParams",
    "AesDerivedKeyParams",
    "AesGcmParams",
    "AesKeyAlgorithm",
    "AesKeyGenParams",
    "Algorithm",
    "AlgorithmIdentifier",
    "AllowSharedBufferSource",
    "AlphaOption",
    "AnimationFrameProvider",
    "AudioConfiguration",
    "AvcBitstreamFormat",
    "AvcEncoderConfig",
    "BigInteger",
    "BinaryData",
    "BinaryType",
    "Blob",
    "BlobPart",
    "BlobPropertyBag",
    "Body",
    "BodyInit",
    "BroadcastChannel",
    "BroadcastChannelEventMap",
    "BufferSource",
    "ByteLengthQueuingStrategy",
    "CSSImageValue",
    "CSSKeywordValue",
    "CSSKeywordish",
    "CSSMathClamp",
    "CSSMathInvert",
    "CSSMathMax",
    "CSSMathMin",
    "CSSMathNegate",
    "CSSMathOperator",
    "CSSMathProduct",
    "CSSMathSum",
    "CSSMathValue",
    "CSSMatrixComponent",
    "CSSMatrixComponentOptions",
    "CSSNumberish",
    "CSSNumericArray",
    "CSSNumericBaseType",
    "CSSNumericType",
    "CSSNumericValue",
    "CSSPerspective",
    "CSSPerspectiveValue",
    "CSSRotate",
    "CSSScale",
    "CSSSkew",
    "CSSSkewX",
    "CSSSkewY",
    "CSSStyleValue",
    "CSSTransformComponent",
    "CSSTransformValue",
    "CSSTranslate",
    "CSSUnitValue",
    "CSSUnparsedSegment",
    "CSSUnparsedValue",
    "CSSVariableReferenceValue",
    "Cache",
    "CacheQueryOptions",
    "CacheStorage",
    "CanvasCompositing",
    "CanvasDirection",
    "CanvasDrawImage",
    "CanvasDrawPath",
    "CanvasFillRule",
    "CanvasFillStrokeStyles",
    "CanvasFilters",
    "CanvasFontKerning",
    "CanvasFontStretch",
    "CanvasFontVariantCaps",
    "CanvasGradient",
    "CanvasImageData",
    "CanvasImageSmoothing",
    "CanvasImageSource",
    "CanvasLineCap",
    "CanvasLineJoin",
    "CanvasPath",
    "CanvasPathDrawingStyles",
    "CanvasPattern",
    "CanvasRect",
    "CanvasShadowStyles",
    "CanvasState",
    "CanvasText",
    "CanvasTextAlign",
    "CanvasTextBaseline",
    "CanvasTextDrawingStyles",
    "CanvasTextRendering",
    "CanvasTransform",
    "Client",
    "ClientQueryOptions",
    "ClientTypes",
    "Clients",
    "CloseEvent",
    "CloseEventInit",
    "CodecState",
    "ColorGamut",
    "ColorSpaceConversion",
    "CompressionFormat",
    "CompressionStream",
    "Console",
    "CountQueuingStrategy",
    "Crypto",
    "CryptoKey",
    "CryptoKeyPair",
    "CustomEvent",
    "CustomEventInit",
    "DOMException",
    "DOMHighResTimeStamp",
    "DOMMatrix",
    "DOMMatrix2DInit",
    "DOMMatrixInit",
    "DOMMatrixReadOnly",
    "DOMPoint",
    "DOMPointInit",
    "DOMPointReadOnly",
    "DOMQuad",
    "DOMQuadInit",
    "DOMRect",
    "DOMRectInit",
    "DOMRectReadOnly",
    "DOMStringList",
    "DecompressionStream",
    "DedicatedWorkerGlobalScope",
    "DedicatedWorkerGlobalScopeEventMap",
    "DocumentVisibilityState",
    "EXT_blend_minmax",
    "EXT_color_buffer_float",
    "EXT_color_buffer_half_float",
    "EXT_float_blend",
    "EXT_frag_depth",
    "EXT_sRGB",
    "EXT_shader_texture_lod",
    "EXT_texture_compression_bptc",
    "EXT_texture_compression_rgtc",
    "EXT_texture_filter_anisotropic",
    "EXT_texture_norm16",
    "EcKeyGenParams",
    "EcKeyImportParams",
    "EcdhKeyDeriveParams",
    "EcdsaParams",
    "EncodedVideoChunk",
    "EncodedVideoChunkInit",
    "EncodedVideoChunkMetadata",
    "EncodedVideoChunkOutputCallback",
    "EncodedVideoChunkType",
    "EndingType",
    "EpochTimeStamp",
    "ErrorEvent",
    "ErrorEventInit",
    "Event",
    "EventInit",
    "EventListener",
    "EventListenerObject",
    "EventListenerOptions",
    "EventListenerOrEventListenerObject",
    "EventSource",
    "EventSourceEventMap",
    "EventSourceInit",
    "EventTarget",
    "ExtendableEvent",
    "ExtendableEventInit",
    "ExtendableMessageEvent",
    "ExtendableMessageEventInit",
    "FetchEvent",
    "FetchEventInit",
    "File",
    "FileList",
    "FilePropertyBag",
    "FileReader",
    "FileReaderEventMap",
    "FileReaderSync",
    "FileSystemCreateWritableOptions",
    "FileSystemDirectoryHandle",
    "FileSystemFileHandle",
    "FileSystemGetDirectoryOptions",
    "FileSystemGetFileOptions",
    "FileSystemHandle",
    "FileSystemHandleKind",
    "FileSystemReadWriteOptions",
    "FileSystemRemoveOptions",
    "FileSystemSyncAccessHandle",
    "FileSystemWritableFileStream",
    "FileSystemWriteChunkType",
    "Float32List",
    "FontDisplay",
    "FontFace",
    "FontFaceDescriptors",
    "FontFaceLoadStatus",
    "FontFaceSet",
    "FontFaceSetEventMap",
    "FontFaceSetLoadEvent",
    "FontFaceSetLoadEventInit",
    "FontFaceSetLoadStatus",
    "FontFaceSource",
    "FormData",
    "FormDataEntryValue",
    "FrameRequestCallback",
    "FrameType",
    "GLbitfield",
    "GLboolean",
    "GLclampf",
    "GLenum",
    "GLfloat",
    "GLint",
    "GLint64",
    "GLintptr",
    "GLsizei",
    "GLsizeiptr",
    "GLuint",
    "GLuint64",
    "GenericTransformStream",
    "GetNotificationOptions",
    "GlobalCompositeOperation",
    "HardwareAcceleration",
    "HashAlgorithmIdentifier",
    "HdrMetadataType",
    "Headers",
    "HeadersInit",
    "HkdfParams",
    "HmacImportParams",
    "HmacKeyGenParams",
    "IDBCursor",
    "IDBCursorDirection",
    "IDBCursorWithValue",
    "IDBDatabase",
    "IDBDatabaseEventMap",
    "IDBDatabaseInfo",
    "IDBFactory",
    "IDBIndex",
    "IDBIndexParameters",
    "IDBKeyRange",
    "IDBObjectStore",
    "IDBObjectStoreParameters",
    "IDBOpenDBRequest",
    "IDBOpenDBRequestEventMap",
    "IDBRequest",
    "IDBRequestEventMap",
    "IDBRequestReadyState",
    "IDBTransaction",
    "IDBTransactionDurability",
    "IDBTransactionEventMap",
    "IDBTransactionMode",
    "IDBTransactionOptions",
    "IDBValidKey",
    "IDBVersionChangeEvent",
    "IDBVersionChangeEventInit",
    "ImageBitmap",
    "ImageBitmapOptions",
    "ImageBitmapRenderingContext",
    "ImageBitmapRenderingContextSettings",
    "ImageBitmapSource",
    "ImageData",
    "ImageDataSettings",
    "ImageEncodeOptions",
    "ImageOrientation",
    "ImageSmoothingQuality",
    "ImportMeta",
    "Int32List",
    "JsonWebKey",
    "KHR_parallel_shader_compile",
    "KeyAlgorithm",
    "KeyFormat",
    "KeyType",
    "KeyUsage",
    "LatencyMode",
    "Lock",
    "LockGrantedCallback",
    "LockInfo",
    "LockManager",
    "LockManagerSnapshot",
    "LockMode",
    "LockOptions",
    "MediaCapabilities",
    "MediaCapabilitiesDecodingInfo",
    "MediaCapabilitiesEncodingInfo",
    "MediaCapabilitiesInfo",
    "MediaConfiguration",
    "MediaDecodingConfiguration",
    "MediaDecodingType",
    "MediaEncodingConfiguration",
    "MediaEncodingType",
    "MessageChannel",
    "MessageEvent",
    "MessageEventInit",
    "MessageEventSource",
    "MessagePort",
    "MessagePortEventMap",
    "MultiCacheQueryOptions",
    "NamedCurve",
    "NavigationPreloadManager",
    "NavigationPreloadState",
    "NavigatorBadge",
    "NavigatorConcurrentHardware",
    "NavigatorID",
    "NavigatorLanguage",
    "NavigatorLocks",
    "NavigatorOnLine",
    "NavigatorStorage",
    "Notification",
    "NotificationDirection",
    "NotificationEvent",
    "NotificationEventInit",
    "NotificationEventMap",
    "NotificationOptions",
    "NotificationPermission",
    "OES_draw_buffers_indexed",
    "OES_element_index_uint",
    "OES_fbo_render_mipmap",
    "OES_standard_derivatives",
    "OES_texture_float",
    "OES_texture_float_linear",
    "OES_texture_half_float",
    "OES_texture_half_float_linear",
    "OES_vertex_array_object",
    "OVR_multiview2",
    "OffscreenCanvas",
    "OffscreenCanvasEventMap",
    "OffscreenCanvasRenderingContext2D",
    "OffscreenRenderingContext",
    "OffscreenRenderingContextId",
    "OnErrorEventHandler",
    "OnErrorEventHandlerNonNull",
    "Path2D",
    "Pbkdf2Params",
    "Performance",
    "PerformanceEntry",
    "PerformanceEntryList",
    "PerformanceEventMap",
    "PerformanceMark",
    "PerformanceMarkOptions",
    "PerformanceMeasure",
    "PerformanceMeasureOptions",
    "PerformanceObserver",
    "PerformanceObserverCallback",
    "PerformanceObserverEntryList",
    "PerformanceObserverInit",
    "PerformanceResourceTiming",
    "PerformanceServerTiming",
    "PermissionDescriptor",
    "PermissionName",
    "PermissionState",
    "PermissionStatus",
    "PermissionStatusEventMap",
    "Permissions",
    "PlaneLayout",
    "PredefinedColorSpace",
    "PremultiplyAlpha",
    "ProgressEvent",
    "ProgressEventInit",
    "PromiseRejectionEvent",
    "PromiseRejectionEventInit",
    "PushEncryptionKeyName",
    "PushEvent",
    "PushEventInit",
    "PushManager",
    "PushMessageData",
    "PushMessageDataInit",
    "PushSubscription",
    "PushSubscriptionJSON",
    "PushSubscriptionOptions",
    "PushSubscriptionOptionsInit",
    "QueuingStrategy",
    "QueuingStrategyInit",
    "QueuingStrategySize",
    "RTCEncodedAudioFrame",
    "RTCEncodedAudioFrameMetadata",
    "RTCEncodedVideoFrame",
    "RTCEncodedVideoFrameMetadata",
    "RTCEncodedVideoFrameType",
    "RTCRtpScriptTransformer",
    "RTCTransformEvent",
    "ReadableByteStreamController",
    "ReadableStream",
    "ReadableStreamBYOBReader",
    "ReadableStreamBYOBRequest",
    "ReadableStreamController",
    "ReadableStreamDefaultController",
    "ReadableStreamDefaultReader",
    "ReadableStreamGenericReader",
    "ReadableStreamGetReaderOptions",
    "ReadableStreamReadDoneResult",
    "ReadableStreamReadResult",
    "ReadableStreamReadValueResult",
    "ReadableStreamReader",
    "ReadableStreamReaderMode",
    "ReadableStreamType",
    "ReadableWritablePair",
    "ReferrerPolicy",
    "RegistrationOptions",
    "Report",
    "ReportBody",
    "ReportList",
    "ReportingObserver",
    "ReportingObserverCallback",
    "ReportingObserverOptions",
    "Request",
    "RequestCache",
    "RequestCredentials",
    "RequestDestination",
    "RequestInfo",
    "RequestInit",
    "RequestMode",
    "RequestPriority",
    "RequestRedirect",
    "ResizeQuality",
    "Response",
    "ResponseInit",
    "ResponseType",
    "RsaHashedImportParams",
    "RsaHashedKeyGenParams",
    "RsaKeyGenParams",
    "RsaOaepParams",
    "RsaOtherPrimesInfo",
    "RsaPssParams",
    "SecurityPolicyViolationEvent",
    "SecurityPolicyViolationEventDisposition",
    "SecurityPolicyViolationEventInit",
    "ServiceWorker",
    "ServiceWorkerContainer",
    "ServiceWorkerContainerEventMap",
    "ServiceWorkerEventMap",
    "ServiceWorkerGlobalScope",
    "ServiceWorkerGlobalScopeEventMap",
    "ServiceWorkerRegistration",
    "ServiceWorkerRegistrationEventMap",
    "ServiceWorkerState",
    "ServiceWorkerUpdateViaCache",
    "SharedWorkerGlobalScope",
    "SharedWorkerGlobalScopeEventMap",
    "StorageEstimate",
    "StorageManager",
    "StreamPipeOptions",
    "StructuredSerializeOptions",
    "StylePropertyMapReadOnly",
    "SubtleCrypto",
    "TexImageSource",
    "TextDecodeOptions",
    "TextDecoder",
    "TextDecoderCommon",
    "TextDecoderOptions",
    "TextDecoderStream",
    "TextEncoder",
    "TextEncoderCommon",
    "TextEncoderEncodeIntoResult",
    "TextEncoderStream",
    "TextMetrics",
    "TimerHandler",
    "TransferFunction",
    "Transferable",
    "TransformStream",
    "TransformStreamDefaultController",
    "Transformer",
    "TransformerFlushCallback",
    "TransformerStartCallback",
    "TransformerTransformCallback",
    "URL",
    "URLSearchParams",
    "Uint32List",
    "UnderlyingByteSource",
    "UnderlyingDefaultSource",
    "UnderlyingSink",
    "UnderlyingSinkAbortCallback",
    "UnderlyingSinkCloseCallback",
    "UnderlyingSinkStartCallback",
    "UnderlyingSinkWriteCallback",
    "UnderlyingSource",
    "UnderlyingSourceCancelCallback",
    "UnderlyingSourcePullCallback",
    "UnderlyingSourceStartCallback",
    "VideoColorPrimaries",
    "VideoColorSpace",
    "VideoColorSpaceInit",
    "VideoConfiguration",
    "VideoDecoder",
    "VideoDecoderConfig",
    "VideoDecoderEventMap",
    "VideoDecoderInit",
    "VideoDecoderSupport",
    "VideoEncoder",
    "VideoEncoderBitrateMode",
    "VideoEncoderConfig",
    "VideoEncoderEncodeOptions",
    "VideoEncoderEventMap",
    "VideoEncoderInit",
    "VideoEncoderSupport",
    "VideoFrame",
    "VideoFrameBufferInit",
    "VideoFrameCopyToOptions",
    "VideoFrameInit",
    "VideoFrameOutputCallback",
    "VideoMatrixCoefficients",
    "VideoPixelFormat",
    "VideoTransferCharacteristics",
    "VoidFunction",
    "WEBGL_color_buffer_float",
    "WEBGL_compressed_texture_astc",
    "WEBGL_compressed_texture_etc",
    "WEBGL_compressed_texture_etc1",
    "WEBGL_compressed_texture_pvrtc",
    "WEBGL_compressed_texture_s3tc",
    "WEBGL_compressed_texture_s3tc_srgb",
    "WEBGL_debug_renderer_info",
    "WEBGL_debug_shaders",
    "WEBGL_depth_texture",
    "WEBGL_draw_buffers",
    "WEBGL_lose_context",
    "WEBGL_multi_draw",
    "WebAssembly",
    "WebCodecsErrorCallback",
    "WebGL2RenderingContext",
    "WebGL2RenderingContextBase",
    "WebGL2RenderingContextOverloads",
    "WebGLActiveInfo",
    "WebGLBuffer",
    "WebGLContextAttributes",
    "WebGLContextEvent",
    "WebGLContextEventInit",
    "WebGLFramebuffer",
    "WebGLPowerPreference",
    "WebGLProgram",
    "WebGLQuery",
    "WebGLRenderbuffer",
    "WebGLRenderingContext",
    "WebGLRenderingContextBase",
    "WebGLRenderingContextOverloads",
    "WebGLSampler",
    "WebGLShader",
    "WebGLShaderPrecisionFormat",
    "WebGLSync",
    "WebGLTexture",
    "WebGLTransformFeedback",
    "WebGLUniformLocation",
    "WebGLVertexArrayObject",
    "WebGLVertexArrayObjectOES",
    "WebSocket",
    "WebSocketEventMap",
    "WebTransport",
    "WebTransportBidirectionalStream",
    "WebTransportCloseInfo",
    "WebTransportCongestionControl",
    "WebTransportDatagramDuplexStream",
    "WebTransportError",
    "WebTransportErrorOptions",
    "WebTransportErrorSource",
    "WebTransportHash",
    "WebTransportOptions",
    "WebTransportSendStreamOptions",
    "WindowClient",
    "WindowOrWorkerGlobalScope",
    "Worker",
    "WorkerEventMap",
    "WorkerGlobalScope",
    "WorkerGlobalScopeEventMap",
    "WorkerLocation",
    "WorkerNavigator",
    "WorkerOptions",
    "WorkerType",
    "WritableStream",
    "WritableStreamDefaultController",
    "WritableStreamDefaultWriter",
    "WriteCommandType",
    "WriteParams",
    "XMLHttpRequest",
    "XMLHttpRequestBodyInit",
    "XMLHttpRequestEventMap",
    "XMLHttpRequestEventTarget",
    "XMLHttpRequestEventTargetEventMap",
    "XMLHttpRequestResponseType",
    "XMLHttpRequestUpload",
];

/// Returns `true` if `name` is a TypeScript web global
///
/// ```
/// use biome_js_analyze::globals::typescript::web::is_global;
///
/// assert!(is_global(&"HTMLAnchorElement"));
/// ```
pub fn is_global(name: &str) -> bool {
    DOM.binary_search(&name).is_ok() || WEB_WORKER.binary_search(&name).is_ok()
}

#[test]
fn test_order() {
    for items in DOM.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in WEB_WORKER.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
}
