use crate::kind_src::KindsSrc;

pub const YAML_KINDS_SRC: KindsSrc = KindsSrc {
    punct: &[
        (":", "COLON"),
        (",", "COMMA"),
        ("{", "L_CURLY"),
        ("}", "R_CURLY"),
        ("[", "L_BRACK"),
        ("]", "R_BRACK"),
        ("?", "QUESTION"),
        ("-", "DASH"),
        ("|", "PIPE"),
        (">", "R_ANGLE"),
        ("+", "PLUS"),
        ("---", "DIRECTIVE_END"),
        ("...", "DOC_END"),
        // Reserved tokens
        ("`", "BACKTICK"),
        ("@", "AT"),
    ],
    keywords: &[],
    literals: &[
        "DIRECTIVE_LITERAL",
        "ANCHOR_PROPERTY_LITERAL",
        "TAG_PROPERTY_LITERAL",
        "ALIAS_LITERAL",
        "DOUBLE_QUOTED_LITERAL",
        "SINGLE_QUOTED_LITERAL",
        "PLAIN_LITERAL",
        "INDENTATION_INDICATOR",
        "BLOCK_CONTENT_LITERAL",
    ],
    tokens: &[
        "ERROR_TOKEN",
        "NEWLINE",
        "WHITESPACE",
        "COMMENT",
        "FLOW_START",
        "FLOW_END",
        "MAPPING_START",
        "MAPPING_END",
        "SEQUENCE_START",
        "SEQUENCE_END",
    ],
    nodes: &[
        "YAML_ROOT",
        "YAML_DOCUMENT_LIST",
        "YAML_DOCUMENT",
        "YAML_DIRECTIVE_LIST",
        "YAML_DIRECTIVE",
        "YAML_FLOW_JSON_NODE",
        "YAML_FLOW_YAML_NODE",
        "YAML_FLOW_SEQUENCE",
        "YAML_FLOW_SEQUENCE_ENTRY_LIST",
        "YAML_FLOW_MAPPING",
        "YAML_FLOW_MAP_ENTRY_LIST",
        "YAML_FLOW_MAP_EXPLICIT_ENTRY",
        "YAML_FLOW_MAP_IMPLICIT_ENTRY",
        "YAML_ALIAS_NODE",
        "YAML_FLOW_IN_BLOCK_NODE",
        "YAML_BLOCK_SEQUENCE",
        "YAML_BLOCK_SEQUENCE_ENTRY_LIST",
        "YAML_BLOCK_SEQUENCE_ENTRY",
        "YAML_BLOCK_MAPPING",
        "YAML_BLOCK_MAP_ENTRY_LIST",
        "YAML_BLOCK_MAP_EXPLICIT_ENTRY",
        "YAML_BLOCK_MAP_IMPLICIT_ENTRY",
        "YAML_INDENTED_BLOCK",
        "YAML_COMPACT_MAPPING",
        "YAML_COMPACT_MAPPING_INDENTED",
        "YAML_COMPACT_SEQUENCE",
        "YAML_COMPACT_SEQUENCE_INDENTED",
        "YAML_SINGLE_QUOTED_SCALAR",
        "YAML_DOUBLE_QUOTED_SCALAR",
        "YAML_PLAIN_SCALAR",
        "YAML_LITERAL_SCALAR",
        "YAML_FOLDED_SCALAR",
        "YAML_BLOCK_HEADER_LIST",
        "YAML_BLOCK_STRIP_INDICATOR",
        "YAML_BLOCK_KEEP_INDICATOR",
        "YAML_INDENTATION_INDICATOR",
        "YAML_BLOCK_CONTENT",
        "YAML_PROPERTIES_ANCHOR_FIRST",
        "YAML_PROPERTIES_TAG_FIRST",
        "YAML_ANCHOR_PROPERTY",
        "YAML_TAG_PROPERTY",
        // Bogus nodes
        "YAML_BOGUS",
        "YAML_BOGUS_BLOCK_NODE",
        "YAML_BOGUS_BLOCK_MAP_ENTRY",
        "YAML_BOGUS_BLOCK_HEADER",
        "YAML_BOGUS_FLOW_NODE",
    ],
};
