/// Sorted array of TypeScript ES5 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es5.ts>
pub const ES_5: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayLike",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "JSON",
    "Lowercase",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "String",
    "StringConstructor",
    "Symbol",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
];

/// Sorted array of TypeScript ES2015 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2015.ts>
pub const ES_2015: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

pub const ES_6: &[&str] = ES_2015;

/// Sorted array of TypeScript ES2016 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2016.ts>
pub const ES_2016: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

pub const ES_7: &[&str] = ES_2016;

/// Sorted array of TypeScript ES2017 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2017.ts>
pub const ES_2017: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "Atomics",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2018 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2018.ts>
pub const ES_2018: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2019 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2019.ts>
pub const ES_2019: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseLike",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2020 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2020.ts>
pub const ES_2020: &[&str] = &[
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "BigInt",
    "BigInt64Array",
    "BigInt64ArrayConstructor",
    "BigIntConstructor",
    "BigIntToLocaleStringOptions",
    "BigUint64Array",
    "BigUint64ArrayConstructor",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseFulfilledResult",
    "PromiseLike",
    "PromiseRejectedResult",
    "PromiseSettledResult",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "RegExpStringIterator",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2021 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2021.ts>
pub const ES_2021: &[&str] = &[
    "AggregateError",
    "AggregateErrorConstructor",
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "BigInt",
    "BigInt64Array",
    "BigInt64ArrayConstructor",
    "BigIntConstructor",
    "BigIntToLocaleStringOptions",
    "BigUint64Array",
    "BigUint64ArrayConstructor",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FinalizationRegistry",
    "FinalizationRegistryConstructor",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseFulfilledResult",
    "PromiseLike",
    "PromiseRejectedResult",
    "PromiseSettledResult",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakRef",
    "WeakRefConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2022 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es2022.ts>
pub const ES_2022: &[&str] = &[
    "AggregateError",
    "AggregateErrorConstructor",
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "BigInt",
    "BigInt64Array",
    "BigInt64ArrayConstructor",
    "BigIntConstructor",
    "BigIntToLocaleStringOptions",
    "BigUint64Array",
    "BigUint64ArrayConstructor",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "ErrorOptions",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FinalizationRegistry",
    "FinalizationRegistryConstructor",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseFulfilledResult",
    "PromiseLike",
    "PromiseRejectedResult",
    "PromiseSettledResult",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpIndicesArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakRef",
    "WeakRefConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ES2023 builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/esnext.ts>
pub const ES_2023: &[&str] = &[
    "AggregateError",
    "AggregateErrorConstructor",
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "BigInt",
    "BigInt64Array",
    "BigInt64ArrayConstructor",
    "BigIntConstructor",
    "BigIntToLocaleStringOptions",
    "BigUint64Array",
    "BigUint64ArrayConstructor",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Error",
    "ErrorConstructor",
    "ErrorOptions",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FinalizationRegistry",
    "FinalizationRegistryConstructor",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseFulfilledResult",
    "PromiseLike",
    "PromiseRejectedResult",
    "PromiseSettledResult",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpIndicesArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakRef",
    "WeakRefConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Sorted array of TypeScript ESNext builtin
///
/// Source: <https://github.com/typescript-eslint/typescript-eslint/blob/4d6d0d5950f587780dec998816d458ae4b27a513/packages/scope-manager/src/lib/es5.ts>
pub const ES_NEXT: &[&str] = &[
    "AggregateError",
    "AggregateErrorConstructor",
    "Array",
    "ArrayBuffer",
    "ArrayBufferConstructor",
    "ArrayBufferLike",
    "ArrayBufferTypes",
    "ArrayBufferView",
    "ArrayConstructor",
    "ArrayIterator",
    "ArrayLike",
    "AsyncDisposable",
    "AsyncDisposableStack",
    "AsyncDisposableStackConstructor",
    "AsyncGenerator",
    "AsyncGeneratorFunction",
    "AsyncGeneratorFunctionConstructor",
    "AsyncIterable",
    "AsyncIterableIterator",
    "AsyncIterator",
    "Atomics",
    "Awaited",
    "BigInt",
    "BigInt64Array",
    "BigInt64ArrayConstructor",
    "BigIntConstructor",
    "BigIntToLocaleStringOptions",
    "BigUint64Array",
    "BigUint64ArrayConstructor",
    "Boolean",
    "BooleanConstructor",
    "BuiltinIteratorReturn",
    "CallableFunction",
    "Capitalize",
    "ClassAccessorDecoratorContext",
    "ClassAccessorDecoratorResult",
    "ClassAccessorDecoratorTarget",
    "ClassDecorator",
    "ClassDecoratorContext",
    "ClassFieldDecoratorContext",
    "ClassGetterDecoratorContext",
    "ClassMemberDecoratorContext",
    "ClassMethodDecoratorContext",
    "ClassSetterDecoratorContext",
    "ConcatArray",
    "ConstructorParameters",
    "DataView",
    "DataViewConstructor",
    "Date",
    "DateConstructor",
    "DecoratorContext",
    "DecoratorMetadata",
    "DecoratorMetadataObject",
    "Disposable",
    "DisposableStack",
    "DisposableStackConstructor",
    "Error",
    "ErrorConstructor",
    "ErrorOptions",
    "EvalError",
    "EvalErrorConstructor",
    "Exclude",
    "Extract",
    "FinalizationRegistry",
    "FinalizationRegistryConstructor",
    "FlatArray",
    "Float32Array",
    "Float32ArrayConstructor",
    "Float64Array",
    "Float64ArrayConstructor",
    "Function",
    "FunctionConstructor",
    "Generator",
    "GeneratorFunction",
    "GeneratorFunctionConstructor",
    "IArguments",
    "ImportAssertions",
    "ImportAttributes",
    "ImportCallOptions",
    "ImportMeta",
    "InstanceType",
    "Int16Array",
    "Int16ArrayConstructor",
    "Int32Array",
    "Int32ArrayConstructor",
    "Int8Array",
    "Int8ArrayConstructor",
    "Intl",
    "Iterable",
    "IterableIterator",
    "Iterator",
    "IteratorResult",
    "IteratorReturnResult",
    "IteratorYieldResult",
    "JSON",
    "Lowercase",
    "Map",
    "MapConstructor",
    "MapIterator",
    "Math",
    "MethodDecorator",
    "NewableFunction",
    "NoInfer",
    "NonNullable",
    "Number",
    "NumberConstructor",
    "Object",
    "ObjectConstructor",
    "Omit",
    "OmitThisParameter",
    "ParameterDecorator",
    "Parameters",
    "Partial",
    "Pick",
    "Promise",
    "PromiseConstructor",
    "PromiseConstructorLike",
    "PromiseFulfilledResult",
    "PromiseLike",
    "PromiseRejectedResult",
    "PromiseSettledResult",
    "PromiseWithResolvers",
    "PropertyDecorator",
    "PropertyDescriptor",
    "PropertyDescriptorMap",
    "PropertyKey",
    "ProxyConstructor",
    "ProxyHandler",
    "RangeError",
    "RangeErrorConstructor",
    "Readonly",
    "ReadonlyArray",
    "ReadonlyMap",
    "ReadonlySet",
    "Record",
    "ReferenceError",
    "ReferenceErrorConstructor",
    "Reflect",
    "RegExp",
    "RegExpConstructor",
    "RegExpExecArray",
    "RegExpIndicesArray",
    "RegExpMatchArray",
    "Required",
    "ReturnType",
    "Set",
    "SetConstructor",
    "SetIterator",
    "SharedArrayBuffer",
    "SharedArrayBufferConstructor",
    "String",
    "StringConstructor",
    "SuppressedError",
    "SuppressedErrorConstructor",
    "Symbol",
    "SymbolConstructor",
    "SyntaxError",
    "SyntaxErrorConstructor",
    "TemplateStringsArray",
    "ThisParameterType",
    "ThisType",
    "TypeError",
    "TypeErrorConstructor",
    "TypedPropertyDescriptor",
    "URIError",
    "URIErrorConstructor",
    "Uint16Array",
    "Uint16ArrayConstructor",
    "Uint32Array",
    "Uint32ArrayConstructor",
    "Uint8Array",
    "Uint8ArrayConstructor",
    "Uint8ClampedArray",
    "Uint8ClampedArrayConstructor",
    "Uncapitalize",
    "Uppercase",
    "WeakKey",
    "WeakKeyTypes",
    "WeakMap",
    "WeakMapConstructor",
    "WeakRef",
    "WeakRefConstructor",
    "WeakSet",
    "WeakSetConstructor",
];

/// Returns `true` if `name` is a TypeScript language global
///
/// ```
/// use biome_js_analyze::globals::typescript::language::is_global;
///
/// assert!(is_global(&"PromiseConstructor"));
/// ```
pub fn is_global(name: &str) -> bool {
    ES_NEXT.binary_search(&name).is_ok()
}

#[test]
fn test_order() {
    for items in ES_5.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2015.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_6.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2016.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_7.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2017.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2018.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2019.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2020.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2021.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2022.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_2023.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
    for items in ES_NEXT.windows(2) {
        assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
    }
}
