// This file contains the list of all diagnostic categories for the Biome
// toolchain
//
// The `define_categories` macro is preprocessed in the build script for the
// crate in order to generate the static registry. The body of the macro
// consists of a list of key-value pairs defining the categories that have an
// associated hyperlink, then a list of string literals defining the remaining
// categories without a link.

// PLEASE, DON'T EDIT THIS FILE BY HAND.
// Use `just new-lintrule` to create a new rule.
// lint rules are lexicographically sorted and
// must be between `define_categories! {\n` and `\n    ;\n`.

define_categories! {
    "lint/a11y/noAccessKey": "https://biomejs.dev/linter/rules/no-access-key",
    "lint/a11y/noAriaHiddenOnFocusable": "https://biomejs.dev/linter/rules/no-aria-hidden-on-focusable",
    "lint/a11y/noAriaUnsupportedElements": "https://biomejs.dev/linter/rules/no-aria-unsupported-elements",
    "lint/a11y/noAutofocus": "https://biomejs.dev/linter/rules/no-autofocus",
    "lint/a11y/noDistractingElements": "https://biomejs.dev/linter/rules/no-distracting-elements",
    "lint/a11y/noHeaderScope": "https://biomejs.dev/linter/rules/no-header-scope",
    "lint/a11y/noInteractiveElementToNoninteractiveRole": "https://biomejs.dev/linter/rules/no-interactive-element-to-noninteractive-role",
    "lint/a11y/noLabelWithoutControl": "https://biomejs.dev/linter/rules/no-label-without-control",
    "lint/a11y/noNoninteractiveElementInteractions": "https://biomejs.dev/linter/rules/no-noninteractive-element-interactions",
    "lint/a11y/noNoninteractiveElementToInteractiveRole": "https://biomejs.dev/linter/rules/no-noninteractive-element-to-interactive-role",
    "lint/a11y/noNoninteractiveTabindex": "https://biomejs.dev/linter/rules/no-noninteractive-tabindex",
    "lint/a11y/noPositiveTabindex": "https://biomejs.dev/linter/rules/no-positive-tabindex",
    "lint/a11y/noRedundantAlt": "https://biomejs.dev/linter/rules/no-redundant-alt",
    "lint/a11y/noRedundantRoles": "https://biomejs.dev/linter/rules/no-redundant-roles",
    "lint/a11y/noStaticElementInteractions": "https://biomejs.dev/linter/rules/no-static-element-interactions",
    "lint/a11y/noSvgWithoutTitle": "https://biomejs.dev/linter/rules/no-svg-without-title",
    "lint/a11y/useAltText": "https://biomejs.dev/linter/rules/use-alt-text",
    "lint/a11y/useAnchorContent": "https://biomejs.dev/linter/rules/use-anchor-content",
    "lint/a11y/useAriaActivedescendantWithTabindex": "https://biomejs.dev/linter/rules/use-aria-activedescendant-with-tabindex",
    "lint/a11y/useAriaPropsForRole": "https://biomejs.dev/linter/rules/use-aria-props-for-role",
    "lint/a11y/useAriaPropsSupportedByRole": "https://biomejs.dev/linter/rules/use-aria-props-supported-by-role",
    "lint/a11y/useButtonType": "https://biomejs.dev/linter/rules/use-button-type",
    "lint/a11y/useFocusableInteractive": "https://biomejs.dev/linter/rules/use-focusable-interactive",
    "lint/a11y/useGenericFontNames": "https://biomejs.dev/linter/rules/use-generic-font-names",
    "lint/a11y/useHeadingContent": "https://biomejs.dev/linter/rules/use-heading-content",
    "lint/a11y/useHtmlLang": "https://biomejs.dev/linter/rules/use-html-lang",
    "lint/a11y/useIframeTitle": "https://biomejs.dev/linter/rules/use-iframe-title",
    "lint/a11y/useKeyWithClickEvents": "https://biomejs.dev/linter/rules/use-key-with-click-events",
    "lint/a11y/useKeyWithMouseEvents": "https://biomejs.dev/linter/rules/use-key-with-mouse-events",
    "lint/a11y/useMediaCaption": "https://biomejs.dev/linter/rules/use-media-caption",
    "lint/a11y/useSemanticElements": "https://biomejs.dev/linter/rules/use-semantic-elements",
    "lint/a11y/useValidAnchor": "https://biomejs.dev/linter/rules/use-valid-anchor",
    "lint/a11y/useValidAriaProps": "https://biomejs.dev/linter/rules/use-valid-aria-props",
    "lint/a11y/useValidAriaRole": "https://biomejs.dev/linter/rules/use-valid-aria-role",
    "lint/a11y/useValidAriaValues": "https://biomejs.dev/linter/rules/use-valid-aria-values",
    "lint/a11y/useValidAutocomplete": "https://biomejs.dev/linter/rules/use-valid-autocomplete",
    "lint/a11y/useValidLang": "https://biomejs.dev/linter/rules/use-valid-lang",
    "lint/complexity/noAdjacentSpacesInRegex": "https://biomejs.dev/linter/rules/no-adjacent-spaces-in-regex",
    "lint/complexity/noArguments": "https://biomejs.dev/linter/rules/no-arguments",
    "lint/complexity/noBannedTypes": "https://biomejs.dev/linter/rules/no-banned-types",
    "lint/complexity/noCommaOperator": "https://biomejs.dev/linter/rules/no-comma-operator",
    "lint/complexity/noEmptyTypeParameters": "https://biomejs.dev/linter/rules/no-empty-type-parameters",
    "lint/complexity/noExcessiveCognitiveComplexity": "https://biomejs.dev/linter/rules/no-excessive-cognitive-complexity",
    "lint/complexity/noExcessiveLinesPerFunction": "https://biomejs.dev/linter/rules/no-excessive-lines-per-function",
    "lint/complexity/noExcessiveNestedTestSuites": "https://biomejs.dev/linter/rules/no-excessive-nested-test-suites",
    "lint/complexity/noExtraBooleanCast": "https://biomejs.dev/linter/rules/no-extra-boolean-cast",
    "lint/complexity/noFlatMapIdentity": "https://biomejs.dev/linter/rules/no-flat-map-identity",
    "lint/complexity/noForEach": "https://biomejs.dev/linter/rules/no-for-each",
    "lint/complexity/noImplicitCoercions": "https://biomejs.dev/linter/rules/no-implicit-coercions",
    "lint/complexity/noImportantStyles": "https://biomejs.dev/linter/rules/no-important-styles",
    "lint/complexity/noStaticOnlyClass": "https://biomejs.dev/linter/rules/no-static-only-class",
    "lint/complexity/noThisInStatic": "https://biomejs.dev/linter/rules/no-this-in-static",
    "lint/complexity/noUselessCatch": "https://biomejs.dev/linter/rules/no-useless-catch",
    "lint/complexity/noUselessConstructor": "https://biomejs.dev/linter/rules/no-useless-constructor",
    "lint/complexity/noUselessContinue": "https://biomejs.dev/linter/rules/no-useless-continue",
    "lint/complexity/noUselessEmptyExport": "https://biomejs.dev/linter/rules/no-useless-empty-export",
    "lint/complexity/noUselessEscapeInRegex": "https://biomejs.dev/linter/rules/no-useless-escape-in-regex",
    "lint/complexity/noUselessFragments": "https://biomejs.dev/linter/rules/no-useless-fragments",
    "lint/complexity/noUselessLabel": "https://biomejs.dev/linter/rules/no-useless-label",
    "lint/complexity/noUselessLoneBlockStatements": "https://biomejs.dev/linter/rules/no-useless-lone-block-statements",
    "lint/complexity/noUselessRename": "https://biomejs.dev/linter/rules/no-useless-rename",
    "lint/complexity/noUselessStringConcat": "https://biomejs.dev/linter/rules/no-useless-string-concat",
    "lint/complexity/noUselessStringRaw": "https://biomejs.dev/linter/rules/no-useless-string-raw",
    "lint/complexity/noUselessSwitchCase": "https://biomejs.dev/linter/rules/no-useless-switch-case",
    "lint/complexity/noUselessTernary": "https://biomejs.dev/linter/rules/no-useless-ternary",
    "lint/complexity/noUselessThisAlias": "https://biomejs.dev/linter/rules/no-useless-this-alias",
    "lint/complexity/noUselessTypeConstraint": "https://biomejs.dev/linter/rules/no-useless-type-constraint",
    "lint/complexity/noUselessUndefinedInitialization": "https://biomejs.dev/linter/rules/no-useless-undefined-initialization",
    "lint/complexity/noVoid": "https://biomejs.dev/linter/rules/no-void",
    "lint/complexity/useArrowFunction": "https://biomejs.dev/linter/rules/use-arrow-function",
    "lint/complexity/useDateNow": "https://biomejs.dev/linter/rules/use-date-now",
    "lint/complexity/useFlatMap": "https://biomejs.dev/linter/rules/use-flat-map",
    "lint/complexity/useIndexOf": "https://biomejs.dev/linter/rules/use-index-of",
    "lint/complexity/useLiteralKeys": "https://biomejs.dev/linter/rules/use-literal-keys",
    "lint/complexity/useNumericLiterals": "https://biomejs.dev/linter/rules/use-numeric-literals",
    "lint/complexity/useOptionalChain": "https://biomejs.dev/linter/rules/use-optional-chain",
    "lint/complexity/useRegexLiterals": "https://biomejs.dev/linter/rules/use-regex-literals",
    "lint/complexity/useSimpleNumberKeys": "https://biomejs.dev/linter/rules/use-simple-number-keys",
    "lint/complexity/useSimplifiedLogicExpression": "https://biomejs.dev/linter/rules/use-simplified-logic-expression",
    "lint/complexity/useWhile": "https://biomejs.dev/linter/rules/use-while",
    "lint/correctness/noChildrenProp": "https://biomejs.dev/linter/rules/no-children-prop",
    "lint/correctness/noConstAssign": "https://biomejs.dev/linter/rules/no-const-assign",
    "lint/correctness/noConstantCondition": "https://biomejs.dev/linter/rules/no-constant-condition",
    "lint/correctness/noConstantMathMinMaxClamp": "https://biomejs.dev/linter/rules/no-constant-math-min-max-clamp",
    "lint/correctness/noConstructorReturn": "https://biomejs.dev/linter/rules/no-constructor-return",
    "lint/correctness/noEmptyCharacterClassInRegex": "https://biomejs.dev/linter/rules/no-empty-character-class-in-regex",
    "lint/correctness/noEmptyPattern": "https://biomejs.dev/linter/rules/no-empty-pattern",
    "lint/correctness/noGlobalDirnameFilename": "https://biomejs.dev/linter/rules/no-global-dirname-filename",
    "lint/correctness/noGlobalObjectCalls": "https://biomejs.dev/linter/rules/no-global-object-calls",
    "lint/correctness/noInnerDeclarations": "https://biomejs.dev/linter/rules/no-inner-declarations",
    "lint/correctness/noInvalidBuiltinInstantiation": "https://biomejs.dev/linter/rules/no-invalid-builtin-instantiation",
    "lint/correctness/noInvalidConstructorSuper": "https://biomejs.dev/linter/rules/no-invalid-constructor-super",
    "lint/correctness/noInvalidDirectionInLinearGradient": "https://biomejs.dev/linter/rules/no-invalid-direction-in-linear-gradient",
    "lint/correctness/noInvalidGridAreas": "https://biomejs.dev/linter/rules/use-consistent-grid-areas",
    "lint/correctness/noInvalidNewBuiltin": "https://biomejs.dev/linter/rules/no-invalid-new-builtin",
    "lint/correctness/noInvalidPositionAtImportRule": "https://biomejs.dev/linter/rules/no-invalid-position-at-import-rule",
    "lint/correctness/noInvalidUseBeforeDeclaration": "https://biomejs.dev/linter/rules/no-invalid-use-before-declaration",
    "lint/correctness/noMissingVarFunction": "https://biomejs.dev/linter/rules/no-missing-var-function",
    "lint/correctness/noNestedComponentDefinitions": "https://biomejs.dev/linter/rules/no-nested-component-definitions",
    "lint/correctness/noNewSymbol": "https://biomejs.dev/linter/rules/no-new-symbol",
    "lint/correctness/noNodejsModules": "https://biomejs.dev/linter/rules/no-nodejs-modules",
    "lint/correctness/noNonoctalDecimalEscape": "https://biomejs.dev/linter/rules/no-nonoctal-decimal-escape",
    "lint/correctness/noPrecisionLoss": "https://biomejs.dev/linter/rules/no-precision-loss",
    "lint/correctness/noPrivateImports": "https://biomejs.dev/linter/rules/no-private-imports",
    "lint/correctness/noProcessGlobal": "https://biomejs.dev/linter/rules/no-process-global",
    "lint/correctness/noQwikUseVisibleTask": "https://biomejs.dev/linter/rules/no-qwik-use-visible-task",
    "lint/correctness/noReactPropAssignments": "https://biomejs.dev/linter/rules/no-react-prop-assignments",
    "lint/correctness/noRenderReturnValue": "https://biomejs.dev/linter/rules/no-render-return-value",
    "lint/correctness/noRestrictedElements": "https://biomejs.dev/linter/rules/no-restricted-elements",
    "lint/correctness/noSelfAssign": "https://biomejs.dev/linter/rules/no-self-assign",
    "lint/correctness/noSetterReturn": "https://biomejs.dev/linter/rules/no-setter-return",
    "lint/correctness/noSolidDestructuredProps": "https://biomejs.dev/linter/rules/no-solid-destructured-props",
    "lint/correctness/noStringCaseMismatch": "https://biomejs.dev/linter/rules/no-string-case-mismatch",
    "lint/correctness/noSwitchDeclarations": "https://biomejs.dev/linter/rules/no-switch-declarations",
    "lint/correctness/noUndeclaredDependencies": "https://biomejs.dev/linter/rules/no-undeclared-dependencies",
    "lint/correctness/noUndeclaredVariables": "https://biomejs.dev/linter/rules/no-undeclared-variables",
    "lint/correctness/noUnknownFunction": "https://biomejs.dev/linter/rules/no-unknown-function",
    "lint/correctness/noUnknownMediaFeatureName": "https://biomejs.dev/linter/rules/no-unknown-media-feature-name",
    "lint/correctness/noUnknownProperty": "https://biomejs.dev/linter/rules/no-unknown-property",
    "lint/correctness/noUnknownPseudoClass": "https://biomejs.dev/linter/rules/no-unknown-pseudo-class",
    "lint/correctness/noUnknownPseudoClassSelector": "https://biomejs.dev/linter/rules/no-unknown-pseudo-class-selector",
    "lint/correctness/noUnknownPseudoElement": "https://biomejs.dev/linter/rules/no-unknown-selector-pseudo-element",
    "lint/correctness/noUnknownTypeSelector": "https://biomejs.dev/linter/rules/no-unknown-type-selector",
    "lint/correctness/noUnknownUnit": "https://biomejs.dev/linter/rules/no-unknown-unit",
    "lint/correctness/noUnmatchableAnbSelector": "https://biomejs.dev/linter/rules/no-unmatchable-anb-selector",
    "lint/correctness/noUnreachable": "https://biomejs.dev/linter/rules/no-unreachable",
    "lint/correctness/noUnreachableSuper": "https://biomejs.dev/docs/linter/rules/no-unreachable-super",
    "lint/correctness/noUnsafeFinally": "https://biomejs.dev/linter/rules/no-unsafe-finally",
    "lint/correctness/noUnsafeOptionalChaining": "https://biomejs.dev/linter/rules/no-unsafe-optional-chaining",
    "lint/correctness/noUnusedFunctionParameters": "https://biomejs.dev/linter/rules/no-unused-function-parameters",
    "lint/correctness/noUnusedImports": "https://biomejs.dev/linter/rules/no-unused-imports",
    "lint/correctness/noUnusedLabels": "https://biomejs.dev/linter/rules/no-unused-labels",
    "lint/correctness/noUnusedPrivateClassMembers": "https://biomejs.dev/linter/rules/no-unused-private-class-members",
    "lint/correctness/noUnusedVariables": "https://biomejs.dev/linter/rules/no-unused-variables",
    "lint/correctness/noVoidElementsWithChildren": "https://biomejs.dev/linter/rules/no-void-elements-with-children",
    "lint/correctness/noVoidTypeReturn": "https://biomejs.dev/linter/rules/no-void-type-return",
    "lint/correctness/useExhaustiveDependencies": "https://biomejs.dev/linter/rules/use-exhaustive-dependencies",
    "lint/correctness/useGraphqlNamedOperations": "https://biomejs.dev/linter/rules/use-graphql-named-operations",
    "lint/correctness/useHookAtTopLevel": "https://biomejs.dev/linter/rules/use-hook-at-top-level",
    "lint/correctness/useImageSize": "https://biomejs.dev/linter/rules/use-image-size",
    "lint/correctness/useImportExtensions": "https://biomejs.dev/linter/rules/use-import-extensions",
    "lint/correctness/useIsNan": "https://biomejs.dev/linter/rules/use-is-nan",
    "lint/correctness/useJsonImportAttributes": "https://biomejs.dev/linter/rules/use-json-import-attributes",
    "lint/correctness/useJsxKeyInIterable": "https://biomejs.dev/linter/rules/use-jsx-key-in-iterable",
    "lint/correctness/useParseIntRadix": "https://biomejs.dev/linter/rules/use-parse-int-radix",
    "lint/correctness/useQwikClasslist": "https://biomejs.dev/linter/rules/use-qwik-classlist",
    "lint/correctness/useSingleJsDocAsterisk": "https://biomejs.dev/linter/rules/use-single-js-doc-asterisk",
    "lint/correctness/useUniqueElementIds": "https://biomejs.dev/linter/rules/use-unique-element-ids",
    "lint/correctness/useValidForDirection": "https://biomejs.dev/linter/rules/use-valid-for-direction",
    "lint/correctness/useValidTypeof": "https://biomejs.dev/linter/rules/use-valid-typeof",
    "lint/correctness/useYield": "https://biomejs.dev/linter/rules/use-yield",
    "lint/nursery/noColorInvalidHex": "https://biomejs.dev/linter/rules/no-color-invalid-hex",
    "lint/nursery/noContinue": "https://biomejs.dev/linter/rules/no-continue",
    "lint/nursery/noDeprecatedImports": "https://biomejs.dev/linter/rules/no-deprecated-imports",
    "lint/nursery/noDuplicateDependencies": "https://biomejs.dev/linter/rules/no-duplicate-dependencies",
    "lint/nursery/noEmptySource": "https://biomejs.dev/linter/rules/no-empty-source",
    "lint/nursery/noEqualsToNull": "https://biomejs.dev/linter/rules/no-equals-to-null",
    "lint/nursery/noFloatingPromises": "https://biomejs.dev/linter/rules/no-floating-promises",
    "lint/nursery/noForIn": "https://biomejs.dev/linter/rules/no-for-in",
    "lint/nursery/noImplicitCoercion": "https://biomejs.dev/linter/rules/no-implicit-coercion",
    "lint/nursery/noImportCycles": "https://biomejs.dev/linter/rules/no-import-cycles",
    "lint/nursery/noIncrementDecrement": "https://biomejs.dev/linter/rules/no-increment-decrement",
    "lint/nursery/noJsxLiterals": "https://biomejs.dev/linter/rules/no-jsx-literals",
    "lint/nursery/noLeakedRender": "https://biomejs.dev/linter/rules/no-leaked-render",
    "lint/nursery/noMissingGenericFamilyKeyword": "https://biomejs.dev/linter/rules/no-missing-generic-family-keyword",
    "lint/nursery/noMisusedPromises": "https://biomejs.dev/linter/rules/no-misused-promises",
    "lint/nursery/noMultiStr": "https://biomejs.dev/linter/rules/no-multi-str",
    "lint/nursery/noNextAsyncClientComponent": "https://biomejs.dev/linter/rules/no-next-async-client-component",
    "lint/nursery/noParametersOnlyUsedInRecursion": "https://biomejs.dev/linter/rules/no-parameters-only-used-in-recursion",
    "lint/nursery/noProto": "https://biomejs.dev/linter/rules/no-proto",
    "lint/nursery/noReactForwardRef": "https://biomejs.dev/linter/rules/no-react-forward-ref",
    "lint/nursery/noShadow": "https://biomejs.dev/linter/rules/no-shadow",
    "lint/nursery/noDuplicatedSpreadProps": "https://biomejs.dev/linter/rules/no-duplicated-spread-props",
    "lint/nursery/noSyncScripts": "https://biomejs.dev/linter/rules/no-sync-scripts",
    "lint/nursery/noTernary": "https://biomejs.dev/linter/rules/no-ternary",
    "lint/nursery/noUnknownAttribute": "https://biomejs.dev/linter/rules/no-unknown-attribute",
    "lint/nursery/noUnnecessaryConditions": "https://biomejs.dev/linter/rules/no-unnecessary-conditions",
    "lint/nursery/noUnresolvedImports": "https://biomejs.dev/linter/rules/no-unresolved-imports",
    "lint/nursery/noUnusedExpressions": "https://biomejs.dev/linter/rules/no-unused-expressions",
    "lint/nursery/noUnwantedPolyfillio": "https://biomejs.dev/linter/rules/no-unwanted-polyfillio",
    "lint/nursery/noUselessBackrefInRegex": "https://biomejs.dev/linter/rules/no-useless-backref-in-regex",
    "lint/nursery/noUselessCatchBinding": "https://biomejs.dev/linter/rules/no-useless-catch-binding",
    "lint/nursery/noUselessUndefined": "https://biomejs.dev/linter/rules/no-useless-undefined",
    "lint/nursery/noVueDataObjectDeclaration": "https://biomejs.dev/linter/rules/no-vue-data-object-declaration",
    "lint/nursery/noVueDuplicateKeys": "https://biomejs.dev/linter/rules/no-vue-duplicate-keys",
    "lint/nursery/noVueReservedKeys": "https://biomejs.dev/linter/rules/no-vue-reserved-keys",
    "lint/nursery/noVueReservedProps": "https://biomejs.dev/linter/rules/no-vue-reserved-props",
    "lint/nursery/noVueVIfWithVFor": "https://biomejs.dev/linter/rules/no-vue-v-if-with-v-for",
    "lint/nursery/useAnchorHref": "https://biomejs.dev/linter/rules/use-anchor-href",
    "lint/nursery/useArraySortCompare": "https://biomejs.dev/linter/rules/use-array-sort-compare",
    "lint/nursery/useBiomeSuppressionComment": "https://biomejs.dev/linter/rules/use-biome-suppression-comment",
    "lint/nursery/useConsistentArrowReturn": "https://biomejs.dev/linter/rules/use-consistent-arrow-return",
    "lint/nursery/useConsistentGraphqlDescriptions": "https://biomejs.dev/linter/rules/use-consistent-graphql-descriptions",
    "lint/nursery/useConsistentObjectDefinition": "https://biomejs.dev/linter/rules/use-consistent-object-definition",
    "lint/nursery/useDeprecatedDate": "https://biomejs.dev/linter/rules/use-deprecated-date",
    "lint/nursery/useExhaustiveSwitchCases": "https://biomejs.dev/linter/rules/use-exhaustive-switch-cases",
    "lint/nursery/useExplicitFunctionReturnType": "https://biomejs.dev/linter/rules/use-explicit-type",
    "lint/nursery/useExplicitType": "https://biomejs.dev/linter/rules/use-explicit-type",
    "lint/nursery/useFind": "https://biomejs.dev/linter/rules/use-find",
    "lint/nursery/useImportRestrictions": "https://biomejs.dev/linter/rules/use-import-restrictions",
    "lint/nursery/useJsxCurlyBraceConvention": "https://biomejs.dev/linter/rules/use-jsx-curly-brace-convention",
    "lint/nursery/useMaxParams": "https://biomejs.dev/linter/rules/use-max-params",
    "lint/nursery/useQwikMethodUsage": "https://biomejs.dev/linter/rules/use-qwik-method-usage",
    "lint/nursery/useQwikValidLexicalScope": "https://biomejs.dev/linter/rules/use-qwik-valid-lexical-scope",
    "lint/nursery/useSortedClasses": "https://biomejs.dev/linter/rules/use-sorted-classes",
    "lint/nursery/useSpread": "https://biomejs.dev/linter/rules/no-spread",
    "lint/nursery/useUniqueGraphqlOperationName": "https://biomejs.dev/linter/rules/use-unique-graphql-operation-name",
    "lint/nursery/useVueDefineMacrosOrder": "https://biomejs.dev/linter/rules/use-vue-define-macros-order",
    "lint/nursery/useVueHyphenatedAttributes": "https://biomejs.dev/linter/rules/use-vue-hyphenated-attributes",
    "lint/nursery/useVueMultiWordComponentNames": "https://biomejs.dev/linter/rules/use-vue-multi-word-component-names",
    "lint/nursery/useVueValidVBind": "https://biomejs.dev/linter/rules/use-vue-valid-v-bind",
    "lint/nursery/useVueValidVElse": "https://biomejs.dev/linter/rules/use-vue-valid-v-else",
    "lint/nursery/useVueValidVElseIf": "https://biomejs.dev/linter/rules/use-vue-valid-v-else-if",
    "lint/nursery/useVueValidVFor": "https://biomejs.dev/linter/rules/use-vue-valid-v-for",
    "lint/nursery/useVueValidVHtml": "https://biomejs.dev/linter/rules/use-vue-valid-v-html",
    "lint/nursery/useVueValidVIf": "https://biomejs.dev/linter/rules/use-vue-valid-v-if",
    "lint/nursery/useVueValidVModel": "https://biomejs.dev/linter/rules/use-vue-valid-v-model",
    "lint/nursery/useVueValidVOn": "https://biomejs.dev/linter/rules/use-vue-valid-v-on",
    "lint/nursery/useVueValidVText": "https://biomejs.dev/linter/rules/use-vue-valid-v-text",
    "lint/performance/noAccumulatingSpread": "https://biomejs.dev/linter/rules/no-accumulating-spread",
    "lint/performance/noAwaitInLoops": "https://biomejs.dev/linter/rules/no-await-in-loops",
    "lint/performance/noBarrelFile": "https://biomejs.dev/linter/rules/no-barrel-file",
    "lint/performance/noDelete": "https://biomejs.dev/linter/rules/no-delete",
    "lint/performance/noDynamicNamespaceImportAccess": "https://biomejs.dev/linter/rules/no-dynamic-namespace-import-access",
    "lint/performance/noImgElement": "https://biomejs.dev/linter/rules/no-img-element",
    "lint/performance/noNamespaceImport": "https://biomejs.dev/linter/rules/no-namespace-import",
    "lint/performance/noReExportAll": "https://biomejs.dev/linter/rules/no-re-export-all",
    "lint/performance/noUnwantedPolyfillio": "https://biomejs.dev/linter/rules/no-unwanted-polyfillio",
    "lint/performance/useGoogleFontPreconnect": "https://biomejs.dev/linter/rules/use-google-font-preconnect",
    "lint/performance/useSolidForComponent": "https://biomejs.dev/linter/rules/use-solid-for-component",
    "lint/performance/useTopLevelRegex": "https://biomejs.dev/linter/rules/use-top-level-regex",
    "lint/security/noBlankTarget": "https://biomejs.dev/linter/rules/no-blank-target",
    "lint/security/noDangerouslySetInnerHtml": "https://biomejs.dev/linter/rules/no-dangerously-set-inner-html",
    "lint/security/noDangerouslySetInnerHtmlWithChildren": "https://biomejs.dev/linter/rules/no-dangerously-set-inner-html-with-children",
    "lint/security/noGlobalEval": "https://biomejs.dev/linter/rules/no-global-eval",
    "lint/security/noSecrets": "https://biomejs.dev/linter/rules/no-secrets",
    "lint/style/noCommonJs": "https://biomejs.dev/linter/rules/no-common-js",
    "lint/style/noDefaultExport": "https://biomejs.dev/linter/rules/no-default-export",
    "lint/style/noDescendingSpecificity": "https://biomejs.dev/linter/rules/no-descending-specificity",
    "lint/style/noDoneCallback": "https://biomejs.dev/linter/rules/no-done-callback",
    "lint/style/noEnum": "https://biomejs.dev/linter/rules/no-enum",
    "lint/style/noExportedImports": "https://biomejs.dev/linter/rules/no-exported-imports",
    "lint/style/noHeadElement": "https://biomejs.dev/linter/rules/no-head-element",
    "lint/style/noImplicitBoolean": "https://biomejs.dev/linter/rules/no-implicit-boolean",
    "lint/style/noInferrableTypes": "https://biomejs.dev/linter/rules/no-inferrable-types",
    "lint/style/noMagicNumbers": "https://biomejs.dev/linter/rules/no-magic-numbers",
    "lint/style/noNamespace": "https://biomejs.dev/linter/rules/no-namespace",
    "lint/style/noNegationElse": "https://biomejs.dev/linter/rules/no-negation-else",
    "lint/style/noNestedTernary": "https://biomejs.dev/linter/rules/no-nested-ternary",
    "lint/style/noNonNullAssertion": "https://biomejs.dev/linter/rules/no-non-null-assertion",
    "lint/style/noParameterAssign": "https://biomejs.dev/linter/rules/no-parameter-assign",
    "lint/style/noParameterProperties": "https://biomejs.dev/linter/rules/no-parameter-properties",
    "lint/style/noProcessEnv": "https://biomejs.dev/linter/rules/no-process-env",
    "lint/style/noRestrictedGlobals": "https://biomejs.dev/linter/rules/no-restricted-globals",
    "lint/style/noRestrictedImports": "https://biomejs.dev/linter/rules/no-restricted-imports",
    "lint/style/noRestrictedTypes": "https://biomejs.dev/linter/rules/no-restricted-types",
    "lint/style/noShoutyConstants": "https://biomejs.dev/linter/rules/no-shouty-constants",
    "lint/style/noSubstr": "https://biomejs.dev/linter/rules/no-substr",
    "lint/style/noUnusedTemplateLiteral": "https://biomejs.dev/linter/rules/no-unused-template-literal",
    "lint/style/noUselessElse": "https://biomejs.dev/linter/rules/no-useless-else",
    "lint/style/noValueAtRule": "https://biomejs.dev/linter/rules/no-value-at-rule",
    "lint/style/noYodaExpression": "https://biomejs.dev/linter/rules/no-yoda-expression",
    "lint/style/useArrayLiterals": "https://biomejs.dev/linter/rules/use-array-literals",
    "lint/style/useAsConstAssertion": "https://biomejs.dev/linter/rules/use-as-const-assertion",
    "lint/style/useAtIndex": "https://biomejs.dev/linter/rules/use-at-index",
    "lint/style/useBlockStatements": "https://biomejs.dev/linter/rules/use-block-statements",
    "lint/style/useCollapsedElseIf": "https://biomejs.dev/linter/rules/use-collapsed-else-if",
    "lint/style/useCollapsedIf": "https://biomejs.dev/linter/rules/use-collapsed-if",
    "lint/style/useComponentExportOnlyModules": "https://biomejs.dev/linter/rules/use-component-export-only-modules",
    "lint/style/useConsistentArrayType": "https://biomejs.dev/linter/rules/use-consistent-array-type",
    "lint/style/useConsistentBuiltinInstantiation": "https://biomejs.dev/linter/rules/use-consistent-new-builtin",
    "lint/style/useConsistentCurlyBraces": "https://biomejs.dev/linter/rules/use-consistent-curly-braces",
    "lint/style/useConsistentMemberAccessibility": "https://biomejs.dev/linter/rules/use-consistent-member-accessibility",
    "lint/style/useConsistentObjectDefinitions": "https://biomejs.dev/linter/rules/use-consistent-object-definitions",
    "lint/style/useConsistentTypeDefinitions": "https://biomejs.dev/linter/rules/use-consistent-type-definitions",
    "lint/style/useConst": "https://biomejs.dev/linter/rules/use-const",
    "lint/style/useDefaultParameterLast": "https://biomejs.dev/linter/rules/use-default-parameter-last",
    "lint/style/useDefaultSwitchClause": "https://biomejs.dev/linter/rules/use-default-switch-clause",
    "lint/style/useDeprecatedReason": "https://biomejs.dev/linter/rules/use-deprecated-reason",
    "lint/style/useEnumInitializers": "https://biomejs.dev/linter/rules/use-enum-initializers",
    "lint/style/useExplicitLengthCheck": "https://biomejs.dev/linter/rules/use-explicit-length-check",
    "lint/style/useExponentiationOperator": "https://biomejs.dev/linter/rules/use-exponentiation-operator",
    "lint/style/useExportType": "https://biomejs.dev/linter/rules/use-export-type",
    "lint/style/useExportsLast": "https://biomejs.dev/linter/rules/use-exports-last",
    "lint/style/useFilenamingConvention": "https://biomejs.dev/linter/rules/use-filenaming-convention",
    "lint/style/useForOf": "https://biomejs.dev/linter/rules/use-for-of",
    "lint/style/useFragmentSyntax": "https://biomejs.dev/linter/rules/use-fragment-syntax",
    "lint/style/useGraphqlNamingConvention": "https://biomejs.dev/linter/rules/use-graphql-naming-convention",
    "lint/style/useGroupedAccessorPairs": "https://biomejs.dev/linter/rules/use-grouped-accessor-pairs",
    "lint/style/useImportType": "https://biomejs.dev/linter/rules/use-import-type",
    "lint/style/useLiteralEnumMembers": "https://biomejs.dev/linter/rules/use-literal-enum-members",
    "lint/style/useNamingConvention": "https://biomejs.dev/linter/rules/use-naming-convention",
    "lint/style/useNodeAssertStrict": "https://biomejs.dev/linter/rules/use-node-assert-strict",
    "lint/style/useNodejsImportProtocol": "https://biomejs.dev/linter/rules/use-nodejs-import-protocol",
    "lint/style/useNumberNamespace": "https://biomejs.dev/linter/rules/use-number-namespace",
    "lint/style/useNumericSeparators": "https://biomejs.dev/linter/rules/use-numeric-separators",
    "lint/style/useObjectSpread": "https://biomejs.dev/linter/rules/use-object-spread",
    "lint/style/useReactFunctionComponents": "https://biomejs.dev/linter/rules/use-react-function-components",
    "lint/style/useReadonlyClassProperties": "https://biomejs.dev/linter/rules/use-readonly-class-properties",
    "lint/style/useSelfClosingElements": "https://biomejs.dev/linter/rules/use-self-closing-elements",
    "lint/style/useShorthandArrayType": "https://biomejs.dev/linter/rules/use-shorthand-array-type",
    "lint/style/useShorthandAssign": "https://biomejs.dev/linter/rules/use-shorthand-assign",
    "lint/style/useShorthandFunctionType": "https://biomejs.dev/linter/rules/use-shorthand-function-type",
    "lint/style/useSingleCaseStatement": "https://biomejs.dev/linter/rules/use-single-case-statement",
    "lint/style/useSingleVarDeclarator": "https://biomejs.dev/linter/rules/use-single-var-declarator",
    "lint/style/useSymbolDescription": "https://biomejs.dev/linter/rules/use-symbol-description",
    "lint/style/useTemplate": "https://biomejs.dev/linter/rules/use-template",
    "lint/style/useThrowNewError": "https://biomejs.dev/linter/rules/use-throw-new-error",
    "lint/style/useThrowOnlyError": "https://biomejs.dev/linter/rules/use-throw-only-error",
    "lint/style/useTrimStartEnd": "https://biomejs.dev/linter/rules/use-trim-start-end",
    "lint/style/useUnifiedTypeSignatures": "https://biomejs.dev/linter/rules/use-unified-type-signatures",
    "lint/suspicious/noAlert": "https://biomejs.dev/linter/rules/no-alert",
    "lint/suspicious/noApproximativeNumericConstant": "https://biomejs.dev/linter/rules/no-approximative-numeric-constant",
    "lint/suspicious/noArrayIndexKey": "https://biomejs.dev/linter/rules/no-array-index-key",
    "lint/suspicious/noAssignInExpressions": "https://biomejs.dev/linter/rules/no-assign-in-expressions",
    "lint/suspicious/noAsyncPromiseExecutor": "https://biomejs.dev/linter/rules/no-async-promise-executor",
    "lint/suspicious/noBiomeFirstException": "https://biomejs.dev/linter/rules/no-biome-first-exception",
    "lint/suspicious/noBitwiseOperators": "https://biomejs.dev/linter/rules/no-bitwise-operators",
    "lint/suspicious/noCatchAssign": "https://biomejs.dev/linter/rules/no-catch-assign",
    "lint/suspicious/noClassAssign": "https://biomejs.dev/linter/rules/no-class-assign",
    "lint/suspicious/noCommentText": "https://biomejs.dev/linter/rules/no-comment-text",
    "lint/suspicious/noCompareNegZero": "https://biomejs.dev/linter/rules/no-compare-neg-zero",
    "lint/suspicious/noConfusingLabels": "https://biomejs.dev/linter/rules/no-confusing-labels",
    "lint/suspicious/noConfusingVoidType": "https://biomejs.dev/linter/rules/no-confusing-void-type",
    "lint/suspicious/noConsole": "https://biomejs.dev/linter/rules/no-console",
    "lint/suspicious/noConstEnum": "https://biomejs.dev/linter/rules/no-const-enum",
    "lint/suspicious/noConstantBinaryExpressions": "https://biomejs.dev/linter/rules/no-constant-binary-expressions",
    "lint/suspicious/noControlCharactersInRegex": "https://biomejs.dev/linter/rules/no-control-characters-in-regex",
    "lint/suspicious/noDebugger": "https://biomejs.dev/linter/rules/no-debugger",
    "lint/suspicious/noDocumentCookie": "https://biomejs.dev/linter/rules/no-document-cookie",
    "lint/suspicious/noDocumentImportInPage": "https://biomejs.dev/linter/rules/no-document-import-in-page",
    "lint/suspicious/noDoubleEquals": "https://biomejs.dev/linter/rules/no-double-equals",
    "lint/suspicious/noDuplicateAtImportRules": "https://biomejs.dev/linter/rules/no-duplicate-at-import-rules",
    "lint/suspicious/noDuplicateCase": "https://biomejs.dev/linter/rules/no-duplicate-case",
    "lint/suspicious/noDuplicateClassMembers": "https://biomejs.dev/linter/rules/no-duplicate-class-members",
    "lint/suspicious/noDuplicateCustomProperties": "https://biomejs.dev/linter/rules/no-duplicate-custom-properties",
    "lint/suspicious/noDuplicateElseIf": "https://biomejs.dev/linter/rules/no-duplicate-else-if",
    "lint/suspicious/noDuplicateFields": "https://biomejs.dev/linter/rules/no-duplicate-fields",
    "lint/suspicious/noDuplicateFontNames": "https://biomejs.dev/linter/rules/no-font-family-duplicate-names",
    "lint/suspicious/noDuplicateJsxProps": "https://biomejs.dev/linter/rules/no-duplicate-jsx-props",
    "lint/suspicious/noDuplicateObjectKeys": "https://biomejs.dev/linter/rules/no-duplicate-object-keys",
    "lint/suspicious/noDuplicateParameters": "https://biomejs.dev/linter/rules/no-duplicate-parameters",
    "lint/suspicious/noDuplicateProperties": "https://biomejs.dev/linter/rules/no-duplicate-properties",
    "lint/suspicious/noDuplicateSelectorsKeyframeBlock": "https://biomejs.dev/linter/rules/no-duplicate-selectors-keyframe-block",
    "lint/suspicious/noDuplicateTestHooks": "https://biomejs.dev/linter/rules/no-duplicate-test-hooks",
    "lint/suspicious/noEmptyBlock": "https://biomejs.dev/linter/rules/no-empty-block",
    "lint/suspicious/noEmptyBlockStatements": "https://biomejs.dev/linter/rules/no-empty-block-statements",
    "lint/suspicious/noEmptyInterface": "https://biomejs.dev/linter/rules/no-empty-interface",
    "lint/suspicious/noEvolvingTypes": "https://biomejs.dev/linter/rules/no-evolving-types",
    "lint/suspicious/noExplicitAny": "https://biomejs.dev/linter/rules/no-explicit-any",
    "lint/suspicious/noExportsInTest": "https://biomejs.dev/linter/rules/no-exports-in-test",
    "lint/suspicious/noExtraNonNullAssertion": "https://biomejs.dev/linter/rules/no-extra-non-null-assertion",
    "lint/suspicious/noFallthroughSwitchClause": "https://biomejs.dev/linter/rules/no-fallthrough-switch-clause",
    "lint/suspicious/noFocusedTests": "https://biomejs.dev/linter/rules/no-focused-tests",
    "lint/suspicious/noFunctionAssign": "https://biomejs.dev/linter/rules/no-function-assign",
    "lint/suspicious/noGlobalAssign": "https://biomejs.dev/linter/rules/no-global-assign",
    "lint/suspicious/noGlobalIsFinite": "https://biomejs.dev/linter/rules/no-global-is-finite",
    "lint/suspicious/noGlobalIsNan": "https://biomejs.dev/linter/rules/no-global-is-nan",
    "lint/suspicious/noHeadImportInDocument": "https://biomejs.dev/linter/rules/no-head-import-in-document",
    "lint/suspicious/noImplicitAnyLet": "https://biomejs.dev/linter/rules/no-implicit-any-let",
    "lint/suspicious/noImportAssign": "https://biomejs.dev/linter/rules/no-import-assign",
    "lint/suspicious/noImportantInKeyframe": "https://biomejs.dev/linter/rules/no-important-in-keyframe",
    "lint/suspicious/noIrregularWhitespace": "https://biomejs.dev/linter/rules/no-irregular-whitespace",
    "lint/suspicious/noLabelVar": "https://biomejs.dev/linter/rules/no-label-var",
    "lint/suspicious/noMisleadingCharacterClass": "https://biomejs.dev/linter/rules/no-misleading-character-class",
    "lint/suspicious/noMisleadingInstantiator": "https://biomejs.dev/linter/rules/no-misleading-instantiator",
    "lint/suspicious/noMisplacedAssertion": "https://biomejs.dev/linter/rules/no-misplaced-assertion",
    "lint/suspicious/noMisrefactoredShorthandAssign": "https://biomejs.dev/linter/rules/no-misrefactored-shorthand-assign",
    "lint/suspicious/noNonNullAssertedOptionalChain": "https://biomejs.dev/linter/rules/no-non-null-asserted-optional-chain",
    "lint/suspicious/noOctalEscape": "https://biomejs.dev/linter/rules/no-octal-escape",
    "lint/suspicious/noPrototypeBuiltins": "https://biomejs.dev/linter/rules/no-prototype-builtins",
    "lint/suspicious/noQuickfixBiome": "https://biomejs.dev/linter/rules/no-quickfix-biome",
    "lint/suspicious/noReactSpecificProps": "https://biomejs.dev/linter/rules/no-react-specific-props",
    "lint/suspicious/noRedeclare": "https://biomejs.dev/linter/rules/no-redeclare",
    "lint/suspicious/noRedundantUseStrict": "https://biomejs.dev/linter/rules/no-redundant-use-strict",
    "lint/suspicious/noSelfCompare": "https://biomejs.dev/linter/rules/no-self-compare",
    "lint/suspicious/noShadowRestrictedNames": "https://biomejs.dev/linter/rules/no-shadow-restricted-names",
    "lint/suspicious/noShorthandPropertyOverrides": "https://biomejs.dev/linter/rules/no-shorthand-property-overrides",
    "lint/suspicious/noSkippedTests": "https://biomejs.dev/linter/rules/no-skipped-tests",
    "lint/suspicious/noSparseArray": "https://biomejs.dev/linter/rules/no-sparse-array",
    "lint/suspicious/noSuspiciousSemicolonInJsx": "https://biomejs.dev/linter/rules/no-suspicious-semicolon-in-jsx",
    "lint/suspicious/noTemplateCurlyInString": "https://biomejs.dev/linter/rules/no-template-curly-in-string",
    "lint/suspicious/noThenProperty": "https://biomejs.dev/linter/rules/no-then-property",
    "lint/suspicious/noTsIgnore": "https://biomejs.dev/linter/rules/no-ts-ignore",
    "lint/suspicious/noUnassignedVariables": "https://biomejs.dev/linter/rules/no-unassigned-variables",
    "lint/suspicious/noUnknownAtRules": "https://biomejs.dev/linter/rules/no-unknown-at-rules",
    "lint/suspicious/noUnsafeDeclarationMerging": "https://biomejs.dev/linter/rules/no-unsafe-declaration-merging",
    "lint/suspicious/noUnsafeNegation": "https://biomejs.dev/linter/rules/no-unsafe-negation",
    "lint/suspicious/noUselessEscapeInString": "https://biomejs.dev/linter/rules/no-useless-escape-in-string",
    "lint/suspicious/noUselessRegexBackrefs": "https://biomejs.dev/linter/rules/no-useless-regex-backrefs",
    "lint/suspicious/noVar": "https://biomejs.dev/linter/rules/no-var",
    "lint/suspicious/noWith": "https://biomejs.dev/linter/rules/no-with",
    "lint/suspicious/useAdjacentOverloadSignatures": "https://biomejs.dev/linter/rules/use-adjacent-overload-signatures",
    "lint/suspicious/useAwait": "https://biomejs.dev/linter/rules/use-await",
    "lint/suspicious/useBiomeIgnoreFolder": "https://biomejs.dev/linter/rules/use-biome-ignore-folder",
    "lint/suspicious/useDefaultSwitchClauseLast": "https://biomejs.dev/linter/rules/use-default-switch-clause-last",
    "lint/suspicious/useErrorMessage": "https://biomejs.dev/linter/rules/use-error-message",
    "lint/suspicious/useGetterReturn": "https://biomejs.dev/linter/rules/use-getter-return",
    "lint/suspicious/useGoogleFontDisplay": "https://biomejs.dev/linter/rules/use-google-font-display",
    "lint/suspicious/useGuardForIn": "https://biomejs.dev/linter/rules/use-guard-for-in",
    "lint/suspicious/useIsArray": "https://biomejs.dev/linter/rules/use-is-array",
    "lint/suspicious/useIterableCallbackReturn": "https://biomejs.dev/linter/rules/use-iterable-callback-return",
    "lint/suspicious/useNamespaceKeyword": "https://biomejs.dev/linter/rules/use-namespace-keyword",
    "lint/suspicious/useNumberToFixedDigitsArgument": "https://biomejs.dev/linter/rules/use-number-to-fixed-digits-argument",
    "lint/suspicious/useStaticResponseMethods": "https://biomejs.dev/linter/rules/use-static-response-methods",
    "lint/suspicious/useStrictMode": "https://biomejs.dev/linter/rules/use-strict-mode",
    // end lint rules
    // start assist actions
    "assist/source/useSortedKeys": "https://biomejs.dev/assist/actions/use-sorted-keys",
    "assist/source/useSortedProperties": "https://biomejs.dev/assist/actions/use-sorted-properties",
    "assist/source/useSortedAttributes": "https://biomejs.dev/assist/actions/use-sorted-attributes",
    "assist/source/organizeImports": "https://biomejs.dev/assist/actions/organize-imports",
    // end assist actions
    ; // start syntax rules
    "syntax/correctness/noTypeOnlyImportAttributes",
    "syntax/correctness/noSuperWithoutExtends",
    "syntax/correctness/noInitializerWithDefinite",
    "syntax/correctness/noDuplicatePrivateClassMembers",
    // end syntax rules

    // General categories
    "files/missingHandler",
    "format",
    "check",
    "ci",
    "stdin",
    "init",
    "configuration",
    "assist",
    "migrate",
    "deserialize",
    "plugin",
    "project",
    "search",
    "internalError/io",
    "internalError/fs",
    "internalError/panic",
    "reporter/parse",
    "reporter/format",
    "reporter/violations",
    // parse categories
    "parse",

    // Lint groups
    "lint",
    "lint/a11y",
    "lint/complexity",
    "lint/correctness",
    "lint/nursery",
    "lint/performance",
    "lint/security",
    "lint/style",
    "lint/suspicious",
    "lint/plugin",

    // Suppression comments
    "suppressions/parse",
    "suppressions/unknownGroup",
    "suppressions/unknownRule",
    "suppressions/unknownAction",
    "suppressions/unused",
    "suppressions/incorrect",
    // Used in tests and examples
    "args/fileNotFound",
    "flags/invalid",
    "semanticTests",
}
