pub const BASIC_KEYWORDS: [&str; 5] = ["inherit", "initial", "revert", "revert-layer", "unset"];

// https://drafts.csswg.org/css-fonts/#system-family-name-value
pub const SYSTEM_FAMILY_NAME_KEYWORDS: [&str; 6] = [
    "caption",
    "icon",
    "menu",
    "message-box",
    "small-caption",
    "status-bar",
];

pub const FONT_FAMILY_KEYWORDS: [&str; 10] = [
    "cursive",
    "fantasy",
    "monospace",
    "sans-serif",
    "serif",
    "system-ui",
    "ui-monospace",
    "ui-rounded",
    "ui-sans-serif",
    "ui-serif",
];

pub const FONT_WEIGHT_ABSOLUTE_KEYWORDS: [&str; 2] = ["bold", "normal"];
pub const FONT_WEIGHT_NUMERIC_KEYWORDS: [&str; 9] = [
    "100", "200", "300", "400", "500", "600", "700", "800", "900",
];
pub const FONT_STYLE_KEYWORDS: [&str; 3] = ["italic", "normal", "oblique"];
pub const FONT_VARIANTS_KEYWORDS: [&str; 34] = [
    "all-petite-caps",
    "all-small-caps",
    "common-ligatures",
    "contextual",
    "diagonal-fractions",
    "discretionary-ligatures",
    "full-width",
    "historical-forms",
    "historical-ligatures",
    "jis04",
    "jis78",
    "jis83",
    "jis90",
    "lining-nums",
    "no-common-ligatures",
    "no-contextual",
    "no-discretionary-ligatures",
    "no-historical-ligatures",
    "none",
    "normal",
    "oldstyle-nums",
    "ordinal",
    "petite-caps",
    "proportional-nums",
    "proportional-width",
    "ruby",
    "simplified",
    "slashed-zero",
    "small-caps",
    "stacked-fractions",
    "tabular-nums",
    "titling-caps",
    "traditional",
    "unicase",
];

pub const FONT_STRETCH_KEYWORDS: [&str; 8] = [
    "condensed",
    "expanded",
    "extra-condensed",
    "extra-expanded",
    "semi-condensed",
    "semi-expanded",
    "ultra-condensed",
    "ultra-expanded",
];

pub const FONT_SIZE_KEYWORDS: [&str; 9] = [
    "large", "larger", "medium", "small", "smaller", "x-large", "x-small", "xx-large", "xx-small",
];

pub const LINE_HEIGHT_KEYWORDS: [&str; 1] = ["normal"];

/// List of known CSS value functions sourced from [`css-functions-list`](https://www.npmjs.com/package/css-functions-list).
/// See the original list [here](https://github.com/niksy/css-functions-list/blob/master/index.json).
pub const FUNCTION_KEYWORDS: &[&str] = &[
    "-moz-abs",
    "-moz-acos",
    "-moz-anchor",
    "-moz-anchor-size",
    "-moz-annotation",
    "-moz-asin",
    "-moz-atan",
    "-moz-atan2",
    "-moz-attr",
    "-moz-blur",
    "-moz-brightness",
    "-moz-calc",
    "-moz-calc-size",
    "-moz-character-variant",
    "-moz-circle",
    "-moz-clamp",
    "-moz-color",
    "-moz-color-contrast",
    "-moz-color-mix",
    "-moz-color-stop",
    "-moz-conic-gradient",
    "-moz-contrast",
    "-moz-cos",
    "-moz-counter",
    "-moz-counters",
    "-moz-cross-fade",
    "-moz-cubic-bezier",
    "-moz-device-cmyk",
    "-moz-drop-shadow",
    "-moz-element",
    "-moz-ellipse",
    "-moz-env",
    "-moz-exp",
    "-moz-fit-content",
    "-moz-format",
    "-moz-from",
    "-moz-gradient",
    "-moz-grayscale",
    "-moz-hsl",
    "-moz-hsla",
    "-moz-hue-rotate",
    "-moz-hwb",
    "-moz-hypot",
    "-moz-image",
    "-moz-image-rect",
    "-moz-image-set",
    "-moz-inset",
    "-moz-invert",
    "-moz-lab",
    "-moz-layer",
    "-moz-lch",
    "-moz-leader",
    "-moz-light-dark",
    "-moz-linear",
    "-moz-linear-gradient",
    "-moz-local",
    "-moz-log",
    "-moz-matrix",
    "-moz-matrix3d",
    "-moz-max",
    "-moz-min",
    "-moz-minmax",
    "-moz-mod",
    "-moz-oklab",
    "-moz-oklch",
    "-moz-opacity",
    "-moz-ornaments",
    "-moz-paint",
    "-moz-palette-mix",
    "-moz-path",
    "-moz-perspective",
    "-moz-polygon",
    "-moz-pow",
    "-moz-radial-gradient",
    "-moz-ray",
    "-moz-rect",
    "-moz-rem",
    "-moz-repeat",
    "-moz-repeating-conic-gradient",
    "-moz-repeating-linear-gradient",
    "-moz-repeating-radial-gradient",
    "-moz-reversed",
    "-moz-rgb",
    "-moz-rgba",
    "-moz-rotate",
    "-moz-rotate3d",
    "-moz-rotateX",
    "-moz-rotateY",
    "-moz-rotateZ",
    "-moz-rotatex",
    "-moz-rotatey",
    "-moz-rotatez",
    "-moz-round",
    "-moz-saturate",
    "-moz-scale",
    "-moz-scale3d",
    "-moz-scaleX",
    "-moz-scaleY",
    "-moz-scaleZ",
    "-moz-scalex",
    "-moz-scaley",
    "-moz-scalez",
    "-moz-scroll",
    "-moz-selector",
    "-moz-sepia",
    "-moz-shape",
    "-moz-sign",
    "-moz-sin",
    "-moz-skew",
    "-moz-skewX",
    "-moz-skewY",
    "-moz-skewx",
    "-moz-skewy",
    "-moz-sqrt",
    "-moz-steps",
    "-moz-styleset",
    "-moz-stylistic",
    "-moz-swash",
    "-moz-symbols",
    "-moz-tan",
    "-moz-target-counter",
    "-moz-target-counters",
    "-moz-target-text",
    "-moz-to",
    "-moz-translate",
    "-moz-translate3d",
    "-moz-translateX",
    "-moz-translateY",
    "-moz-translateZ",
    "-moz-translatex",
    "-moz-translatey",
    "-moz-translatez",
    "-moz-type",
    "-moz-url",
    "-moz-var",
    "-moz-view",
    "-moz-xywh",
    "-ms-abs",
    "-ms-acos",
    "-ms-anchor",
    "-ms-anchor-size",
    "-ms-annotation",
    "-ms-asin",
    "-ms-atan",
    "-ms-atan2",
    "-ms-attr",
    "-ms-blur",
    "-ms-brightness",
    "-ms-calc",
    "-ms-calc-size",
    "-ms-character-variant",
    "-ms-circle",
    "-ms-clamp",
    "-ms-color",
    "-ms-color-contrast",
    "-ms-color-mix",
    "-ms-color-stop",
    "-ms-conic-gradient",
    "-ms-contrast",
    "-ms-cos",
    "-ms-counter",
    "-ms-counters",
    "-ms-cross-fade",
    "-ms-cubic-bezier",
    "-ms-device-cmyk",
    "-ms-drop-shadow",
    "-ms-element",
    "-ms-ellipse",
    "-ms-env",
    "-ms-exp",
    "-ms-fit-content",
    "-ms-format",
    "-ms-from",
    "-ms-gradient",
    "-ms-grayscale",
    "-ms-hsl",
    "-ms-hsla",
    "-ms-hue-rotate",
    "-ms-hwb",
    "-ms-hypot",
    "-ms-image",
    "-ms-image-rect",
    "-ms-image-set",
    "-ms-inset",
    "-ms-invert",
    "-ms-lab",
    "-ms-layer",
    "-ms-lch",
    "-ms-leader",
    "-ms-light-dark",
    "-ms-linear",
    "-ms-linear-gradient",
    "-ms-local",
    "-ms-log",
    "-ms-matrix",
    "-ms-matrix3d",
    "-ms-max",
    "-ms-min",
    "-ms-minmax",
    "-ms-mod",
    "-ms-oklab",
    "-ms-oklch",
    "-ms-opacity",
    "-ms-ornaments",
    "-ms-paint",
    "-ms-palette-mix",
    "-ms-path",
    "-ms-perspective",
    "-ms-polygon",
    "-ms-pow",
    "-ms-radial-gradient",
    "-ms-ray",
    "-ms-rect",
    "-ms-rem",
    "-ms-repeat",
    "-ms-repeating-conic-gradient",
    "-ms-repeating-linear-gradient",
    "-ms-repeating-radial-gradient",
    "-ms-reversed",
    "-ms-rgb",
    "-ms-rgba",
    "-ms-rotate",
    "-ms-rotate3d",
    "-ms-rotateX",
    "-ms-rotateY",
    "-ms-rotateZ",
    "-ms-rotatex",
    "-ms-rotatey",
    "-ms-rotatez",
    "-ms-round",
    "-ms-saturate",
    "-ms-scale",
    "-ms-scale3d",
    "-ms-scaleX",
    "-ms-scaleY",
    "-ms-scaleZ",
    "-ms-scalex",
    "-ms-scaley",
    "-ms-scalez",
    "-ms-scroll",
    "-ms-selector",
    "-ms-sepia",
    "-ms-shape",
    "-ms-sign",
    "-ms-sin",
    "-ms-skew",
    "-ms-skewX",
    "-ms-skewY",
    "-ms-skewx",
    "-ms-skewy",
    "-ms-sqrt",
    "-ms-steps",
    "-ms-styleset",
    "-ms-stylistic",
    "-ms-swash",
    "-ms-symbols",
    "-ms-tan",
    "-ms-target-counter",
    "-ms-target-counters",
    "-ms-target-text",
    "-ms-to",
    "-ms-translate",
    "-ms-translate3d",
    "-ms-translateX",
    "-ms-translateY",
    "-ms-translateZ",
    "-ms-translatex",
    "-ms-translatey",
    "-ms-translatez",
    "-ms-type",
    "-ms-url",
    "-ms-var",
    "-ms-view",
    "-ms-xywh",
    "-o-abs",
    "-o-acos",
    "-o-anchor",
    "-o-anchor-size",
    "-o-annotation",
    "-o-asin",
    "-o-atan",
    "-o-atan2",
    "-o-attr",
    "-o-blur",
    "-o-brightness",
    "-o-calc",
    "-o-calc-size",
    "-o-character-variant",
    "-o-circle",
    "-o-clamp",
    "-o-color",
    "-o-color-contrast",
    "-o-color-mix",
    "-o-color-stop",
    "-o-conic-gradient",
    "-o-contrast",
    "-o-cos",
    "-o-counter",
    "-o-counters",
    "-o-cross-fade",
    "-o-cubic-bezier",
    "-o-device-cmyk",
    "-o-drop-shadow",
    "-o-element",
    "-o-ellipse",
    "-o-env",
    "-o-exp",
    "-o-fit-content",
    "-o-format",
    "-o-from",
    "-o-gradient",
    "-o-grayscale",
    "-o-hsl",
    "-o-hsla",
    "-o-hue-rotate",
    "-o-hwb",
    "-o-hypot",
    "-o-image",
    "-o-image-rect",
    "-o-image-set",
    "-o-inset",
    "-o-invert",
    "-o-lab",
    "-o-layer",
    "-o-lch",
    "-o-leader",
    "-o-light-dark",
    "-o-linear",
    "-o-linear-gradient",
    "-o-local",
    "-o-log",
    "-o-matrix",
    "-o-matrix3d",
    "-o-max",
    "-o-min",
    "-o-minmax",
    "-o-mod",
    "-o-oklab",
    "-o-oklch",
    "-o-opacity",
    "-o-ornaments",
    "-o-paint",
    "-o-palette-mix",
    "-o-path",
    "-o-perspective",
    "-o-polygon",
    "-o-pow",
    "-o-radial-gradient",
    "-o-ray",
    "-o-rect",
    "-o-rem",
    "-o-repeat",
    "-o-repeating-conic-gradient",
    "-o-repeating-linear-gradient",
    "-o-repeating-radial-gradient",
    "-o-reversed",
    "-o-rgb",
    "-o-rgba",
    "-o-rotate",
    "-o-rotate3d",
    "-o-rotateX",
    "-o-rotateY",
    "-o-rotateZ",
    "-o-rotatex",
    "-o-rotatey",
    "-o-rotatez",
    "-o-round",
    "-o-saturate",
    "-o-scale",
    "-o-scale3d",
    "-o-scaleX",
    "-o-scaleY",
    "-o-scaleZ",
    "-o-scalex",
    "-o-scaley",
    "-o-scalez",
    "-o-scroll",
    "-o-selector",
    "-o-sepia",
    "-o-shape",
    "-o-sign",
    "-o-sin",
    "-o-skew",
    "-o-skewX",
    "-o-skewY",
    "-o-skewx",
    "-o-skewy",
    "-o-sqrt",
    "-o-steps",
    "-o-styleset",
    "-o-stylistic",
    "-o-swash",
    "-o-symbols",
    "-o-tan",
    "-o-target-counter",
    "-o-target-counters",
    "-o-target-text",
    "-o-to",
    "-o-translate",
    "-o-translate3d",
    "-o-translateX",
    "-o-translateY",
    "-o-translateZ",
    "-o-translatex",
    "-o-translatey",
    "-o-translatez",
    "-o-type",
    "-o-url",
    "-o-var",
    "-o-view",
    "-o-xywh",
    "-webkit-abs",
    "-webkit-acos",
    "-webkit-anchor",
    "-webkit-anchor-size",
    "-webkit-annotation",
    "-webkit-asin",
    "-webkit-atan",
    "-webkit-atan2",
    "-webkit-attr",
    "-webkit-blur",
    "-webkit-brightness",
    "-webkit-calc",
    "-webkit-calc-size",
    "-webkit-character-variant",
    "-webkit-circle",
    "-webkit-clamp",
    "-webkit-color",
    "-webkit-color-contrast",
    "-webkit-color-mix",
    "-webkit-color-stop",
    "-webkit-conic-gradient",
    "-webkit-contrast",
    "-webkit-cos",
    "-webkit-counter",
    "-webkit-counters",
    "-webkit-cross-fade",
    "-webkit-cubic-bezier",
    "-webkit-device-cmyk",
    "-webkit-drop-shadow",
    "-webkit-element",
    "-webkit-ellipse",
    "-webkit-env",
    "-webkit-exp",
    "-webkit-fit-content",
    "-webkit-format",
    "-webkit-from",
    "-webkit-gradient",
    "-webkit-grayscale",
    "-webkit-hsl",
    "-webkit-hsla",
    "-webkit-hue-rotate",
    "-webkit-hwb",
    "-webkit-hypot",
    "-webkit-image",
    "-webkit-image-rect",
    "-webkit-image-set",
    "-webkit-inset",
    "-webkit-invert",
    "-webkit-lab",
    "-webkit-layer",
    "-webkit-lch",
    "-webkit-leader",
    "-webkit-light-dark",
    "-webkit-linear",
    "-webkit-linear-gradient",
    "-webkit-local",
    "-webkit-log",
    "-webkit-matrix",
    "-webkit-matrix3d",
    "-webkit-max",
    "-webkit-min",
    "-webkit-minmax",
    "-webkit-mod",
    "-webkit-oklab",
    "-webkit-oklch",
    "-webkit-opacity",
    "-webkit-ornaments",
    "-webkit-paint",
    "-webkit-palette-mix",
    "-webkit-path",
    "-webkit-perspective",
    "-webkit-polygon",
    "-webkit-pow",
    "-webkit-radial-gradient",
    "-webkit-ray",
    "-webkit-rect",
    "-webkit-rem",
    "-webkit-repeat",
    "-webkit-repeating-conic-gradient",
    "-webkit-repeating-linear-gradient",
    "-webkit-repeating-radial-gradient",
    "-webkit-reversed",
    "-webkit-rgb",
    "-webkit-rgba",
    "-webkit-rotate",
    "-webkit-rotate3d",
    "-webkit-rotateX",
    "-webkit-rotateY",
    "-webkit-rotateZ",
    "-webkit-rotatex",
    "-webkit-rotatey",
    "-webkit-rotatez",
    "-webkit-round",
    "-webkit-saturate",
    "-webkit-scale",
    "-webkit-scale3d",
    "-webkit-scaleX",
    "-webkit-scaleY",
    "-webkit-scaleZ",
    "-webkit-scalex",
    "-webkit-scaley",
    "-webkit-scalez",
    "-webkit-scroll",
    "-webkit-selector",
    "-webkit-sepia",
    "-webkit-shape",
    "-webkit-sign",
    "-webkit-sin",
    "-webkit-skew",
    "-webkit-skewX",
    "-webkit-skewY",
    "-webkit-skewx",
    "-webkit-skewy",
    "-webkit-sqrt",
    "-webkit-steps",
    "-webkit-styleset",
    "-webkit-stylistic",
    "-webkit-swash",
    "-webkit-symbols",
    "-webkit-tan",
    "-webkit-target-counter",
    "-webkit-target-counters",
    "-webkit-target-text",
    "-webkit-to",
    "-webkit-translate",
    "-webkit-translate3d",
    "-webkit-translateX",
    "-webkit-translateY",
    "-webkit-translateZ",
    "-webkit-translatex",
    "-webkit-translatey",
    "-webkit-translatez",
    "-webkit-type",
    "-webkit-url",
    "-webkit-var",
    "-webkit-view",
    "-webkit-xywh",
    "abs",
    "acos",
    "anchor",
    "anchor-size",
    "annotation",
    "asin",
    "atan",
    "atan2",
    "attr",
    "blur",
    "brightness",
    "calc",
    "calc-size",
    "character-variant",
    "circle",
    "clamp",
    "color",
    "color-contrast",
    "color-mix",
    "color-stop",
    "conic-gradient",
    "contrast",
    "cos",
    "counter",
    "counters",
    "cross-fade",
    "cubic-bezier",
    "device-cmyk",
    "drop-shadow",
    "element",
    "ellipse",
    "env",
    "exp",
    "fit-content",
    "format",
    "from",
    "gradient",
    "grayscale",
    "hsl",
    "hsla",
    "hue-rotate",
    "hwb",
    "hypot",
    "image",
    "image-rect",
    "image-set",
    "inset",
    "invert",
    "lab",
    "layer",
    "lch",
    "leader",
    "light-dark",
    "linear",
    "linear-gradient",
    "local",
    "log",
    "matrix",
    "matrix3d",
    "max",
    "min",
    "minmax",
    "mod",
    "oklab",
    "oklch",
    "opacity",
    "ornaments",
    "paint",
    "palette-mix",
    "path",
    "perspective",
    "polygon",
    "pow",
    "radial-gradient",
    "ray",
    "rect",
    "rem",
    "repeat",
    "repeating-conic-gradient",
    "repeating-linear-gradient",
    "repeating-radial-gradient",
    "reversed",
    "rgb",
    "rgba",
    "rotate",
    "rotate3d",
    "rotateX",
    "rotateY",
    "rotateZ",
    "rotatex",
    "rotatey",
    "rotatez",
    "round",
    "saturate",
    "scale",
    "scale3d",
    "scaleX",
    "scaleY",
    "scaleZ",
    "scalex",
    "scaley",
    "scalez",
    "scroll",
    "selector",
    "sepia",
    "shape",
    "sign",
    "sin",
    "skew",
    "skewX",
    "skewY",
    "skewx",
    "skewy",
    "sqrt",
    "steps",
    "styleset",
    "stylistic",
    "swash",
    "symbols",
    "tan",
    "target-counter",
    "target-counters",
    "target-text",
    "tech",
    "to",
    "translate",
    "translate3d",
    "translateX",
    "translateY",
    "translateZ",
    "translatex",
    "translatey",
    "translatez",
    "type",
    "url",
    "var",
    "view",
    "xywh",
];

// These are the ones that can have single-colon notation
pub const LEVEL_ONE_AND_TWO_PSEUDO_ELEMENTS: [&str; 5] =
    ["after", "before", "first-letter", "first-line", "slotted"];

pub const VENDOR_SPECIFIC_PSEUDO_ELEMENTS: [&str; 66] = [
    "-moz-focus-inner",
    "-moz-focus-outer",
    "-moz-list-bullet",
    "-moz-meter-bar",
    "-moz-placeholder",
    "-moz-progress-bar",
    "-moz-range-progress",
    "-moz-range-thumb",
    "-moz-range-track",
    "-ms-browse",
    "-ms-check",
    "-ms-clear",
    "-ms-expand",
    "-ms-fill",
    "-ms-fill-lower",
    "-ms-fill-upper",
    "-ms-reveal",
    "-ms-thumb",
    "-ms-ticks-after",
    "-ms-ticks-before",
    "-ms-tooltip",
    "-ms-track",
    "-ms-value",
    "-webkit-calendar-picker-indicator",
    "-webkit-clear-button",
    "-webkit-color-swatch",
    "-webkit-color-swatch-wrapper",
    "-webkit-date-and-time-value",
    "-webkit-datetime-edit",
    "-webkit-datetime-edit-ampm-field",
    "-webkit-datetime-edit-day-field",
    "-webkit-datetime-edit-fields-wrapper",
    "-webkit-datetime-edit-hour-field",
    "-webkit-datetime-edit-millisecond-field",
    "-webkit-datetime-edit-minute-field",
    "-webkit-datetime-edit-month-field",
    "-webkit-datetime-edit-second-field",
    "-webkit-datetime-edit-text",
    "-webkit-datetime-edit-week-field",
    "-webkit-datetime-edit-year-field",
    "-webkit-details-marker",
    "-webkit-distributed",
    "-webkit-file-upload-button",
    "-webkit-input-placeholder",
    "-webkit-keygen-select",
    "-webkit-meter-bar",
    "-webkit-meter-even-less-good-value",
    "-webkit-meter-inner-element",
    "-webkit-meter-optimum-value",
    "-webkit-meter-suboptimum-value",
    "-webkit-progress-bar",
    "-webkit-progress-inner-element",
    "-webkit-progress-value",
    "-webkit-search-cancel-button",
    "-webkit-search-decoration",
    "-webkit-search-results-button",
    "-webkit-search-results-decoration",
    "-webkit-slider-runnable-track",
    "-webkit-slider-thumb",
    "-webkit-textfield-decoration-container",
    "-webkit-validation-bubble",
    "-webkit-validation-bubble-arrow",
    "-webkit-validation-bubble-arrow-clipper",
    "-webkit-validation-bubble-heading",
    "-webkit-validation-bubble-message",
    "-webkit-validation-bubble-text-block",
];

pub const SHADOW_TREE_PSEUDO_ELEMENTS: [&str; 1] = ["part"];

pub const OTHER_PSEUDO_ELEMENTS: [&str; 22] = [
    "backdrop",
    "content",
    "cue",
    "details-content",
    "file-selector-button",
    "grammar-error",
    "highlight",
    "marker",
    "placeholder",
    "prefix",
    "search-text",
    "selection",
    "shadow",
    "slotted",
    "spelling-error",
    "suffix",
    "target-text",
    "view-transition",
    "view-transition-group",
    "view-transition-image-pair",
    "view-transition-new",
    "view-transition-old",
];

/// List of known vendor prefixes
// The order of this affects the behavior of the useSortedProperties rule.
pub const VENDOR_PREFIXES: [&str; 4] = ["-moz-", "-ms-", "-o-", "-webkit-"];

pub const AT_RULE_PAGE_PSEUDO_CLASSES: [&str; 4] = ["blank", "first", "left", "right"];

pub const WEBKIT_SCROLLBAR_PSEUDO_ELEMENTS: [&str; 7] = [
    "-webkit-resizer",
    "-webkit-scrollbar",
    "-webkit-scrollbar-button",
    "-webkit-scrollbar-corner",
    "-webkit-scrollbar-thumb",
    "-webkit-scrollbar-track",
    "-webkit-scrollbar-track-piece",
];

pub const WEBKIT_SCROLLBAR_PSEUDO_CLASSES: [&str; 11] = [
    "corner-present",
    "decrement",
    "double-button",
    "end",
    "horizontal",
    "increment",
    "no-button",
    "single-button",
    "start",
    "vertical",
    "window-inactive",
];

pub const A_NPLUS_BNOTATION_PSEUDO_CLASSES: [&str; 4] = [
    "nth-column",
    "nth-last-column",
    "nth-last-of-type",
    "nth-of-type",
];

pub const A_NPLUS_BOF_SNOTATION_PSEUDO_CLASSES: [&str; 2] = ["nth-child", "nth-last-child"];

pub const LINGUISTIC_PSEUDO_CLASSES: [&str; 2] = ["dir", "lang"];

pub const LOGICAL_COMBINATIONS_PSEUDO_CLASSES: [&str; 5] = ["has", "is", "matches", "not", "where"];

/// See https://drafts.csswg.org/selectors/#resource-pseudos
pub const RESOURCE_STATE_PSEUDO_CLASSES: [&str; 7] = [
    "buffering",
    "muted",
    "paused",
    "playing",
    "seeking",
    "stalled",
    "volume-locked",
];

pub const OTHER_PSEUDO_CLASSES: [&str; 51] = [
    "active",
    "any-link",
    "autofill",
    "blank",
    "checked",
    "current",
    "default",
    "defined",
    "disabled",
    "empty",
    "enabled",
    "first-child",
    "first-of-type",
    "focus",
    "focus-visible",
    "focus-within",
    "fullscreen",
    "fullscreen-ancestor",
    "future",
    "host",
    "host-context",
    "hover",
    "in-range",
    "indeterminate",
    "invalid",
    "last-child",
    "last-of-type",
    "link",
    "modal",
    "only-child",
    "only-of-type",
    "open",
    "optional",
    "out-of-range",
    "past",
    "picture-in-picture",
    "placeholder-shown",
    "popover-open",
    "read-only",
    "read-write",
    "required",
    "root",
    "scope",
    "state",
    "target",
    "unresolved",
    "user-invalid",
    "user-valid",
    "valid",
    "visited",
    "window-inactive",
];

// CSS Modules pseudo-classes
// https://github.com/css-modules/css-modules
pub const CSS_MODULE_PSEUDO_CLASSES: [&str; 2] = ["global", "local"];

// https://github.com/known-css/known-css-properties/blob/master/source/w3c.json
pub const KNOWN_PROPERTIES: &[&str] = &[
    "-webkit-line-clamp",
    "accent-color",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "all",
    "anchor-name",
    "anchor-scope",
    "animation",
    "animation-composition",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-range",
    "animation-range-end",
    "animation-range-start",
    "animation-timeline",
    "animation-timing-function",
    "appearance",
    "aspect-ratio",
    "azimuth",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-repeat",
    "background-size",
    "baseline-shift",
    "baseline-source",
    "block-ellipsis",
    "block-size",
    "block-step",
    "block-step-align",
    "block-step-insert",
    "block-step-round",
    "block-step-size",
    "bookmark-label",
    "bookmark-level",
    "bookmark-state",
    "border",
    "border-block",
    "border-block-color",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-block-style",
    "border-block-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-boundary",
    "border-collapse",
    "border-color",
    "border-end-end-radius",
    "border-end-start-radius",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline",
    "border-inline-color",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-inline-style",
    "border-inline-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-start-end-radius",
    "border-start-start-radius",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-decoration-break",
    "box-shadow",
    "box-sizing",
    "box-snap",
    "break-after",
    "break-before",
    "break-inside",
    "caption-side",
    "caret",
    "caret-animation",
    "caret-color",
    "caret-shape",
    "chains",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-adjust",
    "color-interpolation-filters",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "contain-intrinsic-block-size",
    "contain-intrinsic-height",
    "contain-intrinsic-inline-size",
    "contain-intrinsic-size",
    "contain-intrinsic-width",
    "container",
    "container-name",
    "container-type",
    "content",
    "content-visibility",
    "continue",
    "counter-increment",
    "counter-reset",
    "counter-set",
    "cue",
    "cue-after",
    "cue-before",
    "cursor",
    "direction",
    "display",
    "dominant-baseline",
    "elevation",
    "empty-cells",
    "field-sizing",
    "fill",
    "fill-break",
    "fill-color",
    "fill-image",
    "fill-opacity",
    "fill-origin",
    "fill-position",
    "fill-repeat",
    "fill-rule",
    "fill-size",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "float-defer",
    "float-offset",
    "float-reference",
    "flood-color",
    "flood-opacity",
    "flow",
    "flow-from",
    "flow-into",
    "font",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-language-override",
    "font-optical-sizing",
    "font-palette",
    "font-size",
    "font-size-adjust",
    "font-stretch",
    "font-style",
    "font-synthesis",
    "font-synthesis-position",
    "font-synthesis-small-caps",
    "font-synthesis-style",
    "font-synthesis-weight",
    "font-variant",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-emoji",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variant-position",
    "font-variation-settings",
    "font-weight",
    "font-width",
    "footnote-display",
    "footnote-policy",
    "forced-color-adjust",
    "gap",
    "glyph-orientation-vertical",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-start",
    "grid-row",
    "grid-row-end",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "hanging-punctuation",
    "height",
    "hyphenate-character",
    "hyphenate-limit-chars",
    "hyphenate-limit-last",
    "hyphenate-limit-lines",
    "hyphenate-limit-zone",
    "hyphens",
    "image-orientation",
    "image-rendering",
    "image-resolution",
    "initial-letter",
    "initial-letter-align",
    "initial-letter-wrap",
    "inline-size",
    "inline-sizing",
    "input-security",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "interpolate-size",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-clamp",
    "line-fit-edge",
    "line-grid",
    "line-height",
    "line-height-step",
    "line-padding",
    "line-snap",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-break",
    "margin-inline",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "margin-trim",
    "marker",
    "marker-end",
    "marker-knockout-left",
    "marker-knockout-right",
    "marker-mid",
    "marker-pattern",
    "marker-segment",
    "marker-side",
    "marker-start",
    "mask",
    "mask-border",
    "mask-border-mode",
    "mask-border-outset",
    "mask-border-repeat",
    "mask-border-slice",
    "mask-border-source",
    "mask-border-width",
    "mask-clip",
    "mask-composite",
    "mask-image",
    "mask-mode",
    "mask-origin",
    "mask-position",
    "mask-repeat",
    "mask-size",
    "mask-type",
    "masonry",
    "masonry-auto-tracks",
    "masonry-direction",
    "masonry-fill",
    "masonry-flow",
    "masonry-slack",
    "masonry-template-areas",
    "masonry-template-tracks",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-lines",
    "max-width",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-intrinsic-sizing",
    "min-width",
    "mix-blend-mode",
    "nav-down",
    "nav-left",
    "nav-right",
    "nav-up",
    "navigation", // https://www.w3.org/TR/css-view-transitions-2/#view-transition-navigation-descriptor
    "object-fit",
    "object-position",
    "offset",
    "offset-anchor",
    "offset-distance",
    "offset-path",
    "offset-position",
    "offset-rotate",
    "opacity",
    "order",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-anchor",
    "overflow-block",
    "overflow-clip-margin",
    "overflow-clip-margin-block",
    "overflow-clip-margin-block-end",
    "overflow-clip-margin-block-start",
    "overflow-clip-margin-bottom",
    "overflow-clip-margin-inline",
    "overflow-clip-margin-inline-end",
    "overflow-clip-margin-inline-start",
    "overflow-clip-margin-left",
    "overflow-clip-margin-right",
    "overflow-clip-margin-top",
    "overflow-inline",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "padding",
    "padding-block",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "pause",
    "pause-after",
    "pause-before",
    "perspective",
    "perspective-origin",
    "pitch",
    "pitch-range",
    "place-content",
    "place-items",
    "place-self",
    "play-during",
    "pointer-events",
    "position",
    "position-anchor",
    "position-area",
    "position-try",
    "position-try-fallbacks",
    "position-try-order",
    "position-visibility",
    "print-color-adjust",
    "property-name",
    "quotes",
    "region-fragment",
    "resize",
    "rest",
    "rest-after",
    "rest-before",
    "richness",
    "right",
    "rotate",
    "row-gap",
    "ruby-align",
    "ruby-merge",
    "ruby-overhang",
    "ruby-position",
    "running",
    "scale",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-stop",
    "scroll-snap-type",
    "scroll-start-target",
    "scroll-timeline",
    "scroll-timeline-axis",
    "scroll-timeline-name",
    "scrollbar-color",
    "scrollbar-gutter",
    "scrollbar-width",
    "shape-image-threshold",
    "shape-inside",
    "shape-margin",
    "shape-outside",
    "spatial-navigation-action",
    "spatial-navigation-contain",
    "spatial-navigation-function",
    "speak",
    "speak-as",
    "speak-header",
    "speak-numeral",
    "speak-punctuation",
    "speech-rate",
    "stress",
    "string-set",
    "stroke",
    "stroke-align",
    "stroke-alignment",
    "stroke-break",
    "stroke-color",
    "stroke-dash-corner",
    "stroke-dash-justify",
    "stroke-dashadjust",
    "stroke-dasharray",
    "stroke-dashcorner",
    "stroke-dashoffset",
    "stroke-image",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-origin",
    "stroke-position",
    "stroke-repeat",
    "stroke-size",
    "stroke-width",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-all",
    "text-align-last",
    "text-autospace",
    "text-box",
    "text-box-edge",
    "text-box-trim",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip",
    "text-decoration-skip-box",
    "text-decoration-skip-ink",
    "text-decoration-skip-inset",
    "text-decoration-skip-self",
    "text-decoration-skip-spaces",
    "text-decoration-style",
    "text-decoration-thickness",
    "text-decoration-trim",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-skip",
    "text-emphasis-style",
    "text-group-align",
    "text-indent",
    "text-justify",
    "text-orientation",
    "text-overflow",
    "text-shadow",
    "text-spacing",
    "text-spacing-trim",
    "text-transform",
    "text-underline-offset",
    "text-underline-position",
    "text-wrap",
    "text-wrap-mode",
    "text-wrap-style",
    "timeline-scope",
    "top",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-behavior",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "translate",
    "unicode-bidi",
    "user-select",
    "vertical-align",
    "view-timeline",
    "view-timeline-axis",
    "view-timeline-inset",
    "view-timeline-name",
    "view-transition-class",
    "view-transition-group",
    "view-transition-name",
    "visibility",
    "voice-balance",
    "voice-duration",
    "voice-family",
    "voice-pitch",
    "voice-range",
    "voice-rate",
    "voice-stress",
    "voice-volume",
    "volume",
    "white-space",
    "white-space-collapse",
    "white-space-trim",
    "widows",
    "width",
    "will-change",
    "word-break",
    "word-space-transform",
    "word-spacing",
    "word-wrap",
    "wrap-after",
    "wrap-before",
    "wrap-flow",
    "wrap-inside",
    "wrap-through",
    "writing-mode",
    "z-index",
    "zoom",
];
// https://github.com/known-css/known-css-properties/blob/master/source/browsers/chrome-122.0.json
pub const KNOWN_CHROME_PROPERTIES: [&str; 619] = [
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-app-region",
    "-webkit-appearance",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-after",
    "-webkit-border-after-color",
    "-webkit-border-after-style",
    "-webkit-border-after-width",
    "-webkit-border-before",
    "-webkit-border-before-color",
    "-webkit-border-before-style",
    "-webkit-border-before-width",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-end",
    "-webkit-border-end-color",
    "-webkit-border-end-style",
    "-webkit-border-end-width",
    "-webkit-border-horizontal-spacing",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-start",
    "-webkit-border-start-color",
    "-webkit-border-start-style",
    "-webkit-border-start-width",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-border-vertical-spacing",
    "-webkit-box-align",
    "-webkit-box-decoration-break",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-reflect",
    "-webkit-box-shadow",
    "-webkit-box-sizing",
    "-webkit-clip-path",
    "-webkit-column-break-after",
    "-webkit-column-break-before",
    "-webkit-column-break-inside",
    "-webkit-column-count",
    "-webkit-column-gap",
    "-webkit-column-rule",
    "-webkit-column-rule-color",
    "-webkit-column-rule-style",
    "-webkit-column-rule-width",
    "-webkit-column-span",
    "-webkit-column-width",
    "-webkit-columns",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-font-feature-settings",
    "-webkit-font-smoothing",
    "-webkit-hyphenate-character",
    "-webkit-justify-content",
    "-webkit-line-break",
    "-webkit-line-clamp",
    "-webkit-locale",
    "-webkit-logical-height",
    "-webkit-logical-width",
    "-webkit-margin-after",
    "-webkit-margin-before",
    "-webkit-margin-end",
    "-webkit-margin-start",
    "-webkit-mask",
    "-webkit-mask-box-image",
    "-webkit-mask-box-image-outset",
    "-webkit-mask-box-image-repeat",
    "-webkit-mask-box-image-slice",
    "-webkit-mask-box-image-source",
    "-webkit-mask-box-image-width",
    "-webkit-mask-clip",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-origin",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-size",
    "-webkit-max-logical-height",
    "-webkit-max-logical-width",
    "-webkit-min-logical-height",
    "-webkit-min-logical-width",
    "-webkit-opacity",
    "-webkit-order",
    "-webkit-padding-after",
    "-webkit-padding-before",
    "-webkit-padding-end",
    "-webkit-padding-start",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-perspective-origin-x",
    "-webkit-perspective-origin-y",
    "-webkit-print-color-adjust",
    "-webkit-rtl-ordering",
    "-webkit-ruby-position",
    "-webkit-shape-image-threshold",
    "-webkit-shape-margin",
    "-webkit-shape-outside",
    "-webkit-tap-highlight-color",
    "-webkit-text-combine",
    "-webkit-text-decorations-in-effect",
    "-webkit-text-emphasis",
    "-webkit-text-emphasis-color",
    "-webkit-text-emphasis-position",
    "-webkit-text-emphasis-style",
    "-webkit-text-fill-color",
    "-webkit-text-orientation",
    "-webkit-text-security",
    "-webkit-text-size-adjust",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-origin-x",
    "-webkit-transform-origin-y",
    "-webkit-transform-origin-z",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-drag",
    "-webkit-user-modify",
    "-webkit-user-select",
    "-webkit-writing-mode",
    "accent-color",
    "additive-symbols",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "all",
    "animation",
    "animation-composition",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-range",
    "animation-range-end",
    "animation-range-start",
    "animation-timeline",
    "animation-timing-function",
    "app-region",
    "appearance",
    "ascent-override",
    "aspect-ratio",
    "backdrop-filter",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-size",
    "base-palette",
    "baseline-shift",
    "baseline-source",
    "block-size",
    "border",
    "border-block",
    "border-block-color",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-block-style",
    "border-block-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-end-end-radius",
    "border-end-start-radius",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline",
    "border-inline-color",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-inline-style",
    "border-inline-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-start-end-radius",
    "border-start-start-radius",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "buffered-rendering",
    "caption-side",
    "caret-color",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-interpolation",
    "color-interpolation-filters",
    "color-rendering",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "contain-intrinsic-block-size",
    "contain-intrinsic-height",
    "contain-intrinsic-inline-size",
    "contain-intrinsic-size",
    "contain-intrinsic-width",
    "container",
    "container-name",
    "container-type",
    "content",
    "content-visibility",
    "counter-increment",
    "counter-reset",
    "counter-set",
    "cursor",
    "cx",
    "cy",
    "d",
    "descent-override",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fallback",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "flood-color",
    "flood-opacity",
    "font",
    "font-display",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-optical-sizing",
    "font-palette",
    "font-size",
    "font-stretch",
    "font-style",
    "font-synthesis",
    "font-synthesis-small-caps",
    "font-synthesis-style",
    "font-synthesis-weight",
    "font-variant",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variant-position",
    "font-variation-settings",
    "font-weight",
    "forced-color-adjust",
    "gap",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "height",
    "hyphenate-character",
    "hyphenate-limit-chars",
    "hyphens",
    "image-orientation",
    "image-rendering",
    "inherits",
    "initial-letter",
    "initial-value",
    "inline-size",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-gap-override",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-inline",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-clip",
    "mask-composite",
    "mask-image",
    "mask-mode",
    "mask-origin",
    "mask-position",
    "mask-repeat",
    "mask-size",
    "mask-type",
    "math-depth",
    "math-shift",
    "math-style",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-width",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-width",
    "mix-blend-mode",
    "negative",
    "object-fit",
    "object-position",
    "object-view-box",
    "offset",
    "offset-anchor",
    "offset-distance",
    "offset-path",
    "offset-position",
    "offset-rotate",
    "opacity",
    "order",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-anchor",
    "overflow-clip-margin",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "overlay",
    "override-colors",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "pad",
    "padding",
    "padding-block",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "page-orientation",
    "paint-order",
    "perspective",
    "perspective-origin",
    "place-content",
    "place-items",
    "place-self",
    "pointer-events",
    "position",
    "prefix",
    "quotes",
    "r",
    "range",
    "resize",
    "right",
    "rotate",
    "row-gap",
    "ruby-position",
    "rx",
    "ry",
    "scale",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-stop",
    "scroll-snap-type",
    "scroll-timeline",
    "scroll-timeline-axis",
    "scroll-timeline-name",
    "scrollbar-color",
    "scrollbar-gutter",
    "scrollbar-width",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "shape-rendering",
    "size",
    "size-adjust",
    "speak",
    "speak-as",
    "src",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "suffix",
    "symbols",
    "syntax",
    "system",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-decoration-thickness",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-style",
    "text-indent",
    "text-orientation",
    "text-overflow",
    "text-rendering",
    "text-shadow",
    "text-size-adjust",
    "text-transform",
    "text-underline-offset",
    "text-underline-position",
    "text-wrap",
    "timeline-scope",
    "top",
    "touch-action",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-behavior",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "translate",
    "unicode-bidi",
    "unicode-range",
    "user-select",
    "vector-effect",
    "vertical-align",
    "view-timeline",
    "view-timeline-axis",
    "view-timeline-inset",
    "view-timeline-name",
    "view-transition-name",
    "visibility",
    "white-space",
    "white-space-collapse",
    "widows",
    "width",
    "will-change",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "x",
    "y",
    "z-index",
    "zoom",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/edge-18.0.json
pub const KNOWN_EDGE_PROPERTIES: [&str; 386] = [
    "-ms-content-zoom-chaining",
    "-ms-content-zoom-limit",
    "-ms-content-zoom-limit-max",
    "-ms-content-zoom-limit-min",
    "-ms-content-zoom-snap",
    "-ms-content-zoom-snap-points",
    "-ms-content-zoom-snap-type",
    "-ms-content-zooming",
    "-ms-flow-from",
    "-ms-flow-into",
    "-ms-font-feature-settings",
    "-ms-grid-column",
    "-ms-grid-column-align",
    "-ms-grid-column-span",
    "-ms-grid-columns",
    "-ms-grid-row",
    "-ms-grid-row-align",
    "-ms-grid-row-span",
    "-ms-grid-rows",
    "-ms-high-contrast-adjust",
    "-ms-hyphenate-limit-chars",
    "-ms-hyphenate-limit-lines",
    "-ms-hyphenate-limit-zone",
    "-ms-hyphens",
    "-ms-ime-align",
    "-ms-overflow-style",
    "-ms-scroll-chaining",
    "-ms-scroll-limit",
    "-ms-scroll-limit-x-max",
    "-ms-scroll-limit-x-min",
    "-ms-scroll-limit-y-max",
    "-ms-scroll-limit-y-min",
    "-ms-scroll-rails",
    "-ms-scroll-snap-points-x",
    "-ms-scroll-snap-points-y",
    "-ms-scroll-snap-type",
    "-ms-scroll-snap-x",
    "-ms-scroll-snap-y",
    "-ms-scroll-translation",
    "-ms-text-combine-horizontal",
    "-ms-text-size-adjust",
    "-ms-touch-select",
    "-ms-user-select",
    "-ms-wrap-flow",
    "-ms-wrap-margin",
    "-ms-wrap-through",
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-appearance",
    "-webkit-backdrop-filter",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-box-align",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-sizing",
    "-webkit-column-break-after",
    "-webkit-column-break-before",
    "-webkit-column-break-inside",
    "-webkit-column-count",
    "-webkit-column-gap",
    "-webkit-column-rule",
    "-webkit-column-rule-color",
    "-webkit-column-rule-style",
    "-webkit-column-rule-width",
    "-webkit-column-span",
    "-webkit-column-width",
    "-webkit-columns",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-justify-content",
    "-webkit-line-clamp",
    "-webkit-mask",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-size",
    "-webkit-order",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-tap-highlight-color",
    "-webkit-text-fill-color",
    "-webkit-text-size-adjust",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-modify",
    "-webkit-user-select",
    "-webkit-writing-mode",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "animation",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-timing-function",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-size",
    "baseline-shift",
    "border",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "caption-side",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-interpolation-filters",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "content",
    "counter-increment",
    "counter-reset",
    "cursor",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "flood-color",
    "flood-opacity",
    "font",
    "font-family",
    "font-feature-settings",
    "font-optical-sizing",
    "font-size",
    "font-size-adjust",
    "font-stretch",
    "font-style",
    "font-variant",
    "font-variation-settings",
    "font-weight",
    "gap",
    "glyph-orientation-horizontal",
    "glyph-orientation-vertical",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "height",
    "ime-mode",
    "justify-content",
    "justify-items",
    "justify-self",
    "kerning",
    "layout-grid",
    "layout-grid-char",
    "layout-grid-line",
    "layout-grid-mode",
    "layout-grid-type",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-bottom",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-composite",
    "mask-image",
    "mask-position",
    "mask-position-x",
    "mask-position-y",
    "mask-repeat",
    "mask-size",
    "max-height",
    "max-width",
    "min-height",
    "min-width",
    "object-fit",
    "object-position",
    "opacity",
    "order",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "overscroll-behavior",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "padding",
    "padding-bottom",
    "padding-left",
    "padding-right",
    "padding-top",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "paint-order",
    "pen-action",
    "perspective",
    "perspective-origin",
    "pointer-events",
    "position",
    "quotes",
    "right",
    "row-gap",
    "ruby-align",
    "ruby-overhang",
    "ruby-position",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-indent",
    "text-justify",
    "text-kashida",
    "text-kashida-space",
    "text-overflow",
    "text-shadow",
    "text-transform",
    "text-underline-position",
    "top",
    "touch-action",
    "transform",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "unicode-bidi",
    "vertical-align",
    "visibility",
    "white-space",
    "widows",
    "width",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "z-index",
    "zoom",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/explorer-11.0.json
pub const KNOWN_EXPLORER_PROPERTIES: [&str; 182] = [
    "-ms-block-progression",
    "-ms-interpolation-mode",
    "-ms-transform",
    "-ms-transform-origin",
    "accelerator",
    "alignment-baseline",
    "background",
    "background-attachment",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-size",
    "baseline-shift",
    "behavior",
    "border",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "caption-side",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "content",
    "counter-increment",
    "counter-reset",
    "cursor",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "font",
    "font-family",
    "font-size",
    "font-size-adjust",
    "font-stretch",
    "font-style",
    "font-variant",
    "font-weight",
    "glyph-orientation-horizontal",
    "glyph-orientation-vertical",
    "height",
    "ime-mode",
    "kerning",
    "layout-flow",
    "layout-grid",
    "layout-grid-char",
    "layout-grid-line",
    "layout-grid-mode",
    "layout-grid-type",
    "left",
    "letter-spacing",
    "line-break",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-bottom",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "max-height",
    "max-width",
    "min-height",
    "min-width",
    "opacity",
    "orphans",
    "outline",
    "outline-color",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-x",
    "overflow-y",
    "padding",
    "padding-bottom",
    "padding-left",
    "padding-right",
    "padding-top",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "pointer-events",
    "position",
    "quotes",
    "right",
    "ruby-align",
    "ruby-overhang",
    "ruby-position",
    "scrollbar-arrow-color",
    "scrollbar-base-color",
    "scrollbar-dark-shadow-color",
    "scrollbar-face-color",
    "scrollbar-highlight-color",
    "scrollbar-shadow-color",
    "scrollbar-track-color",
    "scrollbar3d-light-color",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-autospace",
    "text-decoration",
    "text-decoration-blink",
    "text-decoration-line-through",
    "text-decoration-none",
    "text-decoration-overline",
    "text-decoration-underline",
    "text-indent",
    "text-justify",
    "text-justify-trim",
    "text-kashida",
    "text-kashida-space",
    "text-overflow",
    "text-transform",
    "text-underline-position",
    "top",
    "unicode-bidi",
    "vertical-align",
    "visibility",
    "white-space",
    "widows",
    "width",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "z-index",
    "zoom",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/firefox-122.0.json
pub const KNOWN_FIREFOX_PROPERTIES: [&str; 526] = [
    "-moz-animation",
    "-moz-animation-delay",
    "-moz-animation-direction",
    "-moz-animation-duration",
    "-moz-animation-fill-mode",
    "-moz-animation-iteration-count",
    "-moz-animation-name",
    "-moz-animation-play-state",
    "-moz-animation-timing-function",
    "-moz-appearance",
    "-moz-backface-visibility",
    "-moz-border-end",
    "-moz-border-end-color",
    "-moz-border-end-style",
    "-moz-border-end-width",
    "-moz-border-image",
    "-moz-border-start",
    "-moz-border-start-color",
    "-moz-border-start-style",
    "-moz-border-start-width",
    "-moz-box-align",
    "-moz-box-direction",
    "-moz-box-flex",
    "-moz-box-ordinal-group",
    "-moz-box-orient",
    "-moz-box-pack",
    "-moz-box-sizing",
    "-moz-float-edge",
    "-moz-font-feature-settings",
    "-moz-font-language-override",
    "-moz-force-broken-image-icon",
    "-moz-hyphens",
    "-moz-image-region",
    "-moz-margin-end",
    "-moz-margin-start",
    "-moz-orient",
    "-moz-osx-font-smoothing",
    "-moz-padding-end",
    "-moz-padding-start",
    "-moz-perspective",
    "-moz-perspective-origin",
    "-moz-tab-size",
    "-moz-text-size-adjust",
    "-moz-transform",
    "-moz-transform-origin",
    "-moz-transform-style",
    "-moz-transition",
    "-moz-transition-delay",
    "-moz-transition-duration",
    "-moz-transition-property",
    "-moz-transition-timing-function",
    "-moz-user-focus",
    "-moz-user-input",
    "-moz-user-modify",
    "-moz-user-select",
    "-moz-window-dragging",
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-appearance",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-box-align",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-shadow",
    "-webkit-box-sizing",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-justify-content",
    "-webkit-line-clamp",
    "-webkit-mask",
    "-webkit-mask-clip",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-origin",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-size",
    "-webkit-order",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-text-fill-color",
    "-webkit-text-size-adjust",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-select",
    "accent-color",
    "align-content",
    "align-items",
    "align-self",
    "all",
    "animation",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-timing-function",
    "appearance",
    "aspect-ratio",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-size",
    "block-size",
    "border",
    "border-block",
    "border-block-color",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-block-style",
    "border-block-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-end-end-radius",
    "border-end-start-radius",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline",
    "border-inline-color",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-inline-style",
    "border-inline-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-start-end-radius",
    "border-start-start-radius",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-decoration-break",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "caption-side",
    "caret-color",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-adjust",
    "color-interpolation",
    "color-interpolation-filters",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "content",
    "counter-increment",
    "counter-reset",
    "counter-set",
    "cursor",
    "cx",
    "cy",
    "d",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "flood-color",
    "flood-opacity",
    "font",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-language-override",
    "font-optical-sizing",
    "font-size",
    "font-size-adjust",
    "font-stretch",
    "font-style",
    "font-synthesis",
    "font-variant",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variant-position",
    "font-variation-settings",
    "font-weight",
    "gap",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "height",
    "hyphenate-character",
    "hyphens",
    "image-orientation",
    "image-rendering",
    "ime-mode",
    "inline-size",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-inline",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-clip",
    "mask-composite",
    "mask-image",
    "mask-mode",
    "mask-origin",
    "mask-position",
    "mask-position-x",
    "mask-position-y",
    "mask-repeat",
    "mask-size",
    "mask-type",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-width",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-width",
    "mix-blend-mode",
    "object-fit",
    "object-position",
    "offset",
    "offset-anchor",
    "offset-distance",
    "offset-path",
    "offset-rotate",
    "opacity",
    "order",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-anchor",
    "overflow-block",
    "overflow-inline",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "padding",
    "padding-block",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "paint-order",
    "perspective",
    "perspective-origin",
    "place-content",
    "place-items",
    "place-self",
    "pointer-events",
    "position",
    "print-color-adjust",
    "quotes",
    "r",
    "resize",
    "right",
    "rotate",
    "row-gap",
    "ruby-align",
    "ruby-position",
    "rx",
    "ry",
    "scale",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-type",
    "scrollbar-color",
    "scrollbar-gutter",
    "scrollbar-width",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "shape-rendering",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-decoration-thickness",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-style",
    "text-indent",
    "text-justify",
    "text-orientation",
    "text-overflow",
    "text-rendering",
    "text-shadow",
    "text-transform",
    "text-underline-offset",
    "text-underline-position",
    "top",
    "touch-action",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "translate",
    "unicode-bidi",
    "user-select",
    "vector-effect",
    "vertical-align",
    "visibility",
    "white-space",
    "width",
    "will-change",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "x",
    "y",
    "z-index",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/safari-17.1.json
pub const KNOWN_SAFARI_PROPERTIES: [&str; 644] = [
    "-apple-pay-button-style",
    "-apple-pay-button-type",
    "-epub-caption-side",
    "-epub-hyphens",
    "-epub-text-combine",
    "-epub-text-emphasis",
    "-epub-text-emphasis-color",
    "-epub-text-emphasis-style",
    "-epub-text-orientation",
    "-epub-text-transform",
    "-epub-word-break",
    "-epub-writing-mode",
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-alt",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-appearance",
    "-webkit-backdrop-filter",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-after",
    "-webkit-border-after-color",
    "-webkit-border-after-style",
    "-webkit-border-after-width",
    "-webkit-border-before",
    "-webkit-border-before-color",
    "-webkit-border-before-style",
    "-webkit-border-before-width",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-end",
    "-webkit-border-end-color",
    "-webkit-border-end-style",
    "-webkit-border-end-width",
    "-webkit-border-horizontal-spacing",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-start",
    "-webkit-border-start-color",
    "-webkit-border-start-style",
    "-webkit-border-start-width",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-border-vertical-spacing",
    "-webkit-box-align",
    "-webkit-box-decoration-break",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-flex-group",
    "-webkit-box-lines",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-reflect",
    "-webkit-box-shadow",
    "-webkit-box-sizing",
    "-webkit-clip-path",
    "-webkit-column-axis",
    "-webkit-column-break-after",
    "-webkit-column-break-before",
    "-webkit-column-break-inside",
    "-webkit-column-count",
    "-webkit-column-fill",
    "-webkit-column-gap",
    "-webkit-column-progression",
    "-webkit-column-rule",
    "-webkit-column-rule-color",
    "-webkit-column-rule-style",
    "-webkit-column-rule-width",
    "-webkit-column-span",
    "-webkit-column-width",
    "-webkit-columns",
    "-webkit-cursor-visibility",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-font-kerning",
    "-webkit-font-smoothing",
    "-webkit-hyphenate-character",
    "-webkit-hyphenate-limit-after",
    "-webkit-hyphenate-limit-before",
    "-webkit-hyphenate-limit-lines",
    "-webkit-hyphens",
    "-webkit-initial-letter",
    "-webkit-justify-content",
    "-webkit-justify-items",
    "-webkit-line-align",
    "-webkit-line-box-contain",
    "-webkit-line-break",
    "-webkit-line-clamp",
    "-webkit-line-grid",
    "-webkit-line-snap",
    "-webkit-locale",
    "-webkit-logical-height",
    "-webkit-logical-width",
    "-webkit-margin-after",
    "-webkit-margin-before",
    "-webkit-margin-end",
    "-webkit-margin-start",
    "-webkit-mask",
    "-webkit-mask-box-image",
    "-webkit-mask-box-image-outset",
    "-webkit-mask-box-image-repeat",
    "-webkit-mask-box-image-slice",
    "-webkit-mask-box-image-source",
    "-webkit-mask-box-image-width",
    "-webkit-mask-clip",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-origin",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-size",
    "-webkit-mask-source-type",
    "-webkit-max-logical-height",
    "-webkit-max-logical-width",
    "-webkit-min-logical-height",
    "-webkit-min-logical-width",
    "-webkit-nbsp-mode",
    "-webkit-opacity",
    "-webkit-order",
    "-webkit-padding-after",
    "-webkit-padding-before",
    "-webkit-padding-end",
    "-webkit-padding-start",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-perspective-origin-x",
    "-webkit-perspective-origin-y",
    "-webkit-print-color-adjust",
    "-webkit-rtl-ordering",
    "-webkit-ruby-position",
    "-webkit-shape-image-threshold",
    "-webkit-shape-margin",
    "-webkit-shape-outside",
    "-webkit-text-combine",
    "-webkit-text-decoration",
    "-webkit-text-decoration-color",
    "-webkit-text-decoration-line",
    "-webkit-text-decoration-skip",
    "-webkit-text-decoration-style",
    "-webkit-text-decorations-in-effect",
    "-webkit-text-emphasis",
    "-webkit-text-emphasis-color",
    "-webkit-text-emphasis-position",
    "-webkit-text-emphasis-style",
    "-webkit-text-fill-color",
    "-webkit-text-orientation",
    "-webkit-text-security",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-text-underline-position",
    "-webkit-text-zoom",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-origin-x",
    "-webkit-transform-origin-y",
    "-webkit-transform-origin-z",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-drag",
    "-webkit-user-modify",
    "-webkit-user-select",
    "-webkit-writing-mode",
    "accent-color",
    "additive-symbols",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "all",
    "alt",
    "animation",
    "animation-composition",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-timing-function",
    "appearance",
    "aspect-ratio",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-size",
    "base-palette",
    "baseline-shift",
    "block-size",
    "border",
    "border-block",
    "border-block-color",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-block-style",
    "border-block-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-end-end-radius",
    "border-end-start-radius",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline",
    "border-inline-color",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-inline-style",
    "border-inline-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-start-end-radius",
    "border-start-start-radius",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "buffered-rendering",
    "caption-side",
    "caret-color",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-adjust",
    "color-interpolation",
    "color-interpolation-filters",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "contain-intrinsic-block-size",
    "contain-intrinsic-height",
    "contain-intrinsic-inline-size",
    "contain-intrinsic-size",
    "contain-intrinsic-width",
    "container",
    "container-name",
    "container-type",
    "content",
    "counter-increment",
    "counter-reset",
    "cursor",
    "cx",
    "cy",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "epub-caption-side",
    "epub-hyphens",
    "epub-text-combine",
    "epub-text-emphasis",
    "epub-text-emphasis-color",
    "epub-text-emphasis-style",
    "epub-text-orientation",
    "epub-text-transform",
    "epub-word-break",
    "epub-writing-mode",
    "fallback",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "flood-color",
    "flood-opacity",
    "font",
    "font-display",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-optical-sizing",
    "font-palette",
    "font-size",
    "font-size-adjust",
    "font-stretch",
    "font-style",
    "font-synthesis",
    "font-synthesis-small-caps",
    "font-synthesis-style",
    "font-synthesis-weight",
    "font-variant",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variant-position",
    "font-variation-settings",
    "font-weight",
    "gap",
    "glyph-orientation-horizontal",
    "glyph-orientation-vertical",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "hanging-punctuation",
    "height",
    "hyphenate-character",
    "hyphens",
    "image-orientation",
    "image-rendering",
    "inherits",
    "initial-value",
    "inline-size",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "kerning",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-inline",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "margin-trim",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-clip",
    "mask-composite",
    "mask-image",
    "mask-mode",
    "mask-origin",
    "mask-position",
    "mask-repeat",
    "mask-size",
    "mask-type",
    "math-style",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-width",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-width",
    "mix-blend-mode",
    "negative",
    "object-fit",
    "object-position",
    "offset",
    "offset-anchor",
    "offset-distance",
    "offset-path",
    "offset-position",
    "offset-rotate",
    "opacity",
    "order",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "override-colors",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "pad",
    "padding",
    "padding-block",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "paint-order",
    "perspective",
    "perspective-origin",
    "perspective-origin-x",
    "perspective-origin-y",
    "place-content",
    "place-items",
    "place-self",
    "pointer-events",
    "position",
    "prefix",
    "print-color-adjust",
    "quotes",
    "r",
    "range",
    "resize",
    "right",
    "rotate",
    "row-gap",
    "rx",
    "ry",
    "scale",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-margin",
    "scroll-snap-margin-bottom",
    "scroll-snap-margin-left",
    "scroll-snap-margin-right",
    "scroll-snap-margin-top",
    "scroll-snap-stop",
    "scroll-snap-type",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "shape-rendering",
    "size",
    "size-adjust",
    "speak-as",
    "src",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-color",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "suffix",
    "supported-color-schemes",
    "symbols",
    "syntax",
    "system",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-decoration-thickness",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-style",
    "text-indent",
    "text-orientation",
    "text-overflow",
    "text-rendering",
    "text-shadow",
    "text-transform",
    "text-underline-offset",
    "text-underline-position",
    "top",
    "touch-action",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-origin-x",
    "transform-origin-y",
    "transform-origin-z",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "translate",
    "unicode-bidi",
    "unicode-range",
    "vector-effect",
    "vertical-align",
    "visibility",
    "white-space",
    "widows",
    "width",
    "will-change",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "x",
    "y",
    "z-index",
    "zoom",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/samsung_internet-23.0.json
pub const KNOWN_SAMSUNG_INTERNET_PROPERTIES: [&str; 608] = [
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-app-region",
    "-webkit-appearance",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-after",
    "-webkit-border-after-color",
    "-webkit-border-after-style",
    "-webkit-border-after-width",
    "-webkit-border-before",
    "-webkit-border-before-color",
    "-webkit-border-before-style",
    "-webkit-border-before-width",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-end",
    "-webkit-border-end-color",
    "-webkit-border-end-style",
    "-webkit-border-end-width",
    "-webkit-border-horizontal-spacing",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-start",
    "-webkit-border-start-color",
    "-webkit-border-start-style",
    "-webkit-border-start-width",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-border-vertical-spacing",
    "-webkit-box-align",
    "-webkit-box-decoration-break",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-reflect",
    "-webkit-box-shadow",
    "-webkit-box-sizing",
    "-webkit-clip-path",
    "-webkit-column-break-after",
    "-webkit-column-break-before",
    "-webkit-column-break-inside",
    "-webkit-column-count",
    "-webkit-column-gap",
    "-webkit-column-rule",
    "-webkit-column-rule-color",
    "-webkit-column-rule-style",
    "-webkit-column-rule-width",
    "-webkit-column-span",
    "-webkit-column-width",
    "-webkit-columns",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-font-feature-settings",
    "-webkit-font-smoothing",
    "-webkit-highlight",
    "-webkit-hyphenate-character",
    "-webkit-justify-content",
    "-webkit-line-break",
    "-webkit-line-clamp",
    "-webkit-locale",
    "-webkit-logical-height",
    "-webkit-logical-width",
    "-webkit-margin-after",
    "-webkit-margin-before",
    "-webkit-margin-end",
    "-webkit-margin-start",
    "-webkit-mask",
    "-webkit-mask-box-image",
    "-webkit-mask-box-image-outset",
    "-webkit-mask-box-image-repeat",
    "-webkit-mask-box-image-slice",
    "-webkit-mask-box-image-source",
    "-webkit-mask-box-image-width",
    "-webkit-mask-clip",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-origin",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-repeat-x",
    "-webkit-mask-repeat-y",
    "-webkit-mask-size",
    "-webkit-max-logical-height",
    "-webkit-max-logical-width",
    "-webkit-min-logical-height",
    "-webkit-min-logical-width",
    "-webkit-opacity",
    "-webkit-order",
    "-webkit-padding-after",
    "-webkit-padding-before",
    "-webkit-padding-end",
    "-webkit-padding-start",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-perspective-origin-x",
    "-webkit-perspective-origin-y",
    "-webkit-print-color-adjust",
    "-webkit-rtl-ordering",
    "-webkit-ruby-position",
    "-webkit-shape-image-threshold",
    "-webkit-shape-margin",
    "-webkit-shape-outside",
    "-webkit-tap-highlight-color",
    "-webkit-text-combine",
    "-webkit-text-decorations-in-effect",
    "-webkit-text-emphasis",
    "-webkit-text-emphasis-color",
    "-webkit-text-emphasis-position",
    "-webkit-text-emphasis-style",
    "-webkit-text-fill-color",
    "-webkit-text-orientation",
    "-webkit-text-security",
    "-webkit-text-size-adjust",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-origin-x",
    "-webkit-transform-origin-y",
    "-webkit-transform-origin-z",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-drag",
    "-webkit-user-modify",
    "-webkit-user-select",
    "-webkit-writing-mode",
    "accent-color",
    "additive-symbols",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "all",
    "animation",
    "animation-composition",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-range",
    "animation-range-end",
    "animation-range-start",
    "animation-timeline",
    "animation-timing-function",
    "app-region",
    "appearance",
    "ascent-override",
    "aspect-ratio",
    "backdrop-filter",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-repeat-x",
    "background-repeat-y",
    "background-size",
    "base-palette",
    "baseline-shift",
    "baseline-source",
    "block-size",
    "border",
    "border-block",
    "border-block-color",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-block-style",
    "border-block-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-end-end-radius",
    "border-end-start-radius",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline",
    "border-inline-color",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-inline-style",
    "border-inline-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-start-end-radius",
    "border-start-start-radius",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "buffered-rendering",
    "caption-side",
    "caret-color",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-interpolation",
    "color-interpolation-filters",
    "color-rendering",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "contain-intrinsic-block-size",
    "contain-intrinsic-height",
    "contain-intrinsic-inline-size",
    "contain-intrinsic-size",
    "contain-intrinsic-width",
    "container",
    "container-name",
    "container-type",
    "content",
    "content-visibility",
    "counter-increment",
    "counter-reset",
    "counter-set",
    "cursor",
    "cx",
    "cy",
    "d",
    "descent-override",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fallback",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "flood-color",
    "flood-opacity",
    "font",
    "font-display",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-optical-sizing",
    "font-palette",
    "font-size",
    "font-stretch",
    "font-style",
    "font-synthesis",
    "font-synthesis-small-caps",
    "font-synthesis-style",
    "font-synthesis-weight",
    "font-variant",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variation-settings",
    "font-weight",
    "forced-color-adjust",
    "gap",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "height",
    "hyphenate-character",
    "hyphenate-limit-chars",
    "hyphens",
    "image-orientation",
    "image-rendering",
    "inherits",
    "initial-letter",
    "initial-value",
    "inline-size",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-gap-override",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-inline",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-type",
    "math-depth",
    "math-shift",
    "math-style",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-width",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-width",
    "mix-blend-mode",
    "negative",
    "object-fit",
    "object-position",
    "object-view-box",
    "offset",
    "offset-distance",
    "offset-path",
    "offset-rotate",
    "opacity",
    "order",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-anchor",
    "overflow-clip-margin",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "override-colors",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "pad",
    "padding",
    "padding-block",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "page-orientation",
    "paint-order",
    "perspective",
    "perspective-origin",
    "place-content",
    "place-items",
    "place-self",
    "pointer-events",
    "position",
    "prefix",
    "quotes",
    "r",
    "range",
    "resize",
    "right",
    "rotate",
    "row-gap",
    "ruby-position",
    "rx",
    "ry",
    "scale",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-stop",
    "scroll-snap-type",
    "scroll-timeline",
    "scroll-timeline-axis",
    "scroll-timeline-name",
    "scrollbar-gutter",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "shape-rendering",
    "size",
    "size-adjust",
    "speak",
    "speak-as",
    "src",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "suffix",
    "symbols",
    "syntax",
    "system",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-decoration-thickness",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-style",
    "text-indent",
    "text-orientation",
    "text-overflow",
    "text-rendering",
    "text-shadow",
    "text-size-adjust",
    "text-transform",
    "text-underline-offset",
    "text-underline-position",
    "text-wrap",
    "top",
    "touch-action",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "translate",
    "unicode-bidi",
    "unicode-range",
    "user-select",
    "vector-effect",
    "vertical-align",
    "view-timeline",
    "view-timeline-axis",
    "view-timeline-inset",
    "view-timeline-name",
    "view-transition-name",
    "visibility",
    "white-space",
    "white-space-collapse",
    "widows",
    "width",
    "will-change",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "x",
    "y",
    "z-index",
    "zoom",
];

// https://github.com/known-css/known-css-properties/blob/master/source/browsers/uc_browser-13.4.json
pub const KNOWN_US_BROWSER_PROPERTIES: [&str; 517] = [
    "-webkit-align-content",
    "-webkit-align-items",
    "-webkit-align-self",
    "-webkit-animation",
    "-webkit-animation-delay",
    "-webkit-animation-direction",
    "-webkit-animation-duration",
    "-webkit-animation-fill-mode",
    "-webkit-animation-iteration-count",
    "-webkit-animation-name",
    "-webkit-animation-play-state",
    "-webkit-animation-timing-function",
    "-webkit-app-region",
    "-webkit-appearance",
    "-webkit-backface-visibility",
    "-webkit-background-clip",
    "-webkit-background-origin",
    "-webkit-background-size",
    "-webkit-border-after",
    "-webkit-border-after-color",
    "-webkit-border-after-style",
    "-webkit-border-after-width",
    "-webkit-border-before",
    "-webkit-border-before-color",
    "-webkit-border-before-style",
    "-webkit-border-before-width",
    "-webkit-border-bottom-left-radius",
    "-webkit-border-bottom-right-radius",
    "-webkit-border-end",
    "-webkit-border-end-color",
    "-webkit-border-end-style",
    "-webkit-border-end-width",
    "-webkit-border-horizontal-spacing",
    "-webkit-border-image",
    "-webkit-border-radius",
    "-webkit-border-start",
    "-webkit-border-start-color",
    "-webkit-border-start-style",
    "-webkit-border-start-width",
    "-webkit-border-top-left-radius",
    "-webkit-border-top-right-radius",
    "-webkit-border-vertical-spacing",
    "-webkit-box-align",
    "-webkit-box-decoration-break",
    "-webkit-box-direction",
    "-webkit-box-flex",
    "-webkit-box-ordinal-group",
    "-webkit-box-orient",
    "-webkit-box-pack",
    "-webkit-box-reflect",
    "-webkit-box-shadow",
    "-webkit-box-sizing",
    "-webkit-clip-path",
    "-webkit-column-break-after",
    "-webkit-column-break-before",
    "-webkit-column-break-inside",
    "-webkit-column-count",
    "-webkit-column-gap",
    "-webkit-column-rule",
    "-webkit-column-rule-color",
    "-webkit-column-rule-style",
    "-webkit-column-rule-width",
    "-webkit-column-span",
    "-webkit-column-width",
    "-webkit-columns",
    "-webkit-filter",
    "-webkit-flex",
    "-webkit-flex-basis",
    "-webkit-flex-direction",
    "-webkit-flex-flow",
    "-webkit-flex-grow",
    "-webkit-flex-shrink",
    "-webkit-flex-wrap",
    "-webkit-font-feature-settings",
    "-webkit-font-size-delta",
    "-webkit-font-smoothing",
    "-webkit-highlight",
    "-webkit-hyphenate-character",
    "-webkit-justify-content",
    "-webkit-line-break",
    "-webkit-line-clamp",
    "-webkit-locale",
    "-webkit-logical-height",
    "-webkit-logical-width",
    "-webkit-margin-after",
    "-webkit-margin-after-collapse",
    "-webkit-margin-before",
    "-webkit-margin-before-collapse",
    "-webkit-margin-bottom-collapse",
    "-webkit-margin-collapse",
    "-webkit-margin-end",
    "-webkit-margin-start",
    "-webkit-margin-top-collapse",
    "-webkit-mask",
    "-webkit-mask-box-image",
    "-webkit-mask-box-image-outset",
    "-webkit-mask-box-image-repeat",
    "-webkit-mask-box-image-slice",
    "-webkit-mask-box-image-source",
    "-webkit-mask-box-image-width",
    "-webkit-mask-clip",
    "-webkit-mask-composite",
    "-webkit-mask-image",
    "-webkit-mask-origin",
    "-webkit-mask-position",
    "-webkit-mask-position-x",
    "-webkit-mask-position-y",
    "-webkit-mask-repeat",
    "-webkit-mask-repeat-x",
    "-webkit-mask-repeat-y",
    "-webkit-mask-size",
    "-webkit-max-logical-height",
    "-webkit-max-logical-width",
    "-webkit-min-logical-height",
    "-webkit-min-logical-width",
    "-webkit-opacity",
    "-webkit-order",
    "-webkit-padding-after",
    "-webkit-padding-before",
    "-webkit-padding-end",
    "-webkit-padding-start",
    "-webkit-perspective",
    "-webkit-perspective-origin",
    "-webkit-perspective-origin-x",
    "-webkit-perspective-origin-y",
    "-webkit-print-color-adjust",
    "-webkit-rtl-ordering",
    "-webkit-ruby-position",
    "-webkit-shape-image-threshold",
    "-webkit-shape-margin",
    "-webkit-shape-outside",
    "-webkit-tap-highlight-color",
    "-webkit-text-combine",
    "-webkit-text-decorations-in-effect",
    "-webkit-text-emphasis",
    "-webkit-text-emphasis-color",
    "-webkit-text-emphasis-position",
    "-webkit-text-emphasis-style",
    "-webkit-text-fill-color",
    "-webkit-text-orientation",
    "-webkit-text-security",
    "-webkit-text-size-adjust",
    "-webkit-text-stroke",
    "-webkit-text-stroke-color",
    "-webkit-text-stroke-width",
    "-webkit-transform",
    "-webkit-transform-origin",
    "-webkit-transform-origin-x",
    "-webkit-transform-origin-y",
    "-webkit-transform-origin-z",
    "-webkit-transform-style",
    "-webkit-transition",
    "-webkit-transition-delay",
    "-webkit-transition-duration",
    "-webkit-transition-property",
    "-webkit-transition-timing-function",
    "-webkit-user-drag",
    "-webkit-user-modify",
    "-webkit-user-select",
    "-webkit-writing-mode",
    "align-content",
    "align-items",
    "align-self",
    "alignment-baseline",
    "all",
    "animation",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-timing-function",
    "backdrop-filter",
    "backface-visibility",
    "background",
    "background-attachment",
    "background-blend-mode",
    "background-clip",
    "background-color",
    "background-image",
    "background-origin",
    "background-position",
    "background-position-x",
    "background-position-y",
    "background-repeat",
    "background-repeat-x",
    "background-repeat-y",
    "background-size",
    "baseline-shift",
    "block-size",
    "border",
    "border-block-end",
    "border-block-end-color",
    "border-block-end-style",
    "border-block-end-width",
    "border-block-start",
    "border-block-start-color",
    "border-block-start-style",
    "border-block-start-width",
    "border-bottom",
    "border-bottom-color",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-bottom-style",
    "border-bottom-width",
    "border-collapse",
    "border-color",
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
    "border-inline-end",
    "border-inline-end-color",
    "border-inline-end-style",
    "border-inline-end-width",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-start-style",
    "border-inline-start-width",
    "border-left",
    "border-left-color",
    "border-left-style",
    "border-left-width",
    "border-radius",
    "border-right",
    "border-right-color",
    "border-right-style",
    "border-right-width",
    "border-spacing",
    "border-style",
    "border-top",
    "border-top-color",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-top-style",
    "border-top-width",
    "border-width",
    "bottom",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "buffered-rendering",
    "caption-side",
    "caret-color",
    "clear",
    "clip",
    "clip-path",
    "clip-rule",
    "color",
    "color-interpolation",
    "color-interpolation-filters",
    "color-rendering",
    "color-scheme",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "contain",
    "content",
    "counter-increment",
    "counter-reset",
    "cursor",
    "cx",
    "cy",
    "d",
    "direction",
    "display",
    "dominant-baseline",
    "empty-cells",
    "fill",
    "fill-opacity",
    "fill-rule",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "float",
    "flood-color",
    "flood-opacity",
    "font",
    "font-display",
    "font-family",
    "font-feature-settings",
    "font-kerning",
    "font-size",
    "font-stretch",
    "font-style",
    "font-variant",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variation-settings",
    "font-weight",
    "gap",
    "grid",
    "grid-area",
    "grid-auto-columns",
    "grid-auto-flow",
    "grid-auto-rows",
    "grid-column",
    "grid-column-end",
    "grid-column-gap",
    "grid-column-start",
    "grid-gap",
    "grid-row",
    "grid-row-end",
    "grid-row-gap",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "height",
    "hyphens",
    "image-rendering",
    "inline-size",
    "isolation",
    "justify-content",
    "justify-items",
    "justify-self",
    "left",
    "letter-spacing",
    "lighting-color",
    "line-break",
    "line-height",
    "list-style",
    "list-style-image",
    "list-style-position",
    "list-style-type",
    "margin",
    "margin-block-end",
    "margin-block-start",
    "margin-bottom",
    "margin-inline-end",
    "margin-inline-start",
    "margin-left",
    "margin-right",
    "margin-top",
    "marker",
    "marker-end",
    "marker-mid",
    "marker-start",
    "mask",
    "mask-type",
    "max-block-size",
    "max-height",
    "max-inline-size",
    "max-width",
    "max-zoom",
    "min-block-size",
    "min-height",
    "min-inline-size",
    "min-width",
    "min-zoom",
    "mix-blend-mode",
    "object-fit",
    "object-position",
    "offset",
    "offset-distance",
    "offset-path",
    "offset-rotate",
    "opacity",
    "order",
    "orientation",
    "orphans",
    "outline",
    "outline-color",
    "outline-offset",
    "outline-style",
    "outline-width",
    "overflow",
    "overflow-anchor",
    "overflow-wrap",
    "overflow-x",
    "overflow-y",
    "overscroll-behavior",
    "overscroll-behavior-block",
    "overscroll-behavior-inline",
    "overscroll-behavior-x",
    "overscroll-behavior-y",
    "padding",
    "padding-block-end",
    "padding-block-start",
    "padding-bottom",
    "padding-inline-end",
    "padding-inline-start",
    "padding-left",
    "padding-right",
    "padding-top",
    "page",
    "page-break-after",
    "page-break-before",
    "page-break-inside",
    "paint-order",
    "perspective",
    "perspective-origin",
    "place-content",
    "place-items",
    "place-self",
    "pointer-events",
    "position",
    "quotes",
    "r",
    "resize",
    "right",
    "row-gap",
    "rx",
    "ry",
    "scroll-behavior",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-block-end",
    "scroll-margin-block-start",
    "scroll-margin-bottom",
    "scroll-margin-inline",
    "scroll-margin-inline-end",
    "scroll-margin-inline-start",
    "scroll-margin-left",
    "scroll-margin-right",
    "scroll-margin-top",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-block-end",
    "scroll-padding-block-start",
    "scroll-padding-bottom",
    "scroll-padding-inline",
    "scroll-padding-inline-end",
    "scroll-padding-inline-start",
    "scroll-padding-left",
    "scroll-padding-right",
    "scroll-padding-top",
    "scroll-snap-align",
    "scroll-snap-stop",
    "scroll-snap-type",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "shape-rendering",
    "size",
    "speak",
    "src",
    "stop-color",
    "stop-opacity",
    "stroke",
    "stroke-dasharray",
    "stroke-dashoffset",
    "stroke-linecap",
    "stroke-linejoin",
    "stroke-miterlimit",
    "stroke-opacity",
    "stroke-width",
    "tab-size",
    "table-layout",
    "text-align",
    "text-align-last",
    "text-anchor",
    "text-combine-upright",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-indent",
    "text-orientation",
    "text-overflow",
    "text-rendering",
    "text-shadow",
    "text-size-adjust",
    "text-transform",
    "text-underline-position",
    "top",
    "touch-action",
    "transform",
    "transform-box",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "unicode-bidi",
    "unicode-range",
    "user-select",
    "user-zoom",
    "vector-effect",
    "vertical-align",
    "visibility",
    "white-space",
    "widows",
    "width",
    "will-change",
    "word-break",
    "word-spacing",
    "word-wrap",
    "writing-mode",
    "x",
    "y",
    "z-index",
    "zoom",
];

pub const MEDIA_FEATURE_NAMES: [&str; 60] = [
    "any-hover",
    "any-pointer",
    "aspect-ratio",
    "color",
    "color-gamut",
    "color-index",
    "device-aspect-ratio",
    "device-height",
    "device-posture",
    "device-width",
    "display-mode",
    "dynamic-range",
    "environment-blending",
    "forced-colors",
    "grid",
    "height",
    "horizontal-viewport-segments",
    "hover",
    "inverted-colors",
    "light-level",
    "max-aspect-ratio",
    "max-color",
    "max-color-index",
    "max-device-aspect-ratio",
    "max-device-height",
    "max-device-width",
    "max-height",
    "max-monochrome",
    "max-resolution",
    "max-width",
    "min-aspect-ratio",
    "min-color",
    "min-color-index",
    "min-device-aspect-ratio",
    "min-device-height",
    "min-device-width",
    "min-height",
    "min-monochrome",
    "min-resolution",
    "min-width",
    "monochrome",
    "nav-controls",
    "orientation",
    "overflow-block",
    "overflow-inline",
    "pointer",
    "prefers-color-scheme",
    "prefers-contrast",
    "prefers-reduced-data",
    "prefers-reduced-motion",
    "prefers-reduded-transparency",
    "resolution",
    "scan",
    "screen-spanning",
    "scripting",
    "update",
    "vertical-viewport-segments",
    "video-color-gamut",
    "video-dynamic-range",
    "width",
];

pub const SHORTHAND_PROPERTIES: [&str; 57] = [
    "animation",
    "background",
    "border",
    "border-block",
    "border-block-end",
    "border-block-start",
    "border-bottom",
    "border-color",
    "border-image",
    "border-inline",
    "border-inline-end",
    "border-inline-start",
    "border-left",
    "border-radius",
    "border-right",
    "border-style",
    "border-top",
    "border-width",
    "column-rule",
    "columns",
    "flex",
    "flex-flow",
    "font",
    "font-synthesis",
    "gap",
    "grid",
    "grid-area",
    "grid-column",
    "grid-gap",
    "grid-row",
    "grid-template",
    "inset",
    "inset-block",
    "inset-inline",
    "list-style",
    "margin",
    "margin-block",
    "margin-inline",
    "mask",
    "outline",
    "overflow",
    "overscroll-behavior",
    "padding",
    "padding-block",
    "padding-inline",
    "place-content",
    "place-items",
    "place-self",
    "scroll-margin",
    "scroll-margin-block",
    "scroll-margin-inline",
    "scroll-padding",
    "scroll-padding-block",
    "scroll-padding-inline",
    "text-decoration",
    "text-emphasis",
    "transition",
];

pub const LONGHAND_SUB_PROPERTIES_OF_SHORTHAND_PROPERTIES: [&[&str]; 57] = [
    &[
        "animation-delay",
        "animation-direction",
        "animation-duration",
        "animation-fill-mode",
        "animation-iteration-count",
        "animation-name",
        "animation-play-state",
        "animation-timing-function",
    ],
    &[
        "background-attachment",
        "background-clip",
        "background-color",
        "background-image",
        "background-origin",
        "background-position",
        "background-repeat",
        "background-size",
    ],
    &[
        "border-bottom-color",
        "border-bottom-style",
        "border-bottom-width",
        "border-color",
        "border-left-color",
        "border-left-style",
        "border-left-width",
        "border-right-color",
        "border-right-style",
        "border-right-width",
        "border-style",
        "border-top-color",
        "border-top-style",
        "border-top-width",
        "border-width",
    ],
    &[
        "border-block-color",
        "border-block-style",
        "border-block-width",
    ],
    &[
        "border-block-end-color",
        "border-block-end-style",
        "border-block-end-width",
    ],
    &[
        "border-block-start-color",
        "border-block-start-style",
        "border-block-start-width",
    ],
    &[
        "border-bottom-color",
        "border-bottom-style",
        "border-bottom-width",
    ],
    &[
        "border-bottom-color",
        "border-left-color",
        "border-right-color",
        "border-top-color",
    ],
    &[
        "border-image-outset",
        "border-image-repeat",
        "border-image-slice",
        "border-image-source",
        "border-image-width",
    ],
    &[
        "border-inline-color",
        "border-inline-style",
        "border-inline-width",
    ],
    &[
        "border-inline-end-color",
        "border-inline-end-style",
        "border-inline-end-width",
    ],
    &[
        "border-inline-start-color",
        "border-inline-start-style",
        "border-inline-start-width",
    ],
    &[
        "border-left-color",
        "border-left-style",
        "border-left-width",
    ],
    &[
        "border-bottom-left-radius",
        "border-bottom-right-radius",
        "border-top-left-radius",
        "border-top-right-radius",
    ],
    &[
        "border-right-color",
        "border-right-style",
        "border-right-width",
    ],
    &[
        "border-bottom-style",
        "border-left-style",
        "border-right-style",
        "border-top-style",
    ],
    &["border-top-color", "border-top-style", "border-top-width"],
    &[
        "border-bottom-width",
        "border-left-width",
        "border-right-width",
        "border-top-width",
    ],
    &[
        "column-rule-color",
        "column-rule-style",
        "column-rule-width",
    ],
    &["column-count", "column-width"],
    &["flex-basis", "flex-grow", "flex-shrink"],
    &["flex-direction", "flex-wrap"],
    &[
        "font-family",
        "font-size",
        "font-stretch",
        "font-style",
        "font-variant",
        "font-weight",
        "line-height",
    ],
    &[
        "font-synthesis-small-caps",
        "font-synthesis-style",
        "font-synthesis-weight",
    ],
    &["column-gap", "row-gap"],
    &[
        "grid-auto-columns",
        "grid-auto-flow",
        "grid-auto-rows",
        "grid-column-gap",
        "grid-row-gap",
        "grid-template-areas",
        "grid-template-columns",
        "grid-template-rows",
    ],
    &[
        "grid-column-end",
        "grid-column-start",
        "grid-row-end",
        "grid-row-start",
    ],
    &["grid-column-end", "grid-column-start"],
    &["grid-column-gap", "grid-row-gap"],
    &["grid-row-end", "grid-row-start"],
    &[
        "grid-template-areas",
        "grid-template-columns",
        "grid-template-rows",
    ],
    &["bottom", "left", "right", "top"],
    &["inset-block-end", "inset-block-start"],
    &["inset-inline-end", "inset-inline-start"],
    &["list-style-image", "list-style-position", "list-style-type"],
    &["margin-bottom", "margin-left", "margin-right", "margin-top"],
    &["margin-block-end", "margin-block-start"],
    &["margin-inline-end", "margin-inline-start"],
    &[
        "mask-clip",
        "mask-composite",
        "mask-image",
        "mask-mode",
        "mask-origin",
        "mask-position",
        "mask-repeat",
        "mask-size",
    ],
    &["outline-color", "outline-style", "outline-width"],
    &["overflow-x", "overflow-y"],
    &["overscroll-behavior-x", "overscroll-behavior-y"],
    &[
        "padding-bottom",
        "padding-left",
        "padding-right",
        "padding-top",
    ],
    &["padding-block-end", "padding-block-start"],
    &["padding-inline-end", "padding-inline-start"],
    &["align-content", "justify-content"],
    &["align-items", "justify-items"],
    &["align-self", "justify-self"],
    &[
        "scroll-margin-bottom",
        "scroll-margin-left",
        "scroll-margin-right",
        "scroll-margin-top",
    ],
    &["scroll-margin-block-end", "scroll-margin-block-start"],
    &["scroll-margin-inline-end", "scroll-margin-inline-start"],
    &[
        "scroll-padding-bottom",
        "scroll-padding-left",
        "scroll-padding-right",
        "scroll-padding-top",
    ],
    &["scroll-padding-block-end", "scroll-padding-block-start"],
    &["scroll-padding-inline-end", "scroll-padding-inline-start"],
    &[
        "text-decoration-color",
        "text-decoration-line",
        "text-decoration-style",
        "text-decoration-thickness",
    ],
    &["text-emphasis-color", "text-emphasis-style"],
    &[
        "transition-delay",
        "transition-duration",
        "transition-property",
        "transition-timing-function",
    ],
];

pub const RESET_TO_INITIAL_PROPERTIES_BY_BORDER: [&str; 6] = [
    "border-image",
    "border-image-outset",
    "border-image-repeat",
    "border-image-slice",
    "border-image-source",
    "border-image-width",
];

pub const RESET_TO_INITIAL_PROPERTIES_BY_FONT: [&str; 13] = [
    "font-feature-settings",
    "font-kerning",
    "font-language-override",
    "font-optical-sizing",
    "font-size-adjust",
    "font-variant-alternates",
    "font-variant-caps",
    "font-variant-east-asian",
    "font-variant-emoji",
    "font-variant-ligatures",
    "font-variant-numeric",
    "font-variant-position",
    "font-variation-settings",
];

// https://developer.mozilla.org/ja/docs/Web/HTML/Element
// https://github.com/sindresorhus/html-tags/blob/main/html-tags.json
pub(crate) const HTML_TAGS: [&str; 150] = [
    "a",
    "abbr",
    "acronym",
    "address",
    "applet",
    "area",
    "article",
    "aside",
    "audio",
    "b",
    "base",
    "basefont",
    "bdi",
    "bdo",
    "bgsound",
    "big",
    "blink",
    "blockquote",
    "body",
    "br",
    "button",
    "canvas",
    "caption",
    "center",
    "cite",
    "code",
    "col",
    "colgroup",
    "content",
    "data",
    "datalist",
    "dd",
    "del",
    "details",
    "dfn",
    "dialog",
    "dir",
    "div",
    "dl",
    "dt",
    "em",
    "embed",
    "fencedframe",
    "fieldset",
    "figcaption",
    "figure",
    "font",
    "footer",
    "form",
    "frame",
    "frameset",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hgroup",
    "hr",
    "html",
    "i",
    "iframe",
    "img",
    "input",
    "ins",
    "isindex",
    "kbd",
    "keygen",
    "label",
    "legend",
    "li",
    "link",
    "listbox",
    "listing",
    "main",
    "map",
    "mark",
    "marquee",
    "math",
    "menu",
    "menuitem",
    "meta",
    "meter",
    "model",
    "multicol",
    "nav",
    "nextid",
    "nobr",
    "noembed",
    "noframes",
    "noscript",
    "object",
    "ol",
    "optgroup",
    "option",
    "output",
    "p",
    "param",
    "picture",
    "plaintext",
    "portal",
    "pre",
    "progress",
    "q",
    "rb",
    "rp",
    "rt",
    "rtc",
    "ruby",
    "s",
    "samp",
    "script",
    "search",
    "section",
    "select",
    "selectlist",
    "shadow",
    "slot",
    "small",
    "source",
    "spacer",
    "span",
    "strike",
    "strong",
    "style",
    "sub",
    "summary",
    "sup",
    "svg",
    "table",
    "tbody",
    "td",
    "template",
    "textarea",
    "tfoot",
    "th",
    "thead",
    "time",
    "title",
    "tr",
    "track",
    "tt",
    "u",
    "ul",
    "var",
    "video",
    "wbr",
    "xmp",
];

// https://developer.mozilla.org/ja/docs/Web/SVG/Element
// https://github.com/element-io/svg-tags/blob/master/lib/svg-tags.json
pub(crate) const SVG_TAGS: [&str; 82] = [
    "a",
    "altGlyph",
    "altGlyphDef",
    "altGlyphItem",
    "animate",
    "animateColor",
    "animateMotion",
    "animateTransform",
    "circle",
    "clipPath",
    "color-profile",
    "cursor",
    "defs",
    "desc",
    "ellipse",
    "feBlend",
    "feColorMatrix",
    "feComponentTransfer",
    "feComposite",
    "feConvolveMatrix",
    "feDiffuseLighting",
    "feDisplacementMap",
    "feDistantLight",
    "feDropShadow",
    "feFlood",
    "feFuncA",
    "feFuncB",
    "feFuncG",
    "feFuncR",
    "feGaussianBlur",
    "feImage",
    "feMerge",
    "feMergeNode",
    "feMorphology",
    "feOffset",
    "fePointLight",
    "feSpecularLighting",
    "feSpotLight",
    "feTile",
    "feTurbulence",
    "filter",
    "font",
    "font-face",
    "font-face-format",
    "font-face-name",
    "font-face-src",
    "font-face-uri",
    "foreignObject",
    "g",
    "glyph",
    "glyphRef",
    "hatch",
    "hatchpath",
    "hkern",
    "image",
    "line",
    "linearGradient",
    "marker",
    "mask",
    "metadata",
    "missing-glyph",
    "mpath",
    "path",
    "pattern",
    "polygon",
    "polyline",
    "radialGradient",
    "rect",
    "script",
    "set",
    "stop",
    "style",
    "svg",
    "switch",
    "symbol",
    "text",
    "textPath",
    "title",
    "tspan",
    "use",
    "view",
    "vkern",
];

// https://developer.mozilla.org/ja/docs/Web/MathML/Element
pub(crate) const MATH_ML_TAGS: [&str; 32] = [
    "annotation",
    "annotation-xml",
    "maction",
    "math",
    "menclose",
    "merror",
    "mfenced",
    "mfrac",
    "mi",
    "mmultiscripts",
    "mn",
    "mo",
    "mover",
    "mpadded",
    "mphantom",
    "mprescripts",
    "mroot",
    "mrow",
    "ms",
    "mspace",
    "msqrt",
    "mstyle",
    "msub",
    "msubsup",
    "msup",
    "mtable",
    "mtd",
    "mtext",
    "mtr",
    "munder",
    "munderover",
    "semantics",
];

#[cfg(test)]
mod tests {
    use std::collections::HashSet;

    use super::*;

    #[test]
    fn test_basic_keywords_sorted() {
        let sorted = BASIC_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(BASIC_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_system_family_name_keywords_sorted() {
        let sorted = SYSTEM_FAMILY_NAME_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(SYSTEM_FAMILY_NAME_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_family_keywords_sorted() {
        let sorted = FONT_FAMILY_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_FAMILY_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_weight_absolute_keywords_sorted() {
        let sorted = FONT_WEIGHT_ABSOLUTE_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_WEIGHT_ABSOLUTE_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_weight_numeric_keywords_sorted() {
        let sorted = FONT_WEIGHT_NUMERIC_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_WEIGHT_NUMERIC_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_style_keywords_sorted() {
        let sorted = FONT_STYLE_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_STYLE_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_variants_keywords_sorted() {
        let sorted = FONT_VARIANTS_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_VARIANTS_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_stretch_keywords_sorted() {
        let sorted = FONT_STRETCH_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_STRETCH_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_font_size_keywords_sorted() {
        let sorted = FONT_SIZE_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FONT_SIZE_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_line_height_keywords_sorted() {
        let sorted = LINE_HEIGHT_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(LINE_HEIGHT_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_function_keywords_sorted() {
        let sorted = FUNCTION_KEYWORDS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(FUNCTION_KEYWORDS, sorted.as_slice());
    }

    #[test]
    fn test_function_keywords_unique() {
        let mut set = HashSet::new();
        let has_duplicates = FUNCTION_KEYWORDS.iter().any(|&x| !set.insert(x));
        assert!(!has_duplicates);
    }

    #[test]
    fn test_level_one_and_two_pseudo_elements_sorted() {
        let sorted = LEVEL_ONE_AND_TWO_PSEUDO_ELEMENTS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(LEVEL_ONE_AND_TWO_PSEUDO_ELEMENTS, sorted.as_slice());
    }

    #[test]
    fn test_vendor_specific_pseudo_elements_sorted() {
        let sorted = VENDOR_SPECIFIC_PSEUDO_ELEMENTS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(VENDOR_SPECIFIC_PSEUDO_ELEMENTS, sorted.as_slice());
    }

    #[test]
    fn test_shadow_tree_pseudo_elements_sorted() {
        let sorted = SHADOW_TREE_PSEUDO_ELEMENTS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(SHADOW_TREE_PSEUDO_ELEMENTS, sorted.as_slice());
    }

    #[test]
    fn test_other_pseudo_elements_sorted() {
        let sorted = OTHER_PSEUDO_ELEMENTS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(OTHER_PSEUDO_ELEMENTS, sorted.as_slice());
    }

    #[test]
    fn test_vendor_prefixes_sorted() {
        let sorted = VENDOR_PREFIXES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(VENDOR_PREFIXES, sorted.as_slice());
    }

    #[test]
    fn test_at_rule_page_pseudo_classes_sorted() {
        let sorted = AT_RULE_PAGE_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(AT_RULE_PAGE_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_webkit_scrollbar_pseudo_elements_sorted() {
        let sorted = WEBKIT_SCROLLBAR_PSEUDO_ELEMENTS.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(WEBKIT_SCROLLBAR_PSEUDO_ELEMENTS, sorted.as_slice());
    }

    #[test]
    fn test_webkit_scrollbar_pseudo_classes_sorted() {
        let sorted = WEBKIT_SCROLLBAR_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(WEBKIT_SCROLLBAR_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_a_nplus_bnotation_pseudo_classes_sorted() {
        let sorted = A_NPLUS_BNOTATION_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(A_NPLUS_BNOTATION_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_a_nplus_bof_snotation_pseudo_classes_sorted() {
        let sorted = A_NPLUS_BOF_SNOTATION_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(A_NPLUS_BOF_SNOTATION_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_linguistic_pseudo_classes_sorted() {
        let sorted = LINGUISTIC_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(LINGUISTIC_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_logical_combinations_pseudo_classes_sorted() {
        let sorted = LOGICAL_COMBINATIONS_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(LOGICAL_COMBINATIONS_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_resource_state_pseudo_classes_sorted() {
        let sorted = RESOURCE_STATE_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(RESOURCE_STATE_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_other_pseudo_classes_sorted() {
        let sorted = OTHER_PSEUDO_CLASSES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(OTHER_PSEUDO_CLASSES, sorted.as_slice());
    }

    #[test]
    fn test_known_properties_order() {
        for items in KNOWN_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_chrome_properties_sorted() {
        let sorted = KNOWN_CHROME_PROPERTIES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(KNOWN_CHROME_PROPERTIES, sorted.as_slice());
    }

    #[test]
    fn test_known_edge_properties_order() {
        for items in KNOWN_EDGE_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_explorer_properties_order() {
        for items in KNOWN_EXPLORER_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_firefox_properties_order() {
        for items in KNOWN_FIREFOX_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_safari_properties_order() {
        for items in KNOWN_SAFARI_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_samsung_internet_properties_order() {
        for items in KNOWN_SAMSUNG_INTERNET_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_known_us_browser_properties_order() {
        for items in KNOWN_US_BROWSER_PROPERTIES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_media_feature_names_order() {
        for items in MEDIA_FEATURE_NAMES.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_shorthand_properties_sorted() {
        let sorted = SHORTHAND_PROPERTIES.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(SHORTHAND_PROPERTIES, sorted.as_slice());
    }

    #[test]
    fn test_shorthand_properties_unique() {
        let mut set = HashSet::new();
        let has_duplicates = SHORTHAND_PROPERTIES.iter().any(|&x| !set.insert(x));
        assert!(!has_duplicates);
    }

    #[test]
    fn test_longhand_sub_properties_of_shorthand_properties_sorted() {
        for longhand_sub_properties in LONGHAND_SUB_PROPERTIES_OF_SHORTHAND_PROPERTIES.iter() {
            let sorted = longhand_sub_properties.to_vec();
            let _ = sorted.is_sorted();
            assert_eq!(*longhand_sub_properties, sorted.as_slice());
        }
    }

    #[test]
    fn test_longhand_sub_properties_of_shorthand_properties_unique() {
        for longhand_sub_properties in LONGHAND_SUB_PROPERTIES_OF_SHORTHAND_PROPERTIES.iter() {
            let mut set = HashSet::new();
            let has_duplicates = longhand_sub_properties.iter().any(|&x| !set.insert(x));
            assert!(!has_duplicates);
        }
    }

    #[test]
    fn test_shorthand_properties_and_longhand_sub_properties_correspond_correctly() {
        for (shorthand_property, longhand_sub_properties) in SHORTHAND_PROPERTIES
            .iter()
            .zip(LONGHAND_SUB_PROPERTIES_OF_SHORTHAND_PROPERTIES.iter())
        {
            for longhand_sub_property in longhand_sub_properties.iter() {
                if [
                    "border-color",
                    "border-radius",
                    "border-style",
                    "border-width",
                ]
                .contains(shorthand_property)
                {
                    let (start, end) = shorthand_property.split_at(6);
                    assert!(longhand_sub_property.starts_with(start));
                    assert!(longhand_sub_property.ends_with(end));
                } else if *shorthand_property == "columns" {
                    assert!(longhand_sub_property.starts_with("column"));
                } else if *shorthand_property == "flex-flow" {
                    assert!(["flex-direction", "flex-wrap",].contains(longhand_sub_property));
                } else if *shorthand_property == "font" {
                    if *longhand_sub_property != "line-height" {
                        assert!(longhand_sub_property.starts_with(shorthand_property));
                    }
                } else if *shorthand_property == "gap" {
                    assert!(longhand_sub_property.ends_with(shorthand_property));
                } else if *shorthand_property == "grid-area" {
                    assert!(
                        longhand_sub_property.starts_with("grid-row")
                            || longhand_sub_property.starts_with("grid-column")
                    );
                } else if *shorthand_property == "grid-gap" {
                    let (start, end) = shorthand_property.split_at(4);
                    assert!(longhand_sub_property.starts_with(start));
                    assert!(longhand_sub_property.ends_with(end));
                } else if *shorthand_property == "inset" {
                    assert!(["bottom", "left", "right", "top"].contains(longhand_sub_property));
                } else if ["place-content", "place-items", "place-self"]
                    .contains(shorthand_property)
                {
                    assert!(
                        longhand_sub_property.starts_with("align")
                            || longhand_sub_property.starts_with("justify")
                    );

                    let (_, end) = shorthand_property.split_at(5);
                    assert!(longhand_sub_property.ends_with(end));
                } else {
                    assert!(longhand_sub_property.starts_with(shorthand_property));
                }
            }
        }
    }

    #[test]
    fn test_reset_to_initial_properties_by_border_sorted() {
        let sorted = RESET_TO_INITIAL_PROPERTIES_BY_BORDER.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(RESET_TO_INITIAL_PROPERTIES_BY_BORDER, sorted.as_slice());
    }

    #[test]
    fn test_reset_to_initial_properties_by_border_unique() {
        let mut set = HashSet::new();
        let has_duplicates = RESET_TO_INITIAL_PROPERTIES_BY_BORDER
            .iter()
            .any(|&x| !set.insert(x));
        assert!(!has_duplicates);
    }

    #[test]
    fn test_reset_to_initial_properties_by_font_sorted() {
        let sorted = RESET_TO_INITIAL_PROPERTIES_BY_FONT.to_vec();
        let _ = sorted.is_sorted();
        assert_eq!(RESET_TO_INITIAL_PROPERTIES_BY_FONT, sorted.as_slice());
    }

    #[test]
    fn test_reset_to_initial_properties_by_font_unique() {
        let mut set = HashSet::new();
        let has_duplicates = RESET_TO_INITIAL_PROPERTIES_BY_FONT
            .iter()
            .any(|&x| !set.insert(x));
        assert!(!has_duplicates);
    }

    #[test]
    fn test_selector_types() {
        for items in HTML_TAGS.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_svg_tags() {
        for items in SVG_TAGS.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }

    #[test]
    fn test_math_ml_tags() {
        for items in MATH_ML_TAGS.windows(2) {
            assert!(items[0] < items[1], "{} < {}", items[0], items[1]);
        }
    }
}
