import tsPlugin from "@typescript-eslint/eslint-plugin";
import parser from "@typescript-eslint/parser";

export default [
  {
    files: ["**/*.js", "**/*.ts", "**/*.jsx", "**/*.tsx"],
    languageOptions: {
      parser,
      parserOptions: {
        ecmaFeatures: { modules: true },
        ecmaVersion: "latest",
        project: "../../tsconfig.json",
      },
    },
    plugins: {
      "@typescript-eslint": tsPlugin,
    },
    rules: {
      // Biome complexity
      // deprecated rule
      //"@typescript-eslint/ban-types": "error",
      "no-extra-boolean-cast": "error",
      "no-regex-spaces": "error",
      "@typescript-eslint/no-extraneous-class": "error",
      "no-useless-catch": "error",
      "@typescript-eslint/no-useless-constructor": "error",
      "@typescript-eslint/no-useless-empty-export": "error",
      "no-extra-label": "error",
      "no-useless-rename": "error",
      "@typescript-eslint/no-unnecessary-type-constraint": "error",
      "no-void": "error",
      "no-with": "error",
      "prefer-arrow-callback": "error",
      // disable type rules
      //"@typescript-eslint/dot-notation": "error",
      //"@typescript-eslint/prefer-optional-chain": "error",
      "prefer-regex-literals": "error",

      // Biome correctness
      "no-const-assign": "error",
      "no-constant-condition": "error",
      "no-constructor-return": "error",
      "no-empty-character-class": "error",
      "no-empty-pattern": "error",
      "no-obj-calls": "error",
      "no-inner-declarations": "error",
      "constructor-super": "error",
      "no-new-native-nonconstructor": "error",
      "no-new-symbol": "error",
      "@typescript-eslint/no-use-before-define": "error",
      "no-loss-of-precision": "error",
      "no-self-assign": "error",
      "no-setter-return": "error",
      "no-case-declarations": "error",
      "no-undef": "error",
      "no-unreachable": "error",
      "no-this-before-super": "error",
      "no-unsafe-finally": "error",
      "no-unsafe-optional-chaining": "error",
      "no-unused-labels": "error",
      "no-unused-private-class-members": "error",
      "no-unused-vars": "error",
      "no-array-constructor": "error",
      "use-isnan": "error",
      "for-direction": "error",
      "require-yield": "error",

      // Biome security
      "no-eval": "error",

      // Biome style
      "prefer-rest-params": "error",
      "no-sequences": "error",
      "@typescript-eslint/no-inferrable-types": "error",
      "@typescript-eslint/no-namespace": "error",
      "@typescript-eslint/no-non-null-assertion": "error",
      "no-param-reassign": "error",
      "@typescript-eslint/parameter-properties": [
        "error",
        { prefer: "class-property" },
      ],
      "no-var": "error",
      "@typescript-eslint/prefer-as-const": "error",
      "prefer-const": "error",
      "no-lonely-if": "error",
      "@typescript-eslint/array-type": "error",
      "default-param-last": "error",
      "@typescript-eslint/prefer-enum-initializers": "error",
      "prefer-exponentiation-operator": "error",
      // disable type rule
      //"@typescript-eslint/consistent-type-exports": "error",
      "@typescript-eslint/prefer-for-of": "error",
      // disable type rule
      //"@typescript-eslint/consistent-type-imports": "error",
      "@typescript-eslint/prefer-literal-enum-member": "error",
      // disable type rule
      //"@typescript-eslint/naming-convention": "error",
      "prefer-numeric-literals": "error",
      "@typescript-eslint/prefer-function-type": "error",
      "one-var": "error",
      "prefer-template": "error",

      // Biome suspicious
      "no-async-promise-executor": "error",
      "no-cond-assign": "error",
      "no-ex-assign": "error",
      "no-class-assign": "error",
      "no-compare-neg-zero": "error",
      "no-labels": "error",
      "no-control-regex": "error",
      "no-debugger": "error",
      eqeqeq: "error",
      "no-duplicate-case": "error",
      "@typescript-eslint/no-dupe-class-members": "error",
      "no-dupe-keys": "error",
      "no-dupe-args": "error",
      "no-empty": "error",
      "no-empty-static-block": "error",
      "@typescript-eslint/no-empty-function": "error",
      "@typescript-eslint/no-empty-interface": "error",
      "@typescript-eslint/no-explicit-any": "error",
      "@typescript-eslint/no-extra-non-null-assertion": "error",
      "no-fallthrough": "error",
      "no-func-assign": "error",
      "no-global-assign": "error",
      "no-import-assign": "error",
      "no-label-var": "error",
      "no-misleading-character-class": "error",
      "@typescript-eslint/no-misused-new": "error",
      "no-prototype-builtins": "error",
      "no-redeclare": "error",
      "no-self-compare": "error",
      "no-shadow-restricted-names": "error",
      "no-sparse-arrays": "error",
      "@typescript-eslint/no-unsafe-declaration-merging": "error",
      "no-unsafe-negation": "error",
      "require-await": "error",
      // disable type rule
      //"@typescript-eslint/require-await": "error",
      "default-case-last": "error",
      "getter-return": "error",
      "@typescript-eslint/prefer-namespace-keyword": "error",
      "valid-typeof": "error",
    },
  },
];
