/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.bc;

import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        SHA1Digest sHA1Digest;
        if (algorithmIdentifier.getAlgorithm().equals((Object)OIWObjectIdentifiers.idSHA1)) {
            sHA1Digest = new SHA1Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha224)) {
            sHA1Digest = new SHA224Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha256)) {
            sHA1Digest = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha384)) {
            sHA1Digest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha512)) {
            sHA1Digest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.md5)) {
            sHA1Digest = new MD5Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.md4)) {
            sHA1Digest = new MD4Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return sHA1Digest;
    }
}

