/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;
import jnr.ffi.Address;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.Type;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.LongLong;
import jnr.ffi.annotations.SaveError;
import jnr.ffi.annotations.StdCall;
import jnr.ffi.annotations.TypeDefinition;
import jnr.ffi.byref.ByReference;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvokerUtil {
    InvokerUtil() {
    }

    static NativeType getAliasedNativeType(NativeRuntime runtime, Class type, Annotation[] annotations) {
        for (Annotation a : annotations) {
            TypeDefinition typedef = a.annotationType().getAnnotation(TypeDefinition.class);
            if (typedef == null) continue;
            return InvokerUtil.nativeType(runtime.findType(typedef.alias()));
        }
        if (InvokerUtil.isLong32(type, annotations)) {
            return NativeType.SLONG;
        }
        if (InvokerUtil.isLongLong(type, annotations)) {
            return NativeType.SLONGLONG;
        }
        return null;
    }

    public static final boolean requiresErrno(Method method) {
        boolean saveError = true;
        for (Annotation a : method.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }

    public static com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        Object convention = libraryOptions.get((Object)LibraryOption.CallingConvention);
        if (convention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)convention;
        }
        if (convention instanceof CallingConvention) {
            switch ((CallingConvention)((Object)convention)) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + convention);
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    static boolean isLong32(Class type, Annotation[] annotations) {
        return (Long.TYPE == type || Long.class.isAssignableFrom(type)) && Platform.getPlatform().longSize() == 32 && !InvokerUtil.hasAnnotation(annotations, LongLong.class);
    }

    static boolean isLongLong(Class type, Annotation[] annotations) {
        return !(Long.TYPE != type && !Long.class.isAssignableFrom(type) || !InvokerUtil.hasAnnotation(annotations, LongLong.class) && Platform.getPlatform().longSize() != 64);
    }

    static com.kenai.jffi.Type jffiType(NativeType jnrType) {
        switch (jnrType) {
            case VOID: {
                return com.kenai.jffi.Type.VOID;
            }
            case SCHAR: {
                return com.kenai.jffi.Type.SCHAR;
            }
            case UCHAR: {
                return com.kenai.jffi.Type.UCHAR;
            }
            case SSHORT: {
                return com.kenai.jffi.Type.SSHORT;
            }
            case USHORT: {
                return com.kenai.jffi.Type.USHORT;
            }
            case SINT: {
                return com.kenai.jffi.Type.SINT;
            }
            case UINT: {
                return com.kenai.jffi.Type.UINT;
            }
            case SLONG: {
                return com.kenai.jffi.Type.SLONG;
            }
            case ULONG: {
                return com.kenai.jffi.Type.ULONG;
            }
            case SLONGLONG: {
                return com.kenai.jffi.Type.SLONG_LONG;
            }
            case ULONGLONG: {
                return com.kenai.jffi.Type.ULONG_LONG;
            }
            case FLOAT: {
                return com.kenai.jffi.Type.FLOAT;
            }
            case DOUBLE: {
                return com.kenai.jffi.Type.DOUBLE;
            }
            case ADDRESS: {
                return com.kenai.jffi.Type.POINTER;
            }
        }
        throw new IllegalArgumentException("unsupported parameter type: " + (Object)((Object)jnrType));
    }

    static NativeType nativeType(Type jnrType) {
        return jnrType.getNativeType();
    }

    static ResultType getResultType(NativeRuntime runtime, Class type, Annotation[] annotations, FromNativeConverter fromNativeConverter) {
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type, annotations);
        return new ResultType(type, nativeType, annotations, fromNativeConverter);
    }

    static ParameterType getParameterType(NativeRuntime runtime, Class type, Annotation[] annotations, ToNativeConverter toNativeConverter) {
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type, annotations);
        return new ParameterType(type, nativeType, annotations, toNativeConverter);
    }

    static CallContext getCallContext(SigType resultType, SigType[] parameterTypes, com.kenai.jffi.CallingConvention convention, boolean requiresErrno) {
        com.kenai.jffi.Type[] nativeParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.jffiType(parameterTypes[i].nativeType);
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType.nativeType), nativeParamTypes, convention, requiresErrno);
    }

    static CallContext getCallContext(NativeType resultType, NativeType[] parameterTypes, com.kenai.jffi.CallingConvention convention, boolean requiresErrno) {
        com.kenai.jffi.Type[] nativeParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.jffiType(parameterTypes[i]);
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType), nativeParamTypes, convention, requiresErrno);
    }

    public static com.kenai.jffi.CallingConvention getNativeCallingConvention(Method m) {
        if (m.getAnnotation(StdCall.class) != null || m.getDeclaringClass().getAnnotation(StdCall.class) != null) {
            return com.kenai.jffi.CallingConvention.STDCALL;
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    static NativeType getNativeType(NativeRuntime runtime, Class type, Annotation[] annotations) {
        NativeType aliasedType = InvokerUtil.getAliasedNativeType(runtime, type, annotations);
        if (aliasedType != null) {
            return aliasedType;
        }
        if (Void.class.isAssignableFrom(type) || Void.TYPE == type) {
            return NativeType.VOID;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return NativeType.SINT;
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return NativeType.SCHAR;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return NativeType.SSHORT;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return NativeType.SINT;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return InvokerUtil.isLongLong(type, annotations) ? NativeType.SLONGLONG : NativeType.SLONG;
        }
        if (NativeLong.class.isAssignableFrom(type)) {
            return NativeType.SLONG;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return NativeType.FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return NativeType.DOUBLE;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (Address.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (String.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (ByReference.class.isAssignableFrom(type)) {
            return NativeType.ADDRESS;
        }
        if (type.isArray()) {
            return NativeType.ADDRESS;
        }
        if (AsmUtil.isDelegate(type)) {
            return NativeType.ADDRESS;
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    static NativeType getMethodParameterNativeType(NativeRuntime runtime, Class parameterClass, Annotation[] annotations) {
        return InvokerUtil.getNativeType(runtime, parameterClass, annotations);
    }

    static NativeType getMethodResultNativeType(NativeRuntime runtime, Class parameterClass, Annotation[] annotations) {
        return InvokerUtil.getNativeType(runtime, parameterClass, annotations);
    }
}

