/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class Files {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readFileList(File atfile) throws IOException {
        LinkedList<String> _result;
        block8: {
            if (atfile == null) {
                throw new IllegalArgumentException("null input: atfile");
            }
            _result = null;
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(atfile), 8192);
                _result = new LinkedList<String>();
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    _result.add(line);
                }
                Object var5_4 = null;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            in.close();
        }
        if (_result == null) return IConstants.EMPTY_STRING_ARRAY;
        if (_result.isEmpty()) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static File[] pathToFiles(String[] path, boolean canonical) {
        if (path == null) {
            throw new IllegalArgumentException("null input: path");
        }
        if (path.length == 0) {
            return IConstants.EMPTY_FILE_ARRAY;
        }
        ArrayList<File> _result = new ArrayList<File>(path.length);
        HashSet<String> pathnames = new HashSet<String>(path.length);
        String separators = ",".concat(File.pathSeparator);
        for (int i = 0; i < path.length; ++i) {
            String segment = path[i];
            if (segment == null) {
                throw new IllegalArgumentException("null input: path[" + i + "]");
            }
            StringTokenizer tokenizer = new StringTokenizer(segment, separators);
            while (tokenizer.hasMoreTokens()) {
                String pathname = tokenizer.nextToken();
                if (canonical) {
                    pathname = Files.canonicalizePathname(pathname);
                }
                if (!pathnames.add(pathname)) continue;
                _result.add(new File(pathname));
            }
        }
        File[] result = new File[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static String canonicalizePathname(String pathname) {
        if (pathname == null) {
            throw new IllegalArgumentException("null input: pathname");
        }
        try {
            return new File(pathname).getCanonicalPath();
        }
        catch (Exception e) {
            return new File(pathname).getAbsolutePath();
        }
    }

    public static File canonicalizeFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file.getAbsoluteFile();
        }
    }

    public static String getFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        return name.substring(0, lastDot);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return name.substring(lastDot);
    }

    public static File newFile(File dir, File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (dir == null || file.isAbsolute()) {
            return file;
        }
        return new File(dir, file.getPath());
    }

    public static File newFile(File dir, String file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File fileFile = new File(file);
        if (dir == null || fileFile.isAbsolute()) {
            return fileFile;
        }
        return new File(dir, file);
    }

    public static File newFile(String dir, String file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File fileFile = new File(file);
        if (dir == null || fileFile.isAbsolute()) {
            return fileFile;
        }
        return new File(dir, file);
    }

    public static boolean renameFile(File source, File target, boolean overwrite) {
        if (source == null || !source.exists()) {
            throw new IllegalArgumentException("invalid input source: [" + source + "]");
        }
        if (target == null) {
            throw new IllegalArgumentException("null input: target");
        }
        boolean targetExists = target.exists();
        if (!targetExists || overwrite) {
            if (targetExists) {
                target.delete();
            } else {
                File targetDir = target.getParentFile();
                if (targetDir != null && !targetDir.equals(source.getParentFile())) {
                    targetDir.mkdirs();
                }
            }
            return source.renameTo(target);
        }
        return false;
    }

    public static File createTempFile(File parentDir, String prefix, String extension) throws IOException {
        if (parentDir == null || !parentDir.exists()) {
            throw new IllegalArgumentException("invalid parent directory: [" + parentDir + "]");
        }
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("null or less than 3 chars long: " + prefix);
        }
        if (extension == null) {
            extension = ".tmp";
        } else if (extension.charAt(0) != '.') {
            extension = ".".concat(extension);
        }
        return File.createTempFile(prefix, extension, parentDir);
    }

    private Files() {
    }
}

