package org.jruby.parser;

public class Ruby19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          198,  198,  269,   92,  272,  624,  100,  252,  252,  211, 
          432,  252,  511,  290,  370,  233,  612,  265,  213,  266, 
          197,  198,    8,  412,  288,  118,  118,  573,   71,  211, 
          537,  600,    8,  271,  565,  118,  237,  465,  213,  537, 
          466,  772,  786,   88,  301,  630,  198,  537,  287,  291, 
          535,  231,  234,  374,  225,  225,  225,  513,  488,  548, 
          599,  320,   83,  321,  232,  299,  307,  268,  536,  548, 
          118,  555,  561,  673,  568,  569,  362,   80,  388,   69, 
          621,    8,  282,  375,  513,  494,  511,  289,  292,  352, 
          464,  285,  844,  663,  635,  481,   83,  594,  851,  486, 
          548,  265,  910,  318,  367,  488,  513,  488,  548,  462, 
          500,  320,  696,   69,  118,  373,  841,  555,  561,  494, 
          261,  456,   93,  237,   79,   79,  784,  462,   80,  508, 
          494,  594,  684,  513,  494,  381,  548,  666,  352,   70, 
          367,  585,  385,  461,  500,  662,  548,  268,  699,  548, 
          282,  441,  642,  507,  488,  233,  378,  367,  548,  500, 
          489,  464,  594,  508,  494,  490,  275,  607,  458,  278, 
          910,  727,  443,  367,  233,  401,  488,  345,  508,  494, 
          308,  896,  594,  338,  319,  642,  893,  343,  346,  341, 
           68,  344,  511,  748,  339,  548,  342,  427,  340,  543, 
          721,  685,  427,   72,  232,  330,  331,  755,  580,  786, 
          844,  318,  424,  425,  426,  851,  469,  543,   78,   84, 
           84,  119,  119,  232,  691,   84,  227,  227,  227,  308, 
           76,  242,  227,  227,  763,  726,  227,  400,  922,  444, 
          445,  749,  611,  264,  414,  237,  732,  488,  673,  773, 
          268,  413,   14,  252,   72,  252,  252,  692,  805,  237, 
          268,  382,   84,  227,  809,  438,  297,  944,  227,   78, 
           73,  264,  280,  667,  641,  363,  537,  641,   96,  417, 
          418,   76,  364,  225,  225,  784,  548,  253,  259,  278, 
          279,  260,  319,  233,  798,  392,  488,  511,  274,   81, 
          312,   14,  393,  670,  784,  492,  493,  494,  495,  314, 
          297,  450,  440,  360,  442,  386,  118,  643,  282,   53, 
          361,   73,  387,  645,  646,  358,  283,  464,  227,  537, 
           84,   69,  577,  677,  464,  548,  586,  548,  537,  396, 
          654,  815,  232,  655,  579,  537,   80,  365,  579,  673, 
           81,  673,  513,  488,  252,  563,  557,  101,  570,   71, 
          574,  383,  608,  438,  584,  587,  518,  519,  520,  521, 
          225,  225,  225,  225,  579,  523,  524,  589,  573,  577, 
          252,  563,  557,  838,    8,  582,  548,  793,  513,  438, 
          118,  625,  637,  639,  758,  469,  290,  267,  610,  613, 
          252,  563,  557,  548,  761,  282,  278,  591,   80,  438, 
          598,  548,  535,  278,  252,  563,  557,  752,  527,  673, 
          895,  513,  488,  438,  508,  494,  639,  888,   88,  290, 
          536,  548,  513,  494,   84,  601,  488,  352,  730,  366, 
          198,  615,  629,  629,  192,  627,  563,  557,  211,  623, 
           92,  522,  647,  886,  192,  227,  227,  213,  500,  878, 
          508,  494,   88,  894,  720,  252,  563,  557,  640,  673, 
           70,  673,   72,   74,  438,  475,  476,  508,  227,   88, 
          227,  227,  478,  683,  227,  729,  227,   78,  237,  548, 
          941,   84,  648,  508,  494,  118,   79,  275,   84,   76, 
          673,  656,  469,  192,   14,   14,   14,  488,  345,  464, 
           14,   14,  297,   14,  338,  695,  695,  511,  343,  346, 
          341,  913,  344,  614,   74,  339,  698,  342,  828,  340, 
          330,  331,  759,  433,   72,  436,   79,  716,  408,   73, 
          548,  711,  227,  227,  227,  227,   84,  227,  227,   78, 
          403,  702,  695,  703,  367,  918,  705,  708,   77,  709, 
          775,   76,  283,  422,  702,  702,  712,  714,   81,  705, 
          705,   79,  371,  379,  548,  711,   75,  380,  762,  227, 
          408,  372,  227,   14,  227,   84,  297,   79,  227,  227, 
          702,   84,  594,  708,  548,  705,   16,  711,  548,  198, 
          198,   73,  118,  757,   14,  227,   84,  227,  211,   77, 
          737,  711,  734,  741,  820,  724,  613,  213,   84,  733, 
          267,   84,  885,  548,  613,  227,  548,   75,  731,   84, 
           81,  376,  377,  725,  770,   95,   90,  225,  711,  227, 
          395,  776,  473,  469,  397,   16,  883,  548,  738,  283, 
          537,  388,  399,  683,  402,  840,  794,   63,   63,  114, 
          114,  114,  409,   63,  227,  548,   84,  410,  683,  241, 
           90,  530,  475,  476,  477,  548,  411,  756,  118,  478, 
          414,  225,  272,  548,  814,  419,  537,   90,  742,  611, 
          227,  297,  402,  801,  803,  548,  548,   88,  695,  806, 
           63,  764,  416,  537,  296,  530,  192,  192,  192,  713, 
          715,  574,  192,  192,  548,  192,  834,  526,  101,  537, 
          530,  780,  781,   94,  423,  670,  258,  492,  493,  494, 
          495,  796,  548,  797,  192,  192,  800,  192,  192,  192, 
          192,  402,   74,  118,  427,   15,  464,  428,  296,  431, 
          818,  268,  530,  464,  864,  332,  118,  688,  690,   88, 
          310,  311,  449,  548,  475,  476,  683,  101,   63,  453, 
          279,  478,  454,  455,  483,  406,  829,  460,  877,  467, 
          457,  629,  407,  830,  233,  192,  468,  225,   92,  835, 
          836,  837,   91,  474,   15,  475,  476,  480,  297,  278, 
          420,  484,  478,  875,   74,   79,  192,  421,  516,  227, 
           84,  332,   98,   96,   96,  488,  583,  451,  751,   96, 
          447,   84,   92,  611,  452,  897,   91,   77,   84,  616, 
          650,  548,  626,  232,  657,  872,  613,  644,  668,   92, 
          669,  678,  347,   91,  679,   75,  349,  350,   16,   16, 
           16,  548,  548,  227,   16,   16,   96,   16,  401,  401, 
          680,   98,  687,  689,  401,  884,  700,   79,  701,  527, 
          103,  706,   63,  530,  297,  252,  563,  557,  707,  471, 
          548,   84,  118,  881,  438,  548,  472,  548,  386,   77, 
          882,  718,  719,  526,  711,  931,  278,   88,   88,  120, 
          120,   84,   84,   88,   89,   90,  526,   75,  722,  243, 
          728,   84,  735,   84,  739,  745,   84,  227,  227,  272, 
          746,  613,  920,  227,   96,  563,  272,   16,  921,   63, 
          278,   97,  100,  750,  747,  227,   63,  548,   89,  297, 
           88,  530,  548,  760,  298,  278,  774,  779,   16,  402, 
          296,  799,  825,  811,  526,   89,   84,  810,  102,  227, 
          848,  526,  492,  493,  494,  495,  526,   90,  548,   84, 
           84,   84,  548,  548,   90,  101,  819,  278,  821,  831, 
           97,  100,  832,   40,   63,  392,  833,  526,  298,  530, 
          839,  842,  846,   40,  845,  852,  530,   15,   15,   15, 
          853,  526,  854,   15,   15,  856,   15,  279,   88,  475, 
          476,  482,  392,  527,  279,   84,  478,   99,  858,  530, 
          402,  526,  530,   63,  296,  847,  861,  227,   96,   63, 
          855,  857,  862,  859,   84,  860,  278,  863,  865,  866, 
          868,  403,   40,  278,   63,   84,   96,  788,  527,  492, 
          493,  494,  495,  867,  103,  869,   63,   92,  527,   63, 
          102,   91,  530,  870,  871,   48,   99,   63,  874,   98, 
          880,   91,   91,  889,  890,   48,   15,   91,  903,  892, 
          496,  905,  526,  244,  912,   96,  911,  923,  498,  499, 
          500,  501,   96,  926,  930,   96,   84,   15,  530,  933, 
          227,  935,   84,  103,   63,  937,  527,  940,   84,  102, 
          530,  943,   88,  527,   91,  954,  535,  530,  527,   92, 
          548,  548,  526,   91,   48,  548,   93,  464,  537,  296, 
          526,  475,  476,  485,  536,  272,  537,  526,  478,  527, 
           96,  279,  526,  530,  541,  541,  925,  927,  928,  929, 
          765,  766,  932,  767,  934,  936,  938,  939,  543,  537, 
           93,  537,  670,  526,  492,  493,  494,  495,  548,   88, 
          548,   50,  323,   89,  392,  121,   88,   93,  942,   96, 
          200,   50,   91,  879,  783,   96,   95,  907,   97,  100, 
          298,  324,  245,  952,  919,  671,  953,  955,  956,  957, 
           96,  392,  527,  672,  771,  924,  959,  278,  649,   98, 
          526,    0,   96,    0,  278,   96,    0,   59,   60,    0, 
           95,  278,  392,   96,   88,    0,  527,    0,    0,  392, 
           50,  431,  431,  431,    0,   89,  296,   95,  431,  325, 
          326,  327,  328,  329,  278,   40,   40,   40,   63,  392, 
          527,   40,   40,    0,   40,  392,  392,  527,  526,   63, 
           96,  264,  527,   88,  298,  526,   63,  272,    0,   88, 
          526,  264,   94,    0,   99,    0,   40,   40,   40,   40, 
           40,    0,  392,  527,   88,    0,   91,  530,  535,  535, 
          535,  526,    0,    0,  535,  535,   88,  535,    0,   88, 
            0,   89,    0,   96,    0,  259,   94,   88,  421,  421, 
          421,  103,  296,    0,    0,  421,    0,  102,    0,   63, 
          264,    0,    0,   94,   40,    0,    0,   48,   48,   48, 
            0,    0,   48,   48,   48,  530,   48,    0,    0,   63, 
           63,    0,  530,   91,   88,   40,   48,  526,  392,   63, 
           91,   63,    0,  279,   63,   48,   48,    0,   48,   48, 
           48,   48,   48,    0,  464,  332,    0,  535,  530,  298, 
           92,  464,  272,  548,  548,  548,  180,  296,  279,  272, 
          548,  345,  346,  332,    0,  279,    0,    0,  535,   49, 
          824,    0,    0,    0,   63,   93,  347,    0,   91,   49, 
          349,  350,  351,  352,   96,    0,   48,   63,   63,   63, 
            0,    0,    0,    0,  347,   96,    0,  527,  349,  350, 
          351,  352,   96,    0,    0,  180,    0,   48,    0,    0, 
            0,    0,    0,   50,   50,   50,  578,   91,   50,   50, 
           50,    0,   50,   91,  278,    0,    0,    0,   49,    0, 
            0,  278,   50,   63,    0,   95,  527,   93,   91,  173, 
            0,   50,   50,    0,   50,   50,   50,   50,   50,    0, 
           91,    0,   63,   91,    0,   96,  298,    0,    0,    0, 
            0,   91,    0,   63,    0,    0,    0,  670,   88,  492, 
          493,  494,  495,    0,    0,   96,   96,    0,  670,   88, 
          492,  493,  494,  495,  272,   96,   88,   96,  173,    0, 
           96,  272,   50,  183,    0,    0,  114,   95,   91,    0, 
          671,    0,    0,  264,  264,  264,    0,    0,  264,  264, 
          264,  671,  264,   50,   63,    0,   97,  392,    0,  843, 
           63,   94,  782,    0,  785,    0,   63,  789,    0,    0, 
           96,    0,  298,    0,  264,  264,  264,  264,  264,   88, 
          769,    0,  183,   96,   96,   96,    0,  536,  536,  536, 
            0,    0,    0,  536,  536,    0,  536,    0,    0,   88, 
           88,    0,    0,    0,    0,  392,    0,    0,    0,   88, 
          279,   88,  392,    0,   88,    0,    0,  279,    0,  264, 
          251,  251,  264,   94,  251,  100,  527,    0,    0,   96, 
           55,    0,    0,    0,    0,    0,    0,  298,  392,    0, 
           55,    0,    0,  264,    0,    0,  275,  277,   96,    0, 
          826,    0,  251,  251,   88,  300,  302,    0,    0,   96, 
            0,    0,    0,    0,    0,    0,  536,   88,   88,   88, 
            0,   49,   49,   49,  527,    0,   49,   49,   49,    0, 
           49,  527,   91,    0,    0,    0,  527,  536,    0,   55, 
           49,    0,  180,   91,  180,  180,  180,  180,    0,    0, 
           91,    0,   49,   49,   49,   49,   49,  527,    0,    0, 
           96,    0,    0,   88,  458,    0,   96,    0,    0,    0, 
            0,  458,   96,    0,    0,  180,  180,    0,    0,  332, 
            0,  899,   88,  180,  180,  180,  180,    0,    0,    0, 
          906,    0,  908,   88,    0,  345,  346,    0,    0,    0, 
           49,    0,    0,   91,    0,    0,    0,    0,    0,    0, 
          347,    0,  348,    0,  349,  350,  351,  352,    0,    0, 
          355,   49,  356,   91,   91,  173,  120,  173,  173,  173, 
          173,    0,    0,   91,    0,   91,    0,    0,   91,   91, 
            0,    0,    0,    0,   88,    0,    0,  457,    0,    0, 
           88,    0,  115,  115,  457,    0,   88,  578,  173,  173, 
          949,    0,  115,    0,    0,    0,  173,  173,  173,  173, 
          203,    0,    0,    0,  827,    0,    0,    0,   91,  183, 
          203,  183,  183,  183,  183,    0,  530,    0,    0,  115, 
          115,   91,   91,   91,    0,  115,  115,  115,  115,    0, 
            0,  459,  251,  251,  251,  302,    0,    0,  459,    0, 
            0,    0,  183,  183,  203,    0,  251,    0,  251,  251, 
          183,  183,  183,  183,    0,    0,    0,  448,  203,  203, 
            0,    0,    0,  203,    0,    0,    0,   91,    0,    0, 
            0,  115,   55,   55,   55,    0,    0,   55,   55,   55, 
            0,   55,    0,    0,    0,    0,   91,    0,    0,    0, 
            0,   55,    0,    0,    0,    0,    0,   91,    0,    0, 
           55,   55,  262,   55,   55,   55,   55,   55,    0,    0, 
            0,    0,  262,    0,    0,    0,    0,  525,  526,  527, 
          528,  529,  530,  531,  532,  533,  534,  535,  536,  537, 
          538,  539,  540,  541,  542,  543,  544,  545,  546,  547, 
          548,  549,  550,    0,    0,    0,  260,  251,   91,    0, 
          571,   55,  575,  332,   91,    0,  251,  588,    0,    0, 
           91,  262,    0,    0,    0,    0,    0,    0,    0,  345, 
          346,    0,   55,  251,    0,    0,  491,    0,  492,  493, 
          494,  495,  251,    0,  347,    0,  348,    0,  349,  350, 
          351,  352,    0,  251,  571,  622,  588,    0,  670,  251, 
          492,  493,  494,  495,   99,  530,    0,  251,    0,  496, 
          497,    0,  251,  251,    0,    0,  251,  498,  499,  500, 
          501,    0,    0,    0,    0,  115,  115,  115,  115,    0, 
            0,  496,    0,    0,    0,    0,    0,    0,  651,  652, 
          653,  500,  501,    0,    0,    0,  251,  549,    0,  251, 
          115,    0,    0,  530,    0,    0,    0,  549,  251,    0, 
          530,    0,  203,  203,  203,  526,    0,  203,  203,  203, 
            0,  203,    0,  115,    0,    0,    0,    0,    0,    0, 
            0,  203,  203,    0,    0,    0,  530,    0,    0,    0, 
          203,  203,    0,  203,  203,  203,  203,  203,    0,    0, 
            0,    0,    0,    0,    0,  203,  549,    0,    0,    0, 
          115,  115,  115,  115,  115,  115,  115,  115,  115,  115, 
          115,  115,  115,  115,  115,  115,  115,  115,  115,  115, 
          115,  115,  115,  115,  115,  115,    0,    0,  203,    0, 
            0,  203,    0,    0,  203,    0,  203,  115,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  251,    0,    0, 
            0,    0,  203,    0,  262,  262,  262,    0,    0,  262, 
          262,  262,    0,  262,  203,  115,    0,  491,    0,  492, 
          493,  494,  495,    0,    0,    0,    0,  115,  115,  115, 
            0,    0,  115,    0,    0,  262,  262,  262,  262,  262, 
            0,    0,    0,    0,    0,  115,  115,    0,    0,  115, 
          496,  602,    0,    0,    0,    0,    0,    0,  498,  499, 
          500,  501,    0,  251,  491,  258,  492,  493,  494,  495, 
            0,  115,  115,  115,    0,  258,    0,    0,    0,  115, 
          262,    0,  115,  262,    0,    0,  788,    0,  492,  493, 
          494,  495,  115,    0,  251,    0,    0,  496,    0,    0, 
            0,    0,    0,    0,  262,  498,  499,  500,  501,  258, 
            0,    0,    0,    0,  168,    0,    0,    0,    0,  496, 
            0,    0,    0,    0,  258,  802,  804,  498,  499,  500, 
          501,  807,  808,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  812,  622,  251,    0,    0,    0,  816,  549, 
          549,  549,    0,    0,  549,  549,  549,    0,  549,    0, 
            0,    0,    0,  168,    0,    0,    0,    0,  549,  549, 
          802,  804,  807,    0,    0,    0,  251,  549,  549,    0, 
          549,  549,  549,  549,  549,    0,    0,    0,    0,    0, 
          115,    0,  777,    0,    0,    0,    0,    0,    0,  115, 
            0,  787,    0,    0,  791,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  452, 
            0,    0,    0,    0,  873,    0,    0,    0,  549,  452, 
            0,  549,    0,  549,    0,  876,    0,    0,  251,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  549, 
            0,    0,    0,  332,    0,    0,  115,  876,  337,  338, 
            0,    0,    0,  452,    0,    0,    0,    0,    0,  345, 
          346,    0,    0,    0,    0,  115,    0,  452,  452,    0, 
          452,    0,  452,    0,  347,    0,  348,  115,  349,  350, 
          351,  352,  353,  354,  355,    0,  356,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  251,    0, 
          452,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  115,    0,  258,  258,  258, 
            0,    0,  258,  258,  258,  115,  258,  115,    0,    0, 
          115,  115,  455,    0,    0,    0,  258,  258,    0,    0, 
            0,    0,  455,  115,    0,  258,  258,    0,  258,  258, 
          258,  258,  258,  115,  115,  115,  898,    0,  900,  115, 
          901,    0,    0,    0,  904,    0,    0,    0,    0,  909, 
            0,    0,    0,    0,    0,    0,  455,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          455,  455,    0,  455,    0,  455,  258,    0,    0,  258, 
          168,  258,  168,  168,  168,  168,    0,  115,    0,  268, 
            0,    0,    0,    0,    0,    0,    0,  258,    0,    0, 
            0,  115,  460,  455,    0,    0,    0,    0,  945,  460, 
            0,    0,    0,  168,  168,  948,    0,  950,    0,  951, 
          115,  168,  168,  168,  168,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  958,    0,    0,    0, 
            0,    0,  357,    0,    0,    0,  523,  523,  523,  115, 
          523,  452,  452,  452,  523,  523,  452,  452,  452,  523, 
          452,  523,  523,  523,  523,  523,  523,  523,  452,  523, 
          452,  452,  523,  523,  523,  523,  523,  523,  523,  452, 
          452,  523,  452,  452,  452,  452,  452,    0,  523,    0, 
            0,  523,  523,  523,  452,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  452,  452,  452,  452, 
          452,  452,  452,  452,  452,  452,  452,  452,  452,  452, 
            0,    0,  452,  452,  452,  523,  452,  452,  523,  523, 
          452,  523,  523,  452,  523,  452,  523,  452,  523,  452, 
          523,  452,  452,  452,  452,  452,  452,  452,  523,  452, 
          523,  452,    0,  523,  523,  523,  523,  523,  523,    0, 
            0,  150,  523,  452,  523,  523,    0,  523,  523,  524, 
          524,  524,    0,  524,  455,  455,  455,  524,  524,  455, 
          455,  455,  524,  455,  524,  524,  524,  524,  524,  524, 
          524,  455,  524,  455,  455,  524,  524,  524,  524,  524, 
          524,  524,  455,  455,  524,  455,  455,  455,  455,  455, 
          150,  524,    0,    0,  524,  524,  524,  455,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  455, 
          455,  455,  455,  455,  455,  455,  455,  455,  455,  455, 
          455,  455,  455,    0,    0,  455,  455,  455,  524,  455, 
          455,  524,  524,  455,  524,  524,  455,  524,  455,  524, 
          455,  524,  455,  524,  455,  455,  455,  455,  455,  455, 
          455,  524,  455,  524,  455,    0,  524,  524,  524,  524, 
          524,  524,  526,    0,    0,  524,  455,  524,  524,    0, 
          524,  524,  526,    0,    0,    0,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,    0,  343,  344, 
            0,    0,  345,  346,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  526,  347,    0,  348, 
            0,  349,  350,  351,  352,  353,  354,  355,    0,  356, 
          526,  526,    0,   98,    0,  526,    0,    0,    0,  552, 
          553,    0,    0,  554,    0,    0,    0,  167,  168,    0, 
          169,  170,  171,  172,  173,  174,  175,    0,    0,  176, 
          177,    0,    0,  526,  178,  179,  180,  181,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,    0,  527,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,  527,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,  341,  342,    0,    0,    0,    0,  527, 
          345,  346,    0,    0,    0,    0,    0,  150,    0,  150, 
          150,  150,  150,  527,  527,  347,  100,  348,  527,  349, 
          350,  351,  352,  353,  354,  355,    0,  356,    0,  462, 
            0,    0,    0,    0,    0,    0,  462,    0,    0,    0, 
          150,  150,    0,    0,    0,    0,  527,    0,  150,  150, 
          150,  150,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  151,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  526, 
          526,  526,    0,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  151,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
            0,  526,    0,    0,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,    0,    0,  526,  526,  526,  526,    0, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,    0,  526,  526,  526,  526, 
          526,  526,    0,    0,  152,  526,  526,  526,  526,    0, 
          526,  526,  527,  527,  527,    0,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,    0,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  152,  527,    0,    0,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,    0,    0,  527,  527, 
          527,  527,    0,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,    0,  527, 
          527,  527,  527,  527,  527,  530,    0,    0,  527,  527, 
          527,  527,    0,  527,  527,  530,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  151,    0, 
          151,  151,  151,  151,    0,    0,    0,    0,    0,  530, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          461,    0,    0,  530,  530,    0,   99,  461,  530,    0, 
            0,  151,  151,    0,    0,    0,    0,    0,    0,  151, 
          151,  151,  151,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  530,    0,  558,  559, 
            0,    0,  560,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,  273,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,  273,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,    0,  332,  333,  334, 
          335,  336,  337,  338,  339,    0,  341,  342,    0,    0, 
            0,    0,  273,  345,  346,    0,    0,    0,    0,    0, 
          152,    0,  152,  152,  152,  152,  273,  273,  347,    0, 
          348,  273,  349,  350,  351,  352,  353,  354,  355,    0, 
          356,    0,  463,    0,    0,    0,    0,    0,    0,  463, 
            0,    0,    0,  152,  152,    0,    0,    0,    0,  273, 
            0,  152,  152,  152,  152,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  526,  526,  526,    0,  526,  530,  530,  530, 
          526,  526,  530,  530,  530,  526,  530,  526,  526,  526, 
          526,  526,  526,  526,    0,  530,  530,  530,  526,  526, 
          526,  526,  526,  526,  526,  530,  530,  526,  530,  530, 
          530,  530,  530,  268,  526,    0,    0,  526,  526,  526, 
          530,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  530,  530,  530,  530,  530,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,    0,    0,  530,  530, 
          530,  526,    0,  530,  526,  526,  530,  526,  526,  530, 
          526,  530,  526,  530,  526,  530,  526,  530,  530,  530, 
          530,  530,  530,  530,  526,  530,  530,  530,    0,  526, 
          526,  526,  526,  526,  526,    0,    0,  109,  526,  530, 
          526,  526,    0,  526,  526,  525,  525,  525,    0,  525, 
          273,  273,  273,  525,  525,  273,  273,  273,  525,  273, 
          525,  525,  525,  525,  525,  525,  525,    0,  525,  273, 
          273,  525,  525,  525,  525,  525,  525,  525,  273,  273, 
          525,  273,  273,  273,  273,  273,  109,  525,    0,    0, 
          525,  525,  525,  273,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  273,  273,  273,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,    0, 
            0,  273,  273,  273,  525,    0,  273,  525,  525,  273, 
          525,  525,  273,  525,  273,  525,  273,  525,  273,  525, 
          273,  273,  273,  273,  273,  273,  273,  525,  273,  525, 
          273,    0,  525,  525,  525,  525,  525,  525,  531,    0, 
            0,  525,  273,  525,  525,    0,  525,  525,  531,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  531,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,  531,  531,    9,   10, 
            0,  531,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,   20,   21,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,  531, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  247,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  532,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,  532,  113,    0,    0,   46,   47,    0,   48,    0, 
          248,    0,  249,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,  532,   58,    0,   59,   60, 
            0,   61,   62,  109,    0,  109,  109,  109,  109,  532, 
          532,    0,    0,    0,  532,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  452,    0,    0,    0,    0, 
            0,    0,  452,    0,    0,    0,  109,  109,    0,    0, 
            0,    0,  532,    0,  109,  109,  109,  109,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  528,  528,  528,    0,  528, 
          531,  531,  531,  528,  528,  531,  531,  531,  528,  531, 
          528,  528,  528,  528,  528,  528,  528,  110,  531,  531, 
          531,  528,  528,  528,  528,  528,  528,  528,  531,  531, 
          528,  531,  531,  531,  531,  531,    0,  528,    0,    0, 
          528,  528,  528,  531,  528,  528,  528,  528,  528,  528, 
          528,  528,  528,  528,  528,  531,  531,  531,  531,  531, 
          531,  531,  531,  531,  531,  531,  531,  531,  531,    0, 
            0,  531,  531,  531,  528,    0,  531,  528,  528,  531, 
          528,  528,  531,  528,  531,  528,  531,  528,  531,  528, 
          531,  531,  531,  531,  531,  531,  531,  528,  531,  531, 
          531,    0,  528,  528,  528,  528,  528,  528,    0,    0, 
            0,  528,  531,  528,  528,  357,  528,  528,  529,  529, 
          529,    0,  529,  532,  532,  532,  529,  529,  532,  532, 
          532,  529,  532,  529,  529,  529,  529,  529,  529,  529, 
            0,  532,  532,  532,  529,  529,  529,  529,  529,  529, 
          529,  532,  532,  529,  532,  532,  532,  532,  532,    0, 
          529,    0,    0,  529,  529,  529,  532,  529,  529,  529, 
          529,  529,  529,  529,  529,  529,  529,  529,  532,  532, 
          532,  532,  532,  532,  532,  532,  532,  532,  532,  532, 
          532,  532,    0,    0,  532,  532,  532,  529,    0,  532, 
          529,  529,  532,  529,  529,  532,  529,  532,  529,  532, 
          529,  532,  529,  532,  532,  532,  532,  532,  532,  532, 
          529,  532,  532,  532,    0,  529,  529,  529,  529,  529, 
          529,  278,    0,    0,  529,  532,  529,  529,    0,  529, 
          529,  278,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  110,    0,  110,  110,  110,  110, 
            0,    0,    0,    0,    0,  278,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  455,    0,    0,  278, 
          278,    0,  101,  455,  278,    0,    0,  110,  110,    0, 
            0,    0,    0,    0,    0,  110,  110,  110,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  278,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  717, 
            0,    0,    0,    0,  391,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  391,    0,    0,    0,    0,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
            0,  343,  344,    0,    0,  345,  346,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  391,    0, 
          347,    0,  348,    0,  349,  350,  351,  352,  353,  354, 
          355,    0,  356,  391,  566,  553,    0,  391,  567,    0, 
            0,    0,  167,  168,    0,  169,  170,  171,  172,  173, 
          174,  175,    0,    0,  176,  177,    0,    0,    0,  178, 
          179,  180,  181,    0,    0,  391,    0,    0,  264,    0, 
            0,    0,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  527,  527, 
          527,    0,  527,  278,  278,  278,  527,  527,  278,  278, 
          278,  527,  278,  527,  527,  527,  527,  527,  527,  527, 
            0,    0,  278,  278,  527,  527,  527,  527,  527,  527, 
          527,  278,  278,  527,  278,  278,  278,  278,  278,  268, 
          527,    0,    0,  527,  527,  527,  278,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  278,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,    0,    0,  278,  278,  278,  527,    0,  278, 
          527,  527,  278,  527,  527,  278,  527,  278,  527,  278, 
          527,  278,  527,  278,  278,  278,  278,  278,  278,  278, 
          527,  278,    0,  278,    0,  527,  527,  527,  527,  527, 
          527,    0,    0,    0,  527,  278,  527,  527,    0,  527, 
          527,  252,  252,  252,    0,  252,  391,  391,  391,  252, 
          252,  391,  391,  391,  252,  391,  252,  252,  252,  252, 
          252,  252,  252,    0,  391,  391,  391,  252,  252,  252, 
          252,  252,  252,  252,  391,  391,  252,  391,  391,  391, 
          391,  391,    0,  252,    0,    0,  252,  252,  252,  357, 
          252,  252,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,  391,  391,  391,  391,  391,  391,  391,  391,  391, 
          391,  391,  391,  391,  391,    0,    0,  391,  391,  391, 
          252,    0,  391,  252,    0,  391,  252,  252,  391,  252, 
          391,  252,  391,  252,  391,  252,  391,  391,  391,  391, 
          391,  391,  391,  252,  391,  391, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          391,    0,  252,  252,  252,  252,  252,  252,  548,    0, 
            0,  252,    0,  252,  252,    0,  252,  252,  548,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  548,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,  548,    9,   10, 
            0,  548,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,  548, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  285,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,  285,  113,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,  285,   58,  723,   59,   60, 
            0,   61,   62,    0,    0,    0,    0,    0,    0,    0, 
          285,    0,    0,    0,  285,    0,    0,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,    0,  343, 
          344,    0,    0,  345,  346,    0,    0,    0,    0,    0, 
            0,    0,  285,    0,    0,    0,    0,    0,  347,    0, 
          348,    0,  349,  350,  351,  352,  353,  354,  355,    0, 
          356,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,    0,    0,    0,    0,  252,  252,  252,    0,  252, 
          548,  548,  548,  252,  252,  548,  548,  548,  252,  548, 
          252,  252,  252,  252,  252,  252,  252,    0,  548,  548, 
          548,  252,  252,  252,  252,  252,  252,  252,  548,  548, 
          252,  548,  548,  548,  548,  548,    0,  252,  256,  357, 
          252,  252,  252,    0,  252,  252,  252,  252,  252,  252, 
          252,  252,  252,  252,  252,  548,  548,  548,  548,  548, 
          548,  548,  548,  548,  548,  548,  548,  548,  548,    0, 
            0,  548,  548,  548,  252,    0,  548,  252,    0,  548, 
          252,  252,  548,  252,  548,  252,  548,  252,  548,  252, 
          548,  548,  548,  548,  548,  548,  548,  252,  548,  548, 
          548,    0,  252,  252,  252,  252,  252,  252,    0,    0, 
            0,  252,    0,  252,  252,    0,  252,  252,  252,  252, 
          252,    0,  252,  285,  285,  285,  252,  252,  285,  285, 
          285,  252,  285,  252,  252,  252,  252,  252,  252,  252, 
            0,    0,  285,  285,  252,  252,  252,  252,  252,  252, 
          252,  285,  285,  252,  285,  285,  285,  285,  285,    0, 
          252,    0,    0,  252,  252,  252,    0,  252,  252,  252, 
          252,  252,  252,  252,  252,  252,  252,  252,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,  285,  285,  285, 
          285,  285,    0,    0,  285,  285,  285,  252,    0,  285, 
          252,    0,  285,  252,  252,  285,  252,  285,  252,  285, 
          252,  285,  252,  285,  285,  285,  285,  285,  285,  285, 
          252,  285,  526,  285,    0,  252,  252,  252,  252,  252, 
          252,    0,  526,    0,  252,    0,  252,  252,    0,  252, 
          252,  256,  256,  256,    0,    0,  256,  256,  256,    0, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,  256,    0,    0,    0,    0,   90,    0,    0,  256, 
          256,    0,  256,  256,  256,  256,  256,    0,    0,    0, 
            0,  526,    0,   98,    0,  526,    0,    0,    0,    0, 
            0,    0,    0,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,    0,  343,  344,    0,    0,  345, 
          346,    0,    0,  526,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,  256,  347,  256,  348,    0,  349,  350, 
          351,  352,  353,  354,  355,    0,  356,    0,    0,    0, 
            0,  256,    0,    0,    0,  527,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  527,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  595,  559,    0,    0,  596,    0,    0,    0,  167, 
          168,    0,  169,  170,  171,  172,  173,  174,  175,   92, 
            0,  176,  177,    0,    0,    0,  178,  179,  180,  181, 
            0,    0,    0,    0,  527,  264,  100,    0,  527,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  194,  195,    0,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,  527,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   22,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   22,  526, 
          526,  526,    0,  526,  526,  526,  526,  526,  526,    0, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,    0,  526,    0,    0,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
            0,  526,    0,    0,  526,  526,  526,   22,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,    0,    0,  526,  526,  526,  526,    0, 
            0,  526,  526,  526,  526,  526,    0,  526,    0,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,    0,  526,  526,  526,  526, 
          526,  526,    0,    0,    0,  526,    0,  526,  526,    0, 
          526,  526,  527,  527,  527,    0,  527,  527,  527,  527, 
          527,  527,    0,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,    0,  527,    0,    0,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,    0,  527,    0,    0,  527,  527,  527, 
            0,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,    0,    0,  527,  527, 
          527,  527,    0,    0,  527,  527,  527,  527,  527,    0, 
          527,    0,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,    0,  527, 
          527,  527,  527,  527,  527,  530,    0,    0,  527,    0, 
          527,  527,    0,  527,  527,  530,    0,    0,    0,    0, 
           22,   22,   22,    0,    0,    0,   22,   22,    0,   22, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   91, 
            0,   22,   22,   22,   22,   22,    0,    0,    0,    0, 
            0,    0,    0,    0,  530,    0,   99,    0,  530,  332, 
          333,  334,  335,  336,  337,  338,    0,    0,  341,  342, 
            0,    0,    0,    0,    0,  345,  346,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  530,    0,    0,   22, 
          347,    0,  348,    0,  349,  350,  351,  352,  353,  354, 
          355,    0,  356,    0,    4,    5,    6,    0,    8,    0, 
           22,    0,    9,   10,    0,    0,    0,   11,  278,   12, 
           13,   14,  101,  102,   17,   18,    0,    0,  278,    0, 
          103,  104,  105,   22,   23,   24,   25,    0,    0,  106, 
            0,    0,    0,    0,    0,    0,  107,    0,    0,   31, 
           32,   33,    0,  108,   35,   36,   37,  109,   39,    0, 
           40,    0,   93,  110,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  278,    0,  101, 
          111,  278,    0,  112,    0,    0,  113,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  278, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  548,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  548,  526,  526,  526,    0,  526,  530,  530,  530, 
          526,  526,    0,  530,  530,  526,  530,  526,  526,  526, 
          526,  526,  526,  526,    0,  530,    0,    0,  526,  526, 
          526,  526,  526,  526,  526,  530,  530,  526,  530,  530, 
          530,  530,  530,    0,  526,    0,    0,  526,  526,  526, 
          548,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  530,  530,  530,  530,  530,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,    0,    0,  530,  530, 
          530,  526,    0,    0,  526,  526,  530,  526,  526,    0, 
          526,    0,  526,  530,  526,  530,  526,  530,  530,  530, 
          530,  530,  530,  530,  526,  530,  530,  530,    0,  526, 
          526,  526,  526,  526,  526,    0,    0,    0,  526,    0, 
          526,  526,    0,  526,  526,  527,  527,  527,    0,  527, 
          278,  278,  278,  527,  527,    0,  278,  278,  527,  278, 
          527,  527,  527,  527,  527,  527,  527,    0,    0,    0, 
            0,  527,  527,  527,  527,  527,  527,  527,  278,  278, 
          527,  278,  278,  278,  278,  278,    0,  527,    0,    0, 
          527,  527,  527,  295,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,    0, 
            0,  278,  278,  278,  527,    0,    0,  527,  527,  278, 
          527,  527,    0,  527,    0,  527,  278,  527,  278,  527, 
          278,  278,  278,  278,  278,  278,  278,  527,  278,    0, 
          278,    0,  527,  527,  527,  527,  527,  527,    0,    0, 
            0,  527,    0,  527,  527,    0,  527,  527,  252,  252, 
          252,    0,  252,  548,  548,  548,  252,  252,  548,  548, 
          548,  252,  548,  252,  252,  252,  252,  252,  252,  252, 
            0,    0,  548,    0,  252,  252,  252,  252,  252,  252, 
          252,  548,  548,  252,  548,  548,  548,  548,  548,    0, 
          252,    0,    0,  252,  252,  252,    0,  252,  252,  252, 
          252,  252,  252,  252,  252,  252,  252,  252,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  392,  548, 
            0,    0,    0,    0,    0,    0,  548,  252,  392,    0, 
          252,    0,  548,  252,  252,    0,  252,    0,  252,    0, 
          252,    0,  252,    0,    0,    0,    0,    0,    0,    0, 
          252,    0,    0,  548,    0,  252,  252,  252,  252,  252, 
          252,    0,  392,    0,  252,    0,  252,  252,    0,  252, 
          252,    0,    0,    0,    0,    0,  392,  392,    0,   97, 
            0,  392,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  101,  102,   17,   18,    0,  392, 
            0,    0,  103,  104,  105,   22,   23,   24,   25,  391, 
            0,  106,    0,    0,    0,    0,    0,    0,  107,  391, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,    0,  110,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  391,    0,  294,    0,    0,  113,    0, 
            0,   46,   47,    0,   48,    0,    0,  391,  391,    0, 
            0,    0,  391,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    0, 
          391,  617,  553,    0,    0,  618,    0,    0,    0,  167, 
          168,    0,  169,  170,  171,  172,  173,  174,  175,    0, 
            0,  176,  177,  464,    0,    0,  178,  179,  180,  181, 
            0,    0,    0,  464,    0,  264,    0,    0,    0,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  194,  195,    0,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,  464,    0,    0, 
          392,  392,  392,    0,    0,  392,  392,  392,    0,  392, 
            0,  464,  464,    0,   96,    0,  464,    0,  392,  392, 
          392,    0,    0,    0,    0,    0,    0,    0,  392,  392, 
            0,  392,  392,  392,  392,  392,    0,    0,    0,    0, 
            0,    0,    0,  392,  464,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  392,  392,  392,  392,  392, 
          392,  392,  392,  392,  392,  392,  392,  392,  392,    0, 
            0,  392,  392,  392,    0,    0,  392,    0,    0,  392, 
            0,    0,  392,    0,  392,    0,  392,  548,  392,    0, 
          392,  392,  392,  392,  392,  392,  392,  548,  392,  392, 
          392,  391,  391,  391,    0,    0,  391,  391,  391,    0, 
          391,    0,  392,    0,    0,    0,    0,    0,    0,  391, 
          391,  391,    0,    0,    0,    0,    0,    0,    0,  391, 
          391,  548,  391,  391,  391,  391,  391,    0,    0,    0, 
            0,    0,    0,    0,  391,  548,  548,    0,    0,    0, 
          548,    0,    0,    0,    0,    0,  391,  391,  391,  391, 
          391,  391,  391,  391,  391,  391,  391,  391,  391,  391, 
            0,    0,  391,  391,  391,    0,    0,  391,  548,    0, 
          391,    0,    0,  391,    0,  391,    0,  391,    0,  391, 
            0,  391,  391,  391,  391,  391,  391,  391,    0,  391, 
          391,  391,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  391,    0,  464,  464,  464,    0,    0, 
          464,  464,  464,    0,  464,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  464,  464,    0,    0,    0,    0, 
            0,    0,    0,  464,  464,    0,  464,  464,  464,  464, 
          464,    0,    0,    0,    0,    0,    0,    0,  464,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          464,  464,  464,  464,  464,  464,  464,  464,  464,  464, 
          464,  464,  464,  464,    0,  272,  464,  464,  464,    0, 
          465,  464,    0,    0,  464,  272,    0,  464,    0,  464, 
            0,  464,    0,  464,    0,  464,  464,  464,  464,  464, 
          464,  464,    0,  464,    0,  464,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  464,    0,  272, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  272,  272,    0,  103,    0,  272,  548, 
          548,  548,    0,    0,  548,  548,  548,    0,  548,    0, 
            0,    0,    0,    0,    0,    0,    0,  548,  548,  548, 
            0,    0,    0,    0,    0,    0,  272,  548,  548,    0, 
          548,  548,  548,  548,  548,    0,    0,    0,    0,    0, 
            0,    0,  548,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  548,  548,  548,  548,  548,  548, 
          548,  548,  548,  548,  548,  548,  548,  548,    0,  279, 
          548,  548,  548,    0,    0,  548,    0,    0,  548,  279, 
            0,  548,    0,  548,    0,  548,    0,  548,    0,  548, 
          548,  548,  548,  548,  548,  548,    0,  548,  548,  548, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  548,    0,  279,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  619,  559,  279,  279,  620, 
          102,    0,  279,  167,  168,    0,  169,  170,  171,  172, 
          173,  174,  175,    0,    0,  176,  177,    0,    0,    0, 
          178,  179,  180,  181,    0,    0,    0,    0,    0,  264, 
          279,    0,    0,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
            0,    0,  196,  412,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  412,    0,    0,    0,  272,  272,  272, 
            0,    0,  272,  272,  272,    0,  272,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  272,  272,    0,    0, 
            0,    0,    0,    0,    0,  272,  272,  412,  272,  272, 
          272,  272,  272,    0,    0,    0,    0,    0,    0,    0, 
          272,  412,  412,    0,    0,    0,  412,    0,    0,    0, 
            0,    0,  272,  272,  272,  272,  272,  272,  272,  272, 
          272,  272,  272,  272,  272,  272,    0,    0,  272,  272, 
          272,    0,    0,  272,  412,    0,  272,    0,    0,  272, 
            0,  272,    0,  272,  290,  272,    0,  272,  272,  272, 
          272,  272,  272,  272,  290,  272,    0,  272,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  272, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  290,    0, 
            0,  279,  279,  279,    0,    0,  279,  279,  279,    0, 
          279,    0,  290,  290,    0,    0,    0,  290,    0,    0, 
          279,  279,    0,    0,    0,    0,    0,    0,    0,  279, 
          279,    0,  279,  279,  279,  279,  279,    0,    0,    0, 
            0,    0,    0,    0,  279,  290,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
            0,    0,  279,  279,  279,    0,    0,  279,    0,    0, 
          279,    0,    0,  279,    0,  279,    0,  279,    0,  279, 
            0,  279,  279,  279,  279,  279,  279,  279,  236,  279, 
            0,  279,    0,    0,    0,    0,    0,    0,  236,    0, 
            0,    0,    0,  279,    0,  412,  412,  412,    0,    0, 
          412,  412,  412,    0,  412,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  412,  412,    0,    0,    0,    0, 
            0,    0,  236,  412,  412,    0,  412,  412,  412,  412, 
          412,    0,    0,    0,    0,    0,  236,  236,  412,    0, 
            0,  236,    0,    0,    0,    0,    0,    0,    0,    0, 
          412,  412,  412,  412,  412,  412,  412,  412,  412,  412, 
          412,  412,  412,  412,    0,    0,  412,  412,  412,  322, 
            0,  412,    0,    0,  412,    0,    0,  412,    0,  412, 
            0,  412,  285,  412,    0,  412,  412,  412,  412,  412, 
          412,  412,  285,  412,    0,  412,  290,  290,  290,    0, 
            0,  290,  290,  290,    0,  290,    0,  412,    0,    0, 
            0,    0,    0,    0,    0,  290,  290,    0,    0,    0, 
            0,    0,    0,    0,  290,  290,  285,  290,  290,  290, 
          290,  290,    0,    0,    0,    0,    0,    0,    0,  290, 
          285,  285,    0,    0,    0,  285,    0,    0,    0,    0, 
            0,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,    0,    0,  290,  290,  290, 
            0,    0,  290,  285,    0,  290,    0,    0,  290,    0, 
          290,    0,  290,    0,  290,    0,  290,  290,  290,  290, 
          290,  290,  290,    0,  290,  450,  290,    0,    0,    0, 
            0,    0,    0,    0,    0,  450,    0,    0,  290,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  450, 
          236,  236,  236,    0,    0,  236,  236,  236,    0,  236, 
            0,    0,    0,  450,  450,    0,    0,    0,  450,  236, 
          236,    0,    0,    0,    0,    0,    0,    0,  236,  236, 
            0,  236,  236,  236,  236,  236,    0,    0,    0,    0, 
            0,    0,    0,  236,    0,    0,  450,    0,    0,    0, 
            0,    0,    0,    0,    0,  236,  236,  236,  236,  236, 
          236,  236,  236,  236,  236,  236,  322,  236,  236,    0, 
            0,  236,  236,  322,    0,    0,  236,    0,    0,  236, 
            0,    0,  236,    0,  236,    0,  236,  451,  236,    0, 
          236,  236,  236,  236,  236,  236,  236,  451,  236,    0, 
          236,    0,    0,    0,  285,  285,  285,    0,    0,  285, 
          285,  285,  236,  285,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  285,  285,    0,    0,    0,    0,    0, 
            0,  451,  285,  285,    0,  285,  285,  285,  285,  285, 
            0,    0,    0,    0,    0,  451,  451,  285,    0,    0, 
          451,    0,    0,    0,    0,    0,    0,    0,    0,  285, 
          285,  285,  285,  285,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,    0,    0,  285,  285,  285,  451,    0, 
          285,    0,    0,  285,    0,    0,  285,    0,  285,    0, 
          285,    0,  285,    0,  285,  285,  285,  285,  285,  285, 
          285,    0,  285,  214,  285,    0,    0,    0,    0,    0, 
            0,    0,    0,  214,    0,    0,  285,  450,  450,  450, 
            0,    0,  450,  450,  450,    0,  450,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  450,  450,    0,    0, 
            0,    0,    0,    0,    0,  450,  450,  214,  450,  450, 
          450,  450,  450,    0,    0,    0,    0,    0,    0,    0, 
          450,  214,  214,    0,    0,    0,  214,    0,    0,    0, 
            0,    0,    0,  450,  450,  450,  450,  450,  450,  450, 
          450,  450,  450,  450,  450,  450,    0,    0,  450,  450, 
          450,    0,    0,  450,    0,    0,  450,    0,    0,  450, 
            0,  450,    0,  450,  210,  450,    0,  450,  450,  450, 
          450,  450,  450,  450,  210,  450,    0,  450,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  450, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  210,  451, 
          451,  451,    0,    0,  451,  451,  451,    0,  451,    0, 
            0,    0,  210,  210,    0,    0,    0,  210,  451,  451, 
            0,    0,    0,    0,    0,    0,    0,  451,  451,    0, 
          451,  451,  451,  451,  451,    0,    0,    0,    0,    0, 
            0,    0,  451,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  451,  451,  451,  451,  451, 
          451,  451,  451,  451,  451,  451,  451,  451,    0,  207, 
          451,  451,  451,    0,    0,  451,    0,    0,  451,  207, 
            0,  451,    0,  451,    0,  451,    0,  451,    0,  451, 
          451,  451,  451,  451,  451,  451,    0,  451,    0,  451, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  451,    0,  207,    0,  214,  214,  214,    0,    0, 
          214,  214,  214,    0,  214,    0,    0,  207,  207,    0, 
            0,    0,  207,    0,  214,  214,    0,    0,    0,    0, 
            0,    0,    0,  214,  214,    0,  214,  214,  214,  214, 
          214,    0,    0,    0,    0,    0,    0,    0,  214,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  214,  214,  214,  214,  214,  214,  214,  214,  214, 
          214,    0,  214,  214,    0,    0,  214,  214,    0,    0, 
            0,  214,    0,    0,  214,    0,    0,  214,    0,  214, 
            0,  214,  209,  214,    0,  214,  214,  214,  214,  214, 
          214,  214,  209,  214,    0,  214,  210,  210,  210,    0, 
            0,  210,  210,  210,    0,  210,    0,  214,    0,    0, 
            0,    0,    0,    0,    0,  210,  210,    0,    0,    0, 
            0,    0,    0,    0,  210,  210,  209,  210,  210,  210, 
          210,  210,    0,    0,    0,    0,    0,    0,    0,  210, 
          209,  209,    0,    0,    0,  209,    0,    0,    0,    0, 
            0,    0,  210,  210,  210,  210,  210,  210,  210,  210, 
          210,  210,    0,  210,  210,    0,    0,  210,  210,    0, 
            0,    0,  210,    0,    0,  210,    0,    0,  210,    0, 
          210,    0,  210,    0,  210,    0,  210,  210,  210,  210, 
          210,  210,  210,    0,  210,    0,  210,  208,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,  210,    0, 
            0,  207,  207,  207,    0,    0,  207,  207,  207,    0, 
          207,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          207,  207,    0,    0,    0,    0,    0,    0,    0,  207, 
          207,  208,  207,  207,  207,  207,  207,    0,    0,    0, 
            0,    0,    0,    0,  207,  208,  208,    0,    0,    0, 
          208,    0,    0,    0,    0,    0,    0,  207,  207,  207, 
          207,  207,  207,  207,  207,  207,  207,    0,  207,  207, 
            0,    0,  207,  207,    0,    0,    0,  207,    0,    0, 
          207,    0,    0,  207,    0,  207,    0,  207,  211,  207, 
            0,  207,  207,  207,  207,  207,  207,  207,  211,  207, 
            0,  207,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  211,    0,  209,  209,  209,    0,    0,  209, 
          209,  209,    0,  209,    0,    0,  211,  211,    0,    0, 
            0,  211,    0,  209,  209,    0,    0,    0,    0,    0, 
            0,    0,  209,  209,    0,  209,  209,  209,  209,  209, 
            0,    0,    0,    0,    0,    0,    0,  209,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          209,  209,  209,  209,  209,  209,  209,  209,  209,  209, 
            0,  209,  209,    0,  212,  209,  209,    0,    0,    0, 
          209,    0,    0,  209,  212,    0,  209,    0,  209,    0, 
          209,    0,  209,    0,  209,  209,  209,  209,  209,  209, 
          209,    0,  209,    0,  209,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  209,    0,  212,  208, 
          208,  208,    0,    0,  208,  208,  208,    0,  208,    0, 
            0,    0,  212,  212,    0,    0,    0,  212,  208,  208, 
            0,    0,    0,    0,    0,    0,    0,  208,  208,    0, 
          208,  208,  208,  208,  208,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  208,  208,  208,  208,  208, 
          208,  208,  208,  208,  208,    0,  208,  208,    0,    0, 
          208,  208,    0,    0,    0,  208,    0,    0,  208,    0, 
            0,  208,    0,  208,    0,  208,  205,  208,    0,  208, 
          208,  208,  208,  208,  208,  208,  205,  208,    0,  208, 
          211,  211,  211,    0,    0,  211,  211,  211,    0,  211, 
            0,  208,    0,    0,    0,    0,    0,    0,    0,  211, 
          211,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
          205,  211,  211,  211,  211,  211,    0,    0,    0,    0, 
            0,    0,    0,  211,  205,  205,    0,    0,    0,  205, 
            0,    0,    0,    0,    0,    0,  211,  211,  211,  211, 
          211,  211,  211,  211,  211,  211,    0,  211,  211,    0, 
            0,  211,  211,    0,    0,    0,  211,    0,    0,  211, 
            0,    0,  211,    0,  211,    0,  211,    0,  211,    0, 
          211,  211,  211,  211,  211,  211,  211,    0,  211,  206, 
          211,    0,    0,    0,    0,    0,    0,    0,    0,  206, 
            0,    0,  211,    0,    0,    0,  212,  212,  212,    0, 
            0,  212,  212,  212,    0,  212,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  212,  212,    0,    0,    0, 
            0,    0,    0,  206,  212,  212,    0,  212,  212,  212, 
          212,  212,    0,    0,    0,    0,    0,  206,  206,  212, 
            0,    0,  206,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  212,  212,  212,  212,  212,  212,  212,  212, 
          212,  212,    0,  212,  212,    0,    0,  212,  212,    0, 
            0,    0,  212,    0,    0,  212,    0,    0,  212,    0, 
          212,    0,  212,  230,  212,    0,  212,  212,  212,  212, 
          212,  212,  212,  230,  212,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  212,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,  205,  205, 
          205,    0,    0,  205,  205,  205,    0,  205,    0,    0, 
            0,  230,  230,    0,    0,    0,  230,  205,  205,    0, 
            0,    0,    0,    0,    0,    0,  205,  205,    0,  205, 
          205,  205,  205,  205,    0,    0,    0,    0,    0,    0, 
            0,  205,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  205,  205,  205,  205,  205,  205, 
          205,  205,  205,  205,    0,  205,  205,    0,    0,  205, 
          205,    0,    0,    0,  205,  231,    0,  205,    0,    0, 
          205,    0,  205,    0,    0,  231,  205,    0,    0,    0, 
          205,  205,  205,  205,  205,    0,  205,    0,  205,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          205,  206,  206,  206,    0,    0,  206,  206,  206,  231, 
          206,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          206,  206,    0,  231,  231,    0,    0,    0,  231,  206, 
          206,    0,  206,  206,  206,  206,  206,    0,    0,    0, 
            0,    0,    0,    0,  206,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  206,  206,  206, 
          206,  206,  206,  206,  206,  206,  206,    0,  206,  206, 
            0,    0,  206,  206,    0,    0,    0,  206,    0,    0, 
          206,    0,    0,  206,    0,  206,    0,    0,  217,  206, 
            0,    0,    0,  206,  206,  206,  206,  206,  217,  206, 
            0,  206,    0,    0,    0,  230,  230,  230,    0,    0, 
          230,  230,  230,  206,  230,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  230,  230,    0,    0,    0,    0, 
            0,    0,  217,  230,  230,    0,  230,  230,  230,  230, 
          230,    0,    0,    0,    0,    0,  217,  217,  230,    0, 
            0,  217,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  230,  230,  230,  230,  230,  230,  230,  230,  230, 
          230,    0,  230,  230,    0,    0,  230,  230,    0,    0, 
            0,  230,    0,    0,  230,    0,    0,  230,    0,  230, 
            0,    0,    0,  230,    0,    0,    0,    0,    0,  230, 
          230,  230,    0,  230,    0,  230,  215,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  215,  230,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  231,  231,  231, 
            0,    0,  231,  231,  231,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  231,  231,    0,    0, 
          215,    0,    0,    0,    0,  231,  231,    0,  231,  231, 
          231,  231,  231,    0,  215,  215,    0,    0,    0,  215, 
          231,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,  231,  231,  231,  231,  231,  231, 
          231,  231,  231,    0,  231,  231,    0,    0,  231,  231, 
            0,    0,    0,  231,    0,    0,  231,    0,    0,  231, 
            0,  231,    0,    0,  216,  231,    0,    0,    0,    0, 
            0,  231,  231,  231,  216,  231,    0,  231,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  231, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,  217,  217,    0,    0,  217,  217,  217,  216,  217, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
          217,    0,  216,  216,    0,    0,    0,  216,  217,  217, 
            0,  217,  217,  217,  217,  217,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  217,  217,  217,  217, 
          217,  217,  217,  217,  217,  217,    0,  217,  217,    0, 
            0,    0,    0,  220,    0,    0,  217,    0,    0,  217, 
            0,    0,  217,  220,  217,    0,    0,    0,  217,    0, 
            0,    0,    0,    0,  217,  217,  217,    0,  217,    0, 
          217,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,    0,    0,  220,  215,  215, 
          215,    0,    0,  215,  215,  215,    0,  215,    0,    0, 
            0,  220,  220,    0,    0,    0,  220,  215,  215,    0, 
            0,    0,    0,    0,    0,    0,  215,  215,    0,  215, 
          215,  215,  215,  215,    0,    0,    0,    0,    0,    0, 
            0,  215,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  215,  215,  215,  215,  215,  215, 
          215,  215,  215,  215,    0,  215,  215,    0,    0,    0, 
            0,    0,    0,  222,  215,    0,    0,  215,    0,    0, 
          215,    0,  215,  222,    0,    0,    0,    0,    0,    0, 
            0,    0,  215,  215,  215,    0,  215,    0,  215,    0, 
            0,    0,    0,    0,    0,    0,  216,  216,  216,    0, 
          215,  216,  216,  216,    0,  216, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,  222,    0,    0,    0,    0,    0,    0,    0,  216, 
          216,    0,    0,    0,    0,  222,  222,    0,  216,  216, 
          222,  216,  216,  216,  216,  216,    0,    0,    0,    0, 
            0,    0,    0,  216,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  216,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,    0,  216,  216,    0, 
            0,    0,    0,    0,    0,    0,  216,    0,    0,  216, 
            0,    0,  216,    0,  216,    0,    0,  221,    0,    0, 
            0,    0,    0,    0,  216,  216,  216,  221,  216,    0, 
          216,    0,    0,    0,    0,    0,    0,    0,    0,  220, 
          220,  220,  216,    0,  220,  220,  220,    0,  220,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  220,  220, 
            0,  221,    0,    0,    0,    0,    0,  220,  220,    0, 
          220,  220,  220,  220,  220,  221,  221,    0,    0,    0, 
          221,    0,  220,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  220,  220,  220,  220,  220, 
          220,  220,  220,  220,  220,    0,  220,  220,    0,    0, 
            0,    0,    0,    0,  219,  220,    0,    0,  220,    0, 
            0,  220,    0,  220,  219,    0,    0,    0,    0,    0, 
            0,    0,    0,  220,  220,    0,    0,    0,    0,  220, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  220,    0,    0,    0,    0,    0,    0,  219,  222, 
          222,  222,    0,    0,  222,  222,  222,    0,  222,    0, 
            0,    0,  219,  219,    0,    0,    0,  219,  222,  222, 
            0,    0,    0,    0,    0,    0,    0,  222,  222,    0, 
          222,  222,  222,  222,  222,    0,    0,    0,    0,    0, 
            0,    0,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,  222,  222,  222,  222, 
          222,  222,  222,  222,  222,    0,  222,  222,    0,    0, 
            0,    0,  218,    0,    0,  222,    0,    0,  222,    0, 
            0,  222,  218,  222,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  222,  222,    0,    0,    0,    0,  222, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,    0,    0,  218,    0,    0,  221, 
          221,  221,    0,    0,  221,  221,  221,    0,  221,    0, 
          218,  218,    0,    0,    0,  218,    0,    0,  221,  221, 
            0,    0,    0,    0,    0,    0,    0,  221,  221,    0, 
          221,  221,  221,  221,  221,    0,    0,    0,    0,    0, 
            0,    0,  221,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  221,  221,  221,  221,  221, 
          221,  221,  221,  221,  221,    0,  221,  221,    0,    0, 
            0,    0,    0,    0,  223,  221,    0,    0,  221,    0, 
            0,  221,    0,  221,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,  221,  221,    0,  219,  219,  219,  221, 
            0,  219,  219,  219,    0,  219,    0,    0,    0,    0, 
            0,  221,    0,    0,    0,  219,  219,    0,  223,    0, 
            0,    0,    0,    0,  219,  219,    0,  219,  219,  219, 
          219,  219,  223,  223,    0,    0,    0,  223,    0,  219, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,  219,  219,  219,  219,  219,  219, 
          219,  219,    0,  219,  219,    0,    0,    0,    0,    0, 
            0,    0,  219,    0,    0,  219,    0,    0,  219,    0, 
          219,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          219,  219,  224,    0,    0,    0,  219,    0,    0,    0, 
            0,    0,  224,    0,    0,    0,    0,    0,  219,    0, 
            0,    0,    0,    0,  218,  218,  218,    0,    0,  218, 
          218,  218,    0,  218,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  218,  218,    0,  224,    0,    0,    0, 
            0,    0,  218,  218,    0,  218,  218,  218,  218,  218, 
          224,  224,    0,    0,    0,  224,    0,  218,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  218,  218,    0,    0, 
            0,  218,  218,    0,    0,    0,    0,    0,    0,  225, 
          218,    0,    0,  218,    0,    0,  218,    0,  218,  225, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  218,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,  223,  223,  223,    0, 
            0,  223,  223,  223,    0,  223,    0,  225,  225,    0, 
            0,    0,  225,    0,    0,  223,  223,    0,    0,    0, 
            0,    0,    0,    0,  223,  223,    0,  223,  223,  223, 
          223,  223,    0,    0,    0,  232,    0,    0,    0,  223, 
            0,    0,    0,    0,    0,  232,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,  223, 
            0,    0,    0,  223,  223,    0,    0,    0,    0,    0, 
            0,    0,  223,    0,    0,  223,    0,    0,  223,  232, 
          223,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  232,  232,    0,  223,    0,  232,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,    0, 
            0,    0,    0,    0,  224,  224,  224,    0,    0,  224, 
          224,  224,    0,  224,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,  224,  224,  226,    0,    0,    0,    0, 
            0,    0,  224,  224,    0,  224,  224,  224,  224,  224, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  226, 
            0,    0,    0,    0,    0,    0,  224,  224,    0,    0, 
            0,  224,  224,  226,  226,    0,    0,    0,  226,    0, 
          224,    0,    0,  224,    0,    0,  224,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  225,  225,  225,  224,    0,  225,  225,  225,    0, 
          225,    0,  227,    0,    0,    0,  224,    0,    0,    0, 
          225,  225,  227,    0,    0,    0,    0,    0,    0,  225, 
          225,    0,  225,  225,  225,  225,  225,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,    0,    0,    0, 
            0,    0,    0,  225,  225,    0,    0,    0,  225,  225, 
          227,  227,    0,    0,    0,  227,    0,  225,    0,    0, 
          225,    0,    0,  225,    0,  225,    0,  232,  232,  232, 
            0,    0,  232,  232,  232,    0,  232,    0,  233,    0, 
            0,  225,    0,    0,    0,    0,  232,  232,  233,    0, 
            0,    0,    0,  225,    0,  232,  232,    0,  232,  232, 
          232,  232,  232,    0,    0,    0,    0,    0,    0,    0, 
          232,    0,    0,    0,    0,    0,   38,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,   38,    0,    0,  232, 
          232,    0,    0,    0,  232,  232,  233,  233,    0,    0, 
            0,  233,    0,  232,    0,    0,  232,    0,    0,  232, 
            0,  232,    0,    0,    0,    0,    0,  226,  226,  226, 
          258,    0,  226,  226,  226,    0,  226,  232,  204,    0, 
            0,    0,    0,    0,    0,   38,  226,  226,  204,  232, 
            0,    0,    0,    0,    0,  226,  226,    0,  226,  226, 
          226,  226,  226,    0,    0,    0,    0,    0,    0,    0, 
          226,    0,    0,    0,    0,    0,    0,    0,  234,    0, 
            0,    0,  204,    0,    0,    0,    0,    0,  234,  226, 
          226,    0,    0,    0,  226,  226,  204,  204,    0,    0, 
            0,  204,    0,  226,    0,    0,  226,    0,    0,  226, 
            0,  226,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  234,    0,  227,  227,  227,  226,    0,  227, 
          227,  227,    0,  227,    0,    0,  234,  234,    0,  226, 
            0,    0,    0,  227,  227,    0,    0,    0,    0,    0, 
            0,    0,  227,  227,    0,  227,  227,  227,  227,  227, 
            0,    0,    0,  202,    0,    0,    0,  227,    0,    0, 
            0,    0,    0,  202,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,  227,    0,    0, 
            0,  227,  227,    0,    0,    0,    0,    0,    0,    0, 
          227,    0,    0,  227,    0,    0,  227,  202,  227,    0, 
          233,  233,  233,    0,    0,  233,  233,  233,    0,  233, 
            0,  202,  202,    0,  227,    0,    0,    0,    0,  233, 
          233,    0,    0,    0,    0,    0,  227,    0,  233,  233, 
            0,  233,  233,  233,  233,  233,    0,    0,   38,   38, 
           38,    0,    0,  233,   38,   38,    0,   38,    0,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  201, 
            0,    0,    0,  233,    0,    0,    0,  233,  233,   38, 
           38,   38,   38,   38,    0,    0,  233,    0,    0,  233, 
            0,    0,  233,    0,  233,    0,    0,    0,    0,    0, 
          204,  204,  204,  201,    0,  204,  204,  204,    0,  204, 
          233,    0,    0,    0,    0,    0,    0,  201,  201,  204, 
          204,    0,  233,    0,    0,    0,    0,   38,  204,  204, 
            0,  204,  204,  204,  204,  204,    0,    0,    0,    0, 
          234,  234,  234,  204,  197,  234,  234,  234,   38,  234, 
            0,    0,    0,    0,  197,    0,    0,    0,    0,  234, 
          234,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
            0,  234,  234,  234,  234,  234,  204,    0,    0,  204, 
            0,    0,  204,  234,  204,    0,    0,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          204,    0,  197,  197,    0,  198,    0,    0,    0,    0, 
            0,    0,  204,    0,    0,  198,  234,    0,    0,  234, 
            0,    0,  234,    0,  234,  202,  202,  202,    0,    0, 
          202,  202,  202,    0,  202,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,  202,  202,    0,    0,    0,  198, 
            0,    0,  234,  202,  202,    0,  202,  202,  202,  202, 
          202,    0,    0,  198,  198,    0,    0,    0,  202,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  202,  199,    0,  202,    0,    0,  202,    0,  202, 
            0,    0,  199,    0,    0,    0,    0,    0,    0,    0, 
            0,  201,  201,  201,    0,  202,  201,  201,  201,    0, 
          201,    0,    0,    0,    0,    0,    0,  202,    0,    0, 
          201,  201,    0,    0,    0,    0,  199,    0,    0,  201, 
          201,    0,  201,  201,  201,  201,  201,    0,    0,    0, 
          199,  199,    0,    0,  201,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,  201,  200,    0, 
          201,    0,    0,  201,    0,  201,  197,  197,  197,    0, 
            0,  197,  197,  197,    0,  197,    0,    0,    0,    0, 
            0,  201,    0,    0,    0,  197,  197,    0,    0,    0, 
            0,    0,  200,  201,  197,  197,    0,  197,  197,  197, 
          197,  197,    0,    0,    0,    0,  200,  200,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,  198,  198, 
            0,    0,  198,  198,  198,    0,  198,    0,    0,    0, 
            0,    0,  197,    0,    0,  197,  198,  198,  197,    0, 
          197,    0,    0,    0,    0,  198,  198,  193,  198,  198, 
          198,  198,  198,    0,    0,    0,  197,  193,    0,    0, 
          198,    0,    0,    0,    0,    0,    0,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  193,    0,  198,    0,    0,  198,    0,    0,  198, 
            0,  198,    0,    0,    0,  193,  193,    0,  195,    0, 
            0,    0,    0,    0,  199,  199,  199,  198,  195,  199, 
          199,  199,    0,  199,    0,    0,    0,    0,    0,  198, 
            0,    0,    0,  199,  199,    0,    0,    0,    0,    0, 
            0,    0,  199,  199,    0,  199,  199,  199,  199,  199, 
            0,    0,  195,    0,    0,    0,    0,  199,    0,    0, 
            0,    0,    0,    0,    0,    0,  195,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          199,    0,    0,  199,  235,    0,  199,    0,  199,    0, 
          200,  200,  200,    0,  235,  200,  200,  200,    0,  200, 
            0,    0,    0,    0,  199,    0,    0,    0,    0,  200, 
          200,    0,    0,    0,    0,    0,  199,    0,  200,  200, 
            0,  200,  200,  200,  200,  200,    0,    0,  235,    0, 
            0,    0,    0,  200,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,  235,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  200,    0,    0,  200, 
            0,    0,  200,    0,  200,    0,    0,    0,    0,    0, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  196,    0,    0,    0,    0,    0,    0,    0,  193, 
          193,  193,  200,    0,  193,  193,  193,    0,  193,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  193,  193, 
            0,    0,    0,    0,    0,  196,    0,  193,  193,    0, 
          193,  193,  193,  193,  193,    0,    0,    0,  263,  196, 
          196,    0,  193,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          195,  195,  195,    0,    0,  195,  195,  195,    0,  195, 
            0,    0,    0,    0,    0,  193,    0,    0,  193,  195, 
          195,  193,  261,  193,    0,    0,    0,    0,  195,  195, 
          237,  195,  195,  195,  195,  195,    0,  263,    0,  193, 
          237,    0,    0,  195,    0,    0,    0,    0,    0,    0, 
            0,  193,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  237,    0,  195,    0,    0,  195, 
            0,    0,  195,    0,  195,    0,  235,  235,  235,  237, 
            0,  235,  235,  235,    0,  235,    0,    0,    0,    0, 
          195,    0,    0,    0,    0,  235,  235,    0,    0,    0, 
            0,    0,  195,    0,  235,  235,  194,  235,  235,  235, 
          235,  235,    0,    0,    0,    0,  194,    0,    0,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  192,    0,    0,    0,    0,    0,    0,    0,    0, 
          194,  192,  235,    0,    0,  235,    0,    0,  235,    0, 
          235,    0,    0,    0,  194,  194,    0,    0,    0,    0, 
            0,    0,    0,  196,  196,  196,  235,    0,  196,  196, 
          196,    0,  196,    0,    0,  192,    0,    0,  235,    0, 
            0,    0,  196,  196,    0,    0,    0,    0,    0,  192, 
          192,  196,  196,    0,  196,  196,  196,  196,  196,    0, 
            0,    0,    0,    0,    0,    0,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          263,  263,  263,    0,    0,  263,  263,  263,    0,  263, 
            0,    0,    0,    0,    0,    0,  104,    0,    0,  196, 
            0,    0,  196,    0,    0,  196,    0,  196,    0,    0, 
            0,  263,  263,  263,  263,  263,    0,    0,    0,    0, 
            0,    0,    0,  196,    0,    0,    0,    0,    0,    0, 
            0,    0,  237,  237,  237,  196,    0,  237,  237,  237, 
            0,  237,    0,    0,    0,  104,    0,    0,    0,    0, 
            0,  237,  237,    0,    0,    0,  263,    0,    0,  263, 
          237,  237,    0,  237,  237,  237,  237,  237,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,  452,    0,    0, 
          263,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  237,    0, 
            0,  237,    0,    0,  237,    0,  237,    0,  194,  194, 
          194,    0,  105,  194,  194,  194,    0,  194,    0,    0, 
            0,    0,  237,    0,    0,    0,    0,  194,  194,    0, 
            0,    0,    0,    0,  237,    0,  194,  194,    0,  194, 
          194,  194,  194,  192,  192,  192,    0,    0,  192,  192, 
          192,  194,  192,    0,    0,    0,    0,    0,    0,    0, 
            0,  105,  192,  192,    0,    0,    0,    0,    0,    0, 
            0,  192,  192,    0,  192,  192,  192,  192,    0,    0, 
            0,    0,    0,    0,  194,    0,  192,  194,    0,    0, 
          194,    0,  194,  455,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  194,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  192, 
          194,    0,  192,    0,    0,  192,    0,  192,    0,    0, 
            0,    0,  104,  104,  104,  104,  104,  104,  104,  104, 
          104,  104,  104,  192,  104,  104,  104,    0,  104,  104, 
          104,  104,  104,  104,  104,  192,  523,    0,    0,  104, 
          104,  104,  104,  104,  104,  104,    0,    0,  104,    0, 
            0,    0,    0,    0,  104,  104,    0,  104,  104,  104, 
          104,    0,  104,  104,  104,  104,  104,  104,    0,  104, 
          104,  104,  104,  104,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  452,    0,    0,    0,    0,    0, 
            0,  452,  104,    0,    0,  104,  523,    0,  104,  104, 
            0,  104,    0,  104,    0,  530,    0,  104,    0,    0, 
            0,    0,  104,    0,    0,  104,    0,  523,    0,    0, 
          104,  104,  104,  104,  104,  104,    0,    0,    0,  104, 
            0,  104,  104,    0,  104,  104,    0,    0,  105,  105, 
          105,  105,  105,  105,  105,  105,  105,  105,  105,    0, 
          105,  105,  105,    0,  105,  105,  105,  105,  105,  105, 
          105,    0,  524,    0,    0,  105,  105,  105,  105,  105, 
          105,  105,    0,    0,  105,    0,    0,    0,    0,    0, 
          105,  105,    0,  105,  105,  105,  105,    0,  105,  105, 
          105,  105,  105,  105,    0,  105,  105,  105,  105,  105, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          455,    0,    0,    0,    0,    0,    0,  455,  105,    0, 
            0,  105,  524,    0,  105,  105,    0,  105,    0,  105, 
            0,  278,    0,  105,    0,    0,    0,    0,  105,    0, 
            0,  105,    0,  524,    0,    0,  105,  105,  105,  105, 
          105,  105,    0,    0,    0,  105,    0,  105,  105,    0, 
          105,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
          104,  104,  104,  104,  104,  104,  104,  104,  104,  104, 
          104,    0,  105,  104,  104,    0,  104,  104,  104,  104, 
          104,  104,  104,    0,  530,    0,    0,  104,  104,  104, 
          104,  104,  104,  104,    0,    0,  104,    0,    0,    0, 
            0,    0,  104,  104,    0,  104,  104,  104,  104,    0, 
          104,  104,  104,  104,  104,  104,    0,  104,  104,  104, 
          104,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  530,    0,    0,    0,    0,    0,    0,  530, 
          104,    0,    0,  104,  526,    0,  104,  104,    0,  104, 
            0,  104,    0,  279,    0,  104,    0,    0,    0,    0, 
          104,    0,    0,  104,    0,  530,    0,    0,  104,  104, 
          104,  104,  104,  104,    0,    0,    0,  104,    0,  104, 
          104,    0,  104,  104,    0,    0,  105,  105,  105,  105, 
          105,  105,  105,  105,  105,  105,  105,    0,  323,  105, 
          105,    0,  105,  105,  105,  105,  105,  105,  105,    0, 
            0,    0,    0,  105,  105,  105,  105,  105,  105,  105, 
            0,    0,  105,    0,    0,    0,    0,    0,  105,  105, 
            0,  105,  105,  105,  105,    0,  105,  105,  105,  105, 
          105,  105,    0,  105,  105,  105,  105,  323,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  278,    0, 
            0,    0,    0,    0,    0,  278,  105,    0,    0,  105, 
          527,    0,  105,  105,    0,  105,    0,  105,    0,    0, 
            0,  105,    0,    0,    0,    0,  105,    0,    0,  105, 
            0,    0,    0,    0,  105,  105,  105,  105,  105,  105, 
            0,    0,    0,  105,    0,  105,  105,    0,  105,  105, 
            0,    0,    0,    0,    0,    0,    0,    0,  105,  105, 
          105,  105,  105,  105,  105,  105,  105,  105,  105,    0, 
          548,  105,  105,    0,  105,  105,  105,  105,  105,  105, 
          105,    0,    0,    0,    0,  105,  105,  105,  105,  105, 
          105,  105,    0,    0,  105,    0,    0,    0,    0,    0, 
          105,  105,    0,  105,  105,  105,  105,    0,  105,  105, 
          105,  105,  105,  105,    0,  105,  105,  105,  105,  548, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          279,    0,    0,    0,    0,    0,    0,  279,  105,    0, 
            0,  105,    0,    0,  105,  105,    0,  105,    0,  105, 
            0,    0,    0,  105,    0,    0,    0,    0,  105,    0, 
            0,  105,    0,    0,    0,    0,  105,  105,  105,  105, 
          105,  105,    0,    0,    0,  105,    0,  105,  105,    0, 
          105,  105,    0,    0,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,    0,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  548,    0,    0, 
            0,  323,  323,  323,  323,  323,  323,  323,    0,    0, 
          323,    0,    0,    0,    0,    0,  323,  323,    0,  323, 
          323,  323,  323,    0,  323,  323,  323,  323,  323,  323, 
            0,  323,  323,  323,  323,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,    0,    0,    0, 
            0,    0,    0,    0,  323,    0,    0,  323,    0,    0, 
          323,  323,    0,  323,    0,  323,    0,    0,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,  323,    0,    0, 
            0,    0,  323,  323,  323,  323,  323,  323,    0,    0, 
            0,  323,    0,  323,  323,    0,  323,  323,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,  548,  548,  548, 
          548,  548,    0,    0,  548,  548,  548,    0,    0,    0, 
          548,  233,  548,  548,  548,  548,  548,  548,  548,    0, 
            0,    0,    0,  548,  548,  548,  548,  548,  548,  548, 
            0,    0,  548,    0,    0,    0,    0,    0,  548,  548, 
            0,  548,  548,  548,  548,    0,  548,  548,  548,  548, 
          548,  548,    0,  548,  548,  548,  548,    0,    0,    0, 
          232,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,    0,    0,  548, 
            0,    0,  548,  548,    0,  548,    0,  548,    0,    0, 
            0,  548,    0,    0,    0,    0,    0,    0,    0,  548, 
            0,    0,    0,    0,  548,  548,  548,  548,  548,  548, 
            0,    0,    0,  548,    0,  548,  548,    0,  548,  548, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  548,  548,  548,  548,  548,  548,    0, 
            0,    0,  548,  548,    0,    0,    0,  548,    0,  548, 
          548,  548,  548,  548,  548,  548,    0,    0,    0,    0, 
          548,  548,  548,  548,  548,  548,  548,    0,    0,  548, 
            0,    0,    0,    0,    0,  548,  548,    0,  548,  548, 
          548,  548,    0,  548,  548,  548,  548,  548,  548,    0, 
          548,  548,  548,  548,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  548,    0,    0,  548,    0,  581,  548, 
          548,    0,  548,    0,  548,    0,    0,    0,  548,    0, 
            0,    0,    0,    0,    0,    0,  548,    0,  392,  548, 
            0,  548,  548,  548,  548,  548,  548,    0,  392,    0, 
          548,    0,  548,  548,    0,  548,  548,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,   89,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,  392,    0,   97, 
           28,  392,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  392, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,  318, 
          113,    0,    0,   46,   47,    0,   48,    0,    0,  318, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  318,    0, 
            0,    0,  318,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          318,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  319,   12,   13,   14,  101, 
          102,   17,   18,    0,    0,  319,    0,  103,  104,  105, 
           22,   23,   24,   25,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,  107,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,  319, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          392,  392,  392,    0,  319,    0,  392,  392,  319,  392, 
          294,    0,    0,  113,    0,    0,   46,   47,  392,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,  392,  392, 
            0,  392,  392,  392,  392,  392,  319,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    0,  392,  392,  392,  392,  392, 
          392,  392,  392,  392,  392,  392,  392,  392,  392,    0, 
            0,  392,  392,  392,    0,    0,    0,    0,    0,  392, 
            0,    0,    0,    0,    0,    0,  392,  282,  392,    0, 
          392,  392,  392,  392,  392,  392,  392,  282,  392,  392, 
          392,  318,  318,  318,    0,    0,  318,  318,  318,    0, 
          318,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          318,    0,    0,    0,    0,    0,    0,    0,    0,  318, 
          318,  282,  318,  318,  318,  318,  318,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  282,    0,    0,    0, 
          282,    0,    0,    0,    0,    0,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
            0,    0,  318,  318,  318,    0,    0,    0,  282,    0, 
          318,    0,    0,    0,    0,    0,    0,  318,    0,  318, 
          464,  318,  318,  318,  318,  318,  318,  318,    0,  318, 
          464,  318,    0,    0,    0,    0,    0,  319,  319,  319, 
            0,    0,  319,  319,  319,    0,  319,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  319,    0,    0,    0, 
            0,    0,    0,    0,   88,  319,  319,    0,  319,  319, 
          319,  319,  319,    0,    0,    0,    0,    0,    0,  464, 
            0,   96,    0,  464,    0,    0,    0,    0,    0,    0, 
            0,    0,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,    0,    0,  319,  319, 
          319,  464,    0,    0,    0,    0,  319,    0,    0,    0, 
            0,    0,    0,  319,    0,  319,    0,  319,  319,  319, 
          319,  319,  319,  319,  272,  319,    0,  319,    0,    0, 
            0,    0,    0,    0,  272,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   95,  282, 
          282,  282,    0,    0,  282,  282,  282,    0,  282,    0, 
            0,    0,    0,  272,    0,  103,    0,  272,  282,    0, 
            0,    0,    0,    0,    0,    0,    0,  282,  282,    0, 
          282,  282,  282,  282,  282,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  272,    0,    0,    0,    0, 
            0,    0,    0,    0,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,    0,    0, 
          282,  282,  282,    0,    0,    0,    0,    0,  282,    0, 
            0,    0,    0,    0,    0,  282,    0,  282,  279,  282, 
          282,  282,  282,  282,  282,  282,    0,  282,  279,  282, 
            0,    0,  464,  464,  464,    0,    0,    0,  464,  464, 
            0,  464,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          464,  464,   94,  464,  464,  464,  464,  464,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,    0,  102, 
            0,  279,    0,    0,    0,    0,    0,  464,  464,  464, 
          464,  464,  464,  464,  464,  464,  464,  464,  464,  464, 
          464,    0,    0,  464,  464,  464,    0,  465,    0,  279, 
            0,  464,    0,    0,    0,    0,    0,    0,  464,    0, 
          464,    0,  464,  464,  464,  464,  464,  464,  464,  260, 
          464,    0,  464,    0,    0,    0,    0,    0,    0,  260, 
            0,    0,    0,    0,    0,    0,  272,  272,  272,    0, 
            0,    0,  272,  272,    0,  272,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   60,  260,  272,  272,    0,  272,  272,  272, 
          272,  272,   60,    0,    0,    0,    0,    0,  260,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  272,  272,  272,  272,  272,  272,  272,  272,  272, 
          272,  272,  272,  272,  272,    0,    0,  272,  272,  272, 
            0,    0,    0,    0,    0,  272,    0,    0,    0,    0, 
            0,   60,  272,   62,  272,    0,  272,  272,  272,  272, 
          272,  272,  272,   62,  272,    0,  272,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   64, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   64, 
          279,  279,  279,    0,    0,    0,  279,  279,    0,  279, 
            0,    0,   62,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  279,  279, 
            0,  279,  279,  279,  279,  279,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   64,    0, 
            0,    0,    0,    0,    0,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,    0, 
            0,  279,  279,  279,    0,    0,    0,    0,    0,  279, 
            0,    0,    0,    0,    0,    0,  279,    0,  279,    0, 
          279,  279,  279,  279,  279,  279,  279,    0,  279,    0, 
          279,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  260,  260,  260,    0,    0,  260,  260,  260,    0, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          260,  260,    0,    0,    0,    0,    0,    0,    0,  260, 
          260,  416,  260,  260,  260,  260,  260,    0,    0,    0, 
            0,    0,    0,    0,   60,   60,   60,    0,    0,   60, 
           60,   60,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   60,   60,    0,    0,    0,    0,    0, 
            0,    0,   60,   60,    0,   60,   60,   60,   60,   60, 
          260,    0,    0,  260,    0,  260,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  260,    0,    0,    0,   62,   62,   62,    0,    0, 
           62,   62,   62,    0,   62,    0,    0,    0,    0,    0, 
            0,    0,    0,   60,   62,   62,   60,    0,    0,    0, 
            0,    0,    0,   62,   62,    0,   62,   62,   62,   62, 
           62,   64,   64,   64,   60,    0,   64,   64,   64,    0, 
           64,    0,    0,    0,  416,    0,    0,    0,    0,    0, 
           64,   64,    0,    0,    0,    0,    0,    0,    0,   64, 
           64,    0,   64,   64,   64,   64,   64,    0,    0,    0, 
            0,    0,    0,    0,   62,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   62, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   64,    0,    0,   64,    0,    0, 
            0,    0,    0,    4,    5,    6,    7,    8,    0,    0, 
            0,    9,   10,    0,    0,   64,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    3, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  217,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,  217,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
          281,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  101,  102,   17,   18,    0, 
            0,    0,    0,  103,   20,   21,   22,   23,   24,   25, 
            0,    0,  106,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  247,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,    0,  113, 
            0,    0,   46,   47,    0,   48,    0,  248,    0,  249, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,  104,  105,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  247,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,    0,  113,    0,    0,   46,   47,    0,   48,    0, 
          638,    0,  249,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  252,  252,  252,    0,  252,    0,    0, 
            0,  252,  252,    0,    0,    0,  252,    0,  252,  252, 
          252,  252,  252,  252,  252,    0,    0,    0,    0,  252, 
          252,  252,  252,  252,  252,  252,    0,    0,  252,    0, 
            0,    0,    0,    0,    0,  252,    0,    0,  252,  252, 
          252,    0,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,  252,  252,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  252,    0,    0,  252,    0,    0,  252,  252, 
            0,  252,    0,  252,    0,  252,    0,  252,    0,    0, 
            0,    0,    0,    0,    0,  252,    0,    0,    0,    0, 
          252,  252,  252,  252,  252,  252,    0,    0,    0,  252, 
            0,  252,  252,    0,  252,  252,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  101,  102,   17,   18,    0,    0, 
            0,    0,  103,  104,  105,   22,   23,   24,   25,    0, 
            0,  106,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  247,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  223,    0,    0,  113,    0, 
            0,   46,   47,    0,   48,    0,  248,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  101,  102,   17, 
           18,    0,    0,    0,    0,  103,  104,  105,   22,   23, 
           24,   25,    0,    0,  106,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,  247,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,    0, 
            0,  113,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,  249,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          101,  102,   17,   18,    0,    0,    0,    0,  103,  104, 
          105,   22,   23,   24,   25,    0,    0,  106,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,  247,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,    0,    0,  113,    0,    0,   46,   47,    0, 
           48,    0,  638,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  101,  102,   17,   18,    0,    0,    0, 
            0,  103,  104,  105,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          247,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,    0,    0,  113,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  101,  102,   17,   18, 
            0,    0,    0,    0,  103,  104,  105,   22,   23,   24, 
           25,    0,    0,  106,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
          113,  447,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          250,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          223,    0,    0,  113,    0,    0,   46,   47,    0,   48, 
            0,  572,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  101,  102,   17,   18,    0,    0,    0,    0, 
          103,  104,  105,   22,   23,   24,   25,    0,    0,  106, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,    0,  113,    0,    0,   46, 
           47,    0,   48,    0,  572,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  101,  102,   17,   18,    0, 
            0,    0,    0,  103,  104,  105,   22,   23,   24,   25, 
            0,    0,  106,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,    0,  113, 
            0,    0,   46,   47,    0,   48,    0,  248,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,  104,  105,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,    0,  113,    0,    0,   46,   47,    0,   48,    0, 
          813,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  101,  102,   17,   18,    0,    0,    0,    0,  103, 
          104,  105,   22,   23,   24,   25,    0,    0,  106,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  223,    0,    0,  113,    0,    0,   46,   47, 
            0,   48,    0,  638,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,  537,  537,  537,    0, 
          537,    0,    0,    0,  537,  537,    0,    0,    0,  537, 
            0,  537,  537,  537,  537,  537,  537,  537,    0,    0, 
            0,    0,  537,  537,  537,  537,  537,  537,  537,    0, 
            0,  537,    0,    0,    0,    0,    0,    0,  537,    0, 
            0,  537,  537,  537,    0,  537,  537,  537,  537,  537, 
          537,    0,  537,  537,  537,  537,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  537,    0,    0,  537,  537, 
            0,  537,  537,    0,  537,    0,    0,    0,    0,    0, 
          537,    0,    0,    0,    0,    0,    0,    0,  537,    0, 
            0,    0,    0,  537,  537,  537,  537,  537,  537,    0, 
            0,    0,  537,    0,  537,  537,    0,  537,  537,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,    0, 
            0,  113,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          101,  102,   17,   18,    0,    0,    0,    0,  103,  104, 
          105,   22,   23,   24,   25,    0,    0,  106,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,    0,    0,  113,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,    0,    0,  113,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,  537,  537, 
          537,    0,  537,    0,    0,    0,  537,  537,    0,    0, 
            0,  537,    0,  537,  537,  537,  537,  537,  537,  537, 
            0,    0,    0,    0,  537,  537,  537,  537,  537,  537, 
          537,    0,    0,  537,    0,    0,    0,    0,    0,    0, 
          537,    0,    0,  537,  537,  537,    0,  537,  537,  537, 
          537,  537,  537,    0,  537,  537,  537,  537,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  537,    0,    0, 
          537,    0,    0,  537,  537,    0,  537,    0,    0,    0, 
            0,    0,  537,    0,    0,    0,    0,    0,    0,    0, 
          537,    0,    0,    0,    0,  537,  537,  537,  537,  537, 
          537,    0,    0,    0,  537,    0,  537,  537,    0,  537, 
          537,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  101, 
          102,   17,   18,    0,    0,    0,    0,  103,  104,  105, 
           22,   23,   24,   25,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,  107,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          240,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  101,  102,   17,   18,    0,    0,    0,    0, 
          103,  104,  105,   22,   23,   24,   25,    0,    0,  106, 
            0,    0,    0,    0,    0,    0,  107,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  110,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  294,    0,    0,  368,    0,    0,   46, 
           47,    0,   48,    0,  369,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  101,  102,   17,   18,    0, 
            0,    0,    0,  103,  104,  105,   22,   23,   24,   25, 
            0,    0,  106,    0,    0,    0,    0,    0,    0,  107, 
            0,    0,   31,   32,   33,    0,  108,   35,   36,   37, 
          109,   39,    0,   40,    0,    0,  110,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  112,    0,    0,  113, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,  104,  105,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,  107,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  110, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  294, 
            0,    0,  368,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  101,  102,   17,   18,    0,    0,    0,    0,  103, 
          104,  105,   22,   23,   24,   25,    0,    0,  106,    0, 
            0,    0,    0,    0,    0,  107,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
            0,    0,  110,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  823,    0,    0,  113,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  101,  102,   17,   18,    0,    0, 
            0,    0,  103,  104,  105,   22,   23,   24,   25,    0, 
            0,  106,    0,    0,    0,    0,    0,    0,  107,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,    0,  110,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  902,    0,    0,  113,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,  122, 
          123,  124,  125,  126,  127,  128,  129,    0,    0,  130, 
          131,  132,  133,  134,    0,    0,  135,  136,  137,  138, 
          139,  140,  141,    0,    0,  142,  143,  144,  202,  203, 
          204,  205,  149,  150,  151,  152,  153,  154,  155,  156, 
          157,  158,  159,  160,  206,  207,  208,    0,  209,  165, 
          270,    0,  210,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,   52,  122,  123,  124, 
          125,  126,  127,  128,  129,    0,    0,  130,  131,  132, 
          133,  134,    0,    0,  135,  136,  137,  138,  139,  140, 
          141,    0,    0,  142,  143,  144,  202,  203,  204,  205, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  206,  207,  208,    0,  209,  165,    0,    0, 
          210,    0,    0,    0,  167,  168,    0,  169,  170,  171, 
          172,  173,  174,  175,    0,    0,  176,  177,    0,    0, 
            0,  178,  179,  180,  181,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,   52,  122,  123,  124,  125,  126, 
          127,  128,  129,    0,    0,  130,  131,  132,  133,  134, 
            0,    0,  135,  136,  137,  138,  139,  140,  141,    0, 
            0,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,  162,  163,    0,  164,  165,   36,   37,  166,   39, 
            0,    0,  167,  168,    0,  169,  170,  171,  172,  173, 
          174,  175,    0,    0,  176,  177,    0,    0,    0,  178, 
          179,  180,  181,    0,    0,    0,    0,    0,  182,    0, 
            0,    0,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,  122,  123,  124,  125,  126,  127,  128,  129, 
            0,    0,  130,  131,  132,  133,  134,    0,    0,  135, 
          136,  137,  138,  139,  140,  141,    0,    0,  142,  143, 
          144,  202,  203,  204,  205,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  159,  160,  206,  207,  208, 
            0,  209,  165,  303,  304,  210,  305,    0,    0,  167, 
          168,    0,  169,  170,  171,  172,  173,  174,  175,    0, 
            0,  176,  177,    0,    0,    0,  178,  179,  180,  181, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  194,  195,    0,    0,  196,  122, 
          123,  124,  125,  126,  127,  128,  129,    0,    0,  130, 
          131,  132,  133,  134,    0,    0,  135,  136,  137,  138, 
          139,  140,  141,    0,    0,  142,  143,  144,  202,  203, 
          204,  205,  149,  150,  151,  152,  153,  154,  155,  156, 
          157,  158,  159,  160,  206,  207,  208,    0,  209,  165, 
            0,    0,  210,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  631,  553,  196,    0,  632,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  633,  559, 
          196,    0,  634,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  658,  553,  196,    0,  659,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  660,  559, 
          196,    0,  661,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  914,  553,  196,    0,  915,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  916,  559, 
          196,    0,  917,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  946,  559,  196,    0,  947,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  566,  553, 
          196,    0,  567,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,    2,   28,  413,    3,   15,   16,    7, 
          256,   19,  317,   48,   93,   10,  398,   21,    7,   21, 
            6,   27,    0,  231,   47,    4,    5,  367,   10,   27, 
           59,  389,   10,   27,  362,   14,   11,  289,   27,   59, 
          292,   44,  689,   44,   51,  418,   52,   59,   47,   48, 
            0,   10,   11,   98,    9,   10,   11,   10,   10,   10, 
          388,   65,   44,   65,   59,   49,   52,   10,    0,   10, 
           49,  360,  361,  496,  363,  364,   91,   10,   91,   61, 
          408,   59,   45,  107,   10,   10,  391,   47,   48,   10, 
           91,   46,  774,  474,  422,  309,   44,  386,  779,  313, 
           10,  105,  867,  280,  305,   10,   59,   59,   59,   10, 
           10,  115,  515,   61,   93,   98,  772,  406,  407,   44, 
          340,  281,   44,   98,    2,    3,  687,   10,   61,   10, 
           10,  420,  305,   59,   59,  112,    0,   32,   59,   10, 
          341,  371,  117,   44,   44,  473,   10,   10,  551,   59, 
          113,  267,  431,  317,   59,   10,  111,  358,   10,   59, 
          372,   44,  451,   44,   44,  377,   10,  397,  284,   91, 
          935,  599,  308,  374,   10,  220,   10,   10,   59,   59, 
           10,   44,  471,   10,  361,  464,  842,   10,   10,   10, 
           61,   10,  497,  621,   10,   59,   10,  372,   10,  344, 
          581,  374,  377,   10,   59,  290,  291,  635,  368,  856, 
          892,  280,  247,  248,  249,  896,  295,  362,   10,    2, 
            3,    4,    5,   59,  325,    8,    9,   10,   11,   59, 
           10,   14,   15,   16,  662,  593,   19,  220,  894,  375, 
          376,  623,  269,  340,  271,  220,  604,   10,  671,  672, 
           10,  234,   10,  261,   61,  263,  264,  358,  703,  234, 
           10,  256,   45,   46,  709,  264,   49,  923,   51,   61, 
           10,  340,  310,  487,  428,  328,  305,  431,  279,  238, 
          239,   61,  335,  238,  239,  846,   10,   15,   16,  378, 
          379,   19,  361,   10,  697,  328,   59,  602,  361,   10, 
           32,   59,  335,  306,  865,  308,  309,  310,  311,   32, 
           93,  274,  267,  328,  269,  328,  295,  433,  281,  365, 
          335,   61,  335,  439,  440,  282,   45,  328,  111,  341, 
          113,  279,  367,  497,  335,   59,  371,   10,  358,  217, 
          456,  722,   59,  459,  367,  374,  279,  337,  371,  772, 
           61,  774,  305,  305,  362,  361,  360,  279,  365,  341, 
          367,  356,  397,  362,  371,  372,  325,  326,  327,  328, 
          325,  326,  327,  328,  397,  330,  331,  374,  718,  414, 
          388,  387,  386,  756,  362,  369,   59,  692,  341,  388, 
          369,  414,  427,  428,  640,  474,  431,  340,  397,  398, 
          408,  407,  406,  344,  656,  368,  328,  382,  341,  408, 
          387,  362,  362,  335,  422,  421,  420,  625,  340,  842, 
          843,  374,  374,  422,  305,  305,  461,  835,   10,  464, 
          362,  341,  358,  358,  217,  390,  341,  358,  602,   44, 
          446,  404,  417,  418,    0,  281,  452,  451,  446,  412, 
          449,  329,  446,  835,   10,  238,  239,  446,  358,  817, 
          341,  341,   44,   44,  580,  473,  472,  471,  428,  892, 
          341,  894,  279,   10,  473,  370,  371,  358,  261,   61, 
          263,  264,  377,  507,  267,  601,  269,  279,   44,  341, 
          918,  274,  447,  374,  374,  474,  374,  341,  281,  279, 
          923,  461,  581,   59,  262,  263,  264,  341,  341,   91, 
          268,  269,  295,  271,  341,  514,  515,  822,  341,  341, 
          341,  879,  341,  401,   61,  341,  550,  341,  736,  341, 
          290,  291,  648,  261,  341,  263,   10,  572,   91,  279, 
          264,  565,  325,  326,  327,  328,  329,  330,  331,  341, 
          267,  555,  551,  555,   61,  883,  555,  561,   10,  561, 
          676,  341,  281,   91,  568,  569,  568,  569,  279,  568, 
          569,  449,   61,  306,   10,  599,   10,  310,  657,  362, 
           91,  337,  365,  341,  367,  368,  369,   61,  371,  372, 
          594,  374,  881,  597,  267,  594,   10,  621,   10,  605, 
          606,  341,  581,  638,  362,  388,  389,  390,  606,   61, 
          609,  635,  606,  612,  730,  590,  615,  606,  401,  605, 
          340,  404,  830,   59,  623,  408,   10,   61,  603,  412, 
          341,  378,  379,  592,  669,   44,   10,  592,  662,  422, 
           44,  677,   91,  722,  262,   59,   91,   59,  611,  368, 
          305,   91,  264,  677,  310,  771,  692,    2,    3,    4, 
            5,    6,  337,    8,  447,  338,  449,   61,  692,   14, 
           44,   10,  370,  371,  372,   59,  337,  636,  657,  377, 
          271,  636,   91,   10,  719,  310,  341,   61,  268,  269, 
          473,  474,   10,  700,  701,  263,  264,  279,  697,  706, 
           45,  664,   59,  358,   49,   44,  262,  263,  264,  568, 
          569,  718,  268,  269,   10,  271,  751,   91,   10,  374, 
           59,  684,  685,   44,  279,  306,   44,  308,  309,  310, 
          311,  694,   59,  696,  290,  291,  699,  293,  294,  295, 
          296,   59,  279,  722,  338,   10,  328,   44,   93,   44, 
          725,   10,   91,  335,  790,  317,  735,  509,  510,  341, 
           54,   55,  361,   59,  370,  371,  790,   59,  113,  317, 
           91,  377,  317,  337,  380,  328,  739,  344,  813,  362, 
          341,  756,  335,  742,   10,  341,  310,  742,   10,  752, 
          753,  754,   10,   44,   59,  370,  371,  372,  581,   91, 
          328,  372,  377,  810,  341,  279,  362,  335,  346,  592, 
          593,  317,   10,    2,    3,  372,   44,  328,   44,    8, 
          340,  604,   44,  269,  335,  849,   44,  279,  611,  267, 
          362,  267,  264,   59,   44,  798,  835,  341,   32,   61, 
           61,  306,  348,   61,  306,  279,  352,  353,  262,  263, 
          264,  263,  264,  636,  268,  269,   45,  271,  263,  264, 
           44,   59,   44,   44,  269,  828,  337,  341,  337,   91, 
          279,  337,  217,   91,  657,  883,  882,  881,  337,  328, 
          264,  664,  861,  328,  883,  269,  335,  271,  328,  341, 
          335,   61,   44,   91,  918,  335,   10,    2,    3,    4, 
            5,  684,  685,    8,   10,  279,  280,  341,   44,   14, 
          264,  694,  338,  696,  263,  337,  699,  700,  701,  328, 
          337,  920,  885,  706,  113,  931,  335,  341,  891,  274, 
           44,   10,   10,  264,  337,  718,  281,  264,   44,  722, 
           45,  280,  269,  362,   49,   59,   44,   59,  362,  267, 
          295,   58,  735,  344,  328,   61,  739,  337,  279,  742, 
          306,  335,  308,  309,  310,  311,  340,  341,  264,  752, 
          753,  754,  268,  269,   44,  267,  264,   91,  264,  264, 
           59,   59,  337,    0,  329,   91,  264,  361,   93,  328, 
          362,   44,   44,   10,  341,  264,  335,  262,  263,  264, 
          362,  340,   44,  268,  269,   44,  271,  328,  113,  370, 
          371,  372,   91,   91,  335,  798,  377,   10,   44,  358, 
          338,   91,  361,  368,  369,  777,   61,  810,  217,  374, 
          782,  783,   44,  785,  817,  787,  328,  789,   44,  791, 
          792,  267,   59,  335,  389,  828,   10,  306,  340,  308, 
          309,  310,  311,   44,   10,  358,  401,  279,  280,  404, 
           10,  279,  280,  264,  362,    0,   59,  412,  264,  267, 
          310,    2,    3,  264,  264,   10,  341,    8,  861,   44, 
          339,  358,  280,   14,  264,  274,  362,   44,  347,  348, 
          349,  350,  281,   44,  310,   59,  879,  362,   91,   44, 
          883,   44,  885,   59,  449,   44,  328,  264,  891,   59, 
          328,  264,  217,  335,   45,   44,  271,  335,  340,  341, 
          344,   10,  340,  341,   59,  362,   10,   91,  340,  474, 
          328,  370,  371,  372,  271,   91,  341,  335,  377,  361, 
          329,   91,  340,  361,  344,  362,  898,  899,  900,  901, 
          308,  309,  904,  311,  906,  907,  908,  909,  344,   58, 
           44,  344,  306,  361,  308,  309,  310,  311,  264,  274, 
           59,    0,   67,  279,  280,    5,  281,   61,  920,  368, 
            6,   10,  113,  822,  687,  374,   10,  865,  267,  267, 
          295,   71,   14,  945,  884,  339,  948,  949,  950,  951, 
          389,  280,  280,  347,  671,  896,  958,   91,  449,  279, 
          280,   -1,  401,   -1,  328,  404,   -1,  375,  376,   -1, 
           44,  335,  328,  412,  329,   -1,  340,   -1,   -1,  335, 
           59,  370,  371,  372,   -1,  341,  581,   61,  377,  293, 
          294,  295,  296,  297,  358,  262,  263,  264,  593,  328, 
          328,  268,  269,   -1,  271,  361,  335,  335,  328,  604, 
          449,    0,  340,  368,  369,  335,  611,   91,   -1,  374, 
          340,   10,   10,   -1,  267,   -1,  293,  294,  295,  296, 
          297,   -1,  361,  361,  389,   -1,  217,  280,  262,  263, 
          264,  361,   -1,   -1,  268,  269,  401,  271,   -1,  404, 
           -1,   44,   -1,  267,   -1,   44,   44,  412,  370,  371, 
          372,  267,  657,   -1,   -1,  377,   -1,  267,   -1,  664, 
           59,   -1,   -1,   61,  341,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  328,  271,   -1,   -1,  684, 
          685,   -1,  335,  274,  449,  362,  281,  340,   91,  694, 
          281,  696,   -1,   91,  699,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  328,  317,   -1,  341,  361,  474, 
           44,  335,  328,  262,  263,  264,   10,  722,  328,  335, 
          269,  333,  334,  317,   -1,  335,   -1,   -1,  362,    0, 
          735,   -1,   -1,   -1,  739,  279,  348,   -1,  329,   10, 
          352,  353,  354,  355,  593,   -1,  341,  752,  753,  754, 
           -1,   -1,   -1,   -1,  348,  604,   -1,   91,  352,  353, 
          354,  355,  611,   -1,   -1,   59,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  367,  368,  267,  268, 
          269,   -1,  271,  374,  328,   -1,   -1,   -1,   59,   -1, 
           -1,  335,  281,  798,   -1,  279,  340,  341,  389,   10, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          401,   -1,  817,  404,   -1,  664,  581,   -1,   -1,   -1, 
           -1,  412,   -1,  828,   -1,   -1,   -1,  306,  593,  308, 
          309,  310,  311,   -1,   -1,  684,  685,   -1,  306,  604, 
          308,  309,  310,  311,  328,  694,  611,  696,   59,   -1, 
          699,  335,  341,   10,   -1,   -1,  861,  341,  449,   -1, 
          339,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  339,  271,  362,  879,   -1,  279,  280,   -1,  347, 
          885,  279,  687,   -1,  689,   -1,  891,  692,   -1,   -1, 
          739,   -1,  657,   -1,  293,  294,  295,  296,  297,  664, 
          665,   -1,   59,  752,  753,  754,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,  684, 
          685,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,  694, 
          328,  696,  335,   -1,  699,   -1,   -1,  335,   -1,  338, 
           15,   16,  341,  341,   19,  279,  280,   -1,   -1,  798, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  722,  361,   -1, 
           10,   -1,   -1,  362,   -1,   -1,   41,   42,  817,   -1, 
          735,   -1,   47,   48,  739,   50,   51,   -1,   -1,  828, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,  752,  753,  754, 
           -1,  262,  263,  264,  328,   -1,  267,  268,  269,   -1, 
          271,  335,  593,   -1,   -1,   -1,  340,  362,   -1,   59, 
          281,   -1,  306,  604,  308,  309,  310,  311,   -1,   -1, 
          611,   -1,  293,  294,  295,  296,  297,  361,   -1,   -1, 
          879,   -1,   -1,  798,  328,   -1,  885,   -1,   -1,   -1, 
           -1,  335,  891,   -1,   -1,  339,  340,   -1,   -1,  317, 
           -1,  856,  817,  347,  348,  349,  350,   -1,   -1,   -1, 
          865,   -1,  867,  828,   -1,  333,  334,   -1,   -1,   -1, 
          341,   -1,   -1,  664,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,   -1,   -1, 
          358,  362,  360,  684,  685,  306,  861,  308,  309,  310, 
          311,   -1,   -1,  694,   -1,  696,   -1,   -1,  699,   44, 
           -1,   -1,   -1,   -1,  879,   -1,   -1,  328,   -1,   -1, 
          885,   -1,    4,    5,  335,   -1,  891,  718,  339,  340, 
          935,   -1,   14,   -1,   -1,   -1,  347,  348,  349,  350, 
            0,   -1,   -1,   -1,  735,   -1,   -1,   -1,  739,  306, 
           10,  308,  309,  310,  311,   -1,   91,   -1,   -1,   41, 
           42,  752,  753,  754,   -1,   47,   48,   49,   50,   -1, 
           -1,  328,  247,  248,  249,  250,   -1,   -1,  335,   -1, 
           -1,   -1,  339,  340,   44,   -1,  261,   -1,  263,  264, 
          347,  348,  349,  350,   -1,   -1,   -1,  272,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,  798,   -1,   -1, 
           -1,   93,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,  817,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,  828,   -1,   -1, 
          290,  291,    0,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,   -1,   -1,   -1,   44,  362,  879,   -1, 
          365,  341,  367,  317,  885,   -1,  371,  372,   -1,   -1, 
          891,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333, 
          334,   -1,  362,  388,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  397,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,   -1,  408,  409,  410,  411,   -1,  306,  414, 
          308,  309,  310,  311,  279,  280,   -1,  422,   -1,  339, 
          340,   -1,  427,  428,   -1,   -1,  431,  347,  348,  349, 
          350,   -1,   -1,   -1,   -1,  247,  248,  249,  250,   -1, 
           -1,  339,   -1,   -1,   -1,   -1,   -1,   -1,  453,  454, 
          455,  349,  350,   -1,   -1,   -1,  461,    0,   -1,  464, 
          272,   -1,   -1,  328,   -1,   -1,   -1,   10,  473,   -1, 
          335,   -1,  262,  263,  264,  340,   -1,  267,  268,  269, 
           -1,  271,   -1,  295,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,  361,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   59,   -1,   -1,   -1, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,  369,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  572,   -1,   -1, 
           -1,   -1,  362,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  374,  397,   -1,  306,   -1,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,  409,  410,  411, 
           -1,   -1,  414,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,  427,  428,   -1,   -1,  431, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,  638,  306,    0,  308,  309,  310,  311, 
           -1,  453,  454,  455,   -1,   10,   -1,   -1,   -1,  461, 
          338,   -1,  464,  341,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  474,   -1,  669,   -1,   -1,  339,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,  347,  348,  349,  350,   44, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,   -1,   -1,   59,  700,  701,  347,  348,  349, 
          350,  706,  707,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  717,  718,  719,   -1,   -1,   -1,  723,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,  281,  282, 
          745,  746,  747,   -1,   -1,   -1,  751,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
          572,   -1,  680,   -1,   -1,   -1,   -1,   -1,   -1,  581, 
           -1,  689,   -1,   -1,  692,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  799,   -1,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,  810,   -1,   -1,  813,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  317,   -1,   -1,  638,  832,  322,  323, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  657,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,  348,   -1,  350,  669,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  883,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  707,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  717,  271,  719,   -1,   -1, 
          722,  723,    0,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   10,  735,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,  745,  746,  747,  854,   -1,  856,  751, 
          858,   -1,   -1,   -1,  862,   -1,   -1,   -1,   -1,  867, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,  341,   -1,   -1,  344, 
          306,  346,  308,  309,  310,  311,   -1,  799,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  813,  328,   91,   -1,   -1,   -1,   -1,  926,  335, 
           -1,   -1,   -1,  339,  340,  933,   -1,  935,   -1,  937, 
          832,  347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  954,   -1,   -1,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  257,  258,  259,  861, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   10,  373,  374,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           59,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,    0,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,   10,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   91,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,    0,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,   -1,   -1,   -1,   44, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,   58,   59,  348,   61,  350,   63,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   91,   -1,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   59,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   10,  373,  374,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   59,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,    0,   -1,   -1,  373,  374, 
          375,  376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   58,   59,   -1,   61,  335,   63,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,    0,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   10,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   44,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,   58,   59,  348,   -1, 
          350,   63,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   91, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   10,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   10,  373,  374, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,    0,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   58,   59,  265,  266, 
           -1,   63,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   91, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   10,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   44,  373,   -1,  375,  376, 
           -1,  378,  379,  306,   -1,  308,  309,  310,  311,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   91,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   59,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   63,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,    0,   -1,   -1,  373,  374,  375,  376,   -1,  378, 
          379,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   58, 
           59,   -1,   61,  335,   63,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   59,  306,  307,   -1,   63,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   91,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   10, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,  374,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   63, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          362,   -1,  364,  365,  366,  367,  368,  369,    0,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   59,  265,  266, 
           -1,   63,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   91, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   10,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   44,  373,  297,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   63, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,    0,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   10,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,  344,  348,  346,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   44, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   59,  340,   61,   -1,   63,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   59,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,  340,  341,  342,  343,   -1,  345,   -1,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,    0,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  341, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  257,  258,  259,   -1,  261,   -1, 
          362,   -1,  265,  266,   -1,   -1,   -1,  270,    0,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   44,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
          333,   63,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           59,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   44,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,  340,  341, 
          342,  343,   -1,  345,   -1,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   10,   -1, 
          339,   -1,  341,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   44,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   91, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,    0, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   10, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           91,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,    0,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   10,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,  280,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,  361, 
          362,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,  280, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   91,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
          361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,    0,  333,  334,  335,   -1, 
          337,  338,   -1,   -1,  341,   10,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,    0, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,  307,   58,   59,  310, 
           61,   -1,   63,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           91,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  374,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   91, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,    0,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  374,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   91,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  374,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,    0, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   44,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  374,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,    0,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  374,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,    0,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   10,  350,   -1,   -1,   -1, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,    0,  350, 
           -1,   -1,   -1,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  374,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,  350,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   -1,   -1,   63, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,    0,  350,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   10,  346,   -1,   -1,   -1,  350,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          374,  267,  268,  269,   -1,  271, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291, 
           63,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   10,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   -1,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,    0,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   44, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  362,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   10,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,  267,  268,  269,   -1,  271,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,  281,  282,   10,  374, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   10,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,  362,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,  374, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   58,   59,   -1,  362,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,  262,  263, 
          264,   -1,   -1,  305,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  325,   -1,   -1,   -1,  329,  330,  293, 
          294,  295,  296,  297,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   44,   -1,  267,  268,  269,   -1,  271, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  281, 
          282,   -1,  374,   -1,   -1,   -1,   -1,  341,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
          262,  263,  264,  305,    0,  267,  268,  269,  362,  271, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  338,   -1,   -1,  341, 
           -1,   -1,  344,  305,  346,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   58,   59,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   10,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,  374,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   58,   59,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,    0,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  362,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           58,   59,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   44,  374,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,  281,  282,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  290,  291,    0,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  362,   10,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   58,   59,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  362,   10,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1, 
          262,  263,  264,   -1,   10,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   58, 
           59,   -1,  305,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  281, 
          282,  344,   44,  346,   -1,   -1,   -1,   -1,  290,  291, 
            0,  293,  294,  295,  296,  297,   -1,   59,   -1,  362, 
           10,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   59, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,  290,  291,    0,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   10,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   10,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  362,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   44,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  374,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,  338,   -1,   -1,  341, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   91,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  262,  263, 
          264,   -1,   10,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  305,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,  305,  341,   -1,   -1, 
          344,   -1,  346,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
          374,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  362,   10,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,  374,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,  339,  340,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   91,   -1,  351,   -1,   -1, 
           -1,   -1,  356,   -1,   -1,  359,   -1,  361,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           10,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,  359,   -1,  361,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   10,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,  339,  340,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   10,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           10,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   10,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,  264,  265,  266,   -1,   -1,   -1, 
          270,   10,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   44,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,    0,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   10,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   44,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61, 
          299,   63,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,    0, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   10, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,    0,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   10,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   44, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   59,   -1,  268,  269,   63,  271, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,  280,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   91,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,  361, 
          362,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,   -1,   91,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
            0,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           10,  362,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   91,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,  337,   -1,   91, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   10,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   59,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   59,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  281,  282,  344,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,  344,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,  362,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,  364,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,  364,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363, 
      };
   }

}
