/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.LocalVariableAllocator;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;

abstract class BaseMethodGenerator
implements MethodGenerator {
    BaseMethodGenerator() {
    }

    public void generate(AsmBuilder builder, String functionName, Function function, Signature signature) {
        ResultType resultType = InvokerUtil.getResultType(NativeRuntime.getInstance(), signature.resultType, signature.resultAnnotations, null);
        ParameterType[] parameterTypes = new ParameterType[signature.parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = InvokerUtil.getParameterType(NativeRuntime.getInstance(), signature.parameterTypes[i], signature.parameterAnnotations[i], null);
        }
        this.generate(builder, functionName, function, resultType, parameterTypes, signature.ignoreError);
    }

    public void generate(AsmBuilder builder, String functionName, Function function, ResultType resultType, ParameterType[] parameterTypes, boolean ignoreError) {
        Class[] javaParameterTypes = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            javaParameterTypes[i] = parameterTypes[i].getDeclaredType();
        }
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor().visitMethod(17, functionName, CodegenUtils.sig(resultType.getDeclaredType(), javaParameterTypes), null, null));
        mv.start();
        mv.getstatic(CodegenUtils.p(AbstractAsmLibraryInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
        mv.aload(0);
        mv.getfield(builder.getClassNamePath(), builder.getCallContextFieldName(function), CodegenUtils.ci(CallContext.class));
        mv.aload(0);
        mv.getfield(builder.getClassNamePath(), builder.getFunctionAddressFieldName(function), CodegenUtils.ci(Long.TYPE));
        LocalVariableAllocator localVariableAllocator = new LocalVariableAllocator(parameterTypes);
        this.generate(builder, mv, localVariableAllocator, function, resultType, parameterTypes, ignoreError);
        mv.visitMaxs(100, localVariableAllocator.getSpaceUsed());
        mv.visitEnd();
    }

    abstract void generate(AsmBuilder var1, SkinnyMethodAdapter var2, LocalVariableAllocator var3, Function var4, ResultType var5, ParameterType[] var6, boolean var7);

    static void loadAndConvertParameter(AsmBuilder builder, SkinnyMethodAdapter mv, LocalVariable parameter, ParameterType parameterType) {
        ToNativeConverter parameterConverter = parameterType.toNativeConverter;
        if (parameterConverter != null) {
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getToNativeConverterName(parameterConverter), CodegenUtils.ci(ToNativeConverter.class));
        }
        AsmUtil.load(mv, parameterType.getDeclaredType(), parameter);
        if (parameterConverter != null) {
            if (parameterType.getDeclaredType().isPrimitive()) {
                AsmUtil.boxValue(mv, NumberUtil.getBoxedClass(parameterType.getDeclaredType()), parameterType.getDeclaredType());
            }
            mv.aconst_null();
            mv.invokeinterface(ToNativeConverter.class, "toNative", Object.class, Object.class, ToNativeContext.class);
            mv.checkcast(CodegenUtils.p(parameterConverter.nativeType()));
        }
    }

    static void convertAndReturnResult(AsmBuilder builder, SkinnyMethodAdapter mv, ResultType resultType, Class nativeResultClass) {
        FromNativeConverter resultConverter = resultType.fromNativeConverter;
        if (resultConverter != null) {
            AsmUtil.boxValue(mv, resultConverter.nativeType(), nativeResultClass);
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getFromNativeConverterName(resultConverter), CodegenUtils.ci(FromNativeConverter.class));
            mv.swap();
            mv.aconst_null();
            mv.invokeinterface(FromNativeConverter.class, "fromNative", Object.class, Object.class, FromNativeContext.class);
            if (resultType.getDeclaredType().isPrimitive()) {
                Class boxedType = NumberUtil.getBoxedClass(resultType.getDeclaredType());
                mv.checkcast(CodegenUtils.p(boxedType));
                AsmUtil.unboxNumber(mv, boxedType, resultType.getDeclaredType(), resultType.nativeType);
                AsmUtil.emitReturnOp(mv, resultType.getDeclaredType());
            } else {
                mv.checkcast(CodegenUtils.p(resultType.getDeclaredType()));
                mv.areturn();
            }
        } else {
            AsmUtil.emitReturn(mv, resultType.getDeclaredType(), nativeResultClass);
        }
    }

    static void emitPostInvoke(AsmBuilder builder, SkinnyMethodAdapter mv, ParameterType[] parameterTypes, LocalVariable[] parameters, LocalVariable[] converted) {
        for (int i = 0; i < converted.length; ++i) {
            if (converted[i] == null) continue;
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getToNativeConverterName(parameterTypes[i].toNativeConverter), CodegenUtils.ci(ToNativeConverter.class));
            mv.checkcast(ToNativeConverter.PostInvocation.class);
            mv.aload(parameters[i]);
            mv.aload(converted[i]);
            mv.aconst_null();
            mv.invokeinterface(ToNativeConverter.PostInvocation.class, "postInvoke", Void.TYPE, Object.class, Object.class, ToNativeContext.class);
        }
    }
}

