/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

public class SmartHandle {
    private final Signature signature;
    private final MethodHandle handle;

    public SmartHandle(Signature signature, MethodHandle handle) {
        this.signature = signature;
        this.handle = handle;
    }

    public static SmartHandle findStaticQuiet(MethodHandles.Lookup lookup, Class target, String name, Signature signature) {
        try {
            return new SmartHandle(signature, lookup.findStatic(target, name, signature.type()));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    public Signature signature() {
        return this.signature;
    }

    public MethodHandle handle() {
        return this.handle;
    }

    public SmartHandle insert(int index, String name, Object arg) {
        return new SmartHandle(this.signature.insertArg(0, name, arg.getClass()), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, boolean arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Boolean.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, byte arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Byte.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, short arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Short.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, char arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Character.TYPE), MethodHandles.insertArguments(this.handle, index, Character.valueOf(arg)));
    }

    public SmartHandle insert(int index, String name, int arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Integer.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, long arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Long.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle insert(int index, String name, float arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Float.TYPE), MethodHandles.insertArguments(this.handle, index, Float.valueOf(arg)));
    }

    public SmartHandle insert(int index, String name, double arg) {
        return new SmartHandle(this.signature.insertArg(0, name, Double.TYPE), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public MethodHandle guard(MethodHandle target, MethodHandle fallback) {
        return MethodHandles.guardWithTest(this.handle, target, fallback);
    }

    public SmartHandle guard(SmartHandle target, SmartHandle fallback) {
        return new SmartHandle(target.signature, MethodHandles.guardWithTest(this.handle, target.handle, fallback.handle));
    }

    public SmartHandle bindTo(Object obj) {
        return new SmartHandle(this.signature.dropFirst(), this.handle.bindTo(obj));
    }
}

