/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Signature {
    private final MethodType methodType;
    private final String[] argNames;

    Signature(Class retval) {
        this(MethodType.methodType(retval), new String[0]);
    }

    Signature(Class retval, Class[] argTypes, String ... argNames) {
        this(MethodType.methodType(retval, argTypes), argNames);
    }

    Signature(MethodType methodType, String ... argNames) {
        assert (methodType.parameterCount() == argNames.length) : "arg name count " + argNames.length + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = argNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.argNames.length; ++i) {
            sb.append(((Class)this.methodType.parameterType(i)).getSimpleName()).append(' ').append(this.argNames[i]);
            if (i + 1 >= this.argNames.length) continue;
            sb.append(", ");
        }
        sb.append(")").append(((Class)this.methodType.returnType()).getSimpleName());
        return sb.toString();
    }

    public static Signature returning(Class retval) {
        Signature sig = new Signature(retval);
        return sig;
    }

    public Signature changeReturn(Class retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature asFold(Class retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature appendArg(String name, Class type) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        newArgNames[this.argNames.length] = name;
        MethodType newMethodType = this.methodType.appendParameterTypes(type);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature appendArgs(String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        System.arraycopy(names, 0, newArgNames, this.argNames.length, names.length);
        MethodType newMethodType = this.methodType.appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArg(String name, Class type) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 1, this.argNames.length);
        newArgNames[0] = name;
        MethodType newMethodType = this.methodType.insertParameterTypes(0, type);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArgs(String[] names, Class[] types) {
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(this.argNames, 0, newArgNames, names.length, this.argNames.length);
        System.arraycopy(names, 0, newArgNames, 0, names.length);
        MethodType newMethodType = this.methodType.insertParameterTypes(0, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArg(int index, String name, Class type) {
        return this.insertArgs(index, new String[]{name}, type);
    }

    public Signature insertArgs(int index, String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(names, 0, newArgNames, index, names.length);
        if (index != 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index);
        }
        if (this.argNames.length - index != 0) {
            System.arraycopy(this.argNames, index, newArgNames, index + names.length, this.argNames.length - index);
        }
        MethodType newMethodType = this.methodType.insertParameterTypes(index, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature dropArg(String name) {
        String[] newArgNames = new String[this.argNames.length - 1];
        MethodType newType = null;
        int j = 0;
        for (int i = 0; i < this.argNames.length; ++i) {
            if (newArgNames[i].equals(name)) {
                newType = this.methodType.dropParameterTypes(i, i + 1);
            }
            newArgNames[j++] = newArgNames[i];
        }
        if (newType == null) {
            return this;
        }
        return new Signature(newType, newArgNames);
    }

    public Signature dropLast() {
        return new Signature(this.methodType.dropParameterTypes(this.methodType.parameterCount() - 1, this.methodType.parameterCount()), Arrays.copyOfRange(this.argNames, 0, this.argNames.length - 1));
    }

    public Signature dropFirst() {
        return new Signature(this.methodType.dropParameterTypes(0, 1), Arrays.copyOfRange(this.argNames, 1, this.argNames.length));
    }

    public Signature spread(String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length - 1 + names.length];
        System.arraycopy(names, 0, newArgNames, newArgNames.length - names.length, names.length);
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length - 1);
        MethodType newMethodType = this.methodType.dropParameterTypes(this.methodType.parameterCount() - 1, this.methodType.parameterCount()).appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature spread(String ... names) {
        Class aryType = this.lastArgType();
        assert (this.lastArgType().isArray());
        Object[] newTypes = new Class[names.length];
        Arrays.fill(newTypes, aryType.getComponentType());
        return this.spread(names, (Class[])newTypes);
    }

    public Signature spread(String baseName, int count) {
        String[] spreadNames = new String[count];
        for (int i = 0; i < count; ++i) {
            spreadNames[i] = baseName + i;
        }
        return this.spread(spreadNames);
    }

    public MethodType type() {
        return this.methodType;
    }

    public String[] argNames() {
        return this.argNames;
    }

    public Class argType(int index) {
        return this.methodType.parameterType(index);
    }

    public Class lastArgType() {
        return this.argType(this.methodType.parameterCount() - 1);
    }

    public Signature permute(String ... permuteArgs) {
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names = new ArrayList<String>(this.argNames.length);
        for (String permuteArg : permuteArgs) {
            Pattern pattern = Pattern.compile(permuteArg);
            for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
                String arg = this.argNames[argOffset];
                if (!pattern.matcher(arg).find()) continue;
                types.add(this.methodType.parameterType(argOffset));
                names.add(this.argNames[argOffset]);
            }
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names.toArray(new String[0]));
    }

    public MethodHandle permuteWith(MethodHandle target, String ... permuteArgs) {
        return MethodHandles.permuteArguments(target, this.methodType, this.to(this.permute(permuteArgs)));
    }

    public SmartHandle permuteWith(SmartHandle target) {
        String[] argNames = target.signature().argNames();
        return new SmartHandle(this.permute(argNames), this.permuteWith(target.handle(), argNames));
    }

    public int[] to(Signature other) {
        return this.nonMatchingTo(other.argNames);
    }

    public int[] to(String ... otherArgPatterns) {
        return this.to(this.permute(otherArgPatterns));
    }

    private int[] nonMatchingTo(String ... otherArgNames) {
        int[] offsets = new int[otherArgNames.length];
        int i = 0;
        for (String arg : otherArgNames) {
            int pos = -1;
            for (int offset = 0; offset < this.argNames.length; ++offset) {
                if (!this.argNames[offset].equals(arg)) continue;
                pos = offset;
                break;
            }
            assert (pos >= 0) : "argument not found: \"" + arg + "\"";
            offsets[i++] = pos;
        }
        return offsets;
    }
}

