/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery --static secp256k1 '2^256 - 2^32 - 977' 32 */
/* curve description: secp256k1 */
/* requested operations: (all) */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f (from "2^256 - 2^32 - 977") */
/* machine_wordsize = 32 (from "32") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */

#include <stdint.h>
typedef unsigned char fiat_secp256k1_uint1;
typedef signed char fiat_secp256k1_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_secp256k1_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp256k1_addcarryx_u32(uint32_t* out1, fiat_secp256k1_uint1* out2, fiat_secp256k1_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1 = ((arg1 + (uint64_t)arg2) + arg3);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  fiat_secp256k1_uint1 x3 = (fiat_secp256k1_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_secp256k1_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_secp256k1_subborrowx_u32(uint32_t* out1, fiat_secp256k1_uint1* out2, fiat_secp256k1_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1 = ((arg2 - (int64_t)arg1) - arg3);
  fiat_secp256k1_int1 x2 = (fiat_secp256k1_int1)(x1 >> 32);
  uint32_t x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_secp256k1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp256k1_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_secp256k1_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1 = ((uint64_t)arg1 * arg2);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  uint32_t x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_secp256k1_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_secp256k1_cmovznz_u32(uint32_t* out1, fiat_secp256k1_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_secp256k1_uint1 x1 = (!(!arg1));
  uint32_t x2 = ((fiat_secp256k1_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  uint32_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_secp256k1_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_mul(uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[7]);
  uint32_t x8 = (arg1[0]);
  uint32_t x9;
  uint32_t x10;
  fiat_secp256k1_mulx_u32(&x9, &x10, x8, (arg2[7]));
  uint32_t x11;
  uint32_t x12;
  fiat_secp256k1_mulx_u32(&x11, &x12, x8, (arg2[6]));
  uint32_t x13;
  uint32_t x14;
  fiat_secp256k1_mulx_u32(&x13, &x14, x8, (arg2[5]));
  uint32_t x15;
  uint32_t x16;
  fiat_secp256k1_mulx_u32(&x15, &x16, x8, (arg2[4]));
  uint32_t x17;
  uint32_t x18;
  fiat_secp256k1_mulx_u32(&x17, &x18, x8, (arg2[3]));
  uint32_t x19;
  uint32_t x20;
  fiat_secp256k1_mulx_u32(&x19, &x20, x8, (arg2[2]));
  uint32_t x21;
  uint32_t x22;
  fiat_secp256k1_mulx_u32(&x21, &x22, x8, (arg2[1]));
  uint32_t x23;
  uint32_t x24;
  fiat_secp256k1_mulx_u32(&x23, &x24, x8, (arg2[0]));
  uint32_t x25;
  fiat_secp256k1_uint1 x26;
  fiat_secp256k1_addcarryx_u32(&x25, &x26, 0x0, x24, x21);
  uint32_t x27;
  fiat_secp256k1_uint1 x28;
  fiat_secp256k1_addcarryx_u32(&x27, &x28, x26, x22, x19);
  uint32_t x29;
  fiat_secp256k1_uint1 x30;
  fiat_secp256k1_addcarryx_u32(&x29, &x30, x28, x20, x17);
  uint32_t x31;
  fiat_secp256k1_uint1 x32;
  fiat_secp256k1_addcarryx_u32(&x31, &x32, x30, x18, x15);
  uint32_t x33;
  fiat_secp256k1_uint1 x34;
  fiat_secp256k1_addcarryx_u32(&x33, &x34, x32, x16, x13);
  uint32_t x35;
  fiat_secp256k1_uint1 x36;
  fiat_secp256k1_addcarryx_u32(&x35, &x36, x34, x14, x11);
  uint32_t x37;
  fiat_secp256k1_uint1 x38;
  fiat_secp256k1_addcarryx_u32(&x37, &x38, x36, x12, x9);
  uint32_t x39;
  fiat_secp256k1_uint1 x40;
  fiat_secp256k1_addcarryx_u32(&x39, &x40, x38, x10, 0x0);
  uint32_t x41;
  uint32_t x42;
  fiat_secp256k1_mulx_u32(&x41, &x42, x23, UINT32_C(0xd2253531));
  uint32_t x43;
  uint32_t x44;
  fiat_secp256k1_mulx_u32(&x43, &x44, x41, UINT32_C(0xffffffff));
  uint32_t x45;
  uint32_t x46;
  fiat_secp256k1_mulx_u32(&x45, &x46, x41, UINT32_C(0xffffffff));
  uint32_t x47;
  uint32_t x48;
  fiat_secp256k1_mulx_u32(&x47, &x48, x41, UINT32_C(0xffffffff));
  uint32_t x49;
  uint32_t x50;
  fiat_secp256k1_mulx_u32(&x49, &x50, x41, UINT32_C(0xffffffff));
  uint32_t x51;
  uint32_t x52;
  fiat_secp256k1_mulx_u32(&x51, &x52, x41, UINT32_C(0xffffffff));
  uint32_t x53;
  uint32_t x54;
  fiat_secp256k1_mulx_u32(&x53, &x54, x41, UINT32_C(0xffffffff));
  uint32_t x55;
  uint32_t x56;
  fiat_secp256k1_mulx_u32(&x55, &x56, x41, UINT32_C(0xfffffffe));
  uint32_t x57;
  uint32_t x58;
  fiat_secp256k1_mulx_u32(&x57, &x58, x41, UINT32_C(0xfffffc2f));
  uint32_t x59;
  fiat_secp256k1_uint1 x60;
  fiat_secp256k1_addcarryx_u32(&x59, &x60, 0x0, x58, x55);
  uint32_t x61;
  fiat_secp256k1_uint1 x62;
  fiat_secp256k1_addcarryx_u32(&x61, &x62, x60, x56, x53);
  uint32_t x63;
  fiat_secp256k1_uint1 x64;
  fiat_secp256k1_addcarryx_u32(&x63, &x64, x62, x54, x51);
  uint32_t x65;
  fiat_secp256k1_uint1 x66;
  fiat_secp256k1_addcarryx_u32(&x65, &x66, x64, x52, x49);
  uint32_t x67;
  fiat_secp256k1_uint1 x68;
  fiat_secp256k1_addcarryx_u32(&x67, &x68, x66, x50, x47);
  uint32_t x69;
  fiat_secp256k1_uint1 x70;
  fiat_secp256k1_addcarryx_u32(&x69, &x70, x68, x48, x45);
  uint32_t x71;
  fiat_secp256k1_uint1 x72;
  fiat_secp256k1_addcarryx_u32(&x71, &x72, x70, x46, x43);
  uint32_t x73;
  fiat_secp256k1_uint1 x74;
  fiat_secp256k1_addcarryx_u32(&x73, &x74, x72, x44, 0x0);
  uint32_t x75;
  fiat_secp256k1_uint1 x76;
  fiat_secp256k1_addcarryx_u32(&x75, &x76, 0x0, x23, x57);
  uint32_t x77;
  fiat_secp256k1_uint1 x78;
  fiat_secp256k1_addcarryx_u32(&x77, &x78, x76, x25, x59);
  uint32_t x79;
  fiat_secp256k1_uint1 x80;
  fiat_secp256k1_addcarryx_u32(&x79, &x80, x78, x27, x61);
  uint32_t x81;
  fiat_secp256k1_uint1 x82;
  fiat_secp256k1_addcarryx_u32(&x81, &x82, x80, x29, x63);
  uint32_t x83;
  fiat_secp256k1_uint1 x84;
  fiat_secp256k1_addcarryx_u32(&x83, &x84, x82, x31, x65);
  uint32_t x85;
  fiat_secp256k1_uint1 x86;
  fiat_secp256k1_addcarryx_u32(&x85, &x86, x84, x33, x67);
  uint32_t x87;
  fiat_secp256k1_uint1 x88;
  fiat_secp256k1_addcarryx_u32(&x87, &x88, x86, x35, x69);
  uint32_t x89;
  fiat_secp256k1_uint1 x90;
  fiat_secp256k1_addcarryx_u32(&x89, &x90, x88, x37, x71);
  uint32_t x91;
  fiat_secp256k1_uint1 x92;
  fiat_secp256k1_addcarryx_u32(&x91, &x92, x90, x39, x73);
  uint32_t x93;
  fiat_secp256k1_uint1 x94;
  fiat_secp256k1_addcarryx_u32(&x93, &x94, x92, 0x0, 0x0);
  uint32_t x95;
  uint32_t x96;
  fiat_secp256k1_mulx_u32(&x95, &x96, x1, (arg2[7]));
  uint32_t x97;
  uint32_t x98;
  fiat_secp256k1_mulx_u32(&x97, &x98, x1, (arg2[6]));
  uint32_t x99;
  uint32_t x100;
  fiat_secp256k1_mulx_u32(&x99, &x100, x1, (arg2[5]));
  uint32_t x101;
  uint32_t x102;
  fiat_secp256k1_mulx_u32(&x101, &x102, x1, (arg2[4]));
  uint32_t x103;
  uint32_t x104;
  fiat_secp256k1_mulx_u32(&x103, &x104, x1, (arg2[3]));
  uint32_t x105;
  uint32_t x106;
  fiat_secp256k1_mulx_u32(&x105, &x106, x1, (arg2[2]));
  uint32_t x107;
  uint32_t x108;
  fiat_secp256k1_mulx_u32(&x107, &x108, x1, (arg2[1]));
  uint32_t x109;
  uint32_t x110;
  fiat_secp256k1_mulx_u32(&x109, &x110, x1, (arg2[0]));
  uint32_t x111;
  fiat_secp256k1_uint1 x112;
  fiat_secp256k1_addcarryx_u32(&x111, &x112, 0x0, x110, x107);
  uint32_t x113;
  fiat_secp256k1_uint1 x114;
  fiat_secp256k1_addcarryx_u32(&x113, &x114, x112, x108, x105);
  uint32_t x115;
  fiat_secp256k1_uint1 x116;
  fiat_secp256k1_addcarryx_u32(&x115, &x116, x114, x106, x103);
  uint32_t x117;
  fiat_secp256k1_uint1 x118;
  fiat_secp256k1_addcarryx_u32(&x117, &x118, x116, x104, x101);
  uint32_t x119;
  fiat_secp256k1_uint1 x120;
  fiat_secp256k1_addcarryx_u32(&x119, &x120, x118, x102, x99);
  uint32_t x121;
  fiat_secp256k1_uint1 x122;
  fiat_secp256k1_addcarryx_u32(&x121, &x122, x120, x100, x97);
  uint32_t x123;
  fiat_secp256k1_uint1 x124;
  fiat_secp256k1_addcarryx_u32(&x123, &x124, x122, x98, x95);
  uint32_t x125;
  fiat_secp256k1_uint1 x126;
  fiat_secp256k1_addcarryx_u32(&x125, &x126, x124, x96, 0x0);
  uint32_t x127;
  fiat_secp256k1_uint1 x128;
  fiat_secp256k1_addcarryx_u32(&x127, &x128, 0x0, x77, x109);
  uint32_t x129;
  fiat_secp256k1_uint1 x130;
  fiat_secp256k1_addcarryx_u32(&x129, &x130, x128, x79, x111);
  uint32_t x131;
  fiat_secp256k1_uint1 x132;
  fiat_secp256k1_addcarryx_u32(&x131, &x132, x130, x81, x113);
  uint32_t x133;
  fiat_secp256k1_uint1 x134;
  fiat_secp256k1_addcarryx_u32(&x133, &x134, x132, x83, x115);
  uint32_t x135;
  fiat_secp256k1_uint1 x136;
  fiat_secp256k1_addcarryx_u32(&x135, &x136, x134, x85, x117);
  uint32_t x137;
  fiat_secp256k1_uint1 x138;
  fiat_secp256k1_addcarryx_u32(&x137, &x138, x136, x87, x119);
  uint32_t x139;
  fiat_secp256k1_uint1 x140;
  fiat_secp256k1_addcarryx_u32(&x139, &x140, x138, x89, x121);
  uint32_t x141;
  fiat_secp256k1_uint1 x142;
  fiat_secp256k1_addcarryx_u32(&x141, &x142, x140, x91, x123);
  uint32_t x143;
  fiat_secp256k1_uint1 x144;
  fiat_secp256k1_addcarryx_u32(&x143, &x144, x142, (fiat_secp256k1_uint1)x93, x125);
  uint32_t x145;
  uint32_t x146;
  fiat_secp256k1_mulx_u32(&x145, &x146, x127, UINT32_C(0xd2253531));
  uint32_t x147;
  uint32_t x148;
  fiat_secp256k1_mulx_u32(&x147, &x148, x145, UINT32_C(0xffffffff));
  uint32_t x149;
  uint32_t x150;
  fiat_secp256k1_mulx_u32(&x149, &x150, x145, UINT32_C(0xffffffff));
  uint32_t x151;
  uint32_t x152;
  fiat_secp256k1_mulx_u32(&x151, &x152, x145, UINT32_C(0xffffffff));
  uint32_t x153;
  uint32_t x154;
  fiat_secp256k1_mulx_u32(&x153, &x154, x145, UINT32_C(0xffffffff));
  uint32_t x155;
  uint32_t x156;
  fiat_secp256k1_mulx_u32(&x155, &x156, x145, UINT32_C(0xffffffff));
  uint32_t x157;
  uint32_t x158;
  fiat_secp256k1_mulx_u32(&x157, &x158, x145, UINT32_C(0xffffffff));
  uint32_t x159;
  uint32_t x160;
  fiat_secp256k1_mulx_u32(&x159, &x160, x145, UINT32_C(0xfffffffe));
  uint32_t x161;
  uint32_t x162;
  fiat_secp256k1_mulx_u32(&x161, &x162, x145, UINT32_C(0xfffffc2f));
  uint32_t x163;
  fiat_secp256k1_uint1 x164;
  fiat_secp256k1_addcarryx_u32(&x163, &x164, 0x0, x162, x159);
  uint32_t x165;
  fiat_secp256k1_uint1 x166;
  fiat_secp256k1_addcarryx_u32(&x165, &x166, x164, x160, x157);
  uint32_t x167;
  fiat_secp256k1_uint1 x168;
  fiat_secp256k1_addcarryx_u32(&x167, &x168, x166, x158, x155);
  uint32_t x169;
  fiat_secp256k1_uint1 x170;
  fiat_secp256k1_addcarryx_u32(&x169, &x170, x168, x156, x153);
  uint32_t x171;
  fiat_secp256k1_uint1 x172;
  fiat_secp256k1_addcarryx_u32(&x171, &x172, x170, x154, x151);
  uint32_t x173;
  fiat_secp256k1_uint1 x174;
  fiat_secp256k1_addcarryx_u32(&x173, &x174, x172, x152, x149);
  uint32_t x175;
  fiat_secp256k1_uint1 x176;
  fiat_secp256k1_addcarryx_u32(&x175, &x176, x174, x150, x147);
  uint32_t x177;
  fiat_secp256k1_uint1 x178;
  fiat_secp256k1_addcarryx_u32(&x177, &x178, x176, x148, 0x0);
  uint32_t x179;
  fiat_secp256k1_uint1 x180;
  fiat_secp256k1_addcarryx_u32(&x179, &x180, 0x0, x127, x161);
  uint32_t x181;
  fiat_secp256k1_uint1 x182;
  fiat_secp256k1_addcarryx_u32(&x181, &x182, x180, x129, x163);
  uint32_t x183;
  fiat_secp256k1_uint1 x184;
  fiat_secp256k1_addcarryx_u32(&x183, &x184, x182, x131, x165);
  uint32_t x185;
  fiat_secp256k1_uint1 x186;
  fiat_secp256k1_addcarryx_u32(&x185, &x186, x184, x133, x167);
  uint32_t x187;
  fiat_secp256k1_uint1 x188;
  fiat_secp256k1_addcarryx_u32(&x187, &x188, x186, x135, x169);
  uint32_t x189;
  fiat_secp256k1_uint1 x190;
  fiat_secp256k1_addcarryx_u32(&x189, &x190, x188, x137, x171);
  uint32_t x191;
  fiat_secp256k1_uint1 x192;
  fiat_secp256k1_addcarryx_u32(&x191, &x192, x190, x139, x173);
  uint32_t x193;
  fiat_secp256k1_uint1 x194;
  fiat_secp256k1_addcarryx_u32(&x193, &x194, x192, x141, x175);
  uint32_t x195;
  fiat_secp256k1_uint1 x196;
  fiat_secp256k1_addcarryx_u32(&x195, &x196, x194, x143, x177);
  uint32_t x197;
  fiat_secp256k1_uint1 x198;
  fiat_secp256k1_addcarryx_u32(&x197, &x198, x196, x144, 0x0);
  uint32_t x199;
  uint32_t x200;
  fiat_secp256k1_mulx_u32(&x199, &x200, x2, (arg2[7]));
  uint32_t x201;
  uint32_t x202;
  fiat_secp256k1_mulx_u32(&x201, &x202, x2, (arg2[6]));
  uint32_t x203;
  uint32_t x204;
  fiat_secp256k1_mulx_u32(&x203, &x204, x2, (arg2[5]));
  uint32_t x205;
  uint32_t x206;
  fiat_secp256k1_mulx_u32(&x205, &x206, x2, (arg2[4]));
  uint32_t x207;
  uint32_t x208;
  fiat_secp256k1_mulx_u32(&x207, &x208, x2, (arg2[3]));
  uint32_t x209;
  uint32_t x210;
  fiat_secp256k1_mulx_u32(&x209, &x210, x2, (arg2[2]));
  uint32_t x211;
  uint32_t x212;
  fiat_secp256k1_mulx_u32(&x211, &x212, x2, (arg2[1]));
  uint32_t x213;
  uint32_t x214;
  fiat_secp256k1_mulx_u32(&x213, &x214, x2, (arg2[0]));
  uint32_t x215;
  fiat_secp256k1_uint1 x216;
  fiat_secp256k1_addcarryx_u32(&x215, &x216, 0x0, x214, x211);
  uint32_t x217;
  fiat_secp256k1_uint1 x218;
  fiat_secp256k1_addcarryx_u32(&x217, &x218, x216, x212, x209);
  uint32_t x219;
  fiat_secp256k1_uint1 x220;
  fiat_secp256k1_addcarryx_u32(&x219, &x220, x218, x210, x207);
  uint32_t x221;
  fiat_secp256k1_uint1 x222;
  fiat_secp256k1_addcarryx_u32(&x221, &x222, x220, x208, x205);
  uint32_t x223;
  fiat_secp256k1_uint1 x224;
  fiat_secp256k1_addcarryx_u32(&x223, &x224, x222, x206, x203);
  uint32_t x225;
  fiat_secp256k1_uint1 x226;
  fiat_secp256k1_addcarryx_u32(&x225, &x226, x224, x204, x201);
  uint32_t x227;
  fiat_secp256k1_uint1 x228;
  fiat_secp256k1_addcarryx_u32(&x227, &x228, x226, x202, x199);
  uint32_t x229;
  fiat_secp256k1_uint1 x230;
  fiat_secp256k1_addcarryx_u32(&x229, &x230, x228, x200, 0x0);
  uint32_t x231;
  fiat_secp256k1_uint1 x232;
  fiat_secp256k1_addcarryx_u32(&x231, &x232, 0x0, x181, x213);
  uint32_t x233;
  fiat_secp256k1_uint1 x234;
  fiat_secp256k1_addcarryx_u32(&x233, &x234, x232, x183, x215);
  uint32_t x235;
  fiat_secp256k1_uint1 x236;
  fiat_secp256k1_addcarryx_u32(&x235, &x236, x234, x185, x217);
  uint32_t x237;
  fiat_secp256k1_uint1 x238;
  fiat_secp256k1_addcarryx_u32(&x237, &x238, x236, x187, x219);
  uint32_t x239;
  fiat_secp256k1_uint1 x240;
  fiat_secp256k1_addcarryx_u32(&x239, &x240, x238, x189, x221);
  uint32_t x241;
  fiat_secp256k1_uint1 x242;
  fiat_secp256k1_addcarryx_u32(&x241, &x242, x240, x191, x223);
  uint32_t x243;
  fiat_secp256k1_uint1 x244;
  fiat_secp256k1_addcarryx_u32(&x243, &x244, x242, x193, x225);
  uint32_t x245;
  fiat_secp256k1_uint1 x246;
  fiat_secp256k1_addcarryx_u32(&x245, &x246, x244, x195, x227);
  uint32_t x247;
  fiat_secp256k1_uint1 x248;
  fiat_secp256k1_addcarryx_u32(&x247, &x248, x246, x197, x229);
  uint32_t x249;
  uint32_t x250;
  fiat_secp256k1_mulx_u32(&x249, &x250, x231, UINT32_C(0xd2253531));
  uint32_t x251;
  uint32_t x252;
  fiat_secp256k1_mulx_u32(&x251, &x252, x249, UINT32_C(0xffffffff));
  uint32_t x253;
  uint32_t x254;
  fiat_secp256k1_mulx_u32(&x253, &x254, x249, UINT32_C(0xffffffff));
  uint32_t x255;
  uint32_t x256;
  fiat_secp256k1_mulx_u32(&x255, &x256, x249, UINT32_C(0xffffffff));
  uint32_t x257;
  uint32_t x258;
  fiat_secp256k1_mulx_u32(&x257, &x258, x249, UINT32_C(0xffffffff));
  uint32_t x259;
  uint32_t x260;
  fiat_secp256k1_mulx_u32(&x259, &x260, x249, UINT32_C(0xffffffff));
  uint32_t x261;
  uint32_t x262;
  fiat_secp256k1_mulx_u32(&x261, &x262, x249, UINT32_C(0xffffffff));
  uint32_t x263;
  uint32_t x264;
  fiat_secp256k1_mulx_u32(&x263, &x264, x249, UINT32_C(0xfffffffe));
  uint32_t x265;
  uint32_t x266;
  fiat_secp256k1_mulx_u32(&x265, &x266, x249, UINT32_C(0xfffffc2f));
  uint32_t x267;
  fiat_secp256k1_uint1 x268;
  fiat_secp256k1_addcarryx_u32(&x267, &x268, 0x0, x266, x263);
  uint32_t x269;
  fiat_secp256k1_uint1 x270;
  fiat_secp256k1_addcarryx_u32(&x269, &x270, x268, x264, x261);
  uint32_t x271;
  fiat_secp256k1_uint1 x272;
  fiat_secp256k1_addcarryx_u32(&x271, &x272, x270, x262, x259);
  uint32_t x273;
  fiat_secp256k1_uint1 x274;
  fiat_secp256k1_addcarryx_u32(&x273, &x274, x272, x260, x257);
  uint32_t x275;
  fiat_secp256k1_uint1 x276;
  fiat_secp256k1_addcarryx_u32(&x275, &x276, x274, x258, x255);
  uint32_t x277;
  fiat_secp256k1_uint1 x278;
  fiat_secp256k1_addcarryx_u32(&x277, &x278, x276, x256, x253);
  uint32_t x279;
  fiat_secp256k1_uint1 x280;
  fiat_secp256k1_addcarryx_u32(&x279, &x280, x278, x254, x251);
  uint32_t x281;
  fiat_secp256k1_uint1 x282;
  fiat_secp256k1_addcarryx_u32(&x281, &x282, x280, x252, 0x0);
  uint32_t x283;
  fiat_secp256k1_uint1 x284;
  fiat_secp256k1_addcarryx_u32(&x283, &x284, 0x0, x231, x265);
  uint32_t x285;
  fiat_secp256k1_uint1 x286;
  fiat_secp256k1_addcarryx_u32(&x285, &x286, x284, x233, x267);
  uint32_t x287;
  fiat_secp256k1_uint1 x288;
  fiat_secp256k1_addcarryx_u32(&x287, &x288, x286, x235, x269);
  uint32_t x289;
  fiat_secp256k1_uint1 x290;
  fiat_secp256k1_addcarryx_u32(&x289, &x290, x288, x237, x271);
  uint32_t x291;
  fiat_secp256k1_uint1 x292;
  fiat_secp256k1_addcarryx_u32(&x291, &x292, x290, x239, x273);
  uint32_t x293;
  fiat_secp256k1_uint1 x294;
  fiat_secp256k1_addcarryx_u32(&x293, &x294, x292, x241, x275);
  uint32_t x295;
  fiat_secp256k1_uint1 x296;
  fiat_secp256k1_addcarryx_u32(&x295, &x296, x294, x243, x277);
  uint32_t x297;
  fiat_secp256k1_uint1 x298;
  fiat_secp256k1_addcarryx_u32(&x297, &x298, x296, x245, x279);
  uint32_t x299;
  fiat_secp256k1_uint1 x300;
  fiat_secp256k1_addcarryx_u32(&x299, &x300, x298, x247, x281);
  uint32_t x301;
  fiat_secp256k1_uint1 x302;
  fiat_secp256k1_addcarryx_u32(&x301, &x302, x300, x248, 0x0);
  uint32_t x303;
  uint32_t x304;
  fiat_secp256k1_mulx_u32(&x303, &x304, x3, (arg2[7]));
  uint32_t x305;
  uint32_t x306;
  fiat_secp256k1_mulx_u32(&x305, &x306, x3, (arg2[6]));
  uint32_t x307;
  uint32_t x308;
  fiat_secp256k1_mulx_u32(&x307, &x308, x3, (arg2[5]));
  uint32_t x309;
  uint32_t x310;
  fiat_secp256k1_mulx_u32(&x309, &x310, x3, (arg2[4]));
  uint32_t x311;
  uint32_t x312;
  fiat_secp256k1_mulx_u32(&x311, &x312, x3, (arg2[3]));
  uint32_t x313;
  uint32_t x314;
  fiat_secp256k1_mulx_u32(&x313, &x314, x3, (arg2[2]));
  uint32_t x315;
  uint32_t x316;
  fiat_secp256k1_mulx_u32(&x315, &x316, x3, (arg2[1]));
  uint32_t x317;
  uint32_t x318;
  fiat_secp256k1_mulx_u32(&x317, &x318, x3, (arg2[0]));
  uint32_t x319;
  fiat_secp256k1_uint1 x320;
  fiat_secp256k1_addcarryx_u32(&x319, &x320, 0x0, x318, x315);
  uint32_t x321;
  fiat_secp256k1_uint1 x322;
  fiat_secp256k1_addcarryx_u32(&x321, &x322, x320, x316, x313);
  uint32_t x323;
  fiat_secp256k1_uint1 x324;
  fiat_secp256k1_addcarryx_u32(&x323, &x324, x322, x314, x311);
  uint32_t x325;
  fiat_secp256k1_uint1 x326;
  fiat_secp256k1_addcarryx_u32(&x325, &x326, x324, x312, x309);
  uint32_t x327;
  fiat_secp256k1_uint1 x328;
  fiat_secp256k1_addcarryx_u32(&x327, &x328, x326, x310, x307);
  uint32_t x329;
  fiat_secp256k1_uint1 x330;
  fiat_secp256k1_addcarryx_u32(&x329, &x330, x328, x308, x305);
  uint32_t x331;
  fiat_secp256k1_uint1 x332;
  fiat_secp256k1_addcarryx_u32(&x331, &x332, x330, x306, x303);
  uint32_t x333;
  fiat_secp256k1_uint1 x334;
  fiat_secp256k1_addcarryx_u32(&x333, &x334, x332, x304, 0x0);
  uint32_t x335;
  fiat_secp256k1_uint1 x336;
  fiat_secp256k1_addcarryx_u32(&x335, &x336, 0x0, x285, x317);
  uint32_t x337;
  fiat_secp256k1_uint1 x338;
  fiat_secp256k1_addcarryx_u32(&x337, &x338, x336, x287, x319);
  uint32_t x339;
  fiat_secp256k1_uint1 x340;
  fiat_secp256k1_addcarryx_u32(&x339, &x340, x338, x289, x321);
  uint32_t x341;
  fiat_secp256k1_uint1 x342;
  fiat_secp256k1_addcarryx_u32(&x341, &x342, x340, x291, x323);
  uint32_t x343;
  fiat_secp256k1_uint1 x344;
  fiat_secp256k1_addcarryx_u32(&x343, &x344, x342, x293, x325);
  uint32_t x345;
  fiat_secp256k1_uint1 x346;
  fiat_secp256k1_addcarryx_u32(&x345, &x346, x344, x295, x327);
  uint32_t x347;
  fiat_secp256k1_uint1 x348;
  fiat_secp256k1_addcarryx_u32(&x347, &x348, x346, x297, x329);
  uint32_t x349;
  fiat_secp256k1_uint1 x350;
  fiat_secp256k1_addcarryx_u32(&x349, &x350, x348, x299, x331);
  uint32_t x351;
  fiat_secp256k1_uint1 x352;
  fiat_secp256k1_addcarryx_u32(&x351, &x352, x350, x301, x333);
  uint32_t x353;
  uint32_t x354;
  fiat_secp256k1_mulx_u32(&x353, &x354, x335, UINT32_C(0xd2253531));
  uint32_t x355;
  uint32_t x356;
  fiat_secp256k1_mulx_u32(&x355, &x356, x353, UINT32_C(0xffffffff));
  uint32_t x357;
  uint32_t x358;
  fiat_secp256k1_mulx_u32(&x357, &x358, x353, UINT32_C(0xffffffff));
  uint32_t x359;
  uint32_t x360;
  fiat_secp256k1_mulx_u32(&x359, &x360, x353, UINT32_C(0xffffffff));
  uint32_t x361;
  uint32_t x362;
  fiat_secp256k1_mulx_u32(&x361, &x362, x353, UINT32_C(0xffffffff));
  uint32_t x363;
  uint32_t x364;
  fiat_secp256k1_mulx_u32(&x363, &x364, x353, UINT32_C(0xffffffff));
  uint32_t x365;
  uint32_t x366;
  fiat_secp256k1_mulx_u32(&x365, &x366, x353, UINT32_C(0xffffffff));
  uint32_t x367;
  uint32_t x368;
  fiat_secp256k1_mulx_u32(&x367, &x368, x353, UINT32_C(0xfffffffe));
  uint32_t x369;
  uint32_t x370;
  fiat_secp256k1_mulx_u32(&x369, &x370, x353, UINT32_C(0xfffffc2f));
  uint32_t x371;
  fiat_secp256k1_uint1 x372;
  fiat_secp256k1_addcarryx_u32(&x371, &x372, 0x0, x370, x367);
  uint32_t x373;
  fiat_secp256k1_uint1 x374;
  fiat_secp256k1_addcarryx_u32(&x373, &x374, x372, x368, x365);
  uint32_t x375;
  fiat_secp256k1_uint1 x376;
  fiat_secp256k1_addcarryx_u32(&x375, &x376, x374, x366, x363);
  uint32_t x377;
  fiat_secp256k1_uint1 x378;
  fiat_secp256k1_addcarryx_u32(&x377, &x378, x376, x364, x361);
  uint32_t x379;
  fiat_secp256k1_uint1 x380;
  fiat_secp256k1_addcarryx_u32(&x379, &x380, x378, x362, x359);
  uint32_t x381;
  fiat_secp256k1_uint1 x382;
  fiat_secp256k1_addcarryx_u32(&x381, &x382, x380, x360, x357);
  uint32_t x383;
  fiat_secp256k1_uint1 x384;
  fiat_secp256k1_addcarryx_u32(&x383, &x384, x382, x358, x355);
  uint32_t x385;
  fiat_secp256k1_uint1 x386;
  fiat_secp256k1_addcarryx_u32(&x385, &x386, x384, x356, 0x0);
  uint32_t x387;
  fiat_secp256k1_uint1 x388;
  fiat_secp256k1_addcarryx_u32(&x387, &x388, 0x0, x335, x369);
  uint32_t x389;
  fiat_secp256k1_uint1 x390;
  fiat_secp256k1_addcarryx_u32(&x389, &x390, x388, x337, x371);
  uint32_t x391;
  fiat_secp256k1_uint1 x392;
  fiat_secp256k1_addcarryx_u32(&x391, &x392, x390, x339, x373);
  uint32_t x393;
  fiat_secp256k1_uint1 x394;
  fiat_secp256k1_addcarryx_u32(&x393, &x394, x392, x341, x375);
  uint32_t x395;
  fiat_secp256k1_uint1 x396;
  fiat_secp256k1_addcarryx_u32(&x395, &x396, x394, x343, x377);
  uint32_t x397;
  fiat_secp256k1_uint1 x398;
  fiat_secp256k1_addcarryx_u32(&x397, &x398, x396, x345, x379);
  uint32_t x399;
  fiat_secp256k1_uint1 x400;
  fiat_secp256k1_addcarryx_u32(&x399, &x400, x398, x347, x381);
  uint32_t x401;
  fiat_secp256k1_uint1 x402;
  fiat_secp256k1_addcarryx_u32(&x401, &x402, x400, x349, x383);
  uint32_t x403;
  fiat_secp256k1_uint1 x404;
  fiat_secp256k1_addcarryx_u32(&x403, &x404, x402, x351, x385);
  uint32_t x405;
  fiat_secp256k1_uint1 x406;
  fiat_secp256k1_addcarryx_u32(&x405, &x406, x404, x352, 0x0);
  uint32_t x407;
  uint32_t x408;
  fiat_secp256k1_mulx_u32(&x407, &x408, x4, (arg2[7]));
  uint32_t x409;
  uint32_t x410;
  fiat_secp256k1_mulx_u32(&x409, &x410, x4, (arg2[6]));
  uint32_t x411;
  uint32_t x412;
  fiat_secp256k1_mulx_u32(&x411, &x412, x4, (arg2[5]));
  uint32_t x413;
  uint32_t x414;
  fiat_secp256k1_mulx_u32(&x413, &x414, x4, (arg2[4]));
  uint32_t x415;
  uint32_t x416;
  fiat_secp256k1_mulx_u32(&x415, &x416, x4, (arg2[3]));
  uint32_t x417;
  uint32_t x418;
  fiat_secp256k1_mulx_u32(&x417, &x418, x4, (arg2[2]));
  uint32_t x419;
  uint32_t x420;
  fiat_secp256k1_mulx_u32(&x419, &x420, x4, (arg2[1]));
  uint32_t x421;
  uint32_t x422;
  fiat_secp256k1_mulx_u32(&x421, &x422, x4, (arg2[0]));
  uint32_t x423;
  fiat_secp256k1_uint1 x424;
  fiat_secp256k1_addcarryx_u32(&x423, &x424, 0x0, x422, x419);
  uint32_t x425;
  fiat_secp256k1_uint1 x426;
  fiat_secp256k1_addcarryx_u32(&x425, &x426, x424, x420, x417);
  uint32_t x427;
  fiat_secp256k1_uint1 x428;
  fiat_secp256k1_addcarryx_u32(&x427, &x428, x426, x418, x415);
  uint32_t x429;
  fiat_secp256k1_uint1 x430;
  fiat_secp256k1_addcarryx_u32(&x429, &x430, x428, x416, x413);
  uint32_t x431;
  fiat_secp256k1_uint1 x432;
  fiat_secp256k1_addcarryx_u32(&x431, &x432, x430, x414, x411);
  uint32_t x433;
  fiat_secp256k1_uint1 x434;
  fiat_secp256k1_addcarryx_u32(&x433, &x434, x432, x412, x409);
  uint32_t x435;
  fiat_secp256k1_uint1 x436;
  fiat_secp256k1_addcarryx_u32(&x435, &x436, x434, x410, x407);
  uint32_t x437;
  fiat_secp256k1_uint1 x438;
  fiat_secp256k1_addcarryx_u32(&x437, &x438, x436, x408, 0x0);
  uint32_t x439;
  fiat_secp256k1_uint1 x440;
  fiat_secp256k1_addcarryx_u32(&x439, &x440, 0x0, x389, x421);
  uint32_t x441;
  fiat_secp256k1_uint1 x442;
  fiat_secp256k1_addcarryx_u32(&x441, &x442, x440, x391, x423);
  uint32_t x443;
  fiat_secp256k1_uint1 x444;
  fiat_secp256k1_addcarryx_u32(&x443, &x444, x442, x393, x425);
  uint32_t x445;
  fiat_secp256k1_uint1 x446;
  fiat_secp256k1_addcarryx_u32(&x445, &x446, x444, x395, x427);
  uint32_t x447;
  fiat_secp256k1_uint1 x448;
  fiat_secp256k1_addcarryx_u32(&x447, &x448, x446, x397, x429);
  uint32_t x449;
  fiat_secp256k1_uint1 x450;
  fiat_secp256k1_addcarryx_u32(&x449, &x450, x448, x399, x431);
  uint32_t x451;
  fiat_secp256k1_uint1 x452;
  fiat_secp256k1_addcarryx_u32(&x451, &x452, x450, x401, x433);
  uint32_t x453;
  fiat_secp256k1_uint1 x454;
  fiat_secp256k1_addcarryx_u32(&x453, &x454, x452, x403, x435);
  uint32_t x455;
  fiat_secp256k1_uint1 x456;
  fiat_secp256k1_addcarryx_u32(&x455, &x456, x454, x405, x437);
  uint32_t x457;
  uint32_t x458;
  fiat_secp256k1_mulx_u32(&x457, &x458, x439, UINT32_C(0xd2253531));
  uint32_t x459;
  uint32_t x460;
  fiat_secp256k1_mulx_u32(&x459, &x460, x457, UINT32_C(0xffffffff));
  uint32_t x461;
  uint32_t x462;
  fiat_secp256k1_mulx_u32(&x461, &x462, x457, UINT32_C(0xffffffff));
  uint32_t x463;
  uint32_t x464;
  fiat_secp256k1_mulx_u32(&x463, &x464, x457, UINT32_C(0xffffffff));
  uint32_t x465;
  uint32_t x466;
  fiat_secp256k1_mulx_u32(&x465, &x466, x457, UINT32_C(0xffffffff));
  uint32_t x467;
  uint32_t x468;
  fiat_secp256k1_mulx_u32(&x467, &x468, x457, UINT32_C(0xffffffff));
  uint32_t x469;
  uint32_t x470;
  fiat_secp256k1_mulx_u32(&x469, &x470, x457, UINT32_C(0xffffffff));
  uint32_t x471;
  uint32_t x472;
  fiat_secp256k1_mulx_u32(&x471, &x472, x457, UINT32_C(0xfffffffe));
  uint32_t x473;
  uint32_t x474;
  fiat_secp256k1_mulx_u32(&x473, &x474, x457, UINT32_C(0xfffffc2f));
  uint32_t x475;
  fiat_secp256k1_uint1 x476;
  fiat_secp256k1_addcarryx_u32(&x475, &x476, 0x0, x474, x471);
  uint32_t x477;
  fiat_secp256k1_uint1 x478;
  fiat_secp256k1_addcarryx_u32(&x477, &x478, x476, x472, x469);
  uint32_t x479;
  fiat_secp256k1_uint1 x480;
  fiat_secp256k1_addcarryx_u32(&x479, &x480, x478, x470, x467);
  uint32_t x481;
  fiat_secp256k1_uint1 x482;
  fiat_secp256k1_addcarryx_u32(&x481, &x482, x480, x468, x465);
  uint32_t x483;
  fiat_secp256k1_uint1 x484;
  fiat_secp256k1_addcarryx_u32(&x483, &x484, x482, x466, x463);
  uint32_t x485;
  fiat_secp256k1_uint1 x486;
  fiat_secp256k1_addcarryx_u32(&x485, &x486, x484, x464, x461);
  uint32_t x487;
  fiat_secp256k1_uint1 x488;
  fiat_secp256k1_addcarryx_u32(&x487, &x488, x486, x462, x459);
  uint32_t x489;
  fiat_secp256k1_uint1 x490;
  fiat_secp256k1_addcarryx_u32(&x489, &x490, x488, x460, 0x0);
  uint32_t x491;
  fiat_secp256k1_uint1 x492;
  fiat_secp256k1_addcarryx_u32(&x491, &x492, 0x0, x439, x473);
  uint32_t x493;
  fiat_secp256k1_uint1 x494;
  fiat_secp256k1_addcarryx_u32(&x493, &x494, x492, x441, x475);
  uint32_t x495;
  fiat_secp256k1_uint1 x496;
  fiat_secp256k1_addcarryx_u32(&x495, &x496, x494, x443, x477);
  uint32_t x497;
  fiat_secp256k1_uint1 x498;
  fiat_secp256k1_addcarryx_u32(&x497, &x498, x496, x445, x479);
  uint32_t x499;
  fiat_secp256k1_uint1 x500;
  fiat_secp256k1_addcarryx_u32(&x499, &x500, x498, x447, x481);
  uint32_t x501;
  fiat_secp256k1_uint1 x502;
  fiat_secp256k1_addcarryx_u32(&x501, &x502, x500, x449, x483);
  uint32_t x503;
  fiat_secp256k1_uint1 x504;
  fiat_secp256k1_addcarryx_u32(&x503, &x504, x502, x451, x485);
  uint32_t x505;
  fiat_secp256k1_uint1 x506;
  fiat_secp256k1_addcarryx_u32(&x505, &x506, x504, x453, x487);
  uint32_t x507;
  fiat_secp256k1_uint1 x508;
  fiat_secp256k1_addcarryx_u32(&x507, &x508, x506, x455, x489);
  uint32_t x509;
  fiat_secp256k1_uint1 x510;
  fiat_secp256k1_addcarryx_u32(&x509, &x510, x508, x456, 0x0);
  uint32_t x511;
  uint32_t x512;
  fiat_secp256k1_mulx_u32(&x511, &x512, x5, (arg2[7]));
  uint32_t x513;
  uint32_t x514;
  fiat_secp256k1_mulx_u32(&x513, &x514, x5, (arg2[6]));
  uint32_t x515;
  uint32_t x516;
  fiat_secp256k1_mulx_u32(&x515, &x516, x5, (arg2[5]));
  uint32_t x517;
  uint32_t x518;
  fiat_secp256k1_mulx_u32(&x517, &x518, x5, (arg2[4]));
  uint32_t x519;
  uint32_t x520;
  fiat_secp256k1_mulx_u32(&x519, &x520, x5, (arg2[3]));
  uint32_t x521;
  uint32_t x522;
  fiat_secp256k1_mulx_u32(&x521, &x522, x5, (arg2[2]));
  uint32_t x523;
  uint32_t x524;
  fiat_secp256k1_mulx_u32(&x523, &x524, x5, (arg2[1]));
  uint32_t x525;
  uint32_t x526;
  fiat_secp256k1_mulx_u32(&x525, &x526, x5, (arg2[0]));
  uint32_t x527;
  fiat_secp256k1_uint1 x528;
  fiat_secp256k1_addcarryx_u32(&x527, &x528, 0x0, x526, x523);
  uint32_t x529;
  fiat_secp256k1_uint1 x530;
  fiat_secp256k1_addcarryx_u32(&x529, &x530, x528, x524, x521);
  uint32_t x531;
  fiat_secp256k1_uint1 x532;
  fiat_secp256k1_addcarryx_u32(&x531, &x532, x530, x522, x519);
  uint32_t x533;
  fiat_secp256k1_uint1 x534;
  fiat_secp256k1_addcarryx_u32(&x533, &x534, x532, x520, x517);
  uint32_t x535;
  fiat_secp256k1_uint1 x536;
  fiat_secp256k1_addcarryx_u32(&x535, &x536, x534, x518, x515);
  uint32_t x537;
  fiat_secp256k1_uint1 x538;
  fiat_secp256k1_addcarryx_u32(&x537, &x538, x536, x516, x513);
  uint32_t x539;
  fiat_secp256k1_uint1 x540;
  fiat_secp256k1_addcarryx_u32(&x539, &x540, x538, x514, x511);
  uint32_t x541;
  fiat_secp256k1_uint1 x542;
  fiat_secp256k1_addcarryx_u32(&x541, &x542, x540, x512, 0x0);
  uint32_t x543;
  fiat_secp256k1_uint1 x544;
  fiat_secp256k1_addcarryx_u32(&x543, &x544, 0x0, x493, x525);
  uint32_t x545;
  fiat_secp256k1_uint1 x546;
  fiat_secp256k1_addcarryx_u32(&x545, &x546, x544, x495, x527);
  uint32_t x547;
  fiat_secp256k1_uint1 x548;
  fiat_secp256k1_addcarryx_u32(&x547, &x548, x546, x497, x529);
  uint32_t x549;
  fiat_secp256k1_uint1 x550;
  fiat_secp256k1_addcarryx_u32(&x549, &x550, x548, x499, x531);
  uint32_t x551;
  fiat_secp256k1_uint1 x552;
  fiat_secp256k1_addcarryx_u32(&x551, &x552, x550, x501, x533);
  uint32_t x553;
  fiat_secp256k1_uint1 x554;
  fiat_secp256k1_addcarryx_u32(&x553, &x554, x552, x503, x535);
  uint32_t x555;
  fiat_secp256k1_uint1 x556;
  fiat_secp256k1_addcarryx_u32(&x555, &x556, x554, x505, x537);
  uint32_t x557;
  fiat_secp256k1_uint1 x558;
  fiat_secp256k1_addcarryx_u32(&x557, &x558, x556, x507, x539);
  uint32_t x559;
  fiat_secp256k1_uint1 x560;
  fiat_secp256k1_addcarryx_u32(&x559, &x560, x558, x509, x541);
  uint32_t x561;
  uint32_t x562;
  fiat_secp256k1_mulx_u32(&x561, &x562, x543, UINT32_C(0xd2253531));
  uint32_t x563;
  uint32_t x564;
  fiat_secp256k1_mulx_u32(&x563, &x564, x561, UINT32_C(0xffffffff));
  uint32_t x565;
  uint32_t x566;
  fiat_secp256k1_mulx_u32(&x565, &x566, x561, UINT32_C(0xffffffff));
  uint32_t x567;
  uint32_t x568;
  fiat_secp256k1_mulx_u32(&x567, &x568, x561, UINT32_C(0xffffffff));
  uint32_t x569;
  uint32_t x570;
  fiat_secp256k1_mulx_u32(&x569, &x570, x561, UINT32_C(0xffffffff));
  uint32_t x571;
  uint32_t x572;
  fiat_secp256k1_mulx_u32(&x571, &x572, x561, UINT32_C(0xffffffff));
  uint32_t x573;
  uint32_t x574;
  fiat_secp256k1_mulx_u32(&x573, &x574, x561, UINT32_C(0xffffffff));
  uint32_t x575;
  uint32_t x576;
  fiat_secp256k1_mulx_u32(&x575, &x576, x561, UINT32_C(0xfffffffe));
  uint32_t x577;
  uint32_t x578;
  fiat_secp256k1_mulx_u32(&x577, &x578, x561, UINT32_C(0xfffffc2f));
  uint32_t x579;
  fiat_secp256k1_uint1 x580;
  fiat_secp256k1_addcarryx_u32(&x579, &x580, 0x0, x578, x575);
  uint32_t x581;
  fiat_secp256k1_uint1 x582;
  fiat_secp256k1_addcarryx_u32(&x581, &x582, x580, x576, x573);
  uint32_t x583;
  fiat_secp256k1_uint1 x584;
  fiat_secp256k1_addcarryx_u32(&x583, &x584, x582, x574, x571);
  uint32_t x585;
  fiat_secp256k1_uint1 x586;
  fiat_secp256k1_addcarryx_u32(&x585, &x586, x584, x572, x569);
  uint32_t x587;
  fiat_secp256k1_uint1 x588;
  fiat_secp256k1_addcarryx_u32(&x587, &x588, x586, x570, x567);
  uint32_t x589;
  fiat_secp256k1_uint1 x590;
  fiat_secp256k1_addcarryx_u32(&x589, &x590, x588, x568, x565);
  uint32_t x591;
  fiat_secp256k1_uint1 x592;
  fiat_secp256k1_addcarryx_u32(&x591, &x592, x590, x566, x563);
  uint32_t x593;
  fiat_secp256k1_uint1 x594;
  fiat_secp256k1_addcarryx_u32(&x593, &x594, x592, x564, 0x0);
  uint32_t x595;
  fiat_secp256k1_uint1 x596;
  fiat_secp256k1_addcarryx_u32(&x595, &x596, 0x0, x543, x577);
  uint32_t x597;
  fiat_secp256k1_uint1 x598;
  fiat_secp256k1_addcarryx_u32(&x597, &x598, x596, x545, x579);
  uint32_t x599;
  fiat_secp256k1_uint1 x600;
  fiat_secp256k1_addcarryx_u32(&x599, &x600, x598, x547, x581);
  uint32_t x601;
  fiat_secp256k1_uint1 x602;
  fiat_secp256k1_addcarryx_u32(&x601, &x602, x600, x549, x583);
  uint32_t x603;
  fiat_secp256k1_uint1 x604;
  fiat_secp256k1_addcarryx_u32(&x603, &x604, x602, x551, x585);
  uint32_t x605;
  fiat_secp256k1_uint1 x606;
  fiat_secp256k1_addcarryx_u32(&x605, &x606, x604, x553, x587);
  uint32_t x607;
  fiat_secp256k1_uint1 x608;
  fiat_secp256k1_addcarryx_u32(&x607, &x608, x606, x555, x589);
  uint32_t x609;
  fiat_secp256k1_uint1 x610;
  fiat_secp256k1_addcarryx_u32(&x609, &x610, x608, x557, x591);
  uint32_t x611;
  fiat_secp256k1_uint1 x612;
  fiat_secp256k1_addcarryx_u32(&x611, &x612, x610, x559, x593);
  uint32_t x613;
  fiat_secp256k1_uint1 x614;
  fiat_secp256k1_addcarryx_u32(&x613, &x614, x612, x560, 0x0);
  uint32_t x615;
  uint32_t x616;
  fiat_secp256k1_mulx_u32(&x615, &x616, x6, (arg2[7]));
  uint32_t x617;
  uint32_t x618;
  fiat_secp256k1_mulx_u32(&x617, &x618, x6, (arg2[6]));
  uint32_t x619;
  uint32_t x620;
  fiat_secp256k1_mulx_u32(&x619, &x620, x6, (arg2[5]));
  uint32_t x621;
  uint32_t x622;
  fiat_secp256k1_mulx_u32(&x621, &x622, x6, (arg2[4]));
  uint32_t x623;
  uint32_t x624;
  fiat_secp256k1_mulx_u32(&x623, &x624, x6, (arg2[3]));
  uint32_t x625;
  uint32_t x626;
  fiat_secp256k1_mulx_u32(&x625, &x626, x6, (arg2[2]));
  uint32_t x627;
  uint32_t x628;
  fiat_secp256k1_mulx_u32(&x627, &x628, x6, (arg2[1]));
  uint32_t x629;
  uint32_t x630;
  fiat_secp256k1_mulx_u32(&x629, &x630, x6, (arg2[0]));
  uint32_t x631;
  fiat_secp256k1_uint1 x632;
  fiat_secp256k1_addcarryx_u32(&x631, &x632, 0x0, x630, x627);
  uint32_t x633;
  fiat_secp256k1_uint1 x634;
  fiat_secp256k1_addcarryx_u32(&x633, &x634, x632, x628, x625);
  uint32_t x635;
  fiat_secp256k1_uint1 x636;
  fiat_secp256k1_addcarryx_u32(&x635, &x636, x634, x626, x623);
  uint32_t x637;
  fiat_secp256k1_uint1 x638;
  fiat_secp256k1_addcarryx_u32(&x637, &x638, x636, x624, x621);
  uint32_t x639;
  fiat_secp256k1_uint1 x640;
  fiat_secp256k1_addcarryx_u32(&x639, &x640, x638, x622, x619);
  uint32_t x641;
  fiat_secp256k1_uint1 x642;
  fiat_secp256k1_addcarryx_u32(&x641, &x642, x640, x620, x617);
  uint32_t x643;
  fiat_secp256k1_uint1 x644;
  fiat_secp256k1_addcarryx_u32(&x643, &x644, x642, x618, x615);
  uint32_t x645;
  fiat_secp256k1_uint1 x646;
  fiat_secp256k1_addcarryx_u32(&x645, &x646, x644, x616, 0x0);
  uint32_t x647;
  fiat_secp256k1_uint1 x648;
  fiat_secp256k1_addcarryx_u32(&x647, &x648, 0x0, x597, x629);
  uint32_t x649;
  fiat_secp256k1_uint1 x650;
  fiat_secp256k1_addcarryx_u32(&x649, &x650, x648, x599, x631);
  uint32_t x651;
  fiat_secp256k1_uint1 x652;
  fiat_secp256k1_addcarryx_u32(&x651, &x652, x650, x601, x633);
  uint32_t x653;
  fiat_secp256k1_uint1 x654;
  fiat_secp256k1_addcarryx_u32(&x653, &x654, x652, x603, x635);
  uint32_t x655;
  fiat_secp256k1_uint1 x656;
  fiat_secp256k1_addcarryx_u32(&x655, &x656, x654, x605, x637);
  uint32_t x657;
  fiat_secp256k1_uint1 x658;
  fiat_secp256k1_addcarryx_u32(&x657, &x658, x656, x607, x639);
  uint32_t x659;
  fiat_secp256k1_uint1 x660;
  fiat_secp256k1_addcarryx_u32(&x659, &x660, x658, x609, x641);
  uint32_t x661;
  fiat_secp256k1_uint1 x662;
  fiat_secp256k1_addcarryx_u32(&x661, &x662, x660, x611, x643);
  uint32_t x663;
  fiat_secp256k1_uint1 x664;
  fiat_secp256k1_addcarryx_u32(&x663, &x664, x662, x613, x645);
  uint32_t x665;
  uint32_t x666;
  fiat_secp256k1_mulx_u32(&x665, &x666, x647, UINT32_C(0xd2253531));
  uint32_t x667;
  uint32_t x668;
  fiat_secp256k1_mulx_u32(&x667, &x668, x665, UINT32_C(0xffffffff));
  uint32_t x669;
  uint32_t x670;
  fiat_secp256k1_mulx_u32(&x669, &x670, x665, UINT32_C(0xffffffff));
  uint32_t x671;
  uint32_t x672;
  fiat_secp256k1_mulx_u32(&x671, &x672, x665, UINT32_C(0xffffffff));
  uint32_t x673;
  uint32_t x674;
  fiat_secp256k1_mulx_u32(&x673, &x674, x665, UINT32_C(0xffffffff));
  uint32_t x675;
  uint32_t x676;
  fiat_secp256k1_mulx_u32(&x675, &x676, x665, UINT32_C(0xffffffff));
  uint32_t x677;
  uint32_t x678;
  fiat_secp256k1_mulx_u32(&x677, &x678, x665, UINT32_C(0xffffffff));
  uint32_t x679;
  uint32_t x680;
  fiat_secp256k1_mulx_u32(&x679, &x680, x665, UINT32_C(0xfffffffe));
  uint32_t x681;
  uint32_t x682;
  fiat_secp256k1_mulx_u32(&x681, &x682, x665, UINT32_C(0xfffffc2f));
  uint32_t x683;
  fiat_secp256k1_uint1 x684;
  fiat_secp256k1_addcarryx_u32(&x683, &x684, 0x0, x682, x679);
  uint32_t x685;
  fiat_secp256k1_uint1 x686;
  fiat_secp256k1_addcarryx_u32(&x685, &x686, x684, x680, x677);
  uint32_t x687;
  fiat_secp256k1_uint1 x688;
  fiat_secp256k1_addcarryx_u32(&x687, &x688, x686, x678, x675);
  uint32_t x689;
  fiat_secp256k1_uint1 x690;
  fiat_secp256k1_addcarryx_u32(&x689, &x690, x688, x676, x673);
  uint32_t x691;
  fiat_secp256k1_uint1 x692;
  fiat_secp256k1_addcarryx_u32(&x691, &x692, x690, x674, x671);
  uint32_t x693;
  fiat_secp256k1_uint1 x694;
  fiat_secp256k1_addcarryx_u32(&x693, &x694, x692, x672, x669);
  uint32_t x695;
  fiat_secp256k1_uint1 x696;
  fiat_secp256k1_addcarryx_u32(&x695, &x696, x694, x670, x667);
  uint32_t x697;
  fiat_secp256k1_uint1 x698;
  fiat_secp256k1_addcarryx_u32(&x697, &x698, x696, x668, 0x0);
  uint32_t x699;
  fiat_secp256k1_uint1 x700;
  fiat_secp256k1_addcarryx_u32(&x699, &x700, 0x0, x647, x681);
  uint32_t x701;
  fiat_secp256k1_uint1 x702;
  fiat_secp256k1_addcarryx_u32(&x701, &x702, x700, x649, x683);
  uint32_t x703;
  fiat_secp256k1_uint1 x704;
  fiat_secp256k1_addcarryx_u32(&x703, &x704, x702, x651, x685);
  uint32_t x705;
  fiat_secp256k1_uint1 x706;
  fiat_secp256k1_addcarryx_u32(&x705, &x706, x704, x653, x687);
  uint32_t x707;
  fiat_secp256k1_uint1 x708;
  fiat_secp256k1_addcarryx_u32(&x707, &x708, x706, x655, x689);
  uint32_t x709;
  fiat_secp256k1_uint1 x710;
  fiat_secp256k1_addcarryx_u32(&x709, &x710, x708, x657, x691);
  uint32_t x711;
  fiat_secp256k1_uint1 x712;
  fiat_secp256k1_addcarryx_u32(&x711, &x712, x710, x659, x693);
  uint32_t x713;
  fiat_secp256k1_uint1 x714;
  fiat_secp256k1_addcarryx_u32(&x713, &x714, x712, x661, x695);
  uint32_t x715;
  fiat_secp256k1_uint1 x716;
  fiat_secp256k1_addcarryx_u32(&x715, &x716, x714, x663, x697);
  uint32_t x717;
  fiat_secp256k1_uint1 x718;
  fiat_secp256k1_addcarryx_u32(&x717, &x718, x716, x664, 0x0);
  uint32_t x719;
  uint32_t x720;
  fiat_secp256k1_mulx_u32(&x719, &x720, x7, (arg2[7]));
  uint32_t x721;
  uint32_t x722;
  fiat_secp256k1_mulx_u32(&x721, &x722, x7, (arg2[6]));
  uint32_t x723;
  uint32_t x724;
  fiat_secp256k1_mulx_u32(&x723, &x724, x7, (arg2[5]));
  uint32_t x725;
  uint32_t x726;
  fiat_secp256k1_mulx_u32(&x725, &x726, x7, (arg2[4]));
  uint32_t x727;
  uint32_t x728;
  fiat_secp256k1_mulx_u32(&x727, &x728, x7, (arg2[3]));
  uint32_t x729;
  uint32_t x730;
  fiat_secp256k1_mulx_u32(&x729, &x730, x7, (arg2[2]));
  uint32_t x731;
  uint32_t x732;
  fiat_secp256k1_mulx_u32(&x731, &x732, x7, (arg2[1]));
  uint32_t x733;
  uint32_t x734;
  fiat_secp256k1_mulx_u32(&x733, &x734, x7, (arg2[0]));
  uint32_t x735;
  fiat_secp256k1_uint1 x736;
  fiat_secp256k1_addcarryx_u32(&x735, &x736, 0x0, x734, x731);
  uint32_t x737;
  fiat_secp256k1_uint1 x738;
  fiat_secp256k1_addcarryx_u32(&x737, &x738, x736, x732, x729);
  uint32_t x739;
  fiat_secp256k1_uint1 x740;
  fiat_secp256k1_addcarryx_u32(&x739, &x740, x738, x730, x727);
  uint32_t x741;
  fiat_secp256k1_uint1 x742;
  fiat_secp256k1_addcarryx_u32(&x741, &x742, x740, x728, x725);
  uint32_t x743;
  fiat_secp256k1_uint1 x744;
  fiat_secp256k1_addcarryx_u32(&x743, &x744, x742, x726, x723);
  uint32_t x745;
  fiat_secp256k1_uint1 x746;
  fiat_secp256k1_addcarryx_u32(&x745, &x746, x744, x724, x721);
  uint32_t x747;
  fiat_secp256k1_uint1 x748;
  fiat_secp256k1_addcarryx_u32(&x747, &x748, x746, x722, x719);
  uint32_t x749;
  fiat_secp256k1_uint1 x750;
  fiat_secp256k1_addcarryx_u32(&x749, &x750, x748, x720, 0x0);
  uint32_t x751;
  fiat_secp256k1_uint1 x752;
  fiat_secp256k1_addcarryx_u32(&x751, &x752, 0x0, x701, x733);
  uint32_t x753;
  fiat_secp256k1_uint1 x754;
  fiat_secp256k1_addcarryx_u32(&x753, &x754, x752, x703, x735);
  uint32_t x755;
  fiat_secp256k1_uint1 x756;
  fiat_secp256k1_addcarryx_u32(&x755, &x756, x754, x705, x737);
  uint32_t x757;
  fiat_secp256k1_uint1 x758;
  fiat_secp256k1_addcarryx_u32(&x757, &x758, x756, x707, x739);
  uint32_t x759;
  fiat_secp256k1_uint1 x760;
  fiat_secp256k1_addcarryx_u32(&x759, &x760, x758, x709, x741);
  uint32_t x761;
  fiat_secp256k1_uint1 x762;
  fiat_secp256k1_addcarryx_u32(&x761, &x762, x760, x711, x743);
  uint32_t x763;
  fiat_secp256k1_uint1 x764;
  fiat_secp256k1_addcarryx_u32(&x763, &x764, x762, x713, x745);
  uint32_t x765;
  fiat_secp256k1_uint1 x766;
  fiat_secp256k1_addcarryx_u32(&x765, &x766, x764, x715, x747);
  uint32_t x767;
  fiat_secp256k1_uint1 x768;
  fiat_secp256k1_addcarryx_u32(&x767, &x768, x766, x717, x749);
  uint32_t x769;
  uint32_t x770;
  fiat_secp256k1_mulx_u32(&x769, &x770, x751, UINT32_C(0xd2253531));
  uint32_t x771;
  uint32_t x772;
  fiat_secp256k1_mulx_u32(&x771, &x772, x769, UINT32_C(0xffffffff));
  uint32_t x773;
  uint32_t x774;
  fiat_secp256k1_mulx_u32(&x773, &x774, x769, UINT32_C(0xffffffff));
  uint32_t x775;
  uint32_t x776;
  fiat_secp256k1_mulx_u32(&x775, &x776, x769, UINT32_C(0xffffffff));
  uint32_t x777;
  uint32_t x778;
  fiat_secp256k1_mulx_u32(&x777, &x778, x769, UINT32_C(0xffffffff));
  uint32_t x779;
  uint32_t x780;
  fiat_secp256k1_mulx_u32(&x779, &x780, x769, UINT32_C(0xffffffff));
  uint32_t x781;
  uint32_t x782;
  fiat_secp256k1_mulx_u32(&x781, &x782, x769, UINT32_C(0xffffffff));
  uint32_t x783;
  uint32_t x784;
  fiat_secp256k1_mulx_u32(&x783, &x784, x769, UINT32_C(0xfffffffe));
  uint32_t x785;
  uint32_t x786;
  fiat_secp256k1_mulx_u32(&x785, &x786, x769, UINT32_C(0xfffffc2f));
  uint32_t x787;
  fiat_secp256k1_uint1 x788;
  fiat_secp256k1_addcarryx_u32(&x787, &x788, 0x0, x786, x783);
  uint32_t x789;
  fiat_secp256k1_uint1 x790;
  fiat_secp256k1_addcarryx_u32(&x789, &x790, x788, x784, x781);
  uint32_t x791;
  fiat_secp256k1_uint1 x792;
  fiat_secp256k1_addcarryx_u32(&x791, &x792, x790, x782, x779);
  uint32_t x793;
  fiat_secp256k1_uint1 x794;
  fiat_secp256k1_addcarryx_u32(&x793, &x794, x792, x780, x777);
  uint32_t x795;
  fiat_secp256k1_uint1 x796;
  fiat_secp256k1_addcarryx_u32(&x795, &x796, x794, x778, x775);
  uint32_t x797;
  fiat_secp256k1_uint1 x798;
  fiat_secp256k1_addcarryx_u32(&x797, &x798, x796, x776, x773);
  uint32_t x799;
  fiat_secp256k1_uint1 x800;
  fiat_secp256k1_addcarryx_u32(&x799, &x800, x798, x774, x771);
  uint32_t x801;
  fiat_secp256k1_uint1 x802;
  fiat_secp256k1_addcarryx_u32(&x801, &x802, x800, x772, 0x0);
  uint32_t x803;
  fiat_secp256k1_uint1 x804;
  fiat_secp256k1_addcarryx_u32(&x803, &x804, 0x0, x751, x785);
  uint32_t x805;
  fiat_secp256k1_uint1 x806;
  fiat_secp256k1_addcarryx_u32(&x805, &x806, x804, x753, x787);
  uint32_t x807;
  fiat_secp256k1_uint1 x808;
  fiat_secp256k1_addcarryx_u32(&x807, &x808, x806, x755, x789);
  uint32_t x809;
  fiat_secp256k1_uint1 x810;
  fiat_secp256k1_addcarryx_u32(&x809, &x810, x808, x757, x791);
  uint32_t x811;
  fiat_secp256k1_uint1 x812;
  fiat_secp256k1_addcarryx_u32(&x811, &x812, x810, x759, x793);
  uint32_t x813;
  fiat_secp256k1_uint1 x814;
  fiat_secp256k1_addcarryx_u32(&x813, &x814, x812, x761, x795);
  uint32_t x815;
  fiat_secp256k1_uint1 x816;
  fiat_secp256k1_addcarryx_u32(&x815, &x816, x814, x763, x797);
  uint32_t x817;
  fiat_secp256k1_uint1 x818;
  fiat_secp256k1_addcarryx_u32(&x817, &x818, x816, x765, x799);
  uint32_t x819;
  fiat_secp256k1_uint1 x820;
  fiat_secp256k1_addcarryx_u32(&x819, &x820, x818, x767, x801);
  uint32_t x821;
  fiat_secp256k1_uint1 x822;
  fiat_secp256k1_addcarryx_u32(&x821, &x822, x820, x768, 0x0);
  uint32_t x823;
  fiat_secp256k1_uint1 x824;
  fiat_secp256k1_subborrowx_u32(&x823, &x824, 0x0, x805, UINT32_C(0xfffffc2f));
  uint32_t x825;
  fiat_secp256k1_uint1 x826;
  fiat_secp256k1_subborrowx_u32(&x825, &x826, x824, x807, UINT32_C(0xfffffffe));
  uint32_t x827;
  fiat_secp256k1_uint1 x828;
  fiat_secp256k1_subborrowx_u32(&x827, &x828, x826, x809, UINT32_C(0xffffffff));
  uint32_t x829;
  fiat_secp256k1_uint1 x830;
  fiat_secp256k1_subborrowx_u32(&x829, &x830, x828, x811, UINT32_C(0xffffffff));
  uint32_t x831;
  fiat_secp256k1_uint1 x832;
  fiat_secp256k1_subborrowx_u32(&x831, &x832, x830, x813, UINT32_C(0xffffffff));
  uint32_t x833;
  fiat_secp256k1_uint1 x834;
  fiat_secp256k1_subborrowx_u32(&x833, &x834, x832, x815, UINT32_C(0xffffffff));
  uint32_t x835;
  fiat_secp256k1_uint1 x836;
  fiat_secp256k1_subborrowx_u32(&x835, &x836, x834, x817, UINT32_C(0xffffffff));
  uint32_t x837;
  fiat_secp256k1_uint1 x838;
  fiat_secp256k1_subborrowx_u32(&x837, &x838, x836, x819, UINT32_C(0xffffffff));
  uint32_t x839;
  fiat_secp256k1_uint1 x840;
  fiat_secp256k1_subborrowx_u32(&x839, &x840, x838, x821, 0x0);
  uint32_t x841;
  fiat_secp256k1_cmovznz_u32(&x841, x840, x823, x805);
  uint32_t x842;
  fiat_secp256k1_cmovznz_u32(&x842, x840, x825, x807);
  uint32_t x843;
  fiat_secp256k1_cmovznz_u32(&x843, x840, x827, x809);
  uint32_t x844;
  fiat_secp256k1_cmovznz_u32(&x844, x840, x829, x811);
  uint32_t x845;
  fiat_secp256k1_cmovznz_u32(&x845, x840, x831, x813);
  uint32_t x846;
  fiat_secp256k1_cmovznz_u32(&x846, x840, x833, x815);
  uint32_t x847;
  fiat_secp256k1_cmovznz_u32(&x847, x840, x835, x817);
  uint32_t x848;
  fiat_secp256k1_cmovznz_u32(&x848, x840, x837, x819);
  out1[0] = x841;
  out1[1] = x842;
  out1[2] = x843;
  out1[3] = x844;
  out1[4] = x845;
  out1[5] = x846;
  out1[6] = x847;
  out1[7] = x848;
}

/*
 * The function fiat_secp256k1_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_square(uint32_t out1[8], const uint32_t arg1[8]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[7]);
  uint32_t x8 = (arg1[0]);
  uint32_t x9;
  uint32_t x10;
  fiat_secp256k1_mulx_u32(&x9, &x10, x8, (arg1[7]));
  uint32_t x11;
  uint32_t x12;
  fiat_secp256k1_mulx_u32(&x11, &x12, x8, (arg1[6]));
  uint32_t x13;
  uint32_t x14;
  fiat_secp256k1_mulx_u32(&x13, &x14, x8, (arg1[5]));
  uint32_t x15;
  uint32_t x16;
  fiat_secp256k1_mulx_u32(&x15, &x16, x8, (arg1[4]));
  uint32_t x17;
  uint32_t x18;
  fiat_secp256k1_mulx_u32(&x17, &x18, x8, (arg1[3]));
  uint32_t x19;
  uint32_t x20;
  fiat_secp256k1_mulx_u32(&x19, &x20, x8, (arg1[2]));
  uint32_t x21;
  uint32_t x22;
  fiat_secp256k1_mulx_u32(&x21, &x22, x8, (arg1[1]));
  uint32_t x23;
  uint32_t x24;
  fiat_secp256k1_mulx_u32(&x23, &x24, x8, (arg1[0]));
  uint32_t x25;
  fiat_secp256k1_uint1 x26;
  fiat_secp256k1_addcarryx_u32(&x25, &x26, 0x0, x24, x21);
  uint32_t x27;
  fiat_secp256k1_uint1 x28;
  fiat_secp256k1_addcarryx_u32(&x27, &x28, x26, x22, x19);
  uint32_t x29;
  fiat_secp256k1_uint1 x30;
  fiat_secp256k1_addcarryx_u32(&x29, &x30, x28, x20, x17);
  uint32_t x31;
  fiat_secp256k1_uint1 x32;
  fiat_secp256k1_addcarryx_u32(&x31, &x32, x30, x18, x15);
  uint32_t x33;
  fiat_secp256k1_uint1 x34;
  fiat_secp256k1_addcarryx_u32(&x33, &x34, x32, x16, x13);
  uint32_t x35;
  fiat_secp256k1_uint1 x36;
  fiat_secp256k1_addcarryx_u32(&x35, &x36, x34, x14, x11);
  uint32_t x37;
  fiat_secp256k1_uint1 x38;
  fiat_secp256k1_addcarryx_u32(&x37, &x38, x36, x12, x9);
  uint32_t x39;
  fiat_secp256k1_uint1 x40;
  fiat_secp256k1_addcarryx_u32(&x39, &x40, x38, x10, 0x0);
  uint32_t x41;
  uint32_t x42;
  fiat_secp256k1_mulx_u32(&x41, &x42, x23, UINT32_C(0xd2253531));
  uint32_t x43;
  uint32_t x44;
  fiat_secp256k1_mulx_u32(&x43, &x44, x41, UINT32_C(0xffffffff));
  uint32_t x45;
  uint32_t x46;
  fiat_secp256k1_mulx_u32(&x45, &x46, x41, UINT32_C(0xffffffff));
  uint32_t x47;
  uint32_t x48;
  fiat_secp256k1_mulx_u32(&x47, &x48, x41, UINT32_C(0xffffffff));
  uint32_t x49;
  uint32_t x50;
  fiat_secp256k1_mulx_u32(&x49, &x50, x41, UINT32_C(0xffffffff));
  uint32_t x51;
  uint32_t x52;
  fiat_secp256k1_mulx_u32(&x51, &x52, x41, UINT32_C(0xffffffff));
  uint32_t x53;
  uint32_t x54;
  fiat_secp256k1_mulx_u32(&x53, &x54, x41, UINT32_C(0xffffffff));
  uint32_t x55;
  uint32_t x56;
  fiat_secp256k1_mulx_u32(&x55, &x56, x41, UINT32_C(0xfffffffe));
  uint32_t x57;
  uint32_t x58;
  fiat_secp256k1_mulx_u32(&x57, &x58, x41, UINT32_C(0xfffffc2f));
  uint32_t x59;
  fiat_secp256k1_uint1 x60;
  fiat_secp256k1_addcarryx_u32(&x59, &x60, 0x0, x58, x55);
  uint32_t x61;
  fiat_secp256k1_uint1 x62;
  fiat_secp256k1_addcarryx_u32(&x61, &x62, x60, x56, x53);
  uint32_t x63;
  fiat_secp256k1_uint1 x64;
  fiat_secp256k1_addcarryx_u32(&x63, &x64, x62, x54, x51);
  uint32_t x65;
  fiat_secp256k1_uint1 x66;
  fiat_secp256k1_addcarryx_u32(&x65, &x66, x64, x52, x49);
  uint32_t x67;
  fiat_secp256k1_uint1 x68;
  fiat_secp256k1_addcarryx_u32(&x67, &x68, x66, x50, x47);
  uint32_t x69;
  fiat_secp256k1_uint1 x70;
  fiat_secp256k1_addcarryx_u32(&x69, &x70, x68, x48, x45);
  uint32_t x71;
  fiat_secp256k1_uint1 x72;
  fiat_secp256k1_addcarryx_u32(&x71, &x72, x70, x46, x43);
  uint32_t x73;
  fiat_secp256k1_uint1 x74;
  fiat_secp256k1_addcarryx_u32(&x73, &x74, x72, x44, 0x0);
  uint32_t x75;
  fiat_secp256k1_uint1 x76;
  fiat_secp256k1_addcarryx_u32(&x75, &x76, 0x0, x23, x57);
  uint32_t x77;
  fiat_secp256k1_uint1 x78;
  fiat_secp256k1_addcarryx_u32(&x77, &x78, x76, x25, x59);
  uint32_t x79;
  fiat_secp256k1_uint1 x80;
  fiat_secp256k1_addcarryx_u32(&x79, &x80, x78, x27, x61);
  uint32_t x81;
  fiat_secp256k1_uint1 x82;
  fiat_secp256k1_addcarryx_u32(&x81, &x82, x80, x29, x63);
  uint32_t x83;
  fiat_secp256k1_uint1 x84;
  fiat_secp256k1_addcarryx_u32(&x83, &x84, x82, x31, x65);
  uint32_t x85;
  fiat_secp256k1_uint1 x86;
  fiat_secp256k1_addcarryx_u32(&x85, &x86, x84, x33, x67);
  uint32_t x87;
  fiat_secp256k1_uint1 x88;
  fiat_secp256k1_addcarryx_u32(&x87, &x88, x86, x35, x69);
  uint32_t x89;
  fiat_secp256k1_uint1 x90;
  fiat_secp256k1_addcarryx_u32(&x89, &x90, x88, x37, x71);
  uint32_t x91;
  fiat_secp256k1_uint1 x92;
  fiat_secp256k1_addcarryx_u32(&x91, &x92, x90, x39, x73);
  uint32_t x93;
  fiat_secp256k1_uint1 x94;
  fiat_secp256k1_addcarryx_u32(&x93, &x94, x92, 0x0, 0x0);
  uint32_t x95;
  uint32_t x96;
  fiat_secp256k1_mulx_u32(&x95, &x96, x1, (arg1[7]));
  uint32_t x97;
  uint32_t x98;
  fiat_secp256k1_mulx_u32(&x97, &x98, x1, (arg1[6]));
  uint32_t x99;
  uint32_t x100;
  fiat_secp256k1_mulx_u32(&x99, &x100, x1, (arg1[5]));
  uint32_t x101;
  uint32_t x102;
  fiat_secp256k1_mulx_u32(&x101, &x102, x1, (arg1[4]));
  uint32_t x103;
  uint32_t x104;
  fiat_secp256k1_mulx_u32(&x103, &x104, x1, (arg1[3]));
  uint32_t x105;
  uint32_t x106;
  fiat_secp256k1_mulx_u32(&x105, &x106, x1, (arg1[2]));
  uint32_t x107;
  uint32_t x108;
  fiat_secp256k1_mulx_u32(&x107, &x108, x1, (arg1[1]));
  uint32_t x109;
  uint32_t x110;
  fiat_secp256k1_mulx_u32(&x109, &x110, x1, (arg1[0]));
  uint32_t x111;
  fiat_secp256k1_uint1 x112;
  fiat_secp256k1_addcarryx_u32(&x111, &x112, 0x0, x110, x107);
  uint32_t x113;
  fiat_secp256k1_uint1 x114;
  fiat_secp256k1_addcarryx_u32(&x113, &x114, x112, x108, x105);
  uint32_t x115;
  fiat_secp256k1_uint1 x116;
  fiat_secp256k1_addcarryx_u32(&x115, &x116, x114, x106, x103);
  uint32_t x117;
  fiat_secp256k1_uint1 x118;
  fiat_secp256k1_addcarryx_u32(&x117, &x118, x116, x104, x101);
  uint32_t x119;
  fiat_secp256k1_uint1 x120;
  fiat_secp256k1_addcarryx_u32(&x119, &x120, x118, x102, x99);
  uint32_t x121;
  fiat_secp256k1_uint1 x122;
  fiat_secp256k1_addcarryx_u32(&x121, &x122, x120, x100, x97);
  uint32_t x123;
  fiat_secp256k1_uint1 x124;
  fiat_secp256k1_addcarryx_u32(&x123, &x124, x122, x98, x95);
  uint32_t x125;
  fiat_secp256k1_uint1 x126;
  fiat_secp256k1_addcarryx_u32(&x125, &x126, x124, x96, 0x0);
  uint32_t x127;
  fiat_secp256k1_uint1 x128;
  fiat_secp256k1_addcarryx_u32(&x127, &x128, 0x0, x77, x109);
  uint32_t x129;
  fiat_secp256k1_uint1 x130;
  fiat_secp256k1_addcarryx_u32(&x129, &x130, x128, x79, x111);
  uint32_t x131;
  fiat_secp256k1_uint1 x132;
  fiat_secp256k1_addcarryx_u32(&x131, &x132, x130, x81, x113);
  uint32_t x133;
  fiat_secp256k1_uint1 x134;
  fiat_secp256k1_addcarryx_u32(&x133, &x134, x132, x83, x115);
  uint32_t x135;
  fiat_secp256k1_uint1 x136;
  fiat_secp256k1_addcarryx_u32(&x135, &x136, x134, x85, x117);
  uint32_t x137;
  fiat_secp256k1_uint1 x138;
  fiat_secp256k1_addcarryx_u32(&x137, &x138, x136, x87, x119);
  uint32_t x139;
  fiat_secp256k1_uint1 x140;
  fiat_secp256k1_addcarryx_u32(&x139, &x140, x138, x89, x121);
  uint32_t x141;
  fiat_secp256k1_uint1 x142;
  fiat_secp256k1_addcarryx_u32(&x141, &x142, x140, x91, x123);
  uint32_t x143;
  fiat_secp256k1_uint1 x144;
  fiat_secp256k1_addcarryx_u32(&x143, &x144, x142, (fiat_secp256k1_uint1)x93, x125);
  uint32_t x145;
  uint32_t x146;
  fiat_secp256k1_mulx_u32(&x145, &x146, x127, UINT32_C(0xd2253531));
  uint32_t x147;
  uint32_t x148;
  fiat_secp256k1_mulx_u32(&x147, &x148, x145, UINT32_C(0xffffffff));
  uint32_t x149;
  uint32_t x150;
  fiat_secp256k1_mulx_u32(&x149, &x150, x145, UINT32_C(0xffffffff));
  uint32_t x151;
  uint32_t x152;
  fiat_secp256k1_mulx_u32(&x151, &x152, x145, UINT32_C(0xffffffff));
  uint32_t x153;
  uint32_t x154;
  fiat_secp256k1_mulx_u32(&x153, &x154, x145, UINT32_C(0xffffffff));
  uint32_t x155;
  uint32_t x156;
  fiat_secp256k1_mulx_u32(&x155, &x156, x145, UINT32_C(0xffffffff));
  uint32_t x157;
  uint32_t x158;
  fiat_secp256k1_mulx_u32(&x157, &x158, x145, UINT32_C(0xffffffff));
  uint32_t x159;
  uint32_t x160;
  fiat_secp256k1_mulx_u32(&x159, &x160, x145, UINT32_C(0xfffffffe));
  uint32_t x161;
  uint32_t x162;
  fiat_secp256k1_mulx_u32(&x161, &x162, x145, UINT32_C(0xfffffc2f));
  uint32_t x163;
  fiat_secp256k1_uint1 x164;
  fiat_secp256k1_addcarryx_u32(&x163, &x164, 0x0, x162, x159);
  uint32_t x165;
  fiat_secp256k1_uint1 x166;
  fiat_secp256k1_addcarryx_u32(&x165, &x166, x164, x160, x157);
  uint32_t x167;
  fiat_secp256k1_uint1 x168;
  fiat_secp256k1_addcarryx_u32(&x167, &x168, x166, x158, x155);
  uint32_t x169;
  fiat_secp256k1_uint1 x170;
  fiat_secp256k1_addcarryx_u32(&x169, &x170, x168, x156, x153);
  uint32_t x171;
  fiat_secp256k1_uint1 x172;
  fiat_secp256k1_addcarryx_u32(&x171, &x172, x170, x154, x151);
  uint32_t x173;
  fiat_secp256k1_uint1 x174;
  fiat_secp256k1_addcarryx_u32(&x173, &x174, x172, x152, x149);
  uint32_t x175;
  fiat_secp256k1_uint1 x176;
  fiat_secp256k1_addcarryx_u32(&x175, &x176, x174, x150, x147);
  uint32_t x177;
  fiat_secp256k1_uint1 x178;
  fiat_secp256k1_addcarryx_u32(&x177, &x178, x176, x148, 0x0);
  uint32_t x179;
  fiat_secp256k1_uint1 x180;
  fiat_secp256k1_addcarryx_u32(&x179, &x180, 0x0, x127, x161);
  uint32_t x181;
  fiat_secp256k1_uint1 x182;
  fiat_secp256k1_addcarryx_u32(&x181, &x182, x180, x129, x163);
  uint32_t x183;
  fiat_secp256k1_uint1 x184;
  fiat_secp256k1_addcarryx_u32(&x183, &x184, x182, x131, x165);
  uint32_t x185;
  fiat_secp256k1_uint1 x186;
  fiat_secp256k1_addcarryx_u32(&x185, &x186, x184, x133, x167);
  uint32_t x187;
  fiat_secp256k1_uint1 x188;
  fiat_secp256k1_addcarryx_u32(&x187, &x188, x186, x135, x169);
  uint32_t x189;
  fiat_secp256k1_uint1 x190;
  fiat_secp256k1_addcarryx_u32(&x189, &x190, x188, x137, x171);
  uint32_t x191;
  fiat_secp256k1_uint1 x192;
  fiat_secp256k1_addcarryx_u32(&x191, &x192, x190, x139, x173);
  uint32_t x193;
  fiat_secp256k1_uint1 x194;
  fiat_secp256k1_addcarryx_u32(&x193, &x194, x192, x141, x175);
  uint32_t x195;
  fiat_secp256k1_uint1 x196;
  fiat_secp256k1_addcarryx_u32(&x195, &x196, x194, x143, x177);
  uint32_t x197;
  fiat_secp256k1_uint1 x198;
  fiat_secp256k1_addcarryx_u32(&x197, &x198, x196, x144, 0x0);
  uint32_t x199;
  uint32_t x200;
  fiat_secp256k1_mulx_u32(&x199, &x200, x2, (arg1[7]));
  uint32_t x201;
  uint32_t x202;
  fiat_secp256k1_mulx_u32(&x201, &x202, x2, (arg1[6]));
  uint32_t x203;
  uint32_t x204;
  fiat_secp256k1_mulx_u32(&x203, &x204, x2, (arg1[5]));
  uint32_t x205;
  uint32_t x206;
  fiat_secp256k1_mulx_u32(&x205, &x206, x2, (arg1[4]));
  uint32_t x207;
  uint32_t x208;
  fiat_secp256k1_mulx_u32(&x207, &x208, x2, (arg1[3]));
  uint32_t x209;
  uint32_t x210;
  fiat_secp256k1_mulx_u32(&x209, &x210, x2, (arg1[2]));
  uint32_t x211;
  uint32_t x212;
  fiat_secp256k1_mulx_u32(&x211, &x212, x2, (arg1[1]));
  uint32_t x213;
  uint32_t x214;
  fiat_secp256k1_mulx_u32(&x213, &x214, x2, (arg1[0]));
  uint32_t x215;
  fiat_secp256k1_uint1 x216;
  fiat_secp256k1_addcarryx_u32(&x215, &x216, 0x0, x214, x211);
  uint32_t x217;
  fiat_secp256k1_uint1 x218;
  fiat_secp256k1_addcarryx_u32(&x217, &x218, x216, x212, x209);
  uint32_t x219;
  fiat_secp256k1_uint1 x220;
  fiat_secp256k1_addcarryx_u32(&x219, &x220, x218, x210, x207);
  uint32_t x221;
  fiat_secp256k1_uint1 x222;
  fiat_secp256k1_addcarryx_u32(&x221, &x222, x220, x208, x205);
  uint32_t x223;
  fiat_secp256k1_uint1 x224;
  fiat_secp256k1_addcarryx_u32(&x223, &x224, x222, x206, x203);
  uint32_t x225;
  fiat_secp256k1_uint1 x226;
  fiat_secp256k1_addcarryx_u32(&x225, &x226, x224, x204, x201);
  uint32_t x227;
  fiat_secp256k1_uint1 x228;
  fiat_secp256k1_addcarryx_u32(&x227, &x228, x226, x202, x199);
  uint32_t x229;
  fiat_secp256k1_uint1 x230;
  fiat_secp256k1_addcarryx_u32(&x229, &x230, x228, x200, 0x0);
  uint32_t x231;
  fiat_secp256k1_uint1 x232;
  fiat_secp256k1_addcarryx_u32(&x231, &x232, 0x0, x181, x213);
  uint32_t x233;
  fiat_secp256k1_uint1 x234;
  fiat_secp256k1_addcarryx_u32(&x233, &x234, x232, x183, x215);
  uint32_t x235;
  fiat_secp256k1_uint1 x236;
  fiat_secp256k1_addcarryx_u32(&x235, &x236, x234, x185, x217);
  uint32_t x237;
  fiat_secp256k1_uint1 x238;
  fiat_secp256k1_addcarryx_u32(&x237, &x238, x236, x187, x219);
  uint32_t x239;
  fiat_secp256k1_uint1 x240;
  fiat_secp256k1_addcarryx_u32(&x239, &x240, x238, x189, x221);
  uint32_t x241;
  fiat_secp256k1_uint1 x242;
  fiat_secp256k1_addcarryx_u32(&x241, &x242, x240, x191, x223);
  uint32_t x243;
  fiat_secp256k1_uint1 x244;
  fiat_secp256k1_addcarryx_u32(&x243, &x244, x242, x193, x225);
  uint32_t x245;
  fiat_secp256k1_uint1 x246;
  fiat_secp256k1_addcarryx_u32(&x245, &x246, x244, x195, x227);
  uint32_t x247;
  fiat_secp256k1_uint1 x248;
  fiat_secp256k1_addcarryx_u32(&x247, &x248, x246, x197, x229);
  uint32_t x249;
  uint32_t x250;
  fiat_secp256k1_mulx_u32(&x249, &x250, x231, UINT32_C(0xd2253531));
  uint32_t x251;
  uint32_t x252;
  fiat_secp256k1_mulx_u32(&x251, &x252, x249, UINT32_C(0xffffffff));
  uint32_t x253;
  uint32_t x254;
  fiat_secp256k1_mulx_u32(&x253, &x254, x249, UINT32_C(0xffffffff));
  uint32_t x255;
  uint32_t x256;
  fiat_secp256k1_mulx_u32(&x255, &x256, x249, UINT32_C(0xffffffff));
  uint32_t x257;
  uint32_t x258;
  fiat_secp256k1_mulx_u32(&x257, &x258, x249, UINT32_C(0xffffffff));
  uint32_t x259;
  uint32_t x260;
  fiat_secp256k1_mulx_u32(&x259, &x260, x249, UINT32_C(0xffffffff));
  uint32_t x261;
  uint32_t x262;
  fiat_secp256k1_mulx_u32(&x261, &x262, x249, UINT32_C(0xffffffff));
  uint32_t x263;
  uint32_t x264;
  fiat_secp256k1_mulx_u32(&x263, &x264, x249, UINT32_C(0xfffffffe));
  uint32_t x265;
  uint32_t x266;
  fiat_secp256k1_mulx_u32(&x265, &x266, x249, UINT32_C(0xfffffc2f));
  uint32_t x267;
  fiat_secp256k1_uint1 x268;
  fiat_secp256k1_addcarryx_u32(&x267, &x268, 0x0, x266, x263);
  uint32_t x269;
  fiat_secp256k1_uint1 x270;
  fiat_secp256k1_addcarryx_u32(&x269, &x270, x268, x264, x261);
  uint32_t x271;
  fiat_secp256k1_uint1 x272;
  fiat_secp256k1_addcarryx_u32(&x271, &x272, x270, x262, x259);
  uint32_t x273;
  fiat_secp256k1_uint1 x274;
  fiat_secp256k1_addcarryx_u32(&x273, &x274, x272, x260, x257);
  uint32_t x275;
  fiat_secp256k1_uint1 x276;
  fiat_secp256k1_addcarryx_u32(&x275, &x276, x274, x258, x255);
  uint32_t x277;
  fiat_secp256k1_uint1 x278;
  fiat_secp256k1_addcarryx_u32(&x277, &x278, x276, x256, x253);
  uint32_t x279;
  fiat_secp256k1_uint1 x280;
  fiat_secp256k1_addcarryx_u32(&x279, &x280, x278, x254, x251);
  uint32_t x281;
  fiat_secp256k1_uint1 x282;
  fiat_secp256k1_addcarryx_u32(&x281, &x282, x280, x252, 0x0);
  uint32_t x283;
  fiat_secp256k1_uint1 x284;
  fiat_secp256k1_addcarryx_u32(&x283, &x284, 0x0, x231, x265);
  uint32_t x285;
  fiat_secp256k1_uint1 x286;
  fiat_secp256k1_addcarryx_u32(&x285, &x286, x284, x233, x267);
  uint32_t x287;
  fiat_secp256k1_uint1 x288;
  fiat_secp256k1_addcarryx_u32(&x287, &x288, x286, x235, x269);
  uint32_t x289;
  fiat_secp256k1_uint1 x290;
  fiat_secp256k1_addcarryx_u32(&x289, &x290, x288, x237, x271);
  uint32_t x291;
  fiat_secp256k1_uint1 x292;
  fiat_secp256k1_addcarryx_u32(&x291, &x292, x290, x239, x273);
  uint32_t x293;
  fiat_secp256k1_uint1 x294;
  fiat_secp256k1_addcarryx_u32(&x293, &x294, x292, x241, x275);
  uint32_t x295;
  fiat_secp256k1_uint1 x296;
  fiat_secp256k1_addcarryx_u32(&x295, &x296, x294, x243, x277);
  uint32_t x297;
  fiat_secp256k1_uint1 x298;
  fiat_secp256k1_addcarryx_u32(&x297, &x298, x296, x245, x279);
  uint32_t x299;
  fiat_secp256k1_uint1 x300;
  fiat_secp256k1_addcarryx_u32(&x299, &x300, x298, x247, x281);
  uint32_t x301;
  fiat_secp256k1_uint1 x302;
  fiat_secp256k1_addcarryx_u32(&x301, &x302, x300, x248, 0x0);
  uint32_t x303;
  uint32_t x304;
  fiat_secp256k1_mulx_u32(&x303, &x304, x3, (arg1[7]));
  uint32_t x305;
  uint32_t x306;
  fiat_secp256k1_mulx_u32(&x305, &x306, x3, (arg1[6]));
  uint32_t x307;
  uint32_t x308;
  fiat_secp256k1_mulx_u32(&x307, &x308, x3, (arg1[5]));
  uint32_t x309;
  uint32_t x310;
  fiat_secp256k1_mulx_u32(&x309, &x310, x3, (arg1[4]));
  uint32_t x311;
  uint32_t x312;
  fiat_secp256k1_mulx_u32(&x311, &x312, x3, (arg1[3]));
  uint32_t x313;
  uint32_t x314;
  fiat_secp256k1_mulx_u32(&x313, &x314, x3, (arg1[2]));
  uint32_t x315;
  uint32_t x316;
  fiat_secp256k1_mulx_u32(&x315, &x316, x3, (arg1[1]));
  uint32_t x317;
  uint32_t x318;
  fiat_secp256k1_mulx_u32(&x317, &x318, x3, (arg1[0]));
  uint32_t x319;
  fiat_secp256k1_uint1 x320;
  fiat_secp256k1_addcarryx_u32(&x319, &x320, 0x0, x318, x315);
  uint32_t x321;
  fiat_secp256k1_uint1 x322;
  fiat_secp256k1_addcarryx_u32(&x321, &x322, x320, x316, x313);
  uint32_t x323;
  fiat_secp256k1_uint1 x324;
  fiat_secp256k1_addcarryx_u32(&x323, &x324, x322, x314, x311);
  uint32_t x325;
  fiat_secp256k1_uint1 x326;
  fiat_secp256k1_addcarryx_u32(&x325, &x326, x324, x312, x309);
  uint32_t x327;
  fiat_secp256k1_uint1 x328;
  fiat_secp256k1_addcarryx_u32(&x327, &x328, x326, x310, x307);
  uint32_t x329;
  fiat_secp256k1_uint1 x330;
  fiat_secp256k1_addcarryx_u32(&x329, &x330, x328, x308, x305);
  uint32_t x331;
  fiat_secp256k1_uint1 x332;
  fiat_secp256k1_addcarryx_u32(&x331, &x332, x330, x306, x303);
  uint32_t x333;
  fiat_secp256k1_uint1 x334;
  fiat_secp256k1_addcarryx_u32(&x333, &x334, x332, x304, 0x0);
  uint32_t x335;
  fiat_secp256k1_uint1 x336;
  fiat_secp256k1_addcarryx_u32(&x335, &x336, 0x0, x285, x317);
  uint32_t x337;
  fiat_secp256k1_uint1 x338;
  fiat_secp256k1_addcarryx_u32(&x337, &x338, x336, x287, x319);
  uint32_t x339;
  fiat_secp256k1_uint1 x340;
  fiat_secp256k1_addcarryx_u32(&x339, &x340, x338, x289, x321);
  uint32_t x341;
  fiat_secp256k1_uint1 x342;
  fiat_secp256k1_addcarryx_u32(&x341, &x342, x340, x291, x323);
  uint32_t x343;
  fiat_secp256k1_uint1 x344;
  fiat_secp256k1_addcarryx_u32(&x343, &x344, x342, x293, x325);
  uint32_t x345;
  fiat_secp256k1_uint1 x346;
  fiat_secp256k1_addcarryx_u32(&x345, &x346, x344, x295, x327);
  uint32_t x347;
  fiat_secp256k1_uint1 x348;
  fiat_secp256k1_addcarryx_u32(&x347, &x348, x346, x297, x329);
  uint32_t x349;
  fiat_secp256k1_uint1 x350;
  fiat_secp256k1_addcarryx_u32(&x349, &x350, x348, x299, x331);
  uint32_t x351;
  fiat_secp256k1_uint1 x352;
  fiat_secp256k1_addcarryx_u32(&x351, &x352, x350, x301, x333);
  uint32_t x353;
  uint32_t x354;
  fiat_secp256k1_mulx_u32(&x353, &x354, x335, UINT32_C(0xd2253531));
  uint32_t x355;
  uint32_t x356;
  fiat_secp256k1_mulx_u32(&x355, &x356, x353, UINT32_C(0xffffffff));
  uint32_t x357;
  uint32_t x358;
  fiat_secp256k1_mulx_u32(&x357, &x358, x353, UINT32_C(0xffffffff));
  uint32_t x359;
  uint32_t x360;
  fiat_secp256k1_mulx_u32(&x359, &x360, x353, UINT32_C(0xffffffff));
  uint32_t x361;
  uint32_t x362;
  fiat_secp256k1_mulx_u32(&x361, &x362, x353, UINT32_C(0xffffffff));
  uint32_t x363;
  uint32_t x364;
  fiat_secp256k1_mulx_u32(&x363, &x364, x353, UINT32_C(0xffffffff));
  uint32_t x365;
  uint32_t x366;
  fiat_secp256k1_mulx_u32(&x365, &x366, x353, UINT32_C(0xffffffff));
  uint32_t x367;
  uint32_t x368;
  fiat_secp256k1_mulx_u32(&x367, &x368, x353, UINT32_C(0xfffffffe));
  uint32_t x369;
  uint32_t x370;
  fiat_secp256k1_mulx_u32(&x369, &x370, x353, UINT32_C(0xfffffc2f));
  uint32_t x371;
  fiat_secp256k1_uint1 x372;
  fiat_secp256k1_addcarryx_u32(&x371, &x372, 0x0, x370, x367);
  uint32_t x373;
  fiat_secp256k1_uint1 x374;
  fiat_secp256k1_addcarryx_u32(&x373, &x374, x372, x368, x365);
  uint32_t x375;
  fiat_secp256k1_uint1 x376;
  fiat_secp256k1_addcarryx_u32(&x375, &x376, x374, x366, x363);
  uint32_t x377;
  fiat_secp256k1_uint1 x378;
  fiat_secp256k1_addcarryx_u32(&x377, &x378, x376, x364, x361);
  uint32_t x379;
  fiat_secp256k1_uint1 x380;
  fiat_secp256k1_addcarryx_u32(&x379, &x380, x378, x362, x359);
  uint32_t x381;
  fiat_secp256k1_uint1 x382;
  fiat_secp256k1_addcarryx_u32(&x381, &x382, x380, x360, x357);
  uint32_t x383;
  fiat_secp256k1_uint1 x384;
  fiat_secp256k1_addcarryx_u32(&x383, &x384, x382, x358, x355);
  uint32_t x385;
  fiat_secp256k1_uint1 x386;
  fiat_secp256k1_addcarryx_u32(&x385, &x386, x384, x356, 0x0);
  uint32_t x387;
  fiat_secp256k1_uint1 x388;
  fiat_secp256k1_addcarryx_u32(&x387, &x388, 0x0, x335, x369);
  uint32_t x389;
  fiat_secp256k1_uint1 x390;
  fiat_secp256k1_addcarryx_u32(&x389, &x390, x388, x337, x371);
  uint32_t x391;
  fiat_secp256k1_uint1 x392;
  fiat_secp256k1_addcarryx_u32(&x391, &x392, x390, x339, x373);
  uint32_t x393;
  fiat_secp256k1_uint1 x394;
  fiat_secp256k1_addcarryx_u32(&x393, &x394, x392, x341, x375);
  uint32_t x395;
  fiat_secp256k1_uint1 x396;
  fiat_secp256k1_addcarryx_u32(&x395, &x396, x394, x343, x377);
  uint32_t x397;
  fiat_secp256k1_uint1 x398;
  fiat_secp256k1_addcarryx_u32(&x397, &x398, x396, x345, x379);
  uint32_t x399;
  fiat_secp256k1_uint1 x400;
  fiat_secp256k1_addcarryx_u32(&x399, &x400, x398, x347, x381);
  uint32_t x401;
  fiat_secp256k1_uint1 x402;
  fiat_secp256k1_addcarryx_u32(&x401, &x402, x400, x349, x383);
  uint32_t x403;
  fiat_secp256k1_uint1 x404;
  fiat_secp256k1_addcarryx_u32(&x403, &x404, x402, x351, x385);
  uint32_t x405;
  fiat_secp256k1_uint1 x406;
  fiat_secp256k1_addcarryx_u32(&x405, &x406, x404, x352, 0x0);
  uint32_t x407;
  uint32_t x408;
  fiat_secp256k1_mulx_u32(&x407, &x408, x4, (arg1[7]));
  uint32_t x409;
  uint32_t x410;
  fiat_secp256k1_mulx_u32(&x409, &x410, x4, (arg1[6]));
  uint32_t x411;
  uint32_t x412;
  fiat_secp256k1_mulx_u32(&x411, &x412, x4, (arg1[5]));
  uint32_t x413;
  uint32_t x414;
  fiat_secp256k1_mulx_u32(&x413, &x414, x4, (arg1[4]));
  uint32_t x415;
  uint32_t x416;
  fiat_secp256k1_mulx_u32(&x415, &x416, x4, (arg1[3]));
  uint32_t x417;
  uint32_t x418;
  fiat_secp256k1_mulx_u32(&x417, &x418, x4, (arg1[2]));
  uint32_t x419;
  uint32_t x420;
  fiat_secp256k1_mulx_u32(&x419, &x420, x4, (arg1[1]));
  uint32_t x421;
  uint32_t x422;
  fiat_secp256k1_mulx_u32(&x421, &x422, x4, (arg1[0]));
  uint32_t x423;
  fiat_secp256k1_uint1 x424;
  fiat_secp256k1_addcarryx_u32(&x423, &x424, 0x0, x422, x419);
  uint32_t x425;
  fiat_secp256k1_uint1 x426;
  fiat_secp256k1_addcarryx_u32(&x425, &x426, x424, x420, x417);
  uint32_t x427;
  fiat_secp256k1_uint1 x428;
  fiat_secp256k1_addcarryx_u32(&x427, &x428, x426, x418, x415);
  uint32_t x429;
  fiat_secp256k1_uint1 x430;
  fiat_secp256k1_addcarryx_u32(&x429, &x430, x428, x416, x413);
  uint32_t x431;
  fiat_secp256k1_uint1 x432;
  fiat_secp256k1_addcarryx_u32(&x431, &x432, x430, x414, x411);
  uint32_t x433;
  fiat_secp256k1_uint1 x434;
  fiat_secp256k1_addcarryx_u32(&x433, &x434, x432, x412, x409);
  uint32_t x435;
  fiat_secp256k1_uint1 x436;
  fiat_secp256k1_addcarryx_u32(&x435, &x436, x434, x410, x407);
  uint32_t x437;
  fiat_secp256k1_uint1 x438;
  fiat_secp256k1_addcarryx_u32(&x437, &x438, x436, x408, 0x0);
  uint32_t x439;
  fiat_secp256k1_uint1 x440;
  fiat_secp256k1_addcarryx_u32(&x439, &x440, 0x0, x389, x421);
  uint32_t x441;
  fiat_secp256k1_uint1 x442;
  fiat_secp256k1_addcarryx_u32(&x441, &x442, x440, x391, x423);
  uint32_t x443;
  fiat_secp256k1_uint1 x444;
  fiat_secp256k1_addcarryx_u32(&x443, &x444, x442, x393, x425);
  uint32_t x445;
  fiat_secp256k1_uint1 x446;
  fiat_secp256k1_addcarryx_u32(&x445, &x446, x444, x395, x427);
  uint32_t x447;
  fiat_secp256k1_uint1 x448;
  fiat_secp256k1_addcarryx_u32(&x447, &x448, x446, x397, x429);
  uint32_t x449;
  fiat_secp256k1_uint1 x450;
  fiat_secp256k1_addcarryx_u32(&x449, &x450, x448, x399, x431);
  uint32_t x451;
  fiat_secp256k1_uint1 x452;
  fiat_secp256k1_addcarryx_u32(&x451, &x452, x450, x401, x433);
  uint32_t x453;
  fiat_secp256k1_uint1 x454;
  fiat_secp256k1_addcarryx_u32(&x453, &x454, x452, x403, x435);
  uint32_t x455;
  fiat_secp256k1_uint1 x456;
  fiat_secp256k1_addcarryx_u32(&x455, &x456, x454, x405, x437);
  uint32_t x457;
  uint32_t x458;
  fiat_secp256k1_mulx_u32(&x457, &x458, x439, UINT32_C(0xd2253531));
  uint32_t x459;
  uint32_t x460;
  fiat_secp256k1_mulx_u32(&x459, &x460, x457, UINT32_C(0xffffffff));
  uint32_t x461;
  uint32_t x462;
  fiat_secp256k1_mulx_u32(&x461, &x462, x457, UINT32_C(0xffffffff));
  uint32_t x463;
  uint32_t x464;
  fiat_secp256k1_mulx_u32(&x463, &x464, x457, UINT32_C(0xffffffff));
  uint32_t x465;
  uint32_t x466;
  fiat_secp256k1_mulx_u32(&x465, &x466, x457, UINT32_C(0xffffffff));
  uint32_t x467;
  uint32_t x468;
  fiat_secp256k1_mulx_u32(&x467, &x468, x457, UINT32_C(0xffffffff));
  uint32_t x469;
  uint32_t x470;
  fiat_secp256k1_mulx_u32(&x469, &x470, x457, UINT32_C(0xffffffff));
  uint32_t x471;
  uint32_t x472;
  fiat_secp256k1_mulx_u32(&x471, &x472, x457, UINT32_C(0xfffffffe));
  uint32_t x473;
  uint32_t x474;
  fiat_secp256k1_mulx_u32(&x473, &x474, x457, UINT32_C(0xfffffc2f));
  uint32_t x475;
  fiat_secp256k1_uint1 x476;
  fiat_secp256k1_addcarryx_u32(&x475, &x476, 0x0, x474, x471);
  uint32_t x477;
  fiat_secp256k1_uint1 x478;
  fiat_secp256k1_addcarryx_u32(&x477, &x478, x476, x472, x469);
  uint32_t x479;
  fiat_secp256k1_uint1 x480;
  fiat_secp256k1_addcarryx_u32(&x479, &x480, x478, x470, x467);
  uint32_t x481;
  fiat_secp256k1_uint1 x482;
  fiat_secp256k1_addcarryx_u32(&x481, &x482, x480, x468, x465);
  uint32_t x483;
  fiat_secp256k1_uint1 x484;
  fiat_secp256k1_addcarryx_u32(&x483, &x484, x482, x466, x463);
  uint32_t x485;
  fiat_secp256k1_uint1 x486;
  fiat_secp256k1_addcarryx_u32(&x485, &x486, x484, x464, x461);
  uint32_t x487;
  fiat_secp256k1_uint1 x488;
  fiat_secp256k1_addcarryx_u32(&x487, &x488, x486, x462, x459);
  uint32_t x489;
  fiat_secp256k1_uint1 x490;
  fiat_secp256k1_addcarryx_u32(&x489, &x490, x488, x460, 0x0);
  uint32_t x491;
  fiat_secp256k1_uint1 x492;
  fiat_secp256k1_addcarryx_u32(&x491, &x492, 0x0, x439, x473);
  uint32_t x493;
  fiat_secp256k1_uint1 x494;
  fiat_secp256k1_addcarryx_u32(&x493, &x494, x492, x441, x475);
  uint32_t x495;
  fiat_secp256k1_uint1 x496;
  fiat_secp256k1_addcarryx_u32(&x495, &x496, x494, x443, x477);
  uint32_t x497;
  fiat_secp256k1_uint1 x498;
  fiat_secp256k1_addcarryx_u32(&x497, &x498, x496, x445, x479);
  uint32_t x499;
  fiat_secp256k1_uint1 x500;
  fiat_secp256k1_addcarryx_u32(&x499, &x500, x498, x447, x481);
  uint32_t x501;
  fiat_secp256k1_uint1 x502;
  fiat_secp256k1_addcarryx_u32(&x501, &x502, x500, x449, x483);
  uint32_t x503;
  fiat_secp256k1_uint1 x504;
  fiat_secp256k1_addcarryx_u32(&x503, &x504, x502, x451, x485);
  uint32_t x505;
  fiat_secp256k1_uint1 x506;
  fiat_secp256k1_addcarryx_u32(&x505, &x506, x504, x453, x487);
  uint32_t x507;
  fiat_secp256k1_uint1 x508;
  fiat_secp256k1_addcarryx_u32(&x507, &x508, x506, x455, x489);
  uint32_t x509;
  fiat_secp256k1_uint1 x510;
  fiat_secp256k1_addcarryx_u32(&x509, &x510, x508, x456, 0x0);
  uint32_t x511;
  uint32_t x512;
  fiat_secp256k1_mulx_u32(&x511, &x512, x5, (arg1[7]));
  uint32_t x513;
  uint32_t x514;
  fiat_secp256k1_mulx_u32(&x513, &x514, x5, (arg1[6]));
  uint32_t x515;
  uint32_t x516;
  fiat_secp256k1_mulx_u32(&x515, &x516, x5, (arg1[5]));
  uint32_t x517;
  uint32_t x518;
  fiat_secp256k1_mulx_u32(&x517, &x518, x5, (arg1[4]));
  uint32_t x519;
  uint32_t x520;
  fiat_secp256k1_mulx_u32(&x519, &x520, x5, (arg1[3]));
  uint32_t x521;
  uint32_t x522;
  fiat_secp256k1_mulx_u32(&x521, &x522, x5, (arg1[2]));
  uint32_t x523;
  uint32_t x524;
  fiat_secp256k1_mulx_u32(&x523, &x524, x5, (arg1[1]));
  uint32_t x525;
  uint32_t x526;
  fiat_secp256k1_mulx_u32(&x525, &x526, x5, (arg1[0]));
  uint32_t x527;
  fiat_secp256k1_uint1 x528;
  fiat_secp256k1_addcarryx_u32(&x527, &x528, 0x0, x526, x523);
  uint32_t x529;
  fiat_secp256k1_uint1 x530;
  fiat_secp256k1_addcarryx_u32(&x529, &x530, x528, x524, x521);
  uint32_t x531;
  fiat_secp256k1_uint1 x532;
  fiat_secp256k1_addcarryx_u32(&x531, &x532, x530, x522, x519);
  uint32_t x533;
  fiat_secp256k1_uint1 x534;
  fiat_secp256k1_addcarryx_u32(&x533, &x534, x532, x520, x517);
  uint32_t x535;
  fiat_secp256k1_uint1 x536;
  fiat_secp256k1_addcarryx_u32(&x535, &x536, x534, x518, x515);
  uint32_t x537;
  fiat_secp256k1_uint1 x538;
  fiat_secp256k1_addcarryx_u32(&x537, &x538, x536, x516, x513);
  uint32_t x539;
  fiat_secp256k1_uint1 x540;
  fiat_secp256k1_addcarryx_u32(&x539, &x540, x538, x514, x511);
  uint32_t x541;
  fiat_secp256k1_uint1 x542;
  fiat_secp256k1_addcarryx_u32(&x541, &x542, x540, x512, 0x0);
  uint32_t x543;
  fiat_secp256k1_uint1 x544;
  fiat_secp256k1_addcarryx_u32(&x543, &x544, 0x0, x493, x525);
  uint32_t x545;
  fiat_secp256k1_uint1 x546;
  fiat_secp256k1_addcarryx_u32(&x545, &x546, x544, x495, x527);
  uint32_t x547;
  fiat_secp256k1_uint1 x548;
  fiat_secp256k1_addcarryx_u32(&x547, &x548, x546, x497, x529);
  uint32_t x549;
  fiat_secp256k1_uint1 x550;
  fiat_secp256k1_addcarryx_u32(&x549, &x550, x548, x499, x531);
  uint32_t x551;
  fiat_secp256k1_uint1 x552;
  fiat_secp256k1_addcarryx_u32(&x551, &x552, x550, x501, x533);
  uint32_t x553;
  fiat_secp256k1_uint1 x554;
  fiat_secp256k1_addcarryx_u32(&x553, &x554, x552, x503, x535);
  uint32_t x555;
  fiat_secp256k1_uint1 x556;
  fiat_secp256k1_addcarryx_u32(&x555, &x556, x554, x505, x537);
  uint32_t x557;
  fiat_secp256k1_uint1 x558;
  fiat_secp256k1_addcarryx_u32(&x557, &x558, x556, x507, x539);
  uint32_t x559;
  fiat_secp256k1_uint1 x560;
  fiat_secp256k1_addcarryx_u32(&x559, &x560, x558, x509, x541);
  uint32_t x561;
  uint32_t x562;
  fiat_secp256k1_mulx_u32(&x561, &x562, x543, UINT32_C(0xd2253531));
  uint32_t x563;
  uint32_t x564;
  fiat_secp256k1_mulx_u32(&x563, &x564, x561, UINT32_C(0xffffffff));
  uint32_t x565;
  uint32_t x566;
  fiat_secp256k1_mulx_u32(&x565, &x566, x561, UINT32_C(0xffffffff));
  uint32_t x567;
  uint32_t x568;
  fiat_secp256k1_mulx_u32(&x567, &x568, x561, UINT32_C(0xffffffff));
  uint32_t x569;
  uint32_t x570;
  fiat_secp256k1_mulx_u32(&x569, &x570, x561, UINT32_C(0xffffffff));
  uint32_t x571;
  uint32_t x572;
  fiat_secp256k1_mulx_u32(&x571, &x572, x561, UINT32_C(0xffffffff));
  uint32_t x573;
  uint32_t x574;
  fiat_secp256k1_mulx_u32(&x573, &x574, x561, UINT32_C(0xffffffff));
  uint32_t x575;
  uint32_t x576;
  fiat_secp256k1_mulx_u32(&x575, &x576, x561, UINT32_C(0xfffffffe));
  uint32_t x577;
  uint32_t x578;
  fiat_secp256k1_mulx_u32(&x577, &x578, x561, UINT32_C(0xfffffc2f));
  uint32_t x579;
  fiat_secp256k1_uint1 x580;
  fiat_secp256k1_addcarryx_u32(&x579, &x580, 0x0, x578, x575);
  uint32_t x581;
  fiat_secp256k1_uint1 x582;
  fiat_secp256k1_addcarryx_u32(&x581, &x582, x580, x576, x573);
  uint32_t x583;
  fiat_secp256k1_uint1 x584;
  fiat_secp256k1_addcarryx_u32(&x583, &x584, x582, x574, x571);
  uint32_t x585;
  fiat_secp256k1_uint1 x586;
  fiat_secp256k1_addcarryx_u32(&x585, &x586, x584, x572, x569);
  uint32_t x587;
  fiat_secp256k1_uint1 x588;
  fiat_secp256k1_addcarryx_u32(&x587, &x588, x586, x570, x567);
  uint32_t x589;
  fiat_secp256k1_uint1 x590;
  fiat_secp256k1_addcarryx_u32(&x589, &x590, x588, x568, x565);
  uint32_t x591;
  fiat_secp256k1_uint1 x592;
  fiat_secp256k1_addcarryx_u32(&x591, &x592, x590, x566, x563);
  uint32_t x593;
  fiat_secp256k1_uint1 x594;
  fiat_secp256k1_addcarryx_u32(&x593, &x594, x592, x564, 0x0);
  uint32_t x595;
  fiat_secp256k1_uint1 x596;
  fiat_secp256k1_addcarryx_u32(&x595, &x596, 0x0, x543, x577);
  uint32_t x597;
  fiat_secp256k1_uint1 x598;
  fiat_secp256k1_addcarryx_u32(&x597, &x598, x596, x545, x579);
  uint32_t x599;
  fiat_secp256k1_uint1 x600;
  fiat_secp256k1_addcarryx_u32(&x599, &x600, x598, x547, x581);
  uint32_t x601;
  fiat_secp256k1_uint1 x602;
  fiat_secp256k1_addcarryx_u32(&x601, &x602, x600, x549, x583);
  uint32_t x603;
  fiat_secp256k1_uint1 x604;
  fiat_secp256k1_addcarryx_u32(&x603, &x604, x602, x551, x585);
  uint32_t x605;
  fiat_secp256k1_uint1 x606;
  fiat_secp256k1_addcarryx_u32(&x605, &x606, x604, x553, x587);
  uint32_t x607;
  fiat_secp256k1_uint1 x608;
  fiat_secp256k1_addcarryx_u32(&x607, &x608, x606, x555, x589);
  uint32_t x609;
  fiat_secp256k1_uint1 x610;
  fiat_secp256k1_addcarryx_u32(&x609, &x610, x608, x557, x591);
  uint32_t x611;
  fiat_secp256k1_uint1 x612;
  fiat_secp256k1_addcarryx_u32(&x611, &x612, x610, x559, x593);
  uint32_t x613;
  fiat_secp256k1_uint1 x614;
  fiat_secp256k1_addcarryx_u32(&x613, &x614, x612, x560, 0x0);
  uint32_t x615;
  uint32_t x616;
  fiat_secp256k1_mulx_u32(&x615, &x616, x6, (arg1[7]));
  uint32_t x617;
  uint32_t x618;
  fiat_secp256k1_mulx_u32(&x617, &x618, x6, (arg1[6]));
  uint32_t x619;
  uint32_t x620;
  fiat_secp256k1_mulx_u32(&x619, &x620, x6, (arg1[5]));
  uint32_t x621;
  uint32_t x622;
  fiat_secp256k1_mulx_u32(&x621, &x622, x6, (arg1[4]));
  uint32_t x623;
  uint32_t x624;
  fiat_secp256k1_mulx_u32(&x623, &x624, x6, (arg1[3]));
  uint32_t x625;
  uint32_t x626;
  fiat_secp256k1_mulx_u32(&x625, &x626, x6, (arg1[2]));
  uint32_t x627;
  uint32_t x628;
  fiat_secp256k1_mulx_u32(&x627, &x628, x6, (arg1[1]));
  uint32_t x629;
  uint32_t x630;
  fiat_secp256k1_mulx_u32(&x629, &x630, x6, (arg1[0]));
  uint32_t x631;
  fiat_secp256k1_uint1 x632;
  fiat_secp256k1_addcarryx_u32(&x631, &x632, 0x0, x630, x627);
  uint32_t x633;
  fiat_secp256k1_uint1 x634;
  fiat_secp256k1_addcarryx_u32(&x633, &x634, x632, x628, x625);
  uint32_t x635;
  fiat_secp256k1_uint1 x636;
  fiat_secp256k1_addcarryx_u32(&x635, &x636, x634, x626, x623);
  uint32_t x637;
  fiat_secp256k1_uint1 x638;
  fiat_secp256k1_addcarryx_u32(&x637, &x638, x636, x624, x621);
  uint32_t x639;
  fiat_secp256k1_uint1 x640;
  fiat_secp256k1_addcarryx_u32(&x639, &x640, x638, x622, x619);
  uint32_t x641;
  fiat_secp256k1_uint1 x642;
  fiat_secp256k1_addcarryx_u32(&x641, &x642, x640, x620, x617);
  uint32_t x643;
  fiat_secp256k1_uint1 x644;
  fiat_secp256k1_addcarryx_u32(&x643, &x644, x642, x618, x615);
  uint32_t x645;
  fiat_secp256k1_uint1 x646;
  fiat_secp256k1_addcarryx_u32(&x645, &x646, x644, x616, 0x0);
  uint32_t x647;
  fiat_secp256k1_uint1 x648;
  fiat_secp256k1_addcarryx_u32(&x647, &x648, 0x0, x597, x629);
  uint32_t x649;
  fiat_secp256k1_uint1 x650;
  fiat_secp256k1_addcarryx_u32(&x649, &x650, x648, x599, x631);
  uint32_t x651;
  fiat_secp256k1_uint1 x652;
  fiat_secp256k1_addcarryx_u32(&x651, &x652, x650, x601, x633);
  uint32_t x653;
  fiat_secp256k1_uint1 x654;
  fiat_secp256k1_addcarryx_u32(&x653, &x654, x652, x603, x635);
  uint32_t x655;
  fiat_secp256k1_uint1 x656;
  fiat_secp256k1_addcarryx_u32(&x655, &x656, x654, x605, x637);
  uint32_t x657;
  fiat_secp256k1_uint1 x658;
  fiat_secp256k1_addcarryx_u32(&x657, &x658, x656, x607, x639);
  uint32_t x659;
  fiat_secp256k1_uint1 x660;
  fiat_secp256k1_addcarryx_u32(&x659, &x660, x658, x609, x641);
  uint32_t x661;
  fiat_secp256k1_uint1 x662;
  fiat_secp256k1_addcarryx_u32(&x661, &x662, x660, x611, x643);
  uint32_t x663;
  fiat_secp256k1_uint1 x664;
  fiat_secp256k1_addcarryx_u32(&x663, &x664, x662, x613, x645);
  uint32_t x665;
  uint32_t x666;
  fiat_secp256k1_mulx_u32(&x665, &x666, x647, UINT32_C(0xd2253531));
  uint32_t x667;
  uint32_t x668;
  fiat_secp256k1_mulx_u32(&x667, &x668, x665, UINT32_C(0xffffffff));
  uint32_t x669;
  uint32_t x670;
  fiat_secp256k1_mulx_u32(&x669, &x670, x665, UINT32_C(0xffffffff));
  uint32_t x671;
  uint32_t x672;
  fiat_secp256k1_mulx_u32(&x671, &x672, x665, UINT32_C(0xffffffff));
  uint32_t x673;
  uint32_t x674;
  fiat_secp256k1_mulx_u32(&x673, &x674, x665, UINT32_C(0xffffffff));
  uint32_t x675;
  uint32_t x676;
  fiat_secp256k1_mulx_u32(&x675, &x676, x665, UINT32_C(0xffffffff));
  uint32_t x677;
  uint32_t x678;
  fiat_secp256k1_mulx_u32(&x677, &x678, x665, UINT32_C(0xffffffff));
  uint32_t x679;
  uint32_t x680;
  fiat_secp256k1_mulx_u32(&x679, &x680, x665, UINT32_C(0xfffffffe));
  uint32_t x681;
  uint32_t x682;
  fiat_secp256k1_mulx_u32(&x681, &x682, x665, UINT32_C(0xfffffc2f));
  uint32_t x683;
  fiat_secp256k1_uint1 x684;
  fiat_secp256k1_addcarryx_u32(&x683, &x684, 0x0, x682, x679);
  uint32_t x685;
  fiat_secp256k1_uint1 x686;
  fiat_secp256k1_addcarryx_u32(&x685, &x686, x684, x680, x677);
  uint32_t x687;
  fiat_secp256k1_uint1 x688;
  fiat_secp256k1_addcarryx_u32(&x687, &x688, x686, x678, x675);
  uint32_t x689;
  fiat_secp256k1_uint1 x690;
  fiat_secp256k1_addcarryx_u32(&x689, &x690, x688, x676, x673);
  uint32_t x691;
  fiat_secp256k1_uint1 x692;
  fiat_secp256k1_addcarryx_u32(&x691, &x692, x690, x674, x671);
  uint32_t x693;
  fiat_secp256k1_uint1 x694;
  fiat_secp256k1_addcarryx_u32(&x693, &x694, x692, x672, x669);
  uint32_t x695;
  fiat_secp256k1_uint1 x696;
  fiat_secp256k1_addcarryx_u32(&x695, &x696, x694, x670, x667);
  uint32_t x697;
  fiat_secp256k1_uint1 x698;
  fiat_secp256k1_addcarryx_u32(&x697, &x698, x696, x668, 0x0);
  uint32_t x699;
  fiat_secp256k1_uint1 x700;
  fiat_secp256k1_addcarryx_u32(&x699, &x700, 0x0, x647, x681);
  uint32_t x701;
  fiat_secp256k1_uint1 x702;
  fiat_secp256k1_addcarryx_u32(&x701, &x702, x700, x649, x683);
  uint32_t x703;
  fiat_secp256k1_uint1 x704;
  fiat_secp256k1_addcarryx_u32(&x703, &x704, x702, x651, x685);
  uint32_t x705;
  fiat_secp256k1_uint1 x706;
  fiat_secp256k1_addcarryx_u32(&x705, &x706, x704, x653, x687);
  uint32_t x707;
  fiat_secp256k1_uint1 x708;
  fiat_secp256k1_addcarryx_u32(&x707, &x708, x706, x655, x689);
  uint32_t x709;
  fiat_secp256k1_uint1 x710;
  fiat_secp256k1_addcarryx_u32(&x709, &x710, x708, x657, x691);
  uint32_t x711;
  fiat_secp256k1_uint1 x712;
  fiat_secp256k1_addcarryx_u32(&x711, &x712, x710, x659, x693);
  uint32_t x713;
  fiat_secp256k1_uint1 x714;
  fiat_secp256k1_addcarryx_u32(&x713, &x714, x712, x661, x695);
  uint32_t x715;
  fiat_secp256k1_uint1 x716;
  fiat_secp256k1_addcarryx_u32(&x715, &x716, x714, x663, x697);
  uint32_t x717;
  fiat_secp256k1_uint1 x718;
  fiat_secp256k1_addcarryx_u32(&x717, &x718, x716, x664, 0x0);
  uint32_t x719;
  uint32_t x720;
  fiat_secp256k1_mulx_u32(&x719, &x720, x7, (arg1[7]));
  uint32_t x721;
  uint32_t x722;
  fiat_secp256k1_mulx_u32(&x721, &x722, x7, (arg1[6]));
  uint32_t x723;
  uint32_t x724;
  fiat_secp256k1_mulx_u32(&x723, &x724, x7, (arg1[5]));
  uint32_t x725;
  uint32_t x726;
  fiat_secp256k1_mulx_u32(&x725, &x726, x7, (arg1[4]));
  uint32_t x727;
  uint32_t x728;
  fiat_secp256k1_mulx_u32(&x727, &x728, x7, (arg1[3]));
  uint32_t x729;
  uint32_t x730;
  fiat_secp256k1_mulx_u32(&x729, &x730, x7, (arg1[2]));
  uint32_t x731;
  uint32_t x732;
  fiat_secp256k1_mulx_u32(&x731, &x732, x7, (arg1[1]));
  uint32_t x733;
  uint32_t x734;
  fiat_secp256k1_mulx_u32(&x733, &x734, x7, (arg1[0]));
  uint32_t x735;
  fiat_secp256k1_uint1 x736;
  fiat_secp256k1_addcarryx_u32(&x735, &x736, 0x0, x734, x731);
  uint32_t x737;
  fiat_secp256k1_uint1 x738;
  fiat_secp256k1_addcarryx_u32(&x737, &x738, x736, x732, x729);
  uint32_t x739;
  fiat_secp256k1_uint1 x740;
  fiat_secp256k1_addcarryx_u32(&x739, &x740, x738, x730, x727);
  uint32_t x741;
  fiat_secp256k1_uint1 x742;
  fiat_secp256k1_addcarryx_u32(&x741, &x742, x740, x728, x725);
  uint32_t x743;
  fiat_secp256k1_uint1 x744;
  fiat_secp256k1_addcarryx_u32(&x743, &x744, x742, x726, x723);
  uint32_t x745;
  fiat_secp256k1_uint1 x746;
  fiat_secp256k1_addcarryx_u32(&x745, &x746, x744, x724, x721);
  uint32_t x747;
  fiat_secp256k1_uint1 x748;
  fiat_secp256k1_addcarryx_u32(&x747, &x748, x746, x722, x719);
  uint32_t x749;
  fiat_secp256k1_uint1 x750;
  fiat_secp256k1_addcarryx_u32(&x749, &x750, x748, x720, 0x0);
  uint32_t x751;
  fiat_secp256k1_uint1 x752;
  fiat_secp256k1_addcarryx_u32(&x751, &x752, 0x0, x701, x733);
  uint32_t x753;
  fiat_secp256k1_uint1 x754;
  fiat_secp256k1_addcarryx_u32(&x753, &x754, x752, x703, x735);
  uint32_t x755;
  fiat_secp256k1_uint1 x756;
  fiat_secp256k1_addcarryx_u32(&x755, &x756, x754, x705, x737);
  uint32_t x757;
  fiat_secp256k1_uint1 x758;
  fiat_secp256k1_addcarryx_u32(&x757, &x758, x756, x707, x739);
  uint32_t x759;
  fiat_secp256k1_uint1 x760;
  fiat_secp256k1_addcarryx_u32(&x759, &x760, x758, x709, x741);
  uint32_t x761;
  fiat_secp256k1_uint1 x762;
  fiat_secp256k1_addcarryx_u32(&x761, &x762, x760, x711, x743);
  uint32_t x763;
  fiat_secp256k1_uint1 x764;
  fiat_secp256k1_addcarryx_u32(&x763, &x764, x762, x713, x745);
  uint32_t x765;
  fiat_secp256k1_uint1 x766;
  fiat_secp256k1_addcarryx_u32(&x765, &x766, x764, x715, x747);
  uint32_t x767;
  fiat_secp256k1_uint1 x768;
  fiat_secp256k1_addcarryx_u32(&x767, &x768, x766, x717, x749);
  uint32_t x769;
  uint32_t x770;
  fiat_secp256k1_mulx_u32(&x769, &x770, x751, UINT32_C(0xd2253531));
  uint32_t x771;
  uint32_t x772;
  fiat_secp256k1_mulx_u32(&x771, &x772, x769, UINT32_C(0xffffffff));
  uint32_t x773;
  uint32_t x774;
  fiat_secp256k1_mulx_u32(&x773, &x774, x769, UINT32_C(0xffffffff));
  uint32_t x775;
  uint32_t x776;
  fiat_secp256k1_mulx_u32(&x775, &x776, x769, UINT32_C(0xffffffff));
  uint32_t x777;
  uint32_t x778;
  fiat_secp256k1_mulx_u32(&x777, &x778, x769, UINT32_C(0xffffffff));
  uint32_t x779;
  uint32_t x780;
  fiat_secp256k1_mulx_u32(&x779, &x780, x769, UINT32_C(0xffffffff));
  uint32_t x781;
  uint32_t x782;
  fiat_secp256k1_mulx_u32(&x781, &x782, x769, UINT32_C(0xffffffff));
  uint32_t x783;
  uint32_t x784;
  fiat_secp256k1_mulx_u32(&x783, &x784, x769, UINT32_C(0xfffffffe));
  uint32_t x785;
  uint32_t x786;
  fiat_secp256k1_mulx_u32(&x785, &x786, x769, UINT32_C(0xfffffc2f));
  uint32_t x787;
  fiat_secp256k1_uint1 x788;
  fiat_secp256k1_addcarryx_u32(&x787, &x788, 0x0, x786, x783);
  uint32_t x789;
  fiat_secp256k1_uint1 x790;
  fiat_secp256k1_addcarryx_u32(&x789, &x790, x788, x784, x781);
  uint32_t x791;
  fiat_secp256k1_uint1 x792;
  fiat_secp256k1_addcarryx_u32(&x791, &x792, x790, x782, x779);
  uint32_t x793;
  fiat_secp256k1_uint1 x794;
  fiat_secp256k1_addcarryx_u32(&x793, &x794, x792, x780, x777);
  uint32_t x795;
  fiat_secp256k1_uint1 x796;
  fiat_secp256k1_addcarryx_u32(&x795, &x796, x794, x778, x775);
  uint32_t x797;
  fiat_secp256k1_uint1 x798;
  fiat_secp256k1_addcarryx_u32(&x797, &x798, x796, x776, x773);
  uint32_t x799;
  fiat_secp256k1_uint1 x800;
  fiat_secp256k1_addcarryx_u32(&x799, &x800, x798, x774, x771);
  uint32_t x801;
  fiat_secp256k1_uint1 x802;
  fiat_secp256k1_addcarryx_u32(&x801, &x802, x800, x772, 0x0);
  uint32_t x803;
  fiat_secp256k1_uint1 x804;
  fiat_secp256k1_addcarryx_u32(&x803, &x804, 0x0, x751, x785);
  uint32_t x805;
  fiat_secp256k1_uint1 x806;
  fiat_secp256k1_addcarryx_u32(&x805, &x806, x804, x753, x787);
  uint32_t x807;
  fiat_secp256k1_uint1 x808;
  fiat_secp256k1_addcarryx_u32(&x807, &x808, x806, x755, x789);
  uint32_t x809;
  fiat_secp256k1_uint1 x810;
  fiat_secp256k1_addcarryx_u32(&x809, &x810, x808, x757, x791);
  uint32_t x811;
  fiat_secp256k1_uint1 x812;
  fiat_secp256k1_addcarryx_u32(&x811, &x812, x810, x759, x793);
  uint32_t x813;
  fiat_secp256k1_uint1 x814;
  fiat_secp256k1_addcarryx_u32(&x813, &x814, x812, x761, x795);
  uint32_t x815;
  fiat_secp256k1_uint1 x816;
  fiat_secp256k1_addcarryx_u32(&x815, &x816, x814, x763, x797);
  uint32_t x817;
  fiat_secp256k1_uint1 x818;
  fiat_secp256k1_addcarryx_u32(&x817, &x818, x816, x765, x799);
  uint32_t x819;
  fiat_secp256k1_uint1 x820;
  fiat_secp256k1_addcarryx_u32(&x819, &x820, x818, x767, x801);
  uint32_t x821;
  fiat_secp256k1_uint1 x822;
  fiat_secp256k1_addcarryx_u32(&x821, &x822, x820, x768, 0x0);
  uint32_t x823;
  fiat_secp256k1_uint1 x824;
  fiat_secp256k1_subborrowx_u32(&x823, &x824, 0x0, x805, UINT32_C(0xfffffc2f));
  uint32_t x825;
  fiat_secp256k1_uint1 x826;
  fiat_secp256k1_subborrowx_u32(&x825, &x826, x824, x807, UINT32_C(0xfffffffe));
  uint32_t x827;
  fiat_secp256k1_uint1 x828;
  fiat_secp256k1_subborrowx_u32(&x827, &x828, x826, x809, UINT32_C(0xffffffff));
  uint32_t x829;
  fiat_secp256k1_uint1 x830;
  fiat_secp256k1_subborrowx_u32(&x829, &x830, x828, x811, UINT32_C(0xffffffff));
  uint32_t x831;
  fiat_secp256k1_uint1 x832;
  fiat_secp256k1_subborrowx_u32(&x831, &x832, x830, x813, UINT32_C(0xffffffff));
  uint32_t x833;
  fiat_secp256k1_uint1 x834;
  fiat_secp256k1_subborrowx_u32(&x833, &x834, x832, x815, UINT32_C(0xffffffff));
  uint32_t x835;
  fiat_secp256k1_uint1 x836;
  fiat_secp256k1_subborrowx_u32(&x835, &x836, x834, x817, UINT32_C(0xffffffff));
  uint32_t x837;
  fiat_secp256k1_uint1 x838;
  fiat_secp256k1_subborrowx_u32(&x837, &x838, x836, x819, UINT32_C(0xffffffff));
  uint32_t x839;
  fiat_secp256k1_uint1 x840;
  fiat_secp256k1_subborrowx_u32(&x839, &x840, x838, x821, 0x0);
  uint32_t x841;
  fiat_secp256k1_cmovznz_u32(&x841, x840, x823, x805);
  uint32_t x842;
  fiat_secp256k1_cmovznz_u32(&x842, x840, x825, x807);
  uint32_t x843;
  fiat_secp256k1_cmovznz_u32(&x843, x840, x827, x809);
  uint32_t x844;
  fiat_secp256k1_cmovznz_u32(&x844, x840, x829, x811);
  uint32_t x845;
  fiat_secp256k1_cmovznz_u32(&x845, x840, x831, x813);
  uint32_t x846;
  fiat_secp256k1_cmovznz_u32(&x846, x840, x833, x815);
  uint32_t x847;
  fiat_secp256k1_cmovznz_u32(&x847, x840, x835, x817);
  uint32_t x848;
  fiat_secp256k1_cmovznz_u32(&x848, x840, x837, x819);
  out1[0] = x841;
  out1[1] = x842;
  out1[2] = x843;
  out1[3] = x844;
  out1[4] = x845;
  out1[5] = x846;
  out1[6] = x847;
  out1[7] = x848;
}

/*
 * The function fiat_secp256k1_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_add(uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
  uint32_t x1;
  fiat_secp256k1_uint1 x2;
  fiat_secp256k1_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_secp256k1_uint1 x4;
  fiat_secp256k1_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_secp256k1_uint1 x6;
  fiat_secp256k1_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_secp256k1_uint1 x8;
  fiat_secp256k1_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_secp256k1_uint1 x10;
  fiat_secp256k1_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_secp256k1_uint1 x12;
  fiat_secp256k1_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_secp256k1_uint1 x14;
  fiat_secp256k1_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_secp256k1_uint1 x16;
  fiat_secp256k1_addcarryx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  uint32_t x17;
  fiat_secp256k1_uint1 x18;
  fiat_secp256k1_subborrowx_u32(&x17, &x18, 0x0, x1, UINT32_C(0xfffffc2f));
  uint32_t x19;
  fiat_secp256k1_uint1 x20;
  fiat_secp256k1_subborrowx_u32(&x19, &x20, x18, x3, UINT32_C(0xfffffffe));
  uint32_t x21;
  fiat_secp256k1_uint1 x22;
  fiat_secp256k1_subborrowx_u32(&x21, &x22, x20, x5, UINT32_C(0xffffffff));
  uint32_t x23;
  fiat_secp256k1_uint1 x24;
  fiat_secp256k1_subborrowx_u32(&x23, &x24, x22, x7, UINT32_C(0xffffffff));
  uint32_t x25;
  fiat_secp256k1_uint1 x26;
  fiat_secp256k1_subborrowx_u32(&x25, &x26, x24, x9, UINT32_C(0xffffffff));
  uint32_t x27;
  fiat_secp256k1_uint1 x28;
  fiat_secp256k1_subborrowx_u32(&x27, &x28, x26, x11, UINT32_C(0xffffffff));
  uint32_t x29;
  fiat_secp256k1_uint1 x30;
  fiat_secp256k1_subborrowx_u32(&x29, &x30, x28, x13, UINT32_C(0xffffffff));
  uint32_t x31;
  fiat_secp256k1_uint1 x32;
  fiat_secp256k1_subborrowx_u32(&x31, &x32, x30, x15, UINT32_C(0xffffffff));
  uint32_t x33;
  fiat_secp256k1_uint1 x34;
  fiat_secp256k1_subborrowx_u32(&x33, &x34, x32, x16, 0x0);
  uint32_t x35;
  fiat_secp256k1_cmovznz_u32(&x35, x34, x17, x1);
  uint32_t x36;
  fiat_secp256k1_cmovznz_u32(&x36, x34, x19, x3);
  uint32_t x37;
  fiat_secp256k1_cmovznz_u32(&x37, x34, x21, x5);
  uint32_t x38;
  fiat_secp256k1_cmovznz_u32(&x38, x34, x23, x7);
  uint32_t x39;
  fiat_secp256k1_cmovznz_u32(&x39, x34, x25, x9);
  uint32_t x40;
  fiat_secp256k1_cmovznz_u32(&x40, x34, x27, x11);
  uint32_t x41;
  fiat_secp256k1_cmovznz_u32(&x41, x34, x29, x13);
  uint32_t x42;
  fiat_secp256k1_cmovznz_u32(&x42, x34, x31, x15);
  out1[0] = x35;
  out1[1] = x36;
  out1[2] = x37;
  out1[3] = x38;
  out1[4] = x39;
  out1[5] = x40;
  out1[6] = x41;
  out1[7] = x42;
}

/*
 * The function fiat_secp256k1_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_sub(uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
  uint32_t x1;
  fiat_secp256k1_uint1 x2;
  fiat_secp256k1_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_secp256k1_uint1 x4;
  fiat_secp256k1_subborrowx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_secp256k1_uint1 x6;
  fiat_secp256k1_subborrowx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_secp256k1_uint1 x8;
  fiat_secp256k1_subborrowx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_secp256k1_uint1 x10;
  fiat_secp256k1_subborrowx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_secp256k1_uint1 x12;
  fiat_secp256k1_subborrowx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_secp256k1_uint1 x14;
  fiat_secp256k1_subborrowx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_secp256k1_uint1 x16;
  fiat_secp256k1_subborrowx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  uint32_t x17;
  fiat_secp256k1_cmovznz_u32(&x17, x16, 0x0, UINT32_C(0xffffffff));
  uint32_t x18;
  fiat_secp256k1_uint1 x19;
  fiat_secp256k1_addcarryx_u32(&x18, &x19, 0x0, x1, (x17 & UINT32_C(0xfffffc2f)));
  uint32_t x20;
  fiat_secp256k1_uint1 x21;
  fiat_secp256k1_addcarryx_u32(&x20, &x21, x19, x3, (x17 & UINT32_C(0xfffffffe)));
  uint32_t x22;
  fiat_secp256k1_uint1 x23;
  fiat_secp256k1_addcarryx_u32(&x22, &x23, x21, x5, (x17 & UINT32_C(0xffffffff)));
  uint32_t x24;
  fiat_secp256k1_uint1 x25;
  fiat_secp256k1_addcarryx_u32(&x24, &x25, x23, x7, (x17 & UINT32_C(0xffffffff)));
  uint32_t x26;
  fiat_secp256k1_uint1 x27;
  fiat_secp256k1_addcarryx_u32(&x26, &x27, x25, x9, (x17 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_secp256k1_uint1 x29;
  fiat_secp256k1_addcarryx_u32(&x28, &x29, x27, x11, (x17 & UINT32_C(0xffffffff)));
  uint32_t x30;
  fiat_secp256k1_uint1 x31;
  fiat_secp256k1_addcarryx_u32(&x30, &x31, x29, x13, (x17 & UINT32_C(0xffffffff)));
  uint32_t x32;
  fiat_secp256k1_uint1 x33;
  fiat_secp256k1_addcarryx_u32(&x32, &x33, x31, x15, (x17 & UINT32_C(0xffffffff)));
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/*
 * The function fiat_secp256k1_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_opp(uint32_t out1[8], const uint32_t arg1[8]) {
  uint32_t x1;
  fiat_secp256k1_uint1 x2;
  fiat_secp256k1_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  uint32_t x3;
  fiat_secp256k1_uint1 x4;
  fiat_secp256k1_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  uint32_t x5;
  fiat_secp256k1_uint1 x6;
  fiat_secp256k1_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  uint32_t x7;
  fiat_secp256k1_uint1 x8;
  fiat_secp256k1_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  uint32_t x9;
  fiat_secp256k1_uint1 x10;
  fiat_secp256k1_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  uint32_t x11;
  fiat_secp256k1_uint1 x12;
  fiat_secp256k1_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  uint32_t x13;
  fiat_secp256k1_uint1 x14;
  fiat_secp256k1_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  uint32_t x15;
  fiat_secp256k1_uint1 x16;
  fiat_secp256k1_subborrowx_u32(&x15, &x16, x14, 0x0, (arg1[7]));
  uint32_t x17;
  fiat_secp256k1_cmovznz_u32(&x17, x16, 0x0, UINT32_C(0xffffffff));
  uint32_t x18;
  fiat_secp256k1_uint1 x19;
  fiat_secp256k1_addcarryx_u32(&x18, &x19, 0x0, x1, (x17 & UINT32_C(0xfffffc2f)));
  uint32_t x20;
  fiat_secp256k1_uint1 x21;
  fiat_secp256k1_addcarryx_u32(&x20, &x21, x19, x3, (x17 & UINT32_C(0xfffffffe)));
  uint32_t x22;
  fiat_secp256k1_uint1 x23;
  fiat_secp256k1_addcarryx_u32(&x22, &x23, x21, x5, (x17 & UINT32_C(0xffffffff)));
  uint32_t x24;
  fiat_secp256k1_uint1 x25;
  fiat_secp256k1_addcarryx_u32(&x24, &x25, x23, x7, (x17 & UINT32_C(0xffffffff)));
  uint32_t x26;
  fiat_secp256k1_uint1 x27;
  fiat_secp256k1_addcarryx_u32(&x26, &x27, x25, x9, (x17 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_secp256k1_uint1 x29;
  fiat_secp256k1_addcarryx_u32(&x28, &x29, x27, x11, (x17 & UINT32_C(0xffffffff)));
  uint32_t x30;
  fiat_secp256k1_uint1 x31;
  fiat_secp256k1_addcarryx_u32(&x30, &x31, x29, x13, (x17 & UINT32_C(0xffffffff)));
  uint32_t x32;
  fiat_secp256k1_uint1 x33;
  fiat_secp256k1_addcarryx_u32(&x32, &x33, x31, x15, (x17 & UINT32_C(0xffffffff)));
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/*
 * The function fiat_secp256k1_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_from_montgomery(uint32_t out1[8], const uint32_t arg1[8]) {
  uint32_t x1 = (arg1[0]);
  uint32_t x2;
  uint32_t x3;
  fiat_secp256k1_mulx_u32(&x2, &x3, x1, UINT32_C(0xd2253531));
  uint32_t x4;
  uint32_t x5;
  fiat_secp256k1_mulx_u32(&x4, &x5, x2, UINT32_C(0xffffffff));
  uint32_t x6;
  uint32_t x7;
  fiat_secp256k1_mulx_u32(&x6, &x7, x2, UINT32_C(0xffffffff));
  uint32_t x8;
  uint32_t x9;
  fiat_secp256k1_mulx_u32(&x8, &x9, x2, UINT32_C(0xffffffff));
  uint32_t x10;
  uint32_t x11;
  fiat_secp256k1_mulx_u32(&x10, &x11, x2, UINT32_C(0xffffffff));
  uint32_t x12;
  uint32_t x13;
  fiat_secp256k1_mulx_u32(&x12, &x13, x2, UINT32_C(0xffffffff));
  uint32_t x14;
  uint32_t x15;
  fiat_secp256k1_mulx_u32(&x14, &x15, x2, UINT32_C(0xffffffff));
  uint32_t x16;
  uint32_t x17;
  fiat_secp256k1_mulx_u32(&x16, &x17, x2, UINT32_C(0xfffffffe));
  uint32_t x18;
  uint32_t x19;
  fiat_secp256k1_mulx_u32(&x18, &x19, x2, UINT32_C(0xfffffc2f));
  uint32_t x20;
  fiat_secp256k1_uint1 x21;
  fiat_secp256k1_addcarryx_u32(&x20, &x21, 0x0, x19, x16);
  uint32_t x22;
  fiat_secp256k1_uint1 x23;
  fiat_secp256k1_addcarryx_u32(&x22, &x23, x21, x17, x14);
  uint32_t x24;
  fiat_secp256k1_uint1 x25;
  fiat_secp256k1_addcarryx_u32(&x24, &x25, x23, x15, x12);
  uint32_t x26;
  fiat_secp256k1_uint1 x27;
  fiat_secp256k1_addcarryx_u32(&x26, &x27, x25, x13, x10);
  uint32_t x28;
  fiat_secp256k1_uint1 x29;
  fiat_secp256k1_addcarryx_u32(&x28, &x29, x27, x11, x8);
  uint32_t x30;
  fiat_secp256k1_uint1 x31;
  fiat_secp256k1_addcarryx_u32(&x30, &x31, x29, x9, x6);
  uint32_t x32;
  fiat_secp256k1_uint1 x33;
  fiat_secp256k1_addcarryx_u32(&x32, &x33, x31, x7, x4);
  uint32_t x34;
  fiat_secp256k1_uint1 x35;
  fiat_secp256k1_addcarryx_u32(&x34, &x35, 0x0, x1, x18);
  uint32_t x36;
  fiat_secp256k1_uint1 x37;
  fiat_secp256k1_addcarryx_u32(&x36, &x37, x35, 0x0, x20);
  uint32_t x38;
  fiat_secp256k1_uint1 x39;
  fiat_secp256k1_addcarryx_u32(&x38, &x39, x37, 0x0, x22);
  uint32_t x40;
  fiat_secp256k1_uint1 x41;
  fiat_secp256k1_addcarryx_u32(&x40, &x41, x39, 0x0, x24);
  uint32_t x42;
  fiat_secp256k1_uint1 x43;
  fiat_secp256k1_addcarryx_u32(&x42, &x43, x41, 0x0, x26);
  uint32_t x44;
  fiat_secp256k1_uint1 x45;
  fiat_secp256k1_addcarryx_u32(&x44, &x45, x43, 0x0, x28);
  uint32_t x46;
  fiat_secp256k1_uint1 x47;
  fiat_secp256k1_addcarryx_u32(&x46, &x47, x45, 0x0, x30);
  uint32_t x48;
  fiat_secp256k1_uint1 x49;
  fiat_secp256k1_addcarryx_u32(&x48, &x49, x47, 0x0, x32);
  uint32_t x50;
  fiat_secp256k1_uint1 x51;
  fiat_secp256k1_addcarryx_u32(&x50, &x51, x33, x5, 0x0);
  uint32_t x52;
  fiat_secp256k1_uint1 x53;
  fiat_secp256k1_addcarryx_u32(&x52, &x53, x49, 0x0, x50);
  uint32_t x54;
  fiat_secp256k1_uint1 x55;
  fiat_secp256k1_addcarryx_u32(&x54, &x55, 0x0, x36, (arg1[1]));
  uint32_t x56;
  fiat_secp256k1_uint1 x57;
  fiat_secp256k1_addcarryx_u32(&x56, &x57, x55, x38, 0x0);
  uint32_t x58;
  fiat_secp256k1_uint1 x59;
  fiat_secp256k1_addcarryx_u32(&x58, &x59, x57, x40, 0x0);
  uint32_t x60;
  fiat_secp256k1_uint1 x61;
  fiat_secp256k1_addcarryx_u32(&x60, &x61, x59, x42, 0x0);
  uint32_t x62;
  fiat_secp256k1_uint1 x63;
  fiat_secp256k1_addcarryx_u32(&x62, &x63, x61, x44, 0x0);
  uint32_t x64;
  fiat_secp256k1_uint1 x65;
  fiat_secp256k1_addcarryx_u32(&x64, &x65, x63, x46, 0x0);
  uint32_t x66;
  fiat_secp256k1_uint1 x67;
  fiat_secp256k1_addcarryx_u32(&x66, &x67, x65, x48, 0x0);
  uint32_t x68;
  fiat_secp256k1_uint1 x69;
  fiat_secp256k1_addcarryx_u32(&x68, &x69, x67, x52, 0x0);
  uint32_t x70;
  uint32_t x71;
  fiat_secp256k1_mulx_u32(&x70, &x71, x54, UINT32_C(0xd2253531));
  uint32_t x72;
  uint32_t x73;
  fiat_secp256k1_mulx_u32(&x72, &x73, x70, UINT32_C(0xffffffff));
  uint32_t x74;
  uint32_t x75;
  fiat_secp256k1_mulx_u32(&x74, &x75, x70, UINT32_C(0xffffffff));
  uint32_t x76;
  uint32_t x77;
  fiat_secp256k1_mulx_u32(&x76, &x77, x70, UINT32_C(0xffffffff));
  uint32_t x78;
  uint32_t x79;
  fiat_secp256k1_mulx_u32(&x78, &x79, x70, UINT32_C(0xffffffff));
  uint32_t x80;
  uint32_t x81;
  fiat_secp256k1_mulx_u32(&x80, &x81, x70, UINT32_C(0xffffffff));
  uint32_t x82;
  uint32_t x83;
  fiat_secp256k1_mulx_u32(&x82, &x83, x70, UINT32_C(0xffffffff));
  uint32_t x84;
  uint32_t x85;
  fiat_secp256k1_mulx_u32(&x84, &x85, x70, UINT32_C(0xfffffffe));
  uint32_t x86;
  uint32_t x87;
  fiat_secp256k1_mulx_u32(&x86, &x87, x70, UINT32_C(0xfffffc2f));
  uint32_t x88;
  fiat_secp256k1_uint1 x89;
  fiat_secp256k1_addcarryx_u32(&x88, &x89, 0x0, x87, x84);
  uint32_t x90;
  fiat_secp256k1_uint1 x91;
  fiat_secp256k1_addcarryx_u32(&x90, &x91, x89, x85, x82);
  uint32_t x92;
  fiat_secp256k1_uint1 x93;
  fiat_secp256k1_addcarryx_u32(&x92, &x93, x91, x83, x80);
  uint32_t x94;
  fiat_secp256k1_uint1 x95;
  fiat_secp256k1_addcarryx_u32(&x94, &x95, x93, x81, x78);
  uint32_t x96;
  fiat_secp256k1_uint1 x97;
  fiat_secp256k1_addcarryx_u32(&x96, &x97, x95, x79, x76);
  uint32_t x98;
  fiat_secp256k1_uint1 x99;
  fiat_secp256k1_addcarryx_u32(&x98, &x99, x97, x77, x74);
  uint32_t x100;
  fiat_secp256k1_uint1 x101;
  fiat_secp256k1_addcarryx_u32(&x100, &x101, x99, x75, x72);
  uint32_t x102;
  fiat_secp256k1_uint1 x103;
  fiat_secp256k1_addcarryx_u32(&x102, &x103, 0x0, x54, x86);
  uint32_t x104;
  fiat_secp256k1_uint1 x105;
  fiat_secp256k1_addcarryx_u32(&x104, &x105, x103, x56, x88);
  uint32_t x106;
  fiat_secp256k1_uint1 x107;
  fiat_secp256k1_addcarryx_u32(&x106, &x107, x105, x58, x90);
  uint32_t x108;
  fiat_secp256k1_uint1 x109;
  fiat_secp256k1_addcarryx_u32(&x108, &x109, x107, x60, x92);
  uint32_t x110;
  fiat_secp256k1_uint1 x111;
  fiat_secp256k1_addcarryx_u32(&x110, &x111, x109, x62, x94);
  uint32_t x112;
  fiat_secp256k1_uint1 x113;
  fiat_secp256k1_addcarryx_u32(&x112, &x113, x111, x64, x96);
  uint32_t x114;
  fiat_secp256k1_uint1 x115;
  fiat_secp256k1_addcarryx_u32(&x114, &x115, x113, x66, x98);
  uint32_t x116;
  fiat_secp256k1_uint1 x117;
  fiat_secp256k1_addcarryx_u32(&x116, &x117, x115, x68, x100);
  uint32_t x118;
  fiat_secp256k1_uint1 x119;
  fiat_secp256k1_addcarryx_u32(&x118, &x119, x101, x73, 0x0);
  uint32_t x120;
  fiat_secp256k1_uint1 x121;
  fiat_secp256k1_addcarryx_u32(&x120, &x121, x53, 0x0, 0x0);
  uint32_t x122;
  fiat_secp256k1_uint1 x123;
  fiat_secp256k1_addcarryx_u32(&x122, &x123, x69, (fiat_secp256k1_uint1)x120, 0x0);
  uint32_t x124;
  fiat_secp256k1_uint1 x125;
  fiat_secp256k1_addcarryx_u32(&x124, &x125, x117, x122, x118);
  uint32_t x126;
  fiat_secp256k1_uint1 x127;
  fiat_secp256k1_addcarryx_u32(&x126, &x127, 0x0, x104, (arg1[2]));
  uint32_t x128;
  fiat_secp256k1_uint1 x129;
  fiat_secp256k1_addcarryx_u32(&x128, &x129, x127, x106, 0x0);
  uint32_t x130;
  fiat_secp256k1_uint1 x131;
  fiat_secp256k1_addcarryx_u32(&x130, &x131, x129, x108, 0x0);
  uint32_t x132;
  fiat_secp256k1_uint1 x133;
  fiat_secp256k1_addcarryx_u32(&x132, &x133, x131, x110, 0x0);
  uint32_t x134;
  fiat_secp256k1_uint1 x135;
  fiat_secp256k1_addcarryx_u32(&x134, &x135, x133, x112, 0x0);
  uint32_t x136;
  fiat_secp256k1_uint1 x137;
  fiat_secp256k1_addcarryx_u32(&x136, &x137, x135, x114, 0x0);
  uint32_t x138;
  fiat_secp256k1_uint1 x139;
  fiat_secp256k1_addcarryx_u32(&x138, &x139, x137, x116, 0x0);
  uint32_t x140;
  fiat_secp256k1_uint1 x141;
  fiat_secp256k1_addcarryx_u32(&x140, &x141, x139, x124, 0x0);
  uint32_t x142;
  uint32_t x143;
  fiat_secp256k1_mulx_u32(&x142, &x143, x126, UINT32_C(0xd2253531));
  uint32_t x144;
  uint32_t x145;
  fiat_secp256k1_mulx_u32(&x144, &x145, x142, UINT32_C(0xffffffff));
  uint32_t x146;
  uint32_t x147;
  fiat_secp256k1_mulx_u32(&x146, &x147, x142, UINT32_C(0xffffffff));
  uint32_t x148;
  uint32_t x149;
  fiat_secp256k1_mulx_u32(&x148, &x149, x142, UINT32_C(0xffffffff));
  uint32_t x150;
  uint32_t x151;
  fiat_secp256k1_mulx_u32(&x150, &x151, x142, UINT32_C(0xffffffff));
  uint32_t x152;
  uint32_t x153;
  fiat_secp256k1_mulx_u32(&x152, &x153, x142, UINT32_C(0xffffffff));
  uint32_t x154;
  uint32_t x155;
  fiat_secp256k1_mulx_u32(&x154, &x155, x142, UINT32_C(0xffffffff));
  uint32_t x156;
  uint32_t x157;
  fiat_secp256k1_mulx_u32(&x156, &x157, x142, UINT32_C(0xfffffffe));
  uint32_t x158;
  uint32_t x159;
  fiat_secp256k1_mulx_u32(&x158, &x159, x142, UINT32_C(0xfffffc2f));
  uint32_t x160;
  fiat_secp256k1_uint1 x161;
  fiat_secp256k1_addcarryx_u32(&x160, &x161, 0x0, x159, x156);
  uint32_t x162;
  fiat_secp256k1_uint1 x163;
  fiat_secp256k1_addcarryx_u32(&x162, &x163, x161, x157, x154);
  uint32_t x164;
  fiat_secp256k1_uint1 x165;
  fiat_secp256k1_addcarryx_u32(&x164, &x165, x163, x155, x152);
  uint32_t x166;
  fiat_secp256k1_uint1 x167;
  fiat_secp256k1_addcarryx_u32(&x166, &x167, x165, x153, x150);
  uint32_t x168;
  fiat_secp256k1_uint1 x169;
  fiat_secp256k1_addcarryx_u32(&x168, &x169, x167, x151, x148);
  uint32_t x170;
  fiat_secp256k1_uint1 x171;
  fiat_secp256k1_addcarryx_u32(&x170, &x171, x169, x149, x146);
  uint32_t x172;
  fiat_secp256k1_uint1 x173;
  fiat_secp256k1_addcarryx_u32(&x172, &x173, x171, x147, x144);
  uint32_t x174;
  fiat_secp256k1_uint1 x175;
  fiat_secp256k1_addcarryx_u32(&x174, &x175, 0x0, x126, x158);
  uint32_t x176;
  fiat_secp256k1_uint1 x177;
  fiat_secp256k1_addcarryx_u32(&x176, &x177, x175, x128, x160);
  uint32_t x178;
  fiat_secp256k1_uint1 x179;
  fiat_secp256k1_addcarryx_u32(&x178, &x179, x177, x130, x162);
  uint32_t x180;
  fiat_secp256k1_uint1 x181;
  fiat_secp256k1_addcarryx_u32(&x180, &x181, x179, x132, x164);
  uint32_t x182;
  fiat_secp256k1_uint1 x183;
  fiat_secp256k1_addcarryx_u32(&x182, &x183, x181, x134, x166);
  uint32_t x184;
  fiat_secp256k1_uint1 x185;
  fiat_secp256k1_addcarryx_u32(&x184, &x185, x183, x136, x168);
  uint32_t x186;
  fiat_secp256k1_uint1 x187;
  fiat_secp256k1_addcarryx_u32(&x186, &x187, x185, x138, x170);
  uint32_t x188;
  fiat_secp256k1_uint1 x189;
  fiat_secp256k1_addcarryx_u32(&x188, &x189, x187, x140, x172);
  uint32_t x190;
  fiat_secp256k1_uint1 x191;
  fiat_secp256k1_addcarryx_u32(&x190, &x191, x173, x145, 0x0);
  uint32_t x192;
  fiat_secp256k1_uint1 x193;
  fiat_secp256k1_addcarryx_u32(&x192, &x193, x125, 0x0, 0x0);
  uint32_t x194;
  fiat_secp256k1_uint1 x195;
  fiat_secp256k1_addcarryx_u32(&x194, &x195, x141, (fiat_secp256k1_uint1)x192, 0x0);
  uint32_t x196;
  fiat_secp256k1_uint1 x197;
  fiat_secp256k1_addcarryx_u32(&x196, &x197, x189, x194, x190);
  uint32_t x198;
  fiat_secp256k1_uint1 x199;
  fiat_secp256k1_addcarryx_u32(&x198, &x199, 0x0, x176, (arg1[3]));
  uint32_t x200;
  fiat_secp256k1_uint1 x201;
  fiat_secp256k1_addcarryx_u32(&x200, &x201, x199, x178, 0x0);
  uint32_t x202;
  fiat_secp256k1_uint1 x203;
  fiat_secp256k1_addcarryx_u32(&x202, &x203, x201, x180, 0x0);
  uint32_t x204;
  fiat_secp256k1_uint1 x205;
  fiat_secp256k1_addcarryx_u32(&x204, &x205, x203, x182, 0x0);
  uint32_t x206;
  fiat_secp256k1_uint1 x207;
  fiat_secp256k1_addcarryx_u32(&x206, &x207, x205, x184, 0x0);
  uint32_t x208;
  fiat_secp256k1_uint1 x209;
  fiat_secp256k1_addcarryx_u32(&x208, &x209, x207, x186, 0x0);
  uint32_t x210;
  fiat_secp256k1_uint1 x211;
  fiat_secp256k1_addcarryx_u32(&x210, &x211, x209, x188, 0x0);
  uint32_t x212;
  fiat_secp256k1_uint1 x213;
  fiat_secp256k1_addcarryx_u32(&x212, &x213, x211, x196, 0x0);
  uint32_t x214;
  uint32_t x215;
  fiat_secp256k1_mulx_u32(&x214, &x215, x198, UINT32_C(0xd2253531));
  uint32_t x216;
  uint32_t x217;
  fiat_secp256k1_mulx_u32(&x216, &x217, x214, UINT32_C(0xffffffff));
  uint32_t x218;
  uint32_t x219;
  fiat_secp256k1_mulx_u32(&x218, &x219, x214, UINT32_C(0xffffffff));
  uint32_t x220;
  uint32_t x221;
  fiat_secp256k1_mulx_u32(&x220, &x221, x214, UINT32_C(0xffffffff));
  uint32_t x222;
  uint32_t x223;
  fiat_secp256k1_mulx_u32(&x222, &x223, x214, UINT32_C(0xffffffff));
  uint32_t x224;
  uint32_t x225;
  fiat_secp256k1_mulx_u32(&x224, &x225, x214, UINT32_C(0xffffffff));
  uint32_t x226;
  uint32_t x227;
  fiat_secp256k1_mulx_u32(&x226, &x227, x214, UINT32_C(0xffffffff));
  uint32_t x228;
  uint32_t x229;
  fiat_secp256k1_mulx_u32(&x228, &x229, x214, UINT32_C(0xfffffffe));
  uint32_t x230;
  uint32_t x231;
  fiat_secp256k1_mulx_u32(&x230, &x231, x214, UINT32_C(0xfffffc2f));
  uint32_t x232;
  fiat_secp256k1_uint1 x233;
  fiat_secp256k1_addcarryx_u32(&x232, &x233, 0x0, x231, x228);
  uint32_t x234;
  fiat_secp256k1_uint1 x235;
  fiat_secp256k1_addcarryx_u32(&x234, &x235, x233, x229, x226);
  uint32_t x236;
  fiat_secp256k1_uint1 x237;
  fiat_secp256k1_addcarryx_u32(&x236, &x237, x235, x227, x224);
  uint32_t x238;
  fiat_secp256k1_uint1 x239;
  fiat_secp256k1_addcarryx_u32(&x238, &x239, x237, x225, x222);
  uint32_t x240;
  fiat_secp256k1_uint1 x241;
  fiat_secp256k1_addcarryx_u32(&x240, &x241, x239, x223, x220);
  uint32_t x242;
  fiat_secp256k1_uint1 x243;
  fiat_secp256k1_addcarryx_u32(&x242, &x243, x241, x221, x218);
  uint32_t x244;
  fiat_secp256k1_uint1 x245;
  fiat_secp256k1_addcarryx_u32(&x244, &x245, x243, x219, x216);
  uint32_t x246;
  fiat_secp256k1_uint1 x247;
  fiat_secp256k1_addcarryx_u32(&x246, &x247, 0x0, x198, x230);
  uint32_t x248;
  fiat_secp256k1_uint1 x249;
  fiat_secp256k1_addcarryx_u32(&x248, &x249, x247, x200, x232);
  uint32_t x250;
  fiat_secp256k1_uint1 x251;
  fiat_secp256k1_addcarryx_u32(&x250, &x251, x249, x202, x234);
  uint32_t x252;
  fiat_secp256k1_uint1 x253;
  fiat_secp256k1_addcarryx_u32(&x252, &x253, x251, x204, x236);
  uint32_t x254;
  fiat_secp256k1_uint1 x255;
  fiat_secp256k1_addcarryx_u32(&x254, &x255, x253, x206, x238);
  uint32_t x256;
  fiat_secp256k1_uint1 x257;
  fiat_secp256k1_addcarryx_u32(&x256, &x257, x255, x208, x240);
  uint32_t x258;
  fiat_secp256k1_uint1 x259;
  fiat_secp256k1_addcarryx_u32(&x258, &x259, x257, x210, x242);
  uint32_t x260;
  fiat_secp256k1_uint1 x261;
  fiat_secp256k1_addcarryx_u32(&x260, &x261, x259, x212, x244);
  uint32_t x262;
  fiat_secp256k1_uint1 x263;
  fiat_secp256k1_addcarryx_u32(&x262, &x263, x245, x217, 0x0);
  uint32_t x264;
  fiat_secp256k1_uint1 x265;
  fiat_secp256k1_addcarryx_u32(&x264, &x265, x197, 0x0, 0x0);
  uint32_t x266;
  fiat_secp256k1_uint1 x267;
  fiat_secp256k1_addcarryx_u32(&x266, &x267, x213, (fiat_secp256k1_uint1)x264, 0x0);
  uint32_t x268;
  fiat_secp256k1_uint1 x269;
  fiat_secp256k1_addcarryx_u32(&x268, &x269, x261, x266, x262);
  uint32_t x270;
  fiat_secp256k1_uint1 x271;
  fiat_secp256k1_addcarryx_u32(&x270, &x271, 0x0, x248, (arg1[4]));
  uint32_t x272;
  fiat_secp256k1_uint1 x273;
  fiat_secp256k1_addcarryx_u32(&x272, &x273, x271, x250, 0x0);
  uint32_t x274;
  fiat_secp256k1_uint1 x275;
  fiat_secp256k1_addcarryx_u32(&x274, &x275, x273, x252, 0x0);
  uint32_t x276;
  fiat_secp256k1_uint1 x277;
  fiat_secp256k1_addcarryx_u32(&x276, &x277, x275, x254, 0x0);
  uint32_t x278;
  fiat_secp256k1_uint1 x279;
  fiat_secp256k1_addcarryx_u32(&x278, &x279, x277, x256, 0x0);
  uint32_t x280;
  fiat_secp256k1_uint1 x281;
  fiat_secp256k1_addcarryx_u32(&x280, &x281, x279, x258, 0x0);
  uint32_t x282;
  fiat_secp256k1_uint1 x283;
  fiat_secp256k1_addcarryx_u32(&x282, &x283, x281, x260, 0x0);
  uint32_t x284;
  fiat_secp256k1_uint1 x285;
  fiat_secp256k1_addcarryx_u32(&x284, &x285, x283, x268, 0x0);
  uint32_t x286;
  uint32_t x287;
  fiat_secp256k1_mulx_u32(&x286, &x287, x270, UINT32_C(0xd2253531));
  uint32_t x288;
  uint32_t x289;
  fiat_secp256k1_mulx_u32(&x288, &x289, x286, UINT32_C(0xffffffff));
  uint32_t x290;
  uint32_t x291;
  fiat_secp256k1_mulx_u32(&x290, &x291, x286, UINT32_C(0xffffffff));
  uint32_t x292;
  uint32_t x293;
  fiat_secp256k1_mulx_u32(&x292, &x293, x286, UINT32_C(0xffffffff));
  uint32_t x294;
  uint32_t x295;
  fiat_secp256k1_mulx_u32(&x294, &x295, x286, UINT32_C(0xffffffff));
  uint32_t x296;
  uint32_t x297;
  fiat_secp256k1_mulx_u32(&x296, &x297, x286, UINT32_C(0xffffffff));
  uint32_t x298;
  uint32_t x299;
  fiat_secp256k1_mulx_u32(&x298, &x299, x286, UINT32_C(0xffffffff));
  uint32_t x300;
  uint32_t x301;
  fiat_secp256k1_mulx_u32(&x300, &x301, x286, UINT32_C(0xfffffffe));
  uint32_t x302;
  uint32_t x303;
  fiat_secp256k1_mulx_u32(&x302, &x303, x286, UINT32_C(0xfffffc2f));
  uint32_t x304;
  fiat_secp256k1_uint1 x305;
  fiat_secp256k1_addcarryx_u32(&x304, &x305, 0x0, x303, x300);
  uint32_t x306;
  fiat_secp256k1_uint1 x307;
  fiat_secp256k1_addcarryx_u32(&x306, &x307, x305, x301, x298);
  uint32_t x308;
  fiat_secp256k1_uint1 x309;
  fiat_secp256k1_addcarryx_u32(&x308, &x309, x307, x299, x296);
  uint32_t x310;
  fiat_secp256k1_uint1 x311;
  fiat_secp256k1_addcarryx_u32(&x310, &x311, x309, x297, x294);
  uint32_t x312;
  fiat_secp256k1_uint1 x313;
  fiat_secp256k1_addcarryx_u32(&x312, &x313, x311, x295, x292);
  uint32_t x314;
  fiat_secp256k1_uint1 x315;
  fiat_secp256k1_addcarryx_u32(&x314, &x315, x313, x293, x290);
  uint32_t x316;
  fiat_secp256k1_uint1 x317;
  fiat_secp256k1_addcarryx_u32(&x316, &x317, x315, x291, x288);
  uint32_t x318;
  fiat_secp256k1_uint1 x319;
  fiat_secp256k1_addcarryx_u32(&x318, &x319, 0x0, x270, x302);
  uint32_t x320;
  fiat_secp256k1_uint1 x321;
  fiat_secp256k1_addcarryx_u32(&x320, &x321, x319, x272, x304);
  uint32_t x322;
  fiat_secp256k1_uint1 x323;
  fiat_secp256k1_addcarryx_u32(&x322, &x323, x321, x274, x306);
  uint32_t x324;
  fiat_secp256k1_uint1 x325;
  fiat_secp256k1_addcarryx_u32(&x324, &x325, x323, x276, x308);
  uint32_t x326;
  fiat_secp256k1_uint1 x327;
  fiat_secp256k1_addcarryx_u32(&x326, &x327, x325, x278, x310);
  uint32_t x328;
  fiat_secp256k1_uint1 x329;
  fiat_secp256k1_addcarryx_u32(&x328, &x329, x327, x280, x312);
  uint32_t x330;
  fiat_secp256k1_uint1 x331;
  fiat_secp256k1_addcarryx_u32(&x330, &x331, x329, x282, x314);
  uint32_t x332;
  fiat_secp256k1_uint1 x333;
  fiat_secp256k1_addcarryx_u32(&x332, &x333, x331, x284, x316);
  uint32_t x334;
  fiat_secp256k1_uint1 x335;
  fiat_secp256k1_addcarryx_u32(&x334, &x335, x317, x289, 0x0);
  uint32_t x336;
  fiat_secp256k1_uint1 x337;
  fiat_secp256k1_addcarryx_u32(&x336, &x337, x269, 0x0, 0x0);
  uint32_t x338;
  fiat_secp256k1_uint1 x339;
  fiat_secp256k1_addcarryx_u32(&x338, &x339, x285, (fiat_secp256k1_uint1)x336, 0x0);
  uint32_t x340;
  fiat_secp256k1_uint1 x341;
  fiat_secp256k1_addcarryx_u32(&x340, &x341, x333, x338, x334);
  uint32_t x342;
  fiat_secp256k1_uint1 x343;
  fiat_secp256k1_addcarryx_u32(&x342, &x343, 0x0, x320, (arg1[5]));
  uint32_t x344;
  fiat_secp256k1_uint1 x345;
  fiat_secp256k1_addcarryx_u32(&x344, &x345, x343, x322, 0x0);
  uint32_t x346;
  fiat_secp256k1_uint1 x347;
  fiat_secp256k1_addcarryx_u32(&x346, &x347, x345, x324, 0x0);
  uint32_t x348;
  fiat_secp256k1_uint1 x349;
  fiat_secp256k1_addcarryx_u32(&x348, &x349, x347, x326, 0x0);
  uint32_t x350;
  fiat_secp256k1_uint1 x351;
  fiat_secp256k1_addcarryx_u32(&x350, &x351, x349, x328, 0x0);
  uint32_t x352;
  fiat_secp256k1_uint1 x353;
  fiat_secp256k1_addcarryx_u32(&x352, &x353, x351, x330, 0x0);
  uint32_t x354;
  fiat_secp256k1_uint1 x355;
  fiat_secp256k1_addcarryx_u32(&x354, &x355, x353, x332, 0x0);
  uint32_t x356;
  fiat_secp256k1_uint1 x357;
  fiat_secp256k1_addcarryx_u32(&x356, &x357, x355, x340, 0x0);
  uint32_t x358;
  uint32_t x359;
  fiat_secp256k1_mulx_u32(&x358, &x359, x342, UINT32_C(0xd2253531));
  uint32_t x360;
  uint32_t x361;
  fiat_secp256k1_mulx_u32(&x360, &x361, x358, UINT32_C(0xffffffff));
  uint32_t x362;
  uint32_t x363;
  fiat_secp256k1_mulx_u32(&x362, &x363, x358, UINT32_C(0xffffffff));
  uint32_t x364;
  uint32_t x365;
  fiat_secp256k1_mulx_u32(&x364, &x365, x358, UINT32_C(0xffffffff));
  uint32_t x366;
  uint32_t x367;
  fiat_secp256k1_mulx_u32(&x366, &x367, x358, UINT32_C(0xffffffff));
  uint32_t x368;
  uint32_t x369;
  fiat_secp256k1_mulx_u32(&x368, &x369, x358, UINT32_C(0xffffffff));
  uint32_t x370;
  uint32_t x371;
  fiat_secp256k1_mulx_u32(&x370, &x371, x358, UINT32_C(0xffffffff));
  uint32_t x372;
  uint32_t x373;
  fiat_secp256k1_mulx_u32(&x372, &x373, x358, UINT32_C(0xfffffffe));
  uint32_t x374;
  uint32_t x375;
  fiat_secp256k1_mulx_u32(&x374, &x375, x358, UINT32_C(0xfffffc2f));
  uint32_t x376;
  fiat_secp256k1_uint1 x377;
  fiat_secp256k1_addcarryx_u32(&x376, &x377, 0x0, x375, x372);
  uint32_t x378;
  fiat_secp256k1_uint1 x379;
  fiat_secp256k1_addcarryx_u32(&x378, &x379, x377, x373, x370);
  uint32_t x380;
  fiat_secp256k1_uint1 x381;
  fiat_secp256k1_addcarryx_u32(&x380, &x381, x379, x371, x368);
  uint32_t x382;
  fiat_secp256k1_uint1 x383;
  fiat_secp256k1_addcarryx_u32(&x382, &x383, x381, x369, x366);
  uint32_t x384;
  fiat_secp256k1_uint1 x385;
  fiat_secp256k1_addcarryx_u32(&x384, &x385, x383, x367, x364);
  uint32_t x386;
  fiat_secp256k1_uint1 x387;
  fiat_secp256k1_addcarryx_u32(&x386, &x387, x385, x365, x362);
  uint32_t x388;
  fiat_secp256k1_uint1 x389;
  fiat_secp256k1_addcarryx_u32(&x388, &x389, x387, x363, x360);
  uint32_t x390;
  fiat_secp256k1_uint1 x391;
  fiat_secp256k1_addcarryx_u32(&x390, &x391, 0x0, x342, x374);
  uint32_t x392;
  fiat_secp256k1_uint1 x393;
  fiat_secp256k1_addcarryx_u32(&x392, &x393, x391, x344, x376);
  uint32_t x394;
  fiat_secp256k1_uint1 x395;
  fiat_secp256k1_addcarryx_u32(&x394, &x395, x393, x346, x378);
  uint32_t x396;
  fiat_secp256k1_uint1 x397;
  fiat_secp256k1_addcarryx_u32(&x396, &x397, x395, x348, x380);
  uint32_t x398;
  fiat_secp256k1_uint1 x399;
  fiat_secp256k1_addcarryx_u32(&x398, &x399, x397, x350, x382);
  uint32_t x400;
  fiat_secp256k1_uint1 x401;
  fiat_secp256k1_addcarryx_u32(&x400, &x401, x399, x352, x384);
  uint32_t x402;
  fiat_secp256k1_uint1 x403;
  fiat_secp256k1_addcarryx_u32(&x402, &x403, x401, x354, x386);
  uint32_t x404;
  fiat_secp256k1_uint1 x405;
  fiat_secp256k1_addcarryx_u32(&x404, &x405, x403, x356, x388);
  uint32_t x406;
  fiat_secp256k1_uint1 x407;
  fiat_secp256k1_addcarryx_u32(&x406, &x407, x389, x361, 0x0);
  uint32_t x408;
  fiat_secp256k1_uint1 x409;
  fiat_secp256k1_addcarryx_u32(&x408, &x409, x341, 0x0, 0x0);
  uint32_t x410;
  fiat_secp256k1_uint1 x411;
  fiat_secp256k1_addcarryx_u32(&x410, &x411, x357, (fiat_secp256k1_uint1)x408, 0x0);
  uint32_t x412;
  fiat_secp256k1_uint1 x413;
  fiat_secp256k1_addcarryx_u32(&x412, &x413, x405, x410, x406);
  uint32_t x414;
  fiat_secp256k1_uint1 x415;
  fiat_secp256k1_addcarryx_u32(&x414, &x415, 0x0, x392, (arg1[6]));
  uint32_t x416;
  fiat_secp256k1_uint1 x417;
  fiat_secp256k1_addcarryx_u32(&x416, &x417, x415, x394, 0x0);
  uint32_t x418;
  fiat_secp256k1_uint1 x419;
  fiat_secp256k1_addcarryx_u32(&x418, &x419, x417, x396, 0x0);
  uint32_t x420;
  fiat_secp256k1_uint1 x421;
  fiat_secp256k1_addcarryx_u32(&x420, &x421, x419, x398, 0x0);
  uint32_t x422;
  fiat_secp256k1_uint1 x423;
  fiat_secp256k1_addcarryx_u32(&x422, &x423, x421, x400, 0x0);
  uint32_t x424;
  fiat_secp256k1_uint1 x425;
  fiat_secp256k1_addcarryx_u32(&x424, &x425, x423, x402, 0x0);
  uint32_t x426;
  fiat_secp256k1_uint1 x427;
  fiat_secp256k1_addcarryx_u32(&x426, &x427, x425, x404, 0x0);
  uint32_t x428;
  fiat_secp256k1_uint1 x429;
  fiat_secp256k1_addcarryx_u32(&x428, &x429, x427, x412, 0x0);
  uint32_t x430;
  uint32_t x431;
  fiat_secp256k1_mulx_u32(&x430, &x431, x414, UINT32_C(0xd2253531));
  uint32_t x432;
  uint32_t x433;
  fiat_secp256k1_mulx_u32(&x432, &x433, x430, UINT32_C(0xffffffff));
  uint32_t x434;
  uint32_t x435;
  fiat_secp256k1_mulx_u32(&x434, &x435, x430, UINT32_C(0xffffffff));
  uint32_t x436;
  uint32_t x437;
  fiat_secp256k1_mulx_u32(&x436, &x437, x430, UINT32_C(0xffffffff));
  uint32_t x438;
  uint32_t x439;
  fiat_secp256k1_mulx_u32(&x438, &x439, x430, UINT32_C(0xffffffff));
  uint32_t x440;
  uint32_t x441;
  fiat_secp256k1_mulx_u32(&x440, &x441, x430, UINT32_C(0xffffffff));
  uint32_t x442;
  uint32_t x443;
  fiat_secp256k1_mulx_u32(&x442, &x443, x430, UINT32_C(0xffffffff));
  uint32_t x444;
  uint32_t x445;
  fiat_secp256k1_mulx_u32(&x444, &x445, x430, UINT32_C(0xfffffffe));
  uint32_t x446;
  uint32_t x447;
  fiat_secp256k1_mulx_u32(&x446, &x447, x430, UINT32_C(0xfffffc2f));
  uint32_t x448;
  fiat_secp256k1_uint1 x449;
  fiat_secp256k1_addcarryx_u32(&x448, &x449, 0x0, x447, x444);
  uint32_t x450;
  fiat_secp256k1_uint1 x451;
  fiat_secp256k1_addcarryx_u32(&x450, &x451, x449, x445, x442);
  uint32_t x452;
  fiat_secp256k1_uint1 x453;
  fiat_secp256k1_addcarryx_u32(&x452, &x453, x451, x443, x440);
  uint32_t x454;
  fiat_secp256k1_uint1 x455;
  fiat_secp256k1_addcarryx_u32(&x454, &x455, x453, x441, x438);
  uint32_t x456;
  fiat_secp256k1_uint1 x457;
  fiat_secp256k1_addcarryx_u32(&x456, &x457, x455, x439, x436);
  uint32_t x458;
  fiat_secp256k1_uint1 x459;
  fiat_secp256k1_addcarryx_u32(&x458, &x459, x457, x437, x434);
  uint32_t x460;
  fiat_secp256k1_uint1 x461;
  fiat_secp256k1_addcarryx_u32(&x460, &x461, x459, x435, x432);
  uint32_t x462;
  fiat_secp256k1_uint1 x463;
  fiat_secp256k1_addcarryx_u32(&x462, &x463, 0x0, x414, x446);
  uint32_t x464;
  fiat_secp256k1_uint1 x465;
  fiat_secp256k1_addcarryx_u32(&x464, &x465, x463, x416, x448);
  uint32_t x466;
  fiat_secp256k1_uint1 x467;
  fiat_secp256k1_addcarryx_u32(&x466, &x467, x465, x418, x450);
  uint32_t x468;
  fiat_secp256k1_uint1 x469;
  fiat_secp256k1_addcarryx_u32(&x468, &x469, x467, x420, x452);
  uint32_t x470;
  fiat_secp256k1_uint1 x471;
  fiat_secp256k1_addcarryx_u32(&x470, &x471, x469, x422, x454);
  uint32_t x472;
  fiat_secp256k1_uint1 x473;
  fiat_secp256k1_addcarryx_u32(&x472, &x473, x471, x424, x456);
  uint32_t x474;
  fiat_secp256k1_uint1 x475;
  fiat_secp256k1_addcarryx_u32(&x474, &x475, x473, x426, x458);
  uint32_t x476;
  fiat_secp256k1_uint1 x477;
  fiat_secp256k1_addcarryx_u32(&x476, &x477, x475, x428, x460);
  uint32_t x478;
  fiat_secp256k1_uint1 x479;
  fiat_secp256k1_addcarryx_u32(&x478, &x479, x461, x433, 0x0);
  uint32_t x480;
  fiat_secp256k1_uint1 x481;
  fiat_secp256k1_addcarryx_u32(&x480, &x481, x413, 0x0, 0x0);
  uint32_t x482;
  fiat_secp256k1_uint1 x483;
  fiat_secp256k1_addcarryx_u32(&x482, &x483, x429, (fiat_secp256k1_uint1)x480, 0x0);
  uint32_t x484;
  fiat_secp256k1_uint1 x485;
  fiat_secp256k1_addcarryx_u32(&x484, &x485, x477, x482, x478);
  uint32_t x486;
  fiat_secp256k1_uint1 x487;
  fiat_secp256k1_addcarryx_u32(&x486, &x487, 0x0, x464, (arg1[7]));
  uint32_t x488;
  fiat_secp256k1_uint1 x489;
  fiat_secp256k1_addcarryx_u32(&x488, &x489, x487, x466, 0x0);
  uint32_t x490;
  fiat_secp256k1_uint1 x491;
  fiat_secp256k1_addcarryx_u32(&x490, &x491, x489, x468, 0x0);
  uint32_t x492;
  fiat_secp256k1_uint1 x493;
  fiat_secp256k1_addcarryx_u32(&x492, &x493, x491, x470, 0x0);
  uint32_t x494;
  fiat_secp256k1_uint1 x495;
  fiat_secp256k1_addcarryx_u32(&x494, &x495, x493, x472, 0x0);
  uint32_t x496;
  fiat_secp256k1_uint1 x497;
  fiat_secp256k1_addcarryx_u32(&x496, &x497, x495, x474, 0x0);
  uint32_t x498;
  fiat_secp256k1_uint1 x499;
  fiat_secp256k1_addcarryx_u32(&x498, &x499, x497, x476, 0x0);
  uint32_t x500;
  fiat_secp256k1_uint1 x501;
  fiat_secp256k1_addcarryx_u32(&x500, &x501, x499, x484, 0x0);
  uint32_t x502;
  uint32_t x503;
  fiat_secp256k1_mulx_u32(&x502, &x503, x486, UINT32_C(0xd2253531));
  uint32_t x504;
  uint32_t x505;
  fiat_secp256k1_mulx_u32(&x504, &x505, x502, UINT32_C(0xffffffff));
  uint32_t x506;
  uint32_t x507;
  fiat_secp256k1_mulx_u32(&x506, &x507, x502, UINT32_C(0xffffffff));
  uint32_t x508;
  uint32_t x509;
  fiat_secp256k1_mulx_u32(&x508, &x509, x502, UINT32_C(0xffffffff));
  uint32_t x510;
  uint32_t x511;
  fiat_secp256k1_mulx_u32(&x510, &x511, x502, UINT32_C(0xffffffff));
  uint32_t x512;
  uint32_t x513;
  fiat_secp256k1_mulx_u32(&x512, &x513, x502, UINT32_C(0xffffffff));
  uint32_t x514;
  uint32_t x515;
  fiat_secp256k1_mulx_u32(&x514, &x515, x502, UINT32_C(0xffffffff));
  uint32_t x516;
  uint32_t x517;
  fiat_secp256k1_mulx_u32(&x516, &x517, x502, UINT32_C(0xfffffffe));
  uint32_t x518;
  uint32_t x519;
  fiat_secp256k1_mulx_u32(&x518, &x519, x502, UINT32_C(0xfffffc2f));
  uint32_t x520;
  fiat_secp256k1_uint1 x521;
  fiat_secp256k1_addcarryx_u32(&x520, &x521, 0x0, x519, x516);
  uint32_t x522;
  fiat_secp256k1_uint1 x523;
  fiat_secp256k1_addcarryx_u32(&x522, &x523, x521, x517, x514);
  uint32_t x524;
  fiat_secp256k1_uint1 x525;
  fiat_secp256k1_addcarryx_u32(&x524, &x525, x523, x515, x512);
  uint32_t x526;
  fiat_secp256k1_uint1 x527;
  fiat_secp256k1_addcarryx_u32(&x526, &x527, x525, x513, x510);
  uint32_t x528;
  fiat_secp256k1_uint1 x529;
  fiat_secp256k1_addcarryx_u32(&x528, &x529, x527, x511, x508);
  uint32_t x530;
  fiat_secp256k1_uint1 x531;
  fiat_secp256k1_addcarryx_u32(&x530, &x531, x529, x509, x506);
  uint32_t x532;
  fiat_secp256k1_uint1 x533;
  fiat_secp256k1_addcarryx_u32(&x532, &x533, x531, x507, x504);
  uint32_t x534;
  fiat_secp256k1_uint1 x535;
  fiat_secp256k1_addcarryx_u32(&x534, &x535, 0x0, x486, x518);
  uint32_t x536;
  fiat_secp256k1_uint1 x537;
  fiat_secp256k1_addcarryx_u32(&x536, &x537, x535, x488, x520);
  uint32_t x538;
  fiat_secp256k1_uint1 x539;
  fiat_secp256k1_addcarryx_u32(&x538, &x539, x537, x490, x522);
  uint32_t x540;
  fiat_secp256k1_uint1 x541;
  fiat_secp256k1_addcarryx_u32(&x540, &x541, x539, x492, x524);
  uint32_t x542;
  fiat_secp256k1_uint1 x543;
  fiat_secp256k1_addcarryx_u32(&x542, &x543, x541, x494, x526);
  uint32_t x544;
  fiat_secp256k1_uint1 x545;
  fiat_secp256k1_addcarryx_u32(&x544, &x545, x543, x496, x528);
  uint32_t x546;
  fiat_secp256k1_uint1 x547;
  fiat_secp256k1_addcarryx_u32(&x546, &x547, x545, x498, x530);
  uint32_t x548;
  fiat_secp256k1_uint1 x549;
  fiat_secp256k1_addcarryx_u32(&x548, &x549, x547, x500, x532);
  uint32_t x550;
  fiat_secp256k1_uint1 x551;
  fiat_secp256k1_addcarryx_u32(&x550, &x551, x533, x505, 0x0);
  uint32_t x552;
  fiat_secp256k1_uint1 x553;
  fiat_secp256k1_addcarryx_u32(&x552, &x553, x485, 0x0, 0x0);
  uint32_t x554;
  fiat_secp256k1_uint1 x555;
  fiat_secp256k1_addcarryx_u32(&x554, &x555, x501, (fiat_secp256k1_uint1)x552, 0x0);
  uint32_t x556;
  fiat_secp256k1_uint1 x557;
  fiat_secp256k1_addcarryx_u32(&x556, &x557, x549, x554, x550);
  uint32_t x558;
  fiat_secp256k1_uint1 x559;
  fiat_secp256k1_subborrowx_u32(&x558, &x559, 0x0, x536, UINT32_C(0xfffffc2f));
  uint32_t x560;
  fiat_secp256k1_uint1 x561;
  fiat_secp256k1_subborrowx_u32(&x560, &x561, x559, x538, UINT32_C(0xfffffffe));
  uint32_t x562;
  fiat_secp256k1_uint1 x563;
  fiat_secp256k1_subborrowx_u32(&x562, &x563, x561, x540, UINT32_C(0xffffffff));
  uint32_t x564;
  fiat_secp256k1_uint1 x565;
  fiat_secp256k1_subborrowx_u32(&x564, &x565, x563, x542, UINT32_C(0xffffffff));
  uint32_t x566;
  fiat_secp256k1_uint1 x567;
  fiat_secp256k1_subborrowx_u32(&x566, &x567, x565, x544, UINT32_C(0xffffffff));
  uint32_t x568;
  fiat_secp256k1_uint1 x569;
  fiat_secp256k1_subborrowx_u32(&x568, &x569, x567, x546, UINT32_C(0xffffffff));
  uint32_t x570;
  fiat_secp256k1_uint1 x571;
  fiat_secp256k1_subborrowx_u32(&x570, &x571, x569, x548, UINT32_C(0xffffffff));
  uint32_t x572;
  fiat_secp256k1_uint1 x573;
  fiat_secp256k1_subborrowx_u32(&x572, &x573, x571, x556, UINT32_C(0xffffffff));
  uint32_t x574;
  fiat_secp256k1_uint1 x575;
  fiat_secp256k1_addcarryx_u32(&x574, &x575, x557, 0x0, 0x0);
  uint32_t x576;
  fiat_secp256k1_uint1 x577;
  fiat_secp256k1_subborrowx_u32(&x576, &x577, x573, (fiat_secp256k1_uint1)x574, 0x0);
  uint32_t x578;
  fiat_secp256k1_cmovznz_u32(&x578, x577, x558, x536);
  uint32_t x579;
  fiat_secp256k1_cmovznz_u32(&x579, x577, x560, x538);
  uint32_t x580;
  fiat_secp256k1_cmovznz_u32(&x580, x577, x562, x540);
  uint32_t x581;
  fiat_secp256k1_cmovznz_u32(&x581, x577, x564, x542);
  uint32_t x582;
  fiat_secp256k1_cmovznz_u32(&x582, x577, x566, x544);
  uint32_t x583;
  fiat_secp256k1_cmovznz_u32(&x583, x577, x568, x546);
  uint32_t x584;
  fiat_secp256k1_cmovznz_u32(&x584, x577, x570, x548);
  uint32_t x585;
  fiat_secp256k1_cmovznz_u32(&x585, x577, x572, x556);
  out1[0] = x578;
  out1[1] = x579;
  out1[2] = x580;
  out1[3] = x581;
  out1[4] = x582;
  out1[5] = x583;
  out1[6] = x584;
  out1[7] = x585;
}

/*
 * The function fiat_secp256k1_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_secp256k1_nonzero(uint32_t* out1, const uint32_t arg1[8]) {
  uint32_t x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | (uint32_t)0x0))))))));
  *out1 = x1;
}

/*
 * The function fiat_secp256k1_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_selectznz(uint32_t out1[8], fiat_secp256k1_uint1 arg1, const uint32_t arg2[8], const uint32_t arg3[8]) {
  uint32_t x1;
  fiat_secp256k1_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  uint32_t x2;
  fiat_secp256k1_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  uint32_t x3;
  fiat_secp256k1_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  uint32_t x4;
  fiat_secp256k1_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  uint32_t x5;
  fiat_secp256k1_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  uint32_t x6;
  fiat_secp256k1_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  uint32_t x7;
  fiat_secp256k1_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  uint32_t x8;
  fiat_secp256k1_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/*
 * The function fiat_secp256k1_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_secp256k1_to_bytes(uint8_t out1[32], const uint32_t arg1[8]) {
  uint32_t x1 = (arg1[7]);
  uint32_t x2 = (arg1[6]);
  uint32_t x3 = (arg1[5]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[3]);
  uint32_t x6 = (arg1[2]);
  uint32_t x7 = (arg1[1]);
  uint32_t x8 = (arg1[0]);
  uint32_t x9 = (x8 >> 8);
  uint8_t x10 = (uint8_t)(x8 & UINT8_C(0xff));
  uint32_t x11 = (x9 >> 8);
  uint8_t x12 = (uint8_t)(x9 & UINT8_C(0xff));
  uint8_t x13 = (uint8_t)(x11 >> 8);
  uint8_t x14 = (uint8_t)(x11 & UINT8_C(0xff));
  uint8_t x15 = (uint8_t)(x13 & UINT8_C(0xff));
  uint32_t x16 = (x7 >> 8);
  uint8_t x17 = (uint8_t)(x7 & UINT8_C(0xff));
  uint32_t x18 = (x16 >> 8);
  uint8_t x19 = (uint8_t)(x16 & UINT8_C(0xff));
  uint8_t x20 = (uint8_t)(x18 >> 8);
  uint8_t x21 = (uint8_t)(x18 & UINT8_C(0xff));
  uint8_t x22 = (uint8_t)(x20 & UINT8_C(0xff));
  uint32_t x23 = (x6 >> 8);
  uint8_t x24 = (uint8_t)(x6 & UINT8_C(0xff));
  uint32_t x25 = (x23 >> 8);
  uint8_t x26 = (uint8_t)(x23 & UINT8_C(0xff));
  uint8_t x27 = (uint8_t)(x25 >> 8);
  uint8_t x28 = (uint8_t)(x25 & UINT8_C(0xff));
  uint8_t x29 = (uint8_t)(x27 & UINT8_C(0xff));
  uint32_t x30 = (x5 >> 8);
  uint8_t x31 = (uint8_t)(x5 & UINT8_C(0xff));
  uint32_t x32 = (x30 >> 8);
  uint8_t x33 = (uint8_t)(x30 & UINT8_C(0xff));
  uint8_t x34 = (uint8_t)(x32 >> 8);
  uint8_t x35 = (uint8_t)(x32 & UINT8_C(0xff));
  uint8_t x36 = (uint8_t)(x34 & UINT8_C(0xff));
  uint32_t x37 = (x4 >> 8);
  uint8_t x38 = (uint8_t)(x4 & UINT8_C(0xff));
  uint32_t x39 = (x37 >> 8);
  uint8_t x40 = (uint8_t)(x37 & UINT8_C(0xff));
  uint8_t x41 = (uint8_t)(x39 >> 8);
  uint8_t x42 = (uint8_t)(x39 & UINT8_C(0xff));
  uint8_t x43 = (uint8_t)(x41 & UINT8_C(0xff));
  uint32_t x44 = (x3 >> 8);
  uint8_t x45 = (uint8_t)(x3 & UINT8_C(0xff));
  uint32_t x46 = (x44 >> 8);
  uint8_t x47 = (uint8_t)(x44 & UINT8_C(0xff));
  uint8_t x48 = (uint8_t)(x46 >> 8);
  uint8_t x49 = (uint8_t)(x46 & UINT8_C(0xff));
  uint8_t x50 = (uint8_t)(x48 & UINT8_C(0xff));
  uint32_t x51 = (x2 >> 8);
  uint8_t x52 = (uint8_t)(x2 & UINT8_C(0xff));
  uint32_t x53 = (x51 >> 8);
  uint8_t x54 = (uint8_t)(x51 & UINT8_C(0xff));
  uint8_t x55 = (uint8_t)(x53 >> 8);
  uint8_t x56 = (uint8_t)(x53 & UINT8_C(0xff));
  uint8_t x57 = (uint8_t)(x55 & UINT8_C(0xff));
  uint32_t x58 = (x1 >> 8);
  uint8_t x59 = (uint8_t)(x1 & UINT8_C(0xff));
  uint32_t x60 = (x58 >> 8);
  uint8_t x61 = (uint8_t)(x58 & UINT8_C(0xff));
  uint8_t x62 = (uint8_t)(x60 >> 8);
  uint8_t x63 = (uint8_t)(x60 & UINT8_C(0xff));
  out1[0] = x10;
  out1[1] = x12;
  out1[2] = x14;
  out1[3] = x15;
  out1[4] = x17;
  out1[5] = x19;
  out1[6] = x21;
  out1[7] = x22;
  out1[8] = x24;
  out1[9] = x26;
  out1[10] = x28;
  out1[11] = x29;
  out1[12] = x31;
  out1[13] = x33;
  out1[14] = x35;
  out1[15] = x36;
  out1[16] = x38;
  out1[17] = x40;
  out1[18] = x42;
  out1[19] = x43;
  out1[20] = x45;
  out1[21] = x47;
  out1[22] = x49;
  out1[23] = x50;
  out1[24] = x52;
  out1[25] = x54;
  out1[26] = x56;
  out1[27] = x57;
  out1[28] = x59;
  out1[29] = x61;
  out1[30] = x63;
  out1[31] = x62;
}

/*
 * The function fiat_secp256k1_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_secp256k1_from_bytes(uint32_t out1[8], const uint8_t arg1[32]) {
  uint32_t x1 = ((uint32_t)(arg1[31]) << 24);
  uint32_t x2 = ((uint32_t)(arg1[30]) << 16);
  uint32_t x3 = ((uint32_t)(arg1[29]) << 8);
  uint8_t x4 = (arg1[28]);
  uint32_t x5 = ((uint32_t)(arg1[27]) << 24);
  uint32_t x6 = ((uint32_t)(arg1[26]) << 16);
  uint32_t x7 = ((uint32_t)(arg1[25]) << 8);
  uint8_t x8 = (arg1[24]);
  uint32_t x9 = ((uint32_t)(arg1[23]) << 24);
  uint32_t x10 = ((uint32_t)(arg1[22]) << 16);
  uint32_t x11 = ((uint32_t)(arg1[21]) << 8);
  uint8_t x12 = (arg1[20]);
  uint32_t x13 = ((uint32_t)(arg1[19]) << 24);
  uint32_t x14 = ((uint32_t)(arg1[18]) << 16);
  uint32_t x15 = ((uint32_t)(arg1[17]) << 8);
  uint8_t x16 = (arg1[16]);
  uint32_t x17 = ((uint32_t)(arg1[15]) << 24);
  uint32_t x18 = ((uint32_t)(arg1[14]) << 16);
  uint32_t x19 = ((uint32_t)(arg1[13]) << 8);
  uint8_t x20 = (arg1[12]);
  uint32_t x21 = ((uint32_t)(arg1[11]) << 24);
  uint32_t x22 = ((uint32_t)(arg1[10]) << 16);
  uint32_t x23 = ((uint32_t)(arg1[9]) << 8);
  uint8_t x24 = (arg1[8]);
  uint32_t x25 = ((uint32_t)(arg1[7]) << 24);
  uint32_t x26 = ((uint32_t)(arg1[6]) << 16);
  uint32_t x27 = ((uint32_t)(arg1[5]) << 8);
  uint8_t x28 = (arg1[4]);
  uint32_t x29 = ((uint32_t)(arg1[3]) << 24);
  uint32_t x30 = ((uint32_t)(arg1[2]) << 16);
  uint32_t x31 = ((uint32_t)(arg1[1]) << 8);
  uint8_t x32 = (arg1[0]);
  uint32_t x33 = (x32 + (x31 + (x30 + x29)));
  uint32_t x34 = (x33 & UINT32_C(0xffffffff));
  uint32_t x35 = (x4 + (x3 + (x2 + x1)));
  uint32_t x36 = (x8 + (x7 + (x6 + x5)));
  uint32_t x37 = (x12 + (x11 + (x10 + x9)));
  uint32_t x38 = (x16 + (x15 + (x14 + x13)));
  uint32_t x39 = (x20 + (x19 + (x18 + x17)));
  uint32_t x40 = (x24 + (x23 + (x22 + x21)));
  uint32_t x41 = (x28 + (x27 + (x26 + x25)));
  uint32_t x42 = (x41 & UINT32_C(0xffffffff));
  uint32_t x43 = (x40 & UINT32_C(0xffffffff));
  uint32_t x44 = (x39 & UINT32_C(0xffffffff));
  uint32_t x45 = (x38 & UINT32_C(0xffffffff));
  uint32_t x46 = (x37 & UINT32_C(0xffffffff));
  uint32_t x47 = (x36 & UINT32_C(0xffffffff));
  out1[0] = x34;
  out1[1] = x42;
  out1[2] = x43;
  out1[3] = x44;
  out1[4] = x45;
  out1[5] = x46;
  out1[6] = x47;
  out1[7] = x35;
}
