/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/unsaturated_solinas --static p521 9 '2^521 - 1' 64 */
/* curve description: p521 */
/* requested operations: (all) */
/* n = 9 (from "9") */
/* s-c = 2^521 - [(1, 1)] (from "2^521 - 1") */
/* machine_wordsize = 64 (from "64") */

/* Computed values: */
/* carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1] */

#include <stdint.h>
typedef unsigned char fiat_p521_uint1;
typedef signed char fiat_p521_int1;
FIAT_EXTENSION typedef signed __int128 fiat_p521_int128;
FIAT_EXTENSION typedef unsigned __int128 fiat_p521_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p521_addcarryx_u58 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^58
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^58⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_addcarryx_u58(uint64_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1 = ((arg1 + arg2) + arg3);
  uint64_t x2 = (x1 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint1 x3 = (fiat_p521_uint1)(x1 >> 58);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p521_subborrowx_u58 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^58
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^58⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_subborrowx_u58(uint64_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
  fiat_p521_int1 x2 = (fiat_p521_int1)(x1 >> 58);
  uint64_t x3 = (x1 & UINT64_C(0x3ffffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p521_uint1)(0x0 - x2);
}

/*
 * The function fiat_p521_addcarryx_u57 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^57
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^57⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x1ffffffffffffff]
 *   arg3: [0x0 ~> 0x1ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x1ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_addcarryx_u57(uint64_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1 = ((arg1 + arg2) + arg3);
  uint64_t x2 = (x1 & UINT64_C(0x1ffffffffffffff));
  fiat_p521_uint1 x3 = (fiat_p521_uint1)(x1 >> 57);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p521_subborrowx_u57 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^57
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^57⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x1ffffffffffffff]
 *   arg3: [0x0 ~> 0x1ffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x1ffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_subborrowx_u57(uint64_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
  fiat_p521_int1 x2 = (fiat_p521_int1)(x1 >> 57);
  uint64_t x3 = (x1 & UINT64_C(0x1ffffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p521_uint1)(0x0 - x2);
}

/*
 * The function fiat_p521_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p521_cmovznz_u64(uint64_t* out1, fiat_p521_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p521_uint1 x1 = (!(!arg1));
  uint64_t x2 = ((fiat_p521_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  uint64_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p521_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 *   arg2: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 */
static void fiat_p521_carry_mul(uint64_t out1[9], const uint64_t arg1[9], const uint64_t arg2[9]) {
  fiat_p521_uint128 x1 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x2 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x3 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x4 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[5]) * (uint64_t)0x2));
  fiat_p521_uint128 x5 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[4]) * (uint64_t)0x2));
  fiat_p521_uint128 x6 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[3]) * (uint64_t)0x2));
  fiat_p521_uint128 x7 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[2]) * (uint64_t)0x2));
  fiat_p521_uint128 x8 = ((fiat_p521_uint128)(arg1[8]) * ((arg2[1]) * (uint64_t)0x2));
  fiat_p521_uint128 x9 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x10 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x11 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x12 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[5]) * (uint64_t)0x2));
  fiat_p521_uint128 x13 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[4]) * (uint64_t)0x2));
  fiat_p521_uint128 x14 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[3]) * (uint64_t)0x2));
  fiat_p521_uint128 x15 = ((fiat_p521_uint128)(arg1[7]) * ((arg2[2]) * (uint64_t)0x2));
  fiat_p521_uint128 x16 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x17 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x18 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x19 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[5]) * (uint64_t)0x2));
  fiat_p521_uint128 x20 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[4]) * (uint64_t)0x2));
  fiat_p521_uint128 x21 = ((fiat_p521_uint128)(arg1[6]) * ((arg2[3]) * (uint64_t)0x2));
  fiat_p521_uint128 x22 = ((fiat_p521_uint128)(arg1[5]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x23 = ((fiat_p521_uint128)(arg1[5]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x24 = ((fiat_p521_uint128)(arg1[5]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x25 = ((fiat_p521_uint128)(arg1[5]) * ((arg2[5]) * (uint64_t)0x2));
  fiat_p521_uint128 x26 = ((fiat_p521_uint128)(arg1[5]) * ((arg2[4]) * (uint64_t)0x2));
  fiat_p521_uint128 x27 = ((fiat_p521_uint128)(arg1[4]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x28 = ((fiat_p521_uint128)(arg1[4]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x29 = ((fiat_p521_uint128)(arg1[4]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x30 = ((fiat_p521_uint128)(arg1[4]) * ((arg2[5]) * (uint64_t)0x2));
  fiat_p521_uint128 x31 = ((fiat_p521_uint128)(arg1[3]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x32 = ((fiat_p521_uint128)(arg1[3]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x33 = ((fiat_p521_uint128)(arg1[3]) * ((arg2[6]) * (uint64_t)0x2));
  fiat_p521_uint128 x34 = ((fiat_p521_uint128)(arg1[2]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x35 = ((fiat_p521_uint128)(arg1[2]) * ((arg2[7]) * (uint64_t)0x2));
  fiat_p521_uint128 x36 = ((fiat_p521_uint128)(arg1[1]) * ((arg2[8]) * (uint64_t)0x2));
  fiat_p521_uint128 x37 = ((fiat_p521_uint128)(arg1[8]) * (arg2[0]));
  fiat_p521_uint128 x38 = ((fiat_p521_uint128)(arg1[7]) * (arg2[1]));
  fiat_p521_uint128 x39 = ((fiat_p521_uint128)(arg1[7]) * (arg2[0]));
  fiat_p521_uint128 x40 = ((fiat_p521_uint128)(arg1[6]) * (arg2[2]));
  fiat_p521_uint128 x41 = ((fiat_p521_uint128)(arg1[6]) * (arg2[1]));
  fiat_p521_uint128 x42 = ((fiat_p521_uint128)(arg1[6]) * (arg2[0]));
  fiat_p521_uint128 x43 = ((fiat_p521_uint128)(arg1[5]) * (arg2[3]));
  fiat_p521_uint128 x44 = ((fiat_p521_uint128)(arg1[5]) * (arg2[2]));
  fiat_p521_uint128 x45 = ((fiat_p521_uint128)(arg1[5]) * (arg2[1]));
  fiat_p521_uint128 x46 = ((fiat_p521_uint128)(arg1[5]) * (arg2[0]));
  fiat_p521_uint128 x47 = ((fiat_p521_uint128)(arg1[4]) * (arg2[4]));
  fiat_p521_uint128 x48 = ((fiat_p521_uint128)(arg1[4]) * (arg2[3]));
  fiat_p521_uint128 x49 = ((fiat_p521_uint128)(arg1[4]) * (arg2[2]));
  fiat_p521_uint128 x50 = ((fiat_p521_uint128)(arg1[4]) * (arg2[1]));
  fiat_p521_uint128 x51 = ((fiat_p521_uint128)(arg1[4]) * (arg2[0]));
  fiat_p521_uint128 x52 = ((fiat_p521_uint128)(arg1[3]) * (arg2[5]));
  fiat_p521_uint128 x53 = ((fiat_p521_uint128)(arg1[3]) * (arg2[4]));
  fiat_p521_uint128 x54 = ((fiat_p521_uint128)(arg1[3]) * (arg2[3]));
  fiat_p521_uint128 x55 = ((fiat_p521_uint128)(arg1[3]) * (arg2[2]));
  fiat_p521_uint128 x56 = ((fiat_p521_uint128)(arg1[3]) * (arg2[1]));
  fiat_p521_uint128 x57 = ((fiat_p521_uint128)(arg1[3]) * (arg2[0]));
  fiat_p521_uint128 x58 = ((fiat_p521_uint128)(arg1[2]) * (arg2[6]));
  fiat_p521_uint128 x59 = ((fiat_p521_uint128)(arg1[2]) * (arg2[5]));
  fiat_p521_uint128 x60 = ((fiat_p521_uint128)(arg1[2]) * (arg2[4]));
  fiat_p521_uint128 x61 = ((fiat_p521_uint128)(arg1[2]) * (arg2[3]));
  fiat_p521_uint128 x62 = ((fiat_p521_uint128)(arg1[2]) * (arg2[2]));
  fiat_p521_uint128 x63 = ((fiat_p521_uint128)(arg1[2]) * (arg2[1]));
  fiat_p521_uint128 x64 = ((fiat_p521_uint128)(arg1[2]) * (arg2[0]));
  fiat_p521_uint128 x65 = ((fiat_p521_uint128)(arg1[1]) * (arg2[7]));
  fiat_p521_uint128 x66 = ((fiat_p521_uint128)(arg1[1]) * (arg2[6]));
  fiat_p521_uint128 x67 = ((fiat_p521_uint128)(arg1[1]) * (arg2[5]));
  fiat_p521_uint128 x68 = ((fiat_p521_uint128)(arg1[1]) * (arg2[4]));
  fiat_p521_uint128 x69 = ((fiat_p521_uint128)(arg1[1]) * (arg2[3]));
  fiat_p521_uint128 x70 = ((fiat_p521_uint128)(arg1[1]) * (arg2[2]));
  fiat_p521_uint128 x71 = ((fiat_p521_uint128)(arg1[1]) * (arg2[1]));
  fiat_p521_uint128 x72 = ((fiat_p521_uint128)(arg1[1]) * (arg2[0]));
  fiat_p521_uint128 x73 = ((fiat_p521_uint128)(arg1[0]) * (arg2[8]));
  fiat_p521_uint128 x74 = ((fiat_p521_uint128)(arg1[0]) * (arg2[7]));
  fiat_p521_uint128 x75 = ((fiat_p521_uint128)(arg1[0]) * (arg2[6]));
  fiat_p521_uint128 x76 = ((fiat_p521_uint128)(arg1[0]) * (arg2[5]));
  fiat_p521_uint128 x77 = ((fiat_p521_uint128)(arg1[0]) * (arg2[4]));
  fiat_p521_uint128 x78 = ((fiat_p521_uint128)(arg1[0]) * (arg2[3]));
  fiat_p521_uint128 x79 = ((fiat_p521_uint128)(arg1[0]) * (arg2[2]));
  fiat_p521_uint128 x80 = ((fiat_p521_uint128)(arg1[0]) * (arg2[1]));
  fiat_p521_uint128 x81 = ((fiat_p521_uint128)(arg1[0]) * (arg2[0]));
  fiat_p521_uint128 x82 = (x81 + (x36 + (x35 + (x33 + (x30 + (x26 + (x21 + (x15 + x8))))))));
  fiat_p521_uint128 x83 = (x82 >> 58);
  uint64_t x84 = (uint64_t)(x82 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x85 = (x73 + (x65 + (x58 + (x52 + (x47 + (x43 + (x40 + (x38 + x37))))))));
  fiat_p521_uint128 x86 = (x74 + (x66 + (x59 + (x53 + (x48 + (x44 + (x41 + (x39 + x1))))))));
  fiat_p521_uint128 x87 = (x75 + (x67 + (x60 + (x54 + (x49 + (x45 + (x42 + (x9 + x2))))))));
  fiat_p521_uint128 x88 = (x76 + (x68 + (x61 + (x55 + (x50 + (x46 + (x16 + (x10 + x3))))))));
  fiat_p521_uint128 x89 = (x77 + (x69 + (x62 + (x56 + (x51 + (x22 + (x17 + (x11 + x4))))))));
  fiat_p521_uint128 x90 = (x78 + (x70 + (x63 + (x57 + (x27 + (x23 + (x18 + (x12 + x5))))))));
  fiat_p521_uint128 x91 = (x79 + (x71 + (x64 + (x31 + (x28 + (x24 + (x19 + (x13 + x6))))))));
  fiat_p521_uint128 x92 = (x80 + (x72 + (x34 + (x32 + (x29 + (x25 + (x20 + (x14 + x7))))))));
  fiat_p521_uint128 x93 = (x83 + x92);
  fiat_p521_uint128 x94 = (x93 >> 58);
  uint64_t x95 = (uint64_t)(x93 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x96 = (x94 + x91);
  fiat_p521_uint128 x97 = (x96 >> 58);
  uint64_t x98 = (uint64_t)(x96 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x99 = (x97 + x90);
  fiat_p521_uint128 x100 = (x99 >> 58);
  uint64_t x101 = (uint64_t)(x99 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x102 = (x100 + x89);
  fiat_p521_uint128 x103 = (x102 >> 58);
  uint64_t x104 = (uint64_t)(x102 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x105 = (x103 + x88);
  fiat_p521_uint128 x106 = (x105 >> 58);
  uint64_t x107 = (uint64_t)(x105 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x108 = (x106 + x87);
  fiat_p521_uint128 x109 = (x108 >> 58);
  uint64_t x110 = (uint64_t)(x108 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x111 = (x109 + x86);
  fiat_p521_uint128 x112 = (x111 >> 58);
  uint64_t x113 = (uint64_t)(x111 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x114 = (x112 + x85);
  fiat_p521_uint128 x115 = (x114 >> 57);
  uint64_t x116 = (uint64_t)(x114 & UINT64_C(0x1ffffffffffffff));
  fiat_p521_uint128 x117 = (x84 + x115);
  uint64_t x118 = (uint64_t)(x117 >> 58);
  uint64_t x119 = (uint64_t)(x117 & UINT64_C(0x3ffffffffffffff));
  uint64_t x120 = (x118 + x95);
  fiat_p521_uint1 x121 = (fiat_p521_uint1)(x120 >> 58);
  uint64_t x122 = (x120 & UINT64_C(0x3ffffffffffffff));
  uint64_t x123 = (x121 + x98);
  out1[0] = x119;
  out1[1] = x122;
  out1[2] = x123;
  out1[3] = x101;
  out1[4] = x104;
  out1[5] = x107;
  out1[6] = x110;
  out1[7] = x113;
  out1[8] = x116;
}

/*
 * The function fiat_p521_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 */
static void fiat_p521_carry_square(uint64_t out1[9], const uint64_t arg1[9]) {
  uint64_t x1 = (arg1[8]);
  uint64_t x2 = (x1 * (uint64_t)0x2);
  uint64_t x3 = ((arg1[8]) * (uint64_t)0x2);
  uint64_t x4 = (arg1[7]);
  uint64_t x5 = (x4 * (uint64_t)0x2);
  uint64_t x6 = ((arg1[7]) * (uint64_t)0x2);
  uint64_t x7 = (arg1[6]);
  uint64_t x8 = (x7 * (uint64_t)0x2);
  uint64_t x9 = ((arg1[6]) * (uint64_t)0x2);
  uint64_t x10 = (arg1[5]);
  uint64_t x11 = (x10 * (uint64_t)0x2);
  uint64_t x12 = ((arg1[5]) * (uint64_t)0x2);
  uint64_t x13 = ((arg1[4]) * (uint64_t)0x2);
  uint64_t x14 = ((arg1[3]) * (uint64_t)0x2);
  uint64_t x15 = ((arg1[2]) * (uint64_t)0x2);
  uint64_t x16 = ((arg1[1]) * (uint64_t)0x2);
  fiat_p521_uint128 x17 = ((fiat_p521_uint128)(arg1[8]) * (x1 * (uint64_t)0x2));
  fiat_p521_uint128 x18 = ((fiat_p521_uint128)(arg1[7]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x19 = ((fiat_p521_uint128)(arg1[7]) * (x4 * (uint64_t)0x2));
  fiat_p521_uint128 x20 = ((fiat_p521_uint128)(arg1[6]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x21 = ((fiat_p521_uint128)(arg1[6]) * (x5 * (uint64_t)0x2));
  fiat_p521_uint128 x22 = ((fiat_p521_uint128)(arg1[6]) * (x7 * (uint64_t)0x2));
  fiat_p521_uint128 x23 = ((fiat_p521_uint128)(arg1[5]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x24 = ((fiat_p521_uint128)(arg1[5]) * (x5 * (uint64_t)0x2));
  fiat_p521_uint128 x25 = ((fiat_p521_uint128)(arg1[5]) * (x8 * (uint64_t)0x2));
  fiat_p521_uint128 x26 = ((fiat_p521_uint128)(arg1[5]) * (x10 * (uint64_t)0x2));
  fiat_p521_uint128 x27 = ((fiat_p521_uint128)(arg1[4]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x28 = ((fiat_p521_uint128)(arg1[4]) * (x5 * (uint64_t)0x2));
  fiat_p521_uint128 x29 = ((fiat_p521_uint128)(arg1[4]) * (x8 * (uint64_t)0x2));
  fiat_p521_uint128 x30 = ((fiat_p521_uint128)(arg1[4]) * (x11 * (uint64_t)0x2));
  fiat_p521_uint128 x31 = ((fiat_p521_uint128)(arg1[4]) * (arg1[4]));
  fiat_p521_uint128 x32 = ((fiat_p521_uint128)(arg1[3]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x33 = ((fiat_p521_uint128)(arg1[3]) * (x5 * (uint64_t)0x2));
  fiat_p521_uint128 x34 = ((fiat_p521_uint128)(arg1[3]) * (x8 * (uint64_t)0x2));
  fiat_p521_uint128 x35 = ((fiat_p521_uint128)(arg1[3]) * x12);
  fiat_p521_uint128 x36 = ((fiat_p521_uint128)(arg1[3]) * x13);
  fiat_p521_uint128 x37 = ((fiat_p521_uint128)(arg1[3]) * (arg1[3]));
  fiat_p521_uint128 x38 = ((fiat_p521_uint128)(arg1[2]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x39 = ((fiat_p521_uint128)(arg1[2]) * (x5 * (uint64_t)0x2));
  fiat_p521_uint128 x40 = ((fiat_p521_uint128)(arg1[2]) * x9);
  fiat_p521_uint128 x41 = ((fiat_p521_uint128)(arg1[2]) * x12);
  fiat_p521_uint128 x42 = ((fiat_p521_uint128)(arg1[2]) * x13);
  fiat_p521_uint128 x43 = ((fiat_p521_uint128)(arg1[2]) * x14);
  fiat_p521_uint128 x44 = ((fiat_p521_uint128)(arg1[2]) * (arg1[2]));
  fiat_p521_uint128 x45 = ((fiat_p521_uint128)(arg1[1]) * (x2 * (uint64_t)0x2));
  fiat_p521_uint128 x46 = ((fiat_p521_uint128)(arg1[1]) * x6);
  fiat_p521_uint128 x47 = ((fiat_p521_uint128)(arg1[1]) * x9);
  fiat_p521_uint128 x48 = ((fiat_p521_uint128)(arg1[1]) * x12);
  fiat_p521_uint128 x49 = ((fiat_p521_uint128)(arg1[1]) * x13);
  fiat_p521_uint128 x50 = ((fiat_p521_uint128)(arg1[1]) * x14);
  fiat_p521_uint128 x51 = ((fiat_p521_uint128)(arg1[1]) * x15);
  fiat_p521_uint128 x52 = ((fiat_p521_uint128)(arg1[1]) * (arg1[1]));
  fiat_p521_uint128 x53 = ((fiat_p521_uint128)(arg1[0]) * x3);
  fiat_p521_uint128 x54 = ((fiat_p521_uint128)(arg1[0]) * x6);
  fiat_p521_uint128 x55 = ((fiat_p521_uint128)(arg1[0]) * x9);
  fiat_p521_uint128 x56 = ((fiat_p521_uint128)(arg1[0]) * x12);
  fiat_p521_uint128 x57 = ((fiat_p521_uint128)(arg1[0]) * x13);
  fiat_p521_uint128 x58 = ((fiat_p521_uint128)(arg1[0]) * x14);
  fiat_p521_uint128 x59 = ((fiat_p521_uint128)(arg1[0]) * x15);
  fiat_p521_uint128 x60 = ((fiat_p521_uint128)(arg1[0]) * x16);
  fiat_p521_uint128 x61 = ((fiat_p521_uint128)(arg1[0]) * (arg1[0]));
  fiat_p521_uint128 x62 = (x61 + (x45 + (x39 + (x34 + x30))));
  fiat_p521_uint128 x63 = (x62 >> 58);
  uint64_t x64 = (uint64_t)(x62 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x65 = (x53 + (x46 + (x40 + (x35 + x31))));
  fiat_p521_uint128 x66 = (x54 + (x47 + (x41 + (x36 + x17))));
  fiat_p521_uint128 x67 = (x55 + (x48 + (x42 + (x37 + x18))));
  fiat_p521_uint128 x68 = (x56 + (x49 + (x43 + (x20 + x19))));
  fiat_p521_uint128 x69 = (x57 + (x50 + (x44 + (x23 + x21))));
  fiat_p521_uint128 x70 = (x58 + (x51 + (x27 + (x24 + x22))));
  fiat_p521_uint128 x71 = (x59 + (x52 + (x32 + (x28 + x25))));
  fiat_p521_uint128 x72 = (x60 + (x38 + (x33 + (x29 + x26))));
  fiat_p521_uint128 x73 = (x63 + x72);
  fiat_p521_uint128 x74 = (x73 >> 58);
  uint64_t x75 = (uint64_t)(x73 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x76 = (x74 + x71);
  fiat_p521_uint128 x77 = (x76 >> 58);
  uint64_t x78 = (uint64_t)(x76 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x79 = (x77 + x70);
  fiat_p521_uint128 x80 = (x79 >> 58);
  uint64_t x81 = (uint64_t)(x79 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x82 = (x80 + x69);
  fiat_p521_uint128 x83 = (x82 >> 58);
  uint64_t x84 = (uint64_t)(x82 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x85 = (x83 + x68);
  fiat_p521_uint128 x86 = (x85 >> 58);
  uint64_t x87 = (uint64_t)(x85 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x88 = (x86 + x67);
  fiat_p521_uint128 x89 = (x88 >> 58);
  uint64_t x90 = (uint64_t)(x88 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x91 = (x89 + x66);
  fiat_p521_uint128 x92 = (x91 >> 58);
  uint64_t x93 = (uint64_t)(x91 & UINT64_C(0x3ffffffffffffff));
  fiat_p521_uint128 x94 = (x92 + x65);
  fiat_p521_uint128 x95 = (x94 >> 57);
  uint64_t x96 = (uint64_t)(x94 & UINT64_C(0x1ffffffffffffff));
  fiat_p521_uint128 x97 = (x64 + x95);
  uint64_t x98 = (uint64_t)(x97 >> 58);
  uint64_t x99 = (uint64_t)(x97 & UINT64_C(0x3ffffffffffffff));
  uint64_t x100 = (x98 + x75);
  fiat_p521_uint1 x101 = (fiat_p521_uint1)(x100 >> 58);
  uint64_t x102 = (x100 & UINT64_C(0x3ffffffffffffff));
  uint64_t x103 = (x101 + x78);
  out1[0] = x99;
  out1[1] = x102;
  out1[2] = x103;
  out1[3] = x81;
  out1[4] = x84;
  out1[5] = x87;
  out1[6] = x90;
  out1[7] = x93;
  out1[8] = x96;
}

/*
 * The function fiat_p521_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 */
static void fiat_p521_carry(uint64_t out1[9], const uint64_t arg1[9]) {
  uint64_t x1 = (arg1[0]);
  uint64_t x2 = ((x1 >> 58) + (arg1[1]));
  uint64_t x3 = ((x2 >> 58) + (arg1[2]));
  uint64_t x4 = ((x3 >> 58) + (arg1[3]));
  uint64_t x5 = ((x4 >> 58) + (arg1[4]));
  uint64_t x6 = ((x5 >> 58) + (arg1[5]));
  uint64_t x7 = ((x6 >> 58) + (arg1[6]));
  uint64_t x8 = ((x7 >> 58) + (arg1[7]));
  uint64_t x9 = ((x8 >> 58) + (arg1[8]));
  uint64_t x10 = ((x1 & UINT64_C(0x3ffffffffffffff)) + (x9 >> 57));
  uint64_t x11 = ((fiat_p521_uint1)(x10 >> 58) + (x2 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x12 = (x10 & UINT64_C(0x3ffffffffffffff));
  uint64_t x13 = (x11 & UINT64_C(0x3ffffffffffffff));
  uint64_t x14 = ((fiat_p521_uint1)(x11 >> 58) + (x3 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x15 = (x4 & UINT64_C(0x3ffffffffffffff));
  uint64_t x16 = (x5 & UINT64_C(0x3ffffffffffffff));
  uint64_t x17 = (x6 & UINT64_C(0x3ffffffffffffff));
  uint64_t x18 = (x7 & UINT64_C(0x3ffffffffffffff));
  uint64_t x19 = (x8 & UINT64_C(0x3ffffffffffffff));
  uint64_t x20 = (x9 & UINT64_C(0x1ffffffffffffff));
  out1[0] = x12;
  out1[1] = x13;
  out1[2] = x14;
  out1[3] = x15;
  out1[4] = x16;
  out1[5] = x17;
  out1[6] = x18;
  out1[7] = x19;
  out1[8] = x20;
}

/*
 * The function fiat_p521_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 *   arg2: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 */
static void fiat_p521_add(uint64_t out1[9], const uint64_t arg1[9], const uint64_t arg2[9]) {
  uint64_t x1 = ((arg1[0]) + (arg2[0]));
  uint64_t x2 = ((arg1[1]) + (arg2[1]));
  uint64_t x3 = ((arg1[2]) + (arg2[2]));
  uint64_t x4 = ((arg1[3]) + (arg2[3]));
  uint64_t x5 = ((arg1[4]) + (arg2[4]));
  uint64_t x6 = ((arg1[5]) + (arg2[5]));
  uint64_t x7 = ((arg1[6]) + (arg2[6]));
  uint64_t x8 = ((arg1[7]) + (arg2[7]));
  uint64_t x9 = ((arg1[8]) + (arg2[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/*
 * The function fiat_p521_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 *   arg2: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 */
static void fiat_p521_sub(uint64_t out1[9], const uint64_t arg1[9], const uint64_t arg2[9]) {
  uint64_t x1 = ((UINT64_C(0x7fffffffffffffe) + (arg1[0])) - (arg2[0]));
  uint64_t x2 = ((UINT64_C(0x7fffffffffffffe) + (arg1[1])) - (arg2[1]));
  uint64_t x3 = ((UINT64_C(0x7fffffffffffffe) + (arg1[2])) - (arg2[2]));
  uint64_t x4 = ((UINT64_C(0x7fffffffffffffe) + (arg1[3])) - (arg2[3]));
  uint64_t x5 = ((UINT64_C(0x7fffffffffffffe) + (arg1[4])) - (arg2[4]));
  uint64_t x6 = ((UINT64_C(0x7fffffffffffffe) + (arg1[5])) - (arg2[5]));
  uint64_t x7 = ((UINT64_C(0x7fffffffffffffe) + (arg1[6])) - (arg2[6]));
  uint64_t x8 = ((UINT64_C(0x7fffffffffffffe) + (arg1[7])) - (arg2[7]));
  uint64_t x9 = ((UINT64_C(0x3fffffffffffffe) + (arg1[8])) - (arg2[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/*
 * The function fiat_p521_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0xd33333333333332], [0x0 ~> 0x699999999999999]]
 */
static void fiat_p521_opp(uint64_t out1[9], const uint64_t arg1[9]) {
  uint64_t x1 = (UINT64_C(0x7fffffffffffffe) - (arg1[0]));
  uint64_t x2 = (UINT64_C(0x7fffffffffffffe) - (arg1[1]));
  uint64_t x3 = (UINT64_C(0x7fffffffffffffe) - (arg1[2]));
  uint64_t x4 = (UINT64_C(0x7fffffffffffffe) - (arg1[3]));
  uint64_t x5 = (UINT64_C(0x7fffffffffffffe) - (arg1[4]));
  uint64_t x6 = (UINT64_C(0x7fffffffffffffe) - (arg1[5]));
  uint64_t x7 = (UINT64_C(0x7fffffffffffffe) - (arg1[6]));
  uint64_t x8 = (UINT64_C(0x7fffffffffffffe) - (arg1[7]));
  uint64_t x9 = (UINT64_C(0x3fffffffffffffe) - (arg1[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/*
 * The function fiat_p521_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p521_selectznz(uint64_t out1[9], fiat_p521_uint1 arg1, const uint64_t arg2[9], const uint64_t arg3[9]) {
  uint64_t x1;
  fiat_p521_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  uint64_t x2;
  fiat_p521_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  uint64_t x3;
  fiat_p521_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  uint64_t x4;
  fiat_p521_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  uint64_t x5;
  fiat_p521_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
  uint64_t x6;
  fiat_p521_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
  uint64_t x7;
  fiat_p521_cmovznz_u64(&x7, arg1, (arg2[6]), (arg3[6]));
  uint64_t x8;
  fiat_p521_cmovznz_u64(&x8, arg1, (arg2[7]), (arg3[7]));
  uint64_t x9;
  fiat_p521_cmovznz_u64(&x9, arg1, (arg2[8]), (arg3[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/*
 * The function fiat_p521_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_p521_to_bytes(uint8_t out1[66], const uint64_t arg1[9]) {
  uint64_t x1;
  fiat_p521_uint1 x2;
  fiat_p521_subborrowx_u58(&x1, &x2, 0x0, (arg1[0]), UINT64_C(0x3ffffffffffffff));
  uint64_t x3;
  fiat_p521_uint1 x4;
  fiat_p521_subborrowx_u58(&x3, &x4, x2, (arg1[1]), UINT64_C(0x3ffffffffffffff));
  uint64_t x5;
  fiat_p521_uint1 x6;
  fiat_p521_subborrowx_u58(&x5, &x6, x4, (arg1[2]), UINT64_C(0x3ffffffffffffff));
  uint64_t x7;
  fiat_p521_uint1 x8;
  fiat_p521_subborrowx_u58(&x7, &x8, x6, (arg1[3]), UINT64_C(0x3ffffffffffffff));
  uint64_t x9;
  fiat_p521_uint1 x10;
  fiat_p521_subborrowx_u58(&x9, &x10, x8, (arg1[4]), UINT64_C(0x3ffffffffffffff));
  uint64_t x11;
  fiat_p521_uint1 x12;
  fiat_p521_subborrowx_u58(&x11, &x12, x10, (arg1[5]), UINT64_C(0x3ffffffffffffff));
  uint64_t x13;
  fiat_p521_uint1 x14;
  fiat_p521_subborrowx_u58(&x13, &x14, x12, (arg1[6]), UINT64_C(0x3ffffffffffffff));
  uint64_t x15;
  fiat_p521_uint1 x16;
  fiat_p521_subborrowx_u58(&x15, &x16, x14, (arg1[7]), UINT64_C(0x3ffffffffffffff));
  uint64_t x17;
  fiat_p521_uint1 x18;
  fiat_p521_subborrowx_u57(&x17, &x18, x16, (arg1[8]), UINT64_C(0x1ffffffffffffff));
  uint64_t x19;
  fiat_p521_cmovznz_u64(&x19, x18, 0x0, UINT64_C(0xffffffffffffffff));
  uint64_t x20;
  fiat_p521_uint1 x21;
  fiat_p521_addcarryx_u58(&x20, &x21, 0x0, x1, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x22;
  fiat_p521_uint1 x23;
  fiat_p521_addcarryx_u58(&x22, &x23, x21, x3, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x24;
  fiat_p521_uint1 x25;
  fiat_p521_addcarryx_u58(&x24, &x25, x23, x5, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x26;
  fiat_p521_uint1 x27;
  fiat_p521_addcarryx_u58(&x26, &x27, x25, x7, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x28;
  fiat_p521_uint1 x29;
  fiat_p521_addcarryx_u58(&x28, &x29, x27, x9, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x30;
  fiat_p521_uint1 x31;
  fiat_p521_addcarryx_u58(&x30, &x31, x29, x11, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x32;
  fiat_p521_uint1 x33;
  fiat_p521_addcarryx_u58(&x32, &x33, x31, x13, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x34;
  fiat_p521_uint1 x35;
  fiat_p521_addcarryx_u58(&x34, &x35, x33, x15, (x19 & UINT64_C(0x3ffffffffffffff)));
  uint64_t x36;
  fiat_p521_uint1 x37;
  fiat_p521_addcarryx_u57(&x36, &x37, x35, x17, (x19 & UINT64_C(0x1ffffffffffffff)));
  uint64_t x38 = (x34 << 6);
  uint64_t x39 = (x32 << 4);
  uint64_t x40 = (x30 << 2);
  uint64_t x41 = (x26 << 6);
  uint64_t x42 = (x24 << 4);
  uint64_t x43 = (x22 << 2);
  uint64_t x44 = (x20 >> 8);
  uint8_t x45 = (uint8_t)(x20 & UINT8_C(0xff));
  uint64_t x46 = (x44 >> 8);
  uint8_t x47 = (uint8_t)(x44 & UINT8_C(0xff));
  uint64_t x48 = (x46 >> 8);
  uint8_t x49 = (uint8_t)(x46 & UINT8_C(0xff));
  uint64_t x50 = (x48 >> 8);
  uint8_t x51 = (uint8_t)(x48 & UINT8_C(0xff));
  uint64_t x52 = (x50 >> 8);
  uint8_t x53 = (uint8_t)(x50 & UINT8_C(0xff));
  uint64_t x54 = (x52 >> 8);
  uint8_t x55 = (uint8_t)(x52 & UINT8_C(0xff));
  uint8_t x56 = (uint8_t)(x54 >> 8);
  uint8_t x57 = (uint8_t)(x54 & UINT8_C(0xff));
  uint64_t x58 = (x56 + x43);
  uint64_t x59 = (x58 >> 8);
  uint8_t x60 = (uint8_t)(x58 & UINT8_C(0xff));
  uint64_t x61 = (x59 >> 8);
  uint8_t x62 = (uint8_t)(x59 & UINT8_C(0xff));
  uint64_t x63 = (x61 >> 8);
  uint8_t x64 = (uint8_t)(x61 & UINT8_C(0xff));
  uint64_t x65 = (x63 >> 8);
  uint8_t x66 = (uint8_t)(x63 & UINT8_C(0xff));
  uint64_t x67 = (x65 >> 8);
  uint8_t x68 = (uint8_t)(x65 & UINT8_C(0xff));
  uint64_t x69 = (x67 >> 8);
  uint8_t x70 = (uint8_t)(x67 & UINT8_C(0xff));
  uint8_t x71 = (uint8_t)(x69 >> 8);
  uint8_t x72 = (uint8_t)(x69 & UINT8_C(0xff));
  uint64_t x73 = (x71 + x42);
  uint64_t x74 = (x73 >> 8);
  uint8_t x75 = (uint8_t)(x73 & UINT8_C(0xff));
  uint64_t x76 = (x74 >> 8);
  uint8_t x77 = (uint8_t)(x74 & UINT8_C(0xff));
  uint64_t x78 = (x76 >> 8);
  uint8_t x79 = (uint8_t)(x76 & UINT8_C(0xff));
  uint64_t x80 = (x78 >> 8);
  uint8_t x81 = (uint8_t)(x78 & UINT8_C(0xff));
  uint64_t x82 = (x80 >> 8);
  uint8_t x83 = (uint8_t)(x80 & UINT8_C(0xff));
  uint64_t x84 = (x82 >> 8);
  uint8_t x85 = (uint8_t)(x82 & UINT8_C(0xff));
  uint8_t x86 = (uint8_t)(x84 >> 8);
  uint8_t x87 = (uint8_t)(x84 & UINT8_C(0xff));
  uint64_t x88 = (x86 + x41);
  uint64_t x89 = (x88 >> 8);
  uint8_t x90 = (uint8_t)(x88 & UINT8_C(0xff));
  uint64_t x91 = (x89 >> 8);
  uint8_t x92 = (uint8_t)(x89 & UINT8_C(0xff));
  uint64_t x93 = (x91 >> 8);
  uint8_t x94 = (uint8_t)(x91 & UINT8_C(0xff));
  uint64_t x95 = (x93 >> 8);
  uint8_t x96 = (uint8_t)(x93 & UINT8_C(0xff));
  uint64_t x97 = (x95 >> 8);
  uint8_t x98 = (uint8_t)(x95 & UINT8_C(0xff));
  uint64_t x99 = (x97 >> 8);
  uint8_t x100 = (uint8_t)(x97 & UINT8_C(0xff));
  uint8_t x101 = (uint8_t)(x99 >> 8);
  uint8_t x102 = (uint8_t)(x99 & UINT8_C(0xff));
  uint8_t x103 = (uint8_t)(x101 & UINT8_C(0xff));
  uint64_t x104 = (x28 >> 8);
  uint8_t x105 = (uint8_t)(x28 & UINT8_C(0xff));
  uint64_t x106 = (x104 >> 8);
  uint8_t x107 = (uint8_t)(x104 & UINT8_C(0xff));
  uint64_t x108 = (x106 >> 8);
  uint8_t x109 = (uint8_t)(x106 & UINT8_C(0xff));
  uint64_t x110 = (x108 >> 8);
  uint8_t x111 = (uint8_t)(x108 & UINT8_C(0xff));
  uint64_t x112 = (x110 >> 8);
  uint8_t x113 = (uint8_t)(x110 & UINT8_C(0xff));
  uint64_t x114 = (x112 >> 8);
  uint8_t x115 = (uint8_t)(x112 & UINT8_C(0xff));
  uint8_t x116 = (uint8_t)(x114 >> 8);
  uint8_t x117 = (uint8_t)(x114 & UINT8_C(0xff));
  uint64_t x118 = (x116 + x40);
  uint64_t x119 = (x118 >> 8);
  uint8_t x120 = (uint8_t)(x118 & UINT8_C(0xff));
  uint64_t x121 = (x119 >> 8);
  uint8_t x122 = (uint8_t)(x119 & UINT8_C(0xff));
  uint64_t x123 = (x121 >> 8);
  uint8_t x124 = (uint8_t)(x121 & UINT8_C(0xff));
  uint64_t x125 = (x123 >> 8);
  uint8_t x126 = (uint8_t)(x123 & UINT8_C(0xff));
  uint64_t x127 = (x125 >> 8);
  uint8_t x128 = (uint8_t)(x125 & UINT8_C(0xff));
  uint64_t x129 = (x127 >> 8);
  uint8_t x130 = (uint8_t)(x127 & UINT8_C(0xff));
  uint8_t x131 = (uint8_t)(x129 >> 8);
  uint8_t x132 = (uint8_t)(x129 & UINT8_C(0xff));
  uint64_t x133 = (x131 + x39);
  uint64_t x134 = (x133 >> 8);
  uint8_t x135 = (uint8_t)(x133 & UINT8_C(0xff));
  uint64_t x136 = (x134 >> 8);
  uint8_t x137 = (uint8_t)(x134 & UINT8_C(0xff));
  uint64_t x138 = (x136 >> 8);
  uint8_t x139 = (uint8_t)(x136 & UINT8_C(0xff));
  uint64_t x140 = (x138 >> 8);
  uint8_t x141 = (uint8_t)(x138 & UINT8_C(0xff));
  uint64_t x142 = (x140 >> 8);
  uint8_t x143 = (uint8_t)(x140 & UINT8_C(0xff));
  uint64_t x144 = (x142 >> 8);
  uint8_t x145 = (uint8_t)(x142 & UINT8_C(0xff));
  uint8_t x146 = (uint8_t)(x144 >> 8);
  uint8_t x147 = (uint8_t)(x144 & UINT8_C(0xff));
  uint64_t x148 = (x146 + x38);
  uint64_t x149 = (x148 >> 8);
  uint8_t x150 = (uint8_t)(x148 & UINT8_C(0xff));
  uint64_t x151 = (x149 >> 8);
  uint8_t x152 = (uint8_t)(x149 & UINT8_C(0xff));
  uint64_t x153 = (x151 >> 8);
  uint8_t x154 = (uint8_t)(x151 & UINT8_C(0xff));
  uint64_t x155 = (x153 >> 8);
  uint8_t x156 = (uint8_t)(x153 & UINT8_C(0xff));
  uint64_t x157 = (x155 >> 8);
  uint8_t x158 = (uint8_t)(x155 & UINT8_C(0xff));
  uint64_t x159 = (x157 >> 8);
  uint8_t x160 = (uint8_t)(x157 & UINT8_C(0xff));
  uint8_t x161 = (uint8_t)(x159 >> 8);
  uint8_t x162 = (uint8_t)(x159 & UINT8_C(0xff));
  uint8_t x163 = (uint8_t)(x161 & UINT8_C(0xff));
  uint64_t x164 = (x36 >> 8);
  uint8_t x165 = (uint8_t)(x36 & UINT8_C(0xff));
  uint64_t x166 = (x164 >> 8);
  uint8_t x167 = (uint8_t)(x164 & UINT8_C(0xff));
  uint64_t x168 = (x166 >> 8);
  uint8_t x169 = (uint8_t)(x166 & UINT8_C(0xff));
  uint64_t x170 = (x168 >> 8);
  uint8_t x171 = (uint8_t)(x168 & UINT8_C(0xff));
  uint64_t x172 = (x170 >> 8);
  uint8_t x173 = (uint8_t)(x170 & UINT8_C(0xff));
  uint64_t x174 = (x172 >> 8);
  uint8_t x175 = (uint8_t)(x172 & UINT8_C(0xff));
  fiat_p521_uint1 x176 = (fiat_p521_uint1)(x174 >> 8);
  uint8_t x177 = (uint8_t)(x174 & UINT8_C(0xff));
  out1[0] = x45;
  out1[1] = x47;
  out1[2] = x49;
  out1[3] = x51;
  out1[4] = x53;
  out1[5] = x55;
  out1[6] = x57;
  out1[7] = x60;
  out1[8] = x62;
  out1[9] = x64;
  out1[10] = x66;
  out1[11] = x68;
  out1[12] = x70;
  out1[13] = x72;
  out1[14] = x75;
  out1[15] = x77;
  out1[16] = x79;
  out1[17] = x81;
  out1[18] = x83;
  out1[19] = x85;
  out1[20] = x87;
  out1[21] = x90;
  out1[22] = x92;
  out1[23] = x94;
  out1[24] = x96;
  out1[25] = x98;
  out1[26] = x100;
  out1[27] = x102;
  out1[28] = x103;
  out1[29] = x105;
  out1[30] = x107;
  out1[31] = x109;
  out1[32] = x111;
  out1[33] = x113;
  out1[34] = x115;
  out1[35] = x117;
  out1[36] = x120;
  out1[37] = x122;
  out1[38] = x124;
  out1[39] = x126;
  out1[40] = x128;
  out1[41] = x130;
  out1[42] = x132;
  out1[43] = x135;
  out1[44] = x137;
  out1[45] = x139;
  out1[46] = x141;
  out1[47] = x143;
  out1[48] = x145;
  out1[49] = x147;
  out1[50] = x150;
  out1[51] = x152;
  out1[52] = x154;
  out1[53] = x156;
  out1[54] = x158;
  out1[55] = x160;
  out1[56] = x162;
  out1[57] = x163;
  out1[58] = x165;
  out1[59] = x167;
  out1[60] = x169;
  out1[61] = x171;
  out1[62] = x173;
  out1[63] = x175;
  out1[64] = x177;
  out1[65] = x176;
}

/*
 * The function fiat_p521_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x466666666666666], [0x0 ~> 0x233333333333333]]
 */
static void fiat_p521_from_bytes(uint64_t out1[9], const uint8_t arg1[66]) {
  uint64_t x1 = ((uint64_t)(fiat_p521_uint1)(arg1[65]) << 56);
  uint64_t x2 = ((uint64_t)(arg1[64]) << 48);
  uint64_t x3 = ((uint64_t)(arg1[63]) << 40);
  uint64_t x4 = ((uint64_t)(arg1[62]) << 32);
  uint64_t x5 = ((uint64_t)(arg1[61]) << 24);
  uint64_t x6 = ((uint64_t)(arg1[60]) << 16);
  uint64_t x7 = ((uint64_t)(arg1[59]) << 8);
  uint8_t x8 = (arg1[58]);
  uint64_t x9 = ((uint64_t)(arg1[57]) << 50);
  uint64_t x10 = ((uint64_t)(arg1[56]) << 42);
  uint64_t x11 = ((uint64_t)(arg1[55]) << 34);
  uint64_t x12 = ((uint64_t)(arg1[54]) << 26);
  uint64_t x13 = ((uint64_t)(arg1[53]) << 18);
  uint64_t x14 = ((uint64_t)(arg1[52]) << 10);
  uint64_t x15 = ((uint64_t)(arg1[51]) << 2);
  uint64_t x16 = ((uint64_t)(arg1[50]) << 52);
  uint64_t x17 = ((uint64_t)(arg1[49]) << 44);
  uint64_t x18 = ((uint64_t)(arg1[48]) << 36);
  uint64_t x19 = ((uint64_t)(arg1[47]) << 28);
  uint64_t x20 = ((uint64_t)(arg1[46]) << 20);
  uint64_t x21 = ((uint64_t)(arg1[45]) << 12);
  uint64_t x22 = ((uint64_t)(arg1[44]) << 4);
  uint64_t x23 = ((uint64_t)(arg1[43]) << 54);
  uint64_t x24 = ((uint64_t)(arg1[42]) << 46);
  uint64_t x25 = ((uint64_t)(arg1[41]) << 38);
  uint64_t x26 = ((uint64_t)(arg1[40]) << 30);
  uint64_t x27 = ((uint64_t)(arg1[39]) << 22);
  uint64_t x28 = ((uint64_t)(arg1[38]) << 14);
  uint64_t x29 = ((uint64_t)(arg1[37]) << 6);
  uint64_t x30 = ((uint64_t)(arg1[36]) << 56);
  uint64_t x31 = ((uint64_t)(arg1[35]) << 48);
  uint64_t x32 = ((uint64_t)(arg1[34]) << 40);
  uint64_t x33 = ((uint64_t)(arg1[33]) << 32);
  uint64_t x34 = ((uint64_t)(arg1[32]) << 24);
  uint64_t x35 = ((uint64_t)(arg1[31]) << 16);
  uint64_t x36 = ((uint64_t)(arg1[30]) << 8);
  uint8_t x37 = (arg1[29]);
  uint64_t x38 = ((uint64_t)(arg1[28]) << 50);
  uint64_t x39 = ((uint64_t)(arg1[27]) << 42);
  uint64_t x40 = ((uint64_t)(arg1[26]) << 34);
  uint64_t x41 = ((uint64_t)(arg1[25]) << 26);
  uint64_t x42 = ((uint64_t)(arg1[24]) << 18);
  uint64_t x43 = ((uint64_t)(arg1[23]) << 10);
  uint64_t x44 = ((uint64_t)(arg1[22]) << 2);
  uint64_t x45 = ((uint64_t)(arg1[21]) << 52);
  uint64_t x46 = ((uint64_t)(arg1[20]) << 44);
  uint64_t x47 = ((uint64_t)(arg1[19]) << 36);
  uint64_t x48 = ((uint64_t)(arg1[18]) << 28);
  uint64_t x49 = ((uint64_t)(arg1[17]) << 20);
  uint64_t x50 = ((uint64_t)(arg1[16]) << 12);
  uint64_t x51 = ((uint64_t)(arg1[15]) << 4);
  uint64_t x52 = ((uint64_t)(arg1[14]) << 54);
  uint64_t x53 = ((uint64_t)(arg1[13]) << 46);
  uint64_t x54 = ((uint64_t)(arg1[12]) << 38);
  uint64_t x55 = ((uint64_t)(arg1[11]) << 30);
  uint64_t x56 = ((uint64_t)(arg1[10]) << 22);
  uint64_t x57 = ((uint64_t)(arg1[9]) << 14);
  uint64_t x58 = ((uint64_t)(arg1[8]) << 6);
  uint64_t x59 = ((uint64_t)(arg1[7]) << 56);
  uint64_t x60 = ((uint64_t)(arg1[6]) << 48);
  uint64_t x61 = ((uint64_t)(arg1[5]) << 40);
  uint64_t x62 = ((uint64_t)(arg1[4]) << 32);
  uint64_t x63 = ((uint64_t)(arg1[3]) << 24);
  uint64_t x64 = ((uint64_t)(arg1[2]) << 16);
  uint64_t x65 = ((uint64_t)(arg1[1]) << 8);
  uint8_t x66 = (arg1[0]);
  uint64_t x67 = (x66 + (x65 + (x64 + (x63 + (x62 + (x61 + (x60 + x59)))))));
  uint8_t x68 = (uint8_t)(x67 >> 58);
  uint64_t x69 = (x67 & UINT64_C(0x3ffffffffffffff));
  uint64_t x70 = (x8 + (x7 + (x6 + (x5 + (x4 + (x3 + (x2 + x1)))))));
  uint64_t x71 = (x15 + (x14 + (x13 + (x12 + (x11 + (x10 + x9))))));
  uint64_t x72 = (x22 + (x21 + (x20 + (x19 + (x18 + (x17 + x16))))));
  uint64_t x73 = (x29 + (x28 + (x27 + (x26 + (x25 + (x24 + x23))))));
  uint64_t x74 = (x37 + (x36 + (x35 + (x34 + (x33 + (x32 + (x31 + x30)))))));
  uint64_t x75 = (x44 + (x43 + (x42 + (x41 + (x40 + (x39 + x38))))));
  uint64_t x76 = (x51 + (x50 + (x49 + (x48 + (x47 + (x46 + x45))))));
  uint64_t x77 = (x58 + (x57 + (x56 + (x55 + (x54 + (x53 + x52))))));
  uint64_t x78 = (x68 + x77);
  uint8_t x79 = (uint8_t)(x78 >> 58);
  uint64_t x80 = (x78 & UINT64_C(0x3ffffffffffffff));
  uint64_t x81 = (x79 + x76);
  uint8_t x82 = (uint8_t)(x81 >> 58);
  uint64_t x83 = (x81 & UINT64_C(0x3ffffffffffffff));
  uint64_t x84 = (x82 + x75);
  uint64_t x85 = (x84 & UINT64_C(0x3ffffffffffffff));
  uint8_t x86 = (uint8_t)(x74 >> 58);
  uint64_t x87 = (x74 & UINT64_C(0x3ffffffffffffff));
  uint64_t x88 = (x86 + x73);
  uint8_t x89 = (uint8_t)(x88 >> 58);
  uint64_t x90 = (x88 & UINT64_C(0x3ffffffffffffff));
  uint64_t x91 = (x89 + x72);
  uint8_t x92 = (uint8_t)(x91 >> 58);
  uint64_t x93 = (x91 & UINT64_C(0x3ffffffffffffff));
  uint64_t x94 = (x92 + x71);
  uint64_t x95 = (x94 & UINT64_C(0x3ffffffffffffff));
  out1[0] = x69;
  out1[1] = x80;
  out1[2] = x83;
  out1[3] = x85;
  out1[4] = x87;
  out1[5] = x90;
  out1[6] = x93;
  out1[7] = x95;
  out1[8] = x70;
}
