/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/unsaturated_solinas --static p521 19 '2^521 - 1' 32 */
/* curve description: p521 */
/* requested operations: (all) */
/* n = 19 (from "19") */
/* s-c = 2^521 - [(1, 1)] (from "2^521 - 1") */
/* machine_wordsize = 32 (from "32") */

/* Computed values: */
/* carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1] */

#include <stdint.h>
typedef unsigned char fiat_p521_uint1;
typedef signed char fiat_p521_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p521_addcarryx_u28 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^28
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^28⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffff]
 *   arg3: [0x0 ~> 0xfffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_addcarryx_u28(uint32_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint32_t x1 = ((arg1 + arg2) + arg3);
  uint32_t x2 = (x1 & UINT32_C(0xfffffff));
  fiat_p521_uint1 x3 = (fiat_p521_uint1)(x1 >> 28);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p521_subborrowx_u28 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^28
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^28⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffff]
 *   arg3: [0x0 ~> 0xfffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_subborrowx_u28(uint32_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int32_t x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
  fiat_p521_int1 x2 = (fiat_p521_int1)(x1 >> 28);
  uint32_t x3 = (x1 & UINT32_C(0xfffffff));
  *out1 = x3;
  *out2 = (fiat_p521_uint1)(0x0 - x2);
}

/*
 * The function fiat_p521_addcarryx_u27 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^27
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^27⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffff]
 *   arg3: [0x0 ~> 0x7ffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_addcarryx_u27(uint32_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint32_t x1 = ((arg1 + arg2) + arg3);
  uint32_t x2 = (x1 & UINT32_C(0x7ffffff));
  fiat_p521_uint1 x3 = (fiat_p521_uint1)(x1 >> 27);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p521_subborrowx_u27 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^27
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^27⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffff]
 *   arg3: [0x0 ~> 0x7ffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p521_subborrowx_u27(uint32_t* out1, fiat_p521_uint1* out2, fiat_p521_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int32_t x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
  fiat_p521_int1 x2 = (fiat_p521_int1)(x1 >> 27);
  uint32_t x3 = (x1 & UINT32_C(0x7ffffff));
  *out1 = x3;
  *out2 = (fiat_p521_uint1)(0x0 - x2);
}

/*
 * The function fiat_p521_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p521_cmovznz_u32(uint32_t* out1, fiat_p521_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_p521_uint1 x1 = (!(!arg1));
  uint32_t x2 = ((fiat_p521_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  uint32_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p521_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 *   arg2: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 */
static void fiat_p521_carry_mul(uint32_t out1[19], const uint32_t arg1[19], const uint32_t arg2[19]) {
  uint64_t x1 = ((uint64_t)(arg1[18]) * (arg2[18]));
  uint64_t x2 = ((uint64_t)(arg1[18]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x3 = ((uint64_t)(arg1[18]) * (arg2[16]));
  uint64_t x4 = ((uint64_t)(arg1[18]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x5 = ((uint64_t)(arg1[18]) * (arg2[14]));
  uint64_t x6 = ((uint64_t)(arg1[18]) * (arg2[13]));
  uint64_t x7 = ((uint64_t)(arg1[18]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x8 = ((uint64_t)(arg1[18]) * (arg2[11]));
  uint64_t x9 = ((uint64_t)(arg1[18]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x10 = ((uint64_t)(arg1[18]) * (arg2[9]));
  uint64_t x11 = ((uint64_t)(arg1[18]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x12 = ((uint64_t)(arg1[18]) * (arg2[7]));
  uint64_t x13 = ((uint64_t)(arg1[18]) * (arg2[6]));
  uint64_t x14 = ((uint64_t)(arg1[18]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x15 = ((uint64_t)(arg1[18]) * (arg2[4]));
  uint64_t x16 = ((uint64_t)(arg1[18]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x17 = ((uint64_t)(arg1[18]) * (arg2[2]));
  uint64_t x18 = ((uint64_t)(arg1[18]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x19 = ((uint64_t)(arg1[17]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x20 = ((uint64_t)(arg1[17]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x21 = ((uint64_t)(arg1[17]) * ((arg2[16]) * (uint32_t)0x2));
  uint64_t x22 = ((uint64_t)(arg1[17]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x23 = ((uint64_t)(arg1[17]) * (arg2[14]));
  uint64_t x24 = ((uint64_t)(arg1[17]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x25 = ((uint64_t)(arg1[17]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x26 = ((uint64_t)(arg1[17]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x27 = ((uint64_t)(arg1[17]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x28 = ((uint64_t)(arg1[17]) * ((arg2[9]) * (uint32_t)0x2));
  uint64_t x29 = ((uint64_t)(arg1[17]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x30 = ((uint64_t)(arg1[17]) * (arg2[7]));
  uint64_t x31 = ((uint64_t)(arg1[17]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x32 = ((uint64_t)(arg1[17]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x33 = ((uint64_t)(arg1[17]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x34 = ((uint64_t)(arg1[17]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x35 = ((uint64_t)(arg1[17]) * ((arg2[2]) * (uint32_t)0x2));
  uint64_t x36 = ((uint64_t)(arg1[16]) * (arg2[18]));
  uint64_t x37 = ((uint64_t)(arg1[16]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x38 = ((uint64_t)(arg1[16]) * (arg2[16]));
  uint64_t x39 = ((uint64_t)(arg1[16]) * (arg2[15]));
  uint64_t x40 = ((uint64_t)(arg1[16]) * (arg2[14]));
  uint64_t x41 = ((uint64_t)(arg1[16]) * (arg2[13]));
  uint64_t x42 = ((uint64_t)(arg1[16]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x43 = ((uint64_t)(arg1[16]) * (arg2[11]));
  uint64_t x44 = ((uint64_t)(arg1[16]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x45 = ((uint64_t)(arg1[16]) * (arg2[9]));
  uint64_t x46 = ((uint64_t)(arg1[16]) * (arg2[8]));
  uint64_t x47 = ((uint64_t)(arg1[16]) * (arg2[7]));
  uint64_t x48 = ((uint64_t)(arg1[16]) * (arg2[6]));
  uint64_t x49 = ((uint64_t)(arg1[16]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x50 = ((uint64_t)(arg1[16]) * (arg2[4]));
  uint64_t x51 = ((uint64_t)(arg1[16]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x52 = ((uint64_t)(arg1[15]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x53 = ((uint64_t)(arg1[15]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x54 = ((uint64_t)(arg1[15]) * (arg2[16]));
  uint64_t x55 = ((uint64_t)(arg1[15]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x56 = ((uint64_t)(arg1[15]) * (arg2[14]));
  uint64_t x57 = ((uint64_t)(arg1[15]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x58 = ((uint64_t)(arg1[15]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x59 = ((uint64_t)(arg1[15]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x60 = ((uint64_t)(arg1[15]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x61 = ((uint64_t)(arg1[15]) * (arg2[9]));
  uint64_t x62 = ((uint64_t)(arg1[15]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x63 = ((uint64_t)(arg1[15]) * (arg2[7]));
  uint64_t x64 = ((uint64_t)(arg1[15]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x65 = ((uint64_t)(arg1[15]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x66 = ((uint64_t)(arg1[15]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x67 = ((uint64_t)(arg1[14]) * (arg2[18]));
  uint64_t x68 = ((uint64_t)(arg1[14]) * (arg2[17]));
  uint64_t x69 = ((uint64_t)(arg1[14]) * (arg2[16]));
  uint64_t x70 = ((uint64_t)(arg1[14]) * (arg2[15]));
  uint64_t x71 = ((uint64_t)(arg1[14]) * (arg2[14]));
  uint64_t x72 = ((uint64_t)(arg1[14]) * (arg2[13]));
  uint64_t x73 = ((uint64_t)(arg1[14]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x74 = ((uint64_t)(arg1[14]) * (arg2[11]));
  uint64_t x75 = ((uint64_t)(arg1[14]) * (arg2[10]));
  uint64_t x76 = ((uint64_t)(arg1[14]) * (arg2[9]));
  uint64_t x77 = ((uint64_t)(arg1[14]) * (arg2[8]));
  uint64_t x78 = ((uint64_t)(arg1[14]) * (arg2[7]));
  uint64_t x79 = ((uint64_t)(arg1[14]) * (arg2[6]));
  uint64_t x80 = ((uint64_t)(arg1[14]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x81 = ((uint64_t)(arg1[13]) * (arg2[18]));
  uint64_t x82 = ((uint64_t)(arg1[13]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x83 = ((uint64_t)(arg1[13]) * (arg2[16]));
  uint64_t x84 = ((uint64_t)(arg1[13]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x85 = ((uint64_t)(arg1[13]) * (arg2[14]));
  uint64_t x86 = ((uint64_t)(arg1[13]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x87 = ((uint64_t)(arg1[13]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x88 = ((uint64_t)(arg1[13]) * (arg2[11]));
  uint64_t x89 = ((uint64_t)(arg1[13]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x90 = ((uint64_t)(arg1[13]) * (arg2[9]));
  uint64_t x91 = ((uint64_t)(arg1[13]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x92 = ((uint64_t)(arg1[13]) * (arg2[7]));
  uint64_t x93 = ((uint64_t)(arg1[13]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x94 = ((uint64_t)(arg1[12]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x95 = ((uint64_t)(arg1[12]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x96 = ((uint64_t)(arg1[12]) * ((arg2[16]) * (uint32_t)0x2));
  uint64_t x97 = ((uint64_t)(arg1[12]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x98 = ((uint64_t)(arg1[12]) * ((arg2[14]) * (uint32_t)0x2));
  uint64_t x99 = ((uint64_t)(arg1[12]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x100 = ((uint64_t)(arg1[12]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x101 = ((uint64_t)(arg1[12]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x102 = ((uint64_t)(arg1[12]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x103 = ((uint64_t)(arg1[12]) * ((arg2[9]) * (uint32_t)0x2));
  uint64_t x104 = ((uint64_t)(arg1[12]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x105 = ((uint64_t)(arg1[12]) * ((arg2[7]) * (uint32_t)0x2));
  uint64_t x106 = ((uint64_t)(arg1[11]) * (arg2[18]));
  uint64_t x107 = ((uint64_t)(arg1[11]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x108 = ((uint64_t)(arg1[11]) * (arg2[16]));
  uint64_t x109 = ((uint64_t)(arg1[11]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x110 = ((uint64_t)(arg1[11]) * (arg2[14]));
  uint64_t x111 = ((uint64_t)(arg1[11]) * (arg2[13]));
  uint64_t x112 = ((uint64_t)(arg1[11]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x113 = ((uint64_t)(arg1[11]) * (arg2[11]));
  uint64_t x114 = ((uint64_t)(arg1[11]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x115 = ((uint64_t)(arg1[11]) * (arg2[9]));
  uint64_t x116 = ((uint64_t)(arg1[11]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x117 = ((uint64_t)(arg1[10]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x118 = ((uint64_t)(arg1[10]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x119 = ((uint64_t)(arg1[10]) * ((arg2[16]) * (uint32_t)0x2));
  uint64_t x120 = ((uint64_t)(arg1[10]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x121 = ((uint64_t)(arg1[10]) * (arg2[14]));
  uint64_t x122 = ((uint64_t)(arg1[10]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x123 = ((uint64_t)(arg1[10]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x124 = ((uint64_t)(arg1[10]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x125 = ((uint64_t)(arg1[10]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x126 = ((uint64_t)(arg1[10]) * ((arg2[9]) * (uint32_t)0x2));
  uint64_t x127 = ((uint64_t)(arg1[9]) * (arg2[18]));
  uint64_t x128 = ((uint64_t)(arg1[9]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x129 = ((uint64_t)(arg1[9]) * (arg2[16]));
  uint64_t x130 = ((uint64_t)(arg1[9]) * (arg2[15]));
  uint64_t x131 = ((uint64_t)(arg1[9]) * (arg2[14]));
  uint64_t x132 = ((uint64_t)(arg1[9]) * (arg2[13]));
  uint64_t x133 = ((uint64_t)(arg1[9]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x134 = ((uint64_t)(arg1[9]) * (arg2[11]));
  uint64_t x135 = ((uint64_t)(arg1[9]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x136 = ((uint64_t)(arg1[8]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x137 = ((uint64_t)(arg1[8]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x138 = ((uint64_t)(arg1[8]) * (arg2[16]));
  uint64_t x139 = ((uint64_t)(arg1[8]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x140 = ((uint64_t)(arg1[8]) * (arg2[14]));
  uint64_t x141 = ((uint64_t)(arg1[8]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x142 = ((uint64_t)(arg1[8]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x143 = ((uint64_t)(arg1[8]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x144 = ((uint64_t)(arg1[7]) * (arg2[18]));
  uint64_t x145 = ((uint64_t)(arg1[7]) * (arg2[17]));
  uint64_t x146 = ((uint64_t)(arg1[7]) * (arg2[16]));
  uint64_t x147 = ((uint64_t)(arg1[7]) * (arg2[15]));
  uint64_t x148 = ((uint64_t)(arg1[7]) * (arg2[14]));
  uint64_t x149 = ((uint64_t)(arg1[7]) * (arg2[13]));
  uint64_t x150 = ((uint64_t)(arg1[7]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x151 = ((uint64_t)(arg1[6]) * (arg2[18]));
  uint64_t x152 = ((uint64_t)(arg1[6]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x153 = ((uint64_t)(arg1[6]) * (arg2[16]));
  uint64_t x154 = ((uint64_t)(arg1[6]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x155 = ((uint64_t)(arg1[6]) * (arg2[14]));
  uint64_t x156 = ((uint64_t)(arg1[6]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x157 = ((uint64_t)(arg1[5]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x158 = ((uint64_t)(arg1[5]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x159 = ((uint64_t)(arg1[5]) * ((arg2[16]) * (uint32_t)0x2));
  uint64_t x160 = ((uint64_t)(arg1[5]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x161 = ((uint64_t)(arg1[5]) * ((arg2[14]) * (uint32_t)0x2));
  uint64_t x162 = ((uint64_t)(arg1[4]) * (arg2[18]));
  uint64_t x163 = ((uint64_t)(arg1[4]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x164 = ((uint64_t)(arg1[4]) * (arg2[16]));
  uint64_t x165 = ((uint64_t)(arg1[4]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x166 = ((uint64_t)(arg1[3]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x167 = ((uint64_t)(arg1[3]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x168 = ((uint64_t)(arg1[3]) * ((arg2[16]) * (uint32_t)0x2));
  uint64_t x169 = ((uint64_t)(arg1[2]) * (arg2[18]));
  uint64_t x170 = ((uint64_t)(arg1[2]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x171 = ((uint64_t)(arg1[1]) * ((arg2[18]) * (uint32_t)0x2));
  uint64_t x172 = ((uint64_t)(arg1[18]) * (arg2[0]));
  uint64_t x173 = ((uint64_t)(arg1[17]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x174 = ((uint64_t)(arg1[17]) * (arg2[0]));
  uint64_t x175 = ((uint64_t)(arg1[16]) * (arg2[2]));
  uint64_t x176 = ((uint64_t)(arg1[16]) * (arg2[1]));
  uint64_t x177 = ((uint64_t)(arg1[16]) * (arg2[0]));
  uint64_t x178 = ((uint64_t)(arg1[15]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x179 = ((uint64_t)(arg1[15]) * (arg2[2]));
  uint64_t x180 = ((uint64_t)(arg1[15]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x181 = ((uint64_t)(arg1[15]) * (arg2[0]));
  uint64_t x182 = ((uint64_t)(arg1[14]) * (arg2[4]));
  uint64_t x183 = ((uint64_t)(arg1[14]) * (arg2[3]));
  uint64_t x184 = ((uint64_t)(arg1[14]) * (arg2[2]));
  uint64_t x185 = ((uint64_t)(arg1[14]) * (arg2[1]));
  uint64_t x186 = ((uint64_t)(arg1[14]) * (arg2[0]));
  uint64_t x187 = ((uint64_t)(arg1[13]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x188 = ((uint64_t)(arg1[13]) * (arg2[4]));
  uint64_t x189 = ((uint64_t)(arg1[13]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x190 = ((uint64_t)(arg1[13]) * (arg2[2]));
  uint64_t x191 = ((uint64_t)(arg1[13]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x192 = ((uint64_t)(arg1[13]) * (arg2[0]));
  uint64_t x193 = ((uint64_t)(arg1[12]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x194 = ((uint64_t)(arg1[12]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x195 = ((uint64_t)(arg1[12]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x196 = ((uint64_t)(arg1[12]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x197 = ((uint64_t)(arg1[12]) * ((arg2[2]) * (uint32_t)0x2));
  uint64_t x198 = ((uint64_t)(arg1[12]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x199 = ((uint64_t)(arg1[12]) * (arg2[0]));
  uint64_t x200 = ((uint64_t)(arg1[11]) * (arg2[7]));
  uint64_t x201 = ((uint64_t)(arg1[11]) * (arg2[6]));
  uint64_t x202 = ((uint64_t)(arg1[11]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x203 = ((uint64_t)(arg1[11]) * (arg2[4]));
  uint64_t x204 = ((uint64_t)(arg1[11]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x205 = ((uint64_t)(arg1[11]) * (arg2[2]));
  uint64_t x206 = ((uint64_t)(arg1[11]) * (arg2[1]));
  uint64_t x207 = ((uint64_t)(arg1[11]) * (arg2[0]));
  uint64_t x208 = ((uint64_t)(arg1[10]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x209 = ((uint64_t)(arg1[10]) * (arg2[7]));
  uint64_t x210 = ((uint64_t)(arg1[10]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x211 = ((uint64_t)(arg1[10]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x212 = ((uint64_t)(arg1[10]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x213 = ((uint64_t)(arg1[10]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x214 = ((uint64_t)(arg1[10]) * (arg2[2]));
  uint64_t x215 = ((uint64_t)(arg1[10]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x216 = ((uint64_t)(arg1[10]) * (arg2[0]));
  uint64_t x217 = ((uint64_t)(arg1[9]) * (arg2[9]));
  uint64_t x218 = ((uint64_t)(arg1[9]) * (arg2[8]));
  uint64_t x219 = ((uint64_t)(arg1[9]) * (arg2[7]));
  uint64_t x220 = ((uint64_t)(arg1[9]) * (arg2[6]));
  uint64_t x221 = ((uint64_t)(arg1[9]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x222 = ((uint64_t)(arg1[9]) * (arg2[4]));
  uint64_t x223 = ((uint64_t)(arg1[9]) * (arg2[3]));
  uint64_t x224 = ((uint64_t)(arg1[9]) * (arg2[2]));
  uint64_t x225 = ((uint64_t)(arg1[9]) * (arg2[1]));
  uint64_t x226 = ((uint64_t)(arg1[9]) * (arg2[0]));
  uint64_t x227 = ((uint64_t)(arg1[8]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x228 = ((uint64_t)(arg1[8]) * (arg2[9]));
  uint64_t x229 = ((uint64_t)(arg1[8]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x230 = ((uint64_t)(arg1[8]) * (arg2[7]));
  uint64_t x231 = ((uint64_t)(arg1[8]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x232 = ((uint64_t)(arg1[8]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x233 = ((uint64_t)(arg1[8]) * (arg2[4]));
  uint64_t x234 = ((uint64_t)(arg1[8]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x235 = ((uint64_t)(arg1[8]) * (arg2[2]));
  uint64_t x236 = ((uint64_t)(arg1[8]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x237 = ((uint64_t)(arg1[8]) * (arg2[0]));
  uint64_t x238 = ((uint64_t)(arg1[7]) * (arg2[11]));
  uint64_t x239 = ((uint64_t)(arg1[7]) * (arg2[10]));
  uint64_t x240 = ((uint64_t)(arg1[7]) * (arg2[9]));
  uint64_t x241 = ((uint64_t)(arg1[7]) * (arg2[8]));
  uint64_t x242 = ((uint64_t)(arg1[7]) * (arg2[7]));
  uint64_t x243 = ((uint64_t)(arg1[7]) * (arg2[6]));
  uint64_t x244 = ((uint64_t)(arg1[7]) * (arg2[5]));
  uint64_t x245 = ((uint64_t)(arg1[7]) * (arg2[4]));
  uint64_t x246 = ((uint64_t)(arg1[7]) * (arg2[3]));
  uint64_t x247 = ((uint64_t)(arg1[7]) * (arg2[2]));
  uint64_t x248 = ((uint64_t)(arg1[7]) * (arg2[1]));
  uint64_t x249 = ((uint64_t)(arg1[7]) * (arg2[0]));
  uint64_t x250 = ((uint64_t)(arg1[6]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x251 = ((uint64_t)(arg1[6]) * (arg2[11]));
  uint64_t x252 = ((uint64_t)(arg1[6]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x253 = ((uint64_t)(arg1[6]) * (arg2[9]));
  uint64_t x254 = ((uint64_t)(arg1[6]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x255 = ((uint64_t)(arg1[6]) * (arg2[7]));
  uint64_t x256 = ((uint64_t)(arg1[6]) * (arg2[6]));
  uint64_t x257 = ((uint64_t)(arg1[6]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x258 = ((uint64_t)(arg1[6]) * (arg2[4]));
  uint64_t x259 = ((uint64_t)(arg1[6]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x260 = ((uint64_t)(arg1[6]) * (arg2[2]));
  uint64_t x261 = ((uint64_t)(arg1[6]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x262 = ((uint64_t)(arg1[6]) * (arg2[0]));
  uint64_t x263 = ((uint64_t)(arg1[5]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x264 = ((uint64_t)(arg1[5]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x265 = ((uint64_t)(arg1[5]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x266 = ((uint64_t)(arg1[5]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x267 = ((uint64_t)(arg1[5]) * ((arg2[9]) * (uint32_t)0x2));
  uint64_t x268 = ((uint64_t)(arg1[5]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x269 = ((uint64_t)(arg1[5]) * (arg2[7]));
  uint64_t x270 = ((uint64_t)(arg1[5]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x271 = ((uint64_t)(arg1[5]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x272 = ((uint64_t)(arg1[5]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x273 = ((uint64_t)(arg1[5]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x274 = ((uint64_t)(arg1[5]) * ((arg2[2]) * (uint32_t)0x2));
  uint64_t x275 = ((uint64_t)(arg1[5]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x276 = ((uint64_t)(arg1[5]) * (arg2[0]));
  uint64_t x277 = ((uint64_t)(arg1[4]) * (arg2[14]));
  uint64_t x278 = ((uint64_t)(arg1[4]) * (arg2[13]));
  uint64_t x279 = ((uint64_t)(arg1[4]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x280 = ((uint64_t)(arg1[4]) * (arg2[11]));
  uint64_t x281 = ((uint64_t)(arg1[4]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x282 = ((uint64_t)(arg1[4]) * (arg2[9]));
  uint64_t x283 = ((uint64_t)(arg1[4]) * (arg2[8]));
  uint64_t x284 = ((uint64_t)(arg1[4]) * (arg2[7]));
  uint64_t x285 = ((uint64_t)(arg1[4]) * (arg2[6]));
  uint64_t x286 = ((uint64_t)(arg1[4]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x287 = ((uint64_t)(arg1[4]) * (arg2[4]));
  uint64_t x288 = ((uint64_t)(arg1[4]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x289 = ((uint64_t)(arg1[4]) * (arg2[2]));
  uint64_t x290 = ((uint64_t)(arg1[4]) * (arg2[1]));
  uint64_t x291 = ((uint64_t)(arg1[4]) * (arg2[0]));
  uint64_t x292 = ((uint64_t)(arg1[3]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x293 = ((uint64_t)(arg1[3]) * (arg2[14]));
  uint64_t x294 = ((uint64_t)(arg1[3]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x295 = ((uint64_t)(arg1[3]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x296 = ((uint64_t)(arg1[3]) * ((arg2[11]) * (uint32_t)0x2));
  uint64_t x297 = ((uint64_t)(arg1[3]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x298 = ((uint64_t)(arg1[3]) * (arg2[9]));
  uint64_t x299 = ((uint64_t)(arg1[3]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x300 = ((uint64_t)(arg1[3]) * (arg2[7]));
  uint64_t x301 = ((uint64_t)(arg1[3]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x302 = ((uint64_t)(arg1[3]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x303 = ((uint64_t)(arg1[3]) * ((arg2[4]) * (uint32_t)0x2));
  uint64_t x304 = ((uint64_t)(arg1[3]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x305 = ((uint64_t)(arg1[3]) * (arg2[2]));
  uint64_t x306 = ((uint64_t)(arg1[3]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x307 = ((uint64_t)(arg1[3]) * (arg2[0]));
  uint64_t x308 = ((uint64_t)(arg1[2]) * (arg2[16]));
  uint64_t x309 = ((uint64_t)(arg1[2]) * (arg2[15]));
  uint64_t x310 = ((uint64_t)(arg1[2]) * (arg2[14]));
  uint64_t x311 = ((uint64_t)(arg1[2]) * (arg2[13]));
  uint64_t x312 = ((uint64_t)(arg1[2]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x313 = ((uint64_t)(arg1[2]) * (arg2[11]));
  uint64_t x314 = ((uint64_t)(arg1[2]) * (arg2[10]));
  uint64_t x315 = ((uint64_t)(arg1[2]) * (arg2[9]));
  uint64_t x316 = ((uint64_t)(arg1[2]) * (arg2[8]));
  uint64_t x317 = ((uint64_t)(arg1[2]) * (arg2[7]));
  uint64_t x318 = ((uint64_t)(arg1[2]) * (arg2[6]));
  uint64_t x319 = ((uint64_t)(arg1[2]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x320 = ((uint64_t)(arg1[2]) * (arg2[4]));
  uint64_t x321 = ((uint64_t)(arg1[2]) * (arg2[3]));
  uint64_t x322 = ((uint64_t)(arg1[2]) * (arg2[2]));
  uint64_t x323 = ((uint64_t)(arg1[2]) * (arg2[1]));
  uint64_t x324 = ((uint64_t)(arg1[2]) * (arg2[0]));
  uint64_t x325 = ((uint64_t)(arg1[1]) * ((arg2[17]) * (uint32_t)0x2));
  uint64_t x326 = ((uint64_t)(arg1[1]) * (arg2[16]));
  uint64_t x327 = ((uint64_t)(arg1[1]) * ((arg2[15]) * (uint32_t)0x2));
  uint64_t x328 = ((uint64_t)(arg1[1]) * (arg2[14]));
  uint64_t x329 = ((uint64_t)(arg1[1]) * ((arg2[13]) * (uint32_t)0x2));
  uint64_t x330 = ((uint64_t)(arg1[1]) * ((arg2[12]) * (uint32_t)0x2));
  uint64_t x331 = ((uint64_t)(arg1[1]) * (arg2[11]));
  uint64_t x332 = ((uint64_t)(arg1[1]) * ((arg2[10]) * (uint32_t)0x2));
  uint64_t x333 = ((uint64_t)(arg1[1]) * (arg2[9]));
  uint64_t x334 = ((uint64_t)(arg1[1]) * ((arg2[8]) * (uint32_t)0x2));
  uint64_t x335 = ((uint64_t)(arg1[1]) * (arg2[7]));
  uint64_t x336 = ((uint64_t)(arg1[1]) * ((arg2[6]) * (uint32_t)0x2));
  uint64_t x337 = ((uint64_t)(arg1[1]) * ((arg2[5]) * (uint32_t)0x2));
  uint64_t x338 = ((uint64_t)(arg1[1]) * (arg2[4]));
  uint64_t x339 = ((uint64_t)(arg1[1]) * ((arg2[3]) * (uint32_t)0x2));
  uint64_t x340 = ((uint64_t)(arg1[1]) * (arg2[2]));
  uint64_t x341 = ((uint64_t)(arg1[1]) * ((arg2[1]) * (uint32_t)0x2));
  uint64_t x342 = ((uint64_t)(arg1[1]) * (arg2[0]));
  uint64_t x343 = ((uint64_t)(arg1[0]) * (arg2[18]));
  uint64_t x344 = ((uint64_t)(arg1[0]) * (arg2[17]));
  uint64_t x345 = ((uint64_t)(arg1[0]) * (arg2[16]));
  uint64_t x346 = ((uint64_t)(arg1[0]) * (arg2[15]));
  uint64_t x347 = ((uint64_t)(arg1[0]) * (arg2[14]));
  uint64_t x348 = ((uint64_t)(arg1[0]) * (arg2[13]));
  uint64_t x349 = ((uint64_t)(arg1[0]) * (arg2[12]));
  uint64_t x350 = ((uint64_t)(arg1[0]) * (arg2[11]));
  uint64_t x351 = ((uint64_t)(arg1[0]) * (arg2[10]));
  uint64_t x352 = ((uint64_t)(arg1[0]) * (arg2[9]));
  uint64_t x353 = ((uint64_t)(arg1[0]) * (arg2[8]));
  uint64_t x354 = ((uint64_t)(arg1[0]) * (arg2[7]));
  uint64_t x355 = ((uint64_t)(arg1[0]) * (arg2[6]));
  uint64_t x356 = ((uint64_t)(arg1[0]) * (arg2[5]));
  uint64_t x357 = ((uint64_t)(arg1[0]) * (arg2[4]));
  uint64_t x358 = ((uint64_t)(arg1[0]) * (arg2[3]));
  uint64_t x359 = ((uint64_t)(arg1[0]) * (arg2[2]));
  uint64_t x360 = ((uint64_t)(arg1[0]) * (arg2[1]));
  uint64_t x361 = ((uint64_t)(arg1[0]) * (arg2[0]));
  uint64_t x362 = (x361 + (x171 + (x170 + (x168 + (x165 + (x161 + (x156 + (x150 + (x143 + (x135 + (x126 + (x116 + (x105 + (x93 + (x80 + (x66 + (x51 + (x35 + x18))))))))))))))))));
  uint64_t x363 = (x362 >> 28);
  uint32_t x364 = (uint32_t)(x362 & UINT32_C(0xfffffff));
  uint64_t x365 = (x343 + (x325 + (x308 + (x292 + (x277 + (x263 + (x250 + (x238 + (x227 + (x217 + (x208 + (x200 + (x193 + (x187 + (x182 + (x178 + (x175 + (x173 + x172))))))))))))))))));
  uint64_t x366 = (x344 + (x326 + (x309 + (x293 + (x278 + (x264 + (x251 + (x239 + (x228 + (x218 + (x209 + (x201 + (x194 + (x188 + (x183 + (x179 + (x176 + (x174 + x1))))))))))))))))));
  uint64_t x367 = (x345 + (x327 + (x310 + (x294 + (x279 + (x265 + (x252 + (x240 + (x229 + (x219 + (x210 + (x202 + (x195 + (x189 + (x184 + (x180 + (x177 + (x19 + x2))))))))))))))))));
  uint64_t x368 = (x346 + (x328 + (x311 + (x295 + (x280 + (x266 + (x253 + (x241 + (x230 + (x220 + (x211 + (x203 + (x196 + (x190 + (x185 + (x181 + (x36 + (x20 + x3))))))))))))))))));
  uint64_t x369 = (x347 + (x329 + (x312 + (x296 + (x281 + (x267 + (x254 + (x242 + (x231 + (x221 + (x212 + (x204 + (x197 + (x191 + (x186 + (x52 + (x37 + (x21 + x4))))))))))))))))));
  uint64_t x370 = (x348 + (x330 + (x313 + (x297 + (x282 + (x268 + (x255 + (x243 + (x232 + (x222 + (x213 + (x205 + (x198 + (x192 + (x67 + (x53 + (x38 + (x22 + x5))))))))))))))))));
  uint64_t x371 = (x349 + (x331 + (x314 + (x298 + (x283 + (x269 + (x256 + (x244 + (x233 + (x223 + (x214 + (x206 + (x199 + (x81 + (x68 + (x54 + (x39 + (x23 + x6))))))))))))))))));
  uint64_t x372 = (x350 + (x332 + (x315 + (x299 + (x284 + (x270 + (x257 + (x245 + (x234 + (x224 + (x215 + (x207 + (x94 + (x82 + (x69 + (x55 + (x40 + (x24 + x7))))))))))))))))));
  uint64_t x373 = (x351 + (x333 + (x316 + (x300 + (x285 + (x271 + (x258 + (x246 + (x235 + (x225 + (x216 + (x106 + (x95 + (x83 + (x70 + (x56 + (x41 + (x25 + x8))))))))))))))))));
  uint64_t x374 = (x352 + (x334 + (x317 + (x301 + (x286 + (x272 + (x259 + (x247 + (x236 + (x226 + (x117 + (x107 + (x96 + (x84 + (x71 + (x57 + (x42 + (x26 + x9))))))))))))))))));
  uint64_t x375 = (x353 + (x335 + (x318 + (x302 + (x287 + (x273 + (x260 + (x248 + (x237 + (x127 + (x118 + (x108 + (x97 + (x85 + (x72 + (x58 + (x43 + (x27 + x10))))))))))))))))));
  uint64_t x376 = (x354 + (x336 + (x319 + (x303 + (x288 + (x274 + (x261 + (x249 + (x136 + (x128 + (x119 + (x109 + (x98 + (x86 + (x73 + (x59 + (x44 + (x28 + x11))))))))))))))))));
  uint64_t x377 = (x355 + (x337 + (x320 + (x304 + (x289 + (x275 + (x262 + (x144 + (x137 + (x129 + (x120 + (x110 + (x99 + (x87 + (x74 + (x60 + (x45 + (x29 + x12))))))))))))))))));
  uint64_t x378 = (x356 + (x338 + (x321 + (x305 + (x290 + (x276 + (x151 + (x145 + (x138 + (x130 + (x121 + (x111 + (x100 + (x88 + (x75 + (x61 + (x46 + (x30 + x13))))))))))))))))));
  uint64_t x379 = (x357 + (x339 + (x322 + (x306 + (x291 + (x157 + (x152 + (x146 + (x139 + (x131 + (x122 + (x112 + (x101 + (x89 + (x76 + (x62 + (x47 + (x31 + x14))))))))))))))))));
  uint64_t x380 = (x358 + (x340 + (x323 + (x307 + (x162 + (x158 + (x153 + (x147 + (x140 + (x132 + (x123 + (x113 + (x102 + (x90 + (x77 + (x63 + (x48 + (x32 + x15))))))))))))))))));
  uint64_t x381 = (x359 + (x341 + (x324 + (x166 + (x163 + (x159 + (x154 + (x148 + (x141 + (x133 + (x124 + (x114 + (x103 + (x91 + (x78 + (x64 + (x49 + (x33 + x16))))))))))))))))));
  uint64_t x382 = (x360 + (x342 + (x169 + (x167 + (x164 + (x160 + (x155 + (x149 + (x142 + (x134 + (x125 + (x115 + (x104 + (x92 + (x79 + (x65 + (x50 + (x34 + x17))))))))))))))))));
  uint64_t x383 = (x363 + x382);
  uint64_t x384 = (x383 >> 27);
  uint32_t x385 = (uint32_t)(x383 & UINT32_C(0x7ffffff));
  uint64_t x386 = (x384 + x381);
  uint64_t x387 = (x386 >> 28);
  uint32_t x388 = (uint32_t)(x386 & UINT32_C(0xfffffff));
  uint64_t x389 = (x387 + x380);
  uint64_t x390 = (x389 >> 27);
  uint32_t x391 = (uint32_t)(x389 & UINT32_C(0x7ffffff));
  uint64_t x392 = (x390 + x379);
  uint64_t x393 = (x392 >> 28);
  uint32_t x394 = (uint32_t)(x392 & UINT32_C(0xfffffff));
  uint64_t x395 = (x393 + x378);
  uint64_t x396 = (x395 >> 27);
  uint32_t x397 = (uint32_t)(x395 & UINT32_C(0x7ffffff));
  uint64_t x398 = (x396 + x377);
  uint64_t x399 = (x398 >> 27);
  uint32_t x400 = (uint32_t)(x398 & UINT32_C(0x7ffffff));
  uint64_t x401 = (x399 + x376);
  uint64_t x402 = (x401 >> 28);
  uint32_t x403 = (uint32_t)(x401 & UINT32_C(0xfffffff));
  uint64_t x404 = (x402 + x375);
  uint64_t x405 = (x404 >> 27);
  uint32_t x406 = (uint32_t)(x404 & UINT32_C(0x7ffffff));
  uint64_t x407 = (x405 + x374);
  uint64_t x408 = (x407 >> 28);
  uint32_t x409 = (uint32_t)(x407 & UINT32_C(0xfffffff));
  uint64_t x410 = (x408 + x373);
  uint64_t x411 = (x410 >> 27);
  uint32_t x412 = (uint32_t)(x410 & UINT32_C(0x7ffffff));
  uint64_t x413 = (x411 + x372);
  uint64_t x414 = (x413 >> 28);
  uint32_t x415 = (uint32_t)(x413 & UINT32_C(0xfffffff));
  uint64_t x416 = (x414 + x371);
  uint64_t x417 = (x416 >> 27);
  uint32_t x418 = (uint32_t)(x416 & UINT32_C(0x7ffffff));
  uint64_t x419 = (x417 + x370);
  uint64_t x420 = (x419 >> 27);
  uint32_t x421 = (uint32_t)(x419 & UINT32_C(0x7ffffff));
  uint64_t x422 = (x420 + x369);
  uint64_t x423 = (x422 >> 28);
  uint32_t x424 = (uint32_t)(x422 & UINT32_C(0xfffffff));
  uint64_t x425 = (x423 + x368);
  uint64_t x426 = (x425 >> 27);
  uint32_t x427 = (uint32_t)(x425 & UINT32_C(0x7ffffff));
  uint64_t x428 = (x426 + x367);
  uint64_t x429 = (x428 >> 28);
  uint32_t x430 = (uint32_t)(x428 & UINT32_C(0xfffffff));
  uint64_t x431 = (x429 + x366);
  uint64_t x432 = (x431 >> 27);
  uint32_t x433 = (uint32_t)(x431 & UINT32_C(0x7ffffff));
  uint64_t x434 = (x432 + x365);
  uint64_t x435 = (x434 >> 27);
  uint32_t x436 = (uint32_t)(x434 & UINT32_C(0x7ffffff));
  uint64_t x437 = (x364 + x435);
  uint32_t x438 = (uint32_t)(x437 >> 28);
  uint32_t x439 = (uint32_t)(x437 & UINT32_C(0xfffffff));
  uint32_t x440 = (x438 + x385);
  fiat_p521_uint1 x441 = (fiat_p521_uint1)(x440 >> 27);
  uint32_t x442 = (x440 & UINT32_C(0x7ffffff));
  uint32_t x443 = (x441 + x388);
  out1[0] = x439;
  out1[1] = x442;
  out1[2] = x443;
  out1[3] = x391;
  out1[4] = x394;
  out1[5] = x397;
  out1[6] = x400;
  out1[7] = x403;
  out1[8] = x406;
  out1[9] = x409;
  out1[10] = x412;
  out1[11] = x415;
  out1[12] = x418;
  out1[13] = x421;
  out1[14] = x424;
  out1[15] = x427;
  out1[16] = x430;
  out1[17] = x433;
  out1[18] = x436;
}

/*
 * The function fiat_p521_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 */
static void fiat_p521_carry_square(uint32_t out1[19], const uint32_t arg1[19]) {
  uint32_t x1 = (arg1[18]);
  uint32_t x2 = (x1 * (uint32_t)0x2);
  uint32_t x3 = ((arg1[18]) * (uint32_t)0x2);
  uint32_t x4 = (arg1[17]);
  uint32_t x5 = (x4 * (uint32_t)0x2);
  uint32_t x6 = ((arg1[17]) * (uint32_t)0x2);
  uint32_t x7 = (arg1[16]);
  uint32_t x8 = (x7 * (uint32_t)0x2);
  uint32_t x9 = ((arg1[16]) * (uint32_t)0x2);
  uint32_t x10 = (arg1[15]);
  uint32_t x11 = (x10 * (uint32_t)0x2);
  uint32_t x12 = ((arg1[15]) * (uint32_t)0x2);
  uint32_t x13 = (arg1[14]);
  uint32_t x14 = (x13 * (uint32_t)0x2);
  uint32_t x15 = ((arg1[14]) * (uint32_t)0x2);
  uint32_t x16 = (arg1[13]);
  uint32_t x17 = (x16 * (uint32_t)0x2);
  uint32_t x18 = ((arg1[13]) * (uint32_t)0x2);
  uint32_t x19 = (arg1[12]);
  uint32_t x20 = (x19 * (uint32_t)0x2);
  uint32_t x21 = ((arg1[12]) * (uint32_t)0x2);
  uint32_t x22 = (arg1[11]);
  uint32_t x23 = (x22 * (uint32_t)0x2);
  uint32_t x24 = ((arg1[11]) * (uint32_t)0x2);
  uint32_t x25 = (arg1[10]);
  uint32_t x26 = (x25 * (uint32_t)0x2);
  uint32_t x27 = ((arg1[10]) * (uint32_t)0x2);
  uint32_t x28 = ((arg1[9]) * (uint32_t)0x2);
  uint32_t x29 = ((arg1[8]) * (uint32_t)0x2);
  uint32_t x30 = ((arg1[7]) * (uint32_t)0x2);
  uint32_t x31 = ((arg1[6]) * (uint32_t)0x2);
  uint32_t x32 = ((arg1[5]) * (uint32_t)0x2);
  uint32_t x33 = ((arg1[4]) * (uint32_t)0x2);
  uint32_t x34 = ((arg1[3]) * (uint32_t)0x2);
  uint32_t x35 = ((arg1[2]) * (uint32_t)0x2);
  uint32_t x36 = ((arg1[1]) * (uint32_t)0x2);
  uint64_t x37 = ((uint64_t)(arg1[18]) * x1);
  uint64_t x38 = ((uint64_t)(arg1[17]) * (x2 * (uint32_t)0x2));
  uint64_t x39 = ((uint64_t)(arg1[17]) * (x4 * (uint32_t)0x2));
  uint64_t x40 = ((uint64_t)(arg1[16]) * x2);
  uint64_t x41 = ((uint64_t)(arg1[16]) * (x5 * (uint32_t)0x2));
  uint64_t x42 = ((uint64_t)(arg1[16]) * x7);
  uint64_t x43 = ((uint64_t)(arg1[15]) * (x2 * (uint32_t)0x2));
  uint64_t x44 = ((uint64_t)(arg1[15]) * (x5 * (uint32_t)0x2));
  uint64_t x45 = ((uint64_t)(arg1[15]) * x8);
  uint64_t x46 = ((uint64_t)(arg1[15]) * (x10 * (uint32_t)0x2));
  uint64_t x47 = ((uint64_t)(arg1[14]) * x2);
  uint64_t x48 = ((uint64_t)(arg1[14]) * x5);
  uint64_t x49 = ((uint64_t)(arg1[14]) * x8);
  uint64_t x50 = ((uint64_t)(arg1[14]) * x11);
  uint64_t x51 = ((uint64_t)(arg1[14]) * x13);
  uint64_t x52 = ((uint64_t)(arg1[13]) * x2);
  uint64_t x53 = ((uint64_t)(arg1[13]) * (x5 * (uint32_t)0x2));
  uint64_t x54 = ((uint64_t)(arg1[13]) * x8);
  uint64_t x55 = ((uint64_t)(arg1[13]) * (x11 * (uint32_t)0x2));
  uint64_t x56 = ((uint64_t)(arg1[13]) * x14);
  uint64_t x57 = ((uint64_t)(arg1[13]) * (x16 * (uint32_t)0x2));
  uint64_t x58 = ((uint64_t)(arg1[12]) * (x2 * (uint32_t)0x2));
  uint64_t x59 = ((uint64_t)(arg1[12]) * (x5 * (uint32_t)0x2));
  uint64_t x60 = ((uint64_t)(arg1[12]) * (x8 * (uint32_t)0x2));
  uint64_t x61 = ((uint64_t)(arg1[12]) * (x11 * (uint32_t)0x2));
  uint64_t x62 = ((uint64_t)(arg1[12]) * (x14 * (uint32_t)0x2));
  uint64_t x63 = ((uint64_t)(arg1[12]) * (x17 * (uint32_t)0x2));
  uint64_t x64 = ((uint64_t)(arg1[12]) * (x19 * (uint32_t)0x2));
  uint64_t x65 = ((uint64_t)(arg1[11]) * x2);
  uint64_t x66 = ((uint64_t)(arg1[11]) * (x5 * (uint32_t)0x2));
  uint64_t x67 = ((uint64_t)(arg1[11]) * x8);
  uint64_t x68 = ((uint64_t)(arg1[11]) * (x11 * (uint32_t)0x2));
  uint64_t x69 = ((uint64_t)(arg1[11]) * x14);
  uint64_t x70 = ((uint64_t)(arg1[11]) * x17);
  uint64_t x71 = ((uint64_t)(arg1[11]) * (x20 * (uint32_t)0x2));
  uint64_t x72 = ((uint64_t)(arg1[11]) * x22);
  uint64_t x73 = ((uint64_t)(arg1[10]) * (x2 * (uint32_t)0x2));
  uint64_t x74 = ((uint64_t)(arg1[10]) * (x5 * (uint32_t)0x2));
  uint64_t x75 = ((uint64_t)(arg1[10]) * (x8 * (uint32_t)0x2));
  uint64_t x76 = ((uint64_t)(arg1[10]) * (x11 * (uint32_t)0x2));
  uint64_t x77 = ((uint64_t)(arg1[10]) * x14);
  uint64_t x78 = ((uint64_t)(arg1[10]) * (x17 * (uint32_t)0x2));
  uint64_t x79 = ((uint64_t)(arg1[10]) * (x20 * (uint32_t)0x2));
  uint64_t x80 = ((uint64_t)(arg1[10]) * (x23 * (uint32_t)0x2));
  uint64_t x81 = ((uint64_t)(arg1[10]) * (x25 * (uint32_t)0x2));
  uint64_t x82 = ((uint64_t)(arg1[9]) * x2);
  uint64_t x83 = ((uint64_t)(arg1[9]) * (x5 * (uint32_t)0x2));
  uint64_t x84 = ((uint64_t)(arg1[9]) * x8);
  uint64_t x85 = ((uint64_t)(arg1[9]) * x11);
  uint64_t x86 = ((uint64_t)(arg1[9]) * x14);
  uint64_t x87 = ((uint64_t)(arg1[9]) * x17);
  uint64_t x88 = ((uint64_t)(arg1[9]) * (x20 * (uint32_t)0x2));
  uint64_t x89 = ((uint64_t)(arg1[9]) * x23);
  uint64_t x90 = ((uint64_t)(arg1[9]) * (x26 * (uint32_t)0x2));
  uint64_t x91 = ((uint64_t)(arg1[9]) * (arg1[9]));
  uint64_t x92 = ((uint64_t)(arg1[8]) * (x2 * (uint32_t)0x2));
  uint64_t x93 = ((uint64_t)(arg1[8]) * (x5 * (uint32_t)0x2));
  uint64_t x94 = ((uint64_t)(arg1[8]) * x8);
  uint64_t x95 = ((uint64_t)(arg1[8]) * (x11 * (uint32_t)0x2));
  uint64_t x96 = ((uint64_t)(arg1[8]) * x14);
  uint64_t x97 = ((uint64_t)(arg1[8]) * (x17 * (uint32_t)0x2));
  uint64_t x98 = ((uint64_t)(arg1[8]) * (x20 * (uint32_t)0x2));
  uint64_t x99 = ((uint64_t)(arg1[8]) * (x23 * (uint32_t)0x2));
  uint64_t x100 = ((uint64_t)(arg1[8]) * (x27 * (uint32_t)0x2));
  uint64_t x101 = ((uint64_t)(arg1[8]) * x28);
  uint64_t x102 = ((uint64_t)(arg1[8]) * ((arg1[8]) * (uint32_t)0x2));
  uint64_t x103 = ((uint64_t)(arg1[7]) * x2);
  uint64_t x104 = ((uint64_t)(arg1[7]) * x5);
  uint64_t x105 = ((uint64_t)(arg1[7]) * x8);
  uint64_t x106 = ((uint64_t)(arg1[7]) * x11);
  uint64_t x107 = ((uint64_t)(arg1[7]) * x14);
  uint64_t x108 = ((uint64_t)(arg1[7]) * x17);
  uint64_t x109 = ((uint64_t)(arg1[7]) * (x20 * (uint32_t)0x2));
  uint64_t x110 = ((uint64_t)(arg1[7]) * x24);
  uint64_t x111 = ((uint64_t)(arg1[7]) * x27);
  uint64_t x112 = ((uint64_t)(arg1[7]) * x28);
  uint64_t x113 = ((uint64_t)(arg1[7]) * x29);
  uint64_t x114 = ((uint64_t)(arg1[7]) * (arg1[7]));
  uint64_t x115 = ((uint64_t)(arg1[6]) * x2);
  uint64_t x116 = ((uint64_t)(arg1[6]) * (x5 * (uint32_t)0x2));
  uint64_t x117 = ((uint64_t)(arg1[6]) * x8);
  uint64_t x118 = ((uint64_t)(arg1[6]) * (x11 * (uint32_t)0x2));
  uint64_t x119 = ((uint64_t)(arg1[6]) * x14);
  uint64_t x120 = ((uint64_t)(arg1[6]) * (x17 * (uint32_t)0x2));
  uint64_t x121 = ((uint64_t)(arg1[6]) * (x21 * (uint32_t)0x2));
  uint64_t x122 = ((uint64_t)(arg1[6]) * x24);
  uint64_t x123 = ((uint64_t)(arg1[6]) * (x27 * (uint32_t)0x2));
  uint64_t x124 = ((uint64_t)(arg1[6]) * x28);
  uint64_t x125 = ((uint64_t)(arg1[6]) * (x29 * (uint32_t)0x2));
  uint64_t x126 = ((uint64_t)(arg1[6]) * x30);
  uint64_t x127 = ((uint64_t)(arg1[6]) * (arg1[6]));
  uint64_t x128 = ((uint64_t)(arg1[5]) * (x2 * (uint32_t)0x2));
  uint64_t x129 = ((uint64_t)(arg1[5]) * (x5 * (uint32_t)0x2));
  uint64_t x130 = ((uint64_t)(arg1[5]) * (x8 * (uint32_t)0x2));
  uint64_t x131 = ((uint64_t)(arg1[5]) * (x11 * (uint32_t)0x2));
  uint64_t x132 = ((uint64_t)(arg1[5]) * (x14 * (uint32_t)0x2));
  uint64_t x133 = ((uint64_t)(arg1[5]) * (x18 * (uint32_t)0x2));
  uint64_t x134 = ((uint64_t)(arg1[5]) * (x21 * (uint32_t)0x2));
  uint64_t x135 = ((uint64_t)(arg1[5]) * (x24 * (uint32_t)0x2));
  uint64_t x136 = ((uint64_t)(arg1[5]) * (x27 * (uint32_t)0x2));
  uint64_t x137 = ((uint64_t)(arg1[5]) * (x28 * (uint32_t)0x2));
  uint64_t x138 = ((uint64_t)(arg1[5]) * (x29 * (uint32_t)0x2));
  uint64_t x139 = ((uint64_t)(arg1[5]) * x30);
  uint64_t x140 = ((uint64_t)(arg1[5]) * (x31 * (uint32_t)0x2));
  uint64_t x141 = ((uint64_t)(arg1[5]) * ((arg1[5]) * (uint32_t)0x2));
  uint64_t x142 = ((uint64_t)(arg1[4]) * x2);
  uint64_t x143 = ((uint64_t)(arg1[4]) * (x5 * (uint32_t)0x2));
  uint64_t x144 = ((uint64_t)(arg1[4]) * x8);
  uint64_t x145 = ((uint64_t)(arg1[4]) * (x11 * (uint32_t)0x2));
  uint64_t x146 = ((uint64_t)(arg1[4]) * x15);
  uint64_t x147 = ((uint64_t)(arg1[4]) * x18);
  uint64_t x148 = ((uint64_t)(arg1[4]) * (x21 * (uint32_t)0x2));
  uint64_t x149 = ((uint64_t)(arg1[4]) * x24);
  uint64_t x150 = ((uint64_t)(arg1[4]) * (x27 * (uint32_t)0x2));
  uint64_t x151 = ((uint64_t)(arg1[4]) * x28);
  uint64_t x152 = ((uint64_t)(arg1[4]) * x29);
  uint64_t x153 = ((uint64_t)(arg1[4]) * x30);
  uint64_t x154 = ((uint64_t)(arg1[4]) * x31);
  uint64_t x155 = ((uint64_t)(arg1[4]) * (x32 * (uint32_t)0x2));
  uint64_t x156 = ((uint64_t)(arg1[4]) * (arg1[4]));
  uint64_t x157 = ((uint64_t)(arg1[3]) * (x2 * (uint32_t)0x2));
  uint64_t x158 = ((uint64_t)(arg1[3]) * (x5 * (uint32_t)0x2));
  uint64_t x159 = ((uint64_t)(arg1[3]) * (x8 * (uint32_t)0x2));
  uint64_t x160 = ((uint64_t)(arg1[3]) * (x12 * (uint32_t)0x2));
  uint64_t x161 = ((uint64_t)(arg1[3]) * x15);
  uint64_t x162 = ((uint64_t)(arg1[3]) * (x18 * (uint32_t)0x2));
  uint64_t x163 = ((uint64_t)(arg1[3]) * (x21 * (uint32_t)0x2));
  uint64_t x164 = ((uint64_t)(arg1[3]) * (x24 * (uint32_t)0x2));
  uint64_t x165 = ((uint64_t)(arg1[3]) * (x27 * (uint32_t)0x2));
  uint64_t x166 = ((uint64_t)(arg1[3]) * x28);
  uint64_t x167 = ((uint64_t)(arg1[3]) * (x29 * (uint32_t)0x2));
  uint64_t x168 = ((uint64_t)(arg1[3]) * x30);
  uint64_t x169 = ((uint64_t)(arg1[3]) * (x31 * (uint32_t)0x2));
  uint64_t x170 = ((uint64_t)(arg1[3]) * (x32 * (uint32_t)0x2));
  uint64_t x171 = ((uint64_t)(arg1[3]) * (x33 * (uint32_t)0x2));
  uint64_t x172 = ((uint64_t)(arg1[3]) * ((arg1[3]) * (uint32_t)0x2));
  uint64_t x173 = ((uint64_t)(arg1[2]) * x2);
  uint64_t x174 = ((uint64_t)(arg1[2]) * (x5 * (uint32_t)0x2));
  uint64_t x175 = ((uint64_t)(arg1[2]) * x9);
  uint64_t x176 = ((uint64_t)(arg1[2]) * x12);
  uint64_t x177 = ((uint64_t)(arg1[2]) * x15);
  uint64_t x178 = ((uint64_t)(arg1[2]) * x18);
  uint64_t x179 = ((uint64_t)(arg1[2]) * (x21 * (uint32_t)0x2));
  uint64_t x180 = ((uint64_t)(arg1[2]) * x24);
  uint64_t x181 = ((uint64_t)(arg1[2]) * x27);
  uint64_t x182 = ((uint64_t)(arg1[2]) * x28);
  uint64_t x183 = ((uint64_t)(arg1[2]) * x29);
  uint64_t x184 = ((uint64_t)(arg1[2]) * x30);
  uint64_t x185 = ((uint64_t)(arg1[2]) * x31);
  uint64_t x186 = ((uint64_t)(arg1[2]) * (x32 * (uint32_t)0x2));
  uint64_t x187 = ((uint64_t)(arg1[2]) * x33);
  uint64_t x188 = ((uint64_t)(arg1[2]) * x34);
  uint64_t x189 = ((uint64_t)(arg1[2]) * (arg1[2]));
  uint64_t x190 = ((uint64_t)(arg1[1]) * (x2 * (uint32_t)0x2));
  uint64_t x191 = ((uint64_t)(arg1[1]) * (x6 * (uint32_t)0x2));
  uint64_t x192 = ((uint64_t)(arg1[1]) * x9);
  uint64_t x193 = ((uint64_t)(arg1[1]) * (x12 * (uint32_t)0x2));
  uint64_t x194 = ((uint64_t)(arg1[1]) * x15);
  uint64_t x195 = ((uint64_t)(arg1[1]) * (x18 * (uint32_t)0x2));
  uint64_t x196 = ((uint64_t)(arg1[1]) * (x21 * (uint32_t)0x2));
  uint64_t x197 = ((uint64_t)(arg1[1]) * x24);
  uint64_t x198 = ((uint64_t)(arg1[1]) * (x27 * (uint32_t)0x2));
  uint64_t x199 = ((uint64_t)(arg1[1]) * x28);
  uint64_t x200 = ((uint64_t)(arg1[1]) * (x29 * (uint32_t)0x2));
  uint64_t x201 = ((uint64_t)(arg1[1]) * x30);
  uint64_t x202 = ((uint64_t)(arg1[1]) * (x31 * (uint32_t)0x2));
  uint64_t x203 = ((uint64_t)(arg1[1]) * (x32 * (uint32_t)0x2));
  uint64_t x204 = ((uint64_t)(arg1[1]) * x33);
  uint64_t x205 = ((uint64_t)(arg1[1]) * (x34 * (uint32_t)0x2));
  uint64_t x206 = ((uint64_t)(arg1[1]) * x35);
  uint64_t x207 = ((uint64_t)(arg1[1]) * ((arg1[1]) * (uint32_t)0x2));
  uint64_t x208 = ((uint64_t)(arg1[0]) * x3);
  uint64_t x209 = ((uint64_t)(arg1[0]) * x6);
  uint64_t x210 = ((uint64_t)(arg1[0]) * x9);
  uint64_t x211 = ((uint64_t)(arg1[0]) * x12);
  uint64_t x212 = ((uint64_t)(arg1[0]) * x15);
  uint64_t x213 = ((uint64_t)(arg1[0]) * x18);
  uint64_t x214 = ((uint64_t)(arg1[0]) * x21);
  uint64_t x215 = ((uint64_t)(arg1[0]) * x24);
  uint64_t x216 = ((uint64_t)(arg1[0]) * x27);
  uint64_t x217 = ((uint64_t)(arg1[0]) * x28);
  uint64_t x218 = ((uint64_t)(arg1[0]) * x29);
  uint64_t x219 = ((uint64_t)(arg1[0]) * x30);
  uint64_t x220 = ((uint64_t)(arg1[0]) * x31);
  uint64_t x221 = ((uint64_t)(arg1[0]) * x32);
  uint64_t x222 = ((uint64_t)(arg1[0]) * x33);
  uint64_t x223 = ((uint64_t)(arg1[0]) * x34);
  uint64_t x224 = ((uint64_t)(arg1[0]) * x35);
  uint64_t x225 = ((uint64_t)(arg1[0]) * x36);
  uint64_t x226 = ((uint64_t)(arg1[0]) * (arg1[0]));
  uint64_t x227 = (x226 + (x190 + (x174 + (x159 + (x145 + (x132 + (x120 + (x109 + (x99 + x90)))))))));
  uint64_t x228 = (x227 >> 28);
  uint32_t x229 = (uint32_t)(x227 & UINT32_C(0xfffffff));
  uint64_t x230 = (x208 + (x191 + (x175 + (x160 + (x146 + (x133 + (x121 + (x110 + (x100 + x91)))))))));
  uint64_t x231 = (x209 + (x192 + (x176 + (x161 + (x147 + (x134 + (x122 + (x111 + (x101 + x37)))))))));
  uint64_t x232 = (x210 + (x193 + (x177 + (x162 + (x148 + (x135 + (x123 + (x112 + (x102 + x38)))))))));
  uint64_t x233 = (x211 + (x194 + (x178 + (x163 + (x149 + (x136 + (x124 + (x113 + (x40 + x39)))))))));
  uint64_t x234 = (x212 + (x195 + (x179 + (x164 + (x150 + (x137 + (x125 + (x114 + (x43 + x41)))))))));
  uint64_t x235 = (x213 + (x196 + (x180 + (x165 + (x151 + (x138 + (x126 + (x47 + (x44 + x42)))))))));
  uint64_t x236 = (x214 + (x197 + (x181 + (x166 + (x152 + (x139 + (x127 + (x52 + (x48 + x45)))))))));
  uint64_t x237 = (x215 + (x198 + (x182 + (x167 + (x153 + (x140 + (x58 + (x53 + (x49 + x46)))))))));
  uint64_t x238 = (x216 + (x199 + (x183 + (x168 + (x154 + (x141 + (x65 + (x59 + (x54 + x50)))))))));
  uint64_t x239 = (x217 + (x200 + (x184 + (x169 + (x155 + (x73 + (x66 + (x60 + (x55 + x51)))))))));
  uint64_t x240 = (x218 + (x201 + (x185 + (x170 + (x156 + (x82 + (x74 + (x67 + (x61 + x56)))))))));
  uint64_t x241 = (x219 + (x202 + (x186 + (x171 + (x92 + (x83 + (x75 + (x68 + (x62 + x57)))))))));
  uint64_t x242 = (x220 + (x203 + (x187 + (x172 + (x103 + (x93 + (x84 + (x76 + (x69 + x63)))))))));
  uint64_t x243 = (x221 + (x204 + (x188 + (x115 + (x104 + (x94 + (x85 + (x77 + (x70 + x64)))))))));
  uint64_t x244 = (x222 + (x205 + (x189 + (x128 + (x116 + (x105 + (x95 + (x86 + (x78 + x71)))))))));
  uint64_t x245 = (x223 + (x206 + (x142 + (x129 + (x117 + (x106 + (x96 + (x87 + (x79 + x72)))))))));
  uint64_t x246 = (x224 + (x207 + (x157 + (x143 + (x130 + (x118 + (x107 + (x97 + (x88 + x80)))))))));
  uint64_t x247 = (x225 + (x173 + (x158 + (x144 + (x131 + (x119 + (x108 + (x98 + (x89 + x81)))))))));
  uint64_t x248 = (x228 + x247);
  uint64_t x249 = (x248 >> 27);
  uint32_t x250 = (uint32_t)(x248 & UINT32_C(0x7ffffff));
  uint64_t x251 = (x249 + x246);
  uint64_t x252 = (x251 >> 28);
  uint32_t x253 = (uint32_t)(x251 & UINT32_C(0xfffffff));
  uint64_t x254 = (x252 + x245);
  uint64_t x255 = (x254 >> 27);
  uint32_t x256 = (uint32_t)(x254 & UINT32_C(0x7ffffff));
  uint64_t x257 = (x255 + x244);
  uint64_t x258 = (x257 >> 28);
  uint32_t x259 = (uint32_t)(x257 & UINT32_C(0xfffffff));
  uint64_t x260 = (x258 + x243);
  uint64_t x261 = (x260 >> 27);
  uint32_t x262 = (uint32_t)(x260 & UINT32_C(0x7ffffff));
  uint64_t x263 = (x261 + x242);
  uint64_t x264 = (x263 >> 27);
  uint32_t x265 = (uint32_t)(x263 & UINT32_C(0x7ffffff));
  uint64_t x266 = (x264 + x241);
  uint64_t x267 = (x266 >> 28);
  uint32_t x268 = (uint32_t)(x266 & UINT32_C(0xfffffff));
  uint64_t x269 = (x267 + x240);
  uint64_t x270 = (x269 >> 27);
  uint32_t x271 = (uint32_t)(x269 & UINT32_C(0x7ffffff));
  uint64_t x272 = (x270 + x239);
  uint64_t x273 = (x272 >> 28);
  uint32_t x274 = (uint32_t)(x272 & UINT32_C(0xfffffff));
  uint64_t x275 = (x273 + x238);
  uint64_t x276 = (x275 >> 27);
  uint32_t x277 = (uint32_t)(x275 & UINT32_C(0x7ffffff));
  uint64_t x278 = (x276 + x237);
  uint64_t x279 = (x278 >> 28);
  uint32_t x280 = (uint32_t)(x278 & UINT32_C(0xfffffff));
  uint64_t x281 = (x279 + x236);
  uint64_t x282 = (x281 >> 27);
  uint32_t x283 = (uint32_t)(x281 & UINT32_C(0x7ffffff));
  uint64_t x284 = (x282 + x235);
  uint64_t x285 = (x284 >> 27);
  uint32_t x286 = (uint32_t)(x284 & UINT32_C(0x7ffffff));
  uint64_t x287 = (x285 + x234);
  uint64_t x288 = (x287 >> 28);
  uint32_t x289 = (uint32_t)(x287 & UINT32_C(0xfffffff));
  uint64_t x290 = (x288 + x233);
  uint64_t x291 = (x290 >> 27);
  uint32_t x292 = (uint32_t)(x290 & UINT32_C(0x7ffffff));
  uint64_t x293 = (x291 + x232);
  uint64_t x294 = (x293 >> 28);
  uint32_t x295 = (uint32_t)(x293 & UINT32_C(0xfffffff));
  uint64_t x296 = (x294 + x231);
  uint64_t x297 = (x296 >> 27);
  uint32_t x298 = (uint32_t)(x296 & UINT32_C(0x7ffffff));
  uint64_t x299 = (x297 + x230);
  uint64_t x300 = (x299 >> 27);
  uint32_t x301 = (uint32_t)(x299 & UINT32_C(0x7ffffff));
  uint64_t x302 = (x229 + x300);
  uint32_t x303 = (uint32_t)(x302 >> 28);
  uint32_t x304 = (uint32_t)(x302 & UINT32_C(0xfffffff));
  uint32_t x305 = (x303 + x250);
  fiat_p521_uint1 x306 = (fiat_p521_uint1)(x305 >> 27);
  uint32_t x307 = (x305 & UINT32_C(0x7ffffff));
  uint32_t x308 = (x306 + x253);
  out1[0] = x304;
  out1[1] = x307;
  out1[2] = x308;
  out1[3] = x256;
  out1[4] = x259;
  out1[5] = x262;
  out1[6] = x265;
  out1[7] = x268;
  out1[8] = x271;
  out1[9] = x274;
  out1[10] = x277;
  out1[11] = x280;
  out1[12] = x283;
  out1[13] = x286;
  out1[14] = x289;
  out1[15] = x292;
  out1[16] = x295;
  out1[17] = x298;
  out1[18] = x301;
}

/*
 * The function fiat_p521_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 */
static void fiat_p521_carry(uint32_t out1[19], const uint32_t arg1[19]) {
  uint32_t x1 = (arg1[0]);
  uint32_t x2 = ((x1 >> 28) + (arg1[1]));
  uint32_t x3 = ((x2 >> 27) + (arg1[2]));
  uint32_t x4 = ((x3 >> 28) + (arg1[3]));
  uint32_t x5 = ((x4 >> 27) + (arg1[4]));
  uint32_t x6 = ((x5 >> 28) + (arg1[5]));
  uint32_t x7 = ((x6 >> 27) + (arg1[6]));
  uint32_t x8 = ((x7 >> 27) + (arg1[7]));
  uint32_t x9 = ((x8 >> 28) + (arg1[8]));
  uint32_t x10 = ((x9 >> 27) + (arg1[9]));
  uint32_t x11 = ((x10 >> 28) + (arg1[10]));
  uint32_t x12 = ((x11 >> 27) + (arg1[11]));
  uint32_t x13 = ((x12 >> 28) + (arg1[12]));
  uint32_t x14 = ((x13 >> 27) + (arg1[13]));
  uint32_t x15 = ((x14 >> 27) + (arg1[14]));
  uint32_t x16 = ((x15 >> 28) + (arg1[15]));
  uint32_t x17 = ((x16 >> 27) + (arg1[16]));
  uint32_t x18 = ((x17 >> 28) + (arg1[17]));
  uint32_t x19 = ((x18 >> 27) + (arg1[18]));
  uint32_t x20 = ((x1 & UINT32_C(0xfffffff)) + (x19 >> 27));
  uint32_t x21 = ((fiat_p521_uint1)(x20 >> 28) + (x2 & UINT32_C(0x7ffffff)));
  uint32_t x22 = (x20 & UINT32_C(0xfffffff));
  uint32_t x23 = (x21 & UINT32_C(0x7ffffff));
  uint32_t x24 = ((fiat_p521_uint1)(x21 >> 27) + (x3 & UINT32_C(0xfffffff)));
  uint32_t x25 = (x4 & UINT32_C(0x7ffffff));
  uint32_t x26 = (x5 & UINT32_C(0xfffffff));
  uint32_t x27 = (x6 & UINT32_C(0x7ffffff));
  uint32_t x28 = (x7 & UINT32_C(0x7ffffff));
  uint32_t x29 = (x8 & UINT32_C(0xfffffff));
  uint32_t x30 = (x9 & UINT32_C(0x7ffffff));
  uint32_t x31 = (x10 & UINT32_C(0xfffffff));
  uint32_t x32 = (x11 & UINT32_C(0x7ffffff));
  uint32_t x33 = (x12 & UINT32_C(0xfffffff));
  uint32_t x34 = (x13 & UINT32_C(0x7ffffff));
  uint32_t x35 = (x14 & UINT32_C(0x7ffffff));
  uint32_t x36 = (x15 & UINT32_C(0xfffffff));
  uint32_t x37 = (x16 & UINT32_C(0x7ffffff));
  uint32_t x38 = (x17 & UINT32_C(0xfffffff));
  uint32_t x39 = (x18 & UINT32_C(0x7ffffff));
  uint32_t x40 = (x19 & UINT32_C(0x7ffffff));
  out1[0] = x22;
  out1[1] = x23;
  out1[2] = x24;
  out1[3] = x25;
  out1[4] = x26;
  out1[5] = x27;
  out1[6] = x28;
  out1[7] = x29;
  out1[8] = x30;
  out1[9] = x31;
  out1[10] = x32;
  out1[11] = x33;
  out1[12] = x34;
  out1[13] = x35;
  out1[14] = x36;
  out1[15] = x37;
  out1[16] = x38;
  out1[17] = x39;
  out1[18] = x40;
}

/*
 * The function fiat_p521_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 *   arg2: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 */
static void fiat_p521_add(uint32_t out1[19], const uint32_t arg1[19], const uint32_t arg2[19]) {
  uint32_t x1 = ((arg1[0]) + (arg2[0]));
  uint32_t x2 = ((arg1[1]) + (arg2[1]));
  uint32_t x3 = ((arg1[2]) + (arg2[2]));
  uint32_t x4 = ((arg1[3]) + (arg2[3]));
  uint32_t x5 = ((arg1[4]) + (arg2[4]));
  uint32_t x6 = ((arg1[5]) + (arg2[5]));
  uint32_t x7 = ((arg1[6]) + (arg2[6]));
  uint32_t x8 = ((arg1[7]) + (arg2[7]));
  uint32_t x9 = ((arg1[8]) + (arg2[8]));
  uint32_t x10 = ((arg1[9]) + (arg2[9]));
  uint32_t x11 = ((arg1[10]) + (arg2[10]));
  uint32_t x12 = ((arg1[11]) + (arg2[11]));
  uint32_t x13 = ((arg1[12]) + (arg2[12]));
  uint32_t x14 = ((arg1[13]) + (arg2[13]));
  uint32_t x15 = ((arg1[14]) + (arg2[14]));
  uint32_t x16 = ((arg1[15]) + (arg2[15]));
  uint32_t x17 = ((arg1[16]) + (arg2[16]));
  uint32_t x18 = ((arg1[17]) + (arg2[17]));
  uint32_t x19 = ((arg1[18]) + (arg2[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/*
 * The function fiat_p521_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 *   arg2: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 */
static void fiat_p521_sub(uint32_t out1[19], const uint32_t arg1[19], const uint32_t arg2[19]) {
  uint32_t x1 = ((UINT32_C(0x1ffffffe) + (arg1[0])) - (arg2[0]));
  uint32_t x2 = ((UINT32_C(0xffffffe) + (arg1[1])) - (arg2[1]));
  uint32_t x3 = ((UINT32_C(0x1ffffffe) + (arg1[2])) - (arg2[2]));
  uint32_t x4 = ((UINT32_C(0xffffffe) + (arg1[3])) - (arg2[3]));
  uint32_t x5 = ((UINT32_C(0x1ffffffe) + (arg1[4])) - (arg2[4]));
  uint32_t x6 = ((UINT32_C(0xffffffe) + (arg1[5])) - (arg2[5]));
  uint32_t x7 = ((UINT32_C(0xffffffe) + (arg1[6])) - (arg2[6]));
  uint32_t x8 = ((UINT32_C(0x1ffffffe) + (arg1[7])) - (arg2[7]));
  uint32_t x9 = ((UINT32_C(0xffffffe) + (arg1[8])) - (arg2[8]));
  uint32_t x10 = ((UINT32_C(0x1ffffffe) + (arg1[9])) - (arg2[9]));
  uint32_t x11 = ((UINT32_C(0xffffffe) + (arg1[10])) - (arg2[10]));
  uint32_t x12 = ((UINT32_C(0x1ffffffe) + (arg1[11])) - (arg2[11]));
  uint32_t x13 = ((UINT32_C(0xffffffe) + (arg1[12])) - (arg2[12]));
  uint32_t x14 = ((UINT32_C(0xffffffe) + (arg1[13])) - (arg2[13]));
  uint32_t x15 = ((UINT32_C(0x1ffffffe) + (arg1[14])) - (arg2[14]));
  uint32_t x16 = ((UINT32_C(0xffffffe) + (arg1[15])) - (arg2[15]));
  uint32_t x17 = ((UINT32_C(0x1ffffffe) + (arg1[16])) - (arg2[16]));
  uint32_t x18 = ((UINT32_C(0xffffffe) + (arg1[17])) - (arg2[17]));
  uint32_t x19 = ((UINT32_C(0xffffffe) + (arg1[18])) - (arg2[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/*
 * The function fiat_p521_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x34cccccb], [0x0 ~> 0x1a666664], [0x0 ~> 0x1a666664]]
 */
static void fiat_p521_opp(uint32_t out1[19], const uint32_t arg1[19]) {
  uint32_t x1 = (UINT32_C(0x1ffffffe) - (arg1[0]));
  uint32_t x2 = (UINT32_C(0xffffffe) - (arg1[1]));
  uint32_t x3 = (UINT32_C(0x1ffffffe) - (arg1[2]));
  uint32_t x4 = (UINT32_C(0xffffffe) - (arg1[3]));
  uint32_t x5 = (UINT32_C(0x1ffffffe) - (arg1[4]));
  uint32_t x6 = (UINT32_C(0xffffffe) - (arg1[5]));
  uint32_t x7 = (UINT32_C(0xffffffe) - (arg1[6]));
  uint32_t x8 = (UINT32_C(0x1ffffffe) - (arg1[7]));
  uint32_t x9 = (UINT32_C(0xffffffe) - (arg1[8]));
  uint32_t x10 = (UINT32_C(0x1ffffffe) - (arg1[9]));
  uint32_t x11 = (UINT32_C(0xffffffe) - (arg1[10]));
  uint32_t x12 = (UINT32_C(0x1ffffffe) - (arg1[11]));
  uint32_t x13 = (UINT32_C(0xffffffe) - (arg1[12]));
  uint32_t x14 = (UINT32_C(0xffffffe) - (arg1[13]));
  uint32_t x15 = (UINT32_C(0x1ffffffe) - (arg1[14]));
  uint32_t x16 = (UINT32_C(0xffffffe) - (arg1[15]));
  uint32_t x17 = (UINT32_C(0x1ffffffe) - (arg1[16]));
  uint32_t x18 = (UINT32_C(0xffffffe) - (arg1[17]));
  uint32_t x19 = (UINT32_C(0xffffffe) - (arg1[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/*
 * The function fiat_p521_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p521_selectznz(uint32_t out1[19], fiat_p521_uint1 arg1, const uint32_t arg2[19], const uint32_t arg3[19]) {
  uint32_t x1;
  fiat_p521_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  uint32_t x2;
  fiat_p521_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  uint32_t x3;
  fiat_p521_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  uint32_t x4;
  fiat_p521_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  uint32_t x5;
  fiat_p521_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  uint32_t x6;
  fiat_p521_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  uint32_t x7;
  fiat_p521_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  uint32_t x8;
  fiat_p521_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
  uint32_t x9;
  fiat_p521_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
  uint32_t x10;
  fiat_p521_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
  uint32_t x11;
  fiat_p521_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
  uint32_t x12;
  fiat_p521_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
  uint32_t x13;
  fiat_p521_cmovznz_u32(&x13, arg1, (arg2[12]), (arg3[12]));
  uint32_t x14;
  fiat_p521_cmovznz_u32(&x14, arg1, (arg2[13]), (arg3[13]));
  uint32_t x15;
  fiat_p521_cmovznz_u32(&x15, arg1, (arg2[14]), (arg3[14]));
  uint32_t x16;
  fiat_p521_cmovznz_u32(&x16, arg1, (arg2[15]), (arg3[15]));
  uint32_t x17;
  fiat_p521_cmovznz_u32(&x17, arg1, (arg2[16]), (arg3[16]));
  uint32_t x18;
  fiat_p521_cmovznz_u32(&x18, arg1, (arg2[17]), (arg3[17]));
  uint32_t x19;
  fiat_p521_cmovznz_u32(&x19, arg1, (arg2[18]), (arg3[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/*
 * The function fiat_p521_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 */
static void fiat_p521_to_bytes(uint8_t out1[66], const uint32_t arg1[19]) {
  uint32_t x1;
  fiat_p521_uint1 x2;
  fiat_p521_subborrowx_u28(&x1, &x2, 0x0, (arg1[0]), UINT32_C(0xfffffff));
  uint32_t x3;
  fiat_p521_uint1 x4;
  fiat_p521_subborrowx_u27(&x3, &x4, x2, (arg1[1]), UINT32_C(0x7ffffff));
  uint32_t x5;
  fiat_p521_uint1 x6;
  fiat_p521_subborrowx_u28(&x5, &x6, x4, (arg1[2]), UINT32_C(0xfffffff));
  uint32_t x7;
  fiat_p521_uint1 x8;
  fiat_p521_subborrowx_u27(&x7, &x8, x6, (arg1[3]), UINT32_C(0x7ffffff));
  uint32_t x9;
  fiat_p521_uint1 x10;
  fiat_p521_subborrowx_u28(&x9, &x10, x8, (arg1[4]), UINT32_C(0xfffffff));
  uint32_t x11;
  fiat_p521_uint1 x12;
  fiat_p521_subborrowx_u27(&x11, &x12, x10, (arg1[5]), UINT32_C(0x7ffffff));
  uint32_t x13;
  fiat_p521_uint1 x14;
  fiat_p521_subborrowx_u27(&x13, &x14, x12, (arg1[6]), UINT32_C(0x7ffffff));
  uint32_t x15;
  fiat_p521_uint1 x16;
  fiat_p521_subborrowx_u28(&x15, &x16, x14, (arg1[7]), UINT32_C(0xfffffff));
  uint32_t x17;
  fiat_p521_uint1 x18;
  fiat_p521_subborrowx_u27(&x17, &x18, x16, (arg1[8]), UINT32_C(0x7ffffff));
  uint32_t x19;
  fiat_p521_uint1 x20;
  fiat_p521_subborrowx_u28(&x19, &x20, x18, (arg1[9]), UINT32_C(0xfffffff));
  uint32_t x21;
  fiat_p521_uint1 x22;
  fiat_p521_subborrowx_u27(&x21, &x22, x20, (arg1[10]), UINT32_C(0x7ffffff));
  uint32_t x23;
  fiat_p521_uint1 x24;
  fiat_p521_subborrowx_u28(&x23, &x24, x22, (arg1[11]), UINT32_C(0xfffffff));
  uint32_t x25;
  fiat_p521_uint1 x26;
  fiat_p521_subborrowx_u27(&x25, &x26, x24, (arg1[12]), UINT32_C(0x7ffffff));
  uint32_t x27;
  fiat_p521_uint1 x28;
  fiat_p521_subborrowx_u27(&x27, &x28, x26, (arg1[13]), UINT32_C(0x7ffffff));
  uint32_t x29;
  fiat_p521_uint1 x30;
  fiat_p521_subborrowx_u28(&x29, &x30, x28, (arg1[14]), UINT32_C(0xfffffff));
  uint32_t x31;
  fiat_p521_uint1 x32;
  fiat_p521_subborrowx_u27(&x31, &x32, x30, (arg1[15]), UINT32_C(0x7ffffff));
  uint32_t x33;
  fiat_p521_uint1 x34;
  fiat_p521_subborrowx_u28(&x33, &x34, x32, (arg1[16]), UINT32_C(0xfffffff));
  uint32_t x35;
  fiat_p521_uint1 x36;
  fiat_p521_subborrowx_u27(&x35, &x36, x34, (arg1[17]), UINT32_C(0x7ffffff));
  uint32_t x37;
  fiat_p521_uint1 x38;
  fiat_p521_subborrowx_u27(&x37, &x38, x36, (arg1[18]), UINT32_C(0x7ffffff));
  uint32_t x39;
  fiat_p521_cmovznz_u32(&x39, x38, 0x0, UINT32_C(0xffffffff));
  uint32_t x40;
  fiat_p521_uint1 x41;
  fiat_p521_addcarryx_u28(&x40, &x41, 0x0, x1, (x39 & UINT32_C(0xfffffff)));
  uint32_t x42;
  fiat_p521_uint1 x43;
  fiat_p521_addcarryx_u27(&x42, &x43, x41, x3, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x44;
  fiat_p521_uint1 x45;
  fiat_p521_addcarryx_u28(&x44, &x45, x43, x5, (x39 & UINT32_C(0xfffffff)));
  uint32_t x46;
  fiat_p521_uint1 x47;
  fiat_p521_addcarryx_u27(&x46, &x47, x45, x7, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x48;
  fiat_p521_uint1 x49;
  fiat_p521_addcarryx_u28(&x48, &x49, x47, x9, (x39 & UINT32_C(0xfffffff)));
  uint32_t x50;
  fiat_p521_uint1 x51;
  fiat_p521_addcarryx_u27(&x50, &x51, x49, x11, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x52;
  fiat_p521_uint1 x53;
  fiat_p521_addcarryx_u27(&x52, &x53, x51, x13, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x54;
  fiat_p521_uint1 x55;
  fiat_p521_addcarryx_u28(&x54, &x55, x53, x15, (x39 & UINT32_C(0xfffffff)));
  uint32_t x56;
  fiat_p521_uint1 x57;
  fiat_p521_addcarryx_u27(&x56, &x57, x55, x17, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x58;
  fiat_p521_uint1 x59;
  fiat_p521_addcarryx_u28(&x58, &x59, x57, x19, (x39 & UINT32_C(0xfffffff)));
  uint32_t x60;
  fiat_p521_uint1 x61;
  fiat_p521_addcarryx_u27(&x60, &x61, x59, x21, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x62;
  fiat_p521_uint1 x63;
  fiat_p521_addcarryx_u28(&x62, &x63, x61, x23, (x39 & UINT32_C(0xfffffff)));
  uint32_t x64;
  fiat_p521_uint1 x65;
  fiat_p521_addcarryx_u27(&x64, &x65, x63, x25, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x66;
  fiat_p521_uint1 x67;
  fiat_p521_addcarryx_u27(&x66, &x67, x65, x27, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x68;
  fiat_p521_uint1 x69;
  fiat_p521_addcarryx_u28(&x68, &x69, x67, x29, (x39 & UINT32_C(0xfffffff)));
  uint32_t x70;
  fiat_p521_uint1 x71;
  fiat_p521_addcarryx_u27(&x70, &x71, x69, x31, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x72;
  fiat_p521_uint1 x73;
  fiat_p521_addcarryx_u28(&x72, &x73, x71, x33, (x39 & UINT32_C(0xfffffff)));
  uint32_t x74;
  fiat_p521_uint1 x75;
  fiat_p521_addcarryx_u27(&x74, &x75, x73, x35, (x39 & UINT32_C(0x7ffffff)));
  uint32_t x76;
  fiat_p521_uint1 x77;
  fiat_p521_addcarryx_u27(&x76, &x77, x75, x37, (x39 & UINT32_C(0x7ffffff)));
  uint64_t x78 = ((uint64_t)x76 << 6);
  uint32_t x79 = (x74 << 3);
  uint64_t x80 = ((uint64_t)x72 << 7);
  uint32_t x81 = (x70 << 4);
  uint32_t x82 = (x66 << 5);
  uint32_t x83 = (x64 << 2);
  uint64_t x84 = ((uint64_t)x62 << 6);
  uint32_t x85 = (x60 << 3);
  uint64_t x86 = ((uint64_t)x58 << 7);
  uint32_t x87 = (x56 << 4);
  uint32_t x88 = (x52 << 5);
  uint32_t x89 = (x50 << 2);
  uint64_t x90 = ((uint64_t)x48 << 6);
  uint32_t x91 = (x46 << 3);
  uint64_t x92 = ((uint64_t)x44 << 7);
  uint32_t x93 = (x42 << 4);
  uint32_t x94 = (x40 >> 8);
  uint8_t x95 = (uint8_t)(x40 & UINT8_C(0xff));
  uint32_t x96 = (x94 >> 8);
  uint8_t x97 = (uint8_t)(x94 & UINT8_C(0xff));
  uint8_t x98 = (uint8_t)(x96 >> 8);
  uint8_t x99 = (uint8_t)(x96 & UINT8_C(0xff));
  uint32_t x100 = (x98 + x93);
  uint32_t x101 = (x100 >> 8);
  uint8_t x102 = (uint8_t)(x100 & UINT8_C(0xff));
  uint32_t x103 = (x101 >> 8);
  uint8_t x104 = (uint8_t)(x101 & UINT8_C(0xff));
  uint8_t x105 = (uint8_t)(x103 >> 8);
  uint8_t x106 = (uint8_t)(x103 & UINT8_C(0xff));
  uint64_t x107 = (x105 + x92);
  uint32_t x108 = (uint32_t)(x107 >> 8);
  uint8_t x109 = (uint8_t)(x107 & UINT8_C(0xff));
  uint32_t x110 = (x108 >> 8);
  uint8_t x111 = (uint8_t)(x108 & UINT8_C(0xff));
  uint32_t x112 = (x110 >> 8);
  uint8_t x113 = (uint8_t)(x110 & UINT8_C(0xff));
  uint8_t x114 = (uint8_t)(x112 >> 8);
  uint8_t x115 = (uint8_t)(x112 & UINT8_C(0xff));
  uint32_t x116 = (x114 + x91);
  uint32_t x117 = (x116 >> 8);
  uint8_t x118 = (uint8_t)(x116 & UINT8_C(0xff));
  uint32_t x119 = (x117 >> 8);
  uint8_t x120 = (uint8_t)(x117 & UINT8_C(0xff));
  uint8_t x121 = (uint8_t)(x119 >> 8);
  uint8_t x122 = (uint8_t)(x119 & UINT8_C(0xff));
  uint64_t x123 = (x121 + x90);
  uint32_t x124 = (uint32_t)(x123 >> 8);
  uint8_t x125 = (uint8_t)(x123 & UINT8_C(0xff));
  uint32_t x126 = (x124 >> 8);
  uint8_t x127 = (uint8_t)(x124 & UINT8_C(0xff));
  uint32_t x128 = (x126 >> 8);
  uint8_t x129 = (uint8_t)(x126 & UINT8_C(0xff));
  uint8_t x130 = (uint8_t)(x128 >> 8);
  uint8_t x131 = (uint8_t)(x128 & UINT8_C(0xff));
  uint32_t x132 = (x130 + x89);
  uint32_t x133 = (x132 >> 8);
  uint8_t x134 = (uint8_t)(x132 & UINT8_C(0xff));
  uint32_t x135 = (x133 >> 8);
  uint8_t x136 = (uint8_t)(x133 & UINT8_C(0xff));
  uint8_t x137 = (uint8_t)(x135 >> 8);
  uint8_t x138 = (uint8_t)(x135 & UINT8_C(0xff));
  uint32_t x139 = (x137 + x88);
  uint32_t x140 = (x139 >> 8);
  uint8_t x141 = (uint8_t)(x139 & UINT8_C(0xff));
  uint32_t x142 = (x140 >> 8);
  uint8_t x143 = (uint8_t)(x140 & UINT8_C(0xff));
  uint8_t x144 = (uint8_t)(x142 >> 8);
  uint8_t x145 = (uint8_t)(x142 & UINT8_C(0xff));
  uint8_t x146 = (uint8_t)(x144 & UINT8_C(0xff));
  uint32_t x147 = (x54 >> 8);
  uint8_t x148 = (uint8_t)(x54 & UINT8_C(0xff));
  uint32_t x149 = (x147 >> 8);
  uint8_t x150 = (uint8_t)(x147 & UINT8_C(0xff));
  uint8_t x151 = (uint8_t)(x149 >> 8);
  uint8_t x152 = (uint8_t)(x149 & UINT8_C(0xff));
  uint32_t x153 = (x151 + x87);
  uint32_t x154 = (x153 >> 8);
  uint8_t x155 = (uint8_t)(x153 & UINT8_C(0xff));
  uint32_t x156 = (x154 >> 8);
  uint8_t x157 = (uint8_t)(x154 & UINT8_C(0xff));
  uint8_t x158 = (uint8_t)(x156 >> 8);
  uint8_t x159 = (uint8_t)(x156 & UINT8_C(0xff));
  uint64_t x160 = (x158 + x86);
  uint32_t x161 = (uint32_t)(x160 >> 8);
  uint8_t x162 = (uint8_t)(x160 & UINT8_C(0xff));
  uint32_t x163 = (x161 >> 8);
  uint8_t x164 = (uint8_t)(x161 & UINT8_C(0xff));
  uint32_t x165 = (x163 >> 8);
  uint8_t x166 = (uint8_t)(x163 & UINT8_C(0xff));
  uint8_t x167 = (uint8_t)(x165 >> 8);
  uint8_t x168 = (uint8_t)(x165 & UINT8_C(0xff));
  uint32_t x169 = (x167 + x85);
  uint32_t x170 = (x169 >> 8);
  uint8_t x171 = (uint8_t)(x169 & UINT8_C(0xff));
  uint32_t x172 = (x170 >> 8);
  uint8_t x173 = (uint8_t)(x170 & UINT8_C(0xff));
  uint8_t x174 = (uint8_t)(x172 >> 8);
  uint8_t x175 = (uint8_t)(x172 & UINT8_C(0xff));
  uint64_t x176 = (x174 + x84);
  uint32_t x177 = (uint32_t)(x176 >> 8);
  uint8_t x178 = (uint8_t)(x176 & UINT8_C(0xff));
  uint32_t x179 = (x177 >> 8);
  uint8_t x180 = (uint8_t)(x177 & UINT8_C(0xff));
  uint32_t x181 = (x179 >> 8);
  uint8_t x182 = (uint8_t)(x179 & UINT8_C(0xff));
  uint8_t x183 = (uint8_t)(x181 >> 8);
  uint8_t x184 = (uint8_t)(x181 & UINT8_C(0xff));
  uint32_t x185 = (x183 + x83);
  uint32_t x186 = (x185 >> 8);
  uint8_t x187 = (uint8_t)(x185 & UINT8_C(0xff));
  uint32_t x188 = (x186 >> 8);
  uint8_t x189 = (uint8_t)(x186 & UINT8_C(0xff));
  uint8_t x190 = (uint8_t)(x188 >> 8);
  uint8_t x191 = (uint8_t)(x188 & UINT8_C(0xff));
  uint32_t x192 = (x190 + x82);
  uint32_t x193 = (x192 >> 8);
  uint8_t x194 = (uint8_t)(x192 & UINT8_C(0xff));
  uint32_t x195 = (x193 >> 8);
  uint8_t x196 = (uint8_t)(x193 & UINT8_C(0xff));
  uint8_t x197 = (uint8_t)(x195 >> 8);
  uint8_t x198 = (uint8_t)(x195 & UINT8_C(0xff));
  uint8_t x199 = (uint8_t)(x197 & UINT8_C(0xff));
  uint32_t x200 = (x68 >> 8);
  uint8_t x201 = (uint8_t)(x68 & UINT8_C(0xff));
  uint32_t x202 = (x200 >> 8);
  uint8_t x203 = (uint8_t)(x200 & UINT8_C(0xff));
  uint8_t x204 = (uint8_t)(x202 >> 8);
  uint8_t x205 = (uint8_t)(x202 & UINT8_C(0xff));
  uint32_t x206 = (x204 + x81);
  uint32_t x207 = (x206 >> 8);
  uint8_t x208 = (uint8_t)(x206 & UINT8_C(0xff));
  uint32_t x209 = (x207 >> 8);
  uint8_t x210 = (uint8_t)(x207 & UINT8_C(0xff));
  uint8_t x211 = (uint8_t)(x209 >> 8);
  uint8_t x212 = (uint8_t)(x209 & UINT8_C(0xff));
  uint64_t x213 = (x211 + x80);
  uint32_t x214 = (uint32_t)(x213 >> 8);
  uint8_t x215 = (uint8_t)(x213 & UINT8_C(0xff));
  uint32_t x216 = (x214 >> 8);
  uint8_t x217 = (uint8_t)(x214 & UINT8_C(0xff));
  uint32_t x218 = (x216 >> 8);
  uint8_t x219 = (uint8_t)(x216 & UINT8_C(0xff));
  uint8_t x220 = (uint8_t)(x218 >> 8);
  uint8_t x221 = (uint8_t)(x218 & UINT8_C(0xff));
  uint32_t x222 = (x220 + x79);
  uint32_t x223 = (x222 >> 8);
  uint8_t x224 = (uint8_t)(x222 & UINT8_C(0xff));
  uint32_t x225 = (x223 >> 8);
  uint8_t x226 = (uint8_t)(x223 & UINT8_C(0xff));
  uint8_t x227 = (uint8_t)(x225 >> 8);
  uint8_t x228 = (uint8_t)(x225 & UINT8_C(0xff));
  uint64_t x229 = (x227 + x78);
  uint32_t x230 = (uint32_t)(x229 >> 8);
  uint8_t x231 = (uint8_t)(x229 & UINT8_C(0xff));
  uint32_t x232 = (x230 >> 8);
  uint8_t x233 = (uint8_t)(x230 & UINT8_C(0xff));
  uint32_t x234 = (x232 >> 8);
  uint8_t x235 = (uint8_t)(x232 & UINT8_C(0xff));
  fiat_p521_uint1 x236 = (fiat_p521_uint1)(x234 >> 8);
  uint8_t x237 = (uint8_t)(x234 & UINT8_C(0xff));
  out1[0] = x95;
  out1[1] = x97;
  out1[2] = x99;
  out1[3] = x102;
  out1[4] = x104;
  out1[5] = x106;
  out1[6] = x109;
  out1[7] = x111;
  out1[8] = x113;
  out1[9] = x115;
  out1[10] = x118;
  out1[11] = x120;
  out1[12] = x122;
  out1[13] = x125;
  out1[14] = x127;
  out1[15] = x129;
  out1[16] = x131;
  out1[17] = x134;
  out1[18] = x136;
  out1[19] = x138;
  out1[20] = x141;
  out1[21] = x143;
  out1[22] = x145;
  out1[23] = x146;
  out1[24] = x148;
  out1[25] = x150;
  out1[26] = x152;
  out1[27] = x155;
  out1[28] = x157;
  out1[29] = x159;
  out1[30] = x162;
  out1[31] = x164;
  out1[32] = x166;
  out1[33] = x168;
  out1[34] = x171;
  out1[35] = x173;
  out1[36] = x175;
  out1[37] = x178;
  out1[38] = x180;
  out1[39] = x182;
  out1[40] = x184;
  out1[41] = x187;
  out1[42] = x189;
  out1[43] = x191;
  out1[44] = x194;
  out1[45] = x196;
  out1[46] = x198;
  out1[47] = x199;
  out1[48] = x201;
  out1[49] = x203;
  out1[50] = x205;
  out1[51] = x208;
  out1[52] = x210;
  out1[53] = x212;
  out1[54] = x215;
  out1[55] = x217;
  out1[56] = x219;
  out1[57] = x221;
  out1[58] = x224;
  out1[59] = x226;
  out1[60] = x228;
  out1[61] = x231;
  out1[62] = x233;
  out1[63] = x235;
  out1[64] = x237;
  out1[65] = x236;
}

/*
 * The function fiat_p521_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x11999999], [0x0 ~> 0x8cccccc], [0x0 ~> 0x8cccccc]]
 */
static void fiat_p521_from_bytes(uint32_t out1[19], const uint8_t arg1[66]) {
  uint32_t x1 = ((uint32_t)(fiat_p521_uint1)(arg1[65]) << 26);
  uint32_t x2 = ((uint32_t)(arg1[64]) << 18);
  uint32_t x3 = ((uint32_t)(arg1[63]) << 10);
  uint32_t x4 = ((uint32_t)(arg1[62]) << 2);
  uint32_t x5 = ((uint32_t)(arg1[61]) << 21);
  uint32_t x6 = ((uint32_t)(arg1[60]) << 13);
  uint32_t x7 = ((uint32_t)(arg1[59]) << 5);
  uint64_t x8 = ((uint64_t)(arg1[58]) << 25);
  uint32_t x9 = ((uint32_t)(arg1[57]) << 17);
  uint32_t x10 = ((uint32_t)(arg1[56]) << 9);
  uint32_t x11 = ((uint32_t)(arg1[55]) * 0x2);
  uint32_t x12 = ((uint32_t)(arg1[54]) << 20);
  uint32_t x13 = ((uint32_t)(arg1[53]) << 12);
  uint32_t x14 = ((uint32_t)(arg1[52]) << 4);
  uint32_t x15 = ((uint32_t)(arg1[51]) << 24);
  uint32_t x16 = ((uint32_t)(arg1[50]) << 16);
  uint32_t x17 = ((uint32_t)(arg1[49]) << 8);
  uint8_t x18 = (arg1[48]);
  uint32_t x19 = ((uint32_t)(arg1[47]) << 19);
  uint32_t x20 = ((uint32_t)(arg1[46]) << 11);
  uint32_t x21 = ((uint32_t)(arg1[45]) << 3);
  uint32_t x22 = ((uint32_t)(arg1[44]) << 22);
  uint32_t x23 = ((uint32_t)(arg1[43]) << 14);
  uint32_t x24 = ((uint32_t)(arg1[42]) << 6);
  uint64_t x25 = ((uint64_t)(arg1[41]) << 26);
  uint32_t x26 = ((uint32_t)(arg1[40]) << 18);
  uint32_t x27 = ((uint32_t)(arg1[39]) << 10);
  uint32_t x28 = ((uint32_t)(arg1[38]) << 2);
  uint32_t x29 = ((uint32_t)(arg1[37]) << 21);
  uint32_t x30 = ((uint32_t)(arg1[36]) << 13);
  uint32_t x31 = ((uint32_t)(arg1[35]) << 5);
  uint64_t x32 = ((uint64_t)(arg1[34]) << 25);
  uint32_t x33 = ((uint32_t)(arg1[33]) << 17);
  uint32_t x34 = ((uint32_t)(arg1[32]) << 9);
  uint32_t x35 = ((uint32_t)(arg1[31]) * 0x2);
  uint32_t x36 = ((uint32_t)(arg1[30]) << 20);
  uint32_t x37 = ((uint32_t)(arg1[29]) << 12);
  uint32_t x38 = ((uint32_t)(arg1[28]) << 4);
  uint32_t x39 = ((uint32_t)(arg1[27]) << 24);
  uint32_t x40 = ((uint32_t)(arg1[26]) << 16);
  uint32_t x41 = ((uint32_t)(arg1[25]) << 8);
  uint8_t x42 = (arg1[24]);
  uint32_t x43 = ((uint32_t)(arg1[23]) << 19);
  uint32_t x44 = ((uint32_t)(arg1[22]) << 11);
  uint32_t x45 = ((uint32_t)(arg1[21]) << 3);
  uint32_t x46 = ((uint32_t)(arg1[20]) << 22);
  uint32_t x47 = ((uint32_t)(arg1[19]) << 14);
  uint32_t x48 = ((uint32_t)(arg1[18]) << 6);
  uint64_t x49 = ((uint64_t)(arg1[17]) << 26);
  uint32_t x50 = ((uint32_t)(arg1[16]) << 18);
  uint32_t x51 = ((uint32_t)(arg1[15]) << 10);
  uint32_t x52 = ((uint32_t)(arg1[14]) << 2);
  uint32_t x53 = ((uint32_t)(arg1[13]) << 21);
  uint32_t x54 = ((uint32_t)(arg1[12]) << 13);
  uint32_t x55 = ((uint32_t)(arg1[11]) << 5);
  uint64_t x56 = ((uint64_t)(arg1[10]) << 25);
  uint32_t x57 = ((uint32_t)(arg1[9]) << 17);
  uint32_t x58 = ((uint32_t)(arg1[8]) << 9);
  uint32_t x59 = ((uint32_t)(arg1[7]) * 0x2);
  uint32_t x60 = ((uint32_t)(arg1[6]) << 20);
  uint32_t x61 = ((uint32_t)(arg1[5]) << 12);
  uint32_t x62 = ((uint32_t)(arg1[4]) << 4);
  uint32_t x63 = ((uint32_t)(arg1[3]) << 24);
  uint32_t x64 = ((uint32_t)(arg1[2]) << 16);
  uint32_t x65 = ((uint32_t)(arg1[1]) << 8);
  uint8_t x66 = (arg1[0]);
  uint32_t x67 = (x66 + (x65 + (x64 + x63)));
  uint8_t x68 = (uint8_t)(x67 >> 28);
  uint32_t x69 = (x67 & UINT32_C(0xfffffff));
  uint32_t x70 = (x4 + (x3 + (x2 + x1)));
  uint32_t x71 = (x7 + (x6 + x5));
  uint64_t x72 = (x11 + (x10 + (x9 + x8)));
  uint32_t x73 = (x14 + (x13 + x12));
  uint32_t x74 = (x18 + (x17 + (x16 + x15)));
  uint32_t x75 = (x21 + (x20 + x19));
  uint32_t x76 = (x24 + (x23 + x22));
  uint64_t x77 = (x28 + (x27 + (x26 + x25)));
  uint32_t x78 = (x31 + (x30 + x29));
  uint64_t x79 = (x35 + (x34 + (x33 + x32)));
  uint32_t x80 = (x38 + (x37 + x36));
  uint32_t x81 = (x42 + (x41 + (x40 + x39)));
  uint32_t x82 = (x45 + (x44 + x43));
  uint32_t x83 = (x48 + (x47 + x46));
  uint64_t x84 = (x52 + (x51 + (x50 + x49)));
  uint32_t x85 = (x55 + (x54 + x53));
  uint64_t x86 = (x59 + (x58 + (x57 + x56)));
  uint32_t x87 = (x62 + (x61 + x60));
  uint32_t x88 = (x68 + x87);
  fiat_p521_uint1 x89 = (fiat_p521_uint1)(x88 >> 27);
  uint32_t x90 = (x88 & UINT32_C(0x7ffffff));
  uint64_t x91 = (x89 + x86);
  uint8_t x92 = (uint8_t)(x91 >> 28);
  uint32_t x93 = (uint32_t)(x91 & UINT32_C(0xfffffff));
  uint32_t x94 = (x92 + x85);
  uint8_t x95 = (uint8_t)(x94 >> 27);
  uint32_t x96 = (x94 & UINT32_C(0x7ffffff));
  uint64_t x97 = (x95 + x84);
  uint8_t x98 = (uint8_t)(x97 >> 28);
  uint32_t x99 = (uint32_t)(x97 & UINT32_C(0xfffffff));
  uint32_t x100 = (x98 + x83);
  uint8_t x101 = (uint8_t)(x100 >> 27);
  uint32_t x102 = (x100 & UINT32_C(0x7ffffff));
  uint32_t x103 = (x101 + x82);
  uint32_t x104 = (x103 & UINT32_C(0x7ffffff));
  uint8_t x105 = (uint8_t)(x81 >> 28);
  uint32_t x106 = (x81 & UINT32_C(0xfffffff));
  uint32_t x107 = (x105 + x80);
  fiat_p521_uint1 x108 = (fiat_p521_uint1)(x107 >> 27);
  uint32_t x109 = (x107 & UINT32_C(0x7ffffff));
  uint64_t x110 = (x108 + x79);
  uint8_t x111 = (uint8_t)(x110 >> 28);
  uint32_t x112 = (uint32_t)(x110 & UINT32_C(0xfffffff));
  uint32_t x113 = (x111 + x78);
  uint8_t x114 = (uint8_t)(x113 >> 27);
  uint32_t x115 = (x113 & UINT32_C(0x7ffffff));
  uint64_t x116 = (x114 + x77);
  uint8_t x117 = (uint8_t)(x116 >> 28);
  uint32_t x118 = (uint32_t)(x116 & UINT32_C(0xfffffff));
  uint32_t x119 = (x117 + x76);
  uint8_t x120 = (uint8_t)(x119 >> 27);
  uint32_t x121 = (x119 & UINT32_C(0x7ffffff));
  uint32_t x122 = (x120 + x75);
  uint32_t x123 = (x122 & UINT32_C(0x7ffffff));
  uint8_t x124 = (uint8_t)(x74 >> 28);
  uint32_t x125 = (x74 & UINT32_C(0xfffffff));
  uint32_t x126 = (x124 + x73);
  fiat_p521_uint1 x127 = (fiat_p521_uint1)(x126 >> 27);
  uint32_t x128 = (x126 & UINT32_C(0x7ffffff));
  uint64_t x129 = (x127 + x72);
  uint8_t x130 = (uint8_t)(x129 >> 28);
  uint32_t x131 = (uint32_t)(x129 & UINT32_C(0xfffffff));
  uint32_t x132 = (x130 + x71);
  uint8_t x133 = (uint8_t)(x132 >> 27);
  uint32_t x134 = (x132 & UINT32_C(0x7ffffff));
  uint32_t x135 = (x133 + x70);
  out1[0] = x69;
  out1[1] = x90;
  out1[2] = x93;
  out1[3] = x96;
  out1[4] = x99;
  out1[5] = x102;
  out1[6] = x104;
  out1[7] = x106;
  out1[8] = x109;
  out1[9] = x112;
  out1[10] = x115;
  out1[11] = x118;
  out1[12] = x121;
  out1[13] = x123;
  out1[14] = x125;
  out1[15] = x128;
  out1[16] = x131;
  out1[17] = x134;
  out1[18] = x135;
}
