/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/unsaturated_solinas --static p448 8 '2^448 - 2^224 - 1' 64 */
/* curve description: p448 */
/* requested operations: (all) */
/* n = 8 (from "8") */
/* s-c = 2^448 - [(2^224, 1), (1, 1)] (from "2^448 - 2^224 - 1") */
/* machine_wordsize = 64 (from "64") */

/* Computed values: */
/* carry_chain = [3, 7, 4, 0, 5, 1, 6, 2, 7, 3, 4, 0] */

#include <stdint.h>
typedef unsigned char fiat_p448_uint1;
typedef signed char fiat_p448_int1;
FIAT_EXTENSION typedef signed __int128 fiat_p448_int128;
FIAT_EXTENSION typedef unsigned __int128 fiat_p448_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p448_addcarryx_u56 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^56
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^56⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p448_addcarryx_u56(uint64_t* out1, fiat_p448_uint1* out2, fiat_p448_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1 = ((arg1 + arg2) + arg3);
  uint64_t x2 = (x1 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint1 x3 = (fiat_p448_uint1)(x1 >> 56);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p448_subborrowx_u56 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^56
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^56⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p448_subborrowx_u56(uint64_t* out1, fiat_p448_uint1* out2, fiat_p448_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
  fiat_p448_int1 x2 = (fiat_p448_int1)(x1 >> 56);
  uint64_t x3 = (x1 & UINT64_C(0xffffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p448_uint1)(0x0 - x2);
}

/*
 * The function fiat_p448_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p448_cmovznz_u64(uint64_t* out1, fiat_p448_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p448_uint1 x1 = (!(!arg1));
  uint64_t x2 = ((fiat_p448_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  uint64_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p448_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 *   arg2: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 */
static void fiat_p448_carry_mul(uint64_t out1[8], const uint64_t arg1[8], const uint64_t arg2[8]) {
  fiat_p448_uint128 x1 = ((fiat_p448_uint128)(arg1[7]) * (arg2[7]));
  fiat_p448_uint128 x2 = ((fiat_p448_uint128)(arg1[7]) * (arg2[6]));
  fiat_p448_uint128 x3 = ((fiat_p448_uint128)(arg1[7]) * (arg2[5]));
  fiat_p448_uint128 x4 = ((fiat_p448_uint128)(arg1[6]) * (arg2[7]));
  fiat_p448_uint128 x5 = ((fiat_p448_uint128)(arg1[6]) * (arg2[6]));
  fiat_p448_uint128 x6 = ((fiat_p448_uint128)(arg1[5]) * (arg2[7]));
  fiat_p448_uint128 x7 = ((fiat_p448_uint128)(arg1[7]) * (arg2[7]));
  fiat_p448_uint128 x8 = ((fiat_p448_uint128)(arg1[7]) * (arg2[6]));
  fiat_p448_uint128 x9 = ((fiat_p448_uint128)(arg1[7]) * (arg2[5]));
  fiat_p448_uint128 x10 = ((fiat_p448_uint128)(arg1[6]) * (arg2[7]));
  fiat_p448_uint128 x11 = ((fiat_p448_uint128)(arg1[6]) * (arg2[6]));
  fiat_p448_uint128 x12 = ((fiat_p448_uint128)(arg1[5]) * (arg2[7]));
  fiat_p448_uint128 x13 = ((fiat_p448_uint128)(arg1[7]) * (arg2[7]));
  fiat_p448_uint128 x14 = ((fiat_p448_uint128)(arg1[7]) * (arg2[6]));
  fiat_p448_uint128 x15 = ((fiat_p448_uint128)(arg1[7]) * (arg2[5]));
  fiat_p448_uint128 x16 = ((fiat_p448_uint128)(arg1[7]) * (arg2[4]));
  fiat_p448_uint128 x17 = ((fiat_p448_uint128)(arg1[7]) * (arg2[3]));
  fiat_p448_uint128 x18 = ((fiat_p448_uint128)(arg1[7]) * (arg2[2]));
  fiat_p448_uint128 x19 = ((fiat_p448_uint128)(arg1[7]) * (arg2[1]));
  fiat_p448_uint128 x20 = ((fiat_p448_uint128)(arg1[6]) * (arg2[7]));
  fiat_p448_uint128 x21 = ((fiat_p448_uint128)(arg1[6]) * (arg2[6]));
  fiat_p448_uint128 x22 = ((fiat_p448_uint128)(arg1[6]) * (arg2[5]));
  fiat_p448_uint128 x23 = ((fiat_p448_uint128)(arg1[6]) * (arg2[4]));
  fiat_p448_uint128 x24 = ((fiat_p448_uint128)(arg1[6]) * (arg2[3]));
  fiat_p448_uint128 x25 = ((fiat_p448_uint128)(arg1[6]) * (arg2[2]));
  fiat_p448_uint128 x26 = ((fiat_p448_uint128)(arg1[5]) * (arg2[7]));
  fiat_p448_uint128 x27 = ((fiat_p448_uint128)(arg1[5]) * (arg2[6]));
  fiat_p448_uint128 x28 = ((fiat_p448_uint128)(arg1[5]) * (arg2[5]));
  fiat_p448_uint128 x29 = ((fiat_p448_uint128)(arg1[5]) * (arg2[4]));
  fiat_p448_uint128 x30 = ((fiat_p448_uint128)(arg1[5]) * (arg2[3]));
  fiat_p448_uint128 x31 = ((fiat_p448_uint128)(arg1[4]) * (arg2[7]));
  fiat_p448_uint128 x32 = ((fiat_p448_uint128)(arg1[4]) * (arg2[6]));
  fiat_p448_uint128 x33 = ((fiat_p448_uint128)(arg1[4]) * (arg2[5]));
  fiat_p448_uint128 x34 = ((fiat_p448_uint128)(arg1[4]) * (arg2[4]));
  fiat_p448_uint128 x35 = ((fiat_p448_uint128)(arg1[3]) * (arg2[7]));
  fiat_p448_uint128 x36 = ((fiat_p448_uint128)(arg1[3]) * (arg2[6]));
  fiat_p448_uint128 x37 = ((fiat_p448_uint128)(arg1[3]) * (arg2[5]));
  fiat_p448_uint128 x38 = ((fiat_p448_uint128)(arg1[2]) * (arg2[7]));
  fiat_p448_uint128 x39 = ((fiat_p448_uint128)(arg1[2]) * (arg2[6]));
  fiat_p448_uint128 x40 = ((fiat_p448_uint128)(arg1[1]) * (arg2[7]));
  fiat_p448_uint128 x41 = ((fiat_p448_uint128)(arg1[7]) * (arg2[4]));
  fiat_p448_uint128 x42 = ((fiat_p448_uint128)(arg1[7]) * (arg2[3]));
  fiat_p448_uint128 x43 = ((fiat_p448_uint128)(arg1[7]) * (arg2[2]));
  fiat_p448_uint128 x44 = ((fiat_p448_uint128)(arg1[7]) * (arg2[1]));
  fiat_p448_uint128 x45 = ((fiat_p448_uint128)(arg1[6]) * (arg2[5]));
  fiat_p448_uint128 x46 = ((fiat_p448_uint128)(arg1[6]) * (arg2[4]));
  fiat_p448_uint128 x47 = ((fiat_p448_uint128)(arg1[6]) * (arg2[3]));
  fiat_p448_uint128 x48 = ((fiat_p448_uint128)(arg1[6]) * (arg2[2]));
  fiat_p448_uint128 x49 = ((fiat_p448_uint128)(arg1[5]) * (arg2[6]));
  fiat_p448_uint128 x50 = ((fiat_p448_uint128)(arg1[5]) * (arg2[5]));
  fiat_p448_uint128 x51 = ((fiat_p448_uint128)(arg1[5]) * (arg2[4]));
  fiat_p448_uint128 x52 = ((fiat_p448_uint128)(arg1[5]) * (arg2[3]));
  fiat_p448_uint128 x53 = ((fiat_p448_uint128)(arg1[4]) * (arg2[7]));
  fiat_p448_uint128 x54 = ((fiat_p448_uint128)(arg1[4]) * (arg2[6]));
  fiat_p448_uint128 x55 = ((fiat_p448_uint128)(arg1[4]) * (arg2[5]));
  fiat_p448_uint128 x56 = ((fiat_p448_uint128)(arg1[4]) * (arg2[4]));
  fiat_p448_uint128 x57 = ((fiat_p448_uint128)(arg1[3]) * (arg2[7]));
  fiat_p448_uint128 x58 = ((fiat_p448_uint128)(arg1[3]) * (arg2[6]));
  fiat_p448_uint128 x59 = ((fiat_p448_uint128)(arg1[3]) * (arg2[5]));
  fiat_p448_uint128 x60 = ((fiat_p448_uint128)(arg1[2]) * (arg2[7]));
  fiat_p448_uint128 x61 = ((fiat_p448_uint128)(arg1[2]) * (arg2[6]));
  fiat_p448_uint128 x62 = ((fiat_p448_uint128)(arg1[1]) * (arg2[7]));
  fiat_p448_uint128 x63 = ((fiat_p448_uint128)(arg1[7]) * (arg2[0]));
  fiat_p448_uint128 x64 = ((fiat_p448_uint128)(arg1[6]) * (arg2[1]));
  fiat_p448_uint128 x65 = ((fiat_p448_uint128)(arg1[6]) * (arg2[0]));
  fiat_p448_uint128 x66 = ((fiat_p448_uint128)(arg1[5]) * (arg2[2]));
  fiat_p448_uint128 x67 = ((fiat_p448_uint128)(arg1[5]) * (arg2[1]));
  fiat_p448_uint128 x68 = ((fiat_p448_uint128)(arg1[5]) * (arg2[0]));
  fiat_p448_uint128 x69 = ((fiat_p448_uint128)(arg1[4]) * (arg2[3]));
  fiat_p448_uint128 x70 = ((fiat_p448_uint128)(arg1[4]) * (arg2[2]));
  fiat_p448_uint128 x71 = ((fiat_p448_uint128)(arg1[4]) * (arg2[1]));
  fiat_p448_uint128 x72 = ((fiat_p448_uint128)(arg1[4]) * (arg2[0]));
  fiat_p448_uint128 x73 = ((fiat_p448_uint128)(arg1[3]) * (arg2[4]));
  fiat_p448_uint128 x74 = ((fiat_p448_uint128)(arg1[3]) * (arg2[3]));
  fiat_p448_uint128 x75 = ((fiat_p448_uint128)(arg1[3]) * (arg2[2]));
  fiat_p448_uint128 x76 = ((fiat_p448_uint128)(arg1[3]) * (arg2[1]));
  fiat_p448_uint128 x77 = ((fiat_p448_uint128)(arg1[3]) * (arg2[0]));
  fiat_p448_uint128 x78 = ((fiat_p448_uint128)(arg1[2]) * (arg2[5]));
  fiat_p448_uint128 x79 = ((fiat_p448_uint128)(arg1[2]) * (arg2[4]));
  fiat_p448_uint128 x80 = ((fiat_p448_uint128)(arg1[2]) * (arg2[3]));
  fiat_p448_uint128 x81 = ((fiat_p448_uint128)(arg1[2]) * (arg2[2]));
  fiat_p448_uint128 x82 = ((fiat_p448_uint128)(arg1[2]) * (arg2[1]));
  fiat_p448_uint128 x83 = ((fiat_p448_uint128)(arg1[2]) * (arg2[0]));
  fiat_p448_uint128 x84 = ((fiat_p448_uint128)(arg1[1]) * (arg2[6]));
  fiat_p448_uint128 x85 = ((fiat_p448_uint128)(arg1[1]) * (arg2[5]));
  fiat_p448_uint128 x86 = ((fiat_p448_uint128)(arg1[1]) * (arg2[4]));
  fiat_p448_uint128 x87 = ((fiat_p448_uint128)(arg1[1]) * (arg2[3]));
  fiat_p448_uint128 x88 = ((fiat_p448_uint128)(arg1[1]) * (arg2[2]));
  fiat_p448_uint128 x89 = ((fiat_p448_uint128)(arg1[1]) * (arg2[1]));
  fiat_p448_uint128 x90 = ((fiat_p448_uint128)(arg1[1]) * (arg2[0]));
  fiat_p448_uint128 x91 = ((fiat_p448_uint128)(arg1[0]) * (arg2[7]));
  fiat_p448_uint128 x92 = ((fiat_p448_uint128)(arg1[0]) * (arg2[6]));
  fiat_p448_uint128 x93 = ((fiat_p448_uint128)(arg1[0]) * (arg2[5]));
  fiat_p448_uint128 x94 = ((fiat_p448_uint128)(arg1[0]) * (arg2[4]));
  fiat_p448_uint128 x95 = ((fiat_p448_uint128)(arg1[0]) * (arg2[3]));
  fiat_p448_uint128 x96 = ((fiat_p448_uint128)(arg1[0]) * (arg2[2]));
  fiat_p448_uint128 x97 = ((fiat_p448_uint128)(arg1[0]) * (arg2[1]));
  fiat_p448_uint128 x98 = ((fiat_p448_uint128)(arg1[0]) * (arg2[0]));
  fiat_p448_uint128 x99 = (x95 + (x88 + (x82 + (x77 + (x31 + (x27 + (x22 + x16)))))));
  uint64_t x100 = (uint64_t)(x99 >> 56);
  uint64_t x101 = (uint64_t)(x99 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x102 = (x91 + (x84 + (x78 + (x73 + (x69 + (x66 + (x64 + (x63 + (x53 + (x49 + (x45 + x41)))))))))));
  fiat_p448_uint128 x103 = (x92 + (x85 + (x79 + (x74 + (x70 + (x67 + (x65 + (x57 + (x54 + (x50 + (x46 + (x42 + (x13 + x7)))))))))))));
  fiat_p448_uint128 x104 = (x93 + (x86 + (x80 + (x75 + (x71 + (x68 + (x60 + (x58 + (x55 + (x51 + (x47 + (x43 + (x20 + (x14 + (x10 + x8)))))))))))))));
  fiat_p448_uint128 x105 = (x94 + (x87 + (x81 + (x76 + (x72 + (x62 + (x61 + (x59 + (x56 + (x52 + (x48 + (x44 + (x26 + (x21 + (x15 + (x12 + (x11 + x9)))))))))))))))));
  fiat_p448_uint128 x106 = (x96 + (x89 + (x83 + (x35 + (x32 + (x28 + (x23 + (x17 + x1))))))));
  fiat_p448_uint128 x107 = (x97 + (x90 + (x38 + (x36 + (x33 + (x29 + (x24 + (x18 + (x4 + x2)))))))));
  fiat_p448_uint128 x108 = (x98 + (x40 + (x39 + (x37 + (x34 + (x30 + (x25 + (x19 + (x6 + (x5 + x3))))))))));
  fiat_p448_uint128 x109 = (x100 + x105);
  uint64_t x110 = (uint64_t)(x102 >> 56);
  uint64_t x111 = (uint64_t)(x102 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x112 = (x109 + x110);
  uint64_t x113 = (uint64_t)(x112 >> 56);
  uint64_t x114 = (uint64_t)(x112 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x115 = (x108 + x110);
  fiat_p448_uint128 x116 = (x113 + x104);
  uint64_t x117 = (uint64_t)(x115 >> 56);
  uint64_t x118 = (uint64_t)(x115 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x119 = (x117 + x107);
  uint64_t x120 = (uint64_t)(x116 >> 56);
  uint64_t x121 = (uint64_t)(x116 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x122 = (x120 + x103);
  uint64_t x123 = (uint64_t)(x119 >> 56);
  uint64_t x124 = (uint64_t)(x119 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x125 = (x123 + x106);
  uint64_t x126 = (uint64_t)(x122 >> 56);
  uint64_t x127 = (uint64_t)(x122 & UINT64_C(0xffffffffffffff));
  uint64_t x128 = (x126 + x111);
  uint64_t x129 = (uint64_t)(x125 >> 56);
  uint64_t x130 = (uint64_t)(x125 & UINT64_C(0xffffffffffffff));
  uint64_t x131 = (x129 + x101);
  uint64_t x132 = (x128 >> 56);
  uint64_t x133 = (x128 & UINT64_C(0xffffffffffffff));
  uint64_t x134 = (x131 >> 56);
  uint64_t x135 = (x131 & UINT64_C(0xffffffffffffff));
  uint64_t x136 = (x114 + x132);
  uint64_t x137 = (x118 + x132);
  uint64_t x138 = (x134 + x136);
  fiat_p448_uint1 x139 = (fiat_p448_uint1)(x138 >> 56);
  uint64_t x140 = (x138 & UINT64_C(0xffffffffffffff));
  uint64_t x141 = (x139 + x121);
  fiat_p448_uint1 x142 = (fiat_p448_uint1)(x137 >> 56);
  uint64_t x143 = (x137 & UINT64_C(0xffffffffffffff));
  uint64_t x144 = (x142 + x124);
  out1[0] = x143;
  out1[1] = x144;
  out1[2] = x130;
  out1[3] = x135;
  out1[4] = x140;
  out1[5] = x141;
  out1[6] = x127;
  out1[7] = x133;
}

/*
 * The function fiat_p448_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 */
static void fiat_p448_carry_square(uint64_t out1[8], const uint64_t arg1[8]) {
  uint64_t x1 = (arg1[7]);
  uint64_t x2 = (arg1[7]);
  uint64_t x3 = (x1 * (uint64_t)0x2);
  uint64_t x4 = (x2 * (uint64_t)0x2);
  uint64_t x5 = ((arg1[7]) * (uint64_t)0x2);
  uint64_t x6 = (arg1[6]);
  uint64_t x7 = (arg1[6]);
  uint64_t x8 = (x6 * (uint64_t)0x2);
  uint64_t x9 = (x7 * (uint64_t)0x2);
  uint64_t x10 = ((arg1[6]) * (uint64_t)0x2);
  uint64_t x11 = (arg1[5]);
  uint64_t x12 = (arg1[5]);
  uint64_t x13 = (x11 * (uint64_t)0x2);
  uint64_t x14 = (x12 * (uint64_t)0x2);
  uint64_t x15 = ((arg1[5]) * (uint64_t)0x2);
  uint64_t x16 = (arg1[4]);
  uint64_t x17 = (arg1[4]);
  uint64_t x18 = ((arg1[4]) * (uint64_t)0x2);
  uint64_t x19 = ((arg1[3]) * (uint64_t)0x2);
  uint64_t x20 = ((arg1[2]) * (uint64_t)0x2);
  uint64_t x21 = ((arg1[1]) * (uint64_t)0x2);
  fiat_p448_uint128 x22 = ((fiat_p448_uint128)(arg1[7]) * x1);
  fiat_p448_uint128 x23 = ((fiat_p448_uint128)(arg1[6]) * x3);
  fiat_p448_uint128 x24 = ((fiat_p448_uint128)(arg1[6]) * x6);
  fiat_p448_uint128 x25 = ((fiat_p448_uint128)(arg1[5]) * x3);
  fiat_p448_uint128 x26 = ((fiat_p448_uint128)(arg1[7]) * x1);
  fiat_p448_uint128 x27 = ((fiat_p448_uint128)(arg1[6]) * x3);
  fiat_p448_uint128 x28 = ((fiat_p448_uint128)(arg1[6]) * x6);
  fiat_p448_uint128 x29 = ((fiat_p448_uint128)(arg1[5]) * x3);
  fiat_p448_uint128 x30 = ((fiat_p448_uint128)(arg1[7]) * x2);
  fiat_p448_uint128 x31 = ((fiat_p448_uint128)(arg1[6]) * x4);
  fiat_p448_uint128 x32 = ((fiat_p448_uint128)(arg1[6]) * x7);
  fiat_p448_uint128 x33 = ((fiat_p448_uint128)(arg1[5]) * x4);
  fiat_p448_uint128 x34 = ((fiat_p448_uint128)(arg1[5]) * x9);
  fiat_p448_uint128 x35 = ((fiat_p448_uint128)(arg1[5]) * x8);
  fiat_p448_uint128 x36 = ((fiat_p448_uint128)(arg1[5]) * x12);
  fiat_p448_uint128 x37 = ((fiat_p448_uint128)(arg1[5]) * x11);
  fiat_p448_uint128 x38 = ((fiat_p448_uint128)(arg1[4]) * x4);
  fiat_p448_uint128 x39 = ((fiat_p448_uint128)(arg1[4]) * x3);
  fiat_p448_uint128 x40 = ((fiat_p448_uint128)(arg1[4]) * x9);
  fiat_p448_uint128 x41 = ((fiat_p448_uint128)(arg1[4]) * x8);
  fiat_p448_uint128 x42 = ((fiat_p448_uint128)(arg1[4]) * x14);
  fiat_p448_uint128 x43 = ((fiat_p448_uint128)(arg1[4]) * x13);
  fiat_p448_uint128 x44 = ((fiat_p448_uint128)(arg1[4]) * x17);
  fiat_p448_uint128 x45 = ((fiat_p448_uint128)(arg1[4]) * x16);
  fiat_p448_uint128 x46 = ((fiat_p448_uint128)(arg1[3]) * x4);
  fiat_p448_uint128 x47 = ((fiat_p448_uint128)(arg1[3]) * x3);
  fiat_p448_uint128 x48 = ((fiat_p448_uint128)(arg1[3]) * x9);
  fiat_p448_uint128 x49 = ((fiat_p448_uint128)(arg1[3]) * x8);
  fiat_p448_uint128 x50 = ((fiat_p448_uint128)(arg1[3]) * x14);
  fiat_p448_uint128 x51 = ((fiat_p448_uint128)(arg1[3]) * x13);
  fiat_p448_uint128 x52 = ((fiat_p448_uint128)(arg1[3]) * x18);
  fiat_p448_uint128 x53 = ((fiat_p448_uint128)(arg1[3]) * (arg1[3]));
  fiat_p448_uint128 x54 = ((fiat_p448_uint128)(arg1[2]) * x4);
  fiat_p448_uint128 x55 = ((fiat_p448_uint128)(arg1[2]) * x3);
  fiat_p448_uint128 x56 = ((fiat_p448_uint128)(arg1[2]) * x9);
  fiat_p448_uint128 x57 = ((fiat_p448_uint128)(arg1[2]) * x8);
  fiat_p448_uint128 x58 = ((fiat_p448_uint128)(arg1[2]) * x15);
  fiat_p448_uint128 x59 = ((fiat_p448_uint128)(arg1[2]) * x18);
  fiat_p448_uint128 x60 = ((fiat_p448_uint128)(arg1[2]) * x19);
  fiat_p448_uint128 x61 = ((fiat_p448_uint128)(arg1[2]) * (arg1[2]));
  fiat_p448_uint128 x62 = ((fiat_p448_uint128)(arg1[1]) * x4);
  fiat_p448_uint128 x63 = ((fiat_p448_uint128)(arg1[1]) * x3);
  fiat_p448_uint128 x64 = ((fiat_p448_uint128)(arg1[1]) * x10);
  fiat_p448_uint128 x65 = ((fiat_p448_uint128)(arg1[1]) * x15);
  fiat_p448_uint128 x66 = ((fiat_p448_uint128)(arg1[1]) * x18);
  fiat_p448_uint128 x67 = ((fiat_p448_uint128)(arg1[1]) * x19);
  fiat_p448_uint128 x68 = ((fiat_p448_uint128)(arg1[1]) * x20);
  fiat_p448_uint128 x69 = ((fiat_p448_uint128)(arg1[1]) * (arg1[1]));
  fiat_p448_uint128 x70 = ((fiat_p448_uint128)(arg1[0]) * x5);
  fiat_p448_uint128 x71 = ((fiat_p448_uint128)(arg1[0]) * x10);
  fiat_p448_uint128 x72 = ((fiat_p448_uint128)(arg1[0]) * x15);
  fiat_p448_uint128 x73 = ((fiat_p448_uint128)(arg1[0]) * x18);
  fiat_p448_uint128 x74 = ((fiat_p448_uint128)(arg1[0]) * x19);
  fiat_p448_uint128 x75 = ((fiat_p448_uint128)(arg1[0]) * x20);
  fiat_p448_uint128 x76 = ((fiat_p448_uint128)(arg1[0]) * x21);
  fiat_p448_uint128 x77 = ((fiat_p448_uint128)(arg1[0]) * (arg1[0]));
  fiat_p448_uint128 x78 = (x74 + (x68 + (x38 + x34)));
  uint64_t x79 = (uint64_t)(x78 >> 56);
  uint64_t x80 = (uint64_t)(x78 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x81 = (x70 + (x64 + (x58 + (x52 + (x39 + x35)))));
  fiat_p448_uint128 x82 = (x71 + (x65 + (x59 + (x53 + (x47 + (x41 + (x37 + (x30 + x26))))))));
  fiat_p448_uint128 x83 = (x72 + (x66 + (x60 + (x55 + (x49 + (x43 + (x31 + x27)))))));
  fiat_p448_uint128 x84 = (x73 + (x67 + (x63 + (x61 + (x57 + (x51 + (x45 + (x33 + (x32 + (x29 + x28))))))))));
  fiat_p448_uint128 x85 = (x75 + (x69 + (x46 + (x40 + (x36 + x22)))));
  fiat_p448_uint128 x86 = (x76 + (x54 + (x48 + (x42 + x23))));
  fiat_p448_uint128 x87 = (x77 + (x62 + (x56 + (x50 + (x44 + (x25 + x24))))));
  fiat_p448_uint128 x88 = (x79 + x84);
  uint64_t x89 = (uint64_t)(x81 >> 56);
  uint64_t x90 = (uint64_t)(x81 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x91 = (x88 + x89);
  uint64_t x92 = (uint64_t)(x91 >> 56);
  uint64_t x93 = (uint64_t)(x91 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x94 = (x87 + x89);
  fiat_p448_uint128 x95 = (x92 + x83);
  uint64_t x96 = (uint64_t)(x94 >> 56);
  uint64_t x97 = (uint64_t)(x94 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x98 = (x96 + x86);
  uint64_t x99 = (uint64_t)(x95 >> 56);
  uint64_t x100 = (uint64_t)(x95 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x101 = (x99 + x82);
  uint64_t x102 = (uint64_t)(x98 >> 56);
  uint64_t x103 = (uint64_t)(x98 & UINT64_C(0xffffffffffffff));
  fiat_p448_uint128 x104 = (x102 + x85);
  uint64_t x105 = (uint64_t)(x101 >> 56);
  uint64_t x106 = (uint64_t)(x101 & UINT64_C(0xffffffffffffff));
  uint64_t x107 = (x105 + x90);
  uint64_t x108 = (uint64_t)(x104 >> 56);
  uint64_t x109 = (uint64_t)(x104 & UINT64_C(0xffffffffffffff));
  uint64_t x110 = (x108 + x80);
  uint64_t x111 = (x107 >> 56);
  uint64_t x112 = (x107 & UINT64_C(0xffffffffffffff));
  uint64_t x113 = (x110 >> 56);
  uint64_t x114 = (x110 & UINT64_C(0xffffffffffffff));
  uint64_t x115 = (x93 + x111);
  uint64_t x116 = (x97 + x111);
  uint64_t x117 = (x113 + x115);
  fiat_p448_uint1 x118 = (fiat_p448_uint1)(x117 >> 56);
  uint64_t x119 = (x117 & UINT64_C(0xffffffffffffff));
  uint64_t x120 = (x118 + x100);
  fiat_p448_uint1 x121 = (fiat_p448_uint1)(x116 >> 56);
  uint64_t x122 = (x116 & UINT64_C(0xffffffffffffff));
  uint64_t x123 = (x121 + x103);
  out1[0] = x122;
  out1[1] = x123;
  out1[2] = x109;
  out1[3] = x114;
  out1[4] = x119;
  out1[5] = x120;
  out1[6] = x106;
  out1[7] = x112;
}

/*
 * The function fiat_p448_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 */
static void fiat_p448_carry(uint64_t out1[8], const uint64_t arg1[8]) {
  uint64_t x1 = (arg1[3]);
  uint64_t x2 = (arg1[7]);
  uint64_t x3 = (x2 >> 56);
  uint64_t x4 = (((x1 >> 56) + (arg1[4])) + x3);
  uint64_t x5 = ((arg1[0]) + x3);
  uint64_t x6 = ((x4 >> 56) + (arg1[5]));
  uint64_t x7 = ((x5 >> 56) + (arg1[1]));
  uint64_t x8 = ((x6 >> 56) + (arg1[6]));
  uint64_t x9 = ((x7 >> 56) + (arg1[2]));
  uint64_t x10 = ((x8 >> 56) + (x2 & UINT64_C(0xffffffffffffff)));
  uint64_t x11 = ((x9 >> 56) + (x1 & UINT64_C(0xffffffffffffff)));
  fiat_p448_uint1 x12 = (fiat_p448_uint1)(x10 >> 56);
  uint64_t x13 = ((x5 & UINT64_C(0xffffffffffffff)) + (uint64_t)x12);
  uint64_t x14 = ((fiat_p448_uint1)(x11 >> 56) + ((x4 & UINT64_C(0xffffffffffffff)) + (uint64_t)x12));
  uint64_t x15 = (x13 & UINT64_C(0xffffffffffffff));
  uint64_t x16 = ((fiat_p448_uint1)(x13 >> 56) + (x7 & UINT64_C(0xffffffffffffff)));
  uint64_t x17 = (x9 & UINT64_C(0xffffffffffffff));
  uint64_t x18 = (x11 & UINT64_C(0xffffffffffffff));
  uint64_t x19 = (x14 & UINT64_C(0xffffffffffffff));
  uint64_t x20 = ((fiat_p448_uint1)(x14 >> 56) + (x6 & UINT64_C(0xffffffffffffff)));
  uint64_t x21 = (x8 & UINT64_C(0xffffffffffffff));
  uint64_t x22 = (x10 & UINT64_C(0xffffffffffffff));
  out1[0] = x15;
  out1[1] = x16;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x20;
  out1[6] = x21;
  out1[7] = x22;
}

/*
 * The function fiat_p448_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 *   arg2: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 */
static void fiat_p448_add(uint64_t out1[8], const uint64_t arg1[8], const uint64_t arg2[8]) {
  uint64_t x1 = ((arg1[0]) + (arg2[0]));
  uint64_t x2 = ((arg1[1]) + (arg2[1]));
  uint64_t x3 = ((arg1[2]) + (arg2[2]));
  uint64_t x4 = ((arg1[3]) + (arg2[3]));
  uint64_t x5 = ((arg1[4]) + (arg2[4]));
  uint64_t x6 = ((arg1[5]) + (arg2[5]));
  uint64_t x7 = ((arg1[6]) + (arg2[6]));
  uint64_t x8 = ((arg1[7]) + (arg2[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/*
 * The function fiat_p448_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 *   arg2: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 */
static void fiat_p448_sub(uint64_t out1[8], const uint64_t arg1[8], const uint64_t arg2[8]) {
  uint64_t x1 = ((UINT64_C(0x1fffffffffffffe) + (arg1[0])) - (arg2[0]));
  uint64_t x2 = ((UINT64_C(0x1fffffffffffffe) + (arg1[1])) - (arg2[1]));
  uint64_t x3 = ((UINT64_C(0x1fffffffffffffe) + (arg1[2])) - (arg2[2]));
  uint64_t x4 = ((UINT64_C(0x1fffffffffffffe) + (arg1[3])) - (arg2[3]));
  uint64_t x5 = ((UINT64_C(0x1fffffffffffffc) + (arg1[4])) - (arg2[4]));
  uint64_t x6 = ((UINT64_C(0x1fffffffffffffe) + (arg1[5])) - (arg2[5]));
  uint64_t x7 = ((UINT64_C(0x1fffffffffffffe) + (arg1[6])) - (arg2[6]));
  uint64_t x8 = ((UINT64_C(0x1fffffffffffffe) + (arg1[7])) - (arg2[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/*
 * The function fiat_p448_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb], [0x0 ~> 0x34ccccccccccccb]]
 */
static void fiat_p448_opp(uint64_t out1[8], const uint64_t arg1[8]) {
  uint64_t x1 = (UINT64_C(0x1fffffffffffffe) - (arg1[0]));
  uint64_t x2 = (UINT64_C(0x1fffffffffffffe) - (arg1[1]));
  uint64_t x3 = (UINT64_C(0x1fffffffffffffe) - (arg1[2]));
  uint64_t x4 = (UINT64_C(0x1fffffffffffffe) - (arg1[3]));
  uint64_t x5 = (UINT64_C(0x1fffffffffffffc) - (arg1[4]));
  uint64_t x6 = (UINT64_C(0x1fffffffffffffe) - (arg1[5]));
  uint64_t x7 = (UINT64_C(0x1fffffffffffffe) - (arg1[6]));
  uint64_t x8 = (UINT64_C(0x1fffffffffffffe) - (arg1[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/*
 * The function fiat_p448_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p448_selectznz(uint64_t out1[8], fiat_p448_uint1 arg1, const uint64_t arg2[8], const uint64_t arg3[8]) {
  uint64_t x1;
  fiat_p448_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  uint64_t x2;
  fiat_p448_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  uint64_t x3;
  fiat_p448_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  uint64_t x4;
  fiat_p448_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  uint64_t x5;
  fiat_p448_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
  uint64_t x6;
  fiat_p448_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
  uint64_t x7;
  fiat_p448_cmovznz_u64(&x7, arg1, (arg2[6]), (arg3[6]));
  uint64_t x8;
  fiat_p448_cmovznz_u64(&x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/*
 * The function fiat_p448_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..55]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p448_to_bytes(uint8_t out1[56], const uint64_t arg1[8]) {
  uint64_t x1;
  fiat_p448_uint1 x2;
  fiat_p448_subborrowx_u56(&x1, &x2, 0x0, (arg1[0]), UINT64_C(0xffffffffffffff));
  uint64_t x3;
  fiat_p448_uint1 x4;
  fiat_p448_subborrowx_u56(&x3, &x4, x2, (arg1[1]), UINT64_C(0xffffffffffffff));
  uint64_t x5;
  fiat_p448_uint1 x6;
  fiat_p448_subborrowx_u56(&x5, &x6, x4, (arg1[2]), UINT64_C(0xffffffffffffff));
  uint64_t x7;
  fiat_p448_uint1 x8;
  fiat_p448_subborrowx_u56(&x7, &x8, x6, (arg1[3]), UINT64_C(0xffffffffffffff));
  uint64_t x9;
  fiat_p448_uint1 x10;
  fiat_p448_subborrowx_u56(&x9, &x10, x8, (arg1[4]), UINT64_C(0xfffffffffffffe));
  uint64_t x11;
  fiat_p448_uint1 x12;
  fiat_p448_subborrowx_u56(&x11, &x12, x10, (arg1[5]), UINT64_C(0xffffffffffffff));
  uint64_t x13;
  fiat_p448_uint1 x14;
  fiat_p448_subborrowx_u56(&x13, &x14, x12, (arg1[6]), UINT64_C(0xffffffffffffff));
  uint64_t x15;
  fiat_p448_uint1 x16;
  fiat_p448_subborrowx_u56(&x15, &x16, x14, (arg1[7]), UINT64_C(0xffffffffffffff));
  uint64_t x17;
  fiat_p448_cmovznz_u64(&x17, x16, 0x0, UINT64_C(0xffffffffffffffff));
  uint64_t x18;
  fiat_p448_uint1 x19;
  fiat_p448_addcarryx_u56(&x18, &x19, 0x0, x1, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x20;
  fiat_p448_uint1 x21;
  fiat_p448_addcarryx_u56(&x20, &x21, x19, x3, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x22;
  fiat_p448_uint1 x23;
  fiat_p448_addcarryx_u56(&x22, &x23, x21, x5, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x24;
  fiat_p448_uint1 x25;
  fiat_p448_addcarryx_u56(&x24, &x25, x23, x7, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x26;
  fiat_p448_uint1 x27;
  fiat_p448_addcarryx_u56(&x26, &x27, x25, x9, (x17 & UINT64_C(0xfffffffffffffe)));
  uint64_t x28;
  fiat_p448_uint1 x29;
  fiat_p448_addcarryx_u56(&x28, &x29, x27, x11, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x30;
  fiat_p448_uint1 x31;
  fiat_p448_addcarryx_u56(&x30, &x31, x29, x13, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x32;
  fiat_p448_uint1 x33;
  fiat_p448_addcarryx_u56(&x32, &x33, x31, x15, (x17 & UINT64_C(0xffffffffffffff)));
  uint64_t x34 = (x18 >> 8);
  uint8_t x35 = (uint8_t)(x18 & UINT8_C(0xff));
  uint64_t x36 = (x34 >> 8);
  uint8_t x37 = (uint8_t)(x34 & UINT8_C(0xff));
  uint64_t x38 = (x36 >> 8);
  uint8_t x39 = (uint8_t)(x36 & UINT8_C(0xff));
  uint64_t x40 = (x38 >> 8);
  uint8_t x41 = (uint8_t)(x38 & UINT8_C(0xff));
  uint64_t x42 = (x40 >> 8);
  uint8_t x43 = (uint8_t)(x40 & UINT8_C(0xff));
  uint8_t x44 = (uint8_t)(x42 >> 8);
  uint8_t x45 = (uint8_t)(x42 & UINT8_C(0xff));
  uint8_t x46 = (uint8_t)(x44 & UINT8_C(0xff));
  uint64_t x47 = (x20 >> 8);
  uint8_t x48 = (uint8_t)(x20 & UINT8_C(0xff));
  uint64_t x49 = (x47 >> 8);
  uint8_t x50 = (uint8_t)(x47 & UINT8_C(0xff));
  uint64_t x51 = (x49 >> 8);
  uint8_t x52 = (uint8_t)(x49 & UINT8_C(0xff));
  uint64_t x53 = (x51 >> 8);
  uint8_t x54 = (uint8_t)(x51 & UINT8_C(0xff));
  uint64_t x55 = (x53 >> 8);
  uint8_t x56 = (uint8_t)(x53 & UINT8_C(0xff));
  uint8_t x57 = (uint8_t)(x55 >> 8);
  uint8_t x58 = (uint8_t)(x55 & UINT8_C(0xff));
  uint8_t x59 = (uint8_t)(x57 & UINT8_C(0xff));
  uint64_t x60 = (x22 >> 8);
  uint8_t x61 = (uint8_t)(x22 & UINT8_C(0xff));
  uint64_t x62 = (x60 >> 8);
  uint8_t x63 = (uint8_t)(x60 & UINT8_C(0xff));
  uint64_t x64 = (x62 >> 8);
  uint8_t x65 = (uint8_t)(x62 & UINT8_C(0xff));
  uint64_t x66 = (x64 >> 8);
  uint8_t x67 = (uint8_t)(x64 & UINT8_C(0xff));
  uint64_t x68 = (x66 >> 8);
  uint8_t x69 = (uint8_t)(x66 & UINT8_C(0xff));
  uint8_t x70 = (uint8_t)(x68 >> 8);
  uint8_t x71 = (uint8_t)(x68 & UINT8_C(0xff));
  uint8_t x72 = (uint8_t)(x70 & UINT8_C(0xff));
  uint64_t x73 = (x24 >> 8);
  uint8_t x74 = (uint8_t)(x24 & UINT8_C(0xff));
  uint64_t x75 = (x73 >> 8);
  uint8_t x76 = (uint8_t)(x73 & UINT8_C(0xff));
  uint64_t x77 = (x75 >> 8);
  uint8_t x78 = (uint8_t)(x75 & UINT8_C(0xff));
  uint64_t x79 = (x77 >> 8);
  uint8_t x80 = (uint8_t)(x77 & UINT8_C(0xff));
  uint64_t x81 = (x79 >> 8);
  uint8_t x82 = (uint8_t)(x79 & UINT8_C(0xff));
  uint8_t x83 = (uint8_t)(x81 >> 8);
  uint8_t x84 = (uint8_t)(x81 & UINT8_C(0xff));
  uint8_t x85 = (uint8_t)(x83 & UINT8_C(0xff));
  uint64_t x86 = (x26 >> 8);
  uint8_t x87 = (uint8_t)(x26 & UINT8_C(0xff));
  uint64_t x88 = (x86 >> 8);
  uint8_t x89 = (uint8_t)(x86 & UINT8_C(0xff));
  uint64_t x90 = (x88 >> 8);
  uint8_t x91 = (uint8_t)(x88 & UINT8_C(0xff));
  uint64_t x92 = (x90 >> 8);
  uint8_t x93 = (uint8_t)(x90 & UINT8_C(0xff));
  uint64_t x94 = (x92 >> 8);
  uint8_t x95 = (uint8_t)(x92 & UINT8_C(0xff));
  uint8_t x96 = (uint8_t)(x94 >> 8);
  uint8_t x97 = (uint8_t)(x94 & UINT8_C(0xff));
  uint8_t x98 = (uint8_t)(x96 & UINT8_C(0xff));
  uint64_t x99 = (x28 >> 8);
  uint8_t x100 = (uint8_t)(x28 & UINT8_C(0xff));
  uint64_t x101 = (x99 >> 8);
  uint8_t x102 = (uint8_t)(x99 & UINT8_C(0xff));
  uint64_t x103 = (x101 >> 8);
  uint8_t x104 = (uint8_t)(x101 & UINT8_C(0xff));
  uint64_t x105 = (x103 >> 8);
  uint8_t x106 = (uint8_t)(x103 & UINT8_C(0xff));
  uint64_t x107 = (x105 >> 8);
  uint8_t x108 = (uint8_t)(x105 & UINT8_C(0xff));
  uint8_t x109 = (uint8_t)(x107 >> 8);
  uint8_t x110 = (uint8_t)(x107 & UINT8_C(0xff));
  uint8_t x111 = (uint8_t)(x109 & UINT8_C(0xff));
  uint64_t x112 = (x30 >> 8);
  uint8_t x113 = (uint8_t)(x30 & UINT8_C(0xff));
  uint64_t x114 = (x112 >> 8);
  uint8_t x115 = (uint8_t)(x112 & UINT8_C(0xff));
  uint64_t x116 = (x114 >> 8);
  uint8_t x117 = (uint8_t)(x114 & UINT8_C(0xff));
  uint64_t x118 = (x116 >> 8);
  uint8_t x119 = (uint8_t)(x116 & UINT8_C(0xff));
  uint64_t x120 = (x118 >> 8);
  uint8_t x121 = (uint8_t)(x118 & UINT8_C(0xff));
  uint8_t x122 = (uint8_t)(x120 >> 8);
  uint8_t x123 = (uint8_t)(x120 & UINT8_C(0xff));
  uint8_t x124 = (uint8_t)(x122 & UINT8_C(0xff));
  uint64_t x125 = (x32 >> 8);
  uint8_t x126 = (uint8_t)(x32 & UINT8_C(0xff));
  uint64_t x127 = (x125 >> 8);
  uint8_t x128 = (uint8_t)(x125 & UINT8_C(0xff));
  uint64_t x129 = (x127 >> 8);
  uint8_t x130 = (uint8_t)(x127 & UINT8_C(0xff));
  uint64_t x131 = (x129 >> 8);
  uint8_t x132 = (uint8_t)(x129 & UINT8_C(0xff));
  uint64_t x133 = (x131 >> 8);
  uint8_t x134 = (uint8_t)(x131 & UINT8_C(0xff));
  uint8_t x135 = (uint8_t)(x133 >> 8);
  uint8_t x136 = (uint8_t)(x133 & UINT8_C(0xff));
  out1[0] = x35;
  out1[1] = x37;
  out1[2] = x39;
  out1[3] = x41;
  out1[4] = x43;
  out1[5] = x45;
  out1[6] = x46;
  out1[7] = x48;
  out1[8] = x50;
  out1[9] = x52;
  out1[10] = x54;
  out1[11] = x56;
  out1[12] = x58;
  out1[13] = x59;
  out1[14] = x61;
  out1[15] = x63;
  out1[16] = x65;
  out1[17] = x67;
  out1[18] = x69;
  out1[19] = x71;
  out1[20] = x72;
  out1[21] = x74;
  out1[22] = x76;
  out1[23] = x78;
  out1[24] = x80;
  out1[25] = x82;
  out1[26] = x84;
  out1[27] = x85;
  out1[28] = x87;
  out1[29] = x89;
  out1[30] = x91;
  out1[31] = x93;
  out1[32] = x95;
  out1[33] = x97;
  out1[34] = x98;
  out1[35] = x100;
  out1[36] = x102;
  out1[37] = x104;
  out1[38] = x106;
  out1[39] = x108;
  out1[40] = x110;
  out1[41] = x111;
  out1[42] = x113;
  out1[43] = x115;
  out1[44] = x117;
  out1[45] = x119;
  out1[46] = x121;
  out1[47] = x123;
  out1[48] = x124;
  out1[49] = x126;
  out1[50] = x128;
  out1[51] = x130;
  out1[52] = x132;
  out1[53] = x134;
  out1[54] = x136;
  out1[55] = x135;
}

/*
 * The function fiat_p448_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999], [0x0 ~> 0x119999999999999]]
 */
static void fiat_p448_from_bytes(uint64_t out1[8], const uint8_t arg1[56]) {
  uint64_t x1 = ((uint64_t)(arg1[55]) << 48);
  uint64_t x2 = ((uint64_t)(arg1[54]) << 40);
  uint64_t x3 = ((uint64_t)(arg1[53]) << 32);
  uint64_t x4 = ((uint64_t)(arg1[52]) << 24);
  uint64_t x5 = ((uint64_t)(arg1[51]) << 16);
  uint64_t x6 = ((uint64_t)(arg1[50]) << 8);
  uint8_t x7 = (arg1[49]);
  uint64_t x8 = ((uint64_t)(arg1[48]) << 48);
  uint64_t x9 = ((uint64_t)(arg1[47]) << 40);
  uint64_t x10 = ((uint64_t)(arg1[46]) << 32);
  uint64_t x11 = ((uint64_t)(arg1[45]) << 24);
  uint64_t x12 = ((uint64_t)(arg1[44]) << 16);
  uint64_t x13 = ((uint64_t)(arg1[43]) << 8);
  uint8_t x14 = (arg1[42]);
  uint64_t x15 = ((uint64_t)(arg1[41]) << 48);
  uint64_t x16 = ((uint64_t)(arg1[40]) << 40);
  uint64_t x17 = ((uint64_t)(arg1[39]) << 32);
  uint64_t x18 = ((uint64_t)(arg1[38]) << 24);
  uint64_t x19 = ((uint64_t)(arg1[37]) << 16);
  uint64_t x20 = ((uint64_t)(arg1[36]) << 8);
  uint8_t x21 = (arg1[35]);
  uint64_t x22 = ((uint64_t)(arg1[34]) << 48);
  uint64_t x23 = ((uint64_t)(arg1[33]) << 40);
  uint64_t x24 = ((uint64_t)(arg1[32]) << 32);
  uint64_t x25 = ((uint64_t)(arg1[31]) << 24);
  uint64_t x26 = ((uint64_t)(arg1[30]) << 16);
  uint64_t x27 = ((uint64_t)(arg1[29]) << 8);
  uint8_t x28 = (arg1[28]);
  uint64_t x29 = ((uint64_t)(arg1[27]) << 48);
  uint64_t x30 = ((uint64_t)(arg1[26]) << 40);
  uint64_t x31 = ((uint64_t)(arg1[25]) << 32);
  uint64_t x32 = ((uint64_t)(arg1[24]) << 24);
  uint64_t x33 = ((uint64_t)(arg1[23]) << 16);
  uint64_t x34 = ((uint64_t)(arg1[22]) << 8);
  uint8_t x35 = (arg1[21]);
  uint64_t x36 = ((uint64_t)(arg1[20]) << 48);
  uint64_t x37 = ((uint64_t)(arg1[19]) << 40);
  uint64_t x38 = ((uint64_t)(arg1[18]) << 32);
  uint64_t x39 = ((uint64_t)(arg1[17]) << 24);
  uint64_t x40 = ((uint64_t)(arg1[16]) << 16);
  uint64_t x41 = ((uint64_t)(arg1[15]) << 8);
  uint8_t x42 = (arg1[14]);
  uint64_t x43 = ((uint64_t)(arg1[13]) << 48);
  uint64_t x44 = ((uint64_t)(arg1[12]) << 40);
  uint64_t x45 = ((uint64_t)(arg1[11]) << 32);
  uint64_t x46 = ((uint64_t)(arg1[10]) << 24);
  uint64_t x47 = ((uint64_t)(arg1[9]) << 16);
  uint64_t x48 = ((uint64_t)(arg1[8]) << 8);
  uint8_t x49 = (arg1[7]);
  uint64_t x50 = ((uint64_t)(arg1[6]) << 48);
  uint64_t x51 = ((uint64_t)(arg1[5]) << 40);
  uint64_t x52 = ((uint64_t)(arg1[4]) << 32);
  uint64_t x53 = ((uint64_t)(arg1[3]) << 24);
  uint64_t x54 = ((uint64_t)(arg1[2]) << 16);
  uint64_t x55 = ((uint64_t)(arg1[1]) << 8);
  uint8_t x56 = (arg1[0]);
  uint64_t x57 = (x56 + (x55 + (x54 + (x53 + (x52 + (x51 + x50))))));
  uint64_t x58 = (x57 & UINT64_C(0xffffffffffffff));
  uint64_t x59 = (x7 + (x6 + (x5 + (x4 + (x3 + (x2 + x1))))));
  uint64_t x60 = (x14 + (x13 + (x12 + (x11 + (x10 + (x9 + x8))))));
  uint64_t x61 = (x21 + (x20 + (x19 + (x18 + (x17 + (x16 + x15))))));
  uint64_t x62 = (x28 + (x27 + (x26 + (x25 + (x24 + (x23 + x22))))));
  uint64_t x63 = (x35 + (x34 + (x33 + (x32 + (x31 + (x30 + x29))))));
  uint64_t x64 = (x42 + (x41 + (x40 + (x39 + (x38 + (x37 + x36))))));
  uint64_t x65 = (x49 + (x48 + (x47 + (x46 + (x45 + (x44 + x43))))));
  uint64_t x66 = (x65 & UINT64_C(0xffffffffffffff));
  uint64_t x67 = (x64 & UINT64_C(0xffffffffffffff));
  uint64_t x68 = (x63 & UINT64_C(0xffffffffffffff));
  uint64_t x69 = (x62 & UINT64_C(0xffffffffffffff));
  uint64_t x70 = (x61 & UINT64_C(0xffffffffffffff));
  uint64_t x71 = (x60 & UINT64_C(0xffffffffffffff));
  out1[0] = x58;
  out1[1] = x66;
  out1[2] = x67;
  out1[3] = x68;
  out1[4] = x69;
  out1[5] = x70;
  out1[6] = x71;
  out1[7] = x59;
}
