/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery --static p384 '2^384 - 2^128 - 2^96 + 2^32 - 1' 32 */
/* curve description: p384 */
/* requested operations: (all) */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1") */
/* machine_wordsize = 32 (from "32") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */

#include <stdint.h>
typedef unsigned char fiat_p384_uint1;
typedef signed char fiat_p384_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p384_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p384_addcarryx_u32(uint32_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1 = ((arg1 + (uint64_t)arg2) + arg3);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  fiat_p384_uint1 x3 = (fiat_p384_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p384_subborrowx_u32(uint32_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1 = ((arg2 - (int64_t)arg1) - arg3);
  fiat_p384_int1 x2 = (fiat_p384_int1)(x1 >> 32);
  uint32_t x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_p384_uint1)(0x0 - x2);
}

/*
 * The function fiat_p384_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_p384_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1 = ((uint64_t)arg1 * arg2);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  uint32_t x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p384_cmovznz_u32(uint32_t* out1, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_p384_uint1 x1 = (!(!arg1));
  uint32_t x2 = ((fiat_p384_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  uint32_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p384_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_mul(uint32_t out1[12], const uint32_t arg1[12], const uint32_t arg2[12]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[7]);
  uint32_t x8 = (arg1[8]);
  uint32_t x9 = (arg1[9]);
  uint32_t x10 = (arg1[10]);
  uint32_t x11 = (arg1[11]);
  uint32_t x12 = (arg1[0]);
  uint32_t x13;
  uint32_t x14;
  fiat_p384_mulx_u32(&x13, &x14, x12, (arg2[11]));
  uint32_t x15;
  uint32_t x16;
  fiat_p384_mulx_u32(&x15, &x16, x12, (arg2[10]));
  uint32_t x17;
  uint32_t x18;
  fiat_p384_mulx_u32(&x17, &x18, x12, (arg2[9]));
  uint32_t x19;
  uint32_t x20;
  fiat_p384_mulx_u32(&x19, &x20, x12, (arg2[8]));
  uint32_t x21;
  uint32_t x22;
  fiat_p384_mulx_u32(&x21, &x22, x12, (arg2[7]));
  uint32_t x23;
  uint32_t x24;
  fiat_p384_mulx_u32(&x23, &x24, x12, (arg2[6]));
  uint32_t x25;
  uint32_t x26;
  fiat_p384_mulx_u32(&x25, &x26, x12, (arg2[5]));
  uint32_t x27;
  uint32_t x28;
  fiat_p384_mulx_u32(&x27, &x28, x12, (arg2[4]));
  uint32_t x29;
  uint32_t x30;
  fiat_p384_mulx_u32(&x29, &x30, x12, (arg2[3]));
  uint32_t x31;
  uint32_t x32;
  fiat_p384_mulx_u32(&x31, &x32, x12, (arg2[2]));
  uint32_t x33;
  uint32_t x34;
  fiat_p384_mulx_u32(&x33, &x34, x12, (arg2[1]));
  uint32_t x35;
  uint32_t x36;
  fiat_p384_mulx_u32(&x35, &x36, x12, (arg2[0]));
  uint32_t x37;
  fiat_p384_uint1 x38;
  fiat_p384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  uint32_t x39;
  fiat_p384_uint1 x40;
  fiat_p384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  uint32_t x41;
  fiat_p384_uint1 x42;
  fiat_p384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  uint32_t x43;
  fiat_p384_uint1 x44;
  fiat_p384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  uint32_t x45;
  fiat_p384_uint1 x46;
  fiat_p384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  uint32_t x47;
  fiat_p384_uint1 x48;
  fiat_p384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  uint32_t x49;
  fiat_p384_uint1 x50;
  fiat_p384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  uint32_t x51;
  fiat_p384_uint1 x52;
  fiat_p384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  uint32_t x53;
  fiat_p384_uint1 x54;
  fiat_p384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  uint32_t x55;
  fiat_p384_uint1 x56;
  fiat_p384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  uint32_t x57;
  fiat_p384_uint1 x58;
  fiat_p384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  uint32_t x59;
  fiat_p384_uint1 x60;
  fiat_p384_addcarryx_u32(&x59, &x60, x58, x14, 0x0);
  uint32_t x61;
  uint32_t x62;
  fiat_p384_mulx_u32(&x61, &x62, x35, UINT32_C(0xffffffff));
  uint32_t x63;
  uint32_t x64;
  fiat_p384_mulx_u32(&x63, &x64, x35, UINT32_C(0xffffffff));
  uint32_t x65;
  uint32_t x66;
  fiat_p384_mulx_u32(&x65, &x66, x35, UINT32_C(0xffffffff));
  uint32_t x67;
  uint32_t x68;
  fiat_p384_mulx_u32(&x67, &x68, x35, UINT32_C(0xffffffff));
  uint32_t x69;
  uint32_t x70;
  fiat_p384_mulx_u32(&x69, &x70, x35, UINT32_C(0xffffffff));
  uint32_t x71;
  uint32_t x72;
  fiat_p384_mulx_u32(&x71, &x72, x35, UINT32_C(0xffffffff));
  uint32_t x73;
  uint32_t x74;
  fiat_p384_mulx_u32(&x73, &x74, x35, UINT32_C(0xffffffff));
  uint32_t x75;
  uint32_t x76;
  fiat_p384_mulx_u32(&x75, &x76, x35, UINT32_C(0xfffffffe));
  uint32_t x77;
  uint32_t x78;
  fiat_p384_mulx_u32(&x77, &x78, x35, UINT32_C(0xffffffff));
  uint32_t x79;
  uint32_t x80;
  fiat_p384_mulx_u32(&x79, &x80, x35, UINT32_C(0xffffffff));
  uint32_t x81;
  fiat_p384_uint1 x82;
  fiat_p384_addcarryx_u32(&x81, &x82, 0x0, x78, x75);
  uint32_t x83;
  fiat_p384_uint1 x84;
  fiat_p384_addcarryx_u32(&x83, &x84, x82, x76, x73);
  uint32_t x85;
  fiat_p384_uint1 x86;
  fiat_p384_addcarryx_u32(&x85, &x86, x84, x74, x71);
  uint32_t x87;
  fiat_p384_uint1 x88;
  fiat_p384_addcarryx_u32(&x87, &x88, x86, x72, x69);
  uint32_t x89;
  fiat_p384_uint1 x90;
  fiat_p384_addcarryx_u32(&x89, &x90, x88, x70, x67);
  uint32_t x91;
  fiat_p384_uint1 x92;
  fiat_p384_addcarryx_u32(&x91, &x92, x90, x68, x65);
  uint32_t x93;
  fiat_p384_uint1 x94;
  fiat_p384_addcarryx_u32(&x93, &x94, x92, x66, x63);
  uint32_t x95;
  fiat_p384_uint1 x96;
  fiat_p384_addcarryx_u32(&x95, &x96, x94, x64, x61);
  uint32_t x97;
  fiat_p384_uint1 x98;
  fiat_p384_addcarryx_u32(&x97, &x98, x96, x62, 0x0);
  uint32_t x99;
  fiat_p384_uint1 x100;
  fiat_p384_addcarryx_u32(&x99, &x100, 0x0, x35, x79);
  uint32_t x101;
  fiat_p384_uint1 x102;
  fiat_p384_addcarryx_u32(&x101, &x102, x100, x37, x80);
  uint32_t x103;
  fiat_p384_uint1 x104;
  fiat_p384_addcarryx_u32(&x103, &x104, x102, x39, 0x0);
  uint32_t x105;
  fiat_p384_uint1 x106;
  fiat_p384_addcarryx_u32(&x105, &x106, x104, x41, x77);
  uint32_t x107;
  fiat_p384_uint1 x108;
  fiat_p384_addcarryx_u32(&x107, &x108, x106, x43, x81);
  uint32_t x109;
  fiat_p384_uint1 x110;
  fiat_p384_addcarryx_u32(&x109, &x110, x108, x45, x83);
  uint32_t x111;
  fiat_p384_uint1 x112;
  fiat_p384_addcarryx_u32(&x111, &x112, x110, x47, x85);
  uint32_t x113;
  fiat_p384_uint1 x114;
  fiat_p384_addcarryx_u32(&x113, &x114, x112, x49, x87);
  uint32_t x115;
  fiat_p384_uint1 x116;
  fiat_p384_addcarryx_u32(&x115, &x116, x114, x51, x89);
  uint32_t x117;
  fiat_p384_uint1 x118;
  fiat_p384_addcarryx_u32(&x117, &x118, x116, x53, x91);
  uint32_t x119;
  fiat_p384_uint1 x120;
  fiat_p384_addcarryx_u32(&x119, &x120, x118, x55, x93);
  uint32_t x121;
  fiat_p384_uint1 x122;
  fiat_p384_addcarryx_u32(&x121, &x122, x120, x57, x95);
  uint32_t x123;
  fiat_p384_uint1 x124;
  fiat_p384_addcarryx_u32(&x123, &x124, x122, x59, x97);
  uint32_t x125;
  fiat_p384_uint1 x126;
  fiat_p384_addcarryx_u32(&x125, &x126, x124, 0x0, 0x0);
  uint32_t x127;
  uint32_t x128;
  fiat_p384_mulx_u32(&x127, &x128, x1, (arg2[11]));
  uint32_t x129;
  uint32_t x130;
  fiat_p384_mulx_u32(&x129, &x130, x1, (arg2[10]));
  uint32_t x131;
  uint32_t x132;
  fiat_p384_mulx_u32(&x131, &x132, x1, (arg2[9]));
  uint32_t x133;
  uint32_t x134;
  fiat_p384_mulx_u32(&x133, &x134, x1, (arg2[8]));
  uint32_t x135;
  uint32_t x136;
  fiat_p384_mulx_u32(&x135, &x136, x1, (arg2[7]));
  uint32_t x137;
  uint32_t x138;
  fiat_p384_mulx_u32(&x137, &x138, x1, (arg2[6]));
  uint32_t x139;
  uint32_t x140;
  fiat_p384_mulx_u32(&x139, &x140, x1, (arg2[5]));
  uint32_t x141;
  uint32_t x142;
  fiat_p384_mulx_u32(&x141, &x142, x1, (arg2[4]));
  uint32_t x143;
  uint32_t x144;
  fiat_p384_mulx_u32(&x143, &x144, x1, (arg2[3]));
  uint32_t x145;
  uint32_t x146;
  fiat_p384_mulx_u32(&x145, &x146, x1, (arg2[2]));
  uint32_t x147;
  uint32_t x148;
  fiat_p384_mulx_u32(&x147, &x148, x1, (arg2[1]));
  uint32_t x149;
  uint32_t x150;
  fiat_p384_mulx_u32(&x149, &x150, x1, (arg2[0]));
  uint32_t x151;
  fiat_p384_uint1 x152;
  fiat_p384_addcarryx_u32(&x151, &x152, 0x0, x150, x147);
  uint32_t x153;
  fiat_p384_uint1 x154;
  fiat_p384_addcarryx_u32(&x153, &x154, x152, x148, x145);
  uint32_t x155;
  fiat_p384_uint1 x156;
  fiat_p384_addcarryx_u32(&x155, &x156, x154, x146, x143);
  uint32_t x157;
  fiat_p384_uint1 x158;
  fiat_p384_addcarryx_u32(&x157, &x158, x156, x144, x141);
  uint32_t x159;
  fiat_p384_uint1 x160;
  fiat_p384_addcarryx_u32(&x159, &x160, x158, x142, x139);
  uint32_t x161;
  fiat_p384_uint1 x162;
  fiat_p384_addcarryx_u32(&x161, &x162, x160, x140, x137);
  uint32_t x163;
  fiat_p384_uint1 x164;
  fiat_p384_addcarryx_u32(&x163, &x164, x162, x138, x135);
  uint32_t x165;
  fiat_p384_uint1 x166;
  fiat_p384_addcarryx_u32(&x165, &x166, x164, x136, x133);
  uint32_t x167;
  fiat_p384_uint1 x168;
  fiat_p384_addcarryx_u32(&x167, &x168, x166, x134, x131);
  uint32_t x169;
  fiat_p384_uint1 x170;
  fiat_p384_addcarryx_u32(&x169, &x170, x168, x132, x129);
  uint32_t x171;
  fiat_p384_uint1 x172;
  fiat_p384_addcarryx_u32(&x171, &x172, x170, x130, x127);
  uint32_t x173;
  fiat_p384_uint1 x174;
  fiat_p384_addcarryx_u32(&x173, &x174, x172, x128, 0x0);
  uint32_t x175;
  fiat_p384_uint1 x176;
  fiat_p384_addcarryx_u32(&x175, &x176, 0x0, x101, x149);
  uint32_t x177;
  fiat_p384_uint1 x178;
  fiat_p384_addcarryx_u32(&x177, &x178, x176, x103, x151);
  uint32_t x179;
  fiat_p384_uint1 x180;
  fiat_p384_addcarryx_u32(&x179, &x180, x178, x105, x153);
  uint32_t x181;
  fiat_p384_uint1 x182;
  fiat_p384_addcarryx_u32(&x181, &x182, x180, x107, x155);
  uint32_t x183;
  fiat_p384_uint1 x184;
  fiat_p384_addcarryx_u32(&x183, &x184, x182, x109, x157);
  uint32_t x185;
  fiat_p384_uint1 x186;
  fiat_p384_addcarryx_u32(&x185, &x186, x184, x111, x159);
  uint32_t x187;
  fiat_p384_uint1 x188;
  fiat_p384_addcarryx_u32(&x187, &x188, x186, x113, x161);
  uint32_t x189;
  fiat_p384_uint1 x190;
  fiat_p384_addcarryx_u32(&x189, &x190, x188, x115, x163);
  uint32_t x191;
  fiat_p384_uint1 x192;
  fiat_p384_addcarryx_u32(&x191, &x192, x190, x117, x165);
  uint32_t x193;
  fiat_p384_uint1 x194;
  fiat_p384_addcarryx_u32(&x193, &x194, x192, x119, x167);
  uint32_t x195;
  fiat_p384_uint1 x196;
  fiat_p384_addcarryx_u32(&x195, &x196, x194, x121, x169);
  uint32_t x197;
  fiat_p384_uint1 x198;
  fiat_p384_addcarryx_u32(&x197, &x198, x196, x123, x171);
  uint32_t x199;
  fiat_p384_uint1 x200;
  fiat_p384_addcarryx_u32(&x199, &x200, x198, (fiat_p384_uint1)x125, x173);
  uint32_t x201;
  uint32_t x202;
  fiat_p384_mulx_u32(&x201, &x202, x175, UINT32_C(0xffffffff));
  uint32_t x203;
  uint32_t x204;
  fiat_p384_mulx_u32(&x203, &x204, x175, UINT32_C(0xffffffff));
  uint32_t x205;
  uint32_t x206;
  fiat_p384_mulx_u32(&x205, &x206, x175, UINT32_C(0xffffffff));
  uint32_t x207;
  uint32_t x208;
  fiat_p384_mulx_u32(&x207, &x208, x175, UINT32_C(0xffffffff));
  uint32_t x209;
  uint32_t x210;
  fiat_p384_mulx_u32(&x209, &x210, x175, UINT32_C(0xffffffff));
  uint32_t x211;
  uint32_t x212;
  fiat_p384_mulx_u32(&x211, &x212, x175, UINT32_C(0xffffffff));
  uint32_t x213;
  uint32_t x214;
  fiat_p384_mulx_u32(&x213, &x214, x175, UINT32_C(0xffffffff));
  uint32_t x215;
  uint32_t x216;
  fiat_p384_mulx_u32(&x215, &x216, x175, UINT32_C(0xfffffffe));
  uint32_t x217;
  uint32_t x218;
  fiat_p384_mulx_u32(&x217, &x218, x175, UINT32_C(0xffffffff));
  uint32_t x219;
  uint32_t x220;
  fiat_p384_mulx_u32(&x219, &x220, x175, UINT32_C(0xffffffff));
  uint32_t x221;
  fiat_p384_uint1 x222;
  fiat_p384_addcarryx_u32(&x221, &x222, 0x0, x218, x215);
  uint32_t x223;
  fiat_p384_uint1 x224;
  fiat_p384_addcarryx_u32(&x223, &x224, x222, x216, x213);
  uint32_t x225;
  fiat_p384_uint1 x226;
  fiat_p384_addcarryx_u32(&x225, &x226, x224, x214, x211);
  uint32_t x227;
  fiat_p384_uint1 x228;
  fiat_p384_addcarryx_u32(&x227, &x228, x226, x212, x209);
  uint32_t x229;
  fiat_p384_uint1 x230;
  fiat_p384_addcarryx_u32(&x229, &x230, x228, x210, x207);
  uint32_t x231;
  fiat_p384_uint1 x232;
  fiat_p384_addcarryx_u32(&x231, &x232, x230, x208, x205);
  uint32_t x233;
  fiat_p384_uint1 x234;
  fiat_p384_addcarryx_u32(&x233, &x234, x232, x206, x203);
  uint32_t x235;
  fiat_p384_uint1 x236;
  fiat_p384_addcarryx_u32(&x235, &x236, x234, x204, x201);
  uint32_t x237;
  fiat_p384_uint1 x238;
  fiat_p384_addcarryx_u32(&x237, &x238, x236, x202, 0x0);
  uint32_t x239;
  fiat_p384_uint1 x240;
  fiat_p384_addcarryx_u32(&x239, &x240, 0x0, x175, x219);
  uint32_t x241;
  fiat_p384_uint1 x242;
  fiat_p384_addcarryx_u32(&x241, &x242, x240, x177, x220);
  uint32_t x243;
  fiat_p384_uint1 x244;
  fiat_p384_addcarryx_u32(&x243, &x244, x242, x179, 0x0);
  uint32_t x245;
  fiat_p384_uint1 x246;
  fiat_p384_addcarryx_u32(&x245, &x246, x244, x181, x217);
  uint32_t x247;
  fiat_p384_uint1 x248;
  fiat_p384_addcarryx_u32(&x247, &x248, x246, x183, x221);
  uint32_t x249;
  fiat_p384_uint1 x250;
  fiat_p384_addcarryx_u32(&x249, &x250, x248, x185, x223);
  uint32_t x251;
  fiat_p384_uint1 x252;
  fiat_p384_addcarryx_u32(&x251, &x252, x250, x187, x225);
  uint32_t x253;
  fiat_p384_uint1 x254;
  fiat_p384_addcarryx_u32(&x253, &x254, x252, x189, x227);
  uint32_t x255;
  fiat_p384_uint1 x256;
  fiat_p384_addcarryx_u32(&x255, &x256, x254, x191, x229);
  uint32_t x257;
  fiat_p384_uint1 x258;
  fiat_p384_addcarryx_u32(&x257, &x258, x256, x193, x231);
  uint32_t x259;
  fiat_p384_uint1 x260;
  fiat_p384_addcarryx_u32(&x259, &x260, x258, x195, x233);
  uint32_t x261;
  fiat_p384_uint1 x262;
  fiat_p384_addcarryx_u32(&x261, &x262, x260, x197, x235);
  uint32_t x263;
  fiat_p384_uint1 x264;
  fiat_p384_addcarryx_u32(&x263, &x264, x262, x199, x237);
  uint32_t x265;
  fiat_p384_uint1 x266;
  fiat_p384_addcarryx_u32(&x265, &x266, x264, x200, 0x0);
  uint32_t x267;
  uint32_t x268;
  fiat_p384_mulx_u32(&x267, &x268, x2, (arg2[11]));
  uint32_t x269;
  uint32_t x270;
  fiat_p384_mulx_u32(&x269, &x270, x2, (arg2[10]));
  uint32_t x271;
  uint32_t x272;
  fiat_p384_mulx_u32(&x271, &x272, x2, (arg2[9]));
  uint32_t x273;
  uint32_t x274;
  fiat_p384_mulx_u32(&x273, &x274, x2, (arg2[8]));
  uint32_t x275;
  uint32_t x276;
  fiat_p384_mulx_u32(&x275, &x276, x2, (arg2[7]));
  uint32_t x277;
  uint32_t x278;
  fiat_p384_mulx_u32(&x277, &x278, x2, (arg2[6]));
  uint32_t x279;
  uint32_t x280;
  fiat_p384_mulx_u32(&x279, &x280, x2, (arg2[5]));
  uint32_t x281;
  uint32_t x282;
  fiat_p384_mulx_u32(&x281, &x282, x2, (arg2[4]));
  uint32_t x283;
  uint32_t x284;
  fiat_p384_mulx_u32(&x283, &x284, x2, (arg2[3]));
  uint32_t x285;
  uint32_t x286;
  fiat_p384_mulx_u32(&x285, &x286, x2, (arg2[2]));
  uint32_t x287;
  uint32_t x288;
  fiat_p384_mulx_u32(&x287, &x288, x2, (arg2[1]));
  uint32_t x289;
  uint32_t x290;
  fiat_p384_mulx_u32(&x289, &x290, x2, (arg2[0]));
  uint32_t x291;
  fiat_p384_uint1 x292;
  fiat_p384_addcarryx_u32(&x291, &x292, 0x0, x290, x287);
  uint32_t x293;
  fiat_p384_uint1 x294;
  fiat_p384_addcarryx_u32(&x293, &x294, x292, x288, x285);
  uint32_t x295;
  fiat_p384_uint1 x296;
  fiat_p384_addcarryx_u32(&x295, &x296, x294, x286, x283);
  uint32_t x297;
  fiat_p384_uint1 x298;
  fiat_p384_addcarryx_u32(&x297, &x298, x296, x284, x281);
  uint32_t x299;
  fiat_p384_uint1 x300;
  fiat_p384_addcarryx_u32(&x299, &x300, x298, x282, x279);
  uint32_t x301;
  fiat_p384_uint1 x302;
  fiat_p384_addcarryx_u32(&x301, &x302, x300, x280, x277);
  uint32_t x303;
  fiat_p384_uint1 x304;
  fiat_p384_addcarryx_u32(&x303, &x304, x302, x278, x275);
  uint32_t x305;
  fiat_p384_uint1 x306;
  fiat_p384_addcarryx_u32(&x305, &x306, x304, x276, x273);
  uint32_t x307;
  fiat_p384_uint1 x308;
  fiat_p384_addcarryx_u32(&x307, &x308, x306, x274, x271);
  uint32_t x309;
  fiat_p384_uint1 x310;
  fiat_p384_addcarryx_u32(&x309, &x310, x308, x272, x269);
  uint32_t x311;
  fiat_p384_uint1 x312;
  fiat_p384_addcarryx_u32(&x311, &x312, x310, x270, x267);
  uint32_t x313;
  fiat_p384_uint1 x314;
  fiat_p384_addcarryx_u32(&x313, &x314, x312, x268, 0x0);
  uint32_t x315;
  fiat_p384_uint1 x316;
  fiat_p384_addcarryx_u32(&x315, &x316, 0x0, x241, x289);
  uint32_t x317;
  fiat_p384_uint1 x318;
  fiat_p384_addcarryx_u32(&x317, &x318, x316, x243, x291);
  uint32_t x319;
  fiat_p384_uint1 x320;
  fiat_p384_addcarryx_u32(&x319, &x320, x318, x245, x293);
  uint32_t x321;
  fiat_p384_uint1 x322;
  fiat_p384_addcarryx_u32(&x321, &x322, x320, x247, x295);
  uint32_t x323;
  fiat_p384_uint1 x324;
  fiat_p384_addcarryx_u32(&x323, &x324, x322, x249, x297);
  uint32_t x325;
  fiat_p384_uint1 x326;
  fiat_p384_addcarryx_u32(&x325, &x326, x324, x251, x299);
  uint32_t x327;
  fiat_p384_uint1 x328;
  fiat_p384_addcarryx_u32(&x327, &x328, x326, x253, x301);
  uint32_t x329;
  fiat_p384_uint1 x330;
  fiat_p384_addcarryx_u32(&x329, &x330, x328, x255, x303);
  uint32_t x331;
  fiat_p384_uint1 x332;
  fiat_p384_addcarryx_u32(&x331, &x332, x330, x257, x305);
  uint32_t x333;
  fiat_p384_uint1 x334;
  fiat_p384_addcarryx_u32(&x333, &x334, x332, x259, x307);
  uint32_t x335;
  fiat_p384_uint1 x336;
  fiat_p384_addcarryx_u32(&x335, &x336, x334, x261, x309);
  uint32_t x337;
  fiat_p384_uint1 x338;
  fiat_p384_addcarryx_u32(&x337, &x338, x336, x263, x311);
  uint32_t x339;
  fiat_p384_uint1 x340;
  fiat_p384_addcarryx_u32(&x339, &x340, x338, x265, x313);
  uint32_t x341;
  uint32_t x342;
  fiat_p384_mulx_u32(&x341, &x342, x315, UINT32_C(0xffffffff));
  uint32_t x343;
  uint32_t x344;
  fiat_p384_mulx_u32(&x343, &x344, x315, UINT32_C(0xffffffff));
  uint32_t x345;
  uint32_t x346;
  fiat_p384_mulx_u32(&x345, &x346, x315, UINT32_C(0xffffffff));
  uint32_t x347;
  uint32_t x348;
  fiat_p384_mulx_u32(&x347, &x348, x315, UINT32_C(0xffffffff));
  uint32_t x349;
  uint32_t x350;
  fiat_p384_mulx_u32(&x349, &x350, x315, UINT32_C(0xffffffff));
  uint32_t x351;
  uint32_t x352;
  fiat_p384_mulx_u32(&x351, &x352, x315, UINT32_C(0xffffffff));
  uint32_t x353;
  uint32_t x354;
  fiat_p384_mulx_u32(&x353, &x354, x315, UINT32_C(0xffffffff));
  uint32_t x355;
  uint32_t x356;
  fiat_p384_mulx_u32(&x355, &x356, x315, UINT32_C(0xfffffffe));
  uint32_t x357;
  uint32_t x358;
  fiat_p384_mulx_u32(&x357, &x358, x315, UINT32_C(0xffffffff));
  uint32_t x359;
  uint32_t x360;
  fiat_p384_mulx_u32(&x359, &x360, x315, UINT32_C(0xffffffff));
  uint32_t x361;
  fiat_p384_uint1 x362;
  fiat_p384_addcarryx_u32(&x361, &x362, 0x0, x358, x355);
  uint32_t x363;
  fiat_p384_uint1 x364;
  fiat_p384_addcarryx_u32(&x363, &x364, x362, x356, x353);
  uint32_t x365;
  fiat_p384_uint1 x366;
  fiat_p384_addcarryx_u32(&x365, &x366, x364, x354, x351);
  uint32_t x367;
  fiat_p384_uint1 x368;
  fiat_p384_addcarryx_u32(&x367, &x368, x366, x352, x349);
  uint32_t x369;
  fiat_p384_uint1 x370;
  fiat_p384_addcarryx_u32(&x369, &x370, x368, x350, x347);
  uint32_t x371;
  fiat_p384_uint1 x372;
  fiat_p384_addcarryx_u32(&x371, &x372, x370, x348, x345);
  uint32_t x373;
  fiat_p384_uint1 x374;
  fiat_p384_addcarryx_u32(&x373, &x374, x372, x346, x343);
  uint32_t x375;
  fiat_p384_uint1 x376;
  fiat_p384_addcarryx_u32(&x375, &x376, x374, x344, x341);
  uint32_t x377;
  fiat_p384_uint1 x378;
  fiat_p384_addcarryx_u32(&x377, &x378, x376, x342, 0x0);
  uint32_t x379;
  fiat_p384_uint1 x380;
  fiat_p384_addcarryx_u32(&x379, &x380, 0x0, x315, x359);
  uint32_t x381;
  fiat_p384_uint1 x382;
  fiat_p384_addcarryx_u32(&x381, &x382, x380, x317, x360);
  uint32_t x383;
  fiat_p384_uint1 x384;
  fiat_p384_addcarryx_u32(&x383, &x384, x382, x319, 0x0);
  uint32_t x385;
  fiat_p384_uint1 x386;
  fiat_p384_addcarryx_u32(&x385, &x386, x384, x321, x357);
  uint32_t x387;
  fiat_p384_uint1 x388;
  fiat_p384_addcarryx_u32(&x387, &x388, x386, x323, x361);
  uint32_t x389;
  fiat_p384_uint1 x390;
  fiat_p384_addcarryx_u32(&x389, &x390, x388, x325, x363);
  uint32_t x391;
  fiat_p384_uint1 x392;
  fiat_p384_addcarryx_u32(&x391, &x392, x390, x327, x365);
  uint32_t x393;
  fiat_p384_uint1 x394;
  fiat_p384_addcarryx_u32(&x393, &x394, x392, x329, x367);
  uint32_t x395;
  fiat_p384_uint1 x396;
  fiat_p384_addcarryx_u32(&x395, &x396, x394, x331, x369);
  uint32_t x397;
  fiat_p384_uint1 x398;
  fiat_p384_addcarryx_u32(&x397, &x398, x396, x333, x371);
  uint32_t x399;
  fiat_p384_uint1 x400;
  fiat_p384_addcarryx_u32(&x399, &x400, x398, x335, x373);
  uint32_t x401;
  fiat_p384_uint1 x402;
  fiat_p384_addcarryx_u32(&x401, &x402, x400, x337, x375);
  uint32_t x403;
  fiat_p384_uint1 x404;
  fiat_p384_addcarryx_u32(&x403, &x404, x402, x339, x377);
  uint32_t x405;
  fiat_p384_uint1 x406;
  fiat_p384_addcarryx_u32(&x405, &x406, x404, x340, 0x0);
  uint32_t x407;
  uint32_t x408;
  fiat_p384_mulx_u32(&x407, &x408, x3, (arg2[11]));
  uint32_t x409;
  uint32_t x410;
  fiat_p384_mulx_u32(&x409, &x410, x3, (arg2[10]));
  uint32_t x411;
  uint32_t x412;
  fiat_p384_mulx_u32(&x411, &x412, x3, (arg2[9]));
  uint32_t x413;
  uint32_t x414;
  fiat_p384_mulx_u32(&x413, &x414, x3, (arg2[8]));
  uint32_t x415;
  uint32_t x416;
  fiat_p384_mulx_u32(&x415, &x416, x3, (arg2[7]));
  uint32_t x417;
  uint32_t x418;
  fiat_p384_mulx_u32(&x417, &x418, x3, (arg2[6]));
  uint32_t x419;
  uint32_t x420;
  fiat_p384_mulx_u32(&x419, &x420, x3, (arg2[5]));
  uint32_t x421;
  uint32_t x422;
  fiat_p384_mulx_u32(&x421, &x422, x3, (arg2[4]));
  uint32_t x423;
  uint32_t x424;
  fiat_p384_mulx_u32(&x423, &x424, x3, (arg2[3]));
  uint32_t x425;
  uint32_t x426;
  fiat_p384_mulx_u32(&x425, &x426, x3, (arg2[2]));
  uint32_t x427;
  uint32_t x428;
  fiat_p384_mulx_u32(&x427, &x428, x3, (arg2[1]));
  uint32_t x429;
  uint32_t x430;
  fiat_p384_mulx_u32(&x429, &x430, x3, (arg2[0]));
  uint32_t x431;
  fiat_p384_uint1 x432;
  fiat_p384_addcarryx_u32(&x431, &x432, 0x0, x430, x427);
  uint32_t x433;
  fiat_p384_uint1 x434;
  fiat_p384_addcarryx_u32(&x433, &x434, x432, x428, x425);
  uint32_t x435;
  fiat_p384_uint1 x436;
  fiat_p384_addcarryx_u32(&x435, &x436, x434, x426, x423);
  uint32_t x437;
  fiat_p384_uint1 x438;
  fiat_p384_addcarryx_u32(&x437, &x438, x436, x424, x421);
  uint32_t x439;
  fiat_p384_uint1 x440;
  fiat_p384_addcarryx_u32(&x439, &x440, x438, x422, x419);
  uint32_t x441;
  fiat_p384_uint1 x442;
  fiat_p384_addcarryx_u32(&x441, &x442, x440, x420, x417);
  uint32_t x443;
  fiat_p384_uint1 x444;
  fiat_p384_addcarryx_u32(&x443, &x444, x442, x418, x415);
  uint32_t x445;
  fiat_p384_uint1 x446;
  fiat_p384_addcarryx_u32(&x445, &x446, x444, x416, x413);
  uint32_t x447;
  fiat_p384_uint1 x448;
  fiat_p384_addcarryx_u32(&x447, &x448, x446, x414, x411);
  uint32_t x449;
  fiat_p384_uint1 x450;
  fiat_p384_addcarryx_u32(&x449, &x450, x448, x412, x409);
  uint32_t x451;
  fiat_p384_uint1 x452;
  fiat_p384_addcarryx_u32(&x451, &x452, x450, x410, x407);
  uint32_t x453;
  fiat_p384_uint1 x454;
  fiat_p384_addcarryx_u32(&x453, &x454, x452, x408, 0x0);
  uint32_t x455;
  fiat_p384_uint1 x456;
  fiat_p384_addcarryx_u32(&x455, &x456, 0x0, x381, x429);
  uint32_t x457;
  fiat_p384_uint1 x458;
  fiat_p384_addcarryx_u32(&x457, &x458, x456, x383, x431);
  uint32_t x459;
  fiat_p384_uint1 x460;
  fiat_p384_addcarryx_u32(&x459, &x460, x458, x385, x433);
  uint32_t x461;
  fiat_p384_uint1 x462;
  fiat_p384_addcarryx_u32(&x461, &x462, x460, x387, x435);
  uint32_t x463;
  fiat_p384_uint1 x464;
  fiat_p384_addcarryx_u32(&x463, &x464, x462, x389, x437);
  uint32_t x465;
  fiat_p384_uint1 x466;
  fiat_p384_addcarryx_u32(&x465, &x466, x464, x391, x439);
  uint32_t x467;
  fiat_p384_uint1 x468;
  fiat_p384_addcarryx_u32(&x467, &x468, x466, x393, x441);
  uint32_t x469;
  fiat_p384_uint1 x470;
  fiat_p384_addcarryx_u32(&x469, &x470, x468, x395, x443);
  uint32_t x471;
  fiat_p384_uint1 x472;
  fiat_p384_addcarryx_u32(&x471, &x472, x470, x397, x445);
  uint32_t x473;
  fiat_p384_uint1 x474;
  fiat_p384_addcarryx_u32(&x473, &x474, x472, x399, x447);
  uint32_t x475;
  fiat_p384_uint1 x476;
  fiat_p384_addcarryx_u32(&x475, &x476, x474, x401, x449);
  uint32_t x477;
  fiat_p384_uint1 x478;
  fiat_p384_addcarryx_u32(&x477, &x478, x476, x403, x451);
  uint32_t x479;
  fiat_p384_uint1 x480;
  fiat_p384_addcarryx_u32(&x479, &x480, x478, x405, x453);
  uint32_t x481;
  uint32_t x482;
  fiat_p384_mulx_u32(&x481, &x482, x455, UINT32_C(0xffffffff));
  uint32_t x483;
  uint32_t x484;
  fiat_p384_mulx_u32(&x483, &x484, x455, UINT32_C(0xffffffff));
  uint32_t x485;
  uint32_t x486;
  fiat_p384_mulx_u32(&x485, &x486, x455, UINT32_C(0xffffffff));
  uint32_t x487;
  uint32_t x488;
  fiat_p384_mulx_u32(&x487, &x488, x455, UINT32_C(0xffffffff));
  uint32_t x489;
  uint32_t x490;
  fiat_p384_mulx_u32(&x489, &x490, x455, UINT32_C(0xffffffff));
  uint32_t x491;
  uint32_t x492;
  fiat_p384_mulx_u32(&x491, &x492, x455, UINT32_C(0xffffffff));
  uint32_t x493;
  uint32_t x494;
  fiat_p384_mulx_u32(&x493, &x494, x455, UINT32_C(0xffffffff));
  uint32_t x495;
  uint32_t x496;
  fiat_p384_mulx_u32(&x495, &x496, x455, UINT32_C(0xfffffffe));
  uint32_t x497;
  uint32_t x498;
  fiat_p384_mulx_u32(&x497, &x498, x455, UINT32_C(0xffffffff));
  uint32_t x499;
  uint32_t x500;
  fiat_p384_mulx_u32(&x499, &x500, x455, UINT32_C(0xffffffff));
  uint32_t x501;
  fiat_p384_uint1 x502;
  fiat_p384_addcarryx_u32(&x501, &x502, 0x0, x498, x495);
  uint32_t x503;
  fiat_p384_uint1 x504;
  fiat_p384_addcarryx_u32(&x503, &x504, x502, x496, x493);
  uint32_t x505;
  fiat_p384_uint1 x506;
  fiat_p384_addcarryx_u32(&x505, &x506, x504, x494, x491);
  uint32_t x507;
  fiat_p384_uint1 x508;
  fiat_p384_addcarryx_u32(&x507, &x508, x506, x492, x489);
  uint32_t x509;
  fiat_p384_uint1 x510;
  fiat_p384_addcarryx_u32(&x509, &x510, x508, x490, x487);
  uint32_t x511;
  fiat_p384_uint1 x512;
  fiat_p384_addcarryx_u32(&x511, &x512, x510, x488, x485);
  uint32_t x513;
  fiat_p384_uint1 x514;
  fiat_p384_addcarryx_u32(&x513, &x514, x512, x486, x483);
  uint32_t x515;
  fiat_p384_uint1 x516;
  fiat_p384_addcarryx_u32(&x515, &x516, x514, x484, x481);
  uint32_t x517;
  fiat_p384_uint1 x518;
  fiat_p384_addcarryx_u32(&x517, &x518, x516, x482, 0x0);
  uint32_t x519;
  fiat_p384_uint1 x520;
  fiat_p384_addcarryx_u32(&x519, &x520, 0x0, x455, x499);
  uint32_t x521;
  fiat_p384_uint1 x522;
  fiat_p384_addcarryx_u32(&x521, &x522, x520, x457, x500);
  uint32_t x523;
  fiat_p384_uint1 x524;
  fiat_p384_addcarryx_u32(&x523, &x524, x522, x459, 0x0);
  uint32_t x525;
  fiat_p384_uint1 x526;
  fiat_p384_addcarryx_u32(&x525, &x526, x524, x461, x497);
  uint32_t x527;
  fiat_p384_uint1 x528;
  fiat_p384_addcarryx_u32(&x527, &x528, x526, x463, x501);
  uint32_t x529;
  fiat_p384_uint1 x530;
  fiat_p384_addcarryx_u32(&x529, &x530, x528, x465, x503);
  uint32_t x531;
  fiat_p384_uint1 x532;
  fiat_p384_addcarryx_u32(&x531, &x532, x530, x467, x505);
  uint32_t x533;
  fiat_p384_uint1 x534;
  fiat_p384_addcarryx_u32(&x533, &x534, x532, x469, x507);
  uint32_t x535;
  fiat_p384_uint1 x536;
  fiat_p384_addcarryx_u32(&x535, &x536, x534, x471, x509);
  uint32_t x537;
  fiat_p384_uint1 x538;
  fiat_p384_addcarryx_u32(&x537, &x538, x536, x473, x511);
  uint32_t x539;
  fiat_p384_uint1 x540;
  fiat_p384_addcarryx_u32(&x539, &x540, x538, x475, x513);
  uint32_t x541;
  fiat_p384_uint1 x542;
  fiat_p384_addcarryx_u32(&x541, &x542, x540, x477, x515);
  uint32_t x543;
  fiat_p384_uint1 x544;
  fiat_p384_addcarryx_u32(&x543, &x544, x542, x479, x517);
  uint32_t x545;
  fiat_p384_uint1 x546;
  fiat_p384_addcarryx_u32(&x545, &x546, x544, x480, 0x0);
  uint32_t x547;
  uint32_t x548;
  fiat_p384_mulx_u32(&x547, &x548, x4, (arg2[11]));
  uint32_t x549;
  uint32_t x550;
  fiat_p384_mulx_u32(&x549, &x550, x4, (arg2[10]));
  uint32_t x551;
  uint32_t x552;
  fiat_p384_mulx_u32(&x551, &x552, x4, (arg2[9]));
  uint32_t x553;
  uint32_t x554;
  fiat_p384_mulx_u32(&x553, &x554, x4, (arg2[8]));
  uint32_t x555;
  uint32_t x556;
  fiat_p384_mulx_u32(&x555, &x556, x4, (arg2[7]));
  uint32_t x557;
  uint32_t x558;
  fiat_p384_mulx_u32(&x557, &x558, x4, (arg2[6]));
  uint32_t x559;
  uint32_t x560;
  fiat_p384_mulx_u32(&x559, &x560, x4, (arg2[5]));
  uint32_t x561;
  uint32_t x562;
  fiat_p384_mulx_u32(&x561, &x562, x4, (arg2[4]));
  uint32_t x563;
  uint32_t x564;
  fiat_p384_mulx_u32(&x563, &x564, x4, (arg2[3]));
  uint32_t x565;
  uint32_t x566;
  fiat_p384_mulx_u32(&x565, &x566, x4, (arg2[2]));
  uint32_t x567;
  uint32_t x568;
  fiat_p384_mulx_u32(&x567, &x568, x4, (arg2[1]));
  uint32_t x569;
  uint32_t x570;
  fiat_p384_mulx_u32(&x569, &x570, x4, (arg2[0]));
  uint32_t x571;
  fiat_p384_uint1 x572;
  fiat_p384_addcarryx_u32(&x571, &x572, 0x0, x570, x567);
  uint32_t x573;
  fiat_p384_uint1 x574;
  fiat_p384_addcarryx_u32(&x573, &x574, x572, x568, x565);
  uint32_t x575;
  fiat_p384_uint1 x576;
  fiat_p384_addcarryx_u32(&x575, &x576, x574, x566, x563);
  uint32_t x577;
  fiat_p384_uint1 x578;
  fiat_p384_addcarryx_u32(&x577, &x578, x576, x564, x561);
  uint32_t x579;
  fiat_p384_uint1 x580;
  fiat_p384_addcarryx_u32(&x579, &x580, x578, x562, x559);
  uint32_t x581;
  fiat_p384_uint1 x582;
  fiat_p384_addcarryx_u32(&x581, &x582, x580, x560, x557);
  uint32_t x583;
  fiat_p384_uint1 x584;
  fiat_p384_addcarryx_u32(&x583, &x584, x582, x558, x555);
  uint32_t x585;
  fiat_p384_uint1 x586;
  fiat_p384_addcarryx_u32(&x585, &x586, x584, x556, x553);
  uint32_t x587;
  fiat_p384_uint1 x588;
  fiat_p384_addcarryx_u32(&x587, &x588, x586, x554, x551);
  uint32_t x589;
  fiat_p384_uint1 x590;
  fiat_p384_addcarryx_u32(&x589, &x590, x588, x552, x549);
  uint32_t x591;
  fiat_p384_uint1 x592;
  fiat_p384_addcarryx_u32(&x591, &x592, x590, x550, x547);
  uint32_t x593;
  fiat_p384_uint1 x594;
  fiat_p384_addcarryx_u32(&x593, &x594, x592, x548, 0x0);
  uint32_t x595;
  fiat_p384_uint1 x596;
  fiat_p384_addcarryx_u32(&x595, &x596, 0x0, x521, x569);
  uint32_t x597;
  fiat_p384_uint1 x598;
  fiat_p384_addcarryx_u32(&x597, &x598, x596, x523, x571);
  uint32_t x599;
  fiat_p384_uint1 x600;
  fiat_p384_addcarryx_u32(&x599, &x600, x598, x525, x573);
  uint32_t x601;
  fiat_p384_uint1 x602;
  fiat_p384_addcarryx_u32(&x601, &x602, x600, x527, x575);
  uint32_t x603;
  fiat_p384_uint1 x604;
  fiat_p384_addcarryx_u32(&x603, &x604, x602, x529, x577);
  uint32_t x605;
  fiat_p384_uint1 x606;
  fiat_p384_addcarryx_u32(&x605, &x606, x604, x531, x579);
  uint32_t x607;
  fiat_p384_uint1 x608;
  fiat_p384_addcarryx_u32(&x607, &x608, x606, x533, x581);
  uint32_t x609;
  fiat_p384_uint1 x610;
  fiat_p384_addcarryx_u32(&x609, &x610, x608, x535, x583);
  uint32_t x611;
  fiat_p384_uint1 x612;
  fiat_p384_addcarryx_u32(&x611, &x612, x610, x537, x585);
  uint32_t x613;
  fiat_p384_uint1 x614;
  fiat_p384_addcarryx_u32(&x613, &x614, x612, x539, x587);
  uint32_t x615;
  fiat_p384_uint1 x616;
  fiat_p384_addcarryx_u32(&x615, &x616, x614, x541, x589);
  uint32_t x617;
  fiat_p384_uint1 x618;
  fiat_p384_addcarryx_u32(&x617, &x618, x616, x543, x591);
  uint32_t x619;
  fiat_p384_uint1 x620;
  fiat_p384_addcarryx_u32(&x619, &x620, x618, x545, x593);
  uint32_t x621;
  uint32_t x622;
  fiat_p384_mulx_u32(&x621, &x622, x595, UINT32_C(0xffffffff));
  uint32_t x623;
  uint32_t x624;
  fiat_p384_mulx_u32(&x623, &x624, x595, UINT32_C(0xffffffff));
  uint32_t x625;
  uint32_t x626;
  fiat_p384_mulx_u32(&x625, &x626, x595, UINT32_C(0xffffffff));
  uint32_t x627;
  uint32_t x628;
  fiat_p384_mulx_u32(&x627, &x628, x595, UINT32_C(0xffffffff));
  uint32_t x629;
  uint32_t x630;
  fiat_p384_mulx_u32(&x629, &x630, x595, UINT32_C(0xffffffff));
  uint32_t x631;
  uint32_t x632;
  fiat_p384_mulx_u32(&x631, &x632, x595, UINT32_C(0xffffffff));
  uint32_t x633;
  uint32_t x634;
  fiat_p384_mulx_u32(&x633, &x634, x595, UINT32_C(0xffffffff));
  uint32_t x635;
  uint32_t x636;
  fiat_p384_mulx_u32(&x635, &x636, x595, UINT32_C(0xfffffffe));
  uint32_t x637;
  uint32_t x638;
  fiat_p384_mulx_u32(&x637, &x638, x595, UINT32_C(0xffffffff));
  uint32_t x639;
  uint32_t x640;
  fiat_p384_mulx_u32(&x639, &x640, x595, UINT32_C(0xffffffff));
  uint32_t x641;
  fiat_p384_uint1 x642;
  fiat_p384_addcarryx_u32(&x641, &x642, 0x0, x638, x635);
  uint32_t x643;
  fiat_p384_uint1 x644;
  fiat_p384_addcarryx_u32(&x643, &x644, x642, x636, x633);
  uint32_t x645;
  fiat_p384_uint1 x646;
  fiat_p384_addcarryx_u32(&x645, &x646, x644, x634, x631);
  uint32_t x647;
  fiat_p384_uint1 x648;
  fiat_p384_addcarryx_u32(&x647, &x648, x646, x632, x629);
  uint32_t x649;
  fiat_p384_uint1 x650;
  fiat_p384_addcarryx_u32(&x649, &x650, x648, x630, x627);
  uint32_t x651;
  fiat_p384_uint1 x652;
  fiat_p384_addcarryx_u32(&x651, &x652, x650, x628, x625);
  uint32_t x653;
  fiat_p384_uint1 x654;
  fiat_p384_addcarryx_u32(&x653, &x654, x652, x626, x623);
  uint32_t x655;
  fiat_p384_uint1 x656;
  fiat_p384_addcarryx_u32(&x655, &x656, x654, x624, x621);
  uint32_t x657;
  fiat_p384_uint1 x658;
  fiat_p384_addcarryx_u32(&x657, &x658, x656, x622, 0x0);
  uint32_t x659;
  fiat_p384_uint1 x660;
  fiat_p384_addcarryx_u32(&x659, &x660, 0x0, x595, x639);
  uint32_t x661;
  fiat_p384_uint1 x662;
  fiat_p384_addcarryx_u32(&x661, &x662, x660, x597, x640);
  uint32_t x663;
  fiat_p384_uint1 x664;
  fiat_p384_addcarryx_u32(&x663, &x664, x662, x599, 0x0);
  uint32_t x665;
  fiat_p384_uint1 x666;
  fiat_p384_addcarryx_u32(&x665, &x666, x664, x601, x637);
  uint32_t x667;
  fiat_p384_uint1 x668;
  fiat_p384_addcarryx_u32(&x667, &x668, x666, x603, x641);
  uint32_t x669;
  fiat_p384_uint1 x670;
  fiat_p384_addcarryx_u32(&x669, &x670, x668, x605, x643);
  uint32_t x671;
  fiat_p384_uint1 x672;
  fiat_p384_addcarryx_u32(&x671, &x672, x670, x607, x645);
  uint32_t x673;
  fiat_p384_uint1 x674;
  fiat_p384_addcarryx_u32(&x673, &x674, x672, x609, x647);
  uint32_t x675;
  fiat_p384_uint1 x676;
  fiat_p384_addcarryx_u32(&x675, &x676, x674, x611, x649);
  uint32_t x677;
  fiat_p384_uint1 x678;
  fiat_p384_addcarryx_u32(&x677, &x678, x676, x613, x651);
  uint32_t x679;
  fiat_p384_uint1 x680;
  fiat_p384_addcarryx_u32(&x679, &x680, x678, x615, x653);
  uint32_t x681;
  fiat_p384_uint1 x682;
  fiat_p384_addcarryx_u32(&x681, &x682, x680, x617, x655);
  uint32_t x683;
  fiat_p384_uint1 x684;
  fiat_p384_addcarryx_u32(&x683, &x684, x682, x619, x657);
  uint32_t x685;
  fiat_p384_uint1 x686;
  fiat_p384_addcarryx_u32(&x685, &x686, x684, x620, 0x0);
  uint32_t x687;
  uint32_t x688;
  fiat_p384_mulx_u32(&x687, &x688, x5, (arg2[11]));
  uint32_t x689;
  uint32_t x690;
  fiat_p384_mulx_u32(&x689, &x690, x5, (arg2[10]));
  uint32_t x691;
  uint32_t x692;
  fiat_p384_mulx_u32(&x691, &x692, x5, (arg2[9]));
  uint32_t x693;
  uint32_t x694;
  fiat_p384_mulx_u32(&x693, &x694, x5, (arg2[8]));
  uint32_t x695;
  uint32_t x696;
  fiat_p384_mulx_u32(&x695, &x696, x5, (arg2[7]));
  uint32_t x697;
  uint32_t x698;
  fiat_p384_mulx_u32(&x697, &x698, x5, (arg2[6]));
  uint32_t x699;
  uint32_t x700;
  fiat_p384_mulx_u32(&x699, &x700, x5, (arg2[5]));
  uint32_t x701;
  uint32_t x702;
  fiat_p384_mulx_u32(&x701, &x702, x5, (arg2[4]));
  uint32_t x703;
  uint32_t x704;
  fiat_p384_mulx_u32(&x703, &x704, x5, (arg2[3]));
  uint32_t x705;
  uint32_t x706;
  fiat_p384_mulx_u32(&x705, &x706, x5, (arg2[2]));
  uint32_t x707;
  uint32_t x708;
  fiat_p384_mulx_u32(&x707, &x708, x5, (arg2[1]));
  uint32_t x709;
  uint32_t x710;
  fiat_p384_mulx_u32(&x709, &x710, x5, (arg2[0]));
  uint32_t x711;
  fiat_p384_uint1 x712;
  fiat_p384_addcarryx_u32(&x711, &x712, 0x0, x710, x707);
  uint32_t x713;
  fiat_p384_uint1 x714;
  fiat_p384_addcarryx_u32(&x713, &x714, x712, x708, x705);
  uint32_t x715;
  fiat_p384_uint1 x716;
  fiat_p384_addcarryx_u32(&x715, &x716, x714, x706, x703);
  uint32_t x717;
  fiat_p384_uint1 x718;
  fiat_p384_addcarryx_u32(&x717, &x718, x716, x704, x701);
  uint32_t x719;
  fiat_p384_uint1 x720;
  fiat_p384_addcarryx_u32(&x719, &x720, x718, x702, x699);
  uint32_t x721;
  fiat_p384_uint1 x722;
  fiat_p384_addcarryx_u32(&x721, &x722, x720, x700, x697);
  uint32_t x723;
  fiat_p384_uint1 x724;
  fiat_p384_addcarryx_u32(&x723, &x724, x722, x698, x695);
  uint32_t x725;
  fiat_p384_uint1 x726;
  fiat_p384_addcarryx_u32(&x725, &x726, x724, x696, x693);
  uint32_t x727;
  fiat_p384_uint1 x728;
  fiat_p384_addcarryx_u32(&x727, &x728, x726, x694, x691);
  uint32_t x729;
  fiat_p384_uint1 x730;
  fiat_p384_addcarryx_u32(&x729, &x730, x728, x692, x689);
  uint32_t x731;
  fiat_p384_uint1 x732;
  fiat_p384_addcarryx_u32(&x731, &x732, x730, x690, x687);
  uint32_t x733;
  fiat_p384_uint1 x734;
  fiat_p384_addcarryx_u32(&x733, &x734, x732, x688, 0x0);
  uint32_t x735;
  fiat_p384_uint1 x736;
  fiat_p384_addcarryx_u32(&x735, &x736, 0x0, x661, x709);
  uint32_t x737;
  fiat_p384_uint1 x738;
  fiat_p384_addcarryx_u32(&x737, &x738, x736, x663, x711);
  uint32_t x739;
  fiat_p384_uint1 x740;
  fiat_p384_addcarryx_u32(&x739, &x740, x738, x665, x713);
  uint32_t x741;
  fiat_p384_uint1 x742;
  fiat_p384_addcarryx_u32(&x741, &x742, x740, x667, x715);
  uint32_t x743;
  fiat_p384_uint1 x744;
  fiat_p384_addcarryx_u32(&x743, &x744, x742, x669, x717);
  uint32_t x745;
  fiat_p384_uint1 x746;
  fiat_p384_addcarryx_u32(&x745, &x746, x744, x671, x719);
  uint32_t x747;
  fiat_p384_uint1 x748;
  fiat_p384_addcarryx_u32(&x747, &x748, x746, x673, x721);
  uint32_t x749;
  fiat_p384_uint1 x750;
  fiat_p384_addcarryx_u32(&x749, &x750, x748, x675, x723);
  uint32_t x751;
  fiat_p384_uint1 x752;
  fiat_p384_addcarryx_u32(&x751, &x752, x750, x677, x725);
  uint32_t x753;
  fiat_p384_uint1 x754;
  fiat_p384_addcarryx_u32(&x753, &x754, x752, x679, x727);
  uint32_t x755;
  fiat_p384_uint1 x756;
  fiat_p384_addcarryx_u32(&x755, &x756, x754, x681, x729);
  uint32_t x757;
  fiat_p384_uint1 x758;
  fiat_p384_addcarryx_u32(&x757, &x758, x756, x683, x731);
  uint32_t x759;
  fiat_p384_uint1 x760;
  fiat_p384_addcarryx_u32(&x759, &x760, x758, x685, x733);
  uint32_t x761;
  uint32_t x762;
  fiat_p384_mulx_u32(&x761, &x762, x735, UINT32_C(0xffffffff));
  uint32_t x763;
  uint32_t x764;
  fiat_p384_mulx_u32(&x763, &x764, x735, UINT32_C(0xffffffff));
  uint32_t x765;
  uint32_t x766;
  fiat_p384_mulx_u32(&x765, &x766, x735, UINT32_C(0xffffffff));
  uint32_t x767;
  uint32_t x768;
  fiat_p384_mulx_u32(&x767, &x768, x735, UINT32_C(0xffffffff));
  uint32_t x769;
  uint32_t x770;
  fiat_p384_mulx_u32(&x769, &x770, x735, UINT32_C(0xffffffff));
  uint32_t x771;
  uint32_t x772;
  fiat_p384_mulx_u32(&x771, &x772, x735, UINT32_C(0xffffffff));
  uint32_t x773;
  uint32_t x774;
  fiat_p384_mulx_u32(&x773, &x774, x735, UINT32_C(0xffffffff));
  uint32_t x775;
  uint32_t x776;
  fiat_p384_mulx_u32(&x775, &x776, x735, UINT32_C(0xfffffffe));
  uint32_t x777;
  uint32_t x778;
  fiat_p384_mulx_u32(&x777, &x778, x735, UINT32_C(0xffffffff));
  uint32_t x779;
  uint32_t x780;
  fiat_p384_mulx_u32(&x779, &x780, x735, UINT32_C(0xffffffff));
  uint32_t x781;
  fiat_p384_uint1 x782;
  fiat_p384_addcarryx_u32(&x781, &x782, 0x0, x778, x775);
  uint32_t x783;
  fiat_p384_uint1 x784;
  fiat_p384_addcarryx_u32(&x783, &x784, x782, x776, x773);
  uint32_t x785;
  fiat_p384_uint1 x786;
  fiat_p384_addcarryx_u32(&x785, &x786, x784, x774, x771);
  uint32_t x787;
  fiat_p384_uint1 x788;
  fiat_p384_addcarryx_u32(&x787, &x788, x786, x772, x769);
  uint32_t x789;
  fiat_p384_uint1 x790;
  fiat_p384_addcarryx_u32(&x789, &x790, x788, x770, x767);
  uint32_t x791;
  fiat_p384_uint1 x792;
  fiat_p384_addcarryx_u32(&x791, &x792, x790, x768, x765);
  uint32_t x793;
  fiat_p384_uint1 x794;
  fiat_p384_addcarryx_u32(&x793, &x794, x792, x766, x763);
  uint32_t x795;
  fiat_p384_uint1 x796;
  fiat_p384_addcarryx_u32(&x795, &x796, x794, x764, x761);
  uint32_t x797;
  fiat_p384_uint1 x798;
  fiat_p384_addcarryx_u32(&x797, &x798, x796, x762, 0x0);
  uint32_t x799;
  fiat_p384_uint1 x800;
  fiat_p384_addcarryx_u32(&x799, &x800, 0x0, x735, x779);
  uint32_t x801;
  fiat_p384_uint1 x802;
  fiat_p384_addcarryx_u32(&x801, &x802, x800, x737, x780);
  uint32_t x803;
  fiat_p384_uint1 x804;
  fiat_p384_addcarryx_u32(&x803, &x804, x802, x739, 0x0);
  uint32_t x805;
  fiat_p384_uint1 x806;
  fiat_p384_addcarryx_u32(&x805, &x806, x804, x741, x777);
  uint32_t x807;
  fiat_p384_uint1 x808;
  fiat_p384_addcarryx_u32(&x807, &x808, x806, x743, x781);
  uint32_t x809;
  fiat_p384_uint1 x810;
  fiat_p384_addcarryx_u32(&x809, &x810, x808, x745, x783);
  uint32_t x811;
  fiat_p384_uint1 x812;
  fiat_p384_addcarryx_u32(&x811, &x812, x810, x747, x785);
  uint32_t x813;
  fiat_p384_uint1 x814;
  fiat_p384_addcarryx_u32(&x813, &x814, x812, x749, x787);
  uint32_t x815;
  fiat_p384_uint1 x816;
  fiat_p384_addcarryx_u32(&x815, &x816, x814, x751, x789);
  uint32_t x817;
  fiat_p384_uint1 x818;
  fiat_p384_addcarryx_u32(&x817, &x818, x816, x753, x791);
  uint32_t x819;
  fiat_p384_uint1 x820;
  fiat_p384_addcarryx_u32(&x819, &x820, x818, x755, x793);
  uint32_t x821;
  fiat_p384_uint1 x822;
  fiat_p384_addcarryx_u32(&x821, &x822, x820, x757, x795);
  uint32_t x823;
  fiat_p384_uint1 x824;
  fiat_p384_addcarryx_u32(&x823, &x824, x822, x759, x797);
  uint32_t x825;
  fiat_p384_uint1 x826;
  fiat_p384_addcarryx_u32(&x825, &x826, x824, x760, 0x0);
  uint32_t x827;
  uint32_t x828;
  fiat_p384_mulx_u32(&x827, &x828, x6, (arg2[11]));
  uint32_t x829;
  uint32_t x830;
  fiat_p384_mulx_u32(&x829, &x830, x6, (arg2[10]));
  uint32_t x831;
  uint32_t x832;
  fiat_p384_mulx_u32(&x831, &x832, x6, (arg2[9]));
  uint32_t x833;
  uint32_t x834;
  fiat_p384_mulx_u32(&x833, &x834, x6, (arg2[8]));
  uint32_t x835;
  uint32_t x836;
  fiat_p384_mulx_u32(&x835, &x836, x6, (arg2[7]));
  uint32_t x837;
  uint32_t x838;
  fiat_p384_mulx_u32(&x837, &x838, x6, (arg2[6]));
  uint32_t x839;
  uint32_t x840;
  fiat_p384_mulx_u32(&x839, &x840, x6, (arg2[5]));
  uint32_t x841;
  uint32_t x842;
  fiat_p384_mulx_u32(&x841, &x842, x6, (arg2[4]));
  uint32_t x843;
  uint32_t x844;
  fiat_p384_mulx_u32(&x843, &x844, x6, (arg2[3]));
  uint32_t x845;
  uint32_t x846;
  fiat_p384_mulx_u32(&x845, &x846, x6, (arg2[2]));
  uint32_t x847;
  uint32_t x848;
  fiat_p384_mulx_u32(&x847, &x848, x6, (arg2[1]));
  uint32_t x849;
  uint32_t x850;
  fiat_p384_mulx_u32(&x849, &x850, x6, (arg2[0]));
  uint32_t x851;
  fiat_p384_uint1 x852;
  fiat_p384_addcarryx_u32(&x851, &x852, 0x0, x850, x847);
  uint32_t x853;
  fiat_p384_uint1 x854;
  fiat_p384_addcarryx_u32(&x853, &x854, x852, x848, x845);
  uint32_t x855;
  fiat_p384_uint1 x856;
  fiat_p384_addcarryx_u32(&x855, &x856, x854, x846, x843);
  uint32_t x857;
  fiat_p384_uint1 x858;
  fiat_p384_addcarryx_u32(&x857, &x858, x856, x844, x841);
  uint32_t x859;
  fiat_p384_uint1 x860;
  fiat_p384_addcarryx_u32(&x859, &x860, x858, x842, x839);
  uint32_t x861;
  fiat_p384_uint1 x862;
  fiat_p384_addcarryx_u32(&x861, &x862, x860, x840, x837);
  uint32_t x863;
  fiat_p384_uint1 x864;
  fiat_p384_addcarryx_u32(&x863, &x864, x862, x838, x835);
  uint32_t x865;
  fiat_p384_uint1 x866;
  fiat_p384_addcarryx_u32(&x865, &x866, x864, x836, x833);
  uint32_t x867;
  fiat_p384_uint1 x868;
  fiat_p384_addcarryx_u32(&x867, &x868, x866, x834, x831);
  uint32_t x869;
  fiat_p384_uint1 x870;
  fiat_p384_addcarryx_u32(&x869, &x870, x868, x832, x829);
  uint32_t x871;
  fiat_p384_uint1 x872;
  fiat_p384_addcarryx_u32(&x871, &x872, x870, x830, x827);
  uint32_t x873;
  fiat_p384_uint1 x874;
  fiat_p384_addcarryx_u32(&x873, &x874, x872, x828, 0x0);
  uint32_t x875;
  fiat_p384_uint1 x876;
  fiat_p384_addcarryx_u32(&x875, &x876, 0x0, x801, x849);
  uint32_t x877;
  fiat_p384_uint1 x878;
  fiat_p384_addcarryx_u32(&x877, &x878, x876, x803, x851);
  uint32_t x879;
  fiat_p384_uint1 x880;
  fiat_p384_addcarryx_u32(&x879, &x880, x878, x805, x853);
  uint32_t x881;
  fiat_p384_uint1 x882;
  fiat_p384_addcarryx_u32(&x881, &x882, x880, x807, x855);
  uint32_t x883;
  fiat_p384_uint1 x884;
  fiat_p384_addcarryx_u32(&x883, &x884, x882, x809, x857);
  uint32_t x885;
  fiat_p384_uint1 x886;
  fiat_p384_addcarryx_u32(&x885, &x886, x884, x811, x859);
  uint32_t x887;
  fiat_p384_uint1 x888;
  fiat_p384_addcarryx_u32(&x887, &x888, x886, x813, x861);
  uint32_t x889;
  fiat_p384_uint1 x890;
  fiat_p384_addcarryx_u32(&x889, &x890, x888, x815, x863);
  uint32_t x891;
  fiat_p384_uint1 x892;
  fiat_p384_addcarryx_u32(&x891, &x892, x890, x817, x865);
  uint32_t x893;
  fiat_p384_uint1 x894;
  fiat_p384_addcarryx_u32(&x893, &x894, x892, x819, x867);
  uint32_t x895;
  fiat_p384_uint1 x896;
  fiat_p384_addcarryx_u32(&x895, &x896, x894, x821, x869);
  uint32_t x897;
  fiat_p384_uint1 x898;
  fiat_p384_addcarryx_u32(&x897, &x898, x896, x823, x871);
  uint32_t x899;
  fiat_p384_uint1 x900;
  fiat_p384_addcarryx_u32(&x899, &x900, x898, x825, x873);
  uint32_t x901;
  uint32_t x902;
  fiat_p384_mulx_u32(&x901, &x902, x875, UINT32_C(0xffffffff));
  uint32_t x903;
  uint32_t x904;
  fiat_p384_mulx_u32(&x903, &x904, x875, UINT32_C(0xffffffff));
  uint32_t x905;
  uint32_t x906;
  fiat_p384_mulx_u32(&x905, &x906, x875, UINT32_C(0xffffffff));
  uint32_t x907;
  uint32_t x908;
  fiat_p384_mulx_u32(&x907, &x908, x875, UINT32_C(0xffffffff));
  uint32_t x909;
  uint32_t x910;
  fiat_p384_mulx_u32(&x909, &x910, x875, UINT32_C(0xffffffff));
  uint32_t x911;
  uint32_t x912;
  fiat_p384_mulx_u32(&x911, &x912, x875, UINT32_C(0xffffffff));
  uint32_t x913;
  uint32_t x914;
  fiat_p384_mulx_u32(&x913, &x914, x875, UINT32_C(0xffffffff));
  uint32_t x915;
  uint32_t x916;
  fiat_p384_mulx_u32(&x915, &x916, x875, UINT32_C(0xfffffffe));
  uint32_t x917;
  uint32_t x918;
  fiat_p384_mulx_u32(&x917, &x918, x875, UINT32_C(0xffffffff));
  uint32_t x919;
  uint32_t x920;
  fiat_p384_mulx_u32(&x919, &x920, x875, UINT32_C(0xffffffff));
  uint32_t x921;
  fiat_p384_uint1 x922;
  fiat_p384_addcarryx_u32(&x921, &x922, 0x0, x918, x915);
  uint32_t x923;
  fiat_p384_uint1 x924;
  fiat_p384_addcarryx_u32(&x923, &x924, x922, x916, x913);
  uint32_t x925;
  fiat_p384_uint1 x926;
  fiat_p384_addcarryx_u32(&x925, &x926, x924, x914, x911);
  uint32_t x927;
  fiat_p384_uint1 x928;
  fiat_p384_addcarryx_u32(&x927, &x928, x926, x912, x909);
  uint32_t x929;
  fiat_p384_uint1 x930;
  fiat_p384_addcarryx_u32(&x929, &x930, x928, x910, x907);
  uint32_t x931;
  fiat_p384_uint1 x932;
  fiat_p384_addcarryx_u32(&x931, &x932, x930, x908, x905);
  uint32_t x933;
  fiat_p384_uint1 x934;
  fiat_p384_addcarryx_u32(&x933, &x934, x932, x906, x903);
  uint32_t x935;
  fiat_p384_uint1 x936;
  fiat_p384_addcarryx_u32(&x935, &x936, x934, x904, x901);
  uint32_t x937;
  fiat_p384_uint1 x938;
  fiat_p384_addcarryx_u32(&x937, &x938, x936, x902, 0x0);
  uint32_t x939;
  fiat_p384_uint1 x940;
  fiat_p384_addcarryx_u32(&x939, &x940, 0x0, x875, x919);
  uint32_t x941;
  fiat_p384_uint1 x942;
  fiat_p384_addcarryx_u32(&x941, &x942, x940, x877, x920);
  uint32_t x943;
  fiat_p384_uint1 x944;
  fiat_p384_addcarryx_u32(&x943, &x944, x942, x879, 0x0);
  uint32_t x945;
  fiat_p384_uint1 x946;
  fiat_p384_addcarryx_u32(&x945, &x946, x944, x881, x917);
  uint32_t x947;
  fiat_p384_uint1 x948;
  fiat_p384_addcarryx_u32(&x947, &x948, x946, x883, x921);
  uint32_t x949;
  fiat_p384_uint1 x950;
  fiat_p384_addcarryx_u32(&x949, &x950, x948, x885, x923);
  uint32_t x951;
  fiat_p384_uint1 x952;
  fiat_p384_addcarryx_u32(&x951, &x952, x950, x887, x925);
  uint32_t x953;
  fiat_p384_uint1 x954;
  fiat_p384_addcarryx_u32(&x953, &x954, x952, x889, x927);
  uint32_t x955;
  fiat_p384_uint1 x956;
  fiat_p384_addcarryx_u32(&x955, &x956, x954, x891, x929);
  uint32_t x957;
  fiat_p384_uint1 x958;
  fiat_p384_addcarryx_u32(&x957, &x958, x956, x893, x931);
  uint32_t x959;
  fiat_p384_uint1 x960;
  fiat_p384_addcarryx_u32(&x959, &x960, x958, x895, x933);
  uint32_t x961;
  fiat_p384_uint1 x962;
  fiat_p384_addcarryx_u32(&x961, &x962, x960, x897, x935);
  uint32_t x963;
  fiat_p384_uint1 x964;
  fiat_p384_addcarryx_u32(&x963, &x964, x962, x899, x937);
  uint32_t x965;
  fiat_p384_uint1 x966;
  fiat_p384_addcarryx_u32(&x965, &x966, x964, x900, 0x0);
  uint32_t x967;
  uint32_t x968;
  fiat_p384_mulx_u32(&x967, &x968, x7, (arg2[11]));
  uint32_t x969;
  uint32_t x970;
  fiat_p384_mulx_u32(&x969, &x970, x7, (arg2[10]));
  uint32_t x971;
  uint32_t x972;
  fiat_p384_mulx_u32(&x971, &x972, x7, (arg2[9]));
  uint32_t x973;
  uint32_t x974;
  fiat_p384_mulx_u32(&x973, &x974, x7, (arg2[8]));
  uint32_t x975;
  uint32_t x976;
  fiat_p384_mulx_u32(&x975, &x976, x7, (arg2[7]));
  uint32_t x977;
  uint32_t x978;
  fiat_p384_mulx_u32(&x977, &x978, x7, (arg2[6]));
  uint32_t x979;
  uint32_t x980;
  fiat_p384_mulx_u32(&x979, &x980, x7, (arg2[5]));
  uint32_t x981;
  uint32_t x982;
  fiat_p384_mulx_u32(&x981, &x982, x7, (arg2[4]));
  uint32_t x983;
  uint32_t x984;
  fiat_p384_mulx_u32(&x983, &x984, x7, (arg2[3]));
  uint32_t x985;
  uint32_t x986;
  fiat_p384_mulx_u32(&x985, &x986, x7, (arg2[2]));
  uint32_t x987;
  uint32_t x988;
  fiat_p384_mulx_u32(&x987, &x988, x7, (arg2[1]));
  uint32_t x989;
  uint32_t x990;
  fiat_p384_mulx_u32(&x989, &x990, x7, (arg2[0]));
  uint32_t x991;
  fiat_p384_uint1 x992;
  fiat_p384_addcarryx_u32(&x991, &x992, 0x0, x990, x987);
  uint32_t x993;
  fiat_p384_uint1 x994;
  fiat_p384_addcarryx_u32(&x993, &x994, x992, x988, x985);
  uint32_t x995;
  fiat_p384_uint1 x996;
  fiat_p384_addcarryx_u32(&x995, &x996, x994, x986, x983);
  uint32_t x997;
  fiat_p384_uint1 x998;
  fiat_p384_addcarryx_u32(&x997, &x998, x996, x984, x981);
  uint32_t x999;
  fiat_p384_uint1 x1000;
  fiat_p384_addcarryx_u32(&x999, &x1000, x998, x982, x979);
  uint32_t x1001;
  fiat_p384_uint1 x1002;
  fiat_p384_addcarryx_u32(&x1001, &x1002, x1000, x980, x977);
  uint32_t x1003;
  fiat_p384_uint1 x1004;
  fiat_p384_addcarryx_u32(&x1003, &x1004, x1002, x978, x975);
  uint32_t x1005;
  fiat_p384_uint1 x1006;
  fiat_p384_addcarryx_u32(&x1005, &x1006, x1004, x976, x973);
  uint32_t x1007;
  fiat_p384_uint1 x1008;
  fiat_p384_addcarryx_u32(&x1007, &x1008, x1006, x974, x971);
  uint32_t x1009;
  fiat_p384_uint1 x1010;
  fiat_p384_addcarryx_u32(&x1009, &x1010, x1008, x972, x969);
  uint32_t x1011;
  fiat_p384_uint1 x1012;
  fiat_p384_addcarryx_u32(&x1011, &x1012, x1010, x970, x967);
  uint32_t x1013;
  fiat_p384_uint1 x1014;
  fiat_p384_addcarryx_u32(&x1013, &x1014, x1012, x968, 0x0);
  uint32_t x1015;
  fiat_p384_uint1 x1016;
  fiat_p384_addcarryx_u32(&x1015, &x1016, 0x0, x941, x989);
  uint32_t x1017;
  fiat_p384_uint1 x1018;
  fiat_p384_addcarryx_u32(&x1017, &x1018, x1016, x943, x991);
  uint32_t x1019;
  fiat_p384_uint1 x1020;
  fiat_p384_addcarryx_u32(&x1019, &x1020, x1018, x945, x993);
  uint32_t x1021;
  fiat_p384_uint1 x1022;
  fiat_p384_addcarryx_u32(&x1021, &x1022, x1020, x947, x995);
  uint32_t x1023;
  fiat_p384_uint1 x1024;
  fiat_p384_addcarryx_u32(&x1023, &x1024, x1022, x949, x997);
  uint32_t x1025;
  fiat_p384_uint1 x1026;
  fiat_p384_addcarryx_u32(&x1025, &x1026, x1024, x951, x999);
  uint32_t x1027;
  fiat_p384_uint1 x1028;
  fiat_p384_addcarryx_u32(&x1027, &x1028, x1026, x953, x1001);
  uint32_t x1029;
  fiat_p384_uint1 x1030;
  fiat_p384_addcarryx_u32(&x1029, &x1030, x1028, x955, x1003);
  uint32_t x1031;
  fiat_p384_uint1 x1032;
  fiat_p384_addcarryx_u32(&x1031, &x1032, x1030, x957, x1005);
  uint32_t x1033;
  fiat_p384_uint1 x1034;
  fiat_p384_addcarryx_u32(&x1033, &x1034, x1032, x959, x1007);
  uint32_t x1035;
  fiat_p384_uint1 x1036;
  fiat_p384_addcarryx_u32(&x1035, &x1036, x1034, x961, x1009);
  uint32_t x1037;
  fiat_p384_uint1 x1038;
  fiat_p384_addcarryx_u32(&x1037, &x1038, x1036, x963, x1011);
  uint32_t x1039;
  fiat_p384_uint1 x1040;
  fiat_p384_addcarryx_u32(&x1039, &x1040, x1038, x965, x1013);
  uint32_t x1041;
  uint32_t x1042;
  fiat_p384_mulx_u32(&x1041, &x1042, x1015, UINT32_C(0xffffffff));
  uint32_t x1043;
  uint32_t x1044;
  fiat_p384_mulx_u32(&x1043, &x1044, x1015, UINT32_C(0xffffffff));
  uint32_t x1045;
  uint32_t x1046;
  fiat_p384_mulx_u32(&x1045, &x1046, x1015, UINT32_C(0xffffffff));
  uint32_t x1047;
  uint32_t x1048;
  fiat_p384_mulx_u32(&x1047, &x1048, x1015, UINT32_C(0xffffffff));
  uint32_t x1049;
  uint32_t x1050;
  fiat_p384_mulx_u32(&x1049, &x1050, x1015, UINT32_C(0xffffffff));
  uint32_t x1051;
  uint32_t x1052;
  fiat_p384_mulx_u32(&x1051, &x1052, x1015, UINT32_C(0xffffffff));
  uint32_t x1053;
  uint32_t x1054;
  fiat_p384_mulx_u32(&x1053, &x1054, x1015, UINT32_C(0xffffffff));
  uint32_t x1055;
  uint32_t x1056;
  fiat_p384_mulx_u32(&x1055, &x1056, x1015, UINT32_C(0xfffffffe));
  uint32_t x1057;
  uint32_t x1058;
  fiat_p384_mulx_u32(&x1057, &x1058, x1015, UINT32_C(0xffffffff));
  uint32_t x1059;
  uint32_t x1060;
  fiat_p384_mulx_u32(&x1059, &x1060, x1015, UINT32_C(0xffffffff));
  uint32_t x1061;
  fiat_p384_uint1 x1062;
  fiat_p384_addcarryx_u32(&x1061, &x1062, 0x0, x1058, x1055);
  uint32_t x1063;
  fiat_p384_uint1 x1064;
  fiat_p384_addcarryx_u32(&x1063, &x1064, x1062, x1056, x1053);
  uint32_t x1065;
  fiat_p384_uint1 x1066;
  fiat_p384_addcarryx_u32(&x1065, &x1066, x1064, x1054, x1051);
  uint32_t x1067;
  fiat_p384_uint1 x1068;
  fiat_p384_addcarryx_u32(&x1067, &x1068, x1066, x1052, x1049);
  uint32_t x1069;
  fiat_p384_uint1 x1070;
  fiat_p384_addcarryx_u32(&x1069, &x1070, x1068, x1050, x1047);
  uint32_t x1071;
  fiat_p384_uint1 x1072;
  fiat_p384_addcarryx_u32(&x1071, &x1072, x1070, x1048, x1045);
  uint32_t x1073;
  fiat_p384_uint1 x1074;
  fiat_p384_addcarryx_u32(&x1073, &x1074, x1072, x1046, x1043);
  uint32_t x1075;
  fiat_p384_uint1 x1076;
  fiat_p384_addcarryx_u32(&x1075, &x1076, x1074, x1044, x1041);
  uint32_t x1077;
  fiat_p384_uint1 x1078;
  fiat_p384_addcarryx_u32(&x1077, &x1078, x1076, x1042, 0x0);
  uint32_t x1079;
  fiat_p384_uint1 x1080;
  fiat_p384_addcarryx_u32(&x1079, &x1080, 0x0, x1015, x1059);
  uint32_t x1081;
  fiat_p384_uint1 x1082;
  fiat_p384_addcarryx_u32(&x1081, &x1082, x1080, x1017, x1060);
  uint32_t x1083;
  fiat_p384_uint1 x1084;
  fiat_p384_addcarryx_u32(&x1083, &x1084, x1082, x1019, 0x0);
  uint32_t x1085;
  fiat_p384_uint1 x1086;
  fiat_p384_addcarryx_u32(&x1085, &x1086, x1084, x1021, x1057);
  uint32_t x1087;
  fiat_p384_uint1 x1088;
  fiat_p384_addcarryx_u32(&x1087, &x1088, x1086, x1023, x1061);
  uint32_t x1089;
  fiat_p384_uint1 x1090;
  fiat_p384_addcarryx_u32(&x1089, &x1090, x1088, x1025, x1063);
  uint32_t x1091;
  fiat_p384_uint1 x1092;
  fiat_p384_addcarryx_u32(&x1091, &x1092, x1090, x1027, x1065);
  uint32_t x1093;
  fiat_p384_uint1 x1094;
  fiat_p384_addcarryx_u32(&x1093, &x1094, x1092, x1029, x1067);
  uint32_t x1095;
  fiat_p384_uint1 x1096;
  fiat_p384_addcarryx_u32(&x1095, &x1096, x1094, x1031, x1069);
  uint32_t x1097;
  fiat_p384_uint1 x1098;
  fiat_p384_addcarryx_u32(&x1097, &x1098, x1096, x1033, x1071);
  uint32_t x1099;
  fiat_p384_uint1 x1100;
  fiat_p384_addcarryx_u32(&x1099, &x1100, x1098, x1035, x1073);
  uint32_t x1101;
  fiat_p384_uint1 x1102;
  fiat_p384_addcarryx_u32(&x1101, &x1102, x1100, x1037, x1075);
  uint32_t x1103;
  fiat_p384_uint1 x1104;
  fiat_p384_addcarryx_u32(&x1103, &x1104, x1102, x1039, x1077);
  uint32_t x1105;
  fiat_p384_uint1 x1106;
  fiat_p384_addcarryx_u32(&x1105, &x1106, x1104, x1040, 0x0);
  uint32_t x1107;
  uint32_t x1108;
  fiat_p384_mulx_u32(&x1107, &x1108, x8, (arg2[11]));
  uint32_t x1109;
  uint32_t x1110;
  fiat_p384_mulx_u32(&x1109, &x1110, x8, (arg2[10]));
  uint32_t x1111;
  uint32_t x1112;
  fiat_p384_mulx_u32(&x1111, &x1112, x8, (arg2[9]));
  uint32_t x1113;
  uint32_t x1114;
  fiat_p384_mulx_u32(&x1113, &x1114, x8, (arg2[8]));
  uint32_t x1115;
  uint32_t x1116;
  fiat_p384_mulx_u32(&x1115, &x1116, x8, (arg2[7]));
  uint32_t x1117;
  uint32_t x1118;
  fiat_p384_mulx_u32(&x1117, &x1118, x8, (arg2[6]));
  uint32_t x1119;
  uint32_t x1120;
  fiat_p384_mulx_u32(&x1119, &x1120, x8, (arg2[5]));
  uint32_t x1121;
  uint32_t x1122;
  fiat_p384_mulx_u32(&x1121, &x1122, x8, (arg2[4]));
  uint32_t x1123;
  uint32_t x1124;
  fiat_p384_mulx_u32(&x1123, &x1124, x8, (arg2[3]));
  uint32_t x1125;
  uint32_t x1126;
  fiat_p384_mulx_u32(&x1125, &x1126, x8, (arg2[2]));
  uint32_t x1127;
  uint32_t x1128;
  fiat_p384_mulx_u32(&x1127, &x1128, x8, (arg2[1]));
  uint32_t x1129;
  uint32_t x1130;
  fiat_p384_mulx_u32(&x1129, &x1130, x8, (arg2[0]));
  uint32_t x1131;
  fiat_p384_uint1 x1132;
  fiat_p384_addcarryx_u32(&x1131, &x1132, 0x0, x1130, x1127);
  uint32_t x1133;
  fiat_p384_uint1 x1134;
  fiat_p384_addcarryx_u32(&x1133, &x1134, x1132, x1128, x1125);
  uint32_t x1135;
  fiat_p384_uint1 x1136;
  fiat_p384_addcarryx_u32(&x1135, &x1136, x1134, x1126, x1123);
  uint32_t x1137;
  fiat_p384_uint1 x1138;
  fiat_p384_addcarryx_u32(&x1137, &x1138, x1136, x1124, x1121);
  uint32_t x1139;
  fiat_p384_uint1 x1140;
  fiat_p384_addcarryx_u32(&x1139, &x1140, x1138, x1122, x1119);
  uint32_t x1141;
  fiat_p384_uint1 x1142;
  fiat_p384_addcarryx_u32(&x1141, &x1142, x1140, x1120, x1117);
  uint32_t x1143;
  fiat_p384_uint1 x1144;
  fiat_p384_addcarryx_u32(&x1143, &x1144, x1142, x1118, x1115);
  uint32_t x1145;
  fiat_p384_uint1 x1146;
  fiat_p384_addcarryx_u32(&x1145, &x1146, x1144, x1116, x1113);
  uint32_t x1147;
  fiat_p384_uint1 x1148;
  fiat_p384_addcarryx_u32(&x1147, &x1148, x1146, x1114, x1111);
  uint32_t x1149;
  fiat_p384_uint1 x1150;
  fiat_p384_addcarryx_u32(&x1149, &x1150, x1148, x1112, x1109);
  uint32_t x1151;
  fiat_p384_uint1 x1152;
  fiat_p384_addcarryx_u32(&x1151, &x1152, x1150, x1110, x1107);
  uint32_t x1153;
  fiat_p384_uint1 x1154;
  fiat_p384_addcarryx_u32(&x1153, &x1154, x1152, x1108, 0x0);
  uint32_t x1155;
  fiat_p384_uint1 x1156;
  fiat_p384_addcarryx_u32(&x1155, &x1156, 0x0, x1081, x1129);
  uint32_t x1157;
  fiat_p384_uint1 x1158;
  fiat_p384_addcarryx_u32(&x1157, &x1158, x1156, x1083, x1131);
  uint32_t x1159;
  fiat_p384_uint1 x1160;
  fiat_p384_addcarryx_u32(&x1159, &x1160, x1158, x1085, x1133);
  uint32_t x1161;
  fiat_p384_uint1 x1162;
  fiat_p384_addcarryx_u32(&x1161, &x1162, x1160, x1087, x1135);
  uint32_t x1163;
  fiat_p384_uint1 x1164;
  fiat_p384_addcarryx_u32(&x1163, &x1164, x1162, x1089, x1137);
  uint32_t x1165;
  fiat_p384_uint1 x1166;
  fiat_p384_addcarryx_u32(&x1165, &x1166, x1164, x1091, x1139);
  uint32_t x1167;
  fiat_p384_uint1 x1168;
  fiat_p384_addcarryx_u32(&x1167, &x1168, x1166, x1093, x1141);
  uint32_t x1169;
  fiat_p384_uint1 x1170;
  fiat_p384_addcarryx_u32(&x1169, &x1170, x1168, x1095, x1143);
  uint32_t x1171;
  fiat_p384_uint1 x1172;
  fiat_p384_addcarryx_u32(&x1171, &x1172, x1170, x1097, x1145);
  uint32_t x1173;
  fiat_p384_uint1 x1174;
  fiat_p384_addcarryx_u32(&x1173, &x1174, x1172, x1099, x1147);
  uint32_t x1175;
  fiat_p384_uint1 x1176;
  fiat_p384_addcarryx_u32(&x1175, &x1176, x1174, x1101, x1149);
  uint32_t x1177;
  fiat_p384_uint1 x1178;
  fiat_p384_addcarryx_u32(&x1177, &x1178, x1176, x1103, x1151);
  uint32_t x1179;
  fiat_p384_uint1 x1180;
  fiat_p384_addcarryx_u32(&x1179, &x1180, x1178, x1105, x1153);
  uint32_t x1181;
  uint32_t x1182;
  fiat_p384_mulx_u32(&x1181, &x1182, x1155, UINT32_C(0xffffffff));
  uint32_t x1183;
  uint32_t x1184;
  fiat_p384_mulx_u32(&x1183, &x1184, x1155, UINT32_C(0xffffffff));
  uint32_t x1185;
  uint32_t x1186;
  fiat_p384_mulx_u32(&x1185, &x1186, x1155, UINT32_C(0xffffffff));
  uint32_t x1187;
  uint32_t x1188;
  fiat_p384_mulx_u32(&x1187, &x1188, x1155, UINT32_C(0xffffffff));
  uint32_t x1189;
  uint32_t x1190;
  fiat_p384_mulx_u32(&x1189, &x1190, x1155, UINT32_C(0xffffffff));
  uint32_t x1191;
  uint32_t x1192;
  fiat_p384_mulx_u32(&x1191, &x1192, x1155, UINT32_C(0xffffffff));
  uint32_t x1193;
  uint32_t x1194;
  fiat_p384_mulx_u32(&x1193, &x1194, x1155, UINT32_C(0xffffffff));
  uint32_t x1195;
  uint32_t x1196;
  fiat_p384_mulx_u32(&x1195, &x1196, x1155, UINT32_C(0xfffffffe));
  uint32_t x1197;
  uint32_t x1198;
  fiat_p384_mulx_u32(&x1197, &x1198, x1155, UINT32_C(0xffffffff));
  uint32_t x1199;
  uint32_t x1200;
  fiat_p384_mulx_u32(&x1199, &x1200, x1155, UINT32_C(0xffffffff));
  uint32_t x1201;
  fiat_p384_uint1 x1202;
  fiat_p384_addcarryx_u32(&x1201, &x1202, 0x0, x1198, x1195);
  uint32_t x1203;
  fiat_p384_uint1 x1204;
  fiat_p384_addcarryx_u32(&x1203, &x1204, x1202, x1196, x1193);
  uint32_t x1205;
  fiat_p384_uint1 x1206;
  fiat_p384_addcarryx_u32(&x1205, &x1206, x1204, x1194, x1191);
  uint32_t x1207;
  fiat_p384_uint1 x1208;
  fiat_p384_addcarryx_u32(&x1207, &x1208, x1206, x1192, x1189);
  uint32_t x1209;
  fiat_p384_uint1 x1210;
  fiat_p384_addcarryx_u32(&x1209, &x1210, x1208, x1190, x1187);
  uint32_t x1211;
  fiat_p384_uint1 x1212;
  fiat_p384_addcarryx_u32(&x1211, &x1212, x1210, x1188, x1185);
  uint32_t x1213;
  fiat_p384_uint1 x1214;
  fiat_p384_addcarryx_u32(&x1213, &x1214, x1212, x1186, x1183);
  uint32_t x1215;
  fiat_p384_uint1 x1216;
  fiat_p384_addcarryx_u32(&x1215, &x1216, x1214, x1184, x1181);
  uint32_t x1217;
  fiat_p384_uint1 x1218;
  fiat_p384_addcarryx_u32(&x1217, &x1218, x1216, x1182, 0x0);
  uint32_t x1219;
  fiat_p384_uint1 x1220;
  fiat_p384_addcarryx_u32(&x1219, &x1220, 0x0, x1155, x1199);
  uint32_t x1221;
  fiat_p384_uint1 x1222;
  fiat_p384_addcarryx_u32(&x1221, &x1222, x1220, x1157, x1200);
  uint32_t x1223;
  fiat_p384_uint1 x1224;
  fiat_p384_addcarryx_u32(&x1223, &x1224, x1222, x1159, 0x0);
  uint32_t x1225;
  fiat_p384_uint1 x1226;
  fiat_p384_addcarryx_u32(&x1225, &x1226, x1224, x1161, x1197);
  uint32_t x1227;
  fiat_p384_uint1 x1228;
  fiat_p384_addcarryx_u32(&x1227, &x1228, x1226, x1163, x1201);
  uint32_t x1229;
  fiat_p384_uint1 x1230;
  fiat_p384_addcarryx_u32(&x1229, &x1230, x1228, x1165, x1203);
  uint32_t x1231;
  fiat_p384_uint1 x1232;
  fiat_p384_addcarryx_u32(&x1231, &x1232, x1230, x1167, x1205);
  uint32_t x1233;
  fiat_p384_uint1 x1234;
  fiat_p384_addcarryx_u32(&x1233, &x1234, x1232, x1169, x1207);
  uint32_t x1235;
  fiat_p384_uint1 x1236;
  fiat_p384_addcarryx_u32(&x1235, &x1236, x1234, x1171, x1209);
  uint32_t x1237;
  fiat_p384_uint1 x1238;
  fiat_p384_addcarryx_u32(&x1237, &x1238, x1236, x1173, x1211);
  uint32_t x1239;
  fiat_p384_uint1 x1240;
  fiat_p384_addcarryx_u32(&x1239, &x1240, x1238, x1175, x1213);
  uint32_t x1241;
  fiat_p384_uint1 x1242;
  fiat_p384_addcarryx_u32(&x1241, &x1242, x1240, x1177, x1215);
  uint32_t x1243;
  fiat_p384_uint1 x1244;
  fiat_p384_addcarryx_u32(&x1243, &x1244, x1242, x1179, x1217);
  uint32_t x1245;
  fiat_p384_uint1 x1246;
  fiat_p384_addcarryx_u32(&x1245, &x1246, x1244, x1180, 0x0);
  uint32_t x1247;
  uint32_t x1248;
  fiat_p384_mulx_u32(&x1247, &x1248, x9, (arg2[11]));
  uint32_t x1249;
  uint32_t x1250;
  fiat_p384_mulx_u32(&x1249, &x1250, x9, (arg2[10]));
  uint32_t x1251;
  uint32_t x1252;
  fiat_p384_mulx_u32(&x1251, &x1252, x9, (arg2[9]));
  uint32_t x1253;
  uint32_t x1254;
  fiat_p384_mulx_u32(&x1253, &x1254, x9, (arg2[8]));
  uint32_t x1255;
  uint32_t x1256;
  fiat_p384_mulx_u32(&x1255, &x1256, x9, (arg2[7]));
  uint32_t x1257;
  uint32_t x1258;
  fiat_p384_mulx_u32(&x1257, &x1258, x9, (arg2[6]));
  uint32_t x1259;
  uint32_t x1260;
  fiat_p384_mulx_u32(&x1259, &x1260, x9, (arg2[5]));
  uint32_t x1261;
  uint32_t x1262;
  fiat_p384_mulx_u32(&x1261, &x1262, x9, (arg2[4]));
  uint32_t x1263;
  uint32_t x1264;
  fiat_p384_mulx_u32(&x1263, &x1264, x9, (arg2[3]));
  uint32_t x1265;
  uint32_t x1266;
  fiat_p384_mulx_u32(&x1265, &x1266, x9, (arg2[2]));
  uint32_t x1267;
  uint32_t x1268;
  fiat_p384_mulx_u32(&x1267, &x1268, x9, (arg2[1]));
  uint32_t x1269;
  uint32_t x1270;
  fiat_p384_mulx_u32(&x1269, &x1270, x9, (arg2[0]));
  uint32_t x1271;
  fiat_p384_uint1 x1272;
  fiat_p384_addcarryx_u32(&x1271, &x1272, 0x0, x1270, x1267);
  uint32_t x1273;
  fiat_p384_uint1 x1274;
  fiat_p384_addcarryx_u32(&x1273, &x1274, x1272, x1268, x1265);
  uint32_t x1275;
  fiat_p384_uint1 x1276;
  fiat_p384_addcarryx_u32(&x1275, &x1276, x1274, x1266, x1263);
  uint32_t x1277;
  fiat_p384_uint1 x1278;
  fiat_p384_addcarryx_u32(&x1277, &x1278, x1276, x1264, x1261);
  uint32_t x1279;
  fiat_p384_uint1 x1280;
  fiat_p384_addcarryx_u32(&x1279, &x1280, x1278, x1262, x1259);
  uint32_t x1281;
  fiat_p384_uint1 x1282;
  fiat_p384_addcarryx_u32(&x1281, &x1282, x1280, x1260, x1257);
  uint32_t x1283;
  fiat_p384_uint1 x1284;
  fiat_p384_addcarryx_u32(&x1283, &x1284, x1282, x1258, x1255);
  uint32_t x1285;
  fiat_p384_uint1 x1286;
  fiat_p384_addcarryx_u32(&x1285, &x1286, x1284, x1256, x1253);
  uint32_t x1287;
  fiat_p384_uint1 x1288;
  fiat_p384_addcarryx_u32(&x1287, &x1288, x1286, x1254, x1251);
  uint32_t x1289;
  fiat_p384_uint1 x1290;
  fiat_p384_addcarryx_u32(&x1289, &x1290, x1288, x1252, x1249);
  uint32_t x1291;
  fiat_p384_uint1 x1292;
  fiat_p384_addcarryx_u32(&x1291, &x1292, x1290, x1250, x1247);
  uint32_t x1293;
  fiat_p384_uint1 x1294;
  fiat_p384_addcarryx_u32(&x1293, &x1294, x1292, x1248, 0x0);
  uint32_t x1295;
  fiat_p384_uint1 x1296;
  fiat_p384_addcarryx_u32(&x1295, &x1296, 0x0, x1221, x1269);
  uint32_t x1297;
  fiat_p384_uint1 x1298;
  fiat_p384_addcarryx_u32(&x1297, &x1298, x1296, x1223, x1271);
  uint32_t x1299;
  fiat_p384_uint1 x1300;
  fiat_p384_addcarryx_u32(&x1299, &x1300, x1298, x1225, x1273);
  uint32_t x1301;
  fiat_p384_uint1 x1302;
  fiat_p384_addcarryx_u32(&x1301, &x1302, x1300, x1227, x1275);
  uint32_t x1303;
  fiat_p384_uint1 x1304;
  fiat_p384_addcarryx_u32(&x1303, &x1304, x1302, x1229, x1277);
  uint32_t x1305;
  fiat_p384_uint1 x1306;
  fiat_p384_addcarryx_u32(&x1305, &x1306, x1304, x1231, x1279);
  uint32_t x1307;
  fiat_p384_uint1 x1308;
  fiat_p384_addcarryx_u32(&x1307, &x1308, x1306, x1233, x1281);
  uint32_t x1309;
  fiat_p384_uint1 x1310;
  fiat_p384_addcarryx_u32(&x1309, &x1310, x1308, x1235, x1283);
  uint32_t x1311;
  fiat_p384_uint1 x1312;
  fiat_p384_addcarryx_u32(&x1311, &x1312, x1310, x1237, x1285);
  uint32_t x1313;
  fiat_p384_uint1 x1314;
  fiat_p384_addcarryx_u32(&x1313, &x1314, x1312, x1239, x1287);
  uint32_t x1315;
  fiat_p384_uint1 x1316;
  fiat_p384_addcarryx_u32(&x1315, &x1316, x1314, x1241, x1289);
  uint32_t x1317;
  fiat_p384_uint1 x1318;
  fiat_p384_addcarryx_u32(&x1317, &x1318, x1316, x1243, x1291);
  uint32_t x1319;
  fiat_p384_uint1 x1320;
  fiat_p384_addcarryx_u32(&x1319, &x1320, x1318, x1245, x1293);
  uint32_t x1321;
  uint32_t x1322;
  fiat_p384_mulx_u32(&x1321, &x1322, x1295, UINT32_C(0xffffffff));
  uint32_t x1323;
  uint32_t x1324;
  fiat_p384_mulx_u32(&x1323, &x1324, x1295, UINT32_C(0xffffffff));
  uint32_t x1325;
  uint32_t x1326;
  fiat_p384_mulx_u32(&x1325, &x1326, x1295, UINT32_C(0xffffffff));
  uint32_t x1327;
  uint32_t x1328;
  fiat_p384_mulx_u32(&x1327, &x1328, x1295, UINT32_C(0xffffffff));
  uint32_t x1329;
  uint32_t x1330;
  fiat_p384_mulx_u32(&x1329, &x1330, x1295, UINT32_C(0xffffffff));
  uint32_t x1331;
  uint32_t x1332;
  fiat_p384_mulx_u32(&x1331, &x1332, x1295, UINT32_C(0xffffffff));
  uint32_t x1333;
  uint32_t x1334;
  fiat_p384_mulx_u32(&x1333, &x1334, x1295, UINT32_C(0xffffffff));
  uint32_t x1335;
  uint32_t x1336;
  fiat_p384_mulx_u32(&x1335, &x1336, x1295, UINT32_C(0xfffffffe));
  uint32_t x1337;
  uint32_t x1338;
  fiat_p384_mulx_u32(&x1337, &x1338, x1295, UINT32_C(0xffffffff));
  uint32_t x1339;
  uint32_t x1340;
  fiat_p384_mulx_u32(&x1339, &x1340, x1295, UINT32_C(0xffffffff));
  uint32_t x1341;
  fiat_p384_uint1 x1342;
  fiat_p384_addcarryx_u32(&x1341, &x1342, 0x0, x1338, x1335);
  uint32_t x1343;
  fiat_p384_uint1 x1344;
  fiat_p384_addcarryx_u32(&x1343, &x1344, x1342, x1336, x1333);
  uint32_t x1345;
  fiat_p384_uint1 x1346;
  fiat_p384_addcarryx_u32(&x1345, &x1346, x1344, x1334, x1331);
  uint32_t x1347;
  fiat_p384_uint1 x1348;
  fiat_p384_addcarryx_u32(&x1347, &x1348, x1346, x1332, x1329);
  uint32_t x1349;
  fiat_p384_uint1 x1350;
  fiat_p384_addcarryx_u32(&x1349, &x1350, x1348, x1330, x1327);
  uint32_t x1351;
  fiat_p384_uint1 x1352;
  fiat_p384_addcarryx_u32(&x1351, &x1352, x1350, x1328, x1325);
  uint32_t x1353;
  fiat_p384_uint1 x1354;
  fiat_p384_addcarryx_u32(&x1353, &x1354, x1352, x1326, x1323);
  uint32_t x1355;
  fiat_p384_uint1 x1356;
  fiat_p384_addcarryx_u32(&x1355, &x1356, x1354, x1324, x1321);
  uint32_t x1357;
  fiat_p384_uint1 x1358;
  fiat_p384_addcarryx_u32(&x1357, &x1358, x1356, x1322, 0x0);
  uint32_t x1359;
  fiat_p384_uint1 x1360;
  fiat_p384_addcarryx_u32(&x1359, &x1360, 0x0, x1295, x1339);
  uint32_t x1361;
  fiat_p384_uint1 x1362;
  fiat_p384_addcarryx_u32(&x1361, &x1362, x1360, x1297, x1340);
  uint32_t x1363;
  fiat_p384_uint1 x1364;
  fiat_p384_addcarryx_u32(&x1363, &x1364, x1362, x1299, 0x0);
  uint32_t x1365;
  fiat_p384_uint1 x1366;
  fiat_p384_addcarryx_u32(&x1365, &x1366, x1364, x1301, x1337);
  uint32_t x1367;
  fiat_p384_uint1 x1368;
  fiat_p384_addcarryx_u32(&x1367, &x1368, x1366, x1303, x1341);
  uint32_t x1369;
  fiat_p384_uint1 x1370;
  fiat_p384_addcarryx_u32(&x1369, &x1370, x1368, x1305, x1343);
  uint32_t x1371;
  fiat_p384_uint1 x1372;
  fiat_p384_addcarryx_u32(&x1371, &x1372, x1370, x1307, x1345);
  uint32_t x1373;
  fiat_p384_uint1 x1374;
  fiat_p384_addcarryx_u32(&x1373, &x1374, x1372, x1309, x1347);
  uint32_t x1375;
  fiat_p384_uint1 x1376;
  fiat_p384_addcarryx_u32(&x1375, &x1376, x1374, x1311, x1349);
  uint32_t x1377;
  fiat_p384_uint1 x1378;
  fiat_p384_addcarryx_u32(&x1377, &x1378, x1376, x1313, x1351);
  uint32_t x1379;
  fiat_p384_uint1 x1380;
  fiat_p384_addcarryx_u32(&x1379, &x1380, x1378, x1315, x1353);
  uint32_t x1381;
  fiat_p384_uint1 x1382;
  fiat_p384_addcarryx_u32(&x1381, &x1382, x1380, x1317, x1355);
  uint32_t x1383;
  fiat_p384_uint1 x1384;
  fiat_p384_addcarryx_u32(&x1383, &x1384, x1382, x1319, x1357);
  uint32_t x1385;
  fiat_p384_uint1 x1386;
  fiat_p384_addcarryx_u32(&x1385, &x1386, x1384, x1320, 0x0);
  uint32_t x1387;
  uint32_t x1388;
  fiat_p384_mulx_u32(&x1387, &x1388, x10, (arg2[11]));
  uint32_t x1389;
  uint32_t x1390;
  fiat_p384_mulx_u32(&x1389, &x1390, x10, (arg2[10]));
  uint32_t x1391;
  uint32_t x1392;
  fiat_p384_mulx_u32(&x1391, &x1392, x10, (arg2[9]));
  uint32_t x1393;
  uint32_t x1394;
  fiat_p384_mulx_u32(&x1393, &x1394, x10, (arg2[8]));
  uint32_t x1395;
  uint32_t x1396;
  fiat_p384_mulx_u32(&x1395, &x1396, x10, (arg2[7]));
  uint32_t x1397;
  uint32_t x1398;
  fiat_p384_mulx_u32(&x1397, &x1398, x10, (arg2[6]));
  uint32_t x1399;
  uint32_t x1400;
  fiat_p384_mulx_u32(&x1399, &x1400, x10, (arg2[5]));
  uint32_t x1401;
  uint32_t x1402;
  fiat_p384_mulx_u32(&x1401, &x1402, x10, (arg2[4]));
  uint32_t x1403;
  uint32_t x1404;
  fiat_p384_mulx_u32(&x1403, &x1404, x10, (arg2[3]));
  uint32_t x1405;
  uint32_t x1406;
  fiat_p384_mulx_u32(&x1405, &x1406, x10, (arg2[2]));
  uint32_t x1407;
  uint32_t x1408;
  fiat_p384_mulx_u32(&x1407, &x1408, x10, (arg2[1]));
  uint32_t x1409;
  uint32_t x1410;
  fiat_p384_mulx_u32(&x1409, &x1410, x10, (arg2[0]));
  uint32_t x1411;
  fiat_p384_uint1 x1412;
  fiat_p384_addcarryx_u32(&x1411, &x1412, 0x0, x1410, x1407);
  uint32_t x1413;
  fiat_p384_uint1 x1414;
  fiat_p384_addcarryx_u32(&x1413, &x1414, x1412, x1408, x1405);
  uint32_t x1415;
  fiat_p384_uint1 x1416;
  fiat_p384_addcarryx_u32(&x1415, &x1416, x1414, x1406, x1403);
  uint32_t x1417;
  fiat_p384_uint1 x1418;
  fiat_p384_addcarryx_u32(&x1417, &x1418, x1416, x1404, x1401);
  uint32_t x1419;
  fiat_p384_uint1 x1420;
  fiat_p384_addcarryx_u32(&x1419, &x1420, x1418, x1402, x1399);
  uint32_t x1421;
  fiat_p384_uint1 x1422;
  fiat_p384_addcarryx_u32(&x1421, &x1422, x1420, x1400, x1397);
  uint32_t x1423;
  fiat_p384_uint1 x1424;
  fiat_p384_addcarryx_u32(&x1423, &x1424, x1422, x1398, x1395);
  uint32_t x1425;
  fiat_p384_uint1 x1426;
  fiat_p384_addcarryx_u32(&x1425, &x1426, x1424, x1396, x1393);
  uint32_t x1427;
  fiat_p384_uint1 x1428;
  fiat_p384_addcarryx_u32(&x1427, &x1428, x1426, x1394, x1391);
  uint32_t x1429;
  fiat_p384_uint1 x1430;
  fiat_p384_addcarryx_u32(&x1429, &x1430, x1428, x1392, x1389);
  uint32_t x1431;
  fiat_p384_uint1 x1432;
  fiat_p384_addcarryx_u32(&x1431, &x1432, x1430, x1390, x1387);
  uint32_t x1433;
  fiat_p384_uint1 x1434;
  fiat_p384_addcarryx_u32(&x1433, &x1434, x1432, x1388, 0x0);
  uint32_t x1435;
  fiat_p384_uint1 x1436;
  fiat_p384_addcarryx_u32(&x1435, &x1436, 0x0, x1361, x1409);
  uint32_t x1437;
  fiat_p384_uint1 x1438;
  fiat_p384_addcarryx_u32(&x1437, &x1438, x1436, x1363, x1411);
  uint32_t x1439;
  fiat_p384_uint1 x1440;
  fiat_p384_addcarryx_u32(&x1439, &x1440, x1438, x1365, x1413);
  uint32_t x1441;
  fiat_p384_uint1 x1442;
  fiat_p384_addcarryx_u32(&x1441, &x1442, x1440, x1367, x1415);
  uint32_t x1443;
  fiat_p384_uint1 x1444;
  fiat_p384_addcarryx_u32(&x1443, &x1444, x1442, x1369, x1417);
  uint32_t x1445;
  fiat_p384_uint1 x1446;
  fiat_p384_addcarryx_u32(&x1445, &x1446, x1444, x1371, x1419);
  uint32_t x1447;
  fiat_p384_uint1 x1448;
  fiat_p384_addcarryx_u32(&x1447, &x1448, x1446, x1373, x1421);
  uint32_t x1449;
  fiat_p384_uint1 x1450;
  fiat_p384_addcarryx_u32(&x1449, &x1450, x1448, x1375, x1423);
  uint32_t x1451;
  fiat_p384_uint1 x1452;
  fiat_p384_addcarryx_u32(&x1451, &x1452, x1450, x1377, x1425);
  uint32_t x1453;
  fiat_p384_uint1 x1454;
  fiat_p384_addcarryx_u32(&x1453, &x1454, x1452, x1379, x1427);
  uint32_t x1455;
  fiat_p384_uint1 x1456;
  fiat_p384_addcarryx_u32(&x1455, &x1456, x1454, x1381, x1429);
  uint32_t x1457;
  fiat_p384_uint1 x1458;
  fiat_p384_addcarryx_u32(&x1457, &x1458, x1456, x1383, x1431);
  uint32_t x1459;
  fiat_p384_uint1 x1460;
  fiat_p384_addcarryx_u32(&x1459, &x1460, x1458, x1385, x1433);
  uint32_t x1461;
  uint32_t x1462;
  fiat_p384_mulx_u32(&x1461, &x1462, x1435, UINT32_C(0xffffffff));
  uint32_t x1463;
  uint32_t x1464;
  fiat_p384_mulx_u32(&x1463, &x1464, x1435, UINT32_C(0xffffffff));
  uint32_t x1465;
  uint32_t x1466;
  fiat_p384_mulx_u32(&x1465, &x1466, x1435, UINT32_C(0xffffffff));
  uint32_t x1467;
  uint32_t x1468;
  fiat_p384_mulx_u32(&x1467, &x1468, x1435, UINT32_C(0xffffffff));
  uint32_t x1469;
  uint32_t x1470;
  fiat_p384_mulx_u32(&x1469, &x1470, x1435, UINT32_C(0xffffffff));
  uint32_t x1471;
  uint32_t x1472;
  fiat_p384_mulx_u32(&x1471, &x1472, x1435, UINT32_C(0xffffffff));
  uint32_t x1473;
  uint32_t x1474;
  fiat_p384_mulx_u32(&x1473, &x1474, x1435, UINT32_C(0xffffffff));
  uint32_t x1475;
  uint32_t x1476;
  fiat_p384_mulx_u32(&x1475, &x1476, x1435, UINT32_C(0xfffffffe));
  uint32_t x1477;
  uint32_t x1478;
  fiat_p384_mulx_u32(&x1477, &x1478, x1435, UINT32_C(0xffffffff));
  uint32_t x1479;
  uint32_t x1480;
  fiat_p384_mulx_u32(&x1479, &x1480, x1435, UINT32_C(0xffffffff));
  uint32_t x1481;
  fiat_p384_uint1 x1482;
  fiat_p384_addcarryx_u32(&x1481, &x1482, 0x0, x1478, x1475);
  uint32_t x1483;
  fiat_p384_uint1 x1484;
  fiat_p384_addcarryx_u32(&x1483, &x1484, x1482, x1476, x1473);
  uint32_t x1485;
  fiat_p384_uint1 x1486;
  fiat_p384_addcarryx_u32(&x1485, &x1486, x1484, x1474, x1471);
  uint32_t x1487;
  fiat_p384_uint1 x1488;
  fiat_p384_addcarryx_u32(&x1487, &x1488, x1486, x1472, x1469);
  uint32_t x1489;
  fiat_p384_uint1 x1490;
  fiat_p384_addcarryx_u32(&x1489, &x1490, x1488, x1470, x1467);
  uint32_t x1491;
  fiat_p384_uint1 x1492;
  fiat_p384_addcarryx_u32(&x1491, &x1492, x1490, x1468, x1465);
  uint32_t x1493;
  fiat_p384_uint1 x1494;
  fiat_p384_addcarryx_u32(&x1493, &x1494, x1492, x1466, x1463);
  uint32_t x1495;
  fiat_p384_uint1 x1496;
  fiat_p384_addcarryx_u32(&x1495, &x1496, x1494, x1464, x1461);
  uint32_t x1497;
  fiat_p384_uint1 x1498;
  fiat_p384_addcarryx_u32(&x1497, &x1498, x1496, x1462, 0x0);
  uint32_t x1499;
  fiat_p384_uint1 x1500;
  fiat_p384_addcarryx_u32(&x1499, &x1500, 0x0, x1435, x1479);
  uint32_t x1501;
  fiat_p384_uint1 x1502;
  fiat_p384_addcarryx_u32(&x1501, &x1502, x1500, x1437, x1480);
  uint32_t x1503;
  fiat_p384_uint1 x1504;
  fiat_p384_addcarryx_u32(&x1503, &x1504, x1502, x1439, 0x0);
  uint32_t x1505;
  fiat_p384_uint1 x1506;
  fiat_p384_addcarryx_u32(&x1505, &x1506, x1504, x1441, x1477);
  uint32_t x1507;
  fiat_p384_uint1 x1508;
  fiat_p384_addcarryx_u32(&x1507, &x1508, x1506, x1443, x1481);
  uint32_t x1509;
  fiat_p384_uint1 x1510;
  fiat_p384_addcarryx_u32(&x1509, &x1510, x1508, x1445, x1483);
  uint32_t x1511;
  fiat_p384_uint1 x1512;
  fiat_p384_addcarryx_u32(&x1511, &x1512, x1510, x1447, x1485);
  uint32_t x1513;
  fiat_p384_uint1 x1514;
  fiat_p384_addcarryx_u32(&x1513, &x1514, x1512, x1449, x1487);
  uint32_t x1515;
  fiat_p384_uint1 x1516;
  fiat_p384_addcarryx_u32(&x1515, &x1516, x1514, x1451, x1489);
  uint32_t x1517;
  fiat_p384_uint1 x1518;
  fiat_p384_addcarryx_u32(&x1517, &x1518, x1516, x1453, x1491);
  uint32_t x1519;
  fiat_p384_uint1 x1520;
  fiat_p384_addcarryx_u32(&x1519, &x1520, x1518, x1455, x1493);
  uint32_t x1521;
  fiat_p384_uint1 x1522;
  fiat_p384_addcarryx_u32(&x1521, &x1522, x1520, x1457, x1495);
  uint32_t x1523;
  fiat_p384_uint1 x1524;
  fiat_p384_addcarryx_u32(&x1523, &x1524, x1522, x1459, x1497);
  uint32_t x1525;
  fiat_p384_uint1 x1526;
  fiat_p384_addcarryx_u32(&x1525, &x1526, x1524, x1460, 0x0);
  uint32_t x1527;
  uint32_t x1528;
  fiat_p384_mulx_u32(&x1527, &x1528, x11, (arg2[11]));
  uint32_t x1529;
  uint32_t x1530;
  fiat_p384_mulx_u32(&x1529, &x1530, x11, (arg2[10]));
  uint32_t x1531;
  uint32_t x1532;
  fiat_p384_mulx_u32(&x1531, &x1532, x11, (arg2[9]));
  uint32_t x1533;
  uint32_t x1534;
  fiat_p384_mulx_u32(&x1533, &x1534, x11, (arg2[8]));
  uint32_t x1535;
  uint32_t x1536;
  fiat_p384_mulx_u32(&x1535, &x1536, x11, (arg2[7]));
  uint32_t x1537;
  uint32_t x1538;
  fiat_p384_mulx_u32(&x1537, &x1538, x11, (arg2[6]));
  uint32_t x1539;
  uint32_t x1540;
  fiat_p384_mulx_u32(&x1539, &x1540, x11, (arg2[5]));
  uint32_t x1541;
  uint32_t x1542;
  fiat_p384_mulx_u32(&x1541, &x1542, x11, (arg2[4]));
  uint32_t x1543;
  uint32_t x1544;
  fiat_p384_mulx_u32(&x1543, &x1544, x11, (arg2[3]));
  uint32_t x1545;
  uint32_t x1546;
  fiat_p384_mulx_u32(&x1545, &x1546, x11, (arg2[2]));
  uint32_t x1547;
  uint32_t x1548;
  fiat_p384_mulx_u32(&x1547, &x1548, x11, (arg2[1]));
  uint32_t x1549;
  uint32_t x1550;
  fiat_p384_mulx_u32(&x1549, &x1550, x11, (arg2[0]));
  uint32_t x1551;
  fiat_p384_uint1 x1552;
  fiat_p384_addcarryx_u32(&x1551, &x1552, 0x0, x1550, x1547);
  uint32_t x1553;
  fiat_p384_uint1 x1554;
  fiat_p384_addcarryx_u32(&x1553, &x1554, x1552, x1548, x1545);
  uint32_t x1555;
  fiat_p384_uint1 x1556;
  fiat_p384_addcarryx_u32(&x1555, &x1556, x1554, x1546, x1543);
  uint32_t x1557;
  fiat_p384_uint1 x1558;
  fiat_p384_addcarryx_u32(&x1557, &x1558, x1556, x1544, x1541);
  uint32_t x1559;
  fiat_p384_uint1 x1560;
  fiat_p384_addcarryx_u32(&x1559, &x1560, x1558, x1542, x1539);
  uint32_t x1561;
  fiat_p384_uint1 x1562;
  fiat_p384_addcarryx_u32(&x1561, &x1562, x1560, x1540, x1537);
  uint32_t x1563;
  fiat_p384_uint1 x1564;
  fiat_p384_addcarryx_u32(&x1563, &x1564, x1562, x1538, x1535);
  uint32_t x1565;
  fiat_p384_uint1 x1566;
  fiat_p384_addcarryx_u32(&x1565, &x1566, x1564, x1536, x1533);
  uint32_t x1567;
  fiat_p384_uint1 x1568;
  fiat_p384_addcarryx_u32(&x1567, &x1568, x1566, x1534, x1531);
  uint32_t x1569;
  fiat_p384_uint1 x1570;
  fiat_p384_addcarryx_u32(&x1569, &x1570, x1568, x1532, x1529);
  uint32_t x1571;
  fiat_p384_uint1 x1572;
  fiat_p384_addcarryx_u32(&x1571, &x1572, x1570, x1530, x1527);
  uint32_t x1573;
  fiat_p384_uint1 x1574;
  fiat_p384_addcarryx_u32(&x1573, &x1574, x1572, x1528, 0x0);
  uint32_t x1575;
  fiat_p384_uint1 x1576;
  fiat_p384_addcarryx_u32(&x1575, &x1576, 0x0, x1501, x1549);
  uint32_t x1577;
  fiat_p384_uint1 x1578;
  fiat_p384_addcarryx_u32(&x1577, &x1578, x1576, x1503, x1551);
  uint32_t x1579;
  fiat_p384_uint1 x1580;
  fiat_p384_addcarryx_u32(&x1579, &x1580, x1578, x1505, x1553);
  uint32_t x1581;
  fiat_p384_uint1 x1582;
  fiat_p384_addcarryx_u32(&x1581, &x1582, x1580, x1507, x1555);
  uint32_t x1583;
  fiat_p384_uint1 x1584;
  fiat_p384_addcarryx_u32(&x1583, &x1584, x1582, x1509, x1557);
  uint32_t x1585;
  fiat_p384_uint1 x1586;
  fiat_p384_addcarryx_u32(&x1585, &x1586, x1584, x1511, x1559);
  uint32_t x1587;
  fiat_p384_uint1 x1588;
  fiat_p384_addcarryx_u32(&x1587, &x1588, x1586, x1513, x1561);
  uint32_t x1589;
  fiat_p384_uint1 x1590;
  fiat_p384_addcarryx_u32(&x1589, &x1590, x1588, x1515, x1563);
  uint32_t x1591;
  fiat_p384_uint1 x1592;
  fiat_p384_addcarryx_u32(&x1591, &x1592, x1590, x1517, x1565);
  uint32_t x1593;
  fiat_p384_uint1 x1594;
  fiat_p384_addcarryx_u32(&x1593, &x1594, x1592, x1519, x1567);
  uint32_t x1595;
  fiat_p384_uint1 x1596;
  fiat_p384_addcarryx_u32(&x1595, &x1596, x1594, x1521, x1569);
  uint32_t x1597;
  fiat_p384_uint1 x1598;
  fiat_p384_addcarryx_u32(&x1597, &x1598, x1596, x1523, x1571);
  uint32_t x1599;
  fiat_p384_uint1 x1600;
  fiat_p384_addcarryx_u32(&x1599, &x1600, x1598, x1525, x1573);
  uint32_t x1601;
  uint32_t x1602;
  fiat_p384_mulx_u32(&x1601, &x1602, x1575, UINT32_C(0xffffffff));
  uint32_t x1603;
  uint32_t x1604;
  fiat_p384_mulx_u32(&x1603, &x1604, x1575, UINT32_C(0xffffffff));
  uint32_t x1605;
  uint32_t x1606;
  fiat_p384_mulx_u32(&x1605, &x1606, x1575, UINT32_C(0xffffffff));
  uint32_t x1607;
  uint32_t x1608;
  fiat_p384_mulx_u32(&x1607, &x1608, x1575, UINT32_C(0xffffffff));
  uint32_t x1609;
  uint32_t x1610;
  fiat_p384_mulx_u32(&x1609, &x1610, x1575, UINT32_C(0xffffffff));
  uint32_t x1611;
  uint32_t x1612;
  fiat_p384_mulx_u32(&x1611, &x1612, x1575, UINT32_C(0xffffffff));
  uint32_t x1613;
  uint32_t x1614;
  fiat_p384_mulx_u32(&x1613, &x1614, x1575, UINT32_C(0xffffffff));
  uint32_t x1615;
  uint32_t x1616;
  fiat_p384_mulx_u32(&x1615, &x1616, x1575, UINT32_C(0xfffffffe));
  uint32_t x1617;
  uint32_t x1618;
  fiat_p384_mulx_u32(&x1617, &x1618, x1575, UINT32_C(0xffffffff));
  uint32_t x1619;
  uint32_t x1620;
  fiat_p384_mulx_u32(&x1619, &x1620, x1575, UINT32_C(0xffffffff));
  uint32_t x1621;
  fiat_p384_uint1 x1622;
  fiat_p384_addcarryx_u32(&x1621, &x1622, 0x0, x1618, x1615);
  uint32_t x1623;
  fiat_p384_uint1 x1624;
  fiat_p384_addcarryx_u32(&x1623, &x1624, x1622, x1616, x1613);
  uint32_t x1625;
  fiat_p384_uint1 x1626;
  fiat_p384_addcarryx_u32(&x1625, &x1626, x1624, x1614, x1611);
  uint32_t x1627;
  fiat_p384_uint1 x1628;
  fiat_p384_addcarryx_u32(&x1627, &x1628, x1626, x1612, x1609);
  uint32_t x1629;
  fiat_p384_uint1 x1630;
  fiat_p384_addcarryx_u32(&x1629, &x1630, x1628, x1610, x1607);
  uint32_t x1631;
  fiat_p384_uint1 x1632;
  fiat_p384_addcarryx_u32(&x1631, &x1632, x1630, x1608, x1605);
  uint32_t x1633;
  fiat_p384_uint1 x1634;
  fiat_p384_addcarryx_u32(&x1633, &x1634, x1632, x1606, x1603);
  uint32_t x1635;
  fiat_p384_uint1 x1636;
  fiat_p384_addcarryx_u32(&x1635, &x1636, x1634, x1604, x1601);
  uint32_t x1637;
  fiat_p384_uint1 x1638;
  fiat_p384_addcarryx_u32(&x1637, &x1638, x1636, x1602, 0x0);
  uint32_t x1639;
  fiat_p384_uint1 x1640;
  fiat_p384_addcarryx_u32(&x1639, &x1640, 0x0, x1575, x1619);
  uint32_t x1641;
  fiat_p384_uint1 x1642;
  fiat_p384_addcarryx_u32(&x1641, &x1642, x1640, x1577, x1620);
  uint32_t x1643;
  fiat_p384_uint1 x1644;
  fiat_p384_addcarryx_u32(&x1643, &x1644, x1642, x1579, 0x0);
  uint32_t x1645;
  fiat_p384_uint1 x1646;
  fiat_p384_addcarryx_u32(&x1645, &x1646, x1644, x1581, x1617);
  uint32_t x1647;
  fiat_p384_uint1 x1648;
  fiat_p384_addcarryx_u32(&x1647, &x1648, x1646, x1583, x1621);
  uint32_t x1649;
  fiat_p384_uint1 x1650;
  fiat_p384_addcarryx_u32(&x1649, &x1650, x1648, x1585, x1623);
  uint32_t x1651;
  fiat_p384_uint1 x1652;
  fiat_p384_addcarryx_u32(&x1651, &x1652, x1650, x1587, x1625);
  uint32_t x1653;
  fiat_p384_uint1 x1654;
  fiat_p384_addcarryx_u32(&x1653, &x1654, x1652, x1589, x1627);
  uint32_t x1655;
  fiat_p384_uint1 x1656;
  fiat_p384_addcarryx_u32(&x1655, &x1656, x1654, x1591, x1629);
  uint32_t x1657;
  fiat_p384_uint1 x1658;
  fiat_p384_addcarryx_u32(&x1657, &x1658, x1656, x1593, x1631);
  uint32_t x1659;
  fiat_p384_uint1 x1660;
  fiat_p384_addcarryx_u32(&x1659, &x1660, x1658, x1595, x1633);
  uint32_t x1661;
  fiat_p384_uint1 x1662;
  fiat_p384_addcarryx_u32(&x1661, &x1662, x1660, x1597, x1635);
  uint32_t x1663;
  fiat_p384_uint1 x1664;
  fiat_p384_addcarryx_u32(&x1663, &x1664, x1662, x1599, x1637);
  uint32_t x1665;
  fiat_p384_uint1 x1666;
  fiat_p384_addcarryx_u32(&x1665, &x1666, x1664, x1600, 0x0);
  uint32_t x1667;
  fiat_p384_uint1 x1668;
  fiat_p384_subborrowx_u32(&x1667, &x1668, 0x0, x1641, UINT32_C(0xffffffff));
  uint32_t x1669;
  fiat_p384_uint1 x1670;
  fiat_p384_subborrowx_u32(&x1669, &x1670, x1668, x1643, 0x0);
  uint32_t x1671;
  fiat_p384_uint1 x1672;
  fiat_p384_subborrowx_u32(&x1671, &x1672, x1670, x1645, 0x0);
  uint32_t x1673;
  fiat_p384_uint1 x1674;
  fiat_p384_subborrowx_u32(&x1673, &x1674, x1672, x1647, UINT32_C(0xffffffff));
  uint32_t x1675;
  fiat_p384_uint1 x1676;
  fiat_p384_subborrowx_u32(&x1675, &x1676, x1674, x1649, UINT32_C(0xfffffffe));
  uint32_t x1677;
  fiat_p384_uint1 x1678;
  fiat_p384_subborrowx_u32(&x1677, &x1678, x1676, x1651, UINT32_C(0xffffffff));
  uint32_t x1679;
  fiat_p384_uint1 x1680;
  fiat_p384_subborrowx_u32(&x1679, &x1680, x1678, x1653, UINT32_C(0xffffffff));
  uint32_t x1681;
  fiat_p384_uint1 x1682;
  fiat_p384_subborrowx_u32(&x1681, &x1682, x1680, x1655, UINT32_C(0xffffffff));
  uint32_t x1683;
  fiat_p384_uint1 x1684;
  fiat_p384_subborrowx_u32(&x1683, &x1684, x1682, x1657, UINT32_C(0xffffffff));
  uint32_t x1685;
  fiat_p384_uint1 x1686;
  fiat_p384_subborrowx_u32(&x1685, &x1686, x1684, x1659, UINT32_C(0xffffffff));
  uint32_t x1687;
  fiat_p384_uint1 x1688;
  fiat_p384_subborrowx_u32(&x1687, &x1688, x1686, x1661, UINT32_C(0xffffffff));
  uint32_t x1689;
  fiat_p384_uint1 x1690;
  fiat_p384_subborrowx_u32(&x1689, &x1690, x1688, x1663, UINT32_C(0xffffffff));
  uint32_t x1691;
  fiat_p384_uint1 x1692;
  fiat_p384_subborrowx_u32(&x1691, &x1692, x1690, x1665, 0x0);
  uint32_t x1693;
  fiat_p384_cmovznz_u32(&x1693, x1692, x1667, x1641);
  uint32_t x1694;
  fiat_p384_cmovznz_u32(&x1694, x1692, x1669, x1643);
  uint32_t x1695;
  fiat_p384_cmovznz_u32(&x1695, x1692, x1671, x1645);
  uint32_t x1696;
  fiat_p384_cmovznz_u32(&x1696, x1692, x1673, x1647);
  uint32_t x1697;
  fiat_p384_cmovznz_u32(&x1697, x1692, x1675, x1649);
  uint32_t x1698;
  fiat_p384_cmovznz_u32(&x1698, x1692, x1677, x1651);
  uint32_t x1699;
  fiat_p384_cmovznz_u32(&x1699, x1692, x1679, x1653);
  uint32_t x1700;
  fiat_p384_cmovznz_u32(&x1700, x1692, x1681, x1655);
  uint32_t x1701;
  fiat_p384_cmovznz_u32(&x1701, x1692, x1683, x1657);
  uint32_t x1702;
  fiat_p384_cmovznz_u32(&x1702, x1692, x1685, x1659);
  uint32_t x1703;
  fiat_p384_cmovznz_u32(&x1703, x1692, x1687, x1661);
  uint32_t x1704;
  fiat_p384_cmovznz_u32(&x1704, x1692, x1689, x1663);
  out1[0] = x1693;
  out1[1] = x1694;
  out1[2] = x1695;
  out1[3] = x1696;
  out1[4] = x1697;
  out1[5] = x1698;
  out1[6] = x1699;
  out1[7] = x1700;
  out1[8] = x1701;
  out1[9] = x1702;
  out1[10] = x1703;
  out1[11] = x1704;
}

/*
 * The function fiat_p384_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_square(uint32_t out1[12], const uint32_t arg1[12]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[7]);
  uint32_t x8 = (arg1[8]);
  uint32_t x9 = (arg1[9]);
  uint32_t x10 = (arg1[10]);
  uint32_t x11 = (arg1[11]);
  uint32_t x12 = (arg1[0]);
  uint32_t x13;
  uint32_t x14;
  fiat_p384_mulx_u32(&x13, &x14, x12, (arg1[11]));
  uint32_t x15;
  uint32_t x16;
  fiat_p384_mulx_u32(&x15, &x16, x12, (arg1[10]));
  uint32_t x17;
  uint32_t x18;
  fiat_p384_mulx_u32(&x17, &x18, x12, (arg1[9]));
  uint32_t x19;
  uint32_t x20;
  fiat_p384_mulx_u32(&x19, &x20, x12, (arg1[8]));
  uint32_t x21;
  uint32_t x22;
  fiat_p384_mulx_u32(&x21, &x22, x12, (arg1[7]));
  uint32_t x23;
  uint32_t x24;
  fiat_p384_mulx_u32(&x23, &x24, x12, (arg1[6]));
  uint32_t x25;
  uint32_t x26;
  fiat_p384_mulx_u32(&x25, &x26, x12, (arg1[5]));
  uint32_t x27;
  uint32_t x28;
  fiat_p384_mulx_u32(&x27, &x28, x12, (arg1[4]));
  uint32_t x29;
  uint32_t x30;
  fiat_p384_mulx_u32(&x29, &x30, x12, (arg1[3]));
  uint32_t x31;
  uint32_t x32;
  fiat_p384_mulx_u32(&x31, &x32, x12, (arg1[2]));
  uint32_t x33;
  uint32_t x34;
  fiat_p384_mulx_u32(&x33, &x34, x12, (arg1[1]));
  uint32_t x35;
  uint32_t x36;
  fiat_p384_mulx_u32(&x35, &x36, x12, (arg1[0]));
  uint32_t x37;
  fiat_p384_uint1 x38;
  fiat_p384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  uint32_t x39;
  fiat_p384_uint1 x40;
  fiat_p384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  uint32_t x41;
  fiat_p384_uint1 x42;
  fiat_p384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  uint32_t x43;
  fiat_p384_uint1 x44;
  fiat_p384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  uint32_t x45;
  fiat_p384_uint1 x46;
  fiat_p384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  uint32_t x47;
  fiat_p384_uint1 x48;
  fiat_p384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  uint32_t x49;
  fiat_p384_uint1 x50;
  fiat_p384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  uint32_t x51;
  fiat_p384_uint1 x52;
  fiat_p384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  uint32_t x53;
  fiat_p384_uint1 x54;
  fiat_p384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  uint32_t x55;
  fiat_p384_uint1 x56;
  fiat_p384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  uint32_t x57;
  fiat_p384_uint1 x58;
  fiat_p384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  uint32_t x59;
  fiat_p384_uint1 x60;
  fiat_p384_addcarryx_u32(&x59, &x60, x58, x14, 0x0);
  uint32_t x61;
  uint32_t x62;
  fiat_p384_mulx_u32(&x61, &x62, x35, UINT32_C(0xffffffff));
  uint32_t x63;
  uint32_t x64;
  fiat_p384_mulx_u32(&x63, &x64, x35, UINT32_C(0xffffffff));
  uint32_t x65;
  uint32_t x66;
  fiat_p384_mulx_u32(&x65, &x66, x35, UINT32_C(0xffffffff));
  uint32_t x67;
  uint32_t x68;
  fiat_p384_mulx_u32(&x67, &x68, x35, UINT32_C(0xffffffff));
  uint32_t x69;
  uint32_t x70;
  fiat_p384_mulx_u32(&x69, &x70, x35, UINT32_C(0xffffffff));
  uint32_t x71;
  uint32_t x72;
  fiat_p384_mulx_u32(&x71, &x72, x35, UINT32_C(0xffffffff));
  uint32_t x73;
  uint32_t x74;
  fiat_p384_mulx_u32(&x73, &x74, x35, UINT32_C(0xffffffff));
  uint32_t x75;
  uint32_t x76;
  fiat_p384_mulx_u32(&x75, &x76, x35, UINT32_C(0xfffffffe));
  uint32_t x77;
  uint32_t x78;
  fiat_p384_mulx_u32(&x77, &x78, x35, UINT32_C(0xffffffff));
  uint32_t x79;
  uint32_t x80;
  fiat_p384_mulx_u32(&x79, &x80, x35, UINT32_C(0xffffffff));
  uint32_t x81;
  fiat_p384_uint1 x82;
  fiat_p384_addcarryx_u32(&x81, &x82, 0x0, x78, x75);
  uint32_t x83;
  fiat_p384_uint1 x84;
  fiat_p384_addcarryx_u32(&x83, &x84, x82, x76, x73);
  uint32_t x85;
  fiat_p384_uint1 x86;
  fiat_p384_addcarryx_u32(&x85, &x86, x84, x74, x71);
  uint32_t x87;
  fiat_p384_uint1 x88;
  fiat_p384_addcarryx_u32(&x87, &x88, x86, x72, x69);
  uint32_t x89;
  fiat_p384_uint1 x90;
  fiat_p384_addcarryx_u32(&x89, &x90, x88, x70, x67);
  uint32_t x91;
  fiat_p384_uint1 x92;
  fiat_p384_addcarryx_u32(&x91, &x92, x90, x68, x65);
  uint32_t x93;
  fiat_p384_uint1 x94;
  fiat_p384_addcarryx_u32(&x93, &x94, x92, x66, x63);
  uint32_t x95;
  fiat_p384_uint1 x96;
  fiat_p384_addcarryx_u32(&x95, &x96, x94, x64, x61);
  uint32_t x97;
  fiat_p384_uint1 x98;
  fiat_p384_addcarryx_u32(&x97, &x98, x96, x62, 0x0);
  uint32_t x99;
  fiat_p384_uint1 x100;
  fiat_p384_addcarryx_u32(&x99, &x100, 0x0, x35, x79);
  uint32_t x101;
  fiat_p384_uint1 x102;
  fiat_p384_addcarryx_u32(&x101, &x102, x100, x37, x80);
  uint32_t x103;
  fiat_p384_uint1 x104;
  fiat_p384_addcarryx_u32(&x103, &x104, x102, x39, 0x0);
  uint32_t x105;
  fiat_p384_uint1 x106;
  fiat_p384_addcarryx_u32(&x105, &x106, x104, x41, x77);
  uint32_t x107;
  fiat_p384_uint1 x108;
  fiat_p384_addcarryx_u32(&x107, &x108, x106, x43, x81);
  uint32_t x109;
  fiat_p384_uint1 x110;
  fiat_p384_addcarryx_u32(&x109, &x110, x108, x45, x83);
  uint32_t x111;
  fiat_p384_uint1 x112;
  fiat_p384_addcarryx_u32(&x111, &x112, x110, x47, x85);
  uint32_t x113;
  fiat_p384_uint1 x114;
  fiat_p384_addcarryx_u32(&x113, &x114, x112, x49, x87);
  uint32_t x115;
  fiat_p384_uint1 x116;
  fiat_p384_addcarryx_u32(&x115, &x116, x114, x51, x89);
  uint32_t x117;
  fiat_p384_uint1 x118;
  fiat_p384_addcarryx_u32(&x117, &x118, x116, x53, x91);
  uint32_t x119;
  fiat_p384_uint1 x120;
  fiat_p384_addcarryx_u32(&x119, &x120, x118, x55, x93);
  uint32_t x121;
  fiat_p384_uint1 x122;
  fiat_p384_addcarryx_u32(&x121, &x122, x120, x57, x95);
  uint32_t x123;
  fiat_p384_uint1 x124;
  fiat_p384_addcarryx_u32(&x123, &x124, x122, x59, x97);
  uint32_t x125;
  fiat_p384_uint1 x126;
  fiat_p384_addcarryx_u32(&x125, &x126, x124, 0x0, 0x0);
  uint32_t x127;
  uint32_t x128;
  fiat_p384_mulx_u32(&x127, &x128, x1, (arg1[11]));
  uint32_t x129;
  uint32_t x130;
  fiat_p384_mulx_u32(&x129, &x130, x1, (arg1[10]));
  uint32_t x131;
  uint32_t x132;
  fiat_p384_mulx_u32(&x131, &x132, x1, (arg1[9]));
  uint32_t x133;
  uint32_t x134;
  fiat_p384_mulx_u32(&x133, &x134, x1, (arg1[8]));
  uint32_t x135;
  uint32_t x136;
  fiat_p384_mulx_u32(&x135, &x136, x1, (arg1[7]));
  uint32_t x137;
  uint32_t x138;
  fiat_p384_mulx_u32(&x137, &x138, x1, (arg1[6]));
  uint32_t x139;
  uint32_t x140;
  fiat_p384_mulx_u32(&x139, &x140, x1, (arg1[5]));
  uint32_t x141;
  uint32_t x142;
  fiat_p384_mulx_u32(&x141, &x142, x1, (arg1[4]));
  uint32_t x143;
  uint32_t x144;
  fiat_p384_mulx_u32(&x143, &x144, x1, (arg1[3]));
  uint32_t x145;
  uint32_t x146;
  fiat_p384_mulx_u32(&x145, &x146, x1, (arg1[2]));
  uint32_t x147;
  uint32_t x148;
  fiat_p384_mulx_u32(&x147, &x148, x1, (arg1[1]));
  uint32_t x149;
  uint32_t x150;
  fiat_p384_mulx_u32(&x149, &x150, x1, (arg1[0]));
  uint32_t x151;
  fiat_p384_uint1 x152;
  fiat_p384_addcarryx_u32(&x151, &x152, 0x0, x150, x147);
  uint32_t x153;
  fiat_p384_uint1 x154;
  fiat_p384_addcarryx_u32(&x153, &x154, x152, x148, x145);
  uint32_t x155;
  fiat_p384_uint1 x156;
  fiat_p384_addcarryx_u32(&x155, &x156, x154, x146, x143);
  uint32_t x157;
  fiat_p384_uint1 x158;
  fiat_p384_addcarryx_u32(&x157, &x158, x156, x144, x141);
  uint32_t x159;
  fiat_p384_uint1 x160;
  fiat_p384_addcarryx_u32(&x159, &x160, x158, x142, x139);
  uint32_t x161;
  fiat_p384_uint1 x162;
  fiat_p384_addcarryx_u32(&x161, &x162, x160, x140, x137);
  uint32_t x163;
  fiat_p384_uint1 x164;
  fiat_p384_addcarryx_u32(&x163, &x164, x162, x138, x135);
  uint32_t x165;
  fiat_p384_uint1 x166;
  fiat_p384_addcarryx_u32(&x165, &x166, x164, x136, x133);
  uint32_t x167;
  fiat_p384_uint1 x168;
  fiat_p384_addcarryx_u32(&x167, &x168, x166, x134, x131);
  uint32_t x169;
  fiat_p384_uint1 x170;
  fiat_p384_addcarryx_u32(&x169, &x170, x168, x132, x129);
  uint32_t x171;
  fiat_p384_uint1 x172;
  fiat_p384_addcarryx_u32(&x171, &x172, x170, x130, x127);
  uint32_t x173;
  fiat_p384_uint1 x174;
  fiat_p384_addcarryx_u32(&x173, &x174, x172, x128, 0x0);
  uint32_t x175;
  fiat_p384_uint1 x176;
  fiat_p384_addcarryx_u32(&x175, &x176, 0x0, x101, x149);
  uint32_t x177;
  fiat_p384_uint1 x178;
  fiat_p384_addcarryx_u32(&x177, &x178, x176, x103, x151);
  uint32_t x179;
  fiat_p384_uint1 x180;
  fiat_p384_addcarryx_u32(&x179, &x180, x178, x105, x153);
  uint32_t x181;
  fiat_p384_uint1 x182;
  fiat_p384_addcarryx_u32(&x181, &x182, x180, x107, x155);
  uint32_t x183;
  fiat_p384_uint1 x184;
  fiat_p384_addcarryx_u32(&x183, &x184, x182, x109, x157);
  uint32_t x185;
  fiat_p384_uint1 x186;
  fiat_p384_addcarryx_u32(&x185, &x186, x184, x111, x159);
  uint32_t x187;
  fiat_p384_uint1 x188;
  fiat_p384_addcarryx_u32(&x187, &x188, x186, x113, x161);
  uint32_t x189;
  fiat_p384_uint1 x190;
  fiat_p384_addcarryx_u32(&x189, &x190, x188, x115, x163);
  uint32_t x191;
  fiat_p384_uint1 x192;
  fiat_p384_addcarryx_u32(&x191, &x192, x190, x117, x165);
  uint32_t x193;
  fiat_p384_uint1 x194;
  fiat_p384_addcarryx_u32(&x193, &x194, x192, x119, x167);
  uint32_t x195;
  fiat_p384_uint1 x196;
  fiat_p384_addcarryx_u32(&x195, &x196, x194, x121, x169);
  uint32_t x197;
  fiat_p384_uint1 x198;
  fiat_p384_addcarryx_u32(&x197, &x198, x196, x123, x171);
  uint32_t x199;
  fiat_p384_uint1 x200;
  fiat_p384_addcarryx_u32(&x199, &x200, x198, (fiat_p384_uint1)x125, x173);
  uint32_t x201;
  uint32_t x202;
  fiat_p384_mulx_u32(&x201, &x202, x175, UINT32_C(0xffffffff));
  uint32_t x203;
  uint32_t x204;
  fiat_p384_mulx_u32(&x203, &x204, x175, UINT32_C(0xffffffff));
  uint32_t x205;
  uint32_t x206;
  fiat_p384_mulx_u32(&x205, &x206, x175, UINT32_C(0xffffffff));
  uint32_t x207;
  uint32_t x208;
  fiat_p384_mulx_u32(&x207, &x208, x175, UINT32_C(0xffffffff));
  uint32_t x209;
  uint32_t x210;
  fiat_p384_mulx_u32(&x209, &x210, x175, UINT32_C(0xffffffff));
  uint32_t x211;
  uint32_t x212;
  fiat_p384_mulx_u32(&x211, &x212, x175, UINT32_C(0xffffffff));
  uint32_t x213;
  uint32_t x214;
  fiat_p384_mulx_u32(&x213, &x214, x175, UINT32_C(0xffffffff));
  uint32_t x215;
  uint32_t x216;
  fiat_p384_mulx_u32(&x215, &x216, x175, UINT32_C(0xfffffffe));
  uint32_t x217;
  uint32_t x218;
  fiat_p384_mulx_u32(&x217, &x218, x175, UINT32_C(0xffffffff));
  uint32_t x219;
  uint32_t x220;
  fiat_p384_mulx_u32(&x219, &x220, x175, UINT32_C(0xffffffff));
  uint32_t x221;
  fiat_p384_uint1 x222;
  fiat_p384_addcarryx_u32(&x221, &x222, 0x0, x218, x215);
  uint32_t x223;
  fiat_p384_uint1 x224;
  fiat_p384_addcarryx_u32(&x223, &x224, x222, x216, x213);
  uint32_t x225;
  fiat_p384_uint1 x226;
  fiat_p384_addcarryx_u32(&x225, &x226, x224, x214, x211);
  uint32_t x227;
  fiat_p384_uint1 x228;
  fiat_p384_addcarryx_u32(&x227, &x228, x226, x212, x209);
  uint32_t x229;
  fiat_p384_uint1 x230;
  fiat_p384_addcarryx_u32(&x229, &x230, x228, x210, x207);
  uint32_t x231;
  fiat_p384_uint1 x232;
  fiat_p384_addcarryx_u32(&x231, &x232, x230, x208, x205);
  uint32_t x233;
  fiat_p384_uint1 x234;
  fiat_p384_addcarryx_u32(&x233, &x234, x232, x206, x203);
  uint32_t x235;
  fiat_p384_uint1 x236;
  fiat_p384_addcarryx_u32(&x235, &x236, x234, x204, x201);
  uint32_t x237;
  fiat_p384_uint1 x238;
  fiat_p384_addcarryx_u32(&x237, &x238, x236, x202, 0x0);
  uint32_t x239;
  fiat_p384_uint1 x240;
  fiat_p384_addcarryx_u32(&x239, &x240, 0x0, x175, x219);
  uint32_t x241;
  fiat_p384_uint1 x242;
  fiat_p384_addcarryx_u32(&x241, &x242, x240, x177, x220);
  uint32_t x243;
  fiat_p384_uint1 x244;
  fiat_p384_addcarryx_u32(&x243, &x244, x242, x179, 0x0);
  uint32_t x245;
  fiat_p384_uint1 x246;
  fiat_p384_addcarryx_u32(&x245, &x246, x244, x181, x217);
  uint32_t x247;
  fiat_p384_uint1 x248;
  fiat_p384_addcarryx_u32(&x247, &x248, x246, x183, x221);
  uint32_t x249;
  fiat_p384_uint1 x250;
  fiat_p384_addcarryx_u32(&x249, &x250, x248, x185, x223);
  uint32_t x251;
  fiat_p384_uint1 x252;
  fiat_p384_addcarryx_u32(&x251, &x252, x250, x187, x225);
  uint32_t x253;
  fiat_p384_uint1 x254;
  fiat_p384_addcarryx_u32(&x253, &x254, x252, x189, x227);
  uint32_t x255;
  fiat_p384_uint1 x256;
  fiat_p384_addcarryx_u32(&x255, &x256, x254, x191, x229);
  uint32_t x257;
  fiat_p384_uint1 x258;
  fiat_p384_addcarryx_u32(&x257, &x258, x256, x193, x231);
  uint32_t x259;
  fiat_p384_uint1 x260;
  fiat_p384_addcarryx_u32(&x259, &x260, x258, x195, x233);
  uint32_t x261;
  fiat_p384_uint1 x262;
  fiat_p384_addcarryx_u32(&x261, &x262, x260, x197, x235);
  uint32_t x263;
  fiat_p384_uint1 x264;
  fiat_p384_addcarryx_u32(&x263, &x264, x262, x199, x237);
  uint32_t x265;
  fiat_p384_uint1 x266;
  fiat_p384_addcarryx_u32(&x265, &x266, x264, x200, 0x0);
  uint32_t x267;
  uint32_t x268;
  fiat_p384_mulx_u32(&x267, &x268, x2, (arg1[11]));
  uint32_t x269;
  uint32_t x270;
  fiat_p384_mulx_u32(&x269, &x270, x2, (arg1[10]));
  uint32_t x271;
  uint32_t x272;
  fiat_p384_mulx_u32(&x271, &x272, x2, (arg1[9]));
  uint32_t x273;
  uint32_t x274;
  fiat_p384_mulx_u32(&x273, &x274, x2, (arg1[8]));
  uint32_t x275;
  uint32_t x276;
  fiat_p384_mulx_u32(&x275, &x276, x2, (arg1[7]));
  uint32_t x277;
  uint32_t x278;
  fiat_p384_mulx_u32(&x277, &x278, x2, (arg1[6]));
  uint32_t x279;
  uint32_t x280;
  fiat_p384_mulx_u32(&x279, &x280, x2, (arg1[5]));
  uint32_t x281;
  uint32_t x282;
  fiat_p384_mulx_u32(&x281, &x282, x2, (arg1[4]));
  uint32_t x283;
  uint32_t x284;
  fiat_p384_mulx_u32(&x283, &x284, x2, (arg1[3]));
  uint32_t x285;
  uint32_t x286;
  fiat_p384_mulx_u32(&x285, &x286, x2, (arg1[2]));
  uint32_t x287;
  uint32_t x288;
  fiat_p384_mulx_u32(&x287, &x288, x2, (arg1[1]));
  uint32_t x289;
  uint32_t x290;
  fiat_p384_mulx_u32(&x289, &x290, x2, (arg1[0]));
  uint32_t x291;
  fiat_p384_uint1 x292;
  fiat_p384_addcarryx_u32(&x291, &x292, 0x0, x290, x287);
  uint32_t x293;
  fiat_p384_uint1 x294;
  fiat_p384_addcarryx_u32(&x293, &x294, x292, x288, x285);
  uint32_t x295;
  fiat_p384_uint1 x296;
  fiat_p384_addcarryx_u32(&x295, &x296, x294, x286, x283);
  uint32_t x297;
  fiat_p384_uint1 x298;
  fiat_p384_addcarryx_u32(&x297, &x298, x296, x284, x281);
  uint32_t x299;
  fiat_p384_uint1 x300;
  fiat_p384_addcarryx_u32(&x299, &x300, x298, x282, x279);
  uint32_t x301;
  fiat_p384_uint1 x302;
  fiat_p384_addcarryx_u32(&x301, &x302, x300, x280, x277);
  uint32_t x303;
  fiat_p384_uint1 x304;
  fiat_p384_addcarryx_u32(&x303, &x304, x302, x278, x275);
  uint32_t x305;
  fiat_p384_uint1 x306;
  fiat_p384_addcarryx_u32(&x305, &x306, x304, x276, x273);
  uint32_t x307;
  fiat_p384_uint1 x308;
  fiat_p384_addcarryx_u32(&x307, &x308, x306, x274, x271);
  uint32_t x309;
  fiat_p384_uint1 x310;
  fiat_p384_addcarryx_u32(&x309, &x310, x308, x272, x269);
  uint32_t x311;
  fiat_p384_uint1 x312;
  fiat_p384_addcarryx_u32(&x311, &x312, x310, x270, x267);
  uint32_t x313;
  fiat_p384_uint1 x314;
  fiat_p384_addcarryx_u32(&x313, &x314, x312, x268, 0x0);
  uint32_t x315;
  fiat_p384_uint1 x316;
  fiat_p384_addcarryx_u32(&x315, &x316, 0x0, x241, x289);
  uint32_t x317;
  fiat_p384_uint1 x318;
  fiat_p384_addcarryx_u32(&x317, &x318, x316, x243, x291);
  uint32_t x319;
  fiat_p384_uint1 x320;
  fiat_p384_addcarryx_u32(&x319, &x320, x318, x245, x293);
  uint32_t x321;
  fiat_p384_uint1 x322;
  fiat_p384_addcarryx_u32(&x321, &x322, x320, x247, x295);
  uint32_t x323;
  fiat_p384_uint1 x324;
  fiat_p384_addcarryx_u32(&x323, &x324, x322, x249, x297);
  uint32_t x325;
  fiat_p384_uint1 x326;
  fiat_p384_addcarryx_u32(&x325, &x326, x324, x251, x299);
  uint32_t x327;
  fiat_p384_uint1 x328;
  fiat_p384_addcarryx_u32(&x327, &x328, x326, x253, x301);
  uint32_t x329;
  fiat_p384_uint1 x330;
  fiat_p384_addcarryx_u32(&x329, &x330, x328, x255, x303);
  uint32_t x331;
  fiat_p384_uint1 x332;
  fiat_p384_addcarryx_u32(&x331, &x332, x330, x257, x305);
  uint32_t x333;
  fiat_p384_uint1 x334;
  fiat_p384_addcarryx_u32(&x333, &x334, x332, x259, x307);
  uint32_t x335;
  fiat_p384_uint1 x336;
  fiat_p384_addcarryx_u32(&x335, &x336, x334, x261, x309);
  uint32_t x337;
  fiat_p384_uint1 x338;
  fiat_p384_addcarryx_u32(&x337, &x338, x336, x263, x311);
  uint32_t x339;
  fiat_p384_uint1 x340;
  fiat_p384_addcarryx_u32(&x339, &x340, x338, x265, x313);
  uint32_t x341;
  uint32_t x342;
  fiat_p384_mulx_u32(&x341, &x342, x315, UINT32_C(0xffffffff));
  uint32_t x343;
  uint32_t x344;
  fiat_p384_mulx_u32(&x343, &x344, x315, UINT32_C(0xffffffff));
  uint32_t x345;
  uint32_t x346;
  fiat_p384_mulx_u32(&x345, &x346, x315, UINT32_C(0xffffffff));
  uint32_t x347;
  uint32_t x348;
  fiat_p384_mulx_u32(&x347, &x348, x315, UINT32_C(0xffffffff));
  uint32_t x349;
  uint32_t x350;
  fiat_p384_mulx_u32(&x349, &x350, x315, UINT32_C(0xffffffff));
  uint32_t x351;
  uint32_t x352;
  fiat_p384_mulx_u32(&x351, &x352, x315, UINT32_C(0xffffffff));
  uint32_t x353;
  uint32_t x354;
  fiat_p384_mulx_u32(&x353, &x354, x315, UINT32_C(0xffffffff));
  uint32_t x355;
  uint32_t x356;
  fiat_p384_mulx_u32(&x355, &x356, x315, UINT32_C(0xfffffffe));
  uint32_t x357;
  uint32_t x358;
  fiat_p384_mulx_u32(&x357, &x358, x315, UINT32_C(0xffffffff));
  uint32_t x359;
  uint32_t x360;
  fiat_p384_mulx_u32(&x359, &x360, x315, UINT32_C(0xffffffff));
  uint32_t x361;
  fiat_p384_uint1 x362;
  fiat_p384_addcarryx_u32(&x361, &x362, 0x0, x358, x355);
  uint32_t x363;
  fiat_p384_uint1 x364;
  fiat_p384_addcarryx_u32(&x363, &x364, x362, x356, x353);
  uint32_t x365;
  fiat_p384_uint1 x366;
  fiat_p384_addcarryx_u32(&x365, &x366, x364, x354, x351);
  uint32_t x367;
  fiat_p384_uint1 x368;
  fiat_p384_addcarryx_u32(&x367, &x368, x366, x352, x349);
  uint32_t x369;
  fiat_p384_uint1 x370;
  fiat_p384_addcarryx_u32(&x369, &x370, x368, x350, x347);
  uint32_t x371;
  fiat_p384_uint1 x372;
  fiat_p384_addcarryx_u32(&x371, &x372, x370, x348, x345);
  uint32_t x373;
  fiat_p384_uint1 x374;
  fiat_p384_addcarryx_u32(&x373, &x374, x372, x346, x343);
  uint32_t x375;
  fiat_p384_uint1 x376;
  fiat_p384_addcarryx_u32(&x375, &x376, x374, x344, x341);
  uint32_t x377;
  fiat_p384_uint1 x378;
  fiat_p384_addcarryx_u32(&x377, &x378, x376, x342, 0x0);
  uint32_t x379;
  fiat_p384_uint1 x380;
  fiat_p384_addcarryx_u32(&x379, &x380, 0x0, x315, x359);
  uint32_t x381;
  fiat_p384_uint1 x382;
  fiat_p384_addcarryx_u32(&x381, &x382, x380, x317, x360);
  uint32_t x383;
  fiat_p384_uint1 x384;
  fiat_p384_addcarryx_u32(&x383, &x384, x382, x319, 0x0);
  uint32_t x385;
  fiat_p384_uint1 x386;
  fiat_p384_addcarryx_u32(&x385, &x386, x384, x321, x357);
  uint32_t x387;
  fiat_p384_uint1 x388;
  fiat_p384_addcarryx_u32(&x387, &x388, x386, x323, x361);
  uint32_t x389;
  fiat_p384_uint1 x390;
  fiat_p384_addcarryx_u32(&x389, &x390, x388, x325, x363);
  uint32_t x391;
  fiat_p384_uint1 x392;
  fiat_p384_addcarryx_u32(&x391, &x392, x390, x327, x365);
  uint32_t x393;
  fiat_p384_uint1 x394;
  fiat_p384_addcarryx_u32(&x393, &x394, x392, x329, x367);
  uint32_t x395;
  fiat_p384_uint1 x396;
  fiat_p384_addcarryx_u32(&x395, &x396, x394, x331, x369);
  uint32_t x397;
  fiat_p384_uint1 x398;
  fiat_p384_addcarryx_u32(&x397, &x398, x396, x333, x371);
  uint32_t x399;
  fiat_p384_uint1 x400;
  fiat_p384_addcarryx_u32(&x399, &x400, x398, x335, x373);
  uint32_t x401;
  fiat_p384_uint1 x402;
  fiat_p384_addcarryx_u32(&x401, &x402, x400, x337, x375);
  uint32_t x403;
  fiat_p384_uint1 x404;
  fiat_p384_addcarryx_u32(&x403, &x404, x402, x339, x377);
  uint32_t x405;
  fiat_p384_uint1 x406;
  fiat_p384_addcarryx_u32(&x405, &x406, x404, x340, 0x0);
  uint32_t x407;
  uint32_t x408;
  fiat_p384_mulx_u32(&x407, &x408, x3, (arg1[11]));
  uint32_t x409;
  uint32_t x410;
  fiat_p384_mulx_u32(&x409, &x410, x3, (arg1[10]));
  uint32_t x411;
  uint32_t x412;
  fiat_p384_mulx_u32(&x411, &x412, x3, (arg1[9]));
  uint32_t x413;
  uint32_t x414;
  fiat_p384_mulx_u32(&x413, &x414, x3, (arg1[8]));
  uint32_t x415;
  uint32_t x416;
  fiat_p384_mulx_u32(&x415, &x416, x3, (arg1[7]));
  uint32_t x417;
  uint32_t x418;
  fiat_p384_mulx_u32(&x417, &x418, x3, (arg1[6]));
  uint32_t x419;
  uint32_t x420;
  fiat_p384_mulx_u32(&x419, &x420, x3, (arg1[5]));
  uint32_t x421;
  uint32_t x422;
  fiat_p384_mulx_u32(&x421, &x422, x3, (arg1[4]));
  uint32_t x423;
  uint32_t x424;
  fiat_p384_mulx_u32(&x423, &x424, x3, (arg1[3]));
  uint32_t x425;
  uint32_t x426;
  fiat_p384_mulx_u32(&x425, &x426, x3, (arg1[2]));
  uint32_t x427;
  uint32_t x428;
  fiat_p384_mulx_u32(&x427, &x428, x3, (arg1[1]));
  uint32_t x429;
  uint32_t x430;
  fiat_p384_mulx_u32(&x429, &x430, x3, (arg1[0]));
  uint32_t x431;
  fiat_p384_uint1 x432;
  fiat_p384_addcarryx_u32(&x431, &x432, 0x0, x430, x427);
  uint32_t x433;
  fiat_p384_uint1 x434;
  fiat_p384_addcarryx_u32(&x433, &x434, x432, x428, x425);
  uint32_t x435;
  fiat_p384_uint1 x436;
  fiat_p384_addcarryx_u32(&x435, &x436, x434, x426, x423);
  uint32_t x437;
  fiat_p384_uint1 x438;
  fiat_p384_addcarryx_u32(&x437, &x438, x436, x424, x421);
  uint32_t x439;
  fiat_p384_uint1 x440;
  fiat_p384_addcarryx_u32(&x439, &x440, x438, x422, x419);
  uint32_t x441;
  fiat_p384_uint1 x442;
  fiat_p384_addcarryx_u32(&x441, &x442, x440, x420, x417);
  uint32_t x443;
  fiat_p384_uint1 x444;
  fiat_p384_addcarryx_u32(&x443, &x444, x442, x418, x415);
  uint32_t x445;
  fiat_p384_uint1 x446;
  fiat_p384_addcarryx_u32(&x445, &x446, x444, x416, x413);
  uint32_t x447;
  fiat_p384_uint1 x448;
  fiat_p384_addcarryx_u32(&x447, &x448, x446, x414, x411);
  uint32_t x449;
  fiat_p384_uint1 x450;
  fiat_p384_addcarryx_u32(&x449, &x450, x448, x412, x409);
  uint32_t x451;
  fiat_p384_uint1 x452;
  fiat_p384_addcarryx_u32(&x451, &x452, x450, x410, x407);
  uint32_t x453;
  fiat_p384_uint1 x454;
  fiat_p384_addcarryx_u32(&x453, &x454, x452, x408, 0x0);
  uint32_t x455;
  fiat_p384_uint1 x456;
  fiat_p384_addcarryx_u32(&x455, &x456, 0x0, x381, x429);
  uint32_t x457;
  fiat_p384_uint1 x458;
  fiat_p384_addcarryx_u32(&x457, &x458, x456, x383, x431);
  uint32_t x459;
  fiat_p384_uint1 x460;
  fiat_p384_addcarryx_u32(&x459, &x460, x458, x385, x433);
  uint32_t x461;
  fiat_p384_uint1 x462;
  fiat_p384_addcarryx_u32(&x461, &x462, x460, x387, x435);
  uint32_t x463;
  fiat_p384_uint1 x464;
  fiat_p384_addcarryx_u32(&x463, &x464, x462, x389, x437);
  uint32_t x465;
  fiat_p384_uint1 x466;
  fiat_p384_addcarryx_u32(&x465, &x466, x464, x391, x439);
  uint32_t x467;
  fiat_p384_uint1 x468;
  fiat_p384_addcarryx_u32(&x467, &x468, x466, x393, x441);
  uint32_t x469;
  fiat_p384_uint1 x470;
  fiat_p384_addcarryx_u32(&x469, &x470, x468, x395, x443);
  uint32_t x471;
  fiat_p384_uint1 x472;
  fiat_p384_addcarryx_u32(&x471, &x472, x470, x397, x445);
  uint32_t x473;
  fiat_p384_uint1 x474;
  fiat_p384_addcarryx_u32(&x473, &x474, x472, x399, x447);
  uint32_t x475;
  fiat_p384_uint1 x476;
  fiat_p384_addcarryx_u32(&x475, &x476, x474, x401, x449);
  uint32_t x477;
  fiat_p384_uint1 x478;
  fiat_p384_addcarryx_u32(&x477, &x478, x476, x403, x451);
  uint32_t x479;
  fiat_p384_uint1 x480;
  fiat_p384_addcarryx_u32(&x479, &x480, x478, x405, x453);
  uint32_t x481;
  uint32_t x482;
  fiat_p384_mulx_u32(&x481, &x482, x455, UINT32_C(0xffffffff));
  uint32_t x483;
  uint32_t x484;
  fiat_p384_mulx_u32(&x483, &x484, x455, UINT32_C(0xffffffff));
  uint32_t x485;
  uint32_t x486;
  fiat_p384_mulx_u32(&x485, &x486, x455, UINT32_C(0xffffffff));
  uint32_t x487;
  uint32_t x488;
  fiat_p384_mulx_u32(&x487, &x488, x455, UINT32_C(0xffffffff));
  uint32_t x489;
  uint32_t x490;
  fiat_p384_mulx_u32(&x489, &x490, x455, UINT32_C(0xffffffff));
  uint32_t x491;
  uint32_t x492;
  fiat_p384_mulx_u32(&x491, &x492, x455, UINT32_C(0xffffffff));
  uint32_t x493;
  uint32_t x494;
  fiat_p384_mulx_u32(&x493, &x494, x455, UINT32_C(0xffffffff));
  uint32_t x495;
  uint32_t x496;
  fiat_p384_mulx_u32(&x495, &x496, x455, UINT32_C(0xfffffffe));
  uint32_t x497;
  uint32_t x498;
  fiat_p384_mulx_u32(&x497, &x498, x455, UINT32_C(0xffffffff));
  uint32_t x499;
  uint32_t x500;
  fiat_p384_mulx_u32(&x499, &x500, x455, UINT32_C(0xffffffff));
  uint32_t x501;
  fiat_p384_uint1 x502;
  fiat_p384_addcarryx_u32(&x501, &x502, 0x0, x498, x495);
  uint32_t x503;
  fiat_p384_uint1 x504;
  fiat_p384_addcarryx_u32(&x503, &x504, x502, x496, x493);
  uint32_t x505;
  fiat_p384_uint1 x506;
  fiat_p384_addcarryx_u32(&x505, &x506, x504, x494, x491);
  uint32_t x507;
  fiat_p384_uint1 x508;
  fiat_p384_addcarryx_u32(&x507, &x508, x506, x492, x489);
  uint32_t x509;
  fiat_p384_uint1 x510;
  fiat_p384_addcarryx_u32(&x509, &x510, x508, x490, x487);
  uint32_t x511;
  fiat_p384_uint1 x512;
  fiat_p384_addcarryx_u32(&x511, &x512, x510, x488, x485);
  uint32_t x513;
  fiat_p384_uint1 x514;
  fiat_p384_addcarryx_u32(&x513, &x514, x512, x486, x483);
  uint32_t x515;
  fiat_p384_uint1 x516;
  fiat_p384_addcarryx_u32(&x515, &x516, x514, x484, x481);
  uint32_t x517;
  fiat_p384_uint1 x518;
  fiat_p384_addcarryx_u32(&x517, &x518, x516, x482, 0x0);
  uint32_t x519;
  fiat_p384_uint1 x520;
  fiat_p384_addcarryx_u32(&x519, &x520, 0x0, x455, x499);
  uint32_t x521;
  fiat_p384_uint1 x522;
  fiat_p384_addcarryx_u32(&x521, &x522, x520, x457, x500);
  uint32_t x523;
  fiat_p384_uint1 x524;
  fiat_p384_addcarryx_u32(&x523, &x524, x522, x459, 0x0);
  uint32_t x525;
  fiat_p384_uint1 x526;
  fiat_p384_addcarryx_u32(&x525, &x526, x524, x461, x497);
  uint32_t x527;
  fiat_p384_uint1 x528;
  fiat_p384_addcarryx_u32(&x527, &x528, x526, x463, x501);
  uint32_t x529;
  fiat_p384_uint1 x530;
  fiat_p384_addcarryx_u32(&x529, &x530, x528, x465, x503);
  uint32_t x531;
  fiat_p384_uint1 x532;
  fiat_p384_addcarryx_u32(&x531, &x532, x530, x467, x505);
  uint32_t x533;
  fiat_p384_uint1 x534;
  fiat_p384_addcarryx_u32(&x533, &x534, x532, x469, x507);
  uint32_t x535;
  fiat_p384_uint1 x536;
  fiat_p384_addcarryx_u32(&x535, &x536, x534, x471, x509);
  uint32_t x537;
  fiat_p384_uint1 x538;
  fiat_p384_addcarryx_u32(&x537, &x538, x536, x473, x511);
  uint32_t x539;
  fiat_p384_uint1 x540;
  fiat_p384_addcarryx_u32(&x539, &x540, x538, x475, x513);
  uint32_t x541;
  fiat_p384_uint1 x542;
  fiat_p384_addcarryx_u32(&x541, &x542, x540, x477, x515);
  uint32_t x543;
  fiat_p384_uint1 x544;
  fiat_p384_addcarryx_u32(&x543, &x544, x542, x479, x517);
  uint32_t x545;
  fiat_p384_uint1 x546;
  fiat_p384_addcarryx_u32(&x545, &x546, x544, x480, 0x0);
  uint32_t x547;
  uint32_t x548;
  fiat_p384_mulx_u32(&x547, &x548, x4, (arg1[11]));
  uint32_t x549;
  uint32_t x550;
  fiat_p384_mulx_u32(&x549, &x550, x4, (arg1[10]));
  uint32_t x551;
  uint32_t x552;
  fiat_p384_mulx_u32(&x551, &x552, x4, (arg1[9]));
  uint32_t x553;
  uint32_t x554;
  fiat_p384_mulx_u32(&x553, &x554, x4, (arg1[8]));
  uint32_t x555;
  uint32_t x556;
  fiat_p384_mulx_u32(&x555, &x556, x4, (arg1[7]));
  uint32_t x557;
  uint32_t x558;
  fiat_p384_mulx_u32(&x557, &x558, x4, (arg1[6]));
  uint32_t x559;
  uint32_t x560;
  fiat_p384_mulx_u32(&x559, &x560, x4, (arg1[5]));
  uint32_t x561;
  uint32_t x562;
  fiat_p384_mulx_u32(&x561, &x562, x4, (arg1[4]));
  uint32_t x563;
  uint32_t x564;
  fiat_p384_mulx_u32(&x563, &x564, x4, (arg1[3]));
  uint32_t x565;
  uint32_t x566;
  fiat_p384_mulx_u32(&x565, &x566, x4, (arg1[2]));
  uint32_t x567;
  uint32_t x568;
  fiat_p384_mulx_u32(&x567, &x568, x4, (arg1[1]));
  uint32_t x569;
  uint32_t x570;
  fiat_p384_mulx_u32(&x569, &x570, x4, (arg1[0]));
  uint32_t x571;
  fiat_p384_uint1 x572;
  fiat_p384_addcarryx_u32(&x571, &x572, 0x0, x570, x567);
  uint32_t x573;
  fiat_p384_uint1 x574;
  fiat_p384_addcarryx_u32(&x573, &x574, x572, x568, x565);
  uint32_t x575;
  fiat_p384_uint1 x576;
  fiat_p384_addcarryx_u32(&x575, &x576, x574, x566, x563);
  uint32_t x577;
  fiat_p384_uint1 x578;
  fiat_p384_addcarryx_u32(&x577, &x578, x576, x564, x561);
  uint32_t x579;
  fiat_p384_uint1 x580;
  fiat_p384_addcarryx_u32(&x579, &x580, x578, x562, x559);
  uint32_t x581;
  fiat_p384_uint1 x582;
  fiat_p384_addcarryx_u32(&x581, &x582, x580, x560, x557);
  uint32_t x583;
  fiat_p384_uint1 x584;
  fiat_p384_addcarryx_u32(&x583, &x584, x582, x558, x555);
  uint32_t x585;
  fiat_p384_uint1 x586;
  fiat_p384_addcarryx_u32(&x585, &x586, x584, x556, x553);
  uint32_t x587;
  fiat_p384_uint1 x588;
  fiat_p384_addcarryx_u32(&x587, &x588, x586, x554, x551);
  uint32_t x589;
  fiat_p384_uint1 x590;
  fiat_p384_addcarryx_u32(&x589, &x590, x588, x552, x549);
  uint32_t x591;
  fiat_p384_uint1 x592;
  fiat_p384_addcarryx_u32(&x591, &x592, x590, x550, x547);
  uint32_t x593;
  fiat_p384_uint1 x594;
  fiat_p384_addcarryx_u32(&x593, &x594, x592, x548, 0x0);
  uint32_t x595;
  fiat_p384_uint1 x596;
  fiat_p384_addcarryx_u32(&x595, &x596, 0x0, x521, x569);
  uint32_t x597;
  fiat_p384_uint1 x598;
  fiat_p384_addcarryx_u32(&x597, &x598, x596, x523, x571);
  uint32_t x599;
  fiat_p384_uint1 x600;
  fiat_p384_addcarryx_u32(&x599, &x600, x598, x525, x573);
  uint32_t x601;
  fiat_p384_uint1 x602;
  fiat_p384_addcarryx_u32(&x601, &x602, x600, x527, x575);
  uint32_t x603;
  fiat_p384_uint1 x604;
  fiat_p384_addcarryx_u32(&x603, &x604, x602, x529, x577);
  uint32_t x605;
  fiat_p384_uint1 x606;
  fiat_p384_addcarryx_u32(&x605, &x606, x604, x531, x579);
  uint32_t x607;
  fiat_p384_uint1 x608;
  fiat_p384_addcarryx_u32(&x607, &x608, x606, x533, x581);
  uint32_t x609;
  fiat_p384_uint1 x610;
  fiat_p384_addcarryx_u32(&x609, &x610, x608, x535, x583);
  uint32_t x611;
  fiat_p384_uint1 x612;
  fiat_p384_addcarryx_u32(&x611, &x612, x610, x537, x585);
  uint32_t x613;
  fiat_p384_uint1 x614;
  fiat_p384_addcarryx_u32(&x613, &x614, x612, x539, x587);
  uint32_t x615;
  fiat_p384_uint1 x616;
  fiat_p384_addcarryx_u32(&x615, &x616, x614, x541, x589);
  uint32_t x617;
  fiat_p384_uint1 x618;
  fiat_p384_addcarryx_u32(&x617, &x618, x616, x543, x591);
  uint32_t x619;
  fiat_p384_uint1 x620;
  fiat_p384_addcarryx_u32(&x619, &x620, x618, x545, x593);
  uint32_t x621;
  uint32_t x622;
  fiat_p384_mulx_u32(&x621, &x622, x595, UINT32_C(0xffffffff));
  uint32_t x623;
  uint32_t x624;
  fiat_p384_mulx_u32(&x623, &x624, x595, UINT32_C(0xffffffff));
  uint32_t x625;
  uint32_t x626;
  fiat_p384_mulx_u32(&x625, &x626, x595, UINT32_C(0xffffffff));
  uint32_t x627;
  uint32_t x628;
  fiat_p384_mulx_u32(&x627, &x628, x595, UINT32_C(0xffffffff));
  uint32_t x629;
  uint32_t x630;
  fiat_p384_mulx_u32(&x629, &x630, x595, UINT32_C(0xffffffff));
  uint32_t x631;
  uint32_t x632;
  fiat_p384_mulx_u32(&x631, &x632, x595, UINT32_C(0xffffffff));
  uint32_t x633;
  uint32_t x634;
  fiat_p384_mulx_u32(&x633, &x634, x595, UINT32_C(0xffffffff));
  uint32_t x635;
  uint32_t x636;
  fiat_p384_mulx_u32(&x635, &x636, x595, UINT32_C(0xfffffffe));
  uint32_t x637;
  uint32_t x638;
  fiat_p384_mulx_u32(&x637, &x638, x595, UINT32_C(0xffffffff));
  uint32_t x639;
  uint32_t x640;
  fiat_p384_mulx_u32(&x639, &x640, x595, UINT32_C(0xffffffff));
  uint32_t x641;
  fiat_p384_uint1 x642;
  fiat_p384_addcarryx_u32(&x641, &x642, 0x0, x638, x635);
  uint32_t x643;
  fiat_p384_uint1 x644;
  fiat_p384_addcarryx_u32(&x643, &x644, x642, x636, x633);
  uint32_t x645;
  fiat_p384_uint1 x646;
  fiat_p384_addcarryx_u32(&x645, &x646, x644, x634, x631);
  uint32_t x647;
  fiat_p384_uint1 x648;
  fiat_p384_addcarryx_u32(&x647, &x648, x646, x632, x629);
  uint32_t x649;
  fiat_p384_uint1 x650;
  fiat_p384_addcarryx_u32(&x649, &x650, x648, x630, x627);
  uint32_t x651;
  fiat_p384_uint1 x652;
  fiat_p384_addcarryx_u32(&x651, &x652, x650, x628, x625);
  uint32_t x653;
  fiat_p384_uint1 x654;
  fiat_p384_addcarryx_u32(&x653, &x654, x652, x626, x623);
  uint32_t x655;
  fiat_p384_uint1 x656;
  fiat_p384_addcarryx_u32(&x655, &x656, x654, x624, x621);
  uint32_t x657;
  fiat_p384_uint1 x658;
  fiat_p384_addcarryx_u32(&x657, &x658, x656, x622, 0x0);
  uint32_t x659;
  fiat_p384_uint1 x660;
  fiat_p384_addcarryx_u32(&x659, &x660, 0x0, x595, x639);
  uint32_t x661;
  fiat_p384_uint1 x662;
  fiat_p384_addcarryx_u32(&x661, &x662, x660, x597, x640);
  uint32_t x663;
  fiat_p384_uint1 x664;
  fiat_p384_addcarryx_u32(&x663, &x664, x662, x599, 0x0);
  uint32_t x665;
  fiat_p384_uint1 x666;
  fiat_p384_addcarryx_u32(&x665, &x666, x664, x601, x637);
  uint32_t x667;
  fiat_p384_uint1 x668;
  fiat_p384_addcarryx_u32(&x667, &x668, x666, x603, x641);
  uint32_t x669;
  fiat_p384_uint1 x670;
  fiat_p384_addcarryx_u32(&x669, &x670, x668, x605, x643);
  uint32_t x671;
  fiat_p384_uint1 x672;
  fiat_p384_addcarryx_u32(&x671, &x672, x670, x607, x645);
  uint32_t x673;
  fiat_p384_uint1 x674;
  fiat_p384_addcarryx_u32(&x673, &x674, x672, x609, x647);
  uint32_t x675;
  fiat_p384_uint1 x676;
  fiat_p384_addcarryx_u32(&x675, &x676, x674, x611, x649);
  uint32_t x677;
  fiat_p384_uint1 x678;
  fiat_p384_addcarryx_u32(&x677, &x678, x676, x613, x651);
  uint32_t x679;
  fiat_p384_uint1 x680;
  fiat_p384_addcarryx_u32(&x679, &x680, x678, x615, x653);
  uint32_t x681;
  fiat_p384_uint1 x682;
  fiat_p384_addcarryx_u32(&x681, &x682, x680, x617, x655);
  uint32_t x683;
  fiat_p384_uint1 x684;
  fiat_p384_addcarryx_u32(&x683, &x684, x682, x619, x657);
  uint32_t x685;
  fiat_p384_uint1 x686;
  fiat_p384_addcarryx_u32(&x685, &x686, x684, x620, 0x0);
  uint32_t x687;
  uint32_t x688;
  fiat_p384_mulx_u32(&x687, &x688, x5, (arg1[11]));
  uint32_t x689;
  uint32_t x690;
  fiat_p384_mulx_u32(&x689, &x690, x5, (arg1[10]));
  uint32_t x691;
  uint32_t x692;
  fiat_p384_mulx_u32(&x691, &x692, x5, (arg1[9]));
  uint32_t x693;
  uint32_t x694;
  fiat_p384_mulx_u32(&x693, &x694, x5, (arg1[8]));
  uint32_t x695;
  uint32_t x696;
  fiat_p384_mulx_u32(&x695, &x696, x5, (arg1[7]));
  uint32_t x697;
  uint32_t x698;
  fiat_p384_mulx_u32(&x697, &x698, x5, (arg1[6]));
  uint32_t x699;
  uint32_t x700;
  fiat_p384_mulx_u32(&x699, &x700, x5, (arg1[5]));
  uint32_t x701;
  uint32_t x702;
  fiat_p384_mulx_u32(&x701, &x702, x5, (arg1[4]));
  uint32_t x703;
  uint32_t x704;
  fiat_p384_mulx_u32(&x703, &x704, x5, (arg1[3]));
  uint32_t x705;
  uint32_t x706;
  fiat_p384_mulx_u32(&x705, &x706, x5, (arg1[2]));
  uint32_t x707;
  uint32_t x708;
  fiat_p384_mulx_u32(&x707, &x708, x5, (arg1[1]));
  uint32_t x709;
  uint32_t x710;
  fiat_p384_mulx_u32(&x709, &x710, x5, (arg1[0]));
  uint32_t x711;
  fiat_p384_uint1 x712;
  fiat_p384_addcarryx_u32(&x711, &x712, 0x0, x710, x707);
  uint32_t x713;
  fiat_p384_uint1 x714;
  fiat_p384_addcarryx_u32(&x713, &x714, x712, x708, x705);
  uint32_t x715;
  fiat_p384_uint1 x716;
  fiat_p384_addcarryx_u32(&x715, &x716, x714, x706, x703);
  uint32_t x717;
  fiat_p384_uint1 x718;
  fiat_p384_addcarryx_u32(&x717, &x718, x716, x704, x701);
  uint32_t x719;
  fiat_p384_uint1 x720;
  fiat_p384_addcarryx_u32(&x719, &x720, x718, x702, x699);
  uint32_t x721;
  fiat_p384_uint1 x722;
  fiat_p384_addcarryx_u32(&x721, &x722, x720, x700, x697);
  uint32_t x723;
  fiat_p384_uint1 x724;
  fiat_p384_addcarryx_u32(&x723, &x724, x722, x698, x695);
  uint32_t x725;
  fiat_p384_uint1 x726;
  fiat_p384_addcarryx_u32(&x725, &x726, x724, x696, x693);
  uint32_t x727;
  fiat_p384_uint1 x728;
  fiat_p384_addcarryx_u32(&x727, &x728, x726, x694, x691);
  uint32_t x729;
  fiat_p384_uint1 x730;
  fiat_p384_addcarryx_u32(&x729, &x730, x728, x692, x689);
  uint32_t x731;
  fiat_p384_uint1 x732;
  fiat_p384_addcarryx_u32(&x731, &x732, x730, x690, x687);
  uint32_t x733;
  fiat_p384_uint1 x734;
  fiat_p384_addcarryx_u32(&x733, &x734, x732, x688, 0x0);
  uint32_t x735;
  fiat_p384_uint1 x736;
  fiat_p384_addcarryx_u32(&x735, &x736, 0x0, x661, x709);
  uint32_t x737;
  fiat_p384_uint1 x738;
  fiat_p384_addcarryx_u32(&x737, &x738, x736, x663, x711);
  uint32_t x739;
  fiat_p384_uint1 x740;
  fiat_p384_addcarryx_u32(&x739, &x740, x738, x665, x713);
  uint32_t x741;
  fiat_p384_uint1 x742;
  fiat_p384_addcarryx_u32(&x741, &x742, x740, x667, x715);
  uint32_t x743;
  fiat_p384_uint1 x744;
  fiat_p384_addcarryx_u32(&x743, &x744, x742, x669, x717);
  uint32_t x745;
  fiat_p384_uint1 x746;
  fiat_p384_addcarryx_u32(&x745, &x746, x744, x671, x719);
  uint32_t x747;
  fiat_p384_uint1 x748;
  fiat_p384_addcarryx_u32(&x747, &x748, x746, x673, x721);
  uint32_t x749;
  fiat_p384_uint1 x750;
  fiat_p384_addcarryx_u32(&x749, &x750, x748, x675, x723);
  uint32_t x751;
  fiat_p384_uint1 x752;
  fiat_p384_addcarryx_u32(&x751, &x752, x750, x677, x725);
  uint32_t x753;
  fiat_p384_uint1 x754;
  fiat_p384_addcarryx_u32(&x753, &x754, x752, x679, x727);
  uint32_t x755;
  fiat_p384_uint1 x756;
  fiat_p384_addcarryx_u32(&x755, &x756, x754, x681, x729);
  uint32_t x757;
  fiat_p384_uint1 x758;
  fiat_p384_addcarryx_u32(&x757, &x758, x756, x683, x731);
  uint32_t x759;
  fiat_p384_uint1 x760;
  fiat_p384_addcarryx_u32(&x759, &x760, x758, x685, x733);
  uint32_t x761;
  uint32_t x762;
  fiat_p384_mulx_u32(&x761, &x762, x735, UINT32_C(0xffffffff));
  uint32_t x763;
  uint32_t x764;
  fiat_p384_mulx_u32(&x763, &x764, x735, UINT32_C(0xffffffff));
  uint32_t x765;
  uint32_t x766;
  fiat_p384_mulx_u32(&x765, &x766, x735, UINT32_C(0xffffffff));
  uint32_t x767;
  uint32_t x768;
  fiat_p384_mulx_u32(&x767, &x768, x735, UINT32_C(0xffffffff));
  uint32_t x769;
  uint32_t x770;
  fiat_p384_mulx_u32(&x769, &x770, x735, UINT32_C(0xffffffff));
  uint32_t x771;
  uint32_t x772;
  fiat_p384_mulx_u32(&x771, &x772, x735, UINT32_C(0xffffffff));
  uint32_t x773;
  uint32_t x774;
  fiat_p384_mulx_u32(&x773, &x774, x735, UINT32_C(0xffffffff));
  uint32_t x775;
  uint32_t x776;
  fiat_p384_mulx_u32(&x775, &x776, x735, UINT32_C(0xfffffffe));
  uint32_t x777;
  uint32_t x778;
  fiat_p384_mulx_u32(&x777, &x778, x735, UINT32_C(0xffffffff));
  uint32_t x779;
  uint32_t x780;
  fiat_p384_mulx_u32(&x779, &x780, x735, UINT32_C(0xffffffff));
  uint32_t x781;
  fiat_p384_uint1 x782;
  fiat_p384_addcarryx_u32(&x781, &x782, 0x0, x778, x775);
  uint32_t x783;
  fiat_p384_uint1 x784;
  fiat_p384_addcarryx_u32(&x783, &x784, x782, x776, x773);
  uint32_t x785;
  fiat_p384_uint1 x786;
  fiat_p384_addcarryx_u32(&x785, &x786, x784, x774, x771);
  uint32_t x787;
  fiat_p384_uint1 x788;
  fiat_p384_addcarryx_u32(&x787, &x788, x786, x772, x769);
  uint32_t x789;
  fiat_p384_uint1 x790;
  fiat_p384_addcarryx_u32(&x789, &x790, x788, x770, x767);
  uint32_t x791;
  fiat_p384_uint1 x792;
  fiat_p384_addcarryx_u32(&x791, &x792, x790, x768, x765);
  uint32_t x793;
  fiat_p384_uint1 x794;
  fiat_p384_addcarryx_u32(&x793, &x794, x792, x766, x763);
  uint32_t x795;
  fiat_p384_uint1 x796;
  fiat_p384_addcarryx_u32(&x795, &x796, x794, x764, x761);
  uint32_t x797;
  fiat_p384_uint1 x798;
  fiat_p384_addcarryx_u32(&x797, &x798, x796, x762, 0x0);
  uint32_t x799;
  fiat_p384_uint1 x800;
  fiat_p384_addcarryx_u32(&x799, &x800, 0x0, x735, x779);
  uint32_t x801;
  fiat_p384_uint1 x802;
  fiat_p384_addcarryx_u32(&x801, &x802, x800, x737, x780);
  uint32_t x803;
  fiat_p384_uint1 x804;
  fiat_p384_addcarryx_u32(&x803, &x804, x802, x739, 0x0);
  uint32_t x805;
  fiat_p384_uint1 x806;
  fiat_p384_addcarryx_u32(&x805, &x806, x804, x741, x777);
  uint32_t x807;
  fiat_p384_uint1 x808;
  fiat_p384_addcarryx_u32(&x807, &x808, x806, x743, x781);
  uint32_t x809;
  fiat_p384_uint1 x810;
  fiat_p384_addcarryx_u32(&x809, &x810, x808, x745, x783);
  uint32_t x811;
  fiat_p384_uint1 x812;
  fiat_p384_addcarryx_u32(&x811, &x812, x810, x747, x785);
  uint32_t x813;
  fiat_p384_uint1 x814;
  fiat_p384_addcarryx_u32(&x813, &x814, x812, x749, x787);
  uint32_t x815;
  fiat_p384_uint1 x816;
  fiat_p384_addcarryx_u32(&x815, &x816, x814, x751, x789);
  uint32_t x817;
  fiat_p384_uint1 x818;
  fiat_p384_addcarryx_u32(&x817, &x818, x816, x753, x791);
  uint32_t x819;
  fiat_p384_uint1 x820;
  fiat_p384_addcarryx_u32(&x819, &x820, x818, x755, x793);
  uint32_t x821;
  fiat_p384_uint1 x822;
  fiat_p384_addcarryx_u32(&x821, &x822, x820, x757, x795);
  uint32_t x823;
  fiat_p384_uint1 x824;
  fiat_p384_addcarryx_u32(&x823, &x824, x822, x759, x797);
  uint32_t x825;
  fiat_p384_uint1 x826;
  fiat_p384_addcarryx_u32(&x825, &x826, x824, x760, 0x0);
  uint32_t x827;
  uint32_t x828;
  fiat_p384_mulx_u32(&x827, &x828, x6, (arg1[11]));
  uint32_t x829;
  uint32_t x830;
  fiat_p384_mulx_u32(&x829, &x830, x6, (arg1[10]));
  uint32_t x831;
  uint32_t x832;
  fiat_p384_mulx_u32(&x831, &x832, x6, (arg1[9]));
  uint32_t x833;
  uint32_t x834;
  fiat_p384_mulx_u32(&x833, &x834, x6, (arg1[8]));
  uint32_t x835;
  uint32_t x836;
  fiat_p384_mulx_u32(&x835, &x836, x6, (arg1[7]));
  uint32_t x837;
  uint32_t x838;
  fiat_p384_mulx_u32(&x837, &x838, x6, (arg1[6]));
  uint32_t x839;
  uint32_t x840;
  fiat_p384_mulx_u32(&x839, &x840, x6, (arg1[5]));
  uint32_t x841;
  uint32_t x842;
  fiat_p384_mulx_u32(&x841, &x842, x6, (arg1[4]));
  uint32_t x843;
  uint32_t x844;
  fiat_p384_mulx_u32(&x843, &x844, x6, (arg1[3]));
  uint32_t x845;
  uint32_t x846;
  fiat_p384_mulx_u32(&x845, &x846, x6, (arg1[2]));
  uint32_t x847;
  uint32_t x848;
  fiat_p384_mulx_u32(&x847, &x848, x6, (arg1[1]));
  uint32_t x849;
  uint32_t x850;
  fiat_p384_mulx_u32(&x849, &x850, x6, (arg1[0]));
  uint32_t x851;
  fiat_p384_uint1 x852;
  fiat_p384_addcarryx_u32(&x851, &x852, 0x0, x850, x847);
  uint32_t x853;
  fiat_p384_uint1 x854;
  fiat_p384_addcarryx_u32(&x853, &x854, x852, x848, x845);
  uint32_t x855;
  fiat_p384_uint1 x856;
  fiat_p384_addcarryx_u32(&x855, &x856, x854, x846, x843);
  uint32_t x857;
  fiat_p384_uint1 x858;
  fiat_p384_addcarryx_u32(&x857, &x858, x856, x844, x841);
  uint32_t x859;
  fiat_p384_uint1 x860;
  fiat_p384_addcarryx_u32(&x859, &x860, x858, x842, x839);
  uint32_t x861;
  fiat_p384_uint1 x862;
  fiat_p384_addcarryx_u32(&x861, &x862, x860, x840, x837);
  uint32_t x863;
  fiat_p384_uint1 x864;
  fiat_p384_addcarryx_u32(&x863, &x864, x862, x838, x835);
  uint32_t x865;
  fiat_p384_uint1 x866;
  fiat_p384_addcarryx_u32(&x865, &x866, x864, x836, x833);
  uint32_t x867;
  fiat_p384_uint1 x868;
  fiat_p384_addcarryx_u32(&x867, &x868, x866, x834, x831);
  uint32_t x869;
  fiat_p384_uint1 x870;
  fiat_p384_addcarryx_u32(&x869, &x870, x868, x832, x829);
  uint32_t x871;
  fiat_p384_uint1 x872;
  fiat_p384_addcarryx_u32(&x871, &x872, x870, x830, x827);
  uint32_t x873;
  fiat_p384_uint1 x874;
  fiat_p384_addcarryx_u32(&x873, &x874, x872, x828, 0x0);
  uint32_t x875;
  fiat_p384_uint1 x876;
  fiat_p384_addcarryx_u32(&x875, &x876, 0x0, x801, x849);
  uint32_t x877;
  fiat_p384_uint1 x878;
  fiat_p384_addcarryx_u32(&x877, &x878, x876, x803, x851);
  uint32_t x879;
  fiat_p384_uint1 x880;
  fiat_p384_addcarryx_u32(&x879, &x880, x878, x805, x853);
  uint32_t x881;
  fiat_p384_uint1 x882;
  fiat_p384_addcarryx_u32(&x881, &x882, x880, x807, x855);
  uint32_t x883;
  fiat_p384_uint1 x884;
  fiat_p384_addcarryx_u32(&x883, &x884, x882, x809, x857);
  uint32_t x885;
  fiat_p384_uint1 x886;
  fiat_p384_addcarryx_u32(&x885, &x886, x884, x811, x859);
  uint32_t x887;
  fiat_p384_uint1 x888;
  fiat_p384_addcarryx_u32(&x887, &x888, x886, x813, x861);
  uint32_t x889;
  fiat_p384_uint1 x890;
  fiat_p384_addcarryx_u32(&x889, &x890, x888, x815, x863);
  uint32_t x891;
  fiat_p384_uint1 x892;
  fiat_p384_addcarryx_u32(&x891, &x892, x890, x817, x865);
  uint32_t x893;
  fiat_p384_uint1 x894;
  fiat_p384_addcarryx_u32(&x893, &x894, x892, x819, x867);
  uint32_t x895;
  fiat_p384_uint1 x896;
  fiat_p384_addcarryx_u32(&x895, &x896, x894, x821, x869);
  uint32_t x897;
  fiat_p384_uint1 x898;
  fiat_p384_addcarryx_u32(&x897, &x898, x896, x823, x871);
  uint32_t x899;
  fiat_p384_uint1 x900;
  fiat_p384_addcarryx_u32(&x899, &x900, x898, x825, x873);
  uint32_t x901;
  uint32_t x902;
  fiat_p384_mulx_u32(&x901, &x902, x875, UINT32_C(0xffffffff));
  uint32_t x903;
  uint32_t x904;
  fiat_p384_mulx_u32(&x903, &x904, x875, UINT32_C(0xffffffff));
  uint32_t x905;
  uint32_t x906;
  fiat_p384_mulx_u32(&x905, &x906, x875, UINT32_C(0xffffffff));
  uint32_t x907;
  uint32_t x908;
  fiat_p384_mulx_u32(&x907, &x908, x875, UINT32_C(0xffffffff));
  uint32_t x909;
  uint32_t x910;
  fiat_p384_mulx_u32(&x909, &x910, x875, UINT32_C(0xffffffff));
  uint32_t x911;
  uint32_t x912;
  fiat_p384_mulx_u32(&x911, &x912, x875, UINT32_C(0xffffffff));
  uint32_t x913;
  uint32_t x914;
  fiat_p384_mulx_u32(&x913, &x914, x875, UINT32_C(0xffffffff));
  uint32_t x915;
  uint32_t x916;
  fiat_p384_mulx_u32(&x915, &x916, x875, UINT32_C(0xfffffffe));
  uint32_t x917;
  uint32_t x918;
  fiat_p384_mulx_u32(&x917, &x918, x875, UINT32_C(0xffffffff));
  uint32_t x919;
  uint32_t x920;
  fiat_p384_mulx_u32(&x919, &x920, x875, UINT32_C(0xffffffff));
  uint32_t x921;
  fiat_p384_uint1 x922;
  fiat_p384_addcarryx_u32(&x921, &x922, 0x0, x918, x915);
  uint32_t x923;
  fiat_p384_uint1 x924;
  fiat_p384_addcarryx_u32(&x923, &x924, x922, x916, x913);
  uint32_t x925;
  fiat_p384_uint1 x926;
  fiat_p384_addcarryx_u32(&x925, &x926, x924, x914, x911);
  uint32_t x927;
  fiat_p384_uint1 x928;
  fiat_p384_addcarryx_u32(&x927, &x928, x926, x912, x909);
  uint32_t x929;
  fiat_p384_uint1 x930;
  fiat_p384_addcarryx_u32(&x929, &x930, x928, x910, x907);
  uint32_t x931;
  fiat_p384_uint1 x932;
  fiat_p384_addcarryx_u32(&x931, &x932, x930, x908, x905);
  uint32_t x933;
  fiat_p384_uint1 x934;
  fiat_p384_addcarryx_u32(&x933, &x934, x932, x906, x903);
  uint32_t x935;
  fiat_p384_uint1 x936;
  fiat_p384_addcarryx_u32(&x935, &x936, x934, x904, x901);
  uint32_t x937;
  fiat_p384_uint1 x938;
  fiat_p384_addcarryx_u32(&x937, &x938, x936, x902, 0x0);
  uint32_t x939;
  fiat_p384_uint1 x940;
  fiat_p384_addcarryx_u32(&x939, &x940, 0x0, x875, x919);
  uint32_t x941;
  fiat_p384_uint1 x942;
  fiat_p384_addcarryx_u32(&x941, &x942, x940, x877, x920);
  uint32_t x943;
  fiat_p384_uint1 x944;
  fiat_p384_addcarryx_u32(&x943, &x944, x942, x879, 0x0);
  uint32_t x945;
  fiat_p384_uint1 x946;
  fiat_p384_addcarryx_u32(&x945, &x946, x944, x881, x917);
  uint32_t x947;
  fiat_p384_uint1 x948;
  fiat_p384_addcarryx_u32(&x947, &x948, x946, x883, x921);
  uint32_t x949;
  fiat_p384_uint1 x950;
  fiat_p384_addcarryx_u32(&x949, &x950, x948, x885, x923);
  uint32_t x951;
  fiat_p384_uint1 x952;
  fiat_p384_addcarryx_u32(&x951, &x952, x950, x887, x925);
  uint32_t x953;
  fiat_p384_uint1 x954;
  fiat_p384_addcarryx_u32(&x953, &x954, x952, x889, x927);
  uint32_t x955;
  fiat_p384_uint1 x956;
  fiat_p384_addcarryx_u32(&x955, &x956, x954, x891, x929);
  uint32_t x957;
  fiat_p384_uint1 x958;
  fiat_p384_addcarryx_u32(&x957, &x958, x956, x893, x931);
  uint32_t x959;
  fiat_p384_uint1 x960;
  fiat_p384_addcarryx_u32(&x959, &x960, x958, x895, x933);
  uint32_t x961;
  fiat_p384_uint1 x962;
  fiat_p384_addcarryx_u32(&x961, &x962, x960, x897, x935);
  uint32_t x963;
  fiat_p384_uint1 x964;
  fiat_p384_addcarryx_u32(&x963, &x964, x962, x899, x937);
  uint32_t x965;
  fiat_p384_uint1 x966;
  fiat_p384_addcarryx_u32(&x965, &x966, x964, x900, 0x0);
  uint32_t x967;
  uint32_t x968;
  fiat_p384_mulx_u32(&x967, &x968, x7, (arg1[11]));
  uint32_t x969;
  uint32_t x970;
  fiat_p384_mulx_u32(&x969, &x970, x7, (arg1[10]));
  uint32_t x971;
  uint32_t x972;
  fiat_p384_mulx_u32(&x971, &x972, x7, (arg1[9]));
  uint32_t x973;
  uint32_t x974;
  fiat_p384_mulx_u32(&x973, &x974, x7, (arg1[8]));
  uint32_t x975;
  uint32_t x976;
  fiat_p384_mulx_u32(&x975, &x976, x7, (arg1[7]));
  uint32_t x977;
  uint32_t x978;
  fiat_p384_mulx_u32(&x977, &x978, x7, (arg1[6]));
  uint32_t x979;
  uint32_t x980;
  fiat_p384_mulx_u32(&x979, &x980, x7, (arg1[5]));
  uint32_t x981;
  uint32_t x982;
  fiat_p384_mulx_u32(&x981, &x982, x7, (arg1[4]));
  uint32_t x983;
  uint32_t x984;
  fiat_p384_mulx_u32(&x983, &x984, x7, (arg1[3]));
  uint32_t x985;
  uint32_t x986;
  fiat_p384_mulx_u32(&x985, &x986, x7, (arg1[2]));
  uint32_t x987;
  uint32_t x988;
  fiat_p384_mulx_u32(&x987, &x988, x7, (arg1[1]));
  uint32_t x989;
  uint32_t x990;
  fiat_p384_mulx_u32(&x989, &x990, x7, (arg1[0]));
  uint32_t x991;
  fiat_p384_uint1 x992;
  fiat_p384_addcarryx_u32(&x991, &x992, 0x0, x990, x987);
  uint32_t x993;
  fiat_p384_uint1 x994;
  fiat_p384_addcarryx_u32(&x993, &x994, x992, x988, x985);
  uint32_t x995;
  fiat_p384_uint1 x996;
  fiat_p384_addcarryx_u32(&x995, &x996, x994, x986, x983);
  uint32_t x997;
  fiat_p384_uint1 x998;
  fiat_p384_addcarryx_u32(&x997, &x998, x996, x984, x981);
  uint32_t x999;
  fiat_p384_uint1 x1000;
  fiat_p384_addcarryx_u32(&x999, &x1000, x998, x982, x979);
  uint32_t x1001;
  fiat_p384_uint1 x1002;
  fiat_p384_addcarryx_u32(&x1001, &x1002, x1000, x980, x977);
  uint32_t x1003;
  fiat_p384_uint1 x1004;
  fiat_p384_addcarryx_u32(&x1003, &x1004, x1002, x978, x975);
  uint32_t x1005;
  fiat_p384_uint1 x1006;
  fiat_p384_addcarryx_u32(&x1005, &x1006, x1004, x976, x973);
  uint32_t x1007;
  fiat_p384_uint1 x1008;
  fiat_p384_addcarryx_u32(&x1007, &x1008, x1006, x974, x971);
  uint32_t x1009;
  fiat_p384_uint1 x1010;
  fiat_p384_addcarryx_u32(&x1009, &x1010, x1008, x972, x969);
  uint32_t x1011;
  fiat_p384_uint1 x1012;
  fiat_p384_addcarryx_u32(&x1011, &x1012, x1010, x970, x967);
  uint32_t x1013;
  fiat_p384_uint1 x1014;
  fiat_p384_addcarryx_u32(&x1013, &x1014, x1012, x968, 0x0);
  uint32_t x1015;
  fiat_p384_uint1 x1016;
  fiat_p384_addcarryx_u32(&x1015, &x1016, 0x0, x941, x989);
  uint32_t x1017;
  fiat_p384_uint1 x1018;
  fiat_p384_addcarryx_u32(&x1017, &x1018, x1016, x943, x991);
  uint32_t x1019;
  fiat_p384_uint1 x1020;
  fiat_p384_addcarryx_u32(&x1019, &x1020, x1018, x945, x993);
  uint32_t x1021;
  fiat_p384_uint1 x1022;
  fiat_p384_addcarryx_u32(&x1021, &x1022, x1020, x947, x995);
  uint32_t x1023;
  fiat_p384_uint1 x1024;
  fiat_p384_addcarryx_u32(&x1023, &x1024, x1022, x949, x997);
  uint32_t x1025;
  fiat_p384_uint1 x1026;
  fiat_p384_addcarryx_u32(&x1025, &x1026, x1024, x951, x999);
  uint32_t x1027;
  fiat_p384_uint1 x1028;
  fiat_p384_addcarryx_u32(&x1027, &x1028, x1026, x953, x1001);
  uint32_t x1029;
  fiat_p384_uint1 x1030;
  fiat_p384_addcarryx_u32(&x1029, &x1030, x1028, x955, x1003);
  uint32_t x1031;
  fiat_p384_uint1 x1032;
  fiat_p384_addcarryx_u32(&x1031, &x1032, x1030, x957, x1005);
  uint32_t x1033;
  fiat_p384_uint1 x1034;
  fiat_p384_addcarryx_u32(&x1033, &x1034, x1032, x959, x1007);
  uint32_t x1035;
  fiat_p384_uint1 x1036;
  fiat_p384_addcarryx_u32(&x1035, &x1036, x1034, x961, x1009);
  uint32_t x1037;
  fiat_p384_uint1 x1038;
  fiat_p384_addcarryx_u32(&x1037, &x1038, x1036, x963, x1011);
  uint32_t x1039;
  fiat_p384_uint1 x1040;
  fiat_p384_addcarryx_u32(&x1039, &x1040, x1038, x965, x1013);
  uint32_t x1041;
  uint32_t x1042;
  fiat_p384_mulx_u32(&x1041, &x1042, x1015, UINT32_C(0xffffffff));
  uint32_t x1043;
  uint32_t x1044;
  fiat_p384_mulx_u32(&x1043, &x1044, x1015, UINT32_C(0xffffffff));
  uint32_t x1045;
  uint32_t x1046;
  fiat_p384_mulx_u32(&x1045, &x1046, x1015, UINT32_C(0xffffffff));
  uint32_t x1047;
  uint32_t x1048;
  fiat_p384_mulx_u32(&x1047, &x1048, x1015, UINT32_C(0xffffffff));
  uint32_t x1049;
  uint32_t x1050;
  fiat_p384_mulx_u32(&x1049, &x1050, x1015, UINT32_C(0xffffffff));
  uint32_t x1051;
  uint32_t x1052;
  fiat_p384_mulx_u32(&x1051, &x1052, x1015, UINT32_C(0xffffffff));
  uint32_t x1053;
  uint32_t x1054;
  fiat_p384_mulx_u32(&x1053, &x1054, x1015, UINT32_C(0xffffffff));
  uint32_t x1055;
  uint32_t x1056;
  fiat_p384_mulx_u32(&x1055, &x1056, x1015, UINT32_C(0xfffffffe));
  uint32_t x1057;
  uint32_t x1058;
  fiat_p384_mulx_u32(&x1057, &x1058, x1015, UINT32_C(0xffffffff));
  uint32_t x1059;
  uint32_t x1060;
  fiat_p384_mulx_u32(&x1059, &x1060, x1015, UINT32_C(0xffffffff));
  uint32_t x1061;
  fiat_p384_uint1 x1062;
  fiat_p384_addcarryx_u32(&x1061, &x1062, 0x0, x1058, x1055);
  uint32_t x1063;
  fiat_p384_uint1 x1064;
  fiat_p384_addcarryx_u32(&x1063, &x1064, x1062, x1056, x1053);
  uint32_t x1065;
  fiat_p384_uint1 x1066;
  fiat_p384_addcarryx_u32(&x1065, &x1066, x1064, x1054, x1051);
  uint32_t x1067;
  fiat_p384_uint1 x1068;
  fiat_p384_addcarryx_u32(&x1067, &x1068, x1066, x1052, x1049);
  uint32_t x1069;
  fiat_p384_uint1 x1070;
  fiat_p384_addcarryx_u32(&x1069, &x1070, x1068, x1050, x1047);
  uint32_t x1071;
  fiat_p384_uint1 x1072;
  fiat_p384_addcarryx_u32(&x1071, &x1072, x1070, x1048, x1045);
  uint32_t x1073;
  fiat_p384_uint1 x1074;
  fiat_p384_addcarryx_u32(&x1073, &x1074, x1072, x1046, x1043);
  uint32_t x1075;
  fiat_p384_uint1 x1076;
  fiat_p384_addcarryx_u32(&x1075, &x1076, x1074, x1044, x1041);
  uint32_t x1077;
  fiat_p384_uint1 x1078;
  fiat_p384_addcarryx_u32(&x1077, &x1078, x1076, x1042, 0x0);
  uint32_t x1079;
  fiat_p384_uint1 x1080;
  fiat_p384_addcarryx_u32(&x1079, &x1080, 0x0, x1015, x1059);
  uint32_t x1081;
  fiat_p384_uint1 x1082;
  fiat_p384_addcarryx_u32(&x1081, &x1082, x1080, x1017, x1060);
  uint32_t x1083;
  fiat_p384_uint1 x1084;
  fiat_p384_addcarryx_u32(&x1083, &x1084, x1082, x1019, 0x0);
  uint32_t x1085;
  fiat_p384_uint1 x1086;
  fiat_p384_addcarryx_u32(&x1085, &x1086, x1084, x1021, x1057);
  uint32_t x1087;
  fiat_p384_uint1 x1088;
  fiat_p384_addcarryx_u32(&x1087, &x1088, x1086, x1023, x1061);
  uint32_t x1089;
  fiat_p384_uint1 x1090;
  fiat_p384_addcarryx_u32(&x1089, &x1090, x1088, x1025, x1063);
  uint32_t x1091;
  fiat_p384_uint1 x1092;
  fiat_p384_addcarryx_u32(&x1091, &x1092, x1090, x1027, x1065);
  uint32_t x1093;
  fiat_p384_uint1 x1094;
  fiat_p384_addcarryx_u32(&x1093, &x1094, x1092, x1029, x1067);
  uint32_t x1095;
  fiat_p384_uint1 x1096;
  fiat_p384_addcarryx_u32(&x1095, &x1096, x1094, x1031, x1069);
  uint32_t x1097;
  fiat_p384_uint1 x1098;
  fiat_p384_addcarryx_u32(&x1097, &x1098, x1096, x1033, x1071);
  uint32_t x1099;
  fiat_p384_uint1 x1100;
  fiat_p384_addcarryx_u32(&x1099, &x1100, x1098, x1035, x1073);
  uint32_t x1101;
  fiat_p384_uint1 x1102;
  fiat_p384_addcarryx_u32(&x1101, &x1102, x1100, x1037, x1075);
  uint32_t x1103;
  fiat_p384_uint1 x1104;
  fiat_p384_addcarryx_u32(&x1103, &x1104, x1102, x1039, x1077);
  uint32_t x1105;
  fiat_p384_uint1 x1106;
  fiat_p384_addcarryx_u32(&x1105, &x1106, x1104, x1040, 0x0);
  uint32_t x1107;
  uint32_t x1108;
  fiat_p384_mulx_u32(&x1107, &x1108, x8, (arg1[11]));
  uint32_t x1109;
  uint32_t x1110;
  fiat_p384_mulx_u32(&x1109, &x1110, x8, (arg1[10]));
  uint32_t x1111;
  uint32_t x1112;
  fiat_p384_mulx_u32(&x1111, &x1112, x8, (arg1[9]));
  uint32_t x1113;
  uint32_t x1114;
  fiat_p384_mulx_u32(&x1113, &x1114, x8, (arg1[8]));
  uint32_t x1115;
  uint32_t x1116;
  fiat_p384_mulx_u32(&x1115, &x1116, x8, (arg1[7]));
  uint32_t x1117;
  uint32_t x1118;
  fiat_p384_mulx_u32(&x1117, &x1118, x8, (arg1[6]));
  uint32_t x1119;
  uint32_t x1120;
  fiat_p384_mulx_u32(&x1119, &x1120, x8, (arg1[5]));
  uint32_t x1121;
  uint32_t x1122;
  fiat_p384_mulx_u32(&x1121, &x1122, x8, (arg1[4]));
  uint32_t x1123;
  uint32_t x1124;
  fiat_p384_mulx_u32(&x1123, &x1124, x8, (arg1[3]));
  uint32_t x1125;
  uint32_t x1126;
  fiat_p384_mulx_u32(&x1125, &x1126, x8, (arg1[2]));
  uint32_t x1127;
  uint32_t x1128;
  fiat_p384_mulx_u32(&x1127, &x1128, x8, (arg1[1]));
  uint32_t x1129;
  uint32_t x1130;
  fiat_p384_mulx_u32(&x1129, &x1130, x8, (arg1[0]));
  uint32_t x1131;
  fiat_p384_uint1 x1132;
  fiat_p384_addcarryx_u32(&x1131, &x1132, 0x0, x1130, x1127);
  uint32_t x1133;
  fiat_p384_uint1 x1134;
  fiat_p384_addcarryx_u32(&x1133, &x1134, x1132, x1128, x1125);
  uint32_t x1135;
  fiat_p384_uint1 x1136;
  fiat_p384_addcarryx_u32(&x1135, &x1136, x1134, x1126, x1123);
  uint32_t x1137;
  fiat_p384_uint1 x1138;
  fiat_p384_addcarryx_u32(&x1137, &x1138, x1136, x1124, x1121);
  uint32_t x1139;
  fiat_p384_uint1 x1140;
  fiat_p384_addcarryx_u32(&x1139, &x1140, x1138, x1122, x1119);
  uint32_t x1141;
  fiat_p384_uint1 x1142;
  fiat_p384_addcarryx_u32(&x1141, &x1142, x1140, x1120, x1117);
  uint32_t x1143;
  fiat_p384_uint1 x1144;
  fiat_p384_addcarryx_u32(&x1143, &x1144, x1142, x1118, x1115);
  uint32_t x1145;
  fiat_p384_uint1 x1146;
  fiat_p384_addcarryx_u32(&x1145, &x1146, x1144, x1116, x1113);
  uint32_t x1147;
  fiat_p384_uint1 x1148;
  fiat_p384_addcarryx_u32(&x1147, &x1148, x1146, x1114, x1111);
  uint32_t x1149;
  fiat_p384_uint1 x1150;
  fiat_p384_addcarryx_u32(&x1149, &x1150, x1148, x1112, x1109);
  uint32_t x1151;
  fiat_p384_uint1 x1152;
  fiat_p384_addcarryx_u32(&x1151, &x1152, x1150, x1110, x1107);
  uint32_t x1153;
  fiat_p384_uint1 x1154;
  fiat_p384_addcarryx_u32(&x1153, &x1154, x1152, x1108, 0x0);
  uint32_t x1155;
  fiat_p384_uint1 x1156;
  fiat_p384_addcarryx_u32(&x1155, &x1156, 0x0, x1081, x1129);
  uint32_t x1157;
  fiat_p384_uint1 x1158;
  fiat_p384_addcarryx_u32(&x1157, &x1158, x1156, x1083, x1131);
  uint32_t x1159;
  fiat_p384_uint1 x1160;
  fiat_p384_addcarryx_u32(&x1159, &x1160, x1158, x1085, x1133);
  uint32_t x1161;
  fiat_p384_uint1 x1162;
  fiat_p384_addcarryx_u32(&x1161, &x1162, x1160, x1087, x1135);
  uint32_t x1163;
  fiat_p384_uint1 x1164;
  fiat_p384_addcarryx_u32(&x1163, &x1164, x1162, x1089, x1137);
  uint32_t x1165;
  fiat_p384_uint1 x1166;
  fiat_p384_addcarryx_u32(&x1165, &x1166, x1164, x1091, x1139);
  uint32_t x1167;
  fiat_p384_uint1 x1168;
  fiat_p384_addcarryx_u32(&x1167, &x1168, x1166, x1093, x1141);
  uint32_t x1169;
  fiat_p384_uint1 x1170;
  fiat_p384_addcarryx_u32(&x1169, &x1170, x1168, x1095, x1143);
  uint32_t x1171;
  fiat_p384_uint1 x1172;
  fiat_p384_addcarryx_u32(&x1171, &x1172, x1170, x1097, x1145);
  uint32_t x1173;
  fiat_p384_uint1 x1174;
  fiat_p384_addcarryx_u32(&x1173, &x1174, x1172, x1099, x1147);
  uint32_t x1175;
  fiat_p384_uint1 x1176;
  fiat_p384_addcarryx_u32(&x1175, &x1176, x1174, x1101, x1149);
  uint32_t x1177;
  fiat_p384_uint1 x1178;
  fiat_p384_addcarryx_u32(&x1177, &x1178, x1176, x1103, x1151);
  uint32_t x1179;
  fiat_p384_uint1 x1180;
  fiat_p384_addcarryx_u32(&x1179, &x1180, x1178, x1105, x1153);
  uint32_t x1181;
  uint32_t x1182;
  fiat_p384_mulx_u32(&x1181, &x1182, x1155, UINT32_C(0xffffffff));
  uint32_t x1183;
  uint32_t x1184;
  fiat_p384_mulx_u32(&x1183, &x1184, x1155, UINT32_C(0xffffffff));
  uint32_t x1185;
  uint32_t x1186;
  fiat_p384_mulx_u32(&x1185, &x1186, x1155, UINT32_C(0xffffffff));
  uint32_t x1187;
  uint32_t x1188;
  fiat_p384_mulx_u32(&x1187, &x1188, x1155, UINT32_C(0xffffffff));
  uint32_t x1189;
  uint32_t x1190;
  fiat_p384_mulx_u32(&x1189, &x1190, x1155, UINT32_C(0xffffffff));
  uint32_t x1191;
  uint32_t x1192;
  fiat_p384_mulx_u32(&x1191, &x1192, x1155, UINT32_C(0xffffffff));
  uint32_t x1193;
  uint32_t x1194;
  fiat_p384_mulx_u32(&x1193, &x1194, x1155, UINT32_C(0xffffffff));
  uint32_t x1195;
  uint32_t x1196;
  fiat_p384_mulx_u32(&x1195, &x1196, x1155, UINT32_C(0xfffffffe));
  uint32_t x1197;
  uint32_t x1198;
  fiat_p384_mulx_u32(&x1197, &x1198, x1155, UINT32_C(0xffffffff));
  uint32_t x1199;
  uint32_t x1200;
  fiat_p384_mulx_u32(&x1199, &x1200, x1155, UINT32_C(0xffffffff));
  uint32_t x1201;
  fiat_p384_uint1 x1202;
  fiat_p384_addcarryx_u32(&x1201, &x1202, 0x0, x1198, x1195);
  uint32_t x1203;
  fiat_p384_uint1 x1204;
  fiat_p384_addcarryx_u32(&x1203, &x1204, x1202, x1196, x1193);
  uint32_t x1205;
  fiat_p384_uint1 x1206;
  fiat_p384_addcarryx_u32(&x1205, &x1206, x1204, x1194, x1191);
  uint32_t x1207;
  fiat_p384_uint1 x1208;
  fiat_p384_addcarryx_u32(&x1207, &x1208, x1206, x1192, x1189);
  uint32_t x1209;
  fiat_p384_uint1 x1210;
  fiat_p384_addcarryx_u32(&x1209, &x1210, x1208, x1190, x1187);
  uint32_t x1211;
  fiat_p384_uint1 x1212;
  fiat_p384_addcarryx_u32(&x1211, &x1212, x1210, x1188, x1185);
  uint32_t x1213;
  fiat_p384_uint1 x1214;
  fiat_p384_addcarryx_u32(&x1213, &x1214, x1212, x1186, x1183);
  uint32_t x1215;
  fiat_p384_uint1 x1216;
  fiat_p384_addcarryx_u32(&x1215, &x1216, x1214, x1184, x1181);
  uint32_t x1217;
  fiat_p384_uint1 x1218;
  fiat_p384_addcarryx_u32(&x1217, &x1218, x1216, x1182, 0x0);
  uint32_t x1219;
  fiat_p384_uint1 x1220;
  fiat_p384_addcarryx_u32(&x1219, &x1220, 0x0, x1155, x1199);
  uint32_t x1221;
  fiat_p384_uint1 x1222;
  fiat_p384_addcarryx_u32(&x1221, &x1222, x1220, x1157, x1200);
  uint32_t x1223;
  fiat_p384_uint1 x1224;
  fiat_p384_addcarryx_u32(&x1223, &x1224, x1222, x1159, 0x0);
  uint32_t x1225;
  fiat_p384_uint1 x1226;
  fiat_p384_addcarryx_u32(&x1225, &x1226, x1224, x1161, x1197);
  uint32_t x1227;
  fiat_p384_uint1 x1228;
  fiat_p384_addcarryx_u32(&x1227, &x1228, x1226, x1163, x1201);
  uint32_t x1229;
  fiat_p384_uint1 x1230;
  fiat_p384_addcarryx_u32(&x1229, &x1230, x1228, x1165, x1203);
  uint32_t x1231;
  fiat_p384_uint1 x1232;
  fiat_p384_addcarryx_u32(&x1231, &x1232, x1230, x1167, x1205);
  uint32_t x1233;
  fiat_p384_uint1 x1234;
  fiat_p384_addcarryx_u32(&x1233, &x1234, x1232, x1169, x1207);
  uint32_t x1235;
  fiat_p384_uint1 x1236;
  fiat_p384_addcarryx_u32(&x1235, &x1236, x1234, x1171, x1209);
  uint32_t x1237;
  fiat_p384_uint1 x1238;
  fiat_p384_addcarryx_u32(&x1237, &x1238, x1236, x1173, x1211);
  uint32_t x1239;
  fiat_p384_uint1 x1240;
  fiat_p384_addcarryx_u32(&x1239, &x1240, x1238, x1175, x1213);
  uint32_t x1241;
  fiat_p384_uint1 x1242;
  fiat_p384_addcarryx_u32(&x1241, &x1242, x1240, x1177, x1215);
  uint32_t x1243;
  fiat_p384_uint1 x1244;
  fiat_p384_addcarryx_u32(&x1243, &x1244, x1242, x1179, x1217);
  uint32_t x1245;
  fiat_p384_uint1 x1246;
  fiat_p384_addcarryx_u32(&x1245, &x1246, x1244, x1180, 0x0);
  uint32_t x1247;
  uint32_t x1248;
  fiat_p384_mulx_u32(&x1247, &x1248, x9, (arg1[11]));
  uint32_t x1249;
  uint32_t x1250;
  fiat_p384_mulx_u32(&x1249, &x1250, x9, (arg1[10]));
  uint32_t x1251;
  uint32_t x1252;
  fiat_p384_mulx_u32(&x1251, &x1252, x9, (arg1[9]));
  uint32_t x1253;
  uint32_t x1254;
  fiat_p384_mulx_u32(&x1253, &x1254, x9, (arg1[8]));
  uint32_t x1255;
  uint32_t x1256;
  fiat_p384_mulx_u32(&x1255, &x1256, x9, (arg1[7]));
  uint32_t x1257;
  uint32_t x1258;
  fiat_p384_mulx_u32(&x1257, &x1258, x9, (arg1[6]));
  uint32_t x1259;
  uint32_t x1260;
  fiat_p384_mulx_u32(&x1259, &x1260, x9, (arg1[5]));
  uint32_t x1261;
  uint32_t x1262;
  fiat_p384_mulx_u32(&x1261, &x1262, x9, (arg1[4]));
  uint32_t x1263;
  uint32_t x1264;
  fiat_p384_mulx_u32(&x1263, &x1264, x9, (arg1[3]));
  uint32_t x1265;
  uint32_t x1266;
  fiat_p384_mulx_u32(&x1265, &x1266, x9, (arg1[2]));
  uint32_t x1267;
  uint32_t x1268;
  fiat_p384_mulx_u32(&x1267, &x1268, x9, (arg1[1]));
  uint32_t x1269;
  uint32_t x1270;
  fiat_p384_mulx_u32(&x1269, &x1270, x9, (arg1[0]));
  uint32_t x1271;
  fiat_p384_uint1 x1272;
  fiat_p384_addcarryx_u32(&x1271, &x1272, 0x0, x1270, x1267);
  uint32_t x1273;
  fiat_p384_uint1 x1274;
  fiat_p384_addcarryx_u32(&x1273, &x1274, x1272, x1268, x1265);
  uint32_t x1275;
  fiat_p384_uint1 x1276;
  fiat_p384_addcarryx_u32(&x1275, &x1276, x1274, x1266, x1263);
  uint32_t x1277;
  fiat_p384_uint1 x1278;
  fiat_p384_addcarryx_u32(&x1277, &x1278, x1276, x1264, x1261);
  uint32_t x1279;
  fiat_p384_uint1 x1280;
  fiat_p384_addcarryx_u32(&x1279, &x1280, x1278, x1262, x1259);
  uint32_t x1281;
  fiat_p384_uint1 x1282;
  fiat_p384_addcarryx_u32(&x1281, &x1282, x1280, x1260, x1257);
  uint32_t x1283;
  fiat_p384_uint1 x1284;
  fiat_p384_addcarryx_u32(&x1283, &x1284, x1282, x1258, x1255);
  uint32_t x1285;
  fiat_p384_uint1 x1286;
  fiat_p384_addcarryx_u32(&x1285, &x1286, x1284, x1256, x1253);
  uint32_t x1287;
  fiat_p384_uint1 x1288;
  fiat_p384_addcarryx_u32(&x1287, &x1288, x1286, x1254, x1251);
  uint32_t x1289;
  fiat_p384_uint1 x1290;
  fiat_p384_addcarryx_u32(&x1289, &x1290, x1288, x1252, x1249);
  uint32_t x1291;
  fiat_p384_uint1 x1292;
  fiat_p384_addcarryx_u32(&x1291, &x1292, x1290, x1250, x1247);
  uint32_t x1293;
  fiat_p384_uint1 x1294;
  fiat_p384_addcarryx_u32(&x1293, &x1294, x1292, x1248, 0x0);
  uint32_t x1295;
  fiat_p384_uint1 x1296;
  fiat_p384_addcarryx_u32(&x1295, &x1296, 0x0, x1221, x1269);
  uint32_t x1297;
  fiat_p384_uint1 x1298;
  fiat_p384_addcarryx_u32(&x1297, &x1298, x1296, x1223, x1271);
  uint32_t x1299;
  fiat_p384_uint1 x1300;
  fiat_p384_addcarryx_u32(&x1299, &x1300, x1298, x1225, x1273);
  uint32_t x1301;
  fiat_p384_uint1 x1302;
  fiat_p384_addcarryx_u32(&x1301, &x1302, x1300, x1227, x1275);
  uint32_t x1303;
  fiat_p384_uint1 x1304;
  fiat_p384_addcarryx_u32(&x1303, &x1304, x1302, x1229, x1277);
  uint32_t x1305;
  fiat_p384_uint1 x1306;
  fiat_p384_addcarryx_u32(&x1305, &x1306, x1304, x1231, x1279);
  uint32_t x1307;
  fiat_p384_uint1 x1308;
  fiat_p384_addcarryx_u32(&x1307, &x1308, x1306, x1233, x1281);
  uint32_t x1309;
  fiat_p384_uint1 x1310;
  fiat_p384_addcarryx_u32(&x1309, &x1310, x1308, x1235, x1283);
  uint32_t x1311;
  fiat_p384_uint1 x1312;
  fiat_p384_addcarryx_u32(&x1311, &x1312, x1310, x1237, x1285);
  uint32_t x1313;
  fiat_p384_uint1 x1314;
  fiat_p384_addcarryx_u32(&x1313, &x1314, x1312, x1239, x1287);
  uint32_t x1315;
  fiat_p384_uint1 x1316;
  fiat_p384_addcarryx_u32(&x1315, &x1316, x1314, x1241, x1289);
  uint32_t x1317;
  fiat_p384_uint1 x1318;
  fiat_p384_addcarryx_u32(&x1317, &x1318, x1316, x1243, x1291);
  uint32_t x1319;
  fiat_p384_uint1 x1320;
  fiat_p384_addcarryx_u32(&x1319, &x1320, x1318, x1245, x1293);
  uint32_t x1321;
  uint32_t x1322;
  fiat_p384_mulx_u32(&x1321, &x1322, x1295, UINT32_C(0xffffffff));
  uint32_t x1323;
  uint32_t x1324;
  fiat_p384_mulx_u32(&x1323, &x1324, x1295, UINT32_C(0xffffffff));
  uint32_t x1325;
  uint32_t x1326;
  fiat_p384_mulx_u32(&x1325, &x1326, x1295, UINT32_C(0xffffffff));
  uint32_t x1327;
  uint32_t x1328;
  fiat_p384_mulx_u32(&x1327, &x1328, x1295, UINT32_C(0xffffffff));
  uint32_t x1329;
  uint32_t x1330;
  fiat_p384_mulx_u32(&x1329, &x1330, x1295, UINT32_C(0xffffffff));
  uint32_t x1331;
  uint32_t x1332;
  fiat_p384_mulx_u32(&x1331, &x1332, x1295, UINT32_C(0xffffffff));
  uint32_t x1333;
  uint32_t x1334;
  fiat_p384_mulx_u32(&x1333, &x1334, x1295, UINT32_C(0xffffffff));
  uint32_t x1335;
  uint32_t x1336;
  fiat_p384_mulx_u32(&x1335, &x1336, x1295, UINT32_C(0xfffffffe));
  uint32_t x1337;
  uint32_t x1338;
  fiat_p384_mulx_u32(&x1337, &x1338, x1295, UINT32_C(0xffffffff));
  uint32_t x1339;
  uint32_t x1340;
  fiat_p384_mulx_u32(&x1339, &x1340, x1295, UINT32_C(0xffffffff));
  uint32_t x1341;
  fiat_p384_uint1 x1342;
  fiat_p384_addcarryx_u32(&x1341, &x1342, 0x0, x1338, x1335);
  uint32_t x1343;
  fiat_p384_uint1 x1344;
  fiat_p384_addcarryx_u32(&x1343, &x1344, x1342, x1336, x1333);
  uint32_t x1345;
  fiat_p384_uint1 x1346;
  fiat_p384_addcarryx_u32(&x1345, &x1346, x1344, x1334, x1331);
  uint32_t x1347;
  fiat_p384_uint1 x1348;
  fiat_p384_addcarryx_u32(&x1347, &x1348, x1346, x1332, x1329);
  uint32_t x1349;
  fiat_p384_uint1 x1350;
  fiat_p384_addcarryx_u32(&x1349, &x1350, x1348, x1330, x1327);
  uint32_t x1351;
  fiat_p384_uint1 x1352;
  fiat_p384_addcarryx_u32(&x1351, &x1352, x1350, x1328, x1325);
  uint32_t x1353;
  fiat_p384_uint1 x1354;
  fiat_p384_addcarryx_u32(&x1353, &x1354, x1352, x1326, x1323);
  uint32_t x1355;
  fiat_p384_uint1 x1356;
  fiat_p384_addcarryx_u32(&x1355, &x1356, x1354, x1324, x1321);
  uint32_t x1357;
  fiat_p384_uint1 x1358;
  fiat_p384_addcarryx_u32(&x1357, &x1358, x1356, x1322, 0x0);
  uint32_t x1359;
  fiat_p384_uint1 x1360;
  fiat_p384_addcarryx_u32(&x1359, &x1360, 0x0, x1295, x1339);
  uint32_t x1361;
  fiat_p384_uint1 x1362;
  fiat_p384_addcarryx_u32(&x1361, &x1362, x1360, x1297, x1340);
  uint32_t x1363;
  fiat_p384_uint1 x1364;
  fiat_p384_addcarryx_u32(&x1363, &x1364, x1362, x1299, 0x0);
  uint32_t x1365;
  fiat_p384_uint1 x1366;
  fiat_p384_addcarryx_u32(&x1365, &x1366, x1364, x1301, x1337);
  uint32_t x1367;
  fiat_p384_uint1 x1368;
  fiat_p384_addcarryx_u32(&x1367, &x1368, x1366, x1303, x1341);
  uint32_t x1369;
  fiat_p384_uint1 x1370;
  fiat_p384_addcarryx_u32(&x1369, &x1370, x1368, x1305, x1343);
  uint32_t x1371;
  fiat_p384_uint1 x1372;
  fiat_p384_addcarryx_u32(&x1371, &x1372, x1370, x1307, x1345);
  uint32_t x1373;
  fiat_p384_uint1 x1374;
  fiat_p384_addcarryx_u32(&x1373, &x1374, x1372, x1309, x1347);
  uint32_t x1375;
  fiat_p384_uint1 x1376;
  fiat_p384_addcarryx_u32(&x1375, &x1376, x1374, x1311, x1349);
  uint32_t x1377;
  fiat_p384_uint1 x1378;
  fiat_p384_addcarryx_u32(&x1377, &x1378, x1376, x1313, x1351);
  uint32_t x1379;
  fiat_p384_uint1 x1380;
  fiat_p384_addcarryx_u32(&x1379, &x1380, x1378, x1315, x1353);
  uint32_t x1381;
  fiat_p384_uint1 x1382;
  fiat_p384_addcarryx_u32(&x1381, &x1382, x1380, x1317, x1355);
  uint32_t x1383;
  fiat_p384_uint1 x1384;
  fiat_p384_addcarryx_u32(&x1383, &x1384, x1382, x1319, x1357);
  uint32_t x1385;
  fiat_p384_uint1 x1386;
  fiat_p384_addcarryx_u32(&x1385, &x1386, x1384, x1320, 0x0);
  uint32_t x1387;
  uint32_t x1388;
  fiat_p384_mulx_u32(&x1387, &x1388, x10, (arg1[11]));
  uint32_t x1389;
  uint32_t x1390;
  fiat_p384_mulx_u32(&x1389, &x1390, x10, (arg1[10]));
  uint32_t x1391;
  uint32_t x1392;
  fiat_p384_mulx_u32(&x1391, &x1392, x10, (arg1[9]));
  uint32_t x1393;
  uint32_t x1394;
  fiat_p384_mulx_u32(&x1393, &x1394, x10, (arg1[8]));
  uint32_t x1395;
  uint32_t x1396;
  fiat_p384_mulx_u32(&x1395, &x1396, x10, (arg1[7]));
  uint32_t x1397;
  uint32_t x1398;
  fiat_p384_mulx_u32(&x1397, &x1398, x10, (arg1[6]));
  uint32_t x1399;
  uint32_t x1400;
  fiat_p384_mulx_u32(&x1399, &x1400, x10, (arg1[5]));
  uint32_t x1401;
  uint32_t x1402;
  fiat_p384_mulx_u32(&x1401, &x1402, x10, (arg1[4]));
  uint32_t x1403;
  uint32_t x1404;
  fiat_p384_mulx_u32(&x1403, &x1404, x10, (arg1[3]));
  uint32_t x1405;
  uint32_t x1406;
  fiat_p384_mulx_u32(&x1405, &x1406, x10, (arg1[2]));
  uint32_t x1407;
  uint32_t x1408;
  fiat_p384_mulx_u32(&x1407, &x1408, x10, (arg1[1]));
  uint32_t x1409;
  uint32_t x1410;
  fiat_p384_mulx_u32(&x1409, &x1410, x10, (arg1[0]));
  uint32_t x1411;
  fiat_p384_uint1 x1412;
  fiat_p384_addcarryx_u32(&x1411, &x1412, 0x0, x1410, x1407);
  uint32_t x1413;
  fiat_p384_uint1 x1414;
  fiat_p384_addcarryx_u32(&x1413, &x1414, x1412, x1408, x1405);
  uint32_t x1415;
  fiat_p384_uint1 x1416;
  fiat_p384_addcarryx_u32(&x1415, &x1416, x1414, x1406, x1403);
  uint32_t x1417;
  fiat_p384_uint1 x1418;
  fiat_p384_addcarryx_u32(&x1417, &x1418, x1416, x1404, x1401);
  uint32_t x1419;
  fiat_p384_uint1 x1420;
  fiat_p384_addcarryx_u32(&x1419, &x1420, x1418, x1402, x1399);
  uint32_t x1421;
  fiat_p384_uint1 x1422;
  fiat_p384_addcarryx_u32(&x1421, &x1422, x1420, x1400, x1397);
  uint32_t x1423;
  fiat_p384_uint1 x1424;
  fiat_p384_addcarryx_u32(&x1423, &x1424, x1422, x1398, x1395);
  uint32_t x1425;
  fiat_p384_uint1 x1426;
  fiat_p384_addcarryx_u32(&x1425, &x1426, x1424, x1396, x1393);
  uint32_t x1427;
  fiat_p384_uint1 x1428;
  fiat_p384_addcarryx_u32(&x1427, &x1428, x1426, x1394, x1391);
  uint32_t x1429;
  fiat_p384_uint1 x1430;
  fiat_p384_addcarryx_u32(&x1429, &x1430, x1428, x1392, x1389);
  uint32_t x1431;
  fiat_p384_uint1 x1432;
  fiat_p384_addcarryx_u32(&x1431, &x1432, x1430, x1390, x1387);
  uint32_t x1433;
  fiat_p384_uint1 x1434;
  fiat_p384_addcarryx_u32(&x1433, &x1434, x1432, x1388, 0x0);
  uint32_t x1435;
  fiat_p384_uint1 x1436;
  fiat_p384_addcarryx_u32(&x1435, &x1436, 0x0, x1361, x1409);
  uint32_t x1437;
  fiat_p384_uint1 x1438;
  fiat_p384_addcarryx_u32(&x1437, &x1438, x1436, x1363, x1411);
  uint32_t x1439;
  fiat_p384_uint1 x1440;
  fiat_p384_addcarryx_u32(&x1439, &x1440, x1438, x1365, x1413);
  uint32_t x1441;
  fiat_p384_uint1 x1442;
  fiat_p384_addcarryx_u32(&x1441, &x1442, x1440, x1367, x1415);
  uint32_t x1443;
  fiat_p384_uint1 x1444;
  fiat_p384_addcarryx_u32(&x1443, &x1444, x1442, x1369, x1417);
  uint32_t x1445;
  fiat_p384_uint1 x1446;
  fiat_p384_addcarryx_u32(&x1445, &x1446, x1444, x1371, x1419);
  uint32_t x1447;
  fiat_p384_uint1 x1448;
  fiat_p384_addcarryx_u32(&x1447, &x1448, x1446, x1373, x1421);
  uint32_t x1449;
  fiat_p384_uint1 x1450;
  fiat_p384_addcarryx_u32(&x1449, &x1450, x1448, x1375, x1423);
  uint32_t x1451;
  fiat_p384_uint1 x1452;
  fiat_p384_addcarryx_u32(&x1451, &x1452, x1450, x1377, x1425);
  uint32_t x1453;
  fiat_p384_uint1 x1454;
  fiat_p384_addcarryx_u32(&x1453, &x1454, x1452, x1379, x1427);
  uint32_t x1455;
  fiat_p384_uint1 x1456;
  fiat_p384_addcarryx_u32(&x1455, &x1456, x1454, x1381, x1429);
  uint32_t x1457;
  fiat_p384_uint1 x1458;
  fiat_p384_addcarryx_u32(&x1457, &x1458, x1456, x1383, x1431);
  uint32_t x1459;
  fiat_p384_uint1 x1460;
  fiat_p384_addcarryx_u32(&x1459, &x1460, x1458, x1385, x1433);
  uint32_t x1461;
  uint32_t x1462;
  fiat_p384_mulx_u32(&x1461, &x1462, x1435, UINT32_C(0xffffffff));
  uint32_t x1463;
  uint32_t x1464;
  fiat_p384_mulx_u32(&x1463, &x1464, x1435, UINT32_C(0xffffffff));
  uint32_t x1465;
  uint32_t x1466;
  fiat_p384_mulx_u32(&x1465, &x1466, x1435, UINT32_C(0xffffffff));
  uint32_t x1467;
  uint32_t x1468;
  fiat_p384_mulx_u32(&x1467, &x1468, x1435, UINT32_C(0xffffffff));
  uint32_t x1469;
  uint32_t x1470;
  fiat_p384_mulx_u32(&x1469, &x1470, x1435, UINT32_C(0xffffffff));
  uint32_t x1471;
  uint32_t x1472;
  fiat_p384_mulx_u32(&x1471, &x1472, x1435, UINT32_C(0xffffffff));
  uint32_t x1473;
  uint32_t x1474;
  fiat_p384_mulx_u32(&x1473, &x1474, x1435, UINT32_C(0xffffffff));
  uint32_t x1475;
  uint32_t x1476;
  fiat_p384_mulx_u32(&x1475, &x1476, x1435, UINT32_C(0xfffffffe));
  uint32_t x1477;
  uint32_t x1478;
  fiat_p384_mulx_u32(&x1477, &x1478, x1435, UINT32_C(0xffffffff));
  uint32_t x1479;
  uint32_t x1480;
  fiat_p384_mulx_u32(&x1479, &x1480, x1435, UINT32_C(0xffffffff));
  uint32_t x1481;
  fiat_p384_uint1 x1482;
  fiat_p384_addcarryx_u32(&x1481, &x1482, 0x0, x1478, x1475);
  uint32_t x1483;
  fiat_p384_uint1 x1484;
  fiat_p384_addcarryx_u32(&x1483, &x1484, x1482, x1476, x1473);
  uint32_t x1485;
  fiat_p384_uint1 x1486;
  fiat_p384_addcarryx_u32(&x1485, &x1486, x1484, x1474, x1471);
  uint32_t x1487;
  fiat_p384_uint1 x1488;
  fiat_p384_addcarryx_u32(&x1487, &x1488, x1486, x1472, x1469);
  uint32_t x1489;
  fiat_p384_uint1 x1490;
  fiat_p384_addcarryx_u32(&x1489, &x1490, x1488, x1470, x1467);
  uint32_t x1491;
  fiat_p384_uint1 x1492;
  fiat_p384_addcarryx_u32(&x1491, &x1492, x1490, x1468, x1465);
  uint32_t x1493;
  fiat_p384_uint1 x1494;
  fiat_p384_addcarryx_u32(&x1493, &x1494, x1492, x1466, x1463);
  uint32_t x1495;
  fiat_p384_uint1 x1496;
  fiat_p384_addcarryx_u32(&x1495, &x1496, x1494, x1464, x1461);
  uint32_t x1497;
  fiat_p384_uint1 x1498;
  fiat_p384_addcarryx_u32(&x1497, &x1498, x1496, x1462, 0x0);
  uint32_t x1499;
  fiat_p384_uint1 x1500;
  fiat_p384_addcarryx_u32(&x1499, &x1500, 0x0, x1435, x1479);
  uint32_t x1501;
  fiat_p384_uint1 x1502;
  fiat_p384_addcarryx_u32(&x1501, &x1502, x1500, x1437, x1480);
  uint32_t x1503;
  fiat_p384_uint1 x1504;
  fiat_p384_addcarryx_u32(&x1503, &x1504, x1502, x1439, 0x0);
  uint32_t x1505;
  fiat_p384_uint1 x1506;
  fiat_p384_addcarryx_u32(&x1505, &x1506, x1504, x1441, x1477);
  uint32_t x1507;
  fiat_p384_uint1 x1508;
  fiat_p384_addcarryx_u32(&x1507, &x1508, x1506, x1443, x1481);
  uint32_t x1509;
  fiat_p384_uint1 x1510;
  fiat_p384_addcarryx_u32(&x1509, &x1510, x1508, x1445, x1483);
  uint32_t x1511;
  fiat_p384_uint1 x1512;
  fiat_p384_addcarryx_u32(&x1511, &x1512, x1510, x1447, x1485);
  uint32_t x1513;
  fiat_p384_uint1 x1514;
  fiat_p384_addcarryx_u32(&x1513, &x1514, x1512, x1449, x1487);
  uint32_t x1515;
  fiat_p384_uint1 x1516;
  fiat_p384_addcarryx_u32(&x1515, &x1516, x1514, x1451, x1489);
  uint32_t x1517;
  fiat_p384_uint1 x1518;
  fiat_p384_addcarryx_u32(&x1517, &x1518, x1516, x1453, x1491);
  uint32_t x1519;
  fiat_p384_uint1 x1520;
  fiat_p384_addcarryx_u32(&x1519, &x1520, x1518, x1455, x1493);
  uint32_t x1521;
  fiat_p384_uint1 x1522;
  fiat_p384_addcarryx_u32(&x1521, &x1522, x1520, x1457, x1495);
  uint32_t x1523;
  fiat_p384_uint1 x1524;
  fiat_p384_addcarryx_u32(&x1523, &x1524, x1522, x1459, x1497);
  uint32_t x1525;
  fiat_p384_uint1 x1526;
  fiat_p384_addcarryx_u32(&x1525, &x1526, x1524, x1460, 0x0);
  uint32_t x1527;
  uint32_t x1528;
  fiat_p384_mulx_u32(&x1527, &x1528, x11, (arg1[11]));
  uint32_t x1529;
  uint32_t x1530;
  fiat_p384_mulx_u32(&x1529, &x1530, x11, (arg1[10]));
  uint32_t x1531;
  uint32_t x1532;
  fiat_p384_mulx_u32(&x1531, &x1532, x11, (arg1[9]));
  uint32_t x1533;
  uint32_t x1534;
  fiat_p384_mulx_u32(&x1533, &x1534, x11, (arg1[8]));
  uint32_t x1535;
  uint32_t x1536;
  fiat_p384_mulx_u32(&x1535, &x1536, x11, (arg1[7]));
  uint32_t x1537;
  uint32_t x1538;
  fiat_p384_mulx_u32(&x1537, &x1538, x11, (arg1[6]));
  uint32_t x1539;
  uint32_t x1540;
  fiat_p384_mulx_u32(&x1539, &x1540, x11, (arg1[5]));
  uint32_t x1541;
  uint32_t x1542;
  fiat_p384_mulx_u32(&x1541, &x1542, x11, (arg1[4]));
  uint32_t x1543;
  uint32_t x1544;
  fiat_p384_mulx_u32(&x1543, &x1544, x11, (arg1[3]));
  uint32_t x1545;
  uint32_t x1546;
  fiat_p384_mulx_u32(&x1545, &x1546, x11, (arg1[2]));
  uint32_t x1547;
  uint32_t x1548;
  fiat_p384_mulx_u32(&x1547, &x1548, x11, (arg1[1]));
  uint32_t x1549;
  uint32_t x1550;
  fiat_p384_mulx_u32(&x1549, &x1550, x11, (arg1[0]));
  uint32_t x1551;
  fiat_p384_uint1 x1552;
  fiat_p384_addcarryx_u32(&x1551, &x1552, 0x0, x1550, x1547);
  uint32_t x1553;
  fiat_p384_uint1 x1554;
  fiat_p384_addcarryx_u32(&x1553, &x1554, x1552, x1548, x1545);
  uint32_t x1555;
  fiat_p384_uint1 x1556;
  fiat_p384_addcarryx_u32(&x1555, &x1556, x1554, x1546, x1543);
  uint32_t x1557;
  fiat_p384_uint1 x1558;
  fiat_p384_addcarryx_u32(&x1557, &x1558, x1556, x1544, x1541);
  uint32_t x1559;
  fiat_p384_uint1 x1560;
  fiat_p384_addcarryx_u32(&x1559, &x1560, x1558, x1542, x1539);
  uint32_t x1561;
  fiat_p384_uint1 x1562;
  fiat_p384_addcarryx_u32(&x1561, &x1562, x1560, x1540, x1537);
  uint32_t x1563;
  fiat_p384_uint1 x1564;
  fiat_p384_addcarryx_u32(&x1563, &x1564, x1562, x1538, x1535);
  uint32_t x1565;
  fiat_p384_uint1 x1566;
  fiat_p384_addcarryx_u32(&x1565, &x1566, x1564, x1536, x1533);
  uint32_t x1567;
  fiat_p384_uint1 x1568;
  fiat_p384_addcarryx_u32(&x1567, &x1568, x1566, x1534, x1531);
  uint32_t x1569;
  fiat_p384_uint1 x1570;
  fiat_p384_addcarryx_u32(&x1569, &x1570, x1568, x1532, x1529);
  uint32_t x1571;
  fiat_p384_uint1 x1572;
  fiat_p384_addcarryx_u32(&x1571, &x1572, x1570, x1530, x1527);
  uint32_t x1573;
  fiat_p384_uint1 x1574;
  fiat_p384_addcarryx_u32(&x1573, &x1574, x1572, x1528, 0x0);
  uint32_t x1575;
  fiat_p384_uint1 x1576;
  fiat_p384_addcarryx_u32(&x1575, &x1576, 0x0, x1501, x1549);
  uint32_t x1577;
  fiat_p384_uint1 x1578;
  fiat_p384_addcarryx_u32(&x1577, &x1578, x1576, x1503, x1551);
  uint32_t x1579;
  fiat_p384_uint1 x1580;
  fiat_p384_addcarryx_u32(&x1579, &x1580, x1578, x1505, x1553);
  uint32_t x1581;
  fiat_p384_uint1 x1582;
  fiat_p384_addcarryx_u32(&x1581, &x1582, x1580, x1507, x1555);
  uint32_t x1583;
  fiat_p384_uint1 x1584;
  fiat_p384_addcarryx_u32(&x1583, &x1584, x1582, x1509, x1557);
  uint32_t x1585;
  fiat_p384_uint1 x1586;
  fiat_p384_addcarryx_u32(&x1585, &x1586, x1584, x1511, x1559);
  uint32_t x1587;
  fiat_p384_uint1 x1588;
  fiat_p384_addcarryx_u32(&x1587, &x1588, x1586, x1513, x1561);
  uint32_t x1589;
  fiat_p384_uint1 x1590;
  fiat_p384_addcarryx_u32(&x1589, &x1590, x1588, x1515, x1563);
  uint32_t x1591;
  fiat_p384_uint1 x1592;
  fiat_p384_addcarryx_u32(&x1591, &x1592, x1590, x1517, x1565);
  uint32_t x1593;
  fiat_p384_uint1 x1594;
  fiat_p384_addcarryx_u32(&x1593, &x1594, x1592, x1519, x1567);
  uint32_t x1595;
  fiat_p384_uint1 x1596;
  fiat_p384_addcarryx_u32(&x1595, &x1596, x1594, x1521, x1569);
  uint32_t x1597;
  fiat_p384_uint1 x1598;
  fiat_p384_addcarryx_u32(&x1597, &x1598, x1596, x1523, x1571);
  uint32_t x1599;
  fiat_p384_uint1 x1600;
  fiat_p384_addcarryx_u32(&x1599, &x1600, x1598, x1525, x1573);
  uint32_t x1601;
  uint32_t x1602;
  fiat_p384_mulx_u32(&x1601, &x1602, x1575, UINT32_C(0xffffffff));
  uint32_t x1603;
  uint32_t x1604;
  fiat_p384_mulx_u32(&x1603, &x1604, x1575, UINT32_C(0xffffffff));
  uint32_t x1605;
  uint32_t x1606;
  fiat_p384_mulx_u32(&x1605, &x1606, x1575, UINT32_C(0xffffffff));
  uint32_t x1607;
  uint32_t x1608;
  fiat_p384_mulx_u32(&x1607, &x1608, x1575, UINT32_C(0xffffffff));
  uint32_t x1609;
  uint32_t x1610;
  fiat_p384_mulx_u32(&x1609, &x1610, x1575, UINT32_C(0xffffffff));
  uint32_t x1611;
  uint32_t x1612;
  fiat_p384_mulx_u32(&x1611, &x1612, x1575, UINT32_C(0xffffffff));
  uint32_t x1613;
  uint32_t x1614;
  fiat_p384_mulx_u32(&x1613, &x1614, x1575, UINT32_C(0xffffffff));
  uint32_t x1615;
  uint32_t x1616;
  fiat_p384_mulx_u32(&x1615, &x1616, x1575, UINT32_C(0xfffffffe));
  uint32_t x1617;
  uint32_t x1618;
  fiat_p384_mulx_u32(&x1617, &x1618, x1575, UINT32_C(0xffffffff));
  uint32_t x1619;
  uint32_t x1620;
  fiat_p384_mulx_u32(&x1619, &x1620, x1575, UINT32_C(0xffffffff));
  uint32_t x1621;
  fiat_p384_uint1 x1622;
  fiat_p384_addcarryx_u32(&x1621, &x1622, 0x0, x1618, x1615);
  uint32_t x1623;
  fiat_p384_uint1 x1624;
  fiat_p384_addcarryx_u32(&x1623, &x1624, x1622, x1616, x1613);
  uint32_t x1625;
  fiat_p384_uint1 x1626;
  fiat_p384_addcarryx_u32(&x1625, &x1626, x1624, x1614, x1611);
  uint32_t x1627;
  fiat_p384_uint1 x1628;
  fiat_p384_addcarryx_u32(&x1627, &x1628, x1626, x1612, x1609);
  uint32_t x1629;
  fiat_p384_uint1 x1630;
  fiat_p384_addcarryx_u32(&x1629, &x1630, x1628, x1610, x1607);
  uint32_t x1631;
  fiat_p384_uint1 x1632;
  fiat_p384_addcarryx_u32(&x1631, &x1632, x1630, x1608, x1605);
  uint32_t x1633;
  fiat_p384_uint1 x1634;
  fiat_p384_addcarryx_u32(&x1633, &x1634, x1632, x1606, x1603);
  uint32_t x1635;
  fiat_p384_uint1 x1636;
  fiat_p384_addcarryx_u32(&x1635, &x1636, x1634, x1604, x1601);
  uint32_t x1637;
  fiat_p384_uint1 x1638;
  fiat_p384_addcarryx_u32(&x1637, &x1638, x1636, x1602, 0x0);
  uint32_t x1639;
  fiat_p384_uint1 x1640;
  fiat_p384_addcarryx_u32(&x1639, &x1640, 0x0, x1575, x1619);
  uint32_t x1641;
  fiat_p384_uint1 x1642;
  fiat_p384_addcarryx_u32(&x1641, &x1642, x1640, x1577, x1620);
  uint32_t x1643;
  fiat_p384_uint1 x1644;
  fiat_p384_addcarryx_u32(&x1643, &x1644, x1642, x1579, 0x0);
  uint32_t x1645;
  fiat_p384_uint1 x1646;
  fiat_p384_addcarryx_u32(&x1645, &x1646, x1644, x1581, x1617);
  uint32_t x1647;
  fiat_p384_uint1 x1648;
  fiat_p384_addcarryx_u32(&x1647, &x1648, x1646, x1583, x1621);
  uint32_t x1649;
  fiat_p384_uint1 x1650;
  fiat_p384_addcarryx_u32(&x1649, &x1650, x1648, x1585, x1623);
  uint32_t x1651;
  fiat_p384_uint1 x1652;
  fiat_p384_addcarryx_u32(&x1651, &x1652, x1650, x1587, x1625);
  uint32_t x1653;
  fiat_p384_uint1 x1654;
  fiat_p384_addcarryx_u32(&x1653, &x1654, x1652, x1589, x1627);
  uint32_t x1655;
  fiat_p384_uint1 x1656;
  fiat_p384_addcarryx_u32(&x1655, &x1656, x1654, x1591, x1629);
  uint32_t x1657;
  fiat_p384_uint1 x1658;
  fiat_p384_addcarryx_u32(&x1657, &x1658, x1656, x1593, x1631);
  uint32_t x1659;
  fiat_p384_uint1 x1660;
  fiat_p384_addcarryx_u32(&x1659, &x1660, x1658, x1595, x1633);
  uint32_t x1661;
  fiat_p384_uint1 x1662;
  fiat_p384_addcarryx_u32(&x1661, &x1662, x1660, x1597, x1635);
  uint32_t x1663;
  fiat_p384_uint1 x1664;
  fiat_p384_addcarryx_u32(&x1663, &x1664, x1662, x1599, x1637);
  uint32_t x1665;
  fiat_p384_uint1 x1666;
  fiat_p384_addcarryx_u32(&x1665, &x1666, x1664, x1600, 0x0);
  uint32_t x1667;
  fiat_p384_uint1 x1668;
  fiat_p384_subborrowx_u32(&x1667, &x1668, 0x0, x1641, UINT32_C(0xffffffff));
  uint32_t x1669;
  fiat_p384_uint1 x1670;
  fiat_p384_subborrowx_u32(&x1669, &x1670, x1668, x1643, 0x0);
  uint32_t x1671;
  fiat_p384_uint1 x1672;
  fiat_p384_subborrowx_u32(&x1671, &x1672, x1670, x1645, 0x0);
  uint32_t x1673;
  fiat_p384_uint1 x1674;
  fiat_p384_subborrowx_u32(&x1673, &x1674, x1672, x1647, UINT32_C(0xffffffff));
  uint32_t x1675;
  fiat_p384_uint1 x1676;
  fiat_p384_subborrowx_u32(&x1675, &x1676, x1674, x1649, UINT32_C(0xfffffffe));
  uint32_t x1677;
  fiat_p384_uint1 x1678;
  fiat_p384_subborrowx_u32(&x1677, &x1678, x1676, x1651, UINT32_C(0xffffffff));
  uint32_t x1679;
  fiat_p384_uint1 x1680;
  fiat_p384_subborrowx_u32(&x1679, &x1680, x1678, x1653, UINT32_C(0xffffffff));
  uint32_t x1681;
  fiat_p384_uint1 x1682;
  fiat_p384_subborrowx_u32(&x1681, &x1682, x1680, x1655, UINT32_C(0xffffffff));
  uint32_t x1683;
  fiat_p384_uint1 x1684;
  fiat_p384_subborrowx_u32(&x1683, &x1684, x1682, x1657, UINT32_C(0xffffffff));
  uint32_t x1685;
  fiat_p384_uint1 x1686;
  fiat_p384_subborrowx_u32(&x1685, &x1686, x1684, x1659, UINT32_C(0xffffffff));
  uint32_t x1687;
  fiat_p384_uint1 x1688;
  fiat_p384_subborrowx_u32(&x1687, &x1688, x1686, x1661, UINT32_C(0xffffffff));
  uint32_t x1689;
  fiat_p384_uint1 x1690;
  fiat_p384_subborrowx_u32(&x1689, &x1690, x1688, x1663, UINT32_C(0xffffffff));
  uint32_t x1691;
  fiat_p384_uint1 x1692;
  fiat_p384_subborrowx_u32(&x1691, &x1692, x1690, x1665, 0x0);
  uint32_t x1693;
  fiat_p384_cmovznz_u32(&x1693, x1692, x1667, x1641);
  uint32_t x1694;
  fiat_p384_cmovznz_u32(&x1694, x1692, x1669, x1643);
  uint32_t x1695;
  fiat_p384_cmovznz_u32(&x1695, x1692, x1671, x1645);
  uint32_t x1696;
  fiat_p384_cmovznz_u32(&x1696, x1692, x1673, x1647);
  uint32_t x1697;
  fiat_p384_cmovznz_u32(&x1697, x1692, x1675, x1649);
  uint32_t x1698;
  fiat_p384_cmovznz_u32(&x1698, x1692, x1677, x1651);
  uint32_t x1699;
  fiat_p384_cmovznz_u32(&x1699, x1692, x1679, x1653);
  uint32_t x1700;
  fiat_p384_cmovznz_u32(&x1700, x1692, x1681, x1655);
  uint32_t x1701;
  fiat_p384_cmovznz_u32(&x1701, x1692, x1683, x1657);
  uint32_t x1702;
  fiat_p384_cmovznz_u32(&x1702, x1692, x1685, x1659);
  uint32_t x1703;
  fiat_p384_cmovznz_u32(&x1703, x1692, x1687, x1661);
  uint32_t x1704;
  fiat_p384_cmovznz_u32(&x1704, x1692, x1689, x1663);
  out1[0] = x1693;
  out1[1] = x1694;
  out1[2] = x1695;
  out1[3] = x1696;
  out1[4] = x1697;
  out1[5] = x1698;
  out1[6] = x1699;
  out1[7] = x1700;
  out1[8] = x1701;
  out1[9] = x1702;
  out1[10] = x1703;
  out1[11] = x1704;
}

/*
 * The function fiat_p384_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_add(uint32_t out1[12], const uint32_t arg1[12], const uint32_t arg2[12]) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  fiat_p384_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_p384_uint1 x4;
  fiat_p384_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_p384_uint1 x6;
  fiat_p384_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_p384_uint1 x8;
  fiat_p384_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_p384_uint1 x10;
  fiat_p384_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_p384_uint1 x12;
  fiat_p384_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_p384_uint1 x14;
  fiat_p384_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_p384_uint1 x16;
  fiat_p384_addcarryx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  uint32_t x17;
  fiat_p384_uint1 x18;
  fiat_p384_addcarryx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
  uint32_t x19;
  fiat_p384_uint1 x20;
  fiat_p384_addcarryx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
  uint32_t x21;
  fiat_p384_uint1 x22;
  fiat_p384_addcarryx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
  uint32_t x23;
  fiat_p384_uint1 x24;
  fiat_p384_addcarryx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
  uint32_t x25;
  fiat_p384_uint1 x26;
  fiat_p384_subborrowx_u32(&x25, &x26, 0x0, x1, UINT32_C(0xffffffff));
  uint32_t x27;
  fiat_p384_uint1 x28;
  fiat_p384_subborrowx_u32(&x27, &x28, x26, x3, 0x0);
  uint32_t x29;
  fiat_p384_uint1 x30;
  fiat_p384_subborrowx_u32(&x29, &x30, x28, x5, 0x0);
  uint32_t x31;
  fiat_p384_uint1 x32;
  fiat_p384_subborrowx_u32(&x31, &x32, x30, x7, UINT32_C(0xffffffff));
  uint32_t x33;
  fiat_p384_uint1 x34;
  fiat_p384_subborrowx_u32(&x33, &x34, x32, x9, UINT32_C(0xfffffffe));
  uint32_t x35;
  fiat_p384_uint1 x36;
  fiat_p384_subborrowx_u32(&x35, &x36, x34, x11, UINT32_C(0xffffffff));
  uint32_t x37;
  fiat_p384_uint1 x38;
  fiat_p384_subborrowx_u32(&x37, &x38, x36, x13, UINT32_C(0xffffffff));
  uint32_t x39;
  fiat_p384_uint1 x40;
  fiat_p384_subborrowx_u32(&x39, &x40, x38, x15, UINT32_C(0xffffffff));
  uint32_t x41;
  fiat_p384_uint1 x42;
  fiat_p384_subborrowx_u32(&x41, &x42, x40, x17, UINT32_C(0xffffffff));
  uint32_t x43;
  fiat_p384_uint1 x44;
  fiat_p384_subborrowx_u32(&x43, &x44, x42, x19, UINT32_C(0xffffffff));
  uint32_t x45;
  fiat_p384_uint1 x46;
  fiat_p384_subborrowx_u32(&x45, &x46, x44, x21, UINT32_C(0xffffffff));
  uint32_t x47;
  fiat_p384_uint1 x48;
  fiat_p384_subborrowx_u32(&x47, &x48, x46, x23, UINT32_C(0xffffffff));
  uint32_t x49;
  fiat_p384_uint1 x50;
  fiat_p384_subborrowx_u32(&x49, &x50, x48, x24, 0x0);
  uint32_t x51;
  fiat_p384_cmovznz_u32(&x51, x50, x25, x1);
  uint32_t x52;
  fiat_p384_cmovznz_u32(&x52, x50, x27, x3);
  uint32_t x53;
  fiat_p384_cmovznz_u32(&x53, x50, x29, x5);
  uint32_t x54;
  fiat_p384_cmovznz_u32(&x54, x50, x31, x7);
  uint32_t x55;
  fiat_p384_cmovznz_u32(&x55, x50, x33, x9);
  uint32_t x56;
  fiat_p384_cmovznz_u32(&x56, x50, x35, x11);
  uint32_t x57;
  fiat_p384_cmovznz_u32(&x57, x50, x37, x13);
  uint32_t x58;
  fiat_p384_cmovznz_u32(&x58, x50, x39, x15);
  uint32_t x59;
  fiat_p384_cmovznz_u32(&x59, x50, x41, x17);
  uint32_t x60;
  fiat_p384_cmovznz_u32(&x60, x50, x43, x19);
  uint32_t x61;
  fiat_p384_cmovznz_u32(&x61, x50, x45, x21);
  uint32_t x62;
  fiat_p384_cmovznz_u32(&x62, x50, x47, x23);
  out1[0] = x51;
  out1[1] = x52;
  out1[2] = x53;
  out1[3] = x54;
  out1[4] = x55;
  out1[5] = x56;
  out1[6] = x57;
  out1[7] = x58;
  out1[8] = x59;
  out1[9] = x60;
  out1[10] = x61;
  out1[11] = x62;
}

/*
 * The function fiat_p384_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_sub(uint32_t out1[12], const uint32_t arg1[12], const uint32_t arg2[12]) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  fiat_p384_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_p384_uint1 x4;
  fiat_p384_subborrowx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_p384_uint1 x6;
  fiat_p384_subborrowx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_p384_uint1 x8;
  fiat_p384_subborrowx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_p384_uint1 x10;
  fiat_p384_subborrowx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_p384_uint1 x12;
  fiat_p384_subborrowx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_p384_uint1 x14;
  fiat_p384_subborrowx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_p384_uint1 x16;
  fiat_p384_subborrowx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  uint32_t x17;
  fiat_p384_uint1 x18;
  fiat_p384_subborrowx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
  uint32_t x19;
  fiat_p384_uint1 x20;
  fiat_p384_subborrowx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
  uint32_t x21;
  fiat_p384_uint1 x22;
  fiat_p384_subborrowx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
  uint32_t x23;
  fiat_p384_uint1 x24;
  fiat_p384_subborrowx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
  uint32_t x25;
  fiat_p384_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
  uint32_t x26;
  fiat_p384_uint1 x27;
  fiat_p384_addcarryx_u32(&x26, &x27, 0x0, x1, (x25 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_p384_uint1 x29;
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
  uint32_t x30;
  fiat_p384_uint1 x31;
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
  uint32_t x32;
  fiat_p384_uint1 x33;
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x7, (x25 & UINT32_C(0xffffffff)));
  uint32_t x34;
  fiat_p384_uint1 x35;
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x9, (x25 & UINT32_C(0xfffffffe)));
  uint32_t x36;
  fiat_p384_uint1 x37;
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x11, (x25 & UINT32_C(0xffffffff)));
  uint32_t x38;
  fiat_p384_uint1 x39;
  fiat_p384_addcarryx_u32(&x38, &x39, x37, x13, (x25 & UINT32_C(0xffffffff)));
  uint32_t x40;
  fiat_p384_uint1 x41;
  fiat_p384_addcarryx_u32(&x40, &x41, x39, x15, (x25 & UINT32_C(0xffffffff)));
  uint32_t x42;
  fiat_p384_uint1 x43;
  fiat_p384_addcarryx_u32(&x42, &x43, x41, x17, (x25 & UINT32_C(0xffffffff)));
  uint32_t x44;
  fiat_p384_uint1 x45;
  fiat_p384_addcarryx_u32(&x44, &x45, x43, x19, (x25 & UINT32_C(0xffffffff)));
  uint32_t x46;
  fiat_p384_uint1 x47;
  fiat_p384_addcarryx_u32(&x46, &x47, x45, x21, (x25 & UINT32_C(0xffffffff)));
  uint32_t x48;
  fiat_p384_uint1 x49;
  fiat_p384_addcarryx_u32(&x48, &x49, x47, x23, (x25 & UINT32_C(0xffffffff)));
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/*
 * The function fiat_p384_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_opp(uint32_t out1[12], const uint32_t arg1[12]) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  fiat_p384_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  uint32_t x3;
  fiat_p384_uint1 x4;
  fiat_p384_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  uint32_t x5;
  fiat_p384_uint1 x6;
  fiat_p384_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  uint32_t x7;
  fiat_p384_uint1 x8;
  fiat_p384_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  uint32_t x9;
  fiat_p384_uint1 x10;
  fiat_p384_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  uint32_t x11;
  fiat_p384_uint1 x12;
  fiat_p384_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  uint32_t x13;
  fiat_p384_uint1 x14;
  fiat_p384_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  uint32_t x15;
  fiat_p384_uint1 x16;
  fiat_p384_subborrowx_u32(&x15, &x16, x14, 0x0, (arg1[7]));
  uint32_t x17;
  fiat_p384_uint1 x18;
  fiat_p384_subborrowx_u32(&x17, &x18, x16, 0x0, (arg1[8]));
  uint32_t x19;
  fiat_p384_uint1 x20;
  fiat_p384_subborrowx_u32(&x19, &x20, x18, 0x0, (arg1[9]));
  uint32_t x21;
  fiat_p384_uint1 x22;
  fiat_p384_subborrowx_u32(&x21, &x22, x20, 0x0, (arg1[10]));
  uint32_t x23;
  fiat_p384_uint1 x24;
  fiat_p384_subborrowx_u32(&x23, &x24, x22, 0x0, (arg1[11]));
  uint32_t x25;
  fiat_p384_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
  uint32_t x26;
  fiat_p384_uint1 x27;
  fiat_p384_addcarryx_u32(&x26, &x27, 0x0, x1, (x25 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_p384_uint1 x29;
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
  uint32_t x30;
  fiat_p384_uint1 x31;
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
  uint32_t x32;
  fiat_p384_uint1 x33;
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x7, (x25 & UINT32_C(0xffffffff)));
  uint32_t x34;
  fiat_p384_uint1 x35;
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x9, (x25 & UINT32_C(0xfffffffe)));
  uint32_t x36;
  fiat_p384_uint1 x37;
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x11, (x25 & UINT32_C(0xffffffff)));
  uint32_t x38;
  fiat_p384_uint1 x39;
  fiat_p384_addcarryx_u32(&x38, &x39, x37, x13, (x25 & UINT32_C(0xffffffff)));
  uint32_t x40;
  fiat_p384_uint1 x41;
  fiat_p384_addcarryx_u32(&x40, &x41, x39, x15, (x25 & UINT32_C(0xffffffff)));
  uint32_t x42;
  fiat_p384_uint1 x43;
  fiat_p384_addcarryx_u32(&x42, &x43, x41, x17, (x25 & UINT32_C(0xffffffff)));
  uint32_t x44;
  fiat_p384_uint1 x45;
  fiat_p384_addcarryx_u32(&x44, &x45, x43, x19, (x25 & UINT32_C(0xffffffff)));
  uint32_t x46;
  fiat_p384_uint1 x47;
  fiat_p384_addcarryx_u32(&x46, &x47, x45, x21, (x25 & UINT32_C(0xffffffff)));
  uint32_t x48;
  fiat_p384_uint1 x49;
  fiat_p384_addcarryx_u32(&x48, &x49, x47, x23, (x25 & UINT32_C(0xffffffff)));
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/*
 * The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_from_montgomery(uint32_t out1[12], const uint32_t arg1[12]) {
  uint32_t x1 = (arg1[0]);
  uint32_t x2;
  uint32_t x3;
  fiat_p384_mulx_u32(&x2, &x3, x1, UINT32_C(0xffffffff));
  uint32_t x4;
  uint32_t x5;
  fiat_p384_mulx_u32(&x4, &x5, x1, UINT32_C(0xffffffff));
  uint32_t x6;
  uint32_t x7;
  fiat_p384_mulx_u32(&x6, &x7, x1, UINT32_C(0xffffffff));
  uint32_t x8;
  uint32_t x9;
  fiat_p384_mulx_u32(&x8, &x9, x1, UINT32_C(0xffffffff));
  uint32_t x10;
  uint32_t x11;
  fiat_p384_mulx_u32(&x10, &x11, x1, UINT32_C(0xffffffff));
  uint32_t x12;
  uint32_t x13;
  fiat_p384_mulx_u32(&x12, &x13, x1, UINT32_C(0xffffffff));
  uint32_t x14;
  uint32_t x15;
  fiat_p384_mulx_u32(&x14, &x15, x1, UINT32_C(0xffffffff));
  uint32_t x16;
  uint32_t x17;
  fiat_p384_mulx_u32(&x16, &x17, x1, UINT32_C(0xfffffffe));
  uint32_t x18;
  uint32_t x19;
  fiat_p384_mulx_u32(&x18, &x19, x1, UINT32_C(0xffffffff));
  uint32_t x20;
  uint32_t x21;
  fiat_p384_mulx_u32(&x20, &x21, x1, UINT32_C(0xffffffff));
  uint32_t x22;
  fiat_p384_uint1 x23;
  fiat_p384_addcarryx_u32(&x22, &x23, 0x0, x19, x16);
  uint32_t x24;
  fiat_p384_uint1 x25;
  fiat_p384_addcarryx_u32(&x24, &x25, x23, x17, x14);
  uint32_t x26;
  fiat_p384_uint1 x27;
  fiat_p384_addcarryx_u32(&x26, &x27, x25, x15, x12);
  uint32_t x28;
  fiat_p384_uint1 x29;
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x13, x10);
  uint32_t x30;
  fiat_p384_uint1 x31;
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x11, x8);
  uint32_t x32;
  fiat_p384_uint1 x33;
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x9, x6);
  uint32_t x34;
  fiat_p384_uint1 x35;
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x7, x4);
  uint32_t x36;
  fiat_p384_uint1 x37;
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x5, x2);
  uint32_t x38;
  fiat_p384_uint1 x39;
  fiat_p384_addcarryx_u32(&x38, &x39, 0x0, x1, x20);
  uint32_t x40;
  fiat_p384_uint1 x41;
  fiat_p384_addcarryx_u32(&x40, &x41, x39, 0x0, x21);
  uint32_t x42;
  fiat_p384_uint1 x43;
  fiat_p384_addcarryx_u32(&x42, &x43, 0x0, x40, (arg1[1]));
  uint32_t x44;
  uint32_t x45;
  fiat_p384_mulx_u32(&x44, &x45, x42, UINT32_C(0xffffffff));
  uint32_t x46;
  uint32_t x47;
  fiat_p384_mulx_u32(&x46, &x47, x42, UINT32_C(0xffffffff));
  uint32_t x48;
  uint32_t x49;
  fiat_p384_mulx_u32(&x48, &x49, x42, UINT32_C(0xffffffff));
  uint32_t x50;
  uint32_t x51;
  fiat_p384_mulx_u32(&x50, &x51, x42, UINT32_C(0xffffffff));
  uint32_t x52;
  uint32_t x53;
  fiat_p384_mulx_u32(&x52, &x53, x42, UINT32_C(0xffffffff));
  uint32_t x54;
  uint32_t x55;
  fiat_p384_mulx_u32(&x54, &x55, x42, UINT32_C(0xffffffff));
  uint32_t x56;
  uint32_t x57;
  fiat_p384_mulx_u32(&x56, &x57, x42, UINT32_C(0xffffffff));
  uint32_t x58;
  uint32_t x59;
  fiat_p384_mulx_u32(&x58, &x59, x42, UINT32_C(0xfffffffe));
  uint32_t x60;
  uint32_t x61;
  fiat_p384_mulx_u32(&x60, &x61, x42, UINT32_C(0xffffffff));
  uint32_t x62;
  uint32_t x63;
  fiat_p384_mulx_u32(&x62, &x63, x42, UINT32_C(0xffffffff));
  uint32_t x64;
  fiat_p384_uint1 x65;
  fiat_p384_addcarryx_u32(&x64, &x65, 0x0, x61, x58);
  uint32_t x66;
  fiat_p384_uint1 x67;
  fiat_p384_addcarryx_u32(&x66, &x67, x65, x59, x56);
  uint32_t x68;
  fiat_p384_uint1 x69;
  fiat_p384_addcarryx_u32(&x68, &x69, x67, x57, x54);
  uint32_t x70;
  fiat_p384_uint1 x71;
  fiat_p384_addcarryx_u32(&x70, &x71, x69, x55, x52);
  uint32_t x72;
  fiat_p384_uint1 x73;
  fiat_p384_addcarryx_u32(&x72, &x73, x71, x53, x50);
  uint32_t x74;
  fiat_p384_uint1 x75;
  fiat_p384_addcarryx_u32(&x74, &x75, x73, x51, x48);
  uint32_t x76;
  fiat_p384_uint1 x77;
  fiat_p384_addcarryx_u32(&x76, &x77, x75, x49, x46);
  uint32_t x78;
  fiat_p384_uint1 x79;
  fiat_p384_addcarryx_u32(&x78, &x79, x77, x47, x44);
  uint32_t x80;
  fiat_p384_uint1 x81;
  fiat_p384_addcarryx_u32(&x80, &x81, x43, 0x0, 0x0);
  uint32_t x82;
  fiat_p384_uint1 x83;
  fiat_p384_addcarryx_u32(&x82, &x83, 0x0, x42, x62);
  uint32_t x84;
  fiat_p384_uint1 x85;
  fiat_p384_addcarryx_u32(&x84, &x85, x83, (fiat_p384_uint1)x80, x63);
  uint32_t x86;
  fiat_p384_uint1 x87;
  fiat_p384_addcarryx_u32(&x86, &x87, x85, x18, 0x0);
  uint32_t x88;
  fiat_p384_uint1 x89;
  fiat_p384_addcarryx_u32(&x88, &x89, x87, x22, x60);
  uint32_t x90;
  fiat_p384_uint1 x91;
  fiat_p384_addcarryx_u32(&x90, &x91, x89, x24, x64);
  uint32_t x92;
  fiat_p384_uint1 x93;
  fiat_p384_addcarryx_u32(&x92, &x93, x91, x26, x66);
  uint32_t x94;
  fiat_p384_uint1 x95;
  fiat_p384_addcarryx_u32(&x94, &x95, x93, x28, x68);
  uint32_t x96;
  fiat_p384_uint1 x97;
  fiat_p384_addcarryx_u32(&x96, &x97, x95, x30, x70);
  uint32_t x98;
  fiat_p384_uint1 x99;
  fiat_p384_addcarryx_u32(&x98, &x99, x97, x32, x72);
  uint32_t x100;
  fiat_p384_uint1 x101;
  fiat_p384_addcarryx_u32(&x100, &x101, x99, x34, x74);
  uint32_t x102;
  fiat_p384_uint1 x103;
  fiat_p384_addcarryx_u32(&x102, &x103, x101, x36, x76);
  uint32_t x104;
  fiat_p384_uint1 x105;
  fiat_p384_addcarryx_u32(&x104, &x105, x37, x3, 0x0);
  uint32_t x106;
  fiat_p384_uint1 x107;
  fiat_p384_addcarryx_u32(&x106, &x107, x103, x104, x78);
  uint32_t x108;
  fiat_p384_uint1 x109;
  fiat_p384_addcarryx_u32(&x108, &x109, x79, x45, 0x0);
  uint32_t x110;
  fiat_p384_uint1 x111;
  fiat_p384_addcarryx_u32(&x110, &x111, x107, 0x0, x108);
  uint32_t x112;
  fiat_p384_uint1 x113;
  fiat_p384_addcarryx_u32(&x112, &x113, 0x0, x84, (arg1[2]));
  uint32_t x114;
  fiat_p384_uint1 x115;
  fiat_p384_addcarryx_u32(&x114, &x115, x113, x86, 0x0);
  uint32_t x116;
  fiat_p384_uint1 x117;
  fiat_p384_addcarryx_u32(&x116, &x117, x115, x88, 0x0);
  uint32_t x118;
  fiat_p384_uint1 x119;
  fiat_p384_addcarryx_u32(&x118, &x119, x117, x90, 0x0);
  uint32_t x120;
  fiat_p384_uint1 x121;
  fiat_p384_addcarryx_u32(&x120, &x121, x119, x92, 0x0);
  uint32_t x122;
  fiat_p384_uint1 x123;
  fiat_p384_addcarryx_u32(&x122, &x123, x121, x94, 0x0);
  uint32_t x124;
  fiat_p384_uint1 x125;
  fiat_p384_addcarryx_u32(&x124, &x125, x123, x96, 0x0);
  uint32_t x126;
  fiat_p384_uint1 x127;
  fiat_p384_addcarryx_u32(&x126, &x127, x125, x98, 0x0);
  uint32_t x128;
  fiat_p384_uint1 x129;
  fiat_p384_addcarryx_u32(&x128, &x129, x127, x100, 0x0);
  uint32_t x130;
  fiat_p384_uint1 x131;
  fiat_p384_addcarryx_u32(&x130, &x131, x129, x102, 0x0);
  uint32_t x132;
  fiat_p384_uint1 x133;
  fiat_p384_addcarryx_u32(&x132, &x133, x131, x106, 0x0);
  uint32_t x134;
  fiat_p384_uint1 x135;
  fiat_p384_addcarryx_u32(&x134, &x135, x133, x110, 0x0);
  uint32_t x136;
  uint32_t x137;
  fiat_p384_mulx_u32(&x136, &x137, x112, UINT32_C(0xffffffff));
  uint32_t x138;
  uint32_t x139;
  fiat_p384_mulx_u32(&x138, &x139, x112, UINT32_C(0xffffffff));
  uint32_t x140;
  uint32_t x141;
  fiat_p384_mulx_u32(&x140, &x141, x112, UINT32_C(0xffffffff));
  uint32_t x142;
  uint32_t x143;
  fiat_p384_mulx_u32(&x142, &x143, x112, UINT32_C(0xffffffff));
  uint32_t x144;
  uint32_t x145;
  fiat_p384_mulx_u32(&x144, &x145, x112, UINT32_C(0xffffffff));
  uint32_t x146;
  uint32_t x147;
  fiat_p384_mulx_u32(&x146, &x147, x112, UINT32_C(0xffffffff));
  uint32_t x148;
  uint32_t x149;
  fiat_p384_mulx_u32(&x148, &x149, x112, UINT32_C(0xffffffff));
  uint32_t x150;
  uint32_t x151;
  fiat_p384_mulx_u32(&x150, &x151, x112, UINT32_C(0xfffffffe));
  uint32_t x152;
  uint32_t x153;
  fiat_p384_mulx_u32(&x152, &x153, x112, UINT32_C(0xffffffff));
  uint32_t x154;
  uint32_t x155;
  fiat_p384_mulx_u32(&x154, &x155, x112, UINT32_C(0xffffffff));
  uint32_t x156;
  fiat_p384_uint1 x157;
  fiat_p384_addcarryx_u32(&x156, &x157, 0x0, x153, x150);
  uint32_t x158;
  fiat_p384_uint1 x159;
  fiat_p384_addcarryx_u32(&x158, &x159, x157, x151, x148);
  uint32_t x160;
  fiat_p384_uint1 x161;
  fiat_p384_addcarryx_u32(&x160, &x161, x159, x149, x146);
  uint32_t x162;
  fiat_p384_uint1 x163;
  fiat_p384_addcarryx_u32(&x162, &x163, x161, x147, x144);
  uint32_t x164;
  fiat_p384_uint1 x165;
  fiat_p384_addcarryx_u32(&x164, &x165, x163, x145, x142);
  uint32_t x166;
  fiat_p384_uint1 x167;
  fiat_p384_addcarryx_u32(&x166, &x167, x165, x143, x140);
  uint32_t x168;
  fiat_p384_uint1 x169;
  fiat_p384_addcarryx_u32(&x168, &x169, x167, x141, x138);
  uint32_t x170;
  fiat_p384_uint1 x171;
  fiat_p384_addcarryx_u32(&x170, &x171, x169, x139, x136);
  uint32_t x172;
  fiat_p384_uint1 x173;
  fiat_p384_addcarryx_u32(&x172, &x173, 0x0, x112, x154);
  uint32_t x174;
  fiat_p384_uint1 x175;
  fiat_p384_addcarryx_u32(&x174, &x175, x173, x114, x155);
  uint32_t x176;
  fiat_p384_uint1 x177;
  fiat_p384_addcarryx_u32(&x176, &x177, x175, x116, 0x0);
  uint32_t x178;
  fiat_p384_uint1 x179;
  fiat_p384_addcarryx_u32(&x178, &x179, x177, x118, x152);
  uint32_t x180;
  fiat_p384_uint1 x181;
  fiat_p384_addcarryx_u32(&x180, &x181, x179, x120, x156);
  uint32_t x182;
  fiat_p384_uint1 x183;
  fiat_p384_addcarryx_u32(&x182, &x183, x181, x122, x158);
  uint32_t x184;
  fiat_p384_uint1 x185;
  fiat_p384_addcarryx_u32(&x184, &x185, x183, x124, x160);
  uint32_t x186;
  fiat_p384_uint1 x187;
  fiat_p384_addcarryx_u32(&x186, &x187, x185, x126, x162);
  uint32_t x188;
  fiat_p384_uint1 x189;
  fiat_p384_addcarryx_u32(&x188, &x189, x187, x128, x164);
  uint32_t x190;
  fiat_p384_uint1 x191;
  fiat_p384_addcarryx_u32(&x190, &x191, x189, x130, x166);
  uint32_t x192;
  fiat_p384_uint1 x193;
  fiat_p384_addcarryx_u32(&x192, &x193, x191, x132, x168);
  uint32_t x194;
  fiat_p384_uint1 x195;
  fiat_p384_addcarryx_u32(&x194, &x195, x193, x134, x170);
  uint32_t x196;
  fiat_p384_uint1 x197;
  fiat_p384_addcarryx_u32(&x196, &x197, x171, x137, 0x0);
  uint32_t x198;
  fiat_p384_uint1 x199;
  fiat_p384_addcarryx_u32(&x198, &x199, x111, 0x0, 0x0);
  uint32_t x200;
  fiat_p384_uint1 x201;
  fiat_p384_addcarryx_u32(&x200, &x201, x135, (fiat_p384_uint1)x198, 0x0);
  uint32_t x202;
  fiat_p384_uint1 x203;
  fiat_p384_addcarryx_u32(&x202, &x203, x195, x200, x196);
  uint32_t x204;
  fiat_p384_uint1 x205;
  fiat_p384_addcarryx_u32(&x204, &x205, 0x0, x174, (arg1[3]));
  uint32_t x206;
  fiat_p384_uint1 x207;
  fiat_p384_addcarryx_u32(&x206, &x207, x205, x176, 0x0);
  uint32_t x208;
  fiat_p384_uint1 x209;
  fiat_p384_addcarryx_u32(&x208, &x209, x207, x178, 0x0);
  uint32_t x210;
  fiat_p384_uint1 x211;
  fiat_p384_addcarryx_u32(&x210, &x211, x209, x180, 0x0);
  uint32_t x212;
  fiat_p384_uint1 x213;
  fiat_p384_addcarryx_u32(&x212, &x213, x211, x182, 0x0);
  uint32_t x214;
  fiat_p384_uint1 x215;
  fiat_p384_addcarryx_u32(&x214, &x215, x213, x184, 0x0);
  uint32_t x216;
  fiat_p384_uint1 x217;
  fiat_p384_addcarryx_u32(&x216, &x217, x215, x186, 0x0);
  uint32_t x218;
  fiat_p384_uint1 x219;
  fiat_p384_addcarryx_u32(&x218, &x219, x217, x188, 0x0);
  uint32_t x220;
  fiat_p384_uint1 x221;
  fiat_p384_addcarryx_u32(&x220, &x221, x219, x190, 0x0);
  uint32_t x222;
  fiat_p384_uint1 x223;
  fiat_p384_addcarryx_u32(&x222, &x223, x221, x192, 0x0);
  uint32_t x224;
  fiat_p384_uint1 x225;
  fiat_p384_addcarryx_u32(&x224, &x225, x223, x194, 0x0);
  uint32_t x226;
  fiat_p384_uint1 x227;
  fiat_p384_addcarryx_u32(&x226, &x227, x225, x202, 0x0);
  uint32_t x228;
  uint32_t x229;
  fiat_p384_mulx_u32(&x228, &x229, x204, UINT32_C(0xffffffff));
  uint32_t x230;
  uint32_t x231;
  fiat_p384_mulx_u32(&x230, &x231, x204, UINT32_C(0xffffffff));
  uint32_t x232;
  uint32_t x233;
  fiat_p384_mulx_u32(&x232, &x233, x204, UINT32_C(0xffffffff));
  uint32_t x234;
  uint32_t x235;
  fiat_p384_mulx_u32(&x234, &x235, x204, UINT32_C(0xffffffff));
  uint32_t x236;
  uint32_t x237;
  fiat_p384_mulx_u32(&x236, &x237, x204, UINT32_C(0xffffffff));
  uint32_t x238;
  uint32_t x239;
  fiat_p384_mulx_u32(&x238, &x239, x204, UINT32_C(0xffffffff));
  uint32_t x240;
  uint32_t x241;
  fiat_p384_mulx_u32(&x240, &x241, x204, UINT32_C(0xffffffff));
  uint32_t x242;
  uint32_t x243;
  fiat_p384_mulx_u32(&x242, &x243, x204, UINT32_C(0xfffffffe));
  uint32_t x244;
  uint32_t x245;
  fiat_p384_mulx_u32(&x244, &x245, x204, UINT32_C(0xffffffff));
  uint32_t x246;
  uint32_t x247;
  fiat_p384_mulx_u32(&x246, &x247, x204, UINT32_C(0xffffffff));
  uint32_t x248;
  fiat_p384_uint1 x249;
  fiat_p384_addcarryx_u32(&x248, &x249, 0x0, x245, x242);
  uint32_t x250;
  fiat_p384_uint1 x251;
  fiat_p384_addcarryx_u32(&x250, &x251, x249, x243, x240);
  uint32_t x252;
  fiat_p384_uint1 x253;
  fiat_p384_addcarryx_u32(&x252, &x253, x251, x241, x238);
  uint32_t x254;
  fiat_p384_uint1 x255;
  fiat_p384_addcarryx_u32(&x254, &x255, x253, x239, x236);
  uint32_t x256;
  fiat_p384_uint1 x257;
  fiat_p384_addcarryx_u32(&x256, &x257, x255, x237, x234);
  uint32_t x258;
  fiat_p384_uint1 x259;
  fiat_p384_addcarryx_u32(&x258, &x259, x257, x235, x232);
  uint32_t x260;
  fiat_p384_uint1 x261;
  fiat_p384_addcarryx_u32(&x260, &x261, x259, x233, x230);
  uint32_t x262;
  fiat_p384_uint1 x263;
  fiat_p384_addcarryx_u32(&x262, &x263, x261, x231, x228);
  uint32_t x264;
  fiat_p384_uint1 x265;
  fiat_p384_addcarryx_u32(&x264, &x265, 0x0, x204, x246);
  uint32_t x266;
  fiat_p384_uint1 x267;
  fiat_p384_addcarryx_u32(&x266, &x267, x265, x206, x247);
  uint32_t x268;
  fiat_p384_uint1 x269;
  fiat_p384_addcarryx_u32(&x268, &x269, x267, x208, 0x0);
  uint32_t x270;
  fiat_p384_uint1 x271;
  fiat_p384_addcarryx_u32(&x270, &x271, x269, x210, x244);
  uint32_t x272;
  fiat_p384_uint1 x273;
  fiat_p384_addcarryx_u32(&x272, &x273, x271, x212, x248);
  uint32_t x274;
  fiat_p384_uint1 x275;
  fiat_p384_addcarryx_u32(&x274, &x275, x273, x214, x250);
  uint32_t x276;
  fiat_p384_uint1 x277;
  fiat_p384_addcarryx_u32(&x276, &x277, x275, x216, x252);
  uint32_t x278;
  fiat_p384_uint1 x279;
  fiat_p384_addcarryx_u32(&x278, &x279, x277, x218, x254);
  uint32_t x280;
  fiat_p384_uint1 x281;
  fiat_p384_addcarryx_u32(&x280, &x281, x279, x220, x256);
  uint32_t x282;
  fiat_p384_uint1 x283;
  fiat_p384_addcarryx_u32(&x282, &x283, x281, x222, x258);
  uint32_t x284;
  fiat_p384_uint1 x285;
  fiat_p384_addcarryx_u32(&x284, &x285, x283, x224, x260);
  uint32_t x286;
  fiat_p384_uint1 x287;
  fiat_p384_addcarryx_u32(&x286, &x287, x285, x226, x262);
  uint32_t x288;
  fiat_p384_uint1 x289;
  fiat_p384_addcarryx_u32(&x288, &x289, x263, x229, 0x0);
  uint32_t x290;
  fiat_p384_uint1 x291;
  fiat_p384_addcarryx_u32(&x290, &x291, x203, 0x0, 0x0);
  uint32_t x292;
  fiat_p384_uint1 x293;
  fiat_p384_addcarryx_u32(&x292, &x293, x227, (fiat_p384_uint1)x290, 0x0);
  uint32_t x294;
  fiat_p384_uint1 x295;
  fiat_p384_addcarryx_u32(&x294, &x295, x287, x292, x288);
  uint32_t x296;
  fiat_p384_uint1 x297;
  fiat_p384_addcarryx_u32(&x296, &x297, 0x0, x266, (arg1[4]));
  uint32_t x298;
  fiat_p384_uint1 x299;
  fiat_p384_addcarryx_u32(&x298, &x299, x297, x268, 0x0);
  uint32_t x300;
  fiat_p384_uint1 x301;
  fiat_p384_addcarryx_u32(&x300, &x301, x299, x270, 0x0);
  uint32_t x302;
  fiat_p384_uint1 x303;
  fiat_p384_addcarryx_u32(&x302, &x303, x301, x272, 0x0);
  uint32_t x304;
  fiat_p384_uint1 x305;
  fiat_p384_addcarryx_u32(&x304, &x305, x303, x274, 0x0);
  uint32_t x306;
  fiat_p384_uint1 x307;
  fiat_p384_addcarryx_u32(&x306, &x307, x305, x276, 0x0);
  uint32_t x308;
  fiat_p384_uint1 x309;
  fiat_p384_addcarryx_u32(&x308, &x309, x307, x278, 0x0);
  uint32_t x310;
  fiat_p384_uint1 x311;
  fiat_p384_addcarryx_u32(&x310, &x311, x309, x280, 0x0);
  uint32_t x312;
  fiat_p384_uint1 x313;
  fiat_p384_addcarryx_u32(&x312, &x313, x311, x282, 0x0);
  uint32_t x314;
  fiat_p384_uint1 x315;
  fiat_p384_addcarryx_u32(&x314, &x315, x313, x284, 0x0);
  uint32_t x316;
  fiat_p384_uint1 x317;
  fiat_p384_addcarryx_u32(&x316, &x317, x315, x286, 0x0);
  uint32_t x318;
  fiat_p384_uint1 x319;
  fiat_p384_addcarryx_u32(&x318, &x319, x317, x294, 0x0);
  uint32_t x320;
  uint32_t x321;
  fiat_p384_mulx_u32(&x320, &x321, x296, UINT32_C(0xffffffff));
  uint32_t x322;
  uint32_t x323;
  fiat_p384_mulx_u32(&x322, &x323, x296, UINT32_C(0xffffffff));
  uint32_t x324;
  uint32_t x325;
  fiat_p384_mulx_u32(&x324, &x325, x296, UINT32_C(0xffffffff));
  uint32_t x326;
  uint32_t x327;
  fiat_p384_mulx_u32(&x326, &x327, x296, UINT32_C(0xffffffff));
  uint32_t x328;
  uint32_t x329;
  fiat_p384_mulx_u32(&x328, &x329, x296, UINT32_C(0xffffffff));
  uint32_t x330;
  uint32_t x331;
  fiat_p384_mulx_u32(&x330, &x331, x296, UINT32_C(0xffffffff));
  uint32_t x332;
  uint32_t x333;
  fiat_p384_mulx_u32(&x332, &x333, x296, UINT32_C(0xffffffff));
  uint32_t x334;
  uint32_t x335;
  fiat_p384_mulx_u32(&x334, &x335, x296, UINT32_C(0xfffffffe));
  uint32_t x336;
  uint32_t x337;
  fiat_p384_mulx_u32(&x336, &x337, x296, UINT32_C(0xffffffff));
  uint32_t x338;
  uint32_t x339;
  fiat_p384_mulx_u32(&x338, &x339, x296, UINT32_C(0xffffffff));
  uint32_t x340;
  fiat_p384_uint1 x341;
  fiat_p384_addcarryx_u32(&x340, &x341, 0x0, x337, x334);
  uint32_t x342;
  fiat_p384_uint1 x343;
  fiat_p384_addcarryx_u32(&x342, &x343, x341, x335, x332);
  uint32_t x344;
  fiat_p384_uint1 x345;
  fiat_p384_addcarryx_u32(&x344, &x345, x343, x333, x330);
  uint32_t x346;
  fiat_p384_uint1 x347;
  fiat_p384_addcarryx_u32(&x346, &x347, x345, x331, x328);
  uint32_t x348;
  fiat_p384_uint1 x349;
  fiat_p384_addcarryx_u32(&x348, &x349, x347, x329, x326);
  uint32_t x350;
  fiat_p384_uint1 x351;
  fiat_p384_addcarryx_u32(&x350, &x351, x349, x327, x324);
  uint32_t x352;
  fiat_p384_uint1 x353;
  fiat_p384_addcarryx_u32(&x352, &x353, x351, x325, x322);
  uint32_t x354;
  fiat_p384_uint1 x355;
  fiat_p384_addcarryx_u32(&x354, &x355, x353, x323, x320);
  uint32_t x356;
  fiat_p384_uint1 x357;
  fiat_p384_addcarryx_u32(&x356, &x357, 0x0, x296, x338);
  uint32_t x358;
  fiat_p384_uint1 x359;
  fiat_p384_addcarryx_u32(&x358, &x359, x357, x298, x339);
  uint32_t x360;
  fiat_p384_uint1 x361;
  fiat_p384_addcarryx_u32(&x360, &x361, x359, x300, 0x0);
  uint32_t x362;
  fiat_p384_uint1 x363;
  fiat_p384_addcarryx_u32(&x362, &x363, x361, x302, x336);
  uint32_t x364;
  fiat_p384_uint1 x365;
  fiat_p384_addcarryx_u32(&x364, &x365, x363, x304, x340);
  uint32_t x366;
  fiat_p384_uint1 x367;
  fiat_p384_addcarryx_u32(&x366, &x367, x365, x306, x342);
  uint32_t x368;
  fiat_p384_uint1 x369;
  fiat_p384_addcarryx_u32(&x368, &x369, x367, x308, x344);
  uint32_t x370;
  fiat_p384_uint1 x371;
  fiat_p384_addcarryx_u32(&x370, &x371, x369, x310, x346);
  uint32_t x372;
  fiat_p384_uint1 x373;
  fiat_p384_addcarryx_u32(&x372, &x373, x371, x312, x348);
  uint32_t x374;
  fiat_p384_uint1 x375;
  fiat_p384_addcarryx_u32(&x374, &x375, x373, x314, x350);
  uint32_t x376;
  fiat_p384_uint1 x377;
  fiat_p384_addcarryx_u32(&x376, &x377, x375, x316, x352);
  uint32_t x378;
  fiat_p384_uint1 x379;
  fiat_p384_addcarryx_u32(&x378, &x379, x377, x318, x354);
  uint32_t x380;
  fiat_p384_uint1 x381;
  fiat_p384_addcarryx_u32(&x380, &x381, x355, x321, 0x0);
  uint32_t x382;
  fiat_p384_uint1 x383;
  fiat_p384_addcarryx_u32(&x382, &x383, x295, 0x0, 0x0);
  uint32_t x384;
  fiat_p384_uint1 x385;
  fiat_p384_addcarryx_u32(&x384, &x385, x319, (fiat_p384_uint1)x382, 0x0);
  uint32_t x386;
  fiat_p384_uint1 x387;
  fiat_p384_addcarryx_u32(&x386, &x387, x379, x384, x380);
  uint32_t x388;
  fiat_p384_uint1 x389;
  fiat_p384_addcarryx_u32(&x388, &x389, 0x0, x358, (arg1[5]));
  uint32_t x390;
  fiat_p384_uint1 x391;
  fiat_p384_addcarryx_u32(&x390, &x391, x389, x360, 0x0);
  uint32_t x392;
  fiat_p384_uint1 x393;
  fiat_p384_addcarryx_u32(&x392, &x393, x391, x362, 0x0);
  uint32_t x394;
  fiat_p384_uint1 x395;
  fiat_p384_addcarryx_u32(&x394, &x395, x393, x364, 0x0);
  uint32_t x396;
  fiat_p384_uint1 x397;
  fiat_p384_addcarryx_u32(&x396, &x397, x395, x366, 0x0);
  uint32_t x398;
  fiat_p384_uint1 x399;
  fiat_p384_addcarryx_u32(&x398, &x399, x397, x368, 0x0);
  uint32_t x400;
  fiat_p384_uint1 x401;
  fiat_p384_addcarryx_u32(&x400, &x401, x399, x370, 0x0);
  uint32_t x402;
  fiat_p384_uint1 x403;
  fiat_p384_addcarryx_u32(&x402, &x403, x401, x372, 0x0);
  uint32_t x404;
  fiat_p384_uint1 x405;
  fiat_p384_addcarryx_u32(&x404, &x405, x403, x374, 0x0);
  uint32_t x406;
  fiat_p384_uint1 x407;
  fiat_p384_addcarryx_u32(&x406, &x407, x405, x376, 0x0);
  uint32_t x408;
  fiat_p384_uint1 x409;
  fiat_p384_addcarryx_u32(&x408, &x409, x407, x378, 0x0);
  uint32_t x410;
  fiat_p384_uint1 x411;
  fiat_p384_addcarryx_u32(&x410, &x411, x409, x386, 0x0);
  uint32_t x412;
  uint32_t x413;
  fiat_p384_mulx_u32(&x412, &x413, x388, UINT32_C(0xffffffff));
  uint32_t x414;
  uint32_t x415;
  fiat_p384_mulx_u32(&x414, &x415, x388, UINT32_C(0xffffffff));
  uint32_t x416;
  uint32_t x417;
  fiat_p384_mulx_u32(&x416, &x417, x388, UINT32_C(0xffffffff));
  uint32_t x418;
  uint32_t x419;
  fiat_p384_mulx_u32(&x418, &x419, x388, UINT32_C(0xffffffff));
  uint32_t x420;
  uint32_t x421;
  fiat_p384_mulx_u32(&x420, &x421, x388, UINT32_C(0xffffffff));
  uint32_t x422;
  uint32_t x423;
  fiat_p384_mulx_u32(&x422, &x423, x388, UINT32_C(0xffffffff));
  uint32_t x424;
  uint32_t x425;
  fiat_p384_mulx_u32(&x424, &x425, x388, UINT32_C(0xffffffff));
  uint32_t x426;
  uint32_t x427;
  fiat_p384_mulx_u32(&x426, &x427, x388, UINT32_C(0xfffffffe));
  uint32_t x428;
  uint32_t x429;
  fiat_p384_mulx_u32(&x428, &x429, x388, UINT32_C(0xffffffff));
  uint32_t x430;
  uint32_t x431;
  fiat_p384_mulx_u32(&x430, &x431, x388, UINT32_C(0xffffffff));
  uint32_t x432;
  fiat_p384_uint1 x433;
  fiat_p384_addcarryx_u32(&x432, &x433, 0x0, x429, x426);
  uint32_t x434;
  fiat_p384_uint1 x435;
  fiat_p384_addcarryx_u32(&x434, &x435, x433, x427, x424);
  uint32_t x436;
  fiat_p384_uint1 x437;
  fiat_p384_addcarryx_u32(&x436, &x437, x435, x425, x422);
  uint32_t x438;
  fiat_p384_uint1 x439;
  fiat_p384_addcarryx_u32(&x438, &x439, x437, x423, x420);
  uint32_t x440;
  fiat_p384_uint1 x441;
  fiat_p384_addcarryx_u32(&x440, &x441, x439, x421, x418);
  uint32_t x442;
  fiat_p384_uint1 x443;
  fiat_p384_addcarryx_u32(&x442, &x443, x441, x419, x416);
  uint32_t x444;
  fiat_p384_uint1 x445;
  fiat_p384_addcarryx_u32(&x444, &x445, x443, x417, x414);
  uint32_t x446;
  fiat_p384_uint1 x447;
  fiat_p384_addcarryx_u32(&x446, &x447, x445, x415, x412);
  uint32_t x448;
  fiat_p384_uint1 x449;
  fiat_p384_addcarryx_u32(&x448, &x449, 0x0, x388, x430);
  uint32_t x450;
  fiat_p384_uint1 x451;
  fiat_p384_addcarryx_u32(&x450, &x451, x449, x390, x431);
  uint32_t x452;
  fiat_p384_uint1 x453;
  fiat_p384_addcarryx_u32(&x452, &x453, x451, x392, 0x0);
  uint32_t x454;
  fiat_p384_uint1 x455;
  fiat_p384_addcarryx_u32(&x454, &x455, x453, x394, x428);
  uint32_t x456;
  fiat_p384_uint1 x457;
  fiat_p384_addcarryx_u32(&x456, &x457, x455, x396, x432);
  uint32_t x458;
  fiat_p384_uint1 x459;
  fiat_p384_addcarryx_u32(&x458, &x459, x457, x398, x434);
  uint32_t x460;
  fiat_p384_uint1 x461;
  fiat_p384_addcarryx_u32(&x460, &x461, x459, x400, x436);
  uint32_t x462;
  fiat_p384_uint1 x463;
  fiat_p384_addcarryx_u32(&x462, &x463, x461, x402, x438);
  uint32_t x464;
  fiat_p384_uint1 x465;
  fiat_p384_addcarryx_u32(&x464, &x465, x463, x404, x440);
  uint32_t x466;
  fiat_p384_uint1 x467;
  fiat_p384_addcarryx_u32(&x466, &x467, x465, x406, x442);
  uint32_t x468;
  fiat_p384_uint1 x469;
  fiat_p384_addcarryx_u32(&x468, &x469, x467, x408, x444);
  uint32_t x470;
  fiat_p384_uint1 x471;
  fiat_p384_addcarryx_u32(&x470, &x471, x469, x410, x446);
  uint32_t x472;
  fiat_p384_uint1 x473;
  fiat_p384_addcarryx_u32(&x472, &x473, x447, x413, 0x0);
  uint32_t x474;
  fiat_p384_uint1 x475;
  fiat_p384_addcarryx_u32(&x474, &x475, x387, 0x0, 0x0);
  uint32_t x476;
  fiat_p384_uint1 x477;
  fiat_p384_addcarryx_u32(&x476, &x477, x411, (fiat_p384_uint1)x474, 0x0);
  uint32_t x478;
  fiat_p384_uint1 x479;
  fiat_p384_addcarryx_u32(&x478, &x479, x471, x476, x472);
  uint32_t x480;
  fiat_p384_uint1 x481;
  fiat_p384_addcarryx_u32(&x480, &x481, 0x0, x450, (arg1[6]));
  uint32_t x482;
  fiat_p384_uint1 x483;
  fiat_p384_addcarryx_u32(&x482, &x483, x481, x452, 0x0);
  uint32_t x484;
  fiat_p384_uint1 x485;
  fiat_p384_addcarryx_u32(&x484, &x485, x483, x454, 0x0);
  uint32_t x486;
  fiat_p384_uint1 x487;
  fiat_p384_addcarryx_u32(&x486, &x487, x485, x456, 0x0);
  uint32_t x488;
  fiat_p384_uint1 x489;
  fiat_p384_addcarryx_u32(&x488, &x489, x487, x458, 0x0);
  uint32_t x490;
  fiat_p384_uint1 x491;
  fiat_p384_addcarryx_u32(&x490, &x491, x489, x460, 0x0);
  uint32_t x492;
  fiat_p384_uint1 x493;
  fiat_p384_addcarryx_u32(&x492, &x493, x491, x462, 0x0);
  uint32_t x494;
  fiat_p384_uint1 x495;
  fiat_p384_addcarryx_u32(&x494, &x495, x493, x464, 0x0);
  uint32_t x496;
  fiat_p384_uint1 x497;
  fiat_p384_addcarryx_u32(&x496, &x497, x495, x466, 0x0);
  uint32_t x498;
  fiat_p384_uint1 x499;
  fiat_p384_addcarryx_u32(&x498, &x499, x497, x468, 0x0);
  uint32_t x500;
  fiat_p384_uint1 x501;
  fiat_p384_addcarryx_u32(&x500, &x501, x499, x470, 0x0);
  uint32_t x502;
  fiat_p384_uint1 x503;
  fiat_p384_addcarryx_u32(&x502, &x503, x501, x478, 0x0);
  uint32_t x504;
  uint32_t x505;
  fiat_p384_mulx_u32(&x504, &x505, x480, UINT32_C(0xffffffff));
  uint32_t x506;
  uint32_t x507;
  fiat_p384_mulx_u32(&x506, &x507, x480, UINT32_C(0xffffffff));
  uint32_t x508;
  uint32_t x509;
  fiat_p384_mulx_u32(&x508, &x509, x480, UINT32_C(0xffffffff));
  uint32_t x510;
  uint32_t x511;
  fiat_p384_mulx_u32(&x510, &x511, x480, UINT32_C(0xffffffff));
  uint32_t x512;
  uint32_t x513;
  fiat_p384_mulx_u32(&x512, &x513, x480, UINT32_C(0xffffffff));
  uint32_t x514;
  uint32_t x515;
  fiat_p384_mulx_u32(&x514, &x515, x480, UINT32_C(0xffffffff));
  uint32_t x516;
  uint32_t x517;
  fiat_p384_mulx_u32(&x516, &x517, x480, UINT32_C(0xffffffff));
  uint32_t x518;
  uint32_t x519;
  fiat_p384_mulx_u32(&x518, &x519, x480, UINT32_C(0xfffffffe));
  uint32_t x520;
  uint32_t x521;
  fiat_p384_mulx_u32(&x520, &x521, x480, UINT32_C(0xffffffff));
  uint32_t x522;
  uint32_t x523;
  fiat_p384_mulx_u32(&x522, &x523, x480, UINT32_C(0xffffffff));
  uint32_t x524;
  fiat_p384_uint1 x525;
  fiat_p384_addcarryx_u32(&x524, &x525, 0x0, x521, x518);
  uint32_t x526;
  fiat_p384_uint1 x527;
  fiat_p384_addcarryx_u32(&x526, &x527, x525, x519, x516);
  uint32_t x528;
  fiat_p384_uint1 x529;
  fiat_p384_addcarryx_u32(&x528, &x529, x527, x517, x514);
  uint32_t x530;
  fiat_p384_uint1 x531;
  fiat_p384_addcarryx_u32(&x530, &x531, x529, x515, x512);
  uint32_t x532;
  fiat_p384_uint1 x533;
  fiat_p384_addcarryx_u32(&x532, &x533, x531, x513, x510);
  uint32_t x534;
  fiat_p384_uint1 x535;
  fiat_p384_addcarryx_u32(&x534, &x535, x533, x511, x508);
  uint32_t x536;
  fiat_p384_uint1 x537;
  fiat_p384_addcarryx_u32(&x536, &x537, x535, x509, x506);
  uint32_t x538;
  fiat_p384_uint1 x539;
  fiat_p384_addcarryx_u32(&x538, &x539, x537, x507, x504);
  uint32_t x540;
  fiat_p384_uint1 x541;
  fiat_p384_addcarryx_u32(&x540, &x541, 0x0, x480, x522);
  uint32_t x542;
  fiat_p384_uint1 x543;
  fiat_p384_addcarryx_u32(&x542, &x543, x541, x482, x523);
  uint32_t x544;
  fiat_p384_uint1 x545;
  fiat_p384_addcarryx_u32(&x544, &x545, x543, x484, 0x0);
  uint32_t x546;
  fiat_p384_uint1 x547;
  fiat_p384_addcarryx_u32(&x546, &x547, x545, x486, x520);
  uint32_t x548;
  fiat_p384_uint1 x549;
  fiat_p384_addcarryx_u32(&x548, &x549, x547, x488, x524);
  uint32_t x550;
  fiat_p384_uint1 x551;
  fiat_p384_addcarryx_u32(&x550, &x551, x549, x490, x526);
  uint32_t x552;
  fiat_p384_uint1 x553;
  fiat_p384_addcarryx_u32(&x552, &x553, x551, x492, x528);
  uint32_t x554;
  fiat_p384_uint1 x555;
  fiat_p384_addcarryx_u32(&x554, &x555, x553, x494, x530);
  uint32_t x556;
  fiat_p384_uint1 x557;
  fiat_p384_addcarryx_u32(&x556, &x557, x555, x496, x532);
  uint32_t x558;
  fiat_p384_uint1 x559;
  fiat_p384_addcarryx_u32(&x558, &x559, x557, x498, x534);
  uint32_t x560;
  fiat_p384_uint1 x561;
  fiat_p384_addcarryx_u32(&x560, &x561, x559, x500, x536);
  uint32_t x562;
  fiat_p384_uint1 x563;
  fiat_p384_addcarryx_u32(&x562, &x563, x561, x502, x538);
  uint32_t x564;
  fiat_p384_uint1 x565;
  fiat_p384_addcarryx_u32(&x564, &x565, x539, x505, 0x0);
  uint32_t x566;
  fiat_p384_uint1 x567;
  fiat_p384_addcarryx_u32(&x566, &x567, x479, 0x0, 0x0);
  uint32_t x568;
  fiat_p384_uint1 x569;
  fiat_p384_addcarryx_u32(&x568, &x569, x503, (fiat_p384_uint1)x566, 0x0);
  uint32_t x570;
  fiat_p384_uint1 x571;
  fiat_p384_addcarryx_u32(&x570, &x571, x563, x568, x564);
  uint32_t x572;
  fiat_p384_uint1 x573;
  fiat_p384_addcarryx_u32(&x572, &x573, 0x0, x542, (arg1[7]));
  uint32_t x574;
  fiat_p384_uint1 x575;
  fiat_p384_addcarryx_u32(&x574, &x575, x573, x544, 0x0);
  uint32_t x576;
  fiat_p384_uint1 x577;
  fiat_p384_addcarryx_u32(&x576, &x577, x575, x546, 0x0);
  uint32_t x578;
  fiat_p384_uint1 x579;
  fiat_p384_addcarryx_u32(&x578, &x579, x577, x548, 0x0);
  uint32_t x580;
  fiat_p384_uint1 x581;
  fiat_p384_addcarryx_u32(&x580, &x581, x579, x550, 0x0);
  uint32_t x582;
  fiat_p384_uint1 x583;
  fiat_p384_addcarryx_u32(&x582, &x583, x581, x552, 0x0);
  uint32_t x584;
  fiat_p384_uint1 x585;
  fiat_p384_addcarryx_u32(&x584, &x585, x583, x554, 0x0);
  uint32_t x586;
  fiat_p384_uint1 x587;
  fiat_p384_addcarryx_u32(&x586, &x587, x585, x556, 0x0);
  uint32_t x588;
  fiat_p384_uint1 x589;
  fiat_p384_addcarryx_u32(&x588, &x589, x587, x558, 0x0);
  uint32_t x590;
  fiat_p384_uint1 x591;
  fiat_p384_addcarryx_u32(&x590, &x591, x589, x560, 0x0);
  uint32_t x592;
  fiat_p384_uint1 x593;
  fiat_p384_addcarryx_u32(&x592, &x593, x591, x562, 0x0);
  uint32_t x594;
  fiat_p384_uint1 x595;
  fiat_p384_addcarryx_u32(&x594, &x595, x593, x570, 0x0);
  uint32_t x596;
  uint32_t x597;
  fiat_p384_mulx_u32(&x596, &x597, x572, UINT32_C(0xffffffff));
  uint32_t x598;
  uint32_t x599;
  fiat_p384_mulx_u32(&x598, &x599, x572, UINT32_C(0xffffffff));
  uint32_t x600;
  uint32_t x601;
  fiat_p384_mulx_u32(&x600, &x601, x572, UINT32_C(0xffffffff));
  uint32_t x602;
  uint32_t x603;
  fiat_p384_mulx_u32(&x602, &x603, x572, UINT32_C(0xffffffff));
  uint32_t x604;
  uint32_t x605;
  fiat_p384_mulx_u32(&x604, &x605, x572, UINT32_C(0xffffffff));
  uint32_t x606;
  uint32_t x607;
  fiat_p384_mulx_u32(&x606, &x607, x572, UINT32_C(0xffffffff));
  uint32_t x608;
  uint32_t x609;
  fiat_p384_mulx_u32(&x608, &x609, x572, UINT32_C(0xffffffff));
  uint32_t x610;
  uint32_t x611;
  fiat_p384_mulx_u32(&x610, &x611, x572, UINT32_C(0xfffffffe));
  uint32_t x612;
  uint32_t x613;
  fiat_p384_mulx_u32(&x612, &x613, x572, UINT32_C(0xffffffff));
  uint32_t x614;
  uint32_t x615;
  fiat_p384_mulx_u32(&x614, &x615, x572, UINT32_C(0xffffffff));
  uint32_t x616;
  fiat_p384_uint1 x617;
  fiat_p384_addcarryx_u32(&x616, &x617, 0x0, x613, x610);
  uint32_t x618;
  fiat_p384_uint1 x619;
  fiat_p384_addcarryx_u32(&x618, &x619, x617, x611, x608);
  uint32_t x620;
  fiat_p384_uint1 x621;
  fiat_p384_addcarryx_u32(&x620, &x621, x619, x609, x606);
  uint32_t x622;
  fiat_p384_uint1 x623;
  fiat_p384_addcarryx_u32(&x622, &x623, x621, x607, x604);
  uint32_t x624;
  fiat_p384_uint1 x625;
  fiat_p384_addcarryx_u32(&x624, &x625, x623, x605, x602);
  uint32_t x626;
  fiat_p384_uint1 x627;
  fiat_p384_addcarryx_u32(&x626, &x627, x625, x603, x600);
  uint32_t x628;
  fiat_p384_uint1 x629;
  fiat_p384_addcarryx_u32(&x628, &x629, x627, x601, x598);
  uint32_t x630;
  fiat_p384_uint1 x631;
  fiat_p384_addcarryx_u32(&x630, &x631, x629, x599, x596);
  uint32_t x632;
  fiat_p384_uint1 x633;
  fiat_p384_addcarryx_u32(&x632, &x633, 0x0, x572, x614);
  uint32_t x634;
  fiat_p384_uint1 x635;
  fiat_p384_addcarryx_u32(&x634, &x635, x633, x574, x615);
  uint32_t x636;
  fiat_p384_uint1 x637;
  fiat_p384_addcarryx_u32(&x636, &x637, x635, x576, 0x0);
  uint32_t x638;
  fiat_p384_uint1 x639;
  fiat_p384_addcarryx_u32(&x638, &x639, x637, x578, x612);
  uint32_t x640;
  fiat_p384_uint1 x641;
  fiat_p384_addcarryx_u32(&x640, &x641, x639, x580, x616);
  uint32_t x642;
  fiat_p384_uint1 x643;
  fiat_p384_addcarryx_u32(&x642, &x643, x641, x582, x618);
  uint32_t x644;
  fiat_p384_uint1 x645;
  fiat_p384_addcarryx_u32(&x644, &x645, x643, x584, x620);
  uint32_t x646;
  fiat_p384_uint1 x647;
  fiat_p384_addcarryx_u32(&x646, &x647, x645, x586, x622);
  uint32_t x648;
  fiat_p384_uint1 x649;
  fiat_p384_addcarryx_u32(&x648, &x649, x647, x588, x624);
  uint32_t x650;
  fiat_p384_uint1 x651;
  fiat_p384_addcarryx_u32(&x650, &x651, x649, x590, x626);
  uint32_t x652;
  fiat_p384_uint1 x653;
  fiat_p384_addcarryx_u32(&x652, &x653, x651, x592, x628);
  uint32_t x654;
  fiat_p384_uint1 x655;
  fiat_p384_addcarryx_u32(&x654, &x655, x653, x594, x630);
  uint32_t x656;
  fiat_p384_uint1 x657;
  fiat_p384_addcarryx_u32(&x656, &x657, x631, x597, 0x0);
  uint32_t x658;
  fiat_p384_uint1 x659;
  fiat_p384_addcarryx_u32(&x658, &x659, x571, 0x0, 0x0);
  uint32_t x660;
  fiat_p384_uint1 x661;
  fiat_p384_addcarryx_u32(&x660, &x661, x595, (fiat_p384_uint1)x658, 0x0);
  uint32_t x662;
  fiat_p384_uint1 x663;
  fiat_p384_addcarryx_u32(&x662, &x663, x655, x660, x656);
  uint32_t x664;
  fiat_p384_uint1 x665;
  fiat_p384_addcarryx_u32(&x664, &x665, 0x0, x634, (arg1[8]));
  uint32_t x666;
  fiat_p384_uint1 x667;
  fiat_p384_addcarryx_u32(&x666, &x667, x665, x636, 0x0);
  uint32_t x668;
  fiat_p384_uint1 x669;
  fiat_p384_addcarryx_u32(&x668, &x669, x667, x638, 0x0);
  uint32_t x670;
  fiat_p384_uint1 x671;
  fiat_p384_addcarryx_u32(&x670, &x671, x669, x640, 0x0);
  uint32_t x672;
  fiat_p384_uint1 x673;
  fiat_p384_addcarryx_u32(&x672, &x673, x671, x642, 0x0);
  uint32_t x674;
  fiat_p384_uint1 x675;
  fiat_p384_addcarryx_u32(&x674, &x675, x673, x644, 0x0);
  uint32_t x676;
  fiat_p384_uint1 x677;
  fiat_p384_addcarryx_u32(&x676, &x677, x675, x646, 0x0);
  uint32_t x678;
  fiat_p384_uint1 x679;
  fiat_p384_addcarryx_u32(&x678, &x679, x677, x648, 0x0);
  uint32_t x680;
  fiat_p384_uint1 x681;
  fiat_p384_addcarryx_u32(&x680, &x681, x679, x650, 0x0);
  uint32_t x682;
  fiat_p384_uint1 x683;
  fiat_p384_addcarryx_u32(&x682, &x683, x681, x652, 0x0);
  uint32_t x684;
  fiat_p384_uint1 x685;
  fiat_p384_addcarryx_u32(&x684, &x685, x683, x654, 0x0);
  uint32_t x686;
  fiat_p384_uint1 x687;
  fiat_p384_addcarryx_u32(&x686, &x687, x685, x662, 0x0);
  uint32_t x688;
  uint32_t x689;
  fiat_p384_mulx_u32(&x688, &x689, x664, UINT32_C(0xffffffff));
  uint32_t x690;
  uint32_t x691;
  fiat_p384_mulx_u32(&x690, &x691, x664, UINT32_C(0xffffffff));
  uint32_t x692;
  uint32_t x693;
  fiat_p384_mulx_u32(&x692, &x693, x664, UINT32_C(0xffffffff));
  uint32_t x694;
  uint32_t x695;
  fiat_p384_mulx_u32(&x694, &x695, x664, UINT32_C(0xffffffff));
  uint32_t x696;
  uint32_t x697;
  fiat_p384_mulx_u32(&x696, &x697, x664, UINT32_C(0xffffffff));
  uint32_t x698;
  uint32_t x699;
  fiat_p384_mulx_u32(&x698, &x699, x664, UINT32_C(0xffffffff));
  uint32_t x700;
  uint32_t x701;
  fiat_p384_mulx_u32(&x700, &x701, x664, UINT32_C(0xffffffff));
  uint32_t x702;
  uint32_t x703;
  fiat_p384_mulx_u32(&x702, &x703, x664, UINT32_C(0xfffffffe));
  uint32_t x704;
  uint32_t x705;
  fiat_p384_mulx_u32(&x704, &x705, x664, UINT32_C(0xffffffff));
  uint32_t x706;
  uint32_t x707;
  fiat_p384_mulx_u32(&x706, &x707, x664, UINT32_C(0xffffffff));
  uint32_t x708;
  fiat_p384_uint1 x709;
  fiat_p384_addcarryx_u32(&x708, &x709, 0x0, x705, x702);
  uint32_t x710;
  fiat_p384_uint1 x711;
  fiat_p384_addcarryx_u32(&x710, &x711, x709, x703, x700);
  uint32_t x712;
  fiat_p384_uint1 x713;
  fiat_p384_addcarryx_u32(&x712, &x713, x711, x701, x698);
  uint32_t x714;
  fiat_p384_uint1 x715;
  fiat_p384_addcarryx_u32(&x714, &x715, x713, x699, x696);
  uint32_t x716;
  fiat_p384_uint1 x717;
  fiat_p384_addcarryx_u32(&x716, &x717, x715, x697, x694);
  uint32_t x718;
  fiat_p384_uint1 x719;
  fiat_p384_addcarryx_u32(&x718, &x719, x717, x695, x692);
  uint32_t x720;
  fiat_p384_uint1 x721;
  fiat_p384_addcarryx_u32(&x720, &x721, x719, x693, x690);
  uint32_t x722;
  fiat_p384_uint1 x723;
  fiat_p384_addcarryx_u32(&x722, &x723, x721, x691, x688);
  uint32_t x724;
  fiat_p384_uint1 x725;
  fiat_p384_addcarryx_u32(&x724, &x725, 0x0, x664, x706);
  uint32_t x726;
  fiat_p384_uint1 x727;
  fiat_p384_addcarryx_u32(&x726, &x727, x725, x666, x707);
  uint32_t x728;
  fiat_p384_uint1 x729;
  fiat_p384_addcarryx_u32(&x728, &x729, x727, x668, 0x0);
  uint32_t x730;
  fiat_p384_uint1 x731;
  fiat_p384_addcarryx_u32(&x730, &x731, x729, x670, x704);
  uint32_t x732;
  fiat_p384_uint1 x733;
  fiat_p384_addcarryx_u32(&x732, &x733, x731, x672, x708);
  uint32_t x734;
  fiat_p384_uint1 x735;
  fiat_p384_addcarryx_u32(&x734, &x735, x733, x674, x710);
  uint32_t x736;
  fiat_p384_uint1 x737;
  fiat_p384_addcarryx_u32(&x736, &x737, x735, x676, x712);
  uint32_t x738;
  fiat_p384_uint1 x739;
  fiat_p384_addcarryx_u32(&x738, &x739, x737, x678, x714);
  uint32_t x740;
  fiat_p384_uint1 x741;
  fiat_p384_addcarryx_u32(&x740, &x741, x739, x680, x716);
  uint32_t x742;
  fiat_p384_uint1 x743;
  fiat_p384_addcarryx_u32(&x742, &x743, x741, x682, x718);
  uint32_t x744;
  fiat_p384_uint1 x745;
  fiat_p384_addcarryx_u32(&x744, &x745, x743, x684, x720);
  uint32_t x746;
  fiat_p384_uint1 x747;
  fiat_p384_addcarryx_u32(&x746, &x747, x745, x686, x722);
  uint32_t x748;
  fiat_p384_uint1 x749;
  fiat_p384_addcarryx_u32(&x748, &x749, x723, x689, 0x0);
  uint32_t x750;
  fiat_p384_uint1 x751;
  fiat_p384_addcarryx_u32(&x750, &x751, x663, 0x0, 0x0);
  uint32_t x752;
  fiat_p384_uint1 x753;
  fiat_p384_addcarryx_u32(&x752, &x753, x687, (fiat_p384_uint1)x750, 0x0);
  uint32_t x754;
  fiat_p384_uint1 x755;
  fiat_p384_addcarryx_u32(&x754, &x755, x747, x752, x748);
  uint32_t x756;
  fiat_p384_uint1 x757;
  fiat_p384_addcarryx_u32(&x756, &x757, 0x0, x726, (arg1[9]));
  uint32_t x758;
  fiat_p384_uint1 x759;
  fiat_p384_addcarryx_u32(&x758, &x759, x757, x728, 0x0);
  uint32_t x760;
  fiat_p384_uint1 x761;
  fiat_p384_addcarryx_u32(&x760, &x761, x759, x730, 0x0);
  uint32_t x762;
  fiat_p384_uint1 x763;
  fiat_p384_addcarryx_u32(&x762, &x763, x761, x732, 0x0);
  uint32_t x764;
  fiat_p384_uint1 x765;
  fiat_p384_addcarryx_u32(&x764, &x765, x763, x734, 0x0);
  uint32_t x766;
  fiat_p384_uint1 x767;
  fiat_p384_addcarryx_u32(&x766, &x767, x765, x736, 0x0);
  uint32_t x768;
  fiat_p384_uint1 x769;
  fiat_p384_addcarryx_u32(&x768, &x769, x767, x738, 0x0);
  uint32_t x770;
  fiat_p384_uint1 x771;
  fiat_p384_addcarryx_u32(&x770, &x771, x769, x740, 0x0);
  uint32_t x772;
  fiat_p384_uint1 x773;
  fiat_p384_addcarryx_u32(&x772, &x773, x771, x742, 0x0);
  uint32_t x774;
  fiat_p384_uint1 x775;
  fiat_p384_addcarryx_u32(&x774, &x775, x773, x744, 0x0);
  uint32_t x776;
  fiat_p384_uint1 x777;
  fiat_p384_addcarryx_u32(&x776, &x777, x775, x746, 0x0);
  uint32_t x778;
  fiat_p384_uint1 x779;
  fiat_p384_addcarryx_u32(&x778, &x779, x777, x754, 0x0);
  uint32_t x780;
  uint32_t x781;
  fiat_p384_mulx_u32(&x780, &x781, x756, UINT32_C(0xffffffff));
  uint32_t x782;
  uint32_t x783;
  fiat_p384_mulx_u32(&x782, &x783, x756, UINT32_C(0xffffffff));
  uint32_t x784;
  uint32_t x785;
  fiat_p384_mulx_u32(&x784, &x785, x756, UINT32_C(0xffffffff));
  uint32_t x786;
  uint32_t x787;
  fiat_p384_mulx_u32(&x786, &x787, x756, UINT32_C(0xffffffff));
  uint32_t x788;
  uint32_t x789;
  fiat_p384_mulx_u32(&x788, &x789, x756, UINT32_C(0xffffffff));
  uint32_t x790;
  uint32_t x791;
  fiat_p384_mulx_u32(&x790, &x791, x756, UINT32_C(0xffffffff));
  uint32_t x792;
  uint32_t x793;
  fiat_p384_mulx_u32(&x792, &x793, x756, UINT32_C(0xffffffff));
  uint32_t x794;
  uint32_t x795;
  fiat_p384_mulx_u32(&x794, &x795, x756, UINT32_C(0xfffffffe));
  uint32_t x796;
  uint32_t x797;
  fiat_p384_mulx_u32(&x796, &x797, x756, UINT32_C(0xffffffff));
  uint32_t x798;
  uint32_t x799;
  fiat_p384_mulx_u32(&x798, &x799, x756, UINT32_C(0xffffffff));
  uint32_t x800;
  fiat_p384_uint1 x801;
  fiat_p384_addcarryx_u32(&x800, &x801, 0x0, x797, x794);
  uint32_t x802;
  fiat_p384_uint1 x803;
  fiat_p384_addcarryx_u32(&x802, &x803, x801, x795, x792);
  uint32_t x804;
  fiat_p384_uint1 x805;
  fiat_p384_addcarryx_u32(&x804, &x805, x803, x793, x790);
  uint32_t x806;
  fiat_p384_uint1 x807;
  fiat_p384_addcarryx_u32(&x806, &x807, x805, x791, x788);
  uint32_t x808;
  fiat_p384_uint1 x809;
  fiat_p384_addcarryx_u32(&x808, &x809, x807, x789, x786);
  uint32_t x810;
  fiat_p384_uint1 x811;
  fiat_p384_addcarryx_u32(&x810, &x811, x809, x787, x784);
  uint32_t x812;
  fiat_p384_uint1 x813;
  fiat_p384_addcarryx_u32(&x812, &x813, x811, x785, x782);
  uint32_t x814;
  fiat_p384_uint1 x815;
  fiat_p384_addcarryx_u32(&x814, &x815, x813, x783, x780);
  uint32_t x816;
  fiat_p384_uint1 x817;
  fiat_p384_addcarryx_u32(&x816, &x817, 0x0, x756, x798);
  uint32_t x818;
  fiat_p384_uint1 x819;
  fiat_p384_addcarryx_u32(&x818, &x819, x817, x758, x799);
  uint32_t x820;
  fiat_p384_uint1 x821;
  fiat_p384_addcarryx_u32(&x820, &x821, x819, x760, 0x0);
  uint32_t x822;
  fiat_p384_uint1 x823;
  fiat_p384_addcarryx_u32(&x822, &x823, x821, x762, x796);
  uint32_t x824;
  fiat_p384_uint1 x825;
  fiat_p384_addcarryx_u32(&x824, &x825, x823, x764, x800);
  uint32_t x826;
  fiat_p384_uint1 x827;
  fiat_p384_addcarryx_u32(&x826, &x827, x825, x766, x802);
  uint32_t x828;
  fiat_p384_uint1 x829;
  fiat_p384_addcarryx_u32(&x828, &x829, x827, x768, x804);
  uint32_t x830;
  fiat_p384_uint1 x831;
  fiat_p384_addcarryx_u32(&x830, &x831, x829, x770, x806);
  uint32_t x832;
  fiat_p384_uint1 x833;
  fiat_p384_addcarryx_u32(&x832, &x833, x831, x772, x808);
  uint32_t x834;
  fiat_p384_uint1 x835;
  fiat_p384_addcarryx_u32(&x834, &x835, x833, x774, x810);
  uint32_t x836;
  fiat_p384_uint1 x837;
  fiat_p384_addcarryx_u32(&x836, &x837, x835, x776, x812);
  uint32_t x838;
  fiat_p384_uint1 x839;
  fiat_p384_addcarryx_u32(&x838, &x839, x837, x778, x814);
  uint32_t x840;
  fiat_p384_uint1 x841;
  fiat_p384_addcarryx_u32(&x840, &x841, x815, x781, 0x0);
  uint32_t x842;
  fiat_p384_uint1 x843;
  fiat_p384_addcarryx_u32(&x842, &x843, x755, 0x0, 0x0);
  uint32_t x844;
  fiat_p384_uint1 x845;
  fiat_p384_addcarryx_u32(&x844, &x845, x779, (fiat_p384_uint1)x842, 0x0);
  uint32_t x846;
  fiat_p384_uint1 x847;
  fiat_p384_addcarryx_u32(&x846, &x847, x839, x844, x840);
  uint32_t x848;
  fiat_p384_uint1 x849;
  fiat_p384_addcarryx_u32(&x848, &x849, 0x0, x818, (arg1[10]));
  uint32_t x850;
  fiat_p384_uint1 x851;
  fiat_p384_addcarryx_u32(&x850, &x851, x849, x820, 0x0);
  uint32_t x852;
  fiat_p384_uint1 x853;
  fiat_p384_addcarryx_u32(&x852, &x853, x851, x822, 0x0);
  uint32_t x854;
  fiat_p384_uint1 x855;
  fiat_p384_addcarryx_u32(&x854, &x855, x853, x824, 0x0);
  uint32_t x856;
  fiat_p384_uint1 x857;
  fiat_p384_addcarryx_u32(&x856, &x857, x855, x826, 0x0);
  uint32_t x858;
  fiat_p384_uint1 x859;
  fiat_p384_addcarryx_u32(&x858, &x859, x857, x828, 0x0);
  uint32_t x860;
  fiat_p384_uint1 x861;
  fiat_p384_addcarryx_u32(&x860, &x861, x859, x830, 0x0);
  uint32_t x862;
  fiat_p384_uint1 x863;
  fiat_p384_addcarryx_u32(&x862, &x863, x861, x832, 0x0);
  uint32_t x864;
  fiat_p384_uint1 x865;
  fiat_p384_addcarryx_u32(&x864, &x865, x863, x834, 0x0);
  uint32_t x866;
  fiat_p384_uint1 x867;
  fiat_p384_addcarryx_u32(&x866, &x867, x865, x836, 0x0);
  uint32_t x868;
  fiat_p384_uint1 x869;
  fiat_p384_addcarryx_u32(&x868, &x869, x867, x838, 0x0);
  uint32_t x870;
  fiat_p384_uint1 x871;
  fiat_p384_addcarryx_u32(&x870, &x871, x869, x846, 0x0);
  uint32_t x872;
  uint32_t x873;
  fiat_p384_mulx_u32(&x872, &x873, x848, UINT32_C(0xffffffff));
  uint32_t x874;
  uint32_t x875;
  fiat_p384_mulx_u32(&x874, &x875, x848, UINT32_C(0xffffffff));
  uint32_t x876;
  uint32_t x877;
  fiat_p384_mulx_u32(&x876, &x877, x848, UINT32_C(0xffffffff));
  uint32_t x878;
  uint32_t x879;
  fiat_p384_mulx_u32(&x878, &x879, x848, UINT32_C(0xffffffff));
  uint32_t x880;
  uint32_t x881;
  fiat_p384_mulx_u32(&x880, &x881, x848, UINT32_C(0xffffffff));
  uint32_t x882;
  uint32_t x883;
  fiat_p384_mulx_u32(&x882, &x883, x848, UINT32_C(0xffffffff));
  uint32_t x884;
  uint32_t x885;
  fiat_p384_mulx_u32(&x884, &x885, x848, UINT32_C(0xffffffff));
  uint32_t x886;
  uint32_t x887;
  fiat_p384_mulx_u32(&x886, &x887, x848, UINT32_C(0xfffffffe));
  uint32_t x888;
  uint32_t x889;
  fiat_p384_mulx_u32(&x888, &x889, x848, UINT32_C(0xffffffff));
  uint32_t x890;
  uint32_t x891;
  fiat_p384_mulx_u32(&x890, &x891, x848, UINT32_C(0xffffffff));
  uint32_t x892;
  fiat_p384_uint1 x893;
  fiat_p384_addcarryx_u32(&x892, &x893, 0x0, x889, x886);
  uint32_t x894;
  fiat_p384_uint1 x895;
  fiat_p384_addcarryx_u32(&x894, &x895, x893, x887, x884);
  uint32_t x896;
  fiat_p384_uint1 x897;
  fiat_p384_addcarryx_u32(&x896, &x897, x895, x885, x882);
  uint32_t x898;
  fiat_p384_uint1 x899;
  fiat_p384_addcarryx_u32(&x898, &x899, x897, x883, x880);
  uint32_t x900;
  fiat_p384_uint1 x901;
  fiat_p384_addcarryx_u32(&x900, &x901, x899, x881, x878);
  uint32_t x902;
  fiat_p384_uint1 x903;
  fiat_p384_addcarryx_u32(&x902, &x903, x901, x879, x876);
  uint32_t x904;
  fiat_p384_uint1 x905;
  fiat_p384_addcarryx_u32(&x904, &x905, x903, x877, x874);
  uint32_t x906;
  fiat_p384_uint1 x907;
  fiat_p384_addcarryx_u32(&x906, &x907, x905, x875, x872);
  uint32_t x908;
  fiat_p384_uint1 x909;
  fiat_p384_addcarryx_u32(&x908, &x909, 0x0, x848, x890);
  uint32_t x910;
  fiat_p384_uint1 x911;
  fiat_p384_addcarryx_u32(&x910, &x911, x909, x850, x891);
  uint32_t x912;
  fiat_p384_uint1 x913;
  fiat_p384_addcarryx_u32(&x912, &x913, x911, x852, 0x0);
  uint32_t x914;
  fiat_p384_uint1 x915;
  fiat_p384_addcarryx_u32(&x914, &x915, x913, x854, x888);
  uint32_t x916;
  fiat_p384_uint1 x917;
  fiat_p384_addcarryx_u32(&x916, &x917, x915, x856, x892);
  uint32_t x918;
  fiat_p384_uint1 x919;
  fiat_p384_addcarryx_u32(&x918, &x919, x917, x858, x894);
  uint32_t x920;
  fiat_p384_uint1 x921;
  fiat_p384_addcarryx_u32(&x920, &x921, x919, x860, x896);
  uint32_t x922;
  fiat_p384_uint1 x923;
  fiat_p384_addcarryx_u32(&x922, &x923, x921, x862, x898);
  uint32_t x924;
  fiat_p384_uint1 x925;
  fiat_p384_addcarryx_u32(&x924, &x925, x923, x864, x900);
  uint32_t x926;
  fiat_p384_uint1 x927;
  fiat_p384_addcarryx_u32(&x926, &x927, x925, x866, x902);
  uint32_t x928;
  fiat_p384_uint1 x929;
  fiat_p384_addcarryx_u32(&x928, &x929, x927, x868, x904);
  uint32_t x930;
  fiat_p384_uint1 x931;
  fiat_p384_addcarryx_u32(&x930, &x931, x929, x870, x906);
  uint32_t x932;
  fiat_p384_uint1 x933;
  fiat_p384_addcarryx_u32(&x932, &x933, x907, x873, 0x0);
  uint32_t x934;
  fiat_p384_uint1 x935;
  fiat_p384_addcarryx_u32(&x934, &x935, x847, 0x0, 0x0);
  uint32_t x936;
  fiat_p384_uint1 x937;
  fiat_p384_addcarryx_u32(&x936, &x937, x871, (fiat_p384_uint1)x934, 0x0);
  uint32_t x938;
  fiat_p384_uint1 x939;
  fiat_p384_addcarryx_u32(&x938, &x939, x931, x936, x932);
  uint32_t x940;
  fiat_p384_uint1 x941;
  fiat_p384_addcarryx_u32(&x940, &x941, 0x0, x910, (arg1[11]));
  uint32_t x942;
  fiat_p384_uint1 x943;
  fiat_p384_addcarryx_u32(&x942, &x943, x941, x912, 0x0);
  uint32_t x944;
  fiat_p384_uint1 x945;
  fiat_p384_addcarryx_u32(&x944, &x945, x943, x914, 0x0);
  uint32_t x946;
  fiat_p384_uint1 x947;
  fiat_p384_addcarryx_u32(&x946, &x947, x945, x916, 0x0);
  uint32_t x948;
  fiat_p384_uint1 x949;
  fiat_p384_addcarryx_u32(&x948, &x949, x947, x918, 0x0);
  uint32_t x950;
  fiat_p384_uint1 x951;
  fiat_p384_addcarryx_u32(&x950, &x951, x949, x920, 0x0);
  uint32_t x952;
  fiat_p384_uint1 x953;
  fiat_p384_addcarryx_u32(&x952, &x953, x951, x922, 0x0);
  uint32_t x954;
  fiat_p384_uint1 x955;
  fiat_p384_addcarryx_u32(&x954, &x955, x953, x924, 0x0);
  uint32_t x956;
  fiat_p384_uint1 x957;
  fiat_p384_addcarryx_u32(&x956, &x957, x955, x926, 0x0);
  uint32_t x958;
  fiat_p384_uint1 x959;
  fiat_p384_addcarryx_u32(&x958, &x959, x957, x928, 0x0);
  uint32_t x960;
  fiat_p384_uint1 x961;
  fiat_p384_addcarryx_u32(&x960, &x961, x959, x930, 0x0);
  uint32_t x962;
  fiat_p384_uint1 x963;
  fiat_p384_addcarryx_u32(&x962, &x963, x961, x938, 0x0);
  uint32_t x964;
  uint32_t x965;
  fiat_p384_mulx_u32(&x964, &x965, x940, UINT32_C(0xffffffff));
  uint32_t x966;
  uint32_t x967;
  fiat_p384_mulx_u32(&x966, &x967, x940, UINT32_C(0xffffffff));
  uint32_t x968;
  uint32_t x969;
  fiat_p384_mulx_u32(&x968, &x969, x940, UINT32_C(0xffffffff));
  uint32_t x970;
  uint32_t x971;
  fiat_p384_mulx_u32(&x970, &x971, x940, UINT32_C(0xffffffff));
  uint32_t x972;
  uint32_t x973;
  fiat_p384_mulx_u32(&x972, &x973, x940, UINT32_C(0xffffffff));
  uint32_t x974;
  uint32_t x975;
  fiat_p384_mulx_u32(&x974, &x975, x940, UINT32_C(0xffffffff));
  uint32_t x976;
  uint32_t x977;
  fiat_p384_mulx_u32(&x976, &x977, x940, UINT32_C(0xffffffff));
  uint32_t x978;
  uint32_t x979;
  fiat_p384_mulx_u32(&x978, &x979, x940, UINT32_C(0xfffffffe));
  uint32_t x980;
  uint32_t x981;
  fiat_p384_mulx_u32(&x980, &x981, x940, UINT32_C(0xffffffff));
  uint32_t x982;
  uint32_t x983;
  fiat_p384_mulx_u32(&x982, &x983, x940, UINT32_C(0xffffffff));
  uint32_t x984;
  fiat_p384_uint1 x985;
  fiat_p384_addcarryx_u32(&x984, &x985, 0x0, x981, x978);
  uint32_t x986;
  fiat_p384_uint1 x987;
  fiat_p384_addcarryx_u32(&x986, &x987, x985, x979, x976);
  uint32_t x988;
  fiat_p384_uint1 x989;
  fiat_p384_addcarryx_u32(&x988, &x989, x987, x977, x974);
  uint32_t x990;
  fiat_p384_uint1 x991;
  fiat_p384_addcarryx_u32(&x990, &x991, x989, x975, x972);
  uint32_t x992;
  fiat_p384_uint1 x993;
  fiat_p384_addcarryx_u32(&x992, &x993, x991, x973, x970);
  uint32_t x994;
  fiat_p384_uint1 x995;
  fiat_p384_addcarryx_u32(&x994, &x995, x993, x971, x968);
  uint32_t x996;
  fiat_p384_uint1 x997;
  fiat_p384_addcarryx_u32(&x996, &x997, x995, x969, x966);
  uint32_t x998;
  fiat_p384_uint1 x999;
  fiat_p384_addcarryx_u32(&x998, &x999, x997, x967, x964);
  uint32_t x1000;
  fiat_p384_uint1 x1001;
  fiat_p384_addcarryx_u32(&x1000, &x1001, 0x0, x940, x982);
  uint32_t x1002;
  fiat_p384_uint1 x1003;
  fiat_p384_addcarryx_u32(&x1002, &x1003, x1001, x942, x983);
  uint32_t x1004;
  fiat_p384_uint1 x1005;
  fiat_p384_addcarryx_u32(&x1004, &x1005, x1003, x944, 0x0);
  uint32_t x1006;
  fiat_p384_uint1 x1007;
  fiat_p384_addcarryx_u32(&x1006, &x1007, x1005, x946, x980);
  uint32_t x1008;
  fiat_p384_uint1 x1009;
  fiat_p384_addcarryx_u32(&x1008, &x1009, x1007, x948, x984);
  uint32_t x1010;
  fiat_p384_uint1 x1011;
  fiat_p384_addcarryx_u32(&x1010, &x1011, x1009, x950, x986);
  uint32_t x1012;
  fiat_p384_uint1 x1013;
  fiat_p384_addcarryx_u32(&x1012, &x1013, x1011, x952, x988);
  uint32_t x1014;
  fiat_p384_uint1 x1015;
  fiat_p384_addcarryx_u32(&x1014, &x1015, x1013, x954, x990);
  uint32_t x1016;
  fiat_p384_uint1 x1017;
  fiat_p384_addcarryx_u32(&x1016, &x1017, x1015, x956, x992);
  uint32_t x1018;
  fiat_p384_uint1 x1019;
  fiat_p384_addcarryx_u32(&x1018, &x1019, x1017, x958, x994);
  uint32_t x1020;
  fiat_p384_uint1 x1021;
  fiat_p384_addcarryx_u32(&x1020, &x1021, x1019, x960, x996);
  uint32_t x1022;
  fiat_p384_uint1 x1023;
  fiat_p384_addcarryx_u32(&x1022, &x1023, x1021, x962, x998);
  uint32_t x1024;
  fiat_p384_uint1 x1025;
  fiat_p384_addcarryx_u32(&x1024, &x1025, x999, x965, 0x0);
  uint32_t x1026;
  fiat_p384_uint1 x1027;
  fiat_p384_addcarryx_u32(&x1026, &x1027, x939, 0x0, 0x0);
  uint32_t x1028;
  fiat_p384_uint1 x1029;
  fiat_p384_addcarryx_u32(&x1028, &x1029, x963, (fiat_p384_uint1)x1026, 0x0);
  uint32_t x1030;
  fiat_p384_uint1 x1031;
  fiat_p384_addcarryx_u32(&x1030, &x1031, x1023, x1028, x1024);
  uint32_t x1032;
  fiat_p384_uint1 x1033;
  fiat_p384_subborrowx_u32(&x1032, &x1033, 0x0, x1002, UINT32_C(0xffffffff));
  uint32_t x1034;
  fiat_p384_uint1 x1035;
  fiat_p384_subborrowx_u32(&x1034, &x1035, x1033, x1004, 0x0);
  uint32_t x1036;
  fiat_p384_uint1 x1037;
  fiat_p384_subborrowx_u32(&x1036, &x1037, x1035, x1006, 0x0);
  uint32_t x1038;
  fiat_p384_uint1 x1039;
  fiat_p384_subborrowx_u32(&x1038, &x1039, x1037, x1008, UINT32_C(0xffffffff));
  uint32_t x1040;
  fiat_p384_uint1 x1041;
  fiat_p384_subborrowx_u32(&x1040, &x1041, x1039, x1010, UINT32_C(0xfffffffe));
  uint32_t x1042;
  fiat_p384_uint1 x1043;
  fiat_p384_subborrowx_u32(&x1042, &x1043, x1041, x1012, UINT32_C(0xffffffff));
  uint32_t x1044;
  fiat_p384_uint1 x1045;
  fiat_p384_subborrowx_u32(&x1044, &x1045, x1043, x1014, UINT32_C(0xffffffff));
  uint32_t x1046;
  fiat_p384_uint1 x1047;
  fiat_p384_subborrowx_u32(&x1046, &x1047, x1045, x1016, UINT32_C(0xffffffff));
  uint32_t x1048;
  fiat_p384_uint1 x1049;
  fiat_p384_subborrowx_u32(&x1048, &x1049, x1047, x1018, UINT32_C(0xffffffff));
  uint32_t x1050;
  fiat_p384_uint1 x1051;
  fiat_p384_subborrowx_u32(&x1050, &x1051, x1049, x1020, UINT32_C(0xffffffff));
  uint32_t x1052;
  fiat_p384_uint1 x1053;
  fiat_p384_subborrowx_u32(&x1052, &x1053, x1051, x1022, UINT32_C(0xffffffff));
  uint32_t x1054;
  fiat_p384_uint1 x1055;
  fiat_p384_subborrowx_u32(&x1054, &x1055, x1053, x1030, UINT32_C(0xffffffff));
  uint32_t x1056;
  fiat_p384_uint1 x1057;
  fiat_p384_addcarryx_u32(&x1056, &x1057, x1031, 0x0, 0x0);
  uint32_t x1058;
  fiat_p384_uint1 x1059;
  fiat_p384_subborrowx_u32(&x1058, &x1059, x1055, (fiat_p384_uint1)x1056, 0x0);
  uint32_t x1060;
  fiat_p384_cmovznz_u32(&x1060, x1059, x1032, x1002);
  uint32_t x1061;
  fiat_p384_cmovznz_u32(&x1061, x1059, x1034, x1004);
  uint32_t x1062;
  fiat_p384_cmovznz_u32(&x1062, x1059, x1036, x1006);
  uint32_t x1063;
  fiat_p384_cmovznz_u32(&x1063, x1059, x1038, x1008);
  uint32_t x1064;
  fiat_p384_cmovznz_u32(&x1064, x1059, x1040, x1010);
  uint32_t x1065;
  fiat_p384_cmovznz_u32(&x1065, x1059, x1042, x1012);
  uint32_t x1066;
  fiat_p384_cmovznz_u32(&x1066, x1059, x1044, x1014);
  uint32_t x1067;
  fiat_p384_cmovznz_u32(&x1067, x1059, x1046, x1016);
  uint32_t x1068;
  fiat_p384_cmovznz_u32(&x1068, x1059, x1048, x1018);
  uint32_t x1069;
  fiat_p384_cmovznz_u32(&x1069, x1059, x1050, x1020);
  uint32_t x1070;
  fiat_p384_cmovznz_u32(&x1070, x1059, x1052, x1022);
  uint32_t x1071;
  fiat_p384_cmovznz_u32(&x1071, x1059, x1054, x1030);
  out1[0] = x1060;
  out1[1] = x1061;
  out1[2] = x1062;
  out1[3] = x1063;
  out1[4] = x1064;
  out1[5] = x1065;
  out1[6] = x1066;
  out1[7] = x1067;
  out1[8] = x1068;
  out1[9] = x1069;
  out1[10] = x1070;
  out1[11] = x1071;
}

/*
 * The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p384_nonzero(uint32_t* out1, const uint32_t arg1[12]) {
  uint32_t x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | ((arg1[11]) | (uint32_t)0x0))))))))))));
  *out1 = x1;
}

/*
 * The function fiat_p384_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_selectznz(uint32_t out1[12], fiat_p384_uint1 arg1, const uint32_t arg2[12], const uint32_t arg3[12]) {
  uint32_t x1;
  fiat_p384_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  uint32_t x2;
  fiat_p384_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  uint32_t x3;
  fiat_p384_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  uint32_t x4;
  fiat_p384_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  uint32_t x5;
  fiat_p384_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  uint32_t x6;
  fiat_p384_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  uint32_t x7;
  fiat_p384_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  uint32_t x8;
  fiat_p384_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
  uint32_t x9;
  fiat_p384_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
  uint32_t x10;
  fiat_p384_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
  uint32_t x11;
  fiat_p384_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
  uint32_t x12;
  fiat_p384_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
}

/*
 * The function fiat_p384_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p384_to_bytes(uint8_t out1[48], const uint32_t arg1[12]) {
  uint32_t x1 = (arg1[11]);
  uint32_t x2 = (arg1[10]);
  uint32_t x3 = (arg1[9]);
  uint32_t x4 = (arg1[8]);
  uint32_t x5 = (arg1[7]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[5]);
  uint32_t x8 = (arg1[4]);
  uint32_t x9 = (arg1[3]);
  uint32_t x10 = (arg1[2]);
  uint32_t x11 = (arg1[1]);
  uint32_t x12 = (arg1[0]);
  uint32_t x13 = (x12 >> 8);
  uint8_t x14 = (uint8_t)(x12 & UINT8_C(0xff));
  uint32_t x15 = (x13 >> 8);
  uint8_t x16 = (uint8_t)(x13 & UINT8_C(0xff));
  uint8_t x17 = (uint8_t)(x15 >> 8);
  uint8_t x18 = (uint8_t)(x15 & UINT8_C(0xff));
  uint8_t x19 = (uint8_t)(x17 & UINT8_C(0xff));
  uint32_t x20 = (x11 >> 8);
  uint8_t x21 = (uint8_t)(x11 & UINT8_C(0xff));
  uint32_t x22 = (x20 >> 8);
  uint8_t x23 = (uint8_t)(x20 & UINT8_C(0xff));
  uint8_t x24 = (uint8_t)(x22 >> 8);
  uint8_t x25 = (uint8_t)(x22 & UINT8_C(0xff));
  uint8_t x26 = (uint8_t)(x24 & UINT8_C(0xff));
  uint32_t x27 = (x10 >> 8);
  uint8_t x28 = (uint8_t)(x10 & UINT8_C(0xff));
  uint32_t x29 = (x27 >> 8);
  uint8_t x30 = (uint8_t)(x27 & UINT8_C(0xff));
  uint8_t x31 = (uint8_t)(x29 >> 8);
  uint8_t x32 = (uint8_t)(x29 & UINT8_C(0xff));
  uint8_t x33 = (uint8_t)(x31 & UINT8_C(0xff));
  uint32_t x34 = (x9 >> 8);
  uint8_t x35 = (uint8_t)(x9 & UINT8_C(0xff));
  uint32_t x36 = (x34 >> 8);
  uint8_t x37 = (uint8_t)(x34 & UINT8_C(0xff));
  uint8_t x38 = (uint8_t)(x36 >> 8);
  uint8_t x39 = (uint8_t)(x36 & UINT8_C(0xff));
  uint8_t x40 = (uint8_t)(x38 & UINT8_C(0xff));
  uint32_t x41 = (x8 >> 8);
  uint8_t x42 = (uint8_t)(x8 & UINT8_C(0xff));
  uint32_t x43 = (x41 >> 8);
  uint8_t x44 = (uint8_t)(x41 & UINT8_C(0xff));
  uint8_t x45 = (uint8_t)(x43 >> 8);
  uint8_t x46 = (uint8_t)(x43 & UINT8_C(0xff));
  uint8_t x47 = (uint8_t)(x45 & UINT8_C(0xff));
  uint32_t x48 = (x7 >> 8);
  uint8_t x49 = (uint8_t)(x7 & UINT8_C(0xff));
  uint32_t x50 = (x48 >> 8);
  uint8_t x51 = (uint8_t)(x48 & UINT8_C(0xff));
  uint8_t x52 = (uint8_t)(x50 >> 8);
  uint8_t x53 = (uint8_t)(x50 & UINT8_C(0xff));
  uint8_t x54 = (uint8_t)(x52 & UINT8_C(0xff));
  uint32_t x55 = (x6 >> 8);
  uint8_t x56 = (uint8_t)(x6 & UINT8_C(0xff));
  uint32_t x57 = (x55 >> 8);
  uint8_t x58 = (uint8_t)(x55 & UINT8_C(0xff));
  uint8_t x59 = (uint8_t)(x57 >> 8);
  uint8_t x60 = (uint8_t)(x57 & UINT8_C(0xff));
  uint8_t x61 = (uint8_t)(x59 & UINT8_C(0xff));
  uint32_t x62 = (x5 >> 8);
  uint8_t x63 = (uint8_t)(x5 & UINT8_C(0xff));
  uint32_t x64 = (x62 >> 8);
  uint8_t x65 = (uint8_t)(x62 & UINT8_C(0xff));
  uint8_t x66 = (uint8_t)(x64 >> 8);
  uint8_t x67 = (uint8_t)(x64 & UINT8_C(0xff));
  uint8_t x68 = (uint8_t)(x66 & UINT8_C(0xff));
  uint32_t x69 = (x4 >> 8);
  uint8_t x70 = (uint8_t)(x4 & UINT8_C(0xff));
  uint32_t x71 = (x69 >> 8);
  uint8_t x72 = (uint8_t)(x69 & UINT8_C(0xff));
  uint8_t x73 = (uint8_t)(x71 >> 8);
  uint8_t x74 = (uint8_t)(x71 & UINT8_C(0xff));
  uint8_t x75 = (uint8_t)(x73 & UINT8_C(0xff));
  uint32_t x76 = (x3 >> 8);
  uint8_t x77 = (uint8_t)(x3 & UINT8_C(0xff));
  uint32_t x78 = (x76 >> 8);
  uint8_t x79 = (uint8_t)(x76 & UINT8_C(0xff));
  uint8_t x80 = (uint8_t)(x78 >> 8);
  uint8_t x81 = (uint8_t)(x78 & UINT8_C(0xff));
  uint8_t x82 = (uint8_t)(x80 & UINT8_C(0xff));
  uint32_t x83 = (x2 >> 8);
  uint8_t x84 = (uint8_t)(x2 & UINT8_C(0xff));
  uint32_t x85 = (x83 >> 8);
  uint8_t x86 = (uint8_t)(x83 & UINT8_C(0xff));
  uint8_t x87 = (uint8_t)(x85 >> 8);
  uint8_t x88 = (uint8_t)(x85 & UINT8_C(0xff));
  uint8_t x89 = (uint8_t)(x87 & UINT8_C(0xff));
  uint32_t x90 = (x1 >> 8);
  uint8_t x91 = (uint8_t)(x1 & UINT8_C(0xff));
  uint32_t x92 = (x90 >> 8);
  uint8_t x93 = (uint8_t)(x90 & UINT8_C(0xff));
  uint8_t x94 = (uint8_t)(x92 >> 8);
  uint8_t x95 = (uint8_t)(x92 & UINT8_C(0xff));
  out1[0] = x14;
  out1[1] = x16;
  out1[2] = x18;
  out1[3] = x19;
  out1[4] = x21;
  out1[5] = x23;
  out1[6] = x25;
  out1[7] = x26;
  out1[8] = x28;
  out1[9] = x30;
  out1[10] = x32;
  out1[11] = x33;
  out1[12] = x35;
  out1[13] = x37;
  out1[14] = x39;
  out1[15] = x40;
  out1[16] = x42;
  out1[17] = x44;
  out1[18] = x46;
  out1[19] = x47;
  out1[20] = x49;
  out1[21] = x51;
  out1[22] = x53;
  out1[23] = x54;
  out1[24] = x56;
  out1[25] = x58;
  out1[26] = x60;
  out1[27] = x61;
  out1[28] = x63;
  out1[29] = x65;
  out1[30] = x67;
  out1[31] = x68;
  out1[32] = x70;
  out1[33] = x72;
  out1[34] = x74;
  out1[35] = x75;
  out1[36] = x77;
  out1[37] = x79;
  out1[38] = x81;
  out1[39] = x82;
  out1[40] = x84;
  out1[41] = x86;
  out1[42] = x88;
  out1[43] = x89;
  out1[44] = x91;
  out1[45] = x93;
  out1[46] = x95;
  out1[47] = x94;
}

/*
 * The function fiat_p384_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_from_bytes(uint32_t out1[12], const uint8_t arg1[48]) {
  uint32_t x1 = ((uint32_t)(arg1[47]) << 24);
  uint32_t x2 = ((uint32_t)(arg1[46]) << 16);
  uint32_t x3 = ((uint32_t)(arg1[45]) << 8);
  uint8_t x4 = (arg1[44]);
  uint32_t x5 = ((uint32_t)(arg1[43]) << 24);
  uint32_t x6 = ((uint32_t)(arg1[42]) << 16);
  uint32_t x7 = ((uint32_t)(arg1[41]) << 8);
  uint8_t x8 = (arg1[40]);
  uint32_t x9 = ((uint32_t)(arg1[39]) << 24);
  uint32_t x10 = ((uint32_t)(arg1[38]) << 16);
  uint32_t x11 = ((uint32_t)(arg1[37]) << 8);
  uint8_t x12 = (arg1[36]);
  uint32_t x13 = ((uint32_t)(arg1[35]) << 24);
  uint32_t x14 = ((uint32_t)(arg1[34]) << 16);
  uint32_t x15 = ((uint32_t)(arg1[33]) << 8);
  uint8_t x16 = (arg1[32]);
  uint32_t x17 = ((uint32_t)(arg1[31]) << 24);
  uint32_t x18 = ((uint32_t)(arg1[30]) << 16);
  uint32_t x19 = ((uint32_t)(arg1[29]) << 8);
  uint8_t x20 = (arg1[28]);
  uint32_t x21 = ((uint32_t)(arg1[27]) << 24);
  uint32_t x22 = ((uint32_t)(arg1[26]) << 16);
  uint32_t x23 = ((uint32_t)(arg1[25]) << 8);
  uint8_t x24 = (arg1[24]);
  uint32_t x25 = ((uint32_t)(arg1[23]) << 24);
  uint32_t x26 = ((uint32_t)(arg1[22]) << 16);
  uint32_t x27 = ((uint32_t)(arg1[21]) << 8);
  uint8_t x28 = (arg1[20]);
  uint32_t x29 = ((uint32_t)(arg1[19]) << 24);
  uint32_t x30 = ((uint32_t)(arg1[18]) << 16);
  uint32_t x31 = ((uint32_t)(arg1[17]) << 8);
  uint8_t x32 = (arg1[16]);
  uint32_t x33 = ((uint32_t)(arg1[15]) << 24);
  uint32_t x34 = ((uint32_t)(arg1[14]) << 16);
  uint32_t x35 = ((uint32_t)(arg1[13]) << 8);
  uint8_t x36 = (arg1[12]);
  uint32_t x37 = ((uint32_t)(arg1[11]) << 24);
  uint32_t x38 = ((uint32_t)(arg1[10]) << 16);
  uint32_t x39 = ((uint32_t)(arg1[9]) << 8);
  uint8_t x40 = (arg1[8]);
  uint32_t x41 = ((uint32_t)(arg1[7]) << 24);
  uint32_t x42 = ((uint32_t)(arg1[6]) << 16);
  uint32_t x43 = ((uint32_t)(arg1[5]) << 8);
  uint8_t x44 = (arg1[4]);
  uint32_t x45 = ((uint32_t)(arg1[3]) << 24);
  uint32_t x46 = ((uint32_t)(arg1[2]) << 16);
  uint32_t x47 = ((uint32_t)(arg1[1]) << 8);
  uint8_t x48 = (arg1[0]);
  uint32_t x49 = (x48 + (x47 + (x46 + x45)));
  uint32_t x50 = (x49 & UINT32_C(0xffffffff));
  uint32_t x51 = (x4 + (x3 + (x2 + x1)));
  uint32_t x52 = (x8 + (x7 + (x6 + x5)));
  uint32_t x53 = (x12 + (x11 + (x10 + x9)));
  uint32_t x54 = (x16 + (x15 + (x14 + x13)));
  uint32_t x55 = (x20 + (x19 + (x18 + x17)));
  uint32_t x56 = (x24 + (x23 + (x22 + x21)));
  uint32_t x57 = (x28 + (x27 + (x26 + x25)));
  uint32_t x58 = (x32 + (x31 + (x30 + x29)));
  uint32_t x59 = (x36 + (x35 + (x34 + x33)));
  uint32_t x60 = (x40 + (x39 + (x38 + x37)));
  uint32_t x61 = (x44 + (x43 + (x42 + x41)));
  uint32_t x62 = (x61 & UINT32_C(0xffffffff));
  uint32_t x63 = (x60 & UINT32_C(0xffffffff));
  uint32_t x64 = (x59 & UINT32_C(0xffffffff));
  uint32_t x65 = (x58 & UINT32_C(0xffffffff));
  uint32_t x66 = (x57 & UINT32_C(0xffffffff));
  uint32_t x67 = (x56 & UINT32_C(0xffffffff));
  uint32_t x68 = (x55 & UINT32_C(0xffffffff));
  uint32_t x69 = (x54 & UINT32_C(0xffffffff));
  uint32_t x70 = (x53 & UINT32_C(0xffffffff));
  uint32_t x71 = (x52 & UINT32_C(0xffffffff));
  out1[0] = x50;
  out1[1] = x62;
  out1[2] = x63;
  out1[3] = x64;
  out1[4] = x65;
  out1[5] = x66;
  out1[6] = x67;
  out1[7] = x68;
  out1[8] = x69;
  out1[9] = x70;
  out1[10] = x71;
  out1[11] = x51;
}
