/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery --static p224 '2^224 - 2^96 + 1' 64 */
/* curve description: p224 */
/* requested operations: (all) */
/* m = 0xffffffffffffffffffffffffffffffff000000000000000000000001 (from "2^224 - 2^96 + 1") */
/* machine_wordsize = 64 (from "64") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */

#include <stdint.h>
typedef unsigned char fiat_p224_uint1;
typedef signed char fiat_p224_int1;
FIAT_EXTENSION typedef signed __int128 fiat_p224_int128;
FIAT_EXTENSION typedef unsigned __int128 fiat_p224_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p224_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p224_addcarryx_u64(uint64_t* out1, fiat_p224_uint1* out2, fiat_p224_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p224_uint128 x1 = ((arg1 + (fiat_p224_uint128)arg2) + arg3);
  uint64_t x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  fiat_p224_uint1 x3 = (fiat_p224_uint1)(x1 >> 64);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p224_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p224_subborrowx_u64(uint64_t* out1, fiat_p224_uint1* out2, fiat_p224_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p224_int128 x1 = ((arg2 - (fiat_p224_int128)arg1) - arg3);
  fiat_p224_int1 x2 = (fiat_p224_int1)(x1 >> 64);
  uint64_t x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p224_uint1)(0x0 - x2);
}

/*
 * The function fiat_p224_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p224_mulx_u64(uint64_t* out1, uint64_t* out2, uint64_t arg1, uint64_t arg2) {
  fiat_p224_uint128 x1 = ((fiat_p224_uint128)arg1 * arg2);
  uint64_t x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
  uint64_t x3 = (uint64_t)(x1 >> 64);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p224_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p224_cmovznz_u64(uint64_t* out1, fiat_p224_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p224_uint1 x1 = (!(!arg1));
  uint64_t x2 = ((fiat_p224_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  uint64_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p224_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_mul(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  uint64_t x1 = (arg1[1]);
  uint64_t x2 = (arg1[2]);
  uint64_t x3 = (arg1[3]);
  uint64_t x4 = (arg1[0]);
  uint64_t x5;
  uint64_t x6;
  fiat_p224_mulx_u64(&x5, &x6, x4, (arg2[3]));
  uint64_t x7;
  uint64_t x8;
  fiat_p224_mulx_u64(&x7, &x8, x4, (arg2[2]));
  uint64_t x9;
  uint64_t x10;
  fiat_p224_mulx_u64(&x9, &x10, x4, (arg2[1]));
  uint64_t x11;
  uint64_t x12;
  fiat_p224_mulx_u64(&x11, &x12, x4, (arg2[0]));
  uint64_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_addcarryx_u64(&x13, &x14, 0x0, x12, x9);
  uint64_t x15;
  fiat_p224_uint1 x16;
  fiat_p224_addcarryx_u64(&x15, &x16, x14, x10, x7);
  uint64_t x17;
  fiat_p224_uint1 x18;
  fiat_p224_addcarryx_u64(&x17, &x18, x16, x8, x5);
  uint64_t x19;
  fiat_p224_uint1 x20;
  fiat_p224_addcarryx_u64(&x19, &x20, x18, x6, 0x0);
  uint64_t x21;
  uint64_t x22;
  fiat_p224_mulx_u64(&x21, &x22, x11, UINT64_C(0xffffffffffffffff));
  uint64_t x23;
  uint64_t x24;
  fiat_p224_mulx_u64(&x23, &x24, x21, UINT32_C(0xffffffff));
  uint64_t x25;
  uint64_t x26;
  fiat_p224_mulx_u64(&x25, &x26, x21, UINT64_C(0xffffffffffffffff));
  uint64_t x27;
  uint64_t x28;
  fiat_p224_mulx_u64(&x27, &x28, x21, UINT64_C(0xffffffff00000000));
  uint64_t x29;
  fiat_p224_uint1 x30;
  fiat_p224_addcarryx_u64(&x29, &x30, 0x0, x28, x25);
  uint64_t x31;
  fiat_p224_uint1 x32;
  fiat_p224_addcarryx_u64(&x31, &x32, x30, x26, x23);
  uint64_t x33;
  fiat_p224_uint1 x34;
  fiat_p224_addcarryx_u64(&x33, &x34, x32, x24, 0x0);
  uint64_t x35;
  fiat_p224_uint1 x36;
  fiat_p224_addcarryx_u64(&x35, &x36, 0x0, x11, x21);
  uint64_t x37;
  fiat_p224_uint1 x38;
  fiat_p224_addcarryx_u64(&x37, &x38, x36, x13, x27);
  uint64_t x39;
  fiat_p224_uint1 x40;
  fiat_p224_addcarryx_u64(&x39, &x40, x38, x15, x29);
  uint64_t x41;
  fiat_p224_uint1 x42;
  fiat_p224_addcarryx_u64(&x41, &x42, x40, x17, x31);
  uint64_t x43;
  fiat_p224_uint1 x44;
  fiat_p224_addcarryx_u64(&x43, &x44, x42, x19, x33);
  uint64_t x45;
  fiat_p224_uint1 x46;
  fiat_p224_addcarryx_u64(&x45, &x46, x44, 0x0, 0x0);
  uint64_t x47;
  uint64_t x48;
  fiat_p224_mulx_u64(&x47, &x48, x1, (arg2[3]));
  uint64_t x49;
  uint64_t x50;
  fiat_p224_mulx_u64(&x49, &x50, x1, (arg2[2]));
  uint64_t x51;
  uint64_t x52;
  fiat_p224_mulx_u64(&x51, &x52, x1, (arg2[1]));
  uint64_t x53;
  uint64_t x54;
  fiat_p224_mulx_u64(&x53, &x54, x1, (arg2[0]));
  uint64_t x55;
  fiat_p224_uint1 x56;
  fiat_p224_addcarryx_u64(&x55, &x56, 0x0, x54, x51);
  uint64_t x57;
  fiat_p224_uint1 x58;
  fiat_p224_addcarryx_u64(&x57, &x58, x56, x52, x49);
  uint64_t x59;
  fiat_p224_uint1 x60;
  fiat_p224_addcarryx_u64(&x59, &x60, x58, x50, x47);
  uint64_t x61;
  fiat_p224_uint1 x62;
  fiat_p224_addcarryx_u64(&x61, &x62, x60, x48, 0x0);
  uint64_t x63;
  fiat_p224_uint1 x64;
  fiat_p224_addcarryx_u64(&x63, &x64, 0x0, x37, x53);
  uint64_t x65;
  fiat_p224_uint1 x66;
  fiat_p224_addcarryx_u64(&x65, &x66, x64, x39, x55);
  uint64_t x67;
  fiat_p224_uint1 x68;
  fiat_p224_addcarryx_u64(&x67, &x68, x66, x41, x57);
  uint64_t x69;
  fiat_p224_uint1 x70;
  fiat_p224_addcarryx_u64(&x69, &x70, x68, x43, x59);
  uint64_t x71;
  fiat_p224_uint1 x72;
  fiat_p224_addcarryx_u64(&x71, &x72, x70, (fiat_p224_uint1)x45, x61);
  uint64_t x73;
  uint64_t x74;
  fiat_p224_mulx_u64(&x73, &x74, x63, UINT64_C(0xffffffffffffffff));
  uint64_t x75;
  uint64_t x76;
  fiat_p224_mulx_u64(&x75, &x76, x73, UINT32_C(0xffffffff));
  uint64_t x77;
  uint64_t x78;
  fiat_p224_mulx_u64(&x77, &x78, x73, UINT64_C(0xffffffffffffffff));
  uint64_t x79;
  uint64_t x80;
  fiat_p224_mulx_u64(&x79, &x80, x73, UINT64_C(0xffffffff00000000));
  uint64_t x81;
  fiat_p224_uint1 x82;
  fiat_p224_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
  uint64_t x83;
  fiat_p224_uint1 x84;
  fiat_p224_addcarryx_u64(&x83, &x84, x82, x78, x75);
  uint64_t x85;
  fiat_p224_uint1 x86;
  fiat_p224_addcarryx_u64(&x85, &x86, x84, x76, 0x0);
  uint64_t x87;
  fiat_p224_uint1 x88;
  fiat_p224_addcarryx_u64(&x87, &x88, 0x0, x63, x73);
  uint64_t x89;
  fiat_p224_uint1 x90;
  fiat_p224_addcarryx_u64(&x89, &x90, x88, x65, x79);
  uint64_t x91;
  fiat_p224_uint1 x92;
  fiat_p224_addcarryx_u64(&x91, &x92, x90, x67, x81);
  uint64_t x93;
  fiat_p224_uint1 x94;
  fiat_p224_addcarryx_u64(&x93, &x94, x92, x69, x83);
  uint64_t x95;
  fiat_p224_uint1 x96;
  fiat_p224_addcarryx_u64(&x95, &x96, x94, x71, x85);
  uint64_t x97;
  fiat_p224_uint1 x98;
  fiat_p224_addcarryx_u64(&x97, &x98, x96, x72, 0x0);
  uint64_t x99;
  uint64_t x100;
  fiat_p224_mulx_u64(&x99, &x100, x2, (arg2[3]));
  uint64_t x101;
  uint64_t x102;
  fiat_p224_mulx_u64(&x101, &x102, x2, (arg2[2]));
  uint64_t x103;
  uint64_t x104;
  fiat_p224_mulx_u64(&x103, &x104, x2, (arg2[1]));
  uint64_t x105;
  uint64_t x106;
  fiat_p224_mulx_u64(&x105, &x106, x2, (arg2[0]));
  uint64_t x107;
  fiat_p224_uint1 x108;
  fiat_p224_addcarryx_u64(&x107, &x108, 0x0, x106, x103);
  uint64_t x109;
  fiat_p224_uint1 x110;
  fiat_p224_addcarryx_u64(&x109, &x110, x108, x104, x101);
  uint64_t x111;
  fiat_p224_uint1 x112;
  fiat_p224_addcarryx_u64(&x111, &x112, x110, x102, x99);
  uint64_t x113;
  fiat_p224_uint1 x114;
  fiat_p224_addcarryx_u64(&x113, &x114, x112, x100, 0x0);
  uint64_t x115;
  fiat_p224_uint1 x116;
  fiat_p224_addcarryx_u64(&x115, &x116, 0x0, x89, x105);
  uint64_t x117;
  fiat_p224_uint1 x118;
  fiat_p224_addcarryx_u64(&x117, &x118, x116, x91, x107);
  uint64_t x119;
  fiat_p224_uint1 x120;
  fiat_p224_addcarryx_u64(&x119, &x120, x118, x93, x109);
  uint64_t x121;
  fiat_p224_uint1 x122;
  fiat_p224_addcarryx_u64(&x121, &x122, x120, x95, x111);
  uint64_t x123;
  fiat_p224_uint1 x124;
  fiat_p224_addcarryx_u64(&x123, &x124, x122, x97, x113);
  uint64_t x125;
  uint64_t x126;
  fiat_p224_mulx_u64(&x125, &x126, x115, UINT64_C(0xffffffffffffffff));
  uint64_t x127;
  uint64_t x128;
  fiat_p224_mulx_u64(&x127, &x128, x125, UINT32_C(0xffffffff));
  uint64_t x129;
  uint64_t x130;
  fiat_p224_mulx_u64(&x129, &x130, x125, UINT64_C(0xffffffffffffffff));
  uint64_t x131;
  uint64_t x132;
  fiat_p224_mulx_u64(&x131, &x132, x125, UINT64_C(0xffffffff00000000));
  uint64_t x133;
  fiat_p224_uint1 x134;
  fiat_p224_addcarryx_u64(&x133, &x134, 0x0, x132, x129);
  uint64_t x135;
  fiat_p224_uint1 x136;
  fiat_p224_addcarryx_u64(&x135, &x136, x134, x130, x127);
  uint64_t x137;
  fiat_p224_uint1 x138;
  fiat_p224_addcarryx_u64(&x137, &x138, x136, x128, 0x0);
  uint64_t x139;
  fiat_p224_uint1 x140;
  fiat_p224_addcarryx_u64(&x139, &x140, 0x0, x115, x125);
  uint64_t x141;
  fiat_p224_uint1 x142;
  fiat_p224_addcarryx_u64(&x141, &x142, x140, x117, x131);
  uint64_t x143;
  fiat_p224_uint1 x144;
  fiat_p224_addcarryx_u64(&x143, &x144, x142, x119, x133);
  uint64_t x145;
  fiat_p224_uint1 x146;
  fiat_p224_addcarryx_u64(&x145, &x146, x144, x121, x135);
  uint64_t x147;
  fiat_p224_uint1 x148;
  fiat_p224_addcarryx_u64(&x147, &x148, x146, x123, x137);
  uint64_t x149;
  fiat_p224_uint1 x150;
  fiat_p224_addcarryx_u64(&x149, &x150, x148, x124, 0x0);
  uint64_t x151;
  uint64_t x152;
  fiat_p224_mulx_u64(&x151, &x152, x3, (arg2[3]));
  uint64_t x153;
  uint64_t x154;
  fiat_p224_mulx_u64(&x153, &x154, x3, (arg2[2]));
  uint64_t x155;
  uint64_t x156;
  fiat_p224_mulx_u64(&x155, &x156, x3, (arg2[1]));
  uint64_t x157;
  uint64_t x158;
  fiat_p224_mulx_u64(&x157, &x158, x3, (arg2[0]));
  uint64_t x159;
  fiat_p224_uint1 x160;
  fiat_p224_addcarryx_u64(&x159, &x160, 0x0, x158, x155);
  uint64_t x161;
  fiat_p224_uint1 x162;
  fiat_p224_addcarryx_u64(&x161, &x162, x160, x156, x153);
  uint64_t x163;
  fiat_p224_uint1 x164;
  fiat_p224_addcarryx_u64(&x163, &x164, x162, x154, x151);
  uint64_t x165;
  fiat_p224_uint1 x166;
  fiat_p224_addcarryx_u64(&x165, &x166, x164, x152, 0x0);
  uint64_t x167;
  fiat_p224_uint1 x168;
  fiat_p224_addcarryx_u64(&x167, &x168, 0x0, x141, x157);
  uint64_t x169;
  fiat_p224_uint1 x170;
  fiat_p224_addcarryx_u64(&x169, &x170, x168, x143, x159);
  uint64_t x171;
  fiat_p224_uint1 x172;
  fiat_p224_addcarryx_u64(&x171, &x172, x170, x145, x161);
  uint64_t x173;
  fiat_p224_uint1 x174;
  fiat_p224_addcarryx_u64(&x173, &x174, x172, x147, x163);
  uint64_t x175;
  fiat_p224_uint1 x176;
  fiat_p224_addcarryx_u64(&x175, &x176, x174, x149, x165);
  uint64_t x177;
  uint64_t x178;
  fiat_p224_mulx_u64(&x177, &x178, x167, UINT64_C(0xffffffffffffffff));
  uint64_t x179;
  uint64_t x180;
  fiat_p224_mulx_u64(&x179, &x180, x177, UINT32_C(0xffffffff));
  uint64_t x181;
  uint64_t x182;
  fiat_p224_mulx_u64(&x181, &x182, x177, UINT64_C(0xffffffffffffffff));
  uint64_t x183;
  uint64_t x184;
  fiat_p224_mulx_u64(&x183, &x184, x177, UINT64_C(0xffffffff00000000));
  uint64_t x185;
  fiat_p224_uint1 x186;
  fiat_p224_addcarryx_u64(&x185, &x186, 0x0, x184, x181);
  uint64_t x187;
  fiat_p224_uint1 x188;
  fiat_p224_addcarryx_u64(&x187, &x188, x186, x182, x179);
  uint64_t x189;
  fiat_p224_uint1 x190;
  fiat_p224_addcarryx_u64(&x189, &x190, x188, x180, 0x0);
  uint64_t x191;
  fiat_p224_uint1 x192;
  fiat_p224_addcarryx_u64(&x191, &x192, 0x0, x167, x177);
  uint64_t x193;
  fiat_p224_uint1 x194;
  fiat_p224_addcarryx_u64(&x193, &x194, x192, x169, x183);
  uint64_t x195;
  fiat_p224_uint1 x196;
  fiat_p224_addcarryx_u64(&x195, &x196, x194, x171, x185);
  uint64_t x197;
  fiat_p224_uint1 x198;
  fiat_p224_addcarryx_u64(&x197, &x198, x196, x173, x187);
  uint64_t x199;
  fiat_p224_uint1 x200;
  fiat_p224_addcarryx_u64(&x199, &x200, x198, x175, x189);
  uint64_t x201;
  fiat_p224_uint1 x202;
  fiat_p224_addcarryx_u64(&x201, &x202, x200, x176, 0x0);
  uint64_t x203;
  fiat_p224_uint1 x204;
  fiat_p224_subborrowx_u64(&x203, &x204, 0x0, x193, 0x1);
  uint64_t x205;
  fiat_p224_uint1 x206;
  fiat_p224_subborrowx_u64(&x205, &x206, x204, x195, UINT64_C(0xffffffff00000000));
  uint64_t x207;
  fiat_p224_uint1 x208;
  fiat_p224_subborrowx_u64(&x207, &x208, x206, x197, UINT64_C(0xffffffffffffffff));
  uint64_t x209;
  fiat_p224_uint1 x210;
  fiat_p224_subborrowx_u64(&x209, &x210, x208, x199, UINT32_C(0xffffffff));
  uint64_t x211;
  fiat_p224_uint1 x212;
  fiat_p224_subborrowx_u64(&x211, &x212, x210, x201, 0x0);
  uint64_t x213;
  fiat_p224_cmovznz_u64(&x213, x212, x203, x193);
  uint64_t x214;
  fiat_p224_cmovznz_u64(&x214, x212, x205, x195);
  uint64_t x215;
  fiat_p224_cmovznz_u64(&x215, x212, x207, x197);
  uint64_t x216;
  fiat_p224_cmovznz_u64(&x216, x212, x209, x199);
  out1[0] = x213;
  out1[1] = x214;
  out1[2] = x215;
  out1[3] = x216;
}

/*
 * The function fiat_p224_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_square(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1 = (arg1[1]);
  uint64_t x2 = (arg1[2]);
  uint64_t x3 = (arg1[3]);
  uint64_t x4 = (arg1[0]);
  uint64_t x5;
  uint64_t x6;
  fiat_p224_mulx_u64(&x5, &x6, x4, (arg1[3]));
  uint64_t x7;
  uint64_t x8;
  fiat_p224_mulx_u64(&x7, &x8, x4, (arg1[2]));
  uint64_t x9;
  uint64_t x10;
  fiat_p224_mulx_u64(&x9, &x10, x4, (arg1[1]));
  uint64_t x11;
  uint64_t x12;
  fiat_p224_mulx_u64(&x11, &x12, x4, (arg1[0]));
  uint64_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_addcarryx_u64(&x13, &x14, 0x0, x12, x9);
  uint64_t x15;
  fiat_p224_uint1 x16;
  fiat_p224_addcarryx_u64(&x15, &x16, x14, x10, x7);
  uint64_t x17;
  fiat_p224_uint1 x18;
  fiat_p224_addcarryx_u64(&x17, &x18, x16, x8, x5);
  uint64_t x19;
  fiat_p224_uint1 x20;
  fiat_p224_addcarryx_u64(&x19, &x20, x18, x6, 0x0);
  uint64_t x21;
  uint64_t x22;
  fiat_p224_mulx_u64(&x21, &x22, x11, UINT64_C(0xffffffffffffffff));
  uint64_t x23;
  uint64_t x24;
  fiat_p224_mulx_u64(&x23, &x24, x21, UINT32_C(0xffffffff));
  uint64_t x25;
  uint64_t x26;
  fiat_p224_mulx_u64(&x25, &x26, x21, UINT64_C(0xffffffffffffffff));
  uint64_t x27;
  uint64_t x28;
  fiat_p224_mulx_u64(&x27, &x28, x21, UINT64_C(0xffffffff00000000));
  uint64_t x29;
  fiat_p224_uint1 x30;
  fiat_p224_addcarryx_u64(&x29, &x30, 0x0, x28, x25);
  uint64_t x31;
  fiat_p224_uint1 x32;
  fiat_p224_addcarryx_u64(&x31, &x32, x30, x26, x23);
  uint64_t x33;
  fiat_p224_uint1 x34;
  fiat_p224_addcarryx_u64(&x33, &x34, x32, x24, 0x0);
  uint64_t x35;
  fiat_p224_uint1 x36;
  fiat_p224_addcarryx_u64(&x35, &x36, 0x0, x11, x21);
  uint64_t x37;
  fiat_p224_uint1 x38;
  fiat_p224_addcarryx_u64(&x37, &x38, x36, x13, x27);
  uint64_t x39;
  fiat_p224_uint1 x40;
  fiat_p224_addcarryx_u64(&x39, &x40, x38, x15, x29);
  uint64_t x41;
  fiat_p224_uint1 x42;
  fiat_p224_addcarryx_u64(&x41, &x42, x40, x17, x31);
  uint64_t x43;
  fiat_p224_uint1 x44;
  fiat_p224_addcarryx_u64(&x43, &x44, x42, x19, x33);
  uint64_t x45;
  fiat_p224_uint1 x46;
  fiat_p224_addcarryx_u64(&x45, &x46, x44, 0x0, 0x0);
  uint64_t x47;
  uint64_t x48;
  fiat_p224_mulx_u64(&x47, &x48, x1, (arg1[3]));
  uint64_t x49;
  uint64_t x50;
  fiat_p224_mulx_u64(&x49, &x50, x1, (arg1[2]));
  uint64_t x51;
  uint64_t x52;
  fiat_p224_mulx_u64(&x51, &x52, x1, (arg1[1]));
  uint64_t x53;
  uint64_t x54;
  fiat_p224_mulx_u64(&x53, &x54, x1, (arg1[0]));
  uint64_t x55;
  fiat_p224_uint1 x56;
  fiat_p224_addcarryx_u64(&x55, &x56, 0x0, x54, x51);
  uint64_t x57;
  fiat_p224_uint1 x58;
  fiat_p224_addcarryx_u64(&x57, &x58, x56, x52, x49);
  uint64_t x59;
  fiat_p224_uint1 x60;
  fiat_p224_addcarryx_u64(&x59, &x60, x58, x50, x47);
  uint64_t x61;
  fiat_p224_uint1 x62;
  fiat_p224_addcarryx_u64(&x61, &x62, x60, x48, 0x0);
  uint64_t x63;
  fiat_p224_uint1 x64;
  fiat_p224_addcarryx_u64(&x63, &x64, 0x0, x37, x53);
  uint64_t x65;
  fiat_p224_uint1 x66;
  fiat_p224_addcarryx_u64(&x65, &x66, x64, x39, x55);
  uint64_t x67;
  fiat_p224_uint1 x68;
  fiat_p224_addcarryx_u64(&x67, &x68, x66, x41, x57);
  uint64_t x69;
  fiat_p224_uint1 x70;
  fiat_p224_addcarryx_u64(&x69, &x70, x68, x43, x59);
  uint64_t x71;
  fiat_p224_uint1 x72;
  fiat_p224_addcarryx_u64(&x71, &x72, x70, (fiat_p224_uint1)x45, x61);
  uint64_t x73;
  uint64_t x74;
  fiat_p224_mulx_u64(&x73, &x74, x63, UINT64_C(0xffffffffffffffff));
  uint64_t x75;
  uint64_t x76;
  fiat_p224_mulx_u64(&x75, &x76, x73, UINT32_C(0xffffffff));
  uint64_t x77;
  uint64_t x78;
  fiat_p224_mulx_u64(&x77, &x78, x73, UINT64_C(0xffffffffffffffff));
  uint64_t x79;
  uint64_t x80;
  fiat_p224_mulx_u64(&x79, &x80, x73, UINT64_C(0xffffffff00000000));
  uint64_t x81;
  fiat_p224_uint1 x82;
  fiat_p224_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
  uint64_t x83;
  fiat_p224_uint1 x84;
  fiat_p224_addcarryx_u64(&x83, &x84, x82, x78, x75);
  uint64_t x85;
  fiat_p224_uint1 x86;
  fiat_p224_addcarryx_u64(&x85, &x86, x84, x76, 0x0);
  uint64_t x87;
  fiat_p224_uint1 x88;
  fiat_p224_addcarryx_u64(&x87, &x88, 0x0, x63, x73);
  uint64_t x89;
  fiat_p224_uint1 x90;
  fiat_p224_addcarryx_u64(&x89, &x90, x88, x65, x79);
  uint64_t x91;
  fiat_p224_uint1 x92;
  fiat_p224_addcarryx_u64(&x91, &x92, x90, x67, x81);
  uint64_t x93;
  fiat_p224_uint1 x94;
  fiat_p224_addcarryx_u64(&x93, &x94, x92, x69, x83);
  uint64_t x95;
  fiat_p224_uint1 x96;
  fiat_p224_addcarryx_u64(&x95, &x96, x94, x71, x85);
  uint64_t x97;
  fiat_p224_uint1 x98;
  fiat_p224_addcarryx_u64(&x97, &x98, x96, x72, 0x0);
  uint64_t x99;
  uint64_t x100;
  fiat_p224_mulx_u64(&x99, &x100, x2, (arg1[3]));
  uint64_t x101;
  uint64_t x102;
  fiat_p224_mulx_u64(&x101, &x102, x2, (arg1[2]));
  uint64_t x103;
  uint64_t x104;
  fiat_p224_mulx_u64(&x103, &x104, x2, (arg1[1]));
  uint64_t x105;
  uint64_t x106;
  fiat_p224_mulx_u64(&x105, &x106, x2, (arg1[0]));
  uint64_t x107;
  fiat_p224_uint1 x108;
  fiat_p224_addcarryx_u64(&x107, &x108, 0x0, x106, x103);
  uint64_t x109;
  fiat_p224_uint1 x110;
  fiat_p224_addcarryx_u64(&x109, &x110, x108, x104, x101);
  uint64_t x111;
  fiat_p224_uint1 x112;
  fiat_p224_addcarryx_u64(&x111, &x112, x110, x102, x99);
  uint64_t x113;
  fiat_p224_uint1 x114;
  fiat_p224_addcarryx_u64(&x113, &x114, x112, x100, 0x0);
  uint64_t x115;
  fiat_p224_uint1 x116;
  fiat_p224_addcarryx_u64(&x115, &x116, 0x0, x89, x105);
  uint64_t x117;
  fiat_p224_uint1 x118;
  fiat_p224_addcarryx_u64(&x117, &x118, x116, x91, x107);
  uint64_t x119;
  fiat_p224_uint1 x120;
  fiat_p224_addcarryx_u64(&x119, &x120, x118, x93, x109);
  uint64_t x121;
  fiat_p224_uint1 x122;
  fiat_p224_addcarryx_u64(&x121, &x122, x120, x95, x111);
  uint64_t x123;
  fiat_p224_uint1 x124;
  fiat_p224_addcarryx_u64(&x123, &x124, x122, x97, x113);
  uint64_t x125;
  uint64_t x126;
  fiat_p224_mulx_u64(&x125, &x126, x115, UINT64_C(0xffffffffffffffff));
  uint64_t x127;
  uint64_t x128;
  fiat_p224_mulx_u64(&x127, &x128, x125, UINT32_C(0xffffffff));
  uint64_t x129;
  uint64_t x130;
  fiat_p224_mulx_u64(&x129, &x130, x125, UINT64_C(0xffffffffffffffff));
  uint64_t x131;
  uint64_t x132;
  fiat_p224_mulx_u64(&x131, &x132, x125, UINT64_C(0xffffffff00000000));
  uint64_t x133;
  fiat_p224_uint1 x134;
  fiat_p224_addcarryx_u64(&x133, &x134, 0x0, x132, x129);
  uint64_t x135;
  fiat_p224_uint1 x136;
  fiat_p224_addcarryx_u64(&x135, &x136, x134, x130, x127);
  uint64_t x137;
  fiat_p224_uint1 x138;
  fiat_p224_addcarryx_u64(&x137, &x138, x136, x128, 0x0);
  uint64_t x139;
  fiat_p224_uint1 x140;
  fiat_p224_addcarryx_u64(&x139, &x140, 0x0, x115, x125);
  uint64_t x141;
  fiat_p224_uint1 x142;
  fiat_p224_addcarryx_u64(&x141, &x142, x140, x117, x131);
  uint64_t x143;
  fiat_p224_uint1 x144;
  fiat_p224_addcarryx_u64(&x143, &x144, x142, x119, x133);
  uint64_t x145;
  fiat_p224_uint1 x146;
  fiat_p224_addcarryx_u64(&x145, &x146, x144, x121, x135);
  uint64_t x147;
  fiat_p224_uint1 x148;
  fiat_p224_addcarryx_u64(&x147, &x148, x146, x123, x137);
  uint64_t x149;
  fiat_p224_uint1 x150;
  fiat_p224_addcarryx_u64(&x149, &x150, x148, x124, 0x0);
  uint64_t x151;
  uint64_t x152;
  fiat_p224_mulx_u64(&x151, &x152, x3, (arg1[3]));
  uint64_t x153;
  uint64_t x154;
  fiat_p224_mulx_u64(&x153, &x154, x3, (arg1[2]));
  uint64_t x155;
  uint64_t x156;
  fiat_p224_mulx_u64(&x155, &x156, x3, (arg1[1]));
  uint64_t x157;
  uint64_t x158;
  fiat_p224_mulx_u64(&x157, &x158, x3, (arg1[0]));
  uint64_t x159;
  fiat_p224_uint1 x160;
  fiat_p224_addcarryx_u64(&x159, &x160, 0x0, x158, x155);
  uint64_t x161;
  fiat_p224_uint1 x162;
  fiat_p224_addcarryx_u64(&x161, &x162, x160, x156, x153);
  uint64_t x163;
  fiat_p224_uint1 x164;
  fiat_p224_addcarryx_u64(&x163, &x164, x162, x154, x151);
  uint64_t x165;
  fiat_p224_uint1 x166;
  fiat_p224_addcarryx_u64(&x165, &x166, x164, x152, 0x0);
  uint64_t x167;
  fiat_p224_uint1 x168;
  fiat_p224_addcarryx_u64(&x167, &x168, 0x0, x141, x157);
  uint64_t x169;
  fiat_p224_uint1 x170;
  fiat_p224_addcarryx_u64(&x169, &x170, x168, x143, x159);
  uint64_t x171;
  fiat_p224_uint1 x172;
  fiat_p224_addcarryx_u64(&x171, &x172, x170, x145, x161);
  uint64_t x173;
  fiat_p224_uint1 x174;
  fiat_p224_addcarryx_u64(&x173, &x174, x172, x147, x163);
  uint64_t x175;
  fiat_p224_uint1 x176;
  fiat_p224_addcarryx_u64(&x175, &x176, x174, x149, x165);
  uint64_t x177;
  uint64_t x178;
  fiat_p224_mulx_u64(&x177, &x178, x167, UINT64_C(0xffffffffffffffff));
  uint64_t x179;
  uint64_t x180;
  fiat_p224_mulx_u64(&x179, &x180, x177, UINT32_C(0xffffffff));
  uint64_t x181;
  uint64_t x182;
  fiat_p224_mulx_u64(&x181, &x182, x177, UINT64_C(0xffffffffffffffff));
  uint64_t x183;
  uint64_t x184;
  fiat_p224_mulx_u64(&x183, &x184, x177, UINT64_C(0xffffffff00000000));
  uint64_t x185;
  fiat_p224_uint1 x186;
  fiat_p224_addcarryx_u64(&x185, &x186, 0x0, x184, x181);
  uint64_t x187;
  fiat_p224_uint1 x188;
  fiat_p224_addcarryx_u64(&x187, &x188, x186, x182, x179);
  uint64_t x189;
  fiat_p224_uint1 x190;
  fiat_p224_addcarryx_u64(&x189, &x190, x188, x180, 0x0);
  uint64_t x191;
  fiat_p224_uint1 x192;
  fiat_p224_addcarryx_u64(&x191, &x192, 0x0, x167, x177);
  uint64_t x193;
  fiat_p224_uint1 x194;
  fiat_p224_addcarryx_u64(&x193, &x194, x192, x169, x183);
  uint64_t x195;
  fiat_p224_uint1 x196;
  fiat_p224_addcarryx_u64(&x195, &x196, x194, x171, x185);
  uint64_t x197;
  fiat_p224_uint1 x198;
  fiat_p224_addcarryx_u64(&x197, &x198, x196, x173, x187);
  uint64_t x199;
  fiat_p224_uint1 x200;
  fiat_p224_addcarryx_u64(&x199, &x200, x198, x175, x189);
  uint64_t x201;
  fiat_p224_uint1 x202;
  fiat_p224_addcarryx_u64(&x201, &x202, x200, x176, 0x0);
  uint64_t x203;
  fiat_p224_uint1 x204;
  fiat_p224_subborrowx_u64(&x203, &x204, 0x0, x193, 0x1);
  uint64_t x205;
  fiat_p224_uint1 x206;
  fiat_p224_subborrowx_u64(&x205, &x206, x204, x195, UINT64_C(0xffffffff00000000));
  uint64_t x207;
  fiat_p224_uint1 x208;
  fiat_p224_subborrowx_u64(&x207, &x208, x206, x197, UINT64_C(0xffffffffffffffff));
  uint64_t x209;
  fiat_p224_uint1 x210;
  fiat_p224_subborrowx_u64(&x209, &x210, x208, x199, UINT32_C(0xffffffff));
  uint64_t x211;
  fiat_p224_uint1 x212;
  fiat_p224_subborrowx_u64(&x211, &x212, x210, x201, 0x0);
  uint64_t x213;
  fiat_p224_cmovznz_u64(&x213, x212, x203, x193);
  uint64_t x214;
  fiat_p224_cmovznz_u64(&x214, x212, x205, x195);
  uint64_t x215;
  fiat_p224_cmovznz_u64(&x215, x212, x207, x197);
  uint64_t x216;
  fiat_p224_cmovznz_u64(&x216, x212, x209, x199);
  out1[0] = x213;
  out1[1] = x214;
  out1[2] = x215;
  out1[3] = x216;
}

/*
 * The function fiat_p224_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_add(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  uint64_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_addcarryx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint64_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_addcarryx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint64_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_addcarryx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint64_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_addcarryx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint64_t x9;
  fiat_p224_uint1 x10;
  fiat_p224_subborrowx_u64(&x9, &x10, 0x0, x1, 0x1);
  uint64_t x11;
  fiat_p224_uint1 x12;
  fiat_p224_subborrowx_u64(&x11, &x12, x10, x3, UINT64_C(0xffffffff00000000));
  uint64_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_subborrowx_u64(&x13, &x14, x12, x5, UINT64_C(0xffffffffffffffff));
  uint64_t x15;
  fiat_p224_uint1 x16;
  fiat_p224_subborrowx_u64(&x15, &x16, x14, x7, UINT32_C(0xffffffff));
  uint64_t x17;
  fiat_p224_uint1 x18;
  fiat_p224_subborrowx_u64(&x17, &x18, x16, x8, 0x0);
  uint64_t x19;
  fiat_p224_cmovznz_u64(&x19, x18, x9, x1);
  uint64_t x20;
  fiat_p224_cmovznz_u64(&x20, x18, x11, x3);
  uint64_t x21;
  fiat_p224_cmovznz_u64(&x21, x18, x13, x5);
  uint64_t x22;
  fiat_p224_cmovznz_u64(&x22, x18, x15, x7);
  out1[0] = x19;
  out1[1] = x20;
  out1[2] = x21;
  out1[3] = x22;
}

/*
 * The function fiat_p224_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_sub(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  uint64_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_subborrowx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint64_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_subborrowx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint64_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_subborrowx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint64_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_subborrowx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint64_t x9;
  fiat_p224_cmovznz_u64(&x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
  uint64_t x10;
  fiat_p224_uint1 x11;
  fiat_p224_addcarryx_u64(&x10, &x11, 0x0, x1, (fiat_p224_uint1)(x9 & 0x1));
  uint64_t x12;
  fiat_p224_uint1 x13;
  fiat_p224_addcarryx_u64(&x12, &x13, x11, x3, (x9 & UINT64_C(0xffffffff00000000)));
  uint64_t x14;
  fiat_p224_uint1 x15;
  fiat_p224_addcarryx_u64(&x14, &x15, x13, x5, (x9 & UINT64_C(0xffffffffffffffff)));
  uint64_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u64(&x16, &x17, x15, x7, (x9 & UINT32_C(0xffffffff)));
  out1[0] = x10;
  out1[1] = x12;
  out1[2] = x14;
  out1[3] = x16;
}

/*
 * The function fiat_p224_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_opp(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_subborrowx_u64(&x1, &x2, 0x0, 0x0, (arg1[0]));
  uint64_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_subborrowx_u64(&x3, &x4, x2, 0x0, (arg1[1]));
  uint64_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_subborrowx_u64(&x5, &x6, x4, 0x0, (arg1[2]));
  uint64_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_subborrowx_u64(&x7, &x8, x6, 0x0, (arg1[3]));
  uint64_t x9;
  fiat_p224_cmovznz_u64(&x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
  uint64_t x10;
  fiat_p224_uint1 x11;
  fiat_p224_addcarryx_u64(&x10, &x11, 0x0, x1, (fiat_p224_uint1)(x9 & 0x1));
  uint64_t x12;
  fiat_p224_uint1 x13;
  fiat_p224_addcarryx_u64(&x12, &x13, x11, x3, (x9 & UINT64_C(0xffffffff00000000)));
  uint64_t x14;
  fiat_p224_uint1 x15;
  fiat_p224_addcarryx_u64(&x14, &x15, x13, x5, (x9 & UINT64_C(0xffffffffffffffff)));
  uint64_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u64(&x16, &x17, x15, x7, (x9 & UINT32_C(0xffffffff)));
  out1[0] = x10;
  out1[1] = x12;
  out1[2] = x14;
  out1[3] = x16;
}

/*
 * The function fiat_p224_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_from_montgomery(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1 = (arg1[0]);
  uint64_t x2;
  uint64_t x3;
  fiat_p224_mulx_u64(&x2, &x3, x1, UINT64_C(0xffffffffffffffff));
  uint64_t x4;
  uint64_t x5;
  fiat_p224_mulx_u64(&x4, &x5, x2, UINT32_C(0xffffffff));
  uint64_t x6;
  uint64_t x7;
  fiat_p224_mulx_u64(&x6, &x7, x2, UINT64_C(0xffffffffffffffff));
  uint64_t x8;
  uint64_t x9;
  fiat_p224_mulx_u64(&x8, &x9, x2, UINT64_C(0xffffffff00000000));
  uint64_t x10;
  fiat_p224_uint1 x11;
  fiat_p224_addcarryx_u64(&x10, &x11, 0x0, x9, x6);
  uint64_t x12;
  fiat_p224_uint1 x13;
  fiat_p224_addcarryx_u64(&x12, &x13, x11, x7, x4);
  uint64_t x14;
  fiat_p224_uint1 x15;
  fiat_p224_addcarryx_u64(&x14, &x15, 0x0, x1, x2);
  uint64_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u64(&x16, &x17, x15, 0x0, x8);
  uint64_t x18;
  fiat_p224_uint1 x19;
  fiat_p224_addcarryx_u64(&x18, &x19, x17, 0x0, x10);
  uint64_t x20;
  fiat_p224_uint1 x21;
  fiat_p224_addcarryx_u64(&x20, &x21, x19, 0x0, x12);
  uint64_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u64(&x22, &x23, 0x0, x16, (arg1[1]));
  uint64_t x24;
  fiat_p224_uint1 x25;
  fiat_p224_addcarryx_u64(&x24, &x25, x23, x18, 0x0);
  uint64_t x26;
  fiat_p224_uint1 x27;
  fiat_p224_addcarryx_u64(&x26, &x27, x25, x20, 0x0);
  uint64_t x28;
  uint64_t x29;
  fiat_p224_mulx_u64(&x28, &x29, x22, UINT64_C(0xffffffffffffffff));
  uint64_t x30;
  uint64_t x31;
  fiat_p224_mulx_u64(&x30, &x31, x28, UINT32_C(0xffffffff));
  uint64_t x32;
  uint64_t x33;
  fiat_p224_mulx_u64(&x32, &x33, x28, UINT64_C(0xffffffffffffffff));
  uint64_t x34;
  uint64_t x35;
  fiat_p224_mulx_u64(&x34, &x35, x28, UINT64_C(0xffffffff00000000));
  uint64_t x36;
  fiat_p224_uint1 x37;
  fiat_p224_addcarryx_u64(&x36, &x37, 0x0, x35, x32);
  uint64_t x38;
  fiat_p224_uint1 x39;
  fiat_p224_addcarryx_u64(&x38, &x39, x37, x33, x30);
  uint64_t x40;
  fiat_p224_uint1 x41;
  fiat_p224_addcarryx_u64(&x40, &x41, 0x0, x22, x28);
  uint64_t x42;
  fiat_p224_uint1 x43;
  fiat_p224_addcarryx_u64(&x42, &x43, x41, x24, x34);
  uint64_t x44;
  fiat_p224_uint1 x45;
  fiat_p224_addcarryx_u64(&x44, &x45, x43, x26, x36);
  uint64_t x46;
  fiat_p224_uint1 x47;
  fiat_p224_addcarryx_u64(&x46, &x47, x13, x5, 0x0);
  uint64_t x48;
  fiat_p224_uint1 x49;
  fiat_p224_addcarryx_u64(&x48, &x49, x21, 0x0, x46);
  uint64_t x50;
  fiat_p224_uint1 x51;
  fiat_p224_addcarryx_u64(&x50, &x51, x27, x48, 0x0);
  uint64_t x52;
  fiat_p224_uint1 x53;
  fiat_p224_addcarryx_u64(&x52, &x53, x45, x50, x38);
  uint64_t x54;
  fiat_p224_uint1 x55;
  fiat_p224_addcarryx_u64(&x54, &x55, 0x0, x42, (arg1[2]));
  uint64_t x56;
  fiat_p224_uint1 x57;
  fiat_p224_addcarryx_u64(&x56, &x57, x55, x44, 0x0);
  uint64_t x58;
  fiat_p224_uint1 x59;
  fiat_p224_addcarryx_u64(&x58, &x59, x57, x52, 0x0);
  uint64_t x60;
  uint64_t x61;
  fiat_p224_mulx_u64(&x60, &x61, x54, UINT64_C(0xffffffffffffffff));
  uint64_t x62;
  uint64_t x63;
  fiat_p224_mulx_u64(&x62, &x63, x60, UINT32_C(0xffffffff));
  uint64_t x64;
  uint64_t x65;
  fiat_p224_mulx_u64(&x64, &x65, x60, UINT64_C(0xffffffffffffffff));
  uint64_t x66;
  uint64_t x67;
  fiat_p224_mulx_u64(&x66, &x67, x60, UINT64_C(0xffffffff00000000));
  uint64_t x68;
  fiat_p224_uint1 x69;
  fiat_p224_addcarryx_u64(&x68, &x69, 0x0, x67, x64);
  uint64_t x70;
  fiat_p224_uint1 x71;
  fiat_p224_addcarryx_u64(&x70, &x71, x69, x65, x62);
  uint64_t x72;
  fiat_p224_uint1 x73;
  fiat_p224_addcarryx_u64(&x72, &x73, 0x0, x54, x60);
  uint64_t x74;
  fiat_p224_uint1 x75;
  fiat_p224_addcarryx_u64(&x74, &x75, x73, x56, x66);
  uint64_t x76;
  fiat_p224_uint1 x77;
  fiat_p224_addcarryx_u64(&x76, &x77, x75, x58, x68);
  uint64_t x78;
  fiat_p224_uint1 x79;
  fiat_p224_addcarryx_u64(&x78, &x79, x39, x31, 0x0);
  uint64_t x80;
  fiat_p224_uint1 x81;
  fiat_p224_addcarryx_u64(&x80, &x81, x53, 0x0, x78);
  uint64_t x82;
  fiat_p224_uint1 x83;
  fiat_p224_addcarryx_u64(&x82, &x83, x59, x80, 0x0);
  uint64_t x84;
  fiat_p224_uint1 x85;
  fiat_p224_addcarryx_u64(&x84, &x85, x77, x82, x70);
  uint64_t x86;
  fiat_p224_uint1 x87;
  fiat_p224_addcarryx_u64(&x86, &x87, 0x0, x74, (arg1[3]));
  uint64_t x88;
  fiat_p224_uint1 x89;
  fiat_p224_addcarryx_u64(&x88, &x89, x87, x76, 0x0);
  uint64_t x90;
  fiat_p224_uint1 x91;
  fiat_p224_addcarryx_u64(&x90, &x91, x89, x84, 0x0);
  uint64_t x92;
  uint64_t x93;
  fiat_p224_mulx_u64(&x92, &x93, x86, UINT64_C(0xffffffffffffffff));
  uint64_t x94;
  uint64_t x95;
  fiat_p224_mulx_u64(&x94, &x95, x92, UINT32_C(0xffffffff));
  uint64_t x96;
  uint64_t x97;
  fiat_p224_mulx_u64(&x96, &x97, x92, UINT64_C(0xffffffffffffffff));
  uint64_t x98;
  uint64_t x99;
  fiat_p224_mulx_u64(&x98, &x99, x92, UINT64_C(0xffffffff00000000));
  uint64_t x100;
  fiat_p224_uint1 x101;
  fiat_p224_addcarryx_u64(&x100, &x101, 0x0, x99, x96);
  uint64_t x102;
  fiat_p224_uint1 x103;
  fiat_p224_addcarryx_u64(&x102, &x103, x101, x97, x94);
  uint64_t x104;
  fiat_p224_uint1 x105;
  fiat_p224_addcarryx_u64(&x104, &x105, 0x0, x86, x92);
  uint64_t x106;
  fiat_p224_uint1 x107;
  fiat_p224_addcarryx_u64(&x106, &x107, x105, x88, x98);
  uint64_t x108;
  fiat_p224_uint1 x109;
  fiat_p224_addcarryx_u64(&x108, &x109, x107, x90, x100);
  uint64_t x110;
  fiat_p224_uint1 x111;
  fiat_p224_addcarryx_u64(&x110, &x111, x71, x63, 0x0);
  uint64_t x112;
  fiat_p224_uint1 x113;
  fiat_p224_addcarryx_u64(&x112, &x113, x85, 0x0, x110);
  uint64_t x114;
  fiat_p224_uint1 x115;
  fiat_p224_addcarryx_u64(&x114, &x115, x91, x112, 0x0);
  uint64_t x116;
  fiat_p224_uint1 x117;
  fiat_p224_addcarryx_u64(&x116, &x117, x109, x114, x102);
  uint64_t x118;
  fiat_p224_uint1 x119;
  fiat_p224_addcarryx_u64(&x118, &x119, x103, x95, 0x0);
  uint64_t x120;
  fiat_p224_uint1 x121;
  fiat_p224_addcarryx_u64(&x120, &x121, x117, 0x0, x118);
  uint64_t x122;
  fiat_p224_uint1 x123;
  fiat_p224_subborrowx_u64(&x122, &x123, 0x0, x106, 0x1);
  uint64_t x124;
  fiat_p224_uint1 x125;
  fiat_p224_subborrowx_u64(&x124, &x125, x123, x108, UINT64_C(0xffffffff00000000));
  uint64_t x126;
  fiat_p224_uint1 x127;
  fiat_p224_subborrowx_u64(&x126, &x127, x125, x116, UINT64_C(0xffffffffffffffff));
  uint64_t x128;
  fiat_p224_uint1 x129;
  fiat_p224_subborrowx_u64(&x128, &x129, x127, x120, UINT32_C(0xffffffff));
  uint64_t x130;
  fiat_p224_uint1 x131;
  fiat_p224_subborrowx_u64(&x130, &x131, x129, 0x0, 0x0);
  uint64_t x132;
  fiat_p224_cmovznz_u64(&x132, x131, x122, x106);
  uint64_t x133;
  fiat_p224_cmovznz_u64(&x133, x131, x124, x108);
  uint64_t x134;
  fiat_p224_cmovznz_u64(&x134, x131, x126, x116);
  uint64_t x135;
  fiat_p224_cmovznz_u64(&x135, x131, x128, x120);
  out1[0] = x132;
  out1[1] = x133;
  out1[2] = x134;
  out1[3] = x135;
}

/*
 * The function fiat_p224_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p224_nonzero(uint64_t* out1, const uint64_t arg1[4]) {
  uint64_t x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | (uint64_t)0x0))));
  *out1 = x1;
}

/*
 * The function fiat_p224_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p224_selectznz(uint64_t out1[4], fiat_p224_uint1 arg1, const uint64_t arg2[4], const uint64_t arg3[4]) {
  uint64_t x1;
  fiat_p224_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  uint64_t x2;
  fiat_p224_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  uint64_t x3;
  fiat_p224_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  uint64_t x4;
  fiat_p224_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/*
 * The function fiat_p224_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x0], [0x0 ~> 0x0], [0x0 ~> 0x0], [0x0 ~> 0x0]]
 */
static void fiat_p224_to_bytes(uint8_t out1[32], const uint64_t arg1[4]) {
  uint64_t x1 = (arg1[3]);
  uint64_t x2 = (arg1[2]);
  uint64_t x3 = (arg1[1]);
  uint64_t x4 = (arg1[0]);
  uint64_t x5 = (x4 >> 8);
  uint8_t x6 = (uint8_t)(x4 & UINT8_C(0xff));
  uint64_t x7 = (x5 >> 8);
  uint8_t x8 = (uint8_t)(x5 & UINT8_C(0xff));
  uint64_t x9 = (x7 >> 8);
  uint8_t x10 = (uint8_t)(x7 & UINT8_C(0xff));
  uint64_t x11 = (x9 >> 8);
  uint8_t x12 = (uint8_t)(x9 & UINT8_C(0xff));
  uint64_t x13 = (x11 >> 8);
  uint8_t x14 = (uint8_t)(x11 & UINT8_C(0xff));
  uint64_t x15 = (x13 >> 8);
  uint8_t x16 = (uint8_t)(x13 & UINT8_C(0xff));
  uint8_t x17 = (uint8_t)(x15 >> 8);
  uint8_t x18 = (uint8_t)(x15 & UINT8_C(0xff));
  uint8_t x19 = (uint8_t)(x17 & UINT8_C(0xff));
  uint64_t x20 = (x3 >> 8);
  uint8_t x21 = (uint8_t)(x3 & UINT8_C(0xff));
  uint64_t x22 = (x20 >> 8);
  uint8_t x23 = (uint8_t)(x20 & UINT8_C(0xff));
  uint64_t x24 = (x22 >> 8);
  uint8_t x25 = (uint8_t)(x22 & UINT8_C(0xff));
  uint64_t x26 = (x24 >> 8);
  uint8_t x27 = (uint8_t)(x24 & UINT8_C(0xff));
  uint64_t x28 = (x26 >> 8);
  uint8_t x29 = (uint8_t)(x26 & UINT8_C(0xff));
  uint64_t x30 = (x28 >> 8);
  uint8_t x31 = (uint8_t)(x28 & UINT8_C(0xff));
  uint8_t x32 = (uint8_t)(x30 >> 8);
  uint8_t x33 = (uint8_t)(x30 & UINT8_C(0xff));
  uint8_t x34 = (uint8_t)(x32 & UINT8_C(0xff));
  uint64_t x35 = (x2 >> 8);
  uint8_t x36 = (uint8_t)(x2 & UINT8_C(0xff));
  uint64_t x37 = (x35 >> 8);
  uint8_t x38 = (uint8_t)(x35 & UINT8_C(0xff));
  uint64_t x39 = (x37 >> 8);
  uint8_t x40 = (uint8_t)(x37 & UINT8_C(0xff));
  uint64_t x41 = (x39 >> 8);
  uint8_t x42 = (uint8_t)(x39 & UINT8_C(0xff));
  uint64_t x43 = (x41 >> 8);
  uint8_t x44 = (uint8_t)(x41 & UINT8_C(0xff));
  uint64_t x45 = (x43 >> 8);
  uint8_t x46 = (uint8_t)(x43 & UINT8_C(0xff));
  uint8_t x47 = (uint8_t)(x45 >> 8);
  uint8_t x48 = (uint8_t)(x45 & UINT8_C(0xff));
  uint8_t x49 = (uint8_t)(x47 & UINT8_C(0xff));
  uint64_t x50 = (x1 >> 8);
  uint8_t x51 = (uint8_t)(x1 & UINT8_C(0xff));
  uint64_t x52 = (x50 >> 8);
  uint8_t x53 = (uint8_t)(x50 & UINT8_C(0xff));
  uint8_t x54 = (uint8_t)(x52 >> 8);
  uint8_t x55 = (uint8_t)(x52 & UINT8_C(0xff));
  uint8_t x56 = (uint8_t)(x54 & UINT8_C(0xff));
  out1[0] = x6;
  out1[1] = x8;
  out1[2] = x10;
  out1[3] = x12;
  out1[4] = x14;
  out1[5] = x16;
  out1[6] = x18;
  out1[7] = x19;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x27;
  out1[12] = x29;
  out1[13] = x31;
  out1[14] = x33;
  out1[15] = x34;
  out1[16] = x36;
  out1[17] = x38;
  out1[18] = x40;
  out1[19] = x42;
  out1[20] = x44;
  out1[21] = x46;
  out1[22] = x48;
  out1[23] = x49;
  out1[24] = x51;
  out1[25] = x53;
  out1[26] = x55;
  out1[27] = x56;
  out1[28] = 0x0;
  out1[29] = 0x0;
  out1[30] = 0x0;
  out1[31] = 0x0;
}

/*
 * The function fiat_p224_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x0], [0x0 ~> 0x0], [0x0 ~> 0x0], [0x0 ~> 0x0]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_from_bytes(uint64_t out1[4], const uint8_t arg1[32]) {
  uint64_t x1 = ((uint64_t)(arg1[27]) << 24);
  uint64_t x2 = ((uint64_t)(arg1[26]) << 16);
  uint64_t x3 = ((uint64_t)(arg1[25]) << 8);
  uint8_t x4 = (arg1[24]);
  uint64_t x5 = ((uint64_t)(arg1[23]) << 56);
  uint64_t x6 = ((uint64_t)(arg1[22]) << 48);
  uint64_t x7 = ((uint64_t)(arg1[21]) << 40);
  uint64_t x8 = ((uint64_t)(arg1[20]) << 32);
  uint64_t x9 = ((uint64_t)(arg1[19]) << 24);
  uint64_t x10 = ((uint64_t)(arg1[18]) << 16);
  uint64_t x11 = ((uint64_t)(arg1[17]) << 8);
  uint8_t x12 = (arg1[16]);
  uint64_t x13 = ((uint64_t)(arg1[15]) << 56);
  uint64_t x14 = ((uint64_t)(arg1[14]) << 48);
  uint64_t x15 = ((uint64_t)(arg1[13]) << 40);
  uint64_t x16 = ((uint64_t)(arg1[12]) << 32);
  uint64_t x17 = ((uint64_t)(arg1[11]) << 24);
  uint64_t x18 = ((uint64_t)(arg1[10]) << 16);
  uint64_t x19 = ((uint64_t)(arg1[9]) << 8);
  uint8_t x20 = (arg1[8]);
  uint64_t x21 = ((uint64_t)(arg1[7]) << 56);
  uint64_t x22 = ((uint64_t)(arg1[6]) << 48);
  uint64_t x23 = ((uint64_t)(arg1[5]) << 40);
  uint64_t x24 = ((uint64_t)(arg1[4]) << 32);
  uint64_t x25 = ((uint64_t)(arg1[3]) << 24);
  uint64_t x26 = ((uint64_t)(arg1[2]) << 16);
  uint64_t x27 = ((uint64_t)(arg1[1]) << 8);
  uint8_t x28 = (arg1[0]);
  uint64_t x29 = (x28 + (x27 + (x26 + (x25 + (x24 + (x23 + (x22 + x21)))))));
  uint64_t x30 = (x29 & UINT64_C(0xffffffffffffffff));
  uint64_t x31 = (x4 + (x3 + (x2 + x1)));
  uint64_t x32 = (x12 + (x11 + (x10 + (x9 + (x8 + (x7 + (x6 + x5)))))));
  uint64_t x33 = (x20 + (x19 + (x18 + (x17 + (x16 + (x15 + (x14 + x13)))))));
  uint64_t x34 = (x33 & UINT64_C(0xffffffffffffffff));
  uint64_t x35 = (x32 & UINT64_C(0xffffffffffffffff));
  out1[0] = x30;
  out1[1] = x34;
  out1[2] = x35;
  out1[3] = x31;
}
