/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery --static p224 '2^224 - 2^96 + 1' 32 */
/* curve description: p224 */
/* requested operations: (all) */
/* m = 0xffffffffffffffffffffffffffffffff000000000000000000000001 (from "2^224 - 2^96 + 1") */
/* machine_wordsize = 32 (from "32") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */

#include <stdint.h>
typedef unsigned char fiat_p224_uint1;
typedef signed char fiat_p224_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p224_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p224_addcarryx_u32(uint32_t* out1, fiat_p224_uint1* out2, fiat_p224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1 = ((arg1 + (uint64_t)arg2) + arg3);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  fiat_p224_uint1 x3 = (fiat_p224_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p224_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p224_subborrowx_u32(uint32_t* out1, fiat_p224_uint1* out2, fiat_p224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1 = ((arg2 - (int64_t)arg1) - arg3);
  fiat_p224_int1 x2 = (fiat_p224_int1)(x1 >> 32);
  uint32_t x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_p224_uint1)(0x0 - x2);
}

/*
 * The function fiat_p224_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_p224_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1 = ((uint64_t)arg1 * arg2);
  uint32_t x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  uint32_t x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p224_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p224_cmovznz_u32(uint32_t* out1, fiat_p224_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_p224_uint1 x1 = (!(!arg1));
  uint32_t x2 = ((fiat_p224_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  uint32_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p224_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_mul(uint32_t out1[7], const uint32_t arg1[7], const uint32_t arg2[7]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[0]);
  uint32_t x8;
  uint32_t x9;
  fiat_p224_mulx_u32(&x8, &x9, x7, (arg2[6]));
  uint32_t x10;
  uint32_t x11;
  fiat_p224_mulx_u32(&x10, &x11, x7, (arg2[5]));
  uint32_t x12;
  uint32_t x13;
  fiat_p224_mulx_u32(&x12, &x13, x7, (arg2[4]));
  uint32_t x14;
  uint32_t x15;
  fiat_p224_mulx_u32(&x14, &x15, x7, (arg2[3]));
  uint32_t x16;
  uint32_t x17;
  fiat_p224_mulx_u32(&x16, &x17, x7, (arg2[2]));
  uint32_t x18;
  uint32_t x19;
  fiat_p224_mulx_u32(&x18, &x19, x7, (arg2[1]));
  uint32_t x20;
  uint32_t x21;
  fiat_p224_mulx_u32(&x20, &x21, x7, (arg2[0]));
  uint32_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u32(&x22, &x23, 0x0, x21, x18);
  uint32_t x24;
  fiat_p224_uint1 x25;
  fiat_p224_addcarryx_u32(&x24, &x25, x23, x19, x16);
  uint32_t x26;
  fiat_p224_uint1 x27;
  fiat_p224_addcarryx_u32(&x26, &x27, x25, x17, x14);
  uint32_t x28;
  fiat_p224_uint1 x29;
  fiat_p224_addcarryx_u32(&x28, &x29, x27, x15, x12);
  uint32_t x30;
  fiat_p224_uint1 x31;
  fiat_p224_addcarryx_u32(&x30, &x31, x29, x13, x10);
  uint32_t x32;
  fiat_p224_uint1 x33;
  fiat_p224_addcarryx_u32(&x32, &x33, x31, x11, x8);
  uint32_t x34;
  fiat_p224_uint1 x35;
  fiat_p224_addcarryx_u32(&x34, &x35, x33, x9, 0x0);
  uint32_t x36;
  uint32_t x37;
  fiat_p224_mulx_u32(&x36, &x37, x20, UINT32_C(0xffffffff));
  uint32_t x38;
  uint32_t x39;
  fiat_p224_mulx_u32(&x38, &x39, x36, UINT32_C(0xffffffff));
  uint32_t x40;
  uint32_t x41;
  fiat_p224_mulx_u32(&x40, &x41, x36, UINT32_C(0xffffffff));
  uint32_t x42;
  uint32_t x43;
  fiat_p224_mulx_u32(&x42, &x43, x36, UINT32_C(0xffffffff));
  uint32_t x44;
  uint32_t x45;
  fiat_p224_mulx_u32(&x44, &x45, x36, UINT32_C(0xffffffff));
  uint32_t x46;
  fiat_p224_uint1 x47;
  fiat_p224_addcarryx_u32(&x46, &x47, 0x0, x45, x42);
  uint32_t x48;
  fiat_p224_uint1 x49;
  fiat_p224_addcarryx_u32(&x48, &x49, x47, x43, x40);
  uint32_t x50;
  fiat_p224_uint1 x51;
  fiat_p224_addcarryx_u32(&x50, &x51, x49, x41, x38);
  uint32_t x52;
  fiat_p224_uint1 x53;
  fiat_p224_addcarryx_u32(&x52, &x53, x51, x39, 0x0);
  uint32_t x54;
  fiat_p224_uint1 x55;
  fiat_p224_addcarryx_u32(&x54, &x55, 0x0, x20, x36);
  uint32_t x56;
  fiat_p224_uint1 x57;
  fiat_p224_addcarryx_u32(&x56, &x57, x55, x22, 0x0);
  uint32_t x58;
  fiat_p224_uint1 x59;
  fiat_p224_addcarryx_u32(&x58, &x59, x57, x24, 0x0);
  uint32_t x60;
  fiat_p224_uint1 x61;
  fiat_p224_addcarryx_u32(&x60, &x61, x59, x26, x44);
  uint32_t x62;
  fiat_p224_uint1 x63;
  fiat_p224_addcarryx_u32(&x62, &x63, x61, x28, x46);
  uint32_t x64;
  fiat_p224_uint1 x65;
  fiat_p224_addcarryx_u32(&x64, &x65, x63, x30, x48);
  uint32_t x66;
  fiat_p224_uint1 x67;
  fiat_p224_addcarryx_u32(&x66, &x67, x65, x32, x50);
  uint32_t x68;
  fiat_p224_uint1 x69;
  fiat_p224_addcarryx_u32(&x68, &x69, x67, x34, x52);
  uint32_t x70;
  fiat_p224_uint1 x71;
  fiat_p224_addcarryx_u32(&x70, &x71, x69, 0x0, 0x0);
  uint32_t x72;
  uint32_t x73;
  fiat_p224_mulx_u32(&x72, &x73, x1, (arg2[6]));
  uint32_t x74;
  uint32_t x75;
  fiat_p224_mulx_u32(&x74, &x75, x1, (arg2[5]));
  uint32_t x76;
  uint32_t x77;
  fiat_p224_mulx_u32(&x76, &x77, x1, (arg2[4]));
  uint32_t x78;
  uint32_t x79;
  fiat_p224_mulx_u32(&x78, &x79, x1, (arg2[3]));
  uint32_t x80;
  uint32_t x81;
  fiat_p224_mulx_u32(&x80, &x81, x1, (arg2[2]));
  uint32_t x82;
  uint32_t x83;
  fiat_p224_mulx_u32(&x82, &x83, x1, (arg2[1]));
  uint32_t x84;
  uint32_t x85;
  fiat_p224_mulx_u32(&x84, &x85, x1, (arg2[0]));
  uint32_t x86;
  fiat_p224_uint1 x87;
  fiat_p224_addcarryx_u32(&x86, &x87, 0x0, x85, x82);
  uint32_t x88;
  fiat_p224_uint1 x89;
  fiat_p224_addcarryx_u32(&x88, &x89, x87, x83, x80);
  uint32_t x90;
  fiat_p224_uint1 x91;
  fiat_p224_addcarryx_u32(&x90, &x91, x89, x81, x78);
  uint32_t x92;
  fiat_p224_uint1 x93;
  fiat_p224_addcarryx_u32(&x92, &x93, x91, x79, x76);
  uint32_t x94;
  fiat_p224_uint1 x95;
  fiat_p224_addcarryx_u32(&x94, &x95, x93, x77, x74);
  uint32_t x96;
  fiat_p224_uint1 x97;
  fiat_p224_addcarryx_u32(&x96, &x97, x95, x75, x72);
  uint32_t x98;
  fiat_p224_uint1 x99;
  fiat_p224_addcarryx_u32(&x98, &x99, x97, x73, 0x0);
  uint32_t x100;
  fiat_p224_uint1 x101;
  fiat_p224_addcarryx_u32(&x100, &x101, 0x0, x56, x84);
  uint32_t x102;
  fiat_p224_uint1 x103;
  fiat_p224_addcarryx_u32(&x102, &x103, x101, x58, x86);
  uint32_t x104;
  fiat_p224_uint1 x105;
  fiat_p224_addcarryx_u32(&x104, &x105, x103, x60, x88);
  uint32_t x106;
  fiat_p224_uint1 x107;
  fiat_p224_addcarryx_u32(&x106, &x107, x105, x62, x90);
  uint32_t x108;
  fiat_p224_uint1 x109;
  fiat_p224_addcarryx_u32(&x108, &x109, x107, x64, x92);
  uint32_t x110;
  fiat_p224_uint1 x111;
  fiat_p224_addcarryx_u32(&x110, &x111, x109, x66, x94);
  uint32_t x112;
  fiat_p224_uint1 x113;
  fiat_p224_addcarryx_u32(&x112, &x113, x111, x68, x96);
  uint32_t x114;
  fiat_p224_uint1 x115;
  fiat_p224_addcarryx_u32(&x114, &x115, x113, (fiat_p224_uint1)x70, x98);
  uint32_t x116;
  uint32_t x117;
  fiat_p224_mulx_u32(&x116, &x117, x100, UINT32_C(0xffffffff));
  uint32_t x118;
  uint32_t x119;
  fiat_p224_mulx_u32(&x118, &x119, x116, UINT32_C(0xffffffff));
  uint32_t x120;
  uint32_t x121;
  fiat_p224_mulx_u32(&x120, &x121, x116, UINT32_C(0xffffffff));
  uint32_t x122;
  uint32_t x123;
  fiat_p224_mulx_u32(&x122, &x123, x116, UINT32_C(0xffffffff));
  uint32_t x124;
  uint32_t x125;
  fiat_p224_mulx_u32(&x124, &x125, x116, UINT32_C(0xffffffff));
  uint32_t x126;
  fiat_p224_uint1 x127;
  fiat_p224_addcarryx_u32(&x126, &x127, 0x0, x125, x122);
  uint32_t x128;
  fiat_p224_uint1 x129;
  fiat_p224_addcarryx_u32(&x128, &x129, x127, x123, x120);
  uint32_t x130;
  fiat_p224_uint1 x131;
  fiat_p224_addcarryx_u32(&x130, &x131, x129, x121, x118);
  uint32_t x132;
  fiat_p224_uint1 x133;
  fiat_p224_addcarryx_u32(&x132, &x133, x131, x119, 0x0);
  uint32_t x134;
  fiat_p224_uint1 x135;
  fiat_p224_addcarryx_u32(&x134, &x135, 0x0, x100, x116);
  uint32_t x136;
  fiat_p224_uint1 x137;
  fiat_p224_addcarryx_u32(&x136, &x137, x135, x102, 0x0);
  uint32_t x138;
  fiat_p224_uint1 x139;
  fiat_p224_addcarryx_u32(&x138, &x139, x137, x104, 0x0);
  uint32_t x140;
  fiat_p224_uint1 x141;
  fiat_p224_addcarryx_u32(&x140, &x141, x139, x106, x124);
  uint32_t x142;
  fiat_p224_uint1 x143;
  fiat_p224_addcarryx_u32(&x142, &x143, x141, x108, x126);
  uint32_t x144;
  fiat_p224_uint1 x145;
  fiat_p224_addcarryx_u32(&x144, &x145, x143, x110, x128);
  uint32_t x146;
  fiat_p224_uint1 x147;
  fiat_p224_addcarryx_u32(&x146, &x147, x145, x112, x130);
  uint32_t x148;
  fiat_p224_uint1 x149;
  fiat_p224_addcarryx_u32(&x148, &x149, x147, x114, x132);
  uint32_t x150;
  fiat_p224_uint1 x151;
  fiat_p224_addcarryx_u32(&x150, &x151, x149, x115, 0x0);
  uint32_t x152;
  uint32_t x153;
  fiat_p224_mulx_u32(&x152, &x153, x2, (arg2[6]));
  uint32_t x154;
  uint32_t x155;
  fiat_p224_mulx_u32(&x154, &x155, x2, (arg2[5]));
  uint32_t x156;
  uint32_t x157;
  fiat_p224_mulx_u32(&x156, &x157, x2, (arg2[4]));
  uint32_t x158;
  uint32_t x159;
  fiat_p224_mulx_u32(&x158, &x159, x2, (arg2[3]));
  uint32_t x160;
  uint32_t x161;
  fiat_p224_mulx_u32(&x160, &x161, x2, (arg2[2]));
  uint32_t x162;
  uint32_t x163;
  fiat_p224_mulx_u32(&x162, &x163, x2, (arg2[1]));
  uint32_t x164;
  uint32_t x165;
  fiat_p224_mulx_u32(&x164, &x165, x2, (arg2[0]));
  uint32_t x166;
  fiat_p224_uint1 x167;
  fiat_p224_addcarryx_u32(&x166, &x167, 0x0, x165, x162);
  uint32_t x168;
  fiat_p224_uint1 x169;
  fiat_p224_addcarryx_u32(&x168, &x169, x167, x163, x160);
  uint32_t x170;
  fiat_p224_uint1 x171;
  fiat_p224_addcarryx_u32(&x170, &x171, x169, x161, x158);
  uint32_t x172;
  fiat_p224_uint1 x173;
  fiat_p224_addcarryx_u32(&x172, &x173, x171, x159, x156);
  uint32_t x174;
  fiat_p224_uint1 x175;
  fiat_p224_addcarryx_u32(&x174, &x175, x173, x157, x154);
  uint32_t x176;
  fiat_p224_uint1 x177;
  fiat_p224_addcarryx_u32(&x176, &x177, x175, x155, x152);
  uint32_t x178;
  fiat_p224_uint1 x179;
  fiat_p224_addcarryx_u32(&x178, &x179, x177, x153, 0x0);
  uint32_t x180;
  fiat_p224_uint1 x181;
  fiat_p224_addcarryx_u32(&x180, &x181, 0x0, x136, x164);
  uint32_t x182;
  fiat_p224_uint1 x183;
  fiat_p224_addcarryx_u32(&x182, &x183, x181, x138, x166);
  uint32_t x184;
  fiat_p224_uint1 x185;
  fiat_p224_addcarryx_u32(&x184, &x185, x183, x140, x168);
  uint32_t x186;
  fiat_p224_uint1 x187;
  fiat_p224_addcarryx_u32(&x186, &x187, x185, x142, x170);
  uint32_t x188;
  fiat_p224_uint1 x189;
  fiat_p224_addcarryx_u32(&x188, &x189, x187, x144, x172);
  uint32_t x190;
  fiat_p224_uint1 x191;
  fiat_p224_addcarryx_u32(&x190, &x191, x189, x146, x174);
  uint32_t x192;
  fiat_p224_uint1 x193;
  fiat_p224_addcarryx_u32(&x192, &x193, x191, x148, x176);
  uint32_t x194;
  fiat_p224_uint1 x195;
  fiat_p224_addcarryx_u32(&x194, &x195, x193, x150, x178);
  uint32_t x196;
  uint32_t x197;
  fiat_p224_mulx_u32(&x196, &x197, x180, UINT32_C(0xffffffff));
  uint32_t x198;
  uint32_t x199;
  fiat_p224_mulx_u32(&x198, &x199, x196, UINT32_C(0xffffffff));
  uint32_t x200;
  uint32_t x201;
  fiat_p224_mulx_u32(&x200, &x201, x196, UINT32_C(0xffffffff));
  uint32_t x202;
  uint32_t x203;
  fiat_p224_mulx_u32(&x202, &x203, x196, UINT32_C(0xffffffff));
  uint32_t x204;
  uint32_t x205;
  fiat_p224_mulx_u32(&x204, &x205, x196, UINT32_C(0xffffffff));
  uint32_t x206;
  fiat_p224_uint1 x207;
  fiat_p224_addcarryx_u32(&x206, &x207, 0x0, x205, x202);
  uint32_t x208;
  fiat_p224_uint1 x209;
  fiat_p224_addcarryx_u32(&x208, &x209, x207, x203, x200);
  uint32_t x210;
  fiat_p224_uint1 x211;
  fiat_p224_addcarryx_u32(&x210, &x211, x209, x201, x198);
  uint32_t x212;
  fiat_p224_uint1 x213;
  fiat_p224_addcarryx_u32(&x212, &x213, x211, x199, 0x0);
  uint32_t x214;
  fiat_p224_uint1 x215;
  fiat_p224_addcarryx_u32(&x214, &x215, 0x0, x180, x196);
  uint32_t x216;
  fiat_p224_uint1 x217;
  fiat_p224_addcarryx_u32(&x216, &x217, x215, x182, 0x0);
  uint32_t x218;
  fiat_p224_uint1 x219;
  fiat_p224_addcarryx_u32(&x218, &x219, x217, x184, 0x0);
  uint32_t x220;
  fiat_p224_uint1 x221;
  fiat_p224_addcarryx_u32(&x220, &x221, x219, x186, x204);
  uint32_t x222;
  fiat_p224_uint1 x223;
  fiat_p224_addcarryx_u32(&x222, &x223, x221, x188, x206);
  uint32_t x224;
  fiat_p224_uint1 x225;
  fiat_p224_addcarryx_u32(&x224, &x225, x223, x190, x208);
  uint32_t x226;
  fiat_p224_uint1 x227;
  fiat_p224_addcarryx_u32(&x226, &x227, x225, x192, x210);
  uint32_t x228;
  fiat_p224_uint1 x229;
  fiat_p224_addcarryx_u32(&x228, &x229, x227, x194, x212);
  uint32_t x230;
  fiat_p224_uint1 x231;
  fiat_p224_addcarryx_u32(&x230, &x231, x229, x195, 0x0);
  uint32_t x232;
  uint32_t x233;
  fiat_p224_mulx_u32(&x232, &x233, x3, (arg2[6]));
  uint32_t x234;
  uint32_t x235;
  fiat_p224_mulx_u32(&x234, &x235, x3, (arg2[5]));
  uint32_t x236;
  uint32_t x237;
  fiat_p224_mulx_u32(&x236, &x237, x3, (arg2[4]));
  uint32_t x238;
  uint32_t x239;
  fiat_p224_mulx_u32(&x238, &x239, x3, (arg2[3]));
  uint32_t x240;
  uint32_t x241;
  fiat_p224_mulx_u32(&x240, &x241, x3, (arg2[2]));
  uint32_t x242;
  uint32_t x243;
  fiat_p224_mulx_u32(&x242, &x243, x3, (arg2[1]));
  uint32_t x244;
  uint32_t x245;
  fiat_p224_mulx_u32(&x244, &x245, x3, (arg2[0]));
  uint32_t x246;
  fiat_p224_uint1 x247;
  fiat_p224_addcarryx_u32(&x246, &x247, 0x0, x245, x242);
  uint32_t x248;
  fiat_p224_uint1 x249;
  fiat_p224_addcarryx_u32(&x248, &x249, x247, x243, x240);
  uint32_t x250;
  fiat_p224_uint1 x251;
  fiat_p224_addcarryx_u32(&x250, &x251, x249, x241, x238);
  uint32_t x252;
  fiat_p224_uint1 x253;
  fiat_p224_addcarryx_u32(&x252, &x253, x251, x239, x236);
  uint32_t x254;
  fiat_p224_uint1 x255;
  fiat_p224_addcarryx_u32(&x254, &x255, x253, x237, x234);
  uint32_t x256;
  fiat_p224_uint1 x257;
  fiat_p224_addcarryx_u32(&x256, &x257, x255, x235, x232);
  uint32_t x258;
  fiat_p224_uint1 x259;
  fiat_p224_addcarryx_u32(&x258, &x259, x257, x233, 0x0);
  uint32_t x260;
  fiat_p224_uint1 x261;
  fiat_p224_addcarryx_u32(&x260, &x261, 0x0, x216, x244);
  uint32_t x262;
  fiat_p224_uint1 x263;
  fiat_p224_addcarryx_u32(&x262, &x263, x261, x218, x246);
  uint32_t x264;
  fiat_p224_uint1 x265;
  fiat_p224_addcarryx_u32(&x264, &x265, x263, x220, x248);
  uint32_t x266;
  fiat_p224_uint1 x267;
  fiat_p224_addcarryx_u32(&x266, &x267, x265, x222, x250);
  uint32_t x268;
  fiat_p224_uint1 x269;
  fiat_p224_addcarryx_u32(&x268, &x269, x267, x224, x252);
  uint32_t x270;
  fiat_p224_uint1 x271;
  fiat_p224_addcarryx_u32(&x270, &x271, x269, x226, x254);
  uint32_t x272;
  fiat_p224_uint1 x273;
  fiat_p224_addcarryx_u32(&x272, &x273, x271, x228, x256);
  uint32_t x274;
  fiat_p224_uint1 x275;
  fiat_p224_addcarryx_u32(&x274, &x275, x273, x230, x258);
  uint32_t x276;
  uint32_t x277;
  fiat_p224_mulx_u32(&x276, &x277, x260, UINT32_C(0xffffffff));
  uint32_t x278;
  uint32_t x279;
  fiat_p224_mulx_u32(&x278, &x279, x276, UINT32_C(0xffffffff));
  uint32_t x280;
  uint32_t x281;
  fiat_p224_mulx_u32(&x280, &x281, x276, UINT32_C(0xffffffff));
  uint32_t x282;
  uint32_t x283;
  fiat_p224_mulx_u32(&x282, &x283, x276, UINT32_C(0xffffffff));
  uint32_t x284;
  uint32_t x285;
  fiat_p224_mulx_u32(&x284, &x285, x276, UINT32_C(0xffffffff));
  uint32_t x286;
  fiat_p224_uint1 x287;
  fiat_p224_addcarryx_u32(&x286, &x287, 0x0, x285, x282);
  uint32_t x288;
  fiat_p224_uint1 x289;
  fiat_p224_addcarryx_u32(&x288, &x289, x287, x283, x280);
  uint32_t x290;
  fiat_p224_uint1 x291;
  fiat_p224_addcarryx_u32(&x290, &x291, x289, x281, x278);
  uint32_t x292;
  fiat_p224_uint1 x293;
  fiat_p224_addcarryx_u32(&x292, &x293, x291, x279, 0x0);
  uint32_t x294;
  fiat_p224_uint1 x295;
  fiat_p224_addcarryx_u32(&x294, &x295, 0x0, x260, x276);
  uint32_t x296;
  fiat_p224_uint1 x297;
  fiat_p224_addcarryx_u32(&x296, &x297, x295, x262, 0x0);
  uint32_t x298;
  fiat_p224_uint1 x299;
  fiat_p224_addcarryx_u32(&x298, &x299, x297, x264, 0x0);
  uint32_t x300;
  fiat_p224_uint1 x301;
  fiat_p224_addcarryx_u32(&x300, &x301, x299, x266, x284);
  uint32_t x302;
  fiat_p224_uint1 x303;
  fiat_p224_addcarryx_u32(&x302, &x303, x301, x268, x286);
  uint32_t x304;
  fiat_p224_uint1 x305;
  fiat_p224_addcarryx_u32(&x304, &x305, x303, x270, x288);
  uint32_t x306;
  fiat_p224_uint1 x307;
  fiat_p224_addcarryx_u32(&x306, &x307, x305, x272, x290);
  uint32_t x308;
  fiat_p224_uint1 x309;
  fiat_p224_addcarryx_u32(&x308, &x309, x307, x274, x292);
  uint32_t x310;
  fiat_p224_uint1 x311;
  fiat_p224_addcarryx_u32(&x310, &x311, x309, x275, 0x0);
  uint32_t x312;
  uint32_t x313;
  fiat_p224_mulx_u32(&x312, &x313, x4, (arg2[6]));
  uint32_t x314;
  uint32_t x315;
  fiat_p224_mulx_u32(&x314, &x315, x4, (arg2[5]));
  uint32_t x316;
  uint32_t x317;
  fiat_p224_mulx_u32(&x316, &x317, x4, (arg2[4]));
  uint32_t x318;
  uint32_t x319;
  fiat_p224_mulx_u32(&x318, &x319, x4, (arg2[3]));
  uint32_t x320;
  uint32_t x321;
  fiat_p224_mulx_u32(&x320, &x321, x4, (arg2[2]));
  uint32_t x322;
  uint32_t x323;
  fiat_p224_mulx_u32(&x322, &x323, x4, (arg2[1]));
  uint32_t x324;
  uint32_t x325;
  fiat_p224_mulx_u32(&x324, &x325, x4, (arg2[0]));
  uint32_t x326;
  fiat_p224_uint1 x327;
  fiat_p224_addcarryx_u32(&x326, &x327, 0x0, x325, x322);
  uint32_t x328;
  fiat_p224_uint1 x329;
  fiat_p224_addcarryx_u32(&x328, &x329, x327, x323, x320);
  uint32_t x330;
  fiat_p224_uint1 x331;
  fiat_p224_addcarryx_u32(&x330, &x331, x329, x321, x318);
  uint32_t x332;
  fiat_p224_uint1 x333;
  fiat_p224_addcarryx_u32(&x332, &x333, x331, x319, x316);
  uint32_t x334;
  fiat_p224_uint1 x335;
  fiat_p224_addcarryx_u32(&x334, &x335, x333, x317, x314);
  uint32_t x336;
  fiat_p224_uint1 x337;
  fiat_p224_addcarryx_u32(&x336, &x337, x335, x315, x312);
  uint32_t x338;
  fiat_p224_uint1 x339;
  fiat_p224_addcarryx_u32(&x338, &x339, x337, x313, 0x0);
  uint32_t x340;
  fiat_p224_uint1 x341;
  fiat_p224_addcarryx_u32(&x340, &x341, 0x0, x296, x324);
  uint32_t x342;
  fiat_p224_uint1 x343;
  fiat_p224_addcarryx_u32(&x342, &x343, x341, x298, x326);
  uint32_t x344;
  fiat_p224_uint1 x345;
  fiat_p224_addcarryx_u32(&x344, &x345, x343, x300, x328);
  uint32_t x346;
  fiat_p224_uint1 x347;
  fiat_p224_addcarryx_u32(&x346, &x347, x345, x302, x330);
  uint32_t x348;
  fiat_p224_uint1 x349;
  fiat_p224_addcarryx_u32(&x348, &x349, x347, x304, x332);
  uint32_t x350;
  fiat_p224_uint1 x351;
  fiat_p224_addcarryx_u32(&x350, &x351, x349, x306, x334);
  uint32_t x352;
  fiat_p224_uint1 x353;
  fiat_p224_addcarryx_u32(&x352, &x353, x351, x308, x336);
  uint32_t x354;
  fiat_p224_uint1 x355;
  fiat_p224_addcarryx_u32(&x354, &x355, x353, x310, x338);
  uint32_t x356;
  uint32_t x357;
  fiat_p224_mulx_u32(&x356, &x357, x340, UINT32_C(0xffffffff));
  uint32_t x358;
  uint32_t x359;
  fiat_p224_mulx_u32(&x358, &x359, x356, UINT32_C(0xffffffff));
  uint32_t x360;
  uint32_t x361;
  fiat_p224_mulx_u32(&x360, &x361, x356, UINT32_C(0xffffffff));
  uint32_t x362;
  uint32_t x363;
  fiat_p224_mulx_u32(&x362, &x363, x356, UINT32_C(0xffffffff));
  uint32_t x364;
  uint32_t x365;
  fiat_p224_mulx_u32(&x364, &x365, x356, UINT32_C(0xffffffff));
  uint32_t x366;
  fiat_p224_uint1 x367;
  fiat_p224_addcarryx_u32(&x366, &x367, 0x0, x365, x362);
  uint32_t x368;
  fiat_p224_uint1 x369;
  fiat_p224_addcarryx_u32(&x368, &x369, x367, x363, x360);
  uint32_t x370;
  fiat_p224_uint1 x371;
  fiat_p224_addcarryx_u32(&x370, &x371, x369, x361, x358);
  uint32_t x372;
  fiat_p224_uint1 x373;
  fiat_p224_addcarryx_u32(&x372, &x373, x371, x359, 0x0);
  uint32_t x374;
  fiat_p224_uint1 x375;
  fiat_p224_addcarryx_u32(&x374, &x375, 0x0, x340, x356);
  uint32_t x376;
  fiat_p224_uint1 x377;
  fiat_p224_addcarryx_u32(&x376, &x377, x375, x342, 0x0);
  uint32_t x378;
  fiat_p224_uint1 x379;
  fiat_p224_addcarryx_u32(&x378, &x379, x377, x344, 0x0);
  uint32_t x380;
  fiat_p224_uint1 x381;
  fiat_p224_addcarryx_u32(&x380, &x381, x379, x346, x364);
  uint32_t x382;
  fiat_p224_uint1 x383;
  fiat_p224_addcarryx_u32(&x382, &x383, x381, x348, x366);
  uint32_t x384;
  fiat_p224_uint1 x385;
  fiat_p224_addcarryx_u32(&x384, &x385, x383, x350, x368);
  uint32_t x386;
  fiat_p224_uint1 x387;
  fiat_p224_addcarryx_u32(&x386, &x387, x385, x352, x370);
  uint32_t x388;
  fiat_p224_uint1 x389;
  fiat_p224_addcarryx_u32(&x388, &x389, x387, x354, x372);
  uint32_t x390;
  fiat_p224_uint1 x391;
  fiat_p224_addcarryx_u32(&x390, &x391, x389, x355, 0x0);
  uint32_t x392;
  uint32_t x393;
  fiat_p224_mulx_u32(&x392, &x393, x5, (arg2[6]));
  uint32_t x394;
  uint32_t x395;
  fiat_p224_mulx_u32(&x394, &x395, x5, (arg2[5]));
  uint32_t x396;
  uint32_t x397;
  fiat_p224_mulx_u32(&x396, &x397, x5, (arg2[4]));
  uint32_t x398;
  uint32_t x399;
  fiat_p224_mulx_u32(&x398, &x399, x5, (arg2[3]));
  uint32_t x400;
  uint32_t x401;
  fiat_p224_mulx_u32(&x400, &x401, x5, (arg2[2]));
  uint32_t x402;
  uint32_t x403;
  fiat_p224_mulx_u32(&x402, &x403, x5, (arg2[1]));
  uint32_t x404;
  uint32_t x405;
  fiat_p224_mulx_u32(&x404, &x405, x5, (arg2[0]));
  uint32_t x406;
  fiat_p224_uint1 x407;
  fiat_p224_addcarryx_u32(&x406, &x407, 0x0, x405, x402);
  uint32_t x408;
  fiat_p224_uint1 x409;
  fiat_p224_addcarryx_u32(&x408, &x409, x407, x403, x400);
  uint32_t x410;
  fiat_p224_uint1 x411;
  fiat_p224_addcarryx_u32(&x410, &x411, x409, x401, x398);
  uint32_t x412;
  fiat_p224_uint1 x413;
  fiat_p224_addcarryx_u32(&x412, &x413, x411, x399, x396);
  uint32_t x414;
  fiat_p224_uint1 x415;
  fiat_p224_addcarryx_u32(&x414, &x415, x413, x397, x394);
  uint32_t x416;
  fiat_p224_uint1 x417;
  fiat_p224_addcarryx_u32(&x416, &x417, x415, x395, x392);
  uint32_t x418;
  fiat_p224_uint1 x419;
  fiat_p224_addcarryx_u32(&x418, &x419, x417, x393, 0x0);
  uint32_t x420;
  fiat_p224_uint1 x421;
  fiat_p224_addcarryx_u32(&x420, &x421, 0x0, x376, x404);
  uint32_t x422;
  fiat_p224_uint1 x423;
  fiat_p224_addcarryx_u32(&x422, &x423, x421, x378, x406);
  uint32_t x424;
  fiat_p224_uint1 x425;
  fiat_p224_addcarryx_u32(&x424, &x425, x423, x380, x408);
  uint32_t x426;
  fiat_p224_uint1 x427;
  fiat_p224_addcarryx_u32(&x426, &x427, x425, x382, x410);
  uint32_t x428;
  fiat_p224_uint1 x429;
  fiat_p224_addcarryx_u32(&x428, &x429, x427, x384, x412);
  uint32_t x430;
  fiat_p224_uint1 x431;
  fiat_p224_addcarryx_u32(&x430, &x431, x429, x386, x414);
  uint32_t x432;
  fiat_p224_uint1 x433;
  fiat_p224_addcarryx_u32(&x432, &x433, x431, x388, x416);
  uint32_t x434;
  fiat_p224_uint1 x435;
  fiat_p224_addcarryx_u32(&x434, &x435, x433, x390, x418);
  uint32_t x436;
  uint32_t x437;
  fiat_p224_mulx_u32(&x436, &x437, x420, UINT32_C(0xffffffff));
  uint32_t x438;
  uint32_t x439;
  fiat_p224_mulx_u32(&x438, &x439, x436, UINT32_C(0xffffffff));
  uint32_t x440;
  uint32_t x441;
  fiat_p224_mulx_u32(&x440, &x441, x436, UINT32_C(0xffffffff));
  uint32_t x442;
  uint32_t x443;
  fiat_p224_mulx_u32(&x442, &x443, x436, UINT32_C(0xffffffff));
  uint32_t x444;
  uint32_t x445;
  fiat_p224_mulx_u32(&x444, &x445, x436, UINT32_C(0xffffffff));
  uint32_t x446;
  fiat_p224_uint1 x447;
  fiat_p224_addcarryx_u32(&x446, &x447, 0x0, x445, x442);
  uint32_t x448;
  fiat_p224_uint1 x449;
  fiat_p224_addcarryx_u32(&x448, &x449, x447, x443, x440);
  uint32_t x450;
  fiat_p224_uint1 x451;
  fiat_p224_addcarryx_u32(&x450, &x451, x449, x441, x438);
  uint32_t x452;
  fiat_p224_uint1 x453;
  fiat_p224_addcarryx_u32(&x452, &x453, x451, x439, 0x0);
  uint32_t x454;
  fiat_p224_uint1 x455;
  fiat_p224_addcarryx_u32(&x454, &x455, 0x0, x420, x436);
  uint32_t x456;
  fiat_p224_uint1 x457;
  fiat_p224_addcarryx_u32(&x456, &x457, x455, x422, 0x0);
  uint32_t x458;
  fiat_p224_uint1 x459;
  fiat_p224_addcarryx_u32(&x458, &x459, x457, x424, 0x0);
  uint32_t x460;
  fiat_p224_uint1 x461;
  fiat_p224_addcarryx_u32(&x460, &x461, x459, x426, x444);
  uint32_t x462;
  fiat_p224_uint1 x463;
  fiat_p224_addcarryx_u32(&x462, &x463, x461, x428, x446);
  uint32_t x464;
  fiat_p224_uint1 x465;
  fiat_p224_addcarryx_u32(&x464, &x465, x463, x430, x448);
  uint32_t x466;
  fiat_p224_uint1 x467;
  fiat_p224_addcarryx_u32(&x466, &x467, x465, x432, x450);
  uint32_t x468;
  fiat_p224_uint1 x469;
  fiat_p224_addcarryx_u32(&x468, &x469, x467, x434, x452);
  uint32_t x470;
  fiat_p224_uint1 x471;
  fiat_p224_addcarryx_u32(&x470, &x471, x469, x435, 0x0);
  uint32_t x472;
  uint32_t x473;
  fiat_p224_mulx_u32(&x472, &x473, x6, (arg2[6]));
  uint32_t x474;
  uint32_t x475;
  fiat_p224_mulx_u32(&x474, &x475, x6, (arg2[5]));
  uint32_t x476;
  uint32_t x477;
  fiat_p224_mulx_u32(&x476, &x477, x6, (arg2[4]));
  uint32_t x478;
  uint32_t x479;
  fiat_p224_mulx_u32(&x478, &x479, x6, (arg2[3]));
  uint32_t x480;
  uint32_t x481;
  fiat_p224_mulx_u32(&x480, &x481, x6, (arg2[2]));
  uint32_t x482;
  uint32_t x483;
  fiat_p224_mulx_u32(&x482, &x483, x6, (arg2[1]));
  uint32_t x484;
  uint32_t x485;
  fiat_p224_mulx_u32(&x484, &x485, x6, (arg2[0]));
  uint32_t x486;
  fiat_p224_uint1 x487;
  fiat_p224_addcarryx_u32(&x486, &x487, 0x0, x485, x482);
  uint32_t x488;
  fiat_p224_uint1 x489;
  fiat_p224_addcarryx_u32(&x488, &x489, x487, x483, x480);
  uint32_t x490;
  fiat_p224_uint1 x491;
  fiat_p224_addcarryx_u32(&x490, &x491, x489, x481, x478);
  uint32_t x492;
  fiat_p224_uint1 x493;
  fiat_p224_addcarryx_u32(&x492, &x493, x491, x479, x476);
  uint32_t x494;
  fiat_p224_uint1 x495;
  fiat_p224_addcarryx_u32(&x494, &x495, x493, x477, x474);
  uint32_t x496;
  fiat_p224_uint1 x497;
  fiat_p224_addcarryx_u32(&x496, &x497, x495, x475, x472);
  uint32_t x498;
  fiat_p224_uint1 x499;
  fiat_p224_addcarryx_u32(&x498, &x499, x497, x473, 0x0);
  uint32_t x500;
  fiat_p224_uint1 x501;
  fiat_p224_addcarryx_u32(&x500, &x501, 0x0, x456, x484);
  uint32_t x502;
  fiat_p224_uint1 x503;
  fiat_p224_addcarryx_u32(&x502, &x503, x501, x458, x486);
  uint32_t x504;
  fiat_p224_uint1 x505;
  fiat_p224_addcarryx_u32(&x504, &x505, x503, x460, x488);
  uint32_t x506;
  fiat_p224_uint1 x507;
  fiat_p224_addcarryx_u32(&x506, &x507, x505, x462, x490);
  uint32_t x508;
  fiat_p224_uint1 x509;
  fiat_p224_addcarryx_u32(&x508, &x509, x507, x464, x492);
  uint32_t x510;
  fiat_p224_uint1 x511;
  fiat_p224_addcarryx_u32(&x510, &x511, x509, x466, x494);
  uint32_t x512;
  fiat_p224_uint1 x513;
  fiat_p224_addcarryx_u32(&x512, &x513, x511, x468, x496);
  uint32_t x514;
  fiat_p224_uint1 x515;
  fiat_p224_addcarryx_u32(&x514, &x515, x513, x470, x498);
  uint32_t x516;
  uint32_t x517;
  fiat_p224_mulx_u32(&x516, &x517, x500, UINT32_C(0xffffffff));
  uint32_t x518;
  uint32_t x519;
  fiat_p224_mulx_u32(&x518, &x519, x516, UINT32_C(0xffffffff));
  uint32_t x520;
  uint32_t x521;
  fiat_p224_mulx_u32(&x520, &x521, x516, UINT32_C(0xffffffff));
  uint32_t x522;
  uint32_t x523;
  fiat_p224_mulx_u32(&x522, &x523, x516, UINT32_C(0xffffffff));
  uint32_t x524;
  uint32_t x525;
  fiat_p224_mulx_u32(&x524, &x525, x516, UINT32_C(0xffffffff));
  uint32_t x526;
  fiat_p224_uint1 x527;
  fiat_p224_addcarryx_u32(&x526, &x527, 0x0, x525, x522);
  uint32_t x528;
  fiat_p224_uint1 x529;
  fiat_p224_addcarryx_u32(&x528, &x529, x527, x523, x520);
  uint32_t x530;
  fiat_p224_uint1 x531;
  fiat_p224_addcarryx_u32(&x530, &x531, x529, x521, x518);
  uint32_t x532;
  fiat_p224_uint1 x533;
  fiat_p224_addcarryx_u32(&x532, &x533, x531, x519, 0x0);
  uint32_t x534;
  fiat_p224_uint1 x535;
  fiat_p224_addcarryx_u32(&x534, &x535, 0x0, x500, x516);
  uint32_t x536;
  fiat_p224_uint1 x537;
  fiat_p224_addcarryx_u32(&x536, &x537, x535, x502, 0x0);
  uint32_t x538;
  fiat_p224_uint1 x539;
  fiat_p224_addcarryx_u32(&x538, &x539, x537, x504, 0x0);
  uint32_t x540;
  fiat_p224_uint1 x541;
  fiat_p224_addcarryx_u32(&x540, &x541, x539, x506, x524);
  uint32_t x542;
  fiat_p224_uint1 x543;
  fiat_p224_addcarryx_u32(&x542, &x543, x541, x508, x526);
  uint32_t x544;
  fiat_p224_uint1 x545;
  fiat_p224_addcarryx_u32(&x544, &x545, x543, x510, x528);
  uint32_t x546;
  fiat_p224_uint1 x547;
  fiat_p224_addcarryx_u32(&x546, &x547, x545, x512, x530);
  uint32_t x548;
  fiat_p224_uint1 x549;
  fiat_p224_addcarryx_u32(&x548, &x549, x547, x514, x532);
  uint32_t x550;
  fiat_p224_uint1 x551;
  fiat_p224_addcarryx_u32(&x550, &x551, x549, x515, 0x0);
  uint32_t x552;
  fiat_p224_uint1 x553;
  fiat_p224_subborrowx_u32(&x552, &x553, 0x0, x536, 0x1);
  uint32_t x554;
  fiat_p224_uint1 x555;
  fiat_p224_subborrowx_u32(&x554, &x555, x553, x538, 0x0);
  uint32_t x556;
  fiat_p224_uint1 x557;
  fiat_p224_subborrowx_u32(&x556, &x557, x555, x540, 0x0);
  uint32_t x558;
  fiat_p224_uint1 x559;
  fiat_p224_subborrowx_u32(&x558, &x559, x557, x542, UINT32_C(0xffffffff));
  uint32_t x560;
  fiat_p224_uint1 x561;
  fiat_p224_subborrowx_u32(&x560, &x561, x559, x544, UINT32_C(0xffffffff));
  uint32_t x562;
  fiat_p224_uint1 x563;
  fiat_p224_subborrowx_u32(&x562, &x563, x561, x546, UINT32_C(0xffffffff));
  uint32_t x564;
  fiat_p224_uint1 x565;
  fiat_p224_subborrowx_u32(&x564, &x565, x563, x548, UINT32_C(0xffffffff));
  uint32_t x566;
  fiat_p224_uint1 x567;
  fiat_p224_subborrowx_u32(&x566, &x567, x565, x550, 0x0);
  uint32_t x568;
  fiat_p224_cmovznz_u32(&x568, x567, x552, x536);
  uint32_t x569;
  fiat_p224_cmovznz_u32(&x569, x567, x554, x538);
  uint32_t x570;
  fiat_p224_cmovznz_u32(&x570, x567, x556, x540);
  uint32_t x571;
  fiat_p224_cmovznz_u32(&x571, x567, x558, x542);
  uint32_t x572;
  fiat_p224_cmovznz_u32(&x572, x567, x560, x544);
  uint32_t x573;
  fiat_p224_cmovznz_u32(&x573, x567, x562, x546);
  uint32_t x574;
  fiat_p224_cmovznz_u32(&x574, x567, x564, x548);
  out1[0] = x568;
  out1[1] = x569;
  out1[2] = x570;
  out1[3] = x571;
  out1[4] = x572;
  out1[5] = x573;
  out1[6] = x574;
}

/*
 * The function fiat_p224_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_square(uint32_t out1[7], const uint32_t arg1[7]) {
  uint32_t x1 = (arg1[1]);
  uint32_t x2 = (arg1[2]);
  uint32_t x3 = (arg1[3]);
  uint32_t x4 = (arg1[4]);
  uint32_t x5 = (arg1[5]);
  uint32_t x6 = (arg1[6]);
  uint32_t x7 = (arg1[0]);
  uint32_t x8;
  uint32_t x9;
  fiat_p224_mulx_u32(&x8, &x9, x7, (arg1[6]));
  uint32_t x10;
  uint32_t x11;
  fiat_p224_mulx_u32(&x10, &x11, x7, (arg1[5]));
  uint32_t x12;
  uint32_t x13;
  fiat_p224_mulx_u32(&x12, &x13, x7, (arg1[4]));
  uint32_t x14;
  uint32_t x15;
  fiat_p224_mulx_u32(&x14, &x15, x7, (arg1[3]));
  uint32_t x16;
  uint32_t x17;
  fiat_p224_mulx_u32(&x16, &x17, x7, (arg1[2]));
  uint32_t x18;
  uint32_t x19;
  fiat_p224_mulx_u32(&x18, &x19, x7, (arg1[1]));
  uint32_t x20;
  uint32_t x21;
  fiat_p224_mulx_u32(&x20, &x21, x7, (arg1[0]));
  uint32_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u32(&x22, &x23, 0x0, x21, x18);
  uint32_t x24;
  fiat_p224_uint1 x25;
  fiat_p224_addcarryx_u32(&x24, &x25, x23, x19, x16);
  uint32_t x26;
  fiat_p224_uint1 x27;
  fiat_p224_addcarryx_u32(&x26, &x27, x25, x17, x14);
  uint32_t x28;
  fiat_p224_uint1 x29;
  fiat_p224_addcarryx_u32(&x28, &x29, x27, x15, x12);
  uint32_t x30;
  fiat_p224_uint1 x31;
  fiat_p224_addcarryx_u32(&x30, &x31, x29, x13, x10);
  uint32_t x32;
  fiat_p224_uint1 x33;
  fiat_p224_addcarryx_u32(&x32, &x33, x31, x11, x8);
  uint32_t x34;
  fiat_p224_uint1 x35;
  fiat_p224_addcarryx_u32(&x34, &x35, x33, x9, 0x0);
  uint32_t x36;
  uint32_t x37;
  fiat_p224_mulx_u32(&x36, &x37, x20, UINT32_C(0xffffffff));
  uint32_t x38;
  uint32_t x39;
  fiat_p224_mulx_u32(&x38, &x39, x36, UINT32_C(0xffffffff));
  uint32_t x40;
  uint32_t x41;
  fiat_p224_mulx_u32(&x40, &x41, x36, UINT32_C(0xffffffff));
  uint32_t x42;
  uint32_t x43;
  fiat_p224_mulx_u32(&x42, &x43, x36, UINT32_C(0xffffffff));
  uint32_t x44;
  uint32_t x45;
  fiat_p224_mulx_u32(&x44, &x45, x36, UINT32_C(0xffffffff));
  uint32_t x46;
  fiat_p224_uint1 x47;
  fiat_p224_addcarryx_u32(&x46, &x47, 0x0, x45, x42);
  uint32_t x48;
  fiat_p224_uint1 x49;
  fiat_p224_addcarryx_u32(&x48, &x49, x47, x43, x40);
  uint32_t x50;
  fiat_p224_uint1 x51;
  fiat_p224_addcarryx_u32(&x50, &x51, x49, x41, x38);
  uint32_t x52;
  fiat_p224_uint1 x53;
  fiat_p224_addcarryx_u32(&x52, &x53, x51, x39, 0x0);
  uint32_t x54;
  fiat_p224_uint1 x55;
  fiat_p224_addcarryx_u32(&x54, &x55, 0x0, x20, x36);
  uint32_t x56;
  fiat_p224_uint1 x57;
  fiat_p224_addcarryx_u32(&x56, &x57, x55, x22, 0x0);
  uint32_t x58;
  fiat_p224_uint1 x59;
  fiat_p224_addcarryx_u32(&x58, &x59, x57, x24, 0x0);
  uint32_t x60;
  fiat_p224_uint1 x61;
  fiat_p224_addcarryx_u32(&x60, &x61, x59, x26, x44);
  uint32_t x62;
  fiat_p224_uint1 x63;
  fiat_p224_addcarryx_u32(&x62, &x63, x61, x28, x46);
  uint32_t x64;
  fiat_p224_uint1 x65;
  fiat_p224_addcarryx_u32(&x64, &x65, x63, x30, x48);
  uint32_t x66;
  fiat_p224_uint1 x67;
  fiat_p224_addcarryx_u32(&x66, &x67, x65, x32, x50);
  uint32_t x68;
  fiat_p224_uint1 x69;
  fiat_p224_addcarryx_u32(&x68, &x69, x67, x34, x52);
  uint32_t x70;
  fiat_p224_uint1 x71;
  fiat_p224_addcarryx_u32(&x70, &x71, x69, 0x0, 0x0);
  uint32_t x72;
  uint32_t x73;
  fiat_p224_mulx_u32(&x72, &x73, x1, (arg1[6]));
  uint32_t x74;
  uint32_t x75;
  fiat_p224_mulx_u32(&x74, &x75, x1, (arg1[5]));
  uint32_t x76;
  uint32_t x77;
  fiat_p224_mulx_u32(&x76, &x77, x1, (arg1[4]));
  uint32_t x78;
  uint32_t x79;
  fiat_p224_mulx_u32(&x78, &x79, x1, (arg1[3]));
  uint32_t x80;
  uint32_t x81;
  fiat_p224_mulx_u32(&x80, &x81, x1, (arg1[2]));
  uint32_t x82;
  uint32_t x83;
  fiat_p224_mulx_u32(&x82, &x83, x1, (arg1[1]));
  uint32_t x84;
  uint32_t x85;
  fiat_p224_mulx_u32(&x84, &x85, x1, (arg1[0]));
  uint32_t x86;
  fiat_p224_uint1 x87;
  fiat_p224_addcarryx_u32(&x86, &x87, 0x0, x85, x82);
  uint32_t x88;
  fiat_p224_uint1 x89;
  fiat_p224_addcarryx_u32(&x88, &x89, x87, x83, x80);
  uint32_t x90;
  fiat_p224_uint1 x91;
  fiat_p224_addcarryx_u32(&x90, &x91, x89, x81, x78);
  uint32_t x92;
  fiat_p224_uint1 x93;
  fiat_p224_addcarryx_u32(&x92, &x93, x91, x79, x76);
  uint32_t x94;
  fiat_p224_uint1 x95;
  fiat_p224_addcarryx_u32(&x94, &x95, x93, x77, x74);
  uint32_t x96;
  fiat_p224_uint1 x97;
  fiat_p224_addcarryx_u32(&x96, &x97, x95, x75, x72);
  uint32_t x98;
  fiat_p224_uint1 x99;
  fiat_p224_addcarryx_u32(&x98, &x99, x97, x73, 0x0);
  uint32_t x100;
  fiat_p224_uint1 x101;
  fiat_p224_addcarryx_u32(&x100, &x101, 0x0, x56, x84);
  uint32_t x102;
  fiat_p224_uint1 x103;
  fiat_p224_addcarryx_u32(&x102, &x103, x101, x58, x86);
  uint32_t x104;
  fiat_p224_uint1 x105;
  fiat_p224_addcarryx_u32(&x104, &x105, x103, x60, x88);
  uint32_t x106;
  fiat_p224_uint1 x107;
  fiat_p224_addcarryx_u32(&x106, &x107, x105, x62, x90);
  uint32_t x108;
  fiat_p224_uint1 x109;
  fiat_p224_addcarryx_u32(&x108, &x109, x107, x64, x92);
  uint32_t x110;
  fiat_p224_uint1 x111;
  fiat_p224_addcarryx_u32(&x110, &x111, x109, x66, x94);
  uint32_t x112;
  fiat_p224_uint1 x113;
  fiat_p224_addcarryx_u32(&x112, &x113, x111, x68, x96);
  uint32_t x114;
  fiat_p224_uint1 x115;
  fiat_p224_addcarryx_u32(&x114, &x115, x113, (fiat_p224_uint1)x70, x98);
  uint32_t x116;
  uint32_t x117;
  fiat_p224_mulx_u32(&x116, &x117, x100, UINT32_C(0xffffffff));
  uint32_t x118;
  uint32_t x119;
  fiat_p224_mulx_u32(&x118, &x119, x116, UINT32_C(0xffffffff));
  uint32_t x120;
  uint32_t x121;
  fiat_p224_mulx_u32(&x120, &x121, x116, UINT32_C(0xffffffff));
  uint32_t x122;
  uint32_t x123;
  fiat_p224_mulx_u32(&x122, &x123, x116, UINT32_C(0xffffffff));
  uint32_t x124;
  uint32_t x125;
  fiat_p224_mulx_u32(&x124, &x125, x116, UINT32_C(0xffffffff));
  uint32_t x126;
  fiat_p224_uint1 x127;
  fiat_p224_addcarryx_u32(&x126, &x127, 0x0, x125, x122);
  uint32_t x128;
  fiat_p224_uint1 x129;
  fiat_p224_addcarryx_u32(&x128, &x129, x127, x123, x120);
  uint32_t x130;
  fiat_p224_uint1 x131;
  fiat_p224_addcarryx_u32(&x130, &x131, x129, x121, x118);
  uint32_t x132;
  fiat_p224_uint1 x133;
  fiat_p224_addcarryx_u32(&x132, &x133, x131, x119, 0x0);
  uint32_t x134;
  fiat_p224_uint1 x135;
  fiat_p224_addcarryx_u32(&x134, &x135, 0x0, x100, x116);
  uint32_t x136;
  fiat_p224_uint1 x137;
  fiat_p224_addcarryx_u32(&x136, &x137, x135, x102, 0x0);
  uint32_t x138;
  fiat_p224_uint1 x139;
  fiat_p224_addcarryx_u32(&x138, &x139, x137, x104, 0x0);
  uint32_t x140;
  fiat_p224_uint1 x141;
  fiat_p224_addcarryx_u32(&x140, &x141, x139, x106, x124);
  uint32_t x142;
  fiat_p224_uint1 x143;
  fiat_p224_addcarryx_u32(&x142, &x143, x141, x108, x126);
  uint32_t x144;
  fiat_p224_uint1 x145;
  fiat_p224_addcarryx_u32(&x144, &x145, x143, x110, x128);
  uint32_t x146;
  fiat_p224_uint1 x147;
  fiat_p224_addcarryx_u32(&x146, &x147, x145, x112, x130);
  uint32_t x148;
  fiat_p224_uint1 x149;
  fiat_p224_addcarryx_u32(&x148, &x149, x147, x114, x132);
  uint32_t x150;
  fiat_p224_uint1 x151;
  fiat_p224_addcarryx_u32(&x150, &x151, x149, x115, 0x0);
  uint32_t x152;
  uint32_t x153;
  fiat_p224_mulx_u32(&x152, &x153, x2, (arg1[6]));
  uint32_t x154;
  uint32_t x155;
  fiat_p224_mulx_u32(&x154, &x155, x2, (arg1[5]));
  uint32_t x156;
  uint32_t x157;
  fiat_p224_mulx_u32(&x156, &x157, x2, (arg1[4]));
  uint32_t x158;
  uint32_t x159;
  fiat_p224_mulx_u32(&x158, &x159, x2, (arg1[3]));
  uint32_t x160;
  uint32_t x161;
  fiat_p224_mulx_u32(&x160, &x161, x2, (arg1[2]));
  uint32_t x162;
  uint32_t x163;
  fiat_p224_mulx_u32(&x162, &x163, x2, (arg1[1]));
  uint32_t x164;
  uint32_t x165;
  fiat_p224_mulx_u32(&x164, &x165, x2, (arg1[0]));
  uint32_t x166;
  fiat_p224_uint1 x167;
  fiat_p224_addcarryx_u32(&x166, &x167, 0x0, x165, x162);
  uint32_t x168;
  fiat_p224_uint1 x169;
  fiat_p224_addcarryx_u32(&x168, &x169, x167, x163, x160);
  uint32_t x170;
  fiat_p224_uint1 x171;
  fiat_p224_addcarryx_u32(&x170, &x171, x169, x161, x158);
  uint32_t x172;
  fiat_p224_uint1 x173;
  fiat_p224_addcarryx_u32(&x172, &x173, x171, x159, x156);
  uint32_t x174;
  fiat_p224_uint1 x175;
  fiat_p224_addcarryx_u32(&x174, &x175, x173, x157, x154);
  uint32_t x176;
  fiat_p224_uint1 x177;
  fiat_p224_addcarryx_u32(&x176, &x177, x175, x155, x152);
  uint32_t x178;
  fiat_p224_uint1 x179;
  fiat_p224_addcarryx_u32(&x178, &x179, x177, x153, 0x0);
  uint32_t x180;
  fiat_p224_uint1 x181;
  fiat_p224_addcarryx_u32(&x180, &x181, 0x0, x136, x164);
  uint32_t x182;
  fiat_p224_uint1 x183;
  fiat_p224_addcarryx_u32(&x182, &x183, x181, x138, x166);
  uint32_t x184;
  fiat_p224_uint1 x185;
  fiat_p224_addcarryx_u32(&x184, &x185, x183, x140, x168);
  uint32_t x186;
  fiat_p224_uint1 x187;
  fiat_p224_addcarryx_u32(&x186, &x187, x185, x142, x170);
  uint32_t x188;
  fiat_p224_uint1 x189;
  fiat_p224_addcarryx_u32(&x188, &x189, x187, x144, x172);
  uint32_t x190;
  fiat_p224_uint1 x191;
  fiat_p224_addcarryx_u32(&x190, &x191, x189, x146, x174);
  uint32_t x192;
  fiat_p224_uint1 x193;
  fiat_p224_addcarryx_u32(&x192, &x193, x191, x148, x176);
  uint32_t x194;
  fiat_p224_uint1 x195;
  fiat_p224_addcarryx_u32(&x194, &x195, x193, x150, x178);
  uint32_t x196;
  uint32_t x197;
  fiat_p224_mulx_u32(&x196, &x197, x180, UINT32_C(0xffffffff));
  uint32_t x198;
  uint32_t x199;
  fiat_p224_mulx_u32(&x198, &x199, x196, UINT32_C(0xffffffff));
  uint32_t x200;
  uint32_t x201;
  fiat_p224_mulx_u32(&x200, &x201, x196, UINT32_C(0xffffffff));
  uint32_t x202;
  uint32_t x203;
  fiat_p224_mulx_u32(&x202, &x203, x196, UINT32_C(0xffffffff));
  uint32_t x204;
  uint32_t x205;
  fiat_p224_mulx_u32(&x204, &x205, x196, UINT32_C(0xffffffff));
  uint32_t x206;
  fiat_p224_uint1 x207;
  fiat_p224_addcarryx_u32(&x206, &x207, 0x0, x205, x202);
  uint32_t x208;
  fiat_p224_uint1 x209;
  fiat_p224_addcarryx_u32(&x208, &x209, x207, x203, x200);
  uint32_t x210;
  fiat_p224_uint1 x211;
  fiat_p224_addcarryx_u32(&x210, &x211, x209, x201, x198);
  uint32_t x212;
  fiat_p224_uint1 x213;
  fiat_p224_addcarryx_u32(&x212, &x213, x211, x199, 0x0);
  uint32_t x214;
  fiat_p224_uint1 x215;
  fiat_p224_addcarryx_u32(&x214, &x215, 0x0, x180, x196);
  uint32_t x216;
  fiat_p224_uint1 x217;
  fiat_p224_addcarryx_u32(&x216, &x217, x215, x182, 0x0);
  uint32_t x218;
  fiat_p224_uint1 x219;
  fiat_p224_addcarryx_u32(&x218, &x219, x217, x184, 0x0);
  uint32_t x220;
  fiat_p224_uint1 x221;
  fiat_p224_addcarryx_u32(&x220, &x221, x219, x186, x204);
  uint32_t x222;
  fiat_p224_uint1 x223;
  fiat_p224_addcarryx_u32(&x222, &x223, x221, x188, x206);
  uint32_t x224;
  fiat_p224_uint1 x225;
  fiat_p224_addcarryx_u32(&x224, &x225, x223, x190, x208);
  uint32_t x226;
  fiat_p224_uint1 x227;
  fiat_p224_addcarryx_u32(&x226, &x227, x225, x192, x210);
  uint32_t x228;
  fiat_p224_uint1 x229;
  fiat_p224_addcarryx_u32(&x228, &x229, x227, x194, x212);
  uint32_t x230;
  fiat_p224_uint1 x231;
  fiat_p224_addcarryx_u32(&x230, &x231, x229, x195, 0x0);
  uint32_t x232;
  uint32_t x233;
  fiat_p224_mulx_u32(&x232, &x233, x3, (arg1[6]));
  uint32_t x234;
  uint32_t x235;
  fiat_p224_mulx_u32(&x234, &x235, x3, (arg1[5]));
  uint32_t x236;
  uint32_t x237;
  fiat_p224_mulx_u32(&x236, &x237, x3, (arg1[4]));
  uint32_t x238;
  uint32_t x239;
  fiat_p224_mulx_u32(&x238, &x239, x3, (arg1[3]));
  uint32_t x240;
  uint32_t x241;
  fiat_p224_mulx_u32(&x240, &x241, x3, (arg1[2]));
  uint32_t x242;
  uint32_t x243;
  fiat_p224_mulx_u32(&x242, &x243, x3, (arg1[1]));
  uint32_t x244;
  uint32_t x245;
  fiat_p224_mulx_u32(&x244, &x245, x3, (arg1[0]));
  uint32_t x246;
  fiat_p224_uint1 x247;
  fiat_p224_addcarryx_u32(&x246, &x247, 0x0, x245, x242);
  uint32_t x248;
  fiat_p224_uint1 x249;
  fiat_p224_addcarryx_u32(&x248, &x249, x247, x243, x240);
  uint32_t x250;
  fiat_p224_uint1 x251;
  fiat_p224_addcarryx_u32(&x250, &x251, x249, x241, x238);
  uint32_t x252;
  fiat_p224_uint1 x253;
  fiat_p224_addcarryx_u32(&x252, &x253, x251, x239, x236);
  uint32_t x254;
  fiat_p224_uint1 x255;
  fiat_p224_addcarryx_u32(&x254, &x255, x253, x237, x234);
  uint32_t x256;
  fiat_p224_uint1 x257;
  fiat_p224_addcarryx_u32(&x256, &x257, x255, x235, x232);
  uint32_t x258;
  fiat_p224_uint1 x259;
  fiat_p224_addcarryx_u32(&x258, &x259, x257, x233, 0x0);
  uint32_t x260;
  fiat_p224_uint1 x261;
  fiat_p224_addcarryx_u32(&x260, &x261, 0x0, x216, x244);
  uint32_t x262;
  fiat_p224_uint1 x263;
  fiat_p224_addcarryx_u32(&x262, &x263, x261, x218, x246);
  uint32_t x264;
  fiat_p224_uint1 x265;
  fiat_p224_addcarryx_u32(&x264, &x265, x263, x220, x248);
  uint32_t x266;
  fiat_p224_uint1 x267;
  fiat_p224_addcarryx_u32(&x266, &x267, x265, x222, x250);
  uint32_t x268;
  fiat_p224_uint1 x269;
  fiat_p224_addcarryx_u32(&x268, &x269, x267, x224, x252);
  uint32_t x270;
  fiat_p224_uint1 x271;
  fiat_p224_addcarryx_u32(&x270, &x271, x269, x226, x254);
  uint32_t x272;
  fiat_p224_uint1 x273;
  fiat_p224_addcarryx_u32(&x272, &x273, x271, x228, x256);
  uint32_t x274;
  fiat_p224_uint1 x275;
  fiat_p224_addcarryx_u32(&x274, &x275, x273, x230, x258);
  uint32_t x276;
  uint32_t x277;
  fiat_p224_mulx_u32(&x276, &x277, x260, UINT32_C(0xffffffff));
  uint32_t x278;
  uint32_t x279;
  fiat_p224_mulx_u32(&x278, &x279, x276, UINT32_C(0xffffffff));
  uint32_t x280;
  uint32_t x281;
  fiat_p224_mulx_u32(&x280, &x281, x276, UINT32_C(0xffffffff));
  uint32_t x282;
  uint32_t x283;
  fiat_p224_mulx_u32(&x282, &x283, x276, UINT32_C(0xffffffff));
  uint32_t x284;
  uint32_t x285;
  fiat_p224_mulx_u32(&x284, &x285, x276, UINT32_C(0xffffffff));
  uint32_t x286;
  fiat_p224_uint1 x287;
  fiat_p224_addcarryx_u32(&x286, &x287, 0x0, x285, x282);
  uint32_t x288;
  fiat_p224_uint1 x289;
  fiat_p224_addcarryx_u32(&x288, &x289, x287, x283, x280);
  uint32_t x290;
  fiat_p224_uint1 x291;
  fiat_p224_addcarryx_u32(&x290, &x291, x289, x281, x278);
  uint32_t x292;
  fiat_p224_uint1 x293;
  fiat_p224_addcarryx_u32(&x292, &x293, x291, x279, 0x0);
  uint32_t x294;
  fiat_p224_uint1 x295;
  fiat_p224_addcarryx_u32(&x294, &x295, 0x0, x260, x276);
  uint32_t x296;
  fiat_p224_uint1 x297;
  fiat_p224_addcarryx_u32(&x296, &x297, x295, x262, 0x0);
  uint32_t x298;
  fiat_p224_uint1 x299;
  fiat_p224_addcarryx_u32(&x298, &x299, x297, x264, 0x0);
  uint32_t x300;
  fiat_p224_uint1 x301;
  fiat_p224_addcarryx_u32(&x300, &x301, x299, x266, x284);
  uint32_t x302;
  fiat_p224_uint1 x303;
  fiat_p224_addcarryx_u32(&x302, &x303, x301, x268, x286);
  uint32_t x304;
  fiat_p224_uint1 x305;
  fiat_p224_addcarryx_u32(&x304, &x305, x303, x270, x288);
  uint32_t x306;
  fiat_p224_uint1 x307;
  fiat_p224_addcarryx_u32(&x306, &x307, x305, x272, x290);
  uint32_t x308;
  fiat_p224_uint1 x309;
  fiat_p224_addcarryx_u32(&x308, &x309, x307, x274, x292);
  uint32_t x310;
  fiat_p224_uint1 x311;
  fiat_p224_addcarryx_u32(&x310, &x311, x309, x275, 0x0);
  uint32_t x312;
  uint32_t x313;
  fiat_p224_mulx_u32(&x312, &x313, x4, (arg1[6]));
  uint32_t x314;
  uint32_t x315;
  fiat_p224_mulx_u32(&x314, &x315, x4, (arg1[5]));
  uint32_t x316;
  uint32_t x317;
  fiat_p224_mulx_u32(&x316, &x317, x4, (arg1[4]));
  uint32_t x318;
  uint32_t x319;
  fiat_p224_mulx_u32(&x318, &x319, x4, (arg1[3]));
  uint32_t x320;
  uint32_t x321;
  fiat_p224_mulx_u32(&x320, &x321, x4, (arg1[2]));
  uint32_t x322;
  uint32_t x323;
  fiat_p224_mulx_u32(&x322, &x323, x4, (arg1[1]));
  uint32_t x324;
  uint32_t x325;
  fiat_p224_mulx_u32(&x324, &x325, x4, (arg1[0]));
  uint32_t x326;
  fiat_p224_uint1 x327;
  fiat_p224_addcarryx_u32(&x326, &x327, 0x0, x325, x322);
  uint32_t x328;
  fiat_p224_uint1 x329;
  fiat_p224_addcarryx_u32(&x328, &x329, x327, x323, x320);
  uint32_t x330;
  fiat_p224_uint1 x331;
  fiat_p224_addcarryx_u32(&x330, &x331, x329, x321, x318);
  uint32_t x332;
  fiat_p224_uint1 x333;
  fiat_p224_addcarryx_u32(&x332, &x333, x331, x319, x316);
  uint32_t x334;
  fiat_p224_uint1 x335;
  fiat_p224_addcarryx_u32(&x334, &x335, x333, x317, x314);
  uint32_t x336;
  fiat_p224_uint1 x337;
  fiat_p224_addcarryx_u32(&x336, &x337, x335, x315, x312);
  uint32_t x338;
  fiat_p224_uint1 x339;
  fiat_p224_addcarryx_u32(&x338, &x339, x337, x313, 0x0);
  uint32_t x340;
  fiat_p224_uint1 x341;
  fiat_p224_addcarryx_u32(&x340, &x341, 0x0, x296, x324);
  uint32_t x342;
  fiat_p224_uint1 x343;
  fiat_p224_addcarryx_u32(&x342, &x343, x341, x298, x326);
  uint32_t x344;
  fiat_p224_uint1 x345;
  fiat_p224_addcarryx_u32(&x344, &x345, x343, x300, x328);
  uint32_t x346;
  fiat_p224_uint1 x347;
  fiat_p224_addcarryx_u32(&x346, &x347, x345, x302, x330);
  uint32_t x348;
  fiat_p224_uint1 x349;
  fiat_p224_addcarryx_u32(&x348, &x349, x347, x304, x332);
  uint32_t x350;
  fiat_p224_uint1 x351;
  fiat_p224_addcarryx_u32(&x350, &x351, x349, x306, x334);
  uint32_t x352;
  fiat_p224_uint1 x353;
  fiat_p224_addcarryx_u32(&x352, &x353, x351, x308, x336);
  uint32_t x354;
  fiat_p224_uint1 x355;
  fiat_p224_addcarryx_u32(&x354, &x355, x353, x310, x338);
  uint32_t x356;
  uint32_t x357;
  fiat_p224_mulx_u32(&x356, &x357, x340, UINT32_C(0xffffffff));
  uint32_t x358;
  uint32_t x359;
  fiat_p224_mulx_u32(&x358, &x359, x356, UINT32_C(0xffffffff));
  uint32_t x360;
  uint32_t x361;
  fiat_p224_mulx_u32(&x360, &x361, x356, UINT32_C(0xffffffff));
  uint32_t x362;
  uint32_t x363;
  fiat_p224_mulx_u32(&x362, &x363, x356, UINT32_C(0xffffffff));
  uint32_t x364;
  uint32_t x365;
  fiat_p224_mulx_u32(&x364, &x365, x356, UINT32_C(0xffffffff));
  uint32_t x366;
  fiat_p224_uint1 x367;
  fiat_p224_addcarryx_u32(&x366, &x367, 0x0, x365, x362);
  uint32_t x368;
  fiat_p224_uint1 x369;
  fiat_p224_addcarryx_u32(&x368, &x369, x367, x363, x360);
  uint32_t x370;
  fiat_p224_uint1 x371;
  fiat_p224_addcarryx_u32(&x370, &x371, x369, x361, x358);
  uint32_t x372;
  fiat_p224_uint1 x373;
  fiat_p224_addcarryx_u32(&x372, &x373, x371, x359, 0x0);
  uint32_t x374;
  fiat_p224_uint1 x375;
  fiat_p224_addcarryx_u32(&x374, &x375, 0x0, x340, x356);
  uint32_t x376;
  fiat_p224_uint1 x377;
  fiat_p224_addcarryx_u32(&x376, &x377, x375, x342, 0x0);
  uint32_t x378;
  fiat_p224_uint1 x379;
  fiat_p224_addcarryx_u32(&x378, &x379, x377, x344, 0x0);
  uint32_t x380;
  fiat_p224_uint1 x381;
  fiat_p224_addcarryx_u32(&x380, &x381, x379, x346, x364);
  uint32_t x382;
  fiat_p224_uint1 x383;
  fiat_p224_addcarryx_u32(&x382, &x383, x381, x348, x366);
  uint32_t x384;
  fiat_p224_uint1 x385;
  fiat_p224_addcarryx_u32(&x384, &x385, x383, x350, x368);
  uint32_t x386;
  fiat_p224_uint1 x387;
  fiat_p224_addcarryx_u32(&x386, &x387, x385, x352, x370);
  uint32_t x388;
  fiat_p224_uint1 x389;
  fiat_p224_addcarryx_u32(&x388, &x389, x387, x354, x372);
  uint32_t x390;
  fiat_p224_uint1 x391;
  fiat_p224_addcarryx_u32(&x390, &x391, x389, x355, 0x0);
  uint32_t x392;
  uint32_t x393;
  fiat_p224_mulx_u32(&x392, &x393, x5, (arg1[6]));
  uint32_t x394;
  uint32_t x395;
  fiat_p224_mulx_u32(&x394, &x395, x5, (arg1[5]));
  uint32_t x396;
  uint32_t x397;
  fiat_p224_mulx_u32(&x396, &x397, x5, (arg1[4]));
  uint32_t x398;
  uint32_t x399;
  fiat_p224_mulx_u32(&x398, &x399, x5, (arg1[3]));
  uint32_t x400;
  uint32_t x401;
  fiat_p224_mulx_u32(&x400, &x401, x5, (arg1[2]));
  uint32_t x402;
  uint32_t x403;
  fiat_p224_mulx_u32(&x402, &x403, x5, (arg1[1]));
  uint32_t x404;
  uint32_t x405;
  fiat_p224_mulx_u32(&x404, &x405, x5, (arg1[0]));
  uint32_t x406;
  fiat_p224_uint1 x407;
  fiat_p224_addcarryx_u32(&x406, &x407, 0x0, x405, x402);
  uint32_t x408;
  fiat_p224_uint1 x409;
  fiat_p224_addcarryx_u32(&x408, &x409, x407, x403, x400);
  uint32_t x410;
  fiat_p224_uint1 x411;
  fiat_p224_addcarryx_u32(&x410, &x411, x409, x401, x398);
  uint32_t x412;
  fiat_p224_uint1 x413;
  fiat_p224_addcarryx_u32(&x412, &x413, x411, x399, x396);
  uint32_t x414;
  fiat_p224_uint1 x415;
  fiat_p224_addcarryx_u32(&x414, &x415, x413, x397, x394);
  uint32_t x416;
  fiat_p224_uint1 x417;
  fiat_p224_addcarryx_u32(&x416, &x417, x415, x395, x392);
  uint32_t x418;
  fiat_p224_uint1 x419;
  fiat_p224_addcarryx_u32(&x418, &x419, x417, x393, 0x0);
  uint32_t x420;
  fiat_p224_uint1 x421;
  fiat_p224_addcarryx_u32(&x420, &x421, 0x0, x376, x404);
  uint32_t x422;
  fiat_p224_uint1 x423;
  fiat_p224_addcarryx_u32(&x422, &x423, x421, x378, x406);
  uint32_t x424;
  fiat_p224_uint1 x425;
  fiat_p224_addcarryx_u32(&x424, &x425, x423, x380, x408);
  uint32_t x426;
  fiat_p224_uint1 x427;
  fiat_p224_addcarryx_u32(&x426, &x427, x425, x382, x410);
  uint32_t x428;
  fiat_p224_uint1 x429;
  fiat_p224_addcarryx_u32(&x428, &x429, x427, x384, x412);
  uint32_t x430;
  fiat_p224_uint1 x431;
  fiat_p224_addcarryx_u32(&x430, &x431, x429, x386, x414);
  uint32_t x432;
  fiat_p224_uint1 x433;
  fiat_p224_addcarryx_u32(&x432, &x433, x431, x388, x416);
  uint32_t x434;
  fiat_p224_uint1 x435;
  fiat_p224_addcarryx_u32(&x434, &x435, x433, x390, x418);
  uint32_t x436;
  uint32_t x437;
  fiat_p224_mulx_u32(&x436, &x437, x420, UINT32_C(0xffffffff));
  uint32_t x438;
  uint32_t x439;
  fiat_p224_mulx_u32(&x438, &x439, x436, UINT32_C(0xffffffff));
  uint32_t x440;
  uint32_t x441;
  fiat_p224_mulx_u32(&x440, &x441, x436, UINT32_C(0xffffffff));
  uint32_t x442;
  uint32_t x443;
  fiat_p224_mulx_u32(&x442, &x443, x436, UINT32_C(0xffffffff));
  uint32_t x444;
  uint32_t x445;
  fiat_p224_mulx_u32(&x444, &x445, x436, UINT32_C(0xffffffff));
  uint32_t x446;
  fiat_p224_uint1 x447;
  fiat_p224_addcarryx_u32(&x446, &x447, 0x0, x445, x442);
  uint32_t x448;
  fiat_p224_uint1 x449;
  fiat_p224_addcarryx_u32(&x448, &x449, x447, x443, x440);
  uint32_t x450;
  fiat_p224_uint1 x451;
  fiat_p224_addcarryx_u32(&x450, &x451, x449, x441, x438);
  uint32_t x452;
  fiat_p224_uint1 x453;
  fiat_p224_addcarryx_u32(&x452, &x453, x451, x439, 0x0);
  uint32_t x454;
  fiat_p224_uint1 x455;
  fiat_p224_addcarryx_u32(&x454, &x455, 0x0, x420, x436);
  uint32_t x456;
  fiat_p224_uint1 x457;
  fiat_p224_addcarryx_u32(&x456, &x457, x455, x422, 0x0);
  uint32_t x458;
  fiat_p224_uint1 x459;
  fiat_p224_addcarryx_u32(&x458, &x459, x457, x424, 0x0);
  uint32_t x460;
  fiat_p224_uint1 x461;
  fiat_p224_addcarryx_u32(&x460, &x461, x459, x426, x444);
  uint32_t x462;
  fiat_p224_uint1 x463;
  fiat_p224_addcarryx_u32(&x462, &x463, x461, x428, x446);
  uint32_t x464;
  fiat_p224_uint1 x465;
  fiat_p224_addcarryx_u32(&x464, &x465, x463, x430, x448);
  uint32_t x466;
  fiat_p224_uint1 x467;
  fiat_p224_addcarryx_u32(&x466, &x467, x465, x432, x450);
  uint32_t x468;
  fiat_p224_uint1 x469;
  fiat_p224_addcarryx_u32(&x468, &x469, x467, x434, x452);
  uint32_t x470;
  fiat_p224_uint1 x471;
  fiat_p224_addcarryx_u32(&x470, &x471, x469, x435, 0x0);
  uint32_t x472;
  uint32_t x473;
  fiat_p224_mulx_u32(&x472, &x473, x6, (arg1[6]));
  uint32_t x474;
  uint32_t x475;
  fiat_p224_mulx_u32(&x474, &x475, x6, (arg1[5]));
  uint32_t x476;
  uint32_t x477;
  fiat_p224_mulx_u32(&x476, &x477, x6, (arg1[4]));
  uint32_t x478;
  uint32_t x479;
  fiat_p224_mulx_u32(&x478, &x479, x6, (arg1[3]));
  uint32_t x480;
  uint32_t x481;
  fiat_p224_mulx_u32(&x480, &x481, x6, (arg1[2]));
  uint32_t x482;
  uint32_t x483;
  fiat_p224_mulx_u32(&x482, &x483, x6, (arg1[1]));
  uint32_t x484;
  uint32_t x485;
  fiat_p224_mulx_u32(&x484, &x485, x6, (arg1[0]));
  uint32_t x486;
  fiat_p224_uint1 x487;
  fiat_p224_addcarryx_u32(&x486, &x487, 0x0, x485, x482);
  uint32_t x488;
  fiat_p224_uint1 x489;
  fiat_p224_addcarryx_u32(&x488, &x489, x487, x483, x480);
  uint32_t x490;
  fiat_p224_uint1 x491;
  fiat_p224_addcarryx_u32(&x490, &x491, x489, x481, x478);
  uint32_t x492;
  fiat_p224_uint1 x493;
  fiat_p224_addcarryx_u32(&x492, &x493, x491, x479, x476);
  uint32_t x494;
  fiat_p224_uint1 x495;
  fiat_p224_addcarryx_u32(&x494, &x495, x493, x477, x474);
  uint32_t x496;
  fiat_p224_uint1 x497;
  fiat_p224_addcarryx_u32(&x496, &x497, x495, x475, x472);
  uint32_t x498;
  fiat_p224_uint1 x499;
  fiat_p224_addcarryx_u32(&x498, &x499, x497, x473, 0x0);
  uint32_t x500;
  fiat_p224_uint1 x501;
  fiat_p224_addcarryx_u32(&x500, &x501, 0x0, x456, x484);
  uint32_t x502;
  fiat_p224_uint1 x503;
  fiat_p224_addcarryx_u32(&x502, &x503, x501, x458, x486);
  uint32_t x504;
  fiat_p224_uint1 x505;
  fiat_p224_addcarryx_u32(&x504, &x505, x503, x460, x488);
  uint32_t x506;
  fiat_p224_uint1 x507;
  fiat_p224_addcarryx_u32(&x506, &x507, x505, x462, x490);
  uint32_t x508;
  fiat_p224_uint1 x509;
  fiat_p224_addcarryx_u32(&x508, &x509, x507, x464, x492);
  uint32_t x510;
  fiat_p224_uint1 x511;
  fiat_p224_addcarryx_u32(&x510, &x511, x509, x466, x494);
  uint32_t x512;
  fiat_p224_uint1 x513;
  fiat_p224_addcarryx_u32(&x512, &x513, x511, x468, x496);
  uint32_t x514;
  fiat_p224_uint1 x515;
  fiat_p224_addcarryx_u32(&x514, &x515, x513, x470, x498);
  uint32_t x516;
  uint32_t x517;
  fiat_p224_mulx_u32(&x516, &x517, x500, UINT32_C(0xffffffff));
  uint32_t x518;
  uint32_t x519;
  fiat_p224_mulx_u32(&x518, &x519, x516, UINT32_C(0xffffffff));
  uint32_t x520;
  uint32_t x521;
  fiat_p224_mulx_u32(&x520, &x521, x516, UINT32_C(0xffffffff));
  uint32_t x522;
  uint32_t x523;
  fiat_p224_mulx_u32(&x522, &x523, x516, UINT32_C(0xffffffff));
  uint32_t x524;
  uint32_t x525;
  fiat_p224_mulx_u32(&x524, &x525, x516, UINT32_C(0xffffffff));
  uint32_t x526;
  fiat_p224_uint1 x527;
  fiat_p224_addcarryx_u32(&x526, &x527, 0x0, x525, x522);
  uint32_t x528;
  fiat_p224_uint1 x529;
  fiat_p224_addcarryx_u32(&x528, &x529, x527, x523, x520);
  uint32_t x530;
  fiat_p224_uint1 x531;
  fiat_p224_addcarryx_u32(&x530, &x531, x529, x521, x518);
  uint32_t x532;
  fiat_p224_uint1 x533;
  fiat_p224_addcarryx_u32(&x532, &x533, x531, x519, 0x0);
  uint32_t x534;
  fiat_p224_uint1 x535;
  fiat_p224_addcarryx_u32(&x534, &x535, 0x0, x500, x516);
  uint32_t x536;
  fiat_p224_uint1 x537;
  fiat_p224_addcarryx_u32(&x536, &x537, x535, x502, 0x0);
  uint32_t x538;
  fiat_p224_uint1 x539;
  fiat_p224_addcarryx_u32(&x538, &x539, x537, x504, 0x0);
  uint32_t x540;
  fiat_p224_uint1 x541;
  fiat_p224_addcarryx_u32(&x540, &x541, x539, x506, x524);
  uint32_t x542;
  fiat_p224_uint1 x543;
  fiat_p224_addcarryx_u32(&x542, &x543, x541, x508, x526);
  uint32_t x544;
  fiat_p224_uint1 x545;
  fiat_p224_addcarryx_u32(&x544, &x545, x543, x510, x528);
  uint32_t x546;
  fiat_p224_uint1 x547;
  fiat_p224_addcarryx_u32(&x546, &x547, x545, x512, x530);
  uint32_t x548;
  fiat_p224_uint1 x549;
  fiat_p224_addcarryx_u32(&x548, &x549, x547, x514, x532);
  uint32_t x550;
  fiat_p224_uint1 x551;
  fiat_p224_addcarryx_u32(&x550, &x551, x549, x515, 0x0);
  uint32_t x552;
  fiat_p224_uint1 x553;
  fiat_p224_subborrowx_u32(&x552, &x553, 0x0, x536, 0x1);
  uint32_t x554;
  fiat_p224_uint1 x555;
  fiat_p224_subborrowx_u32(&x554, &x555, x553, x538, 0x0);
  uint32_t x556;
  fiat_p224_uint1 x557;
  fiat_p224_subborrowx_u32(&x556, &x557, x555, x540, 0x0);
  uint32_t x558;
  fiat_p224_uint1 x559;
  fiat_p224_subborrowx_u32(&x558, &x559, x557, x542, UINT32_C(0xffffffff));
  uint32_t x560;
  fiat_p224_uint1 x561;
  fiat_p224_subborrowx_u32(&x560, &x561, x559, x544, UINT32_C(0xffffffff));
  uint32_t x562;
  fiat_p224_uint1 x563;
  fiat_p224_subborrowx_u32(&x562, &x563, x561, x546, UINT32_C(0xffffffff));
  uint32_t x564;
  fiat_p224_uint1 x565;
  fiat_p224_subborrowx_u32(&x564, &x565, x563, x548, UINT32_C(0xffffffff));
  uint32_t x566;
  fiat_p224_uint1 x567;
  fiat_p224_subborrowx_u32(&x566, &x567, x565, x550, 0x0);
  uint32_t x568;
  fiat_p224_cmovznz_u32(&x568, x567, x552, x536);
  uint32_t x569;
  fiat_p224_cmovznz_u32(&x569, x567, x554, x538);
  uint32_t x570;
  fiat_p224_cmovznz_u32(&x570, x567, x556, x540);
  uint32_t x571;
  fiat_p224_cmovznz_u32(&x571, x567, x558, x542);
  uint32_t x572;
  fiat_p224_cmovznz_u32(&x572, x567, x560, x544);
  uint32_t x573;
  fiat_p224_cmovznz_u32(&x573, x567, x562, x546);
  uint32_t x574;
  fiat_p224_cmovznz_u32(&x574, x567, x564, x548);
  out1[0] = x568;
  out1[1] = x569;
  out1[2] = x570;
  out1[3] = x571;
  out1[4] = x572;
  out1[5] = x573;
  out1[6] = x574;
}

/*
 * The function fiat_p224_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_add(uint32_t out1[7], const uint32_t arg1[7], const uint32_t arg2[7]) {
  uint32_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_p224_uint1 x10;
  fiat_p224_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_p224_uint1 x12;
  fiat_p224_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_p224_uint1 x16;
  fiat_p224_subborrowx_u32(&x15, &x16, 0x0, x1, 0x1);
  uint32_t x17;
  fiat_p224_uint1 x18;
  fiat_p224_subborrowx_u32(&x17, &x18, x16, x3, 0x0);
  uint32_t x19;
  fiat_p224_uint1 x20;
  fiat_p224_subborrowx_u32(&x19, &x20, x18, x5, 0x0);
  uint32_t x21;
  fiat_p224_uint1 x22;
  fiat_p224_subborrowx_u32(&x21, &x22, x20, x7, UINT32_C(0xffffffff));
  uint32_t x23;
  fiat_p224_uint1 x24;
  fiat_p224_subborrowx_u32(&x23, &x24, x22, x9, UINT32_C(0xffffffff));
  uint32_t x25;
  fiat_p224_uint1 x26;
  fiat_p224_subborrowx_u32(&x25, &x26, x24, x11, UINT32_C(0xffffffff));
  uint32_t x27;
  fiat_p224_uint1 x28;
  fiat_p224_subborrowx_u32(&x27, &x28, x26, x13, UINT32_C(0xffffffff));
  uint32_t x29;
  fiat_p224_uint1 x30;
  fiat_p224_subborrowx_u32(&x29, &x30, x28, x14, 0x0);
  uint32_t x31;
  fiat_p224_cmovznz_u32(&x31, x30, x15, x1);
  uint32_t x32;
  fiat_p224_cmovznz_u32(&x32, x30, x17, x3);
  uint32_t x33;
  fiat_p224_cmovznz_u32(&x33, x30, x19, x5);
  uint32_t x34;
  fiat_p224_cmovznz_u32(&x34, x30, x21, x7);
  uint32_t x35;
  fiat_p224_cmovznz_u32(&x35, x30, x23, x9);
  uint32_t x36;
  fiat_p224_cmovznz_u32(&x36, x30, x25, x11);
  uint32_t x37;
  fiat_p224_cmovznz_u32(&x37, x30, x27, x13);
  out1[0] = x31;
  out1[1] = x32;
  out1[2] = x33;
  out1[3] = x34;
  out1[4] = x35;
  out1[5] = x36;
  out1[6] = x37;
}

/*
 * The function fiat_p224_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_sub(uint32_t out1[7], const uint32_t arg1[7], const uint32_t arg2[7]) {
  uint32_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  uint32_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_subborrowx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  uint32_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_subborrowx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  uint32_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_subborrowx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  uint32_t x9;
  fiat_p224_uint1 x10;
  fiat_p224_subborrowx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  uint32_t x11;
  fiat_p224_uint1 x12;
  fiat_p224_subborrowx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  uint32_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_subborrowx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  uint32_t x15;
  fiat_p224_cmovznz_u32(&x15, x14, 0x0, UINT32_C(0xffffffff));
  uint32_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u32(&x16, &x17, 0x0, x1, (fiat_p224_uint1)(x15 & 0x1));
  uint32_t x18;
  fiat_p224_uint1 x19;
  fiat_p224_addcarryx_u32(&x18, &x19, x17, x3, 0x0);
  uint32_t x20;
  fiat_p224_uint1 x21;
  fiat_p224_addcarryx_u32(&x20, &x21, x19, x5, 0x0);
  uint32_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u32(&x22, &x23, x21, x7, (x15 & UINT32_C(0xffffffff)));
  uint32_t x24;
  fiat_p224_uint1 x25;
  fiat_p224_addcarryx_u32(&x24, &x25, x23, x9, (x15 & UINT32_C(0xffffffff)));
  uint32_t x26;
  fiat_p224_uint1 x27;
  fiat_p224_addcarryx_u32(&x26, &x27, x25, x11, (x15 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_p224_uint1 x29;
  fiat_p224_addcarryx_u32(&x28, &x29, x27, x13, (x15 & UINT32_C(0xffffffff)));
  out1[0] = x16;
  out1[1] = x18;
  out1[2] = x20;
  out1[3] = x22;
  out1[4] = x24;
  out1[5] = x26;
  out1[6] = x28;
}

/*
 * The function fiat_p224_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_opp(uint32_t out1[7], const uint32_t arg1[7]) {
  uint32_t x1;
  fiat_p224_uint1 x2;
  fiat_p224_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  uint32_t x3;
  fiat_p224_uint1 x4;
  fiat_p224_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  uint32_t x5;
  fiat_p224_uint1 x6;
  fiat_p224_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  uint32_t x7;
  fiat_p224_uint1 x8;
  fiat_p224_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  uint32_t x9;
  fiat_p224_uint1 x10;
  fiat_p224_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  uint32_t x11;
  fiat_p224_uint1 x12;
  fiat_p224_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  uint32_t x13;
  fiat_p224_uint1 x14;
  fiat_p224_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  uint32_t x15;
  fiat_p224_cmovznz_u32(&x15, x14, 0x0, UINT32_C(0xffffffff));
  uint32_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u32(&x16, &x17, 0x0, x1, (fiat_p224_uint1)(x15 & 0x1));
  uint32_t x18;
  fiat_p224_uint1 x19;
  fiat_p224_addcarryx_u32(&x18, &x19, x17, x3, 0x0);
  uint32_t x20;
  fiat_p224_uint1 x21;
  fiat_p224_addcarryx_u32(&x20, &x21, x19, x5, 0x0);
  uint32_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u32(&x22, &x23, x21, x7, (x15 & UINT32_C(0xffffffff)));
  uint32_t x24;
  fiat_p224_uint1 x25;
  fiat_p224_addcarryx_u32(&x24, &x25, x23, x9, (x15 & UINT32_C(0xffffffff)));
  uint32_t x26;
  fiat_p224_uint1 x27;
  fiat_p224_addcarryx_u32(&x26, &x27, x25, x11, (x15 & UINT32_C(0xffffffff)));
  uint32_t x28;
  fiat_p224_uint1 x29;
  fiat_p224_addcarryx_u32(&x28, &x29, x27, x13, (x15 & UINT32_C(0xffffffff)));
  out1[0] = x16;
  out1[1] = x18;
  out1[2] = x20;
  out1[3] = x22;
  out1[4] = x24;
  out1[5] = x26;
  out1[6] = x28;
}

/*
 * The function fiat_p224_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^7) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_from_montgomery(uint32_t out1[7], const uint32_t arg1[7]) {
  uint32_t x1 = (arg1[0]);
  uint32_t x2;
  uint32_t x3;
  fiat_p224_mulx_u32(&x2, &x3, x1, UINT32_C(0xffffffff));
  uint32_t x4;
  uint32_t x5;
  fiat_p224_mulx_u32(&x4, &x5, x2, UINT32_C(0xffffffff));
  uint32_t x6;
  uint32_t x7;
  fiat_p224_mulx_u32(&x6, &x7, x2, UINT32_C(0xffffffff));
  uint32_t x8;
  uint32_t x9;
  fiat_p224_mulx_u32(&x8, &x9, x2, UINT32_C(0xffffffff));
  uint32_t x10;
  uint32_t x11;
  fiat_p224_mulx_u32(&x10, &x11, x2, UINT32_C(0xffffffff));
  uint32_t x12;
  fiat_p224_uint1 x13;
  fiat_p224_addcarryx_u32(&x12, &x13, 0x0, x11, x8);
  uint32_t x14;
  fiat_p224_uint1 x15;
  fiat_p224_addcarryx_u32(&x14, &x15, x13, x9, x6);
  uint32_t x16;
  fiat_p224_uint1 x17;
  fiat_p224_addcarryx_u32(&x16, &x17, x15, x7, x4);
  uint32_t x18;
  fiat_p224_uint1 x19;
  fiat_p224_addcarryx_u32(&x18, &x19, 0x0, x1, x2);
  uint32_t x20;
  fiat_p224_uint1 x21;
  fiat_p224_addcarryx_u32(&x20, &x21, x19, 0x0, 0x0);
  uint32_t x22;
  fiat_p224_uint1 x23;
  fiat_p224_addcarryx_u32(&x22, &x23, 0x0, (fiat_p224_uint1)x20, (arg1[1]));
  uint32_t x24;
  uint32_t x25;
  fiat_p224_mulx_u32(&x24, &x25, x22, UINT32_C(0xffffffff));
  uint32_t x26;
  uint32_t x27;
  fiat_p224_mulx_u32(&x26, &x27, x24, UINT32_C(0xffffffff));
  uint32_t x28;
  uint32_t x29;
  fiat_p224_mulx_u32(&x28, &x29, x24, UINT32_C(0xffffffff));
  uint32_t x30;
  uint32_t x31;
  fiat_p224_mulx_u32(&x30, &x31, x24, UINT32_C(0xffffffff));
  uint32_t x32;
  uint32_t x33;
  fiat_p224_mulx_u32(&x32, &x33, x24, UINT32_C(0xffffffff));
  uint32_t x34;
  fiat_p224_uint1 x35;
  fiat_p224_addcarryx_u32(&x34, &x35, 0x0, x33, x30);
  uint32_t x36;
  fiat_p224_uint1 x37;
  fiat_p224_addcarryx_u32(&x36, &x37, x35, x31, x28);
  uint32_t x38;
  fiat_p224_uint1 x39;
  fiat_p224_addcarryx_u32(&x38, &x39, x37, x29, x26);
  uint32_t x40;
  fiat_p224_uint1 x41;
  fiat_p224_addcarryx_u32(&x40, &x41, 0x0, x12, x32);
  uint32_t x42;
  fiat_p224_uint1 x43;
  fiat_p224_addcarryx_u32(&x42, &x43, x41, x14, x34);
  uint32_t x44;
  fiat_p224_uint1 x45;
  fiat_p224_addcarryx_u32(&x44, &x45, x43, x16, x36);
  uint32_t x46;
  fiat_p224_uint1 x47;
  fiat_p224_addcarryx_u32(&x46, &x47, x17, x5, 0x0);
  uint32_t x48;
  fiat_p224_uint1 x49;
  fiat_p224_addcarryx_u32(&x48, &x49, x45, x46, x38);
  uint32_t x50;
  fiat_p224_uint1 x51;
  fiat_p224_addcarryx_u32(&x50, &x51, x39, x27, 0x0);
  uint32_t x52;
  fiat_p224_uint1 x53;
  fiat_p224_addcarryx_u32(&x52, &x53, x49, 0x0, x50);
  uint32_t x54;
  fiat_p224_uint1 x55;
  fiat_p224_addcarryx_u32(&x54, &x55, x23, 0x0, 0x0);
  uint32_t x56;
  fiat_p224_uint1 x57;
  fiat_p224_addcarryx_u32(&x56, &x57, 0x0, x22, x24);
  uint32_t x58;
  fiat_p224_uint1 x59;
  fiat_p224_addcarryx_u32(&x58, &x59, x57, (fiat_p224_uint1)x54, 0x0);
  uint32_t x60;
  fiat_p224_uint1 x61;
  fiat_p224_addcarryx_u32(&x60, &x61, 0x0, x58, (arg1[2]));
  uint32_t x62;
  fiat_p224_uint1 x63;
  fiat_p224_addcarryx_u32(&x62, &x63, x61, x10, 0x0);
  uint32_t x64;
  fiat_p224_uint1 x65;
  fiat_p224_addcarryx_u32(&x64, &x65, x63, x40, 0x0);
  uint32_t x66;
  fiat_p224_uint1 x67;
  fiat_p224_addcarryx_u32(&x66, &x67, x65, x42, 0x0);
  uint32_t x68;
  fiat_p224_uint1 x69;
  fiat_p224_addcarryx_u32(&x68, &x69, x67, x44, 0x0);
  uint32_t x70;
  fiat_p224_uint1 x71;
  fiat_p224_addcarryx_u32(&x70, &x71, x69, x48, 0x0);
  uint32_t x72;
  fiat_p224_uint1 x73;
  fiat_p224_addcarryx_u32(&x72, &x73, x71, x52, 0x0);
  uint32_t x74;
  uint32_t x75;
  fiat_p224_mulx_u32(&x74, &x75, x60, UINT32_C(0xffffffff));
  uint32_t x76;
  uint32_t x77;
  fiat_p224_mulx_u32(&x76, &x77, x74, UINT32_C(0xffffffff));
  uint32_t x78;
  uint32_t x79;
  fiat_p224_mulx_u32(&x78, &x79, x74, UINT32_C(0xffffffff));
  uint32_t x80;
  uint32_t x81;
  fiat_p224_mulx_u32(&x80, &x81, x74, UINT32_C(0xffffffff));
  uint32_t x82;
  uint32_t x83;
  fiat_p224_mulx_u32(&x82, &x83, x74, UINT32_C(0xffffffff));
  uint32_t x84;
  fiat_p224_uint1 x85;
  fiat_p224_addcarryx_u32(&x84, &x85, 0x0, x83, x80);
  uint32_t x86;
  fiat_p224_uint1 x87;
  fiat_p224_addcarryx_u32(&x86, &x87, x85, x81, x78);
  uint32_t x88;
  fiat_p224_uint1 x89;
  fiat_p224_addcarryx_u32(&x88, &x89, x87, x79, x76);
  uint32_t x90;
  fiat_p224_uint1 x91;
  fiat_p224_addcarryx_u32(&x90, &x91, 0x0, x60, x74);
  uint32_t x92;
  fiat_p224_uint1 x93;
  fiat_p224_addcarryx_u32(&x92, &x93, x91, x62, 0x0);
  uint32_t x94;
  fiat_p224_uint1 x95;
  fiat_p224_addcarryx_u32(&x94, &x95, x93, x64, 0x0);
  uint32_t x96;
  fiat_p224_uint1 x97;
  fiat_p224_addcarryx_u32(&x96, &x97, x95, x66, x82);
  uint32_t x98;
  fiat_p224_uint1 x99;
  fiat_p224_addcarryx_u32(&x98, &x99, x97, x68, x84);
  uint32_t x100;
  fiat_p224_uint1 x101;
  fiat_p224_addcarryx_u32(&x100, &x101, x99, x70, x86);
  uint32_t x102;
  fiat_p224_uint1 x103;
  fiat_p224_addcarryx_u32(&x102, &x103, x101, x72, x88);
  uint32_t x104;
  fiat_p224_uint1 x105;
  fiat_p224_addcarryx_u32(&x104, &x105, x89, x77, 0x0);
  uint32_t x106;
  fiat_p224_uint1 x107;
  fiat_p224_addcarryx_u32(&x106, &x107, x53, 0x0, 0x0);
  uint32_t x108;
  fiat_p224_uint1 x109;
  fiat_p224_addcarryx_u32(&x108, &x109, x73, (fiat_p224_uint1)x106, 0x0);
  uint32_t x110;
  fiat_p224_uint1 x111;
  fiat_p224_addcarryx_u32(&x110, &x111, x103, x108, x104);
  uint32_t x112;
  fiat_p224_uint1 x113;
  fiat_p224_addcarryx_u32(&x112, &x113, 0x0, x92, (arg1[3]));
  uint32_t x114;
  fiat_p224_uint1 x115;
  fiat_p224_addcarryx_u32(&x114, &x115, x113, x94, 0x0);
  uint32_t x116;
  fiat_p224_uint1 x117;
  fiat_p224_addcarryx_u32(&x116, &x117, x115, x96, 0x0);
  uint32_t x118;
  fiat_p224_uint1 x119;
  fiat_p224_addcarryx_u32(&x118, &x119, x117, x98, 0x0);
  uint32_t x120;
  fiat_p224_uint1 x121;
  fiat_p224_addcarryx_u32(&x120, &x121, x119, x100, 0x0);
  uint32_t x122;
  fiat_p224_uint1 x123;
  fiat_p224_addcarryx_u32(&x122, &x123, x121, x102, 0x0);
  uint32_t x124;
  fiat_p224_uint1 x125;
  fiat_p224_addcarryx_u32(&x124, &x125, x123, x110, 0x0);
  uint32_t x126;
  uint32_t x127;
  fiat_p224_mulx_u32(&x126, &x127, x112, UINT32_C(0xffffffff));
  uint32_t x128;
  uint32_t x129;
  fiat_p224_mulx_u32(&x128, &x129, x126, UINT32_C(0xffffffff));
  uint32_t x130;
  uint32_t x131;
  fiat_p224_mulx_u32(&x130, &x131, x126, UINT32_C(0xffffffff));
  uint32_t x132;
  uint32_t x133;
  fiat_p224_mulx_u32(&x132, &x133, x126, UINT32_C(0xffffffff));
  uint32_t x134;
  uint32_t x135;
  fiat_p224_mulx_u32(&x134, &x135, x126, UINT32_C(0xffffffff));
  uint32_t x136;
  fiat_p224_uint1 x137;
  fiat_p224_addcarryx_u32(&x136, &x137, 0x0, x135, x132);
  uint32_t x138;
  fiat_p224_uint1 x139;
  fiat_p224_addcarryx_u32(&x138, &x139, x137, x133, x130);
  uint32_t x140;
  fiat_p224_uint1 x141;
  fiat_p224_addcarryx_u32(&x140, &x141, x139, x131, x128);
  uint32_t x142;
  fiat_p224_uint1 x143;
  fiat_p224_addcarryx_u32(&x142, &x143, 0x0, x112, x126);
  uint32_t x144;
  fiat_p224_uint1 x145;
  fiat_p224_addcarryx_u32(&x144, &x145, x143, x114, 0x0);
  uint32_t x146;
  fiat_p224_uint1 x147;
  fiat_p224_addcarryx_u32(&x146, &x147, x145, x116, 0x0);
  uint32_t x148;
  fiat_p224_uint1 x149;
  fiat_p224_addcarryx_u32(&x148, &x149, x147, x118, x134);
  uint32_t x150;
  fiat_p224_uint1 x151;
  fiat_p224_addcarryx_u32(&x150, &x151, x149, x120, x136);
  uint32_t x152;
  fiat_p224_uint1 x153;
  fiat_p224_addcarryx_u32(&x152, &x153, x151, x122, x138);
  uint32_t x154;
  fiat_p224_uint1 x155;
  fiat_p224_addcarryx_u32(&x154, &x155, x153, x124, x140);
  uint32_t x156;
  fiat_p224_uint1 x157;
  fiat_p224_addcarryx_u32(&x156, &x157, x141, x129, 0x0);
  uint32_t x158;
  fiat_p224_uint1 x159;
  fiat_p224_addcarryx_u32(&x158, &x159, x111, 0x0, 0x0);
  uint32_t x160;
  fiat_p224_uint1 x161;
  fiat_p224_addcarryx_u32(&x160, &x161, x125, (fiat_p224_uint1)x158, 0x0);
  uint32_t x162;
  fiat_p224_uint1 x163;
  fiat_p224_addcarryx_u32(&x162, &x163, x155, x160, x156);
  uint32_t x164;
  fiat_p224_uint1 x165;
  fiat_p224_addcarryx_u32(&x164, &x165, 0x0, x144, (arg1[4]));
  uint32_t x166;
  fiat_p224_uint1 x167;
  fiat_p224_addcarryx_u32(&x166, &x167, x165, x146, 0x0);
  uint32_t x168;
  fiat_p224_uint1 x169;
  fiat_p224_addcarryx_u32(&x168, &x169, x167, x148, 0x0);
  uint32_t x170;
  fiat_p224_uint1 x171;
  fiat_p224_addcarryx_u32(&x170, &x171, x169, x150, 0x0);
  uint32_t x172;
  fiat_p224_uint1 x173;
  fiat_p224_addcarryx_u32(&x172, &x173, x171, x152, 0x0);
  uint32_t x174;
  fiat_p224_uint1 x175;
  fiat_p224_addcarryx_u32(&x174, &x175, x173, x154, 0x0);
  uint32_t x176;
  fiat_p224_uint1 x177;
  fiat_p224_addcarryx_u32(&x176, &x177, x175, x162, 0x0);
  uint32_t x178;
  uint32_t x179;
  fiat_p224_mulx_u32(&x178, &x179, x164, UINT32_C(0xffffffff));
  uint32_t x180;
  uint32_t x181;
  fiat_p224_mulx_u32(&x180, &x181, x178, UINT32_C(0xffffffff));
  uint32_t x182;
  uint32_t x183;
  fiat_p224_mulx_u32(&x182, &x183, x178, UINT32_C(0xffffffff));
  uint32_t x184;
  uint32_t x185;
  fiat_p224_mulx_u32(&x184, &x185, x178, UINT32_C(0xffffffff));
  uint32_t x186;
  uint32_t x187;
  fiat_p224_mulx_u32(&x186, &x187, x178, UINT32_C(0xffffffff));
  uint32_t x188;
  fiat_p224_uint1 x189;
  fiat_p224_addcarryx_u32(&x188, &x189, 0x0, x187, x184);
  uint32_t x190;
  fiat_p224_uint1 x191;
  fiat_p224_addcarryx_u32(&x190, &x191, x189, x185, x182);
  uint32_t x192;
  fiat_p224_uint1 x193;
  fiat_p224_addcarryx_u32(&x192, &x193, x191, x183, x180);
  uint32_t x194;
  fiat_p224_uint1 x195;
  fiat_p224_addcarryx_u32(&x194, &x195, 0x0, x164, x178);
  uint32_t x196;
  fiat_p224_uint1 x197;
  fiat_p224_addcarryx_u32(&x196, &x197, x195, x166, 0x0);
  uint32_t x198;
  fiat_p224_uint1 x199;
  fiat_p224_addcarryx_u32(&x198, &x199, x197, x168, 0x0);
  uint32_t x200;
  fiat_p224_uint1 x201;
  fiat_p224_addcarryx_u32(&x200, &x201, x199, x170, x186);
  uint32_t x202;
  fiat_p224_uint1 x203;
  fiat_p224_addcarryx_u32(&x202, &x203, x201, x172, x188);
  uint32_t x204;
  fiat_p224_uint1 x205;
  fiat_p224_addcarryx_u32(&x204, &x205, x203, x174, x190);
  uint32_t x206;
  fiat_p224_uint1 x207;
  fiat_p224_addcarryx_u32(&x206, &x207, x205, x176, x192);
  uint32_t x208;
  fiat_p224_uint1 x209;
  fiat_p224_addcarryx_u32(&x208, &x209, x193, x181, 0x0);
  uint32_t x210;
  fiat_p224_uint1 x211;
  fiat_p224_addcarryx_u32(&x210, &x211, x163, 0x0, 0x0);
  uint32_t x212;
  fiat_p224_uint1 x213;
  fiat_p224_addcarryx_u32(&x212, &x213, x177, (fiat_p224_uint1)x210, 0x0);
  uint32_t x214;
  fiat_p224_uint1 x215;
  fiat_p224_addcarryx_u32(&x214, &x215, x207, x212, x208);
  uint32_t x216;
  fiat_p224_uint1 x217;
  fiat_p224_addcarryx_u32(&x216, &x217, 0x0, x196, (arg1[5]));
  uint32_t x218;
  fiat_p224_uint1 x219;
  fiat_p224_addcarryx_u32(&x218, &x219, x217, x198, 0x0);
  uint32_t x220;
  fiat_p224_uint1 x221;
  fiat_p224_addcarryx_u32(&x220, &x221, x219, x200, 0x0);
  uint32_t x222;
  fiat_p224_uint1 x223;
  fiat_p224_addcarryx_u32(&x222, &x223, x221, x202, 0x0);
  uint32_t x224;
  fiat_p224_uint1 x225;
  fiat_p224_addcarryx_u32(&x224, &x225, x223, x204, 0x0);
  uint32_t x226;
  fiat_p224_uint1 x227;
  fiat_p224_addcarryx_u32(&x226, &x227, x225, x206, 0x0);
  uint32_t x228;
  fiat_p224_uint1 x229;
  fiat_p224_addcarryx_u32(&x228, &x229, x227, x214, 0x0);
  uint32_t x230;
  uint32_t x231;
  fiat_p224_mulx_u32(&x230, &x231, x216, UINT32_C(0xffffffff));
  uint32_t x232;
  uint32_t x233;
  fiat_p224_mulx_u32(&x232, &x233, x230, UINT32_C(0xffffffff));
  uint32_t x234;
  uint32_t x235;
  fiat_p224_mulx_u32(&x234, &x235, x230, UINT32_C(0xffffffff));
  uint32_t x236;
  uint32_t x237;
  fiat_p224_mulx_u32(&x236, &x237, x230, UINT32_C(0xffffffff));
  uint32_t x238;
  uint32_t x239;
  fiat_p224_mulx_u32(&x238, &x239, x230, UINT32_C(0xffffffff));
  uint32_t x240;
  fiat_p224_uint1 x241;
  fiat_p224_addcarryx_u32(&x240, &x241, 0x0, x239, x236);
  uint32_t x242;
  fiat_p224_uint1 x243;
  fiat_p224_addcarryx_u32(&x242, &x243, x241, x237, x234);
  uint32_t x244;
  fiat_p224_uint1 x245;
  fiat_p224_addcarryx_u32(&x244, &x245, x243, x235, x232);
  uint32_t x246;
  fiat_p224_uint1 x247;
  fiat_p224_addcarryx_u32(&x246, &x247, 0x0, x216, x230);
  uint32_t x248;
  fiat_p224_uint1 x249;
  fiat_p224_addcarryx_u32(&x248, &x249, x247, x218, 0x0);
  uint32_t x250;
  fiat_p224_uint1 x251;
  fiat_p224_addcarryx_u32(&x250, &x251, x249, x220, 0x0);
  uint32_t x252;
  fiat_p224_uint1 x253;
  fiat_p224_addcarryx_u32(&x252, &x253, x251, x222, x238);
  uint32_t x254;
  fiat_p224_uint1 x255;
  fiat_p224_addcarryx_u32(&x254, &x255, x253, x224, x240);
  uint32_t x256;
  fiat_p224_uint1 x257;
  fiat_p224_addcarryx_u32(&x256, &x257, x255, x226, x242);
  uint32_t x258;
  fiat_p224_uint1 x259;
  fiat_p224_addcarryx_u32(&x258, &x259, x257, x228, x244);
  uint32_t x260;
  fiat_p224_uint1 x261;
  fiat_p224_addcarryx_u32(&x260, &x261, x245, x233, 0x0);
  uint32_t x262;
  fiat_p224_uint1 x263;
  fiat_p224_addcarryx_u32(&x262, &x263, x215, 0x0, 0x0);
  uint32_t x264;
  fiat_p224_uint1 x265;
  fiat_p224_addcarryx_u32(&x264, &x265, x229, (fiat_p224_uint1)x262, 0x0);
  uint32_t x266;
  fiat_p224_uint1 x267;
  fiat_p224_addcarryx_u32(&x266, &x267, x259, x264, x260);
  uint32_t x268;
  fiat_p224_uint1 x269;
  fiat_p224_addcarryx_u32(&x268, &x269, 0x0, x248, (arg1[6]));
  uint32_t x270;
  fiat_p224_uint1 x271;
  fiat_p224_addcarryx_u32(&x270, &x271, x269, x250, 0x0);
  uint32_t x272;
  fiat_p224_uint1 x273;
  fiat_p224_addcarryx_u32(&x272, &x273, x271, x252, 0x0);
  uint32_t x274;
  fiat_p224_uint1 x275;
  fiat_p224_addcarryx_u32(&x274, &x275, x273, x254, 0x0);
  uint32_t x276;
  fiat_p224_uint1 x277;
  fiat_p224_addcarryx_u32(&x276, &x277, x275, x256, 0x0);
  uint32_t x278;
  fiat_p224_uint1 x279;
  fiat_p224_addcarryx_u32(&x278, &x279, x277, x258, 0x0);
  uint32_t x280;
  fiat_p224_uint1 x281;
  fiat_p224_addcarryx_u32(&x280, &x281, x279, x266, 0x0);
  uint32_t x282;
  uint32_t x283;
  fiat_p224_mulx_u32(&x282, &x283, x268, UINT32_C(0xffffffff));
  uint32_t x284;
  uint32_t x285;
  fiat_p224_mulx_u32(&x284, &x285, x282, UINT32_C(0xffffffff));
  uint32_t x286;
  uint32_t x287;
  fiat_p224_mulx_u32(&x286, &x287, x282, UINT32_C(0xffffffff));
  uint32_t x288;
  uint32_t x289;
  fiat_p224_mulx_u32(&x288, &x289, x282, UINT32_C(0xffffffff));
  uint32_t x290;
  uint32_t x291;
  fiat_p224_mulx_u32(&x290, &x291, x282, UINT32_C(0xffffffff));
  uint32_t x292;
  fiat_p224_uint1 x293;
  fiat_p224_addcarryx_u32(&x292, &x293, 0x0, x291, x288);
  uint32_t x294;
  fiat_p224_uint1 x295;
  fiat_p224_addcarryx_u32(&x294, &x295, x293, x289, x286);
  uint32_t x296;
  fiat_p224_uint1 x297;
  fiat_p224_addcarryx_u32(&x296, &x297, x295, x287, x284);
  uint32_t x298;
  fiat_p224_uint1 x299;
  fiat_p224_addcarryx_u32(&x298, &x299, 0x0, x268, x282);
  uint32_t x300;
  fiat_p224_uint1 x301;
  fiat_p224_addcarryx_u32(&x300, &x301, x299, x270, 0x0);
  uint32_t x302;
  fiat_p224_uint1 x303;
  fiat_p224_addcarryx_u32(&x302, &x303, x301, x272, 0x0);
  uint32_t x304;
  fiat_p224_uint1 x305;
  fiat_p224_addcarryx_u32(&x304, &x305, x303, x274, x290);
  uint32_t x306;
  fiat_p224_uint1 x307;
  fiat_p224_addcarryx_u32(&x306, &x307, x305, x276, x292);
  uint32_t x308;
  fiat_p224_uint1 x309;
  fiat_p224_addcarryx_u32(&x308, &x309, x307, x278, x294);
  uint32_t x310;
  fiat_p224_uint1 x311;
  fiat_p224_addcarryx_u32(&x310, &x311, x309, x280, x296);
  uint32_t x312;
  fiat_p224_uint1 x313;
  fiat_p224_addcarryx_u32(&x312, &x313, x297, x285, 0x0);
  uint32_t x314;
  fiat_p224_uint1 x315;
  fiat_p224_addcarryx_u32(&x314, &x315, x267, 0x0, 0x0);
  uint32_t x316;
  fiat_p224_uint1 x317;
  fiat_p224_addcarryx_u32(&x316, &x317, x281, (fiat_p224_uint1)x314, 0x0);
  uint32_t x318;
  fiat_p224_uint1 x319;
  fiat_p224_addcarryx_u32(&x318, &x319, x311, x316, x312);
  uint32_t x320;
  fiat_p224_uint1 x321;
  fiat_p224_subborrowx_u32(&x320, &x321, 0x0, x300, 0x1);
  uint32_t x322;
  fiat_p224_uint1 x323;
  fiat_p224_subborrowx_u32(&x322, &x323, x321, x302, 0x0);
  uint32_t x324;
  fiat_p224_uint1 x325;
  fiat_p224_subborrowx_u32(&x324, &x325, x323, x304, 0x0);
  uint32_t x326;
  fiat_p224_uint1 x327;
  fiat_p224_subborrowx_u32(&x326, &x327, x325, x306, UINT32_C(0xffffffff));
  uint32_t x328;
  fiat_p224_uint1 x329;
  fiat_p224_subborrowx_u32(&x328, &x329, x327, x308, UINT32_C(0xffffffff));
  uint32_t x330;
  fiat_p224_uint1 x331;
  fiat_p224_subborrowx_u32(&x330, &x331, x329, x310, UINT32_C(0xffffffff));
  uint32_t x332;
  fiat_p224_uint1 x333;
  fiat_p224_subborrowx_u32(&x332, &x333, x331, x318, UINT32_C(0xffffffff));
  uint32_t x334;
  fiat_p224_uint1 x335;
  fiat_p224_addcarryx_u32(&x334, &x335, x319, 0x0, 0x0);
  uint32_t x336;
  fiat_p224_uint1 x337;
  fiat_p224_subborrowx_u32(&x336, &x337, x333, (fiat_p224_uint1)x334, 0x0);
  uint32_t x338;
  fiat_p224_cmovznz_u32(&x338, x337, x320, x300);
  uint32_t x339;
  fiat_p224_cmovznz_u32(&x339, x337, x322, x302);
  uint32_t x340;
  fiat_p224_cmovznz_u32(&x340, x337, x324, x304);
  uint32_t x341;
  fiat_p224_cmovznz_u32(&x341, x337, x326, x306);
  uint32_t x342;
  fiat_p224_cmovznz_u32(&x342, x337, x328, x308);
  uint32_t x343;
  fiat_p224_cmovznz_u32(&x343, x337, x330, x310);
  uint32_t x344;
  fiat_p224_cmovznz_u32(&x344, x337, x332, x318);
  out1[0] = x338;
  out1[1] = x339;
  out1[2] = x340;
  out1[3] = x341;
  out1[4] = x342;
  out1[5] = x343;
  out1[6] = x344;
}

/*
 * The function fiat_p224_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p224_nonzero(uint32_t* out1, const uint32_t arg1[7]) {
  uint32_t x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (uint32_t)0x0)))))));
  *out1 = x1;
}

/*
 * The function fiat_p224_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_selectznz(uint32_t out1[7], fiat_p224_uint1 arg1, const uint32_t arg2[7], const uint32_t arg3[7]) {
  uint32_t x1;
  fiat_p224_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  uint32_t x2;
  fiat_p224_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  uint32_t x3;
  fiat_p224_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  uint32_t x4;
  fiat_p224_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  uint32_t x5;
  fiat_p224_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  uint32_t x6;
  fiat_p224_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  uint32_t x7;
  fiat_p224_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
}

/*
 * The function fiat_p224_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..27]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p224_to_bytes(uint8_t out1[28], const uint32_t arg1[7]) {
  uint32_t x1 = (arg1[6]);
  uint32_t x2 = (arg1[5]);
  uint32_t x3 = (arg1[4]);
  uint32_t x4 = (arg1[3]);
  uint32_t x5 = (arg1[2]);
  uint32_t x6 = (arg1[1]);
  uint32_t x7 = (arg1[0]);
  uint32_t x8 = (x7 >> 8);
  uint8_t x9 = (uint8_t)(x7 & UINT8_C(0xff));
  uint32_t x10 = (x8 >> 8);
  uint8_t x11 = (uint8_t)(x8 & UINT8_C(0xff));
  uint8_t x12 = (uint8_t)(x10 >> 8);
  uint8_t x13 = (uint8_t)(x10 & UINT8_C(0xff));
  uint8_t x14 = (uint8_t)(x12 & UINT8_C(0xff));
  uint32_t x15 = (x6 >> 8);
  uint8_t x16 = (uint8_t)(x6 & UINT8_C(0xff));
  uint32_t x17 = (x15 >> 8);
  uint8_t x18 = (uint8_t)(x15 & UINT8_C(0xff));
  uint8_t x19 = (uint8_t)(x17 >> 8);
  uint8_t x20 = (uint8_t)(x17 & UINT8_C(0xff));
  uint8_t x21 = (uint8_t)(x19 & UINT8_C(0xff));
  uint32_t x22 = (x5 >> 8);
  uint8_t x23 = (uint8_t)(x5 & UINT8_C(0xff));
  uint32_t x24 = (x22 >> 8);
  uint8_t x25 = (uint8_t)(x22 & UINT8_C(0xff));
  uint8_t x26 = (uint8_t)(x24 >> 8);
  uint8_t x27 = (uint8_t)(x24 & UINT8_C(0xff));
  uint8_t x28 = (uint8_t)(x26 & UINT8_C(0xff));
  uint32_t x29 = (x4 >> 8);
  uint8_t x30 = (uint8_t)(x4 & UINT8_C(0xff));
  uint32_t x31 = (x29 >> 8);
  uint8_t x32 = (uint8_t)(x29 & UINT8_C(0xff));
  uint8_t x33 = (uint8_t)(x31 >> 8);
  uint8_t x34 = (uint8_t)(x31 & UINT8_C(0xff));
  uint8_t x35 = (uint8_t)(x33 & UINT8_C(0xff));
  uint32_t x36 = (x3 >> 8);
  uint8_t x37 = (uint8_t)(x3 & UINT8_C(0xff));
  uint32_t x38 = (x36 >> 8);
  uint8_t x39 = (uint8_t)(x36 & UINT8_C(0xff));
  uint8_t x40 = (uint8_t)(x38 >> 8);
  uint8_t x41 = (uint8_t)(x38 & UINT8_C(0xff));
  uint8_t x42 = (uint8_t)(x40 & UINT8_C(0xff));
  uint32_t x43 = (x2 >> 8);
  uint8_t x44 = (uint8_t)(x2 & UINT8_C(0xff));
  uint32_t x45 = (x43 >> 8);
  uint8_t x46 = (uint8_t)(x43 & UINT8_C(0xff));
  uint8_t x47 = (uint8_t)(x45 >> 8);
  uint8_t x48 = (uint8_t)(x45 & UINT8_C(0xff));
  uint8_t x49 = (uint8_t)(x47 & UINT8_C(0xff));
  uint32_t x50 = (x1 >> 8);
  uint8_t x51 = (uint8_t)(x1 & UINT8_C(0xff));
  uint32_t x52 = (x50 >> 8);
  uint8_t x53 = (uint8_t)(x50 & UINT8_C(0xff));
  uint8_t x54 = (uint8_t)(x52 >> 8);
  uint8_t x55 = (uint8_t)(x52 & UINT8_C(0xff));
  out1[0] = x9;
  out1[1] = x11;
  out1[2] = x13;
  out1[3] = x14;
  out1[4] = x16;
  out1[5] = x18;
  out1[6] = x20;
  out1[7] = x21;
  out1[8] = x23;
  out1[9] = x25;
  out1[10] = x27;
  out1[11] = x28;
  out1[12] = x30;
  out1[13] = x32;
  out1[14] = x34;
  out1[15] = x35;
  out1[16] = x37;
  out1[17] = x39;
  out1[18] = x41;
  out1[19] = x42;
  out1[20] = x44;
  out1[21] = x46;
  out1[22] = x48;
  out1[23] = x49;
  out1[24] = x51;
  out1[25] = x53;
  out1[26] = x55;
  out1[27] = x54;
}

/*
 * The function fiat_p224_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p224_from_bytes(uint32_t out1[7], const uint8_t arg1[28]) {
  uint32_t x1 = ((uint32_t)(arg1[27]) << 24);
  uint32_t x2 = ((uint32_t)(arg1[26]) << 16);
  uint32_t x3 = ((uint32_t)(arg1[25]) << 8);
  uint8_t x4 = (arg1[24]);
  uint32_t x5 = ((uint32_t)(arg1[23]) << 24);
  uint32_t x6 = ((uint32_t)(arg1[22]) << 16);
  uint32_t x7 = ((uint32_t)(arg1[21]) << 8);
  uint8_t x8 = (arg1[20]);
  uint32_t x9 = ((uint32_t)(arg1[19]) << 24);
  uint32_t x10 = ((uint32_t)(arg1[18]) << 16);
  uint32_t x11 = ((uint32_t)(arg1[17]) << 8);
  uint8_t x12 = (arg1[16]);
  uint32_t x13 = ((uint32_t)(arg1[15]) << 24);
  uint32_t x14 = ((uint32_t)(arg1[14]) << 16);
  uint32_t x15 = ((uint32_t)(arg1[13]) << 8);
  uint8_t x16 = (arg1[12]);
  uint32_t x17 = ((uint32_t)(arg1[11]) << 24);
  uint32_t x18 = ((uint32_t)(arg1[10]) << 16);
  uint32_t x19 = ((uint32_t)(arg1[9]) << 8);
  uint8_t x20 = (arg1[8]);
  uint32_t x21 = ((uint32_t)(arg1[7]) << 24);
  uint32_t x22 = ((uint32_t)(arg1[6]) << 16);
  uint32_t x23 = ((uint32_t)(arg1[5]) << 8);
  uint8_t x24 = (arg1[4]);
  uint32_t x25 = ((uint32_t)(arg1[3]) << 24);
  uint32_t x26 = ((uint32_t)(arg1[2]) << 16);
  uint32_t x27 = ((uint32_t)(arg1[1]) << 8);
  uint8_t x28 = (arg1[0]);
  uint32_t x29 = (x28 + (x27 + (x26 + x25)));
  uint32_t x30 = (x29 & UINT32_C(0xffffffff));
  uint32_t x31 = (x4 + (x3 + (x2 + x1)));
  uint32_t x32 = (x8 + (x7 + (x6 + x5)));
  uint32_t x33 = (x12 + (x11 + (x10 + x9)));
  uint32_t x34 = (x16 + (x15 + (x14 + x13)));
  uint32_t x35 = (x20 + (x19 + (x18 + x17)));
  uint32_t x36 = (x24 + (x23 + (x22 + x21)));
  uint32_t x37 = (x36 & UINT32_C(0xffffffff));
  uint32_t x38 = (x35 & UINT32_C(0xffffffff));
  uint32_t x39 = (x34 & UINT32_C(0xffffffff));
  uint32_t x40 = (x33 & UINT32_C(0xffffffff));
  uint32_t x41 = (x32 & UINT32_C(0xffffffff));
  out1[0] = x30;
  out1[1] = x37;
  out1[2] = x38;
  out1[3] = x39;
  out1[4] = x40;
  out1[5] = x41;
  out1[6] = x31;
}
