/* Autogenerated: /home/chjj/fiat-crypto/src/ExtractionOCaml/unsaturated_solinas --static p192 4 '2^192 - 2^64 - 1' 64 */
/* curve description: p192 */
/* requested operations: (all) */
/* n = 4 (from "4") */
/* s-c = 2^192 - [(2^64, 1), (1, 1)] (from "2^192 - 2^64 - 1") */
/* machine_wordsize = 64 (from "64") */

/* Computed values: */
/* carry_chain = [0, 3, 1, 0, 2, 3, 1, 0] */

#include <stdint.h>
typedef unsigned char fiat_p192_uint1;
typedef signed char fiat_p192_int1;
FIAT_EXTENSION typedef signed __int128 fiat_p192_int128;
FIAT_EXTENSION typedef unsigned __int128 fiat_p192_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_p192_addcarryx_u48 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^48
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^48⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p192_addcarryx_u48(uint64_t* out1, fiat_p192_uint1* out2, fiat_p192_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1 = ((arg1 + arg2) + arg3);
  uint64_t x2 = (x1 & UINT64_C(0xffffffffffff));
  fiat_p192_uint1 x3 = (fiat_p192_uint1)(x1 >> 48);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p192_subborrowx_u48 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^48
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^48⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_p192_subborrowx_u48(uint64_t* out1, fiat_p192_uint1* out2, fiat_p192_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
  fiat_p192_int1 x2 = (fiat_p192_int1)(x1 >> 48);
  uint64_t x3 = (x1 & UINT64_C(0xffffffffffff));
  *out1 = x3;
  *out2 = (fiat_p192_uint1)(0x0 - x2);
}

/*
 * The function fiat_p192_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_p192_cmovznz_u64(uint64_t* out1, fiat_p192_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_p192_uint1 x1 = (!(!arg1));
  uint64_t x2 = ((fiat_p192_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  uint64_t x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p192_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 *   arg2: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 */
static void fiat_p192_carry_mul(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  fiat_p192_uint128 x1 = ((fiat_p192_uint128)(arg1[3]) * (arg2[3]));
  fiat_p192_uint128 x2 = ((fiat_p192_uint128)(arg1[3]) * (arg2[2]));
  fiat_p192_uint128 x3 = ((fiat_p192_uint128)(arg1[3]) * (arg2[1]));
  fiat_p192_uint128 x4 = ((fiat_p192_uint128)(arg1[2]) * (arg2[3]));
  fiat_p192_uint128 x5 = ((fiat_p192_uint128)(arg1[2]) * (arg2[2]));
  fiat_p192_uint128 x6 = ((fiat_p192_uint128)(arg1[1]) * (arg2[3]));
  fiat_p192_uint128 x7 = (((fiat_p192_uint128)(arg1[3]) * (arg2[3])) << 16);
  fiat_p192_uint128 x8 = (((fiat_p192_uint128)(arg1[3]) * (arg2[2])) << 16);
  fiat_p192_uint128 x9 = (((fiat_p192_uint128)(arg1[3]) * (arg2[1])) << 16);
  fiat_p192_uint128 x10 = (((fiat_p192_uint128)(arg1[2]) * (arg2[3])) << 16);
  fiat_p192_uint128 x11 = (((fiat_p192_uint128)(arg1[2]) * (arg2[2])) << 16);
  fiat_p192_uint128 x12 = (((fiat_p192_uint128)(arg1[1]) * (arg2[3])) << 16);
  fiat_p192_uint128 x13 = ((fiat_p192_uint128)(arg1[3]) * (arg2[0]));
  fiat_p192_uint128 x14 = ((fiat_p192_uint128)(arg1[2]) * (arg2[1]));
  fiat_p192_uint128 x15 = ((fiat_p192_uint128)(arg1[2]) * (arg2[0]));
  fiat_p192_uint128 x16 = ((fiat_p192_uint128)(arg1[1]) * (arg2[2]));
  fiat_p192_uint128 x17 = ((fiat_p192_uint128)(arg1[1]) * (arg2[1]));
  fiat_p192_uint128 x18 = ((fiat_p192_uint128)(arg1[1]) * (arg2[0]));
  fiat_p192_uint128 x19 = ((fiat_p192_uint128)(arg1[0]) * (arg2[3]));
  fiat_p192_uint128 x20 = ((fiat_p192_uint128)(arg1[0]) * (arg2[2]));
  fiat_p192_uint128 x21 = ((fiat_p192_uint128)(arg1[0]) * (arg2[1]));
  fiat_p192_uint128 x22 = ((fiat_p192_uint128)(arg1[0]) * (arg2[0]));
  fiat_p192_uint128 x23 = (x22 + (x6 + (x5 + x3)));
  uint64_t x24 = (uint64_t)(x23 >> 48);
  uint64_t x25 = (uint64_t)(x23 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x26 = (x19 + (x16 + (x14 + (x13 + x7))));
  fiat_p192_uint128 x27 = (x20 + (x17 + (x15 + (x10 + (x8 + x1)))));
  fiat_p192_uint128 x28 = (x21 + (x18 + (x12 + (x11 + (x9 + (x4 + x2))))));
  fiat_p192_uint128 x29 = (x24 + x28);
  fiat_p192_uint128 x30 = (x26 >> 48);
  uint64_t x31 = (uint64_t)(x26 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x32 = (x30 << 16);
  fiat_p192_uint128 x33 = (x29 + x32);
  fiat_p192_uint128 x34 = (x33 >> 48);
  uint64_t x35 = (uint64_t)(x33 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x36 = (x25 + x30);
  fiat_p192_uint128 x37 = (x34 + x27);
  uint64_t x38 = (uint64_t)(x36 >> 48);
  uint64_t x39 = (uint64_t)(x36 & UINT64_C(0xffffffffffff));
  uint64_t x40 = (x38 + x35);
  fiat_p192_uint128 x41 = (x37 >> 48);
  uint64_t x42 = (uint64_t)(x37 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x43 = (x41 + x31);
  uint64_t x44 = (uint64_t)(x43 >> 48);
  uint64_t x45 = (uint64_t)(x43 & UINT64_C(0xffffffffffff));
  uint64_t x46 = (x44 << 16);
  uint64_t x47 = (x40 + x46);
  fiat_p192_uint1 x48 = (fiat_p192_uint1)(x47 >> 48);
  uint64_t x49 = (x47 & UINT64_C(0xffffffffffff));
  uint64_t x50 = (x39 + x44);
  uint64_t x51 = (x48 + x42);
  fiat_p192_uint1 x52 = (fiat_p192_uint1)(x50 >> 48);
  uint64_t x53 = (x50 & UINT64_C(0xffffffffffff));
  uint64_t x54 = (x52 + x49);
  out1[0] = x53;
  out1[1] = x54;
  out1[2] = x51;
  out1[3] = x45;
}

/*
 * The function fiat_p192_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 */
static void fiat_p192_carry_square(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1 = (arg1[3]);
  uint64_t x2 = (arg1[3]);
  uint64_t x3 = (x1 * (uint64_t)0x2);
  uint64_t x4 = (x2 * (uint64_t)0x2);
  uint64_t x5 = ((arg1[3]) * (uint64_t)0x2);
  uint64_t x6 = (arg1[2]);
  uint64_t x7 = (arg1[2]);
  uint64_t x8 = ((arg1[2]) * (uint64_t)0x2);
  uint64_t x9 = ((arg1[1]) * (uint64_t)0x2);
  fiat_p192_uint128 x10 = ((fiat_p192_uint128)(arg1[3]) * x2);
  fiat_p192_uint128 x11 = (((fiat_p192_uint128)(arg1[3]) * x1) << 16);
  fiat_p192_uint128 x12 = ((fiat_p192_uint128)(arg1[2]) * x4);
  fiat_p192_uint128 x13 = (((fiat_p192_uint128)(arg1[2]) * x3) << 16);
  fiat_p192_uint128 x14 = ((fiat_p192_uint128)(arg1[2]) * x7);
  fiat_p192_uint128 x15 = (((fiat_p192_uint128)(arg1[2]) * x6) << 16);
  fiat_p192_uint128 x16 = ((fiat_p192_uint128)(arg1[1]) * x4);
  fiat_p192_uint128 x17 = (((fiat_p192_uint128)(arg1[1]) * x3) << 16);
  fiat_p192_uint128 x18 = ((fiat_p192_uint128)(arg1[1]) * x8);
  fiat_p192_uint128 x19 = ((fiat_p192_uint128)(arg1[1]) * (arg1[1]));
  fiat_p192_uint128 x20 = ((fiat_p192_uint128)(arg1[0]) * x5);
  fiat_p192_uint128 x21 = ((fiat_p192_uint128)(arg1[0]) * x8);
  fiat_p192_uint128 x22 = ((fiat_p192_uint128)(arg1[0]) * x9);
  fiat_p192_uint128 x23 = ((fiat_p192_uint128)(arg1[0]) * (arg1[0]));
  fiat_p192_uint128 x24 = (x23 + (x16 + x14));
  uint64_t x25 = (uint64_t)(x24 >> 48);
  uint64_t x26 = (uint64_t)(x24 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x27 = (x20 + (x18 + x11));
  fiat_p192_uint128 x28 = (x21 + (x19 + (x13 + x10)));
  fiat_p192_uint128 x29 = (x22 + (x17 + (x15 + x12)));
  fiat_p192_uint128 x30 = (x25 + x29);
  fiat_p192_uint128 x31 = (x27 >> 48);
  uint64_t x32 = (uint64_t)(x27 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x33 = (x31 << 16);
  fiat_p192_uint128 x34 = (x30 + x33);
  fiat_p192_uint128 x35 = (x34 >> 48);
  uint64_t x36 = (uint64_t)(x34 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x37 = (x26 + x31);
  fiat_p192_uint128 x38 = (x35 + x28);
  uint64_t x39 = (uint64_t)(x37 >> 48);
  uint64_t x40 = (uint64_t)(x37 & UINT64_C(0xffffffffffff));
  uint64_t x41 = (x39 + x36);
  fiat_p192_uint128 x42 = (x38 >> 48);
  uint64_t x43 = (uint64_t)(x38 & UINT64_C(0xffffffffffff));
  fiat_p192_uint128 x44 = (x42 + x32);
  uint64_t x45 = (uint64_t)(x44 >> 48);
  uint64_t x46 = (uint64_t)(x44 & UINT64_C(0xffffffffffff));
  uint64_t x47 = (x45 << 16);
  uint64_t x48 = (x41 + x47);
  fiat_p192_uint1 x49 = (fiat_p192_uint1)(x48 >> 48);
  uint64_t x50 = (x48 & UINT64_C(0xffffffffffff));
  uint64_t x51 = (x40 + x45);
  uint64_t x52 = (x49 + x43);
  fiat_p192_uint1 x53 = (fiat_p192_uint1)(x51 >> 48);
  uint64_t x54 = (x51 & UINT64_C(0xffffffffffff));
  uint64_t x55 = (x53 + x50);
  out1[0] = x54;
  out1[1] = x55;
  out1[2] = x52;
  out1[3] = x46;
}

/*
 * The function fiat_p192_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 */
static void fiat_p192_carry(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1 = (arg1[0]);
  uint64_t x2 = (arg1[3]);
  uint64_t x3 = (x2 >> 48);
  uint64_t x4 = (((x1 >> 48) + (arg1[1])) + (x3 << 16));
  uint64_t x5 = ((x1 & UINT64_C(0xffffffffffff)) + x3);
  uint64_t x6 = ((x4 >> 48) + (arg1[2]));
  uint64_t x7 = ((x6 >> 48) + (x2 & UINT64_C(0xffffffffffff)));
  fiat_p192_uint1 x8 = (fiat_p192_uint1)(x7 >> 48);
  uint64_t x9 = (((fiat_p192_uint1)(x5 >> 48) + (x4 & UINT64_C(0xffffffffffff))) + ((uint64_t)x8 << 16));
  uint64_t x10 = ((x5 & UINT64_C(0xffffffffffff)) + (uint64_t)x8);
  uint64_t x11 = (x10 & UINT64_C(0xffffffffffff));
  uint64_t x12 = ((fiat_p192_uint1)(x10 >> 48) + (x9 & UINT64_C(0xffffffffffff)));
  uint64_t x13 = ((fiat_p192_uint1)(x9 >> 48) + (x6 & UINT64_C(0xffffffffffff)));
  uint64_t x14 = (x7 & UINT64_C(0xffffffffffff));
  out1[0] = x11;
  out1[1] = x12;
  out1[2] = x13;
  out1[3] = x14;
}

/*
 * The function fiat_p192_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 *   arg2: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 */
static void fiat_p192_add(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  uint64_t x1 = ((arg1[0]) + (arg2[0]));
  uint64_t x2 = ((arg1[1]) + (arg2[1]));
  uint64_t x3 = ((arg1[2]) + (arg2[2]));
  uint64_t x4 = ((arg1[3]) + (arg2[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/*
 * The function fiat_p192_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 *   arg2: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 */
static void fiat_p192_sub(uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
  uint64_t x1 = ((UINT64_C(0x1fffffffffffe) + (arg1[0])) - (arg2[0]));
  uint64_t x2 = ((UINT64_C(0x1fffffffdfffe) + (arg1[1])) - (arg2[1]));
  uint64_t x3 = ((UINT64_C(0x1fffffffffffe) + (arg1[2])) - (arg2[2]));
  uint64_t x4 = ((UINT64_C(0x1fffffffffffe) + (arg1[3])) - (arg2[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/*
 * The function fiat_p192_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb], [0x0 ~> 0x34ccccccccccb]]
 */
static void fiat_p192_opp(uint64_t out1[4], const uint64_t arg1[4]) {
  uint64_t x1 = (UINT64_C(0x1fffffffffffe) - (arg1[0]));
  uint64_t x2 = (UINT64_C(0x1fffffffdfffe) - (arg1[1]));
  uint64_t x3 = (UINT64_C(0x1fffffffffffe) - (arg1[2]));
  uint64_t x4 = (UINT64_C(0x1fffffffffffe) - (arg1[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/*
 * The function fiat_p192_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_p192_selectznz(uint64_t out1[4], fiat_p192_uint1 arg1, const uint64_t arg2[4], const uint64_t arg3[4]) {
  uint64_t x1;
  fiat_p192_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  uint64_t x2;
  fiat_p192_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  uint64_t x3;
  fiat_p192_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  uint64_t x4;
  fiat_p192_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/*
 * The function fiat_p192_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..23]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p192_to_bytes(uint8_t out1[24], const uint64_t arg1[4]) {
  uint64_t x1;
  fiat_p192_uint1 x2;
  fiat_p192_subborrowx_u48(&x1, &x2, 0x0, (arg1[0]), UINT64_C(0xffffffffffff));
  uint64_t x3;
  fiat_p192_uint1 x4;
  fiat_p192_subborrowx_u48(&x3, &x4, x2, (arg1[1]), UINT64_C(0xfffffffeffff));
  uint64_t x5;
  fiat_p192_uint1 x6;
  fiat_p192_subborrowx_u48(&x5, &x6, x4, (arg1[2]), UINT64_C(0xffffffffffff));
  uint64_t x7;
  fiat_p192_uint1 x8;
  fiat_p192_subborrowx_u48(&x7, &x8, x6, (arg1[3]), UINT64_C(0xffffffffffff));
  uint64_t x9;
  fiat_p192_cmovznz_u64(&x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
  uint64_t x10;
  fiat_p192_uint1 x11;
  fiat_p192_addcarryx_u48(&x10, &x11, 0x0, x1, (x9 & UINT64_C(0xffffffffffff)));
  uint64_t x12;
  fiat_p192_uint1 x13;
  fiat_p192_addcarryx_u48(&x12, &x13, x11, x3, (x9 & UINT64_C(0xfffffffeffff)));
  uint64_t x14;
  fiat_p192_uint1 x15;
  fiat_p192_addcarryx_u48(&x14, &x15, x13, x5, (x9 & UINT64_C(0xffffffffffff)));
  uint64_t x16;
  fiat_p192_uint1 x17;
  fiat_p192_addcarryx_u48(&x16, &x17, x15, x7, (x9 & UINT64_C(0xffffffffffff)));
  uint64_t x18 = (x10 >> 8);
  uint8_t x19 = (uint8_t)(x10 & UINT8_C(0xff));
  uint64_t x20 = (x18 >> 8);
  uint8_t x21 = (uint8_t)(x18 & UINT8_C(0xff));
  uint64_t x22 = (x20 >> 8);
  uint8_t x23 = (uint8_t)(x20 & UINT8_C(0xff));
  uint64_t x24 = (x22 >> 8);
  uint8_t x25 = (uint8_t)(x22 & UINT8_C(0xff));
  uint8_t x26 = (uint8_t)(x24 >> 8);
  uint8_t x27 = (uint8_t)(x24 & UINT8_C(0xff));
  uint8_t x28 = (uint8_t)(x26 & UINT8_C(0xff));
  uint64_t x29 = (x12 >> 8);
  uint8_t x30 = (uint8_t)(x12 & UINT8_C(0xff));
  uint64_t x31 = (x29 >> 8);
  uint8_t x32 = (uint8_t)(x29 & UINT8_C(0xff));
  uint64_t x33 = (x31 >> 8);
  uint8_t x34 = (uint8_t)(x31 & UINT8_C(0xff));
  uint64_t x35 = (x33 >> 8);
  uint8_t x36 = (uint8_t)(x33 & UINT8_C(0xff));
  uint8_t x37 = (uint8_t)(x35 >> 8);
  uint8_t x38 = (uint8_t)(x35 & UINT8_C(0xff));
  uint8_t x39 = (uint8_t)(x37 & UINT8_C(0xff));
  uint64_t x40 = (x14 >> 8);
  uint8_t x41 = (uint8_t)(x14 & UINT8_C(0xff));
  uint64_t x42 = (x40 >> 8);
  uint8_t x43 = (uint8_t)(x40 & UINT8_C(0xff));
  uint64_t x44 = (x42 >> 8);
  uint8_t x45 = (uint8_t)(x42 & UINT8_C(0xff));
  uint64_t x46 = (x44 >> 8);
  uint8_t x47 = (uint8_t)(x44 & UINT8_C(0xff));
  uint8_t x48 = (uint8_t)(x46 >> 8);
  uint8_t x49 = (uint8_t)(x46 & UINT8_C(0xff));
  uint8_t x50 = (uint8_t)(x48 & UINT8_C(0xff));
  uint64_t x51 = (x16 >> 8);
  uint8_t x52 = (uint8_t)(x16 & UINT8_C(0xff));
  uint64_t x53 = (x51 >> 8);
  uint8_t x54 = (uint8_t)(x51 & UINT8_C(0xff));
  uint64_t x55 = (x53 >> 8);
  uint8_t x56 = (uint8_t)(x53 & UINT8_C(0xff));
  uint64_t x57 = (x55 >> 8);
  uint8_t x58 = (uint8_t)(x55 & UINT8_C(0xff));
  uint8_t x59 = (uint8_t)(x57 >> 8);
  uint8_t x60 = (uint8_t)(x57 & UINT8_C(0xff));
  out1[0] = x19;
  out1[1] = x21;
  out1[2] = x23;
  out1[3] = x25;
  out1[4] = x27;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
  out1[8] = x34;
  out1[9] = x36;
  out1[10] = x38;
  out1[11] = x39;
  out1[12] = x41;
  out1[13] = x43;
  out1[14] = x45;
  out1[15] = x47;
  out1[16] = x49;
  out1[17] = x50;
  out1[18] = x52;
  out1[19] = x54;
  out1[20] = x56;
  out1[21] = x58;
  out1[22] = x60;
  out1[23] = x59;
}

/*
 * The function fiat_p192_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999], [0x0 ~> 0x1199999999999]]
 */
static void fiat_p192_from_bytes(uint64_t out1[4], const uint8_t arg1[24]) {
  uint64_t x1 = ((uint64_t)(arg1[23]) << 40);
  uint64_t x2 = ((uint64_t)(arg1[22]) << 32);
  uint64_t x3 = ((uint64_t)(arg1[21]) << 24);
  uint64_t x4 = ((uint64_t)(arg1[20]) << 16);
  uint64_t x5 = ((uint64_t)(arg1[19]) << 8);
  uint8_t x6 = (arg1[18]);
  uint64_t x7 = ((uint64_t)(arg1[17]) << 40);
  uint64_t x8 = ((uint64_t)(arg1[16]) << 32);
  uint64_t x9 = ((uint64_t)(arg1[15]) << 24);
  uint64_t x10 = ((uint64_t)(arg1[14]) << 16);
  uint64_t x11 = ((uint64_t)(arg1[13]) << 8);
  uint8_t x12 = (arg1[12]);
  uint64_t x13 = ((uint64_t)(arg1[11]) << 40);
  uint64_t x14 = ((uint64_t)(arg1[10]) << 32);
  uint64_t x15 = ((uint64_t)(arg1[9]) << 24);
  uint64_t x16 = ((uint64_t)(arg1[8]) << 16);
  uint64_t x17 = ((uint64_t)(arg1[7]) << 8);
  uint8_t x18 = (arg1[6]);
  uint64_t x19 = ((uint64_t)(arg1[5]) << 40);
  uint64_t x20 = ((uint64_t)(arg1[4]) << 32);
  uint64_t x21 = ((uint64_t)(arg1[3]) << 24);
  uint64_t x22 = ((uint64_t)(arg1[2]) << 16);
  uint64_t x23 = ((uint64_t)(arg1[1]) << 8);
  uint8_t x24 = (arg1[0]);
  uint64_t x25 = (x24 + (x23 + (x22 + (x21 + (x20 + x19)))));
  uint64_t x26 = (x25 & UINT64_C(0xffffffffffff));
  uint64_t x27 = (x6 + (x5 + (x4 + (x3 + (x2 + x1)))));
  uint64_t x28 = (x12 + (x11 + (x10 + (x9 + (x8 + x7)))));
  uint64_t x29 = (x18 + (x17 + (x16 + (x15 + (x14 + x13)))));
  uint64_t x30 = (x29 & UINT64_C(0xffffffffffff));
  uint64_t x31 = (x28 & UINT64_C(0xffffffffffff));
  out1[0] = x26;
  out1[1] = x30;
  out1[2] = x31;
  out1[3] = x27;
}
