/* Copyright (c) 2017 Pieter Wuille
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef _BCRYPTO_BECH32_H
#define _BCRYPTO_BECH32_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

int
bcrypto_bech32_serialize(char *output,
                         const char *hrp,
                         const uint8_t *data,
                         size_t data_len);

int
bcrypto_bech32_deserialize(char *hrp,
                           uint8_t *data,
                           size_t *data_len,
                           const char *input);

int
bcrypto_bech32_is(const char *str);

int
bcrypto_bech32_convert_bits(uint8_t *out,
                            size_t *outlen,
                            int outbits,
                            const uint8_t *in,
                            size_t inlen,
                            int inbits,
                            int pad);

int
bcrypto_bech32_encode(char *output,
                      const char *hrp,
                      int ver,
                      const uint8_t *prog,
                      size_t prog_len);

int
bcrypto_bech32_decode(int *ver,
                      uint8_t *prog,
                      size_t *prog_len,
                      char *hrp,
                      const char *addr);

int
bcrypto_bech32_test(const char *addr);

#ifdef __cplusplus
}
#endif

#endif
