# Copyright (c) 2013, The MITRE Corporation
# Copyright (c) 2010-2014, Cuckoo Developers
# All rights reserved.

# This file is part of Cuckoo Sandbox - http://www.cuckoosandbox.org
# See the file "docs/LICENSE" for copying permission.

from modules.processing.behavior import fix_key

api_call_mappings = {
"NtCreateFile" : {"action_name" : "create file",
                          "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                          "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                                    "associated_object_element" : "ID",
                                                                                                      "association_type" : "output",
                                                                                                      "forced" : {"associated_object_element" : "Type", 
                                                                                                                  "value" : "File"}},
                                                                              "FileName" : {"associated_object_type" : "FileObjectType",
                                                                                                "associated_object_element" : "File_Path",
                                                                                                "association_type" : "output"}}},
"NtOpenFile" : {"action_name" : "open file",
                "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "File"}},
                                                  "FileName" : {"associated_object_type" : "FileObjectType",
                                                                "associated_object_element" : "File_Path",
                                                                "association_type" : "input"}}},
"NtReadFile" : {"action_name" : "read from file",
                "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "input",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "File"}}}},
"NtWriteFile" : {"action_name" : "write to file",
                 "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                 "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                   "associated_object_element" : "ID",
                                                                   "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                                "value" : "File"}}}},
"NtDeleteFile" : {"action_name" : "delete file",
                  "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                  "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "FileObjectType",
                                                                  "associated_object_element" : "File_Path",
                                                                  "association_type" : "input"}}},
"NtDeviceIoControlFile" : {"action_name" : "send control code to file",
                           "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                           "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "File"}}}},
"NtQueryDirectoryFile" : {"action_name" : "find file",
                          "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                          "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "File"}},
                                                            "FileName" : {"associated_object_type" : "FileObjectType",
                                                                          "associated_object_element" : "File_Path",
                                                                          "association_type" : "input"}}},
"NtQueryInformationFile" : {"action_name" : "get file attributes",
                            "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                            "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                           "value" : "File"}}}},
"NtSetInformationFile" : {"action_name" : "set file attributes",
                          "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                          "parameter_associated_objects" : {"FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "File"}}}},
"NtCreateDirectoryObject" : {"action_name" : "create directory",
                             "action_vocab" : "maecVocabs:DirectoryActionNameVocab-1.0",
                             "parameter_associated_objects" : {"DirectoryHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                    "associated_object_element" : "ID",
                                                                                    "association_type" : "output",
                                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                                    "value" : "File"}}}},
"CreateDirectoryW" : {"action_name" : "create directory",
                      "action_vocab" : "maecVocabs:DirectoryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"DirectoryName" : {"associated_object_type" : "FileObjectType",
                                                                           "associated_object_element" : "File_Path",
                                                                           "association_type" : "output"}}},
"CreateDirectoryExW" : {"action_name" : "create directory",
                        "action_vocab" : "maecVocabs:DirectoryActionNameVocab-1.0",
                        "parameter_associated_objects" : {"DirectoryName" : {"associated_object_type" : "FileObjectType",
                                                                             "associated_object_element" : "File_Path",
                                                                             "association_type" : "output"}}},
"RemoveDirectoryA" : {"action_name" : "delete directory",
                      "action_vocab" : "maecVocabs:DirectoryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"DirectoryName" : {"associated_object_type" : "FileObjectType",
                                                                           "associated_object_element" : "File_Path",
                                                                           "association_type" : "input"}}},
"RemoveDirectoryW" : {"action_name" : "delete directory",
                      "action_vocab" : "maecVocabs:DirectoryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"DirectoryName" : {"associated_object_type" : "FileObjectType",
                                                                           "associated_object_element" : "File_Path",
                                                                           "association_type" : "input"}}},
"MoveFileWithProgressW" : {"action_name" : "move file",
                           "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                           "parameter_associated_objects" : {"ExistingFileName" : {"associated_object_type" : "FileObjectType",
                                                                                   "associated_object_element" : "File_Path",
                                                                                   "association_type" : "input"},
                                                             "NewFileName" : {"associated_object_type" : "FileObjectType",
                                                                              "associated_object_element" : "File_Path",
                                                                              "association_type" : "output"}}},
"FindFirstFileExA" : {"action_name" : "find file",
                      "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                      "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "FileObjectType",
                                                                      "associated_object_element" : "File_Path",
                                                                      "association_type" : "input"}}},
"FindFirstFileExW" : {"action_name" : "find file",
                      "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                      "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "FileObjectType",
                                                                      "associated_object_element" : "File_Path",
                                                                      "association_type" : "input"}}},
"CopyFileA" : {"action_name" : "copy file",
               "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
               "parameter_associated_objects" : {"ExistingFileName" : {"associated_object_type" : "FileObjectType",
                                                                       "associated_object_element" : "File_Path",
                                                                       "association_type" : "input"},
                                                 "NewFileName" : {"associated_object_type" : "FileObjectType",
                                                                  "associated_object_element" : "File_Path",
                                                                  "association_type" : "output"}}},
"CopyFileW" : {"action_name" : "copy file",
               "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
               "parameter_associated_objects" : {"ExistingFileName" : {"associated_object_type" : "FileObjectType",
                                                                       "associated_object_element" : "File_Path",
                                                                       "association_type" : "input"},
                                                 "NewFileName" : {"associated_object_type" : "FileObjectType",
                                                                  "associated_object_element" : "File_Path",
                                                                  "association_type" : "output"}}},
"CopyFileExW" : {"action_name" : "copy file",
                 "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                 "parameter_associated_objects" : {"ExistingFileName" : {"associated_object_type" : "FileObjectType",
                                                                         "associated_object_element" : "File_Path",
                                                                         "association_type" : "input"},
                                                   "NewFileName" : {"associated_object_type" : "FileObjectType",
                                                                    "associated_object_element" : "File_Path",
                                                                    "association_type" : "output"}}},
"DeleteFileA" : {"action_name" : "delete file",
                 "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                 "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "FileObjectType",
                                                                 "associated_object_element" : "File_Path",
                                                                 "association_type" : "input"}}},
"DeleteFileW" : {"action_name" : "delete file",
                 "action_vocab" : "maecVocabs:FileActionNameVocab-1.0",
                 "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "FileObjectType",
                                                                 "associated_object_element" : "File_Path",
                                                                 "association_type" : "input"}}},
"RegOpenKeyExA" : {"action_name" : "open registry key",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Registry" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                   "associated_object_element" : "Hive",
                                                                   "association_type" : "input",
                                                                   "post_processing" : "hiveHexToString"},
                                                     "SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "input",},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together" : ["Registry", "SubKey"]}},
"RegOpenKeyExW" : {"action_name" : "open registry key",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Registry" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                   "associated_object_element" : "Hive",
                                                                   "association_type" : "input",
                                                                   "post_processing" : "hiveHexToString"},
                                                     "SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "input",},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together" : ["Registry", "SubKey"]}},
"RegCreateKeyExA" : {"action_name" : "create registry key",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"Registry" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                   "associated_object_element" : "Hive",
                                                                   "association_type" : "output",
                                                                   "post_processing" : "hiveHexToString"},
                                                     "SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "output"},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together" : ["Registry", "SubKey"]}},
"RegCreateKeyExW" : {"action_name" : "create registry key",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"Registry" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                   "associated_object_element" : "Hive",
                                                                   "association_type" : "output",
                                                                   "post_processing" : "hiveHexToString"},
                                                     "SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "output"},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together" : ["Registry", "SubKey"]}},
"RegDeleteKeyA" : {"action_name" : "delete registry key",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "input"},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "input",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegDeleteKeyW" : {"action_name" : "delete registry key",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"SubKey" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                 "associated_object_element" : "Key",
                                                                 "association_type" : "input"},
                                                     "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "input",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegEnumKeyW" : {"action_name" : "enumerate registry key subkeys",
                 "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                 "parameter_associated_objects" : {"Name" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                            "associated_object_element" : "Key",
                                                            "association_type" : "output"},
                                                  "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                              "associated_object_element" : "ID",
                                                              "association_type" : "input",
                                                              "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegEnumKeyExA" : {"action_name" : "enumerate registry key subkeys",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Name" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                              "associated_object_element" : "Key",
                                                              "association_type" : "output"},
                                                    "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegEnumKeyExW" : {"action_name" : "enumerate registry key subkeys",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Name" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                              "associated_object_element" : "Key",
                                                              "association_type" : "output"},
                                                    "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegEnumValueA" : {"action_name" : "enumerate registry key values",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                    "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ValueName", "element_name" : "Name"},
                                                                                                       {"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                        "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Data", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegEnumValueW" : {"action_name" : "enumerate registry key values",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                    "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ValueName", "element_name" : "Name"},
                                                                                                       {"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                        "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Data", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegSetValueExA" : {"action_name" : "modify registry key value",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                    "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ValueName", "element_name" : "Name"},
                                                                                                       {"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                        "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Buffer", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegSetValueExW" : {"action_name" : "modify registry key value",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                    "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ValueName", "element_name" : "Name"},
                                                                                                       {"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                        "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Buffer", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegQueryValueExA" : {"action_name" : "read registry key value",
                      "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                       "associated_object_element" : "Values/list__Name",
                                                                       "association_type" : "input"},
                                                        "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                        "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                            "post_processing":"regDatatypeToString"},
                                                                                                           {"parameter_name" : "Data", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegQueryValueExW" : {"action_name" : "read registry key value",
                      "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                       "associated_object_element" : "Values/list__Name",
                                                                       "association_type" : "input"},
                                                        "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                        "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                            "post_processing":"regDatatypeToString"},
                                                                                                           {"parameter_name" : "Data", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"RegDeleteValueA" : {"action_name" : "delete registry key value",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                       "associated_object_element" : "Values/list__Name",
                                                                       "association_type" : "input"},
                                                        "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegDeleteValueW" : {"action_name" : "delete registry key value",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                       "associated_object_element" : "Values/list__Name",
                                                                       "association_type" : "input"},
                                                        "Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegQueryInfoKeyA" : {"action_name" : "get registry key attributes",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegQueryInfoKeyW" : {"action_name" : "get registry key attributes",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"RegCloseKey" : {"action_name" : "close registry key",
                 "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                 "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtCreateKey" : {"action_name" : "create registry key",
                 "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                 "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ObjectAttributes", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "ObjectAttributes", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "output"},
                                                   "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtOpenKey" : {"action_name" : "open registry key",
               "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
               "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ObjectAttributes", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "ObjectAttributes", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                  "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "output",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtOpenKeyEx" : {"action_name" : "open registry key",
               "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
               "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ObjectAttributes", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "ObjectAttributes", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                  "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "output",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtRenameKey" : {"action_name" : "rename registry key",
                 "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "NewName", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "NewName", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                  "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtReplaceKey" : {"action_name" : "save hive key to file",
                  "parameter_associated_objects" : {"NewHiveFileName" : {"associated_object_type" : "FileObjectType",
                                                                         "associated_object_element" : "File_Path",
                                                                         "association_type" : "output"},
                                                  "OldHiveFileName" : {"associated_object_type" : "FileObjectType",
                                                                       "associated_object_element" : "File_Path",
                                                                       "association_type" : "input"},
                                                  "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtEnumerateKey" : {"action_name" : "enumerate registry key subkeys",
                    "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                    "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                              "associated_object_element" : "ID",
                                                              "association_type" : "input",
                                                              "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtEnumerateValueKey" : {"action_name" : "enumerate registry key values",
                         "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                         "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                          "associated_object_element" : "ID",
                                                                          "association_type" : "input",
                                                                          "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtSetValueKey" : {"action_name" : "modify registry key value",
                   "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ValueName", "element_name" : "Name"},
                                                                                                       {"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                        "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Buffer", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"NtQueryValueKey" : {"action_name" : "read registry key value",
                     "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                     "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                      "associated_object_element" : "Values/list__Name",
                                                                      "association_type" : "input"},
                                                        "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}},
                                                     "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Type", "element_name" : "Datatype",
                                                                                                         "post_processing":"regDatatypeToString"},
                                                                                                       {"parameter_name" : "Information", "element_name" : "Data"}],
                                                                                   "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                   "associated_object_element" : "Values/list__",
                                                                                   "association_type" : "output"}}},
"NtQueryMultipleValueKey" : {"action_name" : "read registry key value",
                             "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                             "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                              "associated_object_element" : "Values/list__Name",
                                                                              "association_type" : "input"},
                                                               "ValueBuffer" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                                "associated_object_element" : "Values/list__Data",
                                                                                "association_type" : "output"},
                                                               "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtDeleteKey" : {"action_name" : "delete registry key",
                 "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                 "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "input",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtDeleteValueKey" : {"action_name" : "delete registry key value",
                      "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ValueName" : {"associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                       "associated_object_element" : "Values/list__Name",
                                                                       "association_type" : "input"},
                                                        "KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtLoadKey" : {"action_name" : "load registry keys from file",
               "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "TargetKey", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "TargetKey", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                 "SourceFile" : {"associated_object_type" : "FileObjectType",
                                                                 "associated_object_element" : "File_Path",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtLoadKey2" : {"action_name" : "load registry keys from file",
                "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "TargetKey", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "TargetKey", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                 "SourceFile" : {"associated_object_type" : "FileObjectType",
                                                                 "associated_object_element" : "File_Path",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtLoadKeyEx" : {"action_name" : "load registry keys from file",
                 "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "TargetKey", "element_name" : "Hive",
                                                                                                     "post_processing": "regStringToHive"},
                                                                                                    {"parameter_name" : "TargetKey", "element_name" : "Key",
                                                                                                     "post_processing":"regStringToKey"}],
                                                                            "associated_object_type" : "WindowsRegistryKeyObjectType",
                                                                            "association_type" : "input"},
                                                  "SourceFile" : {"associated_object_type" : "FileObjectType",
                                                                  "associated_object_element" : "File_Path",
                                                                  "association_type" : "input",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtQueryKey" : {"action_name" : "get registry key attributes",
                "action_vocab" : "maecVocabs:RegistryActionNameVocab-1.0",
                "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtSaveKey" : {"action_name" : "save registry key subtree to file",
               "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input"},
                                                 "FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                 "associated_object_element" : "ID",
                                                                 "association_type" : "input",
                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "RegistryKey"}}}},
"NtSaveKeyEx" : {"action_name" : "save registry key subtree to file",
                 "parameter_associated_objects" : {"KeyHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "input"},
                                                   "FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                   "associated_object_element" : "ID",
                                                                   "association_type" : "input",
                                                                   "forced" : {"associated_object_element" : "Type", 
                                                                              "value" : "Process"}}}},                                                                                                                                                  
"NtCreateProcess" : {"action_name" : "create process",
                     "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                           "associated_object_element" : "ID",
                                                                           "association_type" : "output",
                                                                           "forced" : {"associated_object_element" : "Type", 
                                                                                       "value" : "Process"}},
                                                      "FileName" : {"associated_object_type" : "FileObjectType",
                                                                    "associated_object_element" : "File_Path",
                                                                    "association_type" : "input"}}},
"NtCreateProcessEx" : {"action_name" : "create process",
                       "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                       "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "output",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Process"}},
                                                      "FileName" : {"associated_object_type" : "FileObjectType",
                                                                    "associated_object_element" : "File_Path",
                                                                    "association_type" : "input"}}},
"NtCreateUserProcess" : {"action_name" : "create process",
                         "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                         "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "output",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Process"}},
                                                            "ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "output",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Thread"}},
                                                            "ThreadName" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                            "associated_object_element" : "Thread_ID",
                                                                            "association_type" : "output"},
                                                     "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ProcessFileName", "element_name" : "File_Name",},
                                                                                                       {"parameter_name" : "ImagePathName", "element_name" : "Path"}],
                                                                                   "associated_object_type" : "ProcessObjectType",
                                                                                   "associated_object_element" : "Image_Info",
                                                                                   "association_type" : "output"}}},
"RtlCreateUserProcess" : {"action_name" : "create process",
                          "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                          "parameter_associated_objects" : {"ParentProcess" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                               "associated_object_element" : "ID",
                                                                               "association_type" : "output",
                                                                               "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Process"}},
                                                            "ImagePath" : {"associated_object_type" : "ProcessObjectType",
                                                                               "associated_object_element" : "Image_Info/Path",
                                                                               "association_type" : "input"}}},
"NtOpenProcess" : {"action_name" : "open process",
                   "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                        "associated_object_element" : "ID",
                                                                        "association_type" : "output",
                                                                        "forced" : {"associated_object_element" : "Type", 
                                                                                    "value" : "Process"}},
                                                     "ProcessIdentifier" : {"associated_object_type" : "ProcessObjectType",
                                                                            "associated_object_element" : "PID",
                                                                            "association_type" : "input"}}},
"NtTerminateProcess" : {"action_name" : "kill process",
                        "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                        "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Process"}}}},
"NtCreateSection" : {"action_name" : "create section",
                     "parameter_associated_objects" : {"SectionHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                          "associated_object_element" : "ID",
                                                                          "association_type" : "output",
                                                                          "forced" : {"associated_object_element" : "Type", 
                                                                                      "value" : "Section"}},
                                                       "FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                                   "value" : "File"}}}}, 
"NtOpenSection" : {"action_name" : "open section",
                   "parameter_associated_objects" : {"SectionHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                          "associated_object_element" : "ID",
                                                                          "association_type" : "output",
                                                                          "forced" : {"associated_object_element" : "Type", 
                                                                                      "value" : "Section"}},
                                                     "ObjectAttributes" : {"associated_object_type" : "MemoryObjectType",
                                                                          "associated_object_element" : "Name",
                                                                          "association_type" : "input"}}},
"CreateProcessInternalW" : {"action_name" : "create process",
                            "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                            "parameter_associated_objects" : {"ProcessId" : {"associated_object_type" : "WindowsProcessObjectType",
                                                                             "associated_object_element" : "PID",
                                                                             "association_type" : "output"},
                                                              "ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                            "associated_object_element" : "Thread_ID",
                                                                            "association_type" : "output"},
                                                             "ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "output",
                                                                                "forced" : {"associated_object_element" : "Type",
                                                                                            "value" : "Process"}},
                                                             "ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                               "associated_object_element" : "ID",
                                                                               "association_type" : "output",
                                                                               "forced" : {"associated_object_element" : "Type", 
                                                                                           "value" : "Thread"}}},
                             "parameter_associated_arguments" : {"ApplicationName" : {"associated_argument_name" : "Application Name"}}},
"ExitProcess" : {"action_name" : "kill process",
                 "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                 "parameter_associated_arguments" : {"ExitCode" : {"associated_argument_name" : "Exit Code"}}},

"ShellExecuteExW" : {"action_name" : "create process",
                     "action_vocab" : "maecVocabs:ProcessActionNameVocab-1.0",
                     "parameter_associated_objects" : {"FilePath" : {"associated_object_type" : "FileObjectType",
                                                                     "associated_object_element" : "File_Path",
                                                                     "association_type" : "input" }}},
"NtUnmapViewOfSection" : {"action_name" : "unmap view of section",
                          "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "input",
                                                                                "forced" : {"associated_object_element" : "Type",
                                                                                            "value" : "Process"}}}},
"NtAllocateVirtualMemory" : {"action_name" : "allocate process virtual memory",
                             "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                             "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                  "associated_object_element" : "ID",
                                                                                  "association_type" : "input",
                                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                                               "value" : "Process"}}}},
"NtReadVirtualMemory" : {"action_name" : "read from process memory",
                         "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                         "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Process"}}}},
"ReadProcessMemory" : {"action_name" : "read from process memory",
                       "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                       "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Process"}}}},
"NtWriteVirtualMemory" : {"action_name" : "write to process memory",
                          "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                          "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Process"}}}},
"WriteProcessMemory" : {"action_name" : "write to process memory",
                        "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                        "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Process"}}}},
"NtProtectVirtualMemory" : {"action_name" : "modify process virtual memory protection",
                            "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                            "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                 "associated_object_element" : "ID",
                                                                                 "association_type" : "input",
                                                                                 "forced" : {"associated_object_element" : "Type", 
                                                                                             "value" : "Process"}}}},
"VirtualProtectEx" : {"action_name" : "modify process virtual memory protection",
                      "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                           "associated_object_element" : "ID",
                                                                           "association_type" : "input",
                                                                           "forced" : {"associated_object_element" : "Type", 
                                                                                       "value" : "Process"}}}},
"NtFreeVirtualMemory" : {"action_name" : "free process virtual memory",
                         "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                         "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Process"}}}},
"VirtualFreeEx" : {"action_name" : "free process virtual memory",
                   "action_vocab" : "maecVocabs:ProcessMemoryActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                        "associated_object_element" : "ID",
                                                                        "association_type" : "input",
                                                                        "forced" : {"associated_object_element" : "Type", 
                                                                                    "value" : "Process"}}}},
"FindWindowA" : {"action_name" : "find window",
                 "action_vocab" : "maecVocabs:GUIActionNameVocab-1.0",
                 "parameter_associated_objects" : {"WindowName" : {"associated_object_type" : "GUIWindowObjectType",
                                                                   "associated_object_element" : "Window_Display_Name",
                                                                   "association_type" : "input"}}},
"FindWindowW" : {"action_name" : "find window",
                 "action_vocab" : "maecVocabs:GUIActionNameVocab-1.0",
                 "parameter_associated_objects" : {"WindowName" : {"associated_object_type" : "GUIWindowObjectType",
                                                                   "associated_object_element" : "Window_Display_Name",
                                                                   "association_type" : "input"}}},
"FindWindowExA" : {"action_name" : "find window",
                   "action_vocab" : "maecVocabs:GUIActionNameVocab-1.0",
                   "parameter_associated_objects" : {"WindowName" : {"associated_object_type" : "GUIWindowObjectType",
                                                                     "associated_object_element" : "Window_Display_Name",
                                                                     "association_type" : "input"}}},
"FindWindowExW" : {"action_name" : "find window",
                   "action_vocab" : "maecVocabs:GUIActionNameVocab-1.0",
                   "parameter_associated_objects" : {"WindowName" : {"associated_object_type" : "GUIWindowObjectType",
                                                                     "associated_object_element" : "Window_Display_Name",
                                                                     "association_type" : "input"}}},
"SetWindowsHookExA" : {"action_name" : "add windows hook",
                       "action_vocab" : "maecVocabs:HookingActionNameVocab-1.0",
                       "parameter_associated_objects" : {"HookIdentifier" : {"associated_object_type" : "WindowsKernelHookObjectType",
                                                                             "associated_object_element" : "Type",
                                                                             "association_type" : "input"},
                                                         "ProcedureAddress" : {"associated_object_type" : "WindowsKernelHookObjectType",
                                                                               "associated_object_element" : "Hooking_Address",
                                                                               "association_type" : "input"},
                                                         "ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                       "associated_object_element" : "Thread_ID",
                                                                       "association_type" : "input"},
                                                         "group_together" : ["HookIdentifier", "ProcedureAddress"]}},
"SetWindowsHookExW" : {"action_name" : "add windows hook",
                       "action_vocab" : "maecVocabs:HookingActionNameVocab-1.0",
                       "parameter_associated_objects" : {"HookIdentifier" : {"associated_object_type" : "WindowsKernelHookObjectType",
                                                                             "associated_object_element" : "Type",
                                                                             "association_type" : "input"},
                                                         "ProcedureAddress" : {"associated_object_type" : "WindowsKernelHookObjectType",
                                                                               "associated_object_element" : "Hooking_Address",
                                                                               "association_type" : "input"},
                                                         "ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                       "associated_object_element" : "Thread_ID",
                                                                       "association_type" : "input"},
                                                         "group_together" : ["HookIdentifier", "ProcedureAddress"]}},
"UnhookWindowsHookEx" : {"action_name" : "remove windows hook",
                         "parameter_associated_objects" : {"HookHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                   "associated_object_element" : "ID",
                                                                                   "association_type" : "input",
                                                                                   "forced" : {"associated_object_element" : "Type", 
                                                                                               "value" : "Hook"}}}},                                       
"LdrLoadDll" : {"action_name" : "load library",
                "action_vocab" : "maecVocabs:LibraryActionNameVocab-1.0",
                "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "LibraryObjectType",
                                                                "associated_object_element" : "Name",
                                                                "association_type" : "input"},
                                                  "BaseAddress" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                   "associated_object_element" : "ID",
                                                                   "association_type" : "output",
                                                                   "forced" : {"associated_object_element" : "Type", 
                                                                               "value" : "Module"}}}},
"LdrGetDllHandle" : {"action_name" : "get dll handle",
                     "parameter_associated_objects" : {"FileName" : {"associated_object_type" : "LibraryObjectType",
                                                                     "associated_object_element" : "Name",
                                                                     "association_type" : "input"},
                                                       "ModuleHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                         "associated_object_element" : "ID",
                                                                         "association_type" : "output",
                                                                         "forced" : {"associated_object_element" : "Type", 
                                                                                     "value" : "Module"}}}},
"LdrGetProcedureAddress" : {"action_name" : "get function address",
                            "action_vocab" : "maecVocabs:LibraryActionNameVocab-1.0",
                            "parameter_associated_objects" : {"ModuleHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "input",
                                                                                "forced" : {"associated_object_element" : "Type", 
                                                                                            "value" : "Module"}},
                                                               "FunctionAddress" : {"associated_object_type" : "APIObjectType",
                                                                                    "associated_object_element" : "Address",
                                                                                    "association_type" : "output",
                                                                                    "post_processing" : "intToHex"},
                                                               "group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "FunctionName", "element_name" : "Function_Name"}, 
                                                                                                                  {"parameter_name" : "Ordinal", "element_name" : "Ordinal"}],
                                                                                            "associated_object_type" : "WindowsExecutableFileObjectType",
                                                                                            "associated_object_element" : "Exports/Exported_Functions/list__",
                                                                                            "association_type" : "input"}}},
"DeviceIoControl" : {"action_name" : "send control code to driver",
                      "parameter_associated_objects" : {"DeviceHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                          "associated_object_element" : "ID",
                                                                          "association_type" : "input",
                                                                          "forced" : {"associated_object_element" : "Type", 
                                                                                      "value" : "Device"}}},
                     "parameter_associated_arguments" : {"IoControlCode" : {"associated_argument_name" : "Control Code",
                                                                            "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"ExitWindowsEx" : {"action_name" : "shutdown system",
                   "action_vocab" : "maecVocabs:SystemActionNameVocab-1.0",
                   "parameter_associated_arguments" : {"Flags" : {"associated_argument_name" : "Flags"},
                                                       "Reason" : {"associated_argument_name" : "Reason"}}},
"IsDebuggerPresent" : {"action_name" : "check for remote debugger",
                       "action_vocab" : "maecVocabs:DebuggingActionNameVocab-1.0"},
"LookupPrivilegeValueW" : {"action_name" : "find privilege value",
                           "parameter_associated_objects" : {"SystemName" : {"associated_object_type" : "SystemObjectType",
                                                                                                             "associated_object_element" : "Hostname",
                                                                                                             "association_type" : "input"}},
                           "parameter_associated_arguments" : {"PrivilegeName" : {"associated_argument_name" : "Privilege Name"}}},
"NtClose" : {"action_name" : "close handle",
                             "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                                           "associated_object_element" : "ID",
                                                                                                           "association_type" : "input"}}},
"WriteConsoleA" : {"action_name" : "write to console",
                   "parameter_associated_objects" : {"ConsoleHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                                    "associated_object_element" : "ID",
                                                                                                    "association_type" : "input",
                                                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                                                                "value" : "Console"}}}},
"WriteConsoleW" : {"action_name" : "write to console",
                   "parameter_associated_objects" : {"ConsoleHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                                    "associated_object_element" : "ID",
                                                                                                    "association_type" : "input",
                                                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                                                                "value" : "Console"}}}},
"ZwMapViewOfSection" : {"action_name" : "map view of section",
                        "parameter_associated_objects" : {"SectionHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Section"}},
                                                          "ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Process"}}},
                        "parameter_associated_arguments" : {"BaseAddress" : {"associated_argument_name" : "Base Address",
                                                                             "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                            "SectionOffset" : {"associated_argument_name" : "Section Offset"}}},
"GetSystemMetrics" : {"action_name" : "get system metrics",
                      "parameter_associated_arguments" : {"SystemMetricIndex" : {"associated_argument_name" : "System Metric Index"}}},
"NtDelayExecution" : {"action_name" : "delay execution",
                      "parameter_associated_arguments" : {"Milliseconds" : {"associated_argument_name" : "Milliseconds"}}},
"GetLocalTime" : {"action_name" : "get system local time",
                  "action_vocab" : "maecVocabs:SystemActionNameVocab-1.0"},
"GetSystemTime" : {"action_name" : "get system time",
                   "action_vocab" : "maecVocabs:SystemActionNameVocab-1.0"},
"GetTickCount" : {"action_name" : "get tick count"},
"NtQuerySystemTime" : {"action_name" : "get system time",
                       "action_vocab" : "maecVocabs:SystemActionNameVocab-1.0"},
"WSAStartup" : {"action_name" : "initialize winsock",
                "parameter_associated_arguments" : {"VersionRequested" : {"associated_argument_name" : "Version Requested"}}},
"gethostbyname" : {"action_name" : "get host by name",
                   "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                   "parameter_associated_arguments" : {"Name" : {"associated_argument_name" : "Hostname", 
                                                                  "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"socket" : {"action_name" : "create socket",
            "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
            "parameter_associated_objects" : {"type" : {"associated_object_type" : "NetworkSocketObjectType",
                                                        "associated_object_element" : "Type",
                                                        "association_type" : "output",
                                                        "post_processing" : "socketTypeToString"},
                                              "af" : {"associated_object_type" : "NetworkSocketObjectType",
                                                      "associated_object_element" : "Address_Family",
                                                      "association_type" : "output",
                                                      "post_processing" : "socketAFToString"},
                                              "protocol" : {"associated_object_type" : "NetworkSocketObjectType",
                                                            "associated_object_element" : "Protocol",
                                                            "association_type" : "output",
                                                            "post_processing" : "socketProtoToString"},
                                              "group_together" : ["type", "protocol", "af"]}},
"connect" : {"action_name" : "connect to socket",
             "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
             "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"send" : {"action_name" : "send data on socket",
          "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
          "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                              "buffer" : {"associated_argument_name" : "Data Buffer"}}},
"sendto" : {"action_name" : "send data to address on socket",
            "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
            "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                                "buffer" : {"associated_argument_name" : "Data Buffer"}}},
"recv" : {"action_name" : "receive data on socket",
          "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
          "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                              "buffer" : {"associated_argument_name" : "Data Buffer"}}},
"recvfrom" : {"action_name" : "receive data on socket",
              "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
              "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                                  "buffer" : {"associated_argument_name" : "Data Buffer"}}},
"accept" : {"action_name" : "accept socket connection",
            "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
            "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"bind" : {"action_name" : "bind address to socket",
          "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
          "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "ip", "element_name" : "IP_Address/Address_Value"},
                                                                                               {"parameter_name" : "port", "element_name" : "Port/Port_Value"}],
                                                                       "associated_object_type" : "NetworkSocketObjectType",
                                                                       "associated_object_element" : "Local_Address",
                                                                       "association_type" : "input"}},
          "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"listen" : {"action_name" : "listen on socket",
            "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
            "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"select" : {"action_name" : "check for ready sockets",
            "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"setsockopt" : {"action_name" : "set socket option",
                "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"ioctlsocket" : {"action_name" : "send command to socket",
                 "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                                     "command" : {"associated_argument_name" : "Command"}}},
"closesocket" : {"action_name" : "close socket",
                 "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                 "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"shutdown" : {"action_name" : "disable socket operation",
              "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"},
                                                  "how" : {"associated_argument_name" : "Operation"}}},
"WSARecv" : {"action_name" : "receive data on socket",
             "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
             "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"WSARecvFrom" : {"action_name" : "receive data on socket",
                 "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                 "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"WSASend" : {"action_name" : "send data on socket",
             "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
             "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"WSASendTo" : {"action_name" : "send data on socket",
               "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
               "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"WSASocketA" : {"action_name" : "create socket",
                "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                "parameter_associated_objects" : {"type" : {"associated_object_type" : "NetworkSocketObjectType",
                                                            "associated_object_element" : "Type",
                                                            "association_type" : "output",
                                                            "post_processing" : "socketTypeToString"},
                                              "af" : {"associated_object_type" : "NetworkSocketObjectType",
                                                      "associated_object_element" : "Address_Family",
                                                      "association_type" : "output",
                                                      "post_processing" : "socketAFToString"},
                                              "protocol" : {"associated_object_type" : "NetworkSocketObjectType",
                                                            "associated_object_element" : "Protocol",
                                                            "association_type" : "output",
                                                            "post_processing" : "socketProtoToString"},
                                              "group_together" : ["type", "protocol", "af"]}},
"WSASocketW" : {"action_name" : "create socket",
                "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                "parameter_associated_objects" : {"type" : {"associated_object_type" : "NetworkSocketObjectType",
                                                            "associated_object_element" : "Type",
                                                            "association_type" : "output",
                                                            "post_processing" : "socketTypeToString"},
                                              "af" : {"associated_object_type" : "NetworkSocketObjectType",
                                                      "associated_object_element" : "Address_Family",
                                                      "association_type" : "output",
                                                      "post_processing" : "socketAFToString"},
                                              "protocol" : {"associated_object_type" : "NetworkSocketObjectType",
                                                            "associated_object_element" : "Protocol",
                                                            "association_type" : "output",
                                                            "post_processing" : "socketProtoToString"},
                                              "group_together" : ["type", "protocol", "af"]}},
"ConnectEx" : {"action_name" : "connect to socket",
               "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
               "parameter_associated_arguments" : {"socket" : {"associated_argument_name" : "Socket Descriptor"}}},
"TransmitFile" : {"action_name" : "send file over socket",
                  "parameter_associated_objects" : {"socket" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "input"},
                                                    "FileHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                    "associated_object_element" : "ID",
                                                                    "association_type" : "input",
                                                                    "forced" : {"associated_object_element" : "Type", 
                                                                                "value" : "File"}},
                                                    "NumberOfBytesToWrite" : {"associated_object_type" : "FileObjectType",
                                                                              "associated_object_element" : "Size_In_Bytes",
                                                                              "association_type" : "output"}},
                  "parameter_associated_arguments" : {"NumberOfBytesPerSend" : {"associated_argument_name" : "Send Data Block Size"}}},
"NtCreateMutant" : {"action_name" : "create mutex",
                    "action_vocab" : "maecVocabs:SynchronizationActionNameVocab-1.0",
                    "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                  "associated_object_element" : "ID",
                                                                  "association_type" : "output",
                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                                "value" : "Mutex"}},
                                                      "MutexName" : {"associated_object_type" : "WindowsMutexObjectType",
                                                                     "associated_object_element" : "Name",
                                                                     "association_type" : "output"}},
                  "parameter_associated_arguments" : {"InitialOwner" : {"associated_argument_name" : "Initial Owner"}}},
"NtOpenMutant" : {"action_name" : "open mutex",
                  "action_vocab" : "maecVocabs:SynchronizationActionNameVocab-1.0",
                  "parameter_associated_objects" : {"Handle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                "associated_object_element" : "ID",
                                                                "association_type" : "output",
                                                                "forced" : {"associated_object_element" : "Type", 
                                                                                "value" : "Mutex"}},
                                                    "MutexName" : {"associated_object_type" : "WindowsMutexObjectType",
                                                                   "associated_object_element" : "Name",
                                                                   "association_type" : "input"}}},
"NtCreateNamedPipeFile" : {"action_name" : "create named pipe",
                           "action_vocab" : "maecVocabs:IPCActionNameVocab-1.0",
                           "parameter_associated_objects" : {"NamedPipeHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                  "associated_object_element" : "ID",
                                                                                  "association_type" : "output",
                                                                                  "forced" : {"associated_object_element" : "Type", 
                                                                                              "value" : "NamedPipe"}},
                                                             "PipeName" : {"associated_object_type" : "WindowsPipeObjectType",
                                                                           "associated_object_element" : "Name",
                                                                           "association_type" : "output"}},
                           "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                                  "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                               "ShareAccess" : {"associated_argument_name" : "Share Access Mode"}}},
"OpenSCManagerA" : {"action_name" : "open service control manager",
                    "parameter_associated_objects" : {"MachineName" : {"associated_object_type" : "SystemObjectType",
                                                                       "associated_object_element" : "Hostname",
                                                                       "association_type" : "input"}},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "DatabaseName" : {"associated_argument_name" : "Database Name"}}},
"OpenSCManagerW" : {"action_name" : "open service control manager",
                    "parameter_associated_objects" : {"MachineName" : {"associated_object_type" : "SystemObjectType",
                                                                       "associated_object_element" : "Hostname",
                                                                       "association_type" : "input"}},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "DatabaseName" : {"associated_argument_name" : "Database Name"}}},
"CreateServiceA" : {"action_name" : "create service",
                    "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                    "parameter_associated_objects" : {"ServiceControlHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "input",
                                                                                "forced" : {"associated_object_element" : "Type", 
                                                                                            "value" : "ServiceControlManager"}},
                                                      "ServiceName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Name",
                                                                       "association_type" : "output"},
                                                      "DisplayName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Display_Name",
                                                                       "association_type" : "output"},
                                                      "ServiceType" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Type",
                                                                       "association_type" : "output"},
                                                      "StartType" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                     "associated_object_element" : "Startup_Type",
                                                                     "association_type" : "output"},
                                                      "ServiceStartName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                            "associated_object_element" : "Started_As",
                                                                            "association_type" : "output"},
                                                      "BinaryPathName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                          "associated_object_element" : "Image_Info/Path",
                                                                          "association_type" : "output"},
                                                      "group_together" : ["ServiceName", "DisplayName", "ServiceType", 
                                                                          "StartType", "ServiceStartName", "BinaryPathName"]},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "ErrorControl" : {"associated_argument_name" : "Error Control"}}},
"CreateServiceW" : {"action_name" : "create service",
                    "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                    "parameter_associated_objects" : {"ServiceControlHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "input",
                                                                                "forced" : {"associated_object_element" : "Type", 
                                                                                            "value" : "ServiceControlManager"}},
                                                      "ServiceName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Name",
                                                                       "association_type" : "output"},
                                                      "DisplayName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Display_Name",
                                                                       "association_type" : "output"},
                                                      "ServiceType" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Type",
                                                                       "association_type" : "output"},
                                                      "StartType" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                     "associated_object_element" : "Startup_Type",
                                                                     "association_type" : "output"},
                                                      "ServiceStartName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                            "associated_object_element" : "Started_As",
                                                                            "association_type" : "output"},
                                                      "BinaryPathName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                          "associated_object_element" : "Image_Info/Path",
                                                                          "association_type" : "output"},
                                                      "group_together" : ["ServiceName", "DisplayName", "ServiceType", 
                                                                          "StartType", "ServiceStartName", "BinaryPathName"]},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "ErrorControl" : {"associated_argument_name" : "Error Control"}}},
"OpenServiceA" : {"action_name" : "open service",
                  "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                  "parameter_associated_objects" : {"ServiceControlManager" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                                "associated_object_element" : "ID",
                                                                                "association_type" : "input",
                                                                                "forced" : {"associated_object_element" : "Type", 
                                                                                            "value" : "ServiceControlManager"}},
                                                     "ServiceName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Name",
                                                                       "association_type" : "input"}},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"OpenServiceW" : {"action_name" : "open service",
                  "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                  "parameter_associated_objects" : {"ServiceControlManager" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                               "associated_object_element" : "ID",
                                                                               "association_type" : "input",
                                                                               "forced" : {"associated_object_element" : "Type", 
                                                                                           "value" : "ServiceControlManager"}},
                                                     "ServiceName" : {"associated_object_type" : "WindowsServiceObjectType",
                                                                       "associated_object_element" : "Service_Name",
                                                                       "association_type" : "input"}},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode", 
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"StartServiceA" : {"action_name" : "start service",
                   "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ServiceHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                                   "value" : "Service"}}},
                   "parameter_associated_arguments" : {"Arguments" : {"associated_argument_name" : "Access Mode"}}},
"StartServiceW" : {"action_name" : "start service",
                   "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ServiceHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                                   "value" : "Service"}}},
                   "parameter_associated_arguments" : {"Arguments" : {"associated_argument_name" : "Access Mode"}}},
"ControlService" : {"action_name" : "send control code to service",
                   "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ServiceHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                                   "value" : "Service"}}},
                   "parameter_associated_arguments" : {"ControlCode" : {"associated_argument_name" : "Control Mode",
                                                                        "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"DeleteService" : {"action_name" : "delete service",
                   "action_vocab" : "maecVocabs:ServiceActionNameVocab-1.0",
                   "parameter_associated_objects" : {"ServiceHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                       "associated_object_element" : "ID",
                                                                       "association_type" : "input",
                                                                       "forced" : {"associated_object_element" : "Type", 
                                                                                   "value" : "Service"}}}},
"NtCreateThread" : {"action_name" : "create thread",
                    "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                    "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                        "associated_object_element" : "ID",
                                                                        "association_type" : "output",
                                                                        "forced" : {"associated_object_element" : "Type", 
                                                                                    "value" : "Thread"}},
                                                      "ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                         "associated_object_element" : "ID",
                                                                         "association_type" : "input",
                                                                         "forced" : {"associated_object_element" : "Type", 
                                                                                     "value" : "Process"}}},
                    "parameter_associated_arguments" : {"ObjectAttributes" : {"associated_argument_name" : "Options",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},

"NtOpenThread" : {"action_name" : "open thread",
                  "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                      "associated_object_element" : "ID",
                                                                      "association_type" : "output",
                                                                      "forced" : {"associated_object_element" : "Type", 
                                                                                  "value" : "Thread"}}},
                    "parameter_associated_arguments" : {"DesiredAccess" : {"associated_argument_name" : "Access Mode",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "ObjectAttributes" : {"associated_argument_name" : "Options",
                                                                              "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},

"NtGetContextThread" : {"action_name" : "get thread context",
                        "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                        "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Thread"}}}},

"NtSetContextThread" : {"action_name" : "set thread context",
                        "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                        "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Thread"}}}},
"NtSuspendThread" : {"action_name" : "suspend thread",
                     "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                         "associated_object_element" : "ID",
                                                                         "association_type" : "input",
                                                                         "forced" : {"associated_object_element" : "Type", 
                                                                                     "value" : "Thread"}}}},
"NtResumeThread" : {"action_name" : "resume thread",
                    "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                        "associated_object_element" : "ID",
                                                                        "association_type" : "input",
                                                                        "forced" : {"associated_object_element" : "Type", 
                                                                                    "value" : "Thread"}}}},
"NtTerminateThread" : {"action_name" : "kill thread",
                       "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                       "parameter_associated_objects" : {"ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Thread"}}}},
"CreateThread" : {"action_name" : "create thread",
                  "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                  "parameter_associated_objects" : {"ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                  "associated_object_element" : "Thread_ID",
                                                                  "association_type" : "output"}},
                    "parameter_associated_arguments" : {"StartRoutine" : {"associated_argument_name" : "Code Address",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "Parameter" : {"associated_argument_name" : "Options",
                                                                       "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "CreationFlags" : {"associated_argument_name" : "Creation Flags",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},

"CreateRemoteThread" : {"action_name" : "create remote thread in process",
                        "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                        "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input"},
                                                          "ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                        "associated_object_element" : "Thread_ID",
                                                                        "association_type" : "output"}},
                        "parameter_associated_arguments" : {"StartRoutine" : {"associated_argument_name" : "Code Address",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "Parameter" : {"associated_argument_name" : "Options",
                                                                       "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                        "CreationFlags" : {"associated_argument_name" : "Creation Flags",
                                                                           "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"ExitThread" : {"action_name" : "exit thread"},				
"RtlCreateUserThread" : {"action_name" : "create thread",
                         "action_vocab" : "maecVocabs:ProcessThreadActionNameVocab-1.0",
                         "parameter_associated_objects" : {"ProcessHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input"},
                                                           "ThreadHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "output",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Thread"}},
                                                           "ThreadId" : {"associated_object_type" : "WindowsThreadObjectType",
                                                                         "associated_object_element" : "Thread_ID",
                                                                         "association_type" : "output"}},
                         "parameter_associated_arguments" : {"CreatedSuspended" : {"associated_argument_name" : "Control Parameter",
                                                                                   "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                             "StartAddress" : {"associated_argument_name" : "Code Address",
                                                                               "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                             "StartParameter" : {"associated_argument_name" : "Options",
                                                                            "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"}}},
"URLDownloadToFileW" : {"action_name" : "download file",
                        "action_vocab" : "maecVocabs:NetworkActionNameVocab-1.0",
                        "parameter_associated_objects" : {"URL" : {"associated_object_type" : "URIObjectType",
                                                                   "associated_object_element" : "Value",
                                                                    "association_type" : "input"},
                                                          "FileName" : {"associated_object_type" : "FileObjectType",
                                                                        "associated_object_element" : "File_Path",
                                                                        "association_type" : "output"}}},
"InternetOpenA" : {"action_name" : "initialize wininet",
                   "parameter_associated_objects" : {"Agent" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Parsed_Header/User_Agent",
                                                                "association_type" : "input"}},
                   "parameter_associated_arguments" : {"AccessType" : {"associated_argument_name" : "Access Mode",
                                                                        "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                       "ProxyName" : {"associated_argument_name" : "Proxy Name"},
                                                       "ProxyBypass" : {"associated_argument_name" : "Proxy Bypass"},
                                                       "Flags" : {"associated_argument_name" : "Flags"}}}, 
"InternetOpenW" : {"action_name" : "initialize wininet",
                   "parameter_associated_objects" : {"Agent" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Parsed_Header/User_Agent",
                                                                "association_type" : "input"}},
                   "parameter_associated_arguments" : {"AccessType" : {"associated_argument_name" : "Access Mode",
                                                                        "associated_argument_vocab" : "cyboxVocabs:ActionArgumentNameVocab-1.0"},
                                                       "ProxyName" : {"associated_argument_name" : "Proxy Name"},
                                                       "ProxyBypass" : {"associated_argument_name" : "Proxy Bypass"},
                                                       "Flags" : {"associated_argument_name" : "Flags"}}},
"InternetConnectA" : {"action_name" : "connect to server",
                      "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Internet Resource"}},
                                                        "ServerName" : {"associated_object_type" : "URIObjectType",
                                                                        "associated_object_element" : "Value",
                                                                        "association_type" : "input"},
                                                        "ServerPort" : {"associated_object_type" : "PortObjectType",
                                                                        "associated_object_element" : "Port_Value",
                                                                        "association_type" : "input"}},
                      "parameter_associated_arguments" : {"Username" : {"associated_argument_name" : "Username"},
                                                          "Password" : {"associated_argument_name" : "Password"},
                                                          "Service" : {"associated_argument_name" : "Service Type"},
                                                          "Flags" : {"associated_argument_name" : "Flags"}}},
"InternetConnectW" : {"action_name" : "connect to server",
                      "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Internet Resource"}},
                                                        "ServerName" : {"associated_object_type" : "URIObjectType",
                                                                        "associated_object_element" : "Value",
                                                                        "association_type" : "input"},
                                                        "ServerPort" : {"associated_object_type" : "PortObjectType",
                                                                        "associated_object_element" : "Port_Value",
                                                                        "association_type" : "input"}},
                      "parameter_associated_arguments" : {"Username" : {"associated_argument_name" : "Username"},
                                                          "Password" : {"associated_argument_name" : "Password"},
                                                          "Service" : {"associated_argument_name" : "Service Type"},
                                                          "Flags" : {"associated_argument_name" : "Flags"}}},
"InternetOpenURLA" : {"action_name" : "connect to url",
                      "action_vocab" : "maecVocabs:NetworkActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ConnectionHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Internet Connection"}},
                                                        "URL" : {"associated_object_type" : "URIObjectType",
                                                                 "associated_object_element" : "Value",
                                                                 "association_type" : "input"},
                                                        "Headers" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                     "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Parsed_Header/Raw_Header",
                                                                     "association_type" : "input"}},
                      "parameter_associated_arguments" : {"Flags" : {"associated_argument_name" : "Flags"}}},
"InternetOpenURLW" : {"action_name" : "connect to url",
                      "action_vocab" : "maecVocabs:NetworkActionNameVocab-1.0",
                      "parameter_associated_objects" : {"ConnectionHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                              "associated_object_element" : "ID",
                                                                              "association_type" : "input",
                                                                              "forced" : {"associated_object_element" : "Type", 
                                                                                          "value" : "Internet Connection"}},
                                                        "URL" : {"associated_object_type" : "URIObjectType",
                                                                 "associated_object_element" : "Value",
                                                                 "association_type" : "input"},
                                                        "Headers" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                     "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Parsed_Header/Raw_Header",
                                                                     "association_type" : "input"}},
                      "parameter_associated_arguments" : {"Flags" : {"associated_argument_name" : "Flags"}}},
"HttpOpenRequestA" : { "action_name" : "open http request",
                       "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Internet Resource"}},
                                                         "Path" : {"associated_object_type" : "URIObjectType",
                                                                   "associated_object_element" : "Value",
                                                                   "association_type" : "input"}},
                        "parameter_associated_arguments" : {"Flags" : {"associated_argument_name" : "Flags"}}},

"HttpOpenRequestW" : { "action_name" : "open http request",
                       "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                             "associated_object_element" : "ID",
                                                                             "association_type" : "input",
                                                                             "forced" : {"associated_object_element" : "Type", 
                                                                                         "value" : "Internet Resource"}},
                                                         "Path" : {"associated_object_type" : "URIObjectType",
                                                                   "associated_object_element" : "Value",
                                                                   "association_type" : "input"}},
                        "parameter_associated_arguments" : {"Flags" : {"associated_argument_name" : "Flags"}}},
"InternetReadFile" : {"action_name" : "read from internet resource",
                      "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Internet Resource"}}}},

"InternetWriteFile" : {"action_name" : "write to internet resource",
                      "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                            "associated_object_element" : "ID",
                                                                            "association_type" : "input",
                                                                            "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "Internet Resource"}}}},

"InternetCloseHandle" : {"action_name" : "close internet resource handle",
                         "parameter_associated_objects" : {"InternetHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                               "associated_object_element" : "ID",
                                                                               "association_type" : "input",
                                                                               "forced" : {"associated_object_element" : "Type", 
                                                                                           "value" : "Internet Resource"}}}},
"HttpSendRequestA" : {"action_name" : "send http request",
                      "parameter_associated_objects" : {"RequestHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                           "associated_object_element" :  "ID",
                                                                           "association_type" : "input",
                                                                           "forced" : {"associated_object_element" : "Type", 
                                                                                        "value" : "HTTPRequest"}},
                                                        "Headers" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                     "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Raw_Header",
                                                                     "association_type" : "input"}},
                    "parameter_associated_arguments" : {"PostData" : {"associated_argument_name" : "Post Data"}}},
"HttpSendRequestW" : {"action_name" : "send http request",
                      "parameter_associated_objects" : {"RequestHandle" : {"associated_object_type" : "WindowsHandleObjectType",
                                                                           "associated_object_element" :  "ID",
                                                                           "association_type" : "input",
                                                                           "forced" : {"associated_object_element" : "Type", 
                                                                                       "value" : "HTTPRequest"}},
                                                        "Headers" : {"associated_object_type" : "HTTPSessionObjectType",
                                                                     "associated_object_element" : "list__HTTP_Request_Response/HTTP_Client_Request/HTTP_Request_Header/Raw_Header",
                                                                     "association_type" : "input"}},
                      "parameter_associated_arguments" : {"PostData" : {"associated_argument_name" : "Post Data"}}},
"DnsQuery_A" : {"action_name" : "send dns query",
                "action_vocab" : "maecVocabs:DNSActionNameVocab-1.0",
                "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Name", "element_name" : "QName/Value"},
                                                                                                     {"parameter_name" : "Type", "element_name" : "QType"}],
                                                                                   "associated_object_type" : "DNSQueryObjectType",
                                                                                   "associated_object_element" : "Question",
                                                                                   "association_type" : "input"}},
                "parameter_associated_arguments" : {"Options" : {"associated_argument_name" : "Options"}}},
"DnsQuery_UTF8" : {"action_name" : "send dns query",
                   "action_vocab" : "maecVocabs:DNSActionNameVocab-1.0",
                   "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Name", "element_name" : "QName/Value"},
                                                                                                     {"parameter_name" : "Type", "element_name" : "QType"}],
                                                                                   "associated_object_type" : "DNSQueryObjectType",
                                                                                   "associated_object_element" : "Question",
                                                                                   "association_type" : "input"}},
                   "parameter_associated_arguments" : {"Options" : {"associated_argument_name" : "Options"}}},
"DnsQuery_W" : {"action_name" : "send dns query",
                "action_vocab" : "maecVocabs:DNSActionNameVocab-1.0",
                "parameter_associated_objects" : {"group_together_nested" : {"parameter_mappings" : [{"parameter_name" : "Name", "element_name" : "QName/Value"},
                                                                                                     {"parameter_name" : "Type", "element_name" : "QType"}],
                                                                                   "associated_object_type" : "DNSQueryObjectType",
                                                                                   "associated_object_element" : "Question",
                                                                                   "association_type" : "input"}},
                "parameter_associated_arguments" : {"Options" : {"associated_argument_name" : "Options"}}},
"getaddrinfo" : {"action_name" : "get host by name",
                 "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                 "parameter_associated_objects" : {"NodeName" : {"associated_object_type" : "URIObjectType",
                                                                 "associated_object_element" : "Value",
                                                                 "association_type" : "input"}},
                 "parameter_associated_arguments" : {"ServiceName" : {"associated_argument_name" : "Service Name"}}},
"GetAddrInfoW" : {"action_name" : "get host by name",
                  "action_vocab" : "maecVocabs:SocketActionNameVocab-1.0",
                  "parameter_associated_objects" : {"NodeName" : {"associated_object_type" : "URIObjectType",
                                                                 "associated_object_element" : "Value",
                                                                 "association_type" : "input"}},
                  "parameter_associated_arguments" : {"ServiceName" : {"associated_argument_name" : "Service Name"}}}

}

def hiveHexToString(hive_hex_value):
    """Maps a Registry Hive hex input to its String (name) equivalent"""
    str_val = str(hive_hex_value)
    if str_val == "0x80000000" or str_val == "-2147483648" or str_val == "2147483648":
        return "HKEY_CLASSES_ROOT"
    elif str_val == "0x80000001" or str_val == "-2147483647" or str_val == "2147483649":
        return "HKEY_CURRENT_USER"
    elif str_val == "0x80000002" or str_val == "-2147483646" or str_val == "2147483650":
        return "HKEY_LOCAL_MACHINE"
    elif str_val == "0x80000003" or str_val == "-2147483645" or str_val == "2147483651":
        return "HKEY_USERS"
    elif str_val == "0x80000004":
        return "HKEY_PERFORMANCE_DATA"
    elif str_val == "0x80000005" or str_val == "2147483653":
        return "HKEY_CURRENT_CONFIG"
    elif str_val == "0x80000006":
        return "HKEY_DYN_DATA"
    else:
        return hive_hex_value

def regDatatypeToString(datatype_int_value):
    """Maps a Registry Datatype integer input to its String (name) equivalent"""
    if str(datatype_int_value) == "1":
        return "REG_SZ"
    elif str(datatype_int_value) == "2":
        return "REG_EXPAND_SZ"
    elif str(datatype_int_value) == "3":
        return "REG_BINARY"
    elif str(datatype_int_value) == "4":
        return "REG_DWORD"
    elif str(datatype_int_value) == "5":
        return "REG_DWORD_BIG_ENDIAN"
    elif str(datatype_int_value) == "6":
        return "REG_LINK"
    elif str(datatype_int_value) == "7":
        return "REG_MULTI_SZ"
    elif str(datatype_int_value) == "8":
        return "REG_RESOURCE_LIST"
    elif str(datatype_int_value) == "9":
        return "REG_FULL_RESOURCE_DESCRIPTOR"
    elif str(datatype_int_value) == "10":
        return "REG_RESOURCE_REQUIREMENTS_LIST"
    elif str(datatype_int_value) == "11":
        return "REG_QWORD"
    else:
        return datatype_int_value


def socketProtoToString(proto_int_value):
    """Maps a Socket Protocol integer input to its String (name) equivalent"""
    if str(proto_int_value) == "1":
        return "IPPROTO_ICMP"
    elif str(proto_int_value) == "2":
        return "IPPROTO_IGMP"
    elif str(proto_int_value) == "3":
        return "BTHPROTO_RFCOMM"
    elif str(proto_int_value) == "6":
        return "IPPROTO_TCP"
    elif str(proto_int_value) == "17":
        return "IPPROTO_UDP"
    elif str(proto_int_value) == "58":
        return "IPPROTO_ICMPV6"
    elif str(proto_int_value) == "113":
        return "IPPROTO_RM"
    else:
        return proto_int_value

def socketAFToString(af_int_value):
    """Maps a Socket Address Family integer input to its String (name) equivalent"""
    if str(af_int_value) == "0":
        return "AF_UNSPEC"
    elif str(af_int_value) == "2":
        return "AF_INET"
    elif str(af_int_value) == "6":
        return "AF_IPX"
    elif str(af_int_value) == "16":
        return "AF_APPLETALK"
    elif str(af_int_value) == "17":
        return "AF_NETBIOS"
    elif str(af_int_value) == "23":
        return "AF_INET6"
    elif str(af_int_value) == "26":
        return "AF_IRDA"
    elif str(af_int_value) == "32":
        return "AF_BTH"
    else:
        return af_int_value

def socketTypeToString(type_int_value):
    """Maps a Socket Type integer input to its String (name) equivalent"""
    if str(type_int_value) == "1":
        return "SOCK_STREAM"
    elif str(type_int_value) == "2":
        return "SOCK_DGRAM"
    elif str(type_int_value) == "3":
        return "SOCK_RAW"
    elif str(type_int_value) == "4":
        return "SOCK_RDM"
    elif str(type_int_value) == "5":
        return "SOCK_SEQPACKET"
    else:
        return type_int_value

def intToHex(value):
    """Convert an integer to a hex string"""
    if isinstance(value, int):
        value = "0x{0:08x}".format(value)

    return value

def regStringToHive(reg_string):
    """Maps a string representing a Registry Key from a NT* API call input to its normalized hive"""
    normalized_key = fix_key(reg_string)
    return normalized_key.split("\\")[0]

def regStringToKey(reg_string):
    """Maps a string representing a Registry Key from a NT* API call input to its normalized key portion"""
    normalized_key = fix_key(reg_string)
    return "\\".join(normalized_key.split("\\")[1:])

