#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) 2010-2014 Cuckoo Sandbox Developers.
# This file is part of Cuckoo Sandbox - http://www.cuckoosandbox.org
# See the file 'docs/LICENSE' for copying permission.

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class BundleType(GeneratedsSuper):
    """BundleType is intended to serve as the high-level construct under
    which all other MAEC elements reside. The required
    schema_version attribute specifies the version of the MAEC
    Schema that the document has been written in and that should be
    used for validation."""
    subclass = None
    superclass = None
    def __init__(self, id=None, schema_version=None, Analyses=None, Behaviors=None, Actions=None, Pools=None):
        self.id = _cast(None, id)
        self.schema_version = _cast(float, schema_version)
        self.Analyses = Analyses
        self.Behaviors = Behaviors
        self.Actions = Actions
        self.Pools = Pools
    def factory(*args_, **kwargs_):
        if BundleType.subclass:
            return BundleType.subclass(*args_, **kwargs_)
        else:
            return BundleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analyses(self): return self.Analyses
    def set_Analyses(self, Analyses): self.Analyses = Analyses
    def get_Behaviors(self): return self.Behaviors
    def set_Behaviors(self, Behaviors): self.Behaviors = Behaviors
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def get_Pools(self): return self.Pools
    def set_Pools(self, Pools): self.Pools = Pools
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_schema_version(self): return self.schema_version
    def set_schema_version(self, schema_version): self.schema_version = schema_version
    def export(self, outfile, level, namespace_='maec:', name_='BundleType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BundleType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='BundleType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.schema_version is not None and 'schema_version' not in already_processed:
            already_processed.append('schema_version')
            outfile.write(' schema_version="%s"' % self.gds_format_float(self.schema_version, input_name='schema_version'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BundleType', fromsubclass_=False):
        if self.Analyses is not None:
            self.Analyses.export(outfile, level, namespace_, name_='Analyses')
        if self.Behaviors is not None:
            self.Behaviors.export(outfile, level, namespace_, name_='Behaviors')
        if self.Actions is not None:
            self.Actions.export(outfile, level, namespace_, name_='Actions')
        if self.Pools is not None:
            self.Pools.export(outfile, level, namespace_, name_='Pools')
    def hasContent_(self):
        if (
            self.Analyses is not None or
            self.Behaviors is not None or
            self.Actions is not None or
            self.Pools is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BundleType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.schema_version is not None and 'schema_version' not in already_processed:
            already_processed.append('schema_version')
            showIndent(outfile, level)
            outfile.write('schema_version = %f,\n' % (self.schema_version,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Analyses is not None:
            showIndent(outfile, level)
            outfile.write('Analyses=model_.AnalysesType(\n')
            self.Analyses.exportLiteral(outfile, level, name_='Analyses')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Behaviors is not None:
            showIndent(outfile, level)
            outfile.write('Behaviors=model_.BehaviorsType(\n')
            self.Behaviors.exportLiteral(outfile, level, name_='Behaviors')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Actions is not None:
            showIndent(outfile, level)
            outfile.write('Actions=model_.ActionsType(\n')
            self.Actions.exportLiteral(outfile, level, name_='Actions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pools is not None:
            showIndent(outfile, level)
            outfile.write('Pools=model_.PoolsType(\n')
            self.Pools.exportLiteral(outfile, level, name_='Pools')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('schema_version', node)
        if value is not None and 'schema_version' not in already_processed:
            already_processed.append('schema_version')
            try:
                self.schema_version = float(value)
            except ValueError as e:
                raise ValueError('Bad float/double attribute (schema_version): %s' % e)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Analyses':
            obj_ = AnalysesType.factory()
            obj_.build(child_)
            self.set_Analyses(obj_)
        elif nodeName_ == 'Behaviors':
            obj_ = BehaviorsType.factory()
            obj_.build(child_)
            self.set_Behaviors(obj_)
        elif nodeName_ == 'Actions':
            obj_ = ActionsType.factory()
            obj_.build(child_)
            self.set_Actions(obj_)
        elif nodeName_ == 'Pools':
            obj_ = PoolsType.factory()
            obj_.build(child_)
            self.set_Pools(obj_)
# end class BundleType


class BehaviorCollectionType(GeneratedsSuper):
    """BehaviorCollectionType is intended to provide a mechanism for
    characterizing collections of behaviors.The name attribute
    contains the name of the behavior collection, if applicable."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Purpose=None, Description=None, Effects=None, Behavior_Sub_Collection=None, Behavior=None, Behavior_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Purpose = Purpose
        self.Description = Description
        self.Effects = Effects
        if Behavior_Sub_Collection is None:
            self.Behavior_Sub_Collection = []
        else:
            self.Behavior_Sub_Collection = Behavior_Sub_Collection
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
        if Behavior_Reference is None:
            self.Behavior_Reference = []
        else:
            self.Behavior_Reference = Behavior_Reference
    def factory(*args_, **kwargs_):
        if BehaviorCollectionType.subclass:
            return BehaviorCollectionType.subclass(*args_, **kwargs_)
        else:
            return BehaviorCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Behavior_Sub_Collection(self): return self.Behavior_Sub_Collection
    def set_Behavior_Sub_Collection(self, Behavior_Sub_Collection): self.Behavior_Sub_Collection = Behavior_Sub_Collection
    def add_Behavior_Sub_Collection(self, value): self.Behavior_Sub_Collection.append(value)
    def insert_Behavior_Sub_Collection(self, index, value): self.Behavior_Sub_Collection[index] = value
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def add_Behavior_Reference(self, value): self.Behavior_Reference.append(value)
    def insert_Behavior_Reference(self, index, value): self.Behavior_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='BehaviorCollectionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorCollectionType', fromsubclass_=False):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('<%sPurpose>%s</%sPurpose>\n' % (namespace_, self.gds_format_string(quote_xml(self.Purpose).encode(ExternalEncoding), input_name='Purpose'), namespace_))
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Effects is not None:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        for Behavior_Sub_Collection_ in self.Behavior_Sub_Collection:
            Behavior_Sub_Collection_.export(outfile, level, namespace_, name_='Behavior_Sub_Collection')
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
        for Behavior_Reference_ in self.Behavior_Reference:
            Behavior_Reference_.export(outfile, level, namespace_, name_='Behavior_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Purpose is not None or
            self.Description is not None or
            self.Effects is not None or
            self.Behavior_Sub_Collection or
            self.Behavior or
            self.Behavior_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('Purpose=%s,\n' % quote_python(self.Purpose).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.EffectsType(\n')
            self.Effects.exportLiteral(outfile, level, name_='Effects')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Behavior_Sub_Collection=[\n')
        level += 1
        for Behavior_Sub_Collection_ in self.Behavior_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorCollectionType(\n')
            Behavior_Sub_Collection_.exportLiteral(outfile, level, name_='BehaviorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Behavior_Reference=[\n')
        level += 1
        for Behavior_Reference_ in self.Behavior_Reference:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorReferenceType(\n')
            Behavior_Reference_.exportLiteral(outfile, level, name_='BehaviorReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affinity_Type':
            Affinity_Type_ = child_.text
            Affinity_Type_ = self.gds_validate_string(Affinity_Type_, node, 'Affinity_Type')
            self.Affinity_Type = Affinity_Type_
        elif nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = child_.text
            Affinity_Degree_ = self.gds_validate_string(Affinity_Degree_, node, 'Affinity_Degree')
            self.Affinity_Degree = Affinity_Degree_
        elif nodeName_ == 'Purpose':
            Purpose_ = child_.text
            Purpose_ = self.gds_validate_string(Purpose_, node, 'Purpose')
            self.Purpose = Purpose_
        elif nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Effects':
            obj_ = EffectsType.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif nodeName_ == 'Behavior_Sub_Collection':
            obj_ = BehaviorCollectionType.factory()
            obj_.build(child_)
            self.Behavior_Sub_Collection.append(obj_)
        elif nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
        elif nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.Behavior_Reference.append(obj_)
# end class BehaviorCollectionType


class BehaviorType(GeneratedsSuper):
    """BehaviorType is intended to serve as a method for the
    characterization of malicious behaviors found or observed in
    malware. Behaviors can be thought of as representing the purpose
    behind groups of MAEC actions, and are therefore representative
    of distinct portions of higher-level malware functionality.
    Thus, while a malware instance may perform some thousands of
    actions, it is likely that these actions represent only a few
    dozen distinct behaviors. Some examples include vulnerability
    exploitation, email address harvesting, and the disabling of a
    security service.The ordinal_position attribute is intended to
    reference the ordinal position of the behavior with respect to
    the execution of the malware.The successful attribute is used to
    describe whether the behavior was successful or not.The duration
    attribute represents the duration of the behavior. Such a value
    may be derived by calculating the difference between the
    timestamps of the first and last actions that compose the
    behavior."""
    subclass = None
    superclass = None
    def __init__(self, successful=None, duration=None, ordinal_position=None, id=None, Purpose=None, Description=None, Discovery_Method=None, Actions=None, Objects=None, Effects=None, Related_Behaviors=None):
        self.successful = _cast(bool, successful)
        self.duration = _cast(None, duration)
        self.ordinal_position = _cast(int, ordinal_position)
        self.id = _cast(None, id)
        self.Purpose = Purpose
        self.Description = Description
        self.Discovery_Method = Discovery_Method
        self.Actions = Actions
        self.Objects = Objects
        self.Effects = Effects
        self.Related_Behaviors = Related_Behaviors
    def factory(*args_, **kwargs_):
        if BehaviorType.subclass:
            return BehaviorType.subclass(*args_, **kwargs_)
        else:
            return BehaviorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def get_Objects(self): return self.Objects
    def set_Objects(self, Objects): self.Objects = Objects
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Related_Behaviors(self): return self.Related_Behaviors
    def set_Related_Behaviors(self, Related_Behaviors): self.Related_Behaviors = Related_Behaviors
    def get_successful(self): return self.successful
    def set_successful(self, successful): self.successful = successful
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='BehaviorType'):
        if self.successful is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            outfile.write(' successful="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.successful)), input_name='successful'))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            outfile.write(' duration=%s' % (self.gds_format_string(quote_attrib(self.duration).encode(ExternalEncoding), input_name='duration'), ))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            outfile.write(' ordinal_position="%s"' % self.gds_format_integer(self.ordinal_position, input_name='ordinal_position'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorType', fromsubclass_=False):
        if self.Purpose is not None:
            self.Purpose.export(outfile, level, namespace_, name_='Purpose')
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Actions is not None:
            self.Actions.export(outfile, level, namespace_, name_='Actions')
        if self.Objects is not None:
            self.Objects.export(outfile, level, namespace_, name_='Objects')
        if self.Effects is not None:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        if self.Related_Behaviors is not None:
            self.Related_Behaviors.export(outfile, level, namespace_, name_='Related_Behaviors')
    def hasContent_(self):
        if (
            self.Purpose is not None or
            self.Description is not None or
            self.Discovery_Method is not None or
            self.Actions is not None or
            self.Objects is not None or
            self.Effects is not None or
            self.Related_Behaviors is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.successful is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            showIndent(outfile, level)
            outfile.write('successful = %s,\n' % (self.successful,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            showIndent(outfile, level)
            outfile.write('duration = "%s",\n' % (self.duration,))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('Purpose=model_.PurposeType(\n')
            self.Purpose.exportLiteral(outfile, level, name_='Purpose')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Actions is not None:
            showIndent(outfile, level)
            outfile.write('Actions=model_.ActionsType1(\n')
            self.Actions.exportLiteral(outfile, level, name_='Actions')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Objects is not None:
            showIndent(outfile, level)
            outfile.write('Objects=model_.ObjectsType(\n')
            self.Objects.exportLiteral(outfile, level, name_='Objects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.EffectsType1(\n')
            self.Effects.exportLiteral(outfile, level, name_='Effects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Behaviors is not None:
            showIndent(outfile, level)
            outfile.write('Related_Behaviors=model_.Related_BehaviorsType(\n')
            self.Related_Behaviors.exportLiteral(outfile, level, name_='Related_Behaviors')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('successful', node)
        if value is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            if value in ('true', '1'):
                self.successful = True
            elif value in ('false', '0'):
                self.successful = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.append('duration')
            self.duration = value
        value = find_attr_value_('ordinal_position', node)
        if value is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            try:
                self.ordinal_position = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
            if self.ordinal_position <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Purpose':
            obj_ = PurposeType.factory()
            obj_.build(child_)
            self.set_Purpose(obj_)
        elif nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif nodeName_ == 'Actions':
            obj_ = ActionsType1.factory()
            obj_.build(child_)
            self.set_Actions(obj_)
        elif nodeName_ == 'Objects':
            obj_ = ObjectsType.factory()
            obj_.build(child_)
            self.set_Objects(obj_)
        elif nodeName_ == 'Effects':
            obj_ = EffectsType1.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif nodeName_ == 'Related_Behaviors':
            obj_ = Related_BehaviorsType.factory()
            obj_.build(child_)
            self.set_Related_Behaviors(obj_)
# end class BehaviorType


class BehaviorReferenceType(GeneratedsSuper):
    """BehaviorReferenceType is intended to serve as a method for linking
    to behaviors.The behavior_id attribute refers to the ID of the
    behavior being referenced.The type attribute refers to the type
    of behavior entity that is being referenced. Possible values:
    Behavior, Behavior_Collection."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, behavior_id=None):
        self.type_ = _cast(None, type_)
        self.behavior_id = _cast(None, behavior_id)
        pass
    def factory(*args_, **kwargs_):
        if BehaviorReferenceType.subclass:
            return BehaviorReferenceType.subclass(*args_, **kwargs_)
        else:
            return BehaviorReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_behavior_id(self): return self.behavior_id
    def set_behavior_id(self, behavior_id): self.behavior_id = behavior_id
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorReferenceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='BehaviorReferenceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.behavior_id is not None and 'behavior_id' not in already_processed:
            already_processed.append('behavior_id')
            outfile.write(' behavior_id=%s' % (quote_attrib(self.behavior_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorReferenceType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.behavior_id is not None and 'behavior_id' not in already_processed:
            already_processed.append('behavior_id')
            showIndent(outfile, level)
            outfile.write('behavior_id = %s,\n' % (self.behavior_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('behavior_id', node)
        if value is not None and 'behavior_id' not in already_processed:
            already_processed.append('behavior_id')
            self.behavior_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BehaviorReferenceType


class ActionCollectionType(GeneratedsSuper):
    """ActionCollectionType is intended to provide a method for
    characterizing collections of actions. This can be useful for
    organizing actions that may be related and where the exact
    relationship is unknown, as well as actions whose associated
    behavior has not yet been established.The name attribute
    contains the name of the action collection, if applicable."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, Action_Sub_Collection=None, Action=None, Action_Reference=None, Effects=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Description = Description
        if Action_Sub_Collection is None:
            self.Action_Sub_Collection = []
        else:
            self.Action_Sub_Collection = Action_Sub_Collection
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
        self.Effects = Effects
    def factory(*args_, **kwargs_):
        if ActionCollectionType.subclass:
            return ActionCollectionType.subclass(*args_, **kwargs_)
        else:
            return ActionCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Action_Sub_Collection(self): return self.Action_Sub_Collection
    def set_Action_Sub_Collection(self, Action_Sub_Collection): self.Action_Sub_Collection = Action_Sub_Collection
    def add_Action_Sub_Collection(self, value): self.Action_Sub_Collection.append(value)
    def insert_Action_Sub_Collection(self, index, value): self.Action_Sub_Collection[index] = value
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='ActionCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionCollectionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionCollectionType', fromsubclass_=False):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        for Action_Sub_Collection_ in self.Action_Sub_Collection:
            Action_Sub_Collection_.export(outfile, level, namespace_, name_='Action_Sub-Collection')
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, namespace_, name_='Action_Reference')
        if self.Effects is not None:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Description is not None or
            self.Action_Sub_Collection or
            self.Action or
            self.Action_Reference or
            self.Effects is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Action_Sub_Collection=[\n')
        level += 1
        for Action_Sub_Collection_ in self.Action_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ActionCollectionType(\n')
            Action_Sub_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='ActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.EffectsType2(\n')
            self.Effects.exportLiteral(outfile, level, name_='Effects')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affinity_Type':
            Affinity_Type_ = child_.text
            Affinity_Type_ = self.gds_validate_string(Affinity_Type_, node, 'Affinity_Type')
            self.Affinity_Type = Affinity_Type_
        elif nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = child_.text
            Affinity_Degree_ = self.gds_validate_string(Affinity_Degree_, node, 'Affinity_Degree')
            self.Affinity_Degree = Affinity_Degree_
        elif nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Action_Sub-Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Sub_Collection.append(obj_)
        elif nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
        elif nodeName_ == 'Action_Reference':
            obj_ = ActionReferenceType.factory()
            obj_.build(child_)
            self.Action_Reference.append(obj_)
        elif nodeName_ == 'Effects':
            obj_ = EffectsType2.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
# end class ActionCollectionType


class ActionType(GeneratedsSuper):
    """ActionType is intended to serve as a method for the characterization
    of actions found or observed in malware. Actions can be thought
    of as system state changes and similar operations that represent
    the fundamental low-level operation of malware. Some examples
    include the creation of a file, deletion of a registry key, and
    the sending of some arbitrary packets on a socket.The type
    attribute is intended to characterize the type of action that
    occurred, based on its activity. Possible values: Login/Logon,
    Logout/Logoff, Start, Stop, Suspend/Pause, Resume, Create,
    Remove/Delete, Access/Open, Close, Move, Copy/Duplicate, Read,
    Write, Execute, Quarantine, Find, Clean, Block, Update, Upgrade,
    Scan, Filter, Install, Allocate, Initialize, Save, Connect,
    Disconnect, Audit, Replicate, Detect, Alert, Backup, Search,
    Restore, Get, Set, Assign, Send, Receive, Transmit, Map, Load,
    Query, Enumerate, Bind, Free, Kill, Encrypt, Decrypt, Encode,
    Decode, Pack, Unpack, Archive, Compress, Decompress, Download,
    Upload, Load, Fork, Join,Merge, Interleave, Schedule, Call,
    Compare, Wipe/Destroy/Purge, Throw/Raise, Lock, Unlock,
    Synchronize, Hook, Unhook, Draw, Click, Press, Depress,
    Close(network), Open(network), Callback, Drop, Accept, Deny,
    Modify, Listen, Send,Start_Winsock, Other.The action_name
    attribute is intended to contain the name of the action
    performed. Typically, this is composed of the Action_Type
    concatenated with the type of object the action is performed
    upon. For instance, the action name for creating a file would be
    'create_file', where the action_type is 'create'. If the object
    does not exist in MAEC's object_type enumeration, it can still
    be included as the second half of the action name. If a specific
    object attribute is being used in the action, this attribute can
    be concatenated after the object type. For instance, an action
    that sets a timestamp on a file would 'set_file_timestamp'.
    Object modifiers can be used by including the modifier in front
    of the object type. For instance, an action that creates a
    remote thread would be 'create_remote_thread'.The
    ordinal_position attribute is intended to reference the ordinal
    position of the action with respect to the execution of the
    malware.The successful attribute is used to describe whether the
    action was successful or not.The timestamp attribute represents
    the local or relative time at which the action occurred or was
    observed."""
    subclass = None
    superclass = None
    def __init__(self, successful=None, timestamp=None, action_name=None, ordinal_position=None, type_=None, id=None, Description=None, Discovery_Method=None, Action_Initiator=None, Action_Implementation=None, Objects=None, Effects=None, Related_Actions=None):
        self.successful = _cast(bool, successful)
        self.timestamp = _cast(None, timestamp)
        self.action_name = _cast(None, action_name)
        self.ordinal_position = _cast(int, ordinal_position)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Description = Description
        self.Discovery_Method = Discovery_Method
        self.Action_Initiator = Action_Initiator
        self.Action_Implementation = Action_Implementation
        self.Objects = Objects
        self.Effects = Effects
        self.Related_Actions = Related_Actions
    def factory(*args_, **kwargs_):
        if ActionType.subclass:
            return ActionType.subclass(*args_, **kwargs_)
        else:
            return ActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Action_Initiator(self): return self.Action_Initiator
    def set_Action_Initiator(self, Action_Initiator): self.Action_Initiator = Action_Initiator
    def get_Action_Implementation(self): return self.Action_Implementation
    def set_Action_Implementation(self, Action_Implementation): self.Action_Implementation = Action_Implementation
    def get_Objects(self): return self.Objects
    def set_Objects(self, Objects): self.Objects = Objects
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Related_Actions(self): return self.Related_Actions
    def set_Related_Actions(self, Related_Actions): self.Related_Actions = Related_Actions
    def get_successful(self): return self.successful
    def set_successful(self, successful): self.successful = successful
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_action_name(self): return self.action_name
    def set_action_name(self, action_name): self.action_name = action_name
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ActionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionType'):
        if self.successful is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            outfile.write(' successful="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.successful)), input_name='successful'))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            outfile.write(' timestamp=%s' % (quote_attrib(self.timestamp), ))
        if self.action_name is not None and 'action_name' not in already_processed:
            already_processed.append('action_name')
            outfile.write(' action_name=%s' % (self.gds_format_string(quote_attrib(self.action_name).encode(ExternalEncoding), input_name='action_name'), ))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            outfile.write(' ordinal_position="%s"' % self.gds_format_integer(self.ordinal_position, input_name='ordinal_position'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionType', fromsubclass_=False):
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Action_Initiator is not None:
            self.Action_Initiator.export(outfile, level, namespace_, name_='Action_Initiator')
        if self.Action_Implementation is not None:
            self.Action_Implementation.export(outfile, level, namespace_, name_='Action_Implementation')
        if self.Objects is not None:
            self.Objects.export(outfile, level, namespace_, name_='Objects')
        if self.Effects is not None:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        if self.Related_Actions is not None:
            self.Related_Actions.export(outfile, level, namespace_, name_='Related_Actions')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Discovery_Method is not None or
            self.Action_Initiator is not None or
            self.Action_Implementation is not None or
            self.Objects is not None or
            self.Effects is not None or
            self.Related_Actions is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.successful is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            showIndent(outfile, level)
            outfile.write('successful = %s,\n' % (self.successful,))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            showIndent(outfile, level)
            outfile.write('timestamp = %s,\n' % (self.timestamp,))
        if self.action_name is not None and 'action_name' not in already_processed:
            already_processed.append('action_name')
            showIndent(outfile, level)
            outfile.write('action_name = "%s",\n' % (self.action_name,))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Initiator is not None:
            showIndent(outfile, level)
            outfile.write('Action_Initiator=model_.Action_InitiatorType(\n')
            self.Action_Initiator.exportLiteral(outfile, level, name_='Action_Initiator')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Implementation is not None:
            showIndent(outfile, level)
            outfile.write('Action_Implementation=model_.ActionImplementationType(\n')
            self.Action_Implementation.exportLiteral(outfile, level, name_='Action_Implementation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Objects is not None:
            showIndent(outfile, level)
            outfile.write('Objects=model_.ObjectsType1(\n')
            self.Objects.exportLiteral(outfile, level, name_='Objects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.EffectsType3(\n')
            self.Effects.exportLiteral(outfile, level, name_='Effects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Actions is not None:
            showIndent(outfile, level)
            outfile.write('Related_Actions=model_.Related_ActionsType(\n')
            self.Related_Actions.exportLiteral(outfile, level, name_='Related_Actions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('successful', node)
        if value is not None and 'successful' not in already_processed:
            already_processed.append('successful')
            if value in ('true', '1'):
                self.successful = True
            elif value in ('false', '0'):
                self.successful = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('timestamp', node)
        if value is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            self.timestamp = value
        value = find_attr_value_('action_name', node)
        if value is not None and 'action_name' not in already_processed:
            already_processed.append('action_name')
            self.action_name = value
        value = find_attr_value_('ordinal_position', node)
        if value is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            try:
                self.ordinal_position = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
            if self.ordinal_position <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif nodeName_ == 'Action_Initiator':
            obj_ = Action_InitiatorType.factory()
            obj_.build(child_)
            self.set_Action_Initiator(obj_)
        elif nodeName_ == 'Action_Implementation':
            obj_ = ActionImplementationType.factory()
            obj_.build(child_)
            self.set_Action_Implementation(obj_)
        elif nodeName_ == 'Objects':
            obj_ = ObjectsType1.factory()
            obj_.build(child_)
            self.set_Objects(obj_)
        elif nodeName_ == 'Effects':
            obj_ = EffectsType3.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif nodeName_ == 'Related_Actions':
            obj_ = Related_ActionsType.factory()
            obj_.build(child_)
            self.set_Related_Actions(obj_)
# end class ActionType


class ActionReferenceType(GeneratedsSuper):
    """ActionReferenceType is intended to serve as a method for linking to
    actions.The action_id attribute refers to the ID of the action
    being referenced.The type field refers to the type of action
    entity that is being referenced. Possible values: Action,
    Action_Collection."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, action_id=None):
        self.type_ = _cast(None, type_)
        self.action_id = _cast(None, action_id)
        pass
    def factory(*args_, **kwargs_):
        if ActionReferenceType.subclass:
            return ActionReferenceType.subclass(*args_, **kwargs_)
        else:
            return ActionReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_action_id(self): return self.action_id
    def set_action_id(self, action_id): self.action_id = action_id
    def export(self, outfile, level, namespace_='maec:', name_='ActionReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionReferenceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionReferenceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.action_id is not None and 'action_id' not in already_processed:
            already_processed.append('action_id')
            outfile.write(' action_id=%s' % (quote_attrib(self.action_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionReferenceType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.action_id is not None and 'action_id' not in already_processed:
            already_processed.append('action_id')
            showIndent(outfile, level)
            outfile.write('action_id = %s,\n' % (self.action_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('action_id', node)
        if value is not None and 'action_id' not in already_processed:
            already_processed.append('action_id')
            self.action_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ActionReferenceType


class ObjectType(GeneratedsSuper):
    """ObjectType is intended to serve as a method for the characterization
    of any entities that actions and behaviors operate on or are
    associated with.The object_name attribute specifies the name of
    the object, if applicable.The type attribute is intended to
    characterize the type of object being characterized in this
    element. Possible values are: URI, Host, Session, Session Token,
    Account, Device (physical), Handle, Heap,Memory Address, Memory
    Page, Window, Dialog, Parameter, Authentication Token,Encryption
    Token, Web Query, Protocol Header, Protocol Field, Link, SQL
    Query,Database, ACL, Role, System, VM, Signature, Channel, API
    Call, Environment Variable, Application, Network, Configuration,
    Policy, Tack, Malware, Message,Email Message, Media, Operating
    System, Query, Domain, Event, OtherThe permanent attribute is
    intended to characterize whether an object stays resident after
    execution of the malware, that is, whather or not it remains on
    the filesystem or other non-volatile entity in some fashion."""
    subclass = None
    superclass = None
    def __init__(self, object_name=None, permanent=None, type_=None, id=None, Object_Size=None, Classifications=None, Associated_Code=None, Related_Objects=None, File_System_Object_Attributes=None, GUI_Object_Attributes=None, IPC_Object_Attributes=None, Internet_Object_Attributes=None, Module_Object_Attributes=None, Registry_Object_Attributes=None, Process_Object_Attributes=None, Memory_Object_Attributes=None, Network_Object_Attributes=None, Daemon_Object_Attributes=None, Custom_Object_Attributes=None):
        self.object_name = _cast(None, object_name)
        self.permanent = _cast(bool, permanent)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Object_Size = Object_Size
        self.Classifications = Classifications
        self.Associated_Code = Associated_Code
        self.Related_Objects = Related_Objects
        self.File_System_Object_Attributes = File_System_Object_Attributes
        self.GUI_Object_Attributes = GUI_Object_Attributes
        self.IPC_Object_Attributes = IPC_Object_Attributes
        self.Internet_Object_Attributes = Internet_Object_Attributes
        self.Module_Object_Attributes = Module_Object_Attributes
        self.Registry_Object_Attributes = Registry_Object_Attributes
        self.Process_Object_Attributes = Process_Object_Attributes
        self.Memory_Object_Attributes = Memory_Object_Attributes
        self.Network_Object_Attributes = Network_Object_Attributes
        self.Daemon_Object_Attributes = Daemon_Object_Attributes
        self.Custom_Object_Attributes = Custom_Object_Attributes
    def factory(*args_, **kwargs_):
        if ObjectType.subclass:
            return ObjectType.subclass(*args_, **kwargs_)
        else:
            return ObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Size(self): return self.Object_Size
    def set_Object_Size(self, Object_Size): self.Object_Size = Object_Size
    def get_Classifications(self): return self.Classifications
    def set_Classifications(self, Classifications): self.Classifications = Classifications
    def get_Associated_Code(self): return self.Associated_Code
    def set_Associated_Code(self, Associated_Code): self.Associated_Code = Associated_Code
    def get_Related_Objects(self): return self.Related_Objects
    def set_Related_Objects(self, Related_Objects): self.Related_Objects = Related_Objects
    def get_File_System_Object_Attributes(self): return self.File_System_Object_Attributes
    def set_File_System_Object_Attributes(self, File_System_Object_Attributes): self.File_System_Object_Attributes = File_System_Object_Attributes
    def get_GUI_Object_Attributes(self): return self.GUI_Object_Attributes
    def set_GUI_Object_Attributes(self, GUI_Object_Attributes): self.GUI_Object_Attributes = GUI_Object_Attributes
    def get_IPC_Object_Attributes(self): return self.IPC_Object_Attributes
    def set_IPC_Object_Attributes(self, IPC_Object_Attributes): self.IPC_Object_Attributes = IPC_Object_Attributes
    def get_Internet_Object_Attributes(self): return self.Internet_Object_Attributes
    def set_Internet_Object_Attributes(self, Internet_Object_Attributes): self.Internet_Object_Attributes = Internet_Object_Attributes
    def get_Module_Object_Attributes(self): return self.Module_Object_Attributes
    def set_Module_Object_Attributes(self, Module_Object_Attributes): self.Module_Object_Attributes = Module_Object_Attributes
    def get_Registry_Object_Attributes(self): return self.Registry_Object_Attributes
    def set_Registry_Object_Attributes(self, Registry_Object_Attributes): self.Registry_Object_Attributes = Registry_Object_Attributes
    def get_Process_Object_Attributes(self): return self.Process_Object_Attributes
    def set_Process_Object_Attributes(self, Process_Object_Attributes): self.Process_Object_Attributes = Process_Object_Attributes
    def get_Memory_Object_Attributes(self): return self.Memory_Object_Attributes
    def set_Memory_Object_Attributes(self, Memory_Object_Attributes): self.Memory_Object_Attributes = Memory_Object_Attributes
    def get_Network_Object_Attributes(self): return self.Network_Object_Attributes
    def set_Network_Object_Attributes(self, Network_Object_Attributes): self.Network_Object_Attributes = Network_Object_Attributes
    def get_Daemon_Object_Attributes(self): return self.Daemon_Object_Attributes
    def set_Daemon_Object_Attributes(self, Daemon_Object_Attributes): self.Daemon_Object_Attributes = Daemon_Object_Attributes
    def get_Custom_Object_Attributes(self): return self.Custom_Object_Attributes
    def set_Custom_Object_Attributes(self, Custom_Object_Attributes): self.Custom_Object_Attributes = Custom_Object_Attributes
    def get_object_name(self): return self.object_name
    def set_object_name(self, object_name): self.object_name = object_name
    def get_permanent(self): return self.permanent
    def set_permanent(self, permanent): self.permanent = permanent
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ObjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ObjectType'):
        if self.object_name is not None and 'object_name' not in already_processed:
            already_processed.append('object_name')
            outfile.write(' object_name=%s' % (self.gds_format_string(quote_attrib(self.object_name).encode(ExternalEncoding), input_name='object_name'), ))
        if self.permanent is not None and 'permanent' not in already_processed:
            already_processed.append('permanent')
            outfile.write(' permanent="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.permanent)), input_name='permanent'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectType', fromsubclass_=False):
        if self.Object_Size is not None:
            self.Object_Size.export(outfile, level, namespace_, name_='Object_Size')
        if self.Classifications is not None:
            self.Classifications.export(outfile, level, namespace_, name_='Classifications')
        if self.Associated_Code is not None:
            self.Associated_Code.export(outfile, level, namespace_, name_='Associated_Code')
        if self.Related_Objects is not None:
            self.Related_Objects.export(outfile, level, namespace_, name_='Related_Objects')
        if self.File_System_Object_Attributes is not None:
            self.File_System_Object_Attributes.export(outfile, level, namespace_, name_='File_System_Object_Attributes')
        if self.GUI_Object_Attributes is not None:
            self.GUI_Object_Attributes.export(outfile, level, namespace_, name_='GUI_Object_Attributes')
        if self.IPC_Object_Attributes is not None:
            self.IPC_Object_Attributes.export(outfile, level, namespace_, name_='IPC_Object_Attributes')
        if self.Internet_Object_Attributes is not None:
            self.Internet_Object_Attributes.export(outfile, level, namespace_, name_='Internet_Object_Attributes')
        if self.Module_Object_Attributes is not None:
            self.Module_Object_Attributes.export(outfile, level, namespace_, name_='Module_Object_Attributes')
        if self.Registry_Object_Attributes is not None:
            self.Registry_Object_Attributes.export(outfile, level, namespace_, name_='Registry_Object_Attributes')
        if self.Process_Object_Attributes is not None:
            self.Process_Object_Attributes.export(outfile, level, namespace_, name_='Process_Object_Attributes')
        if self.Memory_Object_Attributes is not None:
            self.Memory_Object_Attributes.export(outfile, level, namespace_, name_='Memory_Object_Attributes')
        if self.Network_Object_Attributes is not None:
            self.Network_Object_Attributes.export(outfile, level, namespace_, name_='Network_Object_Attributes')
        if self.Daemon_Object_Attributes is not None:
            self.Daemon_Object_Attributes.export(outfile, level, namespace_, name_='Daemon_Object_Attributes')
        if self.Custom_Object_Attributes is not None:
            self.Custom_Object_Attributes.export(outfile, level, namespace_, name_='Custom_Object_Attributes')
    def hasContent_(self):
        if (
            self.Object_Size is not None or
            self.Classifications is not None or
            self.Associated_Code is not None or
            self.Related_Objects is not None or
            self.File_System_Object_Attributes is not None or
            self.GUI_Object_Attributes is not None or
            self.IPC_Object_Attributes is not None or
            self.Internet_Object_Attributes is not None or
            self.Module_Object_Attributes is not None or
            self.Registry_Object_Attributes is not None or
            self.Process_Object_Attributes is not None or
            self.Memory_Object_Attributes is not None or
            self.Network_Object_Attributes is not None or
            self.Daemon_Object_Attributes is not None or
            self.Custom_Object_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.object_name is not None and 'object_name' not in already_processed:
            already_processed.append('object_name')
            showIndent(outfile, level)
            outfile.write('object_name = "%s",\n' % (self.object_name,))
        if self.permanent is not None and 'permanent' not in already_processed:
            already_processed.append('permanent')
            showIndent(outfile, level)
            outfile.write('permanent = %s,\n' % (self.permanent,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Size is not None:
            showIndent(outfile, level)
            outfile.write('Object_Size=model_.Object_SizeType(\n')
            self.Object_Size.exportLiteral(outfile, level, name_='Object_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Classifications is not None:
            showIndent(outfile, level)
            outfile.write('Classifications=model_.ClassificationsType(\n')
            self.Classifications.exportLiteral(outfile, level, name_='Classifications')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Associated_Code is not None:
            showIndent(outfile, level)
            outfile.write('Associated_Code=model_.Associated_CodeType(\n')
            self.Associated_Code.exportLiteral(outfile, level, name_='Associated_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Objects is not None:
            showIndent(outfile, level)
            outfile.write('Related_Objects=model_.Related_ObjectsType(\n')
            self.Related_Objects.exportLiteral(outfile, level, name_='Related_Objects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Object_Attributes=model_.File_System_Object_AttributesType(\n')
            self.File_System_Object_Attributes.exportLiteral(outfile, level, name_='File_System_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.GUI_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('GUI_Object_Attributes=model_.GUI_Object_AttributesType(\n')
            self.GUI_Object_Attributes.exportLiteral(outfile, level, name_='GUI_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IPC_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('IPC_Object_Attributes=model_.IPC_Object_AttributesType(\n')
            self.IPC_Object_Attributes.exportLiteral(outfile, level, name_='IPC_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Internet_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Internet_Object_Attributes=model_.Internet_Object_AttributesType(\n')
            self.Internet_Object_Attributes.exportLiteral(outfile, level, name_='Internet_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Module_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Module_Object_Attributes=model_.Module_Object_AttributesType(\n')
            self.Module_Object_Attributes.exportLiteral(outfile, level, name_='Module_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registry_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Registry_Object_Attributes=model_.Registry_Object_AttributesType(\n')
            self.Registry_Object_Attributes.exportLiteral(outfile, level, name_='Registry_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Process_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Process_Object_Attributes=model_.Process_Object_AttributesType(\n')
            self.Process_Object_Attributes.exportLiteral(outfile, level, name_='Process_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Memory_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Object_Attributes=model_.Memory_Object_AttributesType(\n')
            self.Memory_Object_Attributes.exportLiteral(outfile, level, name_='Memory_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Network_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Network_Object_Attributes=model_.Network_Object_AttributesType(\n')
            self.Network_Object_Attributes.exportLiteral(outfile, level, name_='Network_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Daemon_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Object_Attributes=model_.Daemon_Object_AttributesType(\n')
            self.Daemon_Object_Attributes.exportLiteral(outfile, level, name_='Daemon_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Custom_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Custom_Object_Attributes=model_.Custom_Object_AttributesType(\n')
            self.Custom_Object_Attributes.exportLiteral(outfile, level, name_='Custom_Object_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('object_name', node)
        if value is not None and 'object_name' not in already_processed:
            already_processed.append('object_name')
            self.object_name = value
        value = find_attr_value_('permanent', node)
        if value is not None and 'permanent' not in already_processed:
            already_processed.append('permanent')
            if value in ('true', '1'):
                self.permanent = True
            elif value in ('false', '0'):
                self.permanent = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Size':
            obj_ = Object_SizeType.factory()
            obj_.build(child_)
            self.set_Object_Size(obj_)
        elif nodeName_ == 'Classifications':
            obj_ = ClassificationsType.factory()
            obj_.build(child_)
            self.set_Classifications(obj_)
        elif nodeName_ == 'Associated_Code':
            obj_ = Associated_CodeType.factory()
            obj_.build(child_)
            self.set_Associated_Code(obj_)
        elif nodeName_ == 'Related_Objects':
            obj_ = Related_ObjectsType.factory()
            obj_.build(child_)
            self.set_Related_Objects(obj_)
        elif nodeName_ == 'File_System_Object_Attributes':
            obj_ = File_System_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_File_System_Object_Attributes(obj_)
        elif nodeName_ == 'GUI_Object_Attributes':
            obj_ = GUI_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_GUI_Object_Attributes(obj_)
        elif nodeName_ == 'IPC_Object_Attributes':
            obj_ = IPC_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_IPC_Object_Attributes(obj_)
        elif nodeName_ == 'Internet_Object_Attributes':
            obj_ = Internet_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Internet_Object_Attributes(obj_)
        elif nodeName_ == 'Module_Object_Attributes':
            obj_ = Module_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Module_Object_Attributes(obj_)
        elif nodeName_ == 'Registry_Object_Attributes':
            obj_ = Registry_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Registry_Object_Attributes(obj_)
        elif nodeName_ == 'Process_Object_Attributes':
            obj_ = Process_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Process_Object_Attributes(obj_)
        elif nodeName_ == 'Memory_Object_Attributes':
            obj_ = Memory_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Memory_Object_Attributes(obj_)
        elif nodeName_ == 'Network_Object_Attributes':
            obj_ = Network_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Network_Object_Attributes(obj_)
        elif nodeName_ == 'Daemon_Object_Attributes':
            obj_ = Daemon_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Daemon_Object_Attributes(obj_)
        elif nodeName_ == 'Custom_Object_Attributes':
            obj_ = Custom_Object_AttributesType.factory()
            obj_.build(child_)
            self.set_Custom_Object_Attributes(obj_)
# end class ObjectType


class EffectType(GeneratedsSuper):
    """EffectType is intended to serve as a method for the characterization
    of the results of succesfully executed actions and behaviors."""
    subclass = None
    superclass = None
    def __init__(self, id=None, Description=None, Affected_Objects=None, Constituent_Effects=None, Vulnerability_Exploit=None):
        self.id = _cast(None, id)
        self.Description = Description
        self.Affected_Objects = Affected_Objects
        self.Constituent_Effects = Constituent_Effects
        self.Vulnerability_Exploit = Vulnerability_Exploit
    def factory(*args_, **kwargs_):
        if EffectType.subclass:
            return EffectType.subclass(*args_, **kwargs_)
        else:
            return EffectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Affected_Objects(self): return self.Affected_Objects
    def set_Affected_Objects(self, Affected_Objects): self.Affected_Objects = Affected_Objects
    def get_Constituent_Effects(self): return self.Constituent_Effects
    def set_Constituent_Effects(self, Constituent_Effects): self.Constituent_Effects = Constituent_Effects
    def get_Vulnerability_Exploit(self): return self.Vulnerability_Exploit
    def set_Vulnerability_Exploit(self, Vulnerability_Exploit): self.Vulnerability_Exploit = Vulnerability_Exploit
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='EffectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectType', fromsubclass_=False):
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Affected_Objects is not None:
            self.Affected_Objects.export(outfile, level, namespace_, name_='Affected_Objects')
        if self.Constituent_Effects is not None:
            self.Constituent_Effects.export(outfile, level, namespace_, name_='Constituent_Effects')
        if self.Vulnerability_Exploit is not None:
            self.Vulnerability_Exploit.export(outfile, level, namespace_, name_='Vulnerability_Exploit')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Affected_Objects is not None or
            self.Constituent_Effects is not None or
            self.Vulnerability_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Affected_Objects is not None:
            showIndent(outfile, level)
            outfile.write('Affected_Objects=model_.Affected_ObjectsType(\n')
            self.Affected_Objects.exportLiteral(outfile, level, name_='Affected_Objects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Constituent_Effects is not None:
            showIndent(outfile, level)
            outfile.write('Constituent_Effects=model_.Constituent_EffectsType(\n')
            self.Constituent_Effects.exportLiteral(outfile, level, name_='Constituent_Effects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Vulnerability_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Vulnerability_Exploit=model_.Vulnerability_ExploitType(\n')
            self.Vulnerability_Exploit.exportLiteral(outfile, level, name_='Vulnerability_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Affected_Objects':
            obj_ = Affected_ObjectsType.factory()
            obj_.build(child_)
            self.set_Affected_Objects(obj_)
        elif nodeName_ == 'Constituent_Effects':
            obj_ = Constituent_EffectsType.factory()
            obj_.build(child_)
            self.set_Constituent_Effects(obj_)
        elif nodeName_ == 'Vulnerability_Exploit':
            obj_ = Vulnerability_ExploitType.factory()
            obj_.build(child_)
            self.set_Vulnerability_Exploit(obj_)
# end class EffectType


class EffectCollectionType(GeneratedsSuper):
    """EffectCollectionType is intended to provide a mechanism for
    characterizing collections of effects. For instance, it can be
    used to group all of the effects that result from the execution
    of a particular malware instance.The name attribute contains the
    name of the effect collection, if applicable."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, Effect_Sub_Collection=None, Effect=None, Effect_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Description = Description
        if Effect_Sub_Collection is None:
            self.Effect_Sub_Collection = []
        else:
            self.Effect_Sub_Collection = Effect_Sub_Collection
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if EffectCollectionType.subclass:
            return EffectCollectionType.subclass(*args_, **kwargs_)
        else:
            return EffectCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Effect_Sub_Collection(self): return self.Effect_Sub_Collection
    def set_Effect_Sub_Collection(self, Effect_Sub_Collection): self.Effect_Sub_Collection = Effect_Sub_Collection
    def add_Effect_Sub_Collection(self, value): self.Effect_Sub_Collection.append(value)
    def insert_Effect_Sub_Collection(self, index, value): self.Effect_Sub_Collection[index] = value
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='EffectCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectCollectionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectCollectionType', fromsubclass_=False):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        for Effect_Sub_Collection_ in self.Effect_Sub_Collection:
            Effect_Sub_Collection_.export(outfile, level, namespace_, name_='Effect_Sub_Collection')
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Description is not None or
            self.Effect_Sub_Collection or
            self.Effect or
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Effect_Sub_Collection=[\n')
        level += 1
        for Effect_Sub_Collection_ in self.Effect_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.EffectCollectionType(\n')
            Effect_Sub_Collection_.exportLiteral(outfile, level, name_='EffectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affinity_Type':
            Affinity_Type_ = child_.text
            Affinity_Type_ = self.gds_validate_string(Affinity_Type_, node, 'Affinity_Type')
            self.Affinity_Type = Affinity_Type_
        elif nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = child_.text
            Affinity_Degree_ = self.gds_validate_string(Affinity_Degree_, node, 'Affinity_Degree')
            self.Affinity_Degree = Affinity_Degree_
        elif nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Effect_Sub_Collection':
            obj_ = EffectCollectionType.factory()
            obj_.build(child_)
            self.Effect_Sub_Collection.append(obj_)
        elif nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
        elif nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class EffectCollectionType


class EffectReferenceType(GeneratedsSuper):
    """EffectReferenceType is intended to serve as a method for linking to
    effects.The effect_id attribute refers to the ID of the effect
    being referenced.The type attribute refers to the type of effect
    entity that is being referenced. Possible values: Effect,
    Effect_Collection."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, effect_id=None):
        self.type_ = _cast(None, type_)
        self.effect_id = _cast(None, effect_id)
        pass
    def factory(*args_, **kwargs_):
        if EffectReferenceType.subclass:
            return EffectReferenceType.subclass(*args_, **kwargs_)
        else:
            return EffectReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_effect_id(self): return self.effect_id
    def set_effect_id(self, effect_id): self.effect_id = effect_id
    def export(self, outfile, level, namespace_='maec:', name_='EffectReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectReferenceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectReferenceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.effect_id is not None and 'effect_id' not in already_processed:
            already_processed.append('effect_id')
            outfile.write(' effect_id=%s' % (quote_attrib(self.effect_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectReferenceType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.effect_id is not None and 'effect_id' not in already_processed:
            already_processed.append('effect_id')
            showIndent(outfile, level)
            outfile.write('effect_id = %s,\n' % (self.effect_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('effect_id', node)
        if value is not None and 'effect_id' not in already_processed:
            already_processed.append('effect_id')
            self.effect_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class EffectReferenceType


class StructuredTextType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Text_Title=None, Text=None, Code_Example_Language=None, Code=None, Images=None, Block=None):
        if Text_Title is None:
            self.Text_Title = []
        else:
            self.Text_Title = Text_Title
        if Text is None:
            self.Text = []
        else:
            self.Text = Text
        if Code_Example_Language is None:
            self.Code_Example_Language = []
        else:
            self.Code_Example_Language = Code_Example_Language
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        self.Images = Images
        self.Block = Block
    def factory(*args_, **kwargs_):
        if StructuredTextType.subclass:
            return StructuredTextType.subclass(*args_, **kwargs_)
        else:
            return StructuredTextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text_Title(self): return self.Text_Title
    def set_Text_Title(self, Text_Title): self.Text_Title = Text_Title
    def add_Text_Title(self, value): self.Text_Title.append(value)
    def insert_Text_Title(self, index, value): self.Text_Title[index] = value
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def add_Text(self, value): self.Text.append(value)
    def insert_Text(self, index, value): self.Text[index] = value
    def get_Code_Example_Language(self): return self.Code_Example_Language
    def set_Code_Example_Language(self, Code_Example_Language): self.Code_Example_Language = Code_Example_Language
    def add_Code_Example_Language(self, value): self.Code_Example_Language.append(value)
    def insert_Code_Example_Language(self, index, value): self.Code_Example_Language[index] = value
    def validate_LanguageEnum(self, value):
        # Validate type LanguageEnum, a restriction on xs:string.
        pass
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Images(self): return self.Images
    def set_Images(self, Images): self.Images = Images
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def export(self, outfile, level, namespace_='maec:', name_='StructuredTextType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StructuredTextType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='StructuredTextType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='StructuredTextType', fromsubclass_=False):
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('<%sText_Title>%s</%sText_Title>\n' % (namespace_, self.gds_format_string(quote_xml(Text_Title_).encode(ExternalEncoding), input_name='Text_Title'), namespace_))
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('<%sText>%s</%sText>\n' % (namespace_, self.gds_format_string(quote_xml(Text_).encode(ExternalEncoding), input_name='Text'), namespace_))
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('<%sCode_Example_Language>%s</%sCode_Example_Language>\n' % (namespace_, self.gds_format_string(quote_xml(Code_Example_Language_).encode(ExternalEncoding), input_name='Code_Example_Language'), namespace_))
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('<%sCode>%s</%sCode>\n' % (namespace_, self.gds_format_string(quote_xml(Code_).encode(ExternalEncoding), input_name='Code'), namespace_))
        if self.Images is not None:
            self.Images.export(outfile, level, namespace_, name_='Images')
        if self.Block is not None:
            self.Block.export(outfile, level, namespace_, name_='Block', )
    def hasContent_(self):
        if (
            self.Text_Title or
            self.Text or
            self.Code_Example_Language or
            self.Code or
            self.Images is not None or
            self.Block is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StructuredTextType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Text_Title=[\n')
        level += 1
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_Title_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Text=[\n')
        level += 1
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code_Example_Language=[\n')
        level += 1
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_Example_Language_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Images is not None:
            showIndent(outfile, level)
            outfile.write('Images=model_.ImagesType(\n')
            self.Images.exportLiteral(outfile, level, name_='Images')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Block is not None:
            showIndent(outfile, level)
            outfile.write('Block=model_.Block(\n')
            self.Block.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text_Title':
            Text_Title_ = child_.text
            Text_Title_ = self.gds_validate_string(Text_Title_, node, 'Text_Title')
            self.Text_Title.append(Text_Title_)
        elif nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text.append(Text_)
        elif nodeName_ == 'Code_Example_Language':
            Code_Example_Language_ = child_.text
            Code_Example_Language_ = self.gds_validate_string(Code_Example_Language_, node, 'Code_Example_Language')
            self.Code_Example_Language.append(Code_Example_Language_)
            self.validate_LanguageEnum(self.Code_Example_Language)    # validate type LanguageEnum
        elif nodeName_ == 'Code':
            Code_ = child_.text
            Code_ = self.gds_validate_string(Code_, node, 'Code')
            self.Code.append(Code_)
        elif nodeName_ == 'Images':
            obj_ = ImagesType.factory()
            obj_.build(child_)
            self.set_Images(obj_)
        elif nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.set_Block(obj_)
# end class StructuredTextType


class Block(GeneratedsSuper):
    """Block is a Structured_Text element consisting of one of Text_Title,
    Text, Code_Example_Language, or Code followed by another Block
    element. Structured_Text elements help define whitespace and
    text segments. This attribute identifies the nature of the
    content containedwithin the Block."""
    subclass = None
    superclass = None
    def __init__(self, Block_Nature=None, Text_Title=None, Text=None, Code_Example_Language=None, Code=None, Images=None, Block=None):
        self.Block_Nature = _cast(None, Block_Nature)
        if Text_Title is None:
            self.Text_Title = []
        else:
            self.Text_Title = Text_Title
        if Text is None:
            self.Text = []
        else:
            self.Text = Text
        if Code_Example_Language is None:
            self.Code_Example_Language = []
        else:
            self.Code_Example_Language = Code_Example_Language
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        self.Images = Images
        self.Block = Block
    def factory(*args_, **kwargs_):
        if Block.subclass:
            return Block.subclass(*args_, **kwargs_)
        else:
            return Block(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text_Title(self): return self.Text_Title
    def set_Text_Title(self, Text_Title): self.Text_Title = Text_Title
    def add_Text_Title(self, value): self.Text_Title.append(value)
    def insert_Text_Title(self, index, value): self.Text_Title[index] = value
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def add_Text(self, value): self.Text.append(value)
    def insert_Text(self, index, value): self.Text[index] = value
    def get_Code_Example_Language(self): return self.Code_Example_Language
    def set_Code_Example_Language(self, Code_Example_Language): self.Code_Example_Language = Code_Example_Language
    def add_Code_Example_Language(self, value): self.Code_Example_Language.append(value)
    def insert_Code_Example_Language(self, index, value): self.Code_Example_Language[index] = value
    def validate_LanguageEnum(self, value):
        # Validate type LanguageEnum, a restriction on xs:string.
        pass
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Images(self): return self.Images
    def set_Images(self, Images): self.Images = Images
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def get_Block_Nature(self): return self.Block_Nature
    def set_Block_Nature(self, Block_Nature): self.Block_Nature = Block_Nature
    def export(self, outfile, level, namespace_='maec:', name_='Block', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Block')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Block'):
        if self.Block_Nature is not None and 'Block_Nature' not in already_processed:
            already_processed.append('Block_Nature')
            outfile.write(' Block_Nature=%s' % (self.gds_format_string(quote_attrib(self.Block_Nature).encode(ExternalEncoding), input_name='Block_Nature'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Block', fromsubclass_=False):
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('<%sText_Title>%s</%sText_Title>\n' % (namespace_, self.gds_format_string(quote_xml(Text_Title_).encode(ExternalEncoding), input_name='Text_Title'), namespace_))
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('<%sText>%s</%sText>\n' % (namespace_, self.gds_format_string(quote_xml(Text_).encode(ExternalEncoding), input_name='Text'), namespace_))
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('<%sCode_Example_Language>%s</%sCode_Example_Language>\n' % (namespace_, self.gds_format_string(quote_xml(Code_Example_Language_).encode(ExternalEncoding), input_name='Code_Example_Language'), namespace_))
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('<%sCode>%s</%sCode>\n' % (namespace_, self.gds_format_string(quote_xml(Code_).encode(ExternalEncoding), input_name='Code'), namespace_))
        if self.Images is not None:
            self.Images.export(outfile, level, namespace_, name_='Images')
        if self.Block is not None:
            self.Block.export(outfile, level, namespace_, name_='Block', )
    def hasContent_(self):
        if (
            self.Text_Title or
            self.Text or
            self.Code_Example_Language or
            self.Code or
            self.Images is not None or
            self.Block is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Block'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Block_Nature is not None and 'Block_Nature' not in already_processed:
            already_processed.append('Block_Nature')
            showIndent(outfile, level)
            outfile.write('Block_Nature = "%s",\n' % (self.Block_Nature,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Text_Title=[\n')
        level += 1
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_Title_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Text=[\n')
        level += 1
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code_Example_Language=[\n')
        level += 1
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_Example_Language_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Images is not None:
            showIndent(outfile, level)
            outfile.write('Images=model_.ImagesType2(\n')
            self.Images.exportLiteral(outfile, level, name_='Images')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Block is not None:
            showIndent(outfile, level)
            outfile.write('Block=model_.Block(\n')
            self.Block.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Block_Nature', node)
        if value is not None and 'Block_Nature' not in already_processed:
            already_processed.append('Block_Nature')
            self.Block_Nature = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text_Title':
            Text_Title_ = child_.text
            Text_Title_ = self.gds_validate_string(Text_Title_, node, 'Text_Title')
            self.Text_Title.append(Text_Title_)
        elif nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text.append(Text_)
        elif nodeName_ == 'Code_Example_Language':
            Code_Example_Language_ = child_.text
            Code_Example_Language_ = self.gds_validate_string(Code_Example_Language_, node, 'Code_Example_Language')
            self.Code_Example_Language.append(Code_Example_Language_)
            self.validate_LanguageEnum(self.Code_Example_Language)    # validate type LanguageEnum
        elif nodeName_ == 'Code':
            Code_ = child_.text
            Code_ = self.gds_validate_string(Code_, node, 'Code')
            self.Code.append(Code_)
        elif nodeName_ == 'Images':
            obj_ = ImagesType2.factory()
            obj_.build(child_)
            self.set_Images(obj_)
        elif nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.set_Block(obj_)
# end class Block


class ActionImplementationType(GeneratedsSuper):
    """ActionImplementationType is intended to serve as a method for the
    characterization of action implementations. Currently supported
    are implementation achieved through API function calls and
    abstractly defined code. The type attribute refers to the type
    of action implementation being characterized. Possible values:
    API_Call, Code, Other."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, API_Call=None, Code=None, Platform=None, Data_Read=None, Data_Written=None, File_System_Action_Attributes=None, IPC_Action_Attributes=None, Process_Action_Attributes=None, Memory_Action_Attributes=None, Registry_Action_Attributes=None, Network_Action_Attributes=None, Module_Action_Attributes=None, Daemon_Action_Attributes=None, System_Action_Attributes=None, Internet_Action_Attributes=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.API_Call = API_Call
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        self.Platform = Platform
        self.Data_Read = Data_Read
        self.Data_Written = Data_Written
        self.File_System_Action_Attributes = File_System_Action_Attributes
        self.IPC_Action_Attributes = IPC_Action_Attributes
        self.Process_Action_Attributes = Process_Action_Attributes
        self.Memory_Action_Attributes = Memory_Action_Attributes
        self.Registry_Action_Attributes = Registry_Action_Attributes
        self.Network_Action_Attributes = Network_Action_Attributes
        self.Module_Action_Attributes = Module_Action_Attributes
        self.Daemon_Action_Attributes = Daemon_Action_Attributes
        self.System_Action_Attributes = System_Action_Attributes
        self.Internet_Action_Attributes = Internet_Action_Attributes
    def factory(*args_, **kwargs_):
        if ActionImplementationType.subclass:
            return ActionImplementationType.subclass(*args_, **kwargs_)
        else:
            return ActionImplementationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_API_Call(self): return self.API_Call
    def set_API_Call(self, API_Call): self.API_Call = API_Call
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Platform(self): return self.Platform
    def set_Platform(self, Platform): self.Platform = Platform
    def get_Data_Read(self): return self.Data_Read
    def set_Data_Read(self, Data_Read): self.Data_Read = Data_Read
    def get_Data_Written(self): return self.Data_Written
    def set_Data_Written(self, Data_Written): self.Data_Written = Data_Written
    def get_File_System_Action_Attributes(self): return self.File_System_Action_Attributes
    def set_File_System_Action_Attributes(self, File_System_Action_Attributes): self.File_System_Action_Attributes = File_System_Action_Attributes
    def get_IPC_Action_Attributes(self): return self.IPC_Action_Attributes
    def set_IPC_Action_Attributes(self, IPC_Action_Attributes): self.IPC_Action_Attributes = IPC_Action_Attributes
    def get_Process_Action_Attributes(self): return self.Process_Action_Attributes
    def set_Process_Action_Attributes(self, Process_Action_Attributes): self.Process_Action_Attributes = Process_Action_Attributes
    def get_Memory_Action_Attributes(self): return self.Memory_Action_Attributes
    def set_Memory_Action_Attributes(self, Memory_Action_Attributes): self.Memory_Action_Attributes = Memory_Action_Attributes
    def get_Registry_Action_Attributes(self): return self.Registry_Action_Attributes
    def set_Registry_Action_Attributes(self, Registry_Action_Attributes): self.Registry_Action_Attributes = Registry_Action_Attributes
    def get_Network_Action_Attributes(self): return self.Network_Action_Attributes
    def set_Network_Action_Attributes(self, Network_Action_Attributes): self.Network_Action_Attributes = Network_Action_Attributes
    def get_Module_Action_Attributes(self): return self.Module_Action_Attributes
    def set_Module_Action_Attributes(self, Module_Action_Attributes): self.Module_Action_Attributes = Module_Action_Attributes
    def get_Daemon_Action_Attributes(self): return self.Daemon_Action_Attributes
    def set_Daemon_Action_Attributes(self, Daemon_Action_Attributes): self.Daemon_Action_Attributes = Daemon_Action_Attributes
    def get_System_Action_Attributes(self): return self.System_Action_Attributes
    def set_System_Action_Attributes(self, System_Action_Attributes): self.System_Action_Attributes = System_Action_Attributes
    def get_Internet_Action_Attributes(self): return self.Internet_Action_Attributes
    def set_Internet_Action_Attributes(self, Internet_Action_Attributes): self.Internet_Action_Attributes = Internet_Action_Attributes
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ActionImplementationType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionImplementationType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionImplementationType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionImplementationType', fromsubclass_=False):
        if self.API_Call is not None:
            self.API_Call.export(outfile, level, namespace_, name_='API_Call')
        for Code_ in self.Code:
            Code_.export(outfile, level, namespace_, name_='Code')
        if self.Platform is not None:
            self.Platform.export(outfile, level, namespace_, name_='Platform')
        if self.Data_Read is not None:
            self.Data_Read.export(outfile, level, namespace_, name_='Data_Read')
        if self.Data_Written is not None:
            self.Data_Written.export(outfile, level, namespace_, name_='Data_Written')
        if self.File_System_Action_Attributes is not None:
            self.File_System_Action_Attributes.export(outfile, level, namespace_, name_='File_System_Action_Attributes')
        if self.IPC_Action_Attributes is not None:
            self.IPC_Action_Attributes.export(outfile, level, namespace_, name_='IPC_Action_Attributes')
        if self.Process_Action_Attributes is not None:
            self.Process_Action_Attributes.export(outfile, level, namespace_, name_='Process_Action_Attributes')
        if self.Memory_Action_Attributes is not None:
            self.Memory_Action_Attributes.export(outfile, level, namespace_, name_='Memory_Action_Attributes')
        if self.Registry_Action_Attributes is not None:
            self.Registry_Action_Attributes.export(outfile, level, namespace_, name_='Registry_Action_Attributes')
        if self.Network_Action_Attributes is not None:
            self.Network_Action_Attributes.export(outfile, level, namespace_, name_='Network_Action_Attributes')
        if self.Module_Action_Attributes is not None:
            self.Module_Action_Attributes.export(outfile, level, namespace_, name_='Module_Action_Attributes')
        if self.Daemon_Action_Attributes is not None:
            self.Daemon_Action_Attributes.export(outfile, level, namespace_, name_='Daemon_Action_Attributes')
        if self.System_Action_Attributes is not None:
            self.System_Action_Attributes.export(outfile, level, namespace_, name_='System_Action_Attributes')
        if self.Internet_Action_Attributes is not None:
            self.Internet_Action_Attributes.export(outfile, level, namespace_, name_='Internet_Action_Attributes')
    def hasContent_(self):
        if (
            self.API_Call is not None or
            self.Code or
            self.Platform is not None or
            self.Data_Read is not None or
            self.Data_Written is not None or
            self.File_System_Action_Attributes is not None or
            self.IPC_Action_Attributes is not None or
            self.Process_Action_Attributes is not None or
            self.Memory_Action_Attributes is not None or
            self.Registry_Action_Attributes is not None or
            self.Network_Action_Attributes is not None or
            self.Module_Action_Attributes is not None or
            self.Daemon_Action_Attributes is not None or
            self.System_Action_Attributes is not None or
            self.Internet_Action_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionImplementationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.API_Call is not None:
            showIndent(outfile, level)
            outfile.write('API_Call=model_.APICallType(\n')
            self.API_Call.exportLiteral(outfile, level, name_='API_Call')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('model_.CodeType(\n')
            Code_.exportLiteral(outfile, level, name_='CodeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Platform is not None:
            showIndent(outfile, level)
            outfile.write('Platform=model_.CPESpecificationType(\n')
            self.Platform.exportLiteral(outfile, level, name_='Platform')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Read is not None:
            showIndent(outfile, level)
            outfile.write('Data_Read=model_.DataType(\n')
            self.Data_Read.exportLiteral(outfile, level, name_='Data_Read')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Written is not None:
            showIndent(outfile, level)
            outfile.write('Data_Written=model_.DataType(\n')
            self.Data_Written.exportLiteral(outfile, level, name_='Data_Written')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Action_Attributes=model_.File_System_Action_AttributesType(\n')
            self.File_System_Action_Attributes.exportLiteral(outfile, level, name_='File_System_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IPC_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('IPC_Action_Attributes=model_.IPC_Action_AttributesType(\n')
            self.IPC_Action_Attributes.exportLiteral(outfile, level, name_='IPC_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Process_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Process_Action_Attributes=model_.Process_Action_AttributesType(\n')
            self.Process_Action_Attributes.exportLiteral(outfile, level, name_='Process_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Memory_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Action_Attributes=model_.Memory_Action_AttributesType(\n')
            self.Memory_Action_Attributes.exportLiteral(outfile, level, name_='Memory_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registry_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Registry_Action_Attributes=model_.Registry_Action_AttributesType(\n')
            self.Registry_Action_Attributes.exportLiteral(outfile, level, name_='Registry_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Network_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Network_Action_Attributes=model_.Network_Action_AttributesType(\n')
            self.Network_Action_Attributes.exportLiteral(outfile, level, name_='Network_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Module_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Module_Action_Attributes=model_.Module_Action_AttributesType(\n')
            self.Module_Action_Attributes.exportLiteral(outfile, level, name_='Module_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Daemon_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Action_Attributes=model_.Daemon_Action_AttributesType(\n')
            self.Daemon_Action_Attributes.exportLiteral(outfile, level, name_='Daemon_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.System_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('System_Action_Attributes=model_.System_Action_AttributesType(\n')
            self.System_Action_Attributes.exportLiteral(outfile, level, name_='System_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Internet_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Internet_Action_Attributes=model_.Internet_Action_AttributesType(\n')
            self.Internet_Action_Attributes.exportLiteral(outfile, level, name_='Internet_Action_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'API_Call':
            obj_ = APICallType.factory()
            obj_.build(child_)
            self.set_API_Call(obj_)
        elif nodeName_ == 'Code':
            obj_ = CodeType.factory()
            obj_.build(child_)
            self.Code.append(obj_)
        elif nodeName_ == 'Platform':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_Platform(obj_)
        elif nodeName_ == 'Data_Read':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Read(obj_)
        elif nodeName_ == 'Data_Written':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Written(obj_)
        elif nodeName_ == 'File_System_Action_Attributes':
            obj_ = File_System_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_File_System_Action_Attributes(obj_)
        elif nodeName_ == 'IPC_Action_Attributes':
            obj_ = IPC_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_IPC_Action_Attributes(obj_)
        elif nodeName_ == 'Process_Action_Attributes':
            obj_ = Process_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Process_Action_Attributes(obj_)
        elif nodeName_ == 'Memory_Action_Attributes':
            obj_ = Memory_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Memory_Action_Attributes(obj_)
        elif nodeName_ == 'Registry_Action_Attributes':
            obj_ = Registry_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Registry_Action_Attributes(obj_)
        elif nodeName_ == 'Network_Action_Attributes':
            obj_ = Network_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Network_Action_Attributes(obj_)
        elif nodeName_ == 'Module_Action_Attributes':
            obj_ = Module_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Module_Action_Attributes(obj_)
        elif nodeName_ == 'Daemon_Action_Attributes':
            obj_ = Daemon_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Daemon_Action_Attributes(obj_)
        elif nodeName_ == 'System_Action_Attributes':
            obj_ = System_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_System_Action_Attributes(obj_)
        elif nodeName_ == 'Internet_Action_Attributes':
            obj_ = Internet_Action_AttributesType.factory()
            obj_.build(child_)
            self.set_Internet_Action_Attributes(obj_)
# end class ActionImplementationType


class CPESpecificationType(GeneratedsSuper):
    """CPESpecificationType is a modularized data type intended for
    providing a consistent approach to uniquely specifying the
    identity of a specific platform using the Common Platform
    Enumeration (CPE) naming standard. http://cpe.mitre.org/The
    cpe_name attribute contains the CPE Name value for the relevant
    platform. A CPE Name is a percent-encoded URI with each name
    starting with the prefix (the URI scheme name) "cpe:". The
    remainder of the name consists of colon separated values
    representing the CPE part, vendor, product, version, update,
    edition and language (i.e. cpe:/ {part} : {vendor} : {product} :
    {version} : {update} : {edition} : {language}).The xmlns_value
    attribute contains the XML namespace descriptor for the CPE
    namespace relevant to this CPE Name use."""
    subclass = None
    superclass = None
    def __init__(self, cpe_name=None, xmlns_value=None, Title=None, meta_item_metadata=None):
        self.cpe_name = _cast(None, cpe_name)
        self.xmlns_value = _cast(None, xmlns_value)
        self.Title = Title
        self.meta_item_metadata = meta_item_metadata
    def factory(*args_, **kwargs_):
        if CPESpecificationType.subclass:
            return CPESpecificationType.subclass(*args_, **kwargs_)
        else:
            return CPESpecificationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_meta_item_metadata(self): return self.meta_item_metadata
    def set_meta_item_metadata(self, meta_item_metadata): self.meta_item_metadata = meta_item_metadata
    def get_cpe_name(self): return self.cpe_name
    def set_cpe_name(self, cpe_name): self.cpe_name = cpe_name
    def get_xmlns_value(self): return self.xmlns_value
    def set_xmlns_value(self, xmlns_value): self.xmlns_value = xmlns_value
    def export(self, outfile, level, namespace_='maec:', name_='CPESpecificationType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CPESpecificationType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='CPESpecificationType'):
        if self.cpe_name is not None and 'cpe_name' not in already_processed:
            already_processed.append('cpe_name')
            outfile.write(' cpe_name=%s' % (self.gds_format_string(quote_attrib(self.cpe_name).encode(ExternalEncoding), input_name='cpe_name'), ))
        if self.xmlns_value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            outfile.write(' xmlns_value=%s' % (self.gds_format_string(quote_attrib(self.xmlns_value).encode(ExternalEncoding), input_name='xmlns_value'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CPESpecificationType', fromsubclass_=False):
        if self.Title is not None:
            self.Title.export(outfile, level, namespace_, name_='Title')
        if self.meta_item_metadata is not None:
            self.meta_item_metadata.export(outfile, level, namespace_, name_='meta-item-metadata')
    def hasContent_(self):
        if (
            self.Title is not None or
            self.meta_item_metadata is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPESpecificationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cpe_name is not None and 'cpe_name' not in already_processed:
            already_processed.append('cpe_name')
            showIndent(outfile, level)
            outfile.write('cpe_name = "%s",\n' % (self.cpe_name,))
        if self.xmlns_value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            showIndent(outfile, level)
            outfile.write('xmlns_value = "%s",\n' % (self.xmlns_value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=model_.TitleType(\n')
            self.Title.exportLiteral(outfile, level, name_='Title')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.meta_item_metadata is not None:
            showIndent(outfile, level)
            outfile.write('meta_item_metadata=model_.meta_item_metadataType(\n')
            self.meta_item_metadata.exportLiteral(outfile, level, name_='meta_item_metadata')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cpe_name', node)
        if value is not None and 'cpe_name' not in already_processed:
            already_processed.append('cpe_name')
            self.cpe_name = value
        value = find_attr_value_('xmlns_value', node)
        if value is not None and 'xmlns_value' not in already_processed:
            already_processed.append('xmlns_value')
            self.xmlns_value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            obj_ = TitleType.factory()
            obj_.build(child_)
            self.set_Title(obj_)
        elif nodeName_ == 'meta-item-metadata':
            obj_ = meta_item_metadataType.factory()
            obj_.build(child_)
            self.set_meta_item_metadata(obj_)
# end class CPESpecificationType


class APICallType(GeneratedsSuper):
    """APICall_ParameterType is intended provide a method for the
    characterization of API calls, namely functions and their
    parameters.The apifunction_name attribute contains the exact
    name of the API function called. E.g. CreateFileW."""
    subclass = None
    superclass = None
    def __init__(self, apifunction_name=None, id=None, Address=None, ReturnValue=None, APICall_Parameter=None):
        self.apifunction_name = _cast(None, apifunction_name)
        self.id = _cast(None, id)
        self.Address = Address
        self.ReturnValue = ReturnValue
        if APICall_Parameter is None:
            self.APICall_Parameter = []
        else:
            self.APICall_Parameter = APICall_Parameter
    def factory(*args_, **kwargs_):
        if APICallType.subclass:
            return APICallType.subclass(*args_, **kwargs_)
        else:
            return APICallType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_ReturnValue(self): return self.ReturnValue
    def set_ReturnValue(self, ReturnValue): self.ReturnValue = ReturnValue
    def get_APICall_Parameter(self): return self.APICall_Parameter
    def set_APICall_Parameter(self, APICall_Parameter): self.APICall_Parameter = APICall_Parameter
    def add_APICall_Parameter(self, value): self.APICall_Parameter.append(value)
    def insert_APICall_Parameter(self, index, value): self.APICall_Parameter[index] = value
    def get_apifunction_name(self): return self.apifunction_name
    def set_apifunction_name(self, apifunction_name): self.apifunction_name = apifunction_name
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='APICallType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='APICallType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='APICallType'):
        if self.apifunction_name is not None and 'apifunction_name' not in already_processed:
            already_processed.append('apifunction_name')
            outfile.write(' apifunction_name=%s' % (self.gds_format_string(quote_attrib(self.apifunction_name).encode(ExternalEncoding), input_name='apifunction_name'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='APICallType', fromsubclass_=False):
        if self.Address is not None:
            self.Address.export(outfile, level, namespace_, name_='Address')
        if self.ReturnValue is not None:
            showIndent(outfile, level)
            outfile.write('<%sReturnValue>%s</%sReturnValue>\n' % (namespace_, self.gds_format_string(quote_xml(self.ReturnValue).encode(ExternalEncoding), input_name='ReturnValue'), namespace_))
        for APICall_Parameter_ in self.APICall_Parameter:
            APICall_Parameter_.export(outfile, level, namespace_, name_='APICall_Parameter')
    def hasContent_(self):
        if (
            self.Address is not None or
            self.ReturnValue is not None or
            self.APICall_Parameter
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='APICallType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.apifunction_name is not None and 'apifunction_name' not in already_processed:
            already_processed.append('apifunction_name')
            showIndent(outfile, level)
            outfile.write('apifunction_name = "%s",\n' % (self.apifunction_name,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=model_.xs_hexBinary(\n')
            self.Address.exportLiteral(outfile, level, name_='Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ReturnValue is not None:
            showIndent(outfile, level)
            outfile.write('ReturnValue=%s,\n' % quote_python(self.ReturnValue).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('APICall_Parameter=[\n')
        level += 1
        for APICall_Parameter_ in self.APICall_Parameter:
            showIndent(outfile, level)
            outfile.write('model_.APICall_ParameterType(\n')
            APICall_Parameter_.exportLiteral(outfile, level, name_='APICall_ParameterType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('apifunction_name', node)
        if value is not None and 'apifunction_name' not in already_processed:
            already_processed.append('apifunction_name')
            self.apifunction_name = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Address(obj_)
        elif nodeName_ == 'ReturnValue':
            ReturnValue_ = child_.text
            ReturnValue_ = self.gds_validate_string(ReturnValue_, node, 'ReturnValue')
            self.ReturnValue = ReturnValue_
        elif nodeName_ == 'APICall_Parameter':
            obj_ = APICall_ParameterType.factory()
            obj_.build(child_)
            self.APICall_Parameter.append(obj_)
# end class APICallType


class ToolType(GeneratedsSuper):
    """ToolType is intended to provide a way of characterizing any tools
    used in the analysis of malware."""
    subclass = None
    superclass = None
    def __init__(self, id=None, Name=None, Version=None, Vendor=None, Organization=None):
        self.id = _cast(None, id)
        self.Name = Name
        self.Version = Version
        self.Vendor = Vendor
        self.Organization = Organization
    def factory(*args_, **kwargs_):
        if ToolType.subclass:
            return ToolType.subclass(*args_, **kwargs_)
        else:
            return ToolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Vendor(self): return self.Vendor
    def set_Vendor(self, Vendor): self.Vendor = Vendor
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ToolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ToolType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ToolType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('<%sVendor>%s</%sVendor>\n' % (namespace_, self.gds_format_string(quote_xml(self.Vendor).encode(ExternalEncoding), input_name='Vendor'), namespace_))
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrganization>%s</%sOrganization>\n' % (namespace_, self.gds_format_string(quote_xml(self.Organization).encode(ExternalEncoding), input_name='Organization'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Version is not None or
            self.Vendor is not None or
            self.Organization is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('Vendor=%s,\n' % quote_python(self.Vendor).encode(ExternalEncoding))
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=%s,\n' % quote_python(self.Organization).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Version':
            Version_ = child_.text
            Version_ = self.gds_validate_string(Version_, node, 'Version')
            self.Version = Version_
        elif nodeName_ == 'Vendor':
            Vendor_ = child_.text
            Vendor_ = self.gds_validate_string(Vendor_, node, 'Vendor')
            self.Vendor = Vendor_
        elif nodeName_ == 'Organization':
            Organization_ = child_.text
            Organization_ = self.gds_validate_string(Organization_, node, 'Organization')
            self.Organization = Organization_
# end class ToolType


class AnalysisType(GeneratedsSuper):
    """AnalysisType is intended to provide a way of characterizing typical
    malware analysis-related metadata, such as the subject of the
    analysis and when it was started.The analysis_method attribute
    is intended to provide a way of characterizing the type of
    analysis method used in the analysis element. Possible values:
    Static, Dynamic, Combinatorial, Other.The start_datetime
    attribute contains the date/time the analysis was started.The
    complete_datetime attribute contains the date/time the analysis
    was completed.The lastupdate_datetime attribute contains the
    date/time the analysis was last updated."""
    subclass = None
    superclass = None
    def __init__(self, start_datetime=None, lastupdate_datetime=None, id=None, complete_datetime=None, analysis_method=None, Subject=None, Description=None, Analysts=None, Source=None, Analysis_Environment=None, Tools_Used=None, Notes=None):
        self.start_datetime = _cast(None, start_datetime)
        self.lastupdate_datetime = _cast(None, lastupdate_datetime)
        self.id = _cast(None, id)
        self.complete_datetime = _cast(None, complete_datetime)
        self.analysis_method = _cast(None, analysis_method)
        if Subject is None:
            self.Subject = []
        else:
            self.Subject = Subject
        self.Description = Description
        self.Analysts = Analysts
        self.Source = Source
        self.Analysis_Environment = Analysis_Environment
        self.Tools_Used = Tools_Used
        self.Notes = Notes
    def factory(*args_, **kwargs_):
        if AnalysisType.subclass:
            return AnalysisType.subclass(*args_, **kwargs_)
        else:
            return AnalysisType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def add_Subject(self, value): self.Subject.append(value)
    def insert_Subject(self, index, value): self.Subject[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Analysts(self): return self.Analysts
    def set_Analysts(self, Analysts): self.Analysts = Analysts
    def get_Source(self): return self.Source
    def set_Source(self, Source): self.Source = Source
    def get_Analysis_Environment(self): return self.Analysis_Environment
    def set_Analysis_Environment(self, Analysis_Environment): self.Analysis_Environment = Analysis_Environment
    def get_Tools_Used(self): return self.Tools_Used
    def set_Tools_Used(self, Tools_Used): self.Tools_Used = Tools_Used
    def get_Notes(self): return self.Notes
    def set_Notes(self, Notes): self.Notes = Notes
    def get_start_datetime(self): return self.start_datetime
    def set_start_datetime(self, start_datetime): self.start_datetime = start_datetime
    def get_lastupdate_datetime(self): return self.lastupdate_datetime
    def set_lastupdate_datetime(self, lastupdate_datetime): self.lastupdate_datetime = lastupdate_datetime
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_complete_datetime(self): return self.complete_datetime
    def set_complete_datetime(self, complete_datetime): self.complete_datetime = complete_datetime
    def get_analysis_method(self): return self.analysis_method
    def set_analysis_method(self, analysis_method): self.analysis_method = analysis_method
    def export(self, outfile, level, namespace_='maec:', name_='AnalysisType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnalysisType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='AnalysisType'):
        if self.start_datetime is not None and 'start_datetime' not in already_processed:
            already_processed.append('start_datetime')
            outfile.write(' start_datetime=%s' % (self.gds_format_string(quote_attrib(self.start_datetime).encode(ExternalEncoding), input_name='start_datetime'), ))
        if self.lastupdate_datetime is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.append('lastupdate_datetime')
            outfile.write(' lastupdate_datetime=%s' % (self.gds_format_string(quote_attrib(self.lastupdate_datetime).encode(ExternalEncoding), input_name='lastupdate_datetime'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.complete_datetime is not None and 'complete_datetime' not in already_processed:
            already_processed.append('complete_datetime')
            outfile.write(' complete_datetime=%s' % (self.gds_format_string(quote_attrib(self.complete_datetime).encode(ExternalEncoding), input_name='complete_datetime'), ))
        if self.analysis_method is not None and 'analysis_method' not in already_processed:
            already_processed.append('analysis_method')
            outfile.write(' analysis_method=%s' % (self.gds_format_string(quote_attrib(self.analysis_method).encode(ExternalEncoding), input_name='analysis_method'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='AnalysisType', fromsubclass_=False):
        for Subject_ in self.Subject:
            Subject_.export(outfile, level, namespace_, name_='Subject')
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Analysts is not None:
            self.Analysts.export(outfile, level, namespace_, name_='Analysts')
        if self.Source is not None:
            self.Source.export(outfile, level, namespace_, name_='Source')
        if self.Analysis_Environment is not None:
            self.Analysis_Environment.export(outfile, level, namespace_, name_='Analysis_Environment')
        if self.Tools_Used is not None:
            self.Tools_Used.export(outfile, level, namespace_, name_='Tools_Used')
        if self.Notes is not None:
            self.Notes.export(outfile, level, namespace_, name_='Notes')
    def hasContent_(self):
        if (
            self.Subject or
            self.Description is not None or
            self.Analysts is not None or
            self.Source is not None or
            self.Analysis_Environment is not None or
            self.Tools_Used is not None or
            self.Notes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AnalysisType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.start_datetime is not None and 'start_datetime' not in already_processed:
            already_processed.append('start_datetime')
            showIndent(outfile, level)
            outfile.write('start_datetime = "%s",\n' % (self.start_datetime,))
        if self.lastupdate_datetime is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.append('lastupdate_datetime')
            showIndent(outfile, level)
            outfile.write('lastupdate_datetime = "%s",\n' % (self.lastupdate_datetime,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.complete_datetime is not None and 'complete_datetime' not in already_processed:
            already_processed.append('complete_datetime')
            showIndent(outfile, level)
            outfile.write('complete_datetime = "%s",\n' % (self.complete_datetime,))
        if self.analysis_method is not None and 'analysis_method' not in already_processed:
            already_processed.append('analysis_method')
            showIndent(outfile, level)
            outfile.write('analysis_method = "%s",\n' % (self.analysis_method,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Subject=[\n')
        level += 1
        for Subject_ in self.Subject:
            showIndent(outfile, level)
            outfile.write('model_.SubjectType(\n')
            Subject_.exportLiteral(outfile, level, name_='SubjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Analysts is not None:
            showIndent(outfile, level)
            outfile.write('Analysts=model_.AnalystsType(\n')
            self.Analysts.exportLiteral(outfile, level, name_='Analysts')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source is not None:
            showIndent(outfile, level)
            outfile.write('Source=model_.SourceType(\n')
            self.Source.exportLiteral(outfile, level, name_='Source')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Analysis_Environment is not None:
            showIndent(outfile, level)
            outfile.write('Analysis_Environment=model_.Analysis_EnvironmentType(\n')
            self.Analysis_Environment.exportLiteral(outfile, level, name_='Analysis_Environment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Tools_Used is not None:
            showIndent(outfile, level)
            outfile.write('Tools_Used=model_.Tools_UsedType(\n')
            self.Tools_Used.exportLiteral(outfile, level, name_='Tools_Used')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Notes is not None:
            showIndent(outfile, level)
            outfile.write('Notes=model_.NotesType(\n')
            self.Notes.exportLiteral(outfile, level, name_='Notes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('start_datetime', node)
        if value is not None and 'start_datetime' not in already_processed:
            already_processed.append('start_datetime')
            self.start_datetime = value
        value = find_attr_value_('lastupdate_datetime', node)
        if value is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.append('lastupdate_datetime')
            self.lastupdate_datetime = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('complete_datetime', node)
        if value is not None and 'complete_datetime' not in already_processed:
            already_processed.append('complete_datetime')
            self.complete_datetime = value
        value = find_attr_value_('analysis_method', node)
        if value is not None and 'analysis_method' not in already_processed:
            already_processed.append('analysis_method')
            self.analysis_method = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Subject':
            obj_ = SubjectType.factory()
            obj_.build(child_)
            self.Subject.append(obj_)
        elif nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Analysts':
            obj_ = AnalystsType.factory()
            obj_.build(child_)
            self.set_Analysts(obj_)
        elif nodeName_ == 'Source':
            obj_ = SourceType.factory()
            obj_.build(child_)
            self.set_Source(obj_)
        elif nodeName_ == 'Analysis_Environment':
            obj_ = Analysis_EnvironmentType.factory()
            obj_.build(child_)
            self.set_Analysis_Environment(obj_)
        elif nodeName_ == 'Tools_Used':
            obj_ = Tools_UsedType.factory()
            obj_.build(child_)
            self.set_Tools_Used(obj_)
        elif nodeName_ == 'Notes':
            obj_ = NotesType.factory()
            obj_.build(child_)
            self.set_Notes(obj_)
# end class AnalysisType


class ObjectReferenceType(GeneratedsSuper):
    """ObjectReferenceType is intended to serve as a method for linking to
    objects.The object_id attribute refers to the ID of the object
    being referenced.This attribute refers to the type of object
    entity being referenced. Possible values: Object, Object
    Collection."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, object_id=None):
        self.type_ = _cast(None, type_)
        self.object_id = _cast(None, object_id)
        pass
    def factory(*args_, **kwargs_):
        if ObjectReferenceType.subclass:
            return ObjectReferenceType.subclass(*args_, **kwargs_)
        else:
            return ObjectReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_object_id(self): return self.object_id
    def set_object_id(self, object_id): self.object_id = object_id
    def export(self, outfile, level, namespace_='maec:', name_='ObjectReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectReferenceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ObjectReferenceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.object_id is not None and 'object_id' not in already_processed:
            already_processed.append('object_id')
            outfile.write(' object_id=%s' % (quote_attrib(self.object_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectReferenceType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.object_id is not None and 'object_id' not in already_processed:
            already_processed.append('object_id')
            showIndent(outfile, level)
            outfile.write('object_id = %s,\n' % (self.object_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('object_id', node)
        if value is not None and 'object_id' not in already_processed:
            already_processed.append('object_id')
            self.object_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ObjectReferenceType


class CVEVulnerabilityType(GeneratedsSuper):
    """CVEVulnerabilityType is intended to provide a way of referencing
    specific vulnerabilities that malware exploits or attempts to
    exploit via a Common Vulnerabilities and Exposures (CPE)
    identifier. For more information on CPE please see
    http://cpe.mitre.org. The cve_id attribute contains the ID of
    the CVE that is being referenced. E.g. CVE-1999-0002."""
    subclass = None
    superclass = None
    def __init__(self, cve_id=None, CVE_Description=None):
        self.cve_id = _cast(None, cve_id)
        self.CVE_Description = CVE_Description
    def factory(*args_, **kwargs_):
        if CVEVulnerabilityType.subclass:
            return CVEVulnerabilityType.subclass(*args_, **kwargs_)
        else:
            return CVEVulnerabilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CVE_Description(self): return self.CVE_Description
    def set_CVE_Description(self, CVE_Description): self.CVE_Description = CVE_Description
    def get_cve_id(self): return self.cve_id
    def set_cve_id(self, cve_id): self.cve_id = cve_id
    def export(self, outfile, level, namespace_='maec:', name_='CVEVulnerabilityType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CVEVulnerabilityType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='CVEVulnerabilityType'):
        if self.cve_id is not None and 'cve_id' not in already_processed:
            already_processed.append('cve_id')
            outfile.write(' cve_id=%s' % (self.gds_format_string(quote_attrib(self.cve_id).encode(ExternalEncoding), input_name='cve_id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CVEVulnerabilityType', fromsubclass_=False):
        if self.CVE_Description is not None:
            showIndent(outfile, level)
            outfile.write('<%sCVE_Description>%s</%sCVE_Description>\n' % (namespace_, self.gds_format_string(quote_xml(self.CVE_Description).encode(ExternalEncoding), input_name='CVE_Description'), namespace_))
    def hasContent_(self):
        if (
            self.CVE_Description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CVEVulnerabilityType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cve_id is not None and 'cve_id' not in already_processed:
            already_processed.append('cve_id')
            showIndent(outfile, level)
            outfile.write('cve_id = "%s",\n' % (self.cve_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CVE_Description is not None:
            showIndent(outfile, level)
            outfile.write('CVE_Description=%s,\n' % quote_python(self.CVE_Description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cve_id', node)
        if value is not None and 'cve_id' not in already_processed:
            already_processed.append('cve_id')
            self.cve_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CVE_Description':
            CVE_Description_ = child_.text
            CVE_Description_ = self.gds_validate_string(CVE_Description_, node, 'CVE_Description')
            self.CVE_Description = CVE_Description_
# end class CVEVulnerabilityType


class ObjectCollectionType(GeneratedsSuper):
    """ObjectCollectionType is intended to provide a mechanism for
    characterizing collections of effects. For instance, it can be
    used to group all of the actions that are associated with a
    specific behavior.The name attribute contains the name of the
    object collection, if applicable."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Object_Sub_Collection=None, Object=None, Object_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        if Object_Sub_Collection is None:
            self.Object_Sub_Collection = []
        else:
            self.Object_Sub_Collection = Object_Sub_Collection
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
    def factory(*args_, **kwargs_):
        if ObjectCollectionType.subclass:
            return ObjectCollectionType.subclass(*args_, **kwargs_)
        else:
            return ObjectCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Object_Sub_Collection(self): return self.Object_Sub_Collection
    def set_Object_Sub_Collection(self, Object_Sub_Collection): self.Object_Sub_Collection = Object_Sub_Collection
    def add_Object_Sub_Collection(self, value): self.Object_Sub_Collection.append(value)
    def insert_Object_Sub_Collection(self, index, value): self.Object_Sub_Collection[index] = value
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='ObjectCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ObjectCollectionType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectCollectionType', fromsubclass_=False):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.gds_format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        for Object_Sub_Collection_ in self.Object_Sub_Collection:
            Object_Sub_Collection_.export(outfile, level, namespace_, name_='Object_Sub_Collection')
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, namespace_, name_='Object_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Object_Sub_Collection or
            self.Object or
            self.Object_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Object_Sub_Collection=[\n')
        level += 1
        for Object_Sub_Collection_ in self.Object_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ObjectCollectionType(\n')
            Object_Sub_Collection_.exportLiteral(outfile, level, name_='ObjectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affinity_Type':
            Affinity_Type_ = child_.text
            Affinity_Type_ = self.gds_validate_string(Affinity_Type_, node, 'Affinity_Type')
            self.Affinity_Type = Affinity_Type_
        elif nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = child_.text
            Affinity_Degree_ = self.gds_validate_string(Affinity_Degree_, node, 'Affinity_Degree')
            self.Affinity_Degree = Affinity_Degree_
        elif nodeName_ == 'Object_Sub_Collection':
            obj_ = ObjectCollectionType.factory()
            obj_.build(child_)
            self.Object_Sub_Collection.append(obj_)
        elif nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
        elif nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
# end class ObjectCollectionType


class DataType(GeneratedsSuper):
    """DataType is intended to provide a relatively abstract way of
    characterizing data segments that may be
    written/read/transmitted or otherwise utilized in actions or
    behaviors. The format attribute refers to the type of data
    contained in this element. Possible values: Binary, Hexadecimal,
    Text, Other."""
    subclass = None
    superclass = None
    def __init__(self, id=None, format=None, Data_Size=None, Discovery_Method=None, Data_Segment=None):
        self.id = _cast(None, id)
        self.format = _cast(None, format)
        self.Data_Size = Data_Size
        self.Discovery_Method = Discovery_Method
        self.Data_Segment = Data_Segment
    def factory(*args_, **kwargs_):
        if DataType.subclass:
            return DataType.subclass(*args_, **kwargs_)
        else:
            return DataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Data_Size(self): return self.Data_Size
    def set_Data_Size(self, Data_Size): self.Data_Size = Data_Size
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Data_Segment(self): return self.Data_Segment
    def set_Data_Segment(self, Data_Segment): self.Data_Segment = Data_Segment
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def export(self, outfile, level, namespace_='maec:', name_='DataType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='DataType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.append('format')
            outfile.write(' format=%s' % (self.gds_format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DataType', fromsubclass_=False):
        if self.Data_Size is not None:
            self.Data_Size.export(outfile, level, namespace_, name_='Data_Size', )
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Data_Segment is not None:
            showIndent(outfile, level)
            outfile.write('<%sData_Segment>%s</%sData_Segment>\n' % (namespace_, self.gds_format_string(quote_xml(self.Data_Segment).encode(ExternalEncoding), input_name='Data_Segment'), namespace_))
    def hasContent_(self):
        if (
            self.Data_Size is not None or
            self.Discovery_Method is not None or
            self.Data_Segment is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.format is not None and 'format' not in already_processed:
            already_processed.append('format')
            showIndent(outfile, level)
            outfile.write('format = "%s",\n' % (self.format,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Data_Size is not None:
            showIndent(outfile, level)
            outfile.write('Data_Size=model_.Data_SizeType(\n')
            self.Data_Size.exportLiteral(outfile, level, name_='Data_Size')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Segment is not None:
            showIndent(outfile, level)
            outfile.write('Data_Segment=%s,\n' % quote_python(self.Data_Segment).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.append('format')
            self.format = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Data_Size':
            obj_ = Data_SizeType.factory()
            obj_.build(child_)
            self.set_Data_Size(obj_)
        elif nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif nodeName_ == 'Data_Segment':
            Data_Segment_ = child_.text
            Data_Segment_ = self.gds_validate_string(Data_Segment_, node, 'Data_Segment')
            self.Data_Segment = Data_Segment_
# end class DataType


class CodeType(GeneratedsSuper):
    """CodeType is intended to provide a way of characterizing segments of
    malicious code that is extracted or otherwise retrieved from
    malware.The codetype attribute is intended to provide a way of
    specifying the type of code being characterized. Possible
    values: Exploit_Code, Shellcode, Unknown, Other.The language
    attribute refers to the programming language used in the code
    characterized in this element. Possible values are: C, C++, C#,
    Java, JSP, Javascript, ASP.NET, SQL, Python, Perl, PHP, SOAP,
    Ruby, Shell, Pseudocode, .NET, Assembly, XML, HTML.If the code
    was discovered inside a binary, the start_address attribute can
    be used to reference the its start address.The processor_family
    attribute is intended to specify the class of processor that the
    code snippet is targeting. Possible values: x86-32, x86-64,
    IA-64, PowerPC, ARM, Alpha, SPARC, z/Architecture, eSi-RISC,
    MIPS, Motorola 68k, Other.The xorpattern attribute contains a 16
    -hexadecimal-character hex string, which represents the pattern
    that the Code_Segment element should be XORed with in order to
    recover the actual code. The default value is 55AA55AA55AA55BB,
    as specified by IETF RFC 5901."""
    subclass = None
    superclass = None
    def __init__(self, language=None, processor_family=None, start_address=None, codetype=None, xorpattern='55AA55AA55AA55BB', id=None, Discovery_Method=None, Code_Segment=None, Code_Segment_XOR=None, External_File=None):
        self.language = _cast(None, language)
        self.processor_family = _cast(None, processor_family)
        self.start_address = _cast(None, start_address)
        self.codetype = _cast(None, codetype)
        self.xorpattern = _cast(None, xorpattern)
        self.id = _cast(None, id)
        self.Discovery_Method = Discovery_Method
        self.Code_Segment = Code_Segment
        self.Code_Segment_XOR = Code_Segment_XOR
        self.External_File = External_File
    def factory(*args_, **kwargs_):
        if CodeType.subclass:
            return CodeType.subclass(*args_, **kwargs_)
        else:
            return CodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Code_Segment(self): return self.Code_Segment
    def set_Code_Segment(self, Code_Segment): self.Code_Segment = Code_Segment
    def get_Code_Segment_XOR(self): return self.Code_Segment_XOR
    def set_Code_Segment_XOR(self, Code_Segment_XOR): self.Code_Segment_XOR = Code_Segment_XOR
    def get_External_File(self): return self.External_File
    def set_External_File(self, External_File): self.External_File = External_File
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_processor_family(self): return self.processor_family
    def set_processor_family(self, processor_family): self.processor_family = processor_family
    def get_start_address(self): return self.start_address
    def set_start_address(self, start_address): self.start_address = start_address
    def get_codetype(self): return self.codetype
    def set_codetype(self, codetype): self.codetype = codetype
    def get_xorpattern(self): return self.xorpattern
    def set_xorpattern(self, xorpattern): self.xorpattern = xorpattern
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='CodeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CodeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='CodeType'):
        if self.language is not None and 'language' not in already_processed:
            already_processed.append('language')
            outfile.write(' language=%s' % (quote_attrib(self.language), ))
        if self.processor_family is not None and 'processor_family' not in already_processed:
            already_processed.append('processor_family')
            outfile.write(' processor_family=%s' % (quote_attrib(self.processor_family), ))
        if self.start_address is not None and 'start_address' not in already_processed:
            already_processed.append('start_address')
            outfile.write(' start_address=%s' % (quote_attrib(self.start_address), ))
        if self.codetype is not None and 'codetype' not in already_processed:
            already_processed.append('codetype')
            outfile.write(' codetype=%s' % (self.gds_format_string(quote_attrib(self.codetype).encode(ExternalEncoding), input_name='codetype'), ))
        if self.xorpattern is not None and 'xorpattern' not in already_processed:
            already_processed.append('xorpattern')
            outfile.write(' xorpattern=%s' % (quote_attrib(self.xorpattern), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CodeType', fromsubclass_=False):
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Code_Segment is not None:
            showIndent(outfile, level)
            outfile.write('<%sCode_Segment>%s</%sCode_Segment>\n' % (namespace_, self.gds_format_string(quote_xml(self.Code_Segment).encode(ExternalEncoding), input_name='Code_Segment'), namespace_))
        if self.Code_Segment_XOR is not None:
            self.Code_Segment_XOR.export(outfile, level, namespace_, name_='Code_Segment_XOR')
        if self.External_File is not None:
            self.External_File.export(outfile, level, namespace_, name_='External_File')
    def hasContent_(self):
        if (
            self.Discovery_Method is not None or
            self.Code_Segment is not None or
            self.Code_Segment_XOR is not None or
            self.External_File is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CodeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.language is not None and 'language' not in already_processed:
            already_processed.append('language')
            showIndent(outfile, level)
            outfile.write('language = %s,\n' % (self.language,))
        if self.processor_family is not None and 'processor_family' not in already_processed:
            already_processed.append('processor_family')
            showIndent(outfile, level)
            outfile.write('processor_family = %s,\n' % (self.processor_family,))
        if self.start_address is not None and 'start_address' not in already_processed:
            already_processed.append('start_address')
            showIndent(outfile, level)
            outfile.write('start_address = %s,\n' % (self.start_address,))
        if self.codetype is not None and 'codetype' not in already_processed:
            already_processed.append('codetype')
            showIndent(outfile, level)
            outfile.write('codetype = "%s",\n' % (self.codetype,))
        if self.xorpattern is not None and 'xorpattern' not in already_processed:
            already_processed.append('xorpattern')
            showIndent(outfile, level)
            outfile.write('xorpattern = %s,\n' % (self.xorpattern,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Code_Segment is not None:
            showIndent(outfile, level)
            outfile.write('Code_Segment=%s,\n' % quote_python(self.Code_Segment).encode(ExternalEncoding))
        if self.Code_Segment_XOR is not None:
            showIndent(outfile, level)
            outfile.write('Code_Segment_XOR=model_.xs_hexBinary(\n')
            self.Code_Segment_XOR.exportLiteral(outfile, level, name_='Code_Segment_XOR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.External_File is not None:
            showIndent(outfile, level)
            outfile.write('External_File=model_.ObjectType(\n')
            self.External_File.exportLiteral(outfile, level, name_='External_File')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.append('language')
            self.language = value
        value = find_attr_value_('processor_family', node)
        if value is not None and 'processor_family' not in already_processed:
            already_processed.append('processor_family')
            self.processor_family = value
        value = find_attr_value_('start_address', node)
        if value is not None and 'start_address' not in already_processed:
            already_processed.append('start_address')
            self.start_address = value
        value = find_attr_value_('codetype', node)
        if value is not None and 'codetype' not in already_processed:
            already_processed.append('codetype')
            self.codetype = value
        value = find_attr_value_('xorpattern', node)
        if value is not None and 'xorpattern' not in already_processed:
            already_processed.append('xorpattern')
            self.xorpattern = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif nodeName_ == 'Code_Segment':
            Code_Segment_ = child_.text
            Code_Segment_ = self.gds_validate_string(Code_Segment_, node, 'Code_Segment')
            self.Code_Segment = Code_Segment_
        elif nodeName_ == 'Code_Segment_XOR':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Code_Segment_XOR(obj_)
        elif nodeName_ == 'External_File':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_External_File(obj_)
# end class CodeType


class DiscoveryMethod(GeneratedsSuper):
    """DiscoveryMethod is intended to provide a mechanism for the
    characterization of how actions, behaviors, malicious code, data
    segments, and other relevant MAEC entities were discovered.The
    tool_id attribute contains the id of the tool used to discovery
    the entity (if applicable).The method attribute contains the
    method used to discover the entity. Possible values are: Static
    Analysis, Dynamic/Runtime Analysis, Other."""
    subclass = None
    superclass = None
    def __init__(self, tool_id=None, method=None):
        self.tool_id = _cast(None, tool_id)
        self.method = _cast(None, method)
        pass
    def factory(*args_, **kwargs_):
        if DiscoveryMethod.subclass:
            return DiscoveryMethod.subclass(*args_, **kwargs_)
        else:
            return DiscoveryMethod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tool_id(self): return self.tool_id
    def set_tool_id(self, tool_id): self.tool_id = tool_id
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def export(self, outfile, level, namespace_='maec:', name_='DiscoveryMethod', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiscoveryMethod')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='DiscoveryMethod'):
        if self.tool_id is not None and 'tool_id' not in already_processed:
            already_processed.append('tool_id')
            outfile.write(' tool_id=%s' % (quote_attrib(self.tool_id), ))
        if self.method is not None and 'method' not in already_processed:
            already_processed.append('method')
            outfile.write(' method=%s' % (self.gds_format_string(quote_attrib(self.method).encode(ExternalEncoding), input_name='method'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DiscoveryMethod', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DiscoveryMethod'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tool_id is not None and 'tool_id' not in already_processed:
            already_processed.append('tool_id')
            showIndent(outfile, level)
            outfile.write('tool_id = %s,\n' % (self.tool_id,))
        if self.method is not None and 'method' not in already_processed:
            already_processed.append('method')
            showIndent(outfile, level)
            outfile.write('method = "%s",\n' % (self.method,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tool_id', node)
        if value is not None and 'tool_id' not in already_processed:
            already_processed.append('tool_id')
            self.tool_id = value
        value = find_attr_value_('method', node)
        if value is not None and 'method' not in already_processed:
            already_processed.append('method')
            self.method = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DiscoveryMethod


class HashType(GeneratedsSuper):
    """HashType is intended as a way of chracterizing the outputs of
    crytopgrahic hash functions.The type attribute refers to the
    type of hash used in the Hash_Value element. Possible choices
    are: SHA1, SHA256, MD5, MD6, Other.The other_type refers to an
    optional attribute, which can be used if it is necessary to
    specify a hash type other than those that are enumerated in the
    'type' attribute."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, other_type=None, Hash_Value=None):
        self.type_ = _cast(None, type_)
        self.other_type = _cast(None, other_type)
        self.Hash_Value = Hash_Value
    def factory(*args_, **kwargs_):
        if HashType.subclass:
            return HashType.subclass(*args_, **kwargs_)
        else:
            return HashType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash_Value(self): return self.Hash_Value
    def set_Hash_Value(self, Hash_Value): self.Hash_Value = Hash_Value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_other_type(self): return self.other_type
    def set_other_type(self, other_type): self.other_type = other_type
    def export(self, outfile, level, namespace_='maec:', name_='HashType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.other_type is not None and 'other_type' not in already_processed:
            already_processed.append('other_type')
            outfile.write(' other_type=%s' % (self.gds_format_string(quote_attrib(self.other_type).encode(ExternalEncoding), input_name='other_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashType', fromsubclass_=False):
        if self.Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sHash_Value>%s</%sHash_Value>\n' % (namespace_, self.gds_format_string(quote_xml(self.Hash_Value).encode(ExternalEncoding), input_name='Hash_Value'), namespace_))
    def hasContent_(self):
        if (
            self.Hash_Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.other_type is not None and 'other_type' not in already_processed:
            already_processed.append('other_type')
            showIndent(outfile, level)
            outfile.write('other_type = "%s",\n' % (self.other_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Hash_Value=model_.xs_hexBinary(\n')
            self.Hash_Value.exportLiteral(outfile, level, name_='Hash_Value')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('other_type', node)
        if value is not None and 'other_type' not in already_processed:
            already_processed.append('other_type')
            self.other_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash_Value':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Hash_Value(obj_)
# end class HashType


class PEDataDirectoryStruct(GeneratedsSuper):
    """PEDataDirectoryStruct is intended as container for the attributes
    present in a PE binary's data directory structure."""
    subclass = None
    superclass = None
    def __init__(self, Virtual_Address=None, Size=None):
        self.Virtual_Address = Virtual_Address
        self.Size = Size
    def factory(*args_, **kwargs_):
        if PEDataDirectoryStruct.subclass:
            return PEDataDirectoryStruct.subclass(*args_, **kwargs_)
        else:
            return PEDataDirectoryStruct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def export(self, outfile, level, namespace_='maec:', name_='PEDataDirectoryStruct', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEDataDirectoryStruct')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PEDataDirectoryStruct'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEDataDirectoryStruct', fromsubclass_=False):
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, namespace_, name_='Virtual_Address', )
        if self.Size is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize>%s</%sSize>\n' % (namespace_, self.gds_format_integer(self.Size, input_name='Size'), namespace_))
    def hasContent_(self):
        if (
            self.Virtual_Address is not None or
            self.Size is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEDataDirectoryStruct'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.xs_hexBinary(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size is not None:
            showIndent(outfile, level)
            outfile.write('Size=%d,\n' % self.Size)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Virtual_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
# end class PEDataDirectoryStruct


class PESectionHeaderStruct(GeneratedsSuper):
    """PESectionHeaderStruct is intended as container for the attributes
    present in a PE binary's section header structure."""
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Name=None, Physical_Address=None, Virtual_Address=None, Size_Of_Raw_Data=None, Pointer_To_Raw_Data=None, Pointer_To_Relocations=None, Pointer_To_Linenumbers=None, Number_Of_Relocations=None, Number_Of_Linenumbers=None, Characteristics=None):
        self.Hashes = Hashes
        self.Name = Name
        self.Physical_Address = Physical_Address
        self.Virtual_Address = Virtual_Address
        self.Size_Of_Raw_Data = Size_Of_Raw_Data
        self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
        self.Pointer_To_Relocations = Pointer_To_Relocations
        self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
        self.Number_Of_Relocations = Number_Of_Relocations
        self.Number_Of_Linenumbers = Number_Of_Linenumbers
        self.Characteristics = Characteristics
    def factory(*args_, **kwargs_):
        if PESectionHeaderStruct.subclass:
            return PESectionHeaderStruct.subclass(*args_, **kwargs_)
        else:
            return PESectionHeaderStruct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Physical_Address(self): return self.Physical_Address
    def set_Physical_Address(self, Physical_Address): self.Physical_Address = Physical_Address
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Size_Of_Raw_Data(self): return self.Size_Of_Raw_Data
    def set_Size_Of_Raw_Data(self, Size_Of_Raw_Data): self.Size_Of_Raw_Data = Size_Of_Raw_Data
    def get_Pointer_To_Raw_Data(self): return self.Pointer_To_Raw_Data
    def set_Pointer_To_Raw_Data(self, Pointer_To_Raw_Data): self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
    def get_Pointer_To_Relocations(self): return self.Pointer_To_Relocations
    def set_Pointer_To_Relocations(self, Pointer_To_Relocations): self.Pointer_To_Relocations = Pointer_To_Relocations
    def get_Pointer_To_Linenumbers(self): return self.Pointer_To_Linenumbers
    def set_Pointer_To_Linenumbers(self, Pointer_To_Linenumbers): self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
    def get_Number_Of_Relocations(self): return self.Number_Of_Relocations
    def set_Number_Of_Relocations(self, Number_Of_Relocations): self.Number_Of_Relocations = Number_Of_Relocations
    def get_Number_Of_Linenumbers(self): return self.Number_Of_Linenumbers
    def set_Number_Of_Linenumbers(self, Number_Of_Linenumbers): self.Number_Of_Linenumbers = Number_Of_Linenumbers
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def export(self, outfile, level, namespace_='maec:', name_='PESectionHeaderStruct', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PESectionHeaderStruct')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PESectionHeaderStruct'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PESectionHeaderStruct', fromsubclass_=False):
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Physical_Address is not None:
            self.Physical_Address.export(outfile, level, namespace_, name_='Physical_Address')
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, namespace_, name_='Virtual_Address')
        if self.Size_Of_Raw_Data is not None:
            self.Size_Of_Raw_Data.export(outfile, level, namespace_, name_='Size_Of_Raw_Data')
        if self.Pointer_To_Raw_Data is not None:
            self.Pointer_To_Raw_Data.export(outfile, level, namespace_, name_='Pointer_To_Raw_Data')
        if self.Pointer_To_Relocations is not None:
            self.Pointer_To_Relocations.export(outfile, level, namespace_, name_='Pointer_To_Relocations')
        if self.Pointer_To_Linenumbers is not None:
            self.Pointer_To_Linenumbers.export(outfile, level, namespace_, name_='Pointer_To_Linenumbers')
        if self.Number_Of_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Relocations>%s</%sNumber_Of_Relocations>\n' % (namespace_, self.gds_format_integer(self.Number_Of_Relocations, input_name='Number_Of_Relocations'), namespace_))
        if self.Number_Of_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Linenumbers>%s</%sNumber_Of_Linenumbers>\n' % (namespace_, self.gds_format_integer(self.Number_Of_Linenumbers, input_name='Number_Of_Linenumbers'), namespace_))
        if self.Characteristics is not None:
            self.Characteristics.export(outfile, level, namespace_, name_='Characteristics')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Name is not None or
            self.Physical_Address is not None or
            self.Virtual_Address is not None or
            self.Size_Of_Raw_Data is not None or
            self.Pointer_To_Raw_Data is not None or
            self.Pointer_To_Relocations is not None or
            self.Pointer_To_Linenumbers is not None or
            self.Number_Of_Relocations is not None or
            self.Number_Of_Linenumbers is not None or
            self.Characteristics is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionHeaderStruct'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType5(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Physical_Address is not None:
            showIndent(outfile, level)
            outfile.write('Physical_Address=model_.xs_hexBinary(\n')
            self.Physical_Address.exportLiteral(outfile, level, name_='Physical_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.xs_hexBinary(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Raw_Data=model_.xs_hexBinary(\n')
            self.Size_Of_Raw_Data.exportLiteral(outfile, level, name_='Size_Of_Raw_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Raw_Data=model_.xs_hexBinary(\n')
            self.Pointer_To_Raw_Data.exportLiteral(outfile, level, name_='Pointer_To_Raw_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Relocations=model_.xs_hexBinary(\n')
            self.Pointer_To_Relocations.exportLiteral(outfile, level, name_='Pointer_To_Relocations')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Linenumbers=model_.xs_hexBinary(\n')
            self.Pointer_To_Linenumbers.exportLiteral(outfile, level, name_='Pointer_To_Linenumbers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Relocations=%d,\n' % self.Number_Of_Relocations)
        if self.Number_Of_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Linenumbers=%d,\n' % self.Number_Of_Linenumbers)
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=model_.xs_hexBinary(\n')
            self.Characteristics.exportLiteral(outfile, level, name_='Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = HashesType5.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Physical_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Physical_Address(obj_)
        elif nodeName_ == 'Virtual_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Size_Of_Raw_Data':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Raw_Data(obj_)
        elif nodeName_ == 'Pointer_To_Raw_Data':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Pointer_To_Raw_Data(obj_)
        elif nodeName_ == 'Pointer_To_Relocations':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Pointer_To_Relocations(obj_)
        elif nodeName_ == 'Pointer_To_Linenumbers':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Pointer_To_Linenumbers(obj_)
        elif nodeName_ == 'Number_Of_Relocations':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Number_Of_Relocations')
            self.Number_Of_Relocations = ival_
        elif nodeName_ == 'Number_Of_Linenumbers':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Number_Of_Linenumbers')
            self.Number_Of_Linenumbers = ival_
        elif nodeName_ == 'Characteristics':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Characteristics(obj_)
# end class PESectionHeaderStruct


class PEStringType(GeneratedsSuper):
    """PEStringType is intended as container for strings extracted from PE
    binaries.The address attribute refers to the location of the
    specified string in the PE binary.The encoding attribute refers
    to the encoding method used for the string extracted from the PE
    binary. Possible values are: ANSI, Unicode, Other.The length
    attribute refers to the length, in characters, of the string
    extracted from the PE binary."""
    subclass = None
    superclass = None
    def __init__(self, length=None, encoding=None, address=None, String_Value=None, Hashes=None):
        self.length = _cast(int, length)
        self.encoding = _cast(None, encoding)
        self.address = _cast(None, address)
        self.String_Value = String_Value
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEStringType.subclass:
            return PEStringType.subclass(*args_, **kwargs_)
        else:
            return PEStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String_Value(self): return self.String_Value
    def set_String_Value(self, String_Value): self.String_Value = String_Value
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def get_encoding(self): return self.encoding
    def set_encoding(self, encoding): self.encoding = encoding
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def export(self, outfile, level, namespace_='maec:', name_='PEStringType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEStringType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PEStringType'):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_integer(self.length, input_name='length'))
        if self.encoding is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            outfile.write(' encoding=%s' % (self.gds_format_string(quote_attrib(self.encoding).encode(ExternalEncoding), input_name='encoding'), ))
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            outfile.write(' address=%s' % (quote_attrib(self.address), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEStringType', fromsubclass_=False):
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sString_Value>%s</%sString_Value>\n' % (namespace_, self.gds_format_string(quote_xml(self.String_Value).encode(ExternalEncoding), input_name='String_Value'), namespace_))
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
    def hasContent_(self):
        if (
            self.String_Value is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEStringType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
        if self.encoding is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            showIndent(outfile, level)
            outfile.write('encoding = "%s",\n' % (self.encoding,))
        if self.address is not None and 'address' not in already_processed:
            already_processed.append('address')
            showIndent(outfile, level)
            outfile.write('address = %s,\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('String_Value=%s,\n' % quote_python(self.String_Value).encode(ExternalEncoding))
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType6(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
        value = find_attr_value_('encoding', node)
        if value is not None and 'encoding' not in already_processed:
            already_processed.append('encoding')
            self.encoding = value
        value = find_attr_value_('address', node)
        if value is not None and 'address' not in already_processed:
            already_processed.append('address')
            self.address = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'String_Value':
            String_Value_ = child_.text
            String_Value_ = self.gds_validate_string(String_Value_, node, 'String_Value')
            self.String_Value = String_Value_
        elif nodeName_ == 'Hashes':
            obj_ = HashesType6.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEStringType


class PEImportType(GeneratedsSuper):
    """PEImportType is intended as container for the attributes relevant to
    PE binary imports.The type attribute refers to the type of
    import, with regards to being initially visible or hidden in
    relation to PE binary packing. A packed binary will typically
    have few initially visible imports, and thus it is necessary to
    make the distinction between those that are visible initially or
    only after the binary is unpacked. Thus, the possible values for
    this attribute are: Initially Visible, Initially Hidden.The
    delay_load attribute is a boolean value that is intended to
    describe whether a PE binary import is delay-load or not."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, delay_load=None, File_Name=None, Virtual_Address=None, Imported_Functions=None):
        self.type_ = _cast(None, type_)
        self.delay_load = _cast(bool, delay_load)
        self.File_Name = File_Name
        self.Virtual_Address = Virtual_Address
        self.Imported_Functions = Imported_Functions
    def factory(*args_, **kwargs_):
        if PEImportType.subclass:
            return PEImportType.subclass(*args_, **kwargs_)
        else:
            return PEImportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Imported_Functions(self): return self.Imported_Functions
    def set_Imported_Functions(self, Imported_Functions): self.Imported_Functions = Imported_Functions
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_delay_load(self): return self.delay_load
    def set_delay_load(self, delay_load): self.delay_load = delay_load
    def export(self, outfile, level, namespace_='maec:', name_='PEImportType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEImportType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PEImportType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.delay_load is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            outfile.write(' delay_load="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.delay_load)), input_name='delay_load'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEImportType', fromsubclass_=False):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Name>%s</%sFile_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.File_Name).encode(ExternalEncoding), input_name='File_Name'), namespace_))
        if self.Virtual_Address is not None:
            self.Virtual_Address.export(outfile, level, namespace_, name_='Virtual_Address')
        if self.Imported_Functions is not None:
            self.Imported_Functions.export(outfile, level, namespace_, name_='Imported_Functions')
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.Virtual_Address is not None or
            self.Imported_Functions is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.delay_load is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            showIndent(outfile, level)
            outfile.write('delay_load = %s,\n' % (self.delay_load,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('File_Name=%s,\n' % quote_python(self.File_Name).encode(ExternalEncoding))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.xs_hexBinary(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imported_Functions is not None:
            showIndent(outfile, level)
            outfile.write('Imported_Functions=model_.Imported_FunctionsType(\n')
            self.Imported_Functions.exportLiteral(outfile, level, name_='Imported_Functions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('delay_load', node)
        if value is not None and 'delay_load' not in already_processed:
            already_processed.append('delay_load')
            if value in ('true', '1'):
                self.delay_load = True
            elif value in ('false', '0'):
                self.delay_load = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File_Name':
            File_Name_ = child_.text
            File_Name_ = self.gds_validate_string(File_Name_, node, 'File_Name')
            self.File_Name = File_Name_
        elif nodeName_ == 'Virtual_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Imported_Functions':
            obj_ = Imported_FunctionsType.factory()
            obj_.build(child_)
            self.set_Imported_Functions(obj_)
# end class PEImportType


class PEExportType(GeneratedsSuper):
    """PEExportType is intended as container for the attributes relevant to
    PE binary exports."""
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Entry_Point=None, Ordinal=None):
        self.Function_Name = Function_Name
        self.Entry_Point = Entry_Point
        self.Ordinal = Ordinal
    def factory(*args_, **kwargs_):
        if PEExportType.subclass:
            return PEExportType.subclass(*args_, **kwargs_)
        else:
            return PEExportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Entry_Point(self): return self.Entry_Point
    def set_Entry_Point(self, Entry_Point): self.Entry_Point = Entry_Point
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def export(self, outfile, level, namespace_='maec:', name_='PEExportType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEExportType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PEExportType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEExportType', fromsubclass_=False):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntry_Point>%s</%sEntry_Point>\n' % (namespace_, self.gds_format_string(quote_xml(self.Entry_Point).encode(ExternalEncoding), input_name='Entry_Point'), namespace_))
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrdinal>%s</%sOrdinal>\n' % (namespace_, self.gds_format_integer(self.Ordinal, input_name='Ordinal'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Entry_Point is not None or
            self.Ordinal is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEExportType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Entry_Point=model_.xs_hexBinary(\n')
            self.Entry_Point.exportLiteral(outfile, level, name_='Entry_Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=%d,\n' % self.Ordinal)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function_Name':
            Function_Name_ = child_.text
            Function_Name_ = self.gds_validate_string(Function_Name_, node, 'Function_Name')
            self.Function_Name = Function_Name_
        elif nodeName_ == 'Entry_Point':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Entry_Point(obj_)
        elif nodeName_ == 'Ordinal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Ordinal')
            self.Ordinal = ival_
# end class PEExportType


class PESectionType(GeneratedsSuper):
    """PESectionType is intended as container for the attributes relevant
    to PE binary sections."""
    subclass = None
    superclass = None
    def __init__(self, Header_Hashes=None, Data_Hashes=None, Section_Name=None, Entropy=None, Virtual_Address=None, Virtual_Size=None, Flags=None, Relocations=None):
        self.Header_Hashes = Header_Hashes
        self.Data_Hashes = Data_Hashes
        self.Section_Name = Section_Name
        self.Entropy = Entropy
        self.Virtual_Address = Virtual_Address
        self.Virtual_Size = Virtual_Size
        self.Flags = Flags
        self.Relocations = Relocations
    def factory(*args_, **kwargs_):
        if PESectionType.subclass:
            return PESectionType.subclass(*args_, **kwargs_)
        else:
            return PESectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Header_Hashes(self): return self.Header_Hashes
    def set_Header_Hashes(self, Header_Hashes): self.Header_Hashes = Header_Hashes
    def get_Data_Hashes(self): return self.Data_Hashes
    def set_Data_Hashes(self, Data_Hashes): self.Data_Hashes = Data_Hashes
    def get_Section_Name(self): return self.Section_Name
    def set_Section_Name(self, Section_Name): self.Section_Name = Section_Name
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Virtual_Size(self): return self.Virtual_Size
    def set_Virtual_Size(self, Virtual_Size): self.Virtual_Size = Virtual_Size
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def get_Relocations(self): return self.Relocations
    def set_Relocations(self, Relocations): self.Relocations = Relocations
    def export(self, outfile, level, namespace_='maec:', name_='PESectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PESectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PESectionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PESectionType', fromsubclass_=False):
        if self.Header_Hashes is not None:
            self.Header_Hashes.export(outfile, level, namespace_, name_='Header_Hashes')
        if self.Data_Hashes is not None:
            self.Data_Hashes.export(outfile, level, namespace_, name_='Data_Hashes')
        if self.Section_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sSection_Name>%s</%sSection_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Section_Name).encode(ExternalEncoding), input_name='Section_Name'), namespace_))
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntropy>%s</%sEntropy>\n' % (namespace_, self.gds_format_float(self.Entropy, input_name='Entropy'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.gds_format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Virtual_Size is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Size>%s</%sVirtual_Size>\n' % (namespace_, self.gds_format_integer(self.Virtual_Size, input_name='Virtual_Size'), namespace_))
        if self.Flags is not None:
            self.Flags.export(outfile, level, namespace_, name_='Flags')
        if self.Relocations is not None:
            showIndent(outfile, level)
            outfile.write('<%sRelocations>%s</%sRelocations>\n' % (namespace_, self.gds_format_integer(self.Relocations, input_name='Relocations'), namespace_))
    def hasContent_(self):
        if (
            self.Header_Hashes is not None or
            self.Data_Hashes is not None or
            self.Section_Name is not None or
            self.Entropy is not None or
            self.Virtual_Address is not None or
            self.Virtual_Size is not None or
            self.Flags is not None or
            self.Relocations is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Header_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Header_Hashes=model_.Header_HashesType(\n')
            self.Header_Hashes.exportLiteral(outfile, level, name_='Header_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Data_Hashes=model_.Data_HashesType(\n')
            self.Data_Hashes.exportLiteral(outfile, level, name_='Data_Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Name is not None:
            showIndent(outfile, level)
            outfile.write('Section_Name=%s,\n' % quote_python(self.Section_Name).encode(ExternalEncoding))
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=%f,\n' % self.Entropy)
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.xs_hexBinary(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Virtual_Size is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Size=%d,\n' % self.Virtual_Size)
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=model_.xs_hexBinary(\n')
            self.Flags.exportLiteral(outfile, level, name_='Flags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Relocations=%d,\n' % self.Relocations)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Header_Hashes':
            obj_ = Header_HashesType.factory()
            obj_.build(child_)
            self.set_Header_Hashes(obj_)
        elif nodeName_ == 'Data_Hashes':
            obj_ = Data_HashesType.factory()
            obj_.build(child_)
            self.set_Data_Hashes(obj_)
        elif nodeName_ == 'Section_Name':
            Section_Name_ = child_.text
            Section_Name_ = self.gds_validate_string(Section_Name_, node, 'Section_Name')
            self.Section_Name = Section_Name_
        elif nodeName_ == 'Entropy':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires float or double: %s' % e)
            fval_ = self.gds_validate_float(fval_, node, 'Entropy')
            self.Entropy = fval_
        elif nodeName_ == 'Virtual_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Virtual_Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Virtual_Size')
            self.Virtual_Size = ival_
        elif nodeName_ == 'Flags':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Flags(obj_)
        elif nodeName_ == 'Relocations':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Relocations')
            self.Relocations = ival_
# end class PESectionType


class PEResourceType(GeneratedsSuper):
    """PEResourceType is intended as container for the attributes relevant
    to PE binary resources.The type attribute refers to the type of
    data referred to by this resource. Possible values are: Cursor,
    Bitmap, Icon, Menu, Dialog, String, Fontdir, Font, Accelerator,
    RCData, MessageTable, GroupCursor, GroupIcon, Version,
    DLGInclude, PlugPlay, Vxd, AniCursor, AniIcon, HTML, Manifest,
    Other."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, Name=None, Hashes=None):
        self.type_ = _cast(None, type_)
        self.Name = Name
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEResourceType.subclass:
            return PEResourceType.subclass(*args_, **kwargs_)
        else:
            return PEResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='PEResourceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PEResourceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PEResourceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEResourceType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEResourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType7(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Hashes':
            obj_ = HashesType7.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEResourceType


class malwareMetaData(GeneratedsSuper):
    """This is the top level element for the xml document. Required
    attribute is version. Open issues: 2. Right way to express
    commonality in field data so that it can be combined properly 3.
    How to handle unicode in urls Change list 11/12/2009 1. adding
    documentation across the schema 2. added partner to
    OriginTypeEnum 3. made sha1 in fileObject optional 4. added
    isDamaged as a propertyType 5. changed property name isNon-
    replicating to isNonReplicating 6/11/2009 1. incremented version
    2.Rename parents/children in relationship to source/target 3.
    Add generic relationship, ‘relatedTo’ 4. Make commonality
    element in fieldDataEntry optional 5. Add unknown element to
    origintypeenum 6. Remove ipv4 and ipv6 from locationenum 7. Make
    id on ip object startaddress-endaddress even if startaddress ==
    endaddress. Added IPRange type 8. Add optional firstSeenDate to
    fieldDataEntry, for first time entity providing data saw the
    object 6/4/2009 1. File - id should be a xs:hexBinary 2. File -
    extraHash should be a xs:string 3. Uri – add optional
    ipProtocol field, with enumeration of values tcp/udp/icmp etc.
    4. Uri – add documentation that protocol in uri needs to be
    either from well known list (from iana.org) or ‘unknown’ 5.
    Domain - need to fix documentation for domain – example is
    wrong 6. registry – remove valuedata – it is in a property
    7. ip object – rename to ip, and give it a start address and
    end address. Share a single address by making start and end the
    same. Id will be address or startaddress-endaddress 8. service
    – delete – subsumed by uri with extra data elements in it 9.
    classification – remove modifiers (attributes) on category and
    put in properties 10. classification – add documentation that
    category is companyname:category 11. objectProperty – move
    timestamp to be top level instead of on each property and make
    it required 12. relationship – make timestamp required 13.
    relationship – add doc on runs. removed 'exploits' - it refers
    to environment object that no longer exists 14. added comment
    field to propertyenum 15. made timeStamp -> timestamp for
    consistency 16.incremented version 5/31/2009 1. incremented
    version 2. changed url to uri 3. removed environment object and
    related enumerations 4. added restriction on uri to not allow a
    question mark (?) 5/15/2009 1. incremented version 2. Added
    neutral classification type 3. Added numberOfWebsitesHosting and
    numberOfWebsitesRedirecting to volume units enumeration 4. added
    referrer, operatingSystem, userAgent and browser to properties
    5. made classification type attribute required 5/8/2009 1. added
    new object type for asn 2. moved domain information to
    properties, so that domains info can be timestamped 3. added
    properties for geolocation of an ip address 4. added property
    for location url for a file 5. added VolumeUnitsEnum and volume
    tag in fieldData. This is to allow sharing of actual prevalence
    numbers, with various units. 6. Added ipProtocol (tcp/udp) to
    service object. Also changed names of expectedProtocol and
    actualProtocol to be expectedApplicationProtocol and
    actualApplicationProtocol 7. added 'references' surrounding tag
    to ref tag in fieldDataEntry and objectProperty, so that can
    assign multiple references if required 8. made id on file back
    to hexBinary. Use length to figure out what hash it is. 9.
    incremented version 10. added properties for httpMethod and
    postData 11. added relationship types 'contactedBy' and
    'downloadedFrom' 4/17/2009 1. Incremented version 2. Added
    unwanted to ClassificationTypeEnum 3. Added text about ids for
    files to documentation 4. Removed filename from file object
    definition 5. Relaxed requirement on id of file to be an
    xs:hexString to be an xs:string to allow e.g. md5:aaaaabbbbccc
    as an id. Not enormously happy about that… 6. Made sha256
    optional and sha1 required in files 7. Added “open issues”
    section in documentation for top level element 8. Category is
    now an xs:string; deleted CategoryTypeEnum 9. Added comment to
    doc on fieldDataEntry about using standard time periods, but
    kept start date and end date 10. Added objectProperties element,
    and example illustratingProperties.xml. Currently allowed
    properties are filename, filepath, registryValueData and
    urlParameterString. There is an optional timestamp on each
    property. I allowed objectProperty to have an id, so that it can
    be referenced elsewhere, although we might want to re-think
    that. 11. Added some better documentation to relationships 12.
    Added more documentation throughout The version of the schema.
    This is currently fixed to be 1.1. A required identifier for the
    document."""
    subclass = None
    superclass = None
    def __init__(self, version=None, id=None, company=None, author=None, comment=None, timestamp=None, objects=None, objectProperties=None, relationships=None, fieldData=None):
        self.version = _cast(float, version)
        self.id = _cast(None, id)
        self.company = company
        self.author = author
        self.comment = comment
        self.timestamp = timestamp
        self.objects = objects
        self.objectProperties = objectProperties
        self.relationships = relationships
        self.fieldData = fieldData
    def factory(*args_, **kwargs_):
        if malwareMetaData.subclass:
            return malwareMetaData.subclass(*args_, **kwargs_)
        else:
            return malwareMetaData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_company(self): return self.company
    def set_company(self, company): self.company = company
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_objects(self): return self.objects
    def set_objects(self, objects): self.objects = objects
    def get_objectProperties(self): return self.objectProperties
    def set_objectProperties(self, objectProperties): self.objectProperties = objectProperties
    def get_relationships(self): return self.relationships
    def set_relationships(self, relationships): self.relationships = relationships
    def get_fieldData(self): return self.fieldData
    def set_fieldData(self, fieldData): self.fieldData = fieldData
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='malwareMetaData', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='malwareMetaData')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='malwareMetaData'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            outfile.write(' version="%s"' % self.gds_format_float(self.version, input_name='version'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='malwareMetaData', fromsubclass_=False):
        if self.company is not None:
            showIndent(outfile, level)
            outfile.write('<%scompany>%s</%scompany>\n' % (namespace_, self.gds_format_string(quote_xml(self.company).encode(ExternalEncoding), input_name='company'), namespace_))
        if self.author is not None:
            showIndent(outfile, level)
            outfile.write('<%sauthor>%s</%sauthor>\n' % (namespace_, self.gds_format_string(quote_xml(self.author).encode(ExternalEncoding), input_name='author'), namespace_))
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('<%scomment>%s</%scomment>\n' % (namespace_, self.gds_format_string(quote_xml(self.comment).encode(ExternalEncoding), input_name='comment'), namespace_))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('<%stimestamp>%s</%stimestamp>\n' % (namespace_, self.gds_format_string(quote_xml(self.timestamp).encode(ExternalEncoding), input_name='timestamp'), namespace_))
        if self.objects is not None:
            self.objects.export(outfile, level, namespace_, name_='objects')
        if self.objectProperties is not None:
            self.objectProperties.export(outfile, level, namespace_, name_='objectProperties')
        if self.relationships is not None:
            self.relationships.export(outfile, level, namespace_, name_='relationships')
        if self.fieldData is not None:
            self.fieldData.export(outfile, level, namespace_, name_='fieldData')
    def hasContent_(self):
        if (
            self.company is not None or
            self.author is not None or
            self.comment is not None or
            self.timestamp is not None or
            self.objects is not None or
            self.objectProperties is not None or
            self.relationships is not None or
            self.fieldData is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='malwareMetaData'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            showIndent(outfile, level)
            outfile.write('version = %f,\n' % (self.version,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.company is not None:
            showIndent(outfile, level)
            outfile.write('company=%s,\n' % quote_python(self.company).encode(ExternalEncoding))
        if self.author is not None:
            showIndent(outfile, level)
            outfile.write('author=%s,\n' % quote_python(self.author).encode(ExternalEncoding))
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('comment=%s,\n' % quote_python(self.comment).encode(ExternalEncoding))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp=%s,\n' % quote_python(self.timestamp).encode(ExternalEncoding))
        if self.objects is not None:
            showIndent(outfile, level)
            outfile.write('objects=model_.objectsType(\n')
            self.objects.exportLiteral(outfile, level, name_='objects')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.objectProperties is not None:
            showIndent(outfile, level)
            outfile.write('objectProperties=model_.objectPropertiesType(\n')
            self.objectProperties.exportLiteral(outfile, level, name_='objectProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.relationships is not None:
            showIndent(outfile, level)
            outfile.write('relationships=model_.relationshipsType(\n')
            self.relationships.exportLiteral(outfile, level, name_='relationships')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fieldData is not None:
            showIndent(outfile, level)
            outfile.write('fieldData=model_.fieldDataType(\n')
            self.fieldData.exportLiteral(outfile, level, name_='fieldData')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.append('version')
            try:
                self.version = float(value)
            except ValueError as e:
                raise ValueError('Bad float/double attribute (version): %s' % e)
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'company':
            company_ = child_.text
            company_ = self.gds_validate_string(company_, node, 'company')
            self.company = company_
        elif nodeName_ == 'author':
            author_ = child_.text
            author_ = self.gds_validate_string(author_, node, 'author')
            self.author = author_
        elif nodeName_ == 'comment':
            comment_ = child_.text
            comment_ = self.gds_validate_string(comment_, node, 'comment')
            self.comment = comment_
        elif nodeName_ == 'timestamp':
            timestamp_ = child_.text
            timestamp_ = self.gds_validate_string(timestamp_, node, 'timestamp')
            self.timestamp = timestamp_
        elif nodeName_ == 'objects':
            obj_ = objectsType.factory()
            obj_.build(child_)
            self.set_objects(obj_)
        elif nodeName_ == 'objectProperties':
            obj_ = objectPropertiesType.factory()
            obj_.build(child_)
            self.set_objectProperties(obj_)
        elif nodeName_ == 'relationships':
            obj_ = relationshipsType.factory()
            obj_.build(child_)
            self.set_relationships(obj_)
        elif nodeName_ == 'fieldData':
            obj_ = fieldDataType.factory()
            obj_.build(child_)
            self.set_fieldData(obj_)
# end class malwareMetaData


class fileObject(GeneratedsSuper):
    """Object definition for files. The required attribute is the id, which
    needs to be globally unique. By convention, the value used is a
    hash, the stronger the better. The choice should be: use sha256
    if you have it, if not use sha1, if not use md5. Other hashes
    and file sizes are recorded in the elements. File names are put
    in as properties."""
    subclass = None
    superclass = None
    def __init__(self, id=None, md5=None, sha1=None, sha256=None, sha512=None, size=None, crc32=None, fileType=None, extraHash=None):
        self.id = _cast(None, id)
        self.md5 = md5
        self.sha1 = sha1
        self.sha256 = sha256
        self.sha512 = sha512
        self.size = size
        self.crc32 = crc32
        if fileType is None:
            self.fileType = []
        else:
            self.fileType = fileType
        if extraHash is None:
            self.extraHash = []
        else:
            self.extraHash = extraHash
    def factory(*args_, **kwargs_):
        if fileObject.subclass:
            return fileObject.subclass(*args_, **kwargs_)
        else:
            return fileObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_md5(self): return self.md5
    def set_md5(self, md5): self.md5 = md5
    def get_sha1(self): return self.sha1
    def set_sha1(self, sha1): self.sha1 = sha1
    def get_sha256(self): return self.sha256
    def set_sha256(self, sha256): self.sha256 = sha256
    def get_sha512(self): return self.sha512
    def set_sha512(self, sha512): self.sha512 = sha512
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_crc32(self): return self.crc32
    def set_crc32(self, crc32): self.crc32 = crc32
    def get_fileType(self): return self.fileType
    def set_fileType(self, fileType): self.fileType = fileType
    def add_fileType(self, value): self.fileType.append(value)
    def insert_fileType(self, index, value): self.fileType[index] = value
    def get_extraHash(self): return self.extraHash
    def set_extraHash(self, extraHash): self.extraHash = extraHash
    def add_extraHash(self, value): self.extraHash.append(value)
    def insert_extraHash(self, index, value): self.extraHash[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='fileObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fileObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='fileObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='fileObject', fromsubclass_=False):
        if self.md5 is not None:
            showIndent(outfile, level)
            outfile.write('<%smd5>%s</%smd5>\n' % (namespace_, self.gds_format_string(quote_xml(self.md5).encode(ExternalEncoding), input_name='md5'), namespace_))
        if self.sha1 is not None:
            showIndent(outfile, level)
            outfile.write('<%ssha1>%s</%ssha1>\n' % (namespace_, self.gds_format_string(quote_xml(self.sha1).encode(ExternalEncoding), input_name='sha1'), namespace_))
        if self.sha256 is not None:
            showIndent(outfile, level)
            outfile.write('<%ssha256>%s</%ssha256>\n' % (namespace_, self.gds_format_string(quote_xml(self.sha256).encode(ExternalEncoding), input_name='sha256'), namespace_))
        if self.sha512 is not None:
            showIndent(outfile, level)
            outfile.write('<%ssha512>%s</%ssha512>\n' % (namespace_, self.gds_format_string(quote_xml(self.sha512).encode(ExternalEncoding), input_name='sha512'), namespace_))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('<%ssize>%s</%ssize>\n' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_))
        if self.crc32 is not None:
            showIndent(outfile, level)
            outfile.write('<%scrc32>%s</%scrc32>\n' % (namespace_, self.gds_format_string(quote_xml(self.crc32).encode(ExternalEncoding), input_name='crc32'), namespace_))
        for fileType_ in self.fileType:
            showIndent(outfile, level)
            outfile.write('<%sfileType>%s</%sfileType>\n' % (namespace_, self.gds_format_string(quote_xml(fileType_).encode(ExternalEncoding), input_name='fileType'), namespace_))
        for extraHash_ in self.extraHash:
            extraHash_.export(outfile, level, namespace_, name_='extraHash')
    def hasContent_(self):
        if (
            self.md5 is not None or
            self.sha1 is not None or
            self.sha256 is not None or
            self.sha512 is not None or
            self.size is not None or
            self.crc32 is not None or
            self.fileType or
            self.extraHash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='fileObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.md5 is not None:
            showIndent(outfile, level)
            outfile.write('md5=model_.xs_hexBinary(\n')
            self.md5.exportLiteral(outfile, level, name_='md5')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sha1 is not None:
            showIndent(outfile, level)
            outfile.write('sha1=model_.xs_hexBinary(\n')
            self.sha1.exportLiteral(outfile, level, name_='sha1')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sha256 is not None:
            showIndent(outfile, level)
            outfile.write('sha256=model_.xs_hexBinary(\n')
            self.sha256.exportLiteral(outfile, level, name_='sha256')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sha512 is not None:
            showIndent(outfile, level)
            outfile.write('sha512=model_.xs_hexBinary(\n')
            self.sha512.exportLiteral(outfile, level, name_='sha512')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.crc32 is not None:
            showIndent(outfile, level)
            outfile.write('crc32=%s,\n' % quote_python(self.crc32).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('fileType=[\n')
        level += 1
        for fileType_ in self.fileType:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(fileType_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('extraHash=[\n')
        level += 1
        for extraHash_ in self.extraHash:
            showIndent(outfile, level)
            outfile.write('model_.extraHashType(\n')
            extraHash_.exportLiteral(outfile, level, name_='extraHashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'md5':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_md5(obj_)
        elif nodeName_ == 'sha1':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_sha1(obj_)
        elif nodeName_ == 'sha256':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_sha256(obj_)
        elif nodeName_ == 'sha512':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_sha512(obj_)
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'crc32':
            crc32_ = child_.text
            crc32_ = self.gds_validate_string(crc32_, node, 'crc32')
            self.crc32 = crc32_
        elif nodeName_ == 'fileType':
            fileType_ = child_.text
            fileType_ = self.gds_validate_string(fileType_, node, 'fileType')
            self.fileType.append(fileType_)
        elif nodeName_ == 'extraHash':
            obj_ = extraHashType.factory()
            obj_.build(child_)
            self.extraHash.append(obj_)
# end class fileObject


class registryObject(GeneratedsSuper):
    """Registry object. The required attribute is 'id', which is taken to
    be key\\valueName. Keys end in a \, value names start with a \,
    so you have e.g. key =
    hklm\software\microsoft\currentversion\windows\run\ value =\foo
    making the id
    hklm\software\microsoft\currentversion\windows\run\\foo"""
    subclass = None
    superclass = None
    def __init__(self, id=None, key=None, valueName=None):
        self.id = _cast(None, id)
        self.key = key
        self.valueName = valueName
    def factory(*args_, **kwargs_):
        if registryObject.subclass:
            return registryObject.subclass(*args_, **kwargs_)
        else:
            return registryObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_valueName(self): return self.valueName
    def set_valueName(self, valueName): self.valueName = valueName
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='registryObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registryObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='registryObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='registryObject', fromsubclass_=False):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('<%skey>%s</%skey>\n' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_))
        if self.valueName is not None:
            showIndent(outfile, level)
            outfile.write('<%svalueName>%s</%svalueName>\n' % (namespace_, self.gds_format_string(quote_xml(self.valueName).encode(ExternalEncoding), input_name='valueName'), namespace_))
    def hasContent_(self):
        if (
            self.key is not None or
            self.valueName is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='registryObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.valueName is not None:
            showIndent(outfile, level)
            outfile.write('valueName=%s,\n' % quote_python(self.valueName).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'valueName':
            valueName_ = child_.text
            valueName_ = self.gds_validate_string(valueName_, node, 'valueName')
            self.valueName = valueName_
# end class registryObject


class entityObject(GeneratedsSuper):
    """Entity Object. This is used to record groups, companies etc., and
    departments within organizations. The globally unique id
    (attribute) should be constructed from the company and
    department name, e.g. "Company name:Department name",
    "Mcafee:AVERT labs", or "Russian Business Network"."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None):
        self.id = _cast(None, id)
        self.name = name
    def factory(*args_, **kwargs_):
        if entityObject.subclass:
            return entityObject.subclass(*args_, **kwargs_)
        else:
            return entityObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='entityObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entityObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='entityObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='entityObject', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='entityObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class entityObject


class uriObject(GeneratedsSuper):
    """Uri object. Only required element is uri string itself. There are
    elements for each of the broken out elements. The protocol
    should be take from the list at http://www.iana.org/assignments
    /port-numbers, or if not in that list have the value 'unknown'.
    The ipProtocol should be taken from the list
    http://www.iana.org/assignments/protocol-numbers/. The elements
    correspond to the usual breakdown of a uri into its component
    domain, hostname, path, port etc, as described at
    http://en.wikipedia.org/wiki/Uniform_Resource_Locator."""
    subclass = None
    superclass = None
    def __init__(self, id=None, uriString=None, protocol=None, hostname=None, domain=None, port=None, path=None, ipProtocol=None):
        self.id = _cast(None, id)
        self.uriString = uriString
        self.protocol = protocol
        self.hostname = hostname
        self.domain = domain
        self.port = port
        self.path = path
        self.ipProtocol = ipProtocol
    def factory(*args_, **kwargs_):
        if uriObject.subclass:
            return uriObject.subclass(*args_, **kwargs_)
        else:
            return uriObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uriString(self): return self.uriString
    def set_uriString(self, uriString): self.uriString = uriString
    def validate_NoQuestionMark(self, value):
        # Validate type NoQuestionMark, a restriction on xs:string.
        pass
    def get_protocol(self): return self.protocol
    def set_protocol(self, protocol): self.protocol = protocol
    def get_hostname(self): return self.hostname
    def set_hostname(self, hostname): self.hostname = hostname
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_path(self): return self.path
    def set_path(self, path): self.path = path
    def get_ipProtocol(self): return self.ipProtocol
    def set_ipProtocol(self, ipProtocol): self.ipProtocol = ipProtocol
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='uriObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='uriObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='uriObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='uriObject', fromsubclass_=False):
        if self.uriString is not None:
            showIndent(outfile, level)
            outfile.write('<%suriString>%s</%suriString>\n' % (namespace_, self.gds_format_string(quote_xml(self.uriString).encode(ExternalEncoding), input_name='uriString'), namespace_))
        if self.protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sprotocol>%s</%sprotocol>\n' % (namespace_, self.gds_format_string(quote_xml(self.protocol).encode(ExternalEncoding), input_name='protocol'), namespace_))
        if self.hostname is not None:
            showIndent(outfile, level)
            outfile.write('<%shostname>%s</%shostname>\n' % (namespace_, self.gds_format_string(quote_xml(self.hostname).encode(ExternalEncoding), input_name='hostname'), namespace_))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('<%sdomain>%s</%sdomain>\n' % (namespace_, self.gds_format_string(quote_xml(self.domain).encode(ExternalEncoding), input_name='domain'), namespace_))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('<%sport>%s</%sport>\n' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_))
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('<%spath>%s</%spath>\n' % (namespace_, self.gds_format_string(quote_xml(self.path).encode(ExternalEncoding), input_name='path'), namespace_))
        if self.ipProtocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sipProtocol>%s</%sipProtocol>\n' % (namespace_, self.gds_format_string(quote_xml(self.ipProtocol).encode(ExternalEncoding), input_name='ipProtocol'), namespace_))
    def hasContent_(self):
        if (
            self.uriString is not None or
            self.protocol is not None or
            self.hostname is not None or
            self.domain is not None or
            self.port is not None or
            self.path is not None or
            self.ipProtocol is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='uriObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.uriString is not None:
            showIndent(outfile, level)
            outfile.write('uriString=%s,\n' % quote_python(self.uriString).encode(ExternalEncoding))
        if self.protocol is not None:
            showIndent(outfile, level)
            outfile.write('protocol=%s,\n' % quote_python(self.protocol).encode(ExternalEncoding))
        if self.hostname is not None:
            showIndent(outfile, level)
            outfile.write('hostname=%s,\n' % quote_python(self.hostname).encode(ExternalEncoding))
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=%s,\n' % quote_python(self.domain).encode(ExternalEncoding))
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.path is not None:
            showIndent(outfile, level)
            outfile.write('path=%s,\n' % quote_python(self.path).encode(ExternalEncoding))
        if self.ipProtocol is not None:
            showIndent(outfile, level)
            outfile.write('ipProtocol=%s,\n' % quote_python(self.ipProtocol).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
            self.validate_NoQuestionMark(self.id)    # validate type NoQuestionMark
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uriString':
            uriString_ = child_.text
            uriString_ = self.gds_validate_string(uriString_, node, 'uriString')
            self.uriString = uriString_
            self.validate_NoQuestionMark(self.uriString)    # validate type NoQuestionMark
        elif nodeName_ == 'protocol':
            protocol_ = child_.text
            protocol_ = self.gds_validate_string(protocol_, node, 'protocol')
            self.protocol = protocol_
        elif nodeName_ == 'hostname':
            hostname_ = child_.text
            hostname_ = self.gds_validate_string(hostname_, node, 'hostname')
            self.hostname = hostname_
        elif nodeName_ == 'domain':
            domain_ = child_.text
            domain_ = self.gds_validate_string(domain_, node, 'domain')
            self.domain = domain_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'path':
            path_ = child_.text
            path_ = self.gds_validate_string(path_, node, 'path')
            self.path = path_
        elif nodeName_ == 'ipProtocol':
            ipProtocol_ = child_.text
            ipProtocol_ = self.gds_validate_string(ipProtocol_, node, 'ipProtocol')
            self.ipProtocol = ipProtocol_
# end class uriObject


class IPObject(GeneratedsSuper):
    """IP object. Used to hold ipv4, ipv6 ip addresses and address ranges.
    The globally unique id is 'startAddress-endAddress'. There are
    two required elements, startAddress and endAddress, make these
    the same if you are specifying a single address. Thus for ip
    range id, would be e.g. 213.23.45.7-213.23.45.19 For a single
    ip, id would be e.g. 12.34.56.1-12.34.56.1"""
    subclass = None
    superclass = None
    def __init__(self, id=None, startAddress=None, endAddress=None):
        self.id = _cast(None, id)
        self.startAddress = startAddress
        self.endAddress = endAddress
    def factory(*args_, **kwargs_):
        if IPObject.subclass:
            return IPObject.subclass(*args_, **kwargs_)
        else:
            return IPObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_startAddress(self): return self.startAddress
    def set_startAddress(self, startAddress): self.startAddress = startAddress
    def get_endAddress(self): return self.endAddress
    def set_endAddress(self, endAddress): self.endAddress = endAddress
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_IPRange(self, value):
        # Validate type IPRange, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='IPObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='IPObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPObject', fromsubclass_=False):
        if self.startAddress is not None:
            self.startAddress.export(outfile, level, namespace_, name_='startAddress', )
        if self.endAddress is not None:
            self.endAddress.export(outfile, level, namespace_, name_='endAddress', )
    def hasContent_(self):
        if (
            self.startAddress is not None or
            self.endAddress is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.startAddress is not None:
            showIndent(outfile, level)
            outfile.write('startAddress=model_.IPAddress(\n')
            self.startAddress.exportLiteral(outfile, level, name_='startAddress')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.endAddress is not None:
            showIndent(outfile, level)
            outfile.write('endAddress=model_.IPAddress(\n')
            self.endAddress.exportLiteral(outfile, level, name_='endAddress')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
            self.validate_IPRange(self.id)    # validate type IPRange
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'startAddress':
            obj_ = IPAddress.factory()
            obj_.build(child_)
            self.set_startAddress(obj_)
        elif nodeName_ == 'endAddress':
            obj_ = IPAddress.factory()
            obj_.build(child_)
            self.set_endAddress(obj_)
# end class IPObject


class IPAddress(GeneratedsSuper):
    """ip address - string for the actual address and attribute either
    ipv4, ipv6."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if IPAddress.subclass:
            return IPAddress.subclass(*args_, **kwargs_)
        else:
            return IPAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_IPTypeEnum(self, value):
        # Validate type IPTypeEnum, a restriction on xs:string.
        pass
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='IPAddress', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPAddress')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='IPAddress'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPAddress', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPAddress'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.validate_IPTypeEnum(self.type_)    # validate type IPTypeEnum
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IPAddress


class domainObject(GeneratedsSuper):
    """Domain object, used to hold internet domains, e.g.yahoo.com. The
    globally unique identifier (id attribute) is the domain itself.
    whois information on domain is recorded using object properties."""
    subclass = None
    superclass = None
    def __init__(self, id=None, domain=None):
        self.id = _cast(None, id)
        self.domain = domain
    def factory(*args_, **kwargs_):
        if domainObject.subclass:
            return domainObject.subclass(*args_, **kwargs_)
        else:
            return domainObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='domainObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='domainObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='domainObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='domainObject', fromsubclass_=False):
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('<%sdomain>%s</%sdomain>\n' % (namespace_, self.gds_format_string(quote_xml(self.domain).encode(ExternalEncoding), input_name='domain'), namespace_))
    def hasContent_(self):
        if (
            self.domain is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='domainObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.domain is not None:
            showIndent(outfile, level)
            outfile.write('domain=%s,\n' % quote_python(self.domain).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            domain_ = child_.text
            domain_ = self.gds_validate_string(domain_, node, 'domain')
            self.domain = domain_
# end class domainObject


class ASNObject(GeneratedsSuper):
    """Object used to hold information on Autonomous System Numbers. An
    autonomous system (AS) is a collection of connected Internet
    Protocol (IP) routing prefixes under the control of one or more
    network operators that presents a common, clearly defined
    routing policy to the Internet. The id is the number, written as
    an integer for both 16 and 32 bit numbers."""
    subclass = None
    superclass = None
    def __init__(self, id=None, as_number=None):
        self.id = _cast(int, id)
        self.as_number = as_number
    def factory(*args_, **kwargs_):
        if ASNObject.subclass:
            return ASNObject.subclass(*args_, **kwargs_)
        else:
            return ASNObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_as_number(self): return self.as_number
    def set_as_number(self, as_number): self.as_number = as_number
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ASNObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ASNObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ASNObject'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ASNObject', fromsubclass_=False):
        if self.as_number is not None:
            showIndent(outfile, level)
            outfile.write('<%sas-number>%s</%sas-number>\n' % (namespace_, self.gds_format_integer(self.as_number, input_name='as-number'), namespace_))
    def hasContent_(self):
        if (
            self.as_number is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ASNObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.as_number is not None:
            showIndent(outfile, level)
            outfile.write('as_number=%d,\n' % self.as_number)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            try:
                self.id = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'as-number':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'as_number')
            self.as_number = ival_
# end class ASNObject


class classificationObject(GeneratedsSuper):
    """Classification object, used to hold names or classifications of
    objects. The most common use case for this is detection names
    for files from av scanners. However, this object could be used
    for general classification. The globally unique id (attribute)
    should be created from "Company name:internal classification
    name", e.g. "Mcafee:Generic.DX". The other required attribute is
    the type of classification, e.g. clean, dirty, unknown. There
    are elements to capture the category of the classification. The
    category should be entered in the same way to the classification
    name, e.g. company name:category name, e..g Mcafee:Trojan."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, classificationName=None, companyName=None, category=None, classificationDetails=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.classificationName = classificationName
        self.companyName = companyName
        self.category = category
        self.classificationDetails = classificationDetails
    def factory(*args_, **kwargs_):
        if classificationObject.subclass:
            return classificationObject.subclass(*args_, **kwargs_)
        else:
            return classificationObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_classificationName(self): return self.classificationName
    def set_classificationName(self, classificationName): self.classificationName = classificationName
    def get_companyName(self): return self.companyName
    def set_companyName(self, companyName): self.companyName = companyName
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_classificationDetails(self): return self.classificationDetails
    def set_classificationDetails(self, classificationDetails): self.classificationDetails = classificationDetails
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_ClassificationTypeEnum(self, value):
        # Validate type ClassificationTypeEnum, a restriction on xs:string.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='classificationObject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='classificationObject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='classificationObject'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='classificationObject', fromsubclass_=False):
        if self.classificationName is not None:
            showIndent(outfile, level)
            outfile.write('<%sclassificationName>%s</%sclassificationName>\n' % (namespace_, self.gds_format_string(quote_xml(self.classificationName).encode(ExternalEncoding), input_name='classificationName'), namespace_))
        if self.companyName is not None:
            showIndent(outfile, level)
            outfile.write('<%scompanyName>%s</%scompanyName>\n' % (namespace_, self.gds_format_string(quote_xml(self.companyName).encode(ExternalEncoding), input_name='companyName'), namespace_))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('<%scategory>%s</%scategory>\n' % (namespace_, self.gds_format_string(quote_xml(self.category).encode(ExternalEncoding), input_name='category'), namespace_))
        if self.classificationDetails is not None:
            self.classificationDetails.export(outfile, level, namespace_, name_='classificationDetails')
    def hasContent_(self):
        if (
            self.classificationName is not None or
            self.companyName is not None or
            self.category is not None or
            self.classificationDetails is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='classificationObject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.classificationName is not None:
            showIndent(outfile, level)
            outfile.write('classificationName=%s,\n' % quote_python(self.classificationName).encode(ExternalEncoding))
        if self.companyName is not None:
            showIndent(outfile, level)
            outfile.write('companyName=%s,\n' % quote_python(self.companyName).encode(ExternalEncoding))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category).encode(ExternalEncoding))
        if self.classificationDetails is not None:
            showIndent(outfile, level)
            outfile.write('classificationDetails=model_.classificationDetailsType(\n')
            self.classificationDetails.exportLiteral(outfile, level, name_='classificationDetails')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.validate_ClassificationTypeEnum(self.type_)    # validate type ClassificationTypeEnum
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'classificationName':
            classificationName_ = child_.text
            classificationName_ = self.gds_validate_string(classificationName_, node, 'classificationName')
            self.classificationName = classificationName_
        elif nodeName_ == 'companyName':
            companyName_ = child_.text
            companyName_ = self.gds_validate_string(companyName_, node, 'companyName')
            self.companyName = companyName_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'classificationDetails':
            obj_ = classificationDetailsType.factory()
            obj_.build(child_)
            self.set_classificationDetails(obj_)
# end class classificationObject


class fieldDataEntry(GeneratedsSuper):
    """Data structure to hold prevalence information. The data includes a
    reference to another object (which is an xpath expression
    pointing to an object inside the 'ref' element), together with a
    time period (startDate -> endDate), an origin - where the object
    came from, and various location tags. This allows rich
    information on prevalence to be recorded. By convention, time
    periods should be wherever possible standard time periods, e.g.
    minute, hour, 24 hours, week, month, quarter, year. This will
    facilitate combination of data from multiple sources. To
    represent a single entry, make startDate == endDate. Commonality
    is calculated from the sightings of malware objects (and so such
    calculation is easier to automate). Importance is reserved for
    cases when “commonality” is not available or if there is a
    need to communicate the importance when commonality is low. We
    define the commonality on a scale 0 to 100 (0 means “never
    found in the field” and 100 means “found very
    frequently”). Scaling commonality to 0..100 range instead of
    using actual sample counts is to avoid the effect of the user
    base size on the commonality. We derive commonality from the
    number of affected computers – not from the number of samples
    (for example, a hundred parasitic infections of the same virus
    on a single computer are to be counted as one). To calculate the
    commonality we use two-stage approach and logarithmic scale: -
    If the number of affected users exceeds 0.1% of your user base
    (more frequent than 1 in a 1000) set commonality to “100” -
    Otherwise, calculate the ratio of infected computers amongst
    your user base by dividing the real number of affected computers
    ‘n’ by the total number ‘N’ - Apply the following
    formula to get the commonality –( log2(1+n*1000/N) ) * 100 -
    Round to the closest integer Obviously, the calculation above
    can only be applied to counting of malware sightings on
    desktops. If telemetry is collected from a fraction of such
    desktops then an appropriate correction should be used. For all
    other cases (e.g. sighting on gateways, in some network security
    appliance, on an ISP level, etc.) please exercise your best
    judgment and apply provided desktop guideline as an example to
    make sure the commonality factor is as comparable as possible.
    For a URL object the commonality could reflect, for example, how
    widely it was spammed. “Importance” should not be used
    together with “commonality” (unless commonality=“0”) to
    avoid possible confusion. High “importance”, for example,
    can be assigned to samples that are over-hyped by media when
    their commonality is still “0”. Use the following guidelines
    for “importance” which is also defined on a scale 0..100:
    100 – you’d expect your CEO and/or media to call you any
    second about this object 80 – you might get a call from your
    CEO and/or media 60 – you’d expect your boss to call you any
    second 40 – you might get a call from your boss 20 – someone
    is very likely to contact you about this object 10 – you might
    get contacted about this object 0 – you’d be surprised if
    anyone would ever contact you about this object"""
    subclass = None
    superclass = None
    def __init__(self, references=None, startDate=None, endDate=None, firstSeenDate=None, origin=None, commonality=None, volume=None, importance=None, location=None):
        self.references = references
        self.startDate = startDate
        self.endDate = endDate
        self.firstSeenDate = firstSeenDate
        self.origin = origin
        self.commonality = commonality
        if volume is None:
            self.volume = []
        else:
            self.volume = volume
        self.importance = importance
        self.location = location
    def factory(*args_, **kwargs_):
        if fieldDataEntry.subclass:
            return fieldDataEntry.subclass(*args_, **kwargs_)
        else:
            return fieldDataEntry(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_references(self): return self.references
    def set_references(self, references): self.references = references
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def get_firstSeenDate(self): return self.firstSeenDate
    def set_firstSeenDate(self, firstSeenDate): self.firstSeenDate = firstSeenDate
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def validate_OriginTypeEnum(self, value):
        # Validate type OriginTypeEnum, a restriction on xs:string.
        pass
    def get_commonality(self): return self.commonality
    def set_commonality(self, commonality): self.commonality = commonality
    def validate_intBetween0and100(self, value):
        # Validate type intBetween0and100, a restriction on xs:integer.
        pass
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def add_volume(self, value): self.volume.append(value)
    def insert_volume(self, index, value): self.volume[index] = value
    def get_importance(self): return self.importance
    def set_importance(self, importance): self.importance = importance
    def get_location(self): return self.location
    def set_location(self, location): self.location = location
    def export(self, outfile, level, namespace_='maec:', name_='fieldDataEntry', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fieldDataEntry')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='fieldDataEntry'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='fieldDataEntry', fromsubclass_=False):
        if self.references is not None:
            self.references.export(outfile, level, namespace_, name_='references', )
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sstartDate>%s</%sstartDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.startDate).encode(ExternalEncoding), input_name='startDate'), namespace_))
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sendDate>%s</%sendDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.endDate).encode(ExternalEncoding), input_name='endDate'), namespace_))
        if self.firstSeenDate is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstSeenDate>%s</%sfirstSeenDate>\n' % (namespace_, self.gds_format_string(quote_xml(self.firstSeenDate).encode(ExternalEncoding), input_name='firstSeenDate'), namespace_))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sorigin>%s</%sorigin>\n' % (namespace_, self.gds_format_string(quote_xml(self.origin).encode(ExternalEncoding), input_name='origin'), namespace_))
        if self.commonality is not None:
            showIndent(outfile, level)
            outfile.write('<%scommonality>%s</%scommonality>\n' % (namespace_, self.gds_format_integer(self.commonality, input_name='commonality'), namespace_))
        for volume_ in self.volume:
            volume_.export(outfile, level, namespace_, name_='volume')
        if self.importance is not None:
            showIndent(outfile, level)
            outfile.write('<%simportance>%s</%simportance>\n' % (namespace_, self.gds_format_integer(self.importance, input_name='importance'), namespace_))
        if self.location is not None:
            self.location.export(outfile, level, namespace_, name_='location')
    def hasContent_(self):
        if (
            self.references is not None or
            self.startDate is not None or
            self.endDate is not None or
            self.firstSeenDate is not None or
            self.origin is not None or
            self.commonality is not None or
            self.volume or
            self.importance is not None or
            self.location is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='fieldDataEntry'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.references is not None:
            showIndent(outfile, level)
            outfile.write('references=model_.referencesType(\n')
            self.references.exportLiteral(outfile, level, name_='references')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('startDate=%s,\n' % quote_python(self.startDate).encode(ExternalEncoding))
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('endDate=%s,\n' % quote_python(self.endDate).encode(ExternalEncoding))
        if self.firstSeenDate is not None:
            showIndent(outfile, level)
            outfile.write('firstSeenDate=%s,\n' % quote_python(self.firstSeenDate).encode(ExternalEncoding))
        if self.origin is not None:
            showIndent(outfile, level)
            outfile.write('origin=%s,\n' % quote_python(self.origin).encode(ExternalEncoding))
        if self.commonality is not None:
            showIndent(outfile, level)
            outfile.write('commonality=%d,\n' % self.commonality)
        showIndent(outfile, level)
        outfile.write('volume=[\n')
        level += 1
        for volume_ in self.volume:
            showIndent(outfile, level)
            outfile.write('model_.volumeType(\n')
            volume_.exportLiteral(outfile, level, name_='volumeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.importance is not None:
            showIndent(outfile, level)
            outfile.write('importance=%d,\n' % self.importance)
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=model_.locationType(\n')
            self.location.exportLiteral(outfile, level, name_='location')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'references':
            obj_ = referencesType.factory()
            obj_.build(child_)
            self.set_references(obj_)
        elif nodeName_ == 'startDate':
            startDate_ = child_.text
            startDate_ = self.gds_validate_string(startDate_, node, 'startDate')
            self.startDate = startDate_
        elif nodeName_ == 'endDate':
            endDate_ = child_.text
            endDate_ = self.gds_validate_string(endDate_, node, 'endDate')
            self.endDate = endDate_
        elif nodeName_ == 'firstSeenDate':
            firstSeenDate_ = child_.text
            firstSeenDate_ = self.gds_validate_string(firstSeenDate_, node, 'firstSeenDate')
            self.firstSeenDate = firstSeenDate_
        elif nodeName_ == 'origin':
            origin_ = child_.text
            origin_ = self.gds_validate_string(origin_, node, 'origin')
            self.origin = origin_
            self.validate_OriginTypeEnum(self.origin)    # validate type OriginTypeEnum
        elif nodeName_ == 'commonality':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'commonality')
            self.commonality = ival_
            self.validate_intBetween0and100(self.commonality)    # validate type intBetween0and100
        elif nodeName_ == 'volume':
            obj_ = volumeType.factory()
            obj_.build(child_)
            self.volume.append(obj_)
        elif nodeName_ == 'importance':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'importance')
            self.importance = ival_
            self.validate_intBetween0and100(self.importance)    # validate type intBetween0and100
        elif nodeName_ == 'location':
            obj_ = locationType.factory()
            obj_.build(child_)
            self.set_location(obj_)
# end class fieldDataEntry


class reference(GeneratedsSuper):
    """Reference element used to hold xpath expressions to objects, for
    example file[@id="12345"]."""
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if reference.subclass:
            return reference.subclass(*args_, **kwargs_)
        else:
            return reference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='reference', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='reference')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='reference'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='reference', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='reference'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class reference


class property(GeneratedsSuper):
    """A property."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if property.subclass:
            return property.subclass(*args_, **kwargs_)
        else:
            return property(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_PropertyTypeEnum(self, value):
        # Validate type PropertyTypeEnum, a restriction on xs:string.
        pass
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='property', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='property')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='property'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='property', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='property'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.validate_PropertyTypeEnum(self.type_)    # validate type PropertyTypeEnum
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class property


class objectProperty(GeneratedsSuper):
    """Property; a reference to the object, a timestamp and an unbounded
    set of properties. This is used to describe extra information
    about an object. For example, to show the url parameter strings
    associated with a particular URI object. Or to show file names
    associated with a particular file. Properties can also be
    applied to relationships, by referencing the relationship by id.
    This allows use such as e.g. recording the post data sent in an
    http request between a malware (file object) and a uri (uri
    object)."""
    subclass = None
    superclass = None
    def __init__(self, id=None, references=None, timestamp=None, property=None):
        self.id = _cast(None, id)
        self.references = references
        self.timestamp = timestamp
        if property is None:
            self.property = []
        else:
            self.property = property
    def factory(*args_, **kwargs_):
        if objectProperty.subclass:
            return objectProperty.subclass(*args_, **kwargs_)
        else:
            return objectProperty(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_references(self): return self.references
    def set_references(self, references): self.references = references
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def add_property(self, value): self.property.append(value)
    def insert_property(self, index, value): self.property[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='objectProperty', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='objectProperty')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='objectProperty'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='objectProperty', fromsubclass_=False):
        if self.references is not None:
            self.references.export(outfile, level, namespace_, name_='references', )
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('<%stimestamp>%s</%stimestamp>\n' % (namespace_, self.gds_format_string(quote_xml(self.timestamp).encode(ExternalEncoding), input_name='timestamp'), namespace_))
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property')
    def hasContent_(self):
        if (
            self.references is not None or
            self.timestamp is not None or
            self.property
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='objectProperty'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.references is not None:
            showIndent(outfile, level)
            outfile.write('references=model_.referencesType1(\n')
            self.references.exportLiteral(outfile, level, name_='references')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp=%s,\n' % quote_python(self.timestamp).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.property(\n')
            property_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'references':
            obj_ = referencesType1.factory()
            obj_.build(child_)
            self.set_references(obj_)
        elif nodeName_ == 'timestamp':
            timestamp_ = child_.text
            timestamp_ = self.gds_validate_string(timestamp_, node, 'timestamp')
            self.timestamp = timestamp_
        elif nodeName_ == 'property':
            obj_ = property.factory()
            obj_.build(child_)
            self.property.append(obj_)
# end class objectProperty


class relationship(GeneratedsSuper):
    """Relationships are used to express relationships between objects, and
    dates. Relationships have a type (an attribute with a defined
    list of allowed relationships), source (a set of xpath
    references to the parent end of the relationship), target (xpath
    references to the other end of the relationship) and an optional
    date. The linking of objects with types is a powerful way of
    describing data. The dates can be used to provide context. For
    example, to assign a classification to an object, that can done
    with an "isClassifiedAs" relationship, with the date meaning
    that that was the data that that classification was assigned. To
    show urls and the last visited data, this can be expressed as a
    "verifiedBy" relationship between the urls and the entity doing
    the verification, with the date interpreted as the verification
    date."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, source=None, target=None, timestamp=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.source = source
        self.target = target
        self.timestamp = timestamp
    def factory(*args_, **kwargs_):
        if relationship.subclass:
            return relationship.subclass(*args_, **kwargs_)
        else:
            return relationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_RelationshipTypeEnum(self, value):
        # Validate type RelationshipTypeEnum, a restriction on xs:string.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='relationship', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relationship')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='relationship'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='relationship', fromsubclass_=False):
        if self.source is not None:
            self.source.export(outfile, level, namespace_, name_='source', )
        if self.target is not None:
            self.target.export(outfile, level, namespace_, name_='target', )
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('<%stimestamp>%s</%stimestamp>\n' % (namespace_, self.gds_format_string(quote_xml(self.timestamp).encode(ExternalEncoding), input_name='timestamp'), namespace_))
    def hasContent_(self):
        if (
            self.source is not None or
            self.target is not None or
            self.timestamp is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='relationship'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=model_.sourceType(\n')
            self.source.exportLiteral(outfile, level, name_='source')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.target is not None:
            showIndent(outfile, level)
            outfile.write('target=model_.targetType(\n')
            self.target.exportLiteral(outfile, level, name_='target')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp=%s,\n' % quote_python(self.timestamp).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.validate_RelationshipTypeEnum(self.type_)    # validate type RelationshipTypeEnum
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'source':
            obj_ = sourceType.factory()
            obj_.build(child_)
            self.set_source(obj_)
        elif nodeName_ == 'target':
            obj_ = targetType.factory()
            obj_.build(child_)
            self.set_target(obj_)
        elif nodeName_ == 'timestamp':
            timestamp_ = child_.text
            timestamp_ = self.gds_validate_string(timestamp_, node, 'timestamp')
            self.timestamp = timestamp_
# end class relationship


class AnalysesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Analysis=None):
        if Analysis is None:
            self.Analysis = []
        else:
            self.Analysis = Analysis
    def factory(*args_, **kwargs_):
        if AnalysesType.subclass:
            return AnalysesType.subclass(*args_, **kwargs_)
        else:
            return AnalysesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analysis(self): return self.Analysis
    def set_Analysis(self, Analysis): self.Analysis = Analysis
    def add_Analysis(self, value): self.Analysis.append(value)
    def insert_Analysis(self, index, value): self.Analysis[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='AnalysesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnalysesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='AnalysesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='AnalysesType', fromsubclass_=False):
        for Analysis_ in self.Analysis:
            Analysis_.export(outfile, level, namespace_, name_='Analysis')
    def hasContent_(self):
        if (
            self.Analysis
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AnalysesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Analysis=[\n')
        level += 1
        for Analysis_ in self.Analysis:
            showIndent(outfile, level)
            outfile.write('model_.AnalysisType(\n')
            Analysis_.exportLiteral(outfile, level, name_='AnalysisType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Analysis':
            obj_ = AnalysisType.factory()
            obj_.build(child_)
            self.Analysis.append(obj_)
# end class AnalysesType


class BehaviorsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior=None):
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
    def factory(*args_, **kwargs_):
        if BehaviorsType.subclass:
            return BehaviorsType.subclass(*args_, **kwargs_)
        else:
            return BehaviorsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='BehaviorsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorsType', fromsubclass_=False):
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
    def hasContent_(self):
        if (
            self.Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
# end class BehaviorsType


class ActionsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if ActionsType.subclass:
            return ActionsType.subclass(*args_, **kwargs_)
        else:
            return ActionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ActionsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionsType', fromsubclass_=False):
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class ActionsType


class PoolsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collection_Pool=None, Behavior_Pool=None, Action_Collection_Pool=None, Action_Pool=None, Object_Pool=None, Effect_Pool=None, Object_Collection_Pool=None):
        self.Behavior_Collection_Pool = Behavior_Collection_Pool
        self.Behavior_Pool = Behavior_Pool
        self.Action_Collection_Pool = Action_Collection_Pool
        self.Action_Pool = Action_Pool
        self.Object_Pool = Object_Pool
        self.Effect_Pool = Effect_Pool
        self.Object_Collection_Pool = Object_Collection_Pool
    def factory(*args_, **kwargs_):
        if PoolsType.subclass:
            return PoolsType.subclass(*args_, **kwargs_)
        else:
            return PoolsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collection_Pool(self): return self.Behavior_Collection_Pool
    def set_Behavior_Collection_Pool(self, Behavior_Collection_Pool): self.Behavior_Collection_Pool = Behavior_Collection_Pool
    def get_Behavior_Pool(self): return self.Behavior_Pool
    def set_Behavior_Pool(self, Behavior_Pool): self.Behavior_Pool = Behavior_Pool
    def get_Action_Collection_Pool(self): return self.Action_Collection_Pool
    def set_Action_Collection_Pool(self, Action_Collection_Pool): self.Action_Collection_Pool = Action_Collection_Pool
    def get_Action_Pool(self): return self.Action_Pool
    def set_Action_Pool(self, Action_Pool): self.Action_Pool = Action_Pool
    def get_Object_Pool(self): return self.Object_Pool
    def set_Object_Pool(self, Object_Pool): self.Object_Pool = Object_Pool
    def get_Effect_Pool(self): return self.Effect_Pool
    def set_Effect_Pool(self, Effect_Pool): self.Effect_Pool = Effect_Pool
    def get_Object_Collection_Pool(self): return self.Object_Collection_Pool
    def set_Object_Collection_Pool(self, Object_Collection_Pool): self.Object_Collection_Pool = Object_Collection_Pool
    def export(self, outfile, level, namespace_='maec:', name_='PoolsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PoolsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PoolsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PoolsType', fromsubclass_=False):
        if self.Behavior_Collection_Pool is not None:
            self.Behavior_Collection_Pool.export(outfile, level, namespace_, name_='Behavior_Collection_Pool')
        if self.Behavior_Pool is not None:
            self.Behavior_Pool.export(outfile, level, namespace_, name_='Behavior_Pool')
        if self.Action_Collection_Pool is not None:
            self.Action_Collection_Pool.export(outfile, level, namespace_, name_='Action_Collection_Pool')
        if self.Action_Pool is not None:
            self.Action_Pool.export(outfile, level, namespace_, name_='Action_Pool')
        if self.Object_Pool is not None:
            self.Object_Pool.export(outfile, level, namespace_, name_='Object_Pool')
        if self.Effect_Pool is not None:
            self.Effect_Pool.export(outfile, level, namespace_, name_='Effect_Pool')
        if self.Object_Collection_Pool is not None:
            self.Object_Collection_Pool.export(outfile, level, namespace_, name_='Object_Collection_Pool')
    def hasContent_(self):
        if (
            self.Behavior_Collection_Pool is not None or
            self.Behavior_Pool is not None or
            self.Action_Collection_Pool is not None or
            self.Action_Pool is not None or
            self.Object_Pool is not None or
            self.Effect_Pool is not None or
            self.Object_Collection_Pool is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PoolsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Behavior_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Collection_Pool=model_.Behavior_Collection_PoolType(\n')
            self.Behavior_Collection_Pool.exportLiteral(outfile, level, name_='Behavior_Collection_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Behavior_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Pool=model_.Behavior_PoolType(\n')
            self.Behavior_Pool.exportLiteral(outfile, level, name_='Behavior_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Action_Collection_Pool=model_.Action_Collection_PoolType(\n')
            self.Action_Collection_Pool.exportLiteral(outfile, level, name_='Action_Collection_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Action_Pool=model_.Action_PoolType(\n')
            self.Action_Pool.exportLiteral(outfile, level, name_='Action_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Object_Pool=model_.Object_PoolType(\n')
            self.Object_Pool.exportLiteral(outfile, level, name_='Object_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effect_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Effect_Pool=model_.Effect_PoolType(\n')
            self.Effect_Pool.exportLiteral(outfile, level, name_='Effect_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Object_Collection_Pool=model_.Object_Collection_PoolType(\n')
            self.Object_Collection_Pool.exportLiteral(outfile, level, name_='Object_Collection_Pool')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Collection_Pool':
            obj_ = Behavior_Collection_PoolType.factory()
            obj_.build(child_)
            self.set_Behavior_Collection_Pool(obj_)
        elif nodeName_ == 'Behavior_Pool':
            obj_ = Behavior_PoolType.factory()
            obj_.build(child_)
            self.set_Behavior_Pool(obj_)
        elif nodeName_ == 'Action_Collection_Pool':
            obj_ = Action_Collection_PoolType.factory()
            obj_.build(child_)
            self.set_Action_Collection_Pool(obj_)
        elif nodeName_ == 'Action_Pool':
            obj_ = Action_PoolType.factory()
            obj_.build(child_)
            self.set_Action_Pool(obj_)
        elif nodeName_ == 'Object_Pool':
            obj_ = Object_PoolType.factory()
            obj_.build(child_)
            self.set_Object_Pool(obj_)
        elif nodeName_ == 'Effect_Pool':
            obj_ = Effect_PoolType.factory()
            obj_.build(child_)
            self.set_Effect_Pool(obj_)
        elif nodeName_ == 'Object_Collection_Pool':
            obj_ = Object_Collection_PoolType.factory()
            obj_.build(child_)
            self.set_Object_Collection_Pool(obj_)
# end class PoolsType


class Behavior_Collection_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collection=None):
        if Behavior_Collection is None:
            self.Behavior_Collection = []
        else:
            self.Behavior_Collection = Behavior_Collection
    def factory(*args_, **kwargs_):
        if Behavior_Collection_PoolType.subclass:
            return Behavior_Collection_PoolType.subclass(*args_, **kwargs_)
        else:
            return Behavior_Collection_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collection(self): return self.Behavior_Collection
    def set_Behavior_Collection(self, Behavior_Collection): self.Behavior_Collection = Behavior_Collection
    def add_Behavior_Collection(self, value): self.Behavior_Collection.append(value)
    def insert_Behavior_Collection(self, index, value): self.Behavior_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Behavior_Collection_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Behavior_Collection_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Behavior_Collection_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Behavior_Collection_PoolType', fromsubclass_=False):
        for Behavior_Collection_ in self.Behavior_Collection:
            Behavior_Collection_.export(outfile, level, namespace_, name_='Behavior_Collection')
    def hasContent_(self):
        if (
            self.Behavior_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Behavior_Collection_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Collection=[\n')
        level += 1
        for Behavior_Collection_ in self.Behavior_Collection:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorCollectionType(\n')
            Behavior_Collection_.exportLiteral(outfile, level, name_='BehaviorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Collection':
            obj_ = BehaviorCollectionType.factory()
            obj_.build(child_)
            self.Behavior_Collection.append(obj_)
# end class Behavior_Collection_PoolType


class Behavior_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior=None):
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
    def factory(*args_, **kwargs_):
        if Behavior_PoolType.subclass:
            return Behavior_PoolType.subclass(*args_, **kwargs_)
        else:
            return Behavior_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Behavior_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Behavior_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Behavior_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Behavior_PoolType', fromsubclass_=False):
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
    def hasContent_(self):
        if (
            self.Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Behavior_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
# end class Behavior_PoolType


class Action_Collection_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action_Collection=None):
        if Action_Collection is None:
            self.Action_Collection = []
        else:
            self.Action_Collection = Action_Collection
    def factory(*args_, **kwargs_):
        if Action_Collection_PoolType.subclass:
            return Action_Collection_PoolType.subclass(*args_, **kwargs_)
        else:
            return Action_Collection_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Collection(self): return self.Action_Collection
    def set_Action_Collection(self, Action_Collection): self.Action_Collection = Action_Collection
    def add_Action_Collection(self, value): self.Action_Collection.append(value)
    def insert_Action_Collection(self, index, value): self.Action_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Action_Collection_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Action_Collection_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Action_Collection_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_Collection_PoolType', fromsubclass_=False):
        for Action_Collection_ in self.Action_Collection:
            Action_Collection_.export(outfile, level, namespace_, name_='Action_Collection')
    def hasContent_(self):
        if (
            self.Action_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_Collection_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Collection=[\n')
        level += 1
        for Action_Collection_ in self.Action_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ActionCollectionType(\n')
            Action_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Collection.append(obj_)
# end class Action_Collection_PoolType


class Action_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if Action_PoolType.subclass:
            return Action_PoolType.subclass(*args_, **kwargs_)
        else:
            return Action_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Action_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Action_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Action_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_PoolType', fromsubclass_=False):
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class Action_PoolType


class Object_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object=None):
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if Object_PoolType.subclass:
            return Object_PoolType.subclass(*args_, **kwargs_)
        else:
            return Object_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Object_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Object_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Object_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_PoolType', fromsubclass_=False):
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
    def hasContent_(self):
        if (
            self.Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
# end class Object_PoolType


class Effect_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
    def factory(*args_, **kwargs_):
        if Effect_PoolType.subclass:
            return Effect_PoolType.subclass(*args_, **kwargs_)
        else:
            return Effect_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Effect_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Effect_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Effect_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Effect_PoolType', fromsubclass_=False):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
    def hasContent_(self):
        if (
            self.Effect
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Effect_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
# end class Effect_PoolType


class Object_Collection_PoolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Collection=None):
        if Object_Collection is None:
            self.Object_Collection = []
        else:
            self.Object_Collection = Object_Collection
    def factory(*args_, **kwargs_):
        if Object_Collection_PoolType.subclass:
            return Object_Collection_PoolType.subclass(*args_, **kwargs_)
        else:
            return Object_Collection_PoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Collection(self): return self.Object_Collection
    def set_Object_Collection(self, Object_Collection): self.Object_Collection = Object_Collection
    def add_Object_Collection(self, value): self.Object_Collection.append(value)
    def insert_Object_Collection(self, index, value): self.Object_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Object_Collection_PoolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Object_Collection_PoolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Object_Collection_PoolType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_Collection_PoolType', fromsubclass_=False):
        for Object_Collection_ in self.Object_Collection:
            Object_Collection_.export(outfile, level, namespace_, name_='Object_Collection')
    def hasContent_(self):
        if (
            self.Object_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_Collection_PoolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Collection=[\n')
        level += 1
        for Object_Collection_ in self.Object_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ObjectCollectionType(\n')
            Object_Collection_.exportLiteral(outfile, level, name_='ObjectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Collection':
            obj_ = ObjectCollectionType.factory()
            obj_.build(child_)
            self.Object_Collection.append(obj_)
# end class Object_Collection_PoolType


class EffectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
    def factory(*args_, **kwargs_):
        if EffectsType.subclass:
            return EffectsType.subclass(*args_, **kwargs_)
        else:
            return EffectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='EffectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectsType', fromsubclass_=False):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
    def hasContent_(self):
        if (
            self.Effect
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
# end class EffectsType


class PurposeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, Attempted_Vulnerability_Exploit=None):
        self.Description = Description
        self.Attempted_Vulnerability_Exploit = Attempted_Vulnerability_Exploit
    def factory(*args_, **kwargs_):
        if PurposeType.subclass:
            return PurposeType.subclass(*args_, **kwargs_)
        else:
            return PurposeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Attempted_Vulnerability_Exploit(self): return self.Attempted_Vulnerability_Exploit
    def set_Attempted_Vulnerability_Exploit(self, Attempted_Vulnerability_Exploit): self.Attempted_Vulnerability_Exploit = Attempted_Vulnerability_Exploit
    def export(self, outfile, level, namespace_='maec:', name_='PurposeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PurposeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PurposeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PurposeType', fromsubclass_=False):
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Attempted_Vulnerability_Exploit is not None:
            self.Attempted_Vulnerability_Exploit.export(outfile, level, namespace_, name_='Attempted_Vulnerability_Exploit')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Attempted_Vulnerability_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PurposeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attempted_Vulnerability_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Attempted_Vulnerability_Exploit=model_.Attempted_Vulnerability_ExploitType(\n')
            self.Attempted_Vulnerability_Exploit.exportLiteral(outfile, level, name_='Attempted_Vulnerability_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Attempted_Vulnerability_Exploit':
            obj_ = Attempted_Vulnerability_ExploitType.factory()
            obj_.build(child_)
            self.set_Attempted_Vulnerability_Exploit(obj_)
# end class PurposeType


class Attempted_Vulnerability_ExploitType(GeneratedsSuper):
    """This field refers to whether the vulnerability that is being
    exploited is known or unknown. Only known vulnerabilities will
    have an associated CPE identifier. Possible values: Known,
    Unknown."""
    subclass = None
    superclass = None
    def __init__(self, vulnerability_type=None, Known_Exploit=None):
        self.vulnerability_type = _cast(None, vulnerability_type)
        self.Known_Exploit = Known_Exploit
    def factory(*args_, **kwargs_):
        if Attempted_Vulnerability_ExploitType.subclass:
            return Attempted_Vulnerability_ExploitType.subclass(*args_, **kwargs_)
        else:
            return Attempted_Vulnerability_ExploitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Known_Exploit(self): return self.Known_Exploit
    def set_Known_Exploit(self, Known_Exploit): self.Known_Exploit = Known_Exploit
    def get_vulnerability_type(self): return self.vulnerability_type
    def set_vulnerability_type(self, vulnerability_type): self.vulnerability_type = vulnerability_type
    def export(self, outfile, level, namespace_='maec:', name_='Attempted_Vulnerability_ExploitType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Attempted_Vulnerability_ExploitType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Attempted_Vulnerability_ExploitType'):
        if self.vulnerability_type is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            outfile.write(' vulnerability_type=%s' % (self.gds_format_string(quote_attrib(self.vulnerability_type).encode(ExternalEncoding), input_name='vulnerability_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Attempted_Vulnerability_ExploitType', fromsubclass_=False):
        if self.Known_Exploit is not None:
            self.Known_Exploit.export(outfile, level, namespace_, name_='Known_Exploit', )
    def hasContent_(self):
        if (
            self.Known_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Attempted_Vulnerability_ExploitType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vulnerability_type is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            showIndent(outfile, level)
            outfile.write('vulnerability_type = "%s",\n' % (self.vulnerability_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Known_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Known_Exploit=model_.CVEVulnerabilityType(\n')
            self.Known_Exploit.exportLiteral(outfile, level, name_='Known_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vulnerability_type', node)
        if value is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            self.vulnerability_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Known_Exploit':
            obj_ = CVEVulnerabilityType.factory()
            obj_.build(child_)
            self.set_Known_Exploit(obj_)
# end class Attempted_Vulnerability_ExploitType


class ActionsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action_Collection=None, Action=None, Action_Reference=None):
        if Action_Collection is None:
            self.Action_Collection = []
        else:
            self.Action_Collection = Action_Collection
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
    def factory(*args_, **kwargs_):
        if ActionsType1.subclass:
            return ActionsType1.subclass(*args_, **kwargs_)
        else:
            return ActionsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Collection(self): return self.Action_Collection
    def set_Action_Collection(self, Action_Collection): self.Action_Collection = Action_Collection
    def add_Action_Collection(self, value): self.Action_Collection.append(value)
    def insert_Action_Collection(self, index, value): self.Action_Collection[index] = value
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ActionsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ActionsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionsType1', fromsubclass_=False):
        for Action_Collection_ in self.Action_Collection:
            Action_Collection_.export(outfile, level, namespace_, name_='Action_Collection')
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, namespace_, name_='Action_Reference')
    def hasContent_(self):
        if (
            self.Action_Collection or
            self.Action or
            self.Action_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Collection=[\n')
        level += 1
        for Action_Collection_ in self.Action_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ActionCollectionType(\n')
            Action_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='ActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Collection.append(obj_)
        elif nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
        elif nodeName_ == 'Action_Reference':
            obj_ = ActionReferenceType.factory()
            obj_.build(child_)
            self.Action_Reference.append(obj_)
# end class ActionsType1


class ObjectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None, Object=None):
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if ObjectsType.subclass:
            return ObjectsType.subclass(*args_, **kwargs_)
        else:
            return ObjectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ObjectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ObjectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectsType', fromsubclass_=False):
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, namespace_, name_='Object_Reference')
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
    def hasContent_(self):
        if (
            self.Object_Reference or
            self.Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
        elif nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
# end class ObjectsType


class EffectsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None, Effect_Reference=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if EffectsType1.subclass:
            return EffectsType1.subclass(*args_, **kwargs_)
        else:
            return EffectsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='EffectsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectsType1', fromsubclass_=False):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Effect or
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
        elif nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class EffectsType1


class Related_BehaviorsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Behavior=None):
        if Related_Behavior is None:
            self.Related_Behavior = []
        else:
            self.Related_Behavior = Related_Behavior
    def factory(*args_, **kwargs_):
        if Related_BehaviorsType.subclass:
            return Related_BehaviorsType.subclass(*args_, **kwargs_)
        else:
            return Related_BehaviorsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Behavior(self): return self.Related_Behavior
    def set_Related_Behavior(self, Related_Behavior): self.Related_Behavior = Related_Behavior
    def add_Related_Behavior(self, value): self.Related_Behavior.append(value)
    def insert_Related_Behavior(self, index, value): self.Related_Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_BehaviorsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_BehaviorsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_BehaviorsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_BehaviorsType', fromsubclass_=False):
        for Related_Behavior_ in self.Related_Behavior:
            Related_Behavior_.export(outfile, level, namespace_, name_='Related_Behavior')
    def hasContent_(self):
        if (
            self.Related_Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_BehaviorsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Behavior=[\n')
        level += 1
        for Related_Behavior_ in self.Related_Behavior:
            showIndent(outfile, level)
            outfile.write('model_.Related_BehaviorType(\n')
            Related_Behavior_.exportLiteral(outfile, level, name_='Related_BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Related_Behavior':
            obj_ = Related_BehaviorType.factory()
            obj_.build(child_)
            self.Related_Behavior.append(obj_)
# end class Related_BehaviorsType


class Related_BehaviorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Reference=None, Nature_of_Relationship=None):
        self.Behavior_Reference = Behavior_Reference
        self.Nature_of_Relationship = Nature_of_Relationship
    def factory(*args_, **kwargs_):
        if Related_BehaviorType.subclass:
            return Related_BehaviorType.subclass(*args_, **kwargs_)
        else:
            return Related_BehaviorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def get_Nature_of_Relationship(self): return self.Nature_of_Relationship
    def set_Nature_of_Relationship(self, Nature_of_Relationship): self.Nature_of_Relationship = Nature_of_Relationship
    def export(self, outfile, level, namespace_='maec:', name_='Related_BehaviorType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_BehaviorType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_BehaviorType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_BehaviorType', fromsubclass_=False):
        if self.Behavior_Reference is not None:
            self.Behavior_Reference.export(outfile, level, namespace_, name_='Behavior_Reference', )
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_of_Relationship>%s</%sNature_of_Relationship>\n' % (namespace_, self.gds_format_string(quote_xml(self.Nature_of_Relationship).encode(ExternalEncoding), input_name='Nature_of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Behavior_Reference is not None or
            self.Nature_of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_BehaviorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Behavior_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Reference=model_.BehaviorReferenceType(\n')
            self.Behavior_Reference.exportLiteral(outfile, level, name_='Behavior_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_of_Relationship=%s,\n' % quote_python(self.Nature_of_Relationship).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.set_Behavior_Reference(obj_)
        elif nodeName_ == 'Nature_of_Relationship':
            Nature_of_Relationship_ = child_.text
            Nature_of_Relationship_ = self.gds_validate_string(Nature_of_Relationship_, node, 'Nature_of_Relationship')
            self.Nature_of_Relationship = Nature_of_Relationship_
# end class Related_BehaviorType


class Nature_of_Relationship(GeneratedsSuper):
    """This field defines the relationship between the characterized
    behavior and the one being referenced. Possible values:
    Following_Dependency, Preceding_Dependency, Other."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Nature_of_Relationship.subclass:
            return Nature_of_Relationship.subclass(*args_, **kwargs_)
        else:
            return Nature_of_Relationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Nature_of_Relationship', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Nature_of_Relationship')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Nature_of_Relationship'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Nature_of_Relationship', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nature_of_Relationship'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Nature_of_Relationship


class EffectsType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None, Effect_Reference=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if EffectsType2.subclass:
            return EffectsType2.subclass(*args_, **kwargs_)
        else:
            return EffectsType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='EffectsType2', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectsType2')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectsType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectsType2', fromsubclass_=False):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Effect or
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectsType2'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
        elif nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class EffectsType2


class Action_InitiatorType(GeneratedsSuper):
    """This attribute is used to state the type of object which initiated
    the action. Possible values: Process, Other."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, Initiator_Object=None):
        self.type_ = _cast(None, type_)
        self.Initiator_Object = Initiator_Object
    def factory(*args_, **kwargs_):
        if Action_InitiatorType.subclass:
            return Action_InitiatorType.subclass(*args_, **kwargs_)
        else:
            return Action_InitiatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Initiator_Object(self): return self.Initiator_Object
    def set_Initiator_Object(self, Initiator_Object): self.Initiator_Object = Initiator_Object
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='Action_InitiatorType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Action_InitiatorType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Action_InitiatorType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_InitiatorType', fromsubclass_=False):
        if self.Initiator_Object is not None:
            self.Initiator_Object.export(outfile, level, namespace_, name_='Initiator_Object')
    def hasContent_(self):
        if (
            self.Initiator_Object is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_InitiatorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Initiator_Object is not None:
            showIndent(outfile, level)
            outfile.write('Initiator_Object=model_.ObjectReferenceType(\n')
            self.Initiator_Object.exportLiteral(outfile, level, name_='Initiator_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Initiator_Object':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Initiator_Object(obj_)
# end class Action_InitiatorType


class ObjectsType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None, Object=None):
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if ObjectsType1.subclass:
            return ObjectsType1.subclass(*args_, **kwargs_)
        else:
            return ObjectsType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ObjectsType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectsType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ObjectsType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectsType1', fromsubclass_=False):
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, namespace_, name_='Object_Reference')
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
    def hasContent_(self):
        if (
            self.Object_Reference or
            self.Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectsType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
        elif nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
# end class ObjectsType1


class EffectsType3(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None, Effect_Reference=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if EffectsType3.subclass:
            return EffectsType3.subclass(*args_, **kwargs_)
        else:
            return EffectsType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='EffectsType3', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EffectsType3')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='EffectsType3'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectsType3', fromsubclass_=False):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Effect or
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectsType3'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
        elif nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class EffectsType3


class Related_ActionsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Action=None):
        if Related_Action is None:
            self.Related_Action = []
        else:
            self.Related_Action = Related_Action
    def factory(*args_, **kwargs_):
        if Related_ActionsType.subclass:
            return Related_ActionsType.subclass(*args_, **kwargs_)
        else:
            return Related_ActionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Action(self): return self.Related_Action
    def set_Related_Action(self, Related_Action): self.Related_Action = Related_Action
    def add_Related_Action(self, value): self.Related_Action.append(value)
    def insert_Related_Action(self, index, value): self.Related_Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_ActionsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_ActionsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_ActionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_ActionsType', fromsubclass_=False):
        for Related_Action_ in self.Related_Action:
            Related_Action_.export(outfile, level, namespace_, name_='Related_Action')
    def hasContent_(self):
        if (
            self.Related_Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_ActionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Action=[\n')
        level += 1
        for Related_Action_ in self.Related_Action:
            showIndent(outfile, level)
            outfile.write('model_.Related_ActionType(\n')
            Related_Action_.exportLiteral(outfile, level, name_='Related_ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Related_Action':
            obj_ = Related_ActionType.factory()
            obj_.build(child_)
            self.Related_Action.append(obj_)
# end class Related_ActionsType


class Related_ActionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action_Reference=None, Nature_of_Relationship=None):
        self.Action_Reference = Action_Reference
        self.Nature_of_Relationship = Nature_of_Relationship
    def factory(*args_, **kwargs_):
        if Related_ActionType.subclass:
            return Related_ActionType.subclass(*args_, **kwargs_)
        else:
            return Related_ActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def get_Nature_of_Relationship(self): return self.Nature_of_Relationship
    def set_Nature_of_Relationship(self, Nature_of_Relationship): self.Nature_of_Relationship = Nature_of_Relationship
    def export(self, outfile, level, namespace_='maec:', name_='Related_ActionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_ActionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_ActionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_ActionType', fromsubclass_=False):
        if self.Action_Reference is not None:
            self.Action_Reference.export(outfile, level, namespace_, name_='Action_Reference', )
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_of_Relationship>%s</%sNature_of_Relationship>\n' % (namespace_, self.gds_format_string(quote_xml(self.Nature_of_Relationship).encode(ExternalEncoding), input_name='Nature_of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Action_Reference is not None or
            self.Nature_of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_ActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Action_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Action_Reference=model_.ActionReferenceType(\n')
            self.Action_Reference.exportLiteral(outfile, level, name_='Action_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_of_Relationship=%s,\n' % quote_python(self.Nature_of_Relationship).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Reference':
            obj_ = ActionReferenceType.factory()
            obj_.build(child_)
            self.set_Action_Reference(obj_)
        elif nodeName_ == 'Nature_of_Relationship':
            Nature_of_Relationship_ = child_.text
            Nature_of_Relationship_ = self.gds_validate_string(Nature_of_Relationship_, node, 'Nature_of_Relationship')
            self.Nature_of_Relationship = Nature_of_Relationship_
# end class Related_ActionType


class Object_SizeType(GeneratedsSuper):
    """This attribute represents the Units used in the object size field.
    Possible values are: Bytes, Kilobytes, Megabytes."""
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Object_SizeType.subclass:
            return Object_SizeType.subclass(*args_, **kwargs_)
        else:
            return Object_SizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Object_SizeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Object_SizeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Object_SizeType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_SizeType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_SizeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            showIndent(outfile, level)
            outfile.write('units = "%s",\n' % (self.units,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.append('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Object_SizeType


class ClassificationsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Classification=None):
        if Classification is None:
            self.Classification = []
        else:
            self.Classification = Classification
    def factory(*args_, **kwargs_):
        if ClassificationsType.subclass:
            return ClassificationsType.subclass(*args_, **kwargs_)
        else:
            return ClassificationsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Classification(self): return self.Classification
    def set_Classification(self, Classification): self.Classification = Classification
    def add_Classification(self, value): self.Classification.append(value)
    def insert_Classification(self, index, value): self.Classification[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ClassificationsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ClassificationsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ClassificationsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ClassificationsType', fromsubclass_=False):
        for Classification_ in self.Classification:
            Classification_.export(outfile, level, namespace_, name_='Classification')
    def hasContent_(self):
        if (
            self.Classification
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ClassificationsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Classification=[\n')
        level += 1
        for Classification_ in self.Classification:
            showIndent(outfile, level)
            outfile.write('model_.classificationObject(\n')
            Classification_.exportLiteral(outfile, level, name_='classificationObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Classification':
            obj_ = classificationObject.factory()
            obj_.build(child_)
            self.Classification.append(obj_)
# end class ClassificationsType


class Associated_CodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Associated_Code_Snippet=None):
        if Associated_Code_Snippet is None:
            self.Associated_Code_Snippet = []
        else:
            self.Associated_Code_Snippet = Associated_Code_Snippet
    def factory(*args_, **kwargs_):
        if Associated_CodeType.subclass:
            return Associated_CodeType.subclass(*args_, **kwargs_)
        else:
            return Associated_CodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Associated_Code_Snippet(self): return self.Associated_Code_Snippet
    def set_Associated_Code_Snippet(self, Associated_Code_Snippet): self.Associated_Code_Snippet = Associated_Code_Snippet
    def add_Associated_Code_Snippet(self, value): self.Associated_Code_Snippet.append(value)
    def insert_Associated_Code_Snippet(self, index, value): self.Associated_Code_Snippet[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Associated_CodeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Associated_CodeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Associated_CodeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Associated_CodeType', fromsubclass_=False):
        for Associated_Code_Snippet_ in self.Associated_Code_Snippet:
            Associated_Code_Snippet_.export(outfile, level, namespace_, name_='Associated_Code_Snippet')
    def hasContent_(self):
        if (
            self.Associated_Code_Snippet
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Associated_CodeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Associated_Code_Snippet=[\n')
        level += 1
        for Associated_Code_Snippet_ in self.Associated_Code_Snippet:
            showIndent(outfile, level)
            outfile.write('model_.Associated_Code_SnippetType(\n')
            Associated_Code_Snippet_.exportLiteral(outfile, level, name_='Associated_Code_SnippetType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Associated_Code_Snippet':
            obj_ = Associated_Code_SnippetType.factory()
            obj_.build(child_)
            self.Associated_Code_Snippet.append(obj_)
# end class Associated_CodeType


class Associated_Code_SnippetType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Code_Snippet=None, Nature_Of_Relationship=None):
        self.Code_Snippet = Code_Snippet
        self.Nature_Of_Relationship = Nature_Of_Relationship
    def factory(*args_, **kwargs_):
        if Associated_Code_SnippetType.subclass:
            return Associated_Code_SnippetType.subclass(*args_, **kwargs_)
        else:
            return Associated_Code_SnippetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Code_Snippet(self): return self.Code_Snippet
    def set_Code_Snippet(self, Code_Snippet): self.Code_Snippet = Code_Snippet
    def get_Nature_Of_Relationship(self): return self.Nature_Of_Relationship
    def set_Nature_Of_Relationship(self, Nature_Of_Relationship): self.Nature_Of_Relationship = Nature_Of_Relationship
    def export(self, outfile, level, namespace_='maec:', name_='Associated_Code_SnippetType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Associated_Code_SnippetType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Associated_Code_SnippetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Associated_Code_SnippetType', fromsubclass_=False):
        if self.Code_Snippet is not None:
            self.Code_Snippet.export(outfile, level, namespace_, name_='Code_Snippet', )
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_Of_Relationship>%s</%sNature_Of_Relationship>\n' % (namespace_, self.gds_format_string(quote_xml(self.Nature_Of_Relationship).encode(ExternalEncoding), input_name='Nature_Of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Code_Snippet is not None or
            self.Nature_Of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Associated_Code_SnippetType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Code_Snippet is not None:
            showIndent(outfile, level)
            outfile.write('Code_Snippet=model_.CodeType(\n')
            self.Code_Snippet.exportLiteral(outfile, level, name_='Code_Snippet')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_Of_Relationship=%s,\n' % quote_python(self.Nature_Of_Relationship).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Code_Snippet':
            obj_ = CodeType.factory()
            obj_.build(child_)
            self.set_Code_Snippet(obj_)
        elif nodeName_ == 'Nature_Of_Relationship':
            Nature_Of_Relationship_ = child_.text
            Nature_Of_Relationship_ = self.gds_validate_string(Nature_Of_Relationship_, node, 'Nature_Of_Relationship')
            self.Nature_Of_Relationship = Nature_Of_Relationship_
# end class Associated_Code_SnippetType


class Nature_Of_Relationship(GeneratedsSuper):
    """This field defines the relationship between the object and code
    segment referenced in this element. Possible values:
    Contained_Inside, Created_By, Other."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Nature_Of_Relationship.subclass:
            return Nature_Of_Relationship.subclass(*args_, **kwargs_)
        else:
            return Nature_Of_Relationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Nature_Of_Relationship', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Nature_Of_Relationship')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Nature_Of_Relationship'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Nature_Of_Relationship', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nature_Of_Relationship'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Nature_Of_Relationship


class Related_ObjectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Object=None):
        if Related_Object is None:
            self.Related_Object = []
        else:
            self.Related_Object = Related_Object
    def factory(*args_, **kwargs_):
        if Related_ObjectsType.subclass:
            return Related_ObjectsType.subclass(*args_, **kwargs_)
        else:
            return Related_ObjectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Object(self): return self.Related_Object
    def set_Related_Object(self, Related_Object): self.Related_Object = Related_Object
    def add_Related_Object(self, value): self.Related_Object.append(value)
    def insert_Related_Object(self, index, value): self.Related_Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_ObjectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_ObjectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_ObjectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_ObjectsType', fromsubclass_=False):
        for Related_Object_ in self.Related_Object:
            Related_Object_.export(outfile, level, namespace_, name_='Related_Object')
    def hasContent_(self):
        if (
            self.Related_Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_ObjectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Object=[\n')
        level += 1
        for Related_Object_ in self.Related_Object:
            showIndent(outfile, level)
            outfile.write('model_.Related_ObjectType(\n')
            Related_Object_.exportLiteral(outfile, level, name_='Related_ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Related_Object':
            obj_ = Related_ObjectType.factory()
            obj_.build(child_)
            self.Related_Object.append(obj_)
# end class Related_ObjectsType


class Related_ObjectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None, Nature_Of_Relationship=None):
        self.Object_Reference = Object_Reference
        self.Nature_Of_Relationship = Nature_Of_Relationship
    def factory(*args_, **kwargs_):
        if Related_ObjectType.subclass:
            return Related_ObjectType.subclass(*args_, **kwargs_)
        else:
            return Related_ObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_Nature_Of_Relationship(self): return self.Nature_Of_Relationship
    def set_Nature_Of_Relationship(self, Nature_Of_Relationship): self.Nature_Of_Relationship = Nature_Of_Relationship
    def export(self, outfile, level, namespace_='maec:', name_='Related_ObjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Related_ObjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Related_ObjectType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_ObjectType', fromsubclass_=False):
        if self.Object_Reference is not None:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference', )
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_Of_Relationship>%s</%sNature_Of_Relationship>\n' % (namespace_, self.gds_format_string(quote_xml(self.Nature_Of_Relationship).encode(ExternalEncoding), input_name='Nature_Of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Object_Reference is not None or
            self.Nature_Of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_ObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_Of_Relationship=%s,\n' % quote_python(self.Nature_Of_Relationship).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
        elif nodeName_ == 'Nature_Of_Relationship':
            Nature_Of_Relationship_ = child_.text
            Nature_Of_Relationship_ = self.gds_validate_string(Nature_Of_Relationship_, node, 'Nature_Of_Relationship')
            self.Nature_Of_Relationship = Nature_Of_Relationship_
# end class Related_ObjectType


class File_System_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DateTime_Created=None, DateTime_Modified=None, Path=None, Hashes=None, Permissions=None, File_Type=None, Packing=None, Pipe_Mode=None, Maximum_Instances=None, Security_Attributes=None, Origin=None, File_Type_Attributes=None):
        self.DateTime_Created = DateTime_Created
        self.DateTime_Modified = DateTime_Modified
        self.Path = Path
        self.Hashes = Hashes
        self.Permissions = Permissions
        self.File_Type = File_Type
        self.Packing = Packing
        self.Pipe_Mode = Pipe_Mode
        self.Maximum_Instances = Maximum_Instances
        self.Security_Attributes = Security_Attributes
        self.Origin = Origin
        self.File_Type_Attributes = File_Type_Attributes
    def factory(*args_, **kwargs_):
        if File_System_Object_AttributesType.subclass:
            return File_System_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return File_System_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateTime_Created(self): return self.DateTime_Created
    def set_DateTime_Created(self, DateTime_Created): self.DateTime_Created = DateTime_Created
    def get_DateTime_Modified(self): return self.DateTime_Modified
    def set_DateTime_Modified(self, DateTime_Modified): self.DateTime_Modified = DateTime_Modified
    def get_Path(self): return self.Path
    def set_Path(self, Path): self.Path = Path
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Permissions(self): return self.Permissions
    def set_Permissions(self, Permissions): self.Permissions = Permissions
    def get_File_Type(self): return self.File_Type
    def set_File_Type(self, File_Type): self.File_Type = File_Type
    def get_Packing(self): return self.Packing
    def set_Packing(self, Packing): self.Packing = Packing
    def get_Pipe_Mode(self): return self.Pipe_Mode
    def set_Pipe_Mode(self, Pipe_Mode): self.Pipe_Mode = Pipe_Mode
    def get_Maximum_Instances(self): return self.Maximum_Instances
    def set_Maximum_Instances(self, Maximum_Instances): self.Maximum_Instances = Maximum_Instances
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Origin(self): return self.Origin
    def set_Origin(self, Origin): self.Origin = Origin
    def get_File_Type_Attributes(self): return self.File_Type_Attributes
    def set_File_Type_Attributes(self, File_Type_Attributes): self.File_Type_Attributes = File_Type_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_System_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_System_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='File_System_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_System_Object_AttributesType', fromsubclass_=False):
        if self.DateTime_Created is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime_Created>%s</%sDateTime_Created>\n' % (namespace_, self.gds_format_string(quote_xml(self.DateTime_Created).encode(ExternalEncoding), input_name='DateTime_Created'), namespace_))
        if self.DateTime_Modified is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime_Modified>%s</%sDateTime_Modified>\n' % (namespace_, self.gds_format_string(quote_xml(self.DateTime_Modified).encode(ExternalEncoding), input_name='DateTime_Modified'), namespace_))
        if self.Path is not None:
            self.Path.export(outfile, level, namespace_, name_='Path')
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Permissions is not None:
            showIndent(outfile, level)
            outfile.write('<%sPermissions>%s</%sPermissions>\n' % (namespace_, self.gds_format_string(quote_xml(self.Permissions).encode(ExternalEncoding), input_name='Permissions'), namespace_))
        if self.File_Type is not None:
            self.File_Type.export(outfile, level, namespace_, name_='File_Type')
        if self.Packing is not None:
            self.Packing.export(outfile, level, namespace_, name_='Packing')
        if self.Pipe_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sPipe_Mode>%s</%sPipe_Mode>\n' % (namespace_, self.gds_format_string(quote_xml(self.Pipe_Mode).encode(ExternalEncoding), input_name='Pipe_Mode'), namespace_))
        if self.Maximum_Instances is not None:
            showIndent(outfile, level)
            outfile.write('<%sMaximum_Instances>%s</%sMaximum_Instances>\n' % (namespace_, self.gds_format_integer(self.Maximum_Instances, input_name='Maximum_Instances'), namespace_))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.gds_format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Origin is not None:
            self.Origin.export(outfile, level, namespace_, name_='Origin')
        if self.File_Type_Attributes is not None:
            self.File_Type_Attributes.export(outfile, level, namespace_, name_='File_Type_Attributes')
    def hasContent_(self):
        if (
            self.DateTime_Created is not None or
            self.DateTime_Modified is not None or
            self.Path is not None or
            self.Hashes is not None or
            self.Permissions is not None or
            self.File_Type is not None or
            self.Packing is not None or
            self.Pipe_Mode is not None or
            self.Maximum_Instances is not None or
            self.Security_Attributes is not None or
            self.Origin is not None or
            self.File_Type_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_System_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DateTime_Created is not None:
            showIndent(outfile, level)
            outfile.write('DateTime_Created=%s,\n' % quote_python(self.DateTime_Created).encode(ExternalEncoding))
        if self.DateTime_Modified is not None:
            showIndent(outfile, level)
            outfile.write('DateTime_Modified=%s,\n' % quote_python(self.DateTime_Modified).encode(ExternalEncoding))
        if self.Path is not None:
            showIndent(outfile, level)
            outfile.write('Path=model_.PathType(\n')
            self.Path.exportLiteral(outfile, level, name_='Path')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Permissions is not None:
            showIndent(outfile, level)
            outfile.write('Permissions=%s,\n' % quote_python(self.Permissions).encode(ExternalEncoding))
        if self.File_Type is not None:
            showIndent(outfile, level)
            outfile.write('File_Type=model_.File_TypeType(\n')
            self.File_Type.exportLiteral(outfile, level, name_='File_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Packing is not None:
            showIndent(outfile, level)
            outfile.write('Packing=model_.PackingType(\n')
            self.Packing.exportLiteral(outfile, level, name_='Packing')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pipe_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Pipe_Mode=%s,\n' % quote_python(self.Pipe_Mode).encode(ExternalEncoding))
        if self.Maximum_Instances is not None:
            showIndent(outfile, level)
            outfile.write('Maximum_Instances=%d,\n' % self.Maximum_Instances)
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Origin is not None:
            showIndent(outfile, level)
            outfile.write('Origin=model_.uriObject(\n')
            self.Origin.exportLiteral(outfile, level, name_='Origin')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Type_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_Type_Attributes=model_.File_Type_AttributesType(\n')
            self.File_Type_Attributes.exportLiteral(outfile, level, name_='File_Type_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DateTime_Created':
            DateTime_Created_ = child_.text
            DateTime_Created_ = self.gds_validate_string(DateTime_Created_, node, 'DateTime_Created')
            self.DateTime_Created = DateTime_Created_
        elif nodeName_ == 'DateTime_Modified':
            DateTime_Modified_ = child_.text
            DateTime_Modified_ = self.gds_validate_string(DateTime_Modified_, node, 'DateTime_Modified')
            self.DateTime_Modified = DateTime_Modified_
        elif nodeName_ == 'Path':
            obj_ = PathType.factory()
            obj_.build(child_)
            self.set_Path(obj_)
        elif nodeName_ == 'Hashes':
            obj_ = HashesType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Permissions':
            Permissions_ = child_.text
            Permissions_ = self.gds_validate_string(Permissions_, node, 'Permissions')
            self.Permissions = Permissions_
        elif nodeName_ == 'File_Type':
            obj_ = File_TypeType.factory()
            obj_.build(child_)
            self.set_File_Type(obj_)
        elif nodeName_ == 'Packing':
            obj_ = PackingType.factory()
            obj_.build(child_)
            self.set_Packing(obj_)
        elif nodeName_ == 'Pipe_Mode':
            Pipe_Mode_ = child_.text
            Pipe_Mode_ = self.gds_validate_string(Pipe_Mode_, node, 'Pipe_Mode')
            self.Pipe_Mode = Pipe_Mode_
        elif nodeName_ == 'Maximum_Instances':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Maximum_Instances')
            self.Maximum_Instances = ival_
        elif nodeName_ == 'Security_Attributes':
            Security_Attributes_ = child_.text
            Security_Attributes_ = self.gds_validate_string(Security_Attributes_, node, 'Security_Attributes')
            self.Security_Attributes = Security_Attributes_
        elif nodeName_ == 'Origin':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.set_Origin(obj_)
        elif nodeName_ == 'File_Type_Attributes':
            obj_ = File_Type_AttributesType.factory()
            obj_.build(child_)
            self.set_File_Type_Attributes(obj_)
# end class File_System_Object_AttributesType


class PathType(GeneratedsSuper):
    """This attribute refers to the type of path that this element refers
    to. Possible values: Fully_Qualified, Relative."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PathType.subclass:
            return PathType.subclass(*args_, **kwargs_)
        else:
            return PathType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='PathType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PathType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PathType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PathType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PathType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PathType


class HashesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType.subclass:
            return HashesType.subclass(*args_, **kwargs_)
        else:
            return HashesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType


class File_TypeType(GeneratedsSuper):
    """The type attribute is meant to provide a general way of
    characterizing file type, through MAEC's FileType enumeration.
    Possible values: PE, JS, PDF, ZIP, TXT, ASM, DOC, DOCX, XLS,
    XLSX, PPT, PPTX, Other."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, TrID_Type=None, Discovery_Method=None):
        self.type_ = _cast(None, type_)
        self.TrID_Type = TrID_Type
        self.Discovery_Method = Discovery_Method
    def factory(*args_, **kwargs_):
        if File_TypeType.subclass:
            return File_TypeType.subclass(*args_, **kwargs_)
        else:
            return File_TypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TrID_Type(self): return self.TrID_Type
    def set_TrID_Type(self, TrID_Type): self.TrID_Type = TrID_Type
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='File_TypeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_TypeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='File_TypeType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_TypeType', fromsubclass_=False):
        if self.TrID_Type is not None:
            self.TrID_Type.export(outfile, level, namespace_, name_='TrID_Type')
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
    def hasContent_(self):
        if (
            self.TrID_Type is not None or
            self.Discovery_Method is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_TypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TrID_Type is not None:
            showIndent(outfile, level)
            outfile.write('TrID_Type=model_.TrID_TypeType(\n')
            self.TrID_Type.exportLiteral(outfile, level, name_='TrID_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TrID_Type':
            obj_ = TrID_TypeType.factory()
            obj_.build(child_)
            self.set_TrID_Type(obj_)
        elif nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
# end class File_TypeType


class TrID_TypeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, TriD_ID=None, TRID_Confidence=None):
        self.TriD_ID = TriD_ID
        self.TRID_Confidence = TRID_Confidence
    def factory(*args_, **kwargs_):
        if TrID_TypeType.subclass:
            return TrID_TypeType.subclass(*args_, **kwargs_)
        else:
            return TrID_TypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TriD_ID(self): return self.TriD_ID
    def set_TriD_ID(self, TriD_ID): self.TriD_ID = TriD_ID
    def get_TRID_Confidence(self): return self.TRID_Confidence
    def set_TRID_Confidence(self, TRID_Confidence): self.TRID_Confidence = TRID_Confidence
    def export(self, outfile, level, namespace_='maec:', name_='TrID_TypeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TrID_TypeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='TrID_TypeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='TrID_TypeType', fromsubclass_=False):
        if self.TriD_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTriD_ID>%s</%sTriD_ID>\n' % (namespace_, self.gds_format_string(quote_xml(self.TriD_ID).encode(ExternalEncoding), input_name='TriD_ID'), namespace_))
        if self.TRID_Confidence is not None:
            showIndent(outfile, level)
            outfile.write('<%sTRID_Confidence>%s</%sTRID_Confidence>\n' % (namespace_, self.gds_format_float(self.TRID_Confidence, input_name='TRID_Confidence'), namespace_))
    def hasContent_(self):
        if (
            self.TriD_ID is not None or
            self.TRID_Confidence is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TrID_TypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TriD_ID is not None:
            showIndent(outfile, level)
            outfile.write('TriD_ID=%s,\n' % quote_python(self.TriD_ID).encode(ExternalEncoding))
        if self.TRID_Confidence is not None:
            showIndent(outfile, level)
            outfile.write('TRID_Confidence=%f,\n' % self.TRID_Confidence)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TriD_ID':
            TriD_ID_ = child_.text
            TriD_ID_ = self.gds_validate_string(TriD_ID_, node, 'TriD_ID')
            self.TriD_ID = TriD_ID_
        elif nodeName_ == 'TRID_Confidence':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires float or double: %s' % e)
            fval_ = self.gds_validate_float(fval_, node, 'TRID_Confidence')
            self.TRID_Confidence = fval_
# end class TrID_TypeType


class PackingType(GeneratedsSuper):
    """The is_packed attribute is used to indicate whether the file system
    object is packed or not."""
    subclass = None
    superclass = None
    def __init__(self, is_packed=None, Packer_Type=None):
        self.is_packed = _cast(bool, is_packed)
        if Packer_Type is None:
            self.Packer_Type = []
        else:
            self.Packer_Type = Packer_Type
    def factory(*args_, **kwargs_):
        if PackingType.subclass:
            return PackingType.subclass(*args_, **kwargs_)
        else:
            return PackingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Packer_Type(self): return self.Packer_Type
    def set_Packer_Type(self, Packer_Type): self.Packer_Type = Packer_Type
    def add_Packer_Type(self, value): self.Packer_Type.append(value)
    def insert_Packer_Type(self, index, value): self.Packer_Type[index] = value
    def get_is_packed(self): return self.is_packed
    def set_is_packed(self, is_packed): self.is_packed = is_packed
    def export(self, outfile, level, namespace_='maec:', name_='PackingType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PackingType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PackingType'):
        if self.is_packed is not None and 'is_packed' not in already_processed:
            already_processed.append('is_packed')
            outfile.write(' is_packed="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_packed)), input_name='is_packed'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PackingType', fromsubclass_=False):
        for Packer_Type_ in self.Packer_Type:
            Packer_Type_.export(outfile, level, namespace_, name_='Packer_Type')
    def hasContent_(self):
        if (
            self.Packer_Type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PackingType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_packed is not None and 'is_packed' not in already_processed:
            already_processed.append('is_packed')
            showIndent(outfile, level)
            outfile.write('is_packed = %s,\n' % (self.is_packed,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Packer_Type=[\n')
        level += 1
        for Packer_Type_ in self.Packer_Type:
            showIndent(outfile, level)
            outfile.write('model_.Packer_TypeType(\n')
            Packer_Type_.exportLiteral(outfile, level, name_='Packer_TypeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_packed', node)
        if value is not None and 'is_packed' not in already_processed:
            already_processed.append('is_packed')
            if value in ('true', '1'):
                self.is_packed = True
            elif value in ('false', '0'):
                self.is_packed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Packer_Type':
            obj_ = Packer_TypeType.factory()
            obj_.build(child_)
            self.Packer_Type.append(obj_)
# end class PackingType


class Packer_TypeType(GeneratedsSuper):
    """This is intended to characterize the type of packer characterized in
    this element. Possible values: Archiver, Installer, Self-
    Extracting_Archiver, Crypter, Packer, Protector, Bundler, Other."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, Name=None, Version=None, Discovery_Method=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Name = Name
        self.Version = Version
        self.Discovery_Method = Discovery_Method
    def factory(*args_, **kwargs_):
        if Packer_TypeType.subclass:
            return Packer_TypeType.subclass(*args_, **kwargs_)
        else:
            return Packer_TypeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='Packer_TypeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Packer_TypeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Packer_TypeType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Packer_TypeType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Version is not None or
            self.Discovery_Method is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Packer_TypeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Version':
            Version_ = child_.text
            Version_ = self.gds_validate_string(Version_, node, 'Version')
            self.Version = Version_
        elif nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
# end class Packer_TypeType


class File_Type_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, PE_Binary_Attributes=None):
        self.PE_Binary_Attributes = PE_Binary_Attributes
    def factory(*args_, **kwargs_):
        if File_Type_AttributesType.subclass:
            return File_Type_AttributesType.subclass(*args_, **kwargs_)
        else:
            return File_Type_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PE_Binary_Attributes(self): return self.PE_Binary_Attributes
    def set_PE_Binary_Attributes(self, PE_Binary_Attributes): self.PE_Binary_Attributes = PE_Binary_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_Type_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_Type_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='File_Type_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_Type_AttributesType', fromsubclass_=False):
        if self.PE_Binary_Attributes is not None:
            self.PE_Binary_Attributes.export(outfile, level, namespace_, name_='PE_Binary_Attributes')
    def hasContent_(self):
        if (
            self.PE_Binary_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_Type_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.PE_Binary_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('PE_Binary_Attributes=model_.PE_Binary_AttributesType(\n')
            self.PE_Binary_Attributes.exportLiteral(outfile, level, name_='PE_Binary_Attributes')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PE_Binary_Attributes':
            obj_ = PE_Binary_AttributesType.factory()
            obj_.build(child_)
            self.set_PE_Binary_Attributes(obj_)
# end class File_Type_AttributesType


class PE_Binary_AttributesType(GeneratedsSuper):
    """The type attribute is used to define the type of PE file being
    characterized. Possible values: EXE, DLL.The dll_count attribute
    is used to define the number of DLLs loaded by a PE file."""
    subclass = None
    superclass = None
    def __init__(self, dll_count=None, type_=None, Version_Block=None, Headers=None, Strings=None, Imports=None, Exports=None, Resources=None, Sections=None, Digital_Certificates=None):
        self.dll_count = _cast(int, dll_count)
        self.type_ = _cast(None, type_)
        self.Version_Block = Version_Block
        self.Headers = Headers
        self.Strings = Strings
        self.Imports = Imports
        self.Exports = Exports
        self.Resources = Resources
        self.Sections = Sections
        self.Digital_Certificates = Digital_Certificates
    def factory(*args_, **kwargs_):
        if PE_Binary_AttributesType.subclass:
            return PE_Binary_AttributesType.subclass(*args_, **kwargs_)
        else:
            return PE_Binary_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Version_Block(self): return self.Version_Block
    def set_Version_Block(self, Version_Block): self.Version_Block = Version_Block
    def get_Headers(self): return self.Headers
    def set_Headers(self, Headers): self.Headers = Headers
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def get_Imports(self): return self.Imports
    def set_Imports(self, Imports): self.Imports = Imports
    def get_Exports(self): return self.Exports
    def set_Exports(self, Exports): self.Exports = Exports
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Sections(self): return self.Sections
    def set_Sections(self, Sections): self.Sections = Sections
    def get_Digital_Certificates(self): return self.Digital_Certificates
    def set_Digital_Certificates(self, Digital_Certificates): self.Digital_Certificates = Digital_Certificates
    def get_dll_count(self): return self.dll_count
    def set_dll_count(self, dll_count): self.dll_count = dll_count
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='PE_Binary_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PE_Binary_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PE_Binary_AttributesType'):
        if self.dll_count is not None and 'dll_count' not in already_processed:
            already_processed.append('dll_count')
            outfile.write(' dll_count="%s"' % self.gds_format_integer(self.dll_count, input_name='dll_count'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PE_Binary_AttributesType', fromsubclass_=False):
        if self.Version_Block is not None:
            self.Version_Block.export(outfile, level, namespace_, name_='Version_Block')
        if self.Headers is not None:
            self.Headers.export(outfile, level, namespace_, name_='Headers')
        if self.Strings is not None:
            self.Strings.export(outfile, level, namespace_, name_='Strings')
        if self.Imports is not None:
            self.Imports.export(outfile, level, namespace_, name_='Imports')
        if self.Exports is not None:
            self.Exports.export(outfile, level, namespace_, name_='Exports')
        if self.Resources is not None:
            self.Resources.export(outfile, level, namespace_, name_='Resources')
        if self.Sections is not None:
            self.Sections.export(outfile, level, namespace_, name_='Sections')
        if self.Digital_Certificates is not None:
            self.Digital_Certificates.export(outfile, level, namespace_, name_='Digital_Certificates')
    def hasContent_(self):
        if (
            self.Version_Block is not None or
            self.Headers is not None or
            self.Strings is not None or
            self.Imports is not None or
            self.Exports is not None or
            self.Resources is not None or
            self.Sections is not None or
            self.Digital_Certificates is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PE_Binary_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.dll_count is not None and 'dll_count' not in already_processed:
            already_processed.append('dll_count')
            showIndent(outfile, level)
            outfile.write('dll_count = %d,\n' % (self.dll_count,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Version_Block is not None:
            showIndent(outfile, level)
            outfile.write('Version_Block=model_.Version_BlockType(\n')
            self.Version_Block.exportLiteral(outfile, level, name_='Version_Block')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Headers is not None:
            showIndent(outfile, level)
            outfile.write('Headers=model_.HeadersType(\n')
            self.Headers.exportLiteral(outfile, level, name_='Headers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Strings is not None:
            showIndent(outfile, level)
            outfile.write('Strings=model_.StringsType(\n')
            self.Strings.exportLiteral(outfile, level, name_='Strings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imports is not None:
            showIndent(outfile, level)
            outfile.write('Imports=model_.ImportsType(\n')
            self.Imports.exportLiteral(outfile, level, name_='Imports')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exports is not None:
            showIndent(outfile, level)
            outfile.write('Exports=model_.ExportsType(\n')
            self.Exports.exportLiteral(outfile, level, name_='Exports')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resources is not None:
            showIndent(outfile, level)
            outfile.write('Resources=model_.ResourcesType(\n')
            self.Resources.exportLiteral(outfile, level, name_='Resources')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Sections is not None:
            showIndent(outfile, level)
            outfile.write('Sections=model_.SectionsType(\n')
            self.Sections.exportLiteral(outfile, level, name_='Sections')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Digital_Certificates is not None:
            showIndent(outfile, level)
            outfile.write('Digital_Certificates=model_.Digital_CertificatesType(\n')
            self.Digital_Certificates.exportLiteral(outfile, level, name_='Digital_Certificates')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dll_count', node)
        if value is not None and 'dll_count' not in already_processed:
            already_processed.append('dll_count')
            try:
                self.dll_count = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Version_Block':
            obj_ = Version_BlockType.factory()
            obj_.build(child_)
            self.set_Version_Block(obj_)
        elif nodeName_ == 'Headers':
            obj_ = HeadersType.factory()
            obj_.build(child_)
            self.set_Headers(obj_)
        elif nodeName_ == 'Strings':
            obj_ = StringsType.factory()
            obj_.build(child_)
            self.set_Strings(obj_)
        elif nodeName_ == 'Imports':
            obj_ = ImportsType.factory()
            obj_.build(child_)
            self.set_Imports(obj_)
        elif nodeName_ == 'Exports':
            obj_ = ExportsType.factory()
            obj_.build(child_)
            self.set_Exports(obj_)
        elif nodeName_ == 'Resources':
            obj_ = ResourcesType.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif nodeName_ == 'Sections':
            obj_ = SectionsType.factory()
            obj_.build(child_)
            self.set_Sections(obj_)
        elif nodeName_ == 'Digital_Certificates':
            obj_ = Digital_CertificatesType.factory()
            obj_.build(child_)
            self.set_Digital_Certificates(obj_)
# end class PE_Binary_AttributesType


class Version_BlockType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Name=None, Product_Name=None, Company_Name=None, Legal_Copyright=None, Product_Version_Text=None, File_Description=None, File_Version_Text=None, Original_File_Name=None):
        self.Internal_Name = Internal_Name
        self.Product_Name = Product_Name
        self.Company_Name = Company_Name
        self.Legal_Copyright = Legal_Copyright
        self.Product_Version_Text = Product_Version_Text
        self.File_Description = File_Description
        self.File_Version_Text = File_Version_Text
        self.Original_File_Name = Original_File_Name
    def factory(*args_, **kwargs_):
        if Version_BlockType.subclass:
            return Version_BlockType.subclass(*args_, **kwargs_)
        else:
            return Version_BlockType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Name(self): return self.Internal_Name
    def set_Internal_Name(self, Internal_Name): self.Internal_Name = Internal_Name
    def get_Product_Name(self): return self.Product_Name
    def set_Product_Name(self, Product_Name): self.Product_Name = Product_Name
    def get_Company_Name(self): return self.Company_Name
    def set_Company_Name(self, Company_Name): self.Company_Name = Company_Name
    def get_Legal_Copyright(self): return self.Legal_Copyright
    def set_Legal_Copyright(self, Legal_Copyright): self.Legal_Copyright = Legal_Copyright
    def get_Product_Version_Text(self): return self.Product_Version_Text
    def set_Product_Version_Text(self, Product_Version_Text): self.Product_Version_Text = Product_Version_Text
    def get_File_Description(self): return self.File_Description
    def set_File_Description(self, File_Description): self.File_Description = File_Description
    def get_File_Version_Text(self): return self.File_Version_Text
    def set_File_Version_Text(self, File_Version_Text): self.File_Version_Text = File_Version_Text
    def get_Original_File_Name(self): return self.Original_File_Name
    def set_Original_File_Name(self, Original_File_Name): self.Original_File_Name = Original_File_Name
    def export(self, outfile, level, namespace_='maec:', name_='Version_BlockType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Version_BlockType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Version_BlockType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Version_BlockType', fromsubclass_=False):
        if self.Internal_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Name>%s</%sInternal_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Internal_Name).encode(ExternalEncoding), input_name='Internal_Name'), namespace_))
        if self.Product_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sProduct_Name>%s</%sProduct_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Product_Name).encode(ExternalEncoding), input_name='Product_Name'), namespace_))
        if self.Company_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sCompany_Name>%s</%sCompany_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Company_Name).encode(ExternalEncoding), input_name='Company_Name'), namespace_))
        if self.Legal_Copyright is not None:
            showIndent(outfile, level)
            outfile.write('<%sLegal_Copyright>%s</%sLegal_Copyright>\n' % (namespace_, self.gds_format_string(quote_xml(self.Legal_Copyright).encode(ExternalEncoding), input_name='Legal_Copyright'), namespace_))
        if self.Product_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sProduct_Version_Text>%s</%sProduct_Version_Text>\n' % (namespace_, self.gds_format_string(quote_xml(self.Product_Version_Text).encode(ExternalEncoding), input_name='Product_Version_Text'), namespace_))
        if self.File_Description is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Description>%s</%sFile_Description>\n' % (namespace_, self.gds_format_string(quote_xml(self.File_Description).encode(ExternalEncoding), input_name='File_Description'), namespace_))
        if self.File_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Version_Text>%s</%sFile_Version_Text>\n' % (namespace_, self.gds_format_string(quote_xml(self.File_Version_Text).encode(ExternalEncoding), input_name='File_Version_Text'), namespace_))
        if self.Original_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sOriginal_File_Name>%s</%sOriginal_File_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Original_File_Name).encode(ExternalEncoding), input_name='Original_File_Name'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Name is not None or
            self.Product_Name is not None or
            self.Company_Name is not None or
            self.Legal_Copyright is not None or
            self.Product_Version_Text is not None or
            self.File_Description is not None or
            self.File_Version_Text is not None or
            self.Original_File_Name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Version_BlockType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Name is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Name=%s,\n' % quote_python(self.Internal_Name).encode(ExternalEncoding))
        if self.Product_Name is not None:
            showIndent(outfile, level)
            outfile.write('Product_Name=%s,\n' % quote_python(self.Product_Name).encode(ExternalEncoding))
        if self.Company_Name is not None:
            showIndent(outfile, level)
            outfile.write('Company_Name=%s,\n' % quote_python(self.Company_Name).encode(ExternalEncoding))
        if self.Legal_Copyright is not None:
            showIndent(outfile, level)
            outfile.write('Legal_Copyright=%s,\n' % quote_python(self.Legal_Copyright).encode(ExternalEncoding))
        if self.Product_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('Product_Version_Text=%s,\n' % quote_python(self.Product_Version_Text).encode(ExternalEncoding))
        if self.File_Description is not None:
            showIndent(outfile, level)
            outfile.write('File_Description=%s,\n' % quote_python(self.File_Description).encode(ExternalEncoding))
        if self.File_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('File_Version_Text=%s,\n' % quote_python(self.File_Version_Text).encode(ExternalEncoding))
        if self.Original_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Original_File_Name=%s,\n' % quote_python(self.Original_File_Name).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Internal_Name':
            Internal_Name_ = child_.text
            Internal_Name_ = self.gds_validate_string(Internal_Name_, node, 'Internal_Name')
            self.Internal_Name = Internal_Name_
        elif nodeName_ == 'Product_Name':
            Product_Name_ = child_.text
            Product_Name_ = self.gds_validate_string(Product_Name_, node, 'Product_Name')
            self.Product_Name = Product_Name_
        elif nodeName_ == 'Company_Name':
            Company_Name_ = child_.text
            Company_Name_ = self.gds_validate_string(Company_Name_, node, 'Company_Name')
            self.Company_Name = Company_Name_
        elif nodeName_ == 'Legal_Copyright':
            Legal_Copyright_ = child_.text
            Legal_Copyright_ = self.gds_validate_string(Legal_Copyright_, node, 'Legal_Copyright')
            self.Legal_Copyright = Legal_Copyright_
        elif nodeName_ == 'Product_Version_Text':
            Product_Version_Text_ = child_.text
            Product_Version_Text_ = self.gds_validate_string(Product_Version_Text_, node, 'Product_Version_Text')
            self.Product_Version_Text = Product_Version_Text_
        elif nodeName_ == 'File_Description':
            File_Description_ = child_.text
            File_Description_ = self.gds_validate_string(File_Description_, node, 'File_Description')
            self.File_Description = File_Description_
        elif nodeName_ == 'File_Version_Text':
            File_Version_Text_ = child_.text
            File_Version_Text_ = self.gds_validate_string(File_Version_Text_, node, 'File_Version_Text')
            self.File_Version_Text = File_Version_Text_
        elif nodeName_ == 'Original_File_Name':
            Original_File_Name_ = child_.text
            Original_File_Name_ = self.gds_validate_string(Original_File_Name_, node, 'Original_File_Name')
            self.Original_File_Name = Original_File_Name_
# end class Version_BlockType


class HeadersType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DOS_Header=None, PE_Header=None, Section_Table=None):
        self.DOS_Header = DOS_Header
        self.PE_Header = PE_Header
        self.Section_Table = Section_Table
    def factory(*args_, **kwargs_):
        if HeadersType.subclass:
            return HeadersType.subclass(*args_, **kwargs_)
        else:
            return HeadersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DOS_Header(self): return self.DOS_Header
    def set_DOS_Header(self, DOS_Header): self.DOS_Header = DOS_Header
    def get_PE_Header(self): return self.PE_Header
    def set_PE_Header(self, PE_Header): self.PE_Header = PE_Header
    def get_Section_Table(self): return self.Section_Table
    def set_Section_Table(self, Section_Table): self.Section_Table = Section_Table
    def export(self, outfile, level, namespace_='maec:', name_='HeadersType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HeadersType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HeadersType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HeadersType', fromsubclass_=False):
        if self.DOS_Header is not None:
            self.DOS_Header.export(outfile, level, namespace_, name_='DOS_Header')
        if self.PE_Header is not None:
            self.PE_Header.export(outfile, level, namespace_, name_='PE_Header')
        if self.Section_Table is not None:
            self.Section_Table.export(outfile, level, namespace_, name_='Section_Table')
    def hasContent_(self):
        if (
            self.DOS_Header is not None or
            self.PE_Header is not None or
            self.Section_Table is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HeadersType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DOS_Header is not None:
            showIndent(outfile, level)
            outfile.write('DOS_Header=model_.DOS_HeaderType(\n')
            self.DOS_Header.exportLiteral(outfile, level, name_='DOS_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_Header is not None:
            showIndent(outfile, level)
            outfile.write('PE_Header=model_.PE_HeaderType(\n')
            self.PE_Header.exportLiteral(outfile, level, name_='PE_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Table is not None:
            showIndent(outfile, level)
            outfile.write('Section_Table=model_.Section_TableType(\n')
            self.Section_Table.exportLiteral(outfile, level, name_='Section_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DOS_Header':
            obj_ = DOS_HeaderType.factory()
            obj_.build(child_)
            self.set_DOS_Header(obj_)
        elif nodeName_ == 'PE_Header':
            obj_ = PE_HeaderType.factory()
            obj_.build(child_)
            self.set_PE_Header(obj_)
        elif nodeName_ == 'Section_Table':
            obj_ = Section_TableType.factory()
            obj_.build(child_)
            self.set_Section_Table(obj_)
# end class HeadersType


class DOS_HeaderType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, signature=None, lastsize=None, nblocks=None, nreloc=None, hdrsize=None, minalloc=None, maxalloc=None, checksum=None, relocpos=None, noverlay=None, reserved1=None, oem_id=None, oem_info=None, reserved2=None, e_lfanew=None):
        self.Hashes = Hashes
        self.signature = signature
        self.lastsize = lastsize
        self.nblocks = nblocks
        self.nreloc = nreloc
        self.hdrsize = hdrsize
        self.minalloc = minalloc
        self.maxalloc = maxalloc
        self.checksum = checksum
        self.relocpos = relocpos
        self.noverlay = noverlay
        self.reserved1 = reserved1
        self.oem_id = oem_id
        self.oem_info = oem_info
        self.reserved2 = reserved2
        self.e_lfanew = e_lfanew
    def factory(*args_, **kwargs_):
        if DOS_HeaderType.subclass:
            return DOS_HeaderType.subclass(*args_, **kwargs_)
        else:
            return DOS_HeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_signature(self): return self.signature
    def set_signature(self, signature): self.signature = signature
    def get_lastsize(self): return self.lastsize
    def set_lastsize(self, lastsize): self.lastsize = lastsize
    def get_nblocks(self): return self.nblocks
    def set_nblocks(self, nblocks): self.nblocks = nblocks
    def get_nreloc(self): return self.nreloc
    def set_nreloc(self, nreloc): self.nreloc = nreloc
    def get_hdrsize(self): return self.hdrsize
    def set_hdrsize(self, hdrsize): self.hdrsize = hdrsize
    def get_minalloc(self): return self.minalloc
    def set_minalloc(self, minalloc): self.minalloc = minalloc
    def get_maxalloc(self): return self.maxalloc
    def set_maxalloc(self, maxalloc): self.maxalloc = maxalloc
    def get_checksum(self): return self.checksum
    def set_checksum(self, checksum): self.checksum = checksum
    def get_relocpos(self): return self.relocpos
    def set_relocpos(self, relocpos): self.relocpos = relocpos
    def get_noverlay(self): return self.noverlay
    def set_noverlay(self, noverlay): self.noverlay = noverlay
    def get_reserved1(self): return self.reserved1
    def set_reserved1(self, reserved1): self.reserved1 = reserved1
    def get_oem_id(self): return self.oem_id
    def set_oem_id(self, oem_id): self.oem_id = oem_id
    def get_oem_info(self): return self.oem_info
    def set_oem_info(self, oem_info): self.oem_info = oem_info
    def get_reserved2(self): return self.reserved2
    def set_reserved2(self, reserved2): self.reserved2 = reserved2
    def get_e_lfanew(self): return self.e_lfanew
    def set_e_lfanew(self, e_lfanew): self.e_lfanew = e_lfanew
    def export(self, outfile, level, namespace_='maec:', name_='DOS_HeaderType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DOS_HeaderType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='DOS_HeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DOS_HeaderType', fromsubclass_=False):
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.signature is not None:
            self.signature.export(outfile, level, namespace_, name_='signature')
        if self.lastsize is not None:
            self.lastsize.export(outfile, level, namespace_, name_='lastsize')
        if self.nblocks is not None:
            self.nblocks.export(outfile, level, namespace_, name_='nblocks')
        if self.nreloc is not None:
            self.nreloc.export(outfile, level, namespace_, name_='nreloc')
        if self.hdrsize is not None:
            self.hdrsize.export(outfile, level, namespace_, name_='hdrsize')
        if self.minalloc is not None:
            self.minalloc.export(outfile, level, namespace_, name_='minalloc')
        if self.maxalloc is not None:
            self.maxalloc.export(outfile, level, namespace_, name_='maxalloc')
        if self.checksum is not None:
            self.checksum.export(outfile, level, namespace_, name_='checksum')
        if self.relocpos is not None:
            self.relocpos.export(outfile, level, namespace_, name_='relocpos')
        if self.noverlay is not None:
            self.noverlay.export(outfile, level, namespace_, name_='noverlay')
        if self.reserved1 is not None:
            self.reserved1.export(outfile, level, namespace_, name_='reserved1')
        if self.oem_id is not None:
            self.oem_id.export(outfile, level, namespace_, name_='oem_id')
        if self.oem_info is not None:
            self.oem_info.export(outfile, level, namespace_, name_='oem_info')
        if self.reserved2 is not None:
            self.reserved2.export(outfile, level, namespace_, name_='reserved2')
        if self.e_lfanew is not None:
            self.e_lfanew.export(outfile, level, namespace_, name_='e_lfanew')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.signature is not None or
            self.lastsize is not None or
            self.nblocks is not None or
            self.nreloc is not None or
            self.hdrsize is not None or
            self.minalloc is not None or
            self.maxalloc is not None or
            self.checksum is not None or
            self.relocpos is not None or
            self.noverlay is not None or
            self.reserved1 is not None or
            self.oem_id is not None or
            self.oem_info is not None or
            self.reserved2 is not None or
            self.e_lfanew is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DOS_HeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType1(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.signature is not None:
            showIndent(outfile, level)
            outfile.write('signature=model_.xs_hexBinary(\n')
            self.signature.exportLiteral(outfile, level, name_='signature')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.lastsize is not None:
            showIndent(outfile, level)
            outfile.write('lastsize=model_.xs_hexBinary(\n')
            self.lastsize.exportLiteral(outfile, level, name_='lastsize')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nblocks is not None:
            showIndent(outfile, level)
            outfile.write('nblocks=model_.xs_hexBinary(\n')
            self.nblocks.exportLiteral(outfile, level, name_='nblocks')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nreloc is not None:
            showIndent(outfile, level)
            outfile.write('nreloc=model_.xs_hexBinary(\n')
            self.nreloc.exportLiteral(outfile, level, name_='nreloc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hdrsize is not None:
            showIndent(outfile, level)
            outfile.write('hdrsize=model_.xs_hexBinary(\n')
            self.hdrsize.exportLiteral(outfile, level, name_='hdrsize')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.minalloc is not None:
            showIndent(outfile, level)
            outfile.write('minalloc=model_.xs_hexBinary(\n')
            self.minalloc.exportLiteral(outfile, level, name_='minalloc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.maxalloc is not None:
            showIndent(outfile, level)
            outfile.write('maxalloc=model_.xs_hexBinary(\n')
            self.maxalloc.exportLiteral(outfile, level, name_='maxalloc')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.checksum is not None:
            showIndent(outfile, level)
            outfile.write('checksum=model_.xs_hexBinary(\n')
            self.checksum.exportLiteral(outfile, level, name_='checksum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.relocpos is not None:
            showIndent(outfile, level)
            outfile.write('relocpos=model_.xs_hexBinary(\n')
            self.relocpos.exportLiteral(outfile, level, name_='relocpos')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.noverlay is not None:
            showIndent(outfile, level)
            outfile.write('noverlay=model_.xs_hexBinary(\n')
            self.noverlay.exportLiteral(outfile, level, name_='noverlay')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reserved1 is not None:
            showIndent(outfile, level)
            outfile.write('reserved1=model_.xs_hexBinary(\n')
            self.reserved1.exportLiteral(outfile, level, name_='reserved1')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.oem_id is not None:
            showIndent(outfile, level)
            outfile.write('oem_id=model_.xs_hexBinary(\n')
            self.oem_id.exportLiteral(outfile, level, name_='oem_id')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.oem_info is not None:
            showIndent(outfile, level)
            outfile.write('oem_info=model_.xs_hexBinary(\n')
            self.oem_info.exportLiteral(outfile, level, name_='oem_info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reserved2 is not None:
            showIndent(outfile, level)
            outfile.write('reserved2=model_.xs_hexBinary(\n')
            self.reserved2.exportLiteral(outfile, level, name_='reserved2')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e_lfanew is not None:
            showIndent(outfile, level)
            outfile.write('e_lfanew=model_.xs_hexBinary(\n')
            self.e_lfanew.exportLiteral(outfile, level, name_='e_lfanew')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = HashesType1.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'signature':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_signature(obj_)
        elif nodeName_ == 'lastsize':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_lastsize(obj_)
        elif nodeName_ == 'nblocks':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_nblocks(obj_)
        elif nodeName_ == 'nreloc':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_nreloc(obj_)
        elif nodeName_ == 'hdrsize':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_hdrsize(obj_)
        elif nodeName_ == 'minalloc':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_minalloc(obj_)
        elif nodeName_ == 'maxalloc':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_maxalloc(obj_)
        elif nodeName_ == 'checksum':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_checksum(obj_)
        elif nodeName_ == 'relocpos':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_relocpos(obj_)
        elif nodeName_ == 'noverlay':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_noverlay(obj_)
        elif nodeName_ == 'reserved1':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_reserved1(obj_)
        elif nodeName_ == 'oem_id':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_oem_id(obj_)
        elif nodeName_ == 'oem_info':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_oem_info(obj_)
        elif nodeName_ == 'reserved2':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_reserved2(obj_)
        elif nodeName_ == 'e_lfanew':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_e_lfanew(obj_)
# end class DOS_HeaderType


class HashesType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType1.subclass:
            return HashesType1.subclass(*args_, **kwargs_)
        else:
            return HashesType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType1', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType1


class PE_HeaderType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Entropy=None, Signature=None, File_Header=None, Optional_Header=None):
        self.Hashes = Hashes
        self.Entropy = Entropy
        self.Signature = Signature
        self.File_Header = File_Header
        self.Optional_Header = Optional_Header
    def factory(*args_, **kwargs_):
        if PE_HeaderType.subclass:
            return PE_HeaderType.subclass(*args_, **kwargs_)
        else:
            return PE_HeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def get_File_Header(self): return self.File_Header
    def set_File_Header(self, File_Header): self.File_Header = File_Header
    def get_Optional_Header(self): return self.Optional_Header
    def set_Optional_Header(self, Optional_Header): self.Optional_Header = Optional_Header
    def export(self, outfile, level, namespace_='maec:', name_='PE_HeaderType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PE_HeaderType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='PE_HeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PE_HeaderType', fromsubclass_=False):
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntropy>%s</%sEntropy>\n' % (namespace_, self.gds_format_float(self.Entropy, input_name='Entropy'), namespace_))
        if self.Signature is not None:
            self.Signature.export(outfile, level, namespace_, name_='Signature')
        if self.File_Header is not None:
            self.File_Header.export(outfile, level, namespace_, name_='File_Header')
        if self.Optional_Header is not None:
            self.Optional_Header.export(outfile, level, namespace_, name_='Optional_Header')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Entropy is not None or
            self.Signature is not None or
            self.File_Header is not None or
            self.Optional_Header is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PE_HeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType2(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=%f,\n' % self.Entropy)
        if self.Signature is not None:
            showIndent(outfile, level)
            outfile.write('Signature=model_.xs_hexBinary(\n')
            self.Signature.exportLiteral(outfile, level, name_='Signature')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Header is not None:
            showIndent(outfile, level)
            outfile.write('File_Header=model_.File_HeaderType(\n')
            self.File_Header.exportLiteral(outfile, level, name_='File_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Optional_Header=model_.Optional_HeaderType(\n')
            self.Optional_Header.exportLiteral(outfile, level, name_='Optional_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = HashesType2.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Entropy':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires float or double: %s' % e)
            fval_ = self.gds_validate_float(fval_, node, 'Entropy')
            self.Entropy = fval_
        elif nodeName_ == 'Signature':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Signature(obj_)
        elif nodeName_ == 'File_Header':
            obj_ = File_HeaderType.factory()
            obj_.build(child_)
            self.set_File_Header(obj_)
        elif nodeName_ == 'Optional_Header':
            obj_ = Optional_HeaderType.factory()
            obj_.build(child_)
            self.set_Optional_Header(obj_)
# end class PE_HeaderType


class HashesType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType2.subclass:
            return HashesType2.subclass(*args_, **kwargs_)
        else:
            return HashesType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType2', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType2')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType2', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType2'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType2


class File_HeaderType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Machine=None, Number_Of_Sections=None, Time_Date_Stamp=None, Pointer_To_Symbol_Table=None, Number_Of_Symbols=None, Size_Of_Optional_Header=None, Characteristics=None):
        self.Hashes = Hashes
        self.Machine = Machine
        self.Number_Of_Sections = Number_Of_Sections
        self.Time_Date_Stamp = Time_Date_Stamp
        self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
        self.Number_Of_Symbols = Number_Of_Symbols
        self.Size_Of_Optional_Header = Size_Of_Optional_Header
        self.Characteristics = Characteristics
    def factory(*args_, **kwargs_):
        if File_HeaderType.subclass:
            return File_HeaderType.subclass(*args_, **kwargs_)
        else:
            return File_HeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Machine(self): return self.Machine
    def set_Machine(self, Machine): self.Machine = Machine
    def get_Number_Of_Sections(self): return self.Number_Of_Sections
    def set_Number_Of_Sections(self, Number_Of_Sections): self.Number_Of_Sections = Number_Of_Sections
    def get_Time_Date_Stamp(self): return self.Time_Date_Stamp
    def set_Time_Date_Stamp(self, Time_Date_Stamp): self.Time_Date_Stamp = Time_Date_Stamp
    def get_Pointer_To_Symbol_Table(self): return self.Pointer_To_Symbol_Table
    def set_Pointer_To_Symbol_Table(self, Pointer_To_Symbol_Table): self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
    def get_Number_Of_Symbols(self): return self.Number_Of_Symbols
    def set_Number_Of_Symbols(self, Number_Of_Symbols): self.Number_Of_Symbols = Number_Of_Symbols
    def get_Size_Of_Optional_Header(self): return self.Size_Of_Optional_Header
    def set_Size_Of_Optional_Header(self, Size_Of_Optional_Header): self.Size_Of_Optional_Header = Size_Of_Optional_Header
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def export(self, outfile, level, namespace_='maec:', name_='File_HeaderType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_HeaderType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='File_HeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_HeaderType', fromsubclass_=False):
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Machine is not None:
            self.Machine.export(outfile, level, namespace_, name_='Machine')
        if self.Number_Of_Sections is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Sections>%s</%sNumber_Of_Sections>\n' % (namespace_, self.gds_format_integer(self.Number_Of_Sections, input_name='Number_Of_Sections'), namespace_))
        if self.Time_Date_Stamp is not None:
            self.Time_Date_Stamp.export(outfile, level, namespace_, name_='Time_Date_Stamp')
        if self.Pointer_To_Symbol_Table is not None:
            self.Pointer_To_Symbol_Table.export(outfile, level, namespace_, name_='Pointer_To_Symbol_Table')
        if self.Number_Of_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Symbols>%s</%sNumber_Of_Symbols>\n' % (namespace_, self.gds_format_integer(self.Number_Of_Symbols, input_name='Number_Of_Symbols'), namespace_))
        if self.Size_Of_Optional_Header is not None:
            self.Size_Of_Optional_Header.export(outfile, level, namespace_, name_='Size_Of_Optional_Header')
        if self.Characteristics is not None:
            self.Characteristics.export(outfile, level, namespace_, name_='Characteristics')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Machine is not None or
            self.Number_Of_Sections is not None or
            self.Time_Date_Stamp is not None or
            self.Pointer_To_Symbol_Table is not None or
            self.Number_Of_Symbols is not None or
            self.Size_Of_Optional_Header is not None or
            self.Characteristics is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_HeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType3(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Machine is not None:
            showIndent(outfile, level)
            outfile.write('Machine=model_.xs_hexBinary(\n')
            self.Machine.exportLiteral(outfile, level, name_='Machine')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Sections is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Sections=%d,\n' % self.Number_Of_Sections)
        if self.Time_Date_Stamp is not None:
            showIndent(outfile, level)
            outfile.write('Time_Date_Stamp=model_.xs_hexBinary(\n')
            self.Time_Date_Stamp.exportLiteral(outfile, level, name_='Time_Date_Stamp')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pointer_To_Symbol_Table is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Symbol_Table=model_.xs_hexBinary(\n')
            self.Pointer_To_Symbol_Table.exportLiteral(outfile, level, name_='Pointer_To_Symbol_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Symbols=%d,\n' % self.Number_Of_Symbols)
        if self.Size_Of_Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Optional_Header=model_.xs_hexBinary(\n')
            self.Size_Of_Optional_Header.exportLiteral(outfile, level, name_='Size_Of_Optional_Header')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=model_.xs_hexBinary(\n')
            self.Characteristics.exportLiteral(outfile, level, name_='Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = HashesType3.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Machine':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Machine(obj_)
        elif nodeName_ == 'Number_Of_Sections':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Number_Of_Sections')
            self.Number_Of_Sections = ival_
        elif nodeName_ == 'Time_Date_Stamp':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Time_Date_Stamp(obj_)
        elif nodeName_ == 'Pointer_To_Symbol_Table':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Pointer_To_Symbol_Table(obj_)
        elif nodeName_ == 'Number_Of_Symbols':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Number_Of_Symbols')
            self.Number_Of_Symbols = ival_
        elif nodeName_ == 'Size_Of_Optional_Header':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Optional_Header(obj_)
        elif nodeName_ == 'Characteristics':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Characteristics(obj_)
# end class File_HeaderType


class HashesType3(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType3.subclass:
            return HashesType3.subclass(*args_, **kwargs_)
        else:
            return HashesType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType3', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType3')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType3'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType3', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType3'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType3


class Optional_HeaderType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Major_Linker_Version=None, Minor_Linker_Version=None, Size_Of_Code=None, Size_Of_Initialized_Data=None, Size_Of_Uninitialized_Data=None, Address_Of_Entry_Point=None, Base_Of_Code=None, Base_Of_Data=None, Image_Base=None, Section_Alignment=None, File_Alignment=None, Major_OS_Version=None, Minor_OS_Version=None, Major_Image_Version=None, Minor_Image_Version=None, Major_Subsystem_Version=None, Minor_Subsystem_Version=None, Reserved=None, Size_Of_Image=None, Size_Of_Headers=None, Checksum=None, Subsystem=None, DLL_Characteristics=None, Size_Of_Stack_Reserve=None, Size_Of_Stack_Commit=None, Size_Of_Heap_Reserve=None, Size_Of_Heap_Commit=None, Loader_Flags=None, Number_Of_Rva_And_Sizes=None, Data_Directory=None):
        self.Hashes = Hashes
        self.Major_Linker_Version = Major_Linker_Version
        self.Minor_Linker_Version = Minor_Linker_Version
        self.Size_Of_Code = Size_Of_Code
        self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
        self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
        self.Address_Of_Entry_Point = Address_Of_Entry_Point
        self.Base_Of_Code = Base_Of_Code
        self.Base_Of_Data = Base_Of_Data
        self.Image_Base = Image_Base
        self.Section_Alignment = Section_Alignment
        self.File_Alignment = File_Alignment
        self.Major_OS_Version = Major_OS_Version
        self.Minor_OS_Version = Minor_OS_Version
        self.Major_Image_Version = Major_Image_Version
        self.Minor_Image_Version = Minor_Image_Version
        self.Major_Subsystem_Version = Major_Subsystem_Version
        self.Minor_Subsystem_Version = Minor_Subsystem_Version
        self.Reserved = Reserved
        self.Size_Of_Image = Size_Of_Image
        self.Size_Of_Headers = Size_Of_Headers
        self.Checksum = Checksum
        self.Subsystem = Subsystem
        self.DLL_Characteristics = DLL_Characteristics
        self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
        self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
        self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
        self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
        self.Loader_Flags = Loader_Flags
        self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
        self.Data_Directory = Data_Directory
    def factory(*args_, **kwargs_):
        if Optional_HeaderType.subclass:
            return Optional_HeaderType.subclass(*args_, **kwargs_)
        else:
            return Optional_HeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Major_Linker_Version(self): return self.Major_Linker_Version
    def set_Major_Linker_Version(self, Major_Linker_Version): self.Major_Linker_Version = Major_Linker_Version
    def get_Minor_Linker_Version(self): return self.Minor_Linker_Version
    def set_Minor_Linker_Version(self, Minor_Linker_Version): self.Minor_Linker_Version = Minor_Linker_Version
    def get_Size_Of_Code(self): return self.Size_Of_Code
    def set_Size_Of_Code(self, Size_Of_Code): self.Size_Of_Code = Size_Of_Code
    def get_Size_Of_Initialized_Data(self): return self.Size_Of_Initialized_Data
    def set_Size_Of_Initialized_Data(self, Size_Of_Initialized_Data): self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
    def get_Size_Of_Uninitialized_Data(self): return self.Size_Of_Uninitialized_Data
    def set_Size_Of_Uninitialized_Data(self, Size_Of_Uninitialized_Data): self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
    def get_Address_Of_Entry_Point(self): return self.Address_Of_Entry_Point
    def set_Address_Of_Entry_Point(self, Address_Of_Entry_Point): self.Address_Of_Entry_Point = Address_Of_Entry_Point
    def get_Base_Of_Code(self): return self.Base_Of_Code
    def set_Base_Of_Code(self, Base_Of_Code): self.Base_Of_Code = Base_Of_Code
    def get_Base_Of_Data(self): return self.Base_Of_Data
    def set_Base_Of_Data(self, Base_Of_Data): self.Base_Of_Data = Base_Of_Data
    def get_Image_Base(self): return self.Image_Base
    def set_Image_Base(self, Image_Base): self.Image_Base = Image_Base
    def get_Section_Alignment(self): return self.Section_Alignment
    def set_Section_Alignment(self, Section_Alignment): self.Section_Alignment = Section_Alignment
    def get_File_Alignment(self): return self.File_Alignment
    def set_File_Alignment(self, File_Alignment): self.File_Alignment = File_Alignment
    def get_Major_OS_Version(self): return self.Major_OS_Version
    def set_Major_OS_Version(self, Major_OS_Version): self.Major_OS_Version = Major_OS_Version
    def get_Minor_OS_Version(self): return self.Minor_OS_Version
    def set_Minor_OS_Version(self, Minor_OS_Version): self.Minor_OS_Version = Minor_OS_Version
    def get_Major_Image_Version(self): return self.Major_Image_Version
    def set_Major_Image_Version(self, Major_Image_Version): self.Major_Image_Version = Major_Image_Version
    def get_Minor_Image_Version(self): return self.Minor_Image_Version
    def set_Minor_Image_Version(self, Minor_Image_Version): self.Minor_Image_Version = Minor_Image_Version
    def get_Major_Subsystem_Version(self): return self.Major_Subsystem_Version
    def set_Major_Subsystem_Version(self, Major_Subsystem_Version): self.Major_Subsystem_Version = Major_Subsystem_Version
    def get_Minor_Subsystem_Version(self): return self.Minor_Subsystem_Version
    def set_Minor_Subsystem_Version(self, Minor_Subsystem_Version): self.Minor_Subsystem_Version = Minor_Subsystem_Version
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Size_Of_Image(self): return self.Size_Of_Image
    def set_Size_Of_Image(self, Size_Of_Image): self.Size_Of_Image = Size_Of_Image
    def get_Size_Of_Headers(self): return self.Size_Of_Headers
    def set_Size_Of_Headers(self, Size_Of_Headers): self.Size_Of_Headers = Size_Of_Headers
    def get_Checksum(self): return self.Checksum
    def set_Checksum(self, Checksum): self.Checksum = Checksum
    def get_Subsystem(self): return self.Subsystem
    def set_Subsystem(self, Subsystem): self.Subsystem = Subsystem
    def get_DLL_Characteristics(self): return self.DLL_Characteristics
    def set_DLL_Characteristics(self, DLL_Characteristics): self.DLL_Characteristics = DLL_Characteristics
    def get_Size_Of_Stack_Reserve(self): return self.Size_Of_Stack_Reserve
    def set_Size_Of_Stack_Reserve(self, Size_Of_Stack_Reserve): self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
    def get_Size_Of_Stack_Commit(self): return self.Size_Of_Stack_Commit
    def set_Size_Of_Stack_Commit(self, Size_Of_Stack_Commit): self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
    def get_Size_Of_Heap_Reserve(self): return self.Size_Of_Heap_Reserve
    def set_Size_Of_Heap_Reserve(self, Size_Of_Heap_Reserve): self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
    def get_Size_Of_Heap_Commit(self): return self.Size_Of_Heap_Commit
    def set_Size_Of_Heap_Commit(self, Size_Of_Heap_Commit): self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
    def get_Loader_Flags(self): return self.Loader_Flags
    def set_Loader_Flags(self, Loader_Flags): self.Loader_Flags = Loader_Flags
    def get_Number_Of_Rva_And_Sizes(self): return self.Number_Of_Rva_And_Sizes
    def set_Number_Of_Rva_And_Sizes(self, Number_Of_Rva_And_Sizes): self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
    def get_Data_Directory(self): return self.Data_Directory
    def set_Data_Directory(self, Data_Directory): self.Data_Directory = Data_Directory
    def export(self, outfile, level, namespace_='maec:', name_='Optional_HeaderType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Optional_HeaderType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Optional_HeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Optional_HeaderType', fromsubclass_=False):
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Major_Linker_Version is not None:
            self.Major_Linker_Version.export(outfile, level, namespace_, name_='Major_Linker_Version')
        if self.Minor_Linker_Version is not None:
            self.Minor_Linker_Version.export(outfile, level, namespace_, name_='Minor_Linker_Version')
        if self.Size_Of_Code is not None:
            self.Size_Of_Code.export(outfile, level, namespace_, name_='Size_Of_Code')
        if self.Size_Of_Initialized_Data is not None:
            self.Size_Of_Initialized_Data.export(outfile, level, namespace_, name_='Size_Of_Initialized_Data')
        if self.Size_Of_Uninitialized_Data is not None:
            self.Size_Of_Uninitialized_Data.export(outfile, level, namespace_, name_='Size_Of_Uninitialized_Data')
        if self.Address_Of_Entry_Point is not None:
            self.Address_Of_Entry_Point.export(outfile, level, namespace_, name_='Address_Of_Entry_Point')
        if self.Base_Of_Code is not None:
            self.Base_Of_Code.export(outfile, level, namespace_, name_='Base_Of_Code')
        if self.Base_Of_Data is not None:
            self.Base_Of_Data.export(outfile, level, namespace_, name_='Base_Of_Data')
        if self.Image_Base is not None:
            self.Image_Base.export(outfile, level, namespace_, name_='Image_Base')
        if self.Section_Alignment is not None:
            self.Section_Alignment.export(outfile, level, namespace_, name_='Section_Alignment')
        if self.File_Alignment is not None:
            self.File_Alignment.export(outfile, level, namespace_, name_='File_Alignment')
        if self.Major_OS_Version is not None:
            self.Major_OS_Version.export(outfile, level, namespace_, name_='Major_OS_Version')
        if self.Minor_OS_Version is not None:
            self.Minor_OS_Version.export(outfile, level, namespace_, name_='Minor_OS_Version')
        if self.Major_Image_Version is not None:
            self.Major_Image_Version.export(outfile, level, namespace_, name_='Major_Image_Version')
        if self.Minor_Image_Version is not None:
            self.Minor_Image_Version.export(outfile, level, namespace_, name_='Minor_Image_Version')
        if self.Major_Subsystem_Version is not None:
            self.Major_Subsystem_Version.export(outfile, level, namespace_, name_='Major_Subsystem_Version')
        if self.Minor_Subsystem_Version is not None:
            self.Minor_Subsystem_Version.export(outfile, level, namespace_, name_='Minor_Subsystem_Version')
        if self.Reserved is not None:
            self.Reserved.export(outfile, level, namespace_, name_='Reserved')
        if self.Size_Of_Image is not None:
            self.Size_Of_Image.export(outfile, level, namespace_, name_='Size_Of_Image')
        if self.Size_Of_Headers is not None:
            self.Size_Of_Headers.export(outfile, level, namespace_, name_='Size_Of_Headers')
        if self.Checksum is not None:
            self.Checksum.export(outfile, level, namespace_, name_='Checksum')
        if self.Subsystem is not None:
            self.Subsystem.export(outfile, level, namespace_, name_='Subsystem')
        if self.DLL_Characteristics is not None:
            self.DLL_Characteristics.export(outfile, level, namespace_, name_='DLL_Characteristics')
        if self.Size_Of_Stack_Reserve is not None:
            self.Size_Of_Stack_Reserve.export(outfile, level, namespace_, name_='Size_Of_Stack_Reserve')
        if self.Size_Of_Stack_Commit is not None:
            self.Size_Of_Stack_Commit.export(outfile, level, namespace_, name_='Size_Of_Stack_Commit')
        if self.Size_Of_Heap_Reserve is not None:
            self.Size_Of_Heap_Reserve.export(outfile, level, namespace_, name_='Size_Of_Heap_Reserve')
        if self.Size_Of_Heap_Commit is not None:
            self.Size_Of_Heap_Commit.export(outfile, level, namespace_, name_='Size_Of_Heap_Commit')
        if self.Loader_Flags is not None:
            self.Loader_Flags.export(outfile, level, namespace_, name_='Loader_Flags')
        if self.Number_Of_Rva_And_Sizes is not None:
            self.Number_Of_Rva_And_Sizes.export(outfile, level, namespace_, name_='Number_Of_Rva_And_Sizes')
        if self.Data_Directory is not None:
            self.Data_Directory.export(outfile, level, namespace_, name_='Data_Directory')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Major_Linker_Version is not None or
            self.Minor_Linker_Version is not None or
            self.Size_Of_Code is not None or
            self.Size_Of_Initialized_Data is not None or
            self.Size_Of_Uninitialized_Data is not None or
            self.Address_Of_Entry_Point is not None or
            self.Base_Of_Code is not None or
            self.Base_Of_Data is not None or
            self.Image_Base is not None or
            self.Section_Alignment is not None or
            self.File_Alignment is not None or
            self.Major_OS_Version is not None or
            self.Minor_OS_Version is not None or
            self.Major_Image_Version is not None or
            self.Minor_Image_Version is not None or
            self.Major_Subsystem_Version is not None or
            self.Minor_Subsystem_Version is not None or
            self.Reserved is not None or
            self.Size_Of_Image is not None or
            self.Size_Of_Headers is not None or
            self.Checksum is not None or
            self.Subsystem is not None or
            self.DLL_Characteristics is not None or
            self.Size_Of_Stack_Reserve is not None or
            self.Size_Of_Stack_Commit is not None or
            self.Size_Of_Heap_Reserve is not None or
            self.Size_Of_Heap_Commit is not None or
            self.Loader_Flags is not None or
            self.Number_Of_Rva_And_Sizes is not None or
            self.Data_Directory is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Optional_HeaderType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.HashesType4(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Linker_Version=model_.xs_hexBinary(\n')
            self.Major_Linker_Version.exportLiteral(outfile, level, name_='Major_Linker_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Linker_Version=model_.xs_hexBinary(\n')
            self.Minor_Linker_Version.exportLiteral(outfile, level, name_='Minor_Linker_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Code=model_.xs_hexBinary(\n')
            self.Size_Of_Code.exportLiteral(outfile, level, name_='Size_Of_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Initialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Initialized_Data=model_.xs_hexBinary(\n')
            self.Size_Of_Initialized_Data.exportLiteral(outfile, level, name_='Size_Of_Initialized_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Uninitialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Uninitialized_Data=model_.xs_hexBinary(\n')
            self.Size_Of_Uninitialized_Data.exportLiteral(outfile, level, name_='Size_Of_Uninitialized_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Address_Of_Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Address_Of_Entry_Point=model_.xs_hexBinary(\n')
            self.Address_Of_Entry_Point.exportLiteral(outfile, level, name_='Address_Of_Entry_Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Code=model_.xs_hexBinary(\n')
            self.Base_Of_Code.exportLiteral(outfile, level, name_='Base_Of_Code')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Of_Data is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Data=model_.xs_hexBinary(\n')
            self.Base_Of_Data.exportLiteral(outfile, level, name_='Base_Of_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Image_Base is not None:
            showIndent(outfile, level)
            outfile.write('Image_Base=model_.xs_hexBinary(\n')
            self.Image_Base.exportLiteral(outfile, level, name_='Image_Base')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('Section_Alignment=model_.xs_hexBinary(\n')
            self.Section_Alignment.exportLiteral(outfile, level, name_='Section_Alignment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('File_Alignment=model_.xs_hexBinary(\n')
            self.File_Alignment.exportLiteral(outfile, level, name_='File_Alignment')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_OS_Version=model_.xs_hexBinary(\n')
            self.Major_OS_Version.exportLiteral(outfile, level, name_='Major_OS_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_OS_Version=model_.xs_hexBinary(\n')
            self.Minor_OS_Version.exportLiteral(outfile, level, name_='Minor_OS_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Image_Version=model_.xs_hexBinary(\n')
            self.Major_Image_Version.exportLiteral(outfile, level, name_='Major_Image_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Image_Version=model_.xs_hexBinary(\n')
            self.Minor_Image_Version.exportLiteral(outfile, level, name_='Minor_Image_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Subsystem_Version=model_.xs_hexBinary(\n')
            self.Major_Subsystem_Version.exportLiteral(outfile, level, name_='Major_Subsystem_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Minor_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Subsystem_Version=model_.xs_hexBinary(\n')
            self.Minor_Subsystem_Version.exportLiteral(outfile, level, name_='Minor_Subsystem_Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=model_.xs_hexBinary(\n')
            self.Reserved.exportLiteral(outfile, level, name_='Reserved')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Image is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Image=model_.xs_hexBinary(\n')
            self.Size_Of_Image.exportLiteral(outfile, level, name_='Size_Of_Image')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Headers is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Headers=model_.xs_hexBinary(\n')
            self.Size_Of_Headers.exportLiteral(outfile, level, name_='Size_Of_Headers')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Checksum is not None:
            showIndent(outfile, level)
            outfile.write('Checksum=model_.xs_hexBinary(\n')
            self.Checksum.exportLiteral(outfile, level, name_='Checksum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subsystem is not None:
            showIndent(outfile, level)
            outfile.write('Subsystem=model_.xs_hexBinary(\n')
            self.Subsystem.exportLiteral(outfile, level, name_='Subsystem')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DLL_Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('DLL_Characteristics=model_.xs_hexBinary(\n')
            self.DLL_Characteristics.exportLiteral(outfile, level, name_='DLL_Characteristics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Stack_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Reserve=model_.xs_hexBinary(\n')
            self.Size_Of_Stack_Reserve.exportLiteral(outfile, level, name_='Size_Of_Stack_Reserve')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Stack_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Commit=model_.xs_hexBinary(\n')
            self.Size_Of_Stack_Commit.exportLiteral(outfile, level, name_='Size_Of_Stack_Commit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Heap_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Reserve=model_.xs_hexBinary(\n')
            self.Size_Of_Heap_Reserve.exportLiteral(outfile, level, name_='Size_Of_Heap_Reserve')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Size_Of_Heap_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Commit=model_.xs_hexBinary(\n')
            self.Size_Of_Heap_Commit.exportLiteral(outfile, level, name_='Size_Of_Heap_Commit')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Loader_Flags is not None:
            showIndent(outfile, level)
            outfile.write('Loader_Flags=model_.xs_hexBinary(\n')
            self.Loader_Flags.exportLiteral(outfile, level, name_='Loader_Flags')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Number_Of_Rva_And_Sizes is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Rva_And_Sizes=model_.xs_hexBinary(\n')
            self.Number_Of_Rva_And_Sizes.exportLiteral(outfile, level, name_='Number_Of_Rva_And_Sizes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Data_Directory=model_.Data_DirectoryType(\n')
            self.Data_Directory.exportLiteral(outfile, level, name_='Data_Directory')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = HashesType4.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Major_Linker_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Major_Linker_Version(obj_)
        elif nodeName_ == 'Minor_Linker_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Minor_Linker_Version(obj_)
        elif nodeName_ == 'Size_Of_Code':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Code(obj_)
        elif nodeName_ == 'Size_Of_Initialized_Data':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Initialized_Data(obj_)
        elif nodeName_ == 'Size_Of_Uninitialized_Data':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Uninitialized_Data(obj_)
        elif nodeName_ == 'Address_Of_Entry_Point':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Address_Of_Entry_Point(obj_)
        elif nodeName_ == 'Base_Of_Code':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Base_Of_Code(obj_)
        elif nodeName_ == 'Base_Of_Data':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Base_Of_Data(obj_)
        elif nodeName_ == 'Image_Base':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Image_Base(obj_)
        elif nodeName_ == 'Section_Alignment':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Section_Alignment(obj_)
        elif nodeName_ == 'File_Alignment':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_File_Alignment(obj_)
        elif nodeName_ == 'Major_OS_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Major_OS_Version(obj_)
        elif nodeName_ == 'Minor_OS_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Minor_OS_Version(obj_)
        elif nodeName_ == 'Major_Image_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Major_Image_Version(obj_)
        elif nodeName_ == 'Minor_Image_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Minor_Image_Version(obj_)
        elif nodeName_ == 'Major_Subsystem_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Major_Subsystem_Version(obj_)
        elif nodeName_ == 'Minor_Subsystem_Version':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Minor_Subsystem_Version(obj_)
        elif nodeName_ == 'Reserved':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Reserved(obj_)
        elif nodeName_ == 'Size_Of_Image':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Image(obj_)
        elif nodeName_ == 'Size_Of_Headers':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Headers(obj_)
        elif nodeName_ == 'Checksum':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Checksum(obj_)
        elif nodeName_ == 'Subsystem':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Subsystem(obj_)
        elif nodeName_ == 'DLL_Characteristics':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_DLL_Characteristics(obj_)
        elif nodeName_ == 'Size_Of_Stack_Reserve':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Stack_Reserve(obj_)
        elif nodeName_ == 'Size_Of_Stack_Commit':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Stack_Commit(obj_)
        elif nodeName_ == 'Size_Of_Heap_Reserve':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Heap_Reserve(obj_)
        elif nodeName_ == 'Size_Of_Heap_Commit':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Size_Of_Heap_Commit(obj_)
        elif nodeName_ == 'Loader_Flags':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Loader_Flags(obj_)
        elif nodeName_ == 'Number_Of_Rva_And_Sizes':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Number_Of_Rva_And_Sizes(obj_)
        elif nodeName_ == 'Data_Directory':
            obj_ = Data_DirectoryType.factory()
            obj_.build(child_)
            self.set_Data_Directory(obj_)
# end class Optional_HeaderType


class HashesType4(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType4.subclass:
            return HashesType4.subclass(*args_, **kwargs_)
        else:
            return HashesType4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType4', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType4')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType4'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType4', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType4'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType4


class Data_DirectoryType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Export_Symbols=None, Import_Symbols=None, Resources=None, Exception=None, Security=None, Base_Relocation=None, Debug=None, Architecture=None, Copyright_String=None, Unknown=None, Thread_Local_Storage=None, Load_Configuration=None, Bound_Import=None, Import_Address_Table=None, Delay_Import=None, COM_Descriptor=None):
        self.Export_Symbols = Export_Symbols
        self.Import_Symbols = Import_Symbols
        self.Resources = Resources
        self.Exception = Exception
        self.Security = Security
        self.Base_Relocation = Base_Relocation
        self.Debug = Debug
        self.Architecture = Architecture
        self.Copyright_String = Copyright_String
        self.Unknown = Unknown
        self.Thread_Local_Storage = Thread_Local_Storage
        self.Load_Configuration = Load_Configuration
        self.Bound_Import = Bound_Import
        self.Import_Address_Table = Import_Address_Table
        self.Delay_Import = Delay_Import
        self.COM_Descriptor = COM_Descriptor
    def factory(*args_, **kwargs_):
        if Data_DirectoryType.subclass:
            return Data_DirectoryType.subclass(*args_, **kwargs_)
        else:
            return Data_DirectoryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Export_Symbols(self): return self.Export_Symbols
    def set_Export_Symbols(self, Export_Symbols): self.Export_Symbols = Export_Symbols
    def get_Import_Symbols(self): return self.Import_Symbols
    def set_Import_Symbols(self, Import_Symbols): self.Import_Symbols = Import_Symbols
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Exception(self): return self.Exception
    def set_Exception(self, Exception): self.Exception = Exception
    def get_Security(self): return self.Security
    def set_Security(self, Security): self.Security = Security
    def get_Base_Relocation(self): return self.Base_Relocation
    def set_Base_Relocation(self, Base_Relocation): self.Base_Relocation = Base_Relocation
    def get_Debug(self): return self.Debug
    def set_Debug(self, Debug): self.Debug = Debug
    def get_Architecture(self): return self.Architecture
    def set_Architecture(self, Architecture): self.Architecture = Architecture
    def get_Copyright_String(self): return self.Copyright_String
    def set_Copyright_String(self, Copyright_String): self.Copyright_String = Copyright_String
    def get_Unknown(self): return self.Unknown
    def set_Unknown(self, Unknown): self.Unknown = Unknown
    def get_Thread_Local_Storage(self): return self.Thread_Local_Storage
    def set_Thread_Local_Storage(self, Thread_Local_Storage): self.Thread_Local_Storage = Thread_Local_Storage
    def get_Load_Configuration(self): return self.Load_Configuration
    def set_Load_Configuration(self, Load_Configuration): self.Load_Configuration = Load_Configuration
    def get_Bound_Import(self): return self.Bound_Import
    def set_Bound_Import(self, Bound_Import): self.Bound_Import = Bound_Import
    def get_Import_Address_Table(self): return self.Import_Address_Table
    def set_Import_Address_Table(self, Import_Address_Table): self.Import_Address_Table = Import_Address_Table
    def get_Delay_Import(self): return self.Delay_Import
    def set_Delay_Import(self, Delay_Import): self.Delay_Import = Delay_Import
    def get_COM_Descriptor(self): return self.COM_Descriptor
    def set_COM_Descriptor(self, COM_Descriptor): self.COM_Descriptor = COM_Descriptor
    def export(self, outfile, level, namespace_='maec:', name_='Data_DirectoryType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Data_DirectoryType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Data_DirectoryType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_DirectoryType', fromsubclass_=False):
        if self.Export_Symbols is not None:
            self.Export_Symbols.export(outfile, level, namespace_, name_='Export_Symbols')
        if self.Import_Symbols is not None:
            self.Import_Symbols.export(outfile, level, namespace_, name_='Import_Symbols')
        if self.Resources is not None:
            self.Resources.export(outfile, level, namespace_, name_='Resources')
        if self.Exception is not None:
            self.Exception.export(outfile, level, namespace_, name_='Exception')
        if self.Security is not None:
            self.Security.export(outfile, level, namespace_, name_='Security')
        if self.Base_Relocation is not None:
            self.Base_Relocation.export(outfile, level, namespace_, name_='Base_Relocation')
        if self.Debug is not None:
            self.Debug.export(outfile, level, namespace_, name_='Debug')
        if self.Architecture is not None:
            self.Architecture.export(outfile, level, namespace_, name_='Architecture')
        if self.Copyright_String is not None:
            self.Copyright_String.export(outfile, level, namespace_, name_='Copyright_String')
        if self.Unknown is not None:
            self.Unknown.export(outfile, level, namespace_, name_='Unknown')
        if self.Thread_Local_Storage is not None:
            self.Thread_Local_Storage.export(outfile, level, namespace_, name_='Thread_Local_Storage')
        if self.Load_Configuration is not None:
            self.Load_Configuration.export(outfile, level, namespace_, name_='Load_Configuration')
        if self.Bound_Import is not None:
            self.Bound_Import.export(outfile, level, namespace_, name_='Bound_Import')
        if self.Import_Address_Table is not None:
            self.Import_Address_Table.export(outfile, level, namespace_, name_='Import_Address_Table')
        if self.Delay_Import is not None:
            self.Delay_Import.export(outfile, level, namespace_, name_='Delay_Import')
        if self.COM_Descriptor is not None:
            self.COM_Descriptor.export(outfile, level, namespace_, name_='COM_Descriptor')
    def hasContent_(self):
        if (
            self.Export_Symbols is not None or
            self.Import_Symbols is not None or
            self.Resources is not None or
            self.Exception is not None or
            self.Security is not None or
            self.Base_Relocation is not None or
            self.Debug is not None or
            self.Architecture is not None or
            self.Copyright_String is not None or
            self.Unknown is not None or
            self.Thread_Local_Storage is not None or
            self.Load_Configuration is not None or
            self.Bound_Import is not None or
            self.Import_Address_Table is not None or
            self.Delay_Import is not None or
            self.COM_Descriptor is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_DirectoryType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Export_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Export_Symbols=model_.PEDataDirectoryStruct(\n')
            self.Export_Symbols.exportLiteral(outfile, level, name_='Export_Symbols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Import_Symbols=model_.PEDataDirectoryStruct(\n')
            self.Import_Symbols.exportLiteral(outfile, level, name_='Import_Symbols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resources is not None:
            showIndent(outfile, level)
            outfile.write('Resources=model_.PEDataDirectoryStruct(\n')
            self.Resources.exportLiteral(outfile, level, name_='Resources')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exception is not None:
            showIndent(outfile, level)
            outfile.write('Exception=model_.PEDataDirectoryStruct(\n')
            self.Exception.exportLiteral(outfile, level, name_='Exception')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security is not None:
            showIndent(outfile, level)
            outfile.write('Security=model_.PEDataDirectoryStruct(\n')
            self.Security.exportLiteral(outfile, level, name_='Security')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Relocation is not None:
            showIndent(outfile, level)
            outfile.write('Base_Relocation=model_.PEDataDirectoryStruct(\n')
            self.Base_Relocation.exportLiteral(outfile, level, name_='Base_Relocation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Debug is not None:
            showIndent(outfile, level)
            outfile.write('Debug=model_.PEDataDirectoryStruct(\n')
            self.Debug.exportLiteral(outfile, level, name_='Debug')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Architecture is not None:
            showIndent(outfile, level)
            outfile.write('Architecture=model_.PEDataDirectoryStruct(\n')
            self.Architecture.exportLiteral(outfile, level, name_='Architecture')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Copyright_String is not None:
            showIndent(outfile, level)
            outfile.write('Copyright_String=model_.PEDataDirectoryStruct(\n')
            self.Copyright_String.exportLiteral(outfile, level, name_='Copyright_String')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Unknown is not None:
            showIndent(outfile, level)
            outfile.write('Unknown=model_.PEDataDirectoryStruct(\n')
            self.Unknown.exportLiteral(outfile, level, name_='Unknown')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Thread_Local_Storage is not None:
            showIndent(outfile, level)
            outfile.write('Thread_Local_Storage=model_.PEDataDirectoryStruct(\n')
            self.Thread_Local_Storage.exportLiteral(outfile, level, name_='Thread_Local_Storage')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Load_Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Load_Configuration=model_.PEDataDirectoryStruct(\n')
            self.Load_Configuration.exportLiteral(outfile, level, name_='Load_Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Bound_Import is not None:
            showIndent(outfile, level)
            outfile.write('Bound_Import=model_.PEDataDirectoryStruct(\n')
            self.Bound_Import.exportLiteral(outfile, level, name_='Bound_Import')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Address_Table is not None:
            showIndent(outfile, level)
            outfile.write('Import_Address_Table=model_.PEDataDirectoryStruct(\n')
            self.Import_Address_Table.exportLiteral(outfile, level, name_='Import_Address_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Delay_Import is not None:
            showIndent(outfile, level)
            outfile.write('Delay_Import=model_.PEDataDirectoryStruct(\n')
            self.Delay_Import.exportLiteral(outfile, level, name_='Delay_Import')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.COM_Descriptor is not None:
            showIndent(outfile, level)
            outfile.write('COM_Descriptor=model_.PEDataDirectoryStruct(\n')
            self.COM_Descriptor.exportLiteral(outfile, level, name_='COM_Descriptor')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Export_Symbols':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Export_Symbols(obj_)
        elif nodeName_ == 'Import_Symbols':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Import_Symbols(obj_)
        elif nodeName_ == 'Resources':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif nodeName_ == 'Exception':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Exception(obj_)
        elif nodeName_ == 'Security':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Security(obj_)
        elif nodeName_ == 'Base_Relocation':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Base_Relocation(obj_)
        elif nodeName_ == 'Debug':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Debug(obj_)
        elif nodeName_ == 'Architecture':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Architecture(obj_)
        elif nodeName_ == 'Copyright_String':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Copyright_String(obj_)
        elif nodeName_ == 'Unknown':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Unknown(obj_)
        elif nodeName_ == 'Thread_Local_Storage':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Thread_Local_Storage(obj_)
        elif nodeName_ == 'Load_Configuration':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Load_Configuration(obj_)
        elif nodeName_ == 'Bound_Import':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Bound_Import(obj_)
        elif nodeName_ == 'Import_Address_Table':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Import_Address_Table(obj_)
        elif nodeName_ == 'Delay_Import':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Delay_Import(obj_)
        elif nodeName_ == 'COM_Descriptor':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_COM_Descriptor(obj_)
# end class Data_DirectoryType


class Section_TableType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Section_Header=None):
        if Section_Header is None:
            self.Section_Header = []
        else:
            self.Section_Header = Section_Header
    def factory(*args_, **kwargs_):
        if Section_TableType.subclass:
            return Section_TableType.subclass(*args_, **kwargs_)
        else:
            return Section_TableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section_Header(self): return self.Section_Header
    def set_Section_Header(self, Section_Header): self.Section_Header = Section_Header
    def add_Section_Header(self, value): self.Section_Header.append(value)
    def insert_Section_Header(self, index, value): self.Section_Header[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Section_TableType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Section_TableType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Section_TableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Section_TableType', fromsubclass_=False):
        for Section_Header_ in self.Section_Header:
            Section_Header_.export(outfile, level, namespace_, name_='Section_Header')
    def hasContent_(self):
        if (
            self.Section_Header
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Section_TableType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Section_Header=[\n')
        level += 1
        for Section_Header_ in self.Section_Header:
            showIndent(outfile, level)
            outfile.write('model_.PESectionHeaderStruct(\n')
            Section_Header_.exportLiteral(outfile, level, name_='PESectionHeaderStruct')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Section_Header':
            obj_ = PESectionHeaderStruct.factory()
            obj_.build(child_)
            self.Section_Header.append(obj_)
# end class Section_TableType


class StringsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, String=None):
        if String is None:
            self.String = []
        else:
            self.String = String
    def factory(*args_, **kwargs_):
        if StringsType.subclass:
            return StringsType.subclass(*args_, **kwargs_)
        else:
            return StringsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String(self): return self.String
    def set_String(self, String): self.String = String
    def add_String(self, value): self.String.append(value)
    def insert_String(self, index, value): self.String[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='StringsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StringsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='StringsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='StringsType', fromsubclass_=False):
        for String_ in self.String:
            String_.export(outfile, level, namespace_, name_='String')
    def hasContent_(self):
        if (
            self.String
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StringsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('String=[\n')
        level += 1
        for String_ in self.String:
            showIndent(outfile, level)
            outfile.write('model_.PEStringType(\n')
            String_.exportLiteral(outfile, level, name_='PEStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'String':
            obj_ = PEStringType.factory()
            obj_.build(child_)
            self.String.append(obj_)
# end class StringsType


class ImportsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Import=None):
        if Import is None:
            self.Import = []
        else:
            self.Import = Import
    def factory(*args_, **kwargs_):
        if ImportsType.subclass:
            return ImportsType.subclass(*args_, **kwargs_)
        else:
            return ImportsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Import(self): return self.Import
    def set_Import(self, Import): self.Import = Import
    def add_Import(self, value): self.Import.append(value)
    def insert_Import(self, index, value): self.Import[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ImportsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImportsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImportsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImportsType', fromsubclass_=False):
        for Import_ in self.Import:
            Import_.export(outfile, level, namespace_, name_='Import')
    def hasContent_(self):
        if (
            self.Import
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImportsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Import=[\n')
        level += 1
        for Import_ in self.Import:
            showIndent(outfile, level)
            outfile.write('model_.PEImportType(\n')
            Import_.exportLiteral(outfile, level, name_='PEImportType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Import':
            obj_ = PEImportType.factory()
            obj_.build(child_)
            self.Import.append(obj_)
# end class ImportsType


class ExportsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Export=None):
        if Export is None:
            self.Export = []
        else:
            self.Export = Export
    def factory(*args_, **kwargs_):
        if ExportsType.subclass:
            return ExportsType.subclass(*args_, **kwargs_)
        else:
            return ExportsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Export(self): return self.Export
    def set_Export(self, Export): self.Export = Export
    def add_Export(self, value): self.Export.append(value)
    def insert_Export(self, index, value): self.Export[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ExportsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExportsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ExportsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ExportsType', fromsubclass_=False):
        for Export_ in self.Export:
            Export_.export(outfile, level, namespace_, name_='Export')
    def hasContent_(self):
        if (
            self.Export
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExportsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Export=[\n')
        level += 1
        for Export_ in self.Export:
            showIndent(outfile, level)
            outfile.write('model_.PEExportType(\n')
            Export_.exportLiteral(outfile, level, name_='PEExportType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Export':
            obj_ = PEExportType.factory()
            obj_.build(child_)
            self.Export.append(obj_)
# end class ExportsType


class ResourcesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if ResourcesType.subclass:
            return ResourcesType.subclass(*args_, **kwargs_)
        else:
            return ResourcesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource(self, index, value): self.Resource[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ResourcesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourcesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ResourcesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ResourcesType', fromsubclass_=False):
        for Resource_ in self.Resource:
            Resource_.export(outfile, level, namespace_, name_='Resource')
    def hasContent_(self):
        if (
            self.Resource
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ResourcesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Resource=[\n')
        level += 1
        for Resource_ in self.Resource:
            showIndent(outfile, level)
            outfile.write('model_.PEResourceType(\n')
            Resource_.exportLiteral(outfile, level, name_='PEResourceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            obj_ = PEResourceType.factory()
            obj_.build(child_)
            self.Resource.append(obj_)
# end class ResourcesType


class SectionsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Section=None):
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
    def factory(*args_, **kwargs_):
        if SectionsType.subclass:
            return SectionsType.subclass(*args_, **kwargs_)
        else:
            return SectionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section(self, index, value): self.Section[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='SectionsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SectionsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='SectionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='SectionsType', fromsubclass_=False):
        for Section_ in self.Section:
            Section_.export(outfile, level, namespace_, name_='Section')
    def hasContent_(self):
        if (
            self.Section
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SectionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.PESectionType(\n')
            Section_.exportLiteral(outfile, level, name_='PESectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Section':
            obj_ = PESectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
# end class SectionsType


class Digital_CertificatesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Certificate=None):
        if Certificate is None:
            self.Certificate = []
        else:
            self.Certificate = Certificate
    def factory(*args_, **kwargs_):
        if Digital_CertificatesType.subclass:
            return Digital_CertificatesType.subclass(*args_, **kwargs_)
        else:
            return Digital_CertificatesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Certificate(self): return self.Certificate
    def set_Certificate(self, Certificate): self.Certificate = Certificate
    def add_Certificate(self, value): self.Certificate.append(value)
    def insert_Certificate(self, index, value): self.Certificate[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Digital_CertificatesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Digital_CertificatesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Digital_CertificatesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Digital_CertificatesType', fromsubclass_=False):
        for Certificate_ in self.Certificate:
            Certificate_.export(outfile, level, namespace_, name_='Certificate')
    def hasContent_(self):
        if (
            self.Certificate
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Digital_CertificatesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Certificate=[\n')
        level += 1
        for Certificate_ in self.Certificate:
            showIndent(outfile, level)
            outfile.write('model_.CertificateType(\n')
            Certificate_.exportLiteral(outfile, level, name_='CertificateType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Certificate':
            obj_ = CertificateType.factory()
            obj_.build(child_)
            self.Certificate.append(obj_)
# end class Digital_CertificatesType


class CertificateType(GeneratedsSuper):
    """This boolean attribute represents whether the digital certificate is
    valid or not."""
    subclass = None
    superclass = None
    def __init__(self, validity=None, Issuer=None):
        self.validity = _cast(bool, validity)
        self.Issuer = Issuer
    def factory(*args_, **kwargs_):
        if CertificateType.subclass:
            return CertificateType.subclass(*args_, **kwargs_)
        else:
            return CertificateType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Issuer(self): return self.Issuer
    def set_Issuer(self, Issuer): self.Issuer = Issuer
    def get_validity(self): return self.validity
    def set_validity(self, validity): self.validity = validity
    def export(self, outfile, level, namespace_='maec:', name_='CertificateType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CertificateType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='CertificateType'):
        if self.validity is not None and 'validity' not in already_processed:
            already_processed.append('validity')
            outfile.write(' validity="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.validity)), input_name='validity'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CertificateType', fromsubclass_=False):
        if self.Issuer is not None:
            showIndent(outfile, level)
            outfile.write('<%sIssuer>%s</%sIssuer>\n' % (namespace_, self.gds_format_string(quote_xml(self.Issuer).encode(ExternalEncoding), input_name='Issuer'), namespace_))
    def hasContent_(self):
        if (
            self.Issuer is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CertificateType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.validity is not None and 'validity' not in already_processed:
            already_processed.append('validity')
            showIndent(outfile, level)
            outfile.write('validity = %s,\n' % (self.validity,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Issuer is not None:
            showIndent(outfile, level)
            outfile.write('Issuer=%s,\n' % quote_python(self.Issuer).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('validity', node)
        if value is not None and 'validity' not in already_processed:
            already_processed.append('validity')
            if value in ('true', '1'):
                self.validity = True
            elif value in ('false', '0'):
                self.validity = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Issuer':
            Issuer_ = child_.text
            Issuer_ = self.gds_validate_string(Issuer_, node, 'Issuer')
            self.Issuer = Issuer_
# end class CertificateType


class GUI_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Width=None, Height=None, Window_Display_Name=None, Parent_Window=None, Owner_Window=None, Box_Text=None, Box_Caption=None):
        self.Width = Width
        self.Height = Height
        self.Window_Display_Name = Window_Display_Name
        self.Parent_Window = Parent_Window
        self.Owner_Window = Owner_Window
        self.Box_Text = Box_Text
        self.Box_Caption = Box_Caption
    def factory(*args_, **kwargs_):
        if GUI_Object_AttributesType.subclass:
            return GUI_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return GUI_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Width(self): return self.Width
    def set_Width(self, Width): self.Width = Width
    def get_Height(self): return self.Height
    def set_Height(self, Height): self.Height = Height
    def get_Window_Display_Name(self): return self.Window_Display_Name
    def set_Window_Display_Name(self, Window_Display_Name): self.Window_Display_Name = Window_Display_Name
    def get_Parent_Window(self): return self.Parent_Window
    def set_Parent_Window(self, Parent_Window): self.Parent_Window = Parent_Window
    def get_Owner_Window(self): return self.Owner_Window
    def set_Owner_Window(self, Owner_Window): self.Owner_Window = Owner_Window
    def get_Box_Text(self): return self.Box_Text
    def set_Box_Text(self, Box_Text): self.Box_Text = Box_Text
    def get_Box_Caption(self): return self.Box_Caption
    def set_Box_Caption(self, Box_Caption): self.Box_Caption = Box_Caption
    def export(self, outfile, level, namespace_='maec:', name_='GUI_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GUI_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='GUI_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='GUI_Object_AttributesType', fromsubclass_=False):
        if self.Width is not None:
            showIndent(outfile, level)
            outfile.write('<%sWidth>%s</%sWidth>\n' % (namespace_, self.gds_format_integer(self.Width, input_name='Width'), namespace_))
        if self.Height is not None:
            showIndent(outfile, level)
            outfile.write('<%sHeight>%s</%sHeight>\n' % (namespace_, self.gds_format_integer(self.Height, input_name='Height'), namespace_))
        if self.Window_Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sWindow_Display_Name>%s</%sWindow_Display_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Window_Display_Name).encode(ExternalEncoding), input_name='Window_Display_Name'), namespace_))
        if self.Parent_Window is not None:
            showIndent(outfile, level)
            outfile.write('<%sParent_Window>%s</%sParent_Window>\n' % (namespace_, self.gds_format_string(quote_xml(self.Parent_Window).encode(ExternalEncoding), input_name='Parent_Window'), namespace_))
        if self.Owner_Window is not None:
            showIndent(outfile, level)
            outfile.write('<%sOwner_Window>%s</%sOwner_Window>\n' % (namespace_, self.gds_format_string(quote_xml(self.Owner_Window).encode(ExternalEncoding), input_name='Owner_Window'), namespace_))
        if self.Box_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sBox_Text>%s</%sBox_Text>\n' % (namespace_, self.gds_format_string(quote_xml(self.Box_Text).encode(ExternalEncoding), input_name='Box_Text'), namespace_))
        if self.Box_Caption is not None:
            showIndent(outfile, level)
            outfile.write('<%sBox_Caption>%s</%sBox_Caption>\n' % (namespace_, self.gds_format_string(quote_xml(self.Box_Caption).encode(ExternalEncoding), input_name='Box_Caption'), namespace_))
    def hasContent_(self):
        if (
            self.Width is not None or
            self.Height is not None or
            self.Window_Display_Name is not None or
            self.Parent_Window is not None or
            self.Owner_Window is not None or
            self.Box_Text is not None or
            self.Box_Caption is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GUI_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Width is not None:
            showIndent(outfile, level)
            outfile.write('Width=%d,\n' % self.Width)
        if self.Height is not None:
            showIndent(outfile, level)
            outfile.write('Height=%d,\n' % self.Height)
        if self.Window_Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('Window_Display_Name=%s,\n' % quote_python(self.Window_Display_Name).encode(ExternalEncoding))
        if self.Parent_Window is not None:
            showIndent(outfile, level)
            outfile.write('Parent_Window=%s,\n' % quote_python(self.Parent_Window).encode(ExternalEncoding))
        if self.Owner_Window is not None:
            showIndent(outfile, level)
            outfile.write('Owner_Window=%s,\n' % quote_python(self.Owner_Window).encode(ExternalEncoding))
        if self.Box_Text is not None:
            showIndent(outfile, level)
            outfile.write('Box_Text=%s,\n' % quote_python(self.Box_Text).encode(ExternalEncoding))
        if self.Box_Caption is not None:
            showIndent(outfile, level)
            outfile.write('Box_Caption=%s,\n' % quote_python(self.Box_Caption).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Width':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Width')
            self.Width = ival_
        elif nodeName_ == 'Height':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Height')
            self.Height = ival_
        elif nodeName_ == 'Window_Display_Name':
            Window_Display_Name_ = child_.text
            Window_Display_Name_ = self.gds_validate_string(Window_Display_Name_, node, 'Window_Display_Name')
            self.Window_Display_Name = Window_Display_Name_
        elif nodeName_ == 'Parent_Window':
            Parent_Window_ = child_.text
            Parent_Window_ = self.gds_validate_string(Parent_Window_, node, 'Parent_Window')
            self.Parent_Window = Parent_Window_
        elif nodeName_ == 'Owner_Window':
            Owner_Window_ = child_.text
            Owner_Window_ = self.gds_validate_string(Owner_Window_, node, 'Owner_Window')
            self.Owner_Window = Owner_Window_
        elif nodeName_ == 'Box_Text':
            Box_Text_ = child_.text
            Box_Text_ = self.gds_validate_string(Box_Text_, node, 'Box_Text')
            self.Box_Text = Box_Text_
        elif nodeName_ == 'Box_Caption':
            Box_Caption_ = child_.text
            Box_Caption_ = self.gds_validate_string(Box_Caption_, node, 'Box_Caption')
            self.Box_Caption = Box_Caption_
# end class GUI_Object_AttributesType


class IPC_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Security_Attributes=None, Event_Type=None, Thread_ID=None, Start_Address=None):
        self.Security_Attributes = Security_Attributes
        self.Event_Type = Event_Type
        self.Thread_ID = Thread_ID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if IPC_Object_AttributesType.subclass:
            return IPC_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return IPC_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Event_Type(self): return self.Event_Type
    def set_Event_Type(self, Event_Type): self.Event_Type = Event_Type
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='IPC_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPC_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='IPC_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPC_Object_AttributesType', fromsubclass_=False):
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.gds_format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Event_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sEvent_Type>%s</%sEvent_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Event_Type).encode(ExternalEncoding), input_name='Event_Type'), namespace_))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.gds_format_integer(self.Thread_ID, input_name='Thread_ID'), namespace_))
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
    def hasContent_(self):
        if (
            self.Security_Attributes is not None or
            self.Event_Type is not None or
            self.Thread_ID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPC_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Event_Type is not None:
            showIndent(outfile, level)
            outfile.write('Event_Type=%s,\n' % quote_python(self.Event_Type).encode(ExternalEncoding))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%d,\n' % self.Thread_ID)
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Security_Attributes':
            Security_Attributes_ = child_.text
            Security_Attributes_ = self.gds_validate_string(Security_Attributes_, node, 'Security_Attributes')
            self.Security_Attributes = Security_Attributes_
        elif nodeName_ == 'Event_Type':
            Event_Type_ = child_.text
            Event_Type_ = self.gds_validate_string(Event_Type_, node, 'Event_Type')
            self.Event_Type = Event_Type_
        elif nodeName_ == 'Thread_ID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Thread_ID')
            self.Thread_ID = ival_
        elif nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
# end class IPC_Object_AttributesType


class Event_Type(GeneratedsSuper):
    """The Event_Type field contains the event type of an IPC event object.
    Possible values: Manual_Reset, Auto_Reset."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Event_Type.subclass:
            return Event_Type.subclass(*args_, **kwargs_)
        else:
            return Event_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Event_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Event_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Event_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Event_Type', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Event_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Event_Type


class Internet_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URI=None, AS_Number=None):
        self.URI = URI
        self.AS_Number = AS_Number
    def factory(*args_, **kwargs_):
        if Internet_Object_AttributesType.subclass:
            return Internet_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Internet_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def get_AS_Number(self): return self.AS_Number
    def set_AS_Number(self, AS_Number): self.AS_Number = AS_Number
    def export(self, outfile, level, namespace_='maec:', name_='Internet_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Internet_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Internet_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Internet_Object_AttributesType', fromsubclass_=False):
        if self.URI is not None:
            self.URI.export(outfile, level, namespace_, name_='URI')
        if self.AS_Number is not None:
            showIndent(outfile, level)
            outfile.write('<%sAS_Number>%s</%sAS_Number>\n' % (namespace_, self.gds_format_integer(self.AS_Number, input_name='AS_Number'), namespace_))
    def hasContent_(self):
        if (
            self.URI is not None or
            self.AS_Number is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Internet_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=model_.uriObject(\n')
            self.URI.exportLiteral(outfile, level, name_='URI')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AS_Number is not None:
            showIndent(outfile, level)
            outfile.write('AS_Number=%d,\n' % self.AS_Number)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'URI':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.set_URI(obj_)
        elif nodeName_ == 'AS_Number':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'AS_Number')
            self.AS_Number = ival_
# end class Internet_Object_AttributesType


class Module_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Library_Type=None, Library_File_Name=None, Version=None):
        self.Library_Type = Library_Type
        self.Library_File_Name = Library_File_Name
        self.Version = Version
    def factory(*args_, **kwargs_):
        if Module_Object_AttributesType.subclass:
            return Module_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Module_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Library_Type(self): return self.Library_Type
    def set_Library_Type(self, Library_Type): self.Library_Type = Library_Type
    def get_Library_File_Name(self): return self.Library_File_Name
    def set_Library_File_Name(self, Library_File_Name): self.Library_File_Name = Library_File_Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def export(self, outfile, level, namespace_='maec:', name_='Module_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Module_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Module_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Module_Object_AttributesType', fromsubclass_=False):
        if self.Library_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sLibrary_Type>%s</%sLibrary_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Library_Type).encode(ExternalEncoding), input_name='Library_Type'), namespace_))
        if self.Library_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sLibrary_File_Name>%s</%sLibrary_File_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Library_File_Name).encode(ExternalEncoding), input_name='Library_File_Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.gds_format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
    def hasContent_(self):
        if (
            self.Library_Type is not None or
            self.Library_File_Name is not None or
            self.Version is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Module_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Library_Type is not None:
            showIndent(outfile, level)
            outfile.write('Library_Type=%s,\n' % quote_python(self.Library_Type).encode(ExternalEncoding))
        if self.Library_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Library_File_Name=%s,\n' % quote_python(self.Library_File_Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Library_Type':
            Library_Type_ = child_.text
            Library_Type_ = self.gds_validate_string(Library_Type_, node, 'Library_Type')
            self.Library_Type = Library_Type_
        elif nodeName_ == 'Library_File_Name':
            Library_File_Name_ = child_.text
            Library_File_Name_ = self.gds_validate_string(Library_File_Name_, node, 'Library_File_Name')
            self.Library_File_Name = Library_File_Name_
        elif nodeName_ == 'Version':
            Version_ = child_.text
            Version_ = self.gds_validate_string(Version_, node, 'Version')
            self.Version = Version_
# end class Module_Object_AttributesType


class Library_Type(GeneratedsSuper):
    """The Library_Type field contains the type of library object that is
    being characterized. Possible values: Static, Dynamic, Shared,
    Remote, Other."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Library_Type.subclass:
            return Library_Type.subclass(*args_, **kwargs_)
        else:
            return Library_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Library_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Library_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Library_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Library_Type', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Library_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Library_Type


class Registry_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hive=None, Key=None, Value=None):
        self.Hive = Hive
        self.Key = Key
        self.Value = Value
    def factory(*args_, **kwargs_):
        if Registry_Object_AttributesType.subclass:
            return Registry_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Registry_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hive(self): return self.Hive
    def set_Hive(self, Hive): self.Hive = Hive
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='maec:', name_='Registry_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Registry_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Registry_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Registry_Object_AttributesType', fromsubclass_=False):
        if self.Hive is not None:
            showIndent(outfile, level)
            outfile.write('<%sHive>%s</%sHive>\n' % (namespace_, self.gds_format_string(quote_xml(self.Hive).encode(ExternalEncoding), input_name='Hive'), namespace_))
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('<%sKey>%s</%sKey>\n' % (namespace_, self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_))
        if self.Value is not None:
            self.Value.export(outfile, level, namespace_, name_='Value')
    def hasContent_(self):
        if (
            self.Hive is not None or
            self.Key is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Registry_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hive is not None:
            showIndent(outfile, level)
            outfile.write('Hive=%s,\n' % quote_python(self.Hive).encode(ExternalEncoding))
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.ValueType(\n')
            self.Value.exportLiteral(outfile, level, name_='Value')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hive':
            Hive_ = child_.text
            Hive_ = self.gds_validate_string(Hive_, node, 'Hive')
            self.Hive = Hive_
        elif nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Value':
            obj_ = ValueType.factory()
            obj_.build(child_)
            self.set_Value(obj_)
# end class Registry_Object_AttributesType


class ValueType(GeneratedsSuper):
    """This field refers to the data type of the registry value being
    characterized in this element. Possible values: REG_NONE,
    REG_SZ, REG_EXPAND, REG_BINARY, REG_DWORD,
    REG_DWORD_LITTLE_ENDIAN, REG_DWORD_BIG_ENDIAN, REG_LINK,
    REG_MULTI_SZ, REG_RESOURCE_LIST, REG_FULL_RESOURCE_DESCRIPTOR,
    REG_RESOURCE_REQUIREMENTS_LIST, REG_QWORD,
    REG_QWORD_LITTLE_ENDIAN."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, Value_Name=None, Value_Data=None):
        self.type_ = _cast(None, type_)
        self.Value_Name = Value_Name
        self.Value_Data = Value_Data
    def factory(*args_, **kwargs_):
        if ValueType.subclass:
            return ValueType.subclass(*args_, **kwargs_)
        else:
            return ValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value_Name(self): return self.Value_Name
    def set_Value_Name(self, Value_Name): self.Value_Name = Value_Name
    def get_Value_Data(self): return self.Value_Data
    def set_Value_Data(self, Value_Data): self.Value_Data = Value_Data
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='ValueType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ValueType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ValueType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ValueType', fromsubclass_=False):
        if self.Value_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue_Name>%s</%sValue_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Value_Name).encode(ExternalEncoding), input_name='Value_Name'), namespace_))
        if self.Value_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue_Data>%s</%sValue_Data>\n' % (namespace_, self.gds_format_string(quote_xml(self.Value_Data).encode(ExternalEncoding), input_name='Value_Data'), namespace_))
    def hasContent_(self):
        if (
            self.Value_Name is not None or
            self.Value_Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ValueType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Value_Name is not None:
            showIndent(outfile, level)
            outfile.write('Value_Name=%s,\n' % quote_python(self.Value_Name).encode(ExternalEncoding))
        if self.Value_Data is not None:
            showIndent(outfile, level)
            outfile.write('Value_Data=%s,\n' % quote_python(self.Value_Data).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value_Name':
            Value_Name_ = child_.text
            Value_Name_ = self.gds_validate_string(Value_Name_, node, 'Value_Name')
            self.Value_Name = Value_Name_
        elif nodeName_ == 'Value_Data':
            Value_Data_ = child_.text
            Value_Data_ = self.gds_validate_string(Value_Data_, node, 'Value_Data')
            self.Value_Data = Value_Data_
# end class ValueType


class Process_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Name=None, Start_Username=None, Current_Directory=None, Command_Line=None, Security_Attributes=None, Process_ID=None, Start_Address=None, Parent_Process=None, Start_DateTime=None, Child_Processes=None, Handles=None):
        self.Image_Name = Image_Name
        self.Start_Username = Start_Username
        self.Current_Directory = Current_Directory
        self.Command_Line = Command_Line
        self.Security_Attributes = Security_Attributes
        self.Process_ID = Process_ID
        self.Start_Address = Start_Address
        self.Parent_Process = Parent_Process
        self.Start_DateTime = Start_DateTime
        self.Child_Processes = Child_Processes
        self.Handles = Handles
    def factory(*args_, **kwargs_):
        if Process_Object_AttributesType.subclass:
            return Process_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Process_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Name(self): return self.Image_Name
    def set_Image_Name(self, Image_Name): self.Image_Name = Image_Name
    def get_Start_Username(self): return self.Start_Username
    def set_Start_Username(self, Start_Username): self.Start_Username = Start_Username
    def get_Current_Directory(self): return self.Current_Directory
    def set_Current_Directory(self, Current_Directory): self.Current_Directory = Current_Directory
    def get_Command_Line(self): return self.Command_Line
    def set_Command_Line(self, Command_Line): self.Command_Line = Command_Line
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Process_ID(self): return self.Process_ID
    def set_Process_ID(self, Process_ID): self.Process_ID = Process_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Parent_Process(self): return self.Parent_Process
    def set_Parent_Process(self, Parent_Process): self.Parent_Process = Parent_Process
    def get_Start_DateTime(self): return self.Start_DateTime
    def set_Start_DateTime(self, Start_DateTime): self.Start_DateTime = Start_DateTime
    def get_Child_Processes(self): return self.Child_Processes
    def set_Child_Processes(self, Child_Processes): self.Child_Processes = Child_Processes
    def get_Handles(self): return self.Handles
    def set_Handles(self, Handles): self.Handles = Handles
    def export(self, outfile, level, namespace_='maec:', name_='Process_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Process_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Process_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Process_Object_AttributesType', fromsubclass_=False):
        if self.Image_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Name>%s</%sImage_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Name).encode(ExternalEncoding), input_name='Image_Name'), namespace_))
        if self.Start_Username is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Username>%s</%sStart_Username>\n' % (namespace_, self.gds_format_string(quote_xml(self.Start_Username).encode(ExternalEncoding), input_name='Start_Username'), namespace_))
        if self.Current_Directory is not None:
            showIndent(outfile, level)
            outfile.write('<%sCurrent_Directory>%s</%sCurrent_Directory>\n' % (namespace_, self.gds_format_string(quote_xml(self.Current_Directory).encode(ExternalEncoding), input_name='Current_Directory'), namespace_))
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('<%sCommand_Line>%s</%sCommand_Line>\n' % (namespace_, self.gds_format_string(quote_xml(self.Command_Line).encode(ExternalEncoding), input_name='Command_Line'), namespace_))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.gds_format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Process_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sProcess_ID>%s</%sProcess_ID>\n' % (namespace_, self.gds_format_string(quote_xml(self.Process_ID).encode(ExternalEncoding), input_name='Process_ID'), namespace_))
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
        if self.Parent_Process is not None:
            self.Parent_Process.export(outfile, level, namespace_, name_='Parent_Process')
        if self.Start_DateTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_DateTime>%s</%sStart_DateTime>\n' % (namespace_, self.gds_format_string(quote_xml(self.Start_DateTime).encode(ExternalEncoding), input_name='Start_DateTime'), namespace_))
        if self.Child_Processes is not None:
            self.Child_Processes.export(outfile, level, namespace_, name_='Child_Processes')
        if self.Handles is not None:
            self.Handles.export(outfile, level, namespace_, name_='Handles')
    def hasContent_(self):
        if (
            self.Image_Name is not None or
            self.Start_Username is not None or
            self.Current_Directory is not None or
            self.Command_Line is not None or
            self.Security_Attributes is not None or
            self.Process_ID is not None or
            self.Start_Address is not None or
            self.Parent_Process is not None or
            self.Start_DateTime is not None or
            self.Child_Processes is not None or
            self.Handles is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Process_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Name is not None:
            showIndent(outfile, level)
            outfile.write('Image_Name=%s,\n' % quote_python(self.Image_Name).encode(ExternalEncoding))
        if self.Start_Username is not None:
            showIndent(outfile, level)
            outfile.write('Start_Username=%s,\n' % quote_python(self.Start_Username).encode(ExternalEncoding))
        if self.Current_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Current_Directory=%s,\n' % quote_python(self.Current_Directory).encode(ExternalEncoding))
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('Command_Line=%s,\n' % quote_python(self.Command_Line).encode(ExternalEncoding))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Process_ID is not None:
            showIndent(outfile, level)
            outfile.write('Process_ID=%s,\n' % quote_python(self.Process_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Parent_Process is not None:
            showIndent(outfile, level)
            outfile.write('Parent_Process=model_.ObjectReferenceType(\n')
            self.Parent_Process.exportLiteral(outfile, level, name_='Parent_Process')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Start_DateTime is not None:
            showIndent(outfile, level)
            outfile.write('Start_DateTime=%s,\n' % quote_python(self.Start_DateTime).encode(ExternalEncoding))
        if self.Child_Processes is not None:
            showIndent(outfile, level)
            outfile.write('Child_Processes=model_.Child_ProcessesType(\n')
            self.Child_Processes.exportLiteral(outfile, level, name_='Child_Processes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Handles is not None:
            showIndent(outfile, level)
            outfile.write('Handles=model_.HandlesType(\n')
            self.Handles.exportLiteral(outfile, level, name_='Handles')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image_Name':
            Image_Name_ = child_.text
            Image_Name_ = self.gds_validate_string(Image_Name_, node, 'Image_Name')
            self.Image_Name = Image_Name_
        elif nodeName_ == 'Start_Username':
            Start_Username_ = child_.text
            Start_Username_ = self.gds_validate_string(Start_Username_, node, 'Start_Username')
            self.Start_Username = Start_Username_
        elif nodeName_ == 'Current_Directory':
            Current_Directory_ = child_.text
            Current_Directory_ = self.gds_validate_string(Current_Directory_, node, 'Current_Directory')
            self.Current_Directory = Current_Directory_
        elif nodeName_ == 'Command_Line':
            Command_Line_ = child_.text
            Command_Line_ = self.gds_validate_string(Command_Line_, node, 'Command_Line')
            self.Command_Line = Command_Line_
        elif nodeName_ == 'Security_Attributes':
            Security_Attributes_ = child_.text
            Security_Attributes_ = self.gds_validate_string(Security_Attributes_, node, 'Security_Attributes')
            self.Security_Attributes = Security_Attributes_
        elif nodeName_ == 'Process_ID':
            Process_ID_ = child_.text
            Process_ID_ = self.gds_validate_string(Process_ID_, node, 'Process_ID')
            self.Process_ID = Process_ID_
        elif nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
        elif nodeName_ == 'Parent_Process':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Parent_Process(obj_)
        elif nodeName_ == 'Start_DateTime':
            Start_DateTime_ = child_.text
            Start_DateTime_ = self.gds_validate_string(Start_DateTime_, node, 'Start_DateTime')
            self.Start_DateTime = Start_DateTime_
        elif nodeName_ == 'Child_Processes':
            obj_ = Child_ProcessesType.factory()
            obj_.build(child_)
            self.set_Child_Processes(obj_)
        elif nodeName_ == 'Handles':
            obj_ = HandlesType.factory()
            obj_.build(child_)
            self.set_Handles(obj_)
# end class Process_Object_AttributesType


class Child_ProcessesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Child_Process=None):
        if Child_Process is None:
            self.Child_Process = []
        else:
            self.Child_Process = Child_Process
    def factory(*args_, **kwargs_):
        if Child_ProcessesType.subclass:
            return Child_ProcessesType.subclass(*args_, **kwargs_)
        else:
            return Child_ProcessesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Child_Process(self): return self.Child_Process
    def set_Child_Process(self, Child_Process): self.Child_Process = Child_Process
    def add_Child_Process(self, value): self.Child_Process.append(value)
    def insert_Child_Process(self, index, value): self.Child_Process[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Child_ProcessesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Child_ProcessesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Child_ProcessesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Child_ProcessesType', fromsubclass_=False):
        for Child_Process_ in self.Child_Process:
            Child_Process_.export(outfile, level, namespace_, name_='Child_Process')
    def hasContent_(self):
        if (
            self.Child_Process
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Child_ProcessesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Child_Process=[\n')
        level += 1
        for Child_Process_ in self.Child_Process:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Child_Process_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Child_Process':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Child_Process.append(obj_)
# end class Child_ProcessesType


class HandlesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Handle=None):
        if Handle is None:
            self.Handle = []
        else:
            self.Handle = Handle
    def factory(*args_, **kwargs_):
        if HandlesType.subclass:
            return HandlesType.subclass(*args_, **kwargs_)
        else:
            return HandlesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Handle(self): return self.Handle
    def set_Handle(self, Handle): self.Handle = Handle
    def add_Handle(self, value): self.Handle.append(value)
    def insert_Handle(self, index, value): self.Handle[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HandlesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HandlesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HandlesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HandlesType', fromsubclass_=False):
        for Handle_ in self.Handle:
            Handle_.export(outfile, level, namespace_, name_='Handle')
    def hasContent_(self):
        if (
            self.Handle
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HandlesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Handle=[\n')
        level += 1
        for Handle_ in self.Handle:
            showIndent(outfile, level)
            outfile.write('model_.HandleType(\n')
            Handle_.exportLiteral(outfile, level, name_='HandleType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Handle':
            obj_ = HandleType.factory()
            obj_.build(child_)
            self.Handle.append(obj_)
# end class HandlesType


class HandleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None):
        self.Name = Name
    def factory(*args_, **kwargs_):
        if HandleType.subclass:
            return HandleType.subclass(*args_, **kwargs_)
        else:
            return HandleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='maec:', name_='HandleType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HandleType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HandleType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HandleType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_integer(self.Name, input_name='Name'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HandleType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%d,\n' % self.Name)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Name')
            self.Name = ival_
# end class HandleType


class Memory_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Memory_Block_ID=None, Start_Address=None):
        self.Memory_Block_ID = Memory_Block_ID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if Memory_Object_AttributesType.subclass:
            return Memory_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Memory_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Memory_Block_ID(self): return self.Memory_Block_ID
    def set_Memory_Block_ID(self, Memory_Block_ID): self.Memory_Block_ID = Memory_Block_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='Memory_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Memory_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Memory_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Memory_Object_AttributesType', fromsubclass_=False):
        if self.Memory_Block_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sMemory_Block_ID>%s</%sMemory_Block_ID>\n' % (namespace_, self.gds_format_string(quote_xml(self.Memory_Block_ID).encode(ExternalEncoding), input_name='Memory_Block_ID'), namespace_))
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
    def hasContent_(self):
        if (
            self.Memory_Block_ID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Memory_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Memory_Block_ID is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Block_ID=%s,\n' % quote_python(self.Memory_Block_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Memory_Block_ID':
            Memory_Block_ID_ = child_.text
            Memory_Block_ID_ = self.gds_validate_string(Memory_Block_ID_, node, 'Memory_Block_ID')
            self.Memory_Block_ID = Memory_Block_ID_
        elif nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
# end class Memory_Object_AttributesType


class Network_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Port=None, External_Port=None, Socket_Type=None, Socket_ID=None, Internal_IP_Address=None, External_IP_Address=None, IP_Protocol=None, Application_Layer_Protocol=None):
        self.Internal_Port = Internal_Port
        self.External_Port = External_Port
        self.Socket_Type = Socket_Type
        self.Socket_ID = Socket_ID
        self.Internal_IP_Address = Internal_IP_Address
        self.External_IP_Address = External_IP_Address
        self.IP_Protocol = IP_Protocol
        self.Application_Layer_Protocol = Application_Layer_Protocol
    def factory(*args_, **kwargs_):
        if Network_Object_AttributesType.subclass:
            return Network_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Network_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Port(self): return self.Internal_Port
    def set_Internal_Port(self, Internal_Port): self.Internal_Port = Internal_Port
    def get_External_Port(self): return self.External_Port
    def set_External_Port(self, External_Port): self.External_Port = External_Port
    def get_Socket_Type(self): return self.Socket_Type
    def set_Socket_Type(self, Socket_Type): self.Socket_Type = Socket_Type
    def get_Socket_ID(self): return self.Socket_ID
    def set_Socket_ID(self, Socket_ID): self.Socket_ID = Socket_ID
    def get_Internal_IP_Address(self): return self.Internal_IP_Address
    def set_Internal_IP_Address(self, Internal_IP_Address): self.Internal_IP_Address = Internal_IP_Address
    def get_External_IP_Address(self): return self.External_IP_Address
    def set_External_IP_Address(self, External_IP_Address): self.External_IP_Address = External_IP_Address
    def get_IP_Protocol(self): return self.IP_Protocol
    def set_IP_Protocol(self, IP_Protocol): self.IP_Protocol = IP_Protocol
    def validate_IPTypeEnum(self, value):
        # Validate type IPTypeEnum, a restriction on xs:string.
        pass
    def get_Application_Layer_Protocol(self): return self.Application_Layer_Protocol
    def set_Application_Layer_Protocol(self, Application_Layer_Protocol): self.Application_Layer_Protocol = Application_Layer_Protocol
    def validate_ApplicationProtocolEnum(self, value):
        # Validate type ApplicationProtocolEnum, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Network_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Network_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Network_Object_AttributesType', fromsubclass_=False):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Port>%s</%sInternal_Port>\n' % (namespace_, self.gds_format_integer(self.Internal_Port, input_name='Internal_Port'), namespace_))
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_Port>%s</%sExternal_Port>\n' % (namespace_, self.gds_format_integer(self.External_Port, input_name='External_Port'), namespace_))
        if self.Socket_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sSocket_Type>%s</%sSocket_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Socket_Type).encode(ExternalEncoding), input_name='Socket_Type'), namespace_))
        if self.Socket_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sSocket_ID>%s</%sSocket_ID>\n' % (namespace_, self.gds_format_integer(self.Socket_ID, input_name='Socket_ID'), namespace_))
        if self.Internal_IP_Address is not None:
            self.Internal_IP_Address.export(outfile, level, namespace_, name_='Internal_IP_Address')
        if self.External_IP_Address is not None:
            self.External_IP_Address.export(outfile, level, namespace_, name_='External_IP_Address')
        if self.IP_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sIP_Protocol>%s</%sIP_Protocol>\n' % (namespace_, self.gds_format_string(quote_xml(self.IP_Protocol).encode(ExternalEncoding), input_name='IP_Protocol'), namespace_))
        if self.Application_Layer_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sApplication_Layer_Protocol>%s</%sApplication_Layer_Protocol>\n' % (namespace_, self.gds_format_string(quote_xml(self.Application_Layer_Protocol).encode(ExternalEncoding), input_name='Application_Layer_Protocol'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Port is not None or
            self.External_Port is not None or
            self.Socket_Type is not None or
            self.Socket_ID is not None or
            self.Internal_IP_Address is not None or
            self.External_IP_Address is not None or
            self.IP_Protocol is not None or
            self.Application_Layer_Protocol is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Network_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Port=%d,\n' % self.Internal_Port)
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('External_Port=%d,\n' % self.External_Port)
        if self.Socket_Type is not None:
            showIndent(outfile, level)
            outfile.write('Socket_Type=%s,\n' % quote_python(self.Socket_Type).encode(ExternalEncoding))
        if self.Socket_ID is not None:
            showIndent(outfile, level)
            outfile.write('Socket_ID=%d,\n' % self.Socket_ID)
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Internal_IP_Address=model_.IPAddress(\n')
            self.Internal_IP_Address.exportLiteral(outfile, level, name_='Internal_IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('External_IP_Address=model_.IPAddress(\n')
            self.External_IP_Address.exportLiteral(outfile, level, name_='External_IP_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IP_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('IP_Protocol=%s,\n' % quote_python(self.IP_Protocol).encode(ExternalEncoding))
        if self.Application_Layer_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Application_Layer_Protocol=%s,\n' % quote_python(self.Application_Layer_Protocol).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Internal_Port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Internal_Port')
            self.Internal_Port = ival_
        elif nodeName_ == 'External_Port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'External_Port')
            self.External_Port = ival_
        elif nodeName_ == 'Socket_Type':
            Socket_Type_ = child_.text
            Socket_Type_ = self.gds_validate_string(Socket_Type_, node, 'Socket_Type')
            self.Socket_Type = Socket_Type_
        elif nodeName_ == 'Socket_ID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Socket_ID')
            self.Socket_ID = ival_
        elif nodeName_ == 'Internal_IP_Address':
            obj_ = IPAddress.factory()
            obj_.build(child_)
            self.set_Internal_IP_Address(obj_)
        elif nodeName_ == 'External_IP_Address':
            obj_ = IPAddress.factory()
            obj_.build(child_)
            self.set_External_IP_Address(obj_)
        elif nodeName_ == 'IP_Protocol':
            IP_Protocol_ = child_.text
            IP_Protocol_ = self.gds_validate_string(IP_Protocol_, node, 'IP_Protocol')
            self.IP_Protocol = IP_Protocol_
            self.validate_IPTypeEnum(self.IP_Protocol)    # validate type IPTypeEnum
        elif nodeName_ == 'Application_Layer_Protocol':
            Application_Layer_Protocol_ = child_.text
            Application_Layer_Protocol_ = self.gds_validate_string(Application_Layer_Protocol_, node, 'Application_Layer_Protocol')
            self.Application_Layer_Protocol = Application_Layer_Protocol_
            self.validate_ApplicationProtocolEnum(self.Application_Layer_Protocol)    # validate type ApplicationProtocolEnum
# end class Network_Object_AttributesType


class Socket_Type(GeneratedsSuper):
    """The Socket_Type field contains the socket type for socket network
    objects. Possible values: Streaming, Datagram, Raw, RDM,
    Sequential_Packet, Other."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Socket_Type.subclass:
            return Socket_Type.subclass(*args_, **kwargs_)
        else:
            return Socket_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Socket_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Socket_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Socket_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Socket_Type', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Socket_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Socket_Type


class Daemon_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Service_Type=None, Start_Type=None, Display_Name=None, Daemon_Binary_Object=None, Load_Order_Group=None):
        self.Service_Type = Service_Type
        self.Start_Type = Start_Type
        self.Display_Name = Display_Name
        self.Daemon_Binary_Object = Daemon_Binary_Object
        self.Load_Order_Group = Load_Order_Group
    def factory(*args_, **kwargs_):
        if Daemon_Object_AttributesType.subclass:
            return Daemon_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Daemon_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Service_Type(self): return self.Service_Type
    def set_Service_Type(self, Service_Type): self.Service_Type = Service_Type
    def get_Start_Type(self): return self.Start_Type
    def set_Start_Type(self, Start_Type): self.Start_Type = Start_Type
    def get_Display_Name(self): return self.Display_Name
    def set_Display_Name(self, Display_Name): self.Display_Name = Display_Name
    def get_Daemon_Binary_Object(self): return self.Daemon_Binary_Object
    def set_Daemon_Binary_Object(self, Daemon_Binary_Object): self.Daemon_Binary_Object = Daemon_Binary_Object
    def get_Load_Order_Group(self): return self.Load_Order_Group
    def set_Load_Order_Group(self, Load_Order_Group): self.Load_Order_Group = Load_Order_Group
    def export(self, outfile, level, namespace_='maec:', name_='Daemon_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Daemon_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Daemon_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Daemon_Object_AttributesType', fromsubclass_=False):
        if self.Service_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sService_Type>%s</%sService_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Service_Type).encode(ExternalEncoding), input_name='Service_Type'), namespace_))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Type>%s</%sStart_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Start_Type).encode(ExternalEncoding), input_name='Start_Type'), namespace_))
        if self.Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sDisplay_Name>%s</%sDisplay_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Display_Name).encode(ExternalEncoding), input_name='Display_Name'), namespace_))
        if self.Daemon_Binary_Object is not None:
            self.Daemon_Binary_Object.export(outfile, level, namespace_, name_='Daemon_Binary_Object')
        if self.Load_Order_Group is not None:
            showIndent(outfile, level)
            outfile.write('<%sLoad_Order_Group>%s</%sLoad_Order_Group>\n' % (namespace_, self.gds_format_string(quote_xml(self.Load_Order_Group).encode(ExternalEncoding), input_name='Load_Order_Group'), namespace_))
    def hasContent_(self):
        if (
            self.Service_Type is not None or
            self.Start_Type is not None or
            self.Display_Name is not None or
            self.Daemon_Binary_Object is not None or
            self.Load_Order_Group is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Daemon_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Service_Type is not None:
            showIndent(outfile, level)
            outfile.write('Service_Type=%s,\n' % quote_python(self.Service_Type).encode(ExternalEncoding))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('Start_Type=%s,\n' % quote_python(self.Start_Type).encode(ExternalEncoding))
        if self.Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('Display_Name=%s,\n' % quote_python(self.Display_Name).encode(ExternalEncoding))
        if self.Daemon_Binary_Object is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Binary_Object=model_.ObjectType(\n')
            self.Daemon_Binary_Object.exportLiteral(outfile, level, name_='Daemon_Binary_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Load_Order_Group is not None:
            showIndent(outfile, level)
            outfile.write('Load_Order_Group=%s,\n' % quote_python(self.Load_Order_Group).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Service_Type':
            Service_Type_ = child_.text
            Service_Type_ = self.gds_validate_string(Service_Type_, node, 'Service_Type')
            self.Service_Type = Service_Type_
        elif nodeName_ == 'Start_Type':
            Start_Type_ = child_.text
            Start_Type_ = self.gds_validate_string(Start_Type_, node, 'Start_Type')
            self.Start_Type = Start_Type_
        elif nodeName_ == 'Display_Name':
            Display_Name_ = child_.text
            Display_Name_ = self.gds_validate_string(Display_Name_, node, 'Display_Name')
            self.Display_Name = Display_Name_
        elif nodeName_ == 'Daemon_Binary_Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_Daemon_Binary_Object(obj_)
        elif nodeName_ == 'Load_Order_Group':
            Load_Order_Group_ = child_.text
            Load_Order_Group_ = self.gds_validate_string(Load_Order_Group_, node, 'Load_Order_Group')
            self.Load_Order_Group = Load_Order_Group_
# end class Daemon_Object_AttributesType


class Service_Type(GeneratedsSuper):
    """The Service_Type field contains the type of the service object.
    Possible values: SERVICE_ADAPTER, SERVICE_FILE_SYSTEM_DRIVER,
    SERVICE_KERNEL_DRIVER, SERVICE_RECOGNIZER_DRIVER,
    SERVICE_WIN32_OWN_PROCESS, SERVICE_WIN32_SHARE_PROCESS."""
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if Service_Type.subclass:
            return Service_Type.subclass(*args_, **kwargs_)
        else:
            return Service_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='maec:', name_='Service_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Service_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Service_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Service_Type', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Service_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Service_Type


class Custom_Object_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Custom_Attribute=None):
        if Custom_Attribute is None:
            self.Custom_Attribute = []
        else:
            self.Custom_Attribute = Custom_Attribute
    def factory(*args_, **kwargs_):
        if Custom_Object_AttributesType.subclass:
            return Custom_Object_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Custom_Object_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Custom_Attribute(self): return self.Custom_Attribute
    def set_Custom_Attribute(self, Custom_Attribute): self.Custom_Attribute = Custom_Attribute
    def add_Custom_Attribute(self, value): self.Custom_Attribute.append(value)
    def insert_Custom_Attribute(self, index, value): self.Custom_Attribute[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Custom_Object_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Custom_Object_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Custom_Object_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Custom_Object_AttributesType', fromsubclass_=False):
        for Custom_Attribute_ in self.Custom_Attribute:
            Custom_Attribute_.export(outfile, level, namespace_, name_='Custom_Attribute')
    def hasContent_(self):
        if (
            self.Custom_Attribute
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Custom_Object_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Custom_Attribute=[\n')
        level += 1
        for Custom_Attribute_ in self.Custom_Attribute:
            showIndent(outfile, level)
            outfile.write('model_.Custom_AttributeType(\n')
            Custom_Attribute_.exportLiteral(outfile, level, name_='Custom_AttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Custom_Attribute':
            obj_ = Custom_AttributeType.factory()
            obj_.build(child_)
            self.Custom_Attribute.append(obj_)
# end class Custom_Object_AttributesType


class Custom_AttributeType(GeneratedsSuper):
    """The custom_attribute_name attribute contains the name of the custom
    attribute."""
    subclass = None
    superclass = None
    def __init__(self, custom_attribute_name=None, valueOf_=None):
        self.custom_attribute_name = _cast(None, custom_attribute_name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Custom_AttributeType.subclass:
            return Custom_AttributeType.subclass(*args_, **kwargs_)
        else:
            return Custom_AttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_attribute_name(self): return self.custom_attribute_name
    def set_custom_attribute_name(self, custom_attribute_name): self.custom_attribute_name = custom_attribute_name
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Custom_AttributeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Custom_AttributeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Custom_AttributeType'):
        if self.custom_attribute_name is not None and 'custom_attribute_name' not in already_processed:
            already_processed.append('custom_attribute_name')
            outfile.write(' custom_attribute_name=%s' % (self.gds_format_string(quote_attrib(self.custom_attribute_name).encode(ExternalEncoding), input_name='custom_attribute_name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Custom_AttributeType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Custom_AttributeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.custom_attribute_name is not None and 'custom_attribute_name' not in already_processed:
            already_processed.append('custom_attribute_name')
            showIndent(outfile, level)
            outfile.write('custom_attribute_name = "%s",\n' % (self.custom_attribute_name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('custom_attribute_name', node)
        if value is not None and 'custom_attribute_name' not in already_processed:
            already_processed.append('custom_attribute_name')
            self.custom_attribute_name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Custom_AttributeType


class Affected_ObjectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Affected_Object=None):
        if Affected_Object is None:
            self.Affected_Object = []
        else:
            self.Affected_Object = Affected_Object
    def factory(*args_, **kwargs_):
        if Affected_ObjectsType.subclass:
            return Affected_ObjectsType.subclass(*args_, **kwargs_)
        else:
            return Affected_ObjectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affected_Object(self): return self.Affected_Object
    def set_Affected_Object(self, Affected_Object): self.Affected_Object = Affected_Object
    def add_Affected_Object(self, value): self.Affected_Object.append(value)
    def insert_Affected_Object(self, index, value): self.Affected_Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Affected_ObjectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Affected_ObjectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Affected_ObjectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Affected_ObjectsType', fromsubclass_=False):
        for Affected_Object_ in self.Affected_Object:
            Affected_Object_.export(outfile, level, namespace_, name_='Affected_Object')
    def hasContent_(self):
        if (
            self.Affected_Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Affected_ObjectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Affected_Object=[\n')
        level += 1
        for Affected_Object_ in self.Affected_Object:
            showIndent(outfile, level)
            outfile.write('model_.Affected_ObjectType(\n')
            Affected_Object_.exportLiteral(outfile, level, name_='Affected_ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affected_Object':
            obj_ = Affected_ObjectType.factory()
            obj_.build(child_)
            self.Affected_Object.append(obj_)
# end class Affected_ObjectsType


class Affected_ObjectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, effect_type=None, Object_Reference=None):
        self.effect_type = _cast(None, effect_type)
        self.Object_Reference = Object_Reference
    def factory(*args_, **kwargs_):
        if Affected_ObjectType.subclass:
            return Affected_ObjectType.subclass(*args_, **kwargs_)
        else:
            return Affected_ObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_effect_type(self): return self.effect_type
    def set_effect_type(self, effect_type): self.effect_type = effect_type
    def export(self, outfile, level, namespace_='maec:', name_='Affected_ObjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Affected_ObjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Affected_ObjectType'):
        if self.effect_type is not None and 'effect_type' not in already_processed:
            already_processed.append('effect_type')
            outfile.write(' effect_type=%s' % (quote_attrib(self.effect_type), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Affected_ObjectType', fromsubclass_=False):
        if self.Object_Reference is not None:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference', )
    def hasContent_(self):
        if (
            self.Object_Reference is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Affected_ObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.effect_type is not None and 'effect_type' not in already_processed:
            already_processed.append('effect_type')
            showIndent(outfile, level)
            outfile.write('effect_type = %s,\n' % (self.effect_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('effect_type', node)
        if value is not None and 'effect_type' not in already_processed:
            already_processed.append('effect_type')
            self.effect_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
# end class Affected_ObjectType


class Constituent_EffectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect_Reference=None):
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if Constituent_EffectsType.subclass:
            return Constituent_EffectsType.subclass(*args_, **kwargs_)
        else:
            return Constituent_EffectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Constituent_EffectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Constituent_EffectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Constituent_EffectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Constituent_EffectsType', fromsubclass_=False):
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Constituent_EffectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class Constituent_EffectsType


class Vulnerability_ExploitType(GeneratedsSuper):
    """This field refers to whether the vulnerability that is being
    exploited is known or unknown. Only known vulnerabilities will
    have an associated CPE identifier. Possible values: Known,
    Unknown."""
    subclass = None
    superclass = None
    def __init__(self, vulnerability_type=None, Known_Exploit=None):
        self.vulnerability_type = _cast(None, vulnerability_type)
        self.Known_Exploit = Known_Exploit
    def factory(*args_, **kwargs_):
        if Vulnerability_ExploitType.subclass:
            return Vulnerability_ExploitType.subclass(*args_, **kwargs_)
        else:
            return Vulnerability_ExploitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Known_Exploit(self): return self.Known_Exploit
    def set_Known_Exploit(self, Known_Exploit): self.Known_Exploit = Known_Exploit
    def get_vulnerability_type(self): return self.vulnerability_type
    def set_vulnerability_type(self, vulnerability_type): self.vulnerability_type = vulnerability_type
    def export(self, outfile, level, namespace_='maec:', name_='Vulnerability_ExploitType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Vulnerability_ExploitType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Vulnerability_ExploitType'):
        if self.vulnerability_type is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            outfile.write(' vulnerability_type=%s' % (self.gds_format_string(quote_attrib(self.vulnerability_type).encode(ExternalEncoding), input_name='vulnerability_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Vulnerability_ExploitType', fromsubclass_=False):
        if self.Known_Exploit is not None:
            self.Known_Exploit.export(outfile, level, namespace_, name_='Known_Exploit', )
    def hasContent_(self):
        if (
            self.Known_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Vulnerability_ExploitType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vulnerability_type is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            showIndent(outfile, level)
            outfile.write('vulnerability_type = "%s",\n' % (self.vulnerability_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Known_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Known_Exploit=model_.CVEVulnerabilityType(\n')
            self.Known_Exploit.exportLiteral(outfile, level, name_='Known_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vulnerability_type', node)
        if value is not None and 'vulnerability_type' not in already_processed:
            already_processed.append('vulnerability_type')
            self.vulnerability_type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Known_Exploit':
            obj_ = CVEVulnerabilityType.factory()
            obj_.build(child_)
            self.set_Known_Exploit(obj_)
# end class Vulnerability_ExploitType


class ImagesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image=None):
        if Image is None:
            self.Image = []
        else:
            self.Image = Image
    def factory(*args_, **kwargs_):
        if ImagesType.subclass:
            return ImagesType.subclass(*args_, **kwargs_)
        else:
            return ImagesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image(self): return self.Image
    def set_Image(self, Image): self.Image = Image
    def add_Image(self, value): self.Image.append(value)
    def insert_Image(self, index, value): self.Image[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ImagesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImagesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImagesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImagesType', fromsubclass_=False):
        for Image_ in self.Image:
            Image_.export(outfile, level, namespace_, name_='Image')
    def hasContent_(self):
        if (
            self.Image
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImagesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Image=[\n')
        level += 1
        for Image_ in self.Image:
            showIndent(outfile, level)
            outfile.write('model_.ImageType(\n')
            Image_.exportLiteral(outfile, level, name_='ImageType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image':
            obj_ = ImageType.factory()
            obj_.build(child_)
            self.Image.append(obj_)
# end class ImagesType


class ImageType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Location=None, Image_Title=None):
        self.Image_Location = Image_Location
        self.Image_Title = Image_Title
    def factory(*args_, **kwargs_):
        if ImageType.subclass:
            return ImageType.subclass(*args_, **kwargs_)
        else:
            return ImageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Location(self): return self.Image_Location
    def set_Image_Location(self, Image_Location): self.Image_Location = Image_Location
    def get_Image_Title(self): return self.Image_Title
    def set_Image_Title(self, Image_Title): self.Image_Title = Image_Title
    def export(self, outfile, level, namespace_='maec:', name_='ImageType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImageType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImageType', fromsubclass_=False):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Location>%s</%sImage_Location>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Location).encode(ExternalEncoding), input_name='Image_Location'), namespace_))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Title>%s</%sImage_Title>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Title).encode(ExternalEncoding), input_name='Image_Title'), namespace_))
    def hasContent_(self):
        if (
            self.Image_Location is not None or
            self.Image_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImageType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('Image_Location=%s,\n' % quote_python(self.Image_Location).encode(ExternalEncoding))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('Image_Title=%s,\n' % quote_python(self.Image_Title).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image_Location':
            Image_Location_ = child_.text
            Image_Location_ = self.gds_validate_string(Image_Location_, node, 'Image_Location')
            self.Image_Location = Image_Location_
        elif nodeName_ == 'Image_Title':
            Image_Title_ = child_.text
            Image_Title_ = self.gds_validate_string(Image_Title_, node, 'Image_Title')
            self.Image_Title = Image_Title_
# end class ImageType


class ImagesType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image=None):
        if Image is None:
            self.Image = []
        else:
            self.Image = Image
    def factory(*args_, **kwargs_):
        if ImagesType1.subclass:
            return ImagesType1.subclass(*args_, **kwargs_)
        else:
            return ImagesType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image(self): return self.Image
    def set_Image(self, Image): self.Image = Image
    def add_Image(self, value): self.Image.append(value)
    def insert_Image(self, index, value): self.Image[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ImagesType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImagesType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImagesType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImagesType1', fromsubclass_=False):
        for Image_ in self.Image:
            Image_.export(outfile, level, namespace_, name_='Image')
    def hasContent_(self):
        if (
            self.Image
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImagesType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Image=[\n')
        level += 1
        for Image_ in self.Image:
            showIndent(outfile, level)
            outfile.write('model_.ImageType1(\n')
            Image_.exportLiteral(outfile, level, name_='ImageType1')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image':
            obj_ = ImageType1.factory()
            obj_.build(child_)
            self.Image.append(obj_)
# end class ImagesType1


class ImageType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Location=None, Image_Title=None):
        self.Image_Location = Image_Location
        self.Image_Title = Image_Title
    def factory(*args_, **kwargs_):
        if ImageType1.subclass:
            return ImageType1.subclass(*args_, **kwargs_)
        else:
            return ImageType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Location(self): return self.Image_Location
    def set_Image_Location(self, Image_Location): self.Image_Location = Image_Location
    def get_Image_Title(self): return self.Image_Title
    def set_Image_Title(self, Image_Title): self.Image_Title = Image_Title
    def export(self, outfile, level, namespace_='maec:', name_='ImageType1', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageType1')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImageType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImageType1', fromsubclass_=False):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Location>%s</%sImage_Location>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Location).encode(ExternalEncoding), input_name='Image_Location'), namespace_))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Title>%s</%sImage_Title>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Title).encode(ExternalEncoding), input_name='Image_Title'), namespace_))
    def hasContent_(self):
        if (
            self.Image_Location is not None or
            self.Image_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImageType1'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('Image_Location=%s,\n' % quote_python(self.Image_Location).encode(ExternalEncoding))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('Image_Title=%s,\n' % quote_python(self.Image_Title).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image_Location':
            Image_Location_ = child_.text
            Image_Location_ = self.gds_validate_string(Image_Location_, node, 'Image_Location')
            self.Image_Location = Image_Location_
        elif nodeName_ == 'Image_Title':
            Image_Title_ = child_.text
            Image_Title_ = self.gds_validate_string(Image_Title_, node, 'Image_Title')
            self.Image_Title = Image_Title_
# end class ImageType1


class ImagesType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image=None):
        if Image is None:
            self.Image = []
        else:
            self.Image = Image
    def factory(*args_, **kwargs_):
        if ImagesType2.subclass:
            return ImagesType2.subclass(*args_, **kwargs_)
        else:
            return ImagesType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image(self): return self.Image
    def set_Image(self, Image): self.Image = Image
    def add_Image(self, value): self.Image.append(value)
    def insert_Image(self, index, value): self.Image[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='ImagesType2', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImagesType2')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImagesType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImagesType2', fromsubclass_=False):
        for Image_ in self.Image:
            Image_.export(outfile, level, namespace_, name_='Image')
    def hasContent_(self):
        if (
            self.Image
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImagesType2'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Image=[\n')
        level += 1
        for Image_ in self.Image:
            showIndent(outfile, level)
            outfile.write('model_.ImageType2(\n')
            Image_.exportLiteral(outfile, level, name_='ImageType2')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image':
            obj_ = ImageType2.factory()
            obj_.build(child_)
            self.Image.append(obj_)
# end class ImagesType2


class ImageType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Location=None, Image_Title=None):
        self.Image_Location = Image_Location
        self.Image_Title = Image_Title
    def factory(*args_, **kwargs_):
        if ImageType2.subclass:
            return ImageType2.subclass(*args_, **kwargs_)
        else:
            return ImageType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Location(self): return self.Image_Location
    def set_Image_Location(self, Image_Location): self.Image_Location = Image_Location
    def get_Image_Title(self): return self.Image_Title
    def set_Image_Title(self, Image_Title): self.Image_Title = Image_Title
    def export(self, outfile, level, namespace_='maec:', name_='ImageType2', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageType2')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='ImageType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ImageType2', fromsubclass_=False):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Location>%s</%sImage_Location>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Location).encode(ExternalEncoding), input_name='Image_Location'), namespace_))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Title>%s</%sImage_Title>\n' % (namespace_, self.gds_format_string(quote_xml(self.Image_Title).encode(ExternalEncoding), input_name='Image_Title'), namespace_))
    def hasContent_(self):
        if (
            self.Image_Location is not None or
            self.Image_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ImageType2'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('Image_Location=%s,\n' % quote_python(self.Image_Location).encode(ExternalEncoding))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('Image_Title=%s,\n' % quote_python(self.Image_Title).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Image_Location':
            Image_Location_ = child_.text
            Image_Location_ = self.gds_validate_string(Image_Location_, node, 'Image_Location')
            self.Image_Location = Image_Location_
        elif nodeName_ == 'Image_Title':
            Image_Title_ = child_.text
            Image_Title_ = self.gds_validate_string(Image_Title_, node, 'Image_Title')
            self.Image_Title = Image_Title_
# end class ImageType2


class File_System_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Existing_File_Name=None, Destination_File_Name=None, Access_Mode=None, Flags=None, Open_Mode=None, File_Attributes=None):
        self.Existing_File_Name = Existing_File_Name
        self.Destination_File_Name = Destination_File_Name
        self.Access_Mode = Access_Mode
        self.Flags = Flags
        self.Open_Mode = Open_Mode
        self.File_Attributes = File_Attributes
    def factory(*args_, **kwargs_):
        if File_System_Action_AttributesType.subclass:
            return File_System_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return File_System_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Existing_File_Name(self): return self.Existing_File_Name
    def set_Existing_File_Name(self, Existing_File_Name): self.Existing_File_Name = Existing_File_Name
    def get_Destination_File_Name(self): return self.Destination_File_Name
    def set_Destination_File_Name(self, Destination_File_Name): self.Destination_File_Name = Destination_File_Name
    def get_Access_Mode(self): return self.Access_Mode
    def set_Access_Mode(self, Access_Mode): self.Access_Mode = Access_Mode
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def get_Open_Mode(self): return self.Open_Mode
    def set_Open_Mode(self, Open_Mode): self.Open_Mode = Open_Mode
    def get_File_Attributes(self): return self.File_Attributes
    def set_File_Attributes(self, File_Attributes): self.File_Attributes = File_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_System_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_System_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='File_System_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_System_Action_AttributesType', fromsubclass_=False):
        if self.Existing_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sExisting_File_Name>%s</%sExisting_File_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Existing_File_Name).encode(ExternalEncoding), input_name='Existing_File_Name'), namespace_))
        if self.Destination_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sDestination_File_Name>%s</%sDestination_File_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Destination_File_Name).encode(ExternalEncoding), input_name='Destination_File_Name'), namespace_))
        if self.Access_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sAccess_Mode>%s</%sAccess_Mode>\n' % (namespace_, self.gds_format_string(quote_xml(self.Access_Mode).encode(ExternalEncoding), input_name='Access_Mode'), namespace_))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sFlags>%s</%sFlags>\n' % (namespace_, self.gds_format_string(quote_xml(self.Flags).encode(ExternalEncoding), input_name='Flags'), namespace_))
        if self.Open_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sOpen_Mode>%s</%sOpen_Mode>\n' % (namespace_, self.gds_format_string(quote_xml(self.Open_Mode).encode(ExternalEncoding), input_name='Open_Mode'), namespace_))
        if self.File_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Attributes>%s</%sFile_Attributes>\n' % (namespace_, self.gds_format_string(quote_xml(self.File_Attributes).encode(ExternalEncoding), input_name='File_Attributes'), namespace_))
    def hasContent_(self):
        if (
            self.Existing_File_Name is not None or
            self.Destination_File_Name is not None or
            self.Access_Mode is not None or
            self.Flags is not None or
            self.Open_Mode is not None or
            self.File_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_System_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Existing_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Existing_File_Name=%s,\n' % quote_python(self.Existing_File_Name).encode(ExternalEncoding))
        if self.Destination_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Destination_File_Name=%s,\n' % quote_python(self.Destination_File_Name).encode(ExternalEncoding))
        if self.Access_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Access_Mode=%s,\n' % quote_python(self.Access_Mode).encode(ExternalEncoding))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=%s,\n' % quote_python(self.Flags).encode(ExternalEncoding))
        if self.Open_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Open_Mode=%s,\n' % quote_python(self.Open_Mode).encode(ExternalEncoding))
        if self.File_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_Attributes=%s,\n' % quote_python(self.File_Attributes).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Existing_File_Name':
            Existing_File_Name_ = child_.text
            Existing_File_Name_ = self.gds_validate_string(Existing_File_Name_, node, 'Existing_File_Name')
            self.Existing_File_Name = Existing_File_Name_
        elif nodeName_ == 'Destination_File_Name':
            Destination_File_Name_ = child_.text
            Destination_File_Name_ = self.gds_validate_string(Destination_File_Name_, node, 'Destination_File_Name')
            self.Destination_File_Name = Destination_File_Name_
        elif nodeName_ == 'Access_Mode':
            Access_Mode_ = child_.text
            Access_Mode_ = self.gds_validate_string(Access_Mode_, node, 'Access_Mode')
            self.Access_Mode = Access_Mode_
        elif nodeName_ == 'Flags':
            Flags_ = child_.text
            Flags_ = self.gds_validate_string(Flags_, node, 'Flags')
            self.Flags = Flags_
        elif nodeName_ == 'Open_Mode':
            Open_Mode_ = child_.text
            Open_Mode_ = self.gds_validate_string(Open_Mode_, node, 'Open_Mode')
            self.Open_Mode = Open_Mode_
        elif nodeName_ == 'File_Attributes':
            File_Attributes_ = child_.text
            File_Attributes_ = self.gds_validate_string(File_Attributes_, node, 'File_Attributes')
            self.File_Attributes = File_Attributes_
# end class File_System_Action_AttributesType


class IPC_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Initial_Owner=None, Thread_ID=None, Target_PID=None, Start_Address=None):
        self.Initial_Owner = Initial_Owner
        self.Thread_ID = Thread_ID
        self.Target_PID = Target_PID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if IPC_Action_AttributesType.subclass:
            return IPC_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return IPC_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Initial_Owner(self): return self.Initial_Owner
    def set_Initial_Owner(self, Initial_Owner): self.Initial_Owner = Initial_Owner
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='IPC_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IPC_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='IPC_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPC_Action_AttributesType', fromsubclass_=False):
        if self.Initial_Owner is not None:
            showIndent(outfile, level)
            outfile.write('<%sInitial_Owner>%s</%sInitial_Owner>\n' % (namespace_, self.gds_format_string(quote_xml(self.Initial_Owner).encode(ExternalEncoding), input_name='Initial_Owner'), namespace_))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.gds_format_integer(self.Thread_ID, input_name='Thread_ID'), namespace_))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.gds_format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
    def hasContent_(self):
        if (
            self.Initial_Owner is not None or
            self.Thread_ID is not None or
            self.Target_PID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPC_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Initial_Owner is not None:
            showIndent(outfile, level)
            outfile.write('Initial_Owner=%s,\n' % quote_python(self.Initial_Owner).encode(ExternalEncoding))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%d,\n' % self.Thread_ID)
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Initial_Owner':
            Initial_Owner_ = child_.text
            Initial_Owner_ = self.gds_validate_string(Initial_Owner_, node, 'Initial_Owner')
            self.Initial_Owner = Initial_Owner_
        elif nodeName_ == 'Thread_ID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Thread_ID')
            self.Thread_ID = ival_
        elif nodeName_ == 'Target_PID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Target_PID')
            self.Target_PID = ival_
        elif nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
# end class IPC_Action_AttributesType


class Process_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Process_Base_Address=None, Thread_ID=None, Start_Address=None, Creation_Flags=None, User_Name=None, Target_PID=None):
        self.Process_Base_Address = Process_Base_Address
        self.Thread_ID = Thread_ID
        self.Start_Address = Start_Address
        self.Creation_Flags = Creation_Flags
        self.User_Name = User_Name
        self.Target_PID = Target_PID
    def factory(*args_, **kwargs_):
        if Process_Action_AttributesType.subclass:
            return Process_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Process_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Process_Base_Address(self): return self.Process_Base_Address
    def set_Process_Base_Address(self, Process_Base_Address): self.Process_Base_Address = Process_Base_Address
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Creation_Flags(self): return self.Creation_Flags
    def set_Creation_Flags(self, Creation_Flags): self.Creation_Flags = Creation_Flags
    def get_User_Name(self): return self.User_Name
    def set_User_Name(self, User_Name): self.User_Name = User_Name
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def export(self, outfile, level, namespace_='maec:', name_='Process_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Process_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Process_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Process_Action_AttributesType', fromsubclass_=False):
        if self.Process_Base_Address is not None:
            self.Process_Base_Address.export(outfile, level, namespace_, name_='Process_Base_Address')
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.gds_format_string(quote_xml(self.Thread_ID).encode(ExternalEncoding), input_name='Thread_ID'), namespace_))
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
        if self.Creation_Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sCreation_Flags>%s</%sCreation_Flags>\n' % (namespace_, self.gds_format_string(quote_xml(self.Creation_Flags).encode(ExternalEncoding), input_name='Creation_Flags'), namespace_))
        if self.User_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sUser_Name>%s</%sUser_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.User_Name).encode(ExternalEncoding), input_name='User_Name'), namespace_))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.gds_format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
    def hasContent_(self):
        if (
            self.Process_Base_Address is not None or
            self.Thread_ID is not None or
            self.Start_Address is not None or
            self.Creation_Flags is not None or
            self.User_Name is not None or
            self.Target_PID is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Process_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Process_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('Process_Base_Address=model_.xs_hexBinary(\n')
            self.Process_Base_Address.exportLiteral(outfile, level, name_='Process_Base_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%s,\n' % quote_python(self.Thread_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Creation_Flags is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Flags=%s,\n' % quote_python(self.Creation_Flags).encode(ExternalEncoding))
        if self.User_Name is not None:
            showIndent(outfile, level)
            outfile.write('User_Name=%s,\n' % quote_python(self.User_Name).encode(ExternalEncoding))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Process_Base_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Process_Base_Address(obj_)
        elif nodeName_ == 'Thread_ID':
            Thread_ID_ = child_.text
            Thread_ID_ = self.gds_validate_string(Thread_ID_, node, 'Thread_ID')
            self.Thread_ID = Thread_ID_
        elif nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
        elif nodeName_ == 'Creation_Flags':
            Creation_Flags_ = child_.text
            Creation_Flags_ = self.gds_validate_string(Creation_Flags_, node, 'Creation_Flags')
            self.Creation_Flags = Creation_Flags_
        elif nodeName_ == 'User_Name':
            User_Name_ = child_.text
            User_Name_ = self.gds_validate_string(User_Name_, node, 'User_Name')
            self.User_Name = User_Name_
        elif nodeName_ == 'Target_PID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Target_PID')
            self.Target_PID = ival_
# end class Process_Action_AttributesType


class Memory_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Start_Address=None, Source_Address=None, Destination_Address=None, Page_Base_Address=None, Target_PID=None, Requested_Address=None):
        self.Start_Address = Start_Address
        self.Source_Address = Source_Address
        self.Destination_Address = Destination_Address
        self.Page_Base_Address = Page_Base_Address
        self.Target_PID = Target_PID
        self.Requested_Address = Requested_Address
    def factory(*args_, **kwargs_):
        if Memory_Action_AttributesType.subclass:
            return Memory_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Memory_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Source_Address(self): return self.Source_Address
    def set_Source_Address(self, Source_Address): self.Source_Address = Source_Address
    def get_Destination_Address(self): return self.Destination_Address
    def set_Destination_Address(self, Destination_Address): self.Destination_Address = Destination_Address
    def get_Page_Base_Address(self): return self.Page_Base_Address
    def set_Page_Base_Address(self, Page_Base_Address): self.Page_Base_Address = Page_Base_Address
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def get_Requested_Address(self): return self.Requested_Address
    def set_Requested_Address(self, Requested_Address): self.Requested_Address = Requested_Address
    def export(self, outfile, level, namespace_='maec:', name_='Memory_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Memory_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Memory_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Memory_Action_AttributesType', fromsubclass_=False):
        if self.Start_Address is not None:
            self.Start_Address.export(outfile, level, namespace_, name_='Start_Address')
        if self.Source_Address is not None:
            self.Source_Address.export(outfile, level, namespace_, name_='Source_Address')
        if self.Destination_Address is not None:
            self.Destination_Address.export(outfile, level, namespace_, name_='Destination_Address')
        if self.Page_Base_Address is not None:
            self.Page_Base_Address.export(outfile, level, namespace_, name_='Page_Base_Address')
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.gds_format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
        if self.Requested_Address is not None:
            self.Requested_Address.export(outfile, level, namespace_, name_='Requested_Address')
    def hasContent_(self):
        if (
            self.Start_Address is not None or
            self.Source_Address is not None or
            self.Destination_Address is not None or
            self.Page_Base_Address is not None or
            self.Target_PID is not None or
            self.Requested_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Memory_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=model_.xs_hexBinary(\n')
            self.Start_Address.exportLiteral(outfile, level, name_='Start_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source_Address is not None:
            showIndent(outfile, level)
            outfile.write('Source_Address=model_.xs_hexBinary(\n')
            self.Source_Address.exportLiteral(outfile, level, name_='Source_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Destination_Address is not None:
            showIndent(outfile, level)
            outfile.write('Destination_Address=model_.xs_hexBinary(\n')
            self.Destination_Address.exportLiteral(outfile, level, name_='Destination_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Page_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('Page_Base_Address=model_.xs_hexBinary(\n')
            self.Page_Base_Address.exportLiteral(outfile, level, name_='Page_Base_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
        if self.Requested_Address is not None:
            showIndent(outfile, level)
            outfile.write('Requested_Address=model_.xs_hexBinary(\n')
            self.Requested_Address.exportLiteral(outfile, level, name_='Requested_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Start_Address(obj_)
        elif nodeName_ == 'Source_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Source_Address(obj_)
        elif nodeName_ == 'Destination_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Destination_Address(obj_)
        elif nodeName_ == 'Page_Base_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Page_Base_Address(obj_)
        elif nodeName_ == 'Target_PID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Target_PID')
            self.Target_PID = ival_
        elif nodeName_ == 'Requested_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Requested_Address(obj_)
# end class Memory_Action_AttributesType


class Registry_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Enumerated_Subkeys=None, Enumerated_Values=None):
        self.Enumerated_Subkeys = Enumerated_Subkeys
        self.Enumerated_Values = Enumerated_Values
    def factory(*args_, **kwargs_):
        if Registry_Action_AttributesType.subclass:
            return Registry_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Registry_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Enumerated_Subkeys(self): return self.Enumerated_Subkeys
    def set_Enumerated_Subkeys(self, Enumerated_Subkeys): self.Enumerated_Subkeys = Enumerated_Subkeys
    def get_Enumerated_Values(self): return self.Enumerated_Values
    def set_Enumerated_Values(self, Enumerated_Values): self.Enumerated_Values = Enumerated_Values
    def export(self, outfile, level, namespace_='maec:', name_='Registry_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Registry_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Registry_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Registry_Action_AttributesType', fromsubclass_=False):
        if self.Enumerated_Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('<%sEnumerated_Subkeys>%s</%sEnumerated_Subkeys>\n' % (namespace_, self.gds_format_string(quote_xml(self.Enumerated_Subkeys).encode(ExternalEncoding), input_name='Enumerated_Subkeys'), namespace_))
        if self.Enumerated_Values is not None:
            showIndent(outfile, level)
            outfile.write('<%sEnumerated_Values>%s</%sEnumerated_Values>\n' % (namespace_, self.gds_format_string(quote_xml(self.Enumerated_Values).encode(ExternalEncoding), input_name='Enumerated_Values'), namespace_))
    def hasContent_(self):
        if (
            self.Enumerated_Subkeys is not None or
            self.Enumerated_Values is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Registry_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Enumerated_Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Subkeys=%s,\n' % quote_python(self.Enumerated_Subkeys).encode(ExternalEncoding))
        if self.Enumerated_Values is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Values=%s,\n' % quote_python(self.Enumerated_Values).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Enumerated_Subkeys':
            Enumerated_Subkeys_ = child_.text
            Enumerated_Subkeys_ = self.gds_validate_string(Enumerated_Subkeys_, node, 'Enumerated_Subkeys')
            self.Enumerated_Subkeys = Enumerated_Subkeys_
        elif nodeName_ == 'Enumerated_Values':
            Enumerated_Values_ = child_.text
            Enumerated_Values_ = self.gds_validate_string(Enumerated_Values_, node, 'Enumerated_Values')
            self.Enumerated_Values = Enumerated_Values_
# end class Registry_Action_AttributesType


class Network_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Port=None, External_Port=None, Internal_IP_Address=None, External_IP_Address=None, Host_Name=None, Data_Sent=None, Data_Received=None, Buffer_Length=None):
        self.Internal_Port = Internal_Port
        self.External_Port = External_Port
        self.Internal_IP_Address = Internal_IP_Address
        self.External_IP_Address = External_IP_Address
        self.Host_Name = Host_Name
        self.Data_Sent = Data_Sent
        self.Data_Received = Data_Received
        self.Buffer_Length = Buffer_Length
    def factory(*args_, **kwargs_):
        if Network_Action_AttributesType.subclass:
            return Network_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Network_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Port(self): return self.Internal_Port
    def set_Internal_Port(self, Internal_Port): self.Internal_Port = Internal_Port
    def get_External_Port(self): return self.External_Port
    def set_External_Port(self, External_Port): self.External_Port = External_Port
    def get_Internal_IP_Address(self): return self.Internal_IP_Address
    def set_Internal_IP_Address(self, Internal_IP_Address): self.Internal_IP_Address = Internal_IP_Address
    def get_External_IP_Address(self): return self.External_IP_Address
    def set_External_IP_Address(self, External_IP_Address): self.External_IP_Address = External_IP_Address
    def get_Host_Name(self): return self.Host_Name
    def set_Host_Name(self, Host_Name): self.Host_Name = Host_Name
    def get_Data_Sent(self): return self.Data_Sent
    def set_Data_Sent(self, Data_Sent): self.Data_Sent = Data_Sent
    def get_Data_Received(self): return self.Data_Received
    def set_Data_Received(self, Data_Received): self.Data_Received = Data_Received
    def get_Buffer_Length(self): return self.Buffer_Length
    def set_Buffer_Length(self, Buffer_Length): self.Buffer_Length = Buffer_Length
    def export(self, outfile, level, namespace_='maec:', name_='Network_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Network_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Network_Action_AttributesType', fromsubclass_=False):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Port>%s</%sInternal_Port>\n' % (namespace_, self.gds_format_integer(self.Internal_Port, input_name='Internal_Port'), namespace_))
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_Port>%s</%sExternal_Port>\n' % (namespace_, self.gds_format_integer(self.External_Port, input_name='External_Port'), namespace_))
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_IP_Address>%s</%sInternal_IP_Address>\n' % (namespace_, self.gds_format_string(quote_xml(self.Internal_IP_Address).encode(ExternalEncoding), input_name='Internal_IP_Address'), namespace_))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_IP_Address>%s</%sExternal_IP_Address>\n' % (namespace_, self.gds_format_string(quote_xml(self.External_IP_Address).encode(ExternalEncoding), input_name='External_IP_Address'), namespace_))
        if self.Host_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sHost_Name>%s</%sHost_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Host_Name).encode(ExternalEncoding), input_name='Host_Name'), namespace_))
        if self.Data_Sent is not None:
            self.Data_Sent.export(outfile, level, namespace_, name_='Data_Sent')
        if self.Data_Received is not None:
            self.Data_Received.export(outfile, level, namespace_, name_='Data_Received')
        if self.Buffer_Length is not None:
            showIndent(outfile, level)
            outfile.write('<%sBuffer_Length>%s</%sBuffer_Length>\n' % (namespace_, self.gds_format_integer(self.Buffer_Length, input_name='Buffer_Length'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Port is not None or
            self.External_Port is not None or
            self.Internal_IP_Address is not None or
            self.External_IP_Address is not None or
            self.Host_Name is not None or
            self.Data_Sent is not None or
            self.Data_Received is not None or
            self.Buffer_Length is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Network_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Port=%d,\n' % self.Internal_Port)
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('External_Port=%d,\n' % self.External_Port)
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Internal_IP_Address=%s,\n' % quote_python(self.Internal_IP_Address).encode(ExternalEncoding))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('External_IP_Address=%s,\n' % quote_python(self.External_IP_Address).encode(ExternalEncoding))
        if self.Host_Name is not None:
            showIndent(outfile, level)
            outfile.write('Host_Name=%s,\n' % quote_python(self.Host_Name).encode(ExternalEncoding))
        if self.Data_Sent is not None:
            showIndent(outfile, level)
            outfile.write('Data_Sent=model_.DataType(\n')
            self.Data_Sent.exportLiteral(outfile, level, name_='Data_Sent')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Received is not None:
            showIndent(outfile, level)
            outfile.write('Data_Received=model_.DataType(\n')
            self.Data_Received.exportLiteral(outfile, level, name_='Data_Received')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Buffer_Length is not None:
            showIndent(outfile, level)
            outfile.write('Buffer_Length=%d,\n' % self.Buffer_Length)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Internal_Port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Internal_Port')
            self.Internal_Port = ival_
        elif nodeName_ == 'External_Port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'External_Port')
            self.External_Port = ival_
        elif nodeName_ == 'Internal_IP_Address':
            Internal_IP_Address_ = child_.text
            Internal_IP_Address_ = self.gds_validate_string(Internal_IP_Address_, node, 'Internal_IP_Address')
            self.Internal_IP_Address = Internal_IP_Address_
        elif nodeName_ == 'External_IP_Address':
            External_IP_Address_ = child_.text
            External_IP_Address_ = self.gds_validate_string(External_IP_Address_, node, 'External_IP_Address')
            self.External_IP_Address = External_IP_Address_
        elif nodeName_ == 'Host_Name':
            Host_Name_ = child_.text
            Host_Name_ = self.gds_validate_string(Host_Name_, node, 'Host_Name')
            self.Host_Name = Host_Name_
        elif nodeName_ == 'Data_Sent':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Sent(obj_)
        elif nodeName_ == 'Data_Received':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Received(obj_)
        elif nodeName_ == 'Buffer_Length':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Buffer_Length')
            self.Buffer_Length = ival_
# end class Network_Action_AttributesType


class Module_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Flags=None):
        self.Function_Name = Function_Name
        self.Flags = Flags
    def factory(*args_, **kwargs_):
        if Module_Action_AttributesType.subclass:
            return Module_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Module_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def export(self, outfile, level, namespace_='maec:', name_='Module_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Module_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Module_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Module_Action_AttributesType', fromsubclass_=False):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sFlags>%s</%sFlags>\n' % (namespace_, self.gds_format_string(quote_xml(self.Flags).encode(ExternalEncoding), input_name='Flags'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Flags is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Module_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=%s,\n' % quote_python(self.Flags).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function_Name':
            Function_Name_ = child_.text
            Function_Name_ = self.gds_validate_string(Function_Name_, node, 'Function_Name')
            self.Function_Name = Function_Name_
        elif nodeName_ == 'Flags':
            Flags_ = child_.text
            Flags_ = self.gds_validate_string(Flags_, node, 'Flags')
            self.Flags = Flags_
# end class Module_Action_AttributesType


class Daemon_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Options=None, Start_Type=None, Desired_Access_Type=None, Enumerated_Daemons=None):
        self.Options = Options
        self.Start_Type = Start_Type
        self.Desired_Access_Type = Desired_Access_Type
        self.Enumerated_Daemons = Enumerated_Daemons
    def factory(*args_, **kwargs_):
        if Daemon_Action_AttributesType.subclass:
            return Daemon_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Daemon_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Options(self): return self.Options
    def set_Options(self, Options): self.Options = Options
    def get_Start_Type(self): return self.Start_Type
    def set_Start_Type(self, Start_Type): self.Start_Type = Start_Type
    def get_Desired_Access_Type(self): return self.Desired_Access_Type
    def set_Desired_Access_Type(self, Desired_Access_Type): self.Desired_Access_Type = Desired_Access_Type
    def get_Enumerated_Daemons(self): return self.Enumerated_Daemons
    def set_Enumerated_Daemons(self, Enumerated_Daemons): self.Enumerated_Daemons = Enumerated_Daemons
    def export(self, outfile, level, namespace_='maec:', name_='Daemon_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Daemon_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Daemon_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Daemon_Action_AttributesType', fromsubclass_=False):
        if self.Options is not None:
            showIndent(outfile, level)
            outfile.write('<%sOptions>%s</%sOptions>\n' % (namespace_, self.gds_format_string(quote_xml(self.Options).encode(ExternalEncoding), input_name='Options'), namespace_))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Type>%s</%sStart_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Start_Type).encode(ExternalEncoding), input_name='Start_Type'), namespace_))
        if self.Desired_Access_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sDesired_Access_Type>%s</%sDesired_Access_Type>\n' % (namespace_, self.gds_format_string(quote_xml(self.Desired_Access_Type).encode(ExternalEncoding), input_name='Desired_Access_Type'), namespace_))
        if self.Enumerated_Daemons is not None:
            self.Enumerated_Daemons.export(outfile, level, namespace_, name_='Enumerated_Daemons')
    def hasContent_(self):
        if (
            self.Options is not None or
            self.Start_Type is not None or
            self.Desired_Access_Type is not None or
            self.Enumerated_Daemons is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Daemon_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Options is not None:
            showIndent(outfile, level)
            outfile.write('Options=%s,\n' % quote_python(self.Options).encode(ExternalEncoding))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('Start_Type=%s,\n' % quote_python(self.Start_Type).encode(ExternalEncoding))
        if self.Desired_Access_Type is not None:
            showIndent(outfile, level)
            outfile.write('Desired_Access_Type=%s,\n' % quote_python(self.Desired_Access_Type).encode(ExternalEncoding))
        if self.Enumerated_Daemons is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Daemons=model_.Enumerated_DaemonsType(\n')
            self.Enumerated_Daemons.exportLiteral(outfile, level, name_='Enumerated_Daemons')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Options':
            Options_ = child_.text
            Options_ = self.gds_validate_string(Options_, node, 'Options')
            self.Options = Options_
        elif nodeName_ == 'Start_Type':
            Start_Type_ = child_.text
            Start_Type_ = self.gds_validate_string(Start_Type_, node, 'Start_Type')
            self.Start_Type = Start_Type_
        elif nodeName_ == 'Desired_Access_Type':
            Desired_Access_Type_ = child_.text
            Desired_Access_Type_ = self.gds_validate_string(Desired_Access_Type_, node, 'Desired_Access_Type')
            self.Desired_Access_Type = Desired_Access_Type_
        elif nodeName_ == 'Enumerated_Daemons':
            obj_ = Enumerated_DaemonsType.factory()
            obj_.build(child_)
            self.set_Enumerated_Daemons(obj_)
# end class Daemon_Action_AttributesType


class Enumerated_DaemonsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Daemon_Reference=None):
        if Daemon_Reference is None:
            self.Daemon_Reference = []
        else:
            self.Daemon_Reference = Daemon_Reference
    def factory(*args_, **kwargs_):
        if Enumerated_DaemonsType.subclass:
            return Enumerated_DaemonsType.subclass(*args_, **kwargs_)
        else:
            return Enumerated_DaemonsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Daemon_Reference(self): return self.Daemon_Reference
    def set_Daemon_Reference(self, Daemon_Reference): self.Daemon_Reference = Daemon_Reference
    def add_Daemon_Reference(self, value): self.Daemon_Reference.append(value)
    def insert_Daemon_Reference(self, index, value): self.Daemon_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Enumerated_DaemonsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Enumerated_DaemonsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Enumerated_DaemonsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Enumerated_DaemonsType', fromsubclass_=False):
        for Daemon_Reference_ in self.Daemon_Reference:
            Daemon_Reference_.export(outfile, level, namespace_, name_='Daemon_Reference')
    def hasContent_(self):
        if (
            self.Daemon_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Enumerated_DaemonsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Daemon_Reference=[\n')
        level += 1
        for Daemon_Reference_ in self.Daemon_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Daemon_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Daemon_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Daemon_Reference.append(obj_)
# end class Enumerated_DaemonsType


class System_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Computer_Name=None, Local_Time=None):
        self.Computer_Name = Computer_Name
        self.Local_Time = Local_Time
    def factory(*args_, **kwargs_):
        if System_Action_AttributesType.subclass:
            return System_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return System_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Computer_Name(self): return self.Computer_Name
    def set_Computer_Name(self, Computer_Name): self.Computer_Name = Computer_Name
    def get_Local_Time(self): return self.Local_Time
    def set_Local_Time(self, Local_Time): self.Local_Time = Local_Time
    def export(self, outfile, level, namespace_='maec:', name_='System_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='System_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='System_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='System_Action_AttributesType', fromsubclass_=False):
        if self.Computer_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sComputer_Name>%s</%sComputer_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Computer_Name).encode(ExternalEncoding), input_name='Computer_Name'), namespace_))
        if self.Local_Time is not None:
            self.Local_Time.export(outfile, level, namespace_, name_='Local_Time')
    def hasContent_(self):
        if (
            self.Computer_Name is not None or
            self.Local_Time is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='System_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Computer_Name is not None:
            showIndent(outfile, level)
            outfile.write('Computer_Name=%s,\n' % quote_python(self.Computer_Name).encode(ExternalEncoding))
        if self.Local_Time is not None:
            showIndent(outfile, level)
            outfile.write('Local_Time=model_.xs_time(\n')
            self.Local_Time.exportLiteral(outfile, level, name_='Local_Time')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Computer_Name':
            Computer_Name_ = child_.text
            Computer_Name_ = self.gds_validate_string(Computer_Name_, node, 'Computer_Name')
            self.Computer_Name = Computer_Name_
        elif nodeName_ == 'Local_Time':
            obj_ = xs_time.factory()
            obj_.build(child_)
            self.set_Local_Time(obj_)
# end class System_Action_AttributesType


class Internet_Action_AttributesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URL_Connected=None):
        self.URL_Connected = URL_Connected
    def factory(*args_, **kwargs_):
        if Internet_Action_AttributesType.subclass:
            return Internet_Action_AttributesType.subclass(*args_, **kwargs_)
        else:
            return Internet_Action_AttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URL_Connected(self): return self.URL_Connected
    def set_URL_Connected(self, URL_Connected): self.URL_Connected = URL_Connected
    def export(self, outfile, level, namespace_='maec:', name_='Internet_Action_AttributesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Internet_Action_AttributesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Internet_Action_AttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Internet_Action_AttributesType', fromsubclass_=False):
        if self.URL_Connected is not None:
            self.URL_Connected.export(outfile, level, namespace_, name_='URL_Connected')
    def hasContent_(self):
        if (
            self.URL_Connected is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Internet_Action_AttributesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URL_Connected is not None:
            showIndent(outfile, level)
            outfile.write('URL_Connected=model_.uriObject(\n')
            self.URL_Connected.exportLiteral(outfile, level, name_='URL_Connected')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'URL_Connected':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.set_URL_Connected(obj_)
# end class Internet_Action_AttributesType


class TitleType(GeneratedsSuper):
    """This field holds a shortform descriptor for the language that the
    Title field is expressed in. Attempting to install the relevant
    ISO 2- and 3-letter codes as the enumerated possible values is
    probably never going to be a realistic possibility. See RFC 3066
    at http://www.ietf.org/rfc/rfc3066.txt and the IANA registry at
    http://www.iana.org/assignments/lang-tag-apps.htm for further
    information. The union allows for the 'un-declaration' of
    xml:lang with the empty string."""
    subclass = None
    superclass = None
    def __init__(self, lang=None, valueOf_=None):
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if TitleType.subclass:
            return TitleType.subclass(*args_, **kwargs_)
        else:
            return TitleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='TitleType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TitleType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='TitleType'):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            outfile.write(' lang=%s' % (self.gds_format_string(quote_attrib(self.lang).encode(ExternalEncoding), input_name='lang'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='TitleType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TitleType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            showIndent(outfile, level)
            outfile.write('lang = "%s",\n' % (self.lang,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.append('lang')
            self.lang = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TitleType


class meta_item_metadataType(GeneratedsSuper):
    """The modification-date attribute represents the last time that any
    CPE property has been modified.The status attribute contains the
    internal NVD status of a CPE.The nvd-id attribute contains the
    NVD specific unique identifier for a CPE. This is provided as a
    long-term identifier that can be used to map different versions
    of CPE syntax to a CPE with the same meaning. This is not a
    replacement of a CPEName. Use of a CPEName is still the standard
    ID naming scheme for CPE 2.x.The xmlns-meta attribute contains
    the XML CPE metadata namespace descriptor for the CPE namespace
    relevant to this CPE Name use."""
    subclass = None
    superclass = None
    def __init__(self, status=None, nvd_id=None, xmlns_meta=None, modification_date=None):
        self.status = _cast(None, status)
        self.nvd_id = _cast(int, nvd_id)
        self.xmlns_meta = _cast(None, xmlns_meta)
        self.modification_date = _cast(None, modification_date)
        pass
    def factory(*args_, **kwargs_):
        if meta_item_metadataType.subclass:
            return meta_item_metadataType.subclass(*args_, **kwargs_)
        else:
            return meta_item_metadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_nvd_id(self): return self.nvd_id
    def set_nvd_id(self, nvd_id): self.nvd_id = nvd_id
    def get_xmlns_meta(self): return self.xmlns_meta
    def set_xmlns_meta(self, xmlns_meta): self.xmlns_meta = xmlns_meta
    def get_modification_date(self): return self.modification_date
    def set_modification_date(self, modification_date): self.modification_date = modification_date
    def export(self, outfile, level, namespace_='maec:', name_='meta-item-metadataType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='meta-item-metadataType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='meta-item-metadataType'):
        if self.status is not None and 'status' not in already_processed:
            already_processed.append('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.nvd_id is not None and 'nvd_id' not in already_processed:
            already_processed.append('nvd_id')
            outfile.write(' nvd-id="%s"' % self.gds_format_integer(self.nvd_id, input_name='nvd-id'))
        if self.xmlns_meta is not None and 'xmlns_meta' not in already_processed:
            already_processed.append('xmlns_meta')
            outfile.write(' xmlns-meta=%s' % (self.gds_format_string(quote_attrib(self.xmlns_meta).encode(ExternalEncoding), input_name='xmlns-meta'), ))
        if self.modification_date is not None and 'modification_date' not in already_processed:
            already_processed.append('modification_date')
            outfile.write(' modification-date=%s' % (self.gds_format_string(quote_attrib(self.modification_date).encode(ExternalEncoding), input_name='modification-date'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='meta-item-metadataType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='meta-item-metadataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.append('status')
            showIndent(outfile, level)
            outfile.write('status = "%s",\n' % (self.status,))
        if self.nvd_id is not None and 'nvd_id' not in already_processed:
            already_processed.append('nvd_id')
            showIndent(outfile, level)
            outfile.write('nvd_id = %d,\n' % (self.nvd_id,))
        if self.xmlns_meta is not None and 'xmlns_meta' not in already_processed:
            already_processed.append('xmlns_meta')
            showIndent(outfile, level)
            outfile.write('xmlns_meta = "%s",\n' % (self.xmlns_meta,))
        if self.modification_date is not None and 'modification_date' not in already_processed:
            already_processed.append('modification_date')
            showIndent(outfile, level)
            outfile.write('modification_date = "%s",\n' % (self.modification_date,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.append('status')
            self.status = value
        value = find_attr_value_('nvd-id', node)
        if value is not None and 'nvd-id' not in already_processed:
            already_processed.append('nvd-id')
            try:
                self.nvd_id = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
        value = find_attr_value_('xmlns-meta', node)
        if value is not None and 'xmlns-meta' not in already_processed:
            already_processed.append('xmlns-meta')
            self.xmlns_meta = value
        value = find_attr_value_('modification-date', node)
        if value is not None and 'modification-date' not in already_processed:
            already_processed.append('modification-date')
            self.modification_date = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class meta_item_metadataType


class APICall_ParameterType(GeneratedsSuper):
    """This attribute refers to the ordinal position of the API function
    call parameter with respect to the function itself."""
    subclass = None
    superclass = None
    def __init__(self, ordinal_position=None, Name=None, Value=None):
        self.ordinal_position = _cast(int, ordinal_position)
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if APICall_ParameterType.subclass:
            return APICall_ParameterType.subclass(*args_, **kwargs_)
        else:
            return APICall_ParameterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def export(self, outfile, level, namespace_='maec:', name_='APICall_ParameterType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='APICall_ParameterType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='APICall_ParameterType'):
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            outfile.write(' ordinal_position="%s"' % self.gds_format_integer(self.ordinal_position, input_name='ordinal_position'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='APICall_ParameterType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue>%s</%sValue>\n' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='APICall_ParameterType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ordinal_position', node)
        if value is not None and 'ordinal_position' not in already_processed:
            already_processed.append('ordinal_position')
            try:
                self.ordinal_position = int(value)
            except ValueError as e:
                raise_parse_error(node, 'Bad integer attribute: %s' % e)
            if self.ordinal_position <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
# end class APICall_ParameterType


class SubjectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URI=None, Object_Reference=None, Object=None, Subject_Field_Data=None):
        self.URI = URI
        self.Object_Reference = Object_Reference
        self.Object = Object
        self.Subject_Field_Data = Subject_Field_Data
    def factory(*args_, **kwargs_):
        if SubjectType.subclass:
            return SubjectType.subclass(*args_, **kwargs_)
        else:
            return SubjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def get_Subject_Field_Data(self): return self.Subject_Field_Data
    def set_Subject_Field_Data(self, Subject_Field_Data): self.Subject_Field_Data = Subject_Field_Data
    def export(self, outfile, level, namespace_='maec:', name_='SubjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='SubjectType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='SubjectType', fromsubclass_=False):
        if self.URI is not None:
            self.URI.export(outfile, level, namespace_, name_='URI')
        if self.Object_Reference is not None:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference')
        if self.Object is not None:
            self.Object.export(outfile, level, namespace_, name_='Object')
        if self.Subject_Field_Data is not None:
            self.Subject_Field_Data.export(outfile, level, namespace_, name_='Subject_Field_Data')
    def hasContent_(self):
        if (
            self.URI is not None or
            self.Object_Reference is not None or
            self.Object is not None or
            self.Subject_Field_Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SubjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=model_.uriObject(\n')
            self.URI.exportLiteral(outfile, level, name_='URI')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object is not None:
            showIndent(outfile, level)
            outfile.write('Object=model_.ObjectType(\n')
            self.Object.exportLiteral(outfile, level, name_='Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subject_Field_Data is not None:
            showIndent(outfile, level)
            outfile.write('Subject_Field_Data=model_.fieldDataEntry(\n')
            self.Subject_Field_Data.exportLiteral(outfile, level, name_='Subject_Field_Data')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'URI':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.set_URI(obj_)
        elif nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
        elif nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_Object(obj_)
        elif nodeName_ == 'Subject_Field_Data':
            obj_ = fieldDataEntry.factory()
            obj_.build(child_)
            self.set_Subject_Field_Data(obj_)
# end class SubjectType


class AnalystsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Analyst=None):
        if Analyst is None:
            self.Analyst = []
        else:
            self.Analyst = Analyst
    def factory(*args_, **kwargs_):
        if AnalystsType.subclass:
            return AnalystsType.subclass(*args_, **kwargs_)
        else:
            return AnalystsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analyst(self): return self.Analyst
    def set_Analyst(self, Analyst): self.Analyst = Analyst
    def add_Analyst(self, value): self.Analyst.append(value)
    def insert_Analyst(self, index, value): self.Analyst[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='AnalystsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnalystsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='AnalystsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='AnalystsType', fromsubclass_=False):
        for Analyst_ in self.Analyst:
            showIndent(outfile, level)
            outfile.write('<%sAnalyst>%s</%sAnalyst>\n' % (namespace_, self.gds_format_string(quote_xml(Analyst_).encode(ExternalEncoding), input_name='Analyst'), namespace_))
    def hasContent_(self):
        if (
            self.Analyst
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AnalystsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Analyst=[\n')
        level += 1
        for Analyst_ in self.Analyst:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Analyst_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Analyst':
            Analyst_ = child_.text
            Analyst_ = self.gds_validate_string(Analyst_, node, 'Analyst')
            self.Analyst.append(Analyst_)
# end class AnalystsType


class SourceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Organization_Name=None, POC=None, URI=None):
        self.Organization_Name = Organization_Name
        self.POC = POC
        self.URI = URI
    def factory(*args_, **kwargs_):
        if SourceType.subclass:
            return SourceType.subclass(*args_, **kwargs_)
        else:
            return SourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Organization_Name(self): return self.Organization_Name
    def set_Organization_Name(self, Organization_Name): self.Organization_Name = Organization_Name
    def get_POC(self): return self.POC
    def set_POC(self, POC): self.POC = POC
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def export(self, outfile, level, namespace_='maec:', name_='SourceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SourceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='SourceType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='SourceType', fromsubclass_=False):
        if self.Organization_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrganization_Name>%s</%sOrganization_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Organization_Name).encode(ExternalEncoding), input_name='Organization_Name'), namespace_))
        if self.POC is not None:
            showIndent(outfile, level)
            outfile.write('<%sPOC>%s</%sPOC>\n' % (namespace_, self.gds_format_string(quote_xml(self.POC).encode(ExternalEncoding), input_name='POC'), namespace_))
        if self.URI is not None:
            self.URI.export(outfile, level, namespace_, name_='URI')
    def hasContent_(self):
        if (
            self.Organization_Name is not None or
            self.POC is not None or
            self.URI is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Organization_Name is not None:
            showIndent(outfile, level)
            outfile.write('Organization_Name=%s,\n' % quote_python(self.Organization_Name).encode(ExternalEncoding))
        if self.POC is not None:
            showIndent(outfile, level)
            outfile.write('POC=%s,\n' % quote_python(self.POC).encode(ExternalEncoding))
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=model_.uriObject(\n')
            self.URI.exportLiteral(outfile, level, name_='URI')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Organization_Name':
            Organization_Name_ = child_.text
            Organization_Name_ = self.gds_validate_string(Organization_Name_, node, 'Organization_Name')
            self.Organization_Name = Organization_Name_
        elif nodeName_ == 'POC':
            POC_ = child_.text
            POC_ = self.gds_validate_string(POC_, node, 'POC')
            self.POC = POC_
        elif nodeName_ == 'URI':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.set_URI(obj_)
# end class SourceType


class Analysis_EnvironmentType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, OS=None, Enivironment_Variables=None):
        self.OS = OS
        self.Enivironment_Variables = Enivironment_Variables
    def factory(*args_, **kwargs_):
        if Analysis_EnvironmentType.subclass:
            return Analysis_EnvironmentType.subclass(*args_, **kwargs_)
        else:
            return Analysis_EnvironmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OS(self): return self.OS
    def set_OS(self, OS): self.OS = OS
    def get_Enivironment_Variables(self): return self.Enivironment_Variables
    def set_Enivironment_Variables(self, Enivironment_Variables): self.Enivironment_Variables = Enivironment_Variables
    def export(self, outfile, level, namespace_='maec:', name_='Analysis_EnvironmentType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Analysis_EnvironmentType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Analysis_EnvironmentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Analysis_EnvironmentType', fromsubclass_=False):
        if self.OS is not None:
            self.OS.export(outfile, level, namespace_, name_='OS')
        if self.Enivironment_Variables is not None:
            self.Enivironment_Variables.export(outfile, level, namespace_, name_='Enivironment_Variables')
    def hasContent_(self):
        if (
            self.OS is not None or
            self.Enivironment_Variables is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Analysis_EnvironmentType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.OS is not None:
            showIndent(outfile, level)
            outfile.write('OS=model_.CPESpecificationType(\n')
            self.OS.exportLiteral(outfile, level, name_='OS')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Enivironment_Variables is not None:
            showIndent(outfile, level)
            outfile.write('Enivironment_Variables=model_.Enivironment_VariablesType(\n')
            self.Enivironment_Variables.exportLiteral(outfile, level, name_='Enivironment_Variables')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OS':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_OS(obj_)
        elif nodeName_ == 'Enivironment_Variables':
            obj_ = Enivironment_VariablesType.factory()
            obj_.build(child_)
            self.set_Enivironment_Variables(obj_)
# end class Analysis_EnvironmentType


class Enivironment_VariablesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Environment_Variable=None):
        if Environment_Variable is None:
            self.Environment_Variable = []
        else:
            self.Environment_Variable = Environment_Variable
    def factory(*args_, **kwargs_):
        if Enivironment_VariablesType.subclass:
            return Enivironment_VariablesType.subclass(*args_, **kwargs_)
        else:
            return Enivironment_VariablesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Environment_Variable(self): return self.Environment_Variable
    def set_Environment_Variable(self, Environment_Variable): self.Environment_Variable = Environment_Variable
    def add_Environment_Variable(self, value): self.Environment_Variable.append(value)
    def insert_Environment_Variable(self, index, value): self.Environment_Variable[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Enivironment_VariablesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Enivironment_VariablesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Enivironment_VariablesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Enivironment_VariablesType', fromsubclass_=False):
        for Environment_Variable_ in self.Environment_Variable:
            Environment_Variable_.export(outfile, level, namespace_, name_='Environment_Variable')
    def hasContent_(self):
        if (
            self.Environment_Variable
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Enivironment_VariablesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Environment_Variable=[\n')
        level += 1
        for Environment_Variable_ in self.Environment_Variable:
            showIndent(outfile, level)
            outfile.write('model_.Environment_VariableType(\n')
            Environment_Variable_.exportLiteral(outfile, level, name_='Environment_VariableType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Environment_Variable':
            obj_ = Environment_VariableType.factory()
            obj_.build(child_)
            self.Environment_Variable.append(obj_)
# end class Enivironment_VariablesType


class Environment_VariableType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if Environment_VariableType.subclass:
            return Environment_VariableType.subclass(*args_, **kwargs_)
        else:
            return Environment_VariableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='maec:', name_='Environment_VariableType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Environment_VariableType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Environment_VariableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Environment_VariableType', fromsubclass_=False):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue>%s</%sValue>\n' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Environment_VariableType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
# end class Environment_VariableType


class Tools_UsedType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tool=None):
        if Tool is None:
            self.Tool = []
        else:
            self.Tool = Tool
    def factory(*args_, **kwargs_):
        if Tools_UsedType.subclass:
            return Tools_UsedType.subclass(*args_, **kwargs_)
        else:
            return Tools_UsedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tool(self): return self.Tool
    def set_Tool(self, Tool): self.Tool = Tool
    def add_Tool(self, value): self.Tool.append(value)
    def insert_Tool(self, index, value): self.Tool[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Tools_UsedType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Tools_UsedType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Tools_UsedType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Tools_UsedType', fromsubclass_=False):
        for Tool_ in self.Tool:
            Tool_.export(outfile, level, namespace_, name_='Tool')
    def hasContent_(self):
        if (
            self.Tool
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Tools_UsedType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Tool=[\n')
        level += 1
        for Tool_ in self.Tool:
            showIndent(outfile, level)
            outfile.write('model_.ToolType(\n')
            Tool_.exportLiteral(outfile, level, name_='ToolType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Tool':
            obj_ = ToolType.factory()
            obj_.build(child_)
            self.Tool.append(obj_)
# end class Tools_UsedType


class NotesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Note=None):
        if Note is None:
            self.Note = []
        else:
            self.Note = Note
    def factory(*args_, **kwargs_):
        if NotesType.subclass:
            return NotesType.subclass(*args_, **kwargs_)
        else:
            return NotesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Note(self): return self.Note
    def set_Note(self, Note): self.Note = Note
    def add_Note(self, value): self.Note.append(value)
    def insert_Note(self, index, value): self.Note[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='NotesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NotesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='NotesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='NotesType', fromsubclass_=False):
        for Note_ in self.Note:
            showIndent(outfile, level)
            outfile.write('<%sNote>%s</%sNote>\n' % (namespace_, self.gds_format_string(quote_xml(Note_).encode(ExternalEncoding), input_name='Note'), namespace_))
    def hasContent_(self):
        if (
            self.Note
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NotesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Note=[\n')
        level += 1
        for Note_ in self.Note:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Note_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Note':
            Note_ = child_.text
            Note_ = self.gds_validate_string(Note_, node, 'Note')
            self.Note.append(Note_)
# end class NotesType


class Data_SizeType(GeneratedsSuper):
    """This attribute represents the Units used in the object size field.
    Possible values are: Bytes, Kilobytes, Megabytes."""
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Data_SizeType.subclass:
            return Data_SizeType.subclass(*args_, **kwargs_)
        else:
            return Data_SizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Data_SizeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Data_SizeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Data_SizeType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_SizeType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_SizeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.units is not None and 'units' not in already_processed:
            already_processed.append('units')
            showIndent(outfile, level)
            outfile.write('units = "%s",\n' % (self.units,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.append('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Data_SizeType


class HashesType5(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType5.subclass:
            return HashesType5.subclass(*args_, **kwargs_)
        else:
            return HashesType5(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType5', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType5')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType5'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType5', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType5'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType5


class HashesType6(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType6.subclass:
            return HashesType6.subclass(*args_, **kwargs_)
        else:
            return HashesType6(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType6', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType6')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType6'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType6', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType6'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType6


class Imported_FunctionsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Imported_Function=None):
        if Imported_Function is None:
            self.Imported_Function = []
        else:
            self.Imported_Function = Imported_Function
    def factory(*args_, **kwargs_):
        if Imported_FunctionsType.subclass:
            return Imported_FunctionsType.subclass(*args_, **kwargs_)
        else:
            return Imported_FunctionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Imported_Function(self): return self.Imported_Function
    def set_Imported_Function(self, Imported_Function): self.Imported_Function = Imported_Function
    def add_Imported_Function(self, value): self.Imported_Function.append(value)
    def insert_Imported_Function(self, index, value): self.Imported_Function[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Imported_FunctionsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Imported_FunctionsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Imported_FunctionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Imported_FunctionsType', fromsubclass_=False):
        for Imported_Function_ in self.Imported_Function:
            Imported_Function_.export(outfile, level, namespace_, name_='Imported_Function')
    def hasContent_(self):
        if (
            self.Imported_Function
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Imported_FunctionsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Imported_Function=[\n')
        level += 1
        for Imported_Function_ in self.Imported_Function:
            showIndent(outfile, level)
            outfile.write('model_.Imported_FunctionType(\n')
            Imported_Function_.exportLiteral(outfile, level, name_='Imported_FunctionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Imported_Function':
            obj_ = Imported_FunctionType.factory()
            obj_.build(child_)
            self.Imported_Function.append(obj_)
# end class Imported_FunctionsType


class Imported_FunctionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Virtual_Address=None, Hint=None, Ordinal=None):
        self.Function_Name = Function_Name
        self.Virtual_Address = Virtual_Address
        self.Hint = Hint
        self.Ordinal = Ordinal
    def factory(*args_, **kwargs_):
        if Imported_FunctionType.subclass:
            return Imported_FunctionType.subclass(*args_, **kwargs_)
        else:
            return Imported_FunctionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Hint(self): return self.Hint
    def set_Hint(self, Hint): self.Hint = Hint
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def export(self, outfile, level, namespace_='maec:', name_='Imported_FunctionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Imported_FunctionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Imported_FunctionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Imported_FunctionType', fromsubclass_=False):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.gds_format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.gds_format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Hint is not None:
            self.Hint.export(outfile, level, namespace_, name_='Hint')
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrdinal>%s</%sOrdinal>\n' % (namespace_, self.gds_format_integer(self.Ordinal, input_name='Ordinal'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Virtual_Address is not None or
            self.Hint is not None or
            self.Ordinal is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Imported_FunctionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=model_.xs_hexBinary(\n')
            self.Virtual_Address.exportLiteral(outfile, level, name_='Virtual_Address')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hint is not None:
            showIndent(outfile, level)
            outfile.write('Hint=model_.xs_hexBinary(\n')
            self.Hint.exportLiteral(outfile, level, name_='Hint')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=%d,\n' % self.Ordinal)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Function_Name':
            Function_Name_ = child_.text
            Function_Name_ = self.gds_validate_string(Function_Name_, node, 'Function_Name')
            self.Function_Name = Function_Name_
        elif nodeName_ == 'Virtual_Address':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Virtual_Address(obj_)
        elif nodeName_ == 'Hint':
            obj_ = xs_hexBinary.factory()
            obj_.build(child_)
            self.set_Hint(obj_)
        elif nodeName_ == 'Ordinal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as e:
                raise_parse_error(child_, 'requires integer: %s' % e)
            ival_ = self.gds_validate_integer(ival_, node, 'Ordinal')
            self.Ordinal = ival_
# end class Imported_FunctionType


class Header_HashesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if Header_HashesType.subclass:
            return Header_HashesType.subclass(*args_, **kwargs_)
        else:
            return Header_HashesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Header_HashesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Header_HashesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Header_HashesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Header_HashesType', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Header_HashesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class Header_HashesType


class Data_HashesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if Data_HashesType.subclass:
            return Data_HashesType.subclass(*args_, **kwargs_)
        else:
            return Data_HashesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Data_HashesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Data_HashesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='Data_HashesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_HashesType', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_HashesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class Data_HashesType


class HashesType7(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if HashesType7.subclass:
            return HashesType7.subclass(*args_, **kwargs_)
        else:
            return HashesType7(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='HashesType7', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HashesType7')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='HashesType7'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashesType7', fromsubclass_=False):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashesType7'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class HashesType7


class objectsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, file=None, uri=None, domain=None, registry=None, ip=None, asn=None, entity=None, classification=None):
        if file is None:
            self.file = []
        else:
            self.file = file
        if uri is None:
            self.uri = []
        else:
            self.uri = uri
        if domain is None:
            self.domain = []
        else:
            self.domain = domain
        if registry is None:
            self.registry = []
        else:
            self.registry = registry
        if ip is None:
            self.ip = []
        else:
            self.ip = ip
        if asn is None:
            self.asn = []
        else:
            self.asn = asn
        if entity is None:
            self.entity = []
        else:
            self.entity = entity
        if classification is None:
            self.classification = []
        else:
            self.classification = classification
    def factory(*args_, **kwargs_):
        if objectsType.subclass:
            return objectsType.subclass(*args_, **kwargs_)
        else:
            return objectsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def add_file(self, value): self.file.append(value)
    def insert_file(self, index, value): self.file[index] = value
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def add_uri(self, value): self.uri.append(value)
    def insert_uri(self, index, value): self.uri[index] = value
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def add_domain(self, value): self.domain.append(value)
    def insert_domain(self, index, value): self.domain[index] = value
    def get_registry(self): return self.registry
    def set_registry(self, registry): self.registry = registry
    def add_registry(self, value): self.registry.append(value)
    def insert_registry(self, index, value): self.registry[index] = value
    def get_ip(self): return self.ip
    def set_ip(self, ip): self.ip = ip
    def add_ip(self, value): self.ip.append(value)
    def insert_ip(self, index, value): self.ip[index] = value
    def get_asn(self): return self.asn
    def set_asn(self, asn): self.asn = asn
    def add_asn(self, value): self.asn.append(value)
    def insert_asn(self, index, value): self.asn[index] = value
    def get_entity(self): return self.entity
    def set_entity(self, entity): self.entity = entity
    def add_entity(self, value): self.entity.append(value)
    def insert_entity(self, index, value): self.entity[index] = value
    def get_classification(self): return self.classification
    def set_classification(self, classification): self.classification = classification
    def add_classification(self, value): self.classification.append(value)
    def insert_classification(self, index, value): self.classification[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='objectsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='objectsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='objectsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='objectsType', fromsubclass_=False):
        for file_ in self.file:
            file_.export(outfile, level, namespace_, name_='file')
        for uri_ in self.uri:
            uri_.export(outfile, level, namespace_, name_='uri')
        for domain_ in self.domain:
            domain_.export(outfile, level, namespace_, name_='domain')
        for registry_ in self.registry:
            registry_.export(outfile, level, namespace_, name_='registry')
        for ip_ in self.ip:
            ip_.export(outfile, level, namespace_, name_='ip')
        for asn_ in self.asn:
            asn_.export(outfile, level, namespace_, name_='asn')
        for entity_ in self.entity:
            entity_.export(outfile, level, namespace_, name_='entity')
        for classification_ in self.classification:
            classification_.export(outfile, level, namespace_, name_='classification')
    def hasContent_(self):
        if (
            self.file or
            self.uri or
            self.domain or
            self.registry or
            self.ip or
            self.asn or
            self.entity or
            self.classification
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='objectsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('file=[\n')
        level += 1
        for file_ in self.file:
            showIndent(outfile, level)
            outfile.write('model_.fileObject(\n')
            file_.exportLiteral(outfile, level, name_='fileObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uri=[\n')
        level += 1
        for uri_ in self.uri:
            showIndent(outfile, level)
            outfile.write('model_.uriObject(\n')
            uri_.exportLiteral(outfile, level, name_='uriObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('domain=[\n')
        level += 1
        for domain_ in self.domain:
            showIndent(outfile, level)
            outfile.write('model_.domainObject(\n')
            domain_.exportLiteral(outfile, level, name_='domainObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('registry=[\n')
        level += 1
        for registry_ in self.registry:
            showIndent(outfile, level)
            outfile.write('model_.registryObject(\n')
            registry_.exportLiteral(outfile, level, name_='registryObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ip=[\n')
        level += 1
        for ip_ in self.ip:
            showIndent(outfile, level)
            outfile.write('model_.IPObject(\n')
            ip_.exportLiteral(outfile, level, name_='IPObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('asn=[\n')
        level += 1
        for asn_ in self.asn:
            showIndent(outfile, level)
            outfile.write('model_.ASNObject(\n')
            asn_.exportLiteral(outfile, level, name_='ASNObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('entity=[\n')
        level += 1
        for entity_ in self.entity:
            showIndent(outfile, level)
            outfile.write('model_.entityObject(\n')
            entity_.exportLiteral(outfile, level, name_='entityObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('classification=[\n')
        level += 1
        for classification_ in self.classification:
            showIndent(outfile, level)
            outfile.write('model_.classificationObject(\n')
            classification_.exportLiteral(outfile, level, name_='classificationObject')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = fileObject.factory()
            obj_.build(child_)
            self.file.append(obj_)
        elif nodeName_ == 'uri':
            obj_ = uriObject.factory()
            obj_.build(child_)
            self.uri.append(obj_)
        elif nodeName_ == 'domain':
            obj_ = domainObject.factory()
            obj_.build(child_)
            self.domain.append(obj_)
        elif nodeName_ == 'registry':
            obj_ = registryObject.factory()
            obj_.build(child_)
            self.registry.append(obj_)
        elif nodeName_ == 'ip':
            obj_ = IPObject.factory()
            obj_.build(child_)
            self.ip.append(obj_)
        elif nodeName_ == 'asn':
            obj_ = ASNObject.factory()
            obj_.build(child_)
            self.asn.append(obj_)
        elif nodeName_ == 'entity':
            obj_ = entityObject.factory()
            obj_.build(child_)
            self.entity.append(obj_)
        elif nodeName_ == 'classification':
            obj_ = classificationObject.factory()
            obj_.build(child_)
            self.classification.append(obj_)
# end class objectsType


class objectPropertiesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, objectProperty=None):
        if objectProperty is None:
            self.objectProperty = []
        else:
            self.objectProperty = objectProperty
    def factory(*args_, **kwargs_):
        if objectPropertiesType.subclass:
            return objectPropertiesType.subclass(*args_, **kwargs_)
        else:
            return objectPropertiesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_objectProperty(self): return self.objectProperty
    def set_objectProperty(self, objectProperty): self.objectProperty = objectProperty
    def add_objectProperty(self, value): self.objectProperty.append(value)
    def insert_objectProperty(self, index, value): self.objectProperty[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='objectPropertiesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='objectPropertiesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='objectPropertiesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='objectPropertiesType', fromsubclass_=False):
        for objectProperty_ in self.objectProperty:
            objectProperty_.export(outfile, level, namespace_, name_='objectProperty')
    def hasContent_(self):
        if (
            self.objectProperty
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='objectPropertiesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('objectProperty=[\n')
        level += 1
        for objectProperty_ in self.objectProperty:
            showIndent(outfile, level)
            outfile.write('model_.objectProperty(\n')
            objectProperty_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'objectProperty':
            obj_ = objectProperty.factory()
            obj_.build(child_)
            self.objectProperty.append(obj_)
# end class objectPropertiesType


class relationshipsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, relationship=None):
        if relationship is None:
            self.relationship = []
        else:
            self.relationship = relationship
    def factory(*args_, **kwargs_):
        if relationshipsType.subclass:
            return relationshipsType.subclass(*args_, **kwargs_)
        else:
            return relationshipsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_relationship(self): return self.relationship
    def set_relationship(self, relationship): self.relationship = relationship
    def add_relationship(self, value): self.relationship.append(value)
    def insert_relationship(self, index, value): self.relationship[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='relationshipsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relationshipsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='relationshipsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='relationshipsType', fromsubclass_=False):
        for relationship_ in self.relationship:
            relationship_.export(outfile, level, namespace_, name_='relationship')
    def hasContent_(self):
        if (
            self.relationship
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='relationshipsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('relationship=[\n')
        level += 1
        for relationship_ in self.relationship:
            showIndent(outfile, level)
            outfile.write('model_.relationship(\n')
            relationship_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'relationship':
            obj_ = relationship.factory()
            obj_.build(child_)
            self.relationship.append(obj_)
# end class relationshipsType


class fieldDataType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fieldDataEntry=None):
        if fieldDataEntry is None:
            self.fieldDataEntry = []
        else:
            self.fieldDataEntry = fieldDataEntry
    def factory(*args_, **kwargs_):
        if fieldDataType.subclass:
            return fieldDataType.subclass(*args_, **kwargs_)
        else:
            return fieldDataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fieldDataEntry(self): return self.fieldDataEntry
    def set_fieldDataEntry(self, fieldDataEntry): self.fieldDataEntry = fieldDataEntry
    def add_fieldDataEntry(self, value): self.fieldDataEntry.append(value)
    def insert_fieldDataEntry(self, index, value): self.fieldDataEntry[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='fieldDataType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fieldDataType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec:', name_='fieldDataType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='fieldDataType', fromsubclass_=False):
        for fieldDataEntry_ in self.fieldDataEntry:
            fieldDataEntry_.export(outfile, level, namespace_, name_='fieldDataEntry')
    def hasContent_(self):
        if (
            self.fieldDataEntry
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='fieldDataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('fieldDataEntry=[\n')
        level += 1
        for fieldDataEntry_ in self.fieldDataEntry:
            showIndent(outfile, level)
            outfile.write('model_.fieldDataEntry(\n')
            fieldDataEntry_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fieldDataEntry':
            obj_ = fieldDataEntry.factory()
            obj_.build(child_)
            self.fieldDataEntry.append(obj_)
# end class fieldDataType


class extraHashType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if extraHashType.subclass:
            return extraHashType.subclass(*args_, **kwargs_)
        else:
            return extraHashType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='extraHashType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='extraHashType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='maec