/*
 * Decompiled with CFR 0.152.
 */
package net.corda.bank.api;

import java.time.LocalDateTime;
import java.util.Currency;
import java.util.concurrent.Future;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.finance.flows.CashIssueAndPaymentFlow;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Path(value="bank")
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0001H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/bank/api/BankOfCordaWebApi;", "", "rpc", "Lnet/corda/core/messaging/CordaRPCOps;", "(Lnet/corda/core/messaging/CordaRPCOps;)V", "getCurrentDate", "issueAssetRequest", "Ljavax/ws/rs/core/Response;", "params", "Lnet/corda/bank/api/BankOfCordaWebApi$IssueRequestParams;", "Companion", "IssueRequestParams", "bank-of-corda-demo"})
public final class BankOfCordaWebApi {
    private final CordaRPCOps rpc;
    private static final Logger logger;
    @Deprecated
    public static final Companion Companion;

    @GET
    @Path(value="date")
    @Produces(value={"application/json"})
    @NotNull
    public final Object getCurrentDate() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"date", (Object)LocalDateTime.now().toLocalDate()));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="issue-asset-request")
    @Consumes(value={"application/json"})
    @NotNull
    public final Response issueAssetRequest(@NotNull IssueRequestParams params) {
        Response response;
        byte by;
        byte[] byArray;
        Object v3;
        Amount<Currency> it;
        Object element$iv2;
        Party issueToParty;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Party party = this.rpc.wellKnownPartyFromX500Name(params.getIssueToPartyName());
            if (party == null) {
                Response response2 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Unable to locate " + params.getIssueToPartyName() + " in identity service")).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.status(Response\u2026dentity service\").build()");
                return response2;
            }
            issueToParty = party;
            if (this.rpc.wellKnownPartyFromX500Name(params.getIssuerBankName()) == null) {
                Response response3 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Unable to locate " + params.getIssuerBankName() + " in identity service")).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"Response.status(Response\u2026dentity service\").build()");
                return response3;
            }
            Iterable $receiver$iv = this.rpc.notaryIdentities();
            for (Object element$iv2 : $receiver$iv) {
                it = (Amount<Currency>)element$iv2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)params.getNotaryName())) continue;
                v3 = element$iv2;
                break block6;
            }
            v3 = null;
        }
        Party party = v3;
        if (party == null) {
            Response response4 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Unable to locate notary " + params.getNotaryName() + " in network map")).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"Response.status(Response\u2026 in network map\").build()");
            return response4;
        }
        Party notaryParty = party;
        boolean anonymous = true;
        element$iv2 = params.getIssuerBankPartyRef();
        int n = 0;
        byte[] byArray2 = byArray = new byte[1];
        OpaqueBytes.Companion companion = OpaqueBytes.Companion;
        byArray[n] = by = Byte.parseByte(element$iv2);
        OpaqueBytes issuerBankPartyRef = companion.of(byArray2);
        try {
            void arg0$iv;
            void $receiver$iv;
            element$iv2 = this.rpc;
            it = params.getAmount();
            Boolean arg3$iv = anonymous;
            KotlinUtilsKt.getOrThrow$default((Future)((Future)$receiver$iv.startFlowDynamic(CashIssueAndPaymentFlow.class, new Object[]{arg0$iv, issuerBankPartyRef, issueToParty, arg3$iv, notaryParty}).getReturnValue()), null, (int)1, null);
            logger.info("Issue and payment request completed successfully: " + params);
            Response response5 = Response.status((Response.Status)Response.Status.CREATED).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response5, (String)"Response.status(Response.Status.CREATED).build()");
            response = response5;
        }
        catch (Exception e) {
            logger.error("Issue and payment request failed", (Throwable)e);
            Response response6 = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response6, (String)"Response.status(Response.Status.FORBIDDEN).build()");
            response = response6;
        }
        return response;
    }

    public BankOfCordaWebApi(@NotNull CordaRPCOps rpc) {
        Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
        this.rpc = rpc;
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lnet/corda/bank/api/BankOfCordaWebApi$IssueRequestParams;", "", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueToPartyName", "Lnet/corda/core/identity/CordaX500Name;", "issuerBankPartyRef", "", "issuerBankName", "notaryName", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/CordaX500Name;Ljava/lang/String;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/identity/CordaX500Name;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueToPartyName", "()Lnet/corda/core/identity/CordaX500Name;", "getIssuerBankName", "getIssuerBankPartyRef", "()Ljava/lang/String;", "getNotaryName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "bank-of-corda-demo"})
    public static final class IssueRequestParams {
        @NotNull
        private final Amount<Currency> amount;
        @NotNull
        private final CordaX500Name issueToPartyName;
        @NotNull
        private final String issuerBankPartyRef;
        @NotNull
        private final CordaX500Name issuerBankName;
        @NotNull
        private final CordaX500Name notaryName;

        @NotNull
        public final Amount<Currency> getAmount() {
            return this.amount;
        }

        @NotNull
        public final CordaX500Name getIssueToPartyName() {
            return this.issueToPartyName;
        }

        @NotNull
        public final String getIssuerBankPartyRef() {
            return this.issuerBankPartyRef;
        }

        @NotNull
        public final CordaX500Name getIssuerBankName() {
            return this.issuerBankName;
        }

        @NotNull
        public final CordaX500Name getNotaryName() {
            return this.notaryName;
        }

        public IssueRequestParams(@NotNull Amount<Currency> amount, @NotNull CordaX500Name issueToPartyName, @NotNull String issuerBankPartyRef, @NotNull CordaX500Name issuerBankName, @NotNull CordaX500Name notaryName) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)issueToPartyName, (String)"issueToPartyName");
            Intrinsics.checkParameterIsNotNull((Object)issuerBankPartyRef, (String)"issuerBankPartyRef");
            Intrinsics.checkParameterIsNotNull((Object)issuerBankName, (String)"issuerBankName");
            Intrinsics.checkParameterIsNotNull((Object)notaryName, (String)"notaryName");
            this.amount = amount;
            this.issueToPartyName = issueToPartyName;
            this.issuerBankPartyRef = issuerBankPartyRef;
            this.issuerBankName = issuerBankName;
            this.notaryName = notaryName;
        }

        @NotNull
        public final Amount<Currency> component1() {
            return this.amount;
        }

        @NotNull
        public final CordaX500Name component2() {
            return this.issueToPartyName;
        }

        @NotNull
        public final String component3() {
            return this.issuerBankPartyRef;
        }

        @NotNull
        public final CordaX500Name component4() {
            return this.issuerBankName;
        }

        @NotNull
        public final CordaX500Name component5() {
            return this.notaryName;
        }

        @NotNull
        public final IssueRequestParams copy(@NotNull Amount<Currency> amount, @NotNull CordaX500Name issueToPartyName, @NotNull String issuerBankPartyRef, @NotNull CordaX500Name issuerBankName, @NotNull CordaX500Name notaryName) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)issueToPartyName, (String)"issueToPartyName");
            Intrinsics.checkParameterIsNotNull((Object)issuerBankPartyRef, (String)"issuerBankPartyRef");
            Intrinsics.checkParameterIsNotNull((Object)issuerBankName, (String)"issuerBankName");
            Intrinsics.checkParameterIsNotNull((Object)notaryName, (String)"notaryName");
            return new IssueRequestParams(amount, issueToPartyName, issuerBankPartyRef, issuerBankName, notaryName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ IssueRequestParams copy$default(IssueRequestParams issueRequestParams, Amount amount, CordaX500Name cordaX500Name, String string, CordaX500Name cordaX500Name2, CordaX500Name cordaX500Name3, int n, Object object) {
            if ((n & 1) != 0) {
                amount = issueRequestParams.amount;
            }
            if ((n & 2) != 0) {
                cordaX500Name = issueRequestParams.issueToPartyName;
            }
            if ((n & 4) != 0) {
                string = issueRequestParams.issuerBankPartyRef;
            }
            if ((n & 8) != 0) {
                cordaX500Name2 = issueRequestParams.issuerBankName;
            }
            if ((n & 0x10) != 0) {
                cordaX500Name3 = issueRequestParams.notaryName;
            }
            return issueRequestParams.copy(amount, cordaX500Name, string, cordaX500Name2, cordaX500Name3);
        }

        public String toString() {
            return "IssueRequestParams(amount=" + this.amount + ", issueToPartyName=" + this.issueToPartyName + ", issuerBankPartyRef=" + this.issuerBankPartyRef + ", issuerBankName=" + this.issuerBankName + ", notaryName=" + this.notaryName + ")";
        }

        public int hashCode() {
            Amount<Currency> amount = this.amount;
            CordaX500Name cordaX500Name = this.issueToPartyName;
            String string = this.issuerBankPartyRef;
            CordaX500Name cordaX500Name2 = this.issuerBankName;
            CordaX500Name cordaX500Name3 = this.notaryName;
            return ((((amount != null ? amount.hashCode() : 0) * 31 + (cordaX500Name != null ? cordaX500Name.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (cordaX500Name2 != null ? cordaX500Name2.hashCode() : 0)) * 31 + (cordaX500Name3 != null ? cordaX500Name3.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IssueRequestParams)) break block3;
                    IssueRequestParams issueRequestParams = (IssueRequestParams)object;
                    if (!Intrinsics.areEqual(this.amount, issueRequestParams.amount) || !Intrinsics.areEqual((Object)this.issueToPartyName, (Object)issueRequestParams.issueToPartyName) || !Intrinsics.areEqual((Object)this.issuerBankPartyRef, (Object)issueRequestParams.issuerBankPartyRef) || !Intrinsics.areEqual((Object)this.issuerBankName, (Object)issueRequestParams.issuerBankName) || !Intrinsics.areEqual((Object)this.notaryName, (Object)issueRequestParams.notaryName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/bank/api/BankOfCordaWebApi$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "bank-of-corda-demo"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

