# protoc-gen-jsonshim

`protoc-gen-jsonshim` is a plugin for protoc which generates `MarshalJSON()` and
`UnmarshalJSON()` functions for `.pb.go` types.  The implementations simply
redirect to `MarshalJSONPB()` and `UnmarshalJSONPB()` respectively.  This allows
the types to be used with native Go JSON serialization.

## Usage

Add the executable to your system's PATH, for example:

`$ go install istio.io/tools/cmd/protoc-gen-jsonshim`

Add the `jsonshim_out` option to your `protoc` command line, for example:

`$ protoc --jsonshim_out=:output/path ...`

## Quirks

The generator is built off `protoc-gen-gogo`, which adds some imports that are
not used, along with copying over file comments from the source file.  See below
for an example of the genrated code.

## Examples Of Generated Code

```go
// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/gateway.proto

package v1alpha3 // import "istio.io/api/networking/v1alpha3"

import (
    bytes "bytes"
    fmt "fmt"
    github_com_gogo_protobuf_jsonpb "github.com/gogo/protobuf/jsonpb"
    proto "github.com/gogo/protobuf/proto"
    _ "google.golang.org/genproto/googleapis/api/annotations"
    math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// MarshalJSON is a custom marshaler for Gateway
func (this *Gateway) MarshalJSON() ([]byte, error) {
    str, err := GatewayMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Gateway
func (this *Gateway) UnmarshalJSON(b []byte) error {
    return GatewayUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for Gateway_SelectorEntry
func (this *Gateway_SelectorEntry) MarshalJSON() ([]byte, error) {
    str, err := GatewayMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Gateway_SelectorEntry
func (this *Gateway_SelectorEntry) UnmarshalJSON(b []byte) error {
    return GatewayUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for Server
func (this *Server) MarshalJSON() ([]byte, error) {
    str, err := GatewayMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Server
func (this *Server) UnmarshalJSON(b []byte) error {
    return GatewayUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for Server_TLSOptions
func (this *Server_TLSOptions) MarshalJSON() ([]byte, error) {
    str, err := GatewayMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Server_TLSOptions
func (this *Server_TLSOptions) UnmarshalJSON(b []byte) error {
    return GatewayUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for Port
func (this *Port) MarshalJSON() ([]byte, error) {
    str, err := GatewayMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Port
func (this *Port) UnmarshalJSON(b []byte) error {
    return GatewayUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

var (
    GatewayMarshaler   = &github_com_gogo_protobuf_jsonpb.Marshaler{}
    GatewayUnmarshaler = &github_com_gogo_protobuf_jsonpb.Unmarshaler{}
)
```
